// avst_fifo.v

// (C) 2019 Intel Corporation. All rights reserved.
// Your use of Intel Corporation's design tools, logic functions and other 
// software and tools, and its AMPP partner logic functions, and any output 
// files from any of the foregoing (including device programming or simulation 
// files), and any associated documentation or information are expressly subject 
// to the terms and conditions of the Intel Program License Subscription 
// Agreement, Intel FPGA IP License Agreement, or other applicable 
// license agreement, including, without limitation, that your use is for the 
// sole purpose of programming logic devices manufactured by Intel and sold by 
// Intel or its authorized distributors.  Please refer to the applicable 
// agreement for further details.

// Generated using ACDS version 18.1 625

`timescale 1 ps / 1 ps
module avst_fifo #(
		parameter SYMBOLS_PER_BEAT    = 1,
		parameter BITS_PER_SYMBOL     = 32,
		parameter FIFO_DEPTH          = 64,
		parameter CHANNEL_WIDTH       = 0,
		parameter ERROR_WIDTH         = 0,
		parameter USE_PACKETS         = 1,
		parameter USE_FILL_LEVEL      = 0,
		parameter EMPTY_LATENCY       = 3,
		parameter USE_MEMORY_BLOCKS   = 1,
		parameter USE_STORE_FORWARD   = 0,
		parameter USE_ALMOST_FULL_IF  = 0,
		parameter USE_ALMOST_EMPTY_IF = 0
	) (
		input  wire        clk,               //       clk.clk
		input  wire        reset,             // clk_reset.reset
		input  wire [31:0] in_data,           //        in.data
		input  wire        in_valid,          //          .valid
		output wire        in_ready,          //          .ready
		input  wire        in_startofpacket,  //          .startofpacket
		input  wire        in_endofpacket,    //          .endofpacket
		output wire [31:0] out_data,          //       out.data
		output wire        out_valid,         //          .valid
		input  wire        out_ready,         //          .ready
		output wire        out_startofpacket, //          .startofpacket
		output wire        out_endofpacket    //          .endofpacket
	);

	altera_avalon_sc_fifo #(
		.SYMBOLS_PER_BEAT    (SYMBOLS_PER_BEAT),
		.BITS_PER_SYMBOL     (BITS_PER_SYMBOL),
		.FIFO_DEPTH          (FIFO_DEPTH),
		.CHANNEL_WIDTH       (CHANNEL_WIDTH),
		.ERROR_WIDTH         (ERROR_WIDTH),
		.USE_PACKETS         (USE_PACKETS),
		.USE_FILL_LEVEL      (USE_FILL_LEVEL),
		.EMPTY_LATENCY       (EMPTY_LATENCY),
		.USE_MEMORY_BLOCKS   (USE_MEMORY_BLOCKS),
		.USE_STORE_FORWARD   (USE_STORE_FORWARD),
		.USE_ALMOST_FULL_IF  (USE_ALMOST_FULL_IF),
		.USE_ALMOST_EMPTY_IF (USE_ALMOST_EMPTY_IF)
	) avst_fifo (
		.clk               (clk),                                  //       clk.clk
		.reset             (reset),                                // clk_reset.reset
		.in_data           (in_data),                              //        in.data
		.in_valid          (in_valid),                             //          .valid
		.in_ready          (in_ready),                             //          .ready
		.in_startofpacket  (in_startofpacket),                     //          .startofpacket
		.in_endofpacket    (in_endofpacket),                       //          .endofpacket
		.out_data          (out_data),                             //       out.data
		.out_valid         (out_valid),                            //          .valid
		.out_ready         (out_ready),                            //          .ready
		.out_startofpacket (out_startofpacket),                    //          .startofpacket
		.out_endofpacket   (out_endofpacket),                      //          .endofpacket
		.csr_address       (2'b00),                                // (terminated)
		.csr_read          (1'b0),                                 // (terminated)
		.csr_write         (1'b0),                                 // (terminated)
		.csr_readdata      (),                                     // (terminated)
		.csr_writedata     (32'b00000000000000000000000000000000), // (terminated)
		.almost_full_data  (),                                     // (terminated)
		.almost_empty_data (),                                     // (terminated)
		.in_empty          (1'b0),                                 // (terminated)
		.out_empty         (),                                     // (terminated)
		.in_error          (1'b0),                                 // (terminated)
		.out_error         (),                                     // (terminated)
		.in_channel        (1'b0),                                 // (terminated)
		.out_channel       ()                                      // (terminated)
	);

endmodule
