#!/usr/bin/python3
from tkinter import *
import tkinter
from view_model import ViewModel
from wckToolTips import ToolTipManager
from pathlib import Path
import constants
import os
root = Tk()
main_vm = None
def on_closing():
    global root
    root.destroy()
def main():
    global root
    global main_vm
    main_vm=ViewModel(root);
    ttm=ToolTipManager()
    # Menu
    menubar = Menu(root)
    filemenu = Menu(menubar, tearoff=0)
    filemenu.add_command(label='Open...', command=main_vm.open)
    #main_vm
    filemenu.add_command(label='Save',command=main_vm.save, state=DISABLED)
    filemenu.add_command(label='Save as...',command=main_vm.saveas)
    filemenu.add_separator()
    filemenu.add_command(label='Quit',command=on_closing)
    menubar.add_cascade(label='FILE',menu=filemenu)
    root.config(menu=menubar)
    main_vm.menu_binding = filemenu
    # Bind to VM and setup validators
    hex_validator = (root.register(main_vm.validate_hex), '%d', '%i', '%P', '%s', '%S', '%v', '%V', '%W')
    dec_validator = (root.register(main_vm.validate_dec), '%d', '%i', '%P', '%s', '%S', '%v', '%V', '%W')

    # GroupBox 'Block0'
    group_block0 = LabelFrame(root, text='BLOCK0', padx=5,pady=5)
    group_block0.grid(row=0, padx=10, pady=10, sticky=NSEW)
    # Magic
    Label(group_block0, text='Magic\t\t').grid(row=0, column=0, sticky=W)
    widget=Entry(group_block0, validate='focusout', validatecommand=hex_validator, textvariable=main_vm.block0.magic, width=15)
    widget.grid(row=0, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_b0_magic)
    # PcType
    Label(group_block0, text='PC Type\t\t').grid(row=1, column=0, sticky=W)
    widget=Entry(group_block0, validate='focusout', validatecommand=dec_validator, textvariable=main_vm.block0.pctype, width=5)
    widget.grid(row=1, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_b0_pctype)

    # GroupBox 'Block1'
    group_block1 = LabelFrame(root, text='BLOCK1', padx=5, pady=5)
    group_block1.grid(row=1, padx=10, pady=10, sticky=W)
    # Magic
    Label(group_block1, text='Magic\t\t').grid(row=0, column=0, sticky=W)
    widget=Entry(group_block1, validate='focusout', validatecommand=hex_validator, textvariable=main_vm.block1.magic, width=15)
    widget.grid(row=0, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_b1_magic)
    # GroupBox 'Rkey'
    group_rkey=LabelFrame(group_block1, text='RKEY', padx=5, pady=5)
    group_rkey.grid(row=1, columnspan=2 , padx=3, pady=3, sticky=NW)
    # Rkey Magic
    Label(group_rkey, text='Magic\t\t').grid(row=0, column=0, sticky=W)
    widget=Entry(group_rkey, validate='focusout', validatecommand=hex_validator, textvariable=main_vm.block1.rkey.magic, width=15)
    widget.grid(row=0, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_rkey_magic)
    # Rkey Curve Magic
    Label(group_rkey, text='Curve Magic\t\t').grid(row=1, column=0, sticky=W)
    widget=Entry(group_rkey, validate='focusout', validatecommand=hex_validator, textvariable=main_vm.block1.rkey.curvemagic, width=15)
    widget.grid(row=1, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_rkey_curve)
    # Rkey Permissions
    Label(group_rkey, text='Permissions\t\t').grid(row=2, column=0, sticky=W)
    widget=Entry(group_rkey, validate='focusout', validatecommand=dec_validator, textvariable=main_vm.block1.rkey.permissions, width=5)
    widget.grid(row=2, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_rkey_permissions)
    # Rkey Keyid
    Label(group_rkey, text='Key ID\t\t').grid(row=3, column=0, sticky=W)
    widget=Entry(group_rkey, validate='focusout', validatecommand=dec_validator, textvariable=main_vm.block1.rkey.keyid, width=5)
    widget.grid(row=3, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_rkey_keyid)
    # Rkey pubkey
    Label(group_rkey, text='Public Key\t\t').grid(row=4, column=0, sticky=W)
    widget=Entry(group_rkey, textvariable=main_vm.block1.rkey.pubkey, width=15)
    widget.grid(row=4, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_rkey_pubkey)
    widget = Button(group_rkey, text='...', command=main_vm.browse_rkey_pubkey)
    widget.grid(row=4, column=3, sticky=W)

    # GroupBox 'CsKey'
    group_cskey = LabelFrame(group_block1, text='CSKEY', padx=5,pady=5)
    group_cskey.grid(row=1, rowspan=2, column=2, columnspan=2, padx=3, pady=3, sticky=NW)
    main_vm.cskey_binding=group_cskey # bind to VM so we can enable/disable
    # Include checkbox
    widget=Checkbutton(group_block1, text='Include CSKEY', command=main_vm.toggle_cskey, variable=main_vm.enable_cskey, onvalue=True, offvalue=False)
    widget.grid(row=0, column=2, sticky=W)
    ttm.register(widget, constants.tooltip_cskey_include)
    # Cskey Magic
    Label(group_cskey, text='Magic\t\t').grid(row=0, column=0, sticky=W)
    widget=Entry(group_cskey, validate='focusout', validatecommand=hex_validator, textvariable=main_vm.block1.cskey.magic, width=15)
    widget.grid(row=0, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_cskey_magic)
    # Cskey Curve Magic
    Label(group_cskey, text='Curve Magic\t\t').grid(row=1, column=0, sticky=W)
    widget=Entry(group_cskey, validate='focusout', validatecommand=hex_validator, textvariable=main_vm.block1.cskey.curvemagic, width=15)
    widget.grid(row=1, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_cskey_curve)
    # Rkey Permissions
    Label(group_cskey, text='Permissions\t\t').grid(row=2, column=0, sticky=W)
    widget=Entry(group_cskey, validate='focusout', validatecommand=dec_validator, textvariable=main_vm.block1.cskey.permissions, width=5)
    widget.grid(row=2, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_cskey_permissions)
    # Rkey Keyid
    Label(group_cskey, text='Key ID\t\t').grid(row=3, column=0, sticky=W)
    widget=Entry(group_cskey, validate='focusout', validatecommand=dec_validator, textvariable=main_vm.block1.cskey.keyid, width=5)
    widget.grid(row=3, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_cskey_keyid)
    # Rkey pubkey
    Label(group_cskey, text='Public Key\t\t').grid(row=4, column=0, sticky=W)
    widget=Entry(group_cskey, textvariable=main_vm.block1.cskey.pubkey, width=15)
    widget.grid(row=4, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_cskey_pubkey)
    widget = Button(group_cskey, text='...', command=main_vm.browse_cskey_pubkey)
    widget.grid(row=4, column=3, sticky=W)
    # Sig Magic
    Label(group_cskey, text='Sig Magic\t\t').grid(row=5, column=0, sticky=W)
    widget=Entry(group_cskey, validate='focusout', validatecommand=hex_validator, textvariable=main_vm.block1.cskey.sigmagic, width=15)
    widget.grid(row=5, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_cskey_sigmagic)
    # Hash Alg
    Label(group_cskey, text='Hash Algorithm:').grid(row=6, column =0, sticky=W)
    Radiobutton(group_cskey, variable=main_vm.block1.cskey.hashalg, text='SHA256', value='sha256').grid(row=7, column=0, sticky=W)
    Radiobutton(group_cskey, variable=main_vm.block1.cskey.hashalg, text='SHA384', value='sha384').grid(row=7, column=0, sticky=E)
    # Signing
    Label(group_cskey, text='Signing:').grid(row=8, column=0, sticky=W)
    Radiobutton(group_cskey, variable=main_vm.sigmethod, text='Signing Key', command=main_vm.toggle_sigmethod, value=True).grid(row=9, column=0, sticky=W)
    widget=Entry(group_cskey, textvariable=main_vm.block1.cskey.signkey, width=15)
    widget.grid(row=9, column=1, sticky=W)
    main_vm.cskey_int_entry_binding=widget
    ttm.register(widget, constants.tooltip_cskey_signkey)
    widget=Button(group_cskey, text='...', command=main_vm.browse_cskey_signkey)
    widget.grid(row=9, column=3, sticky=W)
    main_vm.cskey_int_button_binding=widget
    Radiobutton(group_cskey, variable=main_vm.sigmethod, text='Script File', command=main_vm.toggle_sigmethod, value=False).grid(row=10, column=0, sticky=W)
    widget=Entry(group_cskey, textvariable=main_vm.block1.cskey.script,state=DISABLED, width=15)
    widget.grid(row=10, column=1, sticky=W)
    main_vm.cskey_ext_entry_binding=widget
    ttm.register(widget, constants.tooltip_cskey_script)
    widget=Button(group_cskey, text='...',state=DISABLED, command=main_vm.browse_cskey_script)
    widget.grid(row=10, column=3, sticky=W)
    main_vm.cskey_ext_button_binding=widget
    # Groupbox 'Block0 Sig'
    group_b0sig = LabelFrame(group_block1, text='Block 0 Signature', padx=5,pady=5)
    group_b0sig.grid(row=2, columnspan=2, padx=3, pady=3, sticky=NSEW)
    # Magic
    Label(group_b0sig, text='Magic\t\t\t').grid(row=0, column=0, sticky=W)
    widget=Entry(group_b0sig, validate='focusout', validatecommand=hex_validator, textvariable=main_vm.block1.b0sig.magic, width=15)
    widget.grid(row=0, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_b0sig_magic)
    # Sig Magic
    Label(group_b0sig, text='Sig Magic\t\t').grid(row=1, column=0, sticky=W)
    widget=Entry(group_b0sig, validate='focusout', validatecommand=hex_validator, textvariable=main_vm.block1.b0sig.sigmagic, width=15)
    widget.grid(row=1, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_b0sig_sigmagic)
    # Hash Algorithm
    Label(group_b0sig, text='Hash Algorithm:').grid(row=2, column =0, sticky=W)
    Radiobutton(group_b0sig, variable=main_vm.block1.b0sig.hashalg, text='SHA256', value='sha256').grid(row=3, column=0, sticky=W)
    Radiobutton(group_b0sig, variable=main_vm.block1.b0sig.hashalg, text='SHA384', value='sha384').grid(row=3, column=0, sticky=E)
    # Signing
    Label(group_b0sig, text='Signing:').grid(row=4, column=0, sticky=W)
    Radiobutton(group_b0sig, variable=main_vm.b0_sigmethod, text='Signing Key', command=main_vm.toggle_b0_sigmethod, value=True).grid(row=5, column=0, sticky=W)
    widget=Entry(group_b0sig, textvariable=main_vm.block1.b0sig.signkey, width=15)
    widget.grid(row=5, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_b0sig_signkey)
    main_vm.b0sig_int_entry_binding=widget
    widget=Button(group_b0sig, text='...', command=main_vm.browse_b0sig_signkey)
    widget.grid(row=5, column=3, sticky=W)
    main_vm.b0sig_int_button_binding=widget
    Radiobutton(group_b0sig, variable=main_vm.b0_sigmethod, text='Script File', command=main_vm.toggle_b0_sigmethod, value=False).grid(row=6, column=0, sticky=W)
    widget=Entry(group_b0sig, textvariable=main_vm.block1.b0sig.script,state=DISABLED, width=15)
    widget.grid(row=6, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_b0sig_script)
    main_vm.b0sig_ext_entry_binding=widget
    widget=Button(group_b0sig, text='...',state=DISABLED, command=main_vm.browse_b0sig_script)
    widget.grid(row=6, column=3, sticky=W)
    main_vm.b0sig_ext_button_binding=widget
    
    supplemental_frame = Frame(root, padx=5, pady=5)
    supplemental_frame.grid(row=4, padx=10, pady=10, sticky=NSEW)
    # Padding
    group_padding = LabelFrame(supplemental_frame, text='PADDING', padx=5, pady=5)
    group_padding.grid(row=1, sticky=NSEW)
    Label(group_padding, text='Block Pad\t').grid(row=0, column=0, sticky=W)
    widget=Entry(group_padding, textvariable=main_vm.padding.blockpad, width=10)
    widget.grid(row=0, column=1, sticky=W)
    Label(group_padding, text='PC Alignment\t').grid(row=1, column=0, sticky=W)
    ttm.register(widget, constants.tooltip_padding_blockpad)
    widget=Entry(group_padding, textvariable=main_vm.padding.align, width=10)
    widget.grid(row=1, column=1, sticky=W)
    ttm.register(widget, constants.tooltip_padding_align)
    main_vm.padding_binding = group_padding
    widget=Checkbutton(supplemental_frame, text='Include PADDING', command=main_vm.toggle_padding, variable=main_vm.enable_padding, onvalue=True, offvalue=False)
    widget.grid(row=0, sticky=W)
        
    # CPLD
    group_cpld = LabelFrame(supplemental_frame, text='CPLD', padx=5,pady=5)
    group_cpld.grid(row=1, column=1, padx=10, sticky=NSEW)
    Checkbutton(group_cpld, text='Swap Bytes', onvalue=True, offvalue=False, variable=main_vm.cpld.swapbytes).grid(row=0, column=0, sticky=NW)
    Label(group_cpld, text='SVN\t').grid(row=1,column=0, sticky=W)
    widget=Entry(group_cpld, textvariable=main_vm.cpld.svn, width=5)
    widget.grid(row=1,column=1, sticky=W)
    widget=Checkbutton(supplemental_frame, text='Include CPLD', command=main_vm.toggle_cpld, variable=main_vm.enable_cpld, onvalue=True, offvalue=False)
    widget.grid(row=0, column=1, padx=10, sticky=W)
    main_vm.cpld_binding = group_cpld
    
    Label(root, text='1.0', padx=10).grid(row=5, column=0, sticky=SE)
    # Global
    root.title('BlockConfig')
    image = Path('PartGear.png')
    if image.is_file():
        img = tkinter.PhotoImage(file='PartGear.png')
        root.tk.call('wm', 'iconphoto', root._w, img)
    if os.name == 'nt':
        root.geometry('600x655')
    else:
        root.geometry('800x700')
    root.protocol('WM_DELETE_WINDOW', on_closing)
    
    # Intialize values       
    main_vm.toggle_padding()
    main_vm.toggle_cpld()
    
    root.mainloop()

if __name__=='__main__':
    main()
