from model import *
from tkinter import *
from tkinter import filedialog
import xml.etree.ElementTree as ET
import xml.dom.minidom
import os.path
class ViewModel():
    __view=None
    block0=None
    block1=None
    padding=None
    cpld=None
    __tagversion = 'version'
    __version = '1'
    __tagblocksign = 'blocksign'
    __tagb0sig = 'b0_sig'
    __tagmagic = 'magic'
    __tagpctype = 'pctype'
    __tagblock0 = 'block0'
    __tagblock1 = 'block1'
    __tagcurvemagic = 'curvemagic'
    __tagpermissions = 'permissions'
    __tagkeyid = 'keyid'
    __tagpubkey = 'pubkey'
    __tagsigmagic = 'sigmagic'
    __taghashalg = 'hashalg'
    __tagcskey = 'cskey'
    __tagrkey = 'rkey'
    __tagsignkey = 'signkey'
    __tagscript = 'script'
    __tagpadding = 'padding'
    __tagblockpad = 'blockpad'
    __tagalign = 'align'
    __tagcpld = 'cpld'
    __tagswapbytes = 'swapbytes'
    __tagsvn = 'svn'

    __target_file=None
    def __init__(self, view):
        # build model, create TkVars so view can bind
        self.__view=view
        # BLOCK0
        self.block0=Block0()
        self.block0.magic=StringVar(view)
        self.block0.pctype=StringVar(view)
        
        # BLOCK1
        self.block1=Block1()
        self.block1.magic=StringVar(view)
        self.block1.rkey.magic=StringVar(view)
        self.block1.rkey.curvemagic=StringVar(view)
        self.block1.rkey.permissions=StringVar(view)
        self.block1.rkey.keyid=StringVar(view)
        self.block1.rkey.pubkey=StringVar(view)
        self.enable_cskey=BooleanVar(view)
        self.enable_cskey.set(True)
        self.block1.cskey.magic=StringVar(view)
        self.block1.cskey.curvemagic=StringVar(view)
        self.block1.cskey.permissions=StringVar(view)
        self.block1.cskey.keyid=StringVar(view)
        self.block1.cskey.pubkey=StringVar(view)
        self.block1.cskey.sigmagic=StringVar(view)
        self.block1.cskey.hashalg=StringVar(view)
        self.sigmethod=BooleanVar(view)
        self.sigmethod.set(True)
        self.b0_sigmethod=BooleanVar(view)
        self.b0_sigmethod.set(True)
        self.block1.cskey.signkey=StringVar(view)
        self.block1.cskey.script=StringVar(view)
        self.block1.b0sig.magic=StringVar(view)
        self.block1.b0sig.sigmagic=StringVar(view)
        self.block1.b0sig.hashalg=StringVar(view)
        self.block1.b0sig.signkey=StringVar(view)
        self.block1.b0sig.script=StringVar(view)

        # PADDING
        self.padding=Padding()
        self.padding.blockpad=StringVar(view)
        self.padding.align=StringVar(view)
        self.enable_padding=BooleanVar(view)
        self.enable_padding.set(False)
        
        # CPLD
        self.cpld=Cpld()
        self.cpld.swapbytes = BooleanVar(view)
        self.cpld.svn = StringVar(view)
        self.enable_cpld=BooleanVar(view)
        self.enable_cpld.set(False)

        self.block0.magic.set('0xB6EAFD19')
        self.block0.pctype.set('0')
        self.block1.magic.set('0xF27F28D7')
        self.block1.rkey.magic.set('0xA757A046')
        self.block1.rkey.curvemagic.set('0xC7B88C74')
        self.block1.rkey.permissions.set('-1')
        self.block1.rkey.keyid.set('-1')
        self.block1.rkey.pubkey.set('')
        self.block1.cskey.magic.set('0x14711C2F')
        self.block1.cskey.curvemagic.set('0xC7B88C74')
        self.block1.cskey.permissions.set('-1')
        self.block1.cskey.keyid.set('1')
        self.block1.cskey.pubkey.set('')
        self.block1.cskey.sigmagic.set('0xDE64437D')
        self.block1.cskey.hashalg.set('sha256')
        self.block1.b0sig.magic.set('0x15364367')
        self.block1.b0sig.sigmagic.set('0xDE64437D')
        self.block1.b0sig.hashalg.set('sha256')

    def __assembleXml(self):
        root = ET.Element(self.__tagblocksign)
        version = ET.SubElement(root, self.__tagversion)
        version.text = self.__version
        b0 = ET.SubElement(root, self.__tagblock0)
        b0magic = ET.SubElement(b0, self.__tagmagic)
        b0magic.text=self.block0.magic.get()
        b0pctype = ET.SubElement(b0, self.__tagpctype)
        b0pctype.text=self.block0.pctype.get()
        b1 = ET.SubElement(root, self.__tagblock1)
        b1magic = ET.SubElement(b1, self.__tagmagic)
        b1magic.text = self.block1.magic.get()
        rkey = ET.SubElement(b1, self.__tagrkey)
        rmagic = ET.SubElement(rkey, self.__tagmagic)
        rmagic.text = self.block1.rkey.magic.get()
        rcurve = ET.SubElement(rkey, self.__tagcurvemagic)
        rcurve.text = self.block1.rkey.curvemagic.get()
        rperm = ET.SubElement(rkey, self.__tagpermissions)
        rperm.text = self.block1.rkey.permissions.get()
        rkeyid = ET.SubElement(rkey, self.__tagkeyid)
        rkeyid.text = self.block1.rkey.keyid.get()
        rpub = ET.SubElement(rkey, self.__tagpubkey)
        rpub.text = self.block1.rkey.pubkey.get()
        cskey = ET.SubElement(b1, self.__tagcskey)
        csmagic = ET.SubElement(cskey, self.__tagmagic)
        csmagic.text = self.block1.cskey.magic.get()
        cscurve = ET.SubElement(cskey, self.__tagcurvemagic)
        cscurve.text = self.block1.cskey.curvemagic.get()
        csperm = ET.SubElement(cskey, self.__tagpermissions)
        csperm.text=self.block1.cskey.permissions.get()
        cskeyid = ET.SubElement(cskey, self.__tagkeyid)
        cskeyid.text = self.block1.cskey.keyid.get()
        cspubkey = ET.SubElement(cskey, self.__tagpubkey)
        cspubkey.text = self.block1.cskey.pubkey.get()
        cssigmagic = ET.SubElement(cskey, self.__tagsigmagic)
        cssigmagic.text = self.block1.cskey.sigmagic.get()
        cshash = ET.SubElement(cskey, self.__taghashalg)
        cshash.text = self.block1.cskey.hashalg.get()
        if self.sigmethod.get() == True:
            csfile = ET.SubElement(cskey, self.__tagsignkey)
            csfile.text = self.block1.cskey.signkey.get()
        else:
            csfile = ET.SubElement(cskey, self.__tagscript)
            csfile.text = self.block1.cskey.script.get()
        b0sig = ET.SubElement(b1, self.__tagb0sig)
        b0sigmagic = ET.SubElement(b0sig, self.__tagmagic)
        b0sigmagic.text = self.block1.b0sig.magic.get()
        b0sigsigmagic = ET.SubElement(b0sig, self.__tagsigmagic)
        b0sigsigmagic.text = self.block1.b0sig.sigmagic.get()
        b0hash = ET.SubElement(b0sig, self.__taghashalg)
        b0hash.text = self.block1.b0sig.hashalg.get()
        if self.b0_sigmethod.get() == True:
            b0file = ET.SubElement(b0sig, self.__tagsignkey)
            b0file.text = self.block1.b0sig.signkey.get()
        else:
            b0file = ET.SubElement(b0sig, self.__tagscript)
            b0file.text = self.block1.b0sig.script.get()
        if self.enable_padding.get() == True:
            padding = ET.SubElement(root, self.__tagpadding)
            bpad = ET.SubElement(padding, self.__tagblockpad)
            bpad.text = self.padding.blockpad.get()
            align = ET.SubElement(padding, self.__tagalign)
            align.text = self.padding.align.get()
        if self.enable_cpld.get() == True:
            cpld = ET.SubElement(root, self.__tagcpld)
            swap = ET.SubElement(cpld, self.__tagswapbytes)
            swap.text = str(self.cpld.swapbytes.get())
            svn = ET.SubElement(cpld, self.__tagsvn)
            svn.text = self.cpld.svn.get()

        dom = xml.dom.minidom.parseString(ET.tostring(root))
        return(dom.toprettyxml(indent='  '))
    __startdir='.'
    def browse_script(self,target):
        """Opens a file browse menu and will allow the user to select a pem file
        that can be used to sign the binary
        """
        script_file = filedialog.askopenfilename(initialdir=self.__startdir, title = 'Select File', filetypes = (('script files','*.bat *.sh', ),), defaultextension='.bat')
        if script_file:
            self.__startdir=os.path.dirname(script_file)
            target.set(script_file)
    def browse_sigcert(self,target):
        """Opens a file browse menu and will allow the user to select a pem file
        that can be used to sign the binary
        """
        cert_file = filedialog.askopenfilename(initialdir=self.__startdir, title = 'Select File',filetypes = (('pem files','*.pem'),), defaultextension='.pem')
        if cert_file:
            self.__startdir=os.path.dirname(cert_file)
            target.set(cert_file)
    def browse_rkey_pubkey(self):
        self.browse_sigcert(self.block1.rkey.pubkey)
    def browse_cskey_pubkey(self):
        self.browse_sigcert(self.block1.cskey.pubkey)
    def browse_cskey_signkey(self):
        self.browse_sigcert(self.block1.cskey.signkey)
    def browse_cskey_script(self):
        self.browse_script(self.block1.cskey.script)
    def browse_b0sig_signkey(self):
        self.browse_sigcert(self.block1.b0sig.signkey)
    def browse_b0sig_script(self):
        self.browse_script(self.block1.b0sig.script)
    __menu_binding=None
    @property
    def menu_binding(self):
        return self.__menu_binding
    @menu_binding.setter
    def menu_binding(self, val):
        self.__menu_binding = val
    __cskey_int_entry_binding=None
    @property
    def cskey_int_entry_binding(self):
        return self.__cskey_int_entry_binding
    @cskey_int_entry_binding.setter
    def cskey_int_entry_binding(self, val):
        self.__cskey_int_entry_binding = val
    __cskey_int_button_binding=None
    @property
    def cskey_int_button_binding(self):
        return self.__cskey_int_button_binding
    @cskey_int_button_binding.setter
    def cskey_int_button_binding(self, val):
        self.__cskey_int_button_binding = val

    __cskey_ext_entry_binding=None
    @property
    def cskey_ext_entry_binding(self):
        return self.__cskey_ext_entry_binding
    @cskey_ext_entry_binding.setter
    def cskey_ext_entry_binding(self, val):
        self.__cskey_ext_entry_binding = val
    __cskey_ext_button_binding=None
    @property
    def cskey_ext_button_binding(self):
        return self.__cskey_ext_button_binding
    @cskey_ext_button_binding.setter
    def cskey_ext_button_binding(self, val):
        self.__cskey_ext_button_binding = val

    #__swapbytes=None
    #@property
    #def swapbytes(self):
    #    return self.__swapbytes
    #@swapbytes.setter
    #def swapbytes(self, val):
    #    self.__swapbytes = val
    #    
    #def toggle_swap(self):
    #    self.cpld.swapbytes.set(self.swapbytes)

    __sigmethod=None
    @property
    def sigmethod(self):
        return self.__sigmethod
    @sigmethod.setter
    def sigmethod(self, val):
        self.__sigmethod=val
    def toggle_sigmethod(self):
        if self.sigmethod.get() == True:
            self.cskey_int_entry_binding.config(state='normal')
            self.cskey_int_button_binding.config(state='normal')
            self.cskey_ext_entry_binding.config(state='disabled')
            self.cskey_ext_button_binding.config(state='disabled')
        else:
            self.cskey_int_entry_binding.config(state='disabled')
            self.cskey_int_button_binding.config(state='disabled')
            self.cskey_ext_entry_binding.config(state='normal')
            self.cskey_ext_button_binding.config(state='normal')

    __b0sigmethod=None
    @property
    def b0_sigmethod(self):
        return self.__b0sigmethod
    @b0_sigmethod.setter
    def b0_sigmethod(self, val):
        self.__b0sigmethod=val
    def toggle_b0_sigmethod(self):
        if self.__b0sigmethod.get() == True:
            self.b0sig_int_entry_binding.config(state='normal')
            self.b0sig_int_button_binding.config(state='normal')
            self.b0sig_ext_entry_binding.config(state='disabled')
            self.b0sig_ext_button_binding.config(state='disabled')
        else:
            self.b0sig_int_entry_binding.config(state='disabled')
            self.b0sig_int_button_binding.config(state='disabled')
            self.b0sig_ext_entry_binding.config(state='normal')
            self.b0sig_ext_button_binding.config(state='normal')

    __b0sig_int_entry_binding=None
    @property
    def b0sig_int_entry_binding(self):
        return self.__b0sig_int_entry_binding
    @b0sig_int_entry_binding.setter
    def b0sig_int_entry_binding(self, val):
        self.__b0sig_int_entry_binding = val
    __b0sig_int_button_binding=None
    @property
    def b0sig_int_button_binding(self):
        return self.__b0sig_int_button_binding
    @b0sig_int_button_binding.setter
    def b0sig_int_button_binding(self, val):
        self.__b0sig_int_button_binding = val

    __b0sig_ext_entry_binding=None
    @property
    def b0sig_ext_entry_binding(self):
        return self.__b0sig_ext_entry_binding
    @b0sig_ext_entry_binding.setter
    def b0sig_ext_entry_binding(self, val):
        self.__b0sig_ext_entry_binding = val
    __b0sig_ext_button_binding=None
    @property
    def b0sig_int_button_binding(self):
        return self.__b0sig_int_button_binding
    @b0sig_int_button_binding.setter
    def b0sig_int_button_binding(self, val):
        self.__b0sig_int_button_binding = val

    __cpld_binding=None
    @property
    def cpld_binding(self):
        return self.__cpld_binding
    @cpld_binding.setter
    def cpld_binding(self,val):
        self.__cpld_binding = val
    
    __enable_cpld=None
    @property
    def enable_cpld(self):
        return self.__enable_cpld
    @enable_cpld.setter
    def enable_cpld(self,val):
        self.__enable_cpld = val    
    def toggle_cpld(self):
        if self.enable_cpld.get() == False:
            for widget in self.cpld_binding.winfo_children():
                if widget is not LabelFrame:
                    widget.config(state='disabled')
        else:
            for widget in self.cpld_binding.winfo_children():
                if widget is not LabelFrame:
                    widget.config(state='normal')
        
    __padding_binding=None
    @property
    def padding_binding(self):
        return self.__padding_binding
    @padding_binding.setter
    def padding_binding(self, val):
        self.__padding_binding = val
        
    __enable_padding=None
    @property
    def enable_padding(self):
        return self.__enable_padding
    @enable_padding.setter
    def enable_padding(self, val):
        self.__enable_padding = val
    def toggle_padding(self):
        if self.enable_padding.get() == False:
            for widget in self.padding_binding.winfo_children():
                if widget is not LabelFrame:
                    widget.config(state='disabled')
        else:
            for widget in self.padding_binding.winfo_children():
                if widget is not LabelFrame:
                    widget.config(state='normal')

    __cskey_binding=None
    @property
    def cskey_binding(self):
        return self.__cskey_binding
    @cskey_binding.setter
    def cskey_binding(self, val):
        self.__cskey_binding=val
    __enable_cskey=None
    @property
    def enable_cskey(self):
        return self.__enable_cskey
    @enable_cskey.setter
    def enable_cskey(self, val):
        self.__enable_cskey = val
    def toggle_cskey(self):
        if self.enable_cskey.get() == False:
            for widget in self.cskey_binding.winfo_children():
                if widget is not LabelFrame:
                    widget.config(state='disabled')
        else:
            for widget in self.cskey_binding.winfo_children():
                if widget is not LabelFrame:
                    widget.config(state='normal')

    def saveas(self):
        filename = filedialog.asksaveasfilename(initialdir = '.', title = 'Select file',filetypes = (('xml files','*.xml'),),defaultextension='.xml')
        if filename:
            self.save(filename)
            self.__targetfile = filename
            self.menu_binding.entryconfig(1, state='normal')
    def save(self,xmlfile=None):
        if xmlfile==None:
            xmlfile=self.__targetfile
        f = open(xmlfile, 'w+')
        f.write(self.__assembleXml())
        f.close()
    
    def open(self):
        filename = filedialog.askopenfilename(initialdir = '.', title = 'Select file',filetypes = (('xml files','*.xml'),),defaultextension='.xml')
        if filename:
            tree = ET.parse(filename)
            b0tree = tree.find(self.__tagblock0)
            if b0tree != None:
                node = b0tree.find(self.__tagmagic)
                if node != None and node.text != None:
                    self.block0.magic.set(node.text)
                node = b0tree.find(self.__tagpctype)
                if node != None and node.text != None:
                    self.block0.pctype.set(node.text)
            b1tree = tree.find(self.__tagblock1)
            if b1tree != None:
                node = b1tree.find(self.__tagmagic)
                if node != None and node.text != None:
                    self.block1.magic.set(node.text)
                rkey = b1tree.find(self.__tagrkey)
                if rkey != None:
                    node = rkey.find(self.__tagmagic)
                    if node != None and node.text != None:
                        self.block1.rkey.magic.set(node.text)
                    node = rkey.find(self.__tagcurvemagic)
                    if node != None and node.text != None:
                        self.block1.rkey.curvemagic.set(node.text)
                    node = rkey.find(self.__tagpermissions)
                    if node != None and node.text != None:
                        self.block1.rkey.permissions.set(node.text)
                    node = rkey.find(self.__tagkeyid)
                    if node != None and node.text != None:
                        self.block1.rkey.keyid.set(node.text)
                    node = rkey.find(self.__tagpubkey)
                    if node != None and node.text != None:
                        self.block1.rkey.pubkey.set(node.text)
                cskey = b1tree.find(self.__tagcskey)
                if cskey != None:
                    node = cskey.find(self.__tagmagic)
                    if node != None and node.text != None:
                        self.block1.cskey.magic.set(node.text)
                    node = cskey.find(self.__tagcurvemagic)
                    if node != None and node.text != None:
                        self.block1.cskey.curvemagic.set(node.text)
                    node = cskey.find(self.__tagpermissions)
                    if node != None and node.text != None:
                        self.block1.cskey.permissions.set(node.text)
                    node = cskey.find(self.__tagkeyid)
                    if node != None and node.text != None:
                        self.block1.cskey.keyid.set(node.text)
                    node = cskey.find(self.__tagpubkey)
                    if node != None and node.text != None:
                        self.block1.cskey.pubkey.set(node.text)
                    node = cskey.find(self.__tagsigmagic)
                    if node != None and node.text != None:
                        self.block1.cskey.sigmagic.set(node.text)
                    node = cskey.find(self.__taghashalg)
                    if node != None and node.text != None:
                        self.block1.cskey.hashalg.set(node.text)
                    node = cskey.find(self.__tagsignkey)
                    if node != None and node.text != None:
                        self.block1.cskey.signkey.set(node.text)
                        self.sigmethod.set(True)
                    node = cskey.find(self.__tagscript)
                    if node != None and node.text != None:
                        self.block1.cskey.script.set(node.text)
                        self.sigmethod.set(False)
                    self.toggle_sigmethod()
                b0sig = b1tree.find(self.__tagb0sig)
                if b0sig != None:
                    node = b0sig.find(self.__tagmagic)
                    if node != None and node.text != None:
                        self.block1.b0sig.magic.set(node.text)
                    node = b0sig.find(self.__tagsigmagic)
                    if node != None and node.text != None:
                        self.block1.b0sig.sigmagic.set(node.text)
                    node = b0sig.find(self.__taghashalg)
                    if node != None and node.text != None:
                        self.block1.b0sig.hashalg.set(node.text)
                    node = b0sig.find(self.__tagsignkey)
                    if node != None and node.text != None:
                        self.block1.b0sig.signkey.set(node.text)
                    node = b0sig.find(self.__tagscript)
                    if node != None and node.text != None:
                        self.block1.b0sig.script.set(node.text)
            padding = tree.find(self.__tagpadding)
            if padding != None:
                self.enable_padding.set(True)
                self.toggle_padding()
                node = padding.find(self.__tagblockpad)
                if node != None and node.text != None:
                    self.padding.blockpad.set(node.text)
                node = padding.find(self.__tagalign)
                if node != None and node.text != None:
                    self.padding.align.set(node.text)
            cpld = tree.find(self.__tagcpld)
            if cpld != None:
                self.enable_cpld.set(True)
                self.toggle_cpld()
                node = cpld.find(self.__tagswapbytes)
                if node != None and node.text != None:
                    self.cpld.swapbytes.set(node.text)
                node = cpld.find(self.__tagsvn)
                if node != None and node.text != None:
                    self.cpld.svn.set(node.text)
            self.__targetfile = filename
            self.menu_binding.entryconfig(1, state='normal')


    # Error checking around text input
    def validate_hex(self, d, i, P, s, S, v, V, W):
        try:
            if P is "":
                self.__view.nametowidget(W).config(highlightbackground='gray94', highlightcolor='gray94', fg='black')
                return True
            else:
                int(P,16)
        except ValueError:
            self.__view.nametowidget(W).config(highlightbackground='red', highlightcolor='red', fg='red')
            return False
        if len(P) > 10:
            self.__view.nametowidget(W).config(highlightbackground='red', highlightcolor='red', fg='red')
            return False
        self.__view.nametowidget(W).config(highlightbackground='gray94', highlightcolor='gray94', fg='black')
        return True
    def validate_dec(self, d, i, P, s, S, v, V, W):
        try:
            if P is "":
                self.__view.nametowidget(W).config(highlightbackground='gray94', highlightcolor='gray94', fg='black')
                return True
            else:
                int(P,10)
        except ValueError:
            self.__view.nametowidget(W).config(highlightbackground='red', highlightcolor='red', fg='red')
            return False
        if len(P) > 8:
            self.__view.nametowidget(W).config(highlightbackground='red', highlightcolor='red', fg='red')
            return False
        self.__view.nametowidget(W).config(highlightbackground='gray94', highlightcolor='gray94', fg='black')
        return True
