
/** @file
  CoreMsrcommon.h


  <b>Conventions</b>
  - Definitions beginning with "MSR_" are MSRs
  - Definitions beginning with "R_" are registers
  - Definitions beginning with "B_" are bits within registers
  - Definitions beginning with "V_" are meaningful values of bits within the registers
  - Definitions beginning with "S_" are register sizes
  - Definitions beginning with "N_" are the bit position

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _CORE_MSRCOMMON_h
#define _CORE_MSRCOMMON_h
/*
*/
#define MSR_ACM_CPU_KEY_HASH_0 0x00000020

#define N_MSR_ACM_CPU_KEY_HASH_0_KEY_HASH_63_0_OFFSET 0
#define S_MSR_ACM_CPU_KEY_HASH_0_KEY_HASH_63_0_WIDTH 64
#define B_MSR_ACM_CPU_KEY_HASH_0_KEY_HASH_63_0_MASK (0xFFFFFFFFFFFFFFFFULL)

/*
*/
#define MSR_ACM_CPU_KEY_HASH_1 0x00000021

#define N_MSR_ACM_CPU_KEY_HASH_1_KEY_HASH_127_64_OFFSET 0
#define S_MSR_ACM_CPU_KEY_HASH_1_KEY_HASH_127_64_WIDTH 64
#define B_MSR_ACM_CPU_KEY_HASH_1_KEY_HASH_127_64_MASK (0xFFFFFFFFFFFFFFFFULL)

/*
*/
#define MSR_ACM_CPU_KEY_HASH_2 0x00000022

#define N_MSR_ACM_CPU_KEY_HASH_2_KEY_HASH_191_128_OFFSET 0
#define S_MSR_ACM_CPU_KEY_HASH_2_KEY_HASH_191_128_WIDTH 64
#define B_MSR_ACM_CPU_KEY_HASH_2_KEY_HASH_191_128_MASK (0xFFFFFFFFFFFFFFFFULL)

/*
*/
#define MSR_ACM_CPU_KEY_HASH_3 0x00000023

#define N_MSR_ACM_CPU_KEY_HASH_3_KEY_HASH_255_192_OFFSET 0
#define S_MSR_ACM_CPU_KEY_HASH_3_KEY_HASH_255_192_WIDTH 64
#define B_MSR_ACM_CPU_KEY_HASH_3_KEY_HASH_255_192_MASK (0xFFFFFFFFFFFFFFFFULL)

/*
*/
#define MSR_PIC_MSG_CONTROL 0x0000002E

/*
*/
#define N_MSR_PIC_MSG_CONTROL_TPR_MSG_OFF_OFFSET 10
#define S_MSR_PIC_MSG_CONTROL_TPR_MSG_OFF_WIDTH 1
#define B_MSR_PIC_MSG_CONTROL_TPR_MSG_OFF_MASK BIT10

/*
*/
#define MSR_MEMORY_CONTROL 0x00000033

/*
*/
#define N_MSR_MEMORY_CONTROL_SPLIT_LOCK_DISABLE_OFFSET 29
#define S_MSR_MEMORY_CONTROL_SPLIT_LOCK_DISABLE_WIDTH 1
#define B_MSR_MEMORY_CONTROL_SPLIT_LOCK_DISABLE_MASK BIT29

/*
*/
#define N_MSR_MEMORY_CONTROL_SUPPRESS_SPLIT_LOCK_OFFSET 31
#define S_MSR_MEMORY_CONTROL_SUPPRESS_SPLIT_LOCK_WIDTH 1
#define B_MSR_MEMORY_CONTROL_SUPPRESS_SPLIT_LOCK_MASK BIT31

#define MSR_CORE_THREAD_COUNT 0x00000035

#define N_MSR_CORE_THREAD_COUNT_THREADCOUNT_OFFSET 0
#define S_MSR_CORE_THREAD_COUNT_THREADCOUNT_WIDTH 16
#define B_MSR_CORE_THREAD_COUNT_THREADCOUNT_MASK (0x000000000000FFFF)

#define N_MSR_CORE_THREAD_COUNT_CORECOUNT_OFFSET 16
#define S_MSR_CORE_THREAD_COUNT_CORECOUNT_WIDTH 16
#define B_MSR_CORE_THREAD_COUNT_CORECOUNT_MASK (0x00000000FFFF0000)

#define MSR_BIOS_UPGD_TRIG 0x0000007A

/*
*/
#define N_MSR_BIOS_UPGD_TRIG_SE_OFFSET 0
#define S_MSR_BIOS_UPGD_TRIG_SE_WIDTH 1
#define B_MSR_BIOS_UPGD_TRIG_SE_MASK BIT0

/*
*/
#define N_MSR_BIOS_UPGD_TRIG_RSVD_OFFSET 1
#define S_MSR_BIOS_UPGD_TRIG_RSVD_WIDTH 63
#define B_MSR_BIOS_UPGD_TRIG_RSVD_MASK (0xFFFFFFFFFFFFFFFEULL)

/*
*/
#define MSR_BIOS_SIGN_ID 0x0000008B

/*
*/
#define N_MSR_BIOS_SIGN_ID_RSVD_OFFSET 0
#define S_MSR_BIOS_SIGN_ID_RSVD_WIDTH 32
#define B_MSR_BIOS_SIGN_ID_RSVD_MASK (0x00000000FFFFFFFF)

#define N_MSR_BIOS_SIGN_ID_PATCH_ID_OFFSET 32
#define S_MSR_BIOS_SIGN_ID_PATCH_ID_WIDTH 32
#define B_MSR_BIOS_SIGN_ID_PATCH_ID_MASK (0xFFFFFFFF00000000ULL)


/*
*/
#define MSR_SGX_MCU_ERRORCODE 0x000000A0

/*
*/
#define N_MSR_SGX_MCU_ERRORCODE_MCHECK_ERROR_CODE_OFFSET 0
#define S_MSR_SGX_MCU_ERRORCODE_MCHECK_ERROR_CODE_WIDTH 16
#define B_MSR_SGX_MCU_ERRORCODE_MCHECK_ERROR_CODE_MASK (0x000000000000FFFF)

/*
*/
#define N_MSR_SGX_MCU_ERRORCODE_PARTIAL_SUCCESS_OFFSET 31
#define S_MSR_SGX_MCU_ERRORCODE_PARTIAL_SUCCESS_WIDTH 1
#define B_MSR_SGX_MCU_ERRORCODE_PARTIAL_SUCCESS_MASK BIT31

/*
*/
#define MSR_MTRRCAP 0x000000FE

/*
*/
#define N_MSR_MTRRCAP_VCNT_OFFSET 0
#define S_MSR_MTRRCAP_VCNT_WIDTH 8
#define B_MSR_MTRRCAP_VCNT_MASK (0x000000FF)

/*
*/
#define N_MSR_MTRRCAP_FIX_OFFSET 8
#define S_MSR_MTRRCAP_FIX_WIDTH 1
#define B_MSR_MTRRCAP_FIX_MASK BIT8

/*
*/
#define N_MSR_MTRRCAP_RSVD1_OFFSET 9
#define S_MSR_MTRRCAP_RSVD1_WIDTH 1
#define B_MSR_MTRRCAP_RSVD1_MASK BIT9

/*
*/
#define N_MSR_MTRRCAP_WC_OFFSET 10
#define S_MSR_MTRRCAP_WC_WIDTH 1
#define B_MSR_MTRRCAP_WC_MASK BIT10

/*
*/
#define N_MSR_MTRRCAP_SMRR_OFFSET 11
#define S_MSR_MTRRCAP_SMRR_WIDTH 1
#define B_MSR_MTRRCAP_SMRR_MASK BIT11

/*
*/
#define N_MSR_MTRRCAP_PRMRR_OFFSET 12
#define S_MSR_MTRRCAP_PRMRR_WIDTH 1
#define B_MSR_MTRRCAP_PRMRR_MASK BIT12

/*
*/
#define N_MSR_MTRRCAP_SMRR2_OFFSET 13
#define S_MSR_MTRRCAP_SMRR2_WIDTH 1
#define B_MSR_MTRRCAP_SMRR2_MASK BIT13

/*
*/
#define N_MSR_MTRRCAP_SMRR_LOCK_OFFSET 14
#define S_MSR_MTRRCAP_SMRR_LOCK_WIDTH 1
#define B_MSR_MTRRCAP_SMRR_LOCK_MASK BIT14

/*
*/
#define N_MSR_MTRRCAP_RSVD2_OFFSET 15
#define S_MSR_MTRRCAP_RSVD2_WIDTH 17
#define B_MSR_MTRRCAP_RSVD2_MASK (0xFFFF8000)

/*
*/
#define MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG 0x00000121

/*
*/
#define N_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_EMULATED_IO_PORT_OFFSET 0
#define S_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_EMULATED_IO_PORT_WIDTH 16
#define B_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_EMULATED_IO_PORT_MASK (0x000000000000FFFF)

/*
*/
#define N_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_VALID_OFFSET 16
#define S_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_VALID_WIDTH 1
#define B_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_VALID_MASK BIT16

/*
*/
#define N_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_RSVD_OFFSET 17
#define S_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_RSVD_WIDTH 3
#define B_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_RSVD_MASK (0x00000000000E0000)

/*
*/
#define N_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_RSP_DELAY_LOOP_COUNT_OFFSET 20
#define S_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_RSP_DELAY_LOOP_COUNT_WIDTH 12
#define B_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_RSP_DELAY_LOOP_COUNT_MASK (0x00000000FFF00000)

/*
*/
#define N_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_CORRECTION_FACTOR_OFFSET 32
#define S_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_CORRECTION_FACTOR_WIDTH 32
#define B_MSR_BIOS_UCODE_PM_TMR_EMULATION_CFG_CORRECTION_FACTOR_MASK (0xFFFFFFFF00000000ULL)

#define MSR_BIOS_DONE 0x00000151

#define N_MSR_BIOS_DONE_ENABLE_IA_UNTRUSTED_OFFSET 0
#define S_MSR_BIOS_DONE_ENABLE_IA_UNTRUSTED_WIDTH 1
#define B_MSR_BIOS_DONE_ENABLE_IA_UNTRUSTED_MASK BIT0

#define N_MSR_BIOS_DONE_SOC_BIOS_DONE_OFFSET 1
#define S_MSR_BIOS_DONE_SOC_BIOS_DONE_WIDTH 1
#define B_MSR_BIOS_DONE_SOC_BIOS_DONE_MASK BIT1

/*
*/
#define MSR_SMM_MCA_CAP 0x0000017D

/*
*/
#define N_MSR_SMM_MCA_CAP_BANK_SUPPORT_OFFSET 0
#define S_MSR_SMM_MCA_CAP_BANK_SUPPORT_WIDTH 32
#define B_MSR_SMM_MCA_CAP_BANK_SUPPORT_MASK (0x00000000FFFFFFFF)

/*
*/
#define N_MSR_SMM_MCA_CAP_RSVD_OFFSET 32
#define S_MSR_SMM_MCA_CAP_RSVD_WIDTH 22
#define B_MSR_SMM_MCA_CAP_RSVD_MASK (0x003FFFFF00000000ULL)

/*
*/
#define N_MSR_SMM_MCA_CAP_SMM_PROT_MODE_OFFSET 54
#define S_MSR_SMM_MCA_CAP_SMM_PROT_MODE_WIDTH 1
#define B_MSR_SMM_MCA_CAP_SMM_PROT_MODE_MASK BIT54

/*
*/
#define N_MSR_SMM_MCA_CAP_ERROR_SPOOFING_OFFSET 55
#define S_MSR_SMM_MCA_CAP_ERROR_SPOOFING_WIDTH 1
#define B_MSR_SMM_MCA_CAP_ERROR_SPOOFING_MASK BIT55

/*
*/
#define N_MSR_SMM_MCA_CAP_TARGETED_SMI_OFFSET 56
#define S_MSR_SMM_MCA_CAP_TARGETED_SMI_WIDTH 1
#define B_MSR_SMM_MCA_CAP_TARGETED_SMI_MASK BIT56

/*
*/
#define N_MSR_SMM_MCA_CAP_SMM_CPU_SVRSTR_OFFSET 57
#define S_MSR_SMM_MCA_CAP_SMM_CPU_SVRSTR_WIDTH 1
#define B_MSR_SMM_MCA_CAP_SMM_CPU_SVRSTR_MASK BIT57

#define N_MSR_SMM_MCA_CAP_SMM_CODE_ACCESS_CHK_OFFSET 58
#define S_MSR_SMM_MCA_CAP_SMM_CODE_ACCESS_CHK_WIDTH 1
#define B_MSR_SMM_MCA_CAP_SMM_CODE_ACCESS_CHK_MASK BIT58

/*
*/
#define N_MSR_SMM_MCA_CAP_LONG_FLOW_INDICATION_OFFSET 59
#define S_MSR_SMM_MCA_CAP_LONG_FLOW_INDICATION_WIDTH 1
#define B_MSR_SMM_MCA_CAP_LONG_FLOW_INDICATION_MASK BIT59

/*
*/
#define N_MSR_SMM_MCA_CAP_SMM_RSVD_OFFSET 60
#define S_MSR_SMM_MCA_CAP_SMM_RSVD_WIDTH 4
#define B_MSR_SMM_MCA_CAP_SMM_RSVD_MASK (0xF000000000000000ULL)

/*
*/
#define MSR_MISC_ENABLES 0x000001A0

/*
*/
#define N_MSR_MISC_ENABLES_FAST_STRINGS_OFFSET 0
#define S_MSR_MISC_ENABLES_FAST_STRINGS_WIDTH 1
#define B_MSR_MISC_ENABLES_FAST_STRINGS_MASK BIT0

/*
*/
#define N_MSR_MISC_ENABLES_RSVD1_OFFSET 1
#define S_MSR_MISC_ENABLES_RSVD1_WIDTH 1
#define B_MSR_MISC_ENABLES_RSVD1_MASK BIT1

#define N_MSR_MISC_ENABLES_THERMAL_MONITOR_ENABLE_OFFSET 3
#define S_MSR_MISC_ENABLES_THERMAL_MONITOR_ENABLE_WIDTH 1
#define B_MSR_MISC_ENABLES_THERMAL_MONITOR_ENABLE_MASK BIT3

/*
*/
#define N_MSR_MISC_ENABLES_RSVD2_OFFSET 4
#define S_MSR_MISC_ENABLES_RSVD2_WIDTH 3
#define B_MSR_MISC_ENABLES_RSVD2_MASK (0x0000000000000070)

#define N_MSR_MISC_ENABLES_EMON_AVAILABLE_OFFSET 7
#define S_MSR_MISC_ENABLES_EMON_AVAILABLE_WIDTH 1
#define B_MSR_MISC_ENABLES_EMON_AVAILABLE_MASK BIT7

/*
*/
#define N_MSR_MISC_ENABLES_RSVD3_OFFSET 8
#define S_MSR_MISC_ENABLES_RSVD3_WIDTH 3
#define B_MSR_MISC_ENABLES_RSVD3_MASK (0x0000000000000700)

#define N_MSR_MISC_ENABLES_BTS_UNAVAILABLE_OFFSET 11
#define S_MSR_MISC_ENABLES_BTS_UNAVAILABLE_WIDTH 1
#define B_MSR_MISC_ENABLES_BTS_UNAVAILABLE_MASK BIT11

#define N_MSR_MISC_ENABLES_PEBS_UNAVAILABLE_OFFSET 12
#define S_MSR_MISC_ENABLES_PEBS_UNAVAILABLE_WIDTH 1
#define B_MSR_MISC_ENABLES_PEBS_UNAVAILABLE_MASK BIT12

/*
*/
#define N_MSR_MISC_ENABLES_RSVD4_OFFSET 13
#define S_MSR_MISC_ENABLES_RSVD4_WIDTH 3
#define B_MSR_MISC_ENABLES_RSVD4_MASK (0x000000000000E000)

#define N_MSR_MISC_ENABLES_ENABLE_GV3_OFFSET 16
#define S_MSR_MISC_ENABLES_ENABLE_GV3_WIDTH 1
#define B_MSR_MISC_ENABLES_ENABLE_GV3_MASK BIT16

/*
*/
#define N_MSR_MISC_ENABLES_RSVD_BIT_17_OFFSET 17
#define S_MSR_MISC_ENABLES_RSVD_BIT_17_WIDTH 1
#define B_MSR_MISC_ENABLES_RSVD_BIT_17_MASK BIT17

/*
*/
#define N_MSR_MISC_ENABLES_ENABLE_MONITOR_FSM_OFFSET 18
#define S_MSR_MISC_ENABLES_ENABLE_MONITOR_FSM_WIDTH 1
#define B_MSR_MISC_ENABLES_ENABLE_MONITOR_FSM_MASK BIT18

/*
*/
#define N_MSR_MISC_ENABLES_RSVD5_OFFSET 19
#define S_MSR_MISC_ENABLES_RSVD5_WIDTH 3
#define B_MSR_MISC_ENABLES_RSVD5_MASK (0x0000000000380000)

#define N_MSR_MISC_ENABLES_BOOT_NT4_OFFSET 22
#define S_MSR_MISC_ENABLES_BOOT_NT4_WIDTH 1
#define B_MSR_MISC_ENABLES_BOOT_NT4_MASK BIT22

/*
*/
#define N_MSR_MISC_ENABLES_TPR_MESSAGE_DISABLE_OFFSET 23
#define S_MSR_MISC_ENABLES_TPR_MESSAGE_DISABLE_WIDTH 1
#define B_MSR_MISC_ENABLES_TPR_MESSAGE_DISABLE_MASK BIT23

/*
*/
#define N_MSR_MISC_ENABLES_RSVD6_OFFSET 24
#define S_MSR_MISC_ENABLES_RSVD6_WIDTH 3
#define B_MSR_MISC_ENABLES_RSVD6_MASK (0x0000000007000000)

/*
*/
#define N_MSR_MISC_ENABLES_HLEP_DISABLE_OFFSET 28
#define S_MSR_MISC_ENABLES_HLEP_DISABLE_WIDTH 1
#define B_MSR_MISC_ENABLES_HLEP_DISABLE_MASK BIT28

/*
*/
#define N_MSR_MISC_ENABLES_RSVD8_OFFSET 29
#define S_MSR_MISC_ENABLES_RSVD8_WIDTH 9
#define B_MSR_MISC_ENABLES_RSVD8_MASK (0x0000003FE0000000ULL)

/*
*/
#define N_MSR_MISC_ENABLES_TURBO_MODE_DISABLE_OFFSET 38
#define S_MSR_MISC_ENABLES_TURBO_MODE_DISABLE_WIDTH 1
#define B_MSR_MISC_ENABLES_TURBO_MODE_DISABLE_MASK BIT38

/*
*/
#define N_MSR_MISC_ENABLES_RSVD9_OFFSET 39
#define S_MSR_MISC_ENABLES_RSVD9_WIDTH 25
#define B_MSR_MISC_ENABLES_RSVD9_MASK (0xFFFFFF8000000000ULL)

/*
*/
#define MSR_MISC_FEATURE_CONTROL 0x000001A4

/*
*/
#define N_MSR_MISC_FEATURE_CONTROL_MLC_STREAMER_PREFETCH_DISABLE_OFFSET 0
#define S_MSR_MISC_FEATURE_CONTROL_MLC_STREAMER_PREFETCH_DISABLE_WIDTH 1
#define B_MSR_MISC_FEATURE_CONTROL_MLC_STREAMER_PREFETCH_DISABLE_MASK BIT0

/*
*/
#define N_MSR_MISC_FEATURE_CONTROL_MLC_SPATIAL_PREFETCH_DISABLE_OFFSET 1
#define S_MSR_MISC_FEATURE_CONTROL_MLC_SPATIAL_PREFETCH_DISABLE_WIDTH 1
#define B_MSR_MISC_FEATURE_CONTROL_MLC_SPATIAL_PREFETCH_DISABLE_MASK BIT1

/*
*/
#define N_MSR_MISC_FEATURE_CONTROL_DCU_STREAMER_PREFETCH_DISABLE_OFFSET 2
#define S_MSR_MISC_FEATURE_CONTROL_DCU_STREAMER_PREFETCH_DISABLE_WIDTH 1
#define B_MSR_MISC_FEATURE_CONTROL_DCU_STREAMER_PREFETCH_DISABLE_MASK BIT2

/*
*/
#define N_MSR_MISC_FEATURE_CONTROL_DCU_IP_PREFETCH_DISABLE_OFFSET 3
#define S_MSR_MISC_FEATURE_CONTROL_DCU_IP_PREFETCH_DISABLE_WIDTH 1
#define B_MSR_MISC_FEATURE_CONTROL_DCU_IP_PREFETCH_DISABLE_MASK BIT3

/*
*/
#define N_MSR_MISC_FEATURE_CONTROL_RSVD_OFFSET 5
#define S_MSR_MISC_FEATURE_CONTROL_RSVD_WIDTH 1
#define B_MSR_MISC_FEATURE_CONTROL_RSVD_MASK BIT5

/*
*/
#define N_MSR_MISC_FEATURE_CONTROL_DISABLE_THREE_STRIKE_CNT_OFFSET 11
#define S_MSR_MISC_FEATURE_CONTROL_DISABLE_THREE_STRIKE_CNT_WIDTH 1
#define B_MSR_MISC_FEATURE_CONTROL_DISABLE_THREE_STRIKE_CNT_MASK BIT11

/*
*/
#define N_MSR_MISC_FEATURE_CONTROL_RSVD_12_31_OFFSET 12
#define S_MSR_MISC_FEATURE_CONTROL_RSVD_12_31_WIDTH 20
#define B_MSR_MISC_FEATURE_CONTROL_RSVD_12_31_MASK (0xFFFFF000)

/*
*/
#define MSR_THREAD_SW_DEFEATURE 0x000001A8

/*
*/
#define N_MSR_THREAD_SW_DEFEATURE_XINIT_DISABLE_OFFSET 0
#define S_MSR_THREAD_SW_DEFEATURE_XINIT_DISABLE_WIDTH 1
#define B_MSR_THREAD_SW_DEFEATURE_XINIT_DISABLE_MASK BIT0

/*
*/
#define N_MSR_THREAD_SW_DEFEATURE_XMODIFIED_DISABLE_OFFSET 1
#define S_MSR_THREAD_SW_DEFEATURE_XMODIFIED_DISABLE_WIDTH 1
#define B_MSR_THREAD_SW_DEFEATURE_XMODIFIED_DISABLE_MASK BIT1

/*
*/
#define MSR_SMRR_MASK 0x000001F3

/*
*/
#define N_MSR_SMRR_MASK_ASSIST_OFFSET 9
#define S_MSR_SMRR_MASK_ASSIST_WIDTH 1
#define B_MSR_SMRR_MASK_ASSIST_MASK BIT9

/*
*/
#define N_MSR_SMRR_MASK_L_OFFSET 10
#define S_MSR_SMRR_MASK_L_WIDTH 1
#define B_MSR_SMRR_MASK_L_MASK BIT10

/*
*/
#define N_MSR_SMRR_MASK_VLD_OFFSET 11
#define S_MSR_SMRR_MASK_VLD_WIDTH 1
#define B_MSR_SMRR_MASK_VLD_MASK BIT11

/*
*/
#define N_MSR_SMRR_MASK_MASK_OFFSET 12
#define S_MSR_SMRR_MASK_MASK_WIDTH 20
#define B_MSR_SMRR_MASK_MASK_MASK (0x00000000FFFFF000)

/*
*/
#define MSR_PRMRR_MASK 0x000001F5

/*
*/
#define N_MSR_PRMRR_MASK_ASSIST_OFFSET 9
#define S_MSR_PRMRR_MASK_ASSIST_WIDTH 1
#define B_MSR_PRMRR_MASK_ASSIST_MASK BIT9

/*
*/
#define N_MSR_PRMRR_MASK_L_OFFSET 10
#define S_MSR_PRMRR_MASK_L_WIDTH 1
#define B_MSR_PRMRR_MASK_L_MASK BIT10

/*
*/
#define N_MSR_PRMRR_MASK_VLD_OFFSET 11
#define S_MSR_PRMRR_MASK_VLD_WIDTH 1
#define B_MSR_PRMRR_MASK_VLD_MASK BIT11

/*
*/
#define N_MSR_PRMRR_MASK_MASK_OFFSET 12
#define S_MSR_PRMRR_MASK_MASK_WIDTH 40
#define B_MSR_PRMRR_MASK_MASK_MASK (0x000FFFFFFFFFF000ULL)

/*
*/
#define MSR_PRMRR_VALID_CONFIG 0x000001FB

/*
*/
#define N_MSR_PRMRR_VALID_CONFIG_CONFIG_1M_OFFSET 0
#define S_MSR_PRMRR_VALID_CONFIG_CONFIG_1M_WIDTH 1
#define B_MSR_PRMRR_VALID_CONFIG_CONFIG_1M_MASK BIT0

/*
*/
#define N_MSR_PRMRR_VALID_CONFIG_RSVD1_OFFSET 1
#define S_MSR_PRMRR_VALID_CONFIG_RSVD1_WIDTH 4
#define B_MSR_PRMRR_VALID_CONFIG_RSVD1_MASK (0x0000001E)

/*
*/
#define N_MSR_PRMRR_VALID_CONFIG_CONFIG_32M_OFFSET 5
#define S_MSR_PRMRR_VALID_CONFIG_CONFIG_32M_WIDTH 1
#define B_MSR_PRMRR_VALID_CONFIG_CONFIG_32M_MASK BIT5

/*
*/
#define N_MSR_PRMRR_VALID_CONFIG_CONFIG_64M_OFFSET 6
#define S_MSR_PRMRR_VALID_CONFIG_CONFIG_64M_WIDTH 1
#define B_MSR_PRMRR_VALID_CONFIG_CONFIG_64M_MASK BIT6

/*
*/
#define N_MSR_PRMRR_VALID_CONFIG_CONFIG_128M_OFFSET 7
#define S_MSR_PRMRR_VALID_CONFIG_CONFIG_128M_WIDTH 1
#define B_MSR_PRMRR_VALID_CONFIG_CONFIG_128M_MASK BIT7

/*
*/
#define N_MSR_PRMRR_VALID_CONFIG_CONFIG_256M_OFFSET 8
#define S_MSR_PRMRR_VALID_CONFIG_CONFIG_256M_WIDTH 1
#define B_MSR_PRMRR_VALID_CONFIG_CONFIG_256M_MASK BIT8

/*
*/
#define N_MSR_PRMRR_VALID_CONFIG_RSVD2_OFFSET 9
#define S_MSR_PRMRR_VALID_CONFIG_RSVD2_WIDTH 23
#define B_MSR_PRMRR_VALID_CONFIG_RSVD2_MASK (0xFFFFFE00)

/*
*/
#define MSR_SPCL_CHIPSET_USAGE 0x000001FE

/*
*/
#define N_MSR_SPCL_CHIPSET_USAGE_DATA_OFFSET 0
#define S_MSR_SPCL_CHIPSET_USAGE_DATA_WIDTH 32
#define B_MSR_SPCL_CHIPSET_USAGE_DATA_MASK (0xFFFFFFFF)

/*
*/
#define MSR_PAT 0x00000277

/*
*/
#define N_MSR_PAT_ENTRY0_OFFSET 0
#define S_MSR_PAT_ENTRY0_WIDTH 3
#define B_MSR_PAT_ENTRY0_MASK (0x0000000000000007)

/*
*/
#define N_MSR_PAT_ENTRY1_OFFSET 8
#define S_MSR_PAT_ENTRY1_WIDTH 3
#define B_MSR_PAT_ENTRY1_MASK (0x0000000000000700)

/*
*/
#define N_MSR_PAT_ENTRY2_OFFSET 16
#define S_MSR_PAT_ENTRY2_WIDTH 3
#define B_MSR_PAT_ENTRY2_MASK (0x0000000000070000)

/*
*/
#define N_MSR_PAT_ENTRY3_OFFSET 24
#define S_MSR_PAT_ENTRY3_WIDTH 3
#define B_MSR_PAT_ENTRY3_MASK (0x0000000007000000)

/*
*/
#define N_MSR_PAT_ENTRY4_OFFSET 32
#define S_MSR_PAT_ENTRY4_WIDTH 3
#define B_MSR_PAT_ENTRY4_MASK (0x0000000700000000ULL)

/*
*/
#define N_MSR_PAT_ENTRY5_OFFSET 40
#define S_MSR_PAT_ENTRY5_WIDTH 3
#define B_MSR_PAT_ENTRY5_MASK (0x0000070000000000ULL)

/*
*/
#define N_MSR_PAT_ENTRY6_OFFSET 48
#define S_MSR_PAT_ENTRY6_WIDTH 3
#define B_MSR_PAT_ENTRY6_MASK (0x0007000000000000ULL)

/*
*/
#define N_MSR_PAT_ENTRY7_OFFSET 56
#define S_MSR_PAT_ENTRY7_WIDTH 3
#define B_MSR_PAT_ENTRY7_MASK (0x0700000000000000ULL)

/*
*/
#define MSR_PRMRR_BASE_0 0x000002A0

/*
*/
#define N_MSR_PRMRR_BASE_0_MEMTYPE_OFFSET 0
#define S_MSR_PRMRR_BASE_0_MEMTYPE_WIDTH 3
#define B_MSR_PRMRR_BASE_0_MEMTYPE_MASK (0x0000000000000007)

/*
*/
#define N_MSR_PRMRR_BASE_0_CONFIGURED_OFFSET 3
#define S_MSR_PRMRR_BASE_0_CONFIGURED_WIDTH 1
#define B_MSR_PRMRR_BASE_0_CONFIGURED_MASK BIT3

/*
*/
#define N_MSR_PRMRR_BASE_0_BASE_OFFSET 12
#define S_MSR_PRMRR_BASE_0_BASE_WIDTH 40
#define B_MSR_PRMRR_BASE_0_BASE_MASK (0x000FFFFFFFFFF000ULL)

/*
*/
#define MSR_LT_UNLOCK_MEMORY 0x000002E6

/*
*/
#define N_MSR_LT_UNLOCK_MEMORY_RSVD_OFFSET 0
#define S_MSR_LT_UNLOCK_MEMORY_RSVD_WIDTH 64
#define B_MSR_LT_UNLOCK_MEMORY_RSVD_MASK (0xFFFFFFFFFFFFFFFFULL)

/*
*/
#define MSR_BIOS_SE_SVN 0x00000302

#define N_MSR_BIOS_SE_SVN_RESERVED1_OFFSET 0
#define S_MSR_BIOS_SE_SVN_RESERVED1_WIDTH 16
#define B_MSR_BIOS_SE_SVN_RESERVED1_MASK (0x000000000000FFFF)

#define N_MSR_BIOS_SE_SVN_SINIT_SE_SVN_OFFSET 16
#define S_MSR_BIOS_SE_SVN_SINIT_SE_SVN_WIDTH 8
#define B_MSR_BIOS_SE_SVN_SINIT_SE_SVN_MASK (0x0000000000FF0000)

#define N_MSR_BIOS_SE_SVN_SCLEAN_SE_SVN_OFFSET 24
#define S_MSR_BIOS_SE_SVN_SCLEAN_SE_SVN_WIDTH 8
#define B_MSR_BIOS_SE_SVN_SCLEAN_SE_SVN_MASK (0x00000000FF000000)

#define N_MSR_BIOS_SE_SVN_ANC_SE_SVN_OFFSET 32
#define S_MSR_BIOS_SE_SVN_ANC_SE_SVN_WIDTH 8
#define B_MSR_BIOS_SE_SVN_ANC_SE_SVN_MASK (0x000000FF00000000ULL)

#define N_MSR_BIOS_SE_SVN_PFAT_SE_SVN_OFFSET 40
#define S_MSR_BIOS_SE_SVN_PFAT_SE_SVN_WIDTH 8
#define B_MSR_BIOS_SE_SVN_PFAT_SE_SVN_MASK (0x0000FF0000000000ULL)

#define N_MSR_BIOS_SE_SVN_RESERVED2_OFFSET 48
#define S_MSR_BIOS_SE_SVN_RESERVED2_WIDTH 16
#define B_MSR_BIOS_SE_SVN_RESERVED2_MASK (0xFFFF000000000000ULL)

/*
*/
#define MSR_SGX_DEBUG_MODE 0x00000503

/*
*/
#define N_MSR_SGX_DEBUG_MODE_NPK_REQUEST_OFFSET 0
#define S_MSR_SGX_DEBUG_MODE_NPK_REQUEST_WIDTH 1
#define B_MSR_SGX_DEBUG_MODE_NPK_REQUEST_MASK BIT0

/*
*/
#define N_MSR_SGX_DEBUG_MODE_DEBUG_UNLOCK_MODE_OFFSET 1
#define S_MSR_SGX_DEBUG_MODE_DEBUG_UNLOCK_MODE_WIDTH 1
#define B_MSR_SGX_DEBUG_MODE_DEBUG_UNLOCK_MODE_MASK BIT1

/*
*/
#define MSR_RTIT_CTL 0x00000570

/*
*/
#define N_MSR_RTIT_CTL_TRACE_EN_OFFSET 0
#define S_MSR_RTIT_CTL_TRACE_EN_WIDTH 1
#define B_MSR_RTIT_CTL_TRACE_EN_MASK BIT0

/*
*/
#define N_MSR_RTIT_CTL_CYC_EN_OFFSET 1
#define S_MSR_RTIT_CTL_CYC_EN_WIDTH 1
#define B_MSR_RTIT_CTL_CYC_EN_MASK BIT1

#define N_MSR_RTIT_CTL_OS_OFFSET 2
#define S_MSR_RTIT_CTL_OS_WIDTH 1
#define B_MSR_RTIT_CTL_OS_MASK BIT2

#define N_MSR_RTIT_CTL_USR_OFFSET 3
#define S_MSR_RTIT_CTL_USR_WIDTH 1
#define B_MSR_RTIT_CTL_USR_MASK BIT3

/*
*/
#define N_MSR_RTIT_CTL_CR3_FILTER_EN_OFFSET 7
#define S_MSR_RTIT_CTL_CR3_FILTER_EN_WIDTH 1
#define B_MSR_RTIT_CTL_CR3_FILTER_EN_MASK BIT7

/*
*/
#define N_MSR_RTIT_CTL_TOPA_EN_OFFSET 8
#define S_MSR_RTIT_CTL_TOPA_EN_WIDTH 1
#define B_MSR_RTIT_CTL_TOPA_EN_MASK BIT8

/*
*/
#define N_MSR_RTIT_CTL_MTC_EN_OFFSET 9
#define S_MSR_RTIT_CTL_MTC_EN_WIDTH 1
#define B_MSR_RTIT_CTL_MTC_EN_MASK BIT9

/*
*/
#define N_MSR_RTIT_CTL_TSC_EN_OFFSET 10
#define S_MSR_RTIT_CTL_TSC_EN_WIDTH 1
#define B_MSR_RTIT_CTL_TSC_EN_MASK BIT10

/*
*/
#define N_MSR_RTIT_CTL_DISABLE_RET_COMP_OFFSET 11
#define S_MSR_RTIT_CTL_DISABLE_RET_COMP_WIDTH 1
#define B_MSR_RTIT_CTL_DISABLE_RET_COMP_MASK BIT11

#define N_MSR_RTIT_CTL_BRANCH_EN_OFFSET 13
#define S_MSR_RTIT_CTL_BRANCH_EN_WIDTH 1
#define B_MSR_RTIT_CTL_BRANCH_EN_MASK BIT13

#define N_MSR_RTIT_CTL_MTC_FREQ_OFFSET 14
#define S_MSR_RTIT_CTL_MTC_FREQ_WIDTH 4
#define B_MSR_RTIT_CTL_MTC_FREQ_MASK (0x000000000003C000)

#define N_MSR_RTIT_CTL_CYC_THRESH_OFFSET 19
#define S_MSR_RTIT_CTL_CYC_THRESH_WIDTH 4
#define B_MSR_RTIT_CTL_CYC_THRESH_MASK (0x0000000000780000)

#define N_MSR_RTIT_CTL_PSB_FREQ_OFFSET 24
#define S_MSR_RTIT_CTL_PSB_FREQ_WIDTH 4
#define B_MSR_RTIT_CTL_PSB_FREQ_MASK (0x000000000F000000)

#define N_MSR_RTIT_CTL_ADDR0_CFG_OFFSET 32
#define S_MSR_RTIT_CTL_ADDR0_CFG_WIDTH 4
#define B_MSR_RTIT_CTL_ADDR0_CFG_MASK (0x0000000F00000000ULL)

#define N_MSR_RTIT_CTL_ADDR1_CFG_OFFSET 36
#define S_MSR_RTIT_CTL_ADDR1_CFG_WIDTH 4
#define B_MSR_RTIT_CTL_ADDR1_CFG_MASK (0x000000F000000000ULL)

/*
*/
#define N_MSR_RTIT_CTL_INJECT_PSB_PMI_ON_ENABLE_OFFSET 56
#define S_MSR_RTIT_CTL_INJECT_PSB_PMI_ON_ENABLE_WIDTH 1
#define B_MSR_RTIT_CTL_INJECT_PSB_PMI_ON_ENABLE_MASK BIT56

/*
*/
#define MSR_PL3_CONTROL 0x00000615

/*
*/
#define N_MSR_PL3_CONTROL_POWER_LIMIT_OFFSET 0
#define S_MSR_PL3_CONTROL_POWER_LIMIT_WIDTH 15
#define B_MSR_PL3_CONTROL_POWER_LIMIT_MASK (0x00007FFF)

/*
*/
#define N_MSR_PL3_CONTROL_ENABLE_OFFSET 15
#define S_MSR_PL3_CONTROL_ENABLE_WIDTH 1
#define B_MSR_PL3_CONTROL_ENABLE_MASK BIT15

/*
*/
#define N_MSR_PL3_CONTROL_RESERVED_OFFSET 16
#define S_MSR_PL3_CONTROL_RESERVED_WIDTH 1
#define B_MSR_PL3_CONTROL_RESERVED_MASK BIT16

/*
*/
#define N_MSR_PL3_CONTROL_TIMEWINDOW_OFFSET 17
#define S_MSR_PL3_CONTROL_TIMEWINDOW_WIDTH 7
#define B_MSR_PL3_CONTROL_TIMEWINDOW_MASK (0x00FE0000)

/*
*/
#define N_MSR_PL3_CONTROL_DUTYCYLE_OFFSET 24
#define S_MSR_PL3_CONTROL_DUTYCYLE_WIDTH 7
#define B_MSR_PL3_CONTROL_DUTYCYLE_MASK (0x7F000000)

/*
*/
#define N_MSR_PL3_CONTROL_LOCK_OFFSET 31
#define S_MSR_PL3_CONTROL_LOCK_WIDTH 1
#define B_MSR_PL3_CONTROL_LOCK_MASK BIT31

#define MSR_FAST_UNCORE_MSRS_CAPABILITY 0x0000065F

/*
*/
#define N_MSR_FAST_UNCORE_MSRS_CAPABILITY_MSRS_CAPABILITY_OFFSET 0
#define S_MSR_FAST_UNCORE_MSRS_CAPABILITY_MSRS_CAPABILITY_WIDTH 4
#define B_MSR_FAST_UNCORE_MSRS_CAPABILITY_MSRS_CAPABILITY_MASK (0x0000000F)

/*
*/
#define MSR_SMRAM_SMBASE 0x00000C20

/*
*/
#define N_MSR_SMRAM_SMBASE_SMBASE_OFFSET 0
#define S_MSR_SMRAM_SMBASE_SMBASE_WIDTH 32
#define B_MSR_SMRAM_SMBASE_SMBASE_MASK (0x00000000FFFFFFFF)

/*
*/
#define MSR_SPCL_CHIPSET_USAGE 0x000001FE

/*
*/
#define N_MSR_SPCL_CHIPSET_USAGE_DATA_OFFSET 0
#define S_MSR_SPCL_CHIPSET_USAGE_DATA_WIDTH 32
#define B_MSR_SPCL_CHIPSET_USAGE_DATA_MASK (0xFFFFFFFF)

#endif
