
/** @file
  Pcucommon.h


  <b>Conventions</b>
  - Definitions beginning with "MSR_" are MSRs
  - Definitions beginning with "R_" are registers
  - Definitions beginning with "B_" are bits within registers
  - Definitions beginning with "V_" are meaningful values of bits within the registers
  - Definitions beginning with "S_" are register sizes
  - Definitions beginning with "N_" are the bit position

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _PCUCOMMON_h
#define _PCUCOMMON_h

/*
*/
#define MSR_PPIN 0x0000004F

/*
*/
#define N_MSR_PPIN_DATA_OFFSET 0
#define S_MSR_PPIN_DATA_WIDTH 64
#define B_MSR_PPIN_DATA_MASK (0xFFFFFFFFFFFFFFFFULL)

/*
*/
#define MSR_PLATFORM_INFO 0x000000CE

/*
*/
#define N_MSR_PLATFORM_INFO_RSVD_7_0_OFFSET 0
#define S_MSR_PLATFORM_INFO_RSVD_7_0_WIDTH 8
#define B_MSR_PLATFORM_INFO_RSVD_7_0_MASK (0x00000000000000FF)

/*
*/
#define N_MSR_PLATFORM_INFO_MAX_NON_TURBO_LIM_RATIO_OFFSET 8
#define S_MSR_PLATFORM_INFO_MAX_NON_TURBO_LIM_RATIO_WIDTH 8
#define B_MSR_PLATFORM_INFO_MAX_NON_TURBO_LIM_RATIO_MASK (0x000000000000FF00)

/*
*/
#define N_MSR_PLATFORM_INFO_SMM_SAVE_CAP_OFFSET 16
#define S_MSR_PLATFORM_INFO_SMM_SAVE_CAP_WIDTH 1
#define B_MSR_PLATFORM_INFO_SMM_SAVE_CAP_MASK BIT16

/*
*/
#define N_MSR_PLATFORM_INFO_RSVD_22_17_OFFSET 17
#define S_MSR_PLATFORM_INFO_RSVD_22_17_WIDTH 6
#define B_MSR_PLATFORM_INFO_RSVD_22_17_MASK (0x00000000007E0000)

/*
*/
#define N_MSR_PLATFORM_INFO_PPIN_CAP_OFFSET 23
#define S_MSR_PLATFORM_INFO_PPIN_CAP_WIDTH 1
#define B_MSR_PLATFORM_INFO_PPIN_CAP_MASK BIT23

#define N_MSR_PLATFORM_INFO_OCVOLT_OVRD_AVAIL_OFFSET 24
#define S_MSR_PLATFORM_INFO_OCVOLT_OVRD_AVAIL_WIDTH 1
#define B_MSR_PLATFORM_INFO_OCVOLT_OVRD_AVAIL_MASK BIT24

/*
*/
#define N_MSR_PLATFORM_INFO_FIVR_RFI_TUNING_AVAIL_OFFSET 25
#define S_MSR_PLATFORM_INFO_FIVR_RFI_TUNING_AVAIL_WIDTH 1
#define B_MSR_PLATFORM_INFO_FIVR_RFI_TUNING_AVAIL_MASK BIT25

/*
*/
#define N_MSR_PLATFORM_INFO_SAMPLE_PART_OFFSET 27
#define S_MSR_PLATFORM_INFO_SAMPLE_PART_WIDTH 1
#define B_MSR_PLATFORM_INFO_SAMPLE_PART_MASK BIT27

#define N_MSR_PLATFORM_INFO_PRG_TURBO_RATIO_EN_OFFSET 28
#define S_MSR_PLATFORM_INFO_PRG_TURBO_RATIO_EN_WIDTH 1
#define B_MSR_PLATFORM_INFO_PRG_TURBO_RATIO_EN_MASK BIT28

#define N_MSR_PLATFORM_INFO_PRG_TDP_LIM_EN_OFFSET 29
#define S_MSR_PLATFORM_INFO_PRG_TDP_LIM_EN_WIDTH 1
#define B_MSR_PLATFORM_INFO_PRG_TDP_LIM_EN_MASK BIT29

#define N_MSR_PLATFORM_INFO_PRG_TJ_OFFSET_EN_OFFSET 30
#define S_MSR_PLATFORM_INFO_PRG_TJ_OFFSET_EN_WIDTH 1
#define B_MSR_PLATFORM_INFO_PRG_TJ_OFFSET_EN_MASK BIT30

#define N_MSR_PLATFORM_INFO_CPUID_FAULTING_EN_OFFSET 31
#define S_MSR_PLATFORM_INFO_CPUID_FAULTING_EN_WIDTH 1
#define B_MSR_PLATFORM_INFO_CPUID_FAULTING_EN_MASK BIT31

#define N_MSR_PLATFORM_INFO_LPM_SUPPORT_OFFSET 32
#define S_MSR_PLATFORM_INFO_LPM_SUPPORT_WIDTH 1
#define B_MSR_PLATFORM_INFO_LPM_SUPPORT_MASK BIT32

#define N_MSR_PLATFORM_INFO_CONFIG_TDP_LEVELS_OFFSET 33
#define S_MSR_PLATFORM_INFO_CONFIG_TDP_LEVELS_WIDTH 2
#define B_MSR_PLATFORM_INFO_CONFIG_TDP_LEVELS_MASK (BIT34 | BIT33)

#define N_MSR_PLATFORM_INFO_PFAT_ENABLE_OFFSET 35
#define S_MSR_PLATFORM_INFO_PFAT_ENABLE_WIDTH 1
#define B_MSR_PLATFORM_INFO_PFAT_ENABLE_MASK BIT35

#define N_MSR_PLATFORM_INFO_PEG2DMIDIS_EN_OFFSET 36
#define S_MSR_PLATFORM_INFO_PEG2DMIDIS_EN_WIDTH 1
#define B_MSR_PLATFORM_INFO_PEG2DMIDIS_EN_MASK BIT36

#define N_MSR_PLATFORM_INFO_TIMED_MWAIT_ENABLE_OFFSET 37
#define S_MSR_PLATFORM_INFO_TIMED_MWAIT_ENABLE_WIDTH 1
#define B_MSR_PLATFORM_INFO_TIMED_MWAIT_ENABLE_MASK BIT37

#define N_MSR_PLATFORM_INFO_ASA_EN_OFFSET 38
#define S_MSR_PLATFORM_INFO_ASA_EN_WIDTH 1
#define B_MSR_PLATFORM_INFO_ASA_EN_MASK BIT38

/*
*/
#define N_MSR_PLATFORM_INFO_RSVD_39_OFFSET 39
#define S_MSR_PLATFORM_INFO_RSVD_39_WIDTH 1
#define B_MSR_PLATFORM_INFO_RSVD_39_MASK BIT39

/*
*/
#define N_MSR_PLATFORM_INFO_MAX_EFFICIENCY_RATIO_OFFSET 40
#define S_MSR_PLATFORM_INFO_MAX_EFFICIENCY_RATIO_WIDTH 8
#define B_MSR_PLATFORM_INFO_MAX_EFFICIENCY_RATIO_MASK (0x0000FF0000000000ULL)

/*
*/
#define N_MSR_PLATFORM_INFO_MIN_OPERATING_RATIO_OFFSET 48
#define S_MSR_PLATFORM_INFO_MIN_OPERATING_RATIO_WIDTH 8
#define B_MSR_PLATFORM_INFO_MIN_OPERATING_RATIO_MASK (0x00FF000000000000ULL)

/*
*/
#define N_MSR_PLATFORM_INFO_PUSHPATCH_EN_OFFSET 56
#define S_MSR_PLATFORM_INFO_PUSHPATCH_EN_WIDTH 1
#define B_MSR_PLATFORM_INFO_PUSHPATCH_EN_MASK BIT56

/*
*/
#define N_MSR_PLATFORM_INFO_EDRAM_ENABLE_OFFSET 57
#define S_MSR_PLATFORM_INFO_EDRAM_ENABLE_WIDTH 1
#define B_MSR_PLATFORM_INFO_EDRAM_ENABLE_MASK BIT57

#define N_MSR_PLATFORM_INFO_SXP_2LM_ENABLE_OFFSET 58
#define S_MSR_PLATFORM_INFO_SXP_2LM_ENABLE_WIDTH 1
#define B_MSR_PLATFORM_INFO_SXP_2LM_ENABLE_MASK BIT58

/*
*/
#define N_MSR_PLATFORM_INFO_SMM_SUPOVR_STATE_LOCK_ENABLE_OFFSET 59
#define S_MSR_PLATFORM_INFO_SMM_SUPOVR_STATE_LOCK_ENABLE_WIDTH 1
#define B_MSR_PLATFORM_INFO_SMM_SUPOVR_STATE_LOCK_ENABLE_MASK BIT59

#define N_MSR_PLATFORM_INFO_TIO_ENABLE_OFFSET 60
#define S_MSR_PLATFORM_INFO_TIO_ENABLE_WIDTH 1
#define B_MSR_PLATFORM_INFO_TIO_ENABLE_MASK BIT60

/*
*/
#define MSR_FLEX_RATIO 0x00000194

#define N_MSR_FLEX_RATIO_OC_EXTRA_VOLTAGE_OFFSET 0
#define S_MSR_FLEX_RATIO_OC_EXTRA_VOLTAGE_WIDTH 8
#define B_MSR_FLEX_RATIO_OC_EXTRA_VOLTAGE_MASK (0x00000000000000FF)

/*
*/
#define N_MSR_FLEX_RATIO_FLEX_RATIO_OFFSET 8
#define S_MSR_FLEX_RATIO_FLEX_RATIO_WIDTH 8
#define B_MSR_FLEX_RATIO_FLEX_RATIO_MASK (0x000000000000FF00)

/*
*/
#define N_MSR_FLEX_RATIO_ENABLE_OFFSET 16
#define S_MSR_FLEX_RATIO_ENABLE_WIDTH 1
#define B_MSR_FLEX_RATIO_ENABLE_MASK BIT16

#define N_MSR_FLEX_RATIO_OC_BINS_OFFSET 17
#define S_MSR_FLEX_RATIO_OC_BINS_WIDTH 3
#define B_MSR_FLEX_RATIO_OC_BINS_MASK (0x00000000000E0000)

#define N_MSR_FLEX_RATIO_OC_LOCK_OFFSET 20
#define S_MSR_FLEX_RATIO_OC_LOCK_WIDTH 1
#define B_MSR_FLEX_RATIO_OC_LOCK_MASK BIT20

/*
*/
#define MSR_TEMPERATURE_TARGET 0x000001A2

/*
*/
#define N_MSR_TEMPERATURE_TARGET_TCC_OFFSET_TIME_WINDOW_OFFSET 0
#define S_MSR_TEMPERATURE_TARGET_TCC_OFFSET_TIME_WINDOW_WIDTH 7
#define B_MSR_TEMPERATURE_TARGET_TCC_OFFSET_TIME_WINDOW_MASK (0x0000007F)

/*
*/
#define N_MSR_TEMPERATURE_TARGET_TCC_OFFSET_CLAMPING_BIT_OFFSET 7
#define S_MSR_TEMPERATURE_TARGET_TCC_OFFSET_CLAMPING_BIT_WIDTH 1
#define B_MSR_TEMPERATURE_TARGET_TCC_OFFSET_CLAMPING_BIT_MASK BIT7

/*
*/
#define N_MSR_TEMPERATURE_TARGET_FAN_TEMP_TARGET_OFST_OFFSET 8
#define S_MSR_TEMPERATURE_TARGET_FAN_TEMP_TARGET_OFST_WIDTH 8
#define B_MSR_TEMPERATURE_TARGET_FAN_TEMP_TARGET_OFST_MASK (0x0000FF00)

#define N_MSR_TEMPERATURE_TARGET_REF_TEMP_OFFSET 16
#define S_MSR_TEMPERATURE_TARGET_REF_TEMP_WIDTH 8
#define B_MSR_TEMPERATURE_TARGET_REF_TEMP_MASK (0x00FF0000)

#define N_MSR_TEMPERATURE_TARGET_TJ_MAX_TCC_OFFSET_OFFSET 24
#define S_MSR_TEMPERATURE_TARGET_TJ_MAX_TCC_OFFSET_WIDTH 6
#define B_MSR_TEMPERATURE_TARGET_TJ_MAX_TCC_OFFSET_MASK (0x3F000000)

/*
*/
#define N_MSR_TEMPERATURE_TARGET_LOCKED_OFFSET 31
#define S_MSR_TEMPERATURE_TARGET_LOCKED_WIDTH 1
#define B_MSR_TEMPERATURE_TARGET_LOCKED_MASK BIT31

/*
*/
#define MSR_TURBO_RATIO_LIMIT 0x000001AD

/*
*/
#define N_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_1_CORE_OFFSET 0
#define S_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_1_CORE_WIDTH 8
#define B_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_1_CORE_MASK (0x00000000000000FF)

/*
*/
#define N_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_2_CORES_OFFSET 8
#define S_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_2_CORES_WIDTH 8
#define B_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_2_CORES_MASK (0x000000000000FF00)

/*
*/
#define N_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_3_CORES_OFFSET 16
#define S_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_3_CORES_WIDTH 8
#define B_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_3_CORES_MASK (0x0000000000FF0000)

/*
*/
#define N_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_4_CORES_OFFSET 24
#define S_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_4_CORES_WIDTH 8
#define B_MSR_TURBO_RATIO_LIMIT_MAX_TURBO_4_CORES_MASK (0x00000000FF000000)

#define MSR_POWER_CTL1 0x000001FC

#define N_MSR_POWER_CTL1_ENABLE_BIDIR_PROCHOT_OFFSET 0
#define S_MSR_POWER_CTL1_ENABLE_BIDIR_PROCHOT_WIDTH 1
#define B_MSR_POWER_CTL1_ENABLE_BIDIR_PROCHOT_MASK BIT0

#define N_MSR_POWER_CTL1_C1E_ENABLE_OFFSET 1
#define S_MSR_POWER_CTL1_C1E_ENABLE_WIDTH 1
#define B_MSR_POWER_CTL1_C1E_ENABLE_MASK BIT1

/*
*/
#define N_MSR_POWER_CTL1_SAPM_IMC_C2_POLICY_OFFSET 2
#define S_MSR_POWER_CTL1_SAPM_IMC_C2_POLICY_WIDTH 1
#define B_MSR_POWER_CTL1_SAPM_IMC_C2_POLICY_MASK BIT2

#define N_MSR_POWER_CTL1_FAST_BRK_SNP_EN_OFFSET 3
#define S_MSR_POWER_CTL1_FAST_BRK_SNP_EN_WIDTH 1
#define B_MSR_POWER_CTL1_FAST_BRK_SNP_EN_MASK BIT3

/*
*/
#define N_MSR_POWER_CTL1_FAST_BRK_INT_EN_OFFSET 4
#define S_MSR_POWER_CTL1_FAST_BRK_INT_EN_WIDTH 1
#define B_MSR_POWER_CTL1_FAST_BRK_INT_EN_MASK BIT4

/*
*/
#define N_MSR_POWER_CTL1_PHOLD_CST_PREVENTION_INIT_OFFSET 6
#define S_MSR_POWER_CTL1_PHOLD_CST_PREVENTION_INIT_WIDTH 11
#define B_MSR_POWER_CTL1_PHOLD_CST_PREVENTION_INIT_MASK (0x000000000001FFC0)

/*
*/
#define N_MSR_POWER_CTL1_PHOLD_SR_DISABLE_OFFSET 17
#define S_MSR_POWER_CTL1_PHOLD_SR_DISABLE_WIDTH 1
#define B_MSR_POWER_CTL1_PHOLD_SR_DISABLE_MASK BIT17

/*
*/
#define N_MSR_POWER_CTL1_PWR_PERF_PLTFRM_OVR_OFFSET 18
#define S_MSR_POWER_CTL1_PWR_PERF_PLTFRM_OVR_WIDTH 1
#define B_MSR_POWER_CTL1_PWR_PERF_PLTFRM_OVR_MASK BIT18

/*
*/
#define N_MSR_POWER_CTL1_EE_TURBO_DISABLE_OFFSET 19
#define S_MSR_POWER_CTL1_EE_TURBO_DISABLE_WIDTH 1
#define B_MSR_POWER_CTL1_EE_TURBO_DISABLE_MASK BIT19

/*
*/
#define N_MSR_POWER_CTL1_RTH_DISABLE_OFFSET 20
#define S_MSR_POWER_CTL1_RTH_DISABLE_WIDTH 1
#define B_MSR_POWER_CTL1_RTH_DISABLE_MASK BIT20

/*
*/
#define N_MSR_POWER_CTL1_DIS_PROCHOT_OUT_OFFSET 21
#define S_MSR_POWER_CTL1_DIS_PROCHOT_OUT_WIDTH 1
#define B_MSR_POWER_CTL1_DIS_PROCHOT_OUT_MASK BIT21

/*
*/
#define N_MSR_POWER_CTL1_PROCHOT_RESPONSE_OFFSET 22
#define S_MSR_POWER_CTL1_PROCHOT_RESPONSE_WIDTH 1
#define B_MSR_POWER_CTL1_PROCHOT_RESPONSE_MASK BIT22

/*
*/
#define N_MSR_POWER_CTL1_PROCHOT_LOCK_OFFSET 23
#define S_MSR_POWER_CTL1_PROCHOT_LOCK_WIDTH 1
#define B_MSR_POWER_CTL1_PROCHOT_LOCK_MASK BIT23

/*
*/
#define N_MSR_POWER_CTL1_VR_THERM_ALERT_DISABLE_OFFSET 24
#define S_MSR_POWER_CTL1_VR_THERM_ALERT_DISABLE_WIDTH 1
#define B_MSR_POWER_CTL1_VR_THERM_ALERT_DISABLE_MASK BIT24

/*
*/
#define N_MSR_POWER_CTL1_DISABLE_RING_EE_OFFSET 25
#define S_MSR_POWER_CTL1_DISABLE_RING_EE_WIDTH 1
#define B_MSR_POWER_CTL1_DISABLE_RING_EE_MASK BIT25

/*
*/
#define N_MSR_POWER_CTL1_DISABLE_SA_OPTIMIZATION_OFFSET 26
#define S_MSR_POWER_CTL1_DISABLE_SA_OPTIMIZATION_WIDTH 1
#define B_MSR_POWER_CTL1_DISABLE_SA_OPTIMIZATION_MASK BIT26

/*
*/
#define N_MSR_POWER_CTL1_DISABLE_OOK_OFFSET 27
#define S_MSR_POWER_CTL1_DISABLE_OOK_WIDTH 1
#define B_MSR_POWER_CTL1_DISABLE_OOK_MASK BIT27

/*
*/
#define N_MSR_POWER_CTL1_DISABLE_AUTONOMOUS_OFFSET 28
#define S_MSR_POWER_CTL1_DISABLE_AUTONOMOUS_WIDTH 1
#define B_MSR_POWER_CTL1_DISABLE_AUTONOMOUS_MASK BIT28

/*
*/
#define N_MSR_POWER_CTL1_CSTATE_PREWAKE_DISABLE_OFFSET 30
#define S_MSR_POWER_CTL1_CSTATE_PREWAKE_DISABLE_WIDTH 1
#define B_MSR_POWER_CTL1_CSTATE_PREWAKE_DISABLE_MASK BIT30

/*
*/
#define N_MSR_POWER_CTL1_THERM_RSVD_EN_OFFSET 31
#define S_MSR_POWER_CTL1_THERM_RSVD_EN_WIDTH 1
#define B_MSR_POWER_CTL1_THERM_RSVD_EN_MASK BIT31

/*
*/
#define N_MSR_POWER_CTL1_PWR_PERF_TUNING_DISABLE_SAPM_CTRL_OFFSET 32
#define S_MSR_POWER_CTL1_PWR_PERF_TUNING_DISABLE_SAPM_CTRL_WIDTH 1
#define B_MSR_POWER_CTL1_PWR_PERF_TUNING_DISABLE_SAPM_CTRL_MASK BIT32

/*
*/
#define N_MSR_POWER_CTL1_PWR_PERF_TUNING_ENABLE_DYN_SWITCHING_OFFSET 33
#define S_MSR_POWER_CTL1_PWR_PERF_TUNING_ENABLE_DYN_SWITCHING_WIDTH 1
#define B_MSR_POWER_CTL1_PWR_PERF_TUNING_ENABLE_DYN_SWITCHING_MASK BIT33

/*
*/
#define N_MSR_POWER_CTL1_PWR_PERF_TUNING_CFG_MODE_OFFSET 34
#define S_MSR_POWER_CTL1_PWR_PERF_TUNING_CFG_MODE_WIDTH 1
#define B_MSR_POWER_CTL1_PWR_PERF_TUNING_CFG_MODE_MASK BIT34

/*
*/
#define N_MSR_POWER_CTL1_LTR_IIO_DISABLE_OFFSET 35
#define S_MSR_POWER_CTL1_LTR_IIO_DISABLE_WIDTH 1
#define B_MSR_POWER_CTL1_LTR_IIO_DISABLE_MASK BIT35

/*
*/
#define N_MSR_POWER_CTL1_PCH_NEG_DISABLE_OFFSET 36
#define S_MSR_POWER_CTL1_PCH_NEG_DISABLE_WIDTH 1
#define B_MSR_POWER_CTL1_PCH_NEG_DISABLE_MASK BIT36

/*
*/
#define MSR_VR_CURRENT_CONFIG 0x00000601

/*
*/
#define N_MSR_VR_CURRENT_CONFIG_CURRENT_LIMIT_OFFSET 0
#define S_MSR_VR_CURRENT_CONFIG_CURRENT_LIMIT_WIDTH 13
#define B_MSR_VR_CURRENT_CONFIG_CURRENT_LIMIT_MASK (0x0000000000001FFF)

/*
*/
#define N_MSR_VR_CURRENT_CONFIG_LOCK_OFFSET 31
#define S_MSR_VR_CURRENT_CONFIG_LOCK_WIDTH 1
#define B_MSR_VR_CURRENT_CONFIG_LOCK_MASK BIT31

/*
*/
#define N_MSR_VR_CURRENT_CONFIG_PSI1_THRESHOLD_OFFSET 32
#define S_MSR_VR_CURRENT_CONFIG_PSI1_THRESHOLD_WIDTH 10
#define B_MSR_VR_CURRENT_CONFIG_PSI1_THRESHOLD_MASK (0x000003FF00000000ULL)

/*
*/
#define N_MSR_VR_CURRENT_CONFIG_PSI2_THRESHOLD_OFFSET 42
#define S_MSR_VR_CURRENT_CONFIG_PSI2_THRESHOLD_WIDTH 10
#define B_MSR_VR_CURRENT_CONFIG_PSI2_THRESHOLD_MASK (0x000FFC0000000000ULL)

/*
*/
#define N_MSR_VR_CURRENT_CONFIG_PSI3_THRESHOLD_OFFSET 52
#define S_MSR_VR_CURRENT_CONFIG_PSI3_THRESHOLD_WIDTH 10
#define B_MSR_VR_CURRENT_CONFIG_PSI3_THRESHOLD_MASK (0x3FF0000000000000ULL)

/*
*/
#define N_MSR_VR_CURRENT_CONFIG_PS4_ENABLE_OFFSET 62
#define S_MSR_VR_CURRENT_CONFIG_PS4_ENABLE_WIDTH 1
#define B_MSR_VR_CURRENT_CONFIG_PS4_ENABLE_MASK BIT62

/*
*/
#define N_MSR_VR_CURRENT_CONFIG_RESERVED_OFFSET 63
#define S_MSR_VR_CURRENT_CONFIG_RESERVED_WIDTH 1
#define B_MSR_VR_CURRENT_CONFIG_RESERVED_MASK BIT63

/*
*/
#define MSR_PACKAGE_POWER_SKU_UNIT 0x00000606

#define N_MSR_PACKAGE_POWER_SKU_UNIT_PWR_UNIT_OFFSET 0
#define S_MSR_PACKAGE_POWER_SKU_UNIT_PWR_UNIT_WIDTH 4
#define B_MSR_PACKAGE_POWER_SKU_UNIT_PWR_UNIT_MASK (0x0000000F)

#define N_MSR_PACKAGE_POWER_SKU_UNIT_ENERGY_UNIT_OFFSET 8
#define S_MSR_PACKAGE_POWER_SKU_UNIT_ENERGY_UNIT_WIDTH 5
#define B_MSR_PACKAGE_POWER_SKU_UNIT_ENERGY_UNIT_MASK (0x00001F00)

#define N_MSR_PACKAGE_POWER_SKU_UNIT_TIME_UNIT_OFFSET 16
#define S_MSR_PACKAGE_POWER_SKU_UNIT_TIME_UNIT_WIDTH 4
#define B_MSR_PACKAGE_POWER_SKU_UNIT_TIME_UNIT_MASK (0x000F0000)

/*
*/
#define MSR_C_STATE_LATENCY_CONTROL_1 0x0000060B

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_1_VALUE_OFFSET 0
#define S_MSR_C_STATE_LATENCY_CONTROL_1_VALUE_WIDTH 10
#define B_MSR_C_STATE_LATENCY_CONTROL_1_VALUE_MASK (0x000003FF)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_1_MULTIPLIER_OFFSET 10
#define S_MSR_C_STATE_LATENCY_CONTROL_1_MULTIPLIER_WIDTH 3
#define B_MSR_C_STATE_LATENCY_CONTROL_1_MULTIPLIER_MASK (0x00001C00)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_1_VALID_OFFSET 15
#define S_MSR_C_STATE_LATENCY_CONTROL_1_VALID_WIDTH 1
#define B_MSR_C_STATE_LATENCY_CONTROL_1_VALID_MASK BIT15

/*
*/
#define MSR_C_STATE_LATENCY_CONTROL_2 0x0000060C

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_2_VALUE_OFFSET 0
#define S_MSR_C_STATE_LATENCY_CONTROL_2_VALUE_WIDTH 10
#define B_MSR_C_STATE_LATENCY_CONTROL_2_VALUE_MASK (0x000003FF)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_2_MULTIPLIER_OFFSET 10
#define S_MSR_C_STATE_LATENCY_CONTROL_2_MULTIPLIER_WIDTH 3
#define B_MSR_C_STATE_LATENCY_CONTROL_2_MULTIPLIER_MASK (0x00001C00)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_2_VALID_OFFSET 15
#define S_MSR_C_STATE_LATENCY_CONTROL_2_VALID_WIDTH 1
#define B_MSR_C_STATE_LATENCY_CONTROL_2_VALID_MASK BIT15

/*
*/
#define MSR_PACKAGE_POWER_LIMIT 0x00000610

/*
*/
#define N_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_1_OFFSET 0
#define S_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_1_WIDTH 15
#define B_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_1_MASK (0x0000000000007FFF)

/*
*/
#define N_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_1_EN_OFFSET 15
#define S_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_1_EN_WIDTH 1
#define B_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_1_EN_MASK BIT15

#define N_MSR_PACKAGE_POWER_LIMIT_PKG_CLMP_LIM_1_OFFSET 16
#define S_MSR_PACKAGE_POWER_LIMIT_PKG_CLMP_LIM_1_WIDTH 1
#define B_MSR_PACKAGE_POWER_LIMIT_PKG_CLMP_LIM_1_MASK BIT16

#define N_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_1_TIME_OFFSET 17
#define S_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_1_TIME_WIDTH 7
#define B_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_1_TIME_MASK (0x0000000000FE0000)

#define N_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_2_OFFSET 32
#define S_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_2_WIDTH 15
#define B_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_2_MASK (0x00007FFF00000000ULL)

#define N_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_2_EN_OFFSET 47
#define S_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_2_EN_WIDTH 1
#define B_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_2_EN_MASK BIT47

#define N_MSR_PACKAGE_POWER_LIMIT_PKG_CLMP_LIM_2_OFFSET 48
#define S_MSR_PACKAGE_POWER_LIMIT_PKG_CLMP_LIM_2_WIDTH 1
#define B_MSR_PACKAGE_POWER_LIMIT_PKG_CLMP_LIM_2_MASK BIT48

#define N_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_2_TIME_OFFSET 49
#define S_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_2_TIME_WIDTH 7
#define B_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_2_TIME_MASK (0x00FE000000000000ULL)

#define N_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_LOCK_OFFSET 63
#define S_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_LOCK_WIDTH 1
#define B_MSR_PACKAGE_POWER_LIMIT_PKG_PWR_LIM_LOCK_MASK BIT63

#define MSR_PACKAGE_POWER_SKU 0x00000614

/*
*/
#define N_MSR_PACKAGE_POWER_SKU_PKG_TDP_OFFSET 0
#define S_MSR_PACKAGE_POWER_SKU_PKG_TDP_WIDTH 15
#define B_MSR_PACKAGE_POWER_SKU_PKG_TDP_MASK (0x0000000000007FFF)

#define N_MSR_PACKAGE_POWER_SKU_PKG_MIN_PWR_OFFSET 16
#define S_MSR_PACKAGE_POWER_SKU_PKG_MIN_PWR_WIDTH 15
#define B_MSR_PACKAGE_POWER_SKU_PKG_MIN_PWR_MASK (0x000000007FFF0000)

#define N_MSR_PACKAGE_POWER_SKU_PKG_MAX_PWR_OFFSET 32
#define S_MSR_PACKAGE_POWER_SKU_PKG_MAX_PWR_WIDTH 15
#define B_MSR_PACKAGE_POWER_SKU_PKG_MAX_PWR_MASK (0x00007FFF00000000ULL)

#define N_MSR_PACKAGE_POWER_SKU_PKG_MAX_WIN_OFFSET 48
#define S_MSR_PACKAGE_POWER_SKU_PKG_MAX_WIN_WIDTH 7
#define B_MSR_PACKAGE_POWER_SKU_PKG_MAX_WIN_MASK (0x007F000000000000ULL)

#define MSR_DDR_RAPL_LIMIT 0x00000618

/*
*/
#define N_MSR_DDR_RAPL_LIMIT_LIMIT1_POWER_OFFSET 0
#define S_MSR_DDR_RAPL_LIMIT_LIMIT1_POWER_WIDTH 15
#define B_MSR_DDR_RAPL_LIMIT_LIMIT1_POWER_MASK (0x0000000000007FFF)

/*
*/
#define N_MSR_DDR_RAPL_LIMIT_LIMIT1_ENABLE_OFFSET 15
#define S_MSR_DDR_RAPL_LIMIT_LIMIT1_ENABLE_WIDTH 1
#define B_MSR_DDR_RAPL_LIMIT_LIMIT1_ENABLE_MASK BIT15

/*
*/
#define N_MSR_DDR_RAPL_LIMIT_LIMIT1_TIME_WINDOW_Y_OFFSET 17
#define S_MSR_DDR_RAPL_LIMIT_LIMIT1_TIME_WINDOW_Y_WIDTH 5
#define B_MSR_DDR_RAPL_LIMIT_LIMIT1_TIME_WINDOW_Y_MASK (0x00000000003E0000)

/*
*/
#define N_MSR_DDR_RAPL_LIMIT_LIMIT1_TIME_WINDOW_X_OFFSET 22
#define S_MSR_DDR_RAPL_LIMIT_LIMIT1_TIME_WINDOW_X_WIDTH 2
#define B_MSR_DDR_RAPL_LIMIT_LIMIT1_TIME_WINDOW_X_MASK (BIT23 | BIT22)

/*
*/
#define N_MSR_DDR_RAPL_LIMIT_LIMIT2_POWER_OFFSET 32
#define S_MSR_DDR_RAPL_LIMIT_LIMIT2_POWER_WIDTH 15
#define B_MSR_DDR_RAPL_LIMIT_LIMIT2_POWER_MASK (0x00007FFF00000000ULL)

/*
*/
#define N_MSR_DDR_RAPL_LIMIT_LIMIT2_ENABLE_OFFSET 47
#define S_MSR_DDR_RAPL_LIMIT_LIMIT2_ENABLE_WIDTH 1
#define B_MSR_DDR_RAPL_LIMIT_LIMIT2_ENABLE_MASK BIT47

/*
*/
#define N_MSR_DDR_RAPL_LIMIT_LIMIT2_TIME_WINDOW_Y_OFFSET 49
#define S_MSR_DDR_RAPL_LIMIT_LIMIT2_TIME_WINDOW_Y_WIDTH 5
#define B_MSR_DDR_RAPL_LIMIT_LIMIT2_TIME_WINDOW_Y_MASK (0x003E000000000000ULL)

/*
*/
#define N_MSR_DDR_RAPL_LIMIT_LIMIT2_TIME_WINDOW_X_OFFSET 54
#define S_MSR_DDR_RAPL_LIMIT_LIMIT2_TIME_WINDOW_X_WIDTH 2
#define B_MSR_DDR_RAPL_LIMIT_LIMIT2_TIME_WINDOW_X_MASK (BIT55 | BIT54)

/*
*/
#define N_MSR_DDR_RAPL_LIMIT_LOCKED_OFFSET 63
#define S_MSR_DDR_RAPL_LIMIT_LOCKED_WIDTH 1
#define B_MSR_DDR_RAPL_LIMIT_LOCKED_MASK BIT63

/*
*/
#define MSR_UNCORE_RATIO_LIMIT 0x00000620

#define N_MSR_UNCORE_RATIO_LIMIT_MAX_CLR_RATIO_OFFSET 0
#define S_MSR_UNCORE_RATIO_LIMIT_MAX_CLR_RATIO_WIDTH 7
#define B_MSR_UNCORE_RATIO_LIMIT_MAX_CLR_RATIO_MASK (0x0000007F)

#define N_MSR_UNCORE_RATIO_LIMIT_MIN_CLR_RATIO_OFFSET 8
#define S_MSR_UNCORE_RATIO_LIMIT_MIN_CLR_RATIO_WIDTH 7
#define B_MSR_UNCORE_RATIO_LIMIT_MIN_CLR_RATIO_MASK (0x00007F00)

/*
*/
#define MSR_C_STATE_LATENCY_CONTROL_3 0x00000633

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_3_VALUE_OFFSET 0
#define S_MSR_C_STATE_LATENCY_CONTROL_3_VALUE_WIDTH 10
#define B_MSR_C_STATE_LATENCY_CONTROL_3_VALUE_MASK (0x000003FF)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_3_MULTIPLIER_OFFSET 10
#define S_MSR_C_STATE_LATENCY_CONTROL_3_MULTIPLIER_WIDTH 3
#define B_MSR_C_STATE_LATENCY_CONTROL_3_MULTIPLIER_MASK (0x00001C00)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_3_VALID_OFFSET 15
#define S_MSR_C_STATE_LATENCY_CONTROL_3_VALID_WIDTH 1
#define B_MSR_C_STATE_LATENCY_CONTROL_3_VALID_MASK BIT15

/*
*/
#define MSR_C_STATE_LATENCY_CONTROL_4 0x00000634

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_4_VALUE_OFFSET 0
#define S_MSR_C_STATE_LATENCY_CONTROL_4_VALUE_WIDTH 10
#define B_MSR_C_STATE_LATENCY_CONTROL_4_VALUE_MASK (0x000003FF)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_4_MULTIPLIER_OFFSET 10
#define S_MSR_C_STATE_LATENCY_CONTROL_4_MULTIPLIER_WIDTH 3
#define B_MSR_C_STATE_LATENCY_CONTROL_4_MULTIPLIER_MASK (0x00001C00)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_4_VALID_OFFSET 15
#define S_MSR_C_STATE_LATENCY_CONTROL_4_VALID_WIDTH 1
#define B_MSR_C_STATE_LATENCY_CONTROL_4_VALID_MASK BIT15

/*
*/
#define MSR_C_STATE_LATENCY_CONTROL_5 0x00000635

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_5_VALUE_OFFSET 0
#define S_MSR_C_STATE_LATENCY_CONTROL_5_VALUE_WIDTH 10
#define B_MSR_C_STATE_LATENCY_CONTROL_5_VALUE_MASK (0x000003FF)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_5_MULTIPLIER_OFFSET 10
#define S_MSR_C_STATE_LATENCY_CONTROL_5_MULTIPLIER_WIDTH 3
#define B_MSR_C_STATE_LATENCY_CONTROL_5_MULTIPLIER_MASK (0x00001C00)

/*
*/
#define N_MSR_C_STATE_LATENCY_CONTROL_5_VALID_OFFSET 15
#define S_MSR_C_STATE_LATENCY_CONTROL_5_VALID_WIDTH 1
#define B_MSR_C_STATE_LATENCY_CONTROL_5_VALID_MASK BIT15

#define MSR_CONFIG_TDP_NOMINAL 0x00000648

/*
*/
#define N_MSR_CONFIG_TDP_NOMINAL_TDP_RATIO_OFFSET 0
#define S_MSR_CONFIG_TDP_NOMINAL_TDP_RATIO_WIDTH 8
#define B_MSR_CONFIG_TDP_NOMINAL_TDP_RATIO_MASK (0x000000FF)

/*
*/
#define MSR_CONFIG_TDP_LEVEL1 0x00000649

#define N_MSR_CONFIG_TDP_LEVEL1_PKG_TDP_OFFSET 0
#define S_MSR_CONFIG_TDP_LEVEL1_PKG_TDP_WIDTH 15
#define B_MSR_CONFIG_TDP_LEVEL1_PKG_TDP_MASK (0x0000000000007FFF)

/*
*/
#define N_MSR_CONFIG_TDP_LEVEL1_TDP_RATIO_OFFSET 16
#define S_MSR_CONFIG_TDP_LEVEL1_TDP_RATIO_WIDTH 8
#define B_MSR_CONFIG_TDP_LEVEL1_TDP_RATIO_MASK (0x0000000000FF0000)

#define N_MSR_CONFIG_TDP_LEVEL1_PKG_MAX_PWR_OFFSET 32
#define S_MSR_CONFIG_TDP_LEVEL1_PKG_MAX_PWR_WIDTH 15
#define B_MSR_CONFIG_TDP_LEVEL1_PKG_MAX_PWR_MASK (0x00007FFF00000000ULL)

#define N_MSR_CONFIG_TDP_LEVEL1_PKG_MIN_PWR_OFFSET 48
#define S_MSR_CONFIG_TDP_LEVEL1_PKG_MIN_PWR_WIDTH 15
#define B_MSR_CONFIG_TDP_LEVEL1_PKG_MIN_PWR_MASK (0x7FFF000000000000ULL)

/*
*/
#define MSR_CONFIG_TDP_LEVEL2 0x0000064A

#define N_MSR_CONFIG_TDP_LEVEL2_PKG_TDP_OFFSET 0
#define S_MSR_CONFIG_TDP_LEVEL2_PKG_TDP_WIDTH 15
#define B_MSR_CONFIG_TDP_LEVEL2_PKG_TDP_MASK (0x0000000000007FFF)

/*
*/
#define N_MSR_CONFIG_TDP_LEVEL2_TDP_RATIO_OFFSET 16
#define S_MSR_CONFIG_TDP_LEVEL2_TDP_RATIO_WIDTH 8
#define B_MSR_CONFIG_TDP_LEVEL2_TDP_RATIO_MASK (0x0000000000FF0000)

#define N_MSR_CONFIG_TDP_LEVEL2_PKG_MAX_PWR_OFFSET 32
#define S_MSR_CONFIG_TDP_LEVEL2_PKG_MAX_PWR_WIDTH 15
#define B_MSR_CONFIG_TDP_LEVEL2_PKG_MAX_PWR_MASK (0x00007FFF00000000ULL)

#define N_MSR_CONFIG_TDP_LEVEL2_PKG_MIN_PWR_OFFSET 48
#define S_MSR_CONFIG_TDP_LEVEL2_PKG_MIN_PWR_WIDTH 15
#define B_MSR_CONFIG_TDP_LEVEL2_PKG_MIN_PWR_MASK (0x7FFF000000000000ULL)

/*
*/
#define MSR_CONFIG_TDP_CONTROL 0x0000064B

#define N_MSR_CONFIG_TDP_CONTROL_TDP_LEVEL_OFFSET 0
#define S_MSR_CONFIG_TDP_CONTROL_TDP_LEVEL_WIDTH 2
#define B_MSR_CONFIG_TDP_CONTROL_TDP_LEVEL_MASK (BIT1 | BIT0)

#define N_MSR_CONFIG_TDP_CONTROL_CONFIG_TDP_LOCK_OFFSET 31
#define S_MSR_CONFIG_TDP_CONTROL_CONFIG_TDP_LOCK_WIDTH 1
#define B_MSR_CONFIG_TDP_CONTROL_CONFIG_TDP_LOCK_MASK BIT31

/*
*/
#define MSR_TURBO_ACTIVATION_RATIO 0x0000064C

#define N_MSR_TURBO_ACTIVATION_RATIO_MAX_NON_TURBO_RATIO_OFFSET 0
#define S_MSR_TURBO_ACTIVATION_RATIO_MAX_NON_TURBO_RATIO_WIDTH 8
#define B_MSR_TURBO_ACTIVATION_RATIO_MAX_NON_TURBO_RATIO_MASK (0x000000FF)

#define N_MSR_TURBO_ACTIVATION_RATIO_TURBO_ACTIVATION_RATIO_LOCK_OFFSET 31
#define S_MSR_TURBO_ACTIVATION_RATIO_TURBO_ACTIVATION_RATIO_LOCK_WIDTH 1
#define B_MSR_TURBO_ACTIVATION_RATIO_TURBO_ACTIVATION_RATIO_LOCK_MASK BIT31

/*
*/
#define MSR_THREAD_INFO 0x00000654

/*
*/
#define N_MSR_THREAD_INFO_PROCESS_ID_OFFSET 0
#define S_MSR_THREAD_INFO_PROCESS_ID_WIDTH 20
#define B_MSR_THREAD_INFO_PROCESS_ID_MASK (0x00000000000FFFFF)

/*
*/
#define N_MSR_THREAD_INFO_THREAD_PRIORITY_OFFSET 20
#define S_MSR_THREAD_INFO_THREAD_PRIORITY_WIDTH 4
#define B_MSR_THREAD_INFO_THREAD_PRIORITY_MASK (0x0000000000F00000)

/*
*/
#define N_MSR_THREAD_INFO_THREAD_PROCESS_TYPE_OFFSET 24
#define S_MSR_THREAD_INFO_THREAD_PROCESS_TYPE_WIDTH 8
#define B_MSR_THREAD_INFO_THREAD_PROCESS_TYPE_MASK (0x00000000FF000000)

/*
*/
#define N_MSR_THREAD_INFO_SW_THREAD_ID_OFFSET 32
#define S_MSR_THREAD_INFO_SW_THREAD_ID_WIDTH 20
#define B_MSR_THREAD_INFO_SW_THREAD_ID_MASK (0x000FFFFF00000000ULL)

/*
*/
#define N_MSR_THREAD_INFO_SPARE_OFFSET 52
#define S_MSR_THREAD_INFO_SPARE_WIDTH 12
#define B_MSR_THREAD_INFO_SPARE_MASK (0xFFF0000000000000ULL)

/*
*/
#define MSR_PLATFORM_POWER_LIMIT 0x0000065C

/*
*/
#define N_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_1_OFFSET 0
#define S_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_1_WIDTH 15
#define B_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_1_MASK (0x0000000000007FFF)

/*
*/
#define N_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_1_EN_OFFSET 15
#define S_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_1_EN_WIDTH 1
#define B_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_1_EN_MASK BIT15

/*
*/
#define N_MSR_PLATFORM_POWER_LIMIT_CRITICAL_POWER_CLAMP_1_OFFSET 16
#define S_MSR_PLATFORM_POWER_LIMIT_CRITICAL_POWER_CLAMP_1_WIDTH 1
#define B_MSR_PLATFORM_POWER_LIMIT_CRITICAL_POWER_CLAMP_1_MASK BIT16

/*
*/
#define N_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_1_TIME_OFFSET 17
#define S_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_1_TIME_WIDTH 7
#define B_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_1_TIME_MASK (0x0000000000FE0000)

/*
*/
#define N_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_2_OFFSET 32
#define S_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_2_WIDTH 15
#define B_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_2_MASK (0x00007FFF00000000ULL)

/*
*/
#define N_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_2_EN_OFFSET 47
#define S_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_2_EN_WIDTH 1
#define B_MSR_PLATFORM_POWER_LIMIT_POWER_LIMIT_2_EN_MASK BIT47

/*
*/
#define N_MSR_PLATFORM_POWER_LIMIT_CRITICAL_POWER_CLAMP_2_OFFSET 48
#define S_MSR_PLATFORM_POWER_LIMIT_CRITICAL_POWER_CLAMP_2_WIDTH 1
#define B_MSR_PLATFORM_POWER_LIMIT_CRITICAL_POWER_CLAMP_2_MASK BIT48

/*
*/
#define N_MSR_PLATFORM_POWER_LIMIT_LOCK_OFFSET 63
#define S_MSR_PLATFORM_POWER_LIMIT_LOCK_WIDTH 1
#define B_MSR_PLATFORM_POWER_LIMIT_LOCK_MASK BIT63

/*
*/
#define MSR_IA32_PM_ENABLE 0x00000770

/*
*/
#define N_MSR_IA32_PM_ENABLE_HWP_ENABLE_OFFSET 0
#define S_MSR_IA32_PM_ENABLE_HWP_ENABLE_WIDTH 1
#define B_MSR_IA32_PM_ENABLE_HWP_ENABLE_MASK BIT0

/*
*/
#define MSR_IA32_HWP_CAPABILITIES 0x00000771

/*
*/
#define N_MSR_IA32_HWP_CAPABILITIES_HIGHEST_PERFORMANCE_OFFSET 0
#define S_MSR_IA32_HWP_CAPABILITIES_HIGHEST_PERFORMANCE_WIDTH 8
#define B_MSR_IA32_HWP_CAPABILITIES_HIGHEST_PERFORMANCE_MASK (0x000000FF)

#define N_MSR_IA32_HWP_CAPABILITIES_GUARANTEED_PERFORMANCE_OFFSET 8
#define S_MSR_IA32_HWP_CAPABILITIES_GUARANTEED_PERFORMANCE_WIDTH 8
#define B_MSR_IA32_HWP_CAPABILITIES_GUARANTEED_PERFORMANCE_MASK (0x0000FF00)

/*
*/
#define N_MSR_IA32_HWP_CAPABILITIES_MOST_EFFICIENT_PERFORMANCE_OFFSET 16
#define S_MSR_IA32_HWP_CAPABILITIES_MOST_EFFICIENT_PERFORMANCE_WIDTH 8
#define B_MSR_IA32_HWP_CAPABILITIES_MOST_EFFICIENT_PERFORMANCE_MASK (0x00FF0000)

/*
*/
#define N_MSR_IA32_HWP_CAPABILITIES_LOWEST_LINEAR_PERFORMANCE_OFFSET 24
#define S_MSR_IA32_HWP_CAPABILITIES_LOWEST_LINEAR_PERFORMANCE_WIDTH 8
#define B_MSR_IA32_HWP_CAPABILITIES_LOWEST_LINEAR_PERFORMANCE_MASK (0xFF000000)

/*
*/
#define MSR_IA32_HWP_INTERRUPT 0x00000773

/*
*/
#define N_MSR_IA32_HWP_INTERRUPT_CHANGE_TO_GUARANTEED_OFFSET 0
#define S_MSR_IA32_HWP_INTERRUPT_CHANGE_TO_GUARANTEED_WIDTH 1
#define B_MSR_IA32_HWP_INTERRUPT_CHANGE_TO_GUARANTEED_MASK BIT0

/*
*/
#define N_MSR_IA32_HWP_INTERRUPT_EXCURSION_TO_MINIMUM_OFFSET 1
#define S_MSR_IA32_HWP_INTERRUPT_EXCURSION_TO_MINIMUM_WIDTH 1
#define B_MSR_IA32_HWP_INTERRUPT_EXCURSION_TO_MINIMUM_MASK BIT1

/*
*/
#define N_MSR_IA32_HWP_INTERRUPT_CHANGE_TO_HIGHEST_OFFSET 2
#define S_MSR_IA32_HWP_INTERRUPT_CHANGE_TO_HIGHEST_WIDTH 1
#define B_MSR_IA32_HWP_INTERRUPT_CHANGE_TO_HIGHEST_MASK BIT2

/*
*/
#define N_MSR_IA32_HWP_INTERRUPT_PECI_OVERRIDE_OFFSET 3
#define S_MSR_IA32_HWP_INTERRUPT_PECI_OVERRIDE_WIDTH 1
#define B_MSR_IA32_HWP_INTERRUPT_PECI_OVERRIDE_MASK BIT3

/*
*/
#define MSR_IA32_HWP_STATUS 0x00000777

/*
*/
#define N_MSR_IA32_HWP_STATUS_CHANGE_TO_GUARANTEED_OFFSET 0
#define S_MSR_IA32_HWP_STATUS_CHANGE_TO_GUARANTEED_WIDTH 1
#define B_MSR_IA32_HWP_STATUS_CHANGE_TO_GUARANTEED_MASK BIT0

/*
*/
#define N_MSR_IA32_HWP_STATUS_EXCURSION_TO_MINIMUM_OFFSET 2
#define S_MSR_IA32_HWP_STATUS_EXCURSION_TO_MINIMUM_WIDTH 1
#define B_MSR_IA32_HWP_STATUS_EXCURSION_TO_MINIMUM_MASK BIT2

/*
*/
#define N_MSR_IA32_HWP_STATUS_HIGHEST_CHANGE_OFFSET 3
#define S_MSR_IA32_HWP_STATUS_HIGHEST_CHANGE_WIDTH 1
#define B_MSR_IA32_HWP_STATUS_HIGHEST_CHANGE_MASK BIT3

/*
*/
#define N_MSR_IA32_HWP_STATUS_PECI_OVERRIDE_ENTER_OFFSET 4
#define S_MSR_IA32_HWP_STATUS_PECI_OVERRIDE_ENTER_WIDTH 1
#define B_MSR_IA32_HWP_STATUS_PECI_OVERRIDE_ENTER_MASK BIT4

/*
*/
#define N_MSR_IA32_HWP_STATUS_PECI_OVERRIDE_EXIT_OFFSET 5
#define S_MSR_IA32_HWP_STATUS_PECI_OVERRIDE_EXIT_WIDTH 1
#define B_MSR_IA32_HWP_STATUS_PECI_OVERRIDE_EXIT_MASK BIT5

#endif
