/** @file
  Processes ASF messages.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2010 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include <Base.h>
#include <Uefi.h>
#include <Library/DebugLib.h>
#include <Pi/PiStatusCode.h>
#include <IndustryStandardAsf.h>
#include <IntelAsfExtensions.h>
#include <Library/AsfMsgLib.h>

GLOBAL_REMOVE_IF_UNREFERENCED ASF_DATA_HUB_MAP      mAsfProgressDataHubMap[] = {
  {
    AsfMessageBiosPresent,
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_PC_POWER_ON_INIT
  },
  {
    AsfMessageMemInit,
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_HP_PC_RAM_INIT
  },
  {
    AsfMessageMemInitDone,
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_PC_INIT_END
  },
  {
    AsfMessageCacheInit,
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_PC_CACHE_INIT
  },
  {
    AsfMessageSmbusInit,
    EFI_IO_BUS_SMBUS | EFI_P_PC_ENABLE
  },
  {
    AsfMessageOSWakeVector,
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_DXE_RT_PC_S3
  },
  {
    AsfMessageMotherBoardInit,
    EFI_COMPUTING_UNIT_CHIPSET | EFI_CU_PC_INIT_BEGIN
  },
  {
    AsfMessageBspInit,
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_PC_BSP_SELECT
  },
#ifndef ASF_PEI
  {
    AsfMessageHddInit,
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_PC_ENABLE
  },
  {
    AsfMessageApInit,
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | EFI_CU_HP_PC_AP_INIT
  },
  {
    AsfMessageUserAuthentication,
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_PC_AUTHENTICATE_BEGIN
  },
  {
    AsfMessageUserInitSetup,
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_PC_USER_SETUP
  },
  {
    AsfMessageUsbResourceConfig,
    EFI_IO_BUS_USB | EFI_P_PC_ENABLE
  },
  {
    AsfMessagePciResourceConfig,
    EFI_IO_BUS_PCI | EFI_IOB_PCI_BUS_ENUM
  },
  {
    AsfMessageOptionRomInit,
    EFI_SOFTWARE_DXE_BS_DRIVER | EFI_SW_DXE_BS_PC_LEGACY_OPROM_INIT
  },
  {
    AsfMessageVideoInit,
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_PC_ENABLE
  },
  {
    AsfMessageKbcInit,
    EFI_PERIPHERAL_KEYBOARD | EFI_P_PC_ENABLE
  },
  {
    AsfMessageEmControllerInit,
    PERIPHERAL_EMBEDDED_CONTROLLER | EFI_P_PC_INIT
  },
  {
    AsfMessageDockAttached,
    PERIPHERAL_DOCK | EFI_P_PC_INIT
  },
  {
    AsfMessageEnableDock,
    PERIPHERAL_DOCK | EFI_P_PC_ENABLE
  },
  {
    AsfMessageDockEject,
    PERIPHERAL_DOCK | EFI_P_PC_RESET
  },
  {
    AsfMessageDisableDock,
    PERIPHERAL_DOCK | EFI_P_PC_DISABLE
  },
  {
    AsfMessageFdcInit,
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_PC_ENABLE
  },
  {
    AsfMessageKeyboardTest,
    EFI_PERIPHERAL_KEYBOARD | EFI_P_KEYBOARD_PC_SELF_TEST
  },
  {
    AsfMessageMouseTest,
    EFI_PERIPHERAL_MOUSE | EFI_P_MOUSE_PC_SELF_TEST
  },
  {
    AsfMessageAmtBxDone,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_OPROM_DONE
  },
  {
    AsfMessageBatteryPresenceDetected,
    PERIPHERAL_BATTERY | EFI_P_PC_PRESENCE_DETECT
  },
#endif
};

GLOBAL_REMOVE_IF_UNREFERENCED ASF_DATA_HUB_MAP      mAsfErrorDataHubMap[] = {
  {
    AsfMessageNoMemory,
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_NONE_DETECTED
  },
  {
    AsfMessageMemoryFailure,
    EFI_COMPUTING_UNIT_MEMORY | EFI_CU_MEMORY_EC_NONE_USEFUL
  },
  {
    AsfMessageBoardFailure,
    EFI_COMPUTING_UNIT_CHIPSET | EFI_CU_EC_NOT_CONFIGURED
  },
  {
    AsfMessageFirmwareCorruption,
    EFI_SOFTWARE_PEI_MODULE | EFI_SW_PEI_CORE_EC_DXE_CORRUPT
  },
  {
    AsfMessageChassisIntrusion,
    EFI_COMPUTING_UNIT_CHIPSET | CU_CHIPSET_PC_INTRUDER_DETECT
  },
#ifndef ASF_PEI
  {
    AsfMessageHddFailure,
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_NOT_DETECTED
  },
  {
    AsfMessageFdcFailure,
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_CONTROLLER_ERROR
  },
  {
    AsfMessageHdcFailure,
    EFI_PERIPHERAL_FIXED_MEDIA | EFI_P_EC_CONTROLLER_ERROR
  },
  {
    AsfMessageKbdFailure,
    EFI_PERIPHERAL_KEYBOARD | EFI_P_EC_NOT_DETECTED
  },
  {
    AsfMessageNoFdd,
    EFI_PERIPHERAL_REMOVABLE_MEDIA | EFI_P_EC_NOT_DETECTED
  },
  {
    AsfMessageVideoControllerFailure,
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_CONTROLLER_ERROR
  },
  {
    AsfMessageNoVideo,
    EFI_PERIPHERAL_LOCAL_CONSOLE | EFI_P_EC_NOT_DETECTED
  },
  {
    AsfMessageCpuVidMismatch,
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | CU_HP_EC_VID_MISMATCH
  },
  {
    AsfMessageCpuSpeedMatchingFailure,
    EFI_COMPUTING_UNIT_HOST_PROCESSOR | CU_HP_EC_SPEED_MATCHING_FAILURE
  },
  {
    AsfMessageNoBootMedia,
    EFI_SOFTWARE_DXE_BS_DRIVER | SW_DXE_BS_EC_NO_BOOT_MEDIA
  },
  {
    AsfMessageUserAuthenticationInvalid,
    EFI_SOFTWARE_DXE_BS_DRIVER | SW_DXE_BS_EC_AUTHENTICATE_USER_INVALID
  },
  {
    AsfMessageHddAuthenticationInvalid,
    EFI_SOFTWARE_DXE_BS_DRIVER | SW_DXE_BS_EC_AUTHENTICATE_HDD_INVALID,
  },
  {
    AsfMessageTemperatureGenericCritical,
    PERIPHERAL_TEMPERATURE | P_TEMERATURE_EC_GENERIC_CRITICAL
  },
  {
    AsfMessageTemperatureOverCritical,
    PERIPHERAL_TEMPERATURE | P_TEMERATURE_EC_OVER_CRITICAL
  },
  {
    AsfMessageTemperatureUnderCritical,
    PERIPHERAL_TEMPERATURE | P_TEMERATURE_EC_UNDER_CRITICAL
  },
  {
    AsfMessageVoltageGenericCritical,
    PERIPHERAL_VOLTAGE | P_VOLTAGE_EC_GENERIC_CRITICAL
  },
  {
    AsfMessageVoltageOverCritical,
    PERIPHERAL_VOLTAGE | P_VOLTAGE_EC_OVER_CRITICAL
  },
  {
    AsfMessageVoltageUnderCritical,
    PERIPHERAL_VOLTAGE | P_VOLTAGE_EC_UNDER_CRITICAL
  },
  {
    AsfMessageFanGenericCritical,
    PERIPHERAL_FAN | P_FAN_EC_GENERIC_CRITICAL
  },
  {
    AsfMessageFanPredictiveFailure,
    PERIPHERAL_FAN | P_FAN_EC_PREDICTIVE_FAILURE
  },
  {
    AsfMessageFanLowSpeedCritical,
    PERIPHERAL_FAN | P_FAN_EC_LOW_SPEED_CRITICAL
  },
  {
    AsfMessageBatteryLowCritical,
    PERIPHERAL_BATTERY | P_BATTERY_EC_LOW_CRITICAL
  },
  {
    AsfMessageTemperatureGenericWarning,
    PERIPHERAL_TEMPERATURE | P_TEMERATURE_PC_GENERIC_WARNING
  },
  {
    AsfMessageTemperatureOverWarning,
    PERIPHERAL_TEMPERATURE | P_TEMERATURE_PC_OVER_WARNING
  },
  {
    AsfMessageTemperatureUnderWarning,
    PERIPHERAL_TEMPERATURE | P_TEMERATURE_PC_UNDER_WARNING
  },
  {
    AsfMessageFanLowSpeedWarning,
    PERIPHERAL_FAN | P_FAN_PC_LOW_SPEED_WARNING
  },
  {
    AsfMessageBatteryLowWarning,
    PERIPHERAL_BATTERY | P_BATTERY_PC_LOW_WARNING
  },
  {
    AsfMessagePowerFailure,
    PERIPHERAL_POWER_SUPPLY | P_BATTERY_PC_LOW_WARNING
  },
  {
    AsfMessageAmtBxNotStarted,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_OPROM_NOT_STARTED
  },
  {
    AsfMessageAmtBxSleepS4ReportedNotTaken,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_SLEEP_S4_NOT_TAKEN
  },
  {
    AsfMessageAmtBxSleepS5ReportedNotTaken,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_SLEEP_S5_NOT_TAKEN
  },
  {
    AsfMessageAmtBxSleepUnspecifiedReportedNotTaken,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_SLEEP_UNSPECD_NOT_TAKEN
  },
  {
    AsfMessageAmtBxErrActionIntF,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_ERROR_ACTION_INTF
  },
  {
    AsfMessageAmtBxErrActionInv,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_ERROR_ACTION_INV
  },
  {
    AsfMessageAmtBxErrActionSetup,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_ERROR_ACTION_SETUP
  },
  {
    AsfMessageAmtBxErrActionFailure,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_ERROR_ACTION_FAIL
  },
  {
    AsfMessageAmtBxErrActionUnspecified,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_ERROR_ACTION_UNSPECD
  },
  {
    AsfMessageAmtBxOtherUnspecified,
    EFI_SOFTWARE_UNSPECIFIED | SW_DXE_AMTBX_OTHER_UNSPECD
  },
#endif
};

GLOBAL_REMOVE_IF_UNREFERENCED ASF_FRAMEWORK_MESSAGE mAsfFrameworkMessage[] = {
  {
    AsfMessageBiosPresent,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_ENTITY_PRESENCE,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_BIOS,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_BOARD_INIT
    }
  },
  {
    AsfMessageMemInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_MEMORY,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_MEMORY_INIT
    }
  },
  {
    AsfMessageMemInitDone,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS | 0x80,  // Exit
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_MEMORY,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_MEMORY_INIT
    }
  },
  {
    AsfMessageCacheInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_PROCESSOR,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_CACHE_INIT
    }
  },
  {
    AsfMessageSmbusInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_SMBUS_INIT
    }
  },
  {
    AsfMessageOSWakeVector,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_UNSPECIFIED,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_WAKE_OS
    }
  },
  {
    AsfMessageMotherBoardInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_BOARD_INIT
    }
  },
  //
  // Error Event
  //
  {
    AsfMessageNoMemory,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_MEMORY,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_NO_MEMORY
    }
  },
  {
    AsfMessageMemoryFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_MEMORY,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_MEMORY_FAILURE
    }
  },
  {
    AsfMessageBoardFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_BOARD_FAILURE
    }
  },
  {
    AsfMessageFirmwareCorruption,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_ROM_CORRUPTED
    }
  },
  //
  // Chassis Intrusion
  //
  {
    AsfMessageChassisIntrusion,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_CHASSIS_INTRUSION,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_CHASSIS_INTRUSION_GENERIC,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
#ifndef ASF_PEI
  //
  // Progress Event
  //
  {
    AsfMessageHddInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_DISK,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_HDD_INIT
    }
  },
  {
    AsfMessageApInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_PROCESSOR,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_AP_INIT
    }
  },
  {
    AsfMessageUserAuthentication,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_BIOS,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_USER_AUTHENTICATION
    }
  },
  {
    AsfMessageUserInitSetup,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_BIOS,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_USER_SETUP
    }
  },
  {
    AsfMessageUsbResourceConfig,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_BIOS,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_USB_RESOURCE_CONFIG
    }
  },
  {
    AsfMessagePciResourceConfig,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_BIOS,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_PCI_RESOURCE_CONFIG
    }
  },
  {
    AsfMessageOptionRomInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_ADDIN_CARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_OPTION_ROM_INIT
    }
  },
  {
    AsfMessageVideoInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_VIDEO_INIT
    }
  },
  {
    AsfMessageKbcInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_KBC_INIT
    }
  },
  {
    AsfMessageEmControllerInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_EC_INIT
    }
  },
  {
    AsfMessageDockAttached,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_ATTACH_DOCK
    }
  },
  {
    AsfMessageEnableDock,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_ENABLE_DOCK
    }
  },
  {
    AsfMessageDockEject,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_EJECT_DOCK
    }
  },
  {
    AsfMessageDisableDock,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_DISABLE_DOCK
    }
  },
  {
    AsfMessageFdcInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_FDC_INIT
    }
  },
  {
    AsfMessageKeyboardTest,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_KBD_TEST
    }
  },
  {
    AsfMessageMouseTest,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_MOUSE_TEST
    }
  },
  {
    AsfMessageBspInit,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_PROCESSOR,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FP_EVENT_DATA1,
      ASF_FP_BSP_INIT
    }
  },
  //
  // Error Event
  //
  {
    AsfMessageHddFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_DISK,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_HDD_FAILURE
    }
  },
  {
    AsfMessageFdcFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_DISK,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_FDC_FAILURE
    }
  },
  {
    AsfMessageHdcFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_DISK,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_HDC_FAILURE
    }
  },
  {
    AsfMessageKbdFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_KBD_FAILURE
    }
  },
  {
    AsfMessageNoFdd,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_DISK,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_REMOVABLE_BOOT_MEDIA_NOT_FOUND
    }
  },
  {
    AsfMessageVideoControllerFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_DISK,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_VIDEO_CONTROLLER_FAILURE
    }
  },
  {
    AsfMessageNoVideo,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_VIDEO_DEVICE_NOT_FOUND
    }
  },
  {
    AsfMessageCpuVidMismatch,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_PROCESSOR,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_CPU_VOLTAGE_FAILURE
    }
  },
  {
    AsfMessageCpuSpeedMatchingFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_PROCESSOR,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_CPU_MISMATCH_FAILURE
    }
  },
  {
    AsfMessageUserAuthenticationInvalid,
    {
      ASF_MESSAGE_SUBCOMMAND_RETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SECURITY_VIOLATION,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SECURITY_VIOLATION_USER_PASSWORD,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_BIOS,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageHddAuthenticationInvalid,
    {
      ASF_MESSAGE_SUBCOMMAND_RETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SECURITY_VIOLATION,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SECURITY_VIOLATION_OTHER_PASSWORD,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_BIOS,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  //
  // Boot Error
  //
  {
    AsfMessageNoBootMedia,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_DISK,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_REMOVABLE_BOOT_MEDIA_NOT_FOUND
    }
  },
  {
    AsfMessageAmtBxDone,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_PROGRESS,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FP_AMTBX_INIT
    }
  },
  {
    AsfMessageAmtBxNotStarted,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  {
    AsfMessageAmtBxSleepS4ReportedNotTaken,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  {
    AsfMessageAmtBxSleepS5ReportedNotTaken,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  {
    AsfMessageAmtBxSleepUnspecifiedReportedNotTaken,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  {
    AsfMessageAmtBxErrActionIntF,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  {
    AsfMessageAmtBxErrActionInv,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  {
    AsfMessageAmtBxErrActionSetup,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  {
    AsfMessageAmtBxErrActionFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  {
    AsfMessageAmtBxErrActionUnspecified,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  {
    AsfMessageAmtBxOtherUnspecified,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_SYS_FW_ERR_PROG,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_SYS_FW_ERROR,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_INTEL_AMT,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
      ASF_FE_EVENT_DATA1,
      ASF_FE_AMTBX_FAILURE
    }
  },
  //
  // Temperature
  //
  {
    AsfMessageTemperatureGenericCritical,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_TEMPERATURE,
      ASF_EVENT_TYPE_SEVERITY_STATE,
      ASF_EVENT_OFFSET_SEVERITY_MORE_CRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageTemperatureGenericWarning,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_TEMPERATURE,
      ASF_EVENT_TYPE_SEVERITY_STATE,
      ASF_EVENT_OFFSET_SEVERITY_MORE_NONCRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageTemperatureOverCritical,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_TEMPERATURE,
      ASF_EVENT_TYPE_THRESHOLD_BASED,
      ASF_EVENT_OFFSET_THRESHOLD_UPPER_CRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageTemperatureOverWarning,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_TEMPERATURE,
      ASF_EVENT_TYPE_THRESHOLD_BASED,
      ASF_EVENT_OFFSET_THRESHOLD_UPPER_NONCRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageTemperatureUnderCritical,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_TEMPERATURE,
      ASF_EVENT_TYPE_THRESHOLD_BASED,
      ASF_EVENT_OFFSET_THRESHOLD_LOWER_CRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageTemperatureUnderWarning,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_TEMPERATURE,
      ASF_EVENT_TYPE_THRESHOLD_BASED,
      ASF_EVENT_OFFSET_THRESHOLD_LOWER_NONCRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  //
  // Voltage
  //
  {
    AsfMessageVoltageGenericCritical,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_VOLTAGE,
      ASF_EVENT_TYPE_SEVERITY_STATE,
      ASF_EVENT_OFFSET_SEVERITY_MORE_CRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageVoltageOverCritical,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_VOLTAGE,
      ASF_EVENT_TYPE_THRESHOLD_BASED,
      ASF_EVENT_OFFSET_THRESHOLD_UPPER_CRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageVoltageUnderCritical,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_VOLTAGE,
      ASF_EVENT_TYPE_THRESHOLD_BASED,
      ASF_EVENT_OFFSET_THRESHOLD_LOWER_CRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  //
  // Fan
  //
  {
    AsfMessageFanGenericCritical,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_FAN,
      ASF_EVENT_TYPE_SEVERITY_STATE,
      ASF_EVENT_OFFSET_SEVERITY_MORE_CRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageFanPredictiveFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_FAN,
      ASF_EVENT_TYPE_DISCRETE_EVENT_PREDICTIVE_FAIL,
      ASF_EVENT_OFFSET_DISCRETE_EVENT_PREDICTIVE_FAIL_ASSERT,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageFanLowSpeedCritical,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_FAN,
      ASF_EVENT_TYPE_THRESHOLD_BASED,
      ASF_EVENT_OFFSET_THRESHOLD_LOWER_CRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageFanLowSpeedWarning,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_FAN,
      ASF_EVENT_TYPE_THRESHOLD_BASED,
      ASF_EVENT_OFFSET_THRESHOLD_LOWER_NONCRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  //
  // Battery
  //
  {
    AsfMessageBatteryLowWarning,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_BATTERY,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_BATTERY_LOW_WARNING,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONCRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_POWER_SUPPLY,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageBatteryLowCritical,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_BATTERY,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_BATTERY_LOW_CRITICAL,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_CRITICAL,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_POWER_SUPPLY,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessageBatteryPresenceDetected,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_BATTERY,
      ASF_EVENT_TYPE_SENSOR_SPECIFIC,
      ASF_EVENT_OFFSET_BATTERY_PRESENCE_DETECTED,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_MONITOR,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_POWER_SUPPLY,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
  {
    AsfMessagePowerFailure,
    {
      ASF_MESSAGE_SUBCOMMAND_NORETRANSMIT,
      ASF_VERSION,
      ASF_EVENT_SENSOR_TYPE_POWER_SUPPLY,
      ASF_EVENT_TYPE_SEVERITY_STATE,
      ASF_EVENT_OFFSET_POWER_SUPPLY_FAILURE,
      ASF_EVENT_SOURCE_TYPE_ASF10,
      ASF_EVENT_SEVERITY_CODE_NONRECOVERABLE,
      ASF_SENSOR_DEVICE,
      ASF_SENSOR_NUMBER,
      ASF_ENTITY_SYSTEM_BOARD,
      ASF_ENTITY_INSTANCE_UNSPECIFIED,
    }
  },
#endif
};

UINTN AsfProgressDataHubMapSize = sizeof (mAsfProgressDataHubMap);
UINTN AsfErrorDataHubMapSize    = sizeof (mAsfErrorDataHubMap);
UINTN AsfFrameworkMessageSize   = sizeof (mAsfFrameworkMessage);