/** @file
  This file contains ICL specific GPIO information

@copyright
  INTEL CONFIDENTIAL
  Copyright 2016 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#include "MrcOemPlatform.h"
#include "PchAccess.h"
#include "GpioNativeLib.h"
#include "PchInfoLib.h"
#include "GpioPrivateLib.h"
#include "GpioPinsIclLp.h"
#include "GpioPinsIclN.h"

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_GROUP_INFO mPchLpGpioGroupInfo[] = {
  {PID_GPIOCOM0, R_ICL_PCH_LP_GPIO_PCR_GPP_A_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_A_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_A_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_A_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_A_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_A_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_GPP_A_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_A_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_A_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_A_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_A, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_A}, //ICL PCH-LP GPP_A
  {PID_GPIOCOM0, R_ICL_PCH_LP_GPIO_PCR_GPP_B_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_B_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_B_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_B_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_B_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_B_GPI_GPE_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_B_SMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_B_SMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_B_NMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_B_NMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_B_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_B_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_B_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_B_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_B, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_B}, //ICL PCH-LP GPP_B
  {PID_GPIOCOM4, R_ICL_PCH_LP_GPIO_PCR_GPP_C_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_C_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_C_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_C_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_C_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_C_GPI_GPE_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_C_SMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_C_SMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_C_NMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_C_NMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_C_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_C_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_C_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_C_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_C, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_C}, //ICL PCH-LP GPP_C
  {PID_GPIOCOM1, R_ICL_PCH_LP_GPIO_PCR_GPP_D_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_D_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_D_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_D_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_D_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_D_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_GPP_D_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_D_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_D_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_D_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_D, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_D}, //ICL PCH-LP GPP_D
  {PID_GPIOCOM4, R_ICL_PCH_LP_GPIO_PCR_GPP_E_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_E_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_E_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_E_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_E_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_E_GPI_GPE_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_E_SMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_E_SMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_E_NMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_E_NMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_E_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_E_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_E_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_E_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_E, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_E}, //ICL PCH-LP GPP_E
  {PID_GPIOCOM1, R_ICL_PCH_LP_GPIO_PCR_GPP_F_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_F_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_F_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_F_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_F_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_F_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_GPP_F_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_F_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_F_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_F_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_F, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_F}, //ICL PCH-LP GPP_F
  {PID_GPIOCOM0, R_ICL_PCH_LP_GPIO_PCR_GPP_G_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_G_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_G_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_G_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_G_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_G_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_GPP_G_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_G_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_G_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_G_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_G, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_G}, //ICL PCH-LP GPP_G
  {PID_GPIOCOM1, R_ICL_PCH_LP_GPIO_PCR_GPP_H_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_H_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_H_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_H_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_H_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_H_GPI_GPE_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_H_SMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_H_SMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_H_NMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_H_NMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_H_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_H_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_H_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_H_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_H, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_H}, //ICL PCH-LP GPP_H
  {PID_GPIOCOM5, R_ICL_PCH_LP_GPIO_PCR_GPP_R_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_R_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_R_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_R_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_R_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_R_GPI_GPE_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_R_SMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_R_SMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_R_NMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_R_NMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_R_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_R_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_R_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_R_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_R, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_R}, //ICL PCH-LP GPP_R
  {PID_GPIOCOM5, R_ICL_PCH_LP_GPIO_PCR_GPP_S_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_S_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_GPP_S_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_GPP_S_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_GPP_S_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_S_GPI_GPE_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_S_SMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_S_SMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_S_NMI_STS, R_ICL_PCH_LP_GPIO_PCR_GPP_S_NMI_EN, R_ICL_PCH_LP_GPIO_PCR_GPP_S_PADCFGLOCK,   R_ICL_PCH_LP_GPIO_PCR_GPP_S_PADCFGLOCKTX,   R_ICL_PCH_LP_GPIO_PCR_GPP_S_PADCFG_OFFSET, ICL_PCH_LP_GPIO_GPP_S_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPP_S, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPP_S}, //ICL PCH-LP GPP_S
  {PID_GPIOCOM2, R_ICL_PCH_LP_GPIO_PCR_GPD_PAD_OWN,   R_ICL_PCH_LP_GPIO_PCR_GPD_HOSTSW_OWN,   R_ICL_PCH_LP_GPIO_PCR_GPD_GPI_IS,   R_ICL_PCH_LP_GPIO_PCR_GPD_GPI_IE,   R_ICL_PCH_LP_GPIO_PCR_GPD_GPI_GPE_STS,   R_ICL_PCH_LP_GPIO_PCR_GPD_GPI_GPE_EN,   NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_GPD_PADCFGLOCK,     R_ICL_PCH_LP_GPIO_PCR_GPD_PADCFGLOCKTX,     R_ICL_PCH_LP_GPIO_PCR_GPD_PADCFG_OFFSET,   ICL_PCH_LP_GPIO_GPD_PAD_MAX,   V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_GPD,   V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_GPD},   //ICL PCH-LP GPD
  {PID_GPIOCOM1, R_ICL_PCH_LP_GPIO_PCR_VGPIO_PAD_OWN, R_ICL_PCH_LP_GPIO_PCR_VGPIO_HOSTSW_OWN, R_ICL_PCH_LP_GPIO_PCR_VGPIO_GPI_IS, R_ICL_PCH_LP_GPIO_PCR_VGPIO_GPI_IE, R_ICL_PCH_LP_GPIO_PCR_VGPIO_GPI_GPE_STS, R_ICL_PCH_LP_GPIO_PCR_VGPIO_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_VGPIO_0_PADCFGLOCK, R_ICL_PCH_LP_GPIO_PCR_VGPIO_0_PADCFGLOCKTX, R_ICL_PCH_LP_GPIO_PCR_VGPIO_PADCFG_OFFSET, ICL_PCH_LP_GPIO_VGPIO_PAD_MAX, V_ICL_PCH_LP_PMC_PWRM_GPIO_CFG_VGPIO, V_ICL_PCH_LP_GPIO_PCR_MISCCFG_GPE0_VGPIO}, //ICL PCH-LP vGPIO
  {PID_GPIOCOM5, R_ICL_PCH_LP_GPIO_PCR_SPI_PAD_OWN,   R_ICL_PCH_LP_GPIO_PCR_SPI_HOSTSW_OWN,   R_ICL_PCH_LP_GPIO_PCR_SPI_GPI_IS,   R_ICL_PCH_LP_GPIO_PCR_SPI_GPI_IE,   R_ICL_PCH_LP_GPIO_PCR_SPI_GPI_GPE_STS,   R_ICL_PCH_LP_GPIO_PCR_SPI_GPI_GPE_EN,   NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_SPI_PADCFGLOCK,     R_ICL_PCH_LP_GPIO_PCR_SPI_PADCFGLOCKTX,     R_ICL_PCH_LP_GPIO_PCR_SPI_PADCFG_OFFSET,   ICL_PCH_LP_GPIO_SPI_PAD_MAX,   NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}, //ICL PCH-LP SPI
  {PID_GPIOCOM3, R_ICL_PCH_LP_GPIO_PCR_CPU_PAD_OWN,   R_ICL_PCH_LP_GPIO_PCR_CPU_HOSTSW_OWN,   NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,                NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_CPU_PADCFGLOCK,     R_ICL_PCH_LP_GPIO_PCR_CPU_PADCFGLOCKTX,     R_ICL_PCH_LP_GPIO_PCR_CPU_PADCFG_OFFSET,   ICL_PCH_LP_GPIO_CPU_PAD_MAX,   NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}, //ICL PCH-LP CPU
  {PID_GPIOCOM4, R_ICL_PCH_LP_GPIO_PCR_JTAG_PAD_OWN,  R_ICL_PCH_LP_GPIO_PCR_JTAG_HOSTSW_OWN,  NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,                NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_JTAG_PADCFGLOCK,    R_ICL_PCH_LP_GPIO_PCR_JTAG_PADCFGLOCKTX,    R_ICL_PCH_LP_GPIO_PCR_JTAG_PADCFG_OFFSET,  ICL_PCH_LP_GPIO_JTAG_PAD_MAX,  NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}, //ICL PCH-LP JTAG
  {PID_GPIOCOM4, R_ICL_PCH_LP_GPIO_PCR_HVCMOS_PAD_OWN,R_ICL_PCH_LP_GPIO_PCR_HVCMOS_HOSTSW_OWN,R_ICL_PCH_LP_GPIO_PCR_HVCMOS_GPI_IS,R_ICL_PCH_LP_GPIO_PCR_HVCMOS_GPI_IE,R_ICL_PCH_LP_GPIO_PCR_HVCMOS_GPI_GPE_STS,R_ICL_PCH_LP_GPIO_PCR_HVCMOS_GPI_GPE_EN,NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,            NO_REGISTER_FOR_PROPERTY,           R_ICL_PCH_LP_GPIO_PCR_HVCMOS_PADCFGLOCK,  R_ICL_PCH_LP_GPIO_PCR_HVCMOS_PADCFGLOCKTX,  R_ICL_PCH_LP_GPIO_PCR_HVCMOS_PADCFG_OFFSET,ICL_PCH_LP_GPIO_HVCMOS_PAD_MAX,NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}  //ICL PCH-LP HVCMOS
};

GLOBAL_REMOVE_IF_UNREFERENCED GPIO_GROUP_INFO mPchNGpioGroupInfo[] = {
  {PID_GPIOCOM0, R_ICL_PCH_N_GPIO_PCR_GPP_A_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_A_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_A_GPI_IS, R_ICL_PCH_N_GPIO_PCR_GPP_A_GPI_IE, R_ICL_PCH_N_GPIO_PCR_GPP_A_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_GPP_A_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_GPP_A_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_GPP_A_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_GPP_A_PADCFG_OFFSET,  ICL_PCH_N_GPIO_GPP_A_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPP_A,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPP_A}, //ICL PCH-N GPP_A
  {PID_GPIOCOM0, R_ICL_PCH_N_GPIO_PCR_GPP_B_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_B_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_B_GPI_IS, R_ICL_PCH_N_GPIO_PCR_GPP_B_GPI_IE, R_ICL_PCH_N_GPIO_PCR_GPP_B_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_GPP_B_GPI_GPE_EN, R_ICL_PCH_N_GPIO_PCR_GPP_B_SMI_STS, R_ICL_PCH_N_GPIO_PCR_GPP_B_SMI_EN, R_ICL_PCH_N_GPIO_PCR_GPP_B_NMI_STS, R_ICL_PCH_N_GPIO_PCR_GPP_B_NMI_EN, R_ICL_PCH_N_GPIO_PCR_GPP_B_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_GPP_B_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_GPP_B_PADCFG_OFFSET,  ICL_PCH_N_GPIO_GPP_B_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPP_B,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPP_B}, //ICL PCH-N GPP_B
  {PID_GPIOCOM1, R_ICL_PCH_N_GPIO_PCR_GPP_C_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_C_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_C_GPI_IS, R_ICL_PCH_N_GPIO_PCR_GPP_C_GPI_IE, R_ICL_PCH_N_GPIO_PCR_GPP_C_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_GPP_C_GPI_GPE_EN, R_ICL_PCH_N_GPIO_PCR_GPP_C_SMI_STS, R_ICL_PCH_N_GPIO_PCR_GPP_C_SMI_EN, R_ICL_PCH_N_GPIO_PCR_GPP_C_NMI_STS, R_ICL_PCH_N_GPIO_PCR_GPP_C_NMI_EN, R_ICL_PCH_N_GPIO_PCR_GPP_C_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_GPP_C_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_GPP_C_PADCFG_OFFSET,  ICL_PCH_N_GPIO_GPP_C_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPP_C,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPP_C}, //ICL PCH-N GPP_C
  {PID_GPIOCOM1, R_ICL_PCH_N_GPIO_PCR_GPP_D_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_D_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_D_GPI_IS, R_ICL_PCH_N_GPIO_PCR_GPP_D_GPI_IE, R_ICL_PCH_N_GPIO_PCR_GPP_D_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_GPP_D_GPI_GPE_EN, R_ICL_PCH_N_GPIO_PCR_GPP_D_SMI_STS, R_ICL_PCH_N_GPIO_PCR_GPP_D_SMI_EN, R_ICL_PCH_N_GPIO_PCR_GPP_D_NMI_STS, R_ICL_PCH_N_GPIO_PCR_GPP_D_NMI_EN, R_ICL_PCH_N_GPIO_PCR_GPP_D_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_GPP_D_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_GPP_D_PADCFG_OFFSET,  ICL_PCH_N_GPIO_GPP_D_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPP_D,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPP_D}, //ICL PCH-N GPP_D
  {PID_GPIOCOM4, R_ICL_PCH_N_GPIO_PCR_GPP_E_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_E_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_E_GPI_IS, R_ICL_PCH_N_GPIO_PCR_GPP_E_GPI_IE, R_ICL_PCH_N_GPIO_PCR_GPP_E_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_GPP_E_GPI_GPE_EN, R_ICL_PCH_N_GPIO_PCR_GPP_E_SMI_STS, R_ICL_PCH_N_GPIO_PCR_GPP_E_SMI_EN, R_ICL_PCH_N_GPIO_PCR_GPP_E_NMI_STS, R_ICL_PCH_N_GPIO_PCR_GPP_E_NMI_EN, R_ICL_PCH_N_GPIO_PCR_GPP_E_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_GPP_E_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_GPP_E_PADCFG_OFFSET,  ICL_PCH_N_GPIO_GPP_E_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPP_E,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPP_E}, //ICL PCH-N GPP_E
  {PID_GPIOCOM5, R_ICL_PCH_N_GPIO_PCR_GPP_G_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_G_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_G_GPI_IS, R_ICL_PCH_N_GPIO_PCR_GPP_G_GPI_IE, R_ICL_PCH_N_GPIO_PCR_GPP_G_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_GPP_G_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_GPP_G_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_GPP_G_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_GPP_G_PADCFG_OFFSET,  ICL_PCH_N_GPIO_GPP_G_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPP_G,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPP_G}, //ICL PCH-N GPP_G
  {PID_GPIOCOM1, R_ICL_PCH_N_GPIO_PCR_GPP_H_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_H_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_H_GPI_IS, R_ICL_PCH_N_GPIO_PCR_GPP_H_GPI_IE, R_ICL_PCH_N_GPIO_PCR_GPP_H_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_GPP_H_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_GPP_H_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_GPP_H_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_GPP_H_PADCFG_OFFSET,  ICL_PCH_N_GPIO_GPP_H_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPP_H,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPP_H}, //ICL PCH-N GPP_H
  {PID_GPIOCOM0, R_ICL_PCH_N_GPIO_PCR_GPP_R_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_R_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_R_GPI_IS, R_ICL_PCH_N_GPIO_PCR_GPP_R_GPI_IE, R_ICL_PCH_N_GPIO_PCR_GPP_R_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_GPP_R_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_GPP_R_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_GPP_R_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_GPP_R_PADCFG_OFFSET,  ICL_PCH_N_GPIO_GPP_R_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPP_R,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPP_R}, //ICL PCH-N GPP_R
  {PID_GPIOCOM0, R_ICL_PCH_N_GPIO_PCR_GPP_S_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_S_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_GPP_S_GPI_IS, R_ICL_PCH_N_GPIO_PCR_GPP_S_GPI_IE, R_ICL_PCH_N_GPIO_PCR_GPP_S_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_GPP_S_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_GPP_S_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_GPP_S_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_GPP_S_PADCFG_OFFSET,  ICL_PCH_N_GPIO_GPP_S_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPP_S,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPP_S}, //ICL PCH-N GPP_S
  {PID_GPIOCOM2, R_ICL_PCH_N_GPIO_PCR_GPD_PAD_OWN,    R_ICL_PCH_N_GPIO_PCR_GPD_HOSTSW_OWN,    R_ICL_PCH_N_GPIO_PCR_GPD_GPI_IS,   R_ICL_PCH_N_GPIO_PCR_GPD_GPI_IE,   R_ICL_PCH_N_GPIO_PCR_GPD_GPI_GPE_STS,   R_ICL_PCH_N_GPIO_PCR_GPD_GPI_GPE_EN,   NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_GPD_PADCFGLOCK,     R_ICL_PCH_N_GPIO_PCR_GPD_PADCFGLOCKTX,     R_ICL_PCH_N_GPIO_PCR_GPD_PADCFG_OFFSET,    ICL_PCH_N_GPIO_GPD_PAD_MAX,    V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_GPD,    V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_GPD},   //ICL PCH-N GPD
  {PID_GPIOCOM1, R_ICL_PCH_N_GPIO_PCR_VGPIO_PAD_OWN,  R_ICL_PCH_N_GPIO_PCR_VGPIO_HOSTSW_OWN,  R_ICL_PCH_N_GPIO_PCR_VGPIO_GPI_IS, R_ICL_PCH_N_GPIO_PCR_VGPIO_GPI_IE, R_ICL_PCH_N_GPIO_PCR_VGPIO_GPI_GPE_STS, R_ICL_PCH_N_GPIO_PCR_VGPIO_GPI_GPE_EN, NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_VGPIO_PADCFGLOCK,   R_ICL_PCH_N_GPIO_PCR_VGPIO_PADCFGLOCKTX,   R_ICL_PCH_N_GPIO_PCR_VGPIO_PADCFG_OFFSET,  ICL_PCH_N_GPIO_VGPIO_PAD_MAX,  V_ICL_PCH_N_PMC_PWRM_GPIO_CFG_VGPIO,  V_ICL_PCH_N_GPIO_PCR_MISCCFG_GPE0_VGPIO}, //ICL PCH-N vGPIO
  {PID_GPIOCOM3, R_ICL_PCH_N_GPIO_PCR_VGPIO_3_PAD_OWN,R_ICL_PCH_N_GPIO_PCR_VGPIO_3_HOSTSW_OWN,NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_VGPIO_3_PADCFGLOCK, R_ICL_PCH_N_GPIO_PCR_VGPIO_3_PADCFGLOCKTX, R_ICL_PCH_N_GPIO_PCR_VGPIO_3_PADCFG_OFFSET,ICL_PCH_N_GPIO_VGPIO_3_PAD_MAX,NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}, //ICL PCH-N vGPIO_3
  {PID_GPIOCOM4, R_ICL_PCH_N_GPIO_PCR_VGPIO_4_PAD_OWN,R_ICL_PCH_N_GPIO_PCR_VGPIO_4_HOSTSW_OWN,NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_VGPIO_4_PADCFGLOCK, R_ICL_PCH_N_GPIO_PCR_VGPIO_4_PADCFGLOCKTX, R_ICL_PCH_N_GPIO_PCR_VGPIO_4_PADCFG_OFFSET,ICL_PCH_N_GPIO_VGPIO_4_PAD_MAX,NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}, //ICL PCH-N vGPIO_4
  {PID_GPIOCOM0, R_ICL_PCH_N_GPIO_PCR_SPI_PAD_OWN,    R_ICL_PCH_N_GPIO_PCR_SPI_HOSTSW_OWN,    R_ICL_PCH_N_GPIO_PCR_SPI_GPI_IS,   R_ICL_PCH_N_GPIO_PCR_SPI_GPI_IE,   R_ICL_PCH_N_GPIO_PCR_SPI_GPI_GPE_STS,   R_ICL_PCH_N_GPIO_PCR_SPI_GPI_GPE_EN,   NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_SPI_PADCFGLOCK,     R_ICL_PCH_N_GPIO_PCR_SPI_PADCFGLOCKTX,     R_ICL_PCH_N_GPIO_PCR_SPI_PADCFG_OFFSET,    ICL_PCH_N_GPIO_SPI_PAD_MAX,    NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}, //ICL PCH-N SPI
  {PID_GPIOCOM3, R_ICL_PCH_N_GPIO_PCR_CPU_PAD_OWN,    R_ICL_PCH_N_GPIO_PCR_CPU_HOSTSW_OWN,    NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_CPU_PADCFGLOCK,     R_ICL_PCH_N_GPIO_PCR_CPU_PADCFGLOCKTX,     R_ICL_PCH_N_GPIO_PCR_CPU_PADCFG_OFFSET,    ICL_PCH_N_GPIO_CPU_PAD_MAX,    NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}, //ICL PCH-N CPU
  {PID_GPIOCOM4, R_ICL_PCH_N_GPIO_PCR_JTAG_PAD_OWN,   R_ICL_PCH_N_GPIO_PCR_JTAG_HOSTSW_OWN,   NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_JTAG_PADCFGLOCK,    R_ICL_PCH_N_GPIO_PCR_JTAG_PADCFGLOCKTX,    R_ICL_PCH_N_GPIO_PCR_JTAG_PADCFG_OFFSET,   ICL_PCH_N_GPIO_JTAG_PAD_MAX,   NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}, //ICL PCH-N JTAG
  {PID_GPIOCOM4, R_ICL_PCH_N_GPIO_PCR_HVCMOS_PAD_OWN, R_ICL_PCH_N_GPIO_PCR_HVCMOS_HOSTSW_OWN, NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,               NO_REGISTER_FOR_PROPERTY,              NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          NO_REGISTER_FOR_PROPERTY,           NO_REGISTER_FOR_PROPERTY,          R_ICL_PCH_N_GPIO_PCR_HVCMOS_PADCFGLOCK,  R_ICL_PCH_N_GPIO_PCR_HVCMOS_PADCFGLOCKTX,  R_ICL_PCH_N_GPIO_PCR_HVCMOS_PADCFG_OFFSET, ICL_PCH_N_GPIO_HVCMOS_PAD_MAX, NO_REGISTER_FOR_PROPERTY,             NO_REGISTER_FOR_PROPERTY}  //ICL PCH-N HVCMOS
};

/**
  This procedure will retrieve address and length of GPIO info table

  @param[out]  GpioGroupInfoTableLength   Length of GPIO group table

  @retval Pointer to GPIO group table

**/
CONST GPIO_GROUP_INFO*
GpioGetGroupInfoTable (
  OUT UINT32              *GpioGroupInfoTableLength
  )
{
  if (IsPchLp ()) {
    *GpioGroupInfoTableLength = ARRAY_SIZE (mPchLpGpioGroupInfo);
    return mPchLpGpioGroupInfo;
  } else if (IsPchN ()) {
    *GpioGroupInfoTableLength = ARRAY_SIZE (mPchNGpioGroupInfo);
    return mPchNGpioGroupInfo;
  } else {
    //@todo: ICL-H not supported yet
    *GpioGroupInfoTableLength = 0;
    ASSERT (FALSE);
    return NULL;
  }
}

/**
  Get GPIO Chipset ID specific to PCH generation and series
**/
UINT32
GpioGetThisChipsetId (
  VOID
  )
{
  if (IsPchLp ()) {
    return GPIO_ICL_LP_CHIPSET_ID;
  } else if (IsPchN ()) {
    return GPIO_ICL_N_CHIPSET_ID;
  } else {
    return 0;
  }
}

/**
  This internal procedure will check if group is within DeepSleepWell.

  @param[in]  Group               GPIO Group

  @retval GroupWell               TRUE:  This is DSW Group
                                  FALSE: This is not DSW Group
**/
BOOLEAN
GpioIsDswGroup (
  IN  GPIO_GROUP         Group
  )
{
  if (Group == GPIO_ICL_LP_GROUP_GPD) {
    return TRUE;
  } else if (Group == GPIO_ICL_N_GROUP_GPD) {
    return TRUE;
  } else {
    return FALSE;
  }
}


/**
  This procedure will perform special handling of GPP_A_12.

  @param[in]  None

  @retval None
**/
VOID
GpioA12SpecialHandling (
  VOID
  )
{
  return;
}

/**
  This procedure will get IRQ field value to be programmed into register

  @param[in]  Irq                 Irq number
  @param[out] Data32And           Value to be AND'ed with MISCCFG reg
  @param[out] Data32Or            Value to be OR'ed with MISCCFG reg
**/
VOID
GpioGetIrqFieldValue (
  IN  UINT8          Irq,
  OUT UINT32         *Data32And,
  OUT UINT32         *Data32Or
  )
{
  *Data32And = (UINT32)~(B_ICL_PCH_GPIO_PCR_MISCCFG_IRQ_ROUTE);
  *Data32Or  = (UINT32)Irq << N_ICL_PCH_GPIO_PCR_MISCCFG_IRQ_ROUTE;
}

GLOBAL_REMOVE_IF_UNREFERENCED PCH_SBI_PID mGpioComSbiIds []=
{
  PID_GPIOCOM0, PID_GPIOCOM1, PID_GPIOCOM2, PID_GPIOCOM3, PID_GPIOCOM4, PID_GPIOCOM5
};

/**
  This function provides GPIO Community PortIDs

  @param[out] NativePinsTable                Table with GPIO COMMx SBI PortIDs

  @retval     Number of communities
**/
UINT32
GpioGetComSbiPortIds (
  OUT PCH_SBI_PID    **GpioComSbiIds
  )
{
  *GpioComSbiIds = mGpioComSbiIds;
  return ARRAY_SIZE (mGpioComSbiIds);
}
