/**@file

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/


//
// Definition for GPIO groups and pads
//
#ifndef _GPIO_ACPI_DEFINES_VER1_
#define _GPIO_ACPI_DEFINES_VER1_

#include "Pins/GpioPinsVer1Lp.h"
#include "Pins/GpioPinsVer1N.h"
#include "Pins/GpioPinsVer1H.h"

#define GPIO_VER1_LP_ACPI_HID   "INT3455"
#define GPIO_VER1_H_ACPI_HID    "INT3456"
#define GPIO_VER1_N_ACPI_HID    "INT34C3"
#define GPIO_VER1_1_N_ACPI_HID  "INT34C8"

#define GPIO_VER1_LP_DRIVER_GPP_G_00 0
#define GPIO_VER1_LP_DRIVER_GPP_G_01 1
#define GPIO_VER1_LP_DRIVER_GPP_G_02 2
#define GPIO_VER1_LP_DRIVER_GPP_G_03 3
#define GPIO_VER1_LP_DRIVER_GPP_G_04 4
#define GPIO_VER1_LP_DRIVER_GPP_G_05 5
#define GPIO_VER1_LP_DRIVER_GPP_G_06 6
#define GPIO_VER1_LP_DRIVER_GPP_G_07 7

#define GPIO_VER1_LP_DRIVER_GPP_B_00 32
#define GPIO_VER1_LP_DRIVER_GPP_B_01 33
#define GPIO_VER1_LP_DRIVER_GPP_B_02 34
#define GPIO_VER1_LP_DRIVER_GPP_B_03 35
#define GPIO_VER1_LP_DRIVER_GPP_B_04 36
#define GPIO_VER1_LP_DRIVER_GPP_B_05 37
#define GPIO_VER1_LP_DRIVER_GPP_B_06 38
#define GPIO_VER1_LP_DRIVER_GPP_B_07 39
#define GPIO_VER1_LP_DRIVER_GPP_B_08 40
#define GPIO_VER1_LP_DRIVER_GPP_B_09 41
#define GPIO_VER1_LP_DRIVER_GPP_B_10 42
#define GPIO_VER1_LP_DRIVER_GPP_B_11 43
#define GPIO_VER1_LP_DRIVER_GPP_B_12 44
#define GPIO_VER1_LP_DRIVER_GPP_B_13 45
#define GPIO_VER1_LP_DRIVER_GPP_B_14 46
#define GPIO_VER1_LP_DRIVER_GPP_B_15 47
#define GPIO_VER1_LP_DRIVER_GPP_B_16 48
#define GPIO_VER1_LP_DRIVER_GPP_B_17 49
#define GPIO_VER1_LP_DRIVER_GPP_B_18 50
#define GPIO_VER1_LP_DRIVER_GPP_B_19 51
#define GPIO_VER1_LP_DRIVER_GPP_B_20 52
#define GPIO_VER1_LP_DRIVER_GPP_B_21 53
#define GPIO_VER1_LP_DRIVER_GPP_B_22 54
#define GPIO_VER1_LP_DRIVER_GPP_B_23 55

#define GPIO_VER1_LP_DRIVER_GPP_A_00 64
#define GPIO_VER1_LP_DRIVER_GPP_A_01 65
#define GPIO_VER1_LP_DRIVER_GPP_A_02 66
#define GPIO_VER1_LP_DRIVER_GPP_A_03 67
#define GPIO_VER1_LP_DRIVER_GPP_A_04 68
#define GPIO_VER1_LP_DRIVER_GPP_A_05 69
#define GPIO_VER1_LP_DRIVER_GPP_A_06 70
#define GPIO_VER1_LP_DRIVER_GPP_A_07 71
#define GPIO_VER1_LP_DRIVER_GPP_A_08 72
#define GPIO_VER1_LP_DRIVER_GPP_A_09 73
#define GPIO_VER1_LP_DRIVER_GPP_A_10 74
#define GPIO_VER1_LP_DRIVER_GPP_A_11 75
#define GPIO_VER1_LP_DRIVER_GPP_A_12 76
#define GPIO_VER1_LP_DRIVER_GPP_A_13 77
#define GPIO_VER1_LP_DRIVER_GPP_A_14 78
#define GPIO_VER1_LP_DRIVER_GPP_A_15 79
#define GPIO_VER1_LP_DRIVER_GPP_A_16 80
#define GPIO_VER1_LP_DRIVER_GPP_A_17 81
#define GPIO_VER1_LP_DRIVER_GPP_A_18 82
#define GPIO_VER1_LP_DRIVER_GPP_A_19 83
#define GPIO_VER1_LP_DRIVER_GPP_A_20 84
#define GPIO_VER1_LP_DRIVER_GPP_A_21 85
#define GPIO_VER1_LP_DRIVER_GPP_A_22 86
#define GPIO_VER1_LP_DRIVER_GPP_A_23 87

#define GPIO_VER1_LP_DRIVER_GPP_H_00 96
#define GPIO_VER1_LP_DRIVER_GPP_H_01 97
#define GPIO_VER1_LP_DRIVER_GPP_H_02 98
#define GPIO_VER1_LP_DRIVER_GPP_H_03 99
#define GPIO_VER1_LP_DRIVER_GPP_H_04 100
#define GPIO_VER1_LP_DRIVER_GPP_H_05 101
#define GPIO_VER1_LP_DRIVER_GPP_H_06 102
#define GPIO_VER1_LP_DRIVER_GPP_H_07 103
#define GPIO_VER1_LP_DRIVER_GPP_H_08 104
#define GPIO_VER1_LP_DRIVER_GPP_H_09 105
#define GPIO_VER1_LP_DRIVER_GPP_H_10 106
#define GPIO_VER1_LP_DRIVER_GPP_H_11 107
#define GPIO_VER1_LP_DRIVER_GPP_H_12 108
#define GPIO_VER1_LP_DRIVER_GPP_H_13 109
#define GPIO_VER1_LP_DRIVER_GPP_H_14 110
#define GPIO_VER1_LP_DRIVER_GPP_H_15 111
#define GPIO_VER1_LP_DRIVER_GPP_H_16 112
#define GPIO_VER1_LP_DRIVER_GPP_H_17 113
#define GPIO_VER1_LP_DRIVER_GPP_H_18 114
#define GPIO_VER1_LP_DRIVER_GPP_H_19 115
#define GPIO_VER1_LP_DRIVER_GPP_H_20 116
#define GPIO_VER1_LP_DRIVER_GPP_H_21 117
#define GPIO_VER1_LP_DRIVER_GPP_H_22 118
#define GPIO_VER1_LP_DRIVER_GPP_H_23 119

#define GPIO_VER1_LP_DRIVER_GPP_D_00 128
#define GPIO_VER1_LP_DRIVER_GPP_D_01 129
#define GPIO_VER1_LP_DRIVER_GPP_D_02 130
#define GPIO_VER1_LP_DRIVER_GPP_D_03 131
#define GPIO_VER1_LP_DRIVER_GPP_D_04 132
#define GPIO_VER1_LP_DRIVER_GPP_D_05 133
#define GPIO_VER1_LP_DRIVER_GPP_D_06 134
#define GPIO_VER1_LP_DRIVER_GPP_D_07 135
#define GPIO_VER1_LP_DRIVER_GPP_D_08 136
#define GPIO_VER1_LP_DRIVER_GPP_D_09 137
#define GPIO_VER1_LP_DRIVER_GPP_D_10 138
#define GPIO_VER1_LP_DRIVER_GPP_D_11 139
#define GPIO_VER1_LP_DRIVER_GPP_D_12 140
#define GPIO_VER1_LP_DRIVER_GPP_D_13 141
#define GPIO_VER1_LP_DRIVER_GPP_D_14 142
#define GPIO_VER1_LP_DRIVER_GPP_D_15 143
#define GPIO_VER1_LP_DRIVER_GPP_D_16 144
#define GPIO_VER1_LP_DRIVER_GPP_D_17 145
#define GPIO_VER1_LP_DRIVER_GPP_D_18 146
#define GPIO_VER1_LP_DRIVER_GPP_D_19 147

#define GPIO_VER1_LP_DRIVER_GPP_F_00 160
#define GPIO_VER1_LP_DRIVER_GPP_F_01 161
#define GPIO_VER1_LP_DRIVER_GPP_F_02 162
#define GPIO_VER1_LP_DRIVER_GPP_F_03 163
#define GPIO_VER1_LP_DRIVER_GPP_F_04 164
#define GPIO_VER1_LP_DRIVER_GPP_F_05 165
#define GPIO_VER1_LP_DRIVER_GPP_F_06 166
#define GPIO_VER1_LP_DRIVER_GPP_F_07 167
#define GPIO_VER1_LP_DRIVER_GPP_F_08 168
#define GPIO_VER1_LP_DRIVER_GPP_F_09 169
#define GPIO_VER1_LP_DRIVER_GPP_F_10 170
#define GPIO_VER1_LP_DRIVER_GPP_F_11 171
#define GPIO_VER1_LP_DRIVER_GPP_F_12 172
#define GPIO_VER1_LP_DRIVER_GPP_F_13 173
#define GPIO_VER1_LP_DRIVER_GPP_F_14 174
#define GPIO_VER1_LP_DRIVER_GPP_F_15 175
#define GPIO_VER1_LP_DRIVER_GPP_F_16 176
#define GPIO_VER1_LP_DRIVER_GPP_F_17 177
#define GPIO_VER1_LP_DRIVER_GPP_F_18 178
#define GPIO_VER1_LP_DRIVER_GPP_F_19 179

#define GPIO_VER1_LP_DRIVER_VGPIO_00 192
#define GPIO_VER1_LP_DRIVER_VGPIO_03 193
#define GPIO_VER1_LP_DRIVER_VGPIO_04 194
#define GPIO_VER1_LP_DRIVER_VGPIO_05 195
#define GPIO_VER1_LP_DRIVER_VGPIO_39 220

#define GPIO_VER1_LP_DRIVER_GPP_C_00 224
#define GPIO_VER1_LP_DRIVER_GPP_C_01 225
#define GPIO_VER1_LP_DRIVER_GPP_C_02 226
#define GPIO_VER1_LP_DRIVER_GPP_C_03 227
#define GPIO_VER1_LP_DRIVER_GPP_C_04 228
#define GPIO_VER1_LP_DRIVER_GPP_C_05 229
#define GPIO_VER1_LP_DRIVER_GPP_C_06 230
#define GPIO_VER1_LP_DRIVER_GPP_C_07 231
#define GPIO_VER1_LP_DRIVER_GPP_C_08 232
#define GPIO_VER1_LP_DRIVER_GPP_C_09 233
#define GPIO_VER1_LP_DRIVER_GPP_C_10 234
#define GPIO_VER1_LP_DRIVER_GPP_C_11 235
#define GPIO_VER1_LP_DRIVER_GPP_C_12 236
#define GPIO_VER1_LP_DRIVER_GPP_C_13 237
#define GPIO_VER1_LP_DRIVER_GPP_C_14 238
#define GPIO_VER1_LP_DRIVER_GPP_C_15 239
#define GPIO_VER1_LP_DRIVER_GPP_C_16 240
#define GPIO_VER1_LP_DRIVER_GPP_C_17 241
#define GPIO_VER1_LP_DRIVER_GPP_C_18 242
#define GPIO_VER1_LP_DRIVER_GPP_C_19 243
#define GPIO_VER1_LP_DRIVER_GPP_C_20 244
#define GPIO_VER1_LP_DRIVER_GPP_C_21 245
#define GPIO_VER1_LP_DRIVER_GPP_C_22 246
#define GPIO_VER1_LP_DRIVER_GPP_C_23 247

#define GPIO_VER1_LP_DRIVER_GPP_E_00 256
#define GPIO_VER1_LP_DRIVER_GPP_E_01 257
#define GPIO_VER1_LP_DRIVER_GPP_E_02 258
#define GPIO_VER1_LP_DRIVER_GPP_E_03 259
#define GPIO_VER1_LP_DRIVER_GPP_E_04 260
#define GPIO_VER1_LP_DRIVER_GPP_E_05 261
#define GPIO_VER1_LP_DRIVER_GPP_E_06 262
#define GPIO_VER1_LP_DRIVER_GPP_E_07 263
#define GPIO_VER1_LP_DRIVER_GPP_E_08 264
#define GPIO_VER1_LP_DRIVER_GPP_E_09 265
#define GPIO_VER1_LP_DRIVER_GPP_E_10 266
#define GPIO_VER1_LP_DRIVER_GPP_E_11 267
#define GPIO_VER1_LP_DRIVER_GPP_E_12 268
#define GPIO_VER1_LP_DRIVER_GPP_E_13 269
#define GPIO_VER1_LP_DRIVER_GPP_E_14 270
#define GPIO_VER1_LP_DRIVER_GPP_E_15 271
#define GPIO_VER1_LP_DRIVER_GPP_E_16 272
#define GPIO_VER1_LP_DRIVER_GPP_E_17 273
#define GPIO_VER1_LP_DRIVER_GPP_E_18 274
#define GPIO_VER1_LP_DRIVER_GPP_E_19 275
#define GPIO_VER1_LP_DRIVER_GPP_E_20 276
#define GPIO_VER1_LP_DRIVER_GPP_E_21 277
#define GPIO_VER1_LP_DRIVER_GPP_E_22 278
#define GPIO_VER1_LP_DRIVER_GPP_E_23 279

#define GPIO_VER1_LP_DRIVER_GPP_R_00 288
#define GPIO_VER1_LP_DRIVER_GPP_R_01 289
#define GPIO_VER1_LP_DRIVER_GPP_R_02 290
#define GPIO_VER1_LP_DRIVER_GPP_R_03 291
#define GPIO_VER1_LP_DRIVER_GPP_R_04 292
#define GPIO_VER1_LP_DRIVER_GPP_R_05 293
#define GPIO_VER1_LP_DRIVER_GPP_R_06 294
#define GPIO_VER1_LP_DRIVER_GPP_R_07 295

#define GPIO_VER1_LP_DRIVER_GPP_S_00 320
#define GPIO_VER1_LP_DRIVER_GPP_S_01 321
#define GPIO_VER1_LP_DRIVER_GPP_S_02 322
#define GPIO_VER1_LP_DRIVER_GPP_S_03 323
#define GPIO_VER1_LP_DRIVER_GPP_S_04 324
#define GPIO_VER1_LP_DRIVER_GPP_S_05 325
#define GPIO_VER1_LP_DRIVER_GPP_S_06 326
#define GPIO_VER1_LP_DRIVER_GPP_S_07 327

#define GPIO_VER1_LP_IOAPIC_GPP_G_00 0x18
#define GPIO_VER1_LP_IOAPIC_GPP_G_01 0x19
#define GPIO_VER1_LP_IOAPIC_GPP_G_02 0x1a
#define GPIO_VER1_LP_IOAPIC_GPP_G_03 0x1b
#define GPIO_VER1_LP_IOAPIC_GPP_G_04 0x1c
#define GPIO_VER1_LP_IOAPIC_GPP_G_05 0x1d
#define GPIO_VER1_LP_IOAPIC_GPP_G_06 0x1e
#define GPIO_VER1_LP_IOAPIC_GPP_G_07 0x1f

#define GPIO_VER1_LP_IOAPIC_GPP_B_00 0x20
#define GPIO_VER1_LP_IOAPIC_GPP_B_01 0x21
#define GPIO_VER1_LP_IOAPIC_GPP_B_02 0x22
#define GPIO_VER1_LP_IOAPIC_GPP_B_03 0x23
#define GPIO_VER1_LP_IOAPIC_GPP_B_04 0x24
#define GPIO_VER1_LP_IOAPIC_GPP_B_05 0x25
#define GPIO_VER1_LP_IOAPIC_GPP_B_06 0x26
#define GPIO_VER1_LP_IOAPIC_GPP_B_07 0x27
#define GPIO_VER1_LP_IOAPIC_GPP_B_08 0x28
#define GPIO_VER1_LP_IOAPIC_GPP_B_09 0x29
#define GPIO_VER1_LP_IOAPIC_GPP_B_10 0x2a
#define GPIO_VER1_LP_IOAPIC_GPP_B_11 0x2b
#define GPIO_VER1_LP_IOAPIC_GPP_B_12 0x2c
#define GPIO_VER1_LP_IOAPIC_GPP_B_13 0x2d
#define GPIO_VER1_LP_IOAPIC_GPP_B_14 0x2e
#define GPIO_VER1_LP_IOAPIC_GPP_B_15 0x2f
#define GPIO_VER1_LP_IOAPIC_GPP_B_16 0x30
#define GPIO_VER1_LP_IOAPIC_GPP_B_17 0x31
#define GPIO_VER1_LP_IOAPIC_GPP_B_18 0x32
#define GPIO_VER1_LP_IOAPIC_GPP_B_19 0x33
#define GPIO_VER1_LP_IOAPIC_GPP_B_20 0x34
#define GPIO_VER1_LP_IOAPIC_GPP_B_21 0x35
#define GPIO_VER1_LP_IOAPIC_GPP_B_22 0x36
#define GPIO_VER1_LP_IOAPIC_GPP_B_23 0x37

#define GPIO_VER1_LP_IOAPIC_GPP_A_00 0x38
#define GPIO_VER1_LP_IOAPIC_GPP_A_01 0x39
#define GPIO_VER1_LP_IOAPIC_GPP_A_02 0x3a
#define GPIO_VER1_LP_IOAPIC_GPP_A_03 0x3b
#define GPIO_VER1_LP_IOAPIC_GPP_A_04 0x3c
#define GPIO_VER1_LP_IOAPIC_GPP_A_05 0x3d
#define GPIO_VER1_LP_IOAPIC_GPP_A_06 0x3e
#define GPIO_VER1_LP_IOAPIC_GPP_A_07 0x3f
#define GPIO_VER1_LP_IOAPIC_GPP_A_08 0x40
#define GPIO_VER1_LP_IOAPIC_GPP_A_09 0x41
#define GPIO_VER1_LP_IOAPIC_GPP_A_10 0x42
#define GPIO_VER1_LP_IOAPIC_GPP_A_11 0x43
#define GPIO_VER1_LP_IOAPIC_GPP_A_12 0x44
#define GPIO_VER1_LP_IOAPIC_GPP_A_13 0x45
#define GPIO_VER1_LP_IOAPIC_GPP_A_14 0x46
#define GPIO_VER1_LP_IOAPIC_GPP_A_15 0x47
#define GPIO_VER1_LP_IOAPIC_GPP_A_16 0x48
#define GPIO_VER1_LP_IOAPIC_GPP_A_17 0x49
#define GPIO_VER1_LP_IOAPIC_GPP_A_18 0x4a
#define GPIO_VER1_LP_IOAPIC_GPP_A_19 0x4b
#define GPIO_VER1_LP_IOAPIC_GPP_A_20 0x4c
#define GPIO_VER1_LP_IOAPIC_GPP_A_21 0x4d
#define GPIO_VER1_LP_IOAPIC_GPP_A_22 0x4e
#define GPIO_VER1_LP_IOAPIC_GPP_A_23 0x4f

#define GPIO_VER1_LP_IOAPIC_GPP_H_00 0x70
#define GPIO_VER1_LP_IOAPIC_GPP_H_01 0x71
#define GPIO_VER1_LP_IOAPIC_GPP_H_02 0x72
#define GPIO_VER1_LP_IOAPIC_GPP_H_03 0x73
#define GPIO_VER1_LP_IOAPIC_GPP_H_04 0x74
#define GPIO_VER1_LP_IOAPIC_GPP_H_05 0x75
#define GPIO_VER1_LP_IOAPIC_GPP_H_06 0x76
#define GPIO_VER1_LP_IOAPIC_GPP_H_07 0x77
#define GPIO_VER1_LP_IOAPIC_GPP_H_08 0x18
#define GPIO_VER1_LP_IOAPIC_GPP_H_09 0x19
#define GPIO_VER1_LP_IOAPIC_GPP_H_10 0x1a
#define GPIO_VER1_LP_IOAPIC_GPP_H_11 0x1b
#define GPIO_VER1_LP_IOAPIC_GPP_H_12 0x1c
#define GPIO_VER1_LP_IOAPIC_GPP_H_13 0x1d
#define GPIO_VER1_LP_IOAPIC_GPP_H_14 0x1e
#define GPIO_VER1_LP_IOAPIC_GPP_H_15 0x1f
#define GPIO_VER1_LP_IOAPIC_GPP_H_16 0x20
#define GPIO_VER1_LP_IOAPIC_GPP_H_17 0x21
#define GPIO_VER1_LP_IOAPIC_GPP_H_18 0x22
#define GPIO_VER1_LP_IOAPIC_GPP_H_19 0x23
#define GPIO_VER1_LP_IOAPIC_GPP_H_20 0x24
#define GPIO_VER1_LP_IOAPIC_GPP_H_21 0x25
#define GPIO_VER1_LP_IOAPIC_GPP_H_22 0x26
#define GPIO_VER1_LP_IOAPIC_GPP_H_23 0x27

#define GPIO_VER1_LP_IOAPIC_GPP_D_00 0x28
#define GPIO_VER1_LP_IOAPIC_GPP_D_01 0x29
#define GPIO_VER1_LP_IOAPIC_GPP_D_02 0x2a
#define GPIO_VER1_LP_IOAPIC_GPP_D_03 0x2b
#define GPIO_VER1_LP_IOAPIC_GPP_D_04 0x2c
#define GPIO_VER1_LP_IOAPIC_GPP_D_05 0x2d
#define GPIO_VER1_LP_IOAPIC_GPP_D_06 0x2e
#define GPIO_VER1_LP_IOAPIC_GPP_D_07 0x2f
#define GPIO_VER1_LP_IOAPIC_GPP_D_08 0x30
#define GPIO_VER1_LP_IOAPIC_GPP_D_09 0x31
#define GPIO_VER1_LP_IOAPIC_GPP_D_10 0x32
#define GPIO_VER1_LP_IOAPIC_GPP_D_11 0x33
#define GPIO_VER1_LP_IOAPIC_GPP_D_12 0x34
#define GPIO_VER1_LP_IOAPIC_GPP_D_13 0x35
#define GPIO_VER1_LP_IOAPIC_GPP_D_14 0x36
#define GPIO_VER1_LP_IOAPIC_GPP_D_15 0x37
#define GPIO_VER1_LP_IOAPIC_GPP_D_16 0x38
#define GPIO_VER1_LP_IOAPIC_GPP_D_17 0x39
#define GPIO_VER1_LP_IOAPIC_GPP_D_18 0x3a
#define GPIO_VER1_LP_IOAPIC_GPP_D_19 0x3b

#define GPIO_VER1_LP_IOAPIC_GPP_F_00 0x40
#define GPIO_VER1_LP_IOAPIC_GPP_F_01 0x41
#define GPIO_VER1_LP_IOAPIC_GPP_F_02 0x42
#define GPIO_VER1_LP_IOAPIC_GPP_F_03 0x43
#define GPIO_VER1_LP_IOAPIC_GPP_F_04 0x44
#define GPIO_VER1_LP_IOAPIC_GPP_F_05 0x45
#define GPIO_VER1_LP_IOAPIC_GPP_F_06 0x46
#define GPIO_VER1_LP_IOAPIC_GPP_F_07 0x47
#define GPIO_VER1_LP_IOAPIC_GPP_F_08 0x48
#define GPIO_VER1_LP_IOAPIC_GPP_F_09 0x49
#define GPIO_VER1_LP_IOAPIC_GPP_F_10 0x4a
#define GPIO_VER1_LP_IOAPIC_GPP_F_11 0x4b
#define GPIO_VER1_LP_IOAPIC_GPP_F_12 0x4c
#define GPIO_VER1_LP_IOAPIC_GPP_F_13 0x4d
#define GPIO_VER1_LP_IOAPIC_GPP_F_14 0x4e
#define GPIO_VER1_LP_IOAPIC_GPP_F_15 0x4f
#define GPIO_VER1_LP_IOAPIC_GPP_F_16 0x50
#define GPIO_VER1_LP_IOAPIC_GPP_F_17 0x51
#define GPIO_VER1_LP_IOAPIC_GPP_F_18 0x52
#define GPIO_VER1_LP_IOAPIC_GPP_F_19 0x53

#define GPIO_VER1_LP_IOAPIC_VGPIO_04 0x58
#define GPIO_VER1_LP_IOAPIC_VGPIO_39 0x59

#define GPIO_VER1_LP_IOAPIC_GPP_C_00 0x5a
#define GPIO_VER1_LP_IOAPIC_GPP_C_01 0x5b
#define GPIO_VER1_LP_IOAPIC_GPP_C_02 0x5c
#define GPIO_VER1_LP_IOAPIC_GPP_C_03 0x5d
#define GPIO_VER1_LP_IOAPIC_GPP_C_04 0x5e
#define GPIO_VER1_LP_IOAPIC_GPP_C_05 0x5f
#define GPIO_VER1_LP_IOAPIC_GPP_C_06 0x60
#define GPIO_VER1_LP_IOAPIC_GPP_C_07 0x61
#define GPIO_VER1_LP_IOAPIC_GPP_C_08 0x62
#define GPIO_VER1_LP_IOAPIC_GPP_C_09 0x63
#define GPIO_VER1_LP_IOAPIC_GPP_C_10 0x64
#define GPIO_VER1_LP_IOAPIC_GPP_C_11 0x65
#define GPIO_VER1_LP_IOAPIC_GPP_C_12 0x66
#define GPIO_VER1_LP_IOAPIC_GPP_C_13 0x67
#define GPIO_VER1_LP_IOAPIC_GPP_C_14 0x68
#define GPIO_VER1_LP_IOAPIC_GPP_C_15 0x69
#define GPIO_VER1_LP_IOAPIC_GPP_C_16 0x6a
#define GPIO_VER1_LP_IOAPIC_GPP_C_17 0x6b
#define GPIO_VER1_LP_IOAPIC_GPP_C_18 0x6c
#define GPIO_VER1_LP_IOAPIC_GPP_C_19 0x6d
#define GPIO_VER1_LP_IOAPIC_GPP_C_20 0x6e
#define GPIO_VER1_LP_IOAPIC_GPP_C_21 0x6f
#define GPIO_VER1_LP_IOAPIC_GPP_C_22 0x70
#define GPIO_VER1_LP_IOAPIC_GPP_C_23 0x71

#define GPIO_VER1_LP_IOAPIC_GPP_E_00 0x72
#define GPIO_VER1_LP_IOAPIC_GPP_E_01 0x73
#define GPIO_VER1_LP_IOAPIC_GPP_E_02 0x74
#define GPIO_VER1_LP_IOAPIC_GPP_E_03 0x75
#define GPIO_VER1_LP_IOAPIC_GPP_E_04 0x76
#define GPIO_VER1_LP_IOAPIC_GPP_E_05 0x77
#define GPIO_VER1_LP_IOAPIC_GPP_E_06 0x18
#define GPIO_VER1_LP_IOAPIC_GPP_E_07 0x19
#define GPIO_VER1_LP_IOAPIC_GPP_E_08 0x1a
#define GPIO_VER1_LP_IOAPIC_GPP_E_09 0x1b
#define GPIO_VER1_LP_IOAPIC_GPP_E_10 0x1c
#define GPIO_VER1_LP_IOAPIC_GPP_E_11 0x1d
#define GPIO_VER1_LP_IOAPIC_GPP_E_12 0x1e
#define GPIO_VER1_LP_IOAPIC_GPP_E_13 0x1f
#define GPIO_VER1_LP_IOAPIC_GPP_E_14 0x20
#define GPIO_VER1_LP_IOAPIC_GPP_E_15 0x21
#define GPIO_VER1_LP_IOAPIC_GPP_E_16 0x22
#define GPIO_VER1_LP_IOAPIC_GPP_E_17 0x23
#define GPIO_VER1_LP_IOAPIC_GPP_E_18 0x24
#define GPIO_VER1_LP_IOAPIC_GPP_E_19 0x25
#define GPIO_VER1_LP_IOAPIC_GPP_E_20 0x26
#define GPIO_VER1_LP_IOAPIC_GPP_E_21 0x27
#define GPIO_VER1_LP_IOAPIC_GPP_E_22 0x28
#define GPIO_VER1_LP_IOAPIC_GPP_E_23 0x29

#define GPIO_VER1_LP_IOAPIC_GPP_R_00 0x50
#define GPIO_VER1_LP_IOAPIC_GPP_R_01 0x51
#define GPIO_VER1_LP_IOAPIC_GPP_R_02 0x52
#define GPIO_VER1_LP_IOAPIC_GPP_R_03 0x53
#define GPIO_VER1_LP_IOAPIC_GPP_R_04 0x54
#define GPIO_VER1_LP_IOAPIC_GPP_R_05 0x55
#define GPIO_VER1_LP_IOAPIC_GPP_R_06 0x56
#define GPIO_VER1_LP_IOAPIC_GPP_R_07 0x57

#define GPIO_VER1_LP_IOAPIC_GPP_S_00 0x5c
#define GPIO_VER1_LP_IOAPIC_GPP_S_01 0x5d
#define GPIO_VER1_LP_IOAPIC_GPP_S_02 0x5e
#define GPIO_VER1_LP_IOAPIC_GPP_S_03 0x5f
#define GPIO_VER1_LP_IOAPIC_GPP_S_04 0x60
#define GPIO_VER1_LP_IOAPIC_GPP_S_05 0x61
#define GPIO_VER1_LP_IOAPIC_GPP_S_06 0x62
#define GPIO_VER1_LP_IOAPIC_GPP_S_07 0x63

#define GPIO_VER1_N_DRIVER_GPP_G_00 0
#define GPIO_VER1_N_DRIVER_GPP_G_01 1
#define GPIO_VER1_N_DRIVER_GPP_G_02 2
#define GPIO_VER1_N_DRIVER_GPP_G_03 3
#define GPIO_VER1_N_DRIVER_GPP_G_04 4
#define GPIO_VER1_N_DRIVER_GPP_G_05 5
#define GPIO_VER1_N_DRIVER_GPP_G_06 6
#define GPIO_VER1_N_DRIVER_GPP_G_07 7

#define GPIO_VER1_N_DRIVER_GPP_B_00 32
#define GPIO_VER1_N_DRIVER_GPP_B_01 33
#define GPIO_VER1_N_DRIVER_GPP_B_02 34
#define GPIO_VER1_N_DRIVER_GPP_B_03 35
#define GPIO_VER1_N_DRIVER_GPP_B_04 36
#define GPIO_VER1_N_DRIVER_GPP_B_05 37
#define GPIO_VER1_N_DRIVER_GPP_B_06 38
#define GPIO_VER1_N_DRIVER_GPP_B_07 39
#define GPIO_VER1_N_DRIVER_GPP_B_08 40
#define GPIO_VER1_N_DRIVER_GPP_B_09 41
#define GPIO_VER1_N_DRIVER_GPP_B_10 42
#define GPIO_VER1_N_DRIVER_GPP_B_11 43
#define GPIO_VER1_N_DRIVER_GPP_B_12 44
#define GPIO_VER1_N_DRIVER_GPP_B_13 45
#define GPIO_VER1_N_DRIVER_GPP_B_14 46
#define GPIO_VER1_N_DRIVER_GPP_B_15 47
#define GPIO_VER1_N_DRIVER_GPP_B_16 48
#define GPIO_VER1_N_DRIVER_GPP_B_17 49
#define GPIO_VER1_N_DRIVER_GPP_B_18 50
#define GPIO_VER1_N_DRIVER_GPP_B_19 51
#define GPIO_VER1_N_DRIVER_GPP_B_20 52
#define GPIO_VER1_N_DRIVER_GPP_B_21 53
#define GPIO_VER1_N_DRIVER_GPP_B_22 54
#define GPIO_VER1_N_DRIVER_GPP_B_23 55

#define GPIO_VER1_N_DRIVER_GPP_A_00 64
#define GPIO_VER1_N_DRIVER_GPP_A_01 65
#define GPIO_VER1_N_DRIVER_GPP_A_02 66
#define GPIO_VER1_N_DRIVER_GPP_A_03 67
#define GPIO_VER1_N_DRIVER_GPP_A_04 68
#define GPIO_VER1_N_DRIVER_GPP_A_05 69
#define GPIO_VER1_N_DRIVER_GPP_A_06 70
#define GPIO_VER1_N_DRIVER_GPP_A_07 71
#define GPIO_VER1_N_DRIVER_GPP_A_08 72
#define GPIO_VER1_N_DRIVER_GPP_A_09 73
#define GPIO_VER1_N_DRIVER_GPP_A_10 74
#define GPIO_VER1_N_DRIVER_GPP_A_11 75
#define GPIO_VER1_N_DRIVER_GPP_A_12 76
#define GPIO_VER1_N_DRIVER_GPP_A_13 77
#define GPIO_VER1_N_DRIVER_GPP_A_14 78
#define GPIO_VER1_N_DRIVER_GPP_A_15 79
#define GPIO_VER1_N_DRIVER_GPP_A_16 80
#define GPIO_VER1_N_DRIVER_GPP_A_17 81
#define GPIO_VER1_N_DRIVER_GPP_A_18 82
#define GPIO_VER1_N_DRIVER_GPP_A_19 83

#define GPIO_VER1_N_DRIVER_GPP_S_00 96
#define GPIO_VER1_N_DRIVER_GPP_S_01 97
#define GPIO_VER1_N_DRIVER_GPP_S_02 98
#define GPIO_VER1_N_DRIVER_GPP_S_03 99
#define GPIO_VER1_N_DRIVER_GPP_S_04 100
#define GPIO_VER1_N_DRIVER_GPP_S_05 101
#define GPIO_VER1_N_DRIVER_GPP_S_06 102
#define GPIO_VER1_N_DRIVER_GPP_S_07 103

#define GPIO_VER1_N_DRIVER_GPP_R_00 128
#define GPIO_VER1_N_DRIVER_GPP_R_01 129
#define GPIO_VER1_N_DRIVER_GPP_R_02 130
#define GPIO_VER1_N_DRIVER_GPP_R_03 131
#define GPIO_VER1_N_DRIVER_GPP_R_04 132
#define GPIO_VER1_N_DRIVER_GPP_R_05 133
#define GPIO_VER1_N_DRIVER_GPP_R_06 134
#define GPIO_VER1_N_DRIVER_GPP_R_07 135

#define GPIO_VER1_N_DRIVER_GPP_H_00 160
#define GPIO_VER1_N_DRIVER_GPP_H_01 161
#define GPIO_VER1_N_DRIVER_GPP_H_02 162
#define GPIO_VER1_N_DRIVER_GPP_H_03 163
#define GPIO_VER1_N_DRIVER_GPP_H_04 164
#define GPIO_VER1_N_DRIVER_GPP_H_05 165
#define GPIO_VER1_N_DRIVER_GPP_H_06 166
#define GPIO_VER1_N_DRIVER_GPP_H_07 167
#define GPIO_VER1_N_DRIVER_GPP_H_08 168
#define GPIO_VER1_N_DRIVER_GPP_H_09 169
#define GPIO_VER1_N_DRIVER_GPP_H_10 170
#define GPIO_VER1_N_DRIVER_GPP_H_11 171
#define GPIO_VER1_N_DRIVER_GPP_H_12 172
#define GPIO_VER1_N_DRIVER_GPP_H_13 173
#define GPIO_VER1_N_DRIVER_GPP_H_14 174
#define GPIO_VER1_N_DRIVER_GPP_H_15 175
#define GPIO_VER1_N_DRIVER_GPP_H_16 176
#define GPIO_VER1_N_DRIVER_GPP_H_17 177
#define GPIO_VER1_N_DRIVER_GPP_H_18 178
#define GPIO_VER1_N_DRIVER_GPP_H_19 179
#define GPIO_VER1_N_DRIVER_GPP_H_20 180
#define GPIO_VER1_N_DRIVER_GPP_H_21 181
#define GPIO_VER1_N_DRIVER_GPP_H_22 182
#define GPIO_VER1_N_DRIVER_GPP_H_23 183

#define GPIO_VER1_N_DRIVER_GPP_D_00 192
#define GPIO_VER1_N_DRIVER_GPP_D_01 193
#define GPIO_VER1_N_DRIVER_GPP_D_02 194
#define GPIO_VER1_N_DRIVER_GPP_D_03 195
#define GPIO_VER1_N_DRIVER_GPP_D_04 196
#define GPIO_VER1_N_DRIVER_GPP_D_05 197
#define GPIO_VER1_N_DRIVER_GPP_D_06 198
#define GPIO_VER1_N_DRIVER_GPP_D_07 199
#define GPIO_VER1_N_DRIVER_GPP_D_08 200
#define GPIO_VER1_N_DRIVER_GPP_D_09 201
#define GPIO_VER1_N_DRIVER_GPP_D_10 202
#define GPIO_VER1_N_DRIVER_GPP_D_11 203
#define GPIO_VER1_N_DRIVER_GPP_D_12 204
#define GPIO_VER1_N_DRIVER_GPP_D_13 205
#define GPIO_VER1_N_DRIVER_GPP_D_14 206
#define GPIO_VER1_N_DRIVER_GPP_D_15 207
#define GPIO_VER1_N_DRIVER_GPP_D_16 208
#define GPIO_VER1_N_DRIVER_GPP_D_17 209
#define GPIO_VER1_N_DRIVER_GPP_D_18 210
#define GPIO_VER1_N_DRIVER_GPP_D_19 211
#define GPIO_VER1_N_DRIVER_GPP_D_20 212
#define GPIO_VER1_N_DRIVER_GPP_D_21 213
#define GPIO_VER1_N_DRIVER_GPP_D_22 214
#define GPIO_VER1_N_DRIVER_GPP_D_23 215

#define GPIO_VER1_N_DRIVER_VGPIO_00 224
#define GPIO_VER1_N_DRIVER_VGPIO_03 225
#define GPIO_VER1_N_DRIVER_VGPIO_04 226
#define GPIO_VER1_N_DRIVER_VGPIO_05 227
#define GPIO_VER1_N_DRIVER_VGPIO_39 252

#define GPIO_VER1_N_DRIVER_GPP_C_00 256
#define GPIO_VER1_N_DRIVER_GPP_C_01 257
#define GPIO_VER1_N_DRIVER_GPP_C_02 258
#define GPIO_VER1_N_DRIVER_GPP_C_03 259
#define GPIO_VER1_N_DRIVER_GPP_C_04 260
#define GPIO_VER1_N_DRIVER_GPP_C_05 261
#define GPIO_VER1_N_DRIVER_GPP_C_06 262
#define GPIO_VER1_N_DRIVER_GPP_C_07 263
#define GPIO_VER1_N_DRIVER_GPP_C_08 264
#define GPIO_VER1_N_DRIVER_GPP_C_09 265
#define GPIO_VER1_N_DRIVER_GPP_C_10 266
#define GPIO_VER1_N_DRIVER_GPP_C_11 267
#define GPIO_VER1_N_DRIVER_GPP_C_12 268
#define GPIO_VER1_N_DRIVER_GPP_C_13 269
#define GPIO_VER1_N_DRIVER_GPP_C_14 270
#define GPIO_VER1_N_DRIVER_GPP_C_15 271
#define GPIO_VER1_N_DRIVER_GPP_C_16 272
#define GPIO_VER1_N_DRIVER_GPP_C_17 273
#define GPIO_VER1_N_DRIVER_GPP_C_18 274
#define GPIO_VER1_N_DRIVER_GPP_C_19 275
#define GPIO_VER1_N_DRIVER_GPP_C_20 276
#define GPIO_VER1_N_DRIVER_GPP_C_21 277
#define GPIO_VER1_N_DRIVER_GPP_C_22 278
#define GPIO_VER1_N_DRIVER_GPP_C_23 279

#define GPIO_VER1_N_DRIVER_GPP_E_00 288
#define GPIO_VER1_N_DRIVER_GPP_E_01 289
#define GPIO_VER1_N_DRIVER_GPP_E_02 290
#define GPIO_VER1_N_DRIVER_GPP_E_03 291
#define GPIO_VER1_N_DRIVER_GPP_E_04 292
#define GPIO_VER1_N_DRIVER_GPP_E_05 293
#define GPIO_VER1_N_DRIVER_GPP_E_06 294
#define GPIO_VER1_N_DRIVER_GPP_E_07 295
#define GPIO_VER1_N_DRIVER_GPP_E_08 296
#define GPIO_VER1_N_DRIVER_GPP_E_09 297
#define GPIO_VER1_N_DRIVER_GPP_E_10 298
#define GPIO_VER1_N_DRIVER_GPP_E_11 299
#define GPIO_VER1_N_DRIVER_GPP_E_12 300
#define GPIO_VER1_N_DRIVER_GPP_E_13 301
#define GPIO_VER1_N_DRIVER_GPP_E_14 302
#define GPIO_VER1_N_DRIVER_GPP_E_15 303
#define GPIO_VER1_N_DRIVER_GPP_E_16 304
#define GPIO_VER1_N_DRIVER_GPP_E_17 305
#define GPIO_VER1_N_DRIVER_GPP_E_18 306
#define GPIO_VER1_N_DRIVER_GPP_E_19 307
#define GPIO_VER1_N_DRIVER_GPP_E_20 308
#define GPIO_VER1_N_DRIVER_GPP_E_21 309
#define GPIO_VER1_N_DRIVER_GPP_E_22 310
#define GPIO_VER1_N_DRIVER_GPP_E_23 311

#define GPIO_VER1_1_N_DRIVER_GPP_F_00 320
#define GPIO_VER1_1_N_DRIVER_GPP_F_01 321
#define GPIO_VER1_1_N_DRIVER_GPP_F_02 322
#define GPIO_VER1_1_N_DRIVER_GPP_F_03 323
#define GPIO_VER1_1_N_DRIVER_GPP_F_04 324
#define GPIO_VER1_1_N_DRIVER_GPP_F_05 325
#define GPIO_VER1_1_N_DRIVER_GPP_F_06 326
#define GPIO_VER1_1_N_DRIVER_GPP_F_07 327
#define GPIO_VER1_1_N_DRIVER_GPP_F_08 328
#define GPIO_VER1_1_N_DRIVER_GPP_F_09 329
#define GPIO_VER1_1_N_DRIVER_GPP_F_10 330
#define GPIO_VER1_1_N_DRIVER_GPP_F_11 331
#define GPIO_VER1_1_N_DRIVER_GPP_F_12 332
#define GPIO_VER1_1_N_DRIVER_GPP_F_13 333
#define GPIO_VER1_1_N_DRIVER_GPP_F_14 334
#define GPIO_VER1_1_N_DRIVER_GPP_F_15 335
#define GPIO_VER1_1_N_DRIVER_GPP_F_16 336
#define GPIO_VER1_1_N_DRIVER_GPP_F_17 337
#define GPIO_VER1_1_N_DRIVER_GPP_F_18 338
#define GPIO_VER1_1_N_DRIVER_GPP_F_19 339

#define GPIO_VER1_N_IOAPIC_GPP_G_00 0x18
#define GPIO_VER1_N_IOAPIC_GPP_G_01 0x19
#define GPIO_VER1_N_IOAPIC_GPP_G_02 0x1a
#define GPIO_VER1_N_IOAPIC_GPP_G_03 0x1b
#define GPIO_VER1_N_IOAPIC_GPP_G_04 0x1c
#define GPIO_VER1_N_IOAPIC_GPP_G_05 0x1d
#define GPIO_VER1_N_IOAPIC_GPP_G_06 0x1e
#define GPIO_VER1_N_IOAPIC_GPP_G_07 0x1f

#define GPIO_VER1_N_IOAPIC_GPP_B_00 0x20
#define GPIO_VER1_N_IOAPIC_GPP_B_01 0x21
#define GPIO_VER1_N_IOAPIC_GPP_B_02 0x22
#define GPIO_VER1_N_IOAPIC_GPP_B_03 0x23
#define GPIO_VER1_N_IOAPIC_GPP_B_04 0x24
#define GPIO_VER1_N_IOAPIC_GPP_B_05 0x25
#define GPIO_VER1_N_IOAPIC_GPP_B_06 0x26
#define GPIO_VER1_N_IOAPIC_GPP_B_07 0x27
#define GPIO_VER1_N_IOAPIC_GPP_B_08 0x28
#define GPIO_VER1_N_IOAPIC_GPP_B_09 0x29
#define GPIO_VER1_N_IOAPIC_GPP_B_10 0x2a
#define GPIO_VER1_N_IOAPIC_GPP_B_11 0x2b
#define GPIO_VER1_N_IOAPIC_GPP_B_12 0x2c
#define GPIO_VER1_N_IOAPIC_GPP_B_13 0x2d
#define GPIO_VER1_N_IOAPIC_GPP_B_14 0x2e
#define GPIO_VER1_N_IOAPIC_GPP_B_15 0x2f
#define GPIO_VER1_N_IOAPIC_GPP_B_16 0x30
#define GPIO_VER1_N_IOAPIC_GPP_B_17 0x31
#define GPIO_VER1_N_IOAPIC_GPP_B_18 0x32
#define GPIO_VER1_N_IOAPIC_GPP_B_19 0x33
#define GPIO_VER1_N_IOAPIC_GPP_B_20 0x34
#define GPIO_VER1_N_IOAPIC_GPP_B_21 0x35
#define GPIO_VER1_N_IOAPIC_GPP_B_22 0x36
#define GPIO_VER1_N_IOAPIC_GPP_B_23 0x37

#define GPIO_VER1_N_IOAPIC_GPP_A_00 0x38
#define GPIO_VER1_N_IOAPIC_GPP_A_01 0x39
#define GPIO_VER1_N_IOAPIC_GPP_A_02 0x3a
#define GPIO_VER1_N_IOAPIC_GPP_A_03 0x3b
#define GPIO_VER1_N_IOAPIC_GPP_A_04 0x3c
#define GPIO_VER1_N_IOAPIC_GPP_A_05 0x3d
#define GPIO_VER1_N_IOAPIC_GPP_A_06 0x3e
#define GPIO_VER1_N_IOAPIC_GPP_A_07 0x3f
#define GPIO_VER1_N_IOAPIC_GPP_A_08 0x40
#define GPIO_VER1_N_IOAPIC_GPP_A_09 0x41
#define GPIO_VER1_N_IOAPIC_GPP_A_10 0x42
#define GPIO_VER1_N_IOAPIC_GPP_A_11 0x43
#define GPIO_VER1_N_IOAPIC_GPP_A_12 0x44
#define GPIO_VER1_N_IOAPIC_GPP_A_13 0x45
#define GPIO_VER1_N_IOAPIC_GPP_A_14 0x46
#define GPIO_VER1_N_IOAPIC_GPP_A_15 0x47
#define GPIO_VER1_N_IOAPIC_GPP_A_16 0x48
#define GPIO_VER1_N_IOAPIC_GPP_A_17 0x49
#define GPIO_VER1_N_IOAPIC_GPP_A_18 0x4a
#define GPIO_VER1_N_IOAPIC_GPP_A_19 0x4b

#define GPIO_VER1_N_IOAPIC_GPP_S_00 0x5c
#define GPIO_VER1_N_IOAPIC_GPP_S_01 0x5d
#define GPIO_VER1_N_IOAPIC_GPP_S_02 0x5e
#define GPIO_VER1_N_IOAPIC_GPP_S_03 0x5f
#define GPIO_VER1_N_IOAPIC_GPP_S_04 0x60
#define GPIO_VER1_N_IOAPIC_GPP_S_05 0x61
#define GPIO_VER1_N_IOAPIC_GPP_S_06 0x62
#define GPIO_VER1_N_IOAPIC_GPP_S_07 0x63

#define GPIO_VER1_N_IOAPIC_GPP_R_00 0x50
#define GPIO_VER1_N_IOAPIC_GPP_R_01 0x51
#define GPIO_VER1_N_IOAPIC_GPP_R_02 0x52
#define GPIO_VER1_N_IOAPIC_GPP_R_03 0x53
#define GPIO_VER1_N_IOAPIC_GPP_R_04 0x54
#define GPIO_VER1_N_IOAPIC_GPP_R_05 0x55
#define GPIO_VER1_N_IOAPIC_GPP_R_06 0x56
#define GPIO_VER1_N_IOAPIC_GPP_R_07 0x57

#define GPIO_VER1_N_IOAPIC_GPP_H_00 0x70
#define GPIO_VER1_N_IOAPIC_GPP_H_01 0x71
#define GPIO_VER1_N_IOAPIC_GPP_H_02 0x72
#define GPIO_VER1_N_IOAPIC_GPP_H_03 0x73
#define GPIO_VER1_N_IOAPIC_GPP_H_04 0x74
#define GPIO_VER1_N_IOAPIC_GPP_H_05 0x75
#define GPIO_VER1_N_IOAPIC_GPP_H_06 0x76
#define GPIO_VER1_N_IOAPIC_GPP_H_07 0x77
#define GPIO_VER1_N_IOAPIC_GPP_H_08 0x18
#define GPIO_VER1_N_IOAPIC_GPP_H_09 0x19
#define GPIO_VER1_N_IOAPIC_GPP_H_10 0x1a
#define GPIO_VER1_N_IOAPIC_GPP_H_11 0x1b
#define GPIO_VER1_N_IOAPIC_GPP_H_12 0x1c
#define GPIO_VER1_N_IOAPIC_GPP_H_13 0x1d
#define GPIO_VER1_N_IOAPIC_GPP_H_14 0x1e
#define GPIO_VER1_N_IOAPIC_GPP_H_15 0x1f
#define GPIO_VER1_N_IOAPIC_GPP_H_16 0x20
#define GPIO_VER1_N_IOAPIC_GPP_H_17 0x21
#define GPIO_VER1_N_IOAPIC_GPP_H_18 0x22
#define GPIO_VER1_N_IOAPIC_GPP_H_19 0x23
#define GPIO_VER1_N_IOAPIC_GPP_H_20 0x24
#define GPIO_VER1_N_IOAPIC_GPP_H_21 0x25
#define GPIO_VER1_N_IOAPIC_GPP_H_22 0x26
#define GPIO_VER1_N_IOAPIC_GPP_H_23 0x27

#define GPIO_VER1_N_IOAPIC_GPP_D_00 0x28
#define GPIO_VER1_N_IOAPIC_GPP_D_01 0x29
#define GPIO_VER1_N_IOAPIC_GPP_D_02 0x2a
#define GPIO_VER1_N_IOAPIC_GPP_D_03 0x2b
#define GPIO_VER1_N_IOAPIC_GPP_D_04 0x2c
#define GPIO_VER1_N_IOAPIC_GPP_D_05 0x2d
#define GPIO_VER1_N_IOAPIC_GPP_D_06 0x2e
#define GPIO_VER1_N_IOAPIC_GPP_D_07 0x2f
#define GPIO_VER1_N_IOAPIC_GPP_D_08 0x30
#define GPIO_VER1_N_IOAPIC_GPP_D_09 0x31
#define GPIO_VER1_N_IOAPIC_GPP_D_10 0x32
#define GPIO_VER1_N_IOAPIC_GPP_D_11 0x33
#define GPIO_VER1_N_IOAPIC_GPP_D_12 0x34
#define GPIO_VER1_N_IOAPIC_GPP_D_13 0x35
#define GPIO_VER1_N_IOAPIC_GPP_D_14 0x36
#define GPIO_VER1_N_IOAPIC_GPP_D_15 0x37
#define GPIO_VER1_N_IOAPIC_GPP_D_16 0x38
#define GPIO_VER1_N_IOAPIC_GPP_D_17 0x39
#define GPIO_VER1_N_IOAPIC_GPP_D_18 0x3a
#define GPIO_VER1_N_IOAPIC_GPP_D_19 0x3b
#define GPIO_VER1_N_IOAPIC_GPP_D_20 0x3c
#define GPIO_VER1_N_IOAPIC_GPP_D_21 0x3d
#define GPIO_VER1_N_IOAPIC_GPP_D_22 0x3e
#define GPIO_VER1_N_IOAPIC_GPP_D_23 0x3f

#define GPIO_VER1_N_IOAPIC_VGPIO_04 0x58
#define GPIO_VER1_N_IOAPIC_VGPIO_39 0x59

#define GPIO_VER1_N_IOAPIC_GPP_C_00 0x5a
#define GPIO_VER1_N_IOAPIC_GPP_C_01 0x5b
#define GPIO_VER1_N_IOAPIC_GPP_C_02 0x5c
#define GPIO_VER1_N_IOAPIC_GPP_C_03 0x5d
#define GPIO_VER1_N_IOAPIC_GPP_C_04 0x5e
#define GPIO_VER1_N_IOAPIC_GPP_C_05 0x5f
#define GPIO_VER1_N_IOAPIC_GPP_C_06 0x60
#define GPIO_VER1_N_IOAPIC_GPP_C_07 0x61
#define GPIO_VER1_N_IOAPIC_GPP_C_08 0x62
#define GPIO_VER1_N_IOAPIC_GPP_C_09 0x63
#define GPIO_VER1_N_IOAPIC_GPP_C_10 0x64
#define GPIO_VER1_N_IOAPIC_GPP_C_11 0x65
#define GPIO_VER1_N_IOAPIC_GPP_C_12 0x66
#define GPIO_VER1_N_IOAPIC_GPP_C_13 0x67
#define GPIO_VER1_N_IOAPIC_GPP_C_14 0x68
#define GPIO_VER1_N_IOAPIC_GPP_C_15 0x69
#define GPIO_VER1_N_IOAPIC_GPP_C_16 0x6a
#define GPIO_VER1_N_IOAPIC_GPP_C_17 0x6b
#define GPIO_VER1_N_IOAPIC_GPP_C_18 0x6c
#define GPIO_VER1_N_IOAPIC_GPP_C_19 0x6d
#define GPIO_VER1_N_IOAPIC_GPP_C_20 0x6e
#define GPIO_VER1_N_IOAPIC_GPP_C_21 0x6f
#define GPIO_VER1_N_IOAPIC_GPP_C_22 0x70
#define GPIO_VER1_N_IOAPIC_GPP_C_23 0x71

#define GPIO_VER1_N_IOAPIC_GPP_E_00 0x72
#define GPIO_VER1_N_IOAPIC_GPP_E_01 0x73
#define GPIO_VER1_N_IOAPIC_GPP_E_02 0x74
#define GPIO_VER1_N_IOAPIC_GPP_E_03 0x75
#define GPIO_VER1_N_IOAPIC_GPP_E_04 0x76
#define GPIO_VER1_N_IOAPIC_GPP_E_05 0x77
#define GPIO_VER1_N_IOAPIC_GPP_E_06 0x18
#define GPIO_VER1_N_IOAPIC_GPP_E_07 0x19
#define GPIO_VER1_N_IOAPIC_GPP_E_08 0x1a
#define GPIO_VER1_N_IOAPIC_GPP_E_09 0x1b
#define GPIO_VER1_N_IOAPIC_GPP_E_10 0x1c
#define GPIO_VER1_N_IOAPIC_GPP_E_11 0x1d
#define GPIO_VER1_N_IOAPIC_GPP_E_12 0x1e
#define GPIO_VER1_N_IOAPIC_GPP_E_13 0x1f
#define GPIO_VER1_N_IOAPIC_GPP_E_14 0x20
#define GPIO_VER1_N_IOAPIC_GPP_E_15 0x21
#define GPIO_VER1_N_IOAPIC_GPP_E_16 0x22
#define GPIO_VER1_N_IOAPIC_GPP_E_17 0x23
#define GPIO_VER1_N_IOAPIC_GPP_E_18 0x24
#define GPIO_VER1_N_IOAPIC_GPP_E_19 0x25
#define GPIO_VER1_N_IOAPIC_GPP_E_20 0x26
#define GPIO_VER1_N_IOAPIC_GPP_E_21 0x27
#define GPIO_VER1_N_IOAPIC_GPP_E_22 0x28
#define GPIO_VER1_N_IOAPIC_GPP_E_23 0x29

#define GPIO_VER1_1_N_IOAPIC_GPP_F_00 0x40
#define GPIO_VER1_1_N_IOAPIC_GPP_F_01 0x41
#define GPIO_VER1_1_N_IOAPIC_GPP_F_02 0x42
#define GPIO_VER1_1_N_IOAPIC_GPP_F_03 0x43
#define GPIO_VER1_1_N_IOAPIC_GPP_F_04 0x44
#define GPIO_VER1_1_N_IOAPIC_GPP_F_05 0x45
#define GPIO_VER1_1_N_IOAPIC_GPP_F_06 0x46
#define GPIO_VER1_1_N_IOAPIC_GPP_F_07 0x47
#define GPIO_VER1_1_N_IOAPIC_GPP_F_08 0x48
#define GPIO_VER1_1_N_IOAPIC_GPP_F_09 0x49
#define GPIO_VER1_1_N_IOAPIC_GPP_F_10 0x4A
#define GPIO_VER1_1_N_IOAPIC_GPP_F_11 0x4B
#define GPIO_VER1_1_N_IOAPIC_GPP_F_12 0x4C
#define GPIO_VER1_1_N_IOAPIC_GPP_F_13 0x4D
#define GPIO_VER1_1_N_IOAPIC_GPP_F_14 0x4E
#define GPIO_VER1_1_N_IOAPIC_GPP_F_15 0x4F
#define GPIO_VER1_1_N_IOAPIC_GPP_F_16 0x50
#define GPIO_VER1_1_N_IOAPIC_GPP_F_17 0x51
#define GPIO_VER1_1_N_IOAPIC_GPP_F_18 0x52
#define GPIO_VER1_1_N_IOAPIC_GPP_F_19 0x53

#define GPIO_VER1_H_DRIVER_GPP_A0   0
#define GPIO_VER1_H_DRIVER_GPP_A1   1
#define GPIO_VER1_H_DRIVER_GPP_A2   2
#define GPIO_VER1_H_DRIVER_GPP_A3   3
#define GPIO_VER1_H_DRIVER_GPP_A4   4
#define GPIO_VER1_H_DRIVER_GPP_A5   5
#define GPIO_VER1_H_DRIVER_GPP_A6   6
#define GPIO_VER1_H_DRIVER_GPP_A7   7
#define GPIO_VER1_H_DRIVER_GPP_A8   8
#define GPIO_VER1_H_DRIVER_GPP_A9   9
#define GPIO_VER1_H_DRIVER_GPP_A10  10
#define GPIO_VER1_H_DRIVER_GPP_A11  11
#define GPIO_VER1_H_DRIVER_GPP_A12  12
#define GPIO_VER1_H_DRIVER_GPP_A13  13
#define GPIO_VER1_H_DRIVER_GPP_A14  14
#define GPIO_VER1_H_DRIVER_GPP_A15  15
#define GPIO_VER1_H_DRIVER_GPP_A16  16
#define GPIO_VER1_H_DRIVER_GPP_A17  17
#define GPIO_VER1_H_DRIVER_GPP_A18  18
#define GPIO_VER1_H_DRIVER_GPP_A19  19
#define GPIO_VER1_H_DRIVER_GPP_A20  20
#define GPIO_VER1_H_DRIVER_GPP_A21  21
#define GPIO_VER1_H_DRIVER_GPP_A22  22
#define GPIO_VER1_H_DRIVER_GPP_A23  23

#define GPIO_VER1_H_DRIVER_GPP_B0   32
#define GPIO_VER1_H_DRIVER_GPP_B1   33
#define GPIO_VER1_H_DRIVER_GPP_B2   34
#define GPIO_VER1_H_DRIVER_GPP_B3   35
#define GPIO_VER1_H_DRIVER_GPP_B4   36
#define GPIO_VER1_H_DRIVER_GPP_B5   37
#define GPIO_VER1_H_DRIVER_GPP_B6   38
#define GPIO_VER1_H_DRIVER_GPP_B7   39
#define GPIO_VER1_H_DRIVER_GPP_B8   40
#define GPIO_VER1_H_DRIVER_GPP_B9   41
#define GPIO_VER1_H_DRIVER_GPP_B10  42
#define GPIO_VER1_H_DRIVER_GPP_B11  43
#define GPIO_VER1_H_DRIVER_GPP_B12  44
#define GPIO_VER1_H_DRIVER_GPP_B13  45
#define GPIO_VER1_H_DRIVER_GPP_B14  46
#define GPIO_VER1_H_DRIVER_GPP_B15  47
#define GPIO_VER1_H_DRIVER_GPP_B16  48
#define GPIO_VER1_H_DRIVER_GPP_B17  49
#define GPIO_VER1_H_DRIVER_GPP_B18  50
#define GPIO_VER1_H_DRIVER_GPP_B19  51
#define GPIO_VER1_H_DRIVER_GPP_B20  52
#define GPIO_VER1_H_DRIVER_GPP_B21  53
#define GPIO_VER1_H_DRIVER_GPP_B22  54
#define GPIO_VER1_H_DRIVER_GPP_B23  55

#define GPIO_VER1_H_DRIVER_GPP_C0   64
#define GPIO_VER1_H_DRIVER_GPP_C1   65
#define GPIO_VER1_H_DRIVER_GPP_C2   66
#define GPIO_VER1_H_DRIVER_GPP_C3   67
#define GPIO_VER1_H_DRIVER_GPP_C4   68
#define GPIO_VER1_H_DRIVER_GPP_C5   69
#define GPIO_VER1_H_DRIVER_GPP_C6   70
#define GPIO_VER1_H_DRIVER_GPP_C7   71
#define GPIO_VER1_H_DRIVER_GPP_C8   72
#define GPIO_VER1_H_DRIVER_GPP_C9   73
#define GPIO_VER1_H_DRIVER_GPP_C10  74
#define GPIO_VER1_H_DRIVER_GPP_C11  75
#define GPIO_VER1_H_DRIVER_GPP_C12  76
#define GPIO_VER1_H_DRIVER_GPP_C13  77
#define GPIO_VER1_H_DRIVER_GPP_C14  78
#define GPIO_VER1_H_DRIVER_GPP_C15  79
#define GPIO_VER1_H_DRIVER_GPP_C16  80
#define GPIO_VER1_H_DRIVER_GPP_C17  81
#define GPIO_VER1_H_DRIVER_GPP_C18  82
#define GPIO_VER1_H_DRIVER_GPP_C19  83
#define GPIO_VER1_H_DRIVER_GPP_C20  84
#define GPIO_VER1_H_DRIVER_GPP_C21  85
#define GPIO_VER1_H_DRIVER_GPP_C22  86
#define GPIO_VER1_H_DRIVER_GPP_C23  87

#define GPIO_VER1_H_DRIVER_GPP_D0   96
#define GPIO_VER1_H_DRIVER_GPP_D1   97
#define GPIO_VER1_H_DRIVER_GPP_D2   98
#define GPIO_VER1_H_DRIVER_GPP_D3   99
#define GPIO_VER1_H_DRIVER_GPP_D4   100
#define GPIO_VER1_H_DRIVER_GPP_D5   101
#define GPIO_VER1_H_DRIVER_GPP_D6   102
#define GPIO_VER1_H_DRIVER_GPP_D7   103
#define GPIO_VER1_H_DRIVER_GPP_D8   104
#define GPIO_VER1_H_DRIVER_GPP_D9   105
#define GPIO_VER1_H_DRIVER_GPP_D10  106
#define GPIO_VER1_H_DRIVER_GPP_D11  107
#define GPIO_VER1_H_DRIVER_GPP_D12  108
#define GPIO_VER1_H_DRIVER_GPP_D13  109
#define GPIO_VER1_H_DRIVER_GPP_D14  110
#define GPIO_VER1_H_DRIVER_GPP_D15  111

#define GPIO_VER1_H_DRIVER_GPP_E0   256
#define GPIO_VER1_H_DRIVER_GPP_E1   257
#define GPIO_VER1_H_DRIVER_GPP_E2   258
#define GPIO_VER1_H_DRIVER_GPP_E3   259
#define GPIO_VER1_H_DRIVER_GPP_E4   260
#define GPIO_VER1_H_DRIVER_GPP_E5   261
#define GPIO_VER1_H_DRIVER_GPP_E6   262
#define GPIO_VER1_H_DRIVER_GPP_E7   263
#define GPIO_VER1_H_DRIVER_GPP_E8   264
#define GPIO_VER1_H_DRIVER_GPP_E9   265
#define GPIO_VER1_H_DRIVER_GPP_E10  266
#define GPIO_VER1_H_DRIVER_GPP_E11  267
#define GPIO_VER1_H_DRIVER_GPP_E12  268

#define GPIO_VER1_H_DRIVER_GPP_F0   288
#define GPIO_VER1_H_DRIVER_GPP_F1   289
#define GPIO_VER1_H_DRIVER_GPP_F2   290
#define GPIO_VER1_H_DRIVER_GPP_F3   291
#define GPIO_VER1_H_DRIVER_GPP_F4   292
#define GPIO_VER1_H_DRIVER_GPP_F5   293
#define GPIO_VER1_H_DRIVER_GPP_F6   294
#define GPIO_VER1_H_DRIVER_GPP_F7   295
#define GPIO_VER1_H_DRIVER_GPP_F8   296
#define GPIO_VER1_H_DRIVER_GPP_F9   297
#define GPIO_VER1_H_DRIVER_GPP_F10  298
#define GPIO_VER1_H_DRIVER_GPP_F11  299
#define GPIO_VER1_H_DRIVER_GPP_F12  300
#define GPIO_VER1_H_DRIVER_GPP_F13  301
#define GPIO_VER1_H_DRIVER_GPP_F14  302
#define GPIO_VER1_H_DRIVER_GPP_F15  303
#define GPIO_VER1_H_DRIVER_GPP_F16  304
#define GPIO_VER1_H_DRIVER_GPP_F17  305
#define GPIO_VER1_H_DRIVER_GPP_F18  306
#define GPIO_VER1_H_DRIVER_GPP_F19  307
#define GPIO_VER1_H_DRIVER_GPP_F20  308
#define GPIO_VER1_H_DRIVER_GPP_F21  309
#define GPIO_VER1_H_DRIVER_GPP_F22  310
#define GPIO_VER1_H_DRIVER_GPP_F23  311

#define GPIO_VER1_H_DRIVER_GPP_G0   192
#define GPIO_VER1_H_DRIVER_GPP_G1   193
#define GPIO_VER1_H_DRIVER_GPP_G2   194
#define GPIO_VER1_H_DRIVER_GPP_G3   195
#define GPIO_VER1_H_DRIVER_GPP_G4   196
#define GPIO_VER1_H_DRIVER_GPP_G5   197
#define GPIO_VER1_H_DRIVER_GPP_G6   198
#define GPIO_VER1_H_DRIVER_GPP_G7   199
#define GPIO_VER1_H_DRIVER_GPP_G8   200
#define GPIO_VER1_H_DRIVER_GPP_G9   201
#define GPIO_VER1_H_DRIVER_GPP_G10  202
#define GPIO_VER1_H_DRIVER_GPP_G11  203
#define GPIO_VER1_H_DRIVER_GPP_G12  204
#define GPIO_VER1_H_DRIVER_GPP_G13  205
#define GPIO_VER1_H_DRIVER_GPP_G14  206
#define GPIO_VER1_H_DRIVER_GPP_G15  207

#define GPIO_VER1_H_DRIVER_GPP_H0   320
#define GPIO_VER1_H_DRIVER_GPP_H1   321
#define GPIO_VER1_H_DRIVER_GPP_H2   322
#define GPIO_VER1_H_DRIVER_GPP_H3   323
#define GPIO_VER1_H_DRIVER_GPP_H4   324
#define GPIO_VER1_H_DRIVER_GPP_H5   325
#define GPIO_VER1_H_DRIVER_GPP_H6   326
#define GPIO_VER1_H_DRIVER_GPP_H7   327
#define GPIO_VER1_H_DRIVER_GPP_H8   328
#define GPIO_VER1_H_DRIVER_GPP_H9   329
#define GPIO_VER1_H_DRIVER_GPP_H10  330
#define GPIO_VER1_H_DRIVER_GPP_H11  331
#define GPIO_VER1_H_DRIVER_GPP_H12  332
#define GPIO_VER1_H_DRIVER_GPP_H13  333
#define GPIO_VER1_H_DRIVER_GPP_H14  334
#define GPIO_VER1_H_DRIVER_GPP_H15  335
#define GPIO_VER1_H_DRIVER_GPP_H16  336
#define GPIO_VER1_H_DRIVER_GPP_H17  337
#define GPIO_VER1_H_DRIVER_GPP_H18  338
#define GPIO_VER1_H_DRIVER_GPP_H19  339
#define GPIO_VER1_H_DRIVER_GPP_H20  340
#define GPIO_VER1_H_DRIVER_GPP_H21  341
#define GPIO_VER1_H_DRIVER_GPP_H22  342
#define GPIO_VER1_H_DRIVER_GPP_H23  343

#define GPIO_VER1_H_DRIVER_GPP_I0   416
#define GPIO_VER1_H_DRIVER_GPP_I1   417
#define GPIO_VER1_H_DRIVER_GPP_I2   418
#define GPIO_VER1_H_DRIVER_GPP_I3   419
#define GPIO_VER1_H_DRIVER_GPP_I4   420
#define GPIO_VER1_H_DRIVER_GPP_I5   421
#define GPIO_VER1_H_DRIVER_GPP_I6   422
#define GPIO_VER1_H_DRIVER_GPP_I7   423
#define GPIO_VER1_H_DRIVER_GPP_I8   424
#define GPIO_VER1_H_DRIVER_GPP_I9   425
#define GPIO_VER1_H_DRIVER_GPP_I10  426
#define GPIO_VER1_H_DRIVER_GPP_I11  427
#define GPIO_VER1_H_DRIVER_GPP_I12  428
#define GPIO_VER1_H_DRIVER_GPP_I13  429
#define GPIO_VER1_H_DRIVER_GPP_I14  430

#define GPIO_VER1_H_DRIVER_GPP_J0   384
#define GPIO_VER1_H_DRIVER_GPP_J1   385
#define GPIO_VER1_H_DRIVER_GPP_J2   386
#define GPIO_VER1_H_DRIVER_GPP_J3   387
#define GPIO_VER1_H_DRIVER_GPP_J4   388
#define GPIO_VER1_H_DRIVER_GPP_J5   389
#define GPIO_VER1_H_DRIVER_GPP_J6   390
#define GPIO_VER1_H_DRIVER_GPP_J7   391
#define GPIO_VER1_H_DRIVER_GPP_J8   392
#define GPIO_VER1_H_DRIVER_GPP_J9   393

#define GPIO_VER1_H_DRIVER_GPP_K0   352
#define GPIO_VER1_H_DRIVER_GPP_K1   353
#define GPIO_VER1_H_DRIVER_GPP_K2   354
#define GPIO_VER1_H_DRIVER_GPP_K3   355
#define GPIO_VER1_H_DRIVER_GPP_K4   356
#define GPIO_VER1_H_DRIVER_GPP_K5   357
#define GPIO_VER1_H_DRIVER_GPP_K6   358
#define GPIO_VER1_H_DRIVER_GPP_K7   359
#define GPIO_VER1_H_DRIVER_GPP_K8   360
#define GPIO_VER1_H_DRIVER_GPP_K9   361
#define GPIO_VER1_H_DRIVER_GPP_K10  362
#define GPIO_VER1_H_DRIVER_GPP_K11  363

#define GPIO_VER1_H_DRIVER_GPP_R0   128
#define GPIO_VER1_H_DRIVER_GPP_R1   129
#define GPIO_VER1_H_DRIVER_GPP_R2   130
#define GPIO_VER1_H_DRIVER_GPP_R3   131
#define GPIO_VER1_H_DRIVER_GPP_R4   132
#define GPIO_VER1_H_DRIVER_GPP_R5   133
#define GPIO_VER1_H_DRIVER_GPP_R6   134
#define GPIO_VER1_H_DRIVER_GPP_R7   135

#define GPIO_VER1_H_DRIVER_GPP_S0   160
#define GPIO_VER1_H_DRIVER_GPP_S1   161
#define GPIO_VER1_H_DRIVER_GPP_S2   162
#define GPIO_VER1_H_DRIVER_GPP_S3   163
#define GPIO_VER1_H_DRIVER_GPP_S4   164
#define GPIO_VER1_H_DRIVER_GPP_S5   165
#define GPIO_VER1_H_DRIVER_GPP_S6   166
#define GPIO_VER1_H_DRIVER_GPP_S7   167

#define GPIO_VER1_H_DRIVER_VGPIO0   224
#define GPIO_VER1_H_DRIVER_VGPIO3   225
#define GPIO_VER1_H_DRIVER_VGPIO4   226
#define GPIO_VER1_H_DRIVER_VGPIO5   227
#define GPIO_VER1_H_DRIVER_VGPIO6   228
#define GPIO_VER1_H_DRIVER_VGPIO7   229
#define GPIO_VER1_H_DRIVER_VGPIO8   230
#define GPIO_VER1_H_DRIVER_VGPIO9   231
#define GPIO_VER1_H_DRIVER_VGPIO10  232
#define GPIO_VER1_H_DRIVER_VGPIO11  233
#define GPIO_VER1_H_DRIVER_VGPIO12  234
#define GPIO_VER1_H_DRIVER_VGPIO13  235
#define GPIO_VER1_H_DRIVER_VGPIO18  236
#define GPIO_VER1_H_DRIVER_VGPIO19  237
#define GPIO_VER1_H_DRIVER_VGPIO20  238
#define GPIO_VER1_H_DRIVER_VGPIO21  239
#define GPIO_VER1_H_DRIVER_VGPIO22  240
#define GPIO_VER1_H_DRIVER_VGPIO23  241
#define GPIO_VER1_H_DRIVER_VGPIO24  242
#define GPIO_VER1_H_DRIVER_VGPIO25  243
#define GPIO_VER1_H_DRIVER_VGPIO30  244
#define GPIO_VER1_H_DRIVER_VGPIO31  245
#define GPIO_VER1_H_DRIVER_VGPIO32  246
#define GPIO_VER1_H_DRIVER_VGPIO33  247
#define GPIO_VER1_H_DRIVER_VGPIO34  248
#define GPIO_VER1_H_DRIVER_VGPIO35  249
#define GPIO_VER1_H_DRIVER_VGPIO36  250
#define GPIO_VER1_H_DRIVER_VGPIO37  251
#define GPIO_VER1_H_DRIVER_VGPIO39  252

#define GPIO_VER1_H_IOAPIC_GPP_A0   0x18
#define GPIO_VER1_H_IOAPIC_GPP_A1   0x19
#define GPIO_VER1_H_IOAPIC_GPP_A2   0x1A
#define GPIO_VER1_H_IOAPIC_GPP_A3   0x1B
#define GPIO_VER1_H_IOAPIC_GPP_A4   0x1C
#define GPIO_VER1_H_IOAPIC_GPP_A5   0x1D
#define GPIO_VER1_H_IOAPIC_GPP_A6   0x1E
#define GPIO_VER1_H_IOAPIC_GPP_A7   0x1F
#define GPIO_VER1_H_IOAPIC_GPP_A8   0x20
#define GPIO_VER1_H_IOAPIC_GPP_A9   0x21
#define GPIO_VER1_H_IOAPIC_GPP_A10  0x22
#define GPIO_VER1_H_IOAPIC_GPP_A11  0x23
#define GPIO_VER1_H_IOAPIC_GPP_A12  0x24
#define GPIO_VER1_H_IOAPIC_GPP_A13  0x25
#define GPIO_VER1_H_IOAPIC_GPP_A14  0x26
#define GPIO_VER1_H_IOAPIC_GPP_A15  0x27
#define GPIO_VER1_H_IOAPIC_GPP_A16  0x28
#define GPIO_VER1_H_IOAPIC_GPP_A17  0x29
#define GPIO_VER1_H_IOAPIC_GPP_A18  0x2A
#define GPIO_VER1_H_IOAPIC_GPP_A19  0x2B
#define GPIO_VER1_H_IOAPIC_GPP_A20  0x2C
#define GPIO_VER1_H_IOAPIC_GPP_A21  0x2D
#define GPIO_VER1_H_IOAPIC_GPP_A22  0x2E
#define GPIO_VER1_H_IOAPIC_GPP_A23  0x2F
#define GPIO_VER1_H_IOAPIC_GPP_B0   0x30
#define GPIO_VER1_H_IOAPIC_GPP_B1   0x31
#define GPIO_VER1_H_IOAPIC_GPP_B2   0x32
#define GPIO_VER1_H_IOAPIC_GPP_B3   0x33
#define GPIO_VER1_H_IOAPIC_GPP_B4   0x34
#define GPIO_VER1_H_IOAPIC_GPP_B5   0x35
#define GPIO_VER1_H_IOAPIC_GPP_B6   0x36
#define GPIO_VER1_H_IOAPIC_GPP_B7   0x37
#define GPIO_VER1_H_IOAPIC_GPP_B8   0x38
#define GPIO_VER1_H_IOAPIC_GPP_B9   0x39
#define GPIO_VER1_H_IOAPIC_GPP_B10  0x3A
#define GPIO_VER1_H_IOAPIC_GPP_B11  0x3B
#define GPIO_VER1_H_IOAPIC_GPP_B12  0x3C
#define GPIO_VER1_H_IOAPIC_GPP_B13  0x3D
#define GPIO_VER1_H_IOAPIC_GPP_B14  0x3E
#define GPIO_VER1_H_IOAPIC_GPP_B15  0x3F
#define GPIO_VER1_H_IOAPIC_GPP_B16  0x40
#define GPIO_VER1_H_IOAPIC_GPP_B17  0x41
#define GPIO_VER1_H_IOAPIC_GPP_B18  0x42
#define GPIO_VER1_H_IOAPIC_GPP_B19  0x43
#define GPIO_VER1_H_IOAPIC_GPP_B20  0x44
#define GPIO_VER1_H_IOAPIC_GPP_B21  0x45
#define GPIO_VER1_H_IOAPIC_GPP_B22  0x46
#define GPIO_VER1_H_IOAPIC_GPP_B23  0x47
#define GPIO_VER1_H_IOAPIC_GPP_C0   0x48
#define GPIO_VER1_H_IOAPIC_GPP_C1   0x49
#define GPIO_VER1_H_IOAPIC_GPP_C2   0x4A
#define GPIO_VER1_H_IOAPIC_GPP_C3   0x4B
#define GPIO_VER1_H_IOAPIC_GPP_C4   0x4C
#define GPIO_VER1_H_IOAPIC_GPP_C5   0x4D
#define GPIO_VER1_H_IOAPIC_GPP_C6   0x4E
#define GPIO_VER1_H_IOAPIC_GPP_C7   0x4F
#define GPIO_VER1_H_IOAPIC_GPP_C8   0x50
#define GPIO_VER1_H_IOAPIC_GPP_C9   0x51
#define GPIO_VER1_H_IOAPIC_GPP_C10  0x52
#define GPIO_VER1_H_IOAPIC_GPP_C11  0x53
#define GPIO_VER1_H_IOAPIC_GPP_C12  0x54
#define GPIO_VER1_H_IOAPIC_GPP_C13  0x55
#define GPIO_VER1_H_IOAPIC_GPP_C14  0x56
#define GPIO_VER1_H_IOAPIC_GPP_C15  0x57
#define GPIO_VER1_H_IOAPIC_GPP_C16  0x58
#define GPIO_VER1_H_IOAPIC_GPP_C17  0x59
#define GPIO_VER1_H_IOAPIC_GPP_C18  0x5A
#define GPIO_VER1_H_IOAPIC_GPP_C19  0x5B
#define GPIO_VER1_H_IOAPIC_GPP_C20  0x5C
#define GPIO_VER1_H_IOAPIC_GPP_C21  0x5D
#define GPIO_VER1_H_IOAPIC_GPP_C22  0x5E
#define GPIO_VER1_H_IOAPIC_GPP_C23  0x5F
#define GPIO_VER1_H_IOAPIC_GPP_D0   0x60
#define GPIO_VER1_H_IOAPIC_GPP_D1   0x61
#define GPIO_VER1_H_IOAPIC_GPP_D2   0x62
#define GPIO_VER1_H_IOAPIC_GPP_D3   0x63
#define GPIO_VER1_H_IOAPIC_GPP_D4   0x64
#define GPIO_VER1_H_IOAPIC_GPP_D5   0x65
#define GPIO_VER1_H_IOAPIC_GPP_D6   0x66
#define GPIO_VER1_H_IOAPIC_GPP_D7   0x67
#define GPIO_VER1_H_IOAPIC_GPP_D8   0x68
#define GPIO_VER1_H_IOAPIC_GPP_D9   0x69
#define GPIO_VER1_H_IOAPIC_GPP_D10  0x6A
#define GPIO_VER1_H_IOAPIC_GPP_D11  0x6B
#define GPIO_VER1_H_IOAPIC_GPP_D12  0x6C
#define GPIO_VER1_H_IOAPIC_GPP_D13  0x6D
#define GPIO_VER1_H_IOAPIC_GPP_D14  0x6E
#define GPIO_VER1_H_IOAPIC_GPP_D15  0x6F
#define GPIO_VER1_H_IOAPIC_GPP_E0   0x2E
#define GPIO_VER1_H_IOAPIC_GPP_E1   0x2F
#define GPIO_VER1_H_IOAPIC_GPP_E2   0x30
#define GPIO_VER1_H_IOAPIC_GPP_E3   0x31
#define GPIO_VER1_H_IOAPIC_GPP_E4   0x32
#define GPIO_VER1_H_IOAPIC_GPP_E5   0x33
#define GPIO_VER1_H_IOAPIC_GPP_E6   0x34
#define GPIO_VER1_H_IOAPIC_GPP_E7   0x35
#define GPIO_VER1_H_IOAPIC_GPP_E8   0x36
#define GPIO_VER1_H_IOAPIC_GPP_E9   0x37
#define GPIO_VER1_H_IOAPIC_GPP_E10  0x38
#define GPIO_VER1_H_IOAPIC_GPP_E11  0x39
#define GPIO_VER1_H_IOAPIC_GPP_E12  0x3A
#define GPIO_VER1_H_IOAPIC_GPP_F0   0x3B
#define GPIO_VER1_H_IOAPIC_GPP_F1   0x3C
#define GPIO_VER1_H_IOAPIC_GPP_F2   0x3D
#define GPIO_VER1_H_IOAPIC_GPP_F3   0x3E
#define GPIO_VER1_H_IOAPIC_GPP_F4   0x3F
#define GPIO_VER1_H_IOAPIC_GPP_F5   0x40
#define GPIO_VER1_H_IOAPIC_GPP_F6   0x41
#define GPIO_VER1_H_IOAPIC_GPP_F7   0x42
#define GPIO_VER1_H_IOAPIC_GPP_F8   0x43
#define GPIO_VER1_H_IOAPIC_GPP_F9   0x44
#define GPIO_VER1_H_IOAPIC_GPP_F10  0x45
#define GPIO_VER1_H_IOAPIC_GPP_F11  0x46
#define GPIO_VER1_H_IOAPIC_GPP_F12  0x47
#define GPIO_VER1_H_IOAPIC_GPP_F13  0x48
#define GPIO_VER1_H_IOAPIC_GPP_F14  0x49
#define GPIO_VER1_H_IOAPIC_GPP_F15  0x4A
#define GPIO_VER1_H_IOAPIC_GPP_F16  0x4B
#define GPIO_VER1_H_IOAPIC_GPP_F17  0x4C
#define GPIO_VER1_H_IOAPIC_GPP_F18  0x4D
#define GPIO_VER1_H_IOAPIC_GPP_F19  0x4E
#define GPIO_VER1_H_IOAPIC_GPP_F20  0x4F
#define GPIO_VER1_H_IOAPIC_GPP_F21  0x50
#define GPIO_VER1_H_IOAPIC_GPP_F22  0x51
#define GPIO_VER1_H_IOAPIC_GPP_F23  0x52
#define GPIO_VER1_H_IOAPIC_GPP_G0   0x70
#define GPIO_VER1_H_IOAPIC_GPP_G1   0x71
#define GPIO_VER1_H_IOAPIC_GPP_G2   0x72
#define GPIO_VER1_H_IOAPIC_GPP_G3   0x73
#define GPIO_VER1_H_IOAPIC_GPP_G4   0x74
#define GPIO_VER1_H_IOAPIC_GPP_G5   0x75
#define GPIO_VER1_H_IOAPIC_GPP_G6   0x76
#define GPIO_VER1_H_IOAPIC_GPP_G7   0x77
#define GPIO_VER1_H_IOAPIC_GPP_G8   0x18
#define GPIO_VER1_H_IOAPIC_GPP_G9   0x19
#define GPIO_VER1_H_IOAPIC_GPP_G10  0x1A
#define GPIO_VER1_H_IOAPIC_GPP_G11  0x1B
#define GPIO_VER1_H_IOAPIC_GPP_G12  0x1C
#define GPIO_VER1_H_IOAPIC_GPP_G13  0x1D
#define GPIO_VER1_H_IOAPIC_GPP_G14  0x1E
#define GPIO_VER1_H_IOAPIC_GPP_G15  0x1F
#define GPIO_VER1_H_IOAPIC_GPP_H0   0x53
#define GPIO_VER1_H_IOAPIC_GPP_H1   0x54
#define GPIO_VER1_H_IOAPIC_GPP_H2   0x55
#define GPIO_VER1_H_IOAPIC_GPP_H3   0x56
#define GPIO_VER1_H_IOAPIC_GPP_H4   0x57
#define GPIO_VER1_H_IOAPIC_GPP_H5   0x58
#define GPIO_VER1_H_IOAPIC_GPP_H6   0x59
#define GPIO_VER1_H_IOAPIC_GPP_H7   0x5A
#define GPIO_VER1_H_IOAPIC_GPP_H8   0x5B
#define GPIO_VER1_H_IOAPIC_GPP_H9   0x5C
#define GPIO_VER1_H_IOAPIC_GPP_H10  0x5D
#define GPIO_VER1_H_IOAPIC_GPP_H11  0x5E
#define GPIO_VER1_H_IOAPIC_GPP_H12  0x5F
#define GPIO_VER1_H_IOAPIC_GPP_H13  0x60
#define GPIO_VER1_H_IOAPIC_GPP_H14  0x61
#define GPIO_VER1_H_IOAPIC_GPP_H15  0x62
#define GPIO_VER1_H_IOAPIC_GPP_H16  0x63
#define GPIO_VER1_H_IOAPIC_GPP_H17  0x64
#define GPIO_VER1_H_IOAPIC_GPP_H18  0x65
#define GPIO_VER1_H_IOAPIC_GPP_H19  0x66
#define GPIO_VER1_H_IOAPIC_GPP_H20  0x67
#define GPIO_VER1_H_IOAPIC_GPP_H21  0x68
#define GPIO_VER1_H_IOAPIC_GPP_H22  0x69
#define GPIO_VER1_H_IOAPIC_GPP_H23  0x6A
#define GPIO_VER1_H_IOAPIC_GPP_I0   0x22
#define GPIO_VER1_H_IOAPIC_GPP_I1   0x23
#define GPIO_VER1_H_IOAPIC_GPP_I2   0x24
#define GPIO_VER1_H_IOAPIC_GPP_I3   0x25
#define GPIO_VER1_H_IOAPIC_GPP_I4   0x26
#define GPIO_VER1_H_IOAPIC_GPP_I5   0x27
#define GPIO_VER1_H_IOAPIC_GPP_I6   0x28
#define GPIO_VER1_H_IOAPIC_GPP_I7   0x29
#define GPIO_VER1_H_IOAPIC_GPP_I8   0x2A
#define GPIO_VER1_H_IOAPIC_GPP_I9   0x2B
#define GPIO_VER1_H_IOAPIC_GPP_I10  0x2C
#define GPIO_VER1_H_IOAPIC_GPP_I11  0x2D
#define GPIO_VER1_H_IOAPIC_GPP_I12  0x2E
#define GPIO_VER1_H_IOAPIC_GPP_I13  0x2F
#define GPIO_VER1_H_IOAPIC_GPP_I14  0x30
#define GPIO_VER1_H_IOAPIC_GPP_J0   0x18
#define GPIO_VER1_H_IOAPIC_GPP_J1   0x19
#define GPIO_VER1_H_IOAPIC_GPP_J2   0x1A
#define GPIO_VER1_H_IOAPIC_GPP_J3   0x1B
#define GPIO_VER1_H_IOAPIC_GPP_J4   0x1C
#define GPIO_VER1_H_IOAPIC_GPP_J5   0x1D
#define GPIO_VER1_H_IOAPIC_GPP_J6   0x1E
#define GPIO_VER1_H_IOAPIC_GPP_J7   0x1F
#define GPIO_VER1_H_IOAPIC_GPP_J8   0x20
#define GPIO_VER1_H_IOAPIC_GPP_J9   0x21
#define GPIO_VER1_H_IOAPIC_GPP_K0   0x6B
#define GPIO_VER1_H_IOAPIC_GPP_K1   0x6C
#define GPIO_VER1_H_IOAPIC_GPP_K2   0x6D
#define GPIO_VER1_H_IOAPIC_GPP_K3   0x6E
#define GPIO_VER1_H_IOAPIC_GPP_K4   0x6F
#define GPIO_VER1_H_IOAPIC_GPP_K5   0x70
#define GPIO_VER1_H_IOAPIC_GPP_K6   0x71
#define GPIO_VER1_H_IOAPIC_GPP_K7   0x72
#define GPIO_VER1_H_IOAPIC_GPP_K8   0x73
#define GPIO_VER1_H_IOAPIC_GPP_K9   0x74
#define GPIO_VER1_H_IOAPIC_GPP_K10  0x75
#define GPIO_VER1_H_IOAPIC_GPP_K11  0x76
#define GPIO_VER1_H_IOAPIC_GPP_R0   0x31
#define GPIO_VER1_H_IOAPIC_GPP_R1   0x32
#define GPIO_VER1_H_IOAPIC_GPP_R2   0x33
#define GPIO_VER1_H_IOAPIC_GPP_R3   0x34
#define GPIO_VER1_H_IOAPIC_GPP_R4   0x35
#define GPIO_VER1_H_IOAPIC_GPP_R5   0x36
#define GPIO_VER1_H_IOAPIC_GPP_R6   0x37
#define GPIO_VER1_H_IOAPIC_GPP_R7   0x38
#define GPIO_VER1_H_IOAPIC_GPP_S0   0x39
#define GPIO_VER1_H_IOAPIC_GPP_S1   0x3A
#define GPIO_VER1_H_IOAPIC_GPP_S2   0x3B
#define GPIO_VER1_H_IOAPIC_GPP_S3   0x3C
#define GPIO_VER1_H_IOAPIC_GPP_S4   0x3D
#define GPIO_VER1_H_IOAPIC_GPP_S5   0x3E
#define GPIO_VER1_H_IOAPIC_GPP_S6   0x3F
#define GPIO_VER1_H_IOAPIC_GPP_S7   0x40
#define GPIO_VER1_H_IOAPIC_VGPIO4   0x20
#define GPIO_VER1_H_IOAPIC_VGPIO39  0x21
#define GPIO_VER1_H_IOAPIC_GPD0     0x22
#define GPIO_VER1_H_IOAPIC_GPD1     0x23
#define GPIO_VER1_H_IOAPIC_GPD2     0x24
#define GPIO_VER1_H_IOAPIC_GPD3     0x25
#define GPIO_VER1_H_IOAPIC_GPD4     0x26
#define GPIO_VER1_H_IOAPIC_GPD5     0x27
#define GPIO_VER1_H_IOAPIC_GPD6     0x28
#define GPIO_VER1_H_IOAPIC_GPD7     0x29
#define GPIO_VER1_H_IOAPIC_GPD8     0x2A
#define GPIO_VER1_H_IOAPIC_GPD9     0x2B
#define GPIO_VER1_H_IOAPIC_GPD10    0x2C
#define GPIO_VER1_H_IOAPIC_GPD11    0x2D

#endif // _GPIO_ACPI_DEFINES_VER1_
