/**@file
 VER2 GPIO ASL header

@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

//
// Definition for GPIO groups and pads
//
#ifndef _GPIO_ACPI_DEFINES_VER2_
#define _GPIO_ACPI_DEFINES_VER2_

#include "Pins/GpioPinsVer2Lp.h"
#include "Pins/GpioPinsVer2H.h"

#define GPIO_VER2_LP_ACPI_HID "INT34C5"

//
// TGL-PCH-LP
//
#define GPIO_VER2_LP_DRIVER_GPP_B0  0
#define GPIO_VER2_LP_DRIVER_GPP_B1  1
#define GPIO_VER2_LP_DRIVER_GPP_B2  2
#define GPIO_VER2_LP_DRIVER_GPP_B3  3
#define GPIO_VER2_LP_DRIVER_GPP_B4  4
#define GPIO_VER2_LP_DRIVER_GPP_B5  5
#define GPIO_VER2_LP_DRIVER_GPP_B6  6
#define GPIO_VER2_LP_DRIVER_GPP_B7  7
#define GPIO_VER2_LP_DRIVER_GPP_B8  8
#define GPIO_VER2_LP_DRIVER_GPP_B9  9
#define GPIO_VER2_LP_DRIVER_GPP_B10 10
#define GPIO_VER2_LP_DRIVER_GPP_B11 11
#define GPIO_VER2_LP_DRIVER_GPP_B12 12
#define GPIO_VER2_LP_DRIVER_GPP_B13 13
#define GPIO_VER2_LP_DRIVER_GPP_B14 14
#define GPIO_VER2_LP_DRIVER_GPP_B15 15
#define GPIO_VER2_LP_DRIVER_GPP_B16 16
#define GPIO_VER2_LP_DRIVER_GPP_B17 17
#define GPIO_VER2_LP_DRIVER_GPP_B18 18
#define GPIO_VER2_LP_DRIVER_GPP_B19 19
#define GPIO_VER2_LP_DRIVER_GPP_B20 20
#define GPIO_VER2_LP_DRIVER_GPP_B21 21
#define GPIO_VER2_LP_DRIVER_GPP_B22 22
#define GPIO_VER2_LP_DRIVER_GPP_B23 23

#define GPIO_VER2_LP_DRIVER_GPP_T0  32
#define GPIO_VER2_LP_DRIVER_GPP_T1  33
#define GPIO_VER2_LP_DRIVER_GPP_T2  34
#define GPIO_VER2_LP_DRIVER_GPP_T3  35
#define GPIO_VER2_LP_DRIVER_GPP_T4  36
#define GPIO_VER2_LP_DRIVER_GPP_T5  37
#define GPIO_VER2_LP_DRIVER_GPP_T6  38
#define GPIO_VER2_LP_DRIVER_GPP_T7  39
#define GPIO_VER2_LP_DRIVER_GPP_T8  40
#define GPIO_VER2_LP_DRIVER_GPP_T9  41
#define GPIO_VER2_LP_DRIVER_GPP_T10 42
#define GPIO_VER2_LP_DRIVER_GPP_T11 43
#define GPIO_VER2_LP_DRIVER_GPP_T12 44
#define GPIO_VER2_LP_DRIVER_GPP_T13 45
#define GPIO_VER2_LP_DRIVER_GPP_T14 46
#define GPIO_VER2_LP_DRIVER_GPP_T15 47

#define GPIO_VER2_LP_DRIVER_GPP_A0  64
#define GPIO_VER2_LP_DRIVER_GPP_A1  65
#define GPIO_VER2_LP_DRIVER_GPP_A2  66
#define GPIO_VER2_LP_DRIVER_GPP_A3  67
#define GPIO_VER2_LP_DRIVER_GPP_A4  68
#define GPIO_VER2_LP_DRIVER_GPP_A5  69
#define GPIO_VER2_LP_DRIVER_GPP_A6  70
#define GPIO_VER2_LP_DRIVER_GPP_A7  71
#define GPIO_VER2_LP_DRIVER_GPP_A8  72
#define GPIO_VER2_LP_DRIVER_GPP_A9  73
#define GPIO_VER2_LP_DRIVER_GPP_A10 74
#define GPIO_VER2_LP_DRIVER_GPP_A11 75
#define GPIO_VER2_LP_DRIVER_GPP_A12 76
#define GPIO_VER2_LP_DRIVER_GPP_A13 77
#define GPIO_VER2_LP_DRIVER_GPP_A14 78
#define GPIO_VER2_LP_DRIVER_GPP_A15 79
#define GPIO_VER2_LP_DRIVER_GPP_A16 80
#define GPIO_VER2_LP_DRIVER_GPP_A17 81
#define GPIO_VER2_LP_DRIVER_GPP_A18 82
#define GPIO_VER2_LP_DRIVER_GPP_A19 83
#define GPIO_VER2_LP_DRIVER_GPP_A20 84
#define GPIO_VER2_LP_DRIVER_GPP_A21 85
#define GPIO_VER2_LP_DRIVER_GPP_A22 86
#define GPIO_VER2_LP_DRIVER_GPP_A23 87

#define GPIO_VER2_LP_DRIVER_GPP_R0  352
#define GPIO_VER2_LP_DRIVER_GPP_R1  353
#define GPIO_VER2_LP_DRIVER_GPP_R2  354
#define GPIO_VER2_LP_DRIVER_GPP_R3  355
#define GPIO_VER2_LP_DRIVER_GPP_R4  356
#define GPIO_VER2_LP_DRIVER_GPP_R5  357
#define GPIO_VER2_LP_DRIVER_GPP_R6  358
#define GPIO_VER2_LP_DRIVER_GPP_R7  359

#define GPIO_VER2_LP_DRIVER_GPP_S0  96
#define GPIO_VER2_LP_DRIVER_GPP_S1  97
#define GPIO_VER2_LP_DRIVER_GPP_S2  98
#define GPIO_VER2_LP_DRIVER_GPP_S3  99
#define GPIO_VER2_LP_DRIVER_GPP_S4  100
#define GPIO_VER2_LP_DRIVER_GPP_S5  101
#define GPIO_VER2_LP_DRIVER_GPP_S6  102
#define GPIO_VER2_LP_DRIVER_GPP_S7  103

#define GPIO_VER2_LP_DRIVER_GPP_H0  128
#define GPIO_VER2_LP_DRIVER_GPP_H1  129
#define GPIO_VER2_LP_DRIVER_GPP_H2  130
#define GPIO_VER2_LP_DRIVER_GPP_H3  131
#define GPIO_VER2_LP_DRIVER_GPP_H4  132
#define GPIO_VER2_LP_DRIVER_GPP_H5  133
#define GPIO_VER2_LP_DRIVER_GPP_H6  134
#define GPIO_VER2_LP_DRIVER_GPP_H7  135
#define GPIO_VER2_LP_DRIVER_GPP_H8  136
#define GPIO_VER2_LP_DRIVER_GPP_H9  137
#define GPIO_VER2_LP_DRIVER_GPP_H10 138
#define GPIO_VER2_LP_DRIVER_GPP_H11 139
#define GPIO_VER2_LP_DRIVER_GPP_H12 140
#define GPIO_VER2_LP_DRIVER_GPP_H13 141
#define GPIO_VER2_LP_DRIVER_GPP_H14 142
#define GPIO_VER2_LP_DRIVER_GPP_H15 143
#define GPIO_VER2_LP_DRIVER_GPP_H16 144
#define GPIO_VER2_LP_DRIVER_GPP_H17 145
#define GPIO_VER2_LP_DRIVER_GPP_H18 146
#define GPIO_VER2_LP_DRIVER_GPP_H19 147
#define GPIO_VER2_LP_DRIVER_GPP_H20 148
#define GPIO_VER2_LP_DRIVER_GPP_H21 149
#define GPIO_VER2_LP_DRIVER_GPP_H22 150
#define GPIO_VER2_LP_DRIVER_GPP_H23 151

#define GPIO_VER2_LP_DRIVER_GPP_D0  160
#define GPIO_VER2_LP_DRIVER_GPP_D1  161
#define GPIO_VER2_LP_DRIVER_GPP_D2  162
#define GPIO_VER2_LP_DRIVER_GPP_D3  163
#define GPIO_VER2_LP_DRIVER_GPP_D4  164
#define GPIO_VER2_LP_DRIVER_GPP_D5  165
#define GPIO_VER2_LP_DRIVER_GPP_D6  166
#define GPIO_VER2_LP_DRIVER_GPP_D7  167
#define GPIO_VER2_LP_DRIVER_GPP_D8  168
#define GPIO_VER2_LP_DRIVER_GPP_D9  169
#define GPIO_VER2_LP_DRIVER_GPP_D10 170
#define GPIO_VER2_LP_DRIVER_GPP_D11 171
#define GPIO_VER2_LP_DRIVER_GPP_D12 172
#define GPIO_VER2_LP_DRIVER_GPP_D13 173
#define GPIO_VER2_LP_DRIVER_GPP_D14 174
#define GPIO_VER2_LP_DRIVER_GPP_D15 175
#define GPIO_VER2_LP_DRIVER_GPP_D16 176
#define GPIO_VER2_LP_DRIVER_GPP_D17 177
#define GPIO_VER2_LP_DRIVER_GPP_D18 178
#define GPIO_VER2_LP_DRIVER_GPP_D19 179

#define GPIO_VER2_LP_DRIVER_GPP_U0  192
#define GPIO_VER2_LP_DRIVER_GPP_U1  193
#define GPIO_VER2_LP_DRIVER_GPP_U2  194
#define GPIO_VER2_LP_DRIVER_GPP_U3  195
#define GPIO_VER2_LP_DRIVER_GPP_U4  196
#define GPIO_VER2_LP_DRIVER_GPP_U5  197
#define GPIO_VER2_LP_DRIVER_GPP_U6  198
#define GPIO_VER2_LP_DRIVER_GPP_U7  199
#define GPIO_VER2_LP_DRIVER_GPP_U8  200
#define GPIO_VER2_LP_DRIVER_GPP_U9  201
#define GPIO_VER2_LP_DRIVER_GPP_U10 202
#define GPIO_VER2_LP_DRIVER_GPP_U11 203
#define GPIO_VER2_LP_DRIVER_GPP_U12 204
#define GPIO_VER2_LP_DRIVER_GPP_U13 205
#define GPIO_VER2_LP_DRIVER_GPP_U14 206
#define GPIO_VER2_LP_DRIVER_GPP_U15 207
#define GPIO_VER2_LP_DRIVER_GPP_U16 208
#define GPIO_VER2_LP_DRIVER_GPP_U17 209
#define GPIO_VER2_LP_DRIVER_GPP_U18 210
#define GPIO_VER2_LP_DRIVER_GPP_U19 211

#define GPIO_VER2_LP_DRIVER_VGPIO0  224
#define GPIO_VER2_LP_DRIVER_VGPIO4  225
#define GPIO_VER2_LP_DRIVER_VGPIO5  226
#define GPIO_VER2_LP_DRIVER_VGPIO6  227
#define GPIO_VER2_LP_DRIVER_VGPIO7  228
#define GPIO_VER2_LP_DRIVER_VGPIO8  229
#define GPIO_VER2_LP_DRIVER_VGPIO9  230
#define GPIO_VER2_LP_DRIVER_VGPIO10 231
#define GPIO_VER2_LP_DRIVER_VGPIO11 232
#define GPIO_VER2_LP_DRIVER_VGPIO12 233
#define GPIO_VER2_LP_DRIVER_VGPIO13 234
#define GPIO_VER2_LP_DRIVER_VGPIO18 235
#define GPIO_VER2_LP_DRIVER_VGPIO19 236
#define GPIO_VER2_LP_DRIVER_VGPIO20 237
#define GPIO_VER2_LP_DRIVER_VGPIO21 238
#define GPIO_VER2_LP_DRIVER_VGPIO22 239
#define GPIO_VER2_LP_DRIVER_VGPIO23 240
#define GPIO_VER2_LP_DRIVER_VGPIO24 241
#define GPIO_VER2_LP_DRIVER_VGPIO25 242
#define GPIO_VER2_LP_DRIVER_VGPIO30 243
#define GPIO_VER2_LP_DRIVER_VGPIO31 244
#define GPIO_VER2_LP_DRIVER_VGPIO32 245
#define GPIO_VER2_LP_DRIVER_VGPIO33 246
#define GPIO_VER2_LP_DRIVER_VGPIO34 247
#define GPIO_VER2_LP_DRIVER_VGPIO35 248
#define GPIO_VER2_LP_DRIVER_VGPIO36 249
#define GPIO_VER2_LP_DRIVER_VGPIO37 250

#define GPIO_VER2_LP_DRIVER_GPP_C0  256
#define GPIO_VER2_LP_DRIVER_GPP_C1  257
#define GPIO_VER2_LP_DRIVER_GPP_C2  258
#define GPIO_VER2_LP_DRIVER_GPP_C3  259
#define GPIO_VER2_LP_DRIVER_GPP_C4  260
#define GPIO_VER2_LP_DRIVER_GPP_C5  261
#define GPIO_VER2_LP_DRIVER_GPP_C6  262
#define GPIO_VER2_LP_DRIVER_GPP_C7  263
#define GPIO_VER2_LP_DRIVER_GPP_C8  264
#define GPIO_VER2_LP_DRIVER_GPP_C9  265
#define GPIO_VER2_LP_DRIVER_GPP_C10 266
#define GPIO_VER2_LP_DRIVER_GPP_C11 267
#define GPIO_VER2_LP_DRIVER_GPP_C12 268
#define GPIO_VER2_LP_DRIVER_GPP_C13 269
#define GPIO_VER2_LP_DRIVER_GPP_C14 270
#define GPIO_VER2_LP_DRIVER_GPP_C15 271
#define GPIO_VER2_LP_DRIVER_GPP_C16 272
#define GPIO_VER2_LP_DRIVER_GPP_C17 273
#define GPIO_VER2_LP_DRIVER_GPP_C18 274
#define GPIO_VER2_LP_DRIVER_GPP_C19 275
#define GPIO_VER2_LP_DRIVER_GPP_C20 276
#define GPIO_VER2_LP_DRIVER_GPP_C21 277
#define GPIO_VER2_LP_DRIVER_GPP_C22 278
#define GPIO_VER2_LP_DRIVER_GPP_C23 279

#define GPIO_VER2_LP_DRIVER_GPP_F0  288
#define GPIO_VER2_LP_DRIVER_GPP_F1  289
#define GPIO_VER2_LP_DRIVER_GPP_F2  290
#define GPIO_VER2_LP_DRIVER_GPP_F3  291
#define GPIO_VER2_LP_DRIVER_GPP_F4  292
#define GPIO_VER2_LP_DRIVER_GPP_F5  293
#define GPIO_VER2_LP_DRIVER_GPP_F6  294
#define GPIO_VER2_LP_DRIVER_GPP_F7  295
#define GPIO_VER2_LP_DRIVER_GPP_F8  296
#define GPIO_VER2_LP_DRIVER_GPP_F9  297
#define GPIO_VER2_LP_DRIVER_GPP_F10 298
#define GPIO_VER2_LP_DRIVER_GPP_F11 299
#define GPIO_VER2_LP_DRIVER_GPP_F12 300
#define GPIO_VER2_LP_DRIVER_GPP_F13 301
#define GPIO_VER2_LP_DRIVER_GPP_F14 302
#define GPIO_VER2_LP_DRIVER_GPP_F15 303
#define GPIO_VER2_LP_DRIVER_GPP_F16 304
#define GPIO_VER2_LP_DRIVER_GPP_F17 305
#define GPIO_VER2_LP_DRIVER_GPP_F18 306
#define GPIO_VER2_LP_DRIVER_GPP_F19 307
#define GPIO_VER2_LP_DRIVER_GPP_F20 308
#define GPIO_VER2_LP_DRIVER_GPP_F21 309
#define GPIO_VER2_LP_DRIVER_GPP_F22 310
#define GPIO_VER2_LP_DRIVER_GPP_F23 311

#define GPIO_VER2_LP_DRIVER_GPP_E0  320
#define GPIO_VER2_LP_DRIVER_GPP_E1  321
#define GPIO_VER2_LP_DRIVER_GPP_E2  322
#define GPIO_VER2_LP_DRIVER_GPP_E3  323
#define GPIO_VER2_LP_DRIVER_GPP_E4  324
#define GPIO_VER2_LP_DRIVER_GPP_E5  325
#define GPIO_VER2_LP_DRIVER_GPP_E6  326
#define GPIO_VER2_LP_DRIVER_GPP_E7  327
#define GPIO_VER2_LP_DRIVER_GPP_E8  328
#define GPIO_VER2_LP_DRIVER_GPP_E9  329
#define GPIO_VER2_LP_DRIVER_GPP_E10 330
#define GPIO_VER2_LP_DRIVER_GPP_E11 331
#define GPIO_VER2_LP_DRIVER_GPP_E12 332
#define GPIO_VER2_LP_DRIVER_GPP_E13 333
#define GPIO_VER2_LP_DRIVER_GPP_E14 334
#define GPIO_VER2_LP_DRIVER_GPP_E15 335
#define GPIO_VER2_LP_DRIVER_GPP_E16 336
#define GPIO_VER2_LP_DRIVER_GPP_E17 337
#define GPIO_VER2_LP_DRIVER_GPP_E18 338
#define GPIO_VER2_LP_DRIVER_GPP_E19 339
#define GPIO_VER2_LP_DRIVER_GPP_E20 340
#define GPIO_VER2_LP_DRIVER_GPP_E21 341
#define GPIO_VER2_LP_DRIVER_GPP_E22 342
#define GPIO_VER2_LP_DRIVER_GPP_E23 343

#define GPIO_VER2_LP_IOAPIC_GPP_B0  0x18
#define GPIO_VER2_LP_IOAPIC_GPP_B1  0x19
#define GPIO_VER2_LP_IOAPIC_GPP_B2  0x1A
#define GPIO_VER2_LP_IOAPIC_GPP_B3  0x1B
#define GPIO_VER2_LP_IOAPIC_GPP_B4  0x1C
#define GPIO_VER2_LP_IOAPIC_GPP_B5  0x1D
#define GPIO_VER2_LP_IOAPIC_GPP_B6  0x1E
#define GPIO_VER2_LP_IOAPIC_GPP_B7  0x1F
#define GPIO_VER2_LP_IOAPIC_GPP_B8  0x20
#define GPIO_VER2_LP_IOAPIC_GPP_B9  0x21
#define GPIO_VER2_LP_IOAPIC_GPP_B10 0x22
#define GPIO_VER2_LP_IOAPIC_GPP_B11 0x23
#define GPIO_VER2_LP_IOAPIC_GPP_B12 0x24
#define GPIO_VER2_LP_IOAPIC_GPP_B13 0x25
#define GPIO_VER2_LP_IOAPIC_GPP_B14 0x26
#define GPIO_VER2_LP_IOAPIC_GPP_B15 0x27
#define GPIO_VER2_LP_IOAPIC_GPP_B16 0x28
#define GPIO_VER2_LP_IOAPIC_GPP_B17 0x29
#define GPIO_VER2_LP_IOAPIC_GPP_B18 0x2A
#define GPIO_VER2_LP_IOAPIC_GPP_B19 0x2B
#define GPIO_VER2_LP_IOAPIC_GPP_B20 0x2C
#define GPIO_VER2_LP_IOAPIC_GPP_B21 0x2D
#define GPIO_VER2_LP_IOAPIC_GPP_B22 0x2E
#define GPIO_VER2_LP_IOAPIC_GPP_B23 0x2F

#define GPIO_VER2_LP_IOAPIC_GPP_T0  0x30
#define GPIO_VER2_LP_IOAPIC_GPP_T1  0x31
#define GPIO_VER2_LP_IOAPIC_GPP_T2  0x32
#define GPIO_VER2_LP_IOAPIC_GPP_T3  0x33
#define GPIO_VER2_LP_IOAPIC_GPP_T4  0x34
#define GPIO_VER2_LP_IOAPIC_GPP_T5  0x35
#define GPIO_VER2_LP_IOAPIC_GPP_T6  0x36
#define GPIO_VER2_LP_IOAPIC_GPP_T7  0x37
#define GPIO_VER2_LP_IOAPIC_GPP_T8  0x38
#define GPIO_VER2_LP_IOAPIC_GPP_T9  0x39
#define GPIO_VER2_LP_IOAPIC_GPP_T10 0x3A
#define GPIO_VER2_LP_IOAPIC_GPP_T11 0x3B
#define GPIO_VER2_LP_IOAPIC_GPP_T12 0x3C
#define GPIO_VER2_LP_IOAPIC_GPP_T13 0x3D
#define GPIO_VER2_LP_IOAPIC_GPP_T14 0x3E
#define GPIO_VER2_LP_IOAPIC_GPP_T15 0x3F

#define GPIO_VER2_LP_IOAPIC_GPP_A0  0x40
#define GPIO_VER2_LP_IOAPIC_GPP_A1  0x41
#define GPIO_VER2_LP_IOAPIC_GPP_A2  0x42
#define GPIO_VER2_LP_IOAPIC_GPP_A3  0x43
#define GPIO_VER2_LP_IOAPIC_GPP_A4  0x44
#define GPIO_VER2_LP_IOAPIC_GPP_A5  0x45
#define GPIO_VER2_LP_IOAPIC_GPP_A6  0x46
#define GPIO_VER2_LP_IOAPIC_GPP_A7  0x47
#define GPIO_VER2_LP_IOAPIC_GPP_A8  0x48
#define GPIO_VER2_LP_IOAPIC_GPP_A9  0x49
#define GPIO_VER2_LP_IOAPIC_GPP_A10 0x4A
#define GPIO_VER2_LP_IOAPIC_GPP_A11 0x4B
#define GPIO_VER2_LP_IOAPIC_GPP_A12 0x4C
#define GPIO_VER2_LP_IOAPIC_GPP_A13 0x4D
#define GPIO_VER2_LP_IOAPIC_GPP_A14 0x4E
#define GPIO_VER2_LP_IOAPIC_GPP_A15 0x4F
#define GPIO_VER2_LP_IOAPIC_GPP_A16 0x50
#define GPIO_VER2_LP_IOAPIC_GPP_A17 0x51
#define GPIO_VER2_LP_IOAPIC_GPP_A18 0x52
#define GPIO_VER2_LP_IOAPIC_GPP_A19 0x53
#define GPIO_VER2_LP_IOAPIC_GPP_A20 0x54
#define GPIO_VER2_LP_IOAPIC_GPP_A21 0x55
#define GPIO_VER2_LP_IOAPIC_GPP_A22 0x56
#define GPIO_VER2_LP_IOAPIC_GPP_A23 0x57

#define GPIO_VER2_LP_IOAPIC_GPP_R0  0x58
#define GPIO_VER2_LP_IOAPIC_GPP_R1  0x59
#define GPIO_VER2_LP_IOAPIC_GPP_R2  0x5A
#define GPIO_VER2_LP_IOAPIC_GPP_R3  0x5B
#define GPIO_VER2_LP_IOAPIC_GPP_R4  0x5C
#define GPIO_VER2_LP_IOAPIC_GPP_R5  0x5D
#define GPIO_VER2_LP_IOAPIC_GPP_R6  0x5E
#define GPIO_VER2_LP_IOAPIC_GPP_R7  0x5F

#define GPIO_VER2_LP_IOAPIC_GPD0    0x60
#define GPIO_VER2_LP_IOAPIC_GPD1    0x61
#define GPIO_VER2_LP_IOAPIC_GPD2    0x62
#define GPIO_VER2_LP_IOAPIC_GPD3    0x63
#define GPIO_VER2_LP_IOAPIC_GPD4    0x64
#define GPIO_VER2_LP_IOAPIC_GPD5    0x65
#define GPIO_VER2_LP_IOAPIC_GPD6    0x66
#define GPIO_VER2_LP_IOAPIC_GPD7    0x67
#define GPIO_VER2_LP_IOAPIC_GPD8    0x68
#define GPIO_VER2_LP_IOAPIC_GPD9    0x69
#define GPIO_VER2_LP_IOAPIC_GPD10   0x6A
#define GPIO_VER2_LP_IOAPIC_GPD11   0x6B

#define GPIO_VER2_LP_IOAPIC_GPP_S0  0x6C
#define GPIO_VER2_LP_IOAPIC_GPP_S1  0x6D
#define GPIO_VER2_LP_IOAPIC_GPP_S2  0x6E
#define GPIO_VER2_LP_IOAPIC_GPP_S3  0x6F
#define GPIO_VER2_LP_IOAPIC_GPP_S4  0x70
#define GPIO_VER2_LP_IOAPIC_GPP_S5  0x71
#define GPIO_VER2_LP_IOAPIC_GPP_S6  0x72
#define GPIO_VER2_LP_IOAPIC_GPP_S7  0x73

#define GPIO_VER2_LP_IOAPIC_GPP_H0  0x74
#define GPIO_VER2_LP_IOAPIC_GPP_H1  0x75
#define GPIO_VER2_LP_IOAPIC_GPP_H2  0x76
#define GPIO_VER2_LP_IOAPIC_GPP_H3  0x77
#define GPIO_VER2_LP_IOAPIC_GPP_H4  0x18
#define GPIO_VER2_LP_IOAPIC_GPP_H5  0x19
#define GPIO_VER2_LP_IOAPIC_GPP_H6  0x1A
#define GPIO_VER2_LP_IOAPIC_GPP_H7  0x1B
#define GPIO_VER2_LP_IOAPIC_GPP_H8  0x1C
#define GPIO_VER2_LP_IOAPIC_GPP_H9  0x1D
#define GPIO_VER2_LP_IOAPIC_GPP_H10 0x1E
#define GPIO_VER2_LP_IOAPIC_GPP_H11 0x1F
#define GPIO_VER2_LP_IOAPIC_GPP_H12 0x20
#define GPIO_VER2_LP_IOAPIC_GPP_H13 0x21
#define GPIO_VER2_LP_IOAPIC_GPP_H14 0x22
#define GPIO_VER2_LP_IOAPIC_GPP_H15 0x23
#define GPIO_VER2_LP_IOAPIC_GPP_H16 0x24
#define GPIO_VER2_LP_IOAPIC_GPP_H17 0x25
#define GPIO_VER2_LP_IOAPIC_GPP_H18 0x26
#define GPIO_VER2_LP_IOAPIC_GPP_H19 0x27
#define GPIO_VER2_LP_IOAPIC_GPP_H20 0x28
#define GPIO_VER2_LP_IOAPIC_GPP_H21 0x29
#define GPIO_VER2_LP_IOAPIC_GPP_H22 0x2A
#define GPIO_VER2_LP_IOAPIC_GPP_H23 0x2B

#define GPIO_VER2_LP_IOAPIC_GPP_D0  0x2C
#define GPIO_VER2_LP_IOAPIC_GPP_D1  0x2D
#define GPIO_VER2_LP_IOAPIC_GPP_D2  0x2E
#define GPIO_VER2_LP_IOAPIC_GPP_D3  0x2F
#define GPIO_VER2_LP_IOAPIC_GPP_D4  0x30
#define GPIO_VER2_LP_IOAPIC_GPP_D5  0x31
#define GPIO_VER2_LP_IOAPIC_GPP_D6  0x32
#define GPIO_VER2_LP_IOAPIC_GPP_D7  0x33
#define GPIO_VER2_LP_IOAPIC_GPP_D8  0x34
#define GPIO_VER2_LP_IOAPIC_GPP_D9  0x35
#define GPIO_VER2_LP_IOAPIC_GPP_D10 0x36
#define GPIO_VER2_LP_IOAPIC_GPP_D11 0x37
#define GPIO_VER2_LP_IOAPIC_GPP_D12 0x38
#define GPIO_VER2_LP_IOAPIC_GPP_D13 0x39
#define GPIO_VER2_LP_IOAPIC_GPP_D14 0x3A
#define GPIO_VER2_LP_IOAPIC_GPP_D15 0x3B
#define GPIO_VER2_LP_IOAPIC_GPP_D16 0x3C
#define GPIO_VER2_LP_IOAPIC_GPP_D17 0x3D
#define GPIO_VER2_LP_IOAPIC_GPP_D18 0x3E
#define GPIO_VER2_LP_IOAPIC_GPP_D19 0x3F

#define GPIO_VER2_LP_IOAPIC_GPP_U0  0x40
#define GPIO_VER2_LP_IOAPIC_GPP_U1  0x41
#define GPIO_VER2_LP_IOAPIC_GPP_U2  0x42
#define GPIO_VER2_LP_IOAPIC_GPP_U3  0x43
#define GPIO_VER2_LP_IOAPIC_GPP_U4  0x44
#define GPIO_VER2_LP_IOAPIC_GPP_U5  0x45
#define GPIO_VER2_LP_IOAPIC_GPP_U6  0x46
#define GPIO_VER2_LP_IOAPIC_GPP_U7  0x47
#define GPIO_VER2_LP_IOAPIC_GPP_U8  0x48
#define GPIO_VER2_LP_IOAPIC_GPP_U9  0x49
#define GPIO_VER2_LP_IOAPIC_GPP_U10 0x4A
#define GPIO_VER2_LP_IOAPIC_GPP_U11 0x4B
#define GPIO_VER2_LP_IOAPIC_GPP_U12 0x4C
#define GPIO_VER2_LP_IOAPIC_GPP_U13 0x4D
#define GPIO_VER2_LP_IOAPIC_GPP_U14 0x4E
#define GPIO_VER2_LP_IOAPIC_GPP_U15 0x4F
#define GPIO_VER2_LP_IOAPIC_GPP_U16 0x50
#define GPIO_VER2_LP_IOAPIC_GPP_U17 0x51
#define GPIO_VER2_LP_IOAPIC_GPP_U18 0x52
#define GPIO_VER2_LP_IOAPIC_GPP_U19 0x53

#define GPIO_VER2_LP_IOAPIC_VGPIO4  0x54

#define GPIO_VER2_LP_IOAPIC_GPP_F0  0x56
#define GPIO_VER2_LP_IOAPIC_GPP_F1  0x57
#define GPIO_VER2_LP_IOAPIC_GPP_F2  0x58
#define GPIO_VER2_LP_IOAPIC_GPP_F3  0x59
#define GPIO_VER2_LP_IOAPIC_GPP_F4  0x5A
#define GPIO_VER2_LP_IOAPIC_GPP_F5  0x5B
#define GPIO_VER2_LP_IOAPIC_GPP_F6  0x5C
#define GPIO_VER2_LP_IOAPIC_GPP_F7  0x5D
#define GPIO_VER2_LP_IOAPIC_GPP_F8  0x5E
#define GPIO_VER2_LP_IOAPIC_GPP_F9  0x5F
#define GPIO_VER2_LP_IOAPIC_GPP_F10 0x60
#define GPIO_VER2_LP_IOAPIC_GPP_F11 0x61
#define GPIO_VER2_LP_IOAPIC_GPP_F12 0x62
#define GPIO_VER2_LP_IOAPIC_GPP_F13 0x63
#define GPIO_VER2_LP_IOAPIC_GPP_F14 0x64
#define GPIO_VER2_LP_IOAPIC_GPP_F15 0x65
#define GPIO_VER2_LP_IOAPIC_GPP_F16 0x66
#define GPIO_VER2_LP_IOAPIC_GPP_F17 0x67
#define GPIO_VER2_LP_IOAPIC_GPP_F18 0x68
#define GPIO_VER2_LP_IOAPIC_GPP_F19 0x69
#define GPIO_VER2_LP_IOAPIC_GPP_F20 0x6A
#define GPIO_VER2_LP_IOAPIC_GPP_F21 0x6B
#define GPIO_VER2_LP_IOAPIC_GPP_F22 0x6C
#define GPIO_VER2_LP_IOAPIC_GPP_F23 0x6D

#define GPIO_VER2_LP_IOAPIC_GPP_C0  0x6E
#define GPIO_VER2_LP_IOAPIC_GPP_C1  0x6F
#define GPIO_VER2_LP_IOAPIC_GPP_C2  0x70
#define GPIO_VER2_LP_IOAPIC_GPP_C3  0x71
#define GPIO_VER2_LP_IOAPIC_GPP_C4  0x72
#define GPIO_VER2_LP_IOAPIC_GPP_C5  0x73
#define GPIO_VER2_LP_IOAPIC_GPP_C6  0x74
#define GPIO_VER2_LP_IOAPIC_GPP_C7  0x75
#define GPIO_VER2_LP_IOAPIC_GPP_C8  0x76
#define GPIO_VER2_LP_IOAPIC_GPP_C9  0x77
#define GPIO_VER2_LP_IOAPIC_GPP_C10 0x18
#define GPIO_VER2_LP_IOAPIC_GPP_C11 0x19
#define GPIO_VER2_LP_IOAPIC_GPP_C12 0x1A
#define GPIO_VER2_LP_IOAPIC_GPP_C13 0x1B
#define GPIO_VER2_LP_IOAPIC_GPP_C14 0x1C
#define GPIO_VER2_LP_IOAPIC_GPP_C15 0x1D
#define GPIO_VER2_LP_IOAPIC_GPP_C16 0x1E
#define GPIO_VER2_LP_IOAPIC_GPP_C17 0x1F
#define GPIO_VER2_LP_IOAPIC_GPP_C18 0x20
#define GPIO_VER2_LP_IOAPIC_GPP_C19 0x21
#define GPIO_VER2_LP_IOAPIC_GPP_C20 0x22
#define GPIO_VER2_LP_IOAPIC_GPP_C21 0x23
#define GPIO_VER2_LP_IOAPIC_GPP_C22 0x24
#define GPIO_VER2_LP_IOAPIC_GPP_C23 0x25

#define GPIO_VER2_LP_IOAPIC_GPP_E0  0x26
#define GPIO_VER2_LP_IOAPIC_GPP_E1  0x27
#define GPIO_VER2_LP_IOAPIC_GPP_E2  0x28
#define GPIO_VER2_LP_IOAPIC_GPP_E3  0x29
#define GPIO_VER2_LP_IOAPIC_GPP_E4  0x2A
#define GPIO_VER2_LP_IOAPIC_GPP_E5  0x2B
#define GPIO_VER2_LP_IOAPIC_GPP_E6  0x2C
#define GPIO_VER2_LP_IOAPIC_GPP_E7  0x2D
#define GPIO_VER2_LP_IOAPIC_GPP_E8  0x2E
#define GPIO_VER2_LP_IOAPIC_GPP_E9  0x2F
#define GPIO_VER2_LP_IOAPIC_GPP_E10 0x30
#define GPIO_VER2_LP_IOAPIC_GPP_E11 0x31
#define GPIO_VER2_LP_IOAPIC_GPP_E12 0x32
#define GPIO_VER2_LP_IOAPIC_GPP_E13 0x33
#define GPIO_VER2_LP_IOAPIC_GPP_E14 0x34
#define GPIO_VER2_LP_IOAPIC_GPP_E15 0x35
#define GPIO_VER2_LP_IOAPIC_GPP_E16 0x36
#define GPIO_VER2_LP_IOAPIC_GPP_E17 0x37
#define GPIO_VER2_LP_IOAPIC_GPP_E18 0x38
#define GPIO_VER2_LP_IOAPIC_GPP_E19 0x39
#define GPIO_VER2_LP_IOAPIC_GPP_E20 0x3A
#define GPIO_VER2_LP_IOAPIC_GPP_E21 0x3B
#define GPIO_VER2_LP_IOAPIC_GPP_E22 0x3C
#define GPIO_VER2_LP_IOAPIC_GPP_E23 0x3D

//
// TGL-PCH-H
//
#define GPIO_VER2_H_DRIVER_GPP_A0             0
#define GPIO_VER2_H_DRIVER_GPP_A1             1
#define GPIO_VER2_H_DRIVER_GPP_A2             2
#define GPIO_VER2_H_DRIVER_GPP_A3             3
#define GPIO_VER2_H_DRIVER_GPP_A4             4
#define GPIO_VER2_H_DRIVER_GPP_A5             5
#define GPIO_VER2_H_DRIVER_GPP_A6             6
#define GPIO_VER2_H_DRIVER_GPP_A7             7
#define GPIO_VER2_H_DRIVER_GPP_A8             8
#define GPIO_VER2_H_DRIVER_GPP_A9             9
#define GPIO_VER2_H_DRIVER_GPP_A10            10
#define GPIO_VER2_H_DRIVER_GPP_A11            11
#define GPIO_VER2_H_DRIVER_GPP_A12            12
#define GPIO_VER2_H_DRIVER_GPP_A13            13
#define GPIO_VER2_H_DRIVER_GPP_A14            14

#define GPIO_VER2_H_DRIVER_GPP_R0             32
#define GPIO_VER2_H_DRIVER_GPP_R1             33
#define GPIO_VER2_H_DRIVER_GPP_R2             34
#define GPIO_VER2_H_DRIVER_GPP_R3             35
#define GPIO_VER2_H_DRIVER_GPP_R4             36
#define GPIO_VER2_H_DRIVER_GPP_R5             37
#define GPIO_VER2_H_DRIVER_GPP_R6             38
#define GPIO_VER2_H_DRIVER_GPP_R7             39
#define GPIO_VER2_H_DRIVER_GPP_R8             40
#define GPIO_VER2_H_DRIVER_GPP_R9             41
#define GPIO_VER2_H_DRIVER_GPP_R10            42
#define GPIO_VER2_H_DRIVER_GPP_R11            43
#define GPIO_VER2_H_DRIVER_GPP_R12            44
#define GPIO_VER2_H_DRIVER_GPP_R13            45
#define GPIO_VER2_H_DRIVER_GPP_R14            46
#define GPIO_VER2_H_DRIVER_GPP_R15            47
#define GPIO_VER2_H_DRIVER_GPP_R16            48
#define GPIO_VER2_H_DRIVER_GPP_R17            49
#define GPIO_VER2_H_DRIVER_GPP_R18            50
#define GPIO_VER2_H_DRIVER_GPP_R19            51

#define GPIO_VER2_H_DRIVER_GPP_B0             64
#define GPIO_VER2_H_DRIVER_GPP_B1             65
#define GPIO_VER2_H_DRIVER_GPP_B2             66
#define GPIO_VER2_H_DRIVER_GPP_B3             67
#define GPIO_VER2_H_DRIVER_GPP_B4             68
#define GPIO_VER2_H_DRIVER_GPP_B5             69
#define GPIO_VER2_H_DRIVER_GPP_B6             70
#define GPIO_VER2_H_DRIVER_GPP_B7             71
#define GPIO_VER2_H_DRIVER_GPP_B8             72
#define GPIO_VER2_H_DRIVER_GPP_B9             73
#define GPIO_VER2_H_DRIVER_GPP_B10            74
#define GPIO_VER2_H_DRIVER_GPP_B11            75
#define GPIO_VER2_H_DRIVER_GPP_B12            76
#define GPIO_VER2_H_DRIVER_GPP_B13            77
#define GPIO_VER2_H_DRIVER_GPP_B14            78
#define GPIO_VER2_H_DRIVER_GPP_B15            79
#define GPIO_VER2_H_DRIVER_GPP_B16            80
#define GPIO_VER2_H_DRIVER_GPP_B17            81
#define GPIO_VER2_H_DRIVER_GPP_B18            82
#define GPIO_VER2_H_DRIVER_GPP_B19            83
#define GPIO_VER2_H_DRIVER_GPP_B20            84
#define GPIO_VER2_H_DRIVER_GPP_B21            85
#define GPIO_VER2_H_DRIVER_GPP_B22            86
#define GPIO_VER2_H_DRIVER_GPP_B23            87

#define GPIO_VER2_H_DRIVER_GPP_VGPIO_0_0      96
#define GPIO_VER2_H_DRIVER_GPP_VGPIO_0_1      97
#define GPIO_VER2_H_DRIVER_GPP_VGPIO_0_2      98
#define GPIO_VER2_H_DRIVER_GPP_VGPIO_0_3      99
#define GPIO_VER2_H_DRIVER_GPP_VGPIO_0_4      100
#define GPIO_VER2_H_DRIVER_GPP_VGPIO_0_5      101
#define GPIO_VER2_H_DRIVER_GPP_VGPIO_0_6      102
#define GPIO_VER2_H_DRIVER_GPP_VGPIO_0_7      103

#define GPIO_VER2_H_DRIVER_GPP_D0             128
#define GPIO_VER2_H_DRIVER_GPP_D1             129
#define GPIO_VER2_H_DRIVER_GPP_D2             130
#define GPIO_VER2_H_DRIVER_GPP_D3             131
#define GPIO_VER2_H_DRIVER_GPP_D4             132
#define GPIO_VER2_H_DRIVER_GPP_D5             133
#define GPIO_VER2_H_DRIVER_GPP_D6             134
#define GPIO_VER2_H_DRIVER_GPP_D7             135
#define GPIO_VER2_H_DRIVER_GPP_D8             136
#define GPIO_VER2_H_DRIVER_GPP_D9             137
#define GPIO_VER2_H_DRIVER_GPP_D10            138
#define GPIO_VER2_H_DRIVER_GPP_D11            139
#define GPIO_VER2_H_DRIVER_GPP_D12            140
#define GPIO_VER2_H_DRIVER_GPP_D13            141
#define GPIO_VER2_H_DRIVER_GPP_D14            142
#define GPIO_VER2_H_DRIVER_GPP_D15            143
#define GPIO_VER2_H_DRIVER_GPP_D16            144
#define GPIO_VER2_H_DRIVER_GPP_D17            145
#define GPIO_VER2_H_DRIVER_GPP_D18            146
#define GPIO_VER2_H_DRIVER_GPP_D19            147
#define GPIO_VER2_H_DRIVER_GPP_D20            148
#define GPIO_VER2_H_DRIVER_GPP_D21            149
#define GPIO_VER2_H_DRIVER_GPP_D22            150
#define GPIO_VER2_H_DRIVER_GPP_D23            151

#define GPIO_VER2_H_DRIVER_GPP_C0             160
#define GPIO_VER2_H_DRIVER_GPP_C1             161
#define GPIO_VER2_H_DRIVER_GPP_C2             162
#define GPIO_VER2_H_DRIVER_GPP_C3             163
#define GPIO_VER2_H_DRIVER_GPP_C4             164
#define GPIO_VER2_H_DRIVER_GPP_C5             165
#define GPIO_VER2_H_DRIVER_GPP_C6             166
#define GPIO_VER2_H_DRIVER_GPP_C7             167
#define GPIO_VER2_H_DRIVER_GPP_C8             168
#define GPIO_VER2_H_DRIVER_GPP_C9             169
#define GPIO_VER2_H_DRIVER_GPP_C10            170
#define GPIO_VER2_H_DRIVER_GPP_C11            171
#define GPIO_VER2_H_DRIVER_GPP_C12            172
#define GPIO_VER2_H_DRIVER_GPP_C13            173
#define GPIO_VER2_H_DRIVER_GPP_C14            174
#define GPIO_VER2_H_DRIVER_GPP_C15            175
#define GPIO_VER2_H_DRIVER_GPP_C16            176
#define GPIO_VER2_H_DRIVER_GPP_C17            177
#define GPIO_VER2_H_DRIVER_GPP_C18            178
#define GPIO_VER2_H_DRIVER_GPP_C19            179
#define GPIO_VER2_H_DRIVER_GPP_C20            180
#define GPIO_VER2_H_DRIVER_GPP_C21            181
#define GPIO_VER2_H_DRIVER_GPP_C22            182
#define GPIO_VER2_H_DRIVER_GPP_C23            183

#define GPIO_VER2_H_DRIVER_GPP_S0             192
#define GPIO_VER2_H_DRIVER_GPP_S1             193
#define GPIO_VER2_H_DRIVER_GPP_S2             194
#define GPIO_VER2_H_DRIVER_GPP_S3             195
#define GPIO_VER2_H_DRIVER_GPP_S4             196
#define GPIO_VER2_H_DRIVER_GPP_S5             197
#define GPIO_VER2_H_DRIVER_GPP_S6             198
#define GPIO_VER2_H_DRIVER_GPP_S7             199

#define GPIO_VER2_H_DRIVER_GPP_G0             224
#define GPIO_VER2_H_DRIVER_GPP_G1             225
#define GPIO_VER2_H_DRIVER_GPP_G2             226
#define GPIO_VER2_H_DRIVER_GPP_G3             227
#define GPIO_VER2_H_DRIVER_GPP_G4             228
#define GPIO_VER2_H_DRIVER_GPP_G5             229
#define GPIO_VER2_H_DRIVER_GPP_G6             230
#define GPIO_VER2_H_DRIVER_GPP_G7             231
#define GPIO_VER2_H_DRIVER_GPP_G8             232
#define GPIO_VER2_H_DRIVER_GPP_G9             233
#define GPIO_VER2_H_DRIVER_GPP_G10            234
#define GPIO_VER2_H_DRIVER_GPP_G11            235
#define GPIO_VER2_H_DRIVER_GPP_G12            236
#define GPIO_VER2_H_DRIVER_GPP_G13            237
#define GPIO_VER2_H_DRIVER_GPP_G14            238
#define GPIO_VER2_H_DRIVER_GPP_G15            239

#define GPIO_VER2_H_DRIVER_VGPIO0             256
#define GPIO_VER2_H_DRIVER_VGPIO4             257
#define GPIO_VER2_H_DRIVER_VGPIO5             258
#define GPIO_VER2_H_DRIVER_VGPIO6             259
#define GPIO_VER2_H_DRIVER_VGPIO7             260
#define GPIO_VER2_H_DRIVER_VGPIO8             261
#define GPIO_VER2_H_DRIVER_VGPIO9             262
#define GPIO_VER2_H_DRIVER_VGPIO10            263
#define GPIO_VER2_H_DRIVER_VGPIO11            264
#define GPIO_VER2_H_DRIVER_VGPIO12            265
#define GPIO_VER2_H_DRIVER_VGPIO13            266
#define GPIO_VER2_H_DRIVER_VGPIO18            267
#define GPIO_VER2_H_DRIVER_VGPIO19            268
#define GPIO_VER2_H_DRIVER_VGPIO20            269
#define GPIO_VER2_H_DRIVER_VGPIO21            270
#define GPIO_VER2_H_DRIVER_VGPIO22            271
#define GPIO_VER2_H_DRIVER_VGPIO23            272
#define GPIO_VER2_H_DRIVER_VGPIO24            273
#define GPIO_VER2_H_DRIVER_VGPIO25            274
#define GPIO_VER2_H_DRIVER_VGPIO30            275
#define GPIO_VER2_H_DRIVER_VGPIO31            276
#define GPIO_VER2_H_DRIVER_VGPIO32            277
#define GPIO_VER2_H_DRIVER_VGPIO33            278
#define GPIO_VER2_H_DRIVER_VGPIO34            279
#define GPIO_VER2_H_DRIVER_VGPIO35            280
#define GPIO_VER2_H_DRIVER_VGPIO36            281
#define GPIO_VER2_H_DRIVER_VGPIO37            282

#define GPIO_VER2_H_DRIVER_GPD_0              288
#define GPIO_VER2_H_DRIVER_GPD_1              289
#define GPIO_VER2_H_DRIVER_GPD_2              290
#define GPIO_VER2_H_DRIVER_GPD_3              290
#define GPIO_VER2_H_DRIVER_GPD_4              291
#define GPIO_VER2_H_DRIVER_GPD_5              292
#define GPIO_VER2_H_DRIVER_GPD_6              293
#define GPIO_VER2_H_DRIVER_GPD_7              294
#define GPIO_VER2_H_DRIVER_GPD_8              295
#define GPIO_VER2_H_DRIVER_GPD_9              296
#define GPIO_VER2_H_DRIVER_GPD_10             297
#define GPIO_VER2_H_DRIVER_GPD_11             298
#define GPIO_VER2_H_DRIVER_GPD_12             299

#define GPIO_VER2_H_DRIVER_GPP_E0             320
#define GPIO_VER2_H_DRIVER_GPP_E1             321
#define GPIO_VER2_H_DRIVER_GPP_E2             322
#define GPIO_VER2_H_DRIVER_GPP_E3             323
#define GPIO_VER2_H_DRIVER_GPP_E4             324
#define GPIO_VER2_H_DRIVER_GPP_E5             325
#define GPIO_VER2_H_DRIVER_GPP_E6             326
#define GPIO_VER2_H_DRIVER_GPP_E7             327
#define GPIO_VER2_H_DRIVER_GPP_E8             328
#define GPIO_VER2_H_DRIVER_GPP_E9             329
#define GPIO_VER2_H_DRIVER_GPP_E10            330
#define GPIO_VER2_H_DRIVER_GPP_E11            331
#define GPIO_VER2_H_DRIVER_GPP_E12            332

#define GPIO_VER2_H_DRIVER_GPP_F0             352
#define GPIO_VER2_H_DRIVER_GPP_F1             353
#define GPIO_VER2_H_DRIVER_GPP_F2             354
#define GPIO_VER2_H_DRIVER_GPP_F3             355
#define GPIO_VER2_H_DRIVER_GPP_F4             356
#define GPIO_VER2_H_DRIVER_GPP_F5             357
#define GPIO_VER2_H_DRIVER_GPP_F6             358
#define GPIO_VER2_H_DRIVER_GPP_F7             359
#define GPIO_VER2_H_DRIVER_GPP_F8             360
#define GPIO_VER2_H_DRIVER_GPP_F9             361
#define GPIO_VER2_H_DRIVER_GPP_F10            362
#define GPIO_VER2_H_DRIVER_GPP_F11            363
#define GPIO_VER2_H_DRIVER_GPP_F12            364
#define GPIO_VER2_H_DRIVER_GPP_F13            365
#define GPIO_VER2_H_DRIVER_GPP_F14            366
#define GPIO_VER2_H_DRIVER_GPP_F15            367
#define GPIO_VER2_H_DRIVER_GPP_F16            368
#define GPIO_VER2_H_DRIVER_GPP_F17            369
#define GPIO_VER2_H_DRIVER_GPP_F18            370
#define GPIO_VER2_H_DRIVER_GPP_F19            371
#define GPIO_VER2_H_DRIVER_GPP_F20            372
#define GPIO_VER2_H_DRIVER_GPP_F21            373
#define GPIO_VER2_H_DRIVER_GPP_F22            374
#define GPIO_VER2_H_DRIVER_GPP_F23            375

#define GPIO_VER2_H_DRIVER_VGPIO_3_0          384
#define GPIO_VER2_H_DRIVER_VGPIO_3_1          385
#define GPIO_VER2_H_DRIVER_VGPIO_3_2          386
#define GPIO_VER2_H_DRIVER_VGPIO_3_3          387
#define GPIO_VER2_H_DRIVER_VGPIO_3_4          388
#define GPIO_VER2_H_DRIVER_VGPIO_3_5          389
#define GPIO_VER2_H_DRIVER_VGPIO_3_6          390
#define GPIO_VER2_H_DRIVER_VGPIO_3_7          391
#define GPIO_VER2_H_DRIVER_VGPIO_3_8          392
#define GPIO_VER2_H_DRIVER_VGPIO_3_9          393
#define GPIO_VER2_H_DRIVER_VGPIO_3_10         394
#define GPIO_VER2_H_DRIVER_VGPIO_3_11         395
#define GPIO_VER2_H_DRIVER_VGPIO_3_12         396
#define GPIO_VER2_H_DRIVER_VGPIO_3_13         397
#define GPIO_VER2_H_DRIVER_VGPIO_3_14         398
#define GPIO_VER2_H_DRIVER_VGPIO_3_15         399
#define GPIO_VER2_H_DRIVER_VGPIO_3_16         400
#define GPIO_VER2_H_DRIVER_VGPIO_3_17         401
#define GPIO_VER2_H_DRIVER_VGPIO_3_18         402
#define GPIO_VER2_H_DRIVER_VGPIO_3_19         403
#define GPIO_VER2_H_DRIVER_VGPIO_3_20         404
#define GPIO_VER2_H_DRIVER_VGPIO_3_21         405
#define GPIO_VER2_H_DRIVER_VGPIO_3_22         406
#define GPIO_VER2_H_DRIVER_VGPIO_3_23         407
#define GPIO_VER2_H_DRIVER_VGPIO_3_24         408
#define GPIO_VER2_H_DRIVER_VGPIO_3_25         409
#define GPIO_VER2_H_DRIVER_VGPIO_3_26         411
#define GPIO_VER2_H_DRIVER_VGPIO_3_27         412
#define GPIO_VER2_H_DRIVER_VGPIO_3_28         413
#define GPIO_VER2_H_DRIVER_VGPIO_3_29         414
#define GPIO_VER2_H_DRIVER_VGPIO_3_30         415
#define GPIO_VER2_H_DRIVER_VGPIO_3_31         416
#define GPIO_VER2_H_DRIVER_VGPIO_3_32         417
#define GPIO_VER2_H_DRIVER_VGPIO_3_33         418
#define GPIO_VER2_H_DRIVER_VGPIO_3_34         419
#define GPIO_VER2_H_DRIVER_VGPIO_3_35         420
#define GPIO_VER2_H_DRIVER_VGPIO_3_36         421
#define GPIO_VER2_H_DRIVER_VGPIO_3_37         422
#define GPIO_VER2_H_DRIVER_VGPIO_3_38         423
#define GPIO_VER2_H_DRIVER_VGPIO_3_39         424
#define GPIO_VER2_H_DRIVER_VGPIO_3_40         425
#define GPIO_VER2_H_DRIVER_VGPIO_3_41         426
#define GPIO_VER2_H_DRIVER_VGPIO_3_42         427
#define GPIO_VER2_H_DRIVER_VGPIO_3_43         428
#define GPIO_VER2_H_DRIVER_VGPIO_3_44         429
#define GPIO_VER2_H_DRIVER_VGPIO_3_45         430
#define GPIO_VER2_H_DRIVER_VGPIO_3_46         431
#define GPIO_VER2_H_DRIVER_VGPIO_3_47         432
#define GPIO_VER2_H_DRIVER_VGPIO_3_48         433
#define GPIO_VER2_H_DRIVER_VGPIO_3_49         434
#define GPIO_VER2_H_DRIVER_VGPIO_3_50         435
#define GPIO_VER2_H_DRIVER_VGPIO_3_51         436
#define GPIO_VER2_H_DRIVER_VGPIO_3_52         437
#define GPIO_VER2_H_DRIVER_VGPIO_3_53         438
#define GPIO_VER2_H_DRIVER_VGPIO_3_54         439
#define GPIO_VER2_H_DRIVER_VGPIO_3_55         440
#define GPIO_VER2_H_DRIVER_VGPIO_3_56         441
#define GPIO_VER2_H_DRIVER_VGPIO_3_57         442
#define GPIO_VER2_H_DRIVER_VGPIO_3_58         443
#define GPIO_VER2_H_DRIVER_VGPIO_3_59         444
#define GPIO_VER2_H_DRIVER_VGPIO_3_60         445
#define GPIO_VER2_H_DRIVER_VGPIO_3_61         446
#define GPIO_VER2_H_DRIVER_VGPIO_3_62         447
#define GPIO_VER2_H_DRIVER_VGPIO_3_63         448
#define GPIO_VER2_H_DRIVER_VGPIO_3_64         449
#define GPIO_VER2_H_DRIVER_VGPIO_3_65         450
#define GPIO_VER2_H_DRIVER_VGPIO_3_66         451
#define GPIO_VER2_H_DRIVER_VGPIO_3_67         452
#define GPIO_VER2_H_DRIVER_VGPIO_3_68         453
#define GPIO_VER2_H_DRIVER_VGPIO_3_69         454
#define GPIO_VER2_H_DRIVER_VGPIO_3_70         455
#define GPIO_VER2_H_DRIVER_VGPIO_3_71         456
#define GPIO_VER2_H_DRIVER_VGPIO_3_72         457
#define GPIO_VER2_H_DRIVER_VGPIO_3_73         458
#define GPIO_VER2_H_DRIVER_VGPIO_3_74         459
#define GPIO_VER2_H_DRIVER_VGPIO_3_75         460
#define GPIO_VER2_H_DRIVER_VGPIO_3_76         461
#define GPIO_VER2_H_DRIVER_VGPIO_3_77         462
#define GPIO_VER2_H_DRIVER_VGPIO_3_78         463
#define GPIO_VER2_H_DRIVER_VGPIO_3_79         464
#define GPIO_VER2_H_DRIVER_VGPIO_3_80         465
#define GPIO_VER2_H_DRIVER_VGPIO_3_81         466
#define GPIO_VER2_H_DRIVER_VGPIO_3_82         467
#define GPIO_VER2_H_DRIVER_VGPIO_3_83         468

#define GPIO_VER2_H_DRIVER_GPP_H0             480
#define GPIO_VER2_H_DRIVER_GPP_H1             481
#define GPIO_VER2_H_DRIVER_GPP_H2             482
#define GPIO_VER2_H_DRIVER_GPP_H3             483
#define GPIO_VER2_H_DRIVER_GPP_H4             484
#define GPIO_VER2_H_DRIVER_GPP_H5             485
#define GPIO_VER2_H_DRIVER_GPP_H6             486
#define GPIO_VER2_H_DRIVER_GPP_H7             487
#define GPIO_VER2_H_DRIVER_GPP_H8             488
#define GPIO_VER2_H_DRIVER_GPP_H9             489
#define GPIO_VER2_H_DRIVER_GPP_H10            490
#define GPIO_VER2_H_DRIVER_GPP_H11            491
#define GPIO_VER2_H_DRIVER_GPP_H12            492
#define GPIO_VER2_H_DRIVER_GPP_H13            493
#define GPIO_VER2_H_DRIVER_GPP_H14            494
#define GPIO_VER2_H_DRIVER_GPP_H15            495
#define GPIO_VER2_H_DRIVER_GPP_H16            496
#define GPIO_VER2_H_DRIVER_GPP_H17            497
#define GPIO_VER2_H_DRIVER_GPP_H18            498
#define GPIO_VER2_H_DRIVER_GPP_H19            499
#define GPIO_VER2_H_DRIVER_GPP_H20            500
#define GPIO_VER2_H_DRIVER_GPP_H21            501
#define GPIO_VER2_H_DRIVER_GPP_H22            502
#define GPIO_VER2_H_DRIVER_GPP_H23            503

#define GPIO_VER2_H_DRIVER_GPP_J0             512
#define GPIO_VER2_H_DRIVER_GPP_J1             513
#define GPIO_VER2_H_DRIVER_GPP_J2             514
#define GPIO_VER2_H_DRIVER_GPP_J3             515
#define GPIO_VER2_H_DRIVER_GPP_J4             516
#define GPIO_VER2_H_DRIVER_GPP_J5             517
#define GPIO_VER2_H_DRIVER_GPP_J6             518
#define GPIO_VER2_H_DRIVER_GPP_J7             519
#define GPIO_VER2_H_DRIVER_GPP_J8             520
#define GPIO_VER2_H_DRIVER_GPP_J9             521

#define GPIO_VER2_H_DRIVER_GPP_K0             544
#define GPIO_VER2_H_DRIVER_GPP_K1             545
#define GPIO_VER2_H_DRIVER_GPP_K2             546
#define GPIO_VER2_H_DRIVER_GPP_K3             547
#define GPIO_VER2_H_DRIVER_GPP_K4             548
#define GPIO_VER2_H_DRIVER_GPP_K5             549
#define GPIO_VER2_H_DRIVER_GPP_K6             550
#define GPIO_VER2_H_DRIVER_GPP_K7             551
#define GPIO_VER2_H_DRIVER_GPP_K8             552
#define GPIO_VER2_H_DRIVER_GPP_K9             553
#define GPIO_VER2_H_DRIVER_GPP_K10            554
#define GPIO_VER2_H_DRIVER_GPP_K11            555

#define GPIO_VER2_H_DRIVER_GPP_I0             576
#define GPIO_VER2_H_DRIVER_GPP_I1             577
#define GPIO_VER2_H_DRIVER_GPP_I2             578
#define GPIO_VER2_H_DRIVER_GPP_I3             579
#define GPIO_VER2_H_DRIVER_GPP_I4             580
#define GPIO_VER2_H_DRIVER_GPP_I5             581
#define GPIO_VER2_H_DRIVER_GPP_I6             582
#define GPIO_VER2_H_DRIVER_GPP_I7             583
#define GPIO_VER2_H_DRIVER_GPP_I8             584
#define GPIO_VER2_H_DRIVER_GPP_I9             585
#define GPIO_VER2_H_DRIVER_GPP_I10            586
#define GPIO_VER2_H_DRIVER_GPP_I11            587
#define GPIO_VER2_H_DRIVER_GPP_I12            588
#define GPIO_VER2_H_DRIVER_GPP_I13            589
#define GPIO_VER2_H_DRIVER_GPP_I14            590

#define GPIO_VER2_H_DRIVER_JTAG_JTAG_TDO      608
#define GPIO_VER2_H_DRIVER_JTAG_JTAGX         609
#define GPIO_VER2_H_DRIVER_JTAG_PRDYB         610
#define GPIO_VER2_H_DRIVER_JTAG_PREQB         611
#define GPIO_VER2_H_DRIVER_JTAG_JTAG_TDI      612
#define GPIO_VER2_H_DRIVER_JTAG_JTAG_TMS      613
#define GPIO_VER2_H_DRIVER_JTAG_JTAG_TCK      614
#define GPIO_VER2_H_DRIVER_JTAG_DBG_PMODE     615
#define GPIO_VER2_H_DRIVER_JTAG_CPU_TRSTB     616

#define GPIO_VER2_H_DRIVER_CPU_HDACPU_SDI     640
#define GPIO_VER2_H_DRIVER_CPU_HDACPU_SDO     641
#define GPIO_VER2_H_DRIVER_CPU_HDACPU_BCLK    642
#define GPIO_VER2_H_DRIVER_CPU_PM_SYNC        643
#define GPIO_VER2_H_DRIVER_CPU_PECI           644
#define GPIO_VER2_H_DRIVER_CPU_CPUPWRGD       645
#define GPIO_VER2_H_DRIVER_CPU_THRMTRIPB      646
#define GPIO_VER2_H_DRIVER_CPU_PLTRST_CPUB    647
#define GPIO_VER2_H_DRIVER_CPU_PM_DOWN        648
#define GPIO_VER2_H_DRIVER_CPU_TRIGGER_IN     649
#define GPIO_VER2_H_DRIVER_CPU_TRIGGER_OUT    650
#define GPIO_VER2_H_DRIVER_CPU_CLKOUT_CPURTC  651
#define GPIO_VER2_H_DRIVER_CPU_VCCST_OVERRIDE 652
#define GPIO_VER2_H_DRIVER_CPU_C10_WAKE       653

#define GPIO_VER2_H_IOAPIC_GPP_A0   0x18
#define GPIO_VER2_H_IOAPIC_GPP_A1   0x19
#define GPIO_VER2_H_IOAPIC_GPP_A2   0x1A
#define GPIO_VER2_H_IOAPIC_GPP_A3   0x1B
#define GPIO_VER2_H_IOAPIC_GPP_A4   0x1C
#define GPIO_VER2_H_IOAPIC_GPP_A5   0x1D
#define GPIO_VER2_H_IOAPIC_GPP_A6   0x1E
#define GPIO_VER2_H_IOAPIC_GPP_A7   0x1F
#define GPIO_VER2_H_IOAPIC_GPP_A8   0x20
#define GPIO_VER2_H_IOAPIC_GPP_A9   0x21
#define GPIO_VER2_H_IOAPIC_GPP_A10  0x22
#define GPIO_VER2_H_IOAPIC_GPP_A11  0x23
#define GPIO_VER2_H_IOAPIC_GPP_A12  0x24
#define GPIO_VER2_H_IOAPIC_GPP_A13  0x25
#define GPIO_VER2_H_IOAPIC_GPP_A14  0x26
#define GPIO_VER2_H_IOAPIC_GPP_A15  0x27
#define GPIO_VER2_H_IOAPIC_GPP_A16  0x28
#define GPIO_VER2_H_IOAPIC_GPP_A17  0x29
#define GPIO_VER2_H_IOAPIC_GPP_A18  0x2A
#define GPIO_VER2_H_IOAPIC_GPP_A19  0x2B
#define GPIO_VER2_H_IOAPIC_GPP_A20  0x2C
#define GPIO_VER2_H_IOAPIC_GPP_A21  0x2D
#define GPIO_VER2_H_IOAPIC_GPP_A22  0x2E
#define GPIO_VER2_H_IOAPIC_GPP_A23  0x2F

#define GPIO_VER2_H_IOAPIC_GPP_R0   0x37
#define GPIO_VER2_H_IOAPIC_GPP_R1   0x38
#define GPIO_VER2_H_IOAPIC_GPP_R2   0x39
#define GPIO_VER2_H_IOAPIC_GPP_R3   0x3A
#define GPIO_VER2_H_IOAPIC_GPP_R4   0x3B
#define GPIO_VER2_H_IOAPIC_GPP_R5   0x3C
#define GPIO_VER2_H_IOAPIC_GPP_R6   0x3D
#define GPIO_VER2_H_IOAPIC_GPP_R7   0x3E

#define GPIO_VER2_H_IOAPIC_GPP_B0   0x30
#define GPIO_VER2_H_IOAPIC_GPP_B1   0x31
#define GPIO_VER2_H_IOAPIC_GPP_B2   0x32
#define GPIO_VER2_H_IOAPIC_GPP_B3   0x33
#define GPIO_VER2_H_IOAPIC_GPP_B4   0x34
#define GPIO_VER2_H_IOAPIC_GPP_B5   0x35
#define GPIO_VER2_H_IOAPIC_GPP_B6   0x36
#define GPIO_VER2_H_IOAPIC_GPP_B7   0x37
#define GPIO_VER2_H_IOAPIC_GPP_B8   0x38
#define GPIO_VER2_H_IOAPIC_GPP_B9   0x39
#define GPIO_VER2_H_IOAPIC_GPP_B10  0x3A
#define GPIO_VER2_H_IOAPIC_GPP_B11  0x3B
#define GPIO_VER2_H_IOAPIC_GPP_B12  0x3C
#define GPIO_VER2_H_IOAPIC_GPP_B13  0x3D
#define GPIO_VER2_H_IOAPIC_GPP_B14  0x3E
#define GPIO_VER2_H_IOAPIC_GPP_B15  0x3F
#define GPIO_VER2_H_IOAPIC_GPP_B16  0x40
#define GPIO_VER2_H_IOAPIC_GPP_B17  0x41
#define GPIO_VER2_H_IOAPIC_GPP_B18  0x42
#define GPIO_VER2_H_IOAPIC_GPP_B19  0x43
#define GPIO_VER2_H_IOAPIC_GPP_B20  0x44
#define GPIO_VER2_H_IOAPIC_GPP_B21  0x45
#define GPIO_VER2_H_IOAPIC_GPP_B22  0x46
#define GPIO_VER2_H_IOAPIC_GPP_B23  0x47

#define GPIO_VER2_H_IOAPIC_GPP_C0   0x48
#define GPIO_VER2_H_IOAPIC_GPP_C1   0x49
#define GPIO_VER2_H_IOAPIC_GPP_C2   0x4A
#define GPIO_VER2_H_IOAPIC_GPP_C3   0x4B
#define GPIO_VER2_H_IOAPIC_GPP_C4   0x4C
#define GPIO_VER2_H_IOAPIC_GPP_C5   0x4D
#define GPIO_VER2_H_IOAPIC_GPP_C6   0x4E
#define GPIO_VER2_H_IOAPIC_GPP_C7   0x4F
#define GPIO_VER2_H_IOAPIC_GPP_C8   0x50
#define GPIO_VER2_H_IOAPIC_GPP_C9   0x51
#define GPIO_VER2_H_IOAPIC_GPP_C10  0x52
#define GPIO_VER2_H_IOAPIC_GPP_C11  0x53
#define GPIO_VER2_H_IOAPIC_GPP_C12  0x54
#define GPIO_VER2_H_IOAPIC_GPP_C13  0x55
#define GPIO_VER2_H_IOAPIC_GPP_C14  0x56
#define GPIO_VER2_H_IOAPIC_GPP_C15  0x57
#define GPIO_VER2_H_IOAPIC_GPP_C16  0x58
#define GPIO_VER2_H_IOAPIC_GPP_C17  0x59
#define GPIO_VER2_H_IOAPIC_GPP_C18  0x5A
#define GPIO_VER2_H_IOAPIC_GPP_C19  0x5B
#define GPIO_VER2_H_IOAPIC_GPP_C20  0x5C
#define GPIO_VER2_H_IOAPIC_GPP_C21  0x5D
#define GPIO_VER2_H_IOAPIC_GPP_C22  0x5E
#define GPIO_VER2_H_IOAPIC_GPP_C23  0x5F

#define GPIO_VER2_H_IOAPIC_GPP_D0   0x60
#define GPIO_VER2_H_IOAPIC_GPP_D1   0x61
#define GPIO_VER2_H_IOAPIC_GPP_D2   0x62
#define GPIO_VER2_H_IOAPIC_GPP_D3   0x63
#define GPIO_VER2_H_IOAPIC_GPP_D4   0x64
#define GPIO_VER2_H_IOAPIC_GPP_D5   0x65
#define GPIO_VER2_H_IOAPIC_GPP_D6   0x66
#define GPIO_VER2_H_IOAPIC_GPP_D7   0x67
#define GPIO_VER2_H_IOAPIC_GPP_D8   0x68
#define GPIO_VER2_H_IOAPIC_GPP_D9   0x69
#define GPIO_VER2_H_IOAPIC_GPP_D10  0x6A
#define GPIO_VER2_H_IOAPIC_GPP_D11  0x6B
#define GPIO_VER2_H_IOAPIC_GPP_D12  0x6C
#define GPIO_VER2_H_IOAPIC_GPP_D13  0x6D
#define GPIO_VER2_H_IOAPIC_GPP_D14  0x6E
#define GPIO_VER2_H_IOAPIC_GPP_D15  0x6F
#define GPIO_VER2_H_IOAPIC_GPP_D16  0x70
#define GPIO_VER2_H_IOAPIC_GPP_D17  0x71
#define GPIO_VER2_H_IOAPIC_GPP_D18  0x72
#define GPIO_VER2_H_IOAPIC_GPP_D19  0x73
#define GPIO_VER2_H_IOAPIC_GPP_D20  0x74
#define GPIO_VER2_H_IOAPIC_GPP_D21  0x75
#define GPIO_VER2_H_IOAPIC_GPP_D22  0x76
#define GPIO_VER2_H_IOAPIC_GPP_D23  0x77

#define GPIO_VER2_H_IOAPIC_GPP_S0   0x3F
#define GPIO_VER2_H_IOAPIC_GPP_S1   0x40
#define GPIO_VER2_H_IOAPIC_GPP_S2   0x41
#define GPIO_VER2_H_IOAPIC_GPP_S3   0x42
#define GPIO_VER2_H_IOAPIC_GPP_S4   0x43
#define GPIO_VER2_H_IOAPIC_GPP_S5   0x44
#define GPIO_VER2_H_IOAPIC_GPP_S6   0x45
#define GPIO_VER2_H_IOAPIC_GPP_S7   0x46

#define GPIO_VER2_H_IOAPIC_GPP_G0   0x18
#define GPIO_VER2_H_IOAPIC_GPP_G1   0x19
#define GPIO_VER2_H_IOAPIC_GPP_G2   0x1A
#define GPIO_VER2_H_IOAPIC_GPP_G3   0x1B
#define GPIO_VER2_H_IOAPIC_GPP_G4   0x1C
#define GPIO_VER2_H_IOAPIC_GPP_G5   0x1D
#define GPIO_VER2_H_IOAPIC_GPP_G6   0x1E
#define GPIO_VER2_H_IOAPIC_GPP_G7   0x1F
#define GPIO_VER2_H_IOAPIC_GPP_G8   0x20
#define GPIO_VER2_H_IOAPIC_GPP_G9   0x21
#define GPIO_VER2_H_IOAPIC_GPP_G10  0x22
#define GPIO_VER2_H_IOAPIC_GPP_G11  0x23
#define GPIO_VER2_H_IOAPIC_GPP_G12  0x24
#define GPIO_VER2_H_IOAPIC_GPP_G13  0x25
#define GPIO_VER2_H_IOAPIC_GPP_G14  0x26
#define GPIO_VER2_H_IOAPIC_GPP_G15  0x27

#define GPIO_VER2_H_IOAPIC_VGPIO4   0x28

#define GPIO_VER2_H_IOAPIC_GPD0     0x29
#define GPIO_VER2_H_IOAPIC_GPD1     0x2A
#define GPIO_VER2_H_IOAPIC_GPD2     0x2B
#define GPIO_VER2_H_IOAPIC_GPD3     0x2C
#define GPIO_VER2_H_IOAPIC_GPD4     0x2D
#define GPIO_VER2_H_IOAPIC_GPD5     0x2E
#define GPIO_VER2_H_IOAPIC_GPD6     0x2F
#define GPIO_VER2_H_IOAPIC_GPD7     0x30
#define GPIO_VER2_H_IOAPIC_GPD8     0x31
#define GPIO_VER2_H_IOAPIC_GPD9     0x32
#define GPIO_VER2_H_IOAPIC_GPD10    0x33
#define GPIO_VER2_H_IOAPIC_GPD11    0x34
#define GPIO_VER2_H_IOAPIC_GPD12    0x35

#define GPIO_VER2_H_IOAPIC_GPP_E0   0x35
#define GPIO_VER2_H_IOAPIC_GPP_E1   0x36
#define GPIO_VER2_H_IOAPIC_GPP_E2   0x37
#define GPIO_VER2_H_IOAPIC_GPP_E3   0x38
#define GPIO_VER2_H_IOAPIC_GPP_E4   0x39
#define GPIO_VER2_H_IOAPIC_GPP_E5   0x3A
#define GPIO_VER2_H_IOAPIC_GPP_E6   0x3B
#define GPIO_VER2_H_IOAPIC_GPP_E7   0x3C
#define GPIO_VER2_H_IOAPIC_GPP_E8   0x3D
#define GPIO_VER2_H_IOAPIC_GPP_E9   0x3E
#define GPIO_VER2_H_IOAPIC_GPP_E10  0x3F
#define GPIO_VER2_H_IOAPIC_GPP_E11  0x40
#define GPIO_VER2_H_IOAPIC_GPP_E12  0x41

#define GPIO_VER2_H_IOAPIC_GPP_F0   0x42
#define GPIO_VER2_H_IOAPIC_GPP_F1   0x43
#define GPIO_VER2_H_IOAPIC_GPP_F2   0x44
#define GPIO_VER2_H_IOAPIC_GPP_F3   0x45
#define GPIO_VER2_H_IOAPIC_GPP_F4   0x46
#define GPIO_VER2_H_IOAPIC_GPP_F5   0x47
#define GPIO_VER2_H_IOAPIC_GPP_F6   0x48
#define GPIO_VER2_H_IOAPIC_GPP_F7   0x49
#define GPIO_VER2_H_IOAPIC_GPP_F8   0x4A
#define GPIO_VER2_H_IOAPIC_GPP_F9   0x4B
#define GPIO_VER2_H_IOAPIC_GPP_F10  0x4C
#define GPIO_VER2_H_IOAPIC_GPP_F11  0x4D
#define GPIO_VER2_H_IOAPIC_GPP_F12  0x4E
#define GPIO_VER2_H_IOAPIC_GPP_F13  0x4F
#define GPIO_VER2_H_IOAPIC_GPP_F14  0x50
#define GPIO_VER2_H_IOAPIC_GPP_F15  0x51
#define GPIO_VER2_H_IOAPIC_GPP_F16  0x52
#define GPIO_VER2_H_IOAPIC_GPP_F17  0x53
#define GPIO_VER2_H_IOAPIC_GPP_F18  0x54
#define GPIO_VER2_H_IOAPIC_GPP_F19  0x55
#define GPIO_VER2_H_IOAPIC_GPP_F20  0x56
#define GPIO_VER2_H_IOAPIC_GPP_F21  0x57
#define GPIO_VER2_H_IOAPIC_GPP_F22  0x58
#define GPIO_VER2_H_IOAPIC_GPP_F23  0x59

#define GPIO_VER2_H_IOAPIC_GPP_H0   0x5A
#define GPIO_VER2_H_IOAPIC_GPP_H1   0x5B
#define GPIO_VER2_H_IOAPIC_GPP_H2   0x5C
#define GPIO_VER2_H_IOAPIC_GPP_H3   0x5D
#define GPIO_VER2_H_IOAPIC_GPP_H4   0x5E
#define GPIO_VER2_H_IOAPIC_GPP_H5   0x5F
#define GPIO_VER2_H_IOAPIC_GPP_H6   0x60
#define GPIO_VER2_H_IOAPIC_GPP_H7   0x61
#define GPIO_VER2_H_IOAPIC_GPP_H8   0x62
#define GPIO_VER2_H_IOAPIC_GPP_H9   0x63
#define GPIO_VER2_H_IOAPIC_GPP_H10  0x64
#define GPIO_VER2_H_IOAPIC_GPP_H11  0x65
#define GPIO_VER2_H_IOAPIC_GPP_H12  0x66
#define GPIO_VER2_H_IOAPIC_GPP_H13  0x67
#define GPIO_VER2_H_IOAPIC_GPP_H14  0x68
#define GPIO_VER2_H_IOAPIC_GPP_H15  0x69
#define GPIO_VER2_H_IOAPIC_GPP_H16  0x6A
#define GPIO_VER2_H_IOAPIC_GPP_H17  0x6B
#define GPIO_VER2_H_IOAPIC_GPP_H18  0x6C
#define GPIO_VER2_H_IOAPIC_GPP_H19  0x6D
#define GPIO_VER2_H_IOAPIC_GPP_H20  0x6E
#define GPIO_VER2_H_IOAPIC_GPP_H21  0x6F
#define GPIO_VER2_H_IOAPIC_GPP_H22  0x70
#define GPIO_VER2_H_IOAPIC_GPP_H23  0x71

#define GPIO_VER2_H_IOAPIC_GPP_K0   0x72
#define GPIO_VER2_H_IOAPIC_GPP_K1   0x73
#define GPIO_VER2_H_IOAPIC_GPP_K2   0x74
#define GPIO_VER2_H_IOAPIC_GPP_K3   0x75
#define GPIO_VER2_H_IOAPIC_GPP_K4   0x76
#define GPIO_VER2_H_IOAPIC_GPP_K5   0x77
#define GPIO_VER2_H_IOAPIC_GPP_K6   0x18
#define GPIO_VER2_H_IOAPIC_GPP_K7   0x19
#define GPIO_VER2_H_IOAPIC_GPP_K8   0x1A
#define GPIO_VER2_H_IOAPIC_GPP_K9   0x1B
#define GPIO_VER2_H_IOAPIC_GPP_K10  0x1C
#define GPIO_VER2_H_IOAPIC_GPP_K11  0x1D

#define GPIO_VER2_H_IOAPIC_GPP_J0   0x1E
#define GPIO_VER2_H_IOAPIC_GPP_J1   0x1F
#define GPIO_VER2_H_IOAPIC_GPP_J2   0x20
#define GPIO_VER2_H_IOAPIC_GPP_J3   0x21
#define GPIO_VER2_H_IOAPIC_GPP_J4   0x22
#define GPIO_VER2_H_IOAPIC_GPP_J5   0x23
#define GPIO_VER2_H_IOAPIC_GPP_J6   0x24
#define GPIO_VER2_H_IOAPIC_GPP_J7   0x25
#define GPIO_VER2_H_IOAPIC_GPP_J8   0x26
#define GPIO_VER2_H_IOAPIC_GPP_J9   0x27

#define GPIO_VER2_H_IOAPIC_GPP_I0   0x28
#define GPIO_VER2_H_IOAPIC_GPP_I1   0x29
#define GPIO_VER2_H_IOAPIC_GPP_I2   0x2A
#define GPIO_VER2_H_IOAPIC_GPP_I3   0x2B
#define GPIO_VER2_H_IOAPIC_GPP_I4   0x2C
#define GPIO_VER2_H_IOAPIC_GPP_I5   0x2D
#define GPIO_VER2_H_IOAPIC_GPP_I6   0x2E
#define GPIO_VER2_H_IOAPIC_GPP_I7   0x2F
#define GPIO_VER2_H_IOAPIC_GPP_I8   0x30
#define GPIO_VER2_H_IOAPIC_GPP_I9   0x31
#define GPIO_VER2_H_IOAPIC_GPP_I10  0x32
#define GPIO_VER2_H_IOAPIC_GPP_I11  0x33
#define GPIO_VER2_H_IOAPIC_GPP_I12  0x34
#define GPIO_VER2_H_IOAPIC_GPP_I13  0x35
#define GPIO_VER2_H_IOAPIC_GPP_I14  0x36

#endif // _GPIO_ACPI_DEFINES_VER2_
