/** @file
    CnlPchH A0 HSIO C File
@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/


#include <Uefi/UefiBaseType.h>
#include <PchHsio.h>

UINT8 CnlPchHChipsetInitTable_A0[] = {
  0x21, 0x2F, //CRC-16
  0x02,       //Version
  0xd0,       //Product/Stepping
  // Phy Data Group Table (Fixed table with 16 Entries)
  0x00, 0x00,
  0x06, 0x71,
  0x0F, 0x23,
  0x00, 0x0F,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  // HSIO Command Table
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x30, 0x80, 0x01, 0x04, 0x30, 0x00, //  {0xA8, 0x00300401, 0x8030, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x3C, 0x80, 0x02, 0x00, 0x00, 0x00, //  {0xA8, 0x00000002, 0x803C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x48, 0x80, 0x00, 0x00, 0x21, 0x01, //  {0xA8, 0x01210000, 0x8048, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x4C, 0x80, 0x00, 0x0C, 0x00, 0x00, //  {0xA8, 0x00000C00, 0x804C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x60, 0x80, 0x01, 0x00, 0x00, 0x00, //  {0xA8, 0x00000001, 0x8060, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xE8, 0x80, 0x80, 0x08, 0x01, 0x3C, //  {0xA8, 0x3C010880, 0x80E8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x38, 0x81, 0xAC, 0xD4, 0x00, 0x00, //  {0xA8, 0x0000D4AC, 0x8138, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0B, 0x00, 0x90, 0x81, 0x02, 0x06, 0x01, 0x0C, //  {0xA8, 0x0C010602, 0x8190, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0xA8, 0x81, 0x06, 0x00, 0x1F, 0x00, //  {0xA8, 0x001F0006, 0x81A8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0xB0, 0x81, 0x00, 0x3C, 0x00, 0x78, //  {0xA8, 0x78003C00, 0x81B0, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xC8, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xA8, 0x00000001, 0x81C8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xCC, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xA8, 0x00000001, 0x81CC, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x01, 0x00, 0x30, 0x80, 0x01, 0x04, 0x30, 0x00, //  {0xA9, 0x00300401, 0x8030, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x01, 0x00, 0x3C, 0x80, 0x02, 0x00, 0x00, 0x00, //  {0xA9, 0x00000002, 0x803C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x0F, 0x00, 0x48, 0x80, 0x00, 0x00, 0x21, 0x01, //  {0xA9, 0x01210000, 0x8048, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x0F, 0x00, 0x4C, 0x80, 0x00, 0x0C, 0x00, 0x00, //  {0xA9, 0x00000C00, 0x804C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x0F, 0x00, 0x60, 0x80, 0xC1, 0x00, 0x00, 0x09, //  {0xA9, 0x090000C1, 0x8060, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x04, 0x00, 0xE8, 0x80, 0x80, 0x08, 0x01, 0x3C, //  {0xA9, 0x3C010880, 0x80E8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x08, 0x00, 0x38, 0x81, 0xAC, 0xD4, 0x00, 0x00, //  {0xA9, 0x0000D4AC, 0x8138, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x0A, 0x00, 0xB0, 0x81, 0x00, 0x3C, 0x00, 0x78, //  {0xA9, 0x78003C00, 0x81B0, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x01, 0x00, 0xC8, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xA9, 0x00000001, 0x81C8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x01, 0x00, 0xCC, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xA9, 0x00000001, 0x81CC, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x04, 0x80, 0x60, 0x00, 0x00, 0x20, //  {0xAB, 0x20000060, 0x8004, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, //  {0xAB, 0x00000000, 0x8008, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x30, 0x80, 0x01, 0x04, 0x30, 0x00, //  {0xAB, 0x00300401, 0x8030, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x3C, 0x80, 0x02, 0x00, 0x00, 0x00, //  {0xAB, 0x00000002, 0x803C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x48, 0x80, 0x00, 0x00, 0x21, 0x01, //  {0xAB, 0x01210000, 0x8048, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x4C, 0x80, 0x00, 0x0C, 0x00, 0x00, //  {0xAB, 0x00000C00, 0x804C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x60, 0x80, 0x0F, 0x00, 0x00, 0x00, //  {0xAB, 0x0000000F, 0x8060, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0xE8, 0x80, 0x80, 0x08, 0x01, 0x3C, //  {0xAB, 0x3C010880, 0x80E8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0B, 0x00, 0x90, 0x81, 0x03, 0x06, 0x01, 0x0A, //  {0xAB, 0x0A010603, 0x8190, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0A, 0x00, 0xB0, 0x81, 0x00, 0x3C, 0x00, 0x78, //  {0xAB, 0x78003C00, 0x81B0, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xC8, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xAB, 0x00000001, 0x81C8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xCC, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xAB, 0x00000001, 0x81CC, PCH_LANE_OWN_COMMON, LANE},
  0x0F, 0x00, 0x00, 0x00,                                                 //  End Table Marker
  0x28, 0xAF, 0x07, 0x00, 0x0B, 0x00, 0x01, 0x40, 0x06, 0xB0, 0x3D, 0x2F, //  {0xAF, 0x2F3DB006, 0x4001, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x08, 0x41, 0xD0, 0xDA, 0x00, 0x00, //  {0xAF, 0x0000DAD0, 0x4108, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x08, 0x42, 0xD0, 0xDA, 0x00, 0x00, //  {0xAF, 0x0000DAD0, 0x4208, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x08, 0x43, 0xD0, 0xDA, 0x00, 0x00, //  {0xAF, 0x0000DAD0, 0x4308, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x08, 0x44, 0xD0, 0xDA, 0x00, 0x00, //  {0xAF, 0x0000DAD0, 0x4408, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x08, 0x45, 0xD0, 0xDA, 0x00, 0x00, //  {0xAF, 0x0000DAD0, 0x4508, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x08, 0x46, 0xD0, 0xDA, 0x00, 0x00, //  {0xAF, 0x0000DAD0, 0x4608, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x08, 0x47, 0xD0, 0xDA, 0x00, 0x00, //  {0xAF, 0x0000DAD0, 0x4708, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x08, 0x48, 0xD0, 0xDA, 0x00, 0x00, //  {0xAF, 0x0000DAD0, 0x4808, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x41, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4100, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x42, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4200, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x43, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4300, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x44, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4400, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x45, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4500, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x46, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4600, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x47, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4700, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x48, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4800, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x49, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4900, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x4A, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4A00, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x4B, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4B00, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x4C, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4C00, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x4D, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4D00, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x00, 0x4E, 0x91, 0xBD, 0x05, 0xFC, //  {0xAF, 0xFC05BD91, 0x4E00, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x41, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4126, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x42, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4226, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x43, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4326, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x44, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4426, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x45, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4526, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x46, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4626, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x47, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4726, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x48, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4826, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x49, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4926, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x4A, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4A26, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x4B, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4B26, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x4C, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4C26, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x4D, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4D26, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0D, 0x00, 0x26, 0x4E, 0x4B, 0x92, 0x82, 0x43, //  {0xAF, 0x4382924B, 0x4E26, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x2C, 0x40, 0x80, 0x53, 0xA2, 0x09, //  {0xAF, 0x09A25380, 0x402C, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x04, 0x7F, 0x80, 0x84, 0x00, 0x00, //  {0xAF, 0x00008480, 0x7F04, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x04, 0x00, 0x2B, 0x40, 0x05, 0x40, 0x6A, 0x00, //  {0xAF, 0x006A4005, 0x402B, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0F, 0x00, 0x02, 0x7F, 0x70, 0x24, 0x80, 0x4E, //  {0xAF, 0x4E802470, 0x7F02, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x03, 0x00, 0x2C, 0x70, 0x10, 0xC2, 0x88, 0x00, //  {0xAF, 0x0088C210, 0x702C, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x08, 0x00, 0x00, 0x70, 0x08, 0x0E, 0x64, 0x50, //  {0xAF, 0x50640E08, 0x7000, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x06, 0x00, 0x08, 0x70, 0x20, 0x3A, 0x03, 0x20, //  {0xAF, 0x20033A20, 0x7008, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x0E, 0x00, 0x14, 0x70, 0x00, 0x3E, 0xBB, 0x47, //  {0xAF, 0x47BB3E00, 0x7014, USB2PHY, LANE},
  0x28, 0xAF, 0x07, 0x00, 0x06, 0x00, 0x24, 0x70, 0x00, 0xE0, 0x01, 0x30, //  {0xAF, 0x3001E000, 0x7024, USB2PHY, LANE},
  0x0F, 0x00, 0x00, 0x00,                                                 //  End Table Marker
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x28, 0xFC, 0xE0, 0x01, 0x02, 0x01, //  {0xA8, 0x010201E0, 0xFC28, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x24, 0xFC, 0x10, 0x0A, 0x0B, 0xA4, //  {0xA8, 0xA40B0A10, 0xFC24, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0xFC, 0x00, 0x02, 0x1B, 0xE0, //  {0xA8, 0xE01B0200, 0xFC64, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x50, 0xFF, 0x6E, 0x80, 0x10, 0x10, //  {0xAB, 0x1010806E, 0xFF50, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x28, 0xFC, 0xE0, 0x01, 0x02, 0x01, //  {0xAB, 0x010201E0, 0xFC28, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x8C, 0xFD, 0x00, 0x08, 0x1F, 0x20, //  {0xAB, 0x201F0800, 0xFD8C, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x54, 0xFD, 0x06, 0x2A, 0x29, 0x28, //  {0xAB, 0x28292A06, 0xFD54, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0xC8, 0xFE, 0x50, 0x88, 0x8D, 0x3F, //  {0xAB, 0x3F8D8850, 0xFEC8, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x78, 0xFE, 0x60, 0x40, 0x83, 0x40, //  {0xAB, 0x40834060, 0xFE78, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x84, 0xFD, 0x08, 0x0A, 0x00, 0x08, //  {0xAB, 0x08000A08, 0xFD84, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x00, 0xFC, 0x00, 0x01, 0x82, 0x80, //  {0xAB, 0x80820100, 0xFC00, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x18, 0xFE, 0xBF, 0x00, 0x00, 0x00, //  {0xAB, 0x000000BF, 0xFE18, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x3C, 0xFE, 0xF0, 0x00, 0x00, 0x00, //  {0xAB, 0x000000F0, 0xFE3C, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xEC, 0x9E, 0x00, 0x00, 0x00, 0x00, //  {0xA8, 0x00000000, 0x9EEC, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x4C, 0x86, 0x07, 0xC9, 0x02, 0x01, //  {0xA8, 0x0102C907, 0x864C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x44, 0x96, 0x48, 0x15, 0x05, 0x01, //  {0xA8, 0x01051548, 0x9644, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x48, 0x96, 0x4C, 0x15, 0x05, 0x01, //  {0xA8, 0x0105154C, 0x9648, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x44, 0x9E, 0x4C, 0x17, 0x05, 0x01, //  {0xA8, 0x0105174C, 0x9E44, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x48, 0x8E, 0x4C, 0x19, 0x05, 0x01, //  {0xA8, 0x0105194C, 0x8E48, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x48, 0x9E, 0x4C, 0x19, 0x05, 0x01, //  {0xA8, 0x0105194C, 0x9E48, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x40, 0x86, 0x58, 0xCF, 0x05, 0x01, //  {0xA8, 0x0105CF58, 0x8640, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x44, 0x86, 0x48, 0xD5, 0x05, 0x01, //  {0xA8, 0x0105D548, 0x8644, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x40, 0x96, 0x5F, 0xD3, 0x18, 0x01, //  {0xA8, 0x0118D35F, 0x9640, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x0C, 0x86, 0xE4, 0x9B, 0x12, 0x00, //  {0xA8, 0x00129BE4, 0x860C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0C, 0x00, 0x58, 0x96, 0x09, 0xA0, 0x33, 0x01, //  {0xA8, 0x0133A009, 0x9658, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0xF4, 0x96, 0x00, 0x14, 0x00, 0x00, //  {0xA8, 0x00001400, 0x96F4, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x58, 0x95, 0x00, 0x28, 0x1F, 0x15, //  {0xA8, 0x151F2800, 0x9558, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0xCC, 0x9E, 0x21, 0x17, 0x17, 0x00, //  {0xA8, 0x00171721, 0x9ECC, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xE8, 0x9E, 0x00, 0x48, 0x17, 0x18, //  {0xA8, 0x18174800, 0x9EE8, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0xA0, 0x86, 0xE9, 0x00, 0x00, 0x1C, //  {0xA8, 0x1C0000E9, 0x86A0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0D, 0x00, 0xE4, 0x86, 0x50, 0x05, 0x0B, 0x1C, //  {0xA8, 0x1C0B0550, 0x86E4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0xA4, 0x86, 0x1C, 0x1C, 0x1C, 0x00, //  {0xA8, 0x001C1C1C, 0x86A4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x8C, 0x9D, 0x20, 0x00, 0x1F, 0x20, //  {0xA8, 0x201F0020, 0x9D8C, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x8C, 0x85, 0x00, 0x08, 0x1F, 0x20, //  {0xA8, 0x201F0800, 0x858C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x18, 0x84, 0x7C, 0x00, 0x09, 0x02, //  {0xA8, 0x0209007C, 0x8418, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0x08, 0x8E, 0x50, 0x18, 0xE0, 0x21, //  {0xA8, 0x21E01850, 0x8E08, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0x08, 0x96, 0x50, 0x18, 0xE0, 0x21, //  {0xA8, 0x21E01850, 0x9608, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0D, 0x00, 0x08, 0x86, 0x50, 0x18, 0xEC, 0x21, //  {0xA8, 0x21EC1850, 0x8608, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x9C, 0x85, 0x00, 0x0C, 0x49, 0x22, //  {0xA8, 0x22490C00, 0x859C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x04, 0x8C, 0x44, 0x01, 0x24, 0x00, //  {0xA8, 0x00240144, 0x8C04, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x04, 0x9C, 0x44, 0x01, 0x24, 0x00, //  {0xA8, 0x00240144, 0x9C04, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x88, 0x86, 0x20, 0x00, 0x74, 0x24, //  {0xA8, 0x24740020, 0x8688, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0xF0, 0x86, 0x20, 0x28, 0x28, 0x28, //  {0xA8, 0x28282820, 0x86F0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x54, 0x85, 0x06, 0x2A, 0x29, 0x28, //  {0xA8, 0x28292A06, 0x8554, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x54, 0x95, 0x06, 0x2D, 0x2D, 0x28, //  {0xA8, 0x282D2D06, 0x9554, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0xB4, 0x8E, 0x40, 0x40, 0x81, 0x2C, //  {0xA8, 0x2C814040, 0x8EB4, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0xB4, 0x86, 0x40, 0x40, 0x81, 0x2C, //  {0xA8, 0x2C814040, 0x86B4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0xB4, 0x96, 0x40, 0x40, 0x81, 0x2C, //  {0xA8, 0x2C814040, 0x96B4, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x14, 0x86, 0x1F, 0x63, 0x20, 0x03, //  {0xA8, 0x0320631F, 0x8614, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x14, 0x9E, 0x1F, 0x61, 0x30, 0x03, //  {0xA8, 0x0330611F, 0x9E14, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x1C, 0x96, 0x58, 0x00, 0x3B, 0x00, //  {0xA8, 0x003B0058, 0x961C, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x1C, 0x8E, 0xA8, 0x00, 0x3B, 0x00, //  {0xA8, 0x003B00A8, 0x8E1C, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x5C, 0x96, 0x2A, 0x08, 0x3F, 0x00, //  {0xA8, 0x003F082A, 0x965C, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x08, 0x9E, 0x50, 0x18, 0xE0, 0x3F, //  {0xA8, 0x3FE01850, 0x9E08, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x70, 0x86, 0x5A, 0x25, 0x40, 0x40, //  {0xA8, 0x4040255A, 0x8670, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x70, 0x9E, 0x5B, 0x25, 0x40, 0x40, //  {0xA8, 0x4040255B, 0x9E70, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x78, 0x8E, 0x60, 0x40, 0x83, 0x40, //  {0xA8, 0x40834060, 0x8E78, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x78, 0x9E, 0x60, 0x40, 0x83, 0x40, //  {0xA8, 0x40834060, 0x9E78, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x78, 0x86, 0x60, 0x40, 0x83, 0x40, //  {0xA8, 0x40834060, 0x8678, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x78, 0x96, 0x60, 0x40, 0x83, 0x40, //  {0xA8, 0x40834060, 0x9678, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x04, 0x94, 0x45, 0x01, 0x24, 0x04, //  {0xA8, 0x04240145, 0x9404, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x50, 0x96, 0x3F, 0x3F, 0x3F, 0x04, //  {0xA8, 0x043F3F3F, 0x9650, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x8C, 0x86, 0x58, 0x40, 0x04, 0x00, //  {0xA8, 0x00044058, 0x868C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x20, 0x8E, 0x00, 0x48, 0x00, 0x00, //  {0xA8, 0x00004800, 0x8E20, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x20, 0x96, 0x00, 0x48, 0x00, 0x00, //  {0xA8, 0x00004800, 0x9620, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x20, 0x86, 0x00, 0x4C, 0x00, 0x00, //  {0xA8, 0x00004C00, 0x8620, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x9C, 0x86, 0x00, 0x00, 0x4C, 0x00, //  {0xA8, 0x004C0000, 0x869C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x04, 0x96, 0x09, 0x00, 0x05, 0x00, //  {0xA8, 0x00050009, 0x9604, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x04, 0x8E, 0x09, 0x09, 0x05, 0x00, //  {0xA8, 0x00050909, 0x8E04, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x04, 0x9E, 0x09, 0x09, 0x05, 0x00, //  {0xA8, 0x00050909, 0x9E04, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x04, 0x86, 0x09, 0x09, 0x05, 0x00, //  {0xA8, 0x00050909, 0x8604, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x00, 0x86, 0x00, 0xA8, 0x52, 0x00, //  {0xA8, 0x0052A800, 0x8600, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x50, 0x86, 0x3F, 0x3F, 0x3F, 0x05, //  {0xA8, 0x053F3F3F, 0x8650, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x64, 0x86, 0x00, 0x54, 0x00, 0x00, //  {0xA8, 0x00005400, 0x8664, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0xC0, 0x86, 0x00, 0x00, 0x88, 0x5B, //  {0xA8, 0x5B880000, 0x86C0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x1C, 0x84, 0x00, 0xC0, 0x00, 0x60, //  {0xA8, 0x6000C000, 0x841C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x5C, 0x86, 0x2A, 0x08, 0x60, 0x00, //  {0xA8, 0x0060082A, 0x865C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xC8, 0x86, 0x50, 0x88, 0x8D, 0x60, //  {0xA8, 0x608D8850, 0x86C8, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xAC, 0x86, 0xE9, 0x60, 0x00, 0x00, //  {0xA8, 0x000060E9, 0x86AC, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x50, 0x9E, 0x3F, 0x3F, 0x3F, 0x06, //  {0xA8, 0x063F3F3F, 0x9E50, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x04, 0x84, 0x64, 0xC1, 0x64, 0x00, //  {0xA8, 0x0064C164, 0x8404, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0x1C, 0x86, 0xA8, 0x00, 0x3B, 0x6E, //  {0xA8, 0x6E3B00A8, 0x861C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x10, 0x8C, 0x00, 0x00, 0xBF, 0x72, //  {0xA8, 0x72BF0000, 0x8C10, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x10, 0x84, 0x00, 0x00, 0xBF, 0x72, //  {0xA8, 0x72BF0000, 0x8410, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x10, 0x94, 0x00, 0x00, 0xBF, 0x72, //  {0xA8, 0x72BF0000, 0x9410, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x90, 0x86, 0x48, 0x30, 0x50, 0x75, //  {0xA8, 0x75503048, 0x8690, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x38, 0x9C, 0x7F, 0x00, 0x00, 0x00, //  {0xA8, 0x0000007F, 0x9C38, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x38, 0x84, 0x7F, 0x00, 0x00, 0x00, //  {0xA8, 0x0000007F, 0x8438, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0xE0, 0x86, 0x00, 0x04, 0x00, 0x08, //  {0xA8, 0x08000400, 0x86E0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x84, 0x85, 0x08, 0x0A, 0x00, 0x08, //  {0xA8, 0x08000A08, 0x8584, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x00, 0x8C, 0x00, 0x01, 0x02, 0x80, //  {0xA8, 0x80020100, 0x8C00, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0C, 0x00, 0x00, 0x9C, 0x00, 0x01, 0x02, 0x80, //  {0xA8, 0x80020100, 0x9C00, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x00, 0x84, 0x00, 0x01, 0x02, 0x80, //  {0xA8, 0x80020100, 0x8400, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x00, 0x94, 0x00, 0x01, 0x02, 0x80, //  {0xA8, 0x80020100, 0x9400, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x54, 0x9E, 0x02, 0x01, 0xC0, 0x80, //  {0xA8, 0x80C00102, 0x9E54, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x58, 0x9E, 0x09, 0xA0, 0x31, 0x81, //  {0xA8, 0x8131A009, 0x9E58, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x58, 0x86, 0x09, 0xA0, 0x31, 0x81, //  {0xA8, 0x8131A009, 0x8658, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x8C, 0x96, 0x7C, 0x20, 0x08, 0x00, //  {0xA8, 0x0008207C, 0x968C, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xD4, 0x86, 0xC0, 0x80, 0x82, 0x00, //  {0xA8, 0x008280C0, 0x86D4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x8C, 0x8E, 0x7C, 0x80, 0x08, 0x00, //  {0xA8, 0x0008807C, 0x8E8C, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x8C, 0x9E, 0x7C, 0x80, 0x08, 0x00, //  {0xA8, 0x0008807C, 0x9E8C, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0x54, 0x86, 0x02, 0x00, 0xC0, 0x08, //  {0xA8, 0x08C00002, 0x8654, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x74, 0x86, 0x49, 0xFF, 0x80, 0x8D, //  {0xA8, 0x8D80FF49, 0x8674, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x74, 0x8E, 0x49, 0xFF, 0x80, 0x8E, //  {0xA8, 0x8E80FF49, 0x8E74, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x74, 0x96, 0x49, 0xFF, 0x80, 0x8E, //  {0xA8, 0x8E80FF49, 0x9674, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x00, 0x96, 0x00, 0x29, 0x52, 0x09, //  {0xA8, 0x09522900, 0x9600, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x00, 0x8E, 0x00, 0x69, 0x52, 0x09, //  {0xA8, 0x09526900, 0x8E00, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x00, 0x9E, 0x00, 0x69, 0x52, 0x09, //  {0xA8, 0x09526900, 0x9E00, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x3C, 0x84, 0x02, 0x9F, 0x00, 0x00, //  {0xA8, 0x00009F02, 0x843C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x2C, 0x86, 0x0A, 0x10, 0x0A, 0x00, //  {0xA8, 0x000A100A, 0x862C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x24, 0x86, 0xFC, 0x60, 0x33, 0xAA, //  {0xA8, 0xAA3360FC, 0x8624, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0D, 0x00, 0x68, 0x86, 0x2A, 0x82, 0x00, 0xB8, //  {0xA8, 0xB800822A, 0x8668, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x68, 0x96, 0x06, 0x82, 0x01, 0xB8, //  {0xA8, 0xB8018206, 0x9668, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x1C, 0x9E, 0x07, 0x00, 0xBB, 0x00, //  {0xA8, 0x00BB0007, 0x9E1C, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x30, 0x9E, 0x51, 0x80, 0x00, 0xBE, //  {0xA8, 0xBE008051, 0x9E30, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x30, 0x86, 0x50, 0xC0, 0x00, 0xBE, //  {0xA8, 0xBE00C050, 0x8630, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x54, 0x8E, 0x00, 0x01, 0xC0, 0x00, //  {0xA8, 0x00C00100, 0x8E54, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0B, 0x00, 0x54, 0x96, 0x02, 0x01, 0xC0, 0x00, //  {0xA8, 0x00C00102, 0x9654, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x10, 0x9E, 0x55, 0x01, 0xC0, 0x00, //  {0xA8, 0x00C00155, 0x9E10, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x10, 0x86, 0x5F, 0x01, 0xC0, 0x00, //  {0xA8, 0x00C0015F, 0x8610, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0xEC, 0x86, 0xC4, 0x00, 0x00, 0x00, //  {0xA8, 0x000000C4, 0x86EC, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x20, 0x84, 0x25, 0x16, 0x07, 0x0D, //  {0xA8, 0x0D071625, 0x8420, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0xF4, 0x86, 0x00, 0x0E, 0x00, 0x00, //  {0xA8, 0x00000E00, 0x86F4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0x8C, 0x00, 0x00, 0x33, 0xE0, //  {0xA8, 0xE0330000, 0x8C64, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0x9C, 0x00, 0x00, 0x33, 0xE0, //  {0xA8, 0xE0330000, 0x9C64, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0x94, 0x00, 0x00, 0x33, 0xE0, //  {0xA8, 0xE0330000, 0x9464, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0x84, 0x05, 0x00, 0x33, 0xE0, //  {0xA8, 0xE0330005, 0x8464, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x74, 0x9E, 0x49, 0xFF, 0x80, 0x0E, //  {0xA8, 0x0E80FF49, 0x9E74, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0E, 0x00, 0x80, 0x86, 0x60, 0x0F, 0xA0, 0xE8, //  {0xA8, 0xE8A00F60, 0x8680, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x3C, 0x86, 0xF0, 0x00, 0x00, 0x00, //  {0xA8, 0x000000F0, 0x863C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x40, 0x84, 0x00, 0xD2, 0x02, 0xFF, //  {0xA8, 0xFF02D200, 0x8440, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xC4, 0x9E, 0xFF, 0xFF, 0x3F, 0xFF, //  {0xA8, 0xFF3FFFFF, 0x9EC4, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xC4, 0x86, 0xFF, 0xFF, 0x3F, 0xFF, //  {0xA8, 0xFF3FFFFF, 0x86C4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x18, 0x87, 0x00, 0x0C, 0x00, 0x01, //  {0xAB, 0x01000C00, 0x8718, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x24, 0x87, 0x22, 0x22, 0x22, 0x10, //  {0xAB, 0x10222222, 0x8724, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x4C, 0x92, 0x35, 0xCB, 0x03, 0x01, //  {0xAB, 0x0103CB35, 0x924C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x4C, 0x86, 0x07, 0xC9, 0x05, 0x01, //  {0xAB, 0x0105C907, 0x864C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x40, 0x86, 0x58, 0xCF, 0x05, 0x01, //  {0xAB, 0x0105CF58, 0x8640, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x44, 0x86, 0x48, 0xD5, 0x05, 0x01, //  {0xAB, 0x0105D548, 0x8644, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x03, 0x00, 0x4C, 0x87, 0xFF, 0x08, 0x01, 0x00, //  {0xAB, 0x000108FF, 0x874C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x03, 0x00, 0x14, 0x90, 0x1D, 0xC5, 0x00, 0x11, //  {0xAB, 0x1100C51D, 0x9014, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x60, 0x86, 0x08, 0x00, 0x08, 0x13, //  {0xAB, 0x13080008, 0x8660, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x10, 0x92, 0xFF, 0x01, 0xC8, 0x14, //  {0xAB, 0x14C801FF, 0x9210, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x03, 0x00, 0x4C, 0x93, 0xDF, 0x4F, 0x01, 0x00, //  {0xAB, 0x00014FDF, 0x934C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x58, 0x85, 0x20, 0x1E, 0x1F, 0x15, //  {0xAB, 0x151F1E20, 0x8558, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x04, 0x84, 0x64, 0xC0, 0x15, 0x00, //  {0xAB, 0x0015C064, 0x8404, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x06, 0x00, 0x40, 0x87, 0x0A, 0x00, 0xE2, 0x16, //  {0xAB, 0x16E2000A, 0x8740, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x44, 0x93, 0x2B, 0x1F, 0x18, 0x00, //  {0xAB, 0x00181F2B, 0x9344, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x80, 0x86, 0x60, 0x17, 0xA0, 0x01, //  {0xAB, 0x01A01760, 0x8680, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0xE8, 0x86, 0x00, 0x48, 0x17, 0x1A, //  {0xAB, 0x1A174800, 0x86E8, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0xE8, 0x92, 0x00, 0x48, 0x22, 0x1A, //  {0xAB, 0x1A224800, 0x92E8, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x1C, 0x87, 0x03, 0x7F, 0x1B, 0x1B, //  {0xAB, 0x1B1B7F03, 0x871C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0xC0, 0x86, 0x00, 0x10, 0x88, 0x1B, //  {0xAB, 0x1B881000, 0x86C0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xE4, 0x86, 0x50, 0x45, 0x0B, 0x1C, //  {0xAB, 0x1C0B4550, 0x86E4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x10, 0x86, 0xFF, 0x01, 0xC8, 0x1E, //  {0xAB, 0x1EC801FF, 0x8610, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x08, 0x92, 0x50, 0xD1, 0xEC, 0x01, //  {0xAB, 0x01ECD150, 0x9208, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x24, 0x93, 0x36, 0x38, 0xB2, 0x1F, //  {0xAB, 0x1FB23836, 0x9324, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0E, 0x00, 0x40, 0x93, 0x0A, 0x00, 0xEB, 0x1F, //  {0xAB, 0x1FEB000A, 0x9340, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x04, 0x90, 0x44, 0x00, 0x21, 0x00, //  {0xAB, 0x00210044, 0x9004, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0xA4, 0x92, 0x21, 0x21, 0x21, 0x00, //  {0xAB, 0x00212121, 0x92A4, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0x1C, 0x93, 0x03, 0x7F, 0x21, 0x21, //  {0xAB, 0x21217F03, 0x931C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x0C, 0x93, 0x1F, 0xE0, 0x21, 0x21, //  {0xAB, 0x2121E01F, 0x930C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0xA0, 0x92, 0xEC, 0x70, 0x80, 0x21, //  {0xAB, 0x218070EC, 0x92A0, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x08, 0x86, 0x50, 0xD0, 0xEC, 0x21, //  {0xAB, 0x21ECD050, 0x8608, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x9C, 0x85, 0x00, 0x0C, 0x49, 0x22, //  {0xAB, 0x22490C00, 0x859C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x54, 0x93, 0x80, 0x54, 0x02, 0x00, //  {0xAB, 0x00025480, 0x9354, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0xA4, 0x86, 0x28, 0x28, 0x28, 0x00, //  {0xAB, 0x00282828, 0x86A4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xF0, 0x86, 0x20, 0x28, 0x28, 0x28, //  {0xAB, 0x28282820, 0x86F0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x18, 0x84, 0x7C, 0x00, 0x89, 0x02, //  {0xAB, 0x0289007C, 0x8418, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0D, 0x00, 0xA0, 0x86, 0xE9, 0x70, 0xC0, 0x28, //  {0xAB, 0x28C070E9, 0x86A0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x9C, 0x86, 0x00, 0x00, 0x2C, 0x00, //  {0xAB, 0x002C0000, 0x869C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x14, 0x86, 0x9F, 0x63, 0x0C, 0x03, //  {0xAB, 0x030C639F, 0x8614, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0D, 0x00, 0x40, 0x92, 0x4E, 0xCF, 0x18, 0x03, //  {0xAB, 0x0318CF4E, 0x9240, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x60, 0x92, 0x08, 0x00, 0x08, 0x33, //  {0xAB, 0x33080008, 0x9260, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x14, 0x92, 0x9F, 0x63, 0x3C, 0x03, //  {0xAB, 0x033C639F, 0x9214, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x5C, 0x86, 0x2E, 0x08, 0x3B, 0x00, //  {0xAB, 0x003B082E, 0x865C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x09, 0x00, 0x1C, 0x92, 0xF8, 0x10, 0x3B, 0x00, //  {0xAB, 0x003B10F8, 0x921C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x5C, 0x90, 0x96, 0xBC, 0x1F, 0x3F, //  {0xAB, 0x3F1FBC96, 0x905C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x10, 0x93, 0x68, 0x00, 0x40, 0x00, //  {0xAB, 0x00400068, 0x9310, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xCC, 0x92, 0x18, 0x17, 0x17, 0x40, //  {0xAB, 0x40171718, 0x92CC, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x7C, 0x92, 0x18, 0x18, 0x24, 0x40, //  {0xAB, 0x40241818, 0x927C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x70, 0x92, 0x58, 0x25, 0x40, 0x40, //  {0xAB, 0x40402558, 0x9270, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x70, 0x86, 0x5E, 0x25, 0x40, 0x40, //  {0xAB, 0x4040255E, 0x8670, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x80, 0x92, 0x40, 0x17, 0x04, 0x04, //  {0xAB, 0x04041740, 0x9280, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x20, 0x86, 0x00, 0x44, 0x00, 0x00, //  {0xAB, 0x00004400, 0x8620, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x8C, 0x86, 0x58, 0x40, 0x04, 0x00, //  {0xAB, 0x00044058, 0x868C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x18, 0x93, 0x21, 0x00, 0x00, 0x4A, //  {0xAB, 0x4A000021, 0x9318, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0xE4, 0x92, 0x40, 0xA5, 0x0B, 0x4B, //  {0xAB, 0x4B0BA540, 0x92E4, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x64, 0x91, 0x4C, 0x50, 0x4C, 0x4C, //  {0xAB, 0x4C4C504C, 0x9164, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x0C, 0x92, 0xE6, 0x9B, 0x52, 0x00, //  {0xAB, 0x00529BE6, 0x920C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x50, 0x86, 0x3F, 0x3F, 0x3F, 0x05, //  {0xAB, 0x053F3F3F, 0x8650, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x06, 0x00, 0x64, 0x92, 0x00, 0x54, 0x00, 0x00, //  {0xAB, 0x00005400, 0x9264, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x1C, 0x84, 0x00, 0xC0, 0x00, 0x60, //  {0xAB, 0x6000C000, 0x841C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xAC, 0x86, 0xE9, 0x60, 0x00, 0x00, //  {0xAB, 0x000060E9, 0x86AC, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x06, 0x00, 0x54, 0x87, 0x80, 0x50, 0x06, 0x00, //  {0xAB, 0x00065080, 0x8754, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x1C, 0x86, 0x08, 0x10, 0x3B, 0x68, //  {0xAB, 0x683B1008, 0x861C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x06, 0x00, 0x10, 0x84, 0x00, 0x00, 0xBF, 0x72, //  {0xAB, 0x72BF0000, 0x8410, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xEC, 0x86, 0x04, 0x80, 0x00, 0x00, //  {0xAB, 0x00008004, 0x86EC, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xE0, 0x92, 0x02, 0x60, 0x00, 0x08, //  {0xAB, 0x08006002, 0x92E0, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x2C, 0x86, 0x5A, 0x10, 0x08, 0x00, //  {0xAB, 0x0008105A, 0x862C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x20, 0x87, 0x04, 0x02, 0x12, 0x08, //  {0xAB, 0x08120204, 0x8720, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x58, 0x86, 0x09, 0xA0, 0x32, 0x81, //  {0xAB, 0x8132A009, 0x8658, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0xD4, 0x86, 0xC0, 0x80, 0x82, 0x00, //  {0xAB, 0x008280C0, 0x86D4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x8C, 0x92, 0x20, 0x48, 0x86, 0x00, //  {0xAB, 0x00864820, 0x928C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0xB4, 0x92, 0x40, 0x40, 0x81, 0x08, //  {0xAB, 0x08814040, 0x92B4, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x54, 0x86, 0x02, 0x00, 0xC0, 0x88, //  {0xAB, 0x88C00002, 0x8654, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x0C, 0x86, 0xE4, 0x9B, 0x92, 0x00, //  {0xAB, 0x00929BE4, 0x860C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x3C, 0x84, 0x02, 0x9F, 0x00, 0x00, //  {0xAB, 0x00009F02, 0x843C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x64, 0x86, 0x00, 0xA4, 0x00, 0x00, //  {0xAB, 0x0000A400, 0x8664, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x24, 0x84, 0x10, 0x0A, 0x0B, 0xA4, //  {0xAB, 0xA40B0A10, 0x8424, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x24, 0x90, 0x0F, 0x0C, 0x0C, 0xA4, //  {0xAB, 0xA40C0C0F, 0x9024, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x88, 0x92, 0x10, 0x30, 0x76, 0xA4, //  {0xAB, 0xA4763010, 0x9288, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x24, 0x92, 0xF8, 0x18, 0x33, 0xAA, //  {0xAB, 0xAA3318F8, 0x9224, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x2C, 0x92, 0x0C, 0x00, 0x0B, 0x00, //  {0xAB, 0x000B000C, 0x922C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0A, 0x00, 0x00, 0x92, 0x70, 0x94, 0x52, 0x0B, //  {0xAB, 0x0B529470, 0x9200, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0A, 0x00, 0x00, 0x86, 0x70, 0xA8, 0x52, 0x0B, //  {0xAB, 0x0B52A870, 0x8600, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x68, 0x92, 0x06, 0x82, 0x10, 0xB8, //  {0xAB, 0xB8108206, 0x9268, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x68, 0x86, 0x2A, 0x82, 0x10, 0xB8, //  {0xAB, 0xB810822A, 0x8668, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x30, 0x86, 0x50, 0xC0, 0x00, 0xBE, //  {0xAB, 0xBE00C050, 0x8630, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x04, 0x93, 0x80, 0xAA, 0x01, 0xC0, //  {0xAB, 0xC001AA80, 0x9304, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0x08, 0x87, 0x45, 0x34, 0xDF, 0xCC, //  {0xAB, 0xCCDF3445, 0x8708, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x20, 0x93, 0x04, 0x04, 0x04, 0x0D, //  {0xAB, 0x0D040404, 0x9320, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x20, 0x84, 0x25, 0x16, 0x07, 0x0D, //  {0xAB, 0x0D071625, 0x8420, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x20, 0x90, 0x26, 0x16, 0x07, 0x0D, //  {0xAB, 0x0D071626, 0x9020, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0D, 0x00, 0x08, 0x93, 0x75, 0x34, 0xC8, 0xD0, //  {0xAB, 0xD0C83475, 0x9308, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0x48, 0x93, 0x88, 0x0A, 0x8A, 0xD3, //  {0xAB, 0xD38A0A88, 0x9348, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x48, 0x87, 0x88, 0x0A, 0x8D, 0xD7, //  {0xAB, 0xD78D0A88, 0x8748, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xC4, 0x86, 0xD1, 0xEC, 0x21, 0xE4, //  {0xAB, 0xE421ECD1, 0x86C4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0B, 0x00, 0x88, 0x86, 0x20, 0x70, 0x74, 0xE4, //  {0xAB, 0xE4747020, 0x8688, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xC4, 0x92, 0xD1, 0xEC, 0x01, 0xE6, //  {0xAB, 0xE601ECD1, 0x92C4, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x14, 0x93, 0x08, 0x1C, 0x05, 0x0F, //  {0xAB, 0x0F051C08, 0x9314, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x04, 0x86, 0x09, 0x09, 0x0F, 0x00, //  {0xAB, 0x000F0909, 0x8604, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x04, 0x92, 0x09, 0x0B, 0x0F, 0x00, //  {0xAB, 0x000F0B09, 0x9204, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x28, 0x87, 0x00, 0x00, 0x04, 0xFC, //  {0xAB, 0xFC040000, 0x8728, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x40, 0x84, 0xF0, 0xD2, 0x02, 0xFF, //  {0xAB, 0xFF02D2F0, 0x8440, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0x28, 0x93, 0x00, 0x00, 0x1A, 0xFF, //  {0xAB, 0xFF1A0000, 0x9328, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x64, 0x86, 0x08, 0x54, 0x00, 0x00, //  {0xA8, 0x00005408, 0x8664, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x64, 0x86, 0x08, 0xA4, 0x00, 0x00, //  {0xAB, 0x0000A408, 0x8664, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x0F, 0x00, 0x00, 0x00,                                                 //  End Table Marker
};

UINT8 CnlPchHChipsetInitTable_eDBC_A0[] = {
  0xD6, 0xF0, //CRC-16
  0x02,       //Version
  0xd0,       //Product/Stepping
  // Phy Data Group Table (Fixed table with 16 Entries)
  0x00, 0x00,
  0x06, 0x73,
  0x00, 0x0F,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  0x00, 0x00,
  // HSIO Command Table
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x30, 0x80, 0x01, 0x04, 0x30, 0x00, //  {0xA8, 0x00300401, 0x8030, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x3C, 0x80, 0x02, 0x00, 0x00, 0x00, //  {0xA8, 0x00000002, 0x803C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x48, 0x80, 0x00, 0x00, 0x21, 0x01, //  {0xA8, 0x01210000, 0x8048, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x4C, 0x80, 0x00, 0x0C, 0x00, 0x00, //  {0xA8, 0x00000C00, 0x804C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x60, 0x80, 0x01, 0x00, 0x00, 0x00, //  {0xA8, 0x00000001, 0x8060, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xE8, 0x80, 0x80, 0x08, 0x01, 0x3C, //  {0xA8, 0x3C010880, 0x80E8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x38, 0x81, 0xAC, 0xD4, 0x00, 0x00, //  {0xA8, 0x0000D4AC, 0x8138, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0B, 0x00, 0x90, 0x81, 0x02, 0x06, 0x01, 0x0C, //  {0xA8, 0x0C010602, 0x8190, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0xA8, 0x81, 0x06, 0x00, 0x1F, 0x00, //  {0xA8, 0x001F0006, 0x81A8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0xB0, 0x81, 0x00, 0x3C, 0x00, 0x78, //  {0xA8, 0x78003C00, 0x81B0, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xC8, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xA8, 0x00000001, 0x81C8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xCC, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xA8, 0x00000001, 0x81CC, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x01, 0x00, 0x30, 0x80, 0x01, 0x04, 0x30, 0x00, //  {0xA9, 0x00300401, 0x8030, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x01, 0x00, 0x3C, 0x80, 0x02, 0x00, 0x00, 0x00, //  {0xA9, 0x00000002, 0x803C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x0F, 0x00, 0x48, 0x80, 0x00, 0x00, 0x21, 0x01, //  {0xA9, 0x01210000, 0x8048, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x0F, 0x00, 0x4C, 0x80, 0x00, 0x0C, 0x00, 0x00, //  {0xA9, 0x00000C00, 0x804C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x0F, 0x00, 0x60, 0x80, 0xC1, 0x00, 0x00, 0x09, //  {0xA9, 0x090000C1, 0x8060, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x04, 0x00, 0xE8, 0x80, 0x80, 0x08, 0x01, 0x3C, //  {0xA9, 0x3C010880, 0x80E8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x08, 0x00, 0x38, 0x81, 0xAC, 0xD4, 0x00, 0x00, //  {0xA9, 0x0000D4AC, 0x8138, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x0A, 0x00, 0xB0, 0x81, 0x00, 0x3C, 0x00, 0x78, //  {0xA9, 0x78003C00, 0x81B0, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x01, 0x00, 0xC8, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xA9, 0x00000001, 0x81C8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xA9, 0x07, 0x00, 0x01, 0x00, 0xCC, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xA9, 0x00000001, 0x81CC, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x04, 0x80, 0x60, 0x00, 0x00, 0x20, //  {0xAB, 0x20000060, 0x8004, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x08, 0x80, 0x00, 0x00, 0x00, 0x00, //  {0xAB, 0x00000000, 0x8008, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x30, 0x80, 0x01, 0x04, 0x30, 0x00, //  {0xAB, 0x00300401, 0x8030, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x3C, 0x80, 0x02, 0x00, 0x00, 0x00, //  {0xAB, 0x00000002, 0x803C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x48, 0x80, 0x00, 0x00, 0x21, 0x01, //  {0xAB, 0x01210000, 0x8048, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x4C, 0x80, 0x00, 0x0C, 0x00, 0x00, //  {0xAB, 0x00000C00, 0x804C, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x60, 0x80, 0x0F, 0x00, 0x00, 0x00, //  {0xAB, 0x0000000F, 0x8060, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0xE8, 0x80, 0x80, 0x08, 0x01, 0x3C, //  {0xAB, 0x3C010880, 0x80E8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0B, 0x00, 0x90, 0x81, 0x03, 0x06, 0x01, 0x0A, //  {0xAB, 0x0A010603, 0x8190, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x0A, 0x00, 0xB0, 0x81, 0x00, 0x3C, 0x00, 0x78, //  {0xAB, 0x78003C00, 0x81B0, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xC8, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xAB, 0x00000001, 0x81C8, PCH_LANE_OWN_COMMON, LANE},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xCC, 0x81, 0x01, 0x00, 0x00, 0x00, //  {0xAB, 0x00000001, 0x81CC, PCH_LANE_OWN_COMMON, LANE},
  0x0F, 0x00, 0x00, 0x00,                                                 //  End Table Marker
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x28, 0xFC, 0xE0, 0x01, 0x02, 0x01, //  {0xA8, 0x010201E0, 0xFC28, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x24, 0xFC, 0x10, 0x0A, 0x0B, 0xA4, //  {0xA8, 0xA40B0A10, 0xFC24, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0xFC, 0x00, 0x02, 0x1B, 0xE0, //  {0xA8, 0xE01B0200, 0xFC64, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x50, 0xFF, 0x6E, 0x80, 0x10, 0x10, //  {0xAB, 0x1010806E, 0xFF50, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x28, 0xFC, 0xE0, 0x01, 0x02, 0x01, //  {0xAB, 0x010201E0, 0xFC28, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x8C, 0xFD, 0x00, 0x08, 0x1F, 0x20, //  {0xAB, 0x201F0800, 0xFD8C, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x54, 0xFD, 0x06, 0x2A, 0x29, 0x28, //  {0xAB, 0x28292A06, 0xFD54, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0xC8, 0xFE, 0x50, 0x88, 0x8D, 0x3F, //  {0xAB, 0x3F8D8850, 0xFEC8, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x78, 0xFE, 0x60, 0x40, 0x83, 0x40, //  {0xAB, 0x40834060, 0xFE78, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x84, 0xFD, 0x08, 0x0A, 0x00, 0x08, //  {0xAB, 0x08000A08, 0xFD84, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x00, 0xFC, 0x00, 0x01, 0x82, 0x80, //  {0xAB, 0x80820100, 0xFC00, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x18, 0xFE, 0xBF, 0x00, 0x00, 0x00, //  {0xAB, 0x000000BF, 0xFE18, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x3C, 0xFE, 0xF0, 0x00, 0x00, 0x00, //  {0xAB, 0x000000F0, 0xFE3C, PCH_LANE_BDCAST, BDCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xEC, 0x9E, 0x00, 0x00, 0x00, 0x00, //  {0xA8, 0x00000000, 0x9EEC, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x4C, 0x86, 0x07, 0xC9, 0x02, 0x01, //  {0xA8, 0x0102C907, 0x864C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x44, 0x96, 0x48, 0x15, 0x05, 0x01, //  {0xA8, 0x01051548, 0x9644, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x48, 0x96, 0x4C, 0x15, 0x05, 0x01, //  {0xA8, 0x0105154C, 0x9648, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x44, 0x9E, 0x4C, 0x17, 0x05, 0x01, //  {0xA8, 0x0105174C, 0x9E44, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x48, 0x8E, 0x4C, 0x19, 0x05, 0x01, //  {0xA8, 0x0105194C, 0x8E48, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x48, 0x9E, 0x4C, 0x19, 0x05, 0x01, //  {0xA8, 0x0105194C, 0x9E48, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x40, 0x86, 0x58, 0xCF, 0x05, 0x01, //  {0xA8, 0x0105CF58, 0x8640, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x44, 0x86, 0x48, 0xD5, 0x05, 0x01, //  {0xA8, 0x0105D548, 0x8644, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x40, 0x96, 0x5F, 0xD3, 0x18, 0x01, //  {0xA8, 0x0118D35F, 0x9640, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x0C, 0x86, 0xE4, 0x9B, 0x12, 0x00, //  {0xA8, 0x00129BE4, 0x860C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0C, 0x00, 0x58, 0x96, 0x09, 0xA0, 0x33, 0x01, //  {0xA8, 0x0133A009, 0x9658, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0xF4, 0x96, 0x00, 0x14, 0x00, 0x00, //  {0xA8, 0x00001400, 0x96F4, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x58, 0x95, 0x00, 0x28, 0x1F, 0x15, //  {0xA8, 0x151F2800, 0x9558, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0xCC, 0x9E, 0x21, 0x17, 0x17, 0x00, //  {0xA8, 0x00171721, 0x9ECC, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xE8, 0x9E, 0x00, 0x48, 0x17, 0x18, //  {0xA8, 0x18174800, 0x9EE8, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0xA0, 0x86, 0xE9, 0x00, 0x00, 0x1C, //  {0xA8, 0x1C0000E9, 0x86A0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0D, 0x00, 0xE4, 0x86, 0x50, 0x05, 0x0B, 0x1C, //  {0xA8, 0x1C0B0550, 0x86E4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0xA4, 0x86, 0x1C, 0x1C, 0x1C, 0x00, //  {0xA8, 0x001C1C1C, 0x86A4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x8C, 0x9D, 0x20, 0x00, 0x1F, 0x20, //  {0xA8, 0x201F0020, 0x9D8C, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x8C, 0x85, 0x00, 0x08, 0x1F, 0x20, //  {0xA8, 0x201F0800, 0x858C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x18, 0x84, 0x7C, 0x00, 0x09, 0x02, //  {0xA8, 0x0209007C, 0x8418, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0x08, 0x8E, 0x50, 0x18, 0xE0, 0x21, //  {0xA8, 0x21E01850, 0x8E08, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0x08, 0x96, 0x50, 0x18, 0xE0, 0x21, //  {0xA8, 0x21E01850, 0x9608, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0D, 0x00, 0x08, 0x86, 0x50, 0x18, 0xEC, 0x21, //  {0xA8, 0x21EC1850, 0x8608, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x9C, 0x85, 0x00, 0x0C, 0x49, 0x22, //  {0xA8, 0x22490C00, 0x859C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x04, 0x8C, 0x44, 0x01, 0x24, 0x00, //  {0xA8, 0x00240144, 0x8C04, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x04, 0x9C, 0x44, 0x01, 0x24, 0x00, //  {0xA8, 0x00240144, 0x9C04, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x88, 0x86, 0x20, 0x00, 0x74, 0x24, //  {0xA8, 0x24740020, 0x8688, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0xF0, 0x86, 0x20, 0x28, 0x28, 0x28, //  {0xA8, 0x28282820, 0x86F0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x54, 0x85, 0x06, 0x2A, 0x29, 0x28, //  {0xA8, 0x28292A06, 0x8554, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x54, 0x95, 0x06, 0x2D, 0x2D, 0x28, //  {0xA8, 0x282D2D06, 0x9554, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0xB4, 0x8E, 0x40, 0x40, 0x81, 0x2C, //  {0xA8, 0x2C814040, 0x8EB4, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0xB4, 0x86, 0x40, 0x40, 0x81, 0x2C, //  {0xA8, 0x2C814040, 0x86B4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0xB4, 0x96, 0x40, 0x40, 0x81, 0x2C, //  {0xA8, 0x2C814040, 0x96B4, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x14, 0x86, 0x1F, 0x63, 0x20, 0x03, //  {0xA8, 0x0320631F, 0x8614, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x14, 0x9E, 0x1F, 0x61, 0x30, 0x03, //  {0xA8, 0x0330611F, 0x9E14, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x1C, 0x96, 0x58, 0x00, 0x3B, 0x00, //  {0xA8, 0x003B0058, 0x961C, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x1C, 0x8E, 0xA8, 0x00, 0x3B, 0x00, //  {0xA8, 0x003B00A8, 0x8E1C, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x5C, 0x96, 0x2A, 0x08, 0x3F, 0x00, //  {0xA8, 0x003F082A, 0x965C, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x08, 0x9E, 0x50, 0x18, 0xE0, 0x3F, //  {0xA8, 0x3FE01850, 0x9E08, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x70, 0x86, 0x5A, 0x25, 0x40, 0x40, //  {0xA8, 0x4040255A, 0x8670, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x70, 0x9E, 0x5B, 0x25, 0x40, 0x40, //  {0xA8, 0x4040255B, 0x9E70, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x78, 0x8E, 0x60, 0x40, 0x83, 0x40, //  {0xA8, 0x40834060, 0x8E78, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x78, 0x9E, 0x60, 0x40, 0x83, 0x40, //  {0xA8, 0x40834060, 0x9E78, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x78, 0x86, 0x60, 0x40, 0x83, 0x40, //  {0xA8, 0x40834060, 0x8678, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x78, 0x96, 0x60, 0x40, 0x83, 0x40, //  {0xA8, 0x40834060, 0x9678, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x04, 0x94, 0x45, 0x01, 0x24, 0x04, //  {0xA8, 0x04240145, 0x9404, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x50, 0x96, 0x3F, 0x3F, 0x3F, 0x04, //  {0xA8, 0x043F3F3F, 0x9650, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x8C, 0x86, 0x58, 0x40, 0x04, 0x00, //  {0xA8, 0x00044058, 0x868C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x20, 0x8E, 0x00, 0x48, 0x00, 0x00, //  {0xA8, 0x00004800, 0x8E20, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x20, 0x96, 0x00, 0x48, 0x00, 0x00, //  {0xA8, 0x00004800, 0x9620, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x20, 0x86, 0x00, 0x4C, 0x00, 0x00, //  {0xA8, 0x00004C00, 0x8620, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x9C, 0x86, 0x00, 0x00, 0x4C, 0x00, //  {0xA8, 0x004C0000, 0x869C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x04, 0x96, 0x09, 0x00, 0x05, 0x00, //  {0xA8, 0x00050009, 0x9604, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x04, 0x8E, 0x09, 0x09, 0x05, 0x00, //  {0xA8, 0x00050909, 0x8E04, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x04, 0x9E, 0x09, 0x09, 0x05, 0x00, //  {0xA8, 0x00050909, 0x9E04, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x04, 0x86, 0x09, 0x09, 0x05, 0x00, //  {0xA8, 0x00050909, 0x8604, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x00, 0x86, 0x00, 0xA8, 0x52, 0x00, //  {0xA8, 0x0052A800, 0x8600, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x50, 0x86, 0x3F, 0x3F, 0x3F, 0x05, //  {0xA8, 0x053F3F3F, 0x8650, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x64, 0x86, 0x00, 0x54, 0x00, 0x00, //  {0xA8, 0x00005400, 0x8664, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0xC0, 0x86, 0x00, 0x00, 0x88, 0x5B, //  {0xA8, 0x5B880000, 0x86C0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x1C, 0x84, 0x00, 0xC0, 0x00, 0x60, //  {0xA8, 0x6000C000, 0x841C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x5C, 0x86, 0x2A, 0x08, 0x60, 0x00, //  {0xA8, 0x0060082A, 0x865C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xC8, 0x86, 0x50, 0x88, 0x8D, 0x60, //  {0xA8, 0x608D8850, 0x86C8, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0xAC, 0x86, 0xE9, 0x60, 0x00, 0x00, //  {0xA8, 0x000060E9, 0x86AC, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x50, 0x9E, 0x3F, 0x3F, 0x3F, 0x06, //  {0xA8, 0x063F3F3F, 0x9E50, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x04, 0x84, 0x64, 0xC1, 0x64, 0x00, //  {0xA8, 0x0064C164, 0x8404, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0x1C, 0x86, 0xA8, 0x00, 0x3B, 0x6E, //  {0xA8, 0x6E3B00A8, 0x861C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x10, 0x8C, 0x00, 0x00, 0xBF, 0x72, //  {0xA8, 0x72BF0000, 0x8C10, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x10, 0x84, 0x00, 0x00, 0xBF, 0x72, //  {0xA8, 0x72BF0000, 0x8410, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x10, 0x94, 0x00, 0x00, 0xBF, 0x72, //  {0xA8, 0x72BF0000, 0x9410, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x90, 0x86, 0x48, 0x30, 0x50, 0x75, //  {0xA8, 0x75503048, 0x8690, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x38, 0x9C, 0x7F, 0x00, 0x00, 0x00, //  {0xA8, 0x0000007F, 0x9C38, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x38, 0x84, 0x7F, 0x00, 0x00, 0x00, //  {0xA8, 0x0000007F, 0x8438, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0xE0, 0x86, 0x00, 0x04, 0x00, 0x08, //  {0xA8, 0x08000400, 0x86E0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x08, 0x00, 0x84, 0x85, 0x08, 0x0A, 0x00, 0x08, //  {0xA8, 0x08000A08, 0x8584, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x00, 0x8C, 0x00, 0x01, 0x02, 0x80, //  {0xA8, 0x80020100, 0x8C00, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0C, 0x00, 0x00, 0x9C, 0x00, 0x01, 0x02, 0x80, //  {0xA8, 0x80020100, 0x9C00, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x00, 0x84, 0x00, 0x01, 0x02, 0x80, //  {0xA8, 0x80020100, 0x8400, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0x00, 0x94, 0x00, 0x01, 0x02, 0x80, //  {0xA8, 0x80020100, 0x9400, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x03, 0x00, 0x54, 0x9E, 0x02, 0x01, 0xC0, 0x80, //  {0xA8, 0x80C00102, 0x9E54, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x58, 0x9E, 0x09, 0xA0, 0x31, 0x81, //  {0xA8, 0x8131A009, 0x9E58, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x58, 0x86, 0x09, 0xA0, 0x31, 0x81, //  {0xA8, 0x8131A009, 0x8658, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x8C, 0x96, 0x7C, 0x20, 0x08, 0x00, //  {0xA8, 0x0008207C, 0x968C, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xD4, 0x86, 0xC0, 0x80, 0x82, 0x00, //  {0xA8, 0x008280C0, 0x86D4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x8C, 0x8E, 0x7C, 0x80, 0x08, 0x00, //  {0xA8, 0x0008807C, 0x8E8C, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x8C, 0x9E, 0x7C, 0x80, 0x08, 0x00, //  {0xA8, 0x0008807C, 0x9E8C, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x09, 0x00, 0x54, 0x86, 0x02, 0x00, 0xC0, 0x08, //  {0xA8, 0x08C00002, 0x8654, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x74, 0x86, 0x49, 0xFF, 0x80, 0x8D, //  {0xA8, 0x8D80FF49, 0x8674, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x74, 0x8E, 0x49, 0xFF, 0x80, 0x8E, //  {0xA8, 0x8E80FF49, 0x8E74, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x74, 0x96, 0x49, 0xFF, 0x80, 0x8E, //  {0xA8, 0x8E80FF49, 0x9674, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x00, 0x96, 0x00, 0x29, 0x52, 0x09, //  {0xA8, 0x09522900, 0x9600, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x00, 0x8E, 0x00, 0x69, 0x52, 0x09, //  {0xA8, 0x09526900, 0x8E00, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x06, 0x00, 0x00, 0x9E, 0x00, 0x69, 0x52, 0x09, //  {0xA8, 0x09526900, 0x9E00, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x3C, 0x84, 0x02, 0x9F, 0x00, 0x00, //  {0xA8, 0x00009F02, 0x843C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x07, 0x00, 0x2C, 0x86, 0x0A, 0x10, 0x0A, 0x00, //  {0xA8, 0x000A100A, 0x862C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x24, 0x86, 0xFC, 0x60, 0x33, 0xAA, //  {0xA8, 0xAA3360FC, 0x8624, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0D, 0x00, 0x68, 0x86, 0x2A, 0x82, 0x00, 0xB8, //  {0xA8, 0xB800822A, 0x8668, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x68, 0x96, 0x06, 0x82, 0x01, 0xB8, //  {0xA8, 0xB8018206, 0x9668, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x05, 0x00, 0x1C, 0x9E, 0x07, 0x00, 0xBB, 0x00, //  {0xA8, 0x00BB0007, 0x9E1C, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x30, 0x9E, 0x51, 0x80, 0x00, 0xBE, //  {0xA8, 0xBE008051, 0x9E30, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x30, 0x86, 0x50, 0xC0, 0x00, 0xBE, //  {0xA8, 0xBE00C050, 0x8630, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x54, 0x8E, 0x00, 0x01, 0xC0, 0x00, //  {0xA8, 0x00C00100, 0x8E54, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0B, 0x00, 0x54, 0x96, 0x02, 0x01, 0xC0, 0x00, //  {0xA8, 0x00C00102, 0x9654, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x10, 0x9E, 0x55, 0x01, 0xC0, 0x00, //  {0xA8, 0x00C00155, 0x9E10, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x10, 0x86, 0x5F, 0x01, 0xC0, 0x00, //  {0xA8, 0x00C0015F, 0x8610, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0xEC, 0x86, 0xC4, 0x00, 0x00, 0x00, //  {0xA8, 0x000000C4, 0x86EC, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x20, 0x84, 0x25, 0x16, 0x07, 0x0D, //  {0xA8, 0x0D071625, 0x8420, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0xF4, 0x86, 0x00, 0x0E, 0x00, 0x00, //  {0xA8, 0x00000E00, 0x86F4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0x8C, 0x00, 0x00, 0x33, 0xE0, //  {0xA8, 0xE0330000, 0x8C64, V_PCH_PCR_FIA_LANE_OWN_GBE, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0x9C, 0x00, 0x00, 0x33, 0xE0, //  {0xA8, 0xE0330000, 0x9C64, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0x94, 0x00, 0x00, 0x33, 0xE0, //  {0xA8, 0xE0330000, 0x9464, V_PCH_PCR_FIA_LANE_OWN_SATA, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0F, 0x00, 0x64, 0x84, 0x05, 0x00, 0x33, 0xE0, //  {0xA8, 0xE0330005, 0x8464, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0A, 0x00, 0x74, 0x9E, 0x49, 0xFF, 0x80, 0x0E, //  {0xA8, 0x0E80FF49, 0x9E74, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x0E, 0x00, 0x80, 0x86, 0x60, 0x0F, 0xA0, 0xE8, //  {0xA8, 0xE8A00F60, 0x8680, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x3C, 0x86, 0xF0, 0x00, 0x00, 0x00, //  {0xA8, 0x000000F0, 0x863C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x02, 0x00, 0x40, 0x84, 0x00, 0xD2, 0x02, 0xFF, //  {0xA8, 0xFF02D200, 0x8440, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xC4, 0x9E, 0xFF, 0xFF, 0x3F, 0xFF, //  {0xA8, 0xFF3FFFFF, 0x9EC4, V_PCH_PCR_FIA_LANE_OWN_UFS, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x04, 0x00, 0xC4, 0x86, 0xFF, 0xFF, 0x3F, 0xFF, //  {0xA8, 0xFF3FFFFF, 0x86C4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x18, 0x87, 0x00, 0x0C, 0x00, 0x01, //  {0xAB, 0x01000C00, 0x8718, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x24, 0x87, 0x22, 0x22, 0x22, 0x10, //  {0xAB, 0x10222222, 0x8724, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x4C, 0x92, 0x35, 0xCB, 0x03, 0x01, //  {0xAB, 0x0103CB35, 0x924C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x4C, 0x86, 0x07, 0xC9, 0x05, 0x01, //  {0xAB, 0x0105C907, 0x864C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x40, 0x86, 0x58, 0xCF, 0x05, 0x01, //  {0xAB, 0x0105CF58, 0x8640, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x44, 0x86, 0x48, 0xD5, 0x05, 0x01, //  {0xAB, 0x0105D548, 0x8644, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x03, 0x00, 0x4C, 0x87, 0xFF, 0x08, 0x01, 0x00, //  {0xAB, 0x000108FF, 0x874C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x03, 0x00, 0x14, 0x90, 0x1D, 0xC5, 0x00, 0x11, //  {0xAB, 0x1100C51D, 0x9014, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x60, 0x86, 0x08, 0x00, 0x08, 0x13, //  {0xAB, 0x13080008, 0x8660, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x10, 0x92, 0xFF, 0x01, 0xC8, 0x14, //  {0xAB, 0x14C801FF, 0x9210, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x03, 0x00, 0x4C, 0x93, 0xDF, 0x4F, 0x01, 0x00, //  {0xAB, 0x00014FDF, 0x934C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x58, 0x85, 0x20, 0x1E, 0x1F, 0x15, //  {0xAB, 0x151F1E20, 0x8558, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x04, 0x84, 0x64, 0xC0, 0x15, 0x00, //  {0xAB, 0x0015C064, 0x8404, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x06, 0x00, 0x40, 0x87, 0x0A, 0x00, 0xE2, 0x16, //  {0xAB, 0x16E2000A, 0x8740, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x44, 0x93, 0x2B, 0x1F, 0x18, 0x00, //  {0xAB, 0x00181F2B, 0x9344, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x80, 0x86, 0x60, 0x17, 0xA0, 0x01, //  {0xAB, 0x01A01760, 0x8680, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0xE8, 0x86, 0x00, 0x48, 0x17, 0x1A, //  {0xAB, 0x1A174800, 0x86E8, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0xE8, 0x92, 0x00, 0x48, 0x22, 0x1A, //  {0xAB, 0x1A224800, 0x92E8, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x1C, 0x87, 0x03, 0x7F, 0x1B, 0x1B, //  {0xAB, 0x1B1B7F03, 0x871C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0xC0, 0x86, 0x00, 0x10, 0x88, 0x1B, //  {0xAB, 0x1B881000, 0x86C0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xE4, 0x86, 0x50, 0x45, 0x0B, 0x1C, //  {0xAB, 0x1C0B4550, 0x86E4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x10, 0x86, 0xFF, 0x01, 0xC8, 0x1E, //  {0xAB, 0x1EC801FF, 0x8610, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x08, 0x92, 0x50, 0xD1, 0xEC, 0x01, //  {0xAB, 0x01ECD150, 0x9208, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x24, 0x93, 0x36, 0x38, 0xB2, 0x1F, //  {0xAB, 0x1FB23836, 0x9324, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0E, 0x00, 0x40, 0x93, 0x0A, 0x00, 0xEB, 0x1F, //  {0xAB, 0x1FEB000A, 0x9340, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x04, 0x90, 0x44, 0x00, 0x21, 0x00, //  {0xAB, 0x00210044, 0x9004, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0xA4, 0x92, 0x21, 0x21, 0x21, 0x00, //  {0xAB, 0x00212121, 0x92A4, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0x1C, 0x93, 0x03, 0x7F, 0x21, 0x21, //  {0xAB, 0x21217F03, 0x931C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x0C, 0x93, 0x1F, 0xE0, 0x21, 0x21, //  {0xAB, 0x2121E01F, 0x930C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0xA0, 0x92, 0xEC, 0x70, 0x80, 0x21, //  {0xAB, 0x218070EC, 0x92A0, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x08, 0x86, 0x50, 0xD0, 0xEC, 0x21, //  {0xAB, 0x21ECD050, 0x8608, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x9C, 0x85, 0x00, 0x0C, 0x49, 0x22, //  {0xAB, 0x22490C00, 0x859C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x54, 0x93, 0x80, 0x54, 0x02, 0x00, //  {0xAB, 0x00025480, 0x9354, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0xA4, 0x86, 0x28, 0x28, 0x28, 0x00, //  {0xAB, 0x00282828, 0x86A4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xF0, 0x86, 0x20, 0x28, 0x28, 0x28, //  {0xAB, 0x28282820, 0x86F0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x18, 0x84, 0x7C, 0x00, 0x89, 0x02, //  {0xAB, 0x0289007C, 0x8418, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0D, 0x00, 0xA0, 0x86, 0xE9, 0x70, 0xC0, 0x28, //  {0xAB, 0x28C070E9, 0x86A0, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x9C, 0x86, 0x00, 0x00, 0x2C, 0x00, //  {0xAB, 0x002C0000, 0x869C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x14, 0x86, 0x9F, 0x63, 0x0C, 0x03, //  {0xAB, 0x030C639F, 0x8614, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0D, 0x00, 0x40, 0x92, 0x4E, 0xCF, 0x18, 0x03, //  {0xAB, 0x0318CF4E, 0x9240, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x60, 0x92, 0x08, 0x00, 0x08, 0x33, //  {0xAB, 0x33080008, 0x9260, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x14, 0x92, 0x9F, 0x63, 0x3C, 0x03, //  {0xAB, 0x033C639F, 0x9214, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x5C, 0x86, 0x2E, 0x08, 0x3B, 0x00, //  {0xAB, 0x003B082E, 0x865C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x09, 0x00, 0x1C, 0x92, 0xF8, 0x10, 0x3B, 0x00, //  {0xAB, 0x003B10F8, 0x921C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x5C, 0x90, 0x96, 0xBC, 0x1F, 0x3F, //  {0xAB, 0x3F1FBC96, 0x905C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x10, 0x93, 0x68, 0x00, 0x40, 0x00, //  {0xAB, 0x00400068, 0x9310, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xCC, 0x92, 0x18, 0x17, 0x17, 0x40, //  {0xAB, 0x40171718, 0x92CC, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x7C, 0x92, 0x18, 0x18, 0x24, 0x40, //  {0xAB, 0x40241818, 0x927C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x70, 0x92, 0x58, 0x25, 0x40, 0x40, //  {0xAB, 0x40402558, 0x9270, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x70, 0x86, 0x5E, 0x25, 0x40, 0x40, //  {0xAB, 0x4040255E, 0x8670, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x80, 0x92, 0x40, 0x17, 0x04, 0x04, //  {0xAB, 0x04041740, 0x9280, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x20, 0x86, 0x00, 0x44, 0x00, 0x00, //  {0xAB, 0x00004400, 0x8620, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x8C, 0x86, 0x58, 0x40, 0x04, 0x00, //  {0xAB, 0x00044058, 0x868C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x18, 0x93, 0x21, 0x00, 0x00, 0x4A, //  {0xAB, 0x4A000021, 0x9318, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0xE4, 0x92, 0x40, 0xA5, 0x0B, 0x4B, //  {0xAB, 0x4B0BA540, 0x92E4, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x64, 0x91, 0x4C, 0x50, 0x4C, 0x4C, //  {0xAB, 0x4C4C504C, 0x9164, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x0C, 0x92, 0xE6, 0x9B, 0x52, 0x00, //  {0xAB, 0x00529BE6, 0x920C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x50, 0x86, 0x3F, 0x3F, 0x3F, 0x05, //  {0xAB, 0x053F3F3F, 0x8650, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x06, 0x00, 0x64, 0x92, 0x00, 0x54, 0x00, 0x00, //  {0xAB, 0x00005400, 0x9264, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x1C, 0x84, 0x00, 0xC0, 0x00, 0x60, //  {0xAB, 0x6000C000, 0x841C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xAC, 0x86, 0xE9, 0x60, 0x00, 0x00, //  {0xAB, 0x000060E9, 0x86AC, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x06, 0x00, 0x54, 0x87, 0x80, 0x50, 0x06, 0x00, //  {0xAB, 0x00065080, 0x8754, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x1C, 0x86, 0x08, 0x10, 0x3B, 0x68, //  {0xAB, 0x683B1008, 0x861C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x06, 0x00, 0x10, 0x84, 0x00, 0x00, 0xBF, 0x72, //  {0xAB, 0x72BF0000, 0x8410, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xEC, 0x86, 0x04, 0x80, 0x00, 0x00, //  {0xAB, 0x00008004, 0x86EC, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0xE0, 0x92, 0x02, 0x60, 0x00, 0x08, //  {0xAB, 0x08006002, 0x92E0, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x2C, 0x86, 0x5A, 0x10, 0x08, 0x00, //  {0xAB, 0x0008105A, 0x862C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x20, 0x87, 0x04, 0x02, 0x12, 0x08, //  {0xAB, 0x08120204, 0x8720, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x58, 0x86, 0x09, 0xA0, 0x32, 0x81, //  {0xAB, 0x8132A009, 0x8658, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0xD4, 0x86, 0xC0, 0x80, 0x82, 0x00, //  {0xAB, 0x008280C0, 0x86D4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x8C, 0x92, 0x20, 0x48, 0x86, 0x00, //  {0xAB, 0x00864820, 0x928C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0xB4, 0x92, 0x40, 0x40, 0x81, 0x08, //  {0xAB, 0x08814040, 0x92B4, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x54, 0x86, 0x02, 0x00, 0xC0, 0x88, //  {0xAB, 0x88C00002, 0x8654, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x0C, 0x86, 0xE4, 0x9B, 0x92, 0x00, //  {0xAB, 0x00929BE4, 0x860C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x3C, 0x84, 0x02, 0x9F, 0x00, 0x00, //  {0xAB, 0x00009F02, 0x843C, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x64, 0x86, 0x00, 0xA4, 0x00, 0x00, //  {0xAB, 0x0000A400, 0x8664, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x24, 0x84, 0x10, 0x0A, 0x0B, 0xA4, //  {0xAB, 0xA40B0A10, 0x8424, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x24, 0x90, 0x0F, 0x0C, 0x0C, 0xA4, //  {0xAB, 0xA40C0C0F, 0x9024, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x88, 0x92, 0x10, 0x30, 0x76, 0xA4, //  {0xAB, 0xA4763010, 0x9288, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x24, 0x92, 0xF8, 0x18, 0x33, 0xAA, //  {0xAB, 0xAA3318F8, 0x9224, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x2C, 0x92, 0x0C, 0x00, 0x0B, 0x00, //  {0xAB, 0x000B000C, 0x922C, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0A, 0x00, 0x00, 0x92, 0x70, 0x94, 0x52, 0x0B, //  {0xAB, 0x0B529470, 0x9200, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0A, 0x00, 0x00, 0x86, 0x70, 0xA8, 0x52, 0x0B, //  {0xAB, 0x0B52A870, 0x8600, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x68, 0x92, 0x06, 0x82, 0x10, 0xB8, //  {0xAB, 0xB8108206, 0x9268, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x68, 0x86, 0x2A, 0x82, 0x10, 0xB8, //  {0xAB, 0xB810822A, 0x8668, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x30, 0x86, 0x50, 0xC0, 0x00, 0xBE, //  {0xAB, 0xBE00C050, 0x8630, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x04, 0x93, 0x80, 0xAA, 0x01, 0xC0, //  {0xAB, 0xC001AA80, 0x9304, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0x08, 0x87, 0x45, 0x34, 0xDF, 0xCC, //  {0xAB, 0xCCDF3445, 0x8708, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x20, 0x93, 0x04, 0x04, 0x04, 0x0D, //  {0xAB, 0x0D040404, 0x9320, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x20, 0x84, 0x25, 0x16, 0x07, 0x0D, //  {0xAB, 0x0D071625, 0x8420, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x20, 0x90, 0x26, 0x16, 0x07, 0x0D, //  {0xAB, 0x0D071626, 0x9020, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0D, 0x00, 0x08, 0x93, 0x75, 0x34, 0xC8, 0xD0, //  {0xAB, 0xD0C83475, 0x9308, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0x48, 0x93, 0x88, 0x0A, 0x8A, 0xD3, //  {0xAB, 0xD38A0A88, 0x9348, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x04, 0x00, 0x48, 0x87, 0x88, 0x0A, 0x8D, 0xD7, //  {0xAB, 0xD78D0A88, 0x8748, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xC4, 0x86, 0xD1, 0xEC, 0x21, 0xE4, //  {0xAB, 0xE421ECD1, 0x86C4, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0B, 0x00, 0x88, 0x86, 0x20, 0x70, 0x74, 0xE4, //  {0xAB, 0xE4747020, 0x8688, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0xC4, 0x92, 0xD1, 0xEC, 0x01, 0xE6, //  {0xAB, 0xE601ECD1, 0x92C4, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0F, 0x00, 0x14, 0x93, 0x08, 0x1C, 0x05, 0x0F, //  {0xAB, 0x0F051C08, 0x9314, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x05, 0x00, 0x04, 0x86, 0x09, 0x09, 0x0F, 0x00, //  {0xAB, 0x000F0909, 0x8604, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x07, 0x00, 0x04, 0x92, 0x09, 0x0B, 0x0F, 0x00, //  {0xAB, 0x000F0B09, 0x9204, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x08, 0x00, 0x28, 0x87, 0x00, 0x00, 0x04, 0xFC, //  {0xAB, 0xFC040000, 0x8728, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x02, 0x00, 0x40, 0x84, 0xF0, 0xD2, 0x02, 0xFF, //  {0xAB, 0xFF02D2F0, 0x8440, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x0C, 0x00, 0x28, 0x93, 0x00, 0x00, 0x1A, 0xFF, //  {0xAB, 0xFF1A0000, 0x9328, V_PCH_PCR_FIA_LANE_OWN_USB3, MULCAST},
  0x28, 0xA8, 0x07, 0x00, 0x01, 0x00, 0x64, 0x86, 0x08, 0x54, 0x00, 0x00, //  {0xA8, 0x00005408, 0x8664, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x28, 0xAB, 0x07, 0x00, 0x01, 0x00, 0x64, 0x86, 0x08, 0xA4, 0x00, 0x00, //  {0xAB, 0x0000A408, 0x8664, V_PCH_PCR_FIA_LANE_OWN_PCIEDMI, MULCAST},
  0x0F, 0x00, 0x00, 0x00,                                                 //  End Table Marker
};
