/** @file
  This file contains HD Audio NHLT Configuration BLOBs

@copyright
  INTEL CONFIDENTIAL
  Copyright 2015 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

//
// EhL NHLT Configuration BLOBs
//

#include "NhltEndpoints.h"

//
// DMIC Configuration BLOBs
//
// DMIC Config 2 channels, 16 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicStereo16BitFormatConfig[] =
{
  0x00000001,0xffff3210,0xffffff10,0xffffff32,0xffffffff,
  3,
  3,
  0x00300003,
  0x00300003,
  0x3,
  0x1, 0x09001303, 0x0, 0x0303, 0, 0, 0, 0,
  0x11, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x11, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e,
  0x1, 0x09001303, 0x0, 0x0303, 0, 0, 0, 0,
  0x11, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x11, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e
};

// DMIC Config 2 channels, 32 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicStereo32BitFormatConfig[] =
{
  0x00000001,0xffff3210,0xffffff10,0xffffff32,0xffffffff,
  3,
  3,
  0x00380003,
  0x00380003,
  0x3,
  0x1, 0x09001303, 0x0, 0x0303, 0, 0, 0, 0,
  0x11, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x11, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e,
  0x1, 0x09001303, 0x0, 0x0303, 0, 0, 0, 0,
  0x11, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x11, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e
};

// DMIC Config 4 channels, 16 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicQuad16BitFormatConfigEhl[] =
{
  0x00000001, 0xFFFF3210, 0xFFFF3210, 0xFFFFFFFF, 0xFFFFFFFF,
  3,
  3,
  0x00320003,
  0x00320003,
  0x3,
  0xC001, 0x0B001803, 0x0, 0x0E03, 0, 0, 0, 0,
  0x91, 0x10076, 0, 0, 0, 0, 0, 0,
  0x91, 0x501E8, 0, 0, 0, 0, 0, 0,
  0x40000049, 0x40400181,
  0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19, 0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C, 0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1,
  0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896,
  0x46400572, 0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4, 0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33,
  0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4,
  0x4B4FE103, 0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5, 0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E,
  0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D,
  0x50406008, 0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82, 0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF,
  0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21,
  0x554F3223, 0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102, 0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24,
  0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777,
  0x5A4F51AC, 0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8, 0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5,
  0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2,
  0x818FFD76, 0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567, 0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B,
  0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC,
  0x868FFBFF, 0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975, 0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0,
  0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C,
  0x8B80090E, 0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42, 0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25,
  0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F,
  0x908FE8AB, 0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3, 0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684,
  0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531,
  0x95803BAF, 0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799, 0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF,
  0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8,
  0x9A8F2367, 0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687, 0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98,
  0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259,
  0x9F8F2367, 0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5, 0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333,
  0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6,
  0xA4803BAF, 0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8, 0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6,
  0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066,
  0xA98FE8AB, 0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F, 0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D,
  0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72,
  0xAE80090E, 0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD, 0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627,
  0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8,
  0xB38FFBFF, 0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2, 0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F,
  0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD,
  0xB88FFD76, 0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A, 0xB9C00018, 0xBA00001B,
  0xC001, 0x0B001803, 0x0, 0x0E03, 0, 0, 0, 0,
  0x91, 0x10076, 0, 0, 0, 0, 0, 0,
  0x91, 0x501E8, 0, 0, 0, 0, 0, 0,
  0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19, 0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C,
  0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4,
  0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572, 0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4,
  0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90,
  0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103, 0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5,
  0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1,
  0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008, 0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82,
  0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7,
  0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223, 0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102,
  0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA,
  0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC, 0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8,
  0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B,
  0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76, 0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567,
  0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0,
  0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF, 0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975,
  0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C,
  0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E, 0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42,
  0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D,
  0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB, 0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3,
  0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09,
  0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF, 0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799,
  0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4,
  0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367, 0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687,
  0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC,
  0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367, 0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5,
  0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB,
  0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF, 0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8,
  0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6,
  0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB, 0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F,
  0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E,
  0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E, 0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD,
  0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA,
  0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF, 0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2,
  0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B,
  0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76, 0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A,
  0xB9C00018, 0xBA00001B
};

// DMIC Config 4 channels, 32 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicQuad32BitFormatConfigEhl[] =
{
  0x00000001, 0xFFFF3210, 0xFFFF3210, 0xFFFFFFFF, 0xFFFFFFFF,
  3,
  3,
  0x003A0003,
  0x003A0003,
  0x3,
  0xC001, 0x0B001803, 0x0, 0x0E03, 0, 0, 0, 0,
  0x91, 0x10076, 0, 0, 0, 0, 0, 0,
  0x91, 0x501E8, 0, 0, 0, 0, 0, 0,
  0x40000049, 0x40400181,
  0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19, 0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C, 0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1,
  0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896,
  0x46400572, 0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4, 0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33,
  0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4,
  0x4B4FE103, 0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5, 0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E,
  0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D,
  0x50406008, 0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82, 0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF,
  0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21,
  0x554F3223, 0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102, 0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24,
  0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777,
  0x5A4F51AC, 0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8, 0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5,
  0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2,
  0x818FFD76, 0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567, 0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B,
  0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC,
  0x868FFBFF, 0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975, 0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0,
  0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C,
  0x8B80090E, 0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42, 0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25,
  0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F,
  0x908FE8AB, 0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3, 0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684,
  0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531,
  0x95803BAF, 0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799, 0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF,
  0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8,
  0x9A8F2367, 0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687, 0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98,
  0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259,
  0x9F8F2367, 0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5, 0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333,
  0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6,
  0xA4803BAF, 0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8, 0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6,
  0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066,
  0xA98FE8AB, 0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F, 0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D,
  0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72,
  0xAE80090E, 0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD, 0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627,
  0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8,
  0xB38FFBFF, 0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2, 0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F,
  0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD,
  0xB88FFD76, 0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A, 0xB9C00018, 0xBA00001B,
  0xC001, 0x0B001803, 0x0, 0x0E03, 0, 0, 0, 0,
  0x91, 0x10076, 0, 0, 0, 0, 0, 0,
  0x91, 0x501E8, 0, 0, 0, 0, 0, 0,
  0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19, 0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C,
  0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4,
  0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572, 0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4,
  0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90,
  0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103, 0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5,
  0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1,
  0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008, 0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82,
  0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7,
  0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223, 0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102,
  0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA,
  0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC, 0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8,
  0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B,
  0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76, 0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567,
  0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0,
  0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF, 0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975,
  0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C,
  0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E, 0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42,
  0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D,
  0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB, 0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3,
  0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09,
  0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF, 0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799,
  0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4,
  0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367, 0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687,
  0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC,
  0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367, 0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5,
  0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB,
  0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF, 0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8,
  0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6,
  0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB, 0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F,
  0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E,
  0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E, 0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD,
  0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA,
  0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF, 0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2,
  0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B,
  0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76, 0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A,
  0xB9C00018, 0xBA00001B
};

// DMIC Config 4 channels, 16 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicQuad16BitFormatConfig[] =
{
  0x00000001,0xffff3210,0xffffff10,0xffffff32,0xffffffff,
  3,
  3,
  0x00320003,
  0x00320003,
  0x3,
  0x1, 0x09001303, 0x0, 0x0603, 0, 0, 0, 0,
  0x11, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x11, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e,
  0x1, 0x09001303, 0x0, 0x0603, 0, 0, 0, 0,
  0x11, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x11, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e
};

// DMIC Config 4 channels, 32 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicQuad32BitFormatConfig[] =
{
  0x00000001,0xffff3210,0xffffff10,0xffffff32,0xffffffff,
  3,
  3,
  0x003A0003,
  0x003A0003,
  0x3,
  0x1, 0x09001303, 0x0, 0x0303, 0, 0, 0, 0,
  0x11, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x11, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e,
  0x1, 0x09001303, 0x0, 0x0303, 0, 0, 0, 0,
  0x11, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x11, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e
};

// DMIC Config 1 channel, 16 bits
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicMono16BitFormatConfig[] =
{
  0x00000000,
  0xfffffff0,0xfffffff0,0xfffffff0,0xfffffff0,
  3,
  3,
  0x00300003,
  0x00300003,
  0x3,
  0x0, 0x09001303, 0x0, 0x0301, 0, 0, 0, 0,
  0x10, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x10, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e,
  0x0, 0x09001303, 0x0, 0x0301, 0, 0, 0, 0,
  0x10, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x10, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e
};


//
// I2S/SSP Configuration BLOBs
// Audio Format and Configuration details
//
// Frequency: 48kHz, PCM resolution: 24 bits
// TDM slots: 4
// Codec: Realtek ALC274, mode: slave
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk274Render4ch48kHz24bitFormatConfig[]  = {0x0, 0xffffff10, 0xffffff32, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0x83d00737, 0xc0700000, 0x0, 0x02010004, 0xf, 0xf, 0x4002, 0x4, 0x7070f00, 0x20, 0x00020001, 0x00000002};

GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk274Capture4ch48kHz24bitFormatConfig[]  = {0x0, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0x83d00737, 0xc0700000, 0x0, 0x02010004, 0xf, 0xf, 0x4002, 0x4, 0x7070f00, 0x20, 0x00020001, 0x00000002};

// Frequency: 48kHz, PCM resolution: 24 bits
// TDM slots: 4
// Codec: Realtek ALC5660, mode: slave
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk5660SpeakerRender4ch48kHz24bitFormatConfig[]  = {0x00000000, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0x81D00737, 0xC0700000, 0x00000000, 0x0A200000, 0x00000003, 0x00000003, 0x00004002, 0x00000000, 0x07070F00, 0x00000020, 0x00110001, 0x00000000};

GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk5660HeadphonesRender4ch48kHz24bitFormatConfig[]  = {0x00000000, 0xFFFFFF10, 0xFFFFFF32, 0xFFFF3210, 0xFFFF3210, 0xFFFF3210, 0xFFFF3210, 0xFFFF3210, 0xFFFF3210, 0x83D00737, 0xC0700000, 0x00000000, 0x02010004, 0x0000000F, 0x0000000F, 0x00004002, 0x00000004, 0x07070F00, 0x00000020, 0x00020001, 0x00000002};

GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk5660HeadphonesCapture4ch48kHz24bitFormatConfig[]  = {0x00000000, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFF10, 0x81D00737, 0xC0700000, 0x00000000, 0x0A200000, 0x00000003, 0x00000003, 0x00004002, 0x00000000, 0x07070F00, 0x00000020, 0x00110001, 0x00000000};

//
// BlueTooth Configuration BLOBs
//
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 BtFormat1Config[] =
{
  0x0, 0xfffffff0, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0x80c12b3f, 0xc0700000, 0x0, 0x02010006, 0x01, 0x01, 0x4002,
  0x0, 0x06010f00, 0x20, 0x20001, 0x2
};

GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 BtFormat2Config[] =
{
  0x0, 0xfffffff0, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0xffffffff, 0x80c0953f, 0xc0700000, 0x0, 0x02010006, 0x01, 0x01, 0x4002,
  0x0, 0x06010f00, 0x20, 0x20001, 0x2
};

HDA_NHLT_FORMAT_CONFIG mHdaNhltFormatConfigs[V_HDA_FORMAT_MAX] =
{
  {B_HDA_DMIC_2CH_48KHZ_16BIT_FORMAT,               &Ch2_48kHz16bitFormat, sizeof(DmicStereo16BitFormatConfig),               DmicStereo16BitFormatConfig},
  {B_HDA_DMIC_2CH_48KHZ_32BIT_FORMAT,               &Ch2_48kHz32bitFormat, sizeof(DmicStereo32BitFormatConfig),               DmicStereo32BitFormatConfig},
  {B_HDA_DMIC_4CH_48KHZ_16BIT_FORMAT,               &Ch4_48kHz16bitFormat, sizeof(DmicQuad16BitFormatConfig),                 DmicQuad16BitFormatConfig},
  {B_HDA_DMIC_4CH_48KHZ_32BIT_FORMAT,               &Ch4_48kHz32bitFormat, sizeof(DmicQuad32BitFormatConfig),                 DmicQuad32BitFormatConfig},
  {B_HDA_DMIC_1CH_48KHZ_16BIT_FORMAT,               &Ch1_48kHz16bitFormat, sizeof(DmicMono16BitFormatConfig),                 DmicMono16BitFormatConfig},
  {B_HDA_BT_NARROWBAND_FORMAT,                      &NarrowbandFormat,     sizeof(BtFormat1Config),                           BtFormat1Config},
  {B_HDA_BT_WIDEBAND_FORMAT,                        &WidebandFormat,       sizeof(BtFormat2Config),                           BtFormat2Config},
  {B_HDA_BT_A2DP_FORMAT,                            &A2dpFormat,           sizeof(BtFormat2Config),                           BtFormat2Config},
  {B_HDA_I2S_RTK274_RENDER_4CH_48KHZ_24BIT_FORMAT,  &Ch2_48kHz24bitFormat, sizeof(I2sRtk274Render4ch48kHz24bitFormatConfig),  I2sRtk274Render4ch48kHz24bitFormatConfig},
  {B_HDA_I2S_RTK274_CAPTURE_4CH_48KHZ_24BIT_FORMAT, &Ch2_48kHz24bitFormat, sizeof(I2sRtk274Capture4ch48kHz24bitFormatConfig), I2sRtk274Capture4ch48kHz24bitFormatConfig},
  {B_HDA_I2S_RTK5660_SPEAKER_RENDER_4CH_48KHZ_24BIT_FORMAT,     &Ch2_48kHz24bitFormat, sizeof (I2sRtk5660SpeakerRender4ch48kHz24bitFormatConfig),     I2sRtk5660SpeakerRender4ch48kHz24bitFormatConfig},
  {B_HDA_I2S_RTK5660_HEADPHONES_RENDER_4CH_48KHZ_24BIT_FORMAT,  &Ch2_48kHz24bitFormat, sizeof (I2sRtk5660HeadphonesRender4ch48kHz24bitFormatConfig),  I2sRtk5660HeadphonesRender4ch48kHz24bitFormatConfig},
  {B_HDA_I2S_RTK5660_HEADPHONES_CAPTURE_4CH_48KHZ_24BIT_FORMAT, &Ch2_48kHz24bitFormat, sizeof (I2sRtk5660HeadphonesCapture4ch48kHz24bitFormatConfig), I2sRtk5660HeadphonesCapture4ch48kHz24bitFormatConfig}
};