## @file
# @copyright
#  INTEL CONFIDENTIAL
#  Copyright 2018 Intel Corporation.
#
#  The source code contained or described herein and all documents related to the
#  source code ("Material") are owned by Intel Corporation or its suppliers or
#  licensors. Title to the Material remains with Intel Corporation or its suppliers
#  and licensors. The Material may contain trade secrets and proprietary and
#  confidential information of Intel Corporation and its suppliers and licensors,
#  and is protected by worldwide copyright and trade secret laws and treaty
#  provisions. No part of the Material may be used, copied, reproduced, modified,
#  published, uploaded, posted, transmitted, distributed, or disclosed in any way
#  without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure or delivery
#  of the Materials, either expressly, by implication, inducement, estoppel or
#  otherwise. Any license under such intellectual property rights must be
#  express and approved by Intel in writing.
#
#  Unless otherwise agreed by Intel in writing, you may not remove or alter
#  this notice or any other notice embedded in Materials by Intel or
#  Intel's suppliers or licensors in any way.
#
#  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
#  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
#  the terms of your license agreement with Intel or your vendor. This file may
#  be modified by the user, subject to additional terms of the license agreement.
#
# @par Specification
##
#!/bin/sh



FSP_PKG_NAME=GeminilakeFspPkg
FSP_PKG_CONF_NAME=GeminilakeFspPkgConfig
FSP_PKG_EXT_CONF_NAME=GeminilakeFspPkgExtConfig
FSP_BIN_PKG_NAME=GeminilakeFspBinPkg
PLATFORM_SI_PACKAGE=GeminilakeSiliconPkg

function USAGE()
{
  echo
  echo  "$0 \[-h \| -? \| -r32 \| -tr32 \| -d32 \| -clean\]"
  echo
  return 1
}

function Clean(){
  echo Removing Build and Conf directories ...
  if [ -d $WORKSPACE/Build ]
   then
    rm -r $WORKSPACE/Build
  fi
  if [ -d $WORKSPACE/Conf ]
    then
     rm  -r $WORKSPACE/Conf
  fi
  if [ -f *.log ]
   then
    rm *.log
  fi
  WORKSPACE=
  EDK_TOOLS_PATH=
  if [ -e $EXTCONFIG_DSC ]; then
    echo "" > $EXTCONFIG_DSC
  fi
  return 0
}

PLATFORM_TYPE=GELK

function  Build32(){
   cd $WORKSPACE_SILICON/$FSP_PKG_NAME/
   python BuildFsp.py -PlatformType $PLATFORM_TYPE -gcc $TOOL_CHAIN -BuildTarget $BD_TARGET
   cd ../../
}

function ReleaseTypeTest32(){
  BD_TARGET=Release
  Build32 $*
}

function ReleaseBuild32(){
  BD_TARGET=Release
  Build32 $*
}

function DebugBuild32(){
  BD_TARGET=Debug
  Build32 $*
}

cd $WORKSPACE

OUT_DIR=Build

#
# Add $WORKSPACE/Silicon and $WORKSPACE_CORE in PACKAGES_PATH
#
export PACKAGES_PATH=$WORKSPACE_SILICON:$WORKSPACE_COMMON:$WORKSPACE_CORE
echo "Current PACKAGES_PATH is : $PACKAGES_PATH"

#
# clean parameter
#
if [ "$1" = "Geminilake" ]; then
  shift
fi

if [ "$1" = "GCC" ]; then
#
# Detect GCC Tool Chain Version
#
GCC_VERSION=$(gcc -dumpversion|sed 's/^\([0-9]\.[0-9]\).*/\1/')
if [ "$GCC_VERSION" = "4.5" ]; then
  export TOOL_CHAIN=GCC45
elif [ "$GCC_VERSION" = "4.6" ]; then
  export TOOL_CHAIN=GCC46
elif [ "$GCC_VERSION" = "4.7" ]; then
  export TOOL_CHAIN=GCC47
elif [ "$GCC_VERSION" = "4.8" ]; then
  export TOOL_CHAIN=GCC48
elif [ "$GCC_VERSION" = "4.9" ]; then
  export TOOL_CHAIN=GCC49
elif [ "$GCC_VERSION" = "5.3" ]; then
  export TOOL_CHAIN=GCC5
elif [ "$GCC_VERSION" = "5.4" ]; then
  export TOOL_CHAIN=GCC5
else
  echo "Unsupported GCC version!"
  exit 1
fi
#
# Toolchain information
#
gcc -v
fi

if [ "$1" = "CLANG" ]; then
#
# Detect CLANG Tool Chain Version
#
CLANG_VERSION=$(clang --version | awk '{print $4}' | head -c 5 | sed 's/\.[0-9]*$//g')
#
# @todo these define for current teamcity Clang, will remove below define only keep clang3.8
#
if [ "$CLANG_VERSION" = "3.4" ]; then
  export TOOL_CHAIN=CLANG
elif [ "$CLANG_VERSION" = "3.5" ]; then
  export TOOL_CHAIN=CLANG
elif [ "$CLANG_VERSION" = "3.6" ]; then
  export TOOL_CHAIN=CLANG
elif [ "$CLANG_VERSION" = "3.7" ]; then
  export TOOL_CHAIN=CLANG
elif [ "$CLANG_VERSION" = "3.8" ]; then
  export TOOL_CHAIN=CLANG38
else
  echo "Unsupported CLANG version!"
  exit 1
fi
#
# Toolchain information
#
clang --version
fi

if [ -z "${TOOL_CHAIN}" ]; then
  export TOOL_CHAIN=$1
fi

if [ "$2" = "-clean" ]
 then
  Clean
elif [ "$2" = "-r32" ]
 then
  ReleaseBuild32
elif [ "$2" = "-tr32" ]
 then
  ReleaseTypeTest32
elif [ "$2" = "-d32" ]
 then
   DebugBuild32
elif [ -z "$2" ]
 then
   DebugBuild32
else
  echo
  echo  ERROR: $2 is not valid parameter.
  USAGE
fi
