/** @file
  CPU policy PPI produced by a platform driver specifying various
  expected CPU settings. This PPI is consumed by CPU PEI modules.

@copyright
 Copyright (c) 2015 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification
**/
#ifndef _BIOS_GUARD_CONFIG_H_
#define _BIOS_GUARD_CONFIG_H_

#include "BiosGuardDefinitions.h"
#include <Library/BootGuardLib.h>

//
// Extern the GUID for protocol users.
//
extern EFI_GUID gBiosGuardConfigGuid;

#pragma pack(push, 1)

#define BIOS_GUARD_CONFIG_REVISION 1

/**
  Platform policies for BIOS Guard Configuration for all processor security features configuration.
  Platform code can pass relevant configuration data through this structure.
  @note The policies are marked are either <b>(Required)</b> or <b>(Optional)</b>
  - <b>(Required)</b> : This policy is recommended to be properly configured for proper functioning of reference code and silicon initialization
  - <b>(Optional)</b> : This policy is recommended for validation purpose only.
**/
typedef struct {
  CONFIG_BLOCK_HEADER Header;             ///< Offset 0 GUID number for main entry of config block
  BGUP_HEADER          BgupHeader;         ///< BIOS Guard update package header that will be packaged along with BIOS Guard script and update data.
  BGPDT                Bgpdt;              ///< BIOS Guard Platform Data Table contains all the platform data that will be parsed by BIOS Guard module.
  UINT64               BgpdtHash[4];       ///< Hash of the BGPDT that will be programmed to PLAT_FRMW_PROT_HASH_0/1/2/3 MSR.
  UINT8                EcCmdProvisionEav;  ///< EC Command Provision Eav.
  UINT8                EcCmdLock;          ///< EC Command Lock.
  UINT8                Rsvd[2];            ///< Reserved for DWORD alignment.
  BIOSGUARD_LOG        BiosGuardLog;       ///< BIOS Guard log.
} BIOS_GUARD_CONFIG;

#pragma pack(pop)
#endif
