/** @file
  CPU policy PPI produced by a platform driver specifying various
  expected CPU settings. This PPI is consumed by CPU PEI modules.

@copyright
 Copyright (c) 2015-2017 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification
**/
#ifndef _CPU_SECURITY_PREMEM_CONFIG_H_
#define _CPU_SECURITY_PREMEM_CONFIG_H_


//
// Extern the GUID for protocol users.
//
extern EFI_GUID gCpuSecurityPreMemConfigGuid;

#pragma pack(push, 1)

//
// CPU_SECURITY_PREMEM_CONFIG revisions
//
#define CPU_SECURITY_CONFIG_PREMEM_REVISION 1

#define CPU_PREMEM_POLICY_REVISION  1

/**
  Platform Policies for CPU features configuration Platform code can enable/disable/configure features through this structure.
**/
typedef struct {
  CONFIG_BLOCK_HEADER Header;                ///< Offset 0 GUID number for main entry of config block
  UINT32 Txt                             : 1; ///< Enable or Disable TXT; <b>0: Disable</b>; 1: Enable.
  UINT32 SkipStopPbet                    : 1; ///< Skip Stop PBET Timer <b>0: Disabled</b>, 1: Enabled
  UINT32 BiosGuard                       : 1; ///< Enable or Disable BIOS Guard; 0: Disable, <b>1:Enable</b>
#ifdef SGX_SUPPORT
  UINT32 EnableSgx                       : 1;
#endif
  UINT32 RsvdBits                        :28; ///< Bits reserved for DWORD alignment.

#ifdef SGX_SUPPORT
  UINT32 PrmrrSize;                           ///< PRMRR Size.<b>Software Control: 0x0</b>  32MB: 0x2000000, 64MB: 0x4000000, 128 MB: 0x8000000
#endif
  UINT16 TotalFlashSize;                      ///< Total Flash Size on the system in KB
  UINT16 BiosSize;                            ///< BIOS Size in KB

} CPU_SECURITY_PREMEM_CONFIG;

typedef struct {
  CONFIG_BLOCK_HEADER Header;                ///< Offset 0 GUID number for main entry of config block
  UINT32 ProcessorTraceMemSize;               ///< Processor Trace size
} CPU_PREMEM_CONFIG;

#pragma pack(pop)

#endif
