/** @file
SGX Policies which will be consumed by other modules. 

@copyright
 Copyright (c) 2015 - 2018 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification
**/

#ifdef SGX_SUPPORT

#ifndef _SOFTWARE_GUARD_CONFIG_H_
#define _SOFTWARE_GUARD_CONFIG_H_

#pragma pack(push, 1)

#define SOFTWARE_GUARD_CONFIG_REVISION  2
#define EPC_OS_CTRL        L"EPCSW"


/**
  SGX Platform Configuration
**/
typedef struct {
  CONFIG_BLOCK_HEADER Header;   ///< Offset 0 GUID number for main entry of config block
  UINT64 SgxEpoch0;              ///< SGX EPOCH0 value. 0: Minimum, 0xFFFFFFFFFFFFFFFF: Maximum
  UINT64 SgxEpoch1;              ///< SGX EPOCH1 value. 0: Minimum, 0xFFFFFFFFFFFFFFFF: Maximum
  UINT64 EpcOffset;              ///< EPC offset from PRMRR base. <b>0x4000000</b> 0: Minimum, 0xFFFFFFFFFFFFFFFF: Maximum
  UINT64 EpcLength;              ///< EPC length inside PRM range.<b>0x5C00000</b> 0: Minimum, 0xFFFFFFFFFFFFFFFF: Maximum
  UINT64 PrmrrBase;              ///< PRMRR Base. <b>0</b> 0: Minimum, 0xFFFFFFFFFFFFFFFF: Maximum
  /**
    Below policies are used by SV
  **/

  UINT32 SkipSgxPatch       : 1; ///< BIOS to skip load patch <b>0: Disable</b>, 1:Enable
  UINT32 SkipPrmrr          : 1; ///< BIOS to skip setting PRMRR base address <b>0: Disable</b>, 1:Enable
  UINT32 SkipAcpiNvs        : 1; ///< SGX feature Enable configuration after patch load 0: Disable, <b>1:Enable</b>
  UINT32 SvPolicyEnable     : 1; ///< SV policy enable; <b>0: Disable</b>, 1: Enable.
  UINT32 EnableSgx7a        : 1; ///< SGX Enable using MSR 0x7A 0: Disabled, <b>1: Enabled</b>
  UINT32 SgxDebugMode       : 1; ///< SGX Debug Mode. <b>0: Disabled</b>, 1:Enabled
  UINT32 SvRsvdBits         :26; ///< Reserved for DWORD alignment of SV policy section.
  UINT16 SelectiveEnableSgx;     ///< Selectively enable SGX for core/thread. <b>0xFFFF</b> 0: Minimum, 0xFFFF: Maximum
  UINT8  SgxLcp;                 ///< SGX LCP mode <b>0: Intel Locked<b>1: Unlocked mode </b>, 2:Locked mode
  UINT8  Rsvd1[1];               ///< Reserved for DWORD alignment.
  UINT64 SgxLePubKeyHash0;       ///< SgxLEKeyHash0 value. 0: Minimum, 0xFFFFFFFFFFFFFFFF: Maximum
  UINT64 SgxLePubKeyHash1;       ///< SgxLEKeyHash1 value. 0: Minimum, 0xFFFFFFFFFFFFFFFF: Maximum
  UINT64 SgxLePubKeyHash2;       ///< SgxLEKeyHash2 value. 0: Minimum, 0xFFFFFFFFFFFFFFFF: Maximum
  UINT64 SgxLePubKeyHash3;       ///< SgxLEKeyHash3 value. 0: Minimum, 0xFFFFFFFFFFFFFFFF: Maximum

} SOFTWARE_GUARD_CONFIG;

#pragma pack(pop)
#endif

#endif
