/** @file
  CPU Policy structure definition which will contain several config blocks during runtime.

@copyright
 Copyright (c) 2009 - 2016 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification
**/
#ifndef _CPU_POLICY_COMMON_H_
#define _CPU_POLICY_COMMON_H_

#include "BiosGuardDefinitions.h"
#include <ConfigBlock.h>
#include <CpuAccess.h>
#include <CpuDataStruct.h>
#include <ConfigBlock/BiosGuardConfig.h>
#include <ConfigBlock/CpuConfig.h>
#include <ConfigBlock/CpuConfigPreMem.h>
#include <ConfigBlock/CpuOverclockingConfig.h>
#include <ConfigBlock/CpuPowerMgmtConfig.h>
#ifdef SGX_SUPPORT
#include <ConfigBlock/CpuSgxConfig.h> 
#endif

//
// Extern the GUID for protocol users.
//
extern EFI_GUID gSiCpuPolicyPpiGuid;

#pragma pack(1)


//
// SI_CPU_POLICY_PPI revisions
//
#define SI_CPU_POLICY_PPI_REVISION  1


/**
  The PPI allows the platform code to publish a set of configuration information that the
  CPU drivers will use to configure the processor in the PEI phase.
  This Policy PPI needs to be initialized for CPU configuration.
  @note The PPI has to be published before processor PEIMs are dispatched.
**/
typedef struct {
  CONFIG_BLOCK_TABLE_HEADER ConfigBlockTableHeader;
  //CONFIG_BLOCK_OFFSET_TABLE OffsetTable; ///< Offset 32 config Block Offset Table (N*4)
  //
  // Individual Config Block Structures are added here in memory as part of AddConfigBlock()
  //
} SI_CPU_POLICY_PPI;

#pragma pack()
#endif // _CPU_POLICY_COMMON_H_
