/** @file
  Prototype of the CpuPolicy library.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2014 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/
#ifndef _CPU_POLICY_LIB_H_
#define _CPU_POLICY_LIB_H_

#include <CpuPolicyCommon.h>
#include <Library/ConfigBlockLib.h>

#define     AP_HALT_LOOP         1
#define     AP_MWAIT_LOOP        2
#define     AP_RUN_LOOP          3
#define     MWAIT_DISABLE        0

/**
  Print whole CPU_POLICY_PPI and serial out.

  @param[in] SiCpuPolicyPpi             The RC Policy PPI instance
**/
VOID
CpuPrintPolicyPpi (
  IN  SI_CPU_POLICY_PPI                 *SiCpuPolicyPpi
  );

/**
  Print whole CPU_POLICY_PPI and serial out.

  @param[in] SiCpuPolicyPpi             The RC Policy PPI instance
**/
VOID
CpuPrintPolicyPreMemPpi (
  IN  SI_CPU_POLICY_PPI                 *SiCpuPolicyPpi
  );

/**
  CreateCpuConfigBlocks creates the Config Blocks for CPU Policy.
  @param[in, out] SiCpuPolicyPpi        The pointer to get CPU Policy PPI instance

  @retval EFI_SUCCESS                   The policy default is initialized.
  @retval EFI_OUT_OF_RESOURCES          Insufficient resources to create buffer
**/
EFI_STATUS
EFIAPI
CreateCpuConfigBlocks (
  IN OUT  SI_CPU_POLICY_PPI          **SiCpuPolicyPpi
  );

/**
  CreateCpuConfigBlocks creates the Config Blocks for CPU Policy in Prememory phase.
  @param[in, out] SiCpuPolicyPpi        The pointer to get CPU Policy PPI instance

  @retval EFI_SUCCESS                   The policy default is initialized.
  @retval EFI_OUT_OF_RESOURCES          Insufficient resources to create buffer
**/
EFI_STATUS
EFIAPI
 CreateCpuConfigBlocksPreMem (
  IN OUT  SI_CPU_POLICY_PPI          **SiCpuPolicyPpi
  );
/**
  CpuInstallPolicyPpi installs SiCpuPolicyPpi.
  While installed, RC assumes the Policy is ready and finalized. So please update and override
  any setting before calling this function.

  @param[in] SiCpuPolicyPpi             The pointer to PEI Cpu Policy PPI instance

  @retval EFI_SUCCESS                   The policy is installed.
  @retval EFI_OUT_OF_RESOURCES          Insufficient resources to create buffer
**/
EFI_STATUS
EFIAPI
CpuInstallPolicyPpi (
  IN  SI_CPU_POLICY_PPI                 *SiCpuPolicyPpi
  );
/**
  CpuInstallPolicyPpi installs SiCpuPolicyPpi in Prememory phase.
  While installed, RC assumes the Policy is ready and finalized. So please update and override
  any setting before calling this function.

  @param[in] SiCpuPolicyPpi             The pointer to PEI Cpu Policy PPI instance

  @retval EFI_SUCCESS                   The policy is installed.
  @retval EFI_OUT_OF_RESOURCES          Insufficient resources to create buffer
**/
EFI_STATUS
EFIAPI
CpuInstallPolicyPpiPreMem (
  IN  SI_CPU_POLICY_PPI                 *SiCpuPolicyPpi
  );
/**
  Calulcates the Memsize required for Intel Processor Trace 

**/
UINTN
CalculateIntelTraceBufferSize (
  IN  CONST EFI_PEI_SERVICES        **PeiServices
  );
#endif // _PEI_CPU_POLICY_LIB_H_
