/** @file
  Header file for Software Guard Lib implementation.

@copyright
 Copyright (c) 2012 - 2016 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/

#ifdef SGX_SUPPORT

#ifndef _SOFTWARE_GUARD_LIB_H_
#define _SOFTWARE_GUARD_LIB_H_

#include <CpuPolicyCommon.h>


#define SGX_LCP_INTEL_LOCKED 0x0 ///< SGX Launch Control Policy - Intel Locked
#define SGX_LCP_UNLOCKED 0x1     ///< SGX Launch Control Policy - Unlocked
#define SGX_LCP_LOCKED 0x2       ///< SGX Launch Control Policy - Locked



/**
  Update Software Guard Epochs
**/
VOID
EpochUpdate (
  IN  SI_CPU_POLICY_PPI    *SiCpuPolicyPpi
  );

/**
  Check if SGX present.
  Presence of  feature is detectable by reading CPUID.(EAX=12,
  ECX=0):EAX[0].

  @retval TRUE  - SGX is present on the system
  @retval FALSE - SGX is not present on the system
**/
BOOLEAN
IsSgxPresent (
  VOID
  );

/**
  Check if PRM configuration for SGX was approved by MCHECK.

  @retval TRUE  - PRM configuration was approved by MCHECK
  @retval FALSE - PRM configuration was not approved by MCHECK
**/
BOOLEAN
IsPrmApproved (
  VOID
  );

/**
  Activation of SGX feature after patch load  via BIOS_UPGD_TRIG (MSR 0x7a)
**/
VOID
ActivateSgxFeature (
  VOID
  );

/**
  Initialize SGX PRMRR core MSRs.
**/
VOID
InitializeCorePrmrr (
  VOID
  );
  
/**
  Enable/Disable SGX in the processor.
  To enable the SGX, System BIOS must set bit 18 in
  IA32_FEATURE_CONTROL MSR. This function will assert if
  IA32_FEATURE_CONTROL MSR is locked and bit 18 wasn't set

**/
VOID
EnableSgxFeature (
  VOID
  );


/**
  Return TRUE if SGX in feature control was set
  IA32_FEATURE_CONTROL MSR(3Ah) [18] == 1

  @retval TRUE if SGX in feature control was set.
  @retval FALSE if SGX in feature control was not set
**/
BOOLEAN
IsSgxFeatureCtrlSet (
  VOID
  );

/**
  Check if SGX patch can be loaded. Patch can be loaded if all
  of these conditions are met
  - 1: EnableSgx policy was set to enable
  - 2: SGX feature is supported by CPU
  - 3: PRM was successfully allocated and PRMRRs were set

  @retval TRUE  if all conditions are met
  @retval FALSE if at least one of the condtions is not met
**/
BOOLEAN
IsSgxPreconditionsMet (
  VOID
  );

/**
  Return TRUE if SGX Policy is enabled

  @retval TRUE  if SGX Policy is enabled
  @retval FALSE if SGX Policy is disabled
**/
BOOLEAN
IsSgxPolicyEnabled (
  VOID
  );

/**
  Perform SGX initialization by logical processor.

  @param[in] SiCpuPolicyPpi
**/
VOID
SgxInitializationByLogicalProcessorPrePatchLoad (
  IN  SI_CPU_POLICY_PPI    *SiCpuPolicyPpi
  );

/**
  Perform SGX Post Patch Load initialization.
  @param[in] CpuConfig
  @param[in] SoftwareGuardConfig
**/
VOID
SgxInitializationPostPatchLoad (
  IN  CPU_CONFIG              *CpuConfig,
  IN  SOFTWARE_GUARD_CONFIG   *SoftwareGuardConfig
  );


#endif

#endif
