/** @file
  Code which supports SGX feature.

@copyright
 Copyright (c) 2016 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/

#include <Uefi.h>
#include <PiPei.h>

#ifdef SGX_SUPPORT

#include <Private/Library/SoftwareGuardLib.h>
#include <Library/CpuPlatformLib.h>

/**
  Check if SGX patch can be loaded. Patch can be loaded if all
  of these conditions are met
  - 1: EnableSgx policy was set to enable
  - 2: SGX feature is supported by CPU
  - 3: PRM was successfully allocated and PRMRRs were set

  @retval FALSE
**/
BOOLEAN
IsSgxPreconditionsMet (
  VOID
  )
{
  return (IsSgxPolicyEnabled() && IsSgxSupported() && IsPrmrrAlreadySet());
}

/**
  Check on the processor if PRM is supported.

  @retval FALSE
**/
BOOLEAN
IsPrmrrSupported (
  VOID
  )
{
  return FALSE;
}

/**
  Verify whether SGX in Feature Control MSR was set
  IA32_FEATURE_CONTROL MSR(3Ah) [18] == 1

  @retval FALSE
**/
BOOLEAN
IsSgxFeatureCtrlSet (
  VOID
  )
{
  return FALSE;
}

/**
  Verify whether PRMRR base was already set on this core

  @retval FALSE
**/
BOOLEAN
IsPrmrrAlreadySet (
  VOID
  )
{
  return FALSE;
}

/**
  Update Software Guard Epochs
**/
VOID
EpochUpdate (
  IN  SI_CPU_POLICY_PPI    *SiCpuPolicyPpi
  )
{
  return;
}


/**
  Initialize SGX PRMRR core and uncore MSRs.
**/
VOID
InitializeCorePrmrr (
  VOID
  )
{
  return;
}

/**
  Enable/Disable SGX in the processor.
**/
VOID
EnableSgxFeature (
  VOID
  )
{
  return;
}

/**
  Verify whether BIOS needs to load SGX patch.
  Can be set by setup option.

  @retval FALSE
**/
BOOLEAN
IsSgxPolicyEnabled (
  VOID
  )
{

  return FALSE;
}

/**
  Activation of SGX feature after patch load via BIOS_UPGD_TRIG (MSR 0x7a)

**/
VOID
ActivateSgxFeature (
  VOID
  )
{
  return;
}

/**
  Check if SGX present.
  Presence of feature is detectable by reading CPUID.(EAX=12,
  ECX=0):EAX[0].

  @retval FALSE
**/
BOOLEAN
IsSgxPresent (
  VOID
  )
{
  return FALSE;
}

/**
  Check if PRM configuration for SGX was approved by MCHECK.

  @retval FALSE
**/
BOOLEAN
IsPrmApproved (
  VOID
  )
{
  return FALSE;
}

#endif
