/** @file
  PEIM to initialize the cache and program for unlock processor

 @copyright
  INTEL CONFIDENTIAL
  Copyright 1999 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification
**/

#include <Ppi/MasterBootMode.h>
#include <Library/DebugLib.h>
#include <Library/PeiServicesLib.h>
#include <Library/HobLib.h>
#include <Ppi/SecPlatformInformation.h>
#include <Ppi/SmmAccess.h>
#include <Library/ReportStatusCodeLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/MemoryAllocationLib.h>
#include "CpuAccess.h"
#include "CpuInitPeim.h"
#include <Library/CpuPlatformLib.h>
#include <Private/Library/CpuCommonLib.h>
#include <Library/CpuPolicyLib.h>
#include <Library/PostCodeLib.h>

extern EFI_GUID gHtBistHobGuid;

/**
  Check some CPU policies are valid for debugging unexpected problem if these
  values are not initialized or assigned incorrect resource.

  @param[in] SiCpuPolicy    The Cpu Policy protocol instance

**/
VOID
CpuValidatePolicy (
  IN  SI_CPU_POLICY_PPI  *SiCpuPolicy
  )
{
  ASSERT (SiCpuPolicy->ConfigBlockTableHeader.Header.Revision == SI_CPU_POLICY_PPI_REVISION);
}

/**
  This function performs basic initialization for CPU in PEI phase after Policy produced.

**/
VOID
CpuOnPolicyInstalled (
  )
{
  DEBUG ((DEBUG_INFO, "CpuOnPolicyInstalled() - Start\n"));
  ///
  /// Init XMM support
  ///
  XmmInit ();

  DEBUG ((DEBUG_INFO, "CpuOnPolicyInstalled() - End\n"));
}

