/** @file
  This file contains the tests for the IntegratedDeviceDMAProtection bit

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2015 - 2018 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#include "HstiSiliconDxe.h"

/**
  Run tests for IntegratedDeviceDMAProtection bit
**/
VOID
CheckIntegratedDeviceDmaProtection (
  VOID
  )
{
  UINTN           McD0BaseAddress;
  UINTN           MchBar;
  EFI_STATUS      Status;
  CHAR16          *HstiStatusString;
  BOOLEAN         Result;
  UINT32          Vtd1,Vtd2;
  //
  // CheckIntegratedDeviceDmaProtection is not applicable for APL so just return
  //
  if ((mFeatureImplemented[0] & HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION) == 0) {
    return;
  }

  McD0BaseAddress = MmPciBase (SA_MC_BUS, 0, 0);
  Result = TRUE;
  MchBar = MmioRead64 (McD0BaseAddress + R_SA_MCHBAR) &~BIT0;

  DEBUG ((DEBUG_INFO, "  VTd check\n"));

  if (!((MmioRead32 ((MmioRead32 (McD0BaseAddress + R_SA_MCHBAR) &~BIT0) + R_SA_MCHBAR_VTD1_OFFSET) & BIT1) && (MmioRead32 ((MmioRead32 (McD0BaseAddress + R_SA_MCHBAR) &~BIT0) + R_SA_MCHBAR_VTD2_OFFSET) & BIT1)) ) {
    DEBUG ((DEBUG_INFO, "Fail: VTd disabled or not supported\n"));


    HstiStatusString = BuildHstiStatusString (HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_CODE_1 ,HSTI_INTEGRATED_DEVICE_DMA_PROTECTION, HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_STRING_1);
    Status = HstiLibAppendErrorString (
         PLATFORM_SECURITY_ROLE_PLATFORM_REFERENCE,
         NULL,
         HstiStatusString
         );
    ASSERT_EFI_ERROR (Status);
    Result = FALSE;
    FreePool (HstiStatusString);
  }
  else
  {
    DEBUG ((DEBUG_INFO, "    2. VTd enabled\n"));

    if ((MmioRead32 (MmPciBase (SA_IGD_BUS, SA_IGD_DEV, SA_IGD_FUN_0)+R_SA_IGD_VID)) != 0xFFFF) {
    Vtd1 = MmioRead32((MmioRead32 (McD0BaseAddress + R_SA_MCHBAR)&~BIT0) + R_SA_MCHBAR_VTD1_OFFSET);
     DEBUG ((DEBUG_INFO, "    2. VTd1 Offset Read\n"));

    if (((Vtd1 & BIT0) == 0) ||
      ((Vtd1 & 0xfffffffe) == 0)) {
      DEBUG ((DEBUG_INFO, "Fail: VTd1 not enabled\n"));


      HstiStatusString = BuildHstiStatusString (HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_CODE_1 ,HSTI_INTEGRATED_DEVICE_DMA_PROTECTION, HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_STRING_1);
      Status = HstiLibAppendErrorString (
           PLATFORM_SECURITY_ROLE_PLATFORM_REFERENCE,
           NULL,
           HstiStatusString
           );
      ASSERT_EFI_ERROR (Status);
      Result = FALSE;
      FreePool (HstiStatusString);
    }


    if ((Vtd1 & 0xfffffffe) != 0) {
      DEBUG ((DEBUG_INFO, "    3. VTd1 configured correctly\n"));

      /*if ((MmioRead32 (Vtd1)  & BIT1) == 0) {
      DEBUG ((DEBUG_INFO, "Fail: VTd1 not configured correctly\n"));

      HstiStatusString = BuildHstiStatusString (HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_CODE_1 ,HSTI_INTEGRATED_DEVICE_DMA_PROTECTION, HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_STRING_1);
      Status = HstiLibAppendErrorString (
             PLATFORM_SECURITY_ROLE_PLATFORM_REFERENCE,
             NULL,
             HstiStatusString
             );
      ASSERT_EFI_ERROR (Status);
      Result = FALSE;
      FreePool (HstiStatusString);
      }*/
    }

    }


     Vtd2 = MmioRead32((MmioRead32 (McD0BaseAddress + R_SA_MCHBAR)&~BIT0) + R_SA_MCHBAR_VTD2_OFFSET);
     DEBUG ((DEBUG_INFO, "    2. VTd2 Offset Read\n"));

    if (((Vtd2 & BIT0) == 0) ||
      ((Vtd2 & 0xfffffffe) == 0)) {
      DEBUG ((DEBUG_INFO, "Fail: VTd2 not enabled\n"));


      HstiStatusString = BuildHstiStatusString (HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_CODE_1 ,HSTI_INTEGRATED_DEVICE_DMA_PROTECTION, HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_STRING_1);
      Status = HstiLibAppendErrorString (
           PLATFORM_SECURITY_ROLE_PLATFORM_REFERENCE,
           NULL,
           HstiStatusString
           );
      ASSERT_EFI_ERROR (Status);
      Result = FALSE;
      FreePool (HstiStatusString);
    }
    if ((Vtd2 & 0xfffffffe) != 0) {
      DEBUG ((DEBUG_INFO, "    3. VTd2 configured correctly\n"));

     /* if ((MmioRead32 (Vtd2)  & BIT1) == 0) {
      DEBUG ((DEBUG_INFO, "Fail: VTd2 not configured correctly\n"));

      HstiStatusString = BuildHstiStatusString (HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_CODE_1 ,HSTI_INTEGRATED_DEVICE_DMA_PROTECTION, HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION_UNEXP_STATUS_STRING_1);
      Status = HstiLibAppendErrorString (
             PLATFORM_SECURITY_ROLE_PLATFORM_REFERENCE,
             NULL,
             HstiStatusString
             );
      ASSERT_EFI_ERROR (Status);
      Result = FALSE;
      FreePool (HstiStatusString);
      }*/
    }

  }

  //
  // ALL PASS
  //
  if (Result) {
    Status = HstiLibSetFeaturesVerified (
         PLATFORM_SECURITY_ROLE_PLATFORM_REFERENCE,
         NULL,
         0,
         HSTI_BYTE0_INTEGRATED_DEVICE_DMA_PROTECTION
         );
    ASSERT_EFI_ERROR (Status);
  }




  return;
}
