/** @file
  This library provides the GLK GPIO library definitions

@copyright
 Copyright (c) 2016 - 2017 Intel Corporation. All rights reserved This
 software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _GLK_GPIOLIB_H_
#define _GLK_GPIOLIB_H_

#define GPIO_PADBAR                     0x600
#define GPIO_PAD_INDEX_FACTOR			16		//each GPIO pad has 4 configuration DW

#define GPIO_NORTH_COMMUNITY_LENGTH     0xAFF
#define GPIO_NORTHWEST_COMMUNITY_LENGTH 0xCEF
#define GPIO_AUDIO_COMMUNITY_LENGTH 	0x7BF
#define GPIO_SCC_COMMUNITY_LENGTH 		0x82F

// GPIO pad and offset definition as GPIO HAS

// 
// NorthWest community GPIO pad definition
//
#define NW_GPIO_17             (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0710   //PADBAR included
#define NW_GPIO_21			   (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0750	//GPIO#21 (GPIO_21 ->Function 2: CNV_MFUART2_RXD
#define NW_GPIO_22			   (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0760	//GPIO#22 (GPIO_22) ->Function 2: CNV_MFUART2_TXD
#define NW_GPIO_23			   (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0770	//GPIO#23 (GPIO_23) ->Functio 2: CNV_GNSS_PABLANKIt /Function 5: PMIC_STDBY
#define NW_GPIO_41             (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0890   //PADBAR included
#define NW_GPIO_212			   (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0AD0	//GPIO #77  (GPIO_212) Touch Panel Interrupt

#define NW_GPIO_35             (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0830     //GPIO#35
#define NW_GPIO_36             (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0840     //GPIO#36
#define N_GPIO_148             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0A80      //(GPIO_148) native function LPC_CLKOUT0
#define N_GPIO_149             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0A90      //(GPIO_149) native function LPC_CLKOUT1
#define N_GPIO_150             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0AA0      //(GPIO_150) native function LPC_AD0
#define N_GPIO_151             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0AB0      //(GPIO_151) native function LPC_AD1
#define N_GPIO_152             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0AC0      //(GPIO_152) native function LPC_AD2
#define N_GPIO_153             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0AD0      //(GPIO_153) native function LPC_AD3
#define N_GPIO_154             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0AE0      //(GPIO_154) native function LPC_CLKRUNB
#define N_GPIO_155             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0AF0      //(GPIO_155) native function LPC_FRAMEB

//
// North community GPIO pad definition
//
#define N_GPIO_13             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x06D0      //GPIO #13 (GPIO_89)
#define N_GPIO_15             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x06F0      //GPIO #15 (GPIO_91)
#define N_GPIO_23             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0770     //GPIO #23 (GPIO_99)
#define N_GPIO_24             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0780     //GPIO #24 (GPIO_100)
#define N_GPIO_25             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0790     //GPIO #25 (GPIO_101)
#define N_GPIO_26             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x07A0     //GPIO #26 (GPIO_102)
#define N_GPIO_28             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x07C0     //GPIO #28 (GPIO_104)
#define N_GPIO_105            (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x07D0     //GPIO #29 (GPIO_105), purpose PCIe x4 slot2 reset
#define N_GPIO_35             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0830     //GPIO #35 (GPIO_111)
#define N_GPIO_37             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0850     //GPIO #37 (GPIO_113)
#define N_GPIO_49             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0910     //GPIO #49 (GPIO_125)
#define N_GPIO_120			  (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x08C0     //GPIO #44 (GPIO_120), purpose CLKREQ
#define N_GPIO_121			  (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x08D0     //GPIO #45 (GPIO_121), purpose CLKREQ
#define N_GPIO_122			  (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x08E0     //GPIO #46 (GPIO_122), purpose CLKREQ
#define N_GPIO_123			  (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x08F0     //GPIO #47 (GPIO_123), purpose CLKREQ
#define N_GPIO_137			  (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x09D0     //GPIO #61 (GPIO_137), purpose PCIe x4 slot1 reset
#define N_GPIO_157            (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0610     //GPIO #61 (GPIO_157), purpose PCIe M.2 WWAN reset
#define N_GPIO_97             (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0750     //(GPIO_97) FST_SPI_CLK_FB
#define N_GPIO_147            (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+0x0A70     //(GPIO_147) LPC_ILB_SERIRQ

#define NW_TCK                (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+GPIO_PADBAR+0x0000
#define NW_TRST_B             (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+GPIO_PADBAR+0x0010
#define NW_TMS                (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+GPIO_PADBAR+0x0020 
#define NW_TDI                (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+GPIO_PADBAR+0x0030  
#define NW_TDO                (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+GPIO_PADBAR+0x0040  
#define LPSS_SPI_2_CLK        (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x080   
#define LPSS_SPI_2_FS0        (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x090   
#define LPSS_SPI_2_FS1        (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x0A0   
#define LPSS_SPI_2_FS2        (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x0B0   
#define LPSS_SPI_2_RXD        (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x0C0   
#define LPSS_SPI_2_TXD        (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x0D0   
#define NW_PMIC_THERMTRIP_B   (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+GPIO_PADBAR+0x4B0 
#define NW_PROCHOT_B          (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+GPIO_PADBAR+0x4A0 
#define FST_SPI_CS0_B         (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x0E0  
#define FST_SPI_CS1_B         (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x0F0
#define FST_SPI_MOSI_IO0      (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x100 
#define FST_SPI_MISO_IO1      (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x110 
#define FST_SPI_IO2           (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x120 
#define FST_SPI_IO3           (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x130 
#define FST_SPI_CLK           (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x140 
#define FST_SPI_CLK_FB        (((UINT32)GPIO_MMIO_OFFSET_N)<<16)+GPIO_PADBAR+0x150 
//
// Audio community GPIO pad definition
//
#define A_GPIO_161            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0650    //GPIO #5 (GPIO_161) native function -AVS_I2S1_MCLK, purpose: touch panel reset
#define A_GPIO_163            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0670    //GPIO #7 (GPIO_163) native function -AVS_I2S1_WS_SYNC, purpose: PCIe M.2 WiFi reset
#define A_GPIO_175            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0730    //GPIO #19 (GPIO_175) native function -AVS_M_DATA_2
#define A_GPIO_157            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0610   //(GPIO_157) native function AVS_I2S0_BCLK
#define A_GPIO_165            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0690   //(GPIO_165) native function AVS_I2S1_SDO

//
// SCC community GPIO pad definition
//
#define SMB_ALERTB            (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+GPIO_PADBAR+0x000 
#define SMB_CLK               (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+GPIO_PADBAR+0x010  
#define SMB_DATA              (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+GPIO_PADBAR+0x020 
#define	SCC_GPIO_191		  (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+0x700	//GPIO #16 (GPIO_191) native function CNV_BRI_DT, HW strap
#define	SCC_GPIO_192		  (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+0x710	//GPIO #17 (GPIO_192) native function CNV_BRI_RSP, HW strap
#define	SCC_GPIO_193		  (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+0x720	//GPIO #18 (GPIO_193) native function CNV_RGI_DT, HW strap
#define	SCC_GPIO_194		  (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+0x730	//GPIO #19 (GPIO_194) native function CNV_RGI_RSP, HW strap
#define	SCC_GPIO_195		  (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+0x740	//GPIO #20 (GPIO_195) native function CNV_RF_RESET_B, HW strap
#define	SCC_GPIO_196		  (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+0x750	//GPIO #21 (GPIO_196) native function XTAL_CLKREQ, HW strap
#define	SCC_GPIO_210		  (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+0x6D0	//GPIO #13 (GPIO_210) purpose PCIe GbE / LAN reset
#define SCC_GPIO_197          (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+0x760    //(GPIO_197) native function SDIO_CLK_FB
#define SCC_GPIO_199          (((UINT32)GPIO_MMIO_OFFSET_SCC)<<16)+0x780    //(GPIO_199) native function EMMC0_CLK_FB
//
// Virtual GPIO pad definitions
//
#define NW_VGPIO_0            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B00    // GPIO#50 (vCNV_BTEN) - BT Enable
#define NW_VGPIO_1            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B10    // GPIO#51 (vCNV_GNEN) - GNSS Enable
#define NW_VGPIO_2            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B20    // GPIO#52 (vCNV_WFEN) - Wifi Mode
#define NW_VGPIO_3            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B30    // GPIO#53 (vCNV_WCEN) - CnviBtChargingMode
#define NW_VGPIO_4            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B40    // GPIO#54 (vCNV_BT_HOST_WAKEB) - CnviBtHostWakeInterrupt
#define NW_VGPIO_5            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B50    // GPIO#55 (vCNV_BT_IF_SELECT) - CnviBtInterface Select
#define NW_VGPIO_6            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B60    // GPIO#56 (vCNV_BT_UART_TXD)
#define NW_VGPIO_7            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B70    // GPIO#57 (vCNV_BT_UART_RXD)
#define NW_VGPIO_8            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B80    // GPIO#58 (vCNV_BT_UART_CTS_B)
#define NW_VGPIO_9            (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0B90    // GPIO#59 (vCNV_BT_UART_RTS_B)
#define NW_VGPIO_10           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0BA0    // GPIO#60 (vCNV_MFUART1_TXD)
#define NW_VGPIO_11           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0BB0    // GPIO#61 (vCNV_MFUART1_RXD)
#define NW_VGPIO_12           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0BC0    // GPIO#62 (vCNV_MFUART1_CTS_B)
#define NW_VGPIO_13           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0BD0    // GPIO#63 (vCNV_MFUART1_RTS_B)
#define NW_VGPIO_14           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0BE0    // GPIO#64 (vCNV_GNSS_UART_TXD)
#define NW_VGPIO_15           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0BF0    // GPIO#65 (vCNV_GNSS_UART_RXD)
#define NW_VGPIO_16           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C00    // GPIO#66 (vCNV_GNSS_UART_CTS_B)
#define NW_VGPIO_17           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C10    // GPIO#67 (vCNV_GNSS_UART_RTS_B)
#define NW_VGPIO_18           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C20    // GPIO#68 (vLPSS_UART0_TXD)
#define NW_VGPIO_19           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C30    // GPIO#69 (vLPSS_UART0_RXD)
#define NW_VGPIO_20           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C40    // GPIO#70 (vLPSS_UART0_CTS_B)
#define NW_VGPIO_21           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C50    // GPIO#71 (vLPSS_UART0_RTS_B)
#define NW_VGPIO_22           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C60    // GPIO#72 (vLPSS_UART1_TXD)
#define NW_VGPIO_23           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C70    // GPIO#73 (vLPSS_UART1_RXD)
#define NW_VGPIO_24           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C80    // GPIO#74 (vLPSS_UART1_CTS_B)
#define NW_VGPIO_25           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0C90    // GPIO#75 (vLPSS_UART1_RTS_B)
#define NW_VGPIO_26           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0CA0    // GPIO#76 (vLPSS_UART2_TXD)
#define NW_VGPIO_27           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0CB0    // GPIO#77 (vLPSS_UART2_RXD)
#define NW_VGPIO_28           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0CC0    // GPIO#78 (vLPSS_UART2_CTS_B)
#define NW_VGPIO_29           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0CD0    // GPIO#79 (vLPSS_UART2_RTS_B)
#define NW_VGPIO_30           (((UINT32)GPIO_MMIO_OFFSET_NW)<<16)+0x0CE0    // GPIO#80 (vCNV_GNSS_HOST_WAKEB)

#define	A_VGPIO_31            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0740    //GPIO#4 (vCNV_BT_I2S_BCLK)
#define	A_VGPIO_32            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0750    //GPIO#5 (vCNV_BT_I2S_WS_SYNC)
#define	A_VGPIO_33            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0760    //GPIO#6 (vCNV_BT_I2S_SDO)
#define	A_VGPIO_34            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0770    //GPIO#7 (vCNV_BT_I2S_SDI)
#define	A_VGPIO_35            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0780    //GPIO#8 (vAVS_I2S0_BCLK)
#define	A_VGPIO_36            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x0790    //GPIO#9 (vAVS_I2S0_WS_SYNC)
#define	A_VGPIO_37            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x07A0    //GPIO#10 (vAVS_I2S0_SDO)
#define	A_VGPIO_38            (((UINT32)GPIO_MMIO_OFFSET_AUDIO)<<16)+0x07B0    //GPIO#11 (vAVS_I2S0_SDI)

//
// Alias for GPIO pads - to maintain code commonality for modularity purpose
//
#define	GPIO_eSPI_MODE_EN         A_GPIO_175
#define	GPIO_eSPI_MODE_TYPE       SCC_GPIO_191
#define GPIO_CNVi_PIN_STRAP       SCC_GPIO_193	//CNV_RGI_DT - pin strap driven by CRF to low which enables the CNVi
#endif
