/** @file
  This file declares the compute CSE Variable Storage Support Protocol.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2018 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _CSE_VARIABLE_STORAGE_SUPPORT_PROTOCOL_H_
#define _CSE_VARIABLE_STORAGE_SUPPORT_PROTOCOL_H_

extern EFI_GUID gCseVariableStorageSupportProtocolGuid;

typedef struct _CSE_VARIABLE_STORAGE_SUPPORT_PROTOCOL CSE_VARIABLE_STORAGE_SUPPORT_PROTOCOL;

/**
  This function should be called after each trusted channel read message completes. After the last message
  is received the read message data will be sent to the variable cache.

  @param[in]        IsLastCommand               Indicates whether this is the last command for a variable.
  @param[in]        TrustedChannelReadResponse  A pointer to the trusted channel read response for the message.

  @retval           EFI_SUCCESS                 The read message data was successfully processsed.
  @retval           EFI_INVALID_PARAMETER       The TrustedChannelHeader parameter is NULL.
  @retval           Others                      An error occurred attempting to update the variable cache.

**/
typedef
EFI_STATUS
(EFIAPI *TRUSTED_CHANNEL_READ_MESSAGE_COMPLETE) (
  IN  BOOLEAN                                     IsLastCommand,
  IN  CONST HECI2_TRUSTED_CHANNEL_BIOS_READ_RESP  *TrustedChannelReadResponse
  );

/**
  This function should be called after each trusted channel write message completes. After the last message
  is received the variable index area will be updated to reflect the details of the variable written.

  @param[in]        IsLastCommand             Indicates whether this is the last command for a variable.

  @retval           EFI_SUCCESS               The write message was successfully processed.
  @retval           Others                    An error occurred updating the index area.

**/
typedef
EFI_STATUS
(EFIAPI *TRUSTED_CHANNEL_WRITE_MESSAGE_COMPLETE) (
  IN  BOOLEAN                                   IsLastCommand
  );

///
/// CSE Variable Storage Support Protocol
/// Interface to support operations needed to supplement CSE variable storage transactions.
///
struct _CSE_VARIABLE_STORAGE_SUPPORT_PROTOCOL {
  TRUSTED_CHANNEL_READ_MESSAGE_COMPLETE   ReadMessageComplete;
  TRUSTED_CHANNEL_WRITE_MESSAGE_COMPLETE  WriteMessageComplete;
};

#endif
