/** @file
  This file declares the Temporary Runtime DXE Debug Protocol

  This protocol provides debug services for Runtime DXE drivers at
  OS runtime. It is temporary until a DebugLib instance capable of
  supporting Runtime DXE is available.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _TEMP_RUNTIME_DEBUG_PROTOCOL_H_
#define _TEMP_RUNTIME_DEBUG_PROTOCOL_H_

typedef struct _TEMP_RUNTIME_DEBUG_PROTOCOL  TEMP_RUNTIME_DEBUG_PROTOCOL;

/**
  Prints a debug message and data in Runtime DXE.

  @param[in]      DebugMessageString      The debug string to print.
  @param[in]      DebugMessageData        A bufer of data to print.
  @param[in]      DebugMessageDataLength  The length in bytes of the DebugMessageData buffer.

  @retval         EFI_SUCCESS             The debug message was printed successfully.
  @retval         Others                  The debug message could not be printed.
**/
typedef
EFI_STATUS
(EFIAPI *TEMP_RUNTIME_DEBUG_PRINT)(
  IN   CHAR8        *DebugMessageString,
  IN   UINT8        *DebugMessageData,      OPTIONAL
  IN   UINTN        DebugMessageDataLength  OPTIONAL
  );

///
/// Temporary Runtime Debug Print Protocol
/// Interface functions to print debug messages in a Runtime DXE driver at Runtime.
///
struct _TEMP_RUNTIME_DEBUG_PROTOCOL {
  TEMP_RUNTIME_DEBUG_PRINT    RuntimeDebugPrint;        ///< Prints a debug message in Runtime DXE
};

#endif
