/**@file
  This library provides the power and performance Setting library definitions.
  
 @copyright
  INTEL CONFIDENTIAL
  Copyright 2012 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification
**/



#include "Pnpsettings.h"

PNP_SETTING g_PnPValueForPerf[] = {
  VALUEFORPERF_MSG_VALUES_PLATFORM_DEFAULT,
};

PNP_SETTING g_PnPValueForPower[] = {
  VALUEFORPOWER_MSG_VALUES_PLATFORM_DEFAULT,
};

PNP_SETTING g_PnPValueForPwrPerf[] = {
  VALUEFORPWRPERF_MSG_VALUES_PLATFORM_DEFAULT,
};

EFI_STATUS
InitializePnpSetting (
  IN SA_MISC_CONFIG *MiscConfig
)
{
  volatile UINT32        Index;
  UINT8                  Index1;
  UINT32                 Value;
  UINT32                 Mask;
  PNP_SETTING*           PnpSettingDataArray;
  UINT32                 PnpSettingArraySize;  

  if (MiscConfig->PnpSettings == PNP_POWER){
    //
    // Power
    //
    PnpSettingDataArray = g_PnPValueForPower;
    PnpSettingArraySize = sizeof(g_PnPValueForPower);
  } else if (MiscConfig->PnpSettings == PNP_PERF){
    //
    // Performance
    //
    PnpSettingDataArray = g_PnPValueForPerf;
    PnpSettingArraySize = sizeof(g_PnPValueForPerf);
  } else if (MiscConfig->PnpSettings == PNP_POWER_PERF){
    //
    // Power & Performance
    //  
    PnpSettingDataArray = g_PnPValueForPwrPerf;
    PnpSettingArraySize = sizeof(g_PnPValueForPwrPerf);
  } else {
    DEBUG ((EFI_D_INFO, "No PnP Setting been Configured !!!\n"));
    return EFI_SUCCESS;
  }

  for (Index = 0; Index <  PnpSettingArraySize/sizeof(PNP_SETTING); Index++) {
    if ((PnpSettingDataArray[Index].MsgPort ==0) && (PnpSettingDataArray[Index].MsgRegAddr == 0) &&(PnpSettingDataArray[Index].Value ==0) ){
      continue;
    }
    
    Mask = 0;
    for (Index1 = PnpSettingDataArray[Index].LSB; Index1 <= PnpSettingDataArray[Index].MSB; Index1++ ){
      Mask |=  (1 << Index1);
    }

    DEBUG ((EFI_D_INFO, "Output PwrPerf Register: PortID: 0x%x, Offset:0x%x, Field[%2d:%2d], Value:%8x\n", PnpSettingDataArray[Index].MsgPort, PnpSettingDataArray[Index].MsgRegAddr,PnpSettingDataArray[Index].MSB, PnpSettingDataArray[Index].LSB, PnpSettingDataArray[Index].Value));

    Value = SideBandRead32(PnpSettingDataArray[Index].MsgPort, PnpSettingDataArray[Index].MsgRegAddr);
    Value &=  ~Mask;
    Value |=  (PnpSettingDataArray[Index].Value << PnpSettingDataArray[Index].LSB);
    SideBandWrite32(PnpSettingDataArray[Index].MsgPort, PnpSettingDataArray[Index].MsgRegAddr, Value);
  }

  return EFI_SUCCESS;
}



