/**@file
  Header file for the Pnp Settings
  
 @copyright
  INTEL CONFIDENTIAL
  Copyright 2012 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification
**/


#ifndef PNP_SETTINGS_H
#define PNP_SETTINGS_H


#include <PiPei.h>
#include <Library/BaseLib.h>
#include <Library/DebugLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/PeiServicesLib.h>
#include <Library/ReportStatusCodeLib.h>



#include "SaAccess.h"
#include <Library/SideBandLib.h>
#include <Library/PeiPnpLib.h>

#include "aunit_bios_settings.h"
#include "bunit_bios_settings.h"
#include "tunit_bios_settings.h"

#define PNP_POWER       1
#define PNP_PERF        2 
#define PNP_POWER_PERF  3

#define VALUEFORPWRPERF_MSG_VALUES_PLATFORM_DEFAULT \
  AUNIT_VALUEFORPWRPERF_MSG_VALUES_PLATFORM_DEFAULT, \
  BUNIT_VALUEFORPWRPERF_MSG_VALUES_PLATFORM_DEFAULT, \
  TUNIT_VALUEFORPWRPERF_MSG_VALUES_PLATFORM_DEFAULT

#define VALUEFORPOWER_MSG_VALUES_PLATFORM_DEFAULT \
  AUNIT_VALUEFORPOWER_MSG_VALUES_PLATFORM_DEFAULT, \
  BUNIT_VALUEFORPOWER_MSG_VALUES_PLATFORM_DEFAULT, \
  TUNIT_VALUEFORPOWER_MSG_VALUES_PLATFORM_DEFAULT

#define VALUEFORPERF_MSG_VALUES_PLATFORM_DEFAULT \
  AUNIT_VALUEFORPERF_MSG_VALUES_PLATFORM_DEFAULT, \
  BUNIT_VALUEFORPERF_MSG_VALUES_PLATFORM_DEFAULT, \
  TUNIT_VALUEFORPERF_MSG_VALUES_PLATFORM_DEFAULT

typedef struct {
	UINT8   MsgPort;
	UINT16  MsgRegAddr;
	UINT8   MSB;
	UINT8   LSB;
	UINT32  Value;
} PNP_SETTING;

#endif
