/** @file
  Header file for the SA Init Library

 @copyright
  INTEL CONFIDENTIAL
  Copyright 1999 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _PEI_SA_INIT_LIB_H_
#define _PEI_SA_INIT_LIB_H_

#include <Ppi/SaPolicy.h>

/**
  System Agent PEI Initialization.

  @param[in]  FfsHeader    - Pointer to Firmware File System file header.
  @param[in]  PeiServices  - General purpose services available to every PEIM.

  @return  EFI_SUCCESS
**/
EFI_STATUS
EFIAPI
SaInit (
  IN EFI_PEI_FILE_HANDLE       FfsHeader,
  IN CONST EFI_PEI_SERVICES    **PeiServices
  );

/**
  ProgramEcBase: Program the EC Base
**/
VOID
ProgramEcBase (
  VOID
  );

/**
  Initialize the SA Aunit

  @param[in] PeiServices          General purpose services available to every PEIM.
  @param[in] SaPolicyPpi          Instance of SI_SA_POLICY_PPI
**/
VOID
SaAunitInit (
  IN CONST EFI_PEI_SERVICES  **PeiServices,
  IN SI_SA_POLICY_PPI        *SaPolicyPpi
  );

/**
  Initialize the SA Punit

  @param[in] PeiServices          General purpose services available to every PEIM.
**/
VOID SaPunitInit(
  IN CONST EFI_PEI_SERVICES  **PeiServices
  );

/**
Program North Cluster devices Subsystem Vendor Identifier (SVID) and Subsystem Identifier (SID).
**/
VOID
SaProgramSvidSid(
  IN  SI_SA_POLICY_PPI       *SiSaPolicyPpi
  );

#endif
