/** @file

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2012 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/


#ifndef _GLOBAL_NVS_AREA_H_
#define _GLOBAL_NVS_AREA_H_

//
// Includes
//
#define GLOBAL_NVS_DEVICE_ENABLE 1
#define GLOBAL_NVS_DEVICE_DISABLE 0

//
// Global NVS Area Protocol GUID
//
#define EFI_GLOBAL_NVS_AREA_PROTOCOL_GUID \
{ 0x74e1e48, 0x8132, 0x47a1, 0x8c, 0x2c, 0x3f, 0x14, 0xad, 0x9a, 0x66, 0xdc }
//
// Revision id - Added TPM related fields
//
#define GLOBAL_NVS_AREA_RIVISION_1       1
//
// Extern the GUID for protocol users.
//
extern EFI_GUID gEfiGlobalNvsAreaProtocolGuid;

///
/// Global NVS Area definition
///
#pragma pack (1)
typedef struct {
/**
  Miscellaneous Dynamic Values, the definitions below need to be matched
  GNVS definitions in Platform.ASL
**/
  UINT16      OperatingSystem;                        ///<   (00) Operating System
  UINT8       LidState;                               ///<   (02) Lid State (Lid Open = 1)
  UINT8       PowerState;                             ///<   (03) Power State (AC Mode = 1)
  //
  // Thermal Policy Values
  //
  UINT8       ActiveTripPoint;                        ///<   (04) Active Trip Point
  UINT8       CriticalThermalTripPoint;               ///<   (05) Critical Trip Point
  UINT8       Reserved11;							  ///<   (06) Reserved
  UINT8       Reserved12;							  ///<   (07) Reserved
  //
  // Processor Configuration Values
  //
  UINT8       ApicEnable;                             ///<   (08) APIC Enabled by SBIOS (APIC Enabled = 1)
  UINT8       LogicalProcessorCount;                  ///<   (09) Number of Logical Processors if MP Enabled != 0
  UINT8       Reserved0;                              ///<   (10) Reserved
  UINT16      CurrentDisplayState;                    ///<   (11) Current Display State
  UINT16      NextDisplayState;                       ///<   (13) Next Display State
  UINT8       NumberOfValidDeviceId;                  ///<   (15) Number of Valid Device IDs
  UINT32      DeviceId1;                              ///<   (16) Device ID 1
  UINT32      DeviceId2;                              ///<   (20) Device ID 2
  UINT32      DeviceId3;                              ///<   (24) Device ID 3
  UINT32      DeviceId4;                              ///<   (28) Device ID 4
  UINT32      DeviceId5;                              ///<   (32) Device ID 5
  //
  // Backlight Control Values
  //
  UINT8       BacklightControlSupport;                ///<   (36) Backlight Control Support
  UINT8       BrightnessPercentage;                   ///<   (37) Brightness Level Percentage
  UINT8       AlsEnable;                              ///<   (38) ALS Enable
  UINT8       MorData;                                ///<   (39) Memory Overwrite Request Data
  UINT32      PPResponse;                             ///<   (40) Physical Presence request operation response
  UINT8       PPRequest;                              ///<   (44) Physical Presence request operation
  UINT8       LastPPRequest;                          ///<   (45) Last Physical Presence request operation
  UINT8       BoardId;                                ///<   (46) Platform board id
  UINT32      IgdOpRegionAddress;                     ///<   (47) IGD OpRegion base address
  UINT8       IgdBootType;                            ///<   (51) IGD Boot Display Device
  UINT8       IgdPanelType;                           ///<   (52) IGD Panel Type CMOs option
  UINT8       IgdTvFormat;                            ///<   (53) IGD TV Format CMOS option
  UINT8       IgdTvMinor;                             ///<   (54) IGD TV Minor Format CMOS option
  UINT8       IgdPanelScaling;                        ///<   (55) IGD Panel Scaling
  UINT8       IgdBlcConfig;                           ///<   (56) IGD BLC Configuration
  UINT8       IgdBiaConfig;                           ///<   (57) IGD BIA Configuration
  UINT8       IgdSscConfig;                           ///<   (58) IGD SSC Configuration
  UINT8       Igd409;                                 ///<   (59) IGD 0409 Modified Settings Flag
  UINT8       Igd509;                                 ///<   (60) IGD 0509 Modified Settings Flag
  UINT8       Igd609;                                 ///<   (61) IGD 0609 Modified Settings Flag
  UINT8       Igd709;                                 ///<   (62) IGD 0709 Modified Settings Flag
  UINT8       IgdDvmtMemSize;                         ///<   (63) IGD DVMT Memory Size
  UINT8       IgdFunc1Enable;                         ///<   (64) IGD Function 1 Enable
  UINT8       IgdSciSmiMode;                          ///<   (65) GMCH SMI/SCI mode (0=SCI)
  UINT8       IgdPAVP;                                ///<   (66) IGD PAVP data
  UINT8       PcieOSCControl;                         ///<   (67) PCIE OSC Control
  UINT8       NativePCIESupport;                      ///<   (68) Native PCIE Setup Value
  UINT8       DisplaySupport;                         ///<   (69) _DOS Display Support Flag.
  UINT8       GlobalIoapicInterruptMode;              ///<   (70) Global IOAPIC/8259 Interrupt Mode Flag.
  UINT8       GlobalCoolingType;                      ///<   (71) Global Cooling Type Flag.
  UINT8       GlobalL01Counter;                       ///<   (72) Global L01 Counter.
  UINT32      DeviceId6;                              ///<   (73) Device ID 6
  UINT32      DeviceId7;                              ///<   (77) Device ID 7
  UINT32      DeviceId8;                              ///<   (81) Device ID 8
  UINT32      DeviceId9;                              ///<   (85) Device ID 9
  UINT32      DeviceId10;                             ///<   (89) Device ID 10
  UINT32      DeviceId11;                             ///<   (93) Device ID 11
  UINT32      DeviceId12;                             ///<   (97) Device ID 12
  UINT32      DeviceId13;                             ///<   (101) Device ID 13
  UINT32      DeviceId14;                             ///<   (105) Device ID 14
  UINT32      DeviceId15;                             ///<   (109) Device ID 15
  UINT32      HdaNhltAcpiAddr;                        ///<   (113) HD-Audio NHLT ACPI address
  UINT32      HdaNhltAcpiLength;                      ///<   (117) HD-Audio NHLT ACPI length
  UINT32      HdaDspFeatureMask;                      ///<   (121) HD-Audio DSP Feature Mask
  UINT8       PlatformFlavor;                         ///<   (125) Platform Flavor
  UINT8       BoardRev;                               ///<   (126) Board Rev
  UINT8       XhciMode;                               ///<   (127) xHCI controller mode
  UINT8       PmicEnable;                             ///<   (128) PMIC enable/disable
  UINT8       IpuAcpiMode;                            ///<   (129) IPU device Acpi type -- 0: Auto; 1: Acpi Igfx; 2: Acpi no Igfx
  UINT32      UART21Addr;                             ///<   (130) HSUART2 BAR1
  UINT32      GPIO0Addr;                              ///<   (134) GPIO0 BAR
  UINT32      GPIO0Len;                               ///<   (138) GPIO0 BAR Length
  UINT32      GPIO1Addr;                              ///<   (142) GPIO1 BAR
  UINT32      GPIO1Len;                               ///<   (146) GPIO1 BAR Length
  UINT32      GPIO2Addr;                              ///<   (150) GPIO2 BAR
  UINT32      GPIO2Len;                               ///<   (154) GPIO2 BAR Length
  UINT32      GPIO3Addr;                              ///<   (158) GPIO3 BAR
  UINT32      GPIO3Len;                               ///<   (162) GPIO3 BAR Length
  UINT32      GPIO4Addr;                              ///<   (166) GPIO4 BAR
  UINT32      GPIO4Len;                               ///<   (170) GPIO4 BAR Length
  UINT32      eMMCAddr;                               ///<   (174) eMMC BAR0
  UINT32      eMMCLen;                                ///<   (178) eMMC BAR0 Length
  UINT32      eMMC1Addr;                              ///<   (182) eMMC BAR1
  UINT32      eMMC1Len;                               ///<   (186) eMMC BAR1 Length
  UINT8       DptfEnable;                             ///<   (190) DPTF Enable
  UINT8       EnableSen0Participant;                  ///<   (191) EnableSen0Participant
  UINT8       PassiveThermalTripPointSen0;            ///<   (192) PassiveThermalTripPointSen0
  UINT8       CriticalThermalTripPointSen0S3;         ///<   (193) CriticalThermalTripPointSen0S3
  UINT8       HotThermalTripPointSen0;                ///<   (194) HotThermalTripPointSen0
  UINT8       CriticalThermalTripPointSen0;           ///<   (195) CriticalThermalTripPointSen0
  UINT8       DptfChargerDevice;                      ///<   (196) DptfChargerDevice
  UINT8       DptfDisplayDevice;                      ///<   (197) DptfDisplayDevice
  UINT8       DptfFanDevice;                          ///<   (198) DptfFanDevice
  UINT8       DptfProcessor;                          ///<   (199) DptfProcessor
  UINT32      DptfProcCriticalTemperature;            ///<   (200) DPTF Processor participant critical temperature
  UINT32      DptfProcPassiveTemperature;             ///<   (204) DPTF Processor participant passive temperature
  UINT32      DptfGenericCriticalTemperature0;        ///<   (208) DPTF Generic sensor0 participant critical temperature
  UINT32      DptfGenericPassiveTemperature0;         ///<   (212) DPTF Generic sensor0 participant passive temperature
  UINT32      DptfGenericCriticalTemperature1;        ///<   (216) DPTF Generic sensor1 participant critical temperature
  UINT32      DptfGenericPassiveTemperature1;         ///<   (220) DPTF Generic sensor1 participant passive temperature
  UINT32      DptfGenericCriticalTemperature2;        ///<   (224) Reserved
  UINT32      DptfGenericPassiveTemperature2;         ///<   (228) Reserved
  UINT32      DptfGenericCriticalTemperature3;        ///<   (232) DPTF Generic sensor3 participant critical temperature
  UINT32      DptfGenericPassiveTemperature3;         ///<   (236) DPTF Generic sensor3 participant passive temperature
  UINT32      DptfGenericCriticalTemperature4;        ///<   (240) DPTF Generic sensor3 participant critical temperature
  UINT32      DptfGenericPassiveTemperature4;         ///<   (244) DPTF Generic sensor3 participant passive temperature
  UINT8       CLpmSetting;                            ///<   (248) DPTF Current low power mode setting
  UINT32      DptfCriticalThreshold0;                 ///<   (249) DPTF Critical threshold0 for SCU
  UINT32      DptfCriticalThreshold1;                 ///<   (253) DPTF Critical threshold1 for SCU
  UINT32      DptfCriticalThreshold2;                 ///<   (257) DPTF Critical threshold2 for SCU
  UINT32      DptfCriticalThreshold3;                 ///<   (261) DPTF Critical threshold3 for SCU
  UINT32      DptfCriticalThreshold4;                 ///<   (265) DPTF Critical threshold4 for SCU
  UINT8       Reserved1;                              ///<   (269) Reserved
  UINT32      LPOEnable;                              ///<   (270) DPTF LPO Enable
  UINT32      LPOStartPState;                         ///<   (274) P-State start index
  UINT32      LPOStepSize;                            ///<   (278) Step size
  UINT32      LPOPowerControlSetting;                 ///<   (282) Power control setting
  UINT32      LPOPerformanceControlSetting;           ///<   (286) Performance control setting
  UINT8       DppmEnabled;                            ///<   (290) DPTF DPPM enable/disable (Deprecated)
  UINT8       BatteryChargingSolution;                ///<   (291) Battery charging solution 0-CLV 1-ULPMC
  UINT32      TPMAddress;                             ///<   (292) TPM Base Address
  UINT32      TPMLength;                              ///<   (296) TPM Length
  UINT8       PssDeveice;                             ///<   (300) PSS Device: 0 - None, 1 - Monzax 2K, 2 - Monzax 8K
  UINT8       ModemSel;                               ///<   (301) Modem selection: 0: Disabled, 1: 7260; 2: 7360;
  UINT8       GpsModeSel;                             ///<   (302) GNSS/GPS mode selection, 0: LPSS mode, 1: ISH mode
  UINT32      HdaDspModMask;                          ///<   (303) Hd-Audio DSP Post-Processing Module Mask
  UINT8       OsSelection;                            ///<   (307) OS Selection 0: WOS 1:AOS 2: Win7
  UINT8       WifiSel;                                ///<   (308) Wi-Fi Device Select 0: SDIO Lightning Peak 1: SDIO Broadcom 2. PCIe Lightning Peak
  UINT32      IPCBar0Address;                         ///<   (309) IPC Bar0 base address
  UINT32      IPCBar0Length;                          ///<   (313) IPC Bar0 Length
  UINT32      SSRAMBar0Address;                       ///<   (317) IPC Bar0 base address
  UINT32      SSRAMBar0Length;                        ///<   (321) IPC Bar0 Length
  UINT32      IPCBIOSMailBoxData;                     ///<   (325) IPC BIOS mail box data
  UINT32      IPCBIOSMailBoxInterface;                ///<   (329) IPC BIOS mail box interface
  UINT32      P2SBBaseAddress;                        ///<   (333) P2SB Base Address
  UINT8       EDPV;                                   ///<   (337) Check for eDP display device
  UINT32      DIDX;                                   ///<   (338) Device ID for eDP device
  UINT8       Reserved8;                              ///<   (342) Reserved
  UINT64      Reserved9   ;                           ///<   (343) Reserved
  UINT64      Reserved10;                             ///<   (351) Reserved
  UINT8       WorldCameraSel;                         ///<   (359) 0 - Disable, 1 - IMX214, 2 - IMX135
  UINT8       UserCameraSel;                          ///<   (360) 0 - Disable, 1 - OV2740
  UINT8       AudioSel;                               ///<   (361) 0 - Disable, 1 - WM8281, 2 - WM8998
  UINT32      LDMA11Addr;                             ///<   (362) DMA1 BAR1
  UINT32      LDMA11Len;                              ///<   (366) DMA1 BAR1 Length
  UINT8       CSDebugLightEC;                         ///<   (370) EC Debug Light (CAPS LOCK) for when in Low Power S0 Idle State
  UINT8       ECLowPowerMode;                         ///<   (371) EC Low Power Mode: 1 - Enabled, 0 - Disabled
  UINT8       CSNotifyEC;                             ///<   (372) EC Notification of Low Power S0 Idle State
  UINT8       EnableModernStandby;                    ///<   (373) Enable / Disable Modern Standby Mode
  UINT32      I2C21Addr;                              ///<   (374) I2C2 BAR1
  UINT32      I2C21Len;                               ///<   (378) I2C2 BAR1 Length
  UINT32      I2C31Addr;                              ///<   (382) I2C3 BAR1
  UINT32      I2C31Len;                               ///<   (386) I2C3 BAR1 Length
  UINT32      I2C41Addr;                              ///<   (390) I2C4 BAR1
  UINT32      I2C41Len;                               ///<   (394) I2C4 BAR1 Length
  UINT32      I2C51Addr;                              ///<   (398) I2C5 BAR1
  UINT32      I2C51Len;                               ///<   (402) I2C5 BAR1 Length
  UINT32      I2C61Addr;                              ///<   (406) I2C6 BAR1
  UINT32      I2C61Len;                               ///<   (410) I2C6 BAR1 Length
  UINT32      I2C71Addr;                              ///<   (414) I2C7 BAR1
  UINT32      I2C71Len;                               ///<   (418) I2C7 BAR1 Length
  UINT32      UsbOtgAddr;                             ///<   (422) USB OTG BAR0
  UINT32      UsbOtgAddr1;                            ///<   (426) USB OTG BAR1
  UINT32      PWM1Addr;                               ///<   (430) PWM1 BAR0
  UINT32      PWM1Len;                                ///<   (434) PWM1 BAR0 Length
  UINT32      PWM11Addr;                              ///<   (438) PWM1 BAR1
  UINT32      PWM11Len;                               ///<   (442) PWM1 BAR1 Length
  UINT32      PWM21Addr;                              ///<   (446) PWM2 BAR1
  UINT32      PWM21Len;                               ///<   (450) PWM2 BAR1 Length  >> Not used in BXT
  UINT32      Port80DebugValue;                       ///<   (454) Port 80 Debug Port Value
  UINT8       Rtd3P0dl;                               ///<   (458) User selectable Delay for Device D0 transition.
  UINT16      LowPowerS0IdleConstraint;               ///<   (459) PEP Constraints
/**
  Bit[1:0] - SATA (0:None, 1:SATA Ports[all], 2:SATA Controller)
     [2]   - En/Dis UART 0
     [3]   -        UART 1
     [4]   -        SDIO
     [5]   -        I2C 0
     [6]   -        I2C 1
     [7]   -        XHCI
     [8]   -        HD Audio (includes ADSP)
     [9]   -        Gfx
     [10]  -        EMMC
     [11]  -        SDXC
     [12]  -        CPU
     [13]  -        CSME
**/
  UINT8       PepList;                                ///<   (461) RTD3 PEP support list
  //
  //(BIT0 - GFx , BIT1 - Sata, BIT2 - UART, BIT3 - SDHC, Bit4 - I2C0, BIT5 - I2C1, Bit6 - XHCI, Bit7 - Audio)
  //
  UINT8       PL1LimitCS;                             ///<   (462) set PL1 limit when entering CS
  UINT16      PL1LimitCSValue;                        ///<   (463) PL1 limit value
  UINT8       PstateCapping;                          ///<   (465) P-state Capping
  UINT8       PassiveThermalTripPoint;                ///<   (466) Passive Trip Point
  UINT16      RTD3Config0;                            ///<   (467) RTD3 Config Setting(BIT0:ZPODD,BIT1:USB Camera Port4, BIT2/3:SATA Port3, Bit4/5:Sata Port1/2, Bit6:Card Reader, Bit7:WWAN, Bit8:WSB SIP FAB1 Card reader)
  UINT8       Rtd3Support;                            ///<   (469) Runtime D3 support.
  UINT8       LowPowerS0Idle;                         ///<   (470) Low Power S0 Idle Enable
  UINT32      SPI21Addr;                              ///<   (471) SPI2 BAR1
  UINT32      SPI21Len;                               ///<   (475) SPI2 BAR1 Length
  UINT32      SPI31Addr;                              ///<   (479) SPI3 BAR1
  UINT32      SPI31Len;                               ///<   (483) SPI3 BAR1 Length
  UINT32      SDIO1Addr;                              ///<   (487) SDCard BAR1
  UINT32      SDIO1Len;                               ///<   (491) SDCard BAR1 Length
  UINT32      SDCard1Addr;                            ///<   (495) SDIO BAR1
  UINT32      SDCard1Len;                             ///<   (499) SDIO BAR1 Length
  UINT32      SPI1Addr;                               ///<   (503) SPI BAR1
  UINT32      SPI1Len;                                ///<   (507) SPI BAR1 Length
  UINT8       SataPortState;                          ///<   (511) SATA port state
  //
  //Bit0 - Port0, Bit1 - Port1, Bit2 - Port2, Bit3 - Port3
  //
  UINT32      UART11Addr;                             ///<   (512) HSUART BAR1
  UINT32      UART11Len;                              ///<   (516) HSUART BAR1 Length
  UINT32      UART21Len;                              ///<   (520) HSUART2 BAR1 Length
  UINT8       WPCN381U;                               ///<   (524) WPCN381U: only used by BXT-P
  UINT8       ECAvailability;                         ///<   (525) Embedded Controller Availability Flag.
  UINT8       PowerButtonSupport;                     ///<   (526) 10sec Power button support
/**
  Bit0: 10 sec P-button Enable/Disable
  Bit1: Internal Flag
  Bit2: Rotation Lock flag, 0:unlock, 1:lock
  Bit3: Slate/Laptop Mode Flag, 0: Slate, 1: Laptop
  Bit4: Undock / Dock Flag, 0: Undock, 1: Dock
  Bit5: VBDL Flag. 0: VBDL is not called, 1: VBDL is called, Virtual Button Driver is loaded.
  Bit6: Reserved for future use.
  Bit7: EC 10sec PB Override state for S3/S4 wake up.
**/
  UINT8       DebugState;                             ///<   (527) Debug State
  UINT32      IpuAddr;                                ///<   (528) IPU Base Address
  UINT8       NumberOfBatteries;                      ///<   (532) Number of batteries
  UINT8       BatteryCapacity0;                       ///<   (533) Battery 0 Stored Capacity
  UINT8       PciDelayOptimizationEcr;                ///<   (534) PciDelayOptimizationEcr
  UINT8       IgdHpllVco;                             ///<   (535) HPLL VCO
  UINT32      UsbTypeCOpBaseAddr;                     ///<   (536) USB Type C OpRegion base address
  UINT8       SelectBtDevice;                         ///<   (540) Blue Tooth Device Selection

  UINT32      DptfProcActiveTemperature;              ///<   (541) DptfProcActiveTemperature
  UINT8       EnableMemoryDevice;                     ///<   (545) EnableMemoryDevice
  UINT8       ActiveThermalTripPointTMEM;             ///<   (546) ActiveThermalTripPointTMEM
  UINT8       PassiveThermalTripPointTMEM;            ///<   (547) PassiveThermalTripPointTMEM
  UINT8       CriticalThermalTripPointTMEM;           ///<   (548) CriticalThermalTripPointTMEM
  UINT8       ThermalSamplingPeriodTMEM;              ///<   (549) ThermalSamplingPeriodTMEM

  UINT8       EnableActivePolicy;                     ///<   (550) EnableActivePolicy
  UINT8       EnablePassivePolicy;                    ///<   (551) EnablePassivePolicy
  UINT8       EnableCriticalPolicy;                   ///<   (552) EnableCriticalPolicy
  UINT8       EnableAPPolicy;                         ///<   (553) EnableAPPolicy
  UINT8       PassiveTc1Value;                        ///<   (554) Passive Trip Point TC1 Value
  UINT8       PassiveTc2Value;                        ///<   (555) Passive Trip Point TC2 Value
  UINT8       PassiveTspValue;                        ///<   (556) Passive Trip Point TSP Value
  UINT8       Reserved13;							  ///<   (557) Reserved
  UINT8       Reserved2;                              ///<   (558) Reserved
  UINT8       IgdState;                               ///<   (559) IGD State
  UINT8       HighPerfMode;                           ///<   (560) Enable/Disable HighPerformance mode for Dptf
  UINT8       DptfWwanDevice;                         ///<   (561) DPTF WWAN
  UINT8       Reserved3;                              ///<   (562) Reserved
  UINT8       PanelSel;                               ///<   (563) Panel AOB  0 - Disable, 1 - TIANMA , 2 - TRULY Fab B TypeC, 3 - TRULY Fab B, 4 -TRULY Fab B Command Mode, 5 - TRULY Fab B Command Mode TypeC
  UINT8       IrmtCfg;                                ///<   (564) IRMT Configuration
  UINT8       ThermalSamplingPeriodTCPU;              ///<   (565) ThermalSamplingPeriodTCPU
  UINT8       BxtStepping;                            ///<   (566) BXT Stepping
  UINT8       Reserved4;                              ///<   (567) Reserved
  UINT8       LtrEnable[6];                           ///<   (568) Latency Tolerance Reporting Enable
                                                      ///<   (569) Latency Tolerance Reporting Enable
                                                      ///<   (570) Latency Tolerance Reporting Enable
                                                      ///<   (571) Latency Tolerance Reporting Enable
                                                      ///<   (572) Latency Tolerance Reporting Enable
                                                      ///<   (573) Latency Tolerance Reporting Enable
  UINT8       ObffEnable[6];                          ///<   (574) Optimized Buffer Flush and Fill
                                                      ///<   (575) Optimized Buffer Flush and Fill
                                                      ///<   (576) Optimized Buffer Flush and Fill
                                                      ///<   (577) Optimized Buffer Flush and Fill
                                                      ///<   (578) Optimized Buffer Flush and Fill
                                                      ///<   (579) Optimized Buffer Flush and Fill
  UINT32      RpAddress[6];                           ///<   (580) Root Port address 1
                                                      ///<   (584) Root Port address 2
                                                      ///<   (588) Root Port address 3
                                                      ///<   (592) Root Port address 4
                                                      ///<   (596) Root Port address 5
                                                      ///<   (600) Root Port address 6
  UINT16      PcieLtrMaxSnoopLatency[6];              ///<   (604) PCIE LTR max snoop Latency 1
                                                      ///<   (606) PCIE LTR max snoop Latency 2
                                                      ///<   (608) PCIE LTR max snoop Latency 3
                                                      ///<   (610) PCIE LTR max snoop Latency 4
                                                      ///<   (612) PCIE LTR max snoop Latency 5
                                                      ///<   (614) PCIE LTR max snoop Latency 6
  UINT16      PcieLtrMaxNoSnoopLatency[6];            ///<   (616) PCIE LTR max no snoop Latency 1
                                                      ///<   (618) PCIE LTR max no snoop Latency 2
                                                      ///<   (620) PCIE LTR max no snoop Latency 3
                                                      ///<   (622) PCIE LTR max no snoop Latency 4
                                                      ///<   (624) PCIE LTR max no snoop Latency 5
                                                      ///<   (626) PCIE LTR max no snoop Latency 6
  UINT8       TrtRevision;                            ///<   (628) TrtRevision
  UINT32      Reserved5;                              ///<   (629)
  UINT8       EnablePowerParticipant;                 ///<   (633) EnablePowerParticipant
  UINT8       EnablePowerBossPolicy;                  ///<   (634) EnablePowerBossPolicy
  //
  // Hybrid Graphics Support
  //
  UINT8       HgEnabled;                              ///<   (635) HG Enabled (0=Disabled, 1=Enabled)
  UINT32      XPcieCfgBaseAddress;                    ///<   (636) Any Device's PCIe Config Space Base Address
  UINT16      DelayAfterPwrEn;                        ///<   (640) Delay after Power Enable
  UINT16      DelayAfterHoldReset;                    ///<   (642) Delay after Hold Reset
  UINT32      HgHoldRstCommOffset;                    ///<   (644) dGPU HLD RST GPIO Community Offset
  UINT16      HgHoldRstPinOffset;                     ///<   (648) dGPU HLD RST GPIO Pin Offset
  UINT8       HgHoldRstActiveInfo;                    ///<   (650) dGPU HLD RST GPIO Active Information
  UINT32      HgPwrEnableCommOffset;                  ///<   (651) dGPU PWR Enable GPIO Community Offset
  UINT16      HgPwrEnablePinOffset;                   ///<   (655) dGPU PWR Enable GPIO Pin Offset
  UINT8       HgPwrEnableActiveInfo;                  ///<   (657) dGPU PWR Enable GPIO Active Information
  UINT8       PcieEpSecBusNum;                        ///<   (658) dGPU Root Port Base Address
  UINT8       PcieEpCapOffset;                        ///<   (659) dGPU Base Address
  UINT32      RootPortBaseAddress;                    ///<   (660) dGPU Root Port Base Address
  UINT32      NvIgOpRegionAddress;                    ///<   (664) NVIG support
  UINT32      NvHmOpRegionAddress;                    ///<   (668) NVHM support
  UINT32      ApXmOpRegionAddress;                    ///<   (672) AMDA support
  UINT8       EnableSen1Participant;                  ///<   (676) EnableSen1Participant
  UINT8       EnableSen2Participant;                  ///<   (677) EnableSen2Participant
  UINT8       EnableSen3Participant;                  ///<   (678) EnableSen3Participant
  UINT8       EnableSen4Participant;                  ///<   (679) EnableSen4Participant
  UINT8       ActiveThermalTripPointSen1;             ///<   (680) ActiveThermalTripPointSen1
  UINT8       PassiveThermalTripPointSen1;            ///<   (681) PassiveThermalTripPointSen1
  UINT8       CriticalThermalTripPointSen1;           ///<   (682) CriticalThermalTripPointSen1
  UINT8       HotThermalTripPointSen1;                ///<   (683) HotThermalTripPointSen1
  UINT8       CriticalThermalTripPointSen1S3;         ///<   (684) CriticalThermalTripPointSen1S3
  UINT8       ThermistorSamplingPeriodSen1;           ///<   (685) ThermistorSamplingPeriodSen1
  UINT8       ActiveThermalTripPointSen2;             ///<   (686) ActiveThermalTripPointSen2
  UINT8       PassiveThermalTripPointSen2;            ///<   (687) PassiveThermalTripPointSen2
  UINT8       CriticalThermalTripPointSen2;           ///<   (688) CriticalThermalTripPointSen2
  UINT8       HotThermalTripPointSen2;                ///<   (689) HotThermalTripPointSen2
  UINT8       CriticalThermalTripPointSen2S3;         ///<   (690) CriticalThermalTripPointSen2S3
  UINT8       ThermistorSamplingPeriodSen2;           ///<   (691) ThermistorSamplingPeriodSen2
  UINT8       ActiveThermalTripPointSen3;             ///<   (692) ActiveThermalTripPointSen3
  UINT8       PassiveThermalTripPointSen3;            ///<   (693) PassiveThermalTripPointSen3
  UINT8       CriticalThermalTripPointSen3;           ///<   (694) CriticalThermalTripPointSen3
  UINT8       HotThermalTripPointSen3;                ///<   (695) HotThermalTripPointSen3
  UINT8       CriticalThermalTripPointSen3S3;         ///<   (696) CriticalThermalTripPointSen3S3
  UINT8       ThermistorSamplingPeriodSen3;           ///<   (697) ThermistorSamplingPeriodSen3
  UINT8       ActiveThermalTripPointSen4;             ///<   (698) ActiveThermalTripPointSen4
  UINT8       PassiveThermalTripPointSen4;            ///<   (699) PassiveThermalTripPointSen4
  UINT8       CriticalThermalTripPointSen4;           ///<   (700) CriticalThermalTripPointSen4
  UINT8       HotThermalTripPointSen4;                ///<   (701) HotThermalTripPointSen4
  UINT8       CriticalThermalTripPointSen4S3;         ///<   (702) CriticalThermalTripPointSen4S3
  UINT8       ThermistorSamplingPeriodSen4;           ///<   (703) ThermistorSamplingPeriodSen4
  UINT32      DptfProcCriticalTemperatureS3;          ///<   (704) DptfProcCriticalTemperatureS3
  UINT32      DptfProcHotThermalTripPoint;            ///<   (708) DptfProcHotThermalTripPoint
  UINT8       DPTFReserved;                           ///<   (712) DPTFReserved0
  UINT8       DPTFReserved1;                          ///<   (713) DPTFReserved1
  UINT8       PmicStepping;                           ///<   (714) PMIC Stepping
  UINT8       ScHdAudioIoBufferOwnership;             ///<   (715) ScHdAudioIoBufferOwnership
  UINT8       XdciEnable;                             ///<   (716) Xdci Enable
  UINT8       Reserved6;                              ///<   (717) Reserved
  UINT8       Reserved7;                              ///<   (718) Reserved
  UINT8       VirtualKeyboard;                        ///<   (719) Virtual keyboard Function 0- Disable 1- Discrete Touch 2- Integrated Touch
//WiGig
  UINT8       WiGigEnable;                            ///<   (720) WiGig Enable for BXTM B0
  UINT16      WiGigSPLCPwrLimit;                      ///<   (721) WiGig SPLC Power Limit
  UINT32      WiGigSPLCTimeWindow;                    ///<   (723) WiGig SPLC Time Window
  //PSM
  UINT8       PsmEnable;                              ///<   (727) WiGig Power sharing manager enabling
  UINT8       PsmSPLC0DomainType;                     ///<   (728) WiGig PSM SPLC0 Domain Type
  UINT16      PsmSPLC0PwrLimit;                       ///<   (729) WiGig PSM SPLC0 Power Limit
  UINT32      PsmSPLC0TimeWindow;                     ///<   (731) WiGig PSM SPLC0 Time Window
  UINT8       PsmSPLC1DomainType;                     ///<   (735) WiGig PSM SPLC1 Domain Type
  UINT16      PsmSPLC1PwrLimit;                       ///<   (736) WiGig PSM SPLC1 Power Limit
  UINT32      PsmSPLC1TimeWindow;                     ///<   (738) WiGig PSM SPLC1 Time Window

  UINT8       PsmDPLC0DomainType;                     ///<   (742) WiGig PSM DPLC0 Domain Type
  UINT8       PsmDPLC0DomainPerference;               ///<   (743) WiGig PSM DPLC0 Domain Preference
  UINT8       PsmDPLC0PowerLimitIndex;                ///<   (744) WiGig PSM DPLC0 Power Limit Index
  UINT16      PsmDPLC0PwrLimit;                       ///<   (745) WiGig PSM DPLC0 Power Limit
  UINT32      PsmDPLC0TimeWindow;                     ///<   (747) WiGig PSM DPLC0 Time Window

  UINT8       PsmDPLC1DomainType;                     ///<   (751) WiGig PSM DPLC1 Domain Type
  UINT8       PsmDPLC1DomainPerference;               ///<   (752) WiGig PSM DPLC1 Domain Preference
  UINT8       PsmDPLC1PowerLimitIndex;                ///<   (753) WiGig PSM DPLC1 Power Limit Index
  UINT16      PsmDPLC1PwrLimit;                       ///<   (754) WiGig PSM DPLC1 Power Limit
  UINT32      PsmDPLC1TimeWindow;                     ///<   (756) WiGig PSM DPLC1 Time Window


  UINT8       I2s343A;                                ///<   (760) I2S audio codec device - INT343A
  UINT8       I2s34C1;                                ///<   (761) I2S audio codec device - INT34C1
  UINT8       I2cNfc;                                 ///<   (762) I2C NFC device - NXP1001
  UINT8       I2cPss;                                 ///<   (763) I2S PSS device - IMPJ0003
  UINT8       UartBt;                                 ///<   (764) UART BT device - BCM2E40
  UINT8       UartGps;                                ///<   (765) UART GPS device - BCM4752

  UINT64      HdaDspPpModCustomGuid1Low;              ///<   (766)
  UINT64      HdaDspPpModCustomGuid1High;             ///<   (774)
  UINT64      HdaDspPpModCustomGuid2Low;              ///<   (782)
  UINT64      HdaDspPpModCustomGuid2High;             ///<   (790)
  UINT64      HdaDspPpModCustomGuid3Low;              ///<   (798)
  UINT64      HdaDspPpModCustomGuid3High;             ///<   (806)
  UINT16      PowerParticipantPollingRate;            ///<   (814) DPTF PowerParticipantPollingRate
  UINT16      EnableDCFG;                             ///<   (816) DPTF Enable DPTF Configuration

  UINT8       OemDesignVariable0;                     ///<   (818) DPTF Oem Design Variable
  UINT8       OemDesignVariable1;                     ///<   (819) DPTF Oem Design Variable
  UINT8       OemDesignVariable2;                     ///<   (820) DPTF Oem Design Variable
  UINT8       OemDesignVariable3;                     ///<   (821) DPTF Oem Design Variable
  UINT8       OemDesignVariable4;                     ///<   (822) DPTF Oem Design Variable
  UINT8       OemDesignVariable5;                     ///<   (823) DPTF Oem Design Variable

  UINT8       EnableVS1Participant;                   ///<   (824) EnableVS1Participant
  UINT8       ActiveThermalTripPointVS1;              ///<   (825) ActiveThermalTripPointVS1
  UINT8       PassiveThermalTripPointVS1;             //<    (826) PassiveThermalTripPointVS1
  UINT8       CriticalThermalTripPointVS1;            ///<   (827) CriticalThermalTripPointVS1
  UINT8       CriticalThermalTripPointVS1S3;          ///<   (828) CriticalThermalTripPointVS1S3
  UINT8       HotThermalTripPointVS1;                 ///<   (829) HotThermalTripPointVS1
  UINT8       EnableVS2Participant;                   ///<   (830) EnableVS2Participant
  UINT8       ActiveThermalTripPointVS2;              ///<   (831) ActiveThermalTripPointVS2
  UINT8       PassiveThermalTripPointVS2;             //<    (832) PassiveThermalTripPointVS2
  UINT8       CriticalThermalTripPointVS2;            ///<   (833) CriticalThermalTripPointVS2
  UINT8       CriticalThermalTripPointVS2S3;          ///<   (834) CriticalThermalTripPointVS2S3
  UINT8       HotThermalTripPointVS2;                 ///<   (835) HotThermalTripPointVS2
  UINT8       EnableVS3Participant;                   ///<   (836) EnableVS3Participant
  UINT8       ActiveThermalTripPointVS3;              ///<   (837) ActiveThermalTripPointVS3
  UINT8       PassiveThermalTripPointVS3;             ///<   (838) PassiveThermalTripPointVS3
  UINT8       CriticalThermalTripPointVS3;            ///<   (839) CriticalThermalTripPointVS3
  UINT8       CriticalThermalTripPointVS3S3;          ///<   (840) CriticalThermalTripPointVS3S3
  UINT8       HotThermalTripPointVS3;                 ///<   (841) HotThermalTripPointVS3

  UINT8       EnableVSPolicy;                         ///<   (842) EnableVsPolicy
  UINT8       Spi1SensorDevice;                       ///<   (843) SPI1 Fingerprint device - FPC1020/FPC1021
  UINT8       NfcSelect;                              ///<   (844) NFC device select: 0: disabled; 1: NFC (IPT)/secure NFC; 2: NFC;
  UINT16      RfemSPLCPwrLimit;                       ///<   (845) RFEM SPLC Power Limit
  UINT32      RfemSPLCTimeWindow;                     ///<   (847) RFEM SPLC Time Window
  UINT8       PanelSelect;                            ///<   (851) Panel Selection (0, 1, 2, 3=eDP, >=4 for MIPI)
  UINT8       EPIEnable;                              ///<   (852) EPIEnable
  UINT8       TypeCEnable;                            ///<   (853) TypeCEnable

  UINT8       PassiveThermalTripPointWWAN;            ///<   (854) PassiveThermalTripPointWWAN
  UINT8       CriticalThermalTripPointWWANS3;         ///<   (855) CriticalThermalTripPointWWANS3
  UINT8       HotThermalTripPointWWAN;                ///<   (856) HotThermalTripPointWWAN
  UINT8       CriticalThermalTripPointWWAN;           ///<   (857) CriticalThermalTripPointWWAN
  UINT8       DisplayHighLimit;                       ///<   (858) DisplayHighLimit
  UINT8       DisplayLowLimit;                        ///<   (859) DisplayLowLimit
  UINT8       Ipc1Enable;                             ///<   (860) IPC1Enable
  UINT8       OsDbgEnable;                            ///<   (861) OsDbgEnable
  UINT8       Ps2MouseEnable;                         ///<   (862) Ps2 Mouse Enable
  UINT8       Ps2KbMsEnable;                          ///<   (863) Ps2 Keyboard and Mouse Enable
  UINT32      Mmio32Base;                             ///<   (864) PCIE MMIO resource base
  UINT32      Mmio32Length;                           ///<   (868) PCIE MMIO resource length
  UINT8       CsmEnable;                              ///<   (872) CsmEnable
  UINT8       CameraRotationAngle;                    ///<   (873) Camera Sensor Rotation Angle
  UINT8       I2cTouchPanel;                          ///<   (874) I2c Touch Panel
  UINT8       I2cTouchPad;                            ///<   (875) I2c Touch pad
  UINT32      I2C0Speed;                              ///<   (876) I2C0 Speed - Standard mode/Fast mode/FastPlus mode/HighSpeed mode
  UINT32      I2C1Speed;                              ///<   (880) I2C1 Speed - Standard mode/Fast mode/FastPlus mode/HighSpeed mode
  UINT32      I2C2Speed;                              ///<   (884) I2C2 Speed - Standard mode/Fast mode/FastPlus mode/HighSpeed mode
  UINT32      I2C3Speed;                              ///<   (888) I2C3 Speed - Standard mode/Fast mode/FastPlus mode/HighSpeed mode
  UINT32      I2C4Speed;                              ///<   (892) I2C4 Speed - Standard mode/Fast mode/FastPlus mode/HighSpeed mode
  UINT32      I2C5Speed;                              ///<   (996) I2C5 Speed - Standard mode/Fast mode/FastPlus mode/HighSpeed mode
  UINT32      I2C6Speed;                              ///<   (900) I2C6 Speed - Standard mode/Fast mode/FastPlus mode/HighSpeed mode
  UINT32      I2C7Speed;                              ///<   (904) I2C7 Speed - Standard mode/Fast mode/FastPlus mode/HighSpeed mode  
  UINT8       SdCardEnable;                           ///<   (908) SdCardEnable
  UINT8       SdioEnable;                             ///<   (909) SdioEnable
  UINT8       EmmcEnable;                             ///<   (910) EmmcEnable
  UINT8       EmmcHostMaxSpeed;                       ///<   (911) eMMC Host Max Speed
  UINT8       ConvertibleEnable;                      ///<   (912) Convertible enable
  UINT8       DockEnable;                             ///<   (913) Dock enable
  UINT8       VirtualGpioButtonSxBitmask;             ///<   (914) Bitmask for virtual GPIO button behavior in Sx wake scenario
  /**
  Bit0: Slate indicator
  Bit1: Dock indicator
  **/
  UINT8       CnviMode;                               ///<   (915) Cnvi Mode        0: Disable, 1: Auto
  UINT8       CnviBtCore;                             ///<   (916) Cnvi BtCore      0: Disable, 1: Enable
  UINT8       CnviBtInterface;                        ///<   (917) Cnvi BtInterface 0: UART,    1: USB
  UINT8       CnviDevStatus;                          ///<   (918) CNVi device status 0 - integrated, 1 - Discreet, 2 - Disabled
  UINT8	      DisableSxWake;						  //<    (919) Merge Power Rails  0: Disable, 1: Enable 
  UINT8       EnableIvCamParticipant;                 ///<   (920) EnableIvCamParticipant
  UINT8       ActiveThermalTripPointIvCam;            ///<   (921) ActiveThermalTripPointIvCam
  UINT8       PassiveThermalTripPointIvCam;           ///<   (922) PassiveThermalTripPointIvCam
  UINT8       CriticalThermalTripPointIvCam;          ///<   (923) CriticalThermalTripPointIvCam
  UINT8       CriticalThermalTripPointIvCamS3;        ///<   (924) CriticalThermalTripPointIvCamS3
  UINT8       HotThermalTripPointIvCam;               ///<   (925) HotThermalTripPointIvCam
  
  UINT8       WTVX;                                   ///<   (926) WITT test devices' version
  UINT8       WITX;                                   ///<   (927) WITT test devices' connection point
  UINT8       GPTD;                                   ///<   (928) GPIO test devices
  UINT16      GDBT;                                   ///<   (929) GPIO test devices' debounce value,
  UINT8       UTKX;                                   ///<   (931) UTK test devices' connection point
  UINT8       SPTD;                                   ///<   (932) SerialIo additional test devices
  UINT32      TableLoadBuffer;                        ///<   (933) [TableLoadBuffer] Buffer for runtime ACPI Table loading
  
  //
  //Dynamic SAR FOR WiFi
  //
  
  UINT8    WrddDomainType1;                           ///<   (937) WrddDomainType1
  UINT16   WrddCountryIndentifier1;                   ///<   (938) WrddCountryIndentifier1
  UINT8    WrddDomainType2;                           ///<   (940) WrddDomainType2
  UINT16   WrddCountryIndentifier2;                   ///<   (941) WrddCountryIndentifier2
  UINT8    WrdsWiFiSarEnable;                         ///<   (943) WrdsWiFiSarEnable
  UINT8    WrdsWiFiSarTxPowerSet1Limit1;              ///<   (944) WrdsWiFiSarTxPowerSet1Limit1
  UINT8    WrdsWiFiSarTxPowerSet1Limit2;              ///<   (945) WrdsWiFiSarTxPowerSet1Limit2
  UINT8    WrdsWiFiSarTxPowerSet1Limit3;              ///<   (946) WrdsWiFiSarTxPowerSet1Limit3
  UINT8    WrdsWiFiSarTxPowerSet1Limit4;              ///<   (947) WrdsWiFiSarTxPowerSet1Limit4
  UINT8    WrdsWiFiSarTxPowerSet1Limit5;              ///<   (948) WrdsWiFiSarTxPowerSet1Limit5
  UINT8    WrdsWiFiSarTxPowerSet1Limit6;              ///<   (949) WrdsWiFiSarTxPowerSet1Limit6
  UINT8    WrdsWiFiSarTxPowerSet1Limit7;              ///<   (950) WrdsWiFiSarTxPowerSet1Limit7
  UINT8    WrdsWiFiSarTxPowerSet1Limit8;              ///<   (951) WrdsWiFiSarTxPowerSet1Limit8
  UINT8    WrdsWiFiSarTxPowerSet1Limit9;              ///<   (952) WrdsWiFiSarTxPowerSet1Limit9
  UINT8    WrdsWiFiSarTxPowerSet1Limit10;             ///<   (953) WrdsWiFiSarTxPowerSet1Limit10
  UINT8    EwrdWiFiDynamicSarEnable;                  ///<   (954) EwrdWiFiDynamicSarEnable
  UINT8    EwrdWiFiDynamicSarRangeSets;               ///<   (955) EwrdWiFiDynamicSarRangeSets
  UINT8    EwrdWiFiSarTxPowerSet2Limit1;              ///<   (956) EwrdWiFiSarTxPowerSet2Limit1
  UINT8    EwrdWiFiSarTxPowerSet2Limit2;              ///<   (957) EwrdWiFiSarTxPowerSet2Limit2
  UINT8    EwrdWiFiSarTxPowerSet2Limit3;              ///<   (958) EwrdWiFiSarTxPowerSet2Limit3
  UINT8    EwrdWiFiSarTxPowerSet2Limit4;              ///<   (959) EwrdWiFiSarTxPowerSet2Limit4
  UINT8    EwrdWiFiSarTxPowerSet2Limit5;              ///<   (960) EwrdWiFiSarTxPowerSet2Limit5
  UINT8    EwrdWiFiSarTxPowerSet2Limit6;              ///<   (961) EwrdWiFiSarTxPowerSet2Limit6
  UINT8    EwrdWiFiSarTxPowerSet2Limit7;              ///<   (962) EwrdWiFiSarTxPowerSet2Limit7
  UINT8    EwrdWiFiSarTxPowerSet2Limit8;              ///<   (963) EwrdWiFiSarTxPowerSet2Limit8
  UINT8    EwrdWiFiSarTxPowerSet2Limit9;              ///<   (964) EwrdWiFiSarTxPowerSet2Limit9
  UINT8    EwrdWiFiSarTxPowerSet2Limit10;             ///<   (965) EwrdWiFiSarTxPowerSet2Limit10
  UINT8    EwrdWiFiSarTxPowerSet3Limit1;              ///<   (966) EwrdWiFiSarTxPowerSet3Limit1
  UINT8    EwrdWiFiSarTxPowerSet3Limit2;              ///<   (967) EwrdWiFiSarTxPowerSet3Limit2
  UINT8    EwrdWiFiSarTxPowerSet3Limit3;              ///<   (968) EwrdWiFiSarTxPowerSet3Limit3
  UINT8    EwrdWiFiSarTxPowerSet3Limit4;              ///<   (969) EwrdWiFiSarTxPowerSet3Limit4
  UINT8    EwrdWiFiSarTxPowerSet3Limit5;              ///<   (970) EwrdWiFiSarTxPowerSet3Limit5
  UINT8    EwrdWiFiSarTxPowerSet3Limit6;              ///<   (971) EwrdWiFiSarTxPowerSet3Limit6
  UINT8    EwrdWiFiSarTxPowerSet3Limit7;              ///<   (972) EwrdWiFiSarTxPowerSet3Limit7
  UINT8    EwrdWiFiSarTxPowerSet3Limit8;              ///<   (973) EwrdWiFiSarTxPowerSet3Limit8
  UINT8    EwrdWiFiSarTxPowerSet3Limit9;              ///<   (974) EwrdWiFiSarTxPowerSet3Limit9
  UINT8    EwrdWiFiSarTxPowerSet3Limit10;             ///<   (975) EwrdWiFiSarTxPowerSet3Limit10
  UINT8    EwrdWiFiSarTxPowerSet4Limit1;              ///<   (976) EwrdWiFiSarTxPowerSet4Limit1
  UINT8    EwrdWiFiSarTxPowerSet4Limit2;              ///<   (977) EwrdWiFiSarTxPowerSet4Limit2
  UINT8    EwrdWiFiSarTxPowerSet4Limit3;              ///<   (978) EwrdWiFiSarTxPowerSet4Limit3
  UINT8    EwrdWiFiSarTxPowerSet4Limit4;              ///<   (979) EwrdWiFiSarTxPowerSet4Limit4
  UINT8    EwrdWiFiSarTxPowerSet4Limit5;              ///<   (980) EwrdWiFiSarTxPowerSet4Limit5
  UINT8    EwrdWiFiSarTxPowerSet4Limit6;              ///<   (981) EwrdWiFiSarTxPowerSet4Limit6
  UINT8    EwrdWiFiSarTxPowerSet4Limit7;              ///<   (982) EwrdWiFiSarTxPowerSet4Limit7
  UINT8    EwrdWiFiSarTxPowerSet4Limit8;              ///<   (983) EwrdWiFiSarTxPowerSet4Limit8
  UINT8    EwrdWiFiSarTxPowerSet4Limit9;              ///<   (984) EwrdWiFiSarTxPowerSet4Limit9
  UINT8    EwrdWiFiSarTxPowerSet4Limit10;             ///<   (985) EwrdWiFiSarTxPowerSet4Limit10
  UINT8    WgdsWiFiSarDeltaGroup1PowerMax1;           ///<   (986) WgdsWiFiSarDeltaGroup1PowerMax1
  UINT8    WgdsWiFiSarDeltaGroup1PowerChainA1;        ///<   (987) WgdsWiFiSarDeltaGroup1PowerChainA1
  UINT8    WgdsWiFiSarDeltaGroup1PowerChainB1;        ///<   (988) WgdsWiFiSarDeltaGroup1PowerChainB1
  UINT8    WgdsWiFiSarDeltaGroup1PowerMax2;           ///<   (989) WgdsWiFiSarDeltaGroup1PowerMax2
  UINT8    WgdsWiFiSarDeltaGroup1PowerChainA2;        ///<   (990) WgdsWiFiSarDeltaGroup1PowerChainA2
  UINT8    WgdsWiFiSarDeltaGroup1PowerChainB2;        ///<   (991) WgdsWiFiSarDeltaGroup1PowerChainB2
  UINT8    WgdsWiFiSarDeltaGroup2PowerMax1;           ///<   (992) WgdsWiFiSarDeltaGroup2PowerMax1
  UINT8    WgdsWiFiSarDeltaGroup2PowerChainA1;        ///<   (993) WgdsWiFiSarDeltaGroup2PowerChainA1
  UINT8    WgdsWiFiSarDeltaGroup2PowerChainB1;        ///<   (994) WgdsWiFiSarDeltaGroup2PowerChainB1
  UINT8    WgdsWiFiSarDeltaGroup2PowerMax2;           ///<   (995) WgdsWiFiSarDeltaGroup2PowerMax2
  UINT8    WgdsWiFiSarDeltaGroup2PowerChainA2;        ///<   (996) WgdsWiFiSarDeltaGroup2PowerChainA2
  UINT8    WgdsWiFiSarDeltaGroup2PowerChainB2;        ///<   (997) WgdsWiFiSarDeltaGroup2PowerChainB2
  UINT8    WgdsWiFiSarDeltaGroup3PowerMax1;           ///<   (998) WgdsWiFiSarDeltaGroup3PowerMax1
  UINT8    WgdsWiFiSarDeltaGroup3PowerChainA1;        ///<   (999) WgdsWiFiSarDeltaGroup3PowerChainA1
  UINT8    WgdsWiFiSarDeltaGroup3PowerChainB1;        ///<   (1000) WgdsWiFiSarDeltaGroup3PowerChainB1
  UINT8    WgdsWiFiSarDeltaGroup3PowerMax2;           ///<   (1001) WgdsWiFiSarDeltaGroup3PowerMax2
  UINT8    WgdsWiFiSarDeltaGroup3PowerChainA2;        ///<   (1002) WgdsWiFiSarDeltaGroup3PowerChainA2
  UINT8    WgdsWiFiSarDeltaGroup3PowerChainB2;        ///<   (1003) WgdsWiFiSarDeltaGroup3PowerChainB2
  UINT8    Reserved14[36];                            ///<   (1004:1039)
  // Reserved for Groups 4 to 9, each needs 6 bytes and total 36 bytes reserved
  UINT8    WiFiDynamicSarAntennaACurrentSet;          ///<   (1040)    WiFiDynamicSarAntennaACurrentSet
  UINT8    WiFiDynamicSarAntennaBCurrentSet;          ///<   (1041)    WiFiDynamicSarAntennaBCurrentSet
  UINT8    BluetoothSar;                              ///<   (1042)    BluetoothSar
  UINT8    BluetoothSarBr;                            ///<   (1043)    BluetoothSarBr
  UINT8    BluetoothSarEdr2;                          ///<   (1044)    BluetoothSarEdr2
  UINT8    BluetoothSarEdr3;                          ///<   (1045)    BluetoothSarEdr3
  UINT8    BluetoothSarLe;                            ///<   (1046)    BluetoothSarLe
  UINT8    BluetoothSarLe2;                           ///<   (1047)    BluetoothSarEdr3
  UINT8    BluetoothSarLeLr;                          ///<   (1048)    BluetoothSarLe
  UINT8    Reserved15[2];                             ///<   (1049:1050)
  // Reserved for Bluetooth Sar future use
  
  //
  // Wireless Power Limit Support
  //
  UINT8       WifiEnable;                             ///<   (1051) WifiEnable
  UINT8       WifiDomainType1;                        ///<   (1052) WifiDomainType1
  UINT16      WifiPowerLimit1;                        ///<   (1053) WifiPowerLimit1
  UINT32      WifiTimeWindow1;                        ///<   (1055) WifiTimeWindow1
  UINT8       WifiDomainType2;                        ///<   (1059) WifiDomainType2
  UINT16      WifiPowerLimit2;                        ///<   (1060) WifiPowerLimit2
  UINT32      WifiTimeWindow2;                        ///<   (1062) WifiTimeWindow2
  UINT8       WifiDomainType3;                        ///<   (1066) WifiDomainType3
  UINT16      WifiPowerLimit3;                        ///<   (1067) WifiPowerLimit3
  UINT32      WifiTimeWindow3;                        ///<   (1069) WifiTimeWindow3
  UINT8       AntennaDiversity;                       ///<   (1073) AntennaDiversity

  //
  // ITSS Sideband Registers
  //
  UINT8       ItssPort;                               ///<   (1074) ITSS port ID
  UINT16      PRCO;                                   ///<   (1075) PIRQ Routing Control Offset
  UINT32      UART20Addr;                             ///<   (1077) HSUART2 BAR0
  UINT32      AuxPowerLimit;

  //
  // PMAX devices settings
  //
  UINT8    PmaxDevice;
  UINT8    PmaxAudioCodec;
  UINT8    PmaxWfCamera;
  UINT8    PmaxUfCamera;
  UINT8    PmaxFlashDevice;
} EFI_GLOBAL_NVS_AREA;
#pragma pack ()

///
/// Global NVS Area Protocol
///
typedef struct _EFI_GLOBAL_NVS_AREA_PROTOCOL {
  EFI_GLOBAL_NVS_AREA     *Area;
} EFI_GLOBAL_NVS_AREA_PROTOCOL;

#endif
