/** @file
  This file contains Initialization of the BDAT data structures for both
  v1.0 and v2.0 taken from v0.6 of "A Compatible Method to Access BIOS
  Data Structures".

@copyright
 Copyright (c) 2013 - 2015 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _BDAT_H_
#define _BDAT_H_

///
/// BDAT definitions
///
#define MAX_NODE              1                     ///< Max processors per system
#define MAX_DIMM              2                     ///< Max DIMMs per channel
#define MAX_RANK_DIMM         2                     ///< Max ranks per DIMM
//#define MAX_BITS             72
#define MAX_SPD_BYTE        256                     ///< Number of bytes in Serial EEPROM

VOID
FillRMTBdatStructure (
  IN  OUT   MMRC_DATA         *MrcData,
      OUT   VOID              *RmtDataBuffer,
  IN        UINT32            RmtDataBufferSize
);

UINT32
GetRMTStructSize (
  IN  OUT   MMRC_DATA         *MrcData
);

#endif // _BDAT_H_
