/** @file
  This file contains extended defination of ConfigMemData.c

@copyright
 Copyright (c) 2013 - 2015 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _CONFIGMEMDATA_H_
#define _CONFIGMEMDATA_H_

#include "Mrc.h"
#include "McFunc.h"
#include "MrcFunc.h"

#pragma pack(1)

typedef enum {
  Trwsr = 0,
  Twrsr,
  Trrdr,
  Twwdr,
  Trwdr,
  Twrdr,
  Trrdd,
  Twwdd,
  Trwdd,
  Twrdd,
  MaxTimingGuardband
} TURNAROUND_TIMINGS;

extern UINT16 mDdrMemoryFrequencyTable[C_MAXDDR];
extern UINT16 mCoreFrequencyTable[C_MAXCOREFREQ];
extern UINT8  mDdrFreq2WLTable[C_MAXDDR];

extern UINT32 mDmapRegisters[MAX_DIMM_CONFIGS][4];
extern UINT32 mDimmConfigs[MAX_DIMM_CONFIGS];
extern UINT8  TimingGuardbands[MaxTimingGuardband][C_MAXDDR];
#pragma pack()

#endif
