/**@file

@copyright
 Copyright (c) 0 - 2015 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification
**/
#ifndef _MRCEFIDEFINITIONS_H_
#define _MRCEFIDEFINITIONS_H_

#if defined(EFI_MEMORY_INIT) || defined(FSP_FLAG)
#include <Ppi/DramPolicyPpi.h>
#include <Library/SteppingLib.h>
#define DRAM_POLICY DRAM_POLICY_PPI
#else

#include <Guiddef.h>
#include "DataTypes.h"

#define DRAM_POLICY_NUMBER_CHANNELS         4
#define DRAM_POLICY_NUMBER_BITS             32
#define DRAM_POLICY_NUMBER_SPD_ADDRESSES    2

#pragma pack(push,1)

typedef GUID                      EFI_GUID;

typedef struct {
  UINT8 RankEnable;
  UINT8 DeviceWidth;
  UINT8 DramDensity;
  UINT8 Option;
  UINT8 OdtConfig;
  UINT8 TristateClk1;
  UINT8 Mode2N;
  UINT8 OdtLevels;
} DRP_DRAM_POLICY;

typedef struct {
    UINT8               Package;
    UINT8               Profile;
    UINT8               MemoryDown;
    UINT8               DDR3LPageSize;
    UINT8               DDR3LASR;
    EFI_PHYSICAL_ADDRESS MrcTrainingDataPtr;
    UINT8               ScramblerSupport;
    UINT16              ChannelHashMask;
    UINT16              SliceHashMask;
    UINT8               InterleavedMode;
    UINT8               ChannelsSlicesEnabled;//bit0=SliceEnabled;bit1=channelEnabled
    UINT8               MinRefRate2xEnabled;
    UINT8               DualRankSupportEnabled;
    UINT16              SystemMemorySizeLimit;
    UINT16              LowMemMaxVal;
    UINT16              HighMemMaxVal;
    UINT8               DisableFastBoot;
    UINT8               RmtMode;
    UINT8               RmtCheckRun;
    UINT16              RmtMarginCheckScaleHighThreshold;
    UINT32              MsgLevelMask;
    UINT8               SpdAddress[DRAM_POLICY_NUMBER_SPD_ADDRESSES];
    UINT8               ChSwizzle[DRAM_POLICY_NUMBER_CHANNELS][DRAM_POLICY_NUMBER_BITS];
    DRP_DRAM_POLICY     ChDrp[DRAM_POLICY_NUMBER_CHANNELS];
    UINT8               DebugMsgLevel;
    UINT8               reserved[13];
} DRAM_POLICY_PPI;

#pragma pack(pop)

typedef enum {
  Bxt          = 0x00,
  Bxt1,
  BxtX,

  BxtP,
  BxtSeriesMax = 0xFF
} BXT_SERIES;

#endif
#endif
