/** @file
  This file the include all the external MRC Function.

@copyright
 Copyright (c) 2013 - 2015 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _MRCFUNC_H_
#define _MRCFUNC_H_

#include "Mrc.h"

/**
  Bit scan forward 8 bits.

  @param[in]  Input

  @retval  UINT8
**/
UINT8
BitScanForward8 (
  IN        UINT8   Input
  );

/**
  Bit scan reverse 16 bits.

  @param[in]  Input

  @retval  INT8
**/
INT8
BitScanReverse16 (
  IN        UINT16   Input
  );

/**
  Fill input structure.

  @param[in,out]  MrcData

  @retval  MMRC_STATUS
**/
MMRC_STATUS
FillInputStructure (
  IN  OUT   MMRC_DATA   *MrcData
  );

/**
  FillOutputStructure

  @param[in,out]  MrcData

  @retval  MMRC_STATUS
**/
MMRC_STATUS
FillOutputStructure (
  IN  OUT   MMRC_DATA   *MrcData
  );

/**
  Returns the IAFW version.

  @param[in,out]      MrcData        MRC Data Structure
  @param[out]         IafwVersion    The IAFW version

**/
VOID
GetIafwVersion (
  IN  OUT   MMRC_DATA   *MrcData,
  OUT       MrcVersion  *IafwVersion
  );

/**
  Returns a UINT32 value representing the MRC and MMRC versions

  @param[in,out]      MrcData        MRC Data Structure

  @retval             MrcVersion     A UINT32 representation of the MRC Version
                                     [31:16] = Mrc Version
                                     [15:0]  = MMRC Version
**/
UINT32
GetMrcVersions (
  IN  OUT   MMRC_DATA   *MrcData
);

/**
  Calculates a CRC-32 of the specified data buffer.

  @param[in] Data     - Pointer to the data buffer.
  @param[in] DataSize - Size of the data buffer, in bytes.

  @retval The CRC-32 value.
**/
extern
UINT32
MrcCalculateCrc32 (
  IN     const UINT8  *const Data,
  IN     const UINT32 DataSize
  );
#endif

