#ifndef __SSA_RESULTS_H__
#define __SSA_RESULTS_H__

#pragma pack (push, 1)

#ifndef INT32_MAX
#define INT32_MAX                       (0x7FFFFFFF)
#endif

///
/// SSA results buffer header.
///
typedef struct {
  UINT32  Revision;
  BOOLEAN TransferMode;
  struct {
    UINT32   Reserved;
    UINT32   MetadataSize;
    EFI_GUID MetadataType;
  } MdBlock;
  struct {
    UINT32   Reserved;
    EFI_GUID ResultType;
    UINT32   ResultElementSize;
    INT32    ResultCapacity;
    INT32    ResultElementCount;
  } RsBlock;
} RESULTS_DATA_HDR;


#pragma pack (pop)

#endif
