/** @file

@copyright
 Copyright (c) 2015 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/

#include "MemOdt.h"
#include "BxtOdtActivationTable.h"

#if ODT_TABLE

ODT_ACT_STRUCT OdtActTable[MAX_ODT_ACT_CONFIG] = {
  //
  // Config index
  //
  (DIMM0 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (SR_DIMM << 7)           | // slot0
  (EMPTY_DIMM << 10)       | // slot1
  (EMPTY_DIMM << 13),        // slot2
  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM0 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (DR_DIMM << 7)           | // slot0
  (EMPTY_DIMM << 10)       | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM0 << 0)             | // target dimm
  (RANK1 << 2)             | // target rank
  (DR_DIMM << 7)           | // slot0
  (EMPTY_DIMM << 10)       | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK1)   |
    0,
  },
  //
  // Config index
  //
  (DIMM0 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (SR_DIMM << 7)           | // slot0
  (SR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM1 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (SR_DIMM << 7)           | // slot0
  (SR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM0 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (DR_DIMM << 7)           | // slot0
  (DR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    // read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM0 << 0)             | // target dimm
  (RANK1 << 2)             | // target rank
  (DR_DIMM << 7)           | // slot0
  (DR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK1)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM1 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (DR_DIMM << 7)           | // slot0
  (DR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM1 << 0)             | // target dimm
  (RANK1 << 2)             | // target rank
  (DR_DIMM << 7)           | // slot0
  (DR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK1)   |
    0,
  },
  //
  // Config index
  //
  (DIMM0 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (DR_DIMM << 7)           | // slot0
  (SR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM0 << 0)             | // target dimm
  (RANK1 << 2)             | // target rank
  (DR_DIMM << 7)           | // slot0
  (SR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK1)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM1 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (DR_DIMM << 7)           | // slot0
  (SR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM0 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (SR_DIMM << 7)           | // slot0
  (DR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM1 << 0)             | // target dimm
  (RANK0 << 2)             | // target rank
  (SR_DIMM << 7)           | // slot0
  (DR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK0)   |
    0,
  },
  //
  // Config index
  //
  (DIMM1 << 0)             | // target dimm
  (RANK1 << 2)             | // target rank
  (SR_DIMM << 7)           | // slot0
  (DR_DIMM << 10)          | // slot1
  (EMPTY_DIMM << 13),        // slot2

  //
  // ODT activation matrix
  //
  {
    //
    //  read
    //
    MCODT_ACT << 15  |
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    0,
    //
    // write
    //
    ODT_ACT << (DIMM0 * MAX_RANK_DIMM + RANK0)   |
    ODT_ACT << (DIMM1 * MAX_RANK_DIMM + RANK1)   |
    0,
  },
};

#endif // ODT_TABLE
