/** @file
  Constant and table defination for memory configuration.

@copyright
 Copyright (c) 2013 - 2015 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/

#include "ConfigMemData.h"
#include "MmrcHooks.h"

/*UINT8 TimingGuardbands[MaxTimingGuardband][C_MAXDDR] = {
{2, 2, 2, 2, 2}, // TRWSR
{0, 0, 0, 0, 0}, // TWRSR
{0, 0, 0, 0, 0}, // TRRDR
{2, 2, 2, 2, 2}, // TWWDR
{1, 1, 1, 1, 1}, // TRWDR
{0, 0, 0, 0, 0}, // TWRDR
{0, 0, 0, 0, 0}, // TRRDD
{2, 2, 2, 2, 2}, // TWWDD
{1, 1, 1, 1, 1}, // TRWDD
{1, 1, 1, 1, 1}, // TWRDD
};
*/
UINT8 TimingGuardbands[MaxTimingGuardband][C_MAXDDR] = {
  {2, 2, 2, 2, 2}, // TRWSR
  {2, 2, 2, 2, 2}, // TWRSR
  {2, 2, 2, 2, 2}, // TRRDR
  {2, 2, 2, 2, 2}, // TWWDR
  {2, 2, 2, 2, 2}, // TRWDR
  {2, 2, 2, 2, 2}, // TWRDR
  {2, 2, 2, 2, 2}, // TRRDD
  {2, 2, 2, 2, 2}, // TWWDD
  {2, 2, 2, 2, 2}, // TRWDD
  {2, 2, 2, 2, 2}, // TWRDD
};

UINT16 mDdrMemoryFrequencyTable[C_MAXDDR] = {
  1600, 1866, 2133, 2400, 2666
};

UINT16 mCoreFrequencyTable[C_MAXCOREFREQ] = {
  800, 1066
};

UINT8 mDdrFreq2WLTable[C_MAXDDR] = {
  8, 9, 10, 11, 12
};

///
/// The 2nd dimension is for the density. tFAW changes if the density is under or over 8Gb.
///
UINT8 mFawTableDdr3[C_MAXDDR][2] = {
  {24, 32}, // 1600MHz
  {26, 33}, // 1866MHz
  {0, 0},   // 2133Hz  // N/A for DDR3
  {0, 0},   // 2400MHz // N/A for DDR3
  {0, 0}    // 2666MHz // N/A for DDR3
};

UINT8 mFawTableDdr4[C_MAXDDR][2] = {
  {16, 20}, // 1600MHz
  {16, 22}, // 1866MHz
  {16, 23}, // 2133MHz
  {16, 26}, // 2400MHz
  {0, 0}   // 2666MHz // DNV TODO - 2666 spec not complete yet. Fill in later.
};
