;;@file
;
;@copyright
; Copyright (c) 2013 - 2015 Intel Corporation. All rights reserved
; This software and associated documentation (if any) is furnished
; under a license and may only be used or copied in accordance
; with the terms of the license. Except as permitted by the
; license, no part of this software or documentation may be
; reproduced, stored in a retrieval system, or transmitted in any
; form or by any means without the express written consent of
; Intel Corporation.
; This file contains an 'Intel Peripheral Driver' and is uniquely
; identified as "Intel Reference Module" and is licensed for Intel
; CPUs and chipsets under the terms of your license agreement with
; Intel or your vendor. This file may be modified by the user, subject
; to additional terms of the license agreement.
;
;@par Specification
;;
;**************************************************************************
;*                                                                        *
;*  PURPOSE:                                                              *
;*                                                                        *
;*      This file contains sample code to initialize processor cache      *
;*      and pass control to the Memory Reference Code                     *
;*                                                                        *
;**************************************************************************
IFNDEF EFI_MEMORY_INIT

.586P


.MODEL flat, SYSCALL
.CODE
;_TEXT32 SEGMENT PARA USE32 PUBLIC 'CODE32'

  PUBLIC _MrcEntryPoint_FAR
  extern @ConfigureMemory@4:      NEAR

; Single MRC entry point
_MrcEntryPoint_FAR PROC FAR PUBLIC
  push  ecx                 ; save *MrcData
  call  @ConfigureMemory@4  ; __fastcall calling convention means initial parameter pointer is in ecx
  pop   ecx
  retf
_MrcEntryPoint_FAR ENDP

ENDIF

END

