/** @file
  File name:    DPIC.h
  Input File:   BXTM_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in DPIC.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

  @copyright
  Copyright (c) 2005-2016 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by the
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is uniquely
  identified as 'Intel Reference Module' and is licensed for Intel
  CPUs and chipsets under the terms of your license agreement with
  Intel or your vendor. This file may be modified by the user, subject
  to additional terms of the license agreement.

  @par Specification
**/
#ifndef _DPIC_H_
#define _DPIC_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define DPIC_CRI_CFG_DPIC_REG                              0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Idle count limit for ISM which is determines when the block should transition
    // to IDLE_REQ. Recommended value = 8'd16.[br]A value of zero breaks the design resulting
    // in an unresponsive endpoint.
    //
    // Bits[7:0], RW, default = 0x10
    //
    UINTX cgctrl_idlecnt : 8;
    //
    // Clock gate defeature. When set to 1, disables side_clk gating within the endpoint
    // when ISM is IDLE. Set to 0 for normal operation. Recommended value = 0
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX cgctrl_clkgatedef : 1;
    //
    // Clock gate enable. When set to 1, enables the ISM to leave ACTIVE and gates the
    // side_clk if in the IDLE state. When set to 0, the ISM never leaves ACTIVE once
    // it gets to that state and the clock is never gated. Recommended value = 1.
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX cgctrl_clkgaten : 1;
    //
    // Reserved
    //
    // Bits[31:10], RO, default = 0x0
    //
    UINTX reserved : 22;
  } Bits;
  UINTX Data;
} DPIC_CRI_CFG_DPIC_STRUCT;
#endif // ASM_INC

#define PLLDIVCTL_DPIC_REG                                 0x00000004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // mplldivs reference divider ratio select (diva). not part of adpll.
    //
    // Bits[4:0], RW, default = 0x2
    //
    UINTX pll_cmn_refdivsel : 5;
    //
    // Reserved bits
    //
    // Bits[23:5], RO, default = 0x0
    //
    UINTX reserved1 : 19;
    //
    // mplldivs feedback multiplexer select (muxa). not part of adpll.
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX pll_cmn_fbmuxsel : 2;
    //
    // Reserved bits
    //
    // Bits[27:26], RO, default = 0x0
    //
    UINTX reserved0 : 2;
    //
    // Feedback clock reset addition (used during power switch operation)
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX fbdivrst_b : 1;
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
    UINTX reserved : 3;
  } Bits;
  UINTX Data;
} PLLDIVCTL_DPIC_STRUCT;
#endif // ASM_INC

#define PLLCTL_DPIC_REG                                    0x00000008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // pll enable signal
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pll_cmn_pllen : 1;
    //
    // pll lock signal (hardware based)
    //
    // Bits[1:1], RO/V, default = 0x0
    //
    UINTX pll_cmn_plllock : 1;
    //
    // forces sfr on even when pll is disabled (active standby mode)
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX pll_cmn_sfren : 1;
    //
    // forces dco calibration when exiting deep sleep mode. required if changing feedback
    // divider ratio or refclk frequency
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX pll_cmn_dcocal : 1;
    //
    // Reserved
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX reserved3 : 4;
    //
    // mplldivs divider reset bar
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX pll_cmn_mplldivsrstb : 1;
    //
    // Reserved
    //
    // Bits[11:9], RO, default = 0x0
    //
    UINTX reserved2 : 3;
    //
    // mplldivs 2xclk multiplexer select (muxc). not part of adpll.
    //
    // Bits[13:12], RW, default = 0x1
    //
    UINTX pll_cmn_2xclkmuxsel : 2;
    //
    // Reserved
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved1 : 2;
    //
    // 2x clock tree drive output enable
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX pll_cmn_2xclken : 1;
    //
    // Reserved
    //
    // Bits[19:17], RO, default = 0x0
    //
    UINTX reserved0 : 3;
    //
    // Coarse delay value for the min DLL delay matching logic in PLL.[br]This should
    // match the initial coarse delay value generated from initial DLL Compensation.
    //
    // Bits[24:20], RW, default = 0x0
    //
    UINTX pll_cmn_fbclktrim : 5;
    //
    // Reserved
    //
    // Bits[31:25], RO, default = 0x0
    //
    UINTX reserved : 7;
  } Bits;
  UINTX Data;
} PLLCTL_DPIC_STRUCT;
#endif // ASM_INC

#define CRIPG_DELAY1_DPIC_REG                              0x0000000C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay for staggered power gate disable. Determines the number of cycles interval
    // between each power gate enable bit being de-asserted. Cripgctrl FSM is in PWRUNGATE
    // state. A value of zero breaks the design resulting in an unresponsive powergating
    // control.
    //
    // Bits[2:0], RW, default = 0x1
    //
    UINTX cripg_disable_stgdly : 3;
    //
    // Reserved
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX reserved1 : 1;
    //
    // Delay for staggered power gate enable. Determines the number of cycles interval
    // between each power gate enable bit being asserted. Cripgctrl FSM is in PWRGATE
    // state. A value of zero breaks the design resulting in an unresponsive powergating
    // control.
    //
    // Bits[6:4], RW, default = 0x1
    //
    UINTX cripg_enable_stgdly : 3;
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX reserved0 : 1;
    //
    // Delay for staggered power gate enable. Determines the number of cycles interval
    // between each power gate enable bit being asserted. Cripgctrl FSM is in PWRGATE
    // state. Value of 0 not supported.
    //
    // Bits[15:8], RW, default = 0x3
    //
    UINTX cripg_clkgaten_stgdly : 8;
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX reserved : 16;
  } Bits;
  UINTX Data;
} CRIPG_DELAY1_DPIC_STRUCT;
#endif // ASM_INC

#define CRIPG_DELAY0_DPIC_REG                              0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When both fabric and agent ISMs are idle. This delay indicates the no. of cycle
    // the FSMs need to be idle after receiving clkack before entering power gating flow.
    // A value of zero breaks the design resulting in an unresponsive powergating control.
    //
    // Bits[7:0], RW, default = 0x14
    //
    UINTX cripg_ism_idle_dly : 8;
    //
    // On wakeup, this indicates the no. of cycles that FSM stays in PWRUGCLKACK after
    // receiving clkack. A value of zero breaks the design resulting in an unresponsive
    // powergating control.
    //
    // Bits[15:8], RW, default = 0x3
    //
    UINTX cripg_clkreq_dsrt_dly : 8;
    //
    // No. of cycles after agent ism idle lock/unlock before FSM moves on from ISMLOCK/ISMUNLOCK.
    // A value of zero breaks the design resulting in an unresponsive powergating control.
    //
    // Bits[18:16], RW, default = 0x3
    //
    UINTX cripg_ism_lock_dly : 3;
    //
    // Reserved
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX reserved1 : 1;
    //
    // No. of cycles after staggered reset assertion/de-assertion before FSM moves on
    // from RSTASRT/RSTDSRT. A value of zero breaks the design resulting in an unresponsive
    // powergating control.
    //
    // Bits[22:20], RW, default = 0x2
    //
    UINTX cripg_rst_asrt_dly : 3;
    //
    // Reserved
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX reserved0 : 1;
    //
    // No. of cycles after isolation cells are enabled/disabled before FSM moves on from
    // ISOLEN/ISOLDIS. A value of zero breaks the design resulting in an unresponsive
    // powergating control.
    //
    // Bits[25:24], RW, default = 0x2
    //
    UINTX cripg_isol_en_dly : 2;
    //
    // Reserved
    //
    // Bits[31:26], RO, default = 0x0
    //
    UINTX reserved : 6;
  } Bits;
  UINTX Data;
} CRIPG_DELAY0_DPIC_STRUCT;
#endif // ASM_INC

#define CRIPGCTL_DPIC_REG                                  0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Config override for staggered power gate enable. When set to '1' cripgen_staggered[3:0]
    // is equal to the value set in cripgen_staggered register field. When set to '0',
    // cripgen_staggered[3:0] is equal to the logic defined value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX cripgen_staggered_ovr : 1;
    //
    // Reserved
    //
    // Bits[3:1], RO, default = 0x0
    //
    UINTX reserved1 : 3;
    //
    // Config control for staggered power gate enable. This config value is used for
    // the cripgen_staggered[3:0] when config override in cripgen_staggered_ovr is set
    // to '1'. This value is ignored if cripgen_staggered_ovr is set to '0'.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX cripgen_staggered : 4;
    //
    // Reserved
    //
    // Bits[11:8], RO, default = 0x0
    //
    UINTX reserved0 : 4;
    //
    // Config override for isolation enable. This config value is used for isol_en when
    // config override in cripg_isolen_ovr is set to '1'. This value is ignored if cripg_isolen_ovr
    // is set to '0'.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX cripg_isolen_ovr : 1;
    //
    // Config control for isolation enable. This config value is used for isol_en when
    // config override in cripg_isolen_ovr is set to '1'. This value is ignored if cripg_isolen_ovr
    // is set to '0'.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX cripg_isolen : 1;
    //
    // Config control for side clock req. This config value is used to override o_side_clkreq.
    // When this config bit is set to '1', o_side_clkreq is set to '1' except when in
    // CLKREQDSRT state of the CRIPG FSM
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX cripg_side_clkreq_ovr : 1;
    //
    // Config control for side clock req. This config value is used to override o_side_clkreq.
    // When this config bit is set to '1', o_side_clkreq is set to '1' except when in
    // CLKREQDSRT state of the CRIPG FSM
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX cripg_clkgaten_ovr : 1;
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX reserved : 16;
  } Bits;
  UINTX Data;
} CRIPGCTL_DPIC_STRUCT;
#endif // ASM_INC

#define CRIPGEN_CTL_DPIC_REG                               0x00000018
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CRI Power Gating Enable. When set to '1' - CRI Power gating logic is enabled.
    // When set to '0' - CRI Power gating logic is disabled.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX cripgen : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} CRIPGEN_CTL_DPIC_STRUCT;
#endif // ASM_INC

#define OBSCTL0_DPIC_REG                                   0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Digital Observation Control 0
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX func_mon_cmn_digobs0sel : 4;
    //
    // Digital Observation Control 1
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX func_mon_cmn_digobs1sel : 4;
    //
    // Analog Observation Control
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX func_mon_cmn_anaobssel : 2;
    //
    // Reserved
    //
    // Bits[31:10], RO, default = 0x0
    //
    UINTX reserved : 22;
  } Bits;
  UINTX Data;
} OBSCTL0_DPIC_STRUCT;
#endif // ASM_INC

#define OBSCTL1_DPIC_REG                                   0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PLL Digital Observation Control 0
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX pll_cmn_digobs0sel : 4;
    //
    // PLL Digital Observation Control 1
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX pll_cmn_digobs1sel : 4;
    //
    // PLL Analog Observation Control 0
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX pll_cmn_anaobs0sel : 2;
    //
    // Reserved
    //
    // Bits[11:10], RO, default = 0x0
    //
    UINTX reserved3 : 2;
    //
    // PLL Analog Observation Control 1
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX pll_cmn_anaobs1sel : 2;
    //
    // Reserved
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved2 : 2;
    //
    // PLL Digital Observation Enable
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX pll_cmn_digobsen : 1;
    //
    // Reserved
    //
    // Bits[19:17], RO, default = 0x0
    //
    UINTX reserved1 : 3;
    //
    // PLL Analog Observation Enable
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX pll_cmn_anaobsen : 1;
    //
    // Reserved
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved0 : 3;
    //
    // PLL Error Flag
    //
    // Bits[24:24], RO/V, default = 0x0
    //
    UINTX pll_cmn_errorflag : 1;
    //
    // Reserved
    //
    // Bits[31:25], RO, default = 0x0
    //
    UINTX reserved : 7;
  } Bits;
  UINTX Data;
} OBSCTL1_DPIC_STRUCT;
#endif // ASM_INC

#define SPIDCLKCTL0_DPIC_REG                               0x00000024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Counter value
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX usynccounter : 6;
    //
    // Reserved
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved0 : 2;
    //
    // Early usync setting (with respect to global usync boundary)[br]2 : 2 clocks prior
    // to global sync boundary[br]3 : 3 clocks prior to global sync boundary[br]and so
    // on.
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX early_spidclkusync : 4;
    //
    // Delay from CLKREQDSRT to clock off
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX clkreqdasrt2clkoff_dly : 4;
    //
    // Delay from clock enable to clock ack
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX clken2clkack_dly : 4;
    //
    // Clock enable / disable on global sync point boundary.
    //
    // Bits[20:20], RW, default = 0x1
    //
    UINTX clken_on_gsp : 1;
    //
    // Reserved
    //
    // Bits[31:21], RO, default = 0x0
    //
    UINTX reserved : 11;
  } Bits;
  UINTX Data;
} SPIDCLKCTL0_DPIC_STRUCT;
#endif // ASM_INC

#define LDOCTL1_DPIC_REG                                   0x00000028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // LDO Clock Enable
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pll_cmn_ldoclken : 1;
    //
    // LDO FF Clock Enable - BL
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX ldoffdig_bl_ldoffclkenable : 1;
    //
    // LDO FF Clock Enable - CC
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX ldoffdig_cc_ldoffclkenable : 1;
    //
    // LDO IO Bufact - BL
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX ldoffdig_bl_ldoiobufact : 1;
    //
    // LDO IO Bufact - CC
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX ldoffdig_cc_ldoiobufact : 1;
    //
    // LDO Self Refresh Exit
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX ldomaindig_cmn_selfrefreshexit : 1;
    //
    // LDO Self Refresh Exit
    //
    // Bits[6:6], RW, default = 0x1
    //
    UINTX ldomaindig_cmn_dvfsfreqselect : 1;
    //
    // LDO offset comp
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX ldomaindig_cmn_startldooffsetcomp : 1;
    //
    // LDO Clock Ratio
    //
    // Bits[11:8], RW, default = 0x1
    //
    UINTX ldomaindig_cmn_clockratio : 4;
    //
    // LDO IOLB Test Enable
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX ldomaindig_cmn_iolbtest : 1;
    //
    // When set, vccfar has converged to the target voltage and is ready to use.
    //
    // Bits[13:13], RO/V, default = 0x0
    //
    UINTX ldomaindig_cmn_ldovccfarpwrgood : 1;
    //
    // Reseved
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved0 : 2;
    //
    // LPDDR 3 / 4 Mode Indiication
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX lpddr34mode : 1;
    //
    // Reseved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} LDOCTL1_DPIC_STRUCT;
#endif // ASM_INC

#define LDOONCTL_DPIC_REG                                  0x0000002C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // LDO On
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX ldomaindig_cmn_ldoon : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} LDOONCTL_DPIC_STRUCT;
#endif // ASM_INC

#define LDORSTCTL_DPIC_REG                                 0x00000030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // LDO Reset
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX ldomaindig_cmn_ldodigrstb : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} LDORSTCTL_DPIC_STRUCT;
#endif // ASM_INC

#define LVUGSUPPLYCTL0_DPIC_REG                            0x00000034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Isolation enable for LVUG to VNNUG crossing
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lvug_isolen : 1;
    //
    // Reseved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} LVUGSUPPLYCTL0_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_RSTB_DPIC_REG                              0x00000100
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PM module reset from config register
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pm_pmrst_b : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} DPIC_PM_RSTB_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_PGOVR_DPIC_REG                             0x00000104
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Isolation Override
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pm_isolen_ovr : 1;
    //
    // PWR VNNA On Staggered Override
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX pm_vnnapwronstaggered_ovr : 1;
    //
    // PWR VCCA On Staggered Override
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX pm_vccapwronstaggered_ovr : 1;
    //
    // Reserved
    //
    // Bits[31:3], RO, default = 0x0
    //
    UINTX reserved : 29;
  } Bits;
  UINTX Data;
} DPIC_PM_PGOVR_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CONFIG0_DPIC_REG                           0x00000108
#ifndef ASM_INC
typedef union {
  struct {
    //
    // SFR On Override
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pm_adpll_sfron_ovr : 1;
    //
    // ADPLL Enable Override
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX pm_adpllen_ovr : 1;
    //
    // SDLL Enable Override
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX pm_ckdll_sdllen_ovr : 1;
    //
    // IOBUFACT Override
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX pm_iobufact_ovr : 1;
    //
    // DIFFAMP Enable Overide
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX pm_diffampenable_ovr : 1;
    //
    // Isolation Enable Value
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX pm_isolen : 1;
    //
    // Clock Gate Override
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX pm_clkgateen_ovr : 1;
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX reserved0 : 1;
    //
    // PWR VNNA On Staggered value
    //
    // Bits[15:8], RW, default = 0xFF
    //
    UINTX pm_vnnapwronstaggered : 8;
    //
    // PWR VCCA On Staggered value
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX pm_vccapwronstaggered : 8;
    //
    // Power mux (ungated): Enable VNN
    //
    // Bits[24:24], RW, default = 0x1
    //
    UINTX pswitch_cmn_vnnpwron : 1;
    //
    // Power mux (ungated): Enable VCCA
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX pswitch_cmn_vccapwron : 1;
    //
    // Select VCCA mode of operation
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX vcca_sel : 1;
    //
    // ref2xrstb override
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX pm_ref2xrstb_ovr : 1;
    //
    // ref2x phase 0 override
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX pm_ref2xph0_ovr : 1;
    //
    // dll comp clak gate overiride
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX pm_dllcomp_clkgate_ovr : 1;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved : 2;
  } Bits;
  UINTX Data;
} DPIC_PM_CONFIG0_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CONFIG1_DPIC_REG                           0x0000010C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // COMP Enable Overide
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pm_comp_en_ovr : 1;
    //
    // PM adpll lock
    //
    // Bits[1:1], RO/V, default = 0x0
    //
    UINTX pm_adpll_lock : 1;
    //
    // 2x Reset Value
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX pm_pg2xrst_b : 1;
    //
    // 2x Reset Override
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX pm_pg2xrst_b_ovr : 1;
    //
    // Clock DLL Flop Reset Value
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX pm_clkdll_floprstb : 1;
    //
    // Clock DLL Flop Reset Override
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX pm_clkdll_floprstb_ovr : 1;
    //
    // Write Pointer Enable Override
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX pm_wrptren_ovr : 1;
    //
    // PI Enable Override
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX pm_pien_ovr : 1;
    //
    // DQRX FIFO Reset Override
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX pm_dqrxfiforstb_ovr : 1;
    //
    // VREFEN  Overide value
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX pm_vrefen_ovr : 1;
    //
    // VREF IO BUFACT Overide
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX pm_vrefiobufact_ovr : 1;
    //
    // ADPLL-Out Output Enable Override
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX pm_adpllouten_ovr : 1;
    //
    // SPID Clock Override
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX pm_spidclkenovrride : 1;
    //
    // LDO Power On Override
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX pm_ldopg_pwron_ovr : 1;
    //
    // 0 for 2 bit stagger ata time sel and 1 for 1 bit stagger at a time
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX pm_stagger_bits_sel : 1;
    //
    // Delay between power off and power on in hvm mode
    //
    // Bits[18:15], RW, default = 0x4
    //
    UINTX pm_hvm_delay : 4;
    //
    // HVM Request
    //
    // Bits[19:19], RW/1S/V, default = 0x0
    //
    UINTX pm_hvm_req : 1;
    //
    // Reserved
    //
    // Bits[31:20], RO, default = 0x0
    //
    UINTX reserved : 12;
  } Bits;
  UINTX Data;
} DPIC_PM_CONFIG1_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CLKREQ_DPIC_REG                            0x00000110
#ifndef ASM_INC
typedef union {
  struct {
    //
    // clk request
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX pmclk_clkreq : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} DPIC_PM_CLKREQ_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY0_DPIC_REG                            0x00000114
#ifndef ASM_INC
typedef union {
  struct {
    //
    // ref2x phase 0 disble delay
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX pm_ref2xph0_disable_dly : 4;
    //
    // dllcomp clock disable  gate delay
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX pm_dllcompcg_disable_dly : 4;
    //
    // ref2x phase 0 enable delay
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX pm_ref2xph0_enable_dly : 4;
    //
    // dllcomp clock enable  gate delay
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX pm_dllcompcg_enable_dly : 4;
    //
    // Delay to assert/de-assert IO BUFFER ACTIVATE
    //
    // Bits[23:16], RW, default = 0x1
    //
    UINTX pm_iobufact_dly : 8;
    //
    // Wait timer for the message interface to provide delay before ack/nack is aaserted
    // or deaaserted
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX pm_acktime : 4;
    //
    // Reserved
    //
    // Bits[31:28], RO, default = 0x0
    //
    UINTX reserved : 4;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY0_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY1_DPIC_REG                            0x00000118
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Comp enable delay in PM clocks
    //
    // Bits[15:0], RW, default = 0x190
    //
    UINTX pm_comp_enable_dly : 16;
    //
    // Delay to turn on the PI's associated with the DLLs in each module
    //
    // Bits[23:16], RW, default = 0x4
    //
    UINTX pm_sdll_enable_dly : 8;
    //
    // Delay to turn on the PI's associated with the wrptr in each module
    //
    // Bits[31:24], RW, default = 0x2
    //
    UINTX pm_wrptr_enable_dly : 8;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY1_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY2_DPIC_REG                            0x0000011C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay to turn off the PI's associated with the DLLs in each module
    //
    // Bits[7:0], RW, default = 0x2
    //
    UINTX pm_sdll_disable_dly : 8;
    //
    // Delay to turn off the PI's associated with the wrptr in each module
    //
    // Bits[15:8], RW, default = 0x2
    //
    UINTX pm_wrptr_disable_dly : 8;
    //
    // Delay after which the pmseq state machine moves from adpll_sfron state to adpll_on_hs
    // state
    //
    // Bits[31:16], RW, default = 0xC8
    //
    UINTX pm_adpll_sfron_dly : 16;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY2_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY3_DPIC_REG                            0x00000120
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay after which the pmseq state machine moves from dis_comp state to adpll_off_hs
    // state
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX pm_adpll_sfroff_dly : 16;
    //
    // Comp disable delay in PM clocks
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX pm_comp_disable_dly : 16;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY3_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY4_DPIC_REG                            0x00000124
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay for the clock gate or clock ungate
    //
    // Bits[3:0], RW, default = 0x4
    //
    UINTX pm_clkgate_wait_timer : 4;
    //
    // Reserved
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX reserved0 : 4;
    //
    // Delay for the isolate and un-isolate
    //
    // Bits[11:8], RW, default = 0x2
    //
    UINTX pm_isol2pgdly : 4;
    //
    // Delay between each power gating stagger FSM state transition
    //
    // Bits[19:12], RW, default = 0xA
    //
    UINTX pm_pg_enable_stgdly : 8;
    //
    // Delay between each power un-gating stagger FSM state transition
    //
    // Bits[27:20], RW, default = 0xA
    //
    UINTX pm_pg_disable_stgdly : 8;
    //
    // Reserved
    //
    // Bits[31:28], RO, default = 0x0
    //
    UINTX reserved : 4;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY4_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY5_DPIC_REG                            0x00000128
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay to assert pgphyrst_d
    //
    // Bits[7:0], RW, default = 0x4
    //
    UINTX pm_pgphyrstb_disable_dly : 8;
    //
    // Delay to deassert pgphyrst_b
    //
    // Bits[15:8], RW, default = 0x4
    //
    UINTX pm_pgphyrstb_enable_dly : 8;
    //
    // Delay to assert pg2xrst_b
    //
    // Bits[23:16], RW, default = 0x4
    //
    UINTX pm_pg2xrstb_disable_dly : 8;
    //
    // Delay to deassert pg2xrstb
    //
    // Bits[31:24], RW, default = 0x4
    //
    UINTX pm_pg2xrstb_enable_dly : 8;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY5_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY6_DPIC_REG                            0x0000012C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay after vrefiobufact set to 0
    //
    // Bits[11:0], RW, default = 0x4
    //
    UINTX pm_vrefiobufact_disable_dly : 12;
    //
    // Delay after vrefiobufact set to 1
    //
    // Bits[23:12], RW, default = 0x4
    //
    UINTX pm_vrefiobufact_enable_dly : 12;
    //
    // Reserved
    //
    // Bits[29:24], RO, default = 0x0
    //
    UINTX reserved0 : 6;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved : 2;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY6_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY7_DPIC_REG                            0x00000130
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay after vrefen set to 0
    //
    // Bits[11:0], RW, default = 0x4
    //
    UINTX pm_vrefen_disable_dly : 12;
    //
    // Delay after vrefen set to 1
    //
    // Bits[23:12], RW, default = 0x4
    //
    UINTX pm_vrefen_enable_dly : 12;
    //
    // Reserved
    //
    // Bits[29:24], RO, default = 0x0
    //
    UINTX reserved0 : 6;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved : 2;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY7_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY8_DPIC_REG                            0x00000134
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enable PI delay
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX pm_pien_dly : 4;
    //
    // Enable LDO vref delay
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX pm_disable_ldovref_dly : 4;
    //
    // Enable LDO isol dleay
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX pm_disable_isol_dly : 3;
    //
    // Enable LDO Power gate delay
    //
    // Bits[18:11], RW, default = 0x0
    //
    UINTX pm_disable_ldopg_dly : 8;
    //
    // disable ref2xrstb
    //
    // Bits[21:19], RW, default = 0x2
    //
    UINTX pm_ref2xrstb_disable_dly : 3;
    //
    // enable ref2xrstb
    //
    // Bits[24:22], RW, default = 0x2
    //
    UINTX pm_ref2xrstb_enable_dly : 3;
    //
    // Reserved
    //
    // Bits[31:25], RO, default = 0x0
    //
    UINTX reserved500 : 7;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY8_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY9_DPIC_REG                            0x00000138
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Disable LDO vref delay
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX pm_enable_ldovref_dly : 16;
    //
    // Disable LDO isol dleay
    //
    // Bits[18:16], RW, default = 0x0
    //
    UINTX pm_enable_isol_dly : 3;
    //
    // Disable LDO Power gate delay
    //
    // Bits[22:19], RW, default = 0x0
    //
    UINTX pm_enable_ldopg_dly : 4;
    //
    // LDO Self Refresh Exit Override
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX pm_ldoselfrefreshexit : 1;
    //
    // Reserved
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved501 : 8;
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY9_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CLKGATE_DPIC_REG                           0x0000013C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Clock Gate Enable
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX pm_clkgateen : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} DPIC_PM_CLKGATE_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PMSWMSG_DPIC_REG                              0x00000140
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Config based Power Management Message
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX pm_sw_msg : 5;
    //
    // Config based Power Management Message Request
    //
    // Bits[5:5], RW/1S/V, default = 0x0
    //
    UINTX pm_sw_req : 1;
    //
    // PM software acknowledge
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX pm_sw_ack : 1;
    //
    // PM clock ack
    //
    // Bits[7:7], RO/V, default = 0x0
    //
    UINTX pmclk_ack : 1;
    //
    // Reserved
    //
    // Bits[10:8], RO, default = 0x0
    //
    UINTX reserved0 : 3;
    //
    // State of Power Management logic. [4]: busy. [3:0] : PM state
    //
    // Bits[15:11], RO/V, default = 0x0
    //
    UINTX pm_cfg_status : 5;
    //
    // Reserved
    //
    // Bits[26:16], RO, default = 0x0
    //
    UINTX reserved : 11;
    //
    // HVM PM Message
    //
    // Bits[31:27], RW, default = 0x4
    //
    UINTX hvm_pmmsg : 5;
  } Bits;
  UINTX Data;
} DPIC_PMSWMSG_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_OVR_DPIC_REG                           0x00000300
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[9:0], RO, default = 0x0
    //
    UINTX reserved1 : 10;
    //
    // Reserved bits
    //
    // Bits[17:10], RO, default = 0x0
    //
    UINTX reserved0 : 8;
    //
    // digital observation enable (grcomp)
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX gcomp_cmn_obsen : 1;
    //
    // Select for digital observation mux 1 (grcomp)
    //
    // Bits[20:19], RW, default = 0x0
    //
    UINTX gcomp_cmn_digobs1_sel : 2;
    //
    // Select for digital observation mux 0 (grcomp)
    //
    // Bits[22:21], RW, default = 0x0
    //
    UINTX gcomp_cmn_digobs0_sel : 2;
    //
    // override enable for override for pull up live rcomp code going to AFE
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX comp_rcomp_pu_live_override_en : 1;
    //
    // override for pull up live rcomp code going to AFE
    //
    // Bits[29:24], RW, default = 0x0
    //
    UINTX comp_rcomp_pu_live_override : 6;
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved : 2;
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_OVR_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_CTL_DPIC_REG                           0x00000304
#ifndef ASM_INC
typedef union {
  struct {
    //
    // static leg signal for the AFE
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX rcomp_pu_staticlive : 1;
    //
    // this tells a timer to start the periodic comp cycle when this number of cycles
    // are completed. Usually this is programmed to 'h7d00 for a 4us delay between two
    // periodic comp cycles.
    //
    // Bits[20:1], RW, default = 0x7D00
    //
    UINTX rcomp_wakeup_period : 20;
    //
    // Not used in design.
    //
    // Bits[26:21], RW, default = 0x0
    //
    UINTX rcomp_general_timer : 6;
    //
    // Reserved bits
    //
    // Bits[31:27], RO, default = 0x0
    //
    UINTX reserved : 5;
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_CTL_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_DEBUG_DPIC_REG                         0x00000500
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bonus configs
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX lrcomp_cmn_ibonus : 4;
    //
    // digital observation enable  (lrcomp)
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX lrcomp_cmn_obsen : 1;
    //
    // Select for digital observation mux 1 (lrcomp)
    //
    // Bits[6:5], RW, default = 0x0
    //
    UINTX lrcomp_cmn_digobs1sel : 2;
    //
    // Select for digital observation mux 0 (lrcomp)
    //
    // Bits[8:7], RW, default = 0x0
    //
    UINTX lrcomp_cmn_digobs0sel : 2;
    //
    // Bonus configs
    //
    // Bits[24:9], RW, default = 0x0
    //
    UINTX lrcomp_spare : 16;
    //
    // Reserved bits
    //
    // Bits[31:25], RO, default = 0x0
    //
    UINTX reserved : 7;
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_DEBUG_DPIC_STRUCT;
#endif // ASM_INC

#define LOWER_DFXVISAULM0_DPIC_REG                         0x00000700
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Lower Level ULM0 Lane (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxlowervisaulm0_datasel : 8;
    //
    // VISA Lower Level ULM0 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxlowervisaulm0_clksel : 8;
    //
    // VISA Lower Level Bypass ULM0
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxlowervisaulm0_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} LOWER_DFXVISAULM0_DPIC_STRUCT;
#endif // ASM_INC

#define LOWER_DFXVISAULM1_DPIC_REG                         0x00000704
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Lower Level ULM1 Lane (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxlowervisaulm1_datasel : 8;
    //
    // VISA Lower Level ULM1 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxlowervisaulm1_clksel : 8;
    //
    // VISA Lower Level Bypass ULM1
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxlowervisaulm1_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} LOWER_DFXVISAULM1_DPIC_STRUCT;
#endif // ASM_INC

#define LOWER_DFXVISAPATTGEN_DPIC_REG                      0x00000708
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Lower Level ULM Pattern Generation
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX dfxlowervisapattgen_lsb : 4;
    //
    // VISA Lower Level ULM Pattern Generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX dfxlowervisapattgen_msb : 3;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved : 25;
  } Bits;
  UINTX Data;
} LOWER_DFXVISAPATTGEN_DPIC_STRUCT;
#endif // ASM_INC

#define TOP_DFXVISAULM0_DPIC_REG                           0x0000070C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Top Level ULM0 Lane (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxtopvisaulm0_datasel : 8;
    //
    // VISA Top Level ULM0 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxtopvisaulm0_clksel : 8;
    //
    // VISA Top Level Bypass ULM0
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxtopvisaulm0_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} TOP_DFXVISAULM0_DPIC_STRUCT;
#endif // ASM_INC

#define TOP_DFXVISAULM1_DPIC_REG                           0x00000710
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Top Level ULM1 Lane (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxtopvisaulm1_datasel : 8;
    //
    // VISA Top Level ULM1 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxtopvisaulm1_clksel : 8;
    //
    // VISA Top Level Bypass ULM1
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxtopvisaulm1_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} TOP_DFXVISAULM1_DPIC_STRUCT;
#endif // ASM_INC

#define TOP_DFXVISAPATTGEN_DPIC_REG                        0x00000714
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Top Level ULM Pattern Generation
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX dfxtopvisapattgen_lsb : 4;
    //
    // VISA Top Level ULM Pattern Generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX dfxtopvisapattgen_msb : 3;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved : 25;
  } Bits;
  UINTX Data;
} TOP_DFXVISAPATTGEN_DPIC_STRUCT;
#endif // ASM_INC


#endif // _DPIC_H_
