/** @file
  File name:    DUNIT.h
  Input File:   BXTM_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in DUNIT.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

  @copyright
  Copyright (c) 2005-2016 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by the
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is uniquely
  identified as 'Intel Reference Module' and is licensed for Intel
  CPUs and chipsets under the terms of your license agreement with
  Intel or your vendor. This file may be modified by the user, subject
  to additional terms of the license agreement.

  @par Specification
**/
#ifndef _DUNIT_H_
#define _DUNIT_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define D_CR_DRP0_DUNIT_REG                                0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enable Rank 0: Must be set to 1 to enable use of this rank.  Note: Setting this
    // bit to 0 is not a functional mode.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX rken0 : 1;
    //
    // Enable Rank 1:  Must be set to 1 to enable use of this rank.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX rken1 : 1;
    //
    // 0 - PMI Dual Data Mode is disabled in Dunit, full cacheline read and writes go
    // through a single Dunit. D-unit needs to issue 2 back to back CASes for DDR3/LPDDR3
    // [br]1 - PMI Dual Data Mode is enabled, only half cacheline read/writes go through
    // a single Dunit, so Dunit only issues a single CAS for DDR3/LPDDR3 [br]Note: This
    // field is reserved for BXT0/1
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX ddmen : 1;
    //
    // Reserved
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX rsvd3 : 1;
    //
    // Data width of the DRAM devices populated on Ranks 0 and 1.  [br]00 - x8,  [br]01
    // - x16,  [br]10 - x32,  [br]11 - x64.
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX dwid : 2;
    //
    // Density of the DRAM devices populated on Ranks 0 and 1. [br]000 - 4Gb,  [br]01
    // - 6Gb,  [br]010 - 8Gb,  [br]011 - 12Gb,  [br]100 - 16Gb,  [br]101-111 - Reserved
    // [br]Note: For LPDDR4 this value is the die density.
    //
    // Bits[8:6], RW, default = 0x0
    //
    UINTX dden : 3;
    //
    // Reserved
    //
    // Bits[13:9], RO, default = 0x0
    //
    UINTX rsvd13_9 : 5;
    //
    // See Address Mapping section for full description.  [br]0 - Rank Select Interleaving
    // disabled, [br]1 - Rank Select Interleaving enabled.
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX rsien : 1;
    //
    // See Address Mapping section for full description.  [br]0 - Bank Address Hashing
    // disabled,  [br]1 - Bank Address Hashing enabled.
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX bahen : 1;
    //
    // Reserved
    //
    // Bits[18:16], RO, default = 0x0
    //
    UINTX rsvd20_16 : 3;
    //
    // CA Swizzle Type
    // 00 - uniDIMM/SODIMM
    // 01 - BGA
    // 10 - BGA mirrored (LPDDR3 only)
    // 11 - UDIMM (DDR3L only)
    //
    // Bits[20:19], RO, default = 0x0
    //
    UINTX caswizzle : 2;
    //
    // 0 -  ECC is disabled,  1  - ECC is enabled. [br]This bit determines if the Dunit
    // treats the PMI BE_ECC bits as ECC bits or Byte Enables. The Dunit should not allow
    // this bit to be set if ECC is disabled by fuse. This should only be used in configurations
    // that support ECC.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX eccen : 1;
    //
    // 000 -  DDR3,  [br]001 - LPDDR3,  [br]010 -  LPDDR4,  [br]011 -  WIO2,  [br]100
    // -  DDR4,  [br]101-111 - Reserved [br]Note: The D-unit should only use this field
    // if allowed by fuse
    //
    // Bits[24:22], RW, default = 0x0
    //
    UINTX dramtype : 3;
    //
    // 000 - Fixed BL8,  [br]001 - Onthefly BL8,  [br]010 - Fixed BL16,  [br]011 - Onthefly
    // BL16,  [br]100 - Fixed BL32,  [br]101 - Onthefly BL32,  [br]110-111 - Reserved
    //
    // Bits[27:25], RW, default = 0x0
    //
    UINTX blmode : 3;
    //
    // Specifies the address mapping to be used:[br] 00 - 1KB (A), 01 - 2KB (B), 10 -
    // 4KB (C), 11 - Reserved
    //
    // Bits[29:28], RW, default = 0x1
    //
    UINTX addrdec : 2;
    //
    // Number of DRAM devices per rank:
    // Specifies how many DRAM devices are ganged together to form a single rank
    // 00 - 1 DRAM device in each rank
    // 01 - 2 DRAM devices in each rank
    // 10 - 4 DRAM devices in each rank
    // 11 - 8 DRAM devices in each rank
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX dramdevice_pr : 2;
  } Bits;
  UINTX Data;
} D_CR_DRP0_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTR0A_DUNIT_REG                               0x00000008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the delay between a DRAM Precharge command and a DRAM Activate command
    // to the same bank. (in DRAM Clocks) [br]Note: Derating adds 1.875ns to this timing.
    //
    // Bits[5:0], RW, default = 0xB
    //
    UINTX trppb : 6;
    //
    // Reserved
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX rsvd7_6 : 2;
    //
    // Specifies the delay between a DRAM Activate command and a DRAM Read or Write command
    // to the same bank. (in DRAM Clocks) [br]Note: Derating adds 1.875ns to this timing
    //
    // Bits[13:8], RW, default = 0xB
    //
    UINTX trcd : 6;
    //
    // Delay between Self Refresh Exit SRX to any DRAM Command not requiring DLL Lock
    // (DDR3) [br]tXSR - Delay between Self Refresh Exit SRX to any DRAM Command (LPDDR/WIO2).
    // [br](in DRAM Clocks)
    //
    // Bits[22:14], RW, default = 0x70
    //
    UINTX txsr : 9;
    //
    // D-unit waits max(tXSR+tZQCL/tZQCS, tXSDLL) before allowing traffic to DRAM.  (in
    // 256 x DRAM Clocks) [br]LPDDR3/LPDDR4/WIO2: tXSDLL = 0, [br]DDR3L: tXSDLL = tDLLK
    // = 512 Clocks = 2 x 256 DRAM Clocks [br]Note: tZQCL/TZQCS = 0 if no ZQ is performed
    // on SR exit. [br]Reserved in BXT0/1
    //
    // Bits[24:23], RW, default = 0x0
    //
    UINTX txsdll : 2;
    //
    // Number of valid clock before CKE high (in DRAM Clocks) [br]LPDDR4: the value in
    // this register covers both tCKCKEH and tCSCKEH [br]DDR3/LPDDR3/WIO2: the value
    // covers tCKSRX which is defined as the number of valid DRAM clocks that have to
    // toggle before the issuing of the Self Refresh Exit SRX. This value is also used
    // if the clock frequency is changed or the clock is stopped or tristated during
    // Power Down i.e. the number valid DRAM clocks that have to toggle before the issuing
    // of the Power Down Exit PDX command. [br]tCKCKEH can be used to compensate for
    // clock stabilization delays in the motherboard
    //
    // Bits[31:25], RW, default = 0x10
    //
    UINTX tckckeh : 7;
  } Bits;
  UINTX Data;
} D_CR_DTR0A_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTR1A_DUNIT_REG                               0x0000000C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the delay between the DRAM  ZQ Calibration Latch command and any DRAM
    // command. (in DRAM Clocks) [br]The LPDDR4 JEDEC standard defines tZQLAT = 30ns
    // [br]Not used in DDR3/LPDDR3/WIO2
    //
    // Bits[5:0], RW, default = 0x18
    //
    UINTX tzqlat : 6;
    //
    // ZQCS to any DRAM Command Delay:  Specifies the delay between the DRAM ZQ Calibration
    // Short (ZQCS) command and any DRAM command. (in DRAM Clocks) [br]The DDR3 JEDEC
    // standard defines tZQCS = Max(64nCK, 80ns) [br]The LPDDR3 JEDEC standards define
    // tZQCS = Max(6nCK, 90ns) [br]LPDDR4 does not support ZQCS command
    //
    // Bits[13:6], RW, default = 0x48
    //
    UINTX tzqcs : 8;
    //
    // LPDDR3: tZQCL - Specifies the delay between the DRAM ZQ Calibration Long (ZQCL)
    // command and any DRAM command during normal operation. [br]LPDDR4: tZQCAL - ZQ
    // Calibration time. [br](in DRAM Clocks) [br]Note: This field defines the ZQ Calibration
    // Long delay during normal operation. It is not the same as tZQinit which uses the
    // same ZQCL command but the delay is longer. tZQinit applies only during poweron
    // initialization of the DRAM devices and tZQoper applies during normal operation.
    // BIOS executes the DRAM initialization sequence so it has to ensure tZQinit is
    // met and not the Dunit
    //
    // Bits[25:14], RW, default = 0x120
    //
    UINTX tzqcl : 12;
    //
    // Reserved
    //
    // Bits[26:26], RO, default = 0x0
    //
    UINTX rsvd26 : 1;
    //
    // Specifies the delay from the DRAM Power Down Exit PDX command to any valid command.
    // (in DRAM Clocks)
    //
    // Bits[31:27], RW, default = 0x6
    //
    UINTX txp : 5;
  } Bits;
  UINTX Data;
} D_CR_DTR1A_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTR2A_DUNIT_REG                               0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the average time between refresh commands. JEDEC Base Refresh Interval
    // time. (in DRAM Clocks) [br]Note: Dunit will ignore the 2 LSBs of this field
    //
    // Bits[15:0], RW, default = 0xC30
    //
    UINTX nrefi : 16;
    //
    // Reserved
    //
    // Bits[16:16], RO, default = 0x0
    //
    UINTX rsvd16 : 1;
    //
    // Specifies the minimum time from CKEL to CKEH. (in DRAM Clocks)
    //
    // Bits[20:17], RW, default = 0x4
    //
    UINTX tcke : 4;
    //
    // Reserved
    //
    // Bits[22:21], RO, default = 0x0
    //
    UINTX rsvd22_21 : 2;
    //
    // Specifies the delay between the REFab command to the next valid command. (in DRAM
    // clocks)
    //
    // Bits[31:23], RW, default = 0x118
    //
    UINTX nrfcab : 9;
  } Bits;
  UINTX Data;
} D_CR_DTR2A_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTR3A_DUNIT_REG                               0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the minimum delay between DRAM Write command to Masked Write command
    // to same bank. (in DRAM Clocks) [br]LPDDR4 Equation: tWMWSB = tCCDMW (BL16) or
    // tCCDMW + 8 (BL32), [br]WIO2 Equation: tWMWSB = tCCDMW (BL4) or tCCDMW + 2 (BL8).
    // [br]Note: Masked Write operation in LPDDR4 is always BL16 and in WIO2 is always
    // BL4. [br]D-unit applies this timing for same rank as well as same bank, refer
    // to Dunit HAS for more details
    //
    // Bits[5:0], RW, default = 0x28
    //
    UINTX twmwsb : 6;
    //
    // The delay in DRAM clocks between the internal write command and the availability
    // of the first word of DRAM input data. (in DRAM Clocks)
    //
    // Bits[10:6], RW, default = 0x8
    //
    UINTX tcwl : 5;
    //
    // Specifies the number of DRAM clocks a command is held valid on the DRAM Address
    // and Control buses. 1N is the DDR3 basic requirement.  2N is the extended mode
    // for board signal integrity. [br]0h - Reserved, 1h - 1 DRAM Clock (1N), 2h - 2
    // DRAM Clocks (2N), 3h - Reserved [br]Note: tCMD must be set to 1N for LPDDR3/LPDDR4/WIO2.
    // [br]Note: This field is reserved in BXT0/1
    //
    // Bits[12:11], RW, default = 0x1
    //
    UINTX tcmd : 2;
    //
    // Specifies the minimum delay between the DRAM Write command and the Precharge command
    // to the same bank. (in DRAM Clocks) [br]LPDDR3/LPDDR4/WIO2 Equation: tWTP = BL/2
    // + CWL + tWR + 1
    //
    // Bits[19:13], RW, default = 0x17
    //
    UINTX twtp : 7;
    //
    // Specifies the number of clocks to be added to turnaround times (for Stretch Mode).
    // It increases delay between Read to Read or Read to Write commands. (in 4 x DRAM
    // Clocks)
    //
    // Bits[26:20], RW, default = 0x0
    //
    UINTX tccd_inc : 7;
    //
    // Specifies the minimum delay between the DRAM Read and Precharge commands to the
    // same bank. (in DRAM Clocks) [br]LPDDR3 Equation: = BL/2 + tRTP - 4 [br]LPDDR4
    // Equation: = BL/2 + Max (8, tRTP) - 8 [br]WIO2 Equation: = BL/2 + tRTP - 2
    //
    // Bits[31:27], RW, default = 0x6
    //
    UINTX trtp : 5;
  } Bits;
  UINTX Data;
} D_CR_DTR3A_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTR4A_DUNIT_REG                               0x00000018
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the delay from the start of a Read data burst of one rank to the Start
    // of a Read data burst of a different rank. (in DRAM Clocks) [br]LPDDR3/4 Equation:
    // tRRDR = (RL + tDQSCKmax + BL/2) + tRPRE - (RL + tDQSCKmin)
    //
    // Bits[5:0], RW, default = 0x9
    //
    UINTX trrdr : 6;
    //
    // Specifies the delay from the start of a Write data burst of one rank to the start
    // of a Write data burst of a different rank. (in DRAM Clocks) [br]LPDDR3 Equation:
    // tWWDR = (WL + BL/2 + tDQSSmax + tWPRE) - (WL + tDQSSmin) [br]LPDDR4 Equation:
    // tWWDR = BL/2 + 4 - tDQSSmin [br]Note: For LPDDR3/4 using ODT this latency may
    // need to be increased by tODToffadj
    //
    // Bits[11:6], RW, default = 0x5
    //
    UINTX twwdr : 6;
    //
    // Specifies the delay from the start of a Read data burst of one rank to the Start
    // of a Write data burst of a different rank. (in DRAM Clocks) [br]LPDDR3 Equation:
    // tRWDR = RL + tDQSCKmax + BL/2 - (WL + tDQSSmin - tWPRE) [br]LPDDR4 Equation: tRWDR
    // = RL + tDQSCKmax + BL/2 - (WL - 2)[br]Note: For LPDDR3/4 using ODT this latency
    // may need to be adjusted by tODTon.
    //
    // Bits[17:12], RW, default = 0x9
    //
    UINTX trwdr : 6;
    //
    // Specifies the delay from the start of a Write data burst of one rank to the start
    // of a Read data burst of a different rank. (in DRAM Clocks) [br]LPDDR3 Equation:
    // tWRDR = WL + tDQSSmax + BL/2 - (RL + tDQSCKmin - tRPRE) [br]LPDDR4 Equation: tWRDR
    // = WL - RL + BL/2 + 4 - tDQSCKmin [br]Note: For LPDDR3/4 using ODT this latency
    // may need to be increased by tODToffadj.
    //
    // Bits[23:18], RW, default = 0x8
    //
    UINTX twrdr : 6;
    //
    // A rolling timeframe in which a maximum of four Activate commands can be issued
    // to the same rank. This is to limit the peak current draw from the DRAM devices.
    // (in DRAM Clocks)
    //
    // Bits[31:24], RW, default = 0x30
    //
    UINTX tfaw : 8;
  } Bits;
  UINTX Data;
} D_CR_DTR4A_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTR5A_DUNIT_REG                               0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the delay from a DRAM Read to a Write command of the same rank. [br]Equation:
    // tRWSR = RL + tDQSCKmax + BL/2 - WL + tWPRE [br]Note:For LPDDR3/4 using ODT this
    // latency may need to be increased by tODToffadj
    //
    // Bits[5:0], RW, default = 0x2
    //
    UINTX trwsr : 6;
    //
    // Specifies the delay from a DRAM Read to Write command of the same rank. [br]LPDDR3/LPDDR4/WIO2
    // Equation: tWRSR  = WL + 1 + BL/2 + tWTR
    //
    // Bits[12:6], RW, default = 0x3
    //
    UINTX twrsr : 7;
    //
    // Specifies the delay from a DRAM Read to another Read command of the same rank.
    // [br]LPDDR3/LPDDR4/WIO2 Equation: tRRSR = tCCD
    //
    // Bits[17:13], RW, default = 0x10
    //
    UINTX trrsr : 5;
    //
    // Specifies the delay from a DRAM Write to another Write command of the same rank.
    // [br]LPDDR3/LPDDR4/WIO2 Equation: tRRSR = tCCD
    //
    // Bits[22:18], RW, default = 0x10
    //
    UINTX twwsr : 5;
    //
    // Specifies the additional delay that is added to DRAM timing when indicated by
    // MR4 status. (in DRAM clocks) [br]LPDDR3/LPDDR4/WIO2: Value is 1.875ns [br]Note:
    // The value in this register is only added to these timing parameters: tRCD, tRAS,
    // tRP and tRRD
    //
    // Bits[25:23], RW, default = 0x0
    //
    UINTX tderate_inc : 3;
    //
    // Reserved
    //
    // Bits[26:26], RO, default = 0x0
    //
    UINTX rsvd26 : 1;
    //
    // Specifies the minimum delay between two DRAM Activate commands to the same rank
    // but different banks (tRC is the minimum delay between activations of the same
    // bank). (in DRAM Clocks)  [br]Note: Derating adds 1.875ns to this timing.
    //
    // Bits[31:27], RW, default = 0x6
    //
    UINTX trrd : 5;
  } Bits;
  UINTX Data;
} D_CR_DTR5A_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTR6A_DUNIT_REG                               0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the quiet time before issuing MRR/MRW command. (in DRAM clocks). [br]
    // LPDDR3 Equation: tPREMRBLK = Max(RL + tDQSCK + BL/2 + tRPST, tXP + tMRRI), LPDDR4/WIO2
    // Equation: tPREMRBLK = tXP + tMRRI
    //
    // Bits[6:0], RW, default = 0x16
    //
    UINTX tpremrblk : 7;
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX rsvd3_2 : 1;
    //
    // Specifies the quiet time after issuing MRR/MRW command (in DRAM Clocks). [br]LPDDR3/4
    // Equation: tPSTMRBLK = RL + tDQSCK + BL/2 of MRR/MRW + 1 - WL - DTR5A.TRWSR, WIO2
    // Equation: tPSTMRBLK = RL + tDQSCK + BL/2 of MRR/MRW + 1
    //
    // Bits[14:8], RW, default = 0x14
    //
    UINTX tpstmrblk : 7;
    //
    // When a critical read request is pending in RPQ and a maintenance operation (MRR,
    // ZQCal, Ref, etc.) needs to be performed, Dunit waits this amount of time before
    // performing the maintenance operation to allow for some high priority requests
    // to be issued (in 4x DRAM clocks)
    //
    // Bits[18:15], RW, default = 0x0
    //
    UINTX mntdly : 4;
    //
    // Specifies the amount of time that DRAM clocks need to toggle after CKE goes low.
    // (in DRAM Clocks) [br]For WIO2/LPDDR3 this covers tCPDED [br]For LPDDR4 this covers
    // both tCKCKEL and tCKELCMD [br]For DDR3 this is tCKSRE [br]Note: D-unit hardware
    // enforces minimum of two SPID clocks after CKEL, any value in this register is
    // the additional time.
    //
    // Bits[22:19], RW, default = 0x2
    //
    UINTX tckckel : 4;
    //
    // Reserved
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX rsvd3_2_1 : 1;
    //
    // Rank idle period that defines an opportunity for refresh. (in DRAM clocks)
    //
    // Bits[31:24], RW, default = 0x20
    //
    UINTX orefdly : 8;
  } Bits;
  UINTX Data;
} D_CR_DTR6A_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTR7A_DUNIT_REG                               0x00000024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the minimum delay between the DRAM Activate and Precharge commands to
    // the same bank. (in DRAM Clocks) [br]Note: Derating adds 1.875ns to this timing
    //
    // Bits[6:0], RW, default = 0x6
    //
    UINTX tras : 7;
    //
    // Reserved
    //
    // Bits[8:7], RO, default = 0x0
    //
    UINTX rsvd7 : 2;
    //
    // Specifies the minimum time between a read command to PowerDown command. (in DRAM
    // Clocks) [br]Must be at least equal to tCL + tDQSCKmax + tCCD + tRPST
    //
    // Bits[15:9], RW, default = 0x6
    //
    UINTX trdpden : 7;
    //
    // Specifies the minimum time between a write command to PowerDown command. (in DRAM
    // Clocks) [br]Must be at least equal to tWR + tCCD + tWL + 2.
    //
    // Bits[22:16], RW, default = 0x6
    //
    UINTX twrpden : 7;
    //
    // Mode Register Write to any command delay:
    // Specifies the quiet time after issuing MRW command (in 8 x DRAM clocks)
    // Note: This time covers for tMRD and tMRW
    //
    // Bits[25:23], RW, default = 0x2
    //
    UINTX tpstmrwblk : 3;
    //
    // Specifies the delay between a DRAM Precharge All Bank command and a DRAM Activate
    // command. (in DRAM Clocks) [br]Note: Derating adds 1.875ns to this timing  [br]For
    // LPDDR, tRPpb = tRP, tRPab = tRP + 3ns.  [br]For DDR3 and WIO2 8ch tRPpb = tRPab
    // = tRP.
    //
    // Bits[31:26], RW, default = 0x3
    //
    UINTX trpab : 6;
  } Bits;
  UINTX Data;
} D_CR_DTR7A_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTR8A_DUNIT_REG                               0x00000028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is a non-JEDEC timing parameter used to delay powerdown entry. (in DRAM Clocks)
    // [br]Note: CKE goes low only on Phase 0 of SPID
    //
    // Bits[7:0], RW, default = 0x18
    //
    UINTX pwddly : 8;
    //
    // Reserved
    //
    // Bits[9:8], RO, default = 0x0
    //
    UINTX rsvd11_8 : 2;
    //
    // Specifies the time between CK stop/tristate to the Low Power Mode entry. (in DRAM
    // Clocks). This timing parameter is used to delay Low Power Mode entry. [br]Note:
    // Must be at least equal to t_idle_length parameter published in the DDRIO PHY HAS
    // and less than 0x7C
    //
    // Bits[16:10], RW, default = 0xA
    //
    UINTX cketolpmddly : 7;
    //
    // Specifies the minimum time between the LP Mode exit to the CK stop/tristate deassertion
    // and powerdown exit. (in DRAM Clocks) [br]Note: Must be equal t_idle_latency published
    // in the DDRIO PHY HAS and less than 0xFC
    //
    // Bits[24:17], RW, default = 0xA
    //
    UINTX lpmdtockedly : 8;
    //
    // Reserved
    //
    // Bits[25:25], RO, default = 0x0
    //
    UINTX rsvd25_23 : 1;
    //
    // Specifies the minimum time that DRAM should remain in SR. (in DRAM Clocks)
    //
    // Bits[31:26], RW, default = 0x3
    //
    UINTX tckesr : 6;
  } Bits;
  UINTX Data;
} D_CR_DTR8A_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DOCRA_DUNIT_REG                               0x0000002C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies number of clocks after Write command that Dunit asserts ODT signal (in
    // DRAM clocks) [br]LPDDR3 Equation: WRODTSTART = WL - RU(tODTon(max)/tCK) [br]DDR3
    // Equation: WRODTSTART = 0
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX wrodtstart : 4;
    //
    // DDR3 spec requires ODT to be asserted high when the DRAM Write command is issued.
    // EARLYWRODT can be set to enable asserting ODT one DRAM clock earlier than the
    // Write Command (WR) for 2N.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX earlywrodt : 1;
    //
    // Specifies number of clocks after ODT assertion that Dunit deasserts ODT signal
    // (in DRAM clocks) [br]LPDDR3 Equation: WRODTSTOP = RU(tODTon(max)/tCK) + RU((tDQSSmax+tWPST)/tCK)
    // + BL/2 - RD(tODToffmin/tCK) [br]DDR3 Equation: WRODTSTOP >= 6
    //
    // Bits[9:5], RW, default = 0x0
    //
    UINTX wrodtstop : 5;
    //
    // Specifies Read ODT assertion delay after Read Command (in DRAM clocks) [br]DDR3
    // Equation: DDR3 Equation: RDODTSTART = CL - CWL + DTR1x.tCMD - DOCR.WRODTSTRT
    //
    // Bits[12:10], RW, default = 0x0
    //
    UINTX rdodtstart : 3;
    //
    // Reserved
    //
    // Bits[13:13], RO, default = 0x0
    //
    UINTX rsvd13_13 : 1;
    //
    // Specifies Read ODT assertion to ODT de-assert delay (in DRAM clocks) [br]DDR3
    // Equation: RDODTSTOP = 6 + DOCRx.WRODTSTOP - DOCRx.WRODTSTRT
    //
    // Bits[18:14], RW, default = 0x0
    //
    UINTX rdodtstop : 5;
    //
    // Reserved
    //
    // Bits[23:19], RO, default = 0x0
    //
    UINTX rsvd23_19 : 5;
    //
    // Specifies the behavior of ODT signals when a Write command is issued to Rank 0
    // [br]00 - Write ODT is disabled [br]01 - Assert ODT to Rank 0 (targeted Rank) [br]10
    // - Assert ODT to Rank 1 (non-targeted Rank) [br]11 - Assert ODT to Rank 0 and Rank
    // 1 [br]Note: 10 and 11 are reserved values for LPDDR3
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX r0wrodtctl : 2;
    //
    // Specifies the behavior of ODT signals when a Write command is issued to Rank 1
    // [br]00 - Write ODT is disabled [br]01 - Assert ODT to Rank 0 (non-targeted Rank)
    // [br]10 - Assert ODT to Rank 1 (targeted Rank) [br]11 - Assert ODT to Rank 0 and
    // Rank 1 [br]Note: 10 and 11 are reserved values for LPDDR3
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX r1wrodtctl : 2;
    //
    // Specifies the behavior of ODT signals when a Read command is issued to Rank 0
    // [br]0 - Read ODT is disabled for Rank 0 [br] 1 - Assert ODT to for Rank 1 (non-targeted
    // Rank) [br]Note: This register must be set to 0 for LPDDR3 devices
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX r0rdodtctl : 1;
    //
    // Specifies the behavior of ODT signals when a Read command is issued to Rank 1
    // [br]0 - Read ODT is disabled for Rank 1 [br] 1 - Assert ODT to for Rank 0 (non-targeted
    // Rank) [br]Note: This register is reserved for LPDDR3 devices
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX r1rdodtctl : 1;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_DOCRA_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DPMC0_DUNIT_REG                               0x00000030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the minimum time the D-unit will wait before it enters Dynamic Self-Refresh
    // mode when idle. (in 16x DRAM Clocks)
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX sredly : 16;
    //
    // When set to 1 the D-unit will automatically control DRAM Self Refresh entry and
    // exit based on interface state and requests in pending queues. When there is no
    // pending request in the queues and PMI is idle then the D-unit will place the DRAM
    // devices in Self Refresh mode. The DRAM devices will be brought out of Self-Refresh
    // when idle conditions don't hold.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dynsren : 1;
    //
    // DDRIO PHY Power Mode Opcode:  After the D-unit has placed the DRAM devices in
    // Self Refresh mode as the result of a Dynamic Self-Refresh, it sends this 5bit
    // value to the DDRIO PHY to tell it which power saving mode it should enter. [br]Changing
    // this register value while in self-refresh will only change the PM state for the
    // next entry in DynSR.
    //
    // Bits[21:17], RW, default = 0x0
    //
    UINTX dynpmop : 5;
    //
    // Specifies when it is safe to send PM message to the PHY. When enabled Dunit waits
    // for SPID Clock to deassert before sending a PM message on SR entry. [br]0 - D-unit
    // will not wait for SPID_clk to deassert before sending the PM message to PHY, 1
    // - D-unit will wait for SPID_clk to deassert before sending PM message to the PHY.
    // [br]Note: The value must be 1 when DYNPMOP = 0x7
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX srpmclkw : 1;
    //
    // Reserved
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX rsvd23 : 1;
    //
    // DDRIO PHY Power Mode Opcode: After the Dunit has placed the DRAM devices in Self
    // Refresh mode as the result of a SUSPEND message, it sends this 5-bit value to
    // the DDRIO PHY to tell it which power saving mode it should enter. [br]Changing
    // this register value while in SUSPEND will have no effect. [br]Note: This opcode
    // cannot be a PM state where it disables PHY PLLs i.e PM7 in LPDDR PHY
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX suspmop : 5;
    //
    // Reserved
    //
    // Bits[31:29], RO, default = 0x0
    //
    UINTX rsvd31_29 : 3;
  } Bits;
  UINTX Data;
} D_CR_DPMC0_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DPMC1_DUNIT_REG                               0x00000034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Setting this bit to 1 disables dynamic control of DRAM Power-Down entry and exit
    // by keeping the CKE pins driven high. BIOS may set it to 1 during DRAM initialization
    // and DDRIO training. This bit should be set to 0 for normal operation.  [br] 0
    // - The Dunit dynamically controls the CKE pins to place the DRAM devices in Power
    // Down mode and bring them out of Power Down mode. 1 - The Dunit constantly drives
    // the CKE pins high to keep the DRAM devices from entering Power Down mode when
    // ranks are idle. [br]Note: This bit is overridden if CKEMODE = 1. [br]This bit
    // does not control CKE behavior on SR entry/exit.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dispwrdn : 1;
    //
    // D-unit will send the value in this register after it has entered Powerdown Mode
    // and has stopped/tristated the clock [br]00 - Disable LPMode
    //
    // Bits[2:1], RW, default = 0x0
    //
    UINTX lpmodeop : 2;
    //
    // Enable/Disable CK Stop/Tristate During Power down.  [br]00 - Disable CK Stop/Tristate
    // During Power down. 01 - Enable CK Stop During Power down. 10 - Enable CK Tristate
    // During Power down. 11 - Reserved
    //
    // Bits[4:3], RW, default = 0x1
    //
    UINTX enckstp : 2;
    //
    // Reserved
    //
    // Bits[6:5], RO, default = 0x0
    //
    UINTX rsvd6_5 : 2;
    //
    // When Disabled Dunit will not close the DRAM page when idle. 0 - Enable page close
    // timer,  1 - Disable page close timer (Used during DRAM init and DDRIO training).
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX pclstodis : 1;
    //
    // Specifies the time from the last access of a DRAM page until that page is scheduled
    // to close by sending a Precharge command to DRAM. (in 16 x DRAM Clocks)
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX pclsto : 8;
    //
    // This is the Segment Mask used for the MRW to MR17 during SUSPENDP (Partial Array
    // Self Refresh entry).
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX pasr : 8;
    //
    // Was CMDTRIST. This feature is controlled by PHY.
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX cmdtrist : 2;
    //
    // 0 -  The DRAM CS pins associated with the enabled ranks are never tristated.
    // 1 - DRAMs CS pins are tristated when DRAM clock is stopped or tristetd . [br]Note:
    // CS is not tristated when clock stop tristate is disabled.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX cstrist : 1;
    //
    // Setting this bit to 0 allows the majority of the D-unit clocks to be gated off
    // when there is no activity in order to save power. When set to 1 D-unit clockgating
    // is disabled.  0 -  Enable,  1 -  Disable. [br]Note: This is a de-feature bit and
    // should be set to 0 for normal operation.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX clkgtdis : 1;
    //
    // Setting this bit to 0 enables the clock gating of IOSF-SB End Points in Dunit
    // and CPGC when there is no IOSF-SB activity in order to save power. [br]0 -  Enable
    // IOSF-SB EP clock gating,  1 -  Disable IOSF-SB clock gating. [br]Note: This is
    // a de-feature bit and should be set to 0 for normal operation.
    //
    // Bits[28:28], RW, default = 0x1
    //
    UINTX sbepclkgtdis : 1;
    //
    // Setting this bit to 0 allows majority of the repeaters between D-unit and PHY
    // to clock gate when there is no activity in order to save power.[br]0 -  Enable
    // Repeaters clock gating,  1 -  Disable Repeaters clock gating.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX rptclkgtdis : 1;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_DPMC1_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DRFC_DUNIT_REG                                0x00000038
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Disable opportunistic scheduling of refresh. [br]0 - Dunit will send a REF command
    // only if there is no pending request to that rank, [br]1 - Dunit will not send
    // any opportunistic refreshes. Refresh commands are only sent when the refresh counter
    // is greater than REFWMHI [br]Note: When set DISREFDBTCLR must also be set to be
    // able to enter SR
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX orefdis : 1;
    //
    // Reserved
    //
    // Bits[3:1], RO, default = 0x0
    //
    UINTX rsvd3_1 : 3;
    //
    // When the Refresh counter per rank is greater than this value the Dunit will send
    // a REF command to the rank if there is no critical priority requests in the pending
    // queues [br]Note: value must be greater or equal to 1 and less than or equal to
    // REFWMPNC
    //
    // Bits[7:4], RW, default = 0x5
    //
    UINTX refwmhi : 4;
    //
    // When the Refresh counter per rank is greater than this value the Dunit will send
    // a REF command to the rank regardless of pending requests. [br]Note: REFWMPNC must
    // be greater than or equal to REFWMHI and greater than 2, Max Value must be less
    // than 8 to not violate 9xtREFI JEDEC requirement
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX refwmpnc : 4;
    //
    // Ensures that refresh rate never drops below a certain limit regardless of TQ polling.
    // [br]000 - Disable  tREFI counter, [br]001 - 0.25x refresh rate (i.e. 4x tREFI
    // same as no limit), [br]010 - 0.5x refresh rate (i.e. 2x tREFI), [br]011 - 1x refresh
    // rate (i.e. 1x tREFI), [br]100 - 2x refresh rate (i.e. 0.5x tREFI), [br]101 - 4x
    // refresh rate (i.e. 0.25x tREFI), [br]110 - 4x refresh rate with derating forced
    // on i.e. 0.25x tREFI, [br]111 - Reserved
    //
    // Bits[14:12], RW, default = 0x1
    //
    UINTX minrefrate : 3;
    //
    // When set to 1 D-unit adds one extra refresh debit (for a total of two) on Self-refresh
    // exit.
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX extrarefdbt : 1;
    //
    // Reserved
    //
    // Bits[17:16], RO, default = 0x0
    //
    UINTX rsvd17_16 : 2;
    //
    // Reserved
    //
    // Bits[19:18], RO, default = 0x0
    //
    UINTX rsvd19_18 : 2;
    //
    // Disables Skewing of Refresh Counting between Ranks.  [br]Each rank has its own
    // refresh counter. By default incrementing these refresh counters are skewed by
    // 1/2 the tREFI period. Setting this bit to a 1 disables this feature and all refresh
    // counters will increment at the same time per tREFI period. Skewing the tREFI counters
    // can improve performance since traffic to all ranks does not have to be blocked
    // to perform refresh. [br]0 - Incrementing the refresh counters are skewed by 1/2
    // tREFI period. 1 - All refresh counters will increment at the same time per tREFI
    // period. [br]Reserved in BXT0
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX refskwdis : 1;
    //
    // When set dunit will not clear refresh debt before Self Refresh SR Entry: [br]0
    // - Dunit sends all postponed REF commands to DRAM before it enters Self Refresh.
    // 1 - Dunit enters SR without clearing the Refresh Debt (for Debug only)
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX disrefdbtclr : 1;
    //
    // Reserved
    //
    // Bits[31:22], RO, default = 0x0
    //
    UINTX rsvd31_22 : 10;
  } Bits;
  UINTX Data;
} D_CR_DRFC_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DSCH_DUNIT_REG                                0x0000003C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The value in this register is subtracted from Masked Write to Read, Masked Write
    // to Write and Masked Write to Masked Write turnaround times to account for half
    // BL MWr commands in LPDDR4 and WIO2. [br]LPDDR4: = MWr tCCD = MWr BL/2 = 8 [br]WIO2:
    // = MWr tCCD = MWr BL/2 = 2
    //
    // Bits[3:0], RW, default = 0x8
    //
    UINTX tmwr_ta_delta : 4;
    //
    // When stretch mode is enabled commands are initiated only on Phase 0 of SPIDClk.
    // [br]00 - Stretch mode is disabled, 01 - Commands are initiated on Phase 0 of every
    // SPID clocks, 10 - Commands are initiated on Phase 0 of even SPID clocks, 11 -
    // Commands are initiated on Phase 0 of odd SPID clocks
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX stretchmode : 2;
    //
    // Reserved
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX rsvd6 : 1;
    //
    // Idle Bypass Mode Enable: When enabled new page hit/empty read requests will bypass
    // D-unit pipeline stages to save latency 0 - Disable Idle Bypass 1 - Enable Idle
    // Bypass Note: Only applies to WIO2, this bit is reserved for other technologies
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX bypassen : 1;
    //
    // 0h - In order mode disabled: Commands are sent out of order, [br]1h - Partial
    // in order mode: Read and Write CAS commands are sent in the order they were recieved.
    // ACT and PRE can go out of order, [br]2h - Full in order mode serialized test:
    // All DRAM commands CAS ACT PRE associated with a PMI request are issued to DDR
    // before any DRAM commands for a subsequent PMI request.  [br]3h - Reserved   [br]In
    // order modes should be enabled during init/training/CPGC testing. Should never
    // be changed while the Dunit queues are nonempty.
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX inordermode : 2;
    //
    // Reserved
    //
    // Bits[15:10], RO, default = 0x0
    //
    UINTX rsvd15_10 : 6;
    //
    // Used to llimit the number of entries in Read Pending Queue. RPQCOUNT will only
    // recognize changes when PMI ISM is not active.
    //
    // Bits[20:16], RW, default = 0x10
    //
    UINTX rpqcount : 5;
    //
    // Used to limit the number of available slots in Write Pending Queue/ Write Data
    // Buffer. WPQCOUNT will only recognize changes when PMI ISM is not active.
    //
    // Bits[26:21], RW, default = 0x20
    //
    UINTX wpqcount : 6;
    //
    // Reserved
    //
    // Bits[31:27], RO, default = 0x0
    //
    UINTX rsvd31_27 : 5;
  } Bits;
  UINTX Data;
} D_CR_DSCH_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DCAL_DUNIT_REG                                0x00000040
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the time interval between two ZQCS (LPDDR3) or ZQ Start (LPDDR4) commands
    // to a DRAM device. (in RTC 32.8KHz clocks)
    //
    // Bits[13:0], RW, default = 0x1057
    //
    UINTX zqint : 14;
    //
    // Reserved
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX rsvd15_14 : 2;
    //
    // 0 - Periodic ZQ Calibration is Enabled, [br]1 - Disable periodic ZQ Calibration
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX zqcdis : 1;
    //
    // Specifies how ZQCal commands are sent to different ranks [br]0 - ZQCL commands
    // are sent in parallel to all ranks after Self Refresh exit. [br]1 -  ZQCL commands
    // are sent serially to each rank after Self Refresh exit.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX zqclmode : 1;
    //
    // Reserved
    //
    // Bits[20:18], RO, default = 0x0
    //
    UINTX rsvd20_18 : 3;
    //
    // 00 - On DynSR exit ZQ timer determines the ZQ type. When the state is lost (i.e
    // due to AutoPG/S0ix) ZQCL is always performed. [br]01 - Always perform ZQCL after
    // self refresh exit, in LPDDR4, ZQ with traffic blocked [br]10 - Always perform
    // ZQCS on SR exit. For LPDDR4, ZQ while traffic is allowed [br]11 - No ZQCL commands
    // are sent. (it disables ZQCAL commands on SR exit).
    //
    // Bits[22:21], RW, default = 0x0
    //
    UINTX srxzqc : 2;
    //
    // Reserved
    //
    // Bits[31:23], RO, default = 0x0
    //
    UINTX rsvd31_23 : 9;
  } Bits;
  UINTX Data;
} D_CR_DCAL_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DRMC_DUNIT_REG                                0x00000044
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Each bit of CKEVAL directly controls a CKE pin when CKEMODE is set to 1.  [br]Used
    // only during init flow.
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX ckeval : 2;
    //
    // Reserved
    //
    // Bits[3:2], RO, default = 0x0
    //
    UINTX rsvd3_2 : 2;
    //
    // 0 - Dunit auto controls the CKE pins based on PowerDown and Self Refresh entry
    // and exit.  [br]1 - The value of CKEVAL field directly controls the CKE pins.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX ckemode : 1;
    //
    // Reserved
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX rsvd7_5 : 3;
    //
    // Each bit of ODTVAL directly controls an ODT pin when ODTMODE is set to 1.  Used
    // only during init flow. Note: Reserved for BXT0/1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX odtval : 2;
    //
    // Reserved
    //
    // Bits[11:10], RO, default = 0x0
    //
    UINTX rsvd11_10 : 2;
    //
    // 0 - Dunit auto controls the ODT pins based on DRAM Write transactions. [br]1 -
    // The value of ODTVAL directly controls the ODT pins. Note: Reserved for BXT0/1
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX odtmode : 1;
    //
    // Reserved
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX rsvd15_13 : 3;
    //
    // This bit must be set and then cleared by BIOS during cold/warm reset. [br]Also
    // when set before SUSPEND/WAKE commands D-unit will not send SR entry/exit commands
    // to DRAM
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX coldwake : 1;
    //
    // Reserved
    //
    // Bits[17:17], RO, default = 0x0
    //
    UINTX rsvd17 : 1;
    //
    // Write a 1 to this bit to lock and clock gate the CPGC.
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX cpgclock : 1;
    //
    // Reserved
    //
    // Bits[31:19], RO, default = 0x0
    //
    UINTX rsvd31_19 : 13;
  } Bits;
  UINTX Data;
} D_CR_DRMC_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_VNNTIMER_DUNIT_REG                            0x0000004C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The final timer value (in 16 x DRAM Clocks)
    //
    // Bits[11:0], RW, default = 0x0
    //
    UINTX vnn_timer_time : 12;
    //
    // Reserved
    //
    // Bits[30:12], RO, default = 0x0
    //
    UINTX rsvd30_12 : 19;
    //
    // 0 - The Dunit VNN Scaling Timer is disabled, [br]1 - The Dunit VNN Scaling Timer
    // is enabled
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX vnn_timer_en : 1;
  } Bits;
  UINTX Data;
} D_CR_VNNTIMER_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_TQCTL_DUNIT_REG                               0x00000050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This bit enables periodic TQ Poll.  If disabled Dunit will not read MR4 value
    // periodically. [br]Note: Will be enabled only if refreshes are enabled
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX tqpollen : 1;
    //
    // This bit enables MR4 read on Self Refresh Exit. If disabled Dunit will not read
    // MR4 value on Self-Refresh exit.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX tqpollsren : 1;
    //
    // When set to 1 Dunit pushes the data form the last MR4 read to a punit register
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX tqdatapushen : 1;
    //
    // When set to 1 the Dynamic Timing Derating is enabled. When the Dunit determines
    // (via TQ polling) that the DRAM requires timing derating in addition to refresh
    // interval adjustment the Dunit will automatically adjust the relevant timing parameters.
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX enderate : 1;
    //
    // When set, before every Self refresh entry, D-unit writes a 1 to bit 7 of TQOFFSET.MR_VALUE
    // when TQDATA for that rank indicates a value higher then 0x3, and writes a 0 to
    // that bit otherwise. The new MR_VALUE is then written into MR2 of DDR3 for each
    // enabled rank.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX srten : 1;
    //
    // Reserved
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX rsvd7_5 : 3;
    //
    // This sets the frequency by which the Dunit polls the DRAM mode register MR4 to
    // determine required refresh rate. (in 4x tREFI units)
    //
    // Bits[21:8], RW, default = 0x0
    //
    UINTX tqpollper : 14;
    //
    // Reserved
    //
    // Bits[25:22], RO, default = 0x0
    //
    UINTX rsvd25_22 : 4;
    //
    // This field contains the data of the last DRAM Mode Register Read to MR4 MRR issued.
    // It is overwritten with each command.
    //
    // Bits[28:26], RW/V, default = 0x3
    //
    UINTX tqdatar0 : 3;
    //
    // If Rank 1 is disabled this value will remain zero. [br]This field contains the
    // data of the last DRAM Mode Register Read to MR4 MRR issued. It is overwritten
    // with each command.
    //
    // Bits[31:29], RW/V, default = 0x3
    //
    UINTX tqdatar1 : 3;
  } Bits;
  UINTX Data;
} D_CR_TQCTL_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_TQOFFSET_DUNIT_REG                            0x00000054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // (WIO2 only) Everytime MR3_OFFSET_UPDATE is set, Dunit merges the value in this
    // field with MR3_VALUE and writes the result to MR3 in DRAM
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX mr3_therm_offset : 2;
    //
    // When set, dunit writes the merged value of MR3_VALUE and MR3_THERM_OFFSET into
    // MR3 of DRAM. Dunit clears this bit once the value is written
    //
    // Bits[2:2], RW/V, default = 0x0
    //
    UINTX mr3_offset_update : 1;
    //
    // Reserved
    //
    // Bits[7:3], RO, default = 0x0
    //
    UINTX rsvd7_3 : 5;
    //
    // Dunit adds the value of this field to TQDATA read from MR4 the resulting value
    // is used to control refresh rate and AC timing derating.
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX mr4_adder : 3;
    //
    // Reserved
    //
    // Bits[15:11], RO, default = 0x0
    //
    UINTX rsvd15_11 : 5;
    //
    // MR3 Shadow Register (WIO2 only ) [br]BIOS sets the value of this field at boot
    // time based on the DRAM device configuration. Dunit merges the value in MR3_THERM_OFFSET
    // with this field and writes the result into DRAM MR3 [br]MR2 Shadow Register (DDR3
    // Only): [br]BIOS writes the correct value of MR2 register in DDR3 into this field
    // at boot time. D-unit modifes one bit and rewrites the MR2 into DDR3 before SR
    // entry.
    //
    // Bits[25:16], RW, default = 0x0
    //
    UINTX mr_value : 10;
    //
    // Reserved
    //
    // Bits[31:26], RO, default = 0x0
    //
    UINTX rsvd31_26 : 6;
  } Bits;
  UINTX Data;
} D_CR_TQOFFSET_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DCO_DUNIT_REG                                 0x00000058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX rsvd0 : 1;
    //
    // Setting this field to 1 enables all maintenance operations. When DCO.IC is set
    // the maintenance operations are enabled irrespective of the value of this field
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX mnten : 1;
    //
    // Writing a 1 to this field resets all maintenance timers. Clears all states and
    // also clears refresh debt queues. This bit needs to be cleared by software after
    // at least 3 SPID clocks.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX mntrst : 1;
    //
    // When enabled dunit will synchronize clock crossing signals  [br]0 - PSMI Mode
    // is disabled, [br]1 - PSMI Mode is enabled [br]Note: change only allowed when D-unit
    // is idle
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX psmien : 1;
    //
    // Reserved
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX rsvd7_4 : 4;
    //
    // Reserved
    //
    // Bits[27:8], RO, default = 0x0
    //
    UINTX rsvd27_8 : 20;
    //
    // 0 - Dunit PMI is connected to Bunit/GSA/2LM, 1 - Dunit PMI is connected to CPGC
    // [br]Note: PMI must be idle and D-unit BGF_RUN = 0 before changing the value in
    // this register
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX pmictl : 1;
    //
    // Reserved
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX rsvd29 : 1;
    //
    // Status indication that the DDRIO PHY initialization is complete reflects the status
    // spid_init_complete signal
    //
    // Bits[30:30], RO/V, default = 0x0
    //
    UINTX dioic : 1;
    //
    // Indicates that initialization of the Dunit has been completed. Memory accesses
    // are permitted and maintenance operation begins. Until this bit is set to a 1 the
    // memory controller will not accept DRAM requests from the Bunit/GSA/2LM (PMI ISMs
    // will not leave idle).  [br]Note: Set this bit to 1 only when all other Dunit registers
    // have been configured. Usually set at the last configuration step by BIOS on cold/warm
    // reset. D-unit hardware sets this bit on SR exit
    //
    // Bits[31:31], RW/V, default = 0x0
    //
    UINTX ic : 1;
  } Bits;
  UINTX Data;
} D_CR_DCO_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DTRC_DUNIT_REG                                0x0000005C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Block Read Commands to DRAM  [br]0 - No Block, 1 - Block
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX blkrd : 1;
    //
    // Block Write Commands to DRAM  [br]0 - No Block, 1 - Block
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX blkwr : 1;
    //
    // Block Activate Commands to DRAM  [br]0 - No Block, 1 - Block
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX blkact : 1;
    //
    // Block Precharge Commands to DRAM [br]0 - No Block, 1 - Block
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX blkpre : 1;
    //
    // Block Processing Read Requests until RPQ is Full. [br]When this bit is set to
    // 1 the Dunit is blocked from processing any of the requests in the RPQ until it
    // is full. The full level is based on the RPQCOUNT value. [br]0 - No block,  1 -
    //  Block
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX blkrpqf : 1;
    //
    // Block Processing Write Requests until WPQ is Full. [br]When this bit is set to
    // 1 the Dunit is blocked from processing any of the requests in the WPQ until it
    // is full. The full level is based on the WPQCOUNT value. [br]0 - No block, 1 -
    //  Block [br]Note: Once WPQ is full, it is unblocked until an entry is deallocated.
    // So there could be more than one write scheduled during that window.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX blkwpqf : 1;
    //
    // The Dunit runs at half (LPDDR3/WIO2/DDR3) or quarter (LPDDR4) the frequency of
    // the DRAM clock to save power. In order to issue back-to-back commands on every
    // DRAM clock cycle, the Dunit has to schedule two commands per Dunit clock. Therefore,
    // it processes requests through separate arbitration paths labeled as Phase_0, Phase_1,
    // Phase_2 and Phase_3.  [br]In LPDDR3/WIO2/DDR3 case setting this bit to a 1 will
    // disable Phase_1 and all memory requests will be processed through Phase_0 arbitration
    // path. With only Phase_1 the DRAM devices will never see back-to-back commands.
    // The best it will see is a command every other DRAM clock cycle. [br]In LPDDR4
    // case commands are two DRAM clocks and they are sent in two consecutive phases.
    // Also, most of the commands are broken into two parts that have to be sent back-to-back.
    // Therefore, setting this bit to 1 will disable initiating *new* commands on Phase_1,
    // Phase_2 and Phase_3.[br]0 - No block, 1 - Block [br]Note: This bit does/must not
    // impact the CPGCs ability to send requests to the SPID in Phase 1/2/3.  Dunit arbiter
    // comprehends this bit to issue 1 Command per SPIDCLK when set versus 2 Commands
    // per SPIDCLK when not set
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX blkphaseb : 1;
    //
    // 0 - Dunit is not in DQ Calibration Mode, 1 -  Dunit is in DQ Calibration Mode
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX dqcalen : 1;
    //
    // 0 - Dunit is not in JEDEC CA Training Mode, 1 -  Dunit is in JEDEC CA Training
    // Mode
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX catrainen : 1;
    //
    // Reserved
    //
    // Bits[31:9], RO, default = 0x0
    //
    UINTX rsvd31_9 : 23;
  } Bits;
  UINTX Data;
} D_CR_DTRC_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DCBR_DUNIT_REG                                0x000000A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX rsvd0 : 1;
    //
    // DSTAT CR update enable
    // When set, Dunit will update the status bits in D_CR_DSTAT. If not set, the status
    // CR, D_CR_DSTAT will not reflect the latest status of the D-unit.
    // Note: This enable bit does not control Page Table Status field
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX cr_stat_en : 1;
    //
    // Page Table Status Update Enable
    // When set, Dunit will update the Page table status in DSTAT.PGTBLVLD. If not set,
    // the status CR will not reflect the latest status of the page table.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX pmidis : 1;
    //
    // When set to 1 the D-unit ignores PHY periodic quite time update requests. [br]Note:
    // Setting this bit does not prevent PHY from requesting selfrefresh exit or bus
    // quiet time.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX phyqtdis : 1;
    //
    // When set to 1 the D-unit ignores PHY periodic quite time update requests. [br]Note:
    // Setting this bit does not prevent PHY from requesting selfrefresh exit or bus
    // quiet time.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX pgtblstaten : 1;
    //
    // Reserved
    //
    // Bits[6:5], RO, default = 0x0
    //
    UINTX rsvd6_5 : 2;
    //
    // When set to 1 D-unit closes all pages by issuing a PREALL before sending the MRR
    // command to DRAM
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX mrrcp : 1;
    //
    // Disable Accepting Requests During Self Refresh Exit (prevent Dunit PMI ISM to
    // leave idle) [br]0 - Dunit accepts and loads PMI requests into the queues during
    // Self Refresh exit period while maintenance operation are in progress, [br]1 -
    // Dunit does not accept PMI requests until Self Refresh exit and all maintenance
    // operations have completed
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX srxnrqdis : 1;
    //
    // Reserved
    //
    // Bits[31:9], RO, default = 0x0
    //
    UINTX rsvd31_9 : 23;
  } Bits;
  UINTX Data;
} D_CR_DCBR_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_SCRAMCTRL_DUNIT_REG                           0x000000A4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Sets the key for the scrambler. The key should be a random value that is set following
    // each cold boot.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX key : 16;
    //
    // Reserved
    //
    // Bits[27:16], RO, default = 0x0
    //
    UINTX rsvd27_16 : 12;
    //
    // This field controls how the scrambler output code is clock gated to reduce power.
    //  [br]00 -  Clock gate disabled,  [br]01 - Clock Gate every 2 cycle,  [br]10 -
    // Clock Gate every 3 cycle,  [br]11 - Clock Gate every 4 cycle
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX clockgate : 2;
    //
    // Reserved
    //
    // Bits[30:30], RO, default = 0x0
    //
    UINTX rsvd30 : 1;
    //
    // When set to 1 data scrambling is enabled. When set to 0 data scrambling is disabled.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX scrm_en : 1;
  } Bits;
  UINTX Data;
} D_CR_SCRAMCTRL_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DSTAT_DUNIT_REG                               0x000000A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX rsvd4_0 : 5;
    //
    // 0 - Dunit RPQ is not empty (pending read requests in RPQ), 1 - Dunit RPQ is empty
    //
    // Bits[5:5], RO/V, default = 0x0
    //
    UINTX rpqempty : 1;
    //
    // 0 - Dunit WPQ is not empty (pending write requests in WPQ), 1 - Dunit WPQ is empty
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX wpqempty : 1;
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX rsvd7 : 1;
    //
    // Rank 0 has a Refresh Debt.
    //
    // Bits[8:8], RO/V, default = 0x0
    //
    UINTX refdbt0 : 1;
    //
    // Rank 1 has a Refresh Debt.
    //
    // Bits[9:9], RO/V, default = 0x0
    //
    UINTX refdbt1 : 1;
    //
    // The Dunit sets this bit to a 1 after it has placed the DRAM devices in Self Refresh
    // mode.  [br]The Dunit clears this bit when it brings the DRAM devices out of Self
    // Refresh mode and completes maintenance operations,  [br]0 -  DRAM not in SelfRefresh.
    //  [br]1 -  DRAM in SelfRefresh  [br]Note: If DRAM is in SR because of Dynamic SR
    // reading any Dunit register will bring DRAM out of SR
    //
    // Bits[10:10], RO/V, default = 0x0
    //
    UINTX disr : 1;
    //
    // Reserved
    //
    // Bits[15:11], RO, default = 0x0
    //
    UINTX rsvd15_11 : 5;
    //
    // This register indicates whether a page is open within a bank. Each bit reflects
    // the page open status of a bank. 2 Ranks x 8 banks/rank = 16 status bits.  [br]PGTBLVLD[7:0]
    // = Page open status for Rank 0 Bank[7:0], [br]PGTBLVLD[15:8] = Page open status
    // for Rank 1 Bank[7:0], [br]0 - The associated bank has been opened, [br]1 - The
    // associated bank is closed
    //
    // Bits[31:16], RO/V, default = 0x0
    //
    UINTX pgtblvld : 16;
  } Bits;
  UINTX Data;
} D_CR_DSTAT_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_ERR_INJ_DUNIT_REG                             0x000000AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX rsvd4_0 : 5;
    //
    // 0 - Dunit RPQ is not empty (pending read requests in RPQ), 1 - Dunit RPQ is empty
    //
    // Bits[5:5], RO/V, default = 0x0
    //
    UINTX rpqempty : 1;
    //
    // 0 - Dunit WPQ is not empty (pending write requests in WPQ), 1 - Dunit WPQ is empty
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX wpqempty : 1;
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX rsvd7 : 1;
    //
    // Rank 0 has a Refresh Debt.
    //
    // Bits[8:8], RO/V, default = 0x0
    //
    UINTX refdbt0 : 1;
    //
    // Rank 1 has a Refresh Debt.
    //
    // Bits[9:9], RO/V, default = 0x0
    //
    UINTX refdbt1 : 1;
    //
    // The Dunit sets this bit to a 1 after it has placed the DRAM devices in Self Refresh
    // mode.  [br]The Dunit clears this bit when it brings the DRAM devices out of Self
    // Refresh mode and completes maintenance operations,  [br]0 -  DRAM not in SelfRefresh.
    //  [br]1 -  DRAM in SelfRefresh  [br]Note: If DRAM is in SR because of Dynamic SR
    // reading any Dunit register will bring DRAM out of SR
    //
    // Bits[10:10], RO/V, default = 0x0
    //
    UINTX disr : 1;
    //
    // Reserved
    //
    // Bits[15:11], RO, default = 0x0
    //
    UINTX rsvd15_11 : 5;
    //
    // This register indicates whether a page is open within a bank. Each bit reflects
    // the page open status of a bank. 2 Ranks x 8 banks/rank = 16 status bits.  [br]PGTBLVLD[7:0]
    // = Page open status for Rank 0 Bank[7:0], [br]PGTBLVLD[15:8] = Page open status
    // for Rank 1 Bank[7:0], [br]0 - The associated bank has been opened, [br]1 - The
    // associated bank is closed
    //
    // Bits[31:16], RO/V, default = 0x0
    //
    UINTX pgtblvld : 16;
  } Bits;
  UINTX Data;
} D_CR_ERR_INJ_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_ERR_INJ_CTL_DUNIT_REG                         0x000000B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // If enabled the error injection is continuously armed for ERR_INJ.ADDR 32B write
    // address matching until it is cleared. [br]00: No error injection. [br]01: Uncorrectable
    // Error (UE) is armed for write address matching to inject UE by using the same
    // poisoning scheme, i.e. inverting corresponding write ECC[6:0] on QW0 of the 32B
    // data. [br]10: Correctable Error (CE) is armed for write address matching to inject
    // CE by inverting corresponding write ECC[0] on QW0 of the 32B data. [br]11: Reserved.
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX sel : 2;
    //
    // Reserved
    //
    // Bits[31:2], RO, default = 0x0
    //
    UINTX rsvd31_2 : 30;
  } Bits;
  UINTX Data;
} D_CR_ERR_INJ_CTL_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_ERR_ECC_LOG_DUNIT_REG                         0x000000B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX rsvd4_0 : 5;
    //
    // 0 - Dunit RPQ is not empty (pending read requests in RPQ), 1 - Dunit RPQ is empty
    //
    // Bits[5:5], RO/V, default = 0x0
    //
    UINTX rpqempty : 1;
    //
    // 0 - Dunit WPQ is not empty (pending write requests in WPQ), 1 - Dunit WPQ is empty
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX wpqempty : 1;
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX rsvd7 : 1;
    //
    // Rank 0 has a Refresh Debt.
    //
    // Bits[8:8], RO/V, default = 0x0
    //
    UINTX refdbt0 : 1;
    //
    // Rank 1 has a Refresh Debt.
    //
    // Bits[9:9], RO/V, default = 0x0
    //
    UINTX refdbt1 : 1;
    //
    // The Dunit sets this bit to a 1 after it has placed the DRAM devices in Self Refresh
    // mode.  [br]The Dunit clears this bit when it brings the DRAM devices out of Self
    // Refresh mode and completes maintenance operations,  [br]0 -  DRAM not in SelfRefresh.
    //  [br]1 -  DRAM in SelfRefresh  [br]Note: If DRAM is in SR because of Dynamic SR
    // reading any Dunit register will bring DRAM out of SR
    //
    // Bits[10:10], RO/V, default = 0x0
    //
    UINTX disr : 1;
    //
    // Reserved
    //
    // Bits[15:11], RO, default = 0x0
    //
    UINTX rsvd15_11 : 5;
    //
    // This register indicates whether a page is open within a bank. Each bit reflects
    // the page open status of a bank. 2 Ranks x 8 banks/rank = 16 status bits.  [br]PGTBLVLD[7:0]
    // = Page open status for Rank 0 Bank[7:0], [br]PGTBLVLD[15:8] = Page open status
    // for Rank 1 Bank[7:0], [br]0 - The associated bank has been opened, [br]1 - The
    // associated bank is closed
    //
    // Bits[31:16], RO/V, default = 0x0
    //
    UINTX pgtblvld : 16;
  } Bits;
  UINTX Data;
} D_CR_ERR_ECC_LOG_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DFUSESTAT_DUNIT_REG                           0x000000BC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // D-unit fuse bits are captured into this register and are available to be read.
    //  [br][0] - fus_dun_ecc_dis,  [br][3:1] - fus_dun_max_supported_device_size[2:0],
    // [br][5:4] - fus_dun_dram_type [1:0], [br][6:6] - wio2_channels, [br][15:7] - reserved
    //
    // Bits[15:0], RO/V, default = 0x0
    //
    UINTX fusestat : 16;
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX rsvd31_9 : 16;
  } Bits;
  UINTX Data;
} D_CR_DFUSESTAT_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_SSKPD0_DUNIT_REG                              0x000000C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // General Purpose Scratchpad.  May be used for BIOS for data storage.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX val : 32;
  } Bits;
  UINTX Data;
} D_CR_SSKPD0_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_SSKPD1_DUNIT_REG                              0x000000C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // General Purpose Scratchpad.  May be used for BIOS for data storage.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX val : 32;
  } Bits;
  UINTX Data;
} D_CR_SSKPD1_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_BONUS0_DUNIT_REG                              0x000000C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bonus Register 0  [br]This register is reserved for ECO
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX bonus0 : 32;
  } Bits;
  UINTX Data;
} D_CR_BONUS0_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_BONUS1_DUNIT_REG                              0x000000CC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bonus Register 1  [br]This register is reserved for ECO
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX bonus1 : 32;
  } Bits;
  UINTX Data;
} D_CR_BONUS1_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DQCALRDATLO_DUNIT_REG                         0x000000D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Holds least significant 32 bits returned as a result of CA Training
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX dqcalrdatlo : 32;
  } Bits;
  UINTX Data;
} D_CR_DQCALRDATLO_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DQCALRDATHI_DUNIT_REG                         0x000000D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Holds most significant 32 bits returned as a result of DQ Calibration/CA Training
    // (Reserved in BXT0/1)
    //
    // Bits[31:0], RO, default = 0x0
    //
    UINTX dqcalrdathi : 32;
  } Bits;
  UINTX Data;
} D_CR_DQCALRDATHI_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CUSTOM_TSV_CMD_PATTERN_DUNIT_REG          0x000000D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Provides custom TSVs for BGFs which write in the SABY2 clock and read in CMD SPID
    // clock
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX saby2_to_cmdspid_tsvs : 16;
    //
    // Provides custom TSVs for BGFs which write in the CMD SPID clock and read in SABY2
    // clock
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX cmdspid_to_saby2_tsvs : 16;
  } Bits;
  UINTX Data;
} D_CR_BGF_CUSTOM_TSV_CMD_PATTERN_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CUSTOM_TSV_CMD_INIT_DUNIT_REG             0x000000DC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Provides custom TSVs for BGFs which write in SABY2 clock and read in CMD SPID
    // clock
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX saby2_to_cmdspid_tsvs : 16;
    //
    // Provides custom TSVs for BGFs which write in the CMD SPID clock and read in SABY2
    // clock
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX cmdspid_to_saby2_tsvs : 16;
  } Bits;
  UINTX Data;
} D_CR_BGF_CUSTOM_TSV_CMD_INIT_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CUSTOM_TSV_DATA_PATTERN_DUNIT_REG         0x000000E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Provides custom TSVs for BGFs which write in SABY2 clock and read in DATA SPID
    // clock
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX saby2_to_dataspid_tsvs : 16;
    //
    // Provides custom TSVs for BGFs which write in the DATA SPID clock and read in SABY2
    // clock
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX dataspid_to_saby2_tsvs : 16;
  } Bits;
  UINTX Data;
} D_CR_BGF_CUSTOM_TSV_DATA_PATTERN_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CUSTOM_TSV_DATA_INIT_DUNIT_REG            0x000000E4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Provides custom TSVs for BGFs which write in SABY2 clock and read in DATA SPID
    // clock
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX saby2_to_dataspid_tsvs : 16;
    //
    // Provides custom TSVs for BGFs which write in the DATA SPID clock and read in SABY2
    // clock
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX dataspid_to_saby2_tsvs : 16;
  } Bits;
  UINTX Data;
} D_CR_BGF_CUSTOM_TSV_DATA_INIT_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_BGF_CTL_DUNIT_REG                             0x00000120
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Start BGFs
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX bgf_run : 1;
    //
    // Reserved
    //
    // Bits[1:1], RO, default = 0x0
    //
    UINTX rsvd_1 : 1;
    //
    // Enable the  use of locally generated sync signals
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX use_localsync : 1;
    //
    // Variable separation of the serial fifos to be passed into the se module.
    //
    // Bits[4:3], RW, default = 0x0
    //
    UINTX fus_seperation_saby2spid : 2;
    //
    // Disable BGF Clock Generator
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX cg_dis : 1;
    //
    // Variable separation of the serial fifos to be passed into the se module.
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX fus_seperation_spidsaby2 : 2;
    //
    // The ratio of clock  A (SAby2):1   Note: this field must be set to the same value
    // as SPIDCMDCLK_RATIO when CPGC is active
    //
    // Bits[15:8], RW, default = 0x1
    //
    UINTX saclkby2_ratio : 8;
    //
    // The ratio of clock  B (SPIDCmd):1
    //
    // Bits[23:16], RW, default = 0x3
    //
    UINTX spidcmdclk_ratio : 8;
    //
    // The ratio of clock  C (SPIDData):1
    //
    // Bits[31:24], RW, default = 0x3
    //
    UINTX spiddataclk_ratio : 8;
  } Bits;
  UINTX Data;
} D_CR_BGF_CTL_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_MMC_DUNIT_REG                                 0x00000124
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When the number of entries in WPQ is greater than or equal to this value the Dunit
    // will switch to Write Major Mode WMM [br]Note: the value must not be set to 0
    //
    // Bits[5:0], RW, default = 0x18
    //
    UINTX wmmentry : 6;
    //
    // When the number of entries in WPQ is less than this value the Dunit will switch
    // back to Read Major Mode.
    //
    // Bits[11:6], RW, default = 0x14
    //
    UINTX wmmexit : 6;
    //
    // When the number of entries in WPQ is greater than or equal to this value (higher
    // than WMM Entry Watermark, less than WPQ size) it triggers Write Isoch Mode (WIM)
    //
    // Bits[17:12], RW, default = 0x1E
    //
    UINTX wimthrs : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[22:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 5;
    //
    // If any read in the RPQ is at this programmable priority RIM is triggered
    //
    // Bits[25:23], RW, default = 0x6
    //
    UINTX rimprio : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[26:26], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // If a conflict read reaches this priority (or greater depending on access class
    // occupancy), WMM will be triggered to unblock the corresponding write. Dunit will
    // stay in WMM until corresponding write is issued. [br]Note: The value in this bit
    // must not be higher than lowest terminal priority level of each access class
    //
    // Bits[29:27], RW, default = 0x5
    //
    UINTX raw_wmm : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
  } Bits;
  UINTX Data;
} D_CR_MMC_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_MMRDWR_AB_DUNIT_REG                           0x00000128
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum number of reads that has to be serviced before a switch to WMM is allowed
    // (set A)
    //
    // Bits[5:0], RW, default = 0x8
    //
    UINTX minrda : 6;
    //
    // Maximum number of writes Dunit can send in WMM mode before returning to RMM.
    // (set A)
    //
    // Bits[11:6], RW, default = 0x1F
    //
    UINTX maxwra : 6;
    //
    // Reserved
    //
    // Bits[13:12], RO, default = 0x0
    //
    UINTX rsvd13_12 : 2;
    //
    // Minimum number of reads that has to be serviced before a switch to WMM is allowed
    // (set B)
    //
    // Bits[19:14], RW, default = 0x8
    //
    UINTX minrdb : 6;
    //
    // Maximum number of writes Dunit can send in WMM mode before returning to RMM.
    // (set B)
    //
    // Bits[25:20], RW, default = 0x1F
    //
    UINTX maxwrb : 6;
    //
    // Reserved
    //
    // Bits[31:26], RO, default = 0x0
    //
    UINTX rsvd31_26 : 6;
  } Bits;
  UINTX Data;
} D_CR_MMRDWR_AB_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_MMRDWR_CD_DUNIT_REG                           0x0000012C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum number of reads that has to be serviced before a switch to WMM is allowed.
    // (set C)
    //
    // Bits[5:0], RW, default = 0x8
    //
    UINTX minrdc : 6;
    //
    // Maximum number of writes Dunit can send in WMM mode before returning to RMM. (set
    // C)
    //
    // Bits[11:6], RW, default = 0x1F
    //
    UINTX maxwrc : 6;
    //
    // Reserved
    //
    // Bits[13:12], RO, default = 0x0
    //
    UINTX rsvd13_12 : 2;
    //
    // Minimum number of reads that has to be serviced before a switch to WMM is allowed.
    // (set D)
    //
    // Bits[19:14], RW, default = 0x8
    //
    UINTX minrdd : 6;
    //
    // Maximum number of writes Dunit can send in WMM mode before returning to RMM.
    // (set D_
    //
    // Bits[25:20], RW, default = 0x1F
    //
    UINTX maxwrd : 6;
    //
    // Reserved
    //
    // Bits[31:26], RO, default = 0x0
    //
    UINTX rsvd31_26 : 6;
  } Bits;
  UINTX Data;
} D_CR_MMRDWR_CD_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_ACCIP_DUNIT_REG                               0x00000130
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Initial priority level of read requests coming with Access Class 0
    //
    // Bits[2:0], RW, default = 0x2
    //
    UINTX ac0ip : 3;
    //
    // Initial priority level of read requests coming with Access Class 1
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX ac1ip : 3;
    //
    // Initial priority level of read requests coming with Access Class 2
    //
    // Bits[8:6], RW, default = 0x7
    //
    UINTX ac2ip : 3;
    //
    // Initial priority level of read requests coming with Access Class 3
    //
    // Bits[11:9], RW, default = 0x3
    //
    UINTX ac3ip : 3;
    //
    // Initial priority level of read requests coming with Access Class 4
    //
    // Bits[14:12], RW, default = 0x1
    //
    UINTX ac4ip : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 17;
  } Bits;
  UINTX Data;
} D_CR_ACCIP_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM0_DUNIT_REG                            0x00000134
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[9:5], RW, default = 0xA
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[14:10], RW, default = 0xA
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[19:15], RW, default = 0xA
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[24:20], RW, default = 0x1F
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[29:25], RW, default = 0x0
    //
    UINTX p6res : 5;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM0_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM1_DUNIT_REG                            0x00000138
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[9:5], RW, default = 0x0
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[14:10], RW, default = 0x0
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[19:15], RW, default = 0x0
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[24:20], RW, default = 0x0
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[29:25], RW, default = 0xA
    //
    UINTX p6res : 5;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM1_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM2_DUNIT_REG                            0x0000013C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[9:5], RW, default = 0x0
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[14:10], RW, default = 0x0
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[19:15], RW, default = 0x0
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[24:20], RW, default = 0x0
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[29:25], RW, default = 0x0
    //
    UINTX p6res : 5;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM2_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM3_DUNIT_REG                            0x00000140
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[9:5], RW, default = 0x0
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[14:10], RW, default = 0x5
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[19:15], RW, default = 0x5
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[24:20], RW, default = 0x1F
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[29:25], RW, default = 0x0
    //
    UINTX p6res : 5;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM3_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_RD_PROM4_DUNIT_REG                            0x00000144
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[4:0], RW, default = 0xA
    //
    UINTX p1res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[9:5], RW, default = 0xA
    //
    UINTX p2res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[14:10], RW, default = 0xA
    //
    UINTX p3res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[19:15], RW, default = 0xA
    //
    UINTX p4res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[24:20], RW, default = 0x1F
    //
    UINTX p5res : 5;
    //
    // Number of CASes that pass before a request in this priority promotes to the next
    // priority level
    //
    // Bits[29:25], RW, default = 0x0
    //
    UINTX p6res : 5;
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX rsvd31_30 : 2;
  } Bits;
  UINTX Data;
} D_CR_RD_PROM4_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DL_THRS_DUNIT_REG                             0x00000148
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A requests with initial priority of 0 will exit priority 0 when its deadline is
    // equal or less than this value plus current time  This field does not affect the
    // priority of any requests in access classes with initial priority bigger than 0
    //
    // Bits[10:0], RW, default = 0x6
    //
    UINTX deadline_thrs : 11;
    //
    // Reserved
    //
    // Bits[31:11], RO, default = 0x0
    //
    UINTX rsvd31_11 : 21;
  } Bits;
  UINTX Data;
} D_CR_DL_THRS_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_MM_BLK_DUNIT_REG                              0x0000014C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Disable RMM Unsafe Top Critical Read Miss block Read and Write Hit same bank.
    // [br]Note: Priority rules 1,3 and 4 should be enabled/disabled together.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX rmm_prio_r1 : 1;
    //
    // Disable RMM CAS Block Rule
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX rmm_prio_r2 : 1;
    //
    // Disable RMM Unsafe Critical Read Hit block Read and Write Miss to same Bank. [br]Note:
    // This rule does not block the bank that is being blocked by RMM_PRIO_R1. [br]Priority
    // rules 1,3 and 4 should be enabled/disabled together.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX rmm_prio_r3 : 1;
    //
    // Disable RMM Unsafe Critical Read Miss block Read and Write Hit to same Bank. [br]Note:
    // This rule does not block the bank that is being blocked by RMM_PRIO_R3. [br]Priority
    // rules 1,3 and 4 should be enabled/disabled together.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX rmm_prio_r4 : 1;
    //
    // Reserved
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX rsvd7_4 : 4;
    //
    // Disable RMM Unsafe Read Page Hit block safe Write Page Hit same rank
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX rmm_reg_r1 : 1;
    //
    // Disable RMM Unsafe Read Page Empty block safe Write Page empty same rank
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX rmm_reg_r2 : 1;
    //
    // Disable RMM Unsafe Read Page Hit block safe Read and Write Page Miss same bank.
    // [br]Note: This rule does not block the bank that is being blocked by RMM_PRIO_R3
    // and RMM_PRIO_R1
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX rmm_reg_r3 : 1;
    //
    // Disable RMM Unsafe Write Page Hit block safe Read Page Miss same bank. [br]Note:
    // This field must not be set to 0 (enabled) if RMM_REG_R5 is also 0
    //
    // Bits[11:11], RW, default = 0x1
    //
    UINTX rmm_reg_r4 : 1;
    //
    // Disable RMM Unsafe Read Page Miss block all safe and unsafe Write Page Hit to
    // the same bank. [br]Note: This field must not be set to 0 (enabled) if RMM_REG_R4
    // is also 0
    //
    // Bits[12:12], RW, default = 0x1
    //
    UINTX rmm_reg_r5 : 1;
    //
    // Disable RMM Unsafe Write Page Hits block safe Write Page Misses same bank
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX rmm_reg_r6 : 1;
    //
    // Reserved
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX rsvd15_14 : 2;
    //
    // Disable WMM Unsafe Top Priority 1 Write Miss block Write Hit same bank. [br]Priority
    // rules 1,3 and 4 should be enabled/disabled together.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX wmm_prio_r1 : 1;
    //
    // Disable WMM CAS Block Rule
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX wmm_prio_r2 : 1;
    //
    // Disable WMM Unsafe Priority 1 Write Hit block Write Miss to same Bank   [br]Note:
    // This rule does not block the bank that is being blocked by WMM_PRIO_R1 [br]Priority
    // rules 1,3 and 4 should be enabled/disabled together.
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX wmm_prio_r3 : 1;
    //
    // Disable WMM Unsafe Priority 1 Read Miss block Write Hit to same Bank. [br]Note:
    // This rule does not block the bank that is being blocked by WMM_PRIO_R3. [br]Priority
    // rules 1,3 and 4 should be enabled/disabled together.
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX wmm_prio_r4 : 1;
    //
    // Reserved
    //
    // Bits[23:20], RO, default = 0x0
    //
    UINTX rsvd23_20 : 4;
    //
    // Disable WMM Unsafe Write Page Hits block safe Write Page Misses same bank
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX wmm_reg_r1 : 1;
    //
    // Reserved
    //
    // Bits[31:25], RO, default = 0x0
    //
    UINTX rsvd31_25 : 7;
  } Bits;
  UINTX Data;
} D_CR_MM_BLK_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DRAM_SR_CMD_DUNIT_REG                         0x00000154
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Take PHY out of PM states and wakes the DRAM out of Self Refresh mode. The bit
    // is cleared by hardware only when the DRAM has exited out of Self Refresh mode
    // and is accessible. Note: When COLDWAKE is set prior of setting this bit the D-unit
    // will not send SR exit command and will not set the DCO.IC bit.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX wake : 1;
    //
    // Reserved
    //
    // Bits[1:1], RO, default = 0x0
    //
    UINTX rsvd1 : 1;
    //
    // A SUSPEND message will put the DRAM into Self-Refresh mode. The D-unit will complete
    // servicing outstanding memory requests and flush all queued Refresh commands to
    // DRAM before putting the DRAM in Self Refresh mode. Finally a PM message will be
    // sent to the PHY. The bit is cleared by hardware only after the PHY indicates the
    // transition requested in the PM message has been completed. Note: When COLDWAKE
    // is set prior of setting this bit the DRAM will not be placed in SR
    //
    // Bits[2:2], RW/V, default = 0x0
    //
    UINTX suspend : 1;
    //
    // A SUSPENDP message will put the DRAM into Self-Refresh mode. The Dunit will complete
    // servicing outstanding memory requests and flush all queued Refresh commands to
    // DRAM before putting the DRAM in Self Refresh mode. Finally a PM message will be
    // sent to the PHY. The bit is cleared by hardware after the PHY indicates the transition
    // requested in the PM message has been completed.  Dunit will perform an MRW to
    // MR17 with an opcode as defined by DPMC0.PASR before it places the DRAM into Self-Refresh.
    // [br]Note: Reserved for BXT
    //
    // Bits[3:3], RW/V, default = 0x0
    //
    UINTX suspendp : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // Reserved
    //
    // Bits[31:8], RO, default = 0x0
    //
    UINTX rsvd31_8 : 24;
  } Bits;
  UINTX Data;
} D_CR_DRAM_SR_CMD_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DRAM_CMD_DUNIT_REG                            0x00000158
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Command to be sent to DRAM. Not all DRAM commands are supported. [br]For LPDDR3:
    // [br]DATA[9:0]=CA[9:0] Rising Edge, [br]DATA [19:10]=CA[9:0] Falling Edge, [br]DATA[23:20]
    // not used. [br]For WIO2: [br]DATA[10:0]=CA[10:0] Rising Edge, [br]DATA[21:11]=CA[10:0]
    // Falling Edge, [br]Data[23:22] not used. [br]For LPDDR4: [br]DATA[5:0]=CA[5:0]
    // CMD1 Edge1, [br]DATA[11:6]=CA[5:0] CMD1 Edge2, [br]DATA[17:12]=CA[5:0] CMD2 Edge1,
    // [br]DATA[23:18]=CA[5:0] CMD2 Edge2. [br]For DDR3: DATA[15:0] = A[15:0], [br]DATA[18:16]
    // = BA[2:0], [br]DATA[19] = WE_N, [br]DATA[20] = CAS_N, [br]DATA[21] = RAS_N, [br]DATA[23:22]
    // not used;
    //
    // Bits[23:0], RW, default = 0x0
    //
    UINTX data : 24;
    //
    // Reserved
    //
    // Bits[27:24], RO, default = 0x0
    //
    UINTX rsvd27_24 : 4;
    //
    // This field sets the BL that D-unit drives on SPID interface. [br]For LPDDR3, WIO2
    // and DDR3: 0 - Burst Length is 4,  1 - Burst Length is 8. [br]For LPDDR4: 0 - Burst
    // Length is 16, 1 - Burst Length is 32
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX bl : 1;
    //
    // This bit needs to be set if the command is a MRR
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX mrrcmd : 1;
    //
    // Rank Select. [br]0 - Rank0, [br]1 - Rank1
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX rank : 1;
    //
    // 2N Mode Command (Reserved in BXT0/1)
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX m2n : 1;
  } Bits;
  UINTX Data;
} D_CR_DRAM_CMD_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DCMDDATA_DUNIT_REG                            0x0000015C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // MRR Data: [br]This field contains the data of the last DRAM Mode Register Read
    // MRR issued through DRAM_CMD register. It is overwritten with each MRR command.
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX mrrdata : 8;
    //
    // Reserved
    //
    // Bits[31:8], RO, default = 0x0
    //
    UINTX rsvd31_8 : 24;
  } Bits;
  UINTX Data;
} D_CR_DCMDDATA_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_SBFT_CTL_DUNIT_REG                            0x00000160
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contains the final checksum value for all data written to this D-unit. Write 1
    // to clear this field.
    //
    // Bits[15:0], RW/1C, default = 0x0
    //
    UINTX data_checksum : 16;
    //
    // Contains the address checksum value for all addresses read and written from this
    // D-unit. Write 1 to clear this field.
    //
    // Bits[23:16], RW/1C, default = 0x0
    //
    UINTX addr_checksum : 8;
    //
    // Read data credit counter value. This values is used as read return credit.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rddata_credit : 4;
    //
    // Read data credit counter enable. When set read data credit counter register is
    // used for credit handling instead of initial credit handshaking.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX rddata_credit_en : 1;
    //
    // Resets the checksum registers when written to 1. Bit automatically resets to 0
    //
    // Bits[29:29], RW/V, default = 0x0
    //
    UINTX reset : 1;
    //
    // Enables checksum calculation in D-unit
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX enable_checksum : 1;
    //
    // Enables pseudorandom data return feature in D-unit
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX enable_prdr : 1;
  } Bits;
  UINTX Data;
} D_CR_SBFT_CTL_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_SBFT_CMASK_DUNIT_REG                          0x00000164
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask ANDed with pseudorandom data.  Resets to all 1s  setting bit n to 0 in this
    // register will force every nth bit in the data to be set to 0
    //
    // Bits[31:0], RW, default = 0xFFFFFFFF
    //
    UINTX clear_mask : 32;
  } Bits;
  UINTX Data;
} D_CR_SBFT_CMASK_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_SBFT_SMASK_DUNIT_REG                          0x00000168
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mask ORed with pseudorandom data.  Resets to all 0s  setting bit n to 1 in this
    // register will force every nth bit in the data to be set to 1
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX set_mask : 32;
  } Bits;
  UINTX Data;
} D_CR_SBFT_SMASK_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_SBFT_SEED_DUNIT_REG                           0x0000016C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Seed XORed with address bits to produce pseudorandom data.  Use this to statically
    // produce different pseudorandom data streams for the same set of request addresses.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX seed : 32;
  } Bits;
  UINTX Data;
} D_CR_SBFT_SEED_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_PGCB_CG_IDLE_TIMER_DUNIT_REG                  0x0000017C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This bit enables periodic DQS Retraining  If disabled Dunit will not perform retraining
    // periodically. [br]Note: Will be enabled only if DCO.IC is set and refreshes are
    // enabled in DRFC.MINREFRATE
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX sb_clk_timer : 4;
    //
    // This bit enables LPDDR4 DQS retraining on Self Refresh Exit. If disabled Dunit
    // will not perform retraining on SR exit.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rsvd_7_4 : 4;
    //
    // Reserved
    //
    // Bits[11:8], RO, default = 0x0
    //
    UINTX spid_clk_timer : 4;
    //
    // After Dunit starts DQS oscillator, it must wait this amount of time before being
    // able to read the value in MR18 and MR19. (in 16x DRAM clocks) [br]Value in this
    // register must be at least equal to DRAM's MR23 value.
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rsvd15_12 : 4;
    //
    // Reserved
    //
    // Bits[19:16], RO, default = 0x0
    //
    UINTX saby2_clk_timer : 4;
    //
    // This sets the frequency by which the Dunit  initiates periodic retraining.(in
    // 1x NREFI)
    //
    // Bits[31:20], RW, default = 0x0
    //
    UINTX rsvd31_20 : 12;
  } Bits;
  UINTX Data;
} D_CR_PGCB_CG_IDLE_TIMER_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DQS_RETRAINING_CTL_DUNIT_REG                  0x00000180
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This bit enables periodic DQS Retraining  If disabled Dunit will not perform retraining
    // periodically. [br]Note: Will be enabled only if DCO.IC is set and refreshes are
    // enabled in DRFC.MINREFRATE
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dqs_retrain_en : 1;
    //
    // This bit enables LPDDR4 DQS retraining on Self Refresh Exit. If disabled Dunit
    // will not perform retraining on SR exit.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX dqs_retrain_srx_en : 1;
    //
    // Reserved
    //
    // Bits[3:2], RO, default = 0x0
    //
    UINTX rsvd3_2 : 2;
    //
    // After Dunit starts DQS oscillator, it must wait this amount of time before being
    // able to read the value in MR18 and MR19. (in 16x DRAM clocks) [br]Value in this
    // register must be at least equal to DRAM's MR23 value.
    //
    // Bits[13:4], RW, default = 0x0
    //
    UINTX dqs_osc_rt : 10;
    //
    // Reserved
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX rsvd15_14 : 2;
    //
    // This sets the frequency by which the Dunit  initiates periodic retraining.(in
    // 1x NREFI)
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX dqs_retrain_int : 16;
  } Bits;
  UINTX Data;
} D_CR_DQS_RETRAINING_CTL_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_MR4_DESWIZZLE_DUNIT_REG                       0x00000184
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Selects byte position of the MR4 data
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX mr4_byte_sel : 2;
    //
    // Reserved
    //
    // Bits[3:2], RO, default = 0x0
    //
    UINTX rsvd3_2 : 2;
    //
    // Selects bit 0 of MR4 data
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX mr4_bit0_sel : 3;
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX rsvd7 : 1;
    //
    // Selects bit 1 of MR4 data
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX mr4_bit1_sel : 3;
    //
    // Reserved
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX rsvd11 : 1;
    //
    // Selects bit 2 of MR4 data
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX mr4_bit2_sel : 3;
    //
    // Reserved
    //
    // Bits[31:15], RO, default = 0x0
    //
    UINTX rsvd31_15 : 17;
  } Bits;
  UINTX Data;
} D_CR_MR4_DESWIZZLE_DUNIT_STRUCT;
#endif // ASM_INC

#define D_CR_DRAM_CMD_DATA_DUNIT_REG                       0x00000134
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Complete register for DRAM commands
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} D_CR_DRAM_CMD_DATA_DUNIT_STRUCT;
#endif // ASM_INC

#define PUNIT_TAP_DUNIT_REG                                0x000001F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Idle Bypass Mode Enable: When enabled new page hit/empty read requests will bypass
    // D-unit pipeline stages to save latency 0 - Disable Idle Bypass 1 - Enable Idle
    // Bypass Note: Only applies to WIO2, this bit is reserved for other technologies
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX mrc_to_tap : 32;
  } Bits;
  UINTX Data;
} PUNIT_TAP_DUNIT_STRUCT;
#endif // ASM_INC


#endif // _DUNIT_H_
