/** @file
  File name:    MmrcProjectDefinitionsGenerated.h
  Input File:   BXTM_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in MmrcProjectDefinitions.h, which is used for non-tool-generated
  data

  Includes all hard defines specific to a project. Things like
  the maximum number of channels, ranks, DIMMs, etc, should be included
  here. This file needs to be included by most MMRC components,
  including Mmrc.h.

  @copyright
  Copyright (c) 2005-2016 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by the
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is uniquely
  identified as 'Intel Reference Module' and is licensed for Intel
  CPUs and chipsets under the terms of your license agreement with
  Intel or your vendor. This file may be modified by the user, subject
  to additional terms of the license agreement.

  @par Specification
**/
#ifndef _MMRCPROJECTDEFINITIONSGENERATED_H_
#define _MMRCPROJECTDEFINITIONSGENERATED_H_

//
// All boxtypes supported by the MRC. Boxtypes are distinct components of silicon.
//
#define DUNIT                                              0x00
#define CPGC                                               0x01
#define DQCCC                                              0x02
#define DQ                                                 0x03
#define CCC                                                0x04
#define DPLVUG                                             0x05
#define ADPLL                                              0x06
#define LDO                                                0x07
#define DPIC                                               0x08
#define WIO2PHY                                            0x09
#define BUNIT                                              0x0A
#define PUNIT                                              0x0B
#define MLMC                                               0x0C
#define CUNIT                                              0x0D
#define P2SB                                               0x0E
#define DDRSAI                                             0x0F
#define SAI                                                0x10
#define AUNIT                                              0x11
//
// Maximum Box Types across blueprints
//
#define MAX_BOXES                                          0x12
//
// Maximum IO Levels across blueprints
//
#define MAX_IO_LEVELS                                      0x02
//
// Maximum Box Types for BLUEPRINT_LPDDR3
//
#define BOXES_BLUEPRINT_LPDDR3                             0x12
//
// Maximum Box Types for BLUEPRINT_LPDDR4
//
#define BOXES_BLUEPRINT_LPDDR4                             0x0F
//
// Maximum length of the boxtype strings
//
#define MAX_BOXNAME_LENGTH                                 8
//
// Register access methods (sideband, PCI, etc)
//
#define eSB                                                0
#define ePCI                                               1
#define eBAR                                               2
#define eACCESS_METHOD_ERROR                               3
//
// Maximum number of GetSets Sheets
//
#define MAX_GETSETS                                        2
//
// Maximum number of blueprints
//
#define MAX_BLUEPRINTS                                     2
//
// Number assignments for each blueprint
//
#define BLUEPRINT_LPDDR3                                   0
#define BLUEPRINT_LPDDR4                                   1
//
// Maximum number of Instances
//
#define MAX_INSTANCE_PORTS                                 61
//
// Maximum Instance Ports for BLUEPRINT_LPDDR3
//
#define INSTANCE_PORTS_BLUEPRINT_LPDDR3                    61
//
// Maximum Instance Ports for BLUEPRINT_LPDDR4
//
#define INSTANCE_PORTS_BLUEPRINT_LPDDR4                    48
//
// Maximum string length of all register names and fieldnames.
//
#define MAX_REGISTER_NAME_LENGTH                           0x0036
//
// This project contains 64 bit variables.
//
#define USE_64_BIT_VARIABLES                               1
//
// Channels
//
#define MAX_CHANNELS                                       4
//
// DIMMS Per Channel
//
#define MAX_DIMMS                                          1
//
// Ranks Per Channel
//
#define MAX_RANKS                                          2
//
// Strobelanes Per Module
//
#define MAX_STROBELANES_PER_DQ_MODULE                      2
//
// DQ Modules Per Channel
//
#define MAX_DQ_MODULES                                     5
//
// Width of the entire bus in bits (i.e. 64 for non-ECC and 72 for ECC)
//
#define MAX_BUS_WIDTH                                      72
//
// Max Strobes Per Channel
//
#define MAX_STROBES                                        4
//
// Bytelanes Per Module
//
#define MAX_BYTELANES_PER_DQ_MODULE                        2
//
// Number of Memory Controllers per CPU socket
//
#define MAX_DUNITS                                         4
//
// Max number of ranks for a single DIMM
//
#define MAX_RANKS_PER_DIMM                                 2
//
// Number of commands sent to the DRAMs during JEDEC init.
//
#define MR_COUNT                                           3
//
// Is DDR3 supported on this project?
//
#define DDR3_SUPPORT                                       0
//
// Is DDR4 supported on this project?
//
#define DDR4_SUPPORT                                       0
//
// Is DDRT supported on this project?
//
#define DDRT_SUPPORT                                       0
//
// Is LPDDR3 supported on this project?
//
#define LPDDR3_SUPPORT                                     0
//
// Is LPDDR4 supported on this project?
//
#define LPDDR4_SUPPORT                                     1
//
// Is WIO2 supported on this project?
//
#define WIO2_SUPPORT                                       1
//
// Which version of CPGC is used on this project? AVN = 99, ANN/CHV = 100, BXT = 200
//
#define CPGC_VERSION                                       200
//
// Max Number of values for the Axis Y
//
#define MAX_ELEMENTS_DIM_Y                                 64
//
// Max Number of values for the Axis X
//
#define MAX_ELEMENTS_DIM_X                                 128
//
// If disabled, the MRC codebase being used will supply its own GetSet functions and data structures.
//
#define USE_GET_SET_FROM_SPREADSHEET                       1
//
// Number of memory confiurations supported. For example - if LPDDR3 1600 and LPDDR4 3200 are the only configurations supported, this would be 2.
//
#define MAX_CONFIGS                                        18
//
// Maximum number of DRAM densities supported (i.e 4Gb, 8Gb, 16Gb = 3)
//
#define MAX_DENSITIES                                      5
//
// Number of knobs per algo
//
#define MAX_KNOBS                                          1
//
// Number of DQ per BL
//
#define MAX_BITS                                           8
//
// Command groups per channel.
//
#define MAX_CMDS                                           2
//
// Control Groups Per Channel.
//
#define MAX_CTLS                                           2
//
// Clock Groups Per Channel.
//
#define MAX_CLKS                                           2
//
// Major Version
//
#define VERSION_MAJOR                                      90
//
// Minor Version
//
#define VERSION_MINOR                                      0
//
// Print MRC functions as they execute
//
#define CAPSULESTRINGS                                     0
//
// Use CPGC for training
//
#define CPGC_API                                           1
//
// Lowest address bit for rank selection during training
//
#define RANK_SHIFT_BIT                                     25
//
// Debug message output to serial or console
//
#define DEBUG_MSG                                          1
//
// Enable training algorithms
//
#define TRAINING_ALGOS                                     1
//
// Number of Samples to take for Rcvn/FWL.
//
#define NUMSAMPLES                                         1
//
// Number of consecutive samples to pass for RCVN/FWL.
//
#define SAMPLETHRESH                                       1
//
// Dithering check for stability for RCVN/FWL.
//
#define DITHER                                             5
//
// Receive enable training
//
#define RECEIVE_ENABLE                                     1
//
// Number of 2x for LP3
//
#define RCVN_PREAMBLE_CNTR_LP3                             1
//
// Number of 2x for LP4
//
#define RCVN_PREAMBLE_CNTR_LP4                             2
//
// offset in ps
//
#define RCVN_PREAMBLE_OFFSET_LP3                           550
//
// offset in ps
//
#define RCVN_PREAMBLE_OFFSET_LP4                           0
//
// Starting point for the half clock during receive enable.
//
#define RCVN_INITIAL2XVAL_LP3                              9
//
// Starting point for the half clock during receive enable.
//
#define RCVN_INITIAL2XVAL_LP4                              13
//
// Enable Rank-2-Rank Training for LP3
//
#define RCVN_RANK2RANK_ON_LP3                              0
//
// Enable Rank-2-Rank Training for LP4
//
#define RCVN_RANK2RANK_ON_LP4                              0
//
// Large Step size as percentage of the Half Clock.
//
#define RCVN_LARGE_STEP                                    25
//
// Step size during second phase of receive enable
//
#define RCVN_MEDIUM_STEP                                   5
//
// Step size during final phase of receive enable
//
#define RCVN_SMALL_STEP                                    1
//
// Fine write leveling training
//
#define FINE_WRITE_LEVELING                                1
//
// Enable Rank-2-Rank Training for LP3
//
#define FWL_RANK2RANK_ON_LP3                               0
//
// Enable Rank-2-Rank Training for LP4
//
#define FWL_RANK2RANK_ON_LP4                               0
//
// Large Step size as percentage of the Half Clock.
//
#define FWL_LARGE_STEP                                     25
//
// Step size during second phase of receive enable
//
#define FWL_MEDIUM_STEP                                    5
//
// Step size during final phase of receive enable
//
#define FWL_SMALL_STEP                                     1
//
// Coarse write leveling training
//
#define COARSE_WRITE_LEVELING                              1
//
// Number of cks to push out DQS
//
#define CWL_CLK_PUSHOUT                                    1
//
// Step size for each DQ Testing (LP4)
//
#define CWL_DQ_STEP                                        5
//
// Early Command Training
//
#define EARLY_COMMAND_TRAINING                             1
//
// Vref to perform ECT.
//
#define ECT_LP4_VREF                                       0x60
//
// Width and Height of the search matrix.
//
#define ECT_TILE_WIDTH                                     9
//
// Use CPGC or DRAM_CMD to enter CBT mode (LP3 Only CA-2N Mode)
//
#define ECT_ENTERCBT_CPGC                                  0
//
// Enable the pushout of the CCC flag
//
#define PUSHOUT_CCC                                        1
//
// Pushout by the number of 2x clcoks.
//
#define PUSHOUT_VALUE                                      3
//
// Early Read Training
//
#define EARLY_READ_TRAINING                                1
//
// After finding final edge, amount of dithering to test.
//
#define ERT_DITHER                                         0
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF                                           0xA
//
// Larger step size to find edge.
//
#define ERT_LARGESTEP                                      10
//
// Medium step size to find edge.
//
#define ERT_MEDIUMSTEP                                     5
//
// Small step size to find edge.
//
#define ERT_SMALLSTEP                                      1
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF_LPDDR4                                    0xA
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF_LPDDR3                                    0x1f
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF_DDR3                                      0x1f
//
// Victim/aggressor read training
//
#define READ_TRAINING                                      1
//
// 
//
#define RT_BIT_SHARING                                     RANK_SHARED|KNOB_SHARED|CALCULATE_BIT
//
// 
//
#define RT_BYTE_SHARING                                    BIT_SHARED|RANK_SHARED|KNOB_SHARED
//
// 
//
#define RT_PERBIT_ENABLED                                  0
//
// 
//
#define RT_NUM_EYEMASKS                                    2
//
// 
//
#define RT_EYEMASK0_PI                                     15
//
// 
//
#define MAX_POWER_KNOBS                                    2
//
// 
//
#define RT_EYEMASK_VREF                                    3
//
// 
//
#define RT_EYEMASK1_PI                                     15
//
// 
//
#define RT_STEP1_VREFMIN                                   0
//
// 
//
#define RT_STEP1_VREFMAX                                   63
//
// 
//
#define RT_STEP1_VREFSTEP                                  2
//
// 
//
#define RT_STEP1_VREFSTART_LP4                             0
//
// 
//
#define RT_STEP1_3_PISTEPLARGE                             1
//
// 
//
#define RT_STEP1_3_PISTEPMEDIUM                            0
//
// 
//
#define RT_STEP1_3_PISTEPSMALL                             0
//
// 
//
#define RT_CTLE_MIN                                        0
//
// 
//
#define RT_CTLE_MAX                                        0
//
// 
//
#define RT_CTLE_STEP                                       2
//
// 
//
#define RT_CTLE_ENABLE                                     0
//
// 
//
#define RT_STEP2_VREFMIN                                   0
//
// 
//
#define RT_STEP2_VREFMAX                                   63
//
// 
//
#define RT_STEP2_VREFSTEP                                  5
//
// 
//
#define RT_STEP3_VREFSAMPLES                               3
//
// Pi/VREF center estimate weight
//
#define RT_STEP1_PICENTER_MINWEIGHT                        2
//
// 
//
#define RT_STEP1_PICENTER_MIDWEIGHT                        3
//
// 
//
#define RT_STEP1_PICENTER_MAXWEIGHT                        5
//
// 
//
#define RT_CTLE_SHARED                                     RANK_SHARED|KNOB_SHARED | BIT_SHARED | BIT_CONTROL
//
// 
//
#define RT_STEP2_PISAMPLES                                 3
//
// 
//
#define WRITE_TRAINING                                     1
//
// 
//
#define WT_BIT_SHARING                                     KNOB_SHARED|RANK_SHARED
//
// 
//
#define WT_BYTE_SHARING                                    BIT_SHARED|KNOB_SHARED|RANK_SHARED
//
// 
//
#define WT_NUM_EYEMASKS                                    2
//
// 
//
#define WT_EYEMASK0_PI                                     40
//
// 
//
#define WT_EYEMASK_VREF                                    3
//
// 
//
#define WT_EYEMASK1_PI                                     1
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFMIN_LP4                               100
//
// 10th of percange of VDDQ
//
#define WT_STEP1_VREFSTEP_LP4                              8
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFMAX_LP4                               420
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFSTART_LP4                             420
//
// 
//
#define WT_STEP1_3_PISTEPLARGE                             1
//
// 
//
#define WT_STEP1_3_PISTEPMEDIUM                            0
//
// 
//
#define WT_STEP1_3_PISTEPSMALL                             0
//
// 
//
#define WT_STEP2_VREFMIN                                   400
//
// 
//
#define WT_STEP2_VREFMAX                                   4
//
// 
//
#define WT_STEP2_VREFSTEP_LP4                              421
//
// 
//
#define WT_STEP3_VREFSAMPLES                               3
//
// 
//
#define WT_STEP1_PICENTER_MINWEIGHT                        2
//
// 
//
#define WT_STEP1_PICENTER_MIDWEIGHT                        3
//
// 
//
#define WT_STEP1_PICENTER_MAXWEIGHT                        5
//
// 
//
#define VDDQ                                               1100
//
// 
//
#define LDO_TARGET                                         850
//
// 
//
#define LDO_ENABLED                                        0
//
// 
//
#define RON                                                35
//
// 
//
#define ODT                                                999999
//
// 
//
#define WT_VREFOVERRIDE_VALUE                              37
//
// 
//
#define WT_VREF_OVERRIDE_ENABLE                            1
//
// 
//
#define RTWT_SIM                                           0
//
// 
//
#define VOC_TRAINING                                       1
//
// 
//
#define VOC_LP4_VrefRMin_LDO_ENABLE                        93
//
// 
//
#define VOC_LP4_VrefRMax_LDO_ENABLE                        429
//
// Voltage ; LDO on = LP4 only
//
#define VOC_LP4_VrefRMin_LDO_DISABLE                       93
//
// Voltage ; LDO on = LP4 only
//
#define VOC_LP4_VrefRMax_LDO_DISABLE                       429
//
// Voltage
//
#define VOC_LP3_VrefRMin                                   238
//
// Voltage
//
#define VOC_LP3_VrefRMax                                   742
//
// Voltage
//
#define VOC_DDR3L_VrefRMin                                 238
//
// Voltage
//
#define VOC_DDR3L_VrefRMax                                 742
//
// 
//
#define VOC_Rext                                           81
//
// 
//
#define VOC_VREF_MAX                                       63
//
// 
//
#define VOC_VREF_STEP_SIZE                                 1
//
// 
//
#define VOC_LP4_PullUpRon_LDO_ENABLE                       140
//
// 
//
#define VOC_LP4_PullDnRon_LDO_ENABLE                       40
//
// 
//
#define VOC_LP4_PullUpRon_LDO_DISABLE                      140
//
// 
//
#define VOC_LP4_PullDnRon_LDO_DISABLE                      40
//
// 
//
#define VOC_LP3_PullUpRon                                  40
//
// 
//
#define VOC_LP3_PullDnRon                                  40
//
// 
//
#define VOC_DDR3L_PullUpRon                                40
//
// 
//
#define VOC_DDR3L_PullDnRon                                40
//
// 
//
#define VOC_LP4_SegmentsEnabled_LDO_ENABLE                 2
//
// 
//
#define VOC_LP4_SegmentsEnabled_LDO_DISABLE                2
//
// 
//
#define VOC_LP3_SegmentsEnabled                            2
//
// 
//
#define VOC_DDR3L_SegmentsEnabled                          2
//
// 
//
#define PERIODIC_TRAINING                                  1
//
// Enable RMT Support
//
#define RMT                                                1
//
//  OKAY to DELETE ** set to 0 on release code ** Peter put here just for sim purposes
//
#define RMT_WRITE_CHECKPOINT                               0
//
// default RMT burst length
//
#define RMT_NUMBURSTS                                      13
//
// default RMT loop count
//
#define RMT_LOOPCOUNT                                      8
//
// Loopcount for production RMT test
//
#define RMT_PRODUCTION_LOOPCOUNT                           7
//
// Numbursts for production RMT test
//
#define RMT_PRODUCTION_NUMBURSTS                           13
//
// CPGC RMT Logging Enable
//
#define RMT_BIT_ERROR_LOGGING_ENABLE                       0
//
// max # of retries (w/JEDEC) if fail after RMT test
//
#define POST_RMT_RETRIES                                   5
//
// jump to other training postcode from RMT command loop
//
#define RMT_JUMP_POSTCODES                                 1
//
// 
//
#define RMT_PPV_NUMBURSTS                                  13
//
// 
//
#define RMT_PPV_LOOPCOUNT                                  7
//
// 
//
#define RMT_PER_BIT_MARGIN                                 1
//
// Late command training
//
#define COMMAND_TRAINING                                   1
//
// Test all memory at the end of MRC
//
#define MEMORY_TEST                                        0
//
// Initialize ECC at the end of MRC
//
#define ECC_SCRUB                                          0
//
// Display all DDRIO delays at the end of MRC
//
#define PHYVIEW_TABLE                                      1
//
// Display memory controller timings
//
#define TIMING_TABLE                                       1
//
// Display function calls
//
#define MRC_FLOW                                           0
//
// Enable BDAT table for publishing memory information in ACPI
//
#define BDAT                                               0
//
// Detect DIMMs via SPD reads
//
#define DETECT_DIMMS                                       0
//
// Enable PUNIT communication via mailbox
//
#define PUNIT_MAILBOX                                      0
//
// Use ODT input table from KIT team
//
#define ODT_TABLE                                          0
//
// Are minus 1 selects supported on this project?
//
#define TX_DQS_MINUS1_SUPPORT                              0
//
// Are minus 1 selects supported on this project?
//
#define TX_DQ_MINUS1_SUPPORT                               0
//
// Display register names with dumping
//
#define DUMP_REGISTER_NAMES                                0
//
// Display register fields when dumping registers
//
#define DUMP_REGISTER_FIELDS                               0
//
// Display all descriptions when dumping them
//
#define DUMP_REGISTER_DESCRIPTIONS                         0
//
// Enable to use new receive enable and fine write leveling algos. These save code space.
//
#define SPACE_OPTIMIZED_ALGOS                              1
//
// Min receive VREF
//
#define RX_VREF_MIN                                        0
//
// Max receive VREF
//
#define RX_VREF_MAX                                        30
//
// Receive VREF step
//
#define RX_VREF_STEP                                       3
//
// Min transmit VREF
//
#define TX_VREF_MIN                                        0
//
// Max transmit VREF
//
#define TX_VREF_MAX                                        63
//
// Transmit VREF step
//
#define TX_VREF_STEP                                       3
//
// Enable Stack size reduction by commented out unused variable
//
#define STACK_SIZE_REDUCE_EN                               1
//
// Enable flag internal validation SV Hooks
//
#define MEM_SV_HOOKS                                       0
//
// Minimum allowable pulse width for RCVN and FWL in 1/16 clock increments. i.e. 4 = 1/4 clock.
//
#define MIN_PULSE_WIDTH                                    2
//
// When running Rd/Wr training, use per-bit algo.
//
#define NEW_RTWT_ALGO                                      1
//
// 
//
#define CPGC_BASED_READWRITES                              1
//
// 
//
#define CPGC_BASED_WRITES                                  1
//
// 
//
#define CPGC_BASED_READS                                   0
//
// 
//
#define CPGC_BASE_EARLYREADS                               0
//
// 
//
#define EARLYMPR_1DSWEEP                                   1
//
// 
//
#define RX_PI_MIN_WIDTH                                    20
//
// 
//
#define LDO_TRAINING                                       0
//
// 
//
#define CTLE_MIN                                           0
//
// 
//
#define CTLE_MAX                                           3
//
// 
//
#define CTLE_STEP                                          1
//
// 
//
#define RT_VREF_MIN                                        0
//
// 
//
#define RT_VREF_MAX                                        30
//
// 
//
#define RT_VREF_STEP                                       3
//
// 
//
#define NUM_CONS_MIN_EWS                                   3
//
// 
//
#define NUM_FINAL_VREF_SAMPLES                             7
//
// 
//
#define RX_PI_MIN_EYEWIDTH                                 15
//
// 
//
#define TX_PI_MIN_EYEWIDTH                                 15
//
// When doing VREF Sweep, starting value
//
#define RT_VREF_SWEEPMIN                                   0
//
// 
//
#define RT_VREF_SWEEPMAX                                   30
//
// 
//
#define RT_VREF_SWEEPSTEP                                  5
//
// Pi/VREF center estimate weight
//
#define MIN_WEIGHT                                         2
//
// 
//
#define MID_WEIGHT                                         3
//
// 
//
#define MAX_WEIGHT                                         5
//
// When doing VREF Sweep, starting value
//
#define WT_VREF_SWEEPMIN                                   0
//
// 
//
#define WT_VREF_SWEEPMAX                                   30
//
// 
//
#define WT_VREF_SWEEPSTEP                                  5
//
// When determing Vref Center, number of PI columns
//
#define MAX_PI_SAMPLES                                     3
//
// When determing Pi center, number Vref rows
//
#define NUM_CONS_VREFS                                     3
//
// 
//
#define RX_PI_MIN                                          0
//
// 
//
#define RX_PI_MAX                                          64
//
// 
//
#define RX_PI_STEP                                         1
//
// 
//
#define MAX_PI                                             63
//
// 
//
#define RTWT_SIM                                           0
//
// 
//
#define BXT_PO                                             0
//
// Tile Search Step Size
//
#define ECT_STEP_SIZE                                      5
//
// Tile Search Width
//
#define ECT_TSWIDTH                                        9
//
// Tile Search Shedding Percentage
//
#define ECT_TS_SHEDDING_PERCENT                            50
//
// Tile Search Value Limit for each Loop (To prevent overflowing integers)
//
#define ECT_TS_VAL_LIMIT                                   255
//
// 
//
#define RCVN_PREAM_CLK_SUBTRACT                            3
//
// 
//
#define ENABLE_EV_HOOKS                                    0
//
// Enable or disable debug messages for SetupMaxPi
//
#define MAXPIDLL_DEBUG_PRINT                               0
//
// Does this DDRIO have an analog DLL?
//
#define ANALOG_DLL_SUPPORT_BLUEPRINT_LPDDR3                0
//
// Does this project have a digital DLL?
//
#define DIGITAL_DLL_SUPPORT_BLUEPRINT_LPDDR3               1
//
// Number of delay types which use clock crossings. Sometimes this is 1 in the case of only having a PI delay. Other projects have a coarse and a fine delay, so this would be 2.
//
#define NUM_CC_DEPENDENT_ELEMENTS_BLUEPRINT_LPDDR3         1
//
// Does this DDRIO have an analog DLL?
//
#define ANALOG_DLL_SUPPORT_BLUEPRINT_LPDDR4                0
//
// Does this project have a digital DLL?
//
#define DIGITAL_DLL_SUPPORT_BLUEPRINT_LPDDR4               1
//
// Number of delay types which use clock crossings. Sometimes this is 1 in the case of only having a PI delay. Other projects have a coarse and a fine delay, so this would be 2.
//
#define NUM_CC_DEPENDENT_ELEMENTS_BLUEPRINT_LPDDR4         1
//
// Definitions for register initialization sequence that tell the common MMRC libraries
// how to program a register, whether the offset is 8 or 16 bits, etc.
//
#define xxxxx1xx                                           0x00 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxx1xR                                           0x01 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxx1Sx                                           0x02 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxx1SR                                           0x03 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxx2xx                                           0x04 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxx2xR                                           0x05 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxx2Sx                                           0x06 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxx2SR                                           0x07 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxE1xx                                           0x08 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxE1xR                                           0x09 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxE1Sx                                           0x0A //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxE1SR                                           0x0B //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxE2xx                                           0x0C //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxE2xR                                           0x0D //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxE2Sx                                           0x0E //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxE2SR                                           0x0F //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxMx1xx                                           0x10 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxMx1xR                                           0x11 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxMx1Sx                                           0x12 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxMx1SR                                           0x13 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxMx2xx                                           0x14 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxMx2xR                                           0x15 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxMx2Sx                                           0x16 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxMx2SR                                           0x17 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxME1xx                                           0x18 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxME1xR                                           0x19 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxME1Sx                                           0x1A //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxME1SR                                           0x1B //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxME2xx                                           0x1C //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxME2xR                                           0x1D //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxME2Sx                                           0x1E //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxME2SR                                           0x1F //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxx1xx                                           0x20 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxx1xR                                           0x21 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxx1Sx                                           0x22 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxx1SR                                           0x23 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxx2xx                                           0x24 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxx2xR                                           0x25 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxx2Sx                                           0x26 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxx2SR                                           0x27 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxE1xx                                           0x28 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxE1xR                                           0x29 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxE1Sx                                           0x2A //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxE1SR                                           0x2B //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxE2xx                                           0x2C //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxE2xR                                           0x2D //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxE2Sx                                           0x2E //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxE2SR                                           0x2F //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNMx1xx                                           0x30 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNMx1xR                                           0x31 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNMx1Sx                                           0x32 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNMx1SR                                           0x33 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNMx2xx                                           0x34 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNMx2xR                                           0x35 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNMx2Sx                                           0x36 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNMx2SR                                           0x37 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNME1xx                                           0x38 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNME1xR                                           0x39 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNME1Sx                                           0x3A //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNME1SR                                           0x3B //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNME2xx                                           0x3C //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNME2xR                                           0x3D //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNME2Sx                                           0x3E //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNME2SR                                           0x3F //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxx1xx                                           0x40 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxx1xR                                           0x41 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxx1Sx                                           0x42 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxx1SR                                           0x43 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxx2xx                                           0x44 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxx2xR                                           0x45 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxx2Sx                                           0x46 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxx2SR                                           0x47 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxE1xx                                           0x48 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxE1xR                                           0x49 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxE1Sx                                           0x4A //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxE1SR                                           0x4B //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxE2xx                                           0x4C //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxE2xR                                           0x4D //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxE2Sx                                           0x4E //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxE2SR                                           0x4F //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxMx1xx                                           0x50 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxMx1xR                                           0x51 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxMx1Sx                                           0x52 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxMx1SR                                           0x53 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxMx2xx                                           0x54 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxMx2xR                                           0x55 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxMx2Sx                                           0x56 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxMx2SR                                           0x57 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxME1xx                                           0x58 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxME1xR                                           0x59 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxME1Sx                                           0x5A //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxME1SR                                           0x5B //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxME2xx                                           0x5C //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxME2xR                                           0x5D //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxME2Sx                                           0x5E //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxME2SR                                           0x5F //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxx1xx                                           0x60 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxx1xR                                           0x61 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxx1Sx                                           0x62 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxx1SR                                           0x63 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxx2xx                                           0x64 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxx2xR                                           0x65 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxx2Sx                                           0x66 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxx2SR                                           0x67 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxE1xx                                           0x68 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxE1xR                                           0x69 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxE1Sx                                           0x6A //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxE1SR                                           0x6B //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxE2xx                                           0x6C //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxE2xR                                           0x6D //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxE2Sx                                           0x6E //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxE2SR                                           0x6F //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNMx1xx                                           0x70 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNMx1xR                                           0x71 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNMx1Sx                                           0x72 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNMx1SR                                           0x73 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNMx2xx                                           0x74 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNMx2xR                                           0x75 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNMx2Sx                                           0x76 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNMx2SR                                           0x77 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNME1xx                                           0x78 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNME1xR                                           0x79 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNME1Sx                                           0x7A //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNME1SR                                           0x7B //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNME2xx                                           0x7C //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNME2xR                                           0x7D //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNME2Sx                                           0x7E //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNME2SR                                           0x7F //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define Dxxxx1xx                                           0x80 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define Dxxxx1xR                                           0x81 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define Dxxxx1Sx                                           0x82 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define Dxxxx1SR                                           0x83 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define Dxxxx2xx                                           0x84 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define Dxxxx2xR                                           0x85 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define Dxxxx2Sx                                           0x86 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define Dxxxx2SR                                           0x87 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxxxE1xx                                           0x88 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxxxE1xR                                           0x89 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxxxE1Sx                                           0x8A //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxxxE1SR                                           0x8B //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxxxE2xx                                           0x8C //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxxxE2xR                                           0x8D //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxxxE2Sx                                           0x8E //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxxxE2SR                                           0x8F //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxxMx1xx                                           0x90 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxxMx1xR                                           0x91 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxxMx1Sx                                           0x92 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxxMx1SR                                           0x93 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxxMx2xx                                           0x94 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxxMx2xR                                           0x95 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxxMx2Sx                                           0x96 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxxMx2SR                                           0x97 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxxME1xx                                           0x98 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxxME1xR                                           0x99 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxxME1Sx                                           0x9A //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxxME1SR                                           0x9B //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxxME2xx                                           0x9C //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxxME2xR                                           0x9D //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxxME2Sx                                           0x9E //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxxME2SR                                           0x9F //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxx1xx                                           0xA0 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxx1xR                                           0xA1 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxx1Sx                                           0xA2 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxx1SR                                           0xA3 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxx2xx                                           0xA4 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxx2xR                                           0xA5 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxx2Sx                                           0xA6 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxx2SR                                           0xA7 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxE1xx                                           0xA8 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxE1xR                                           0xA9 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxE1Sx                                           0xAA //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxE1SR                                           0xAB //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxE2xx                                           0xAC //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxE2xR                                           0xAD //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxE2Sx                                           0xAE //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxE2SR                                           0xAF //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNMx1xx                                           0xB0 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNMx1xR                                           0xB1 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNMx1Sx                                           0xB2 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNMx1SR                                           0xB3 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNMx2xx                                           0xB4 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNMx2xR                                           0xB5 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNMx2Sx                                           0xB6 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNMx2SR                                           0xB7 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNME1xx                                           0xB8 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNME1xR                                           0xB9 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNME1Sx                                           0xBA //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNME1SR                                           0xBB //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNME2xx                                           0xBC //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNME2xR                                           0xBD //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNME2Sx                                           0xBE //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNME2SR                                           0xBF //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxx1xx                                           0xC0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxx1xR                                           0xC1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxx1Sx                                           0xC2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxx1SR                                           0xC3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxx2xx                                           0xC4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxx2xR                                           0xC5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxx2Sx                                           0xC6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxx2SR                                           0xC7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxE1xx                                           0xC8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxE1xR                                           0xC9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxE1Sx                                           0xCA //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxE1SR                                           0xCB //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxE2xx                                           0xCC //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxE2xR                                           0xCD //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxE2Sx                                           0xCE //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxE2SR                                           0xCF //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxMx1xx                                           0xD0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxMx1xR                                           0xD1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxMx1Sx                                           0xD2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxMx1SR                                           0xD3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxMx2xx                                           0xD4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxMx2xR                                           0xD5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxMx2Sx                                           0xD6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxMx2SR                                           0xD7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxME1xx                                           0xD8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxME1xR                                           0xD9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxME1Sx                                           0xDA //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxME1SR                                           0xDB //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxME2xx                                           0xDC //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxME2xR                                           0xDD //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxME2Sx                                           0xDE //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxME2SR                                           0xDF //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxx1xx                                           0xE0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxx1xR                                           0xE1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxx1Sx                                           0xE2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxx1SR                                           0xE3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxx2xx                                           0xE4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxx2xR                                           0xE5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxx2Sx                                           0xE6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxx2SR                                           0xE7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxE1xx                                           0xE8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxE1xR                                           0xE9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxE1Sx                                           0xEA //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxE1SR                                           0xEB //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxE2xx                                           0xEC //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxE2xR                                           0xED //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxE2Sx                                           0xEE //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxE2SR                                           0xEF //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNMx1xx                                           0xF0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNMx1xR                                           0xF1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNMx1Sx                                           0xF2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNMx1SR                                           0xF3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNMx2xx                                           0xF4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNMx2xR                                           0xF5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNMx2Sx                                           0xF6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNMx2SR                                           0xF7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNME1xx                                           0xF8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNME1xR                                           0xF9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNME1Sx                                           0xFA //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNME1SR                                           0xFB //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNME2xx                                           0xFC //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNME2xR                                           0xFD //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNME2Sx                                           0xFE //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNME2SR                                           0xFF //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxxxxx                                           0x00 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=FALSE StringPresent=FALSE
#define xxxxxxxS                                           0x01 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=FALSE StringPresent=TRUE
#define xxxxxxIx                                           0x02 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=TRUE StringPresent=FALSE
#define xxxxxxIS                                           0x03 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=TRUE StringPresent=TRUE
#define xxxxxCxx                                           0x04 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=FALSE StringPresent=FALSE
#define xxxxxCxS                                           0x05 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=FALSE StringPresent=TRUE
#define xxxxxCIx                                           0x06 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=TRUE StringPresent=FALSE
#define xxxxxCIS                                           0x07 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=TRUE StringPresent=TRUE
//
// Max number of DLLs supported (analog plus digital).
//
#define MAX_DLL_COUNT                                      1
//
// Number of DLLs supported (analog plus digital) for BLUEPRINT_LPDDR3
//
#define DLL_COUNT_BLUEPRINT_LPDDR3                         1
//
// Number of DLLs supported (analog plus digital) for BLUEPRINT_LPDDR4
//
#define DLL_COUNT_BLUEPRINT_LPDDR4                         1
//
// Max number of registers needed to be cached for the GetSet functions.
//
#define MAX_NUM_CACHE_ELEMENTS                             27
#define MAX_NUM_CACHE_ELEMENTS_PB                          2
#define MAX_NUM_CACHE_ELEMENTS_NON_SR                      24
#define MAX_NUM_CACHE_ELEMENTS_NON_SR_PB                   3
//
// Number of registers needed to be cached for BLUEPRINT_LPDDR3
//
#define NUM_CACHE_ELEMENTS_BLUEPRINT_LPDDR3                0
//
// Number of registers needed to be cached for BLUEPRINT_LPDDR4
//
#define NUM_CACHE_ELEMENTS_BLUEPRINT_LPDDR4                27
//
// Max number of delay types (i.e. receive enable, TX DQS, etc).
//
#define MAX_NUM_ALGOS                                      11
//
// Max number of delay types for BLUEPRINT_LPDDR3
//
#define NUM_ALGOS_BLUEPRINT_LPDDR3                         11
//
// Max number of delay types for BLUEPRINT_LPDDR4
//
#define NUM_ALGOS_BLUEPRINT_LPDDR4                         11
//
// Max number of delay elements per delay type.
//
#define MAX_NUM_DELAY_ELEMENTS                             3
//
// Number of delay elements per delay type for BLUEPRINT_LPDDR3
//
#define NUM_DELAY_ELEMENTS_BLUEPRINT_LPDDR3                3
//
// Number of delay elements per delay type for BLUEPRINT_LPDDR4
//
#define NUM_DELAY_ELEMENTS_BLUEPRINT_LPDDR4                3
//
// Max number of clock crossing (deadband) elements per delay type.
//
#define MAX_NUM_CC_ELEMENTS                                3
//
// Max number of clock crossing (deadband) ranges.
//
#define MAX_NUM_CC_RANGES                                  12
//
// Number of clock crossing (deadband) elements per delay type for BLUEPRINT_LPDDR3
//
#define NUM_CC_ELEMENTS_BLUEPRINT_LPDDR3                   3
//
// Number of clock crossing (deadband) ranges for BLUEPRINT_LPDDR3
//
#define NUM_CC_RANGES_BLUEPRINT_LPDDR3                     12
//
// Number of clock crossing (deadband) elements per delay type for BLUEPRINT_LPDDR4
//
#define NUM_CC_ELEMENTS_BLUEPRINT_LPDDR4                   3
//
// Number of clock crossing (deadband) ranges for BLUEPRINT_LPDDR4
//
#define NUM_CC_RANGES_BLUEPRINT_LPDDR4                     12
//
// Max number of elements (delay and CC) per delay type.
//
#define MAX_NUM_ELEMENTS_PER_ALGO                          6
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_LPDDR3
//
#define NUM_ELEMENTS_PER_ALGO_BLUEPRINT_LPDDR3             6
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_LPDDR4
//
#define NUM_ELEMENTS_PER_ALGO_BLUEPRINT_LPDDR4             6
//
// Max number of elements in the Signal Info Array
//
#define MAX_SIGNAL_INFO_ELEMENTS                           53
//
// Number of elements in the Signal Info Array for BLUEPRINT_LPDDR3
//
#define SIGNAL_INFO_ELEMENTS_BLUEPRINT_LPDDR3              36
//
// Number of elements in the Signal Info Array for BLUEPRINT_LPDDR4
//
#define SIGNAL_INFO_ELEMENTS_BLUEPRINT_LPDDR4              53
//
// Max number of frequencies supported by DVFS (dynamic voltage and frequency scaling).
//
#define MAX_NUM_DVFS                                       1
//
// Number of frequencies supported by DVFS (dynamic voltage and frequency scaling) for BLUEPRINT_LPDDR3
//
#define NUM_DVFS_BLUEPRINT_LPDDR3                          1
//
// Number of frequencies supported by DVFS (dynamic voltage and frequency scaling) for BLUEPRINT_LPDDR4
//
#define NUM_DVFS_BLUEPRINT_LPDDR4                          1
//
// Indices of each delay type.
//
#define TxDqDelay_Actual                                   0x3000
#define MmrcTxDqsDelay                                     0x3001
#define MmrcCkGrp0                                         0x3002
#define MmrcCkGrp1                                         0x3003
#define MmrcCmdGrp0                                        0x3004
#define MmrcCmdGrp1                                        0x3005
#define MmrcCtlGrp0                                        0x3006
#define MmrcCtlGrp1                                        0x3007
#define MmrcRecEnDelay                                     0x3008
#define MmrcRxDqsNDelay                                    0x3009
#define MmrcRxDqsPDelay                                    0x300A
//
// Indices of each delay type for BLUEPRINT_LPDDR3
//
#define TxDqDelay_Actual_BLUEPRINT_LPDDR3                  0x1000
#define TxDqsDelay_BLUEPRINT_LPDDR3                        0x1001
#define CkGrp0_BLUEPRINT_LPDDR3                            0x1002
#define CkGrp1_BLUEPRINT_LPDDR3                            0x1003
#define CmdGrp0_BLUEPRINT_LPDDR3                           0x1004
#define CmdGrp1_BLUEPRINT_LPDDR3                           0x1005
#define CtlGrp0_BLUEPRINT_LPDDR3                           0x1006
#define CtlGrp1_BLUEPRINT_LPDDR3                           0x1007
#define RecEnDelay_BLUEPRINT_LPDDR3                        0x1008
#define RxDqsNDelay_BLUEPRINT_LPDDR3                       0x1009
#define RxDqsPDelay_BLUEPRINT_LPDDR3                       0x100A
//
// Indices of each delay type for BLUEPRINT_LPDDR4
//
#define TxDqDelay_Actual_BLUEPRINT_LPDDR4                  0x1000
#define TxDqsDelay_BLUEPRINT_LPDDR4                        0x1001
#define CkGrp0_BLUEPRINT_LPDDR4                            0x1002
#define CkGrp1_BLUEPRINT_LPDDR4                            0x1003
#define CmdGrp0_BLUEPRINT_LPDDR4                           0x1004
#define CmdGrp1_BLUEPRINT_LPDDR4                           0x1005
#define CtlGrp0_BLUEPRINT_LPDDR4                           0x1006
#define CtlGrp1_BLUEPRINT_LPDDR4                           0x1007
#define RecEnDelay_BLUEPRINT_LPDDR4                        0x1008
#define RxDqsNDelay_BLUEPRINT_LPDDR4                       0x1009
#define RxDqsPDelay_BLUEPRINT_LPDDR4                       0x100A
//
// These are signal groups. Subtract 0x4000 from each to get the right index for each group.
//
#define MmrcCkAll                                          0x4000
#define MmrcCmdAll                                         0x4001
#define MmrcCtlAll                                         0x4002
#define R                                                  0x4003
#define MmrcRxDqsDelay                                     0x4004
//
// Max number of group signals
//
#define MAX_NUM_GROUP                                      5
//
// These are signal groups. Subtract 0x1000 from each to get the first delay type in each group for BLUEPRINT_LPDDR3
//
#define CkAll_BLUEPRINT_LPDDR3                             0x2002
#define CmdAll_BLUEPRINT_LPDDR3                            0x2004
#define CtlAll_BLUEPRINT_LPDDR3                            0x2006
#define R_BLUEPRINT_LPDDR3                                 0x2008
#define RxDqsDelay_BLUEPRINT_LPDDR3                        0x2009
//
// These are signal groups. Subtract 0x1000 from each to get the first delay type in each group for BLUEPRINT_LPDDR4
//
#define CkAll_BLUEPRINT_LPDDR4                             0x2002
#define CmdAll_BLUEPRINT_LPDDR4                            0x2004
#define CtlAll_BLUEPRINT_LPDDR4                            0x2006
#define R_BLUEPRINT_LPDDR4                                 0x2008
#define RxDqsDelay_BLUEPRINT_LPDDR4                        0x2009
//
// Index for unique get/set calls which aren't tied to a particular delay/cc type.
//
#define Ctle                                               0x5000
#define Ctle_Cap                                           0x5001
#define Ctle_Res                                           0x5002
#define DQS_CNT_RESET                                      0x5003
#define FifoReset                                          0x5004
#define Grp6_2x                                            0x5005
#define PerCompSmp                                         0x5006
#define RecEnSmp                                           0x5007
#define MmrcRxDqBitDelay                                   0x5008
#define RxOdtOvr                                           0x5009
#define RxOdtVal                                           0x500A
#define RxVocEnDq                                          0x500B
#define RxVocEnDqs                                         0x500C
#define RxVocVal                                           0x500D
#define MmrcRxVref                                         0x500E
#define MmrcTxDqBitDelay                                   0x500F
#define MmrcTxDqDelay                                      0x5010
#define MmrcTxVref                                         0x5011
#define WR_LVL_MODE                                        0x5012
#define WR_LVL_MODE_C                                      0x5013
#define WrLvlSmp                                           0x5014
#define RxDiffampOvrDq                                     0x5015
#define RxDiffampOvrDqs                                    0x5016
#define RxDiffampValDq                                     0x5017
#define RxDiffampValDqs                                    0x5018
#define CkeAll                                             0x5019
#define CURRENT_INDEX                                      0x501A
#define DiffampOff                                         0x501B
#define INITIAL_INDEX                                      0x501C
#define MuxcodeMax                                         0x501D
#define MuxcodeMin                                         0x501E
#define OdtEnOff                                           0x501F
#define OdtSegEnOff                                        0x5020
#define RxVocSmp                                           0x5021
#define MmrcTxCaVref                                       0x5022
#define WrPtrEn                                            0x5023
#define RxVocVal0                                          0x5024
#define RxVocVal1                                          0x5025
#define RxVocVal2                                          0x5026
#define RxVocVal3                                          0x5027
#define RxVocVal4                                          0x5028
#define RxVocVal5                                          0x5029
#define RxVocVal6                                          0x502A
#define RxVocVal7                                          0x502B
//
// Max number of unique signals
//
#define MAX_NUM_UNIQUE                                     44
//
// Index for unique get/set calls which aren't tied to a particular delay/cc type for BLUEPRINT_LPDDR3
//
#define Ctle_BLUEPRINT_LPDDR3                              66
#define Ctle_Cap_BLUEPRINT_LPDDR3                          67
#define Ctle_Res_BLUEPRINT_LPDDR3                          68
#define DQS_CNT_RESET_BLUEPRINT_LPDDR3                     69
#define FifoReset_BLUEPRINT_LPDDR3                         70
#define Grp6_2x_BLUEPRINT_LPDDR3                           71
#define PerCompSmp_BLUEPRINT_LPDDR3                        72
#define RecEnSmp_BLUEPRINT_LPDDR3                          73
#define RxDqBitDelay_BLUEPRINT_LPDDR3                      74
#define RxOdtOvr_BLUEPRINT_LPDDR3                          75
#define RxOdtVal_BLUEPRINT_LPDDR3                          76
#define RxVocEnDq_BLUEPRINT_LPDDR3                         77
#define RxVocEnDqs_BLUEPRINT_LPDDR3                        78
#define RxVocVal_BLUEPRINT_LPDDR3                          79
#define RxVref_BLUEPRINT_LPDDR3                            80
#define TxDqBitDelay_BLUEPRINT_LPDDR3                      81
#define TxDqDelay_BLUEPRINT_LPDDR3                         82
#define TxVref_BLUEPRINT_LPDDR3                            83
#define WR_LVL_MODE_BLUEPRINT_LPDDR3                       84
#define WR_LVL_MODE_C_BLUEPRINT_LPDDR3                     85
#define WrLvlSmp_BLUEPRINT_LPDDR3                          86
#define RxDiffampOvrDq_BLUEPRINT_LPDDR3                    87
#define RxDiffampOvrDqs_BLUEPRINT_LPDDR3                   88
#define RxDiffampValDq_BLUEPRINT_LPDDR3                    89
#define RxDiffampValDqs_BLUEPRINT_LPDDR3                   90
//
// Index for unique get/set calls which aren't tied to a particular delay/cc type for BLUEPRINT_LPDDR4
//
#define CkeAll_BLUEPRINT_LPDDR4                            66
#define Ctle_BLUEPRINT_LPDDR4                              67
#define Ctle_Cap_BLUEPRINT_LPDDR4                          68
#define Ctle_Res_BLUEPRINT_LPDDR4                          69
#define CURRENT_INDEX_BLUEPRINT_LPDDR4                     70
#define DiffampOff_BLUEPRINT_LPDDR4                        71
#define DQS_CNT_RESET_BLUEPRINT_LPDDR4                     72
#define FifoReset_BLUEPRINT_LPDDR4                         73
#define Grp6_2x_BLUEPRINT_LPDDR4                           74
#define INITIAL_INDEX_BLUEPRINT_LPDDR4                     75
#define MuxcodeMax_BLUEPRINT_LPDDR4                        76
#define MuxcodeMin_BLUEPRINT_LPDDR4                        77
#define OdtEnOff_BLUEPRINT_LPDDR4                          78
#define OdtSegEnOff_BLUEPRINT_LPDDR4                       79
#define RecEnSmp_BLUEPRINT_LPDDR4                          80
#define RxDqBitDelay_BLUEPRINT_LPDDR4                      81
#define RxOdtOvr_BLUEPRINT_LPDDR4                          82
#define RxOdtVal_BLUEPRINT_LPDDR4                          83
#define RxVocEnDq_BLUEPRINT_LPDDR4                         84
#define RxVocEnDqs_BLUEPRINT_LPDDR4                        85
#define RxVocSmp_BLUEPRINT_LPDDR4                          86
#define RxVref_BLUEPRINT_LPDDR4                            87
#define TxCaVref_BLUEPRINT_LPDDR4                          88
#define TxDqBitDelay_BLUEPRINT_LPDDR4                      89
#define TxDqDelay_BLUEPRINT_LPDDR4                         90
#define TxVref_BLUEPRINT_LPDDR4                            91
#define WR_LVL_MODE_BLUEPRINT_LPDDR4                       92
#define WR_LVL_MODE_C_BLUEPRINT_LPDDR4                     93
#define WrLvlSmp_BLUEPRINT_LPDDR4                          94
#define WrPtrEn_BLUEPRINT_LPDDR4                           95
#define RxDiffampOvrDq_BLUEPRINT_LPDDR4                    96
#define RxDiffampOvrDqs_BLUEPRINT_LPDDR4                   97
#define RxDiffampValDq_BLUEPRINT_LPDDR4                    98
#define RxDiffampValDqs_BLUEPRINT_LPDDR4                   99
#define RxVocVal0_BLUEPRINT_LPDDR4                         100
#define RxVocVal1_BLUEPRINT_LPDDR4                         101
#define RxVocVal2_BLUEPRINT_LPDDR4                         102
#define RxVocVal3_BLUEPRINT_LPDDR4                         103
#define RxVocVal4_BLUEPRINT_LPDDR4                         104
#define RxVocVal5_BLUEPRINT_LPDDR4                         105
#define RxVocVal6_BLUEPRINT_LPDDR4                         106
#define RxVocVal7_BLUEPRINT_LPDDR4                         107
//
// External functions that need to be called for GetSet elements which require and external function to read/write the element.
//
#define TxDqBitDelay_FUNC                                  0
#define TxDqDelay_FUNC                                     1
#define TxVref_FUNC                                        2
#define TxCaVref_FUNC                                      3
//
// External functions for BLUEPRINT_LPDDR3
//
#define TxDqBitDelay_FUNC_BLUEPRINT_LPDDR3                 0
#define TxDqDelay_FUNC_BLUEPRINT_LPDDR3                    1
#define TxVref_FUNC_BLUEPRINT_LPDDR3                       2
//
// External functions for BLUEPRINT_LPDDR4
//
#define TxCaVref_FUNC_BLUEPRINT_LPDDR4                     0
#define TxDqBitDelay_FUNC_BLUEPRINT_LPDDR4                 1
#define TxDqDelay_FUNC_BLUEPRINT_LPDDR4                    2
#define TxVref_FUNC_BLUEPRINT_LPDDR4                       3
//
// Max number of elements (delay and CC) per delay type.
//
#define MAX_NUM_ELEMENTS                                   108
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_LPDDR3
//
#define NUM_ELEMENTS_BLUEPRINT_LPDDR3                      91
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_LPDDR4
//
#define NUM_ELEMENTS_BLUEPRINT_LPDDR4                      108
//
// Total different PFCT variations supported by this project.
//
#define NUM_PLAT                                           3
#define NUM_FREQ                                           10
#define NUM_CONF                                           2
#define NUM_TYPE                                           4
//
// Macros for converting PFCT combinations from the generated tool output into correct bitmasks for the Init sequence.
//
#define P(p)                                               CONV1(p)
#define F(f)                                               CONV2(f)
#define C(c)                                               CONV1(c)
#define T(t)                                               CONV1(t)
#define PF(p,f)                                            CONV2((((p) << NUM_FREQ) + (f)))
#define PT(p,t)                                            CONV1((((p) << NUM_TYPE) + (t)))
#define PC(p,c)                                            CONV1((((p) << NUM_CONF) + (c)))
#define FT(f,t)                                            CONV2((((f) << NUM_TYPE) + (t)))
#define FC(f,c)                                            CONV2((((f) << NUM_CONF) + (c)))
#define CT(c,t)                                            CONV1((((c) << NUM_TYPE) + (t)))
#define PFT(p,f,t)                                         CONV3((((p) << (NUM_FREQ + NUM_TYPE)) + ((f) << NUM_TYPE) + (t)))
#define PFC(p,f,c)                                         CONV2((((p) << (NUM_FREQ + NUM_CONF)) + ((f) << NUM_CONF) + (c)))
#define PCT(p,c,t)                                         CONV2((((p) << (NUM_CONF + NUM_TYPE)) + ((c) << NUM_TYPE) + (t)))
#define FCT(f,c,t)                                         CONV2((((f) << (NUM_CONF + NUM_TYPE)) + ((c) << NUM_TYPE) + (t)))
#define PFCT(p,f,c,t)                                      CONV3((((p) << (NUM_FREQ + NUM_CONF + NUM_TYPE)) + ((f) << (NUM_CONF + NUM_TYPE)) + ((c) << NUM_TYPE) + (t)))
//
// Supported Platforms
//
#define P_NONE                                             0
#define P_SIM                                              BIT0
#define P_EMU                                              BIT1
#define P_SIL                                              BIT2
#define P_ALL                                              0xFFFF
//
// Supported Frequencies
//
#define F_NONE                                             0
#define F_800                                              BIT0
#define F_1066                                             BIT1
#define F_1333                                             BIT2
#define F_1600                                             BIT3
#define F_1866                                             BIT4
#define F_2133                                             BIT5
#define F_2400                                             BIT6
#define F_2667                                             BIT7
#define F_3200                                             BIT8
#define F_2933                                             BIT9
#define F_ALL                                              0xFFFF
//
// Supported Configurations
//
#define C_NONE                                             0
#define C_PO                                               BIT0
#define C_POR                                              BIT1
#define C_ALL                                              0xFFFF
//
// Supported Types
//
#define T_NONE                                             0
#define T_LPDDR3                                           BIT0
#define T_LPDDR4                                           BIT1
#define T_DDR3L                                            BIT2
#define T_WIO2                                             BIT3
#define T_ALL                                              0xFFFF
//
// Supported Boot Paths
//
#define S0                                                 BIT0
#define S0W                                                BIT1
#define S0C                                                BIT2
#define S5                                                 BIT3
#define FB                                                 BIT4
#define S3                                                 BIT5
#define EM                                                 BIT6
#define CSE                                                BIT7
#define RS                                                 BIT8
#define A0                                                 BIT9
#define ALL_PATHS                                          0xFF
//
// Max number of subtasks
//
#define MAX_SUBTASKS                                       2

//
// All possible actions for the init phase of MMRC.
//
#define SET                                                0
#define DELAY                                              1
#define SET_DELAY                                          2
#define FORCE_SET                                          3
#define POLL                                               4
#define GET                                                5
#define SUBTASK                                            6
#define ACTION_ERROR                                       7
//
// Offsets into InitData[] for each init block. Total size = 10781 bytes.
//
#define InitPunit                                          0
#define PollPunit                                          (InitPunit + 8)
#define modmem_init_lpddrgrp1xm_seq                        (PollPunit + 15)
#define modmem_init_lpddrgrp1p5_seq                        (modmem_init_lpddrgrp1xm_seq + 217)
#define modmem_init_lpddrgrp2m_seq                         (modmem_init_lpddrgrp1p5_seq + 383)
#define Wake_Chassis                                       (modmem_init_lpddrgrp2m_seq + 309)
#define modmem_init_lpddrgrp3m_seq                         (Wake_Chassis + 19)
#define modmem_init_lpddrgrp3_seq                          (modmem_init_lpddrgrp3m_seq + 306)
#define modmem_init_lpddrgrp3p75_seq                       (modmem_init_lpddrgrp3_seq + 1258)
#define modmem_init_lpddrgrp4m_seq                         (modmem_init_lpddrgrp3p75_seq + 15)
#define modmem_ldo_offsetcomp_seq                          (modmem_init_lpddrgrp4m_seq + 17)
#define modmem_init_lpddrgrp2p5_seq                        (modmem_ldo_offsetcomp_seq + 9)
#define modmem_ldo_offsetcomp_poll                         (modmem_init_lpddrgrp2p5_seq + 61)
#define modmem_init_lpddrgrp4_seq                          (modmem_ldo_offsetcomp_poll + 1)
#define modmem_init_lpddrgrp4p5_seq                        (modmem_init_lpddrgrp4_seq + 57)
#define modmem_init_lpddrgrp5m_seq                         (modmem_init_lpddrgrp4p5_seq + 11)
#define modmem_init_lpddrgrp5_seq                          (modmem_init_lpddrgrp5m_seq + 173)
#define modmem_init_lpddrgrp5p25_seq                       (modmem_init_lpddrgrp5_seq + 60)
#define modmem_init_lpddrgrp5p5m_seq                       (modmem_init_lpddrgrp5p25_seq + 81)
#define PhyConfigComplete                                  (modmem_init_lpddrgrp5p5m_seq + 280)
#define MRC_to_Tap_step32                                  (PhyConfigComplete + 8)
#define modmem_init_lpddrgrp5p5_seq                        (MRC_to_Tap_step32 + 10)
#define modmem_init_lpddrgrp5p5_seq1                       (modmem_init_lpddrgrp5p5_seq + 8)
#define modmem_init_lpddrgrp6_seq                          (modmem_init_lpddrgrp5p5_seq1 + 15)
#define modmem_init_lpddrgrp6p5_seq                        (modmem_init_lpddrgrp6_seq + 14)
#define modmem_init_lpddrgrp7_seq                          (modmem_init_lpddrgrp6p5_seq + 21)
#define modmem_init_lpddrgrp7p5_seq                        (modmem_init_lpddrgrp7_seq + 38)
#define modmem_init_lpddrgrp7p75_seq                       (modmem_init_lpddrgrp7p5_seq + 21)
#define modmem_init_lpddrgrp8m_seq                         (modmem_init_lpddrgrp7p75_seq + 186)
#define modmem_init_lpddrgrp8m_not_seq                     (modmem_init_lpddrgrp8m_seq + 65)
#define lp4_txdll_ovr_seq                                  (modmem_init_lpddrgrp8m_not_seq + 25)
#define lp4_rxdll_ovr_seq                                  (lp4_txdll_ovr_seq + 63)
#define lp4_rcomp_ovr_seq                                  (lp4_rxdll_ovr_seq + 43)
#define lp4_txdlycomp_ovr_seq                              (lp4_rcomp_ovr_seq + 57)
#define MRC_to_Tap_step53p5                                (lp4_txdlycomp_ovr_seq + 81)
#define DunitResetComplete                                 (MRC_to_Tap_step53p5 + 10)
#define modmem_init_lpddrgrp0_seq                          (DunitResetComplete + 8)
#define modmem_init_lpddrgrp10m_seq                        (modmem_init_lpddrgrp0_seq + 9)
#define InitDunit                                          (modmem_init_lpddrgrp10m_seq + 7)
#define modmem_init_dramreset_seq_sim                      (InitDunit + 156)
#define modmem_init_dramreset_seq                          (modmem_init_dramreset_seq_sim + 45)
#define InitDunitWake                                      (modmem_init_dramreset_seq + 45)
#define PrepareForTraining                                 (InitDunitWake + 25)
#define DIFF_AMP_OVERRIDE                                  (PrepareForTraining + 43)
#define DQ_DB_REGION_PROGRAM                               (DIFF_AMP_OVERRIDE + 69)
#define HandlePostTraining                                 (DQ_DB_REGION_PROGRAM + 25)
#define DIFF_AMP_RESTORE                                   (HandlePostTraining + 1)
#define TrainingDone                                       (DIFF_AMP_RESTORE + 13)
#define ProgamFinalSettings                                (TrainingDone + 31)
#define ProgamFinalSettingsS0                              (ProgamFinalSettings + 446)
#define modmem_init_lpddrgrp11m_seq                        (ProgamFinalSettingsS0 + 15)
#define modmem_init_lpddrgrp11_seq                         (modmem_init_lpddrgrp11m_seq + 120)
#define modmem_init_lpddrgrp12m_seq                        (modmem_init_lpddrgrp11_seq + 23)
#define CPGCModeComplete                                   (modmem_init_lpddrgrp12m_seq + 16)
#define SetBGFRun                                          (CPGCModeComplete + 8)
#define SetMrcDone                                         (SetBGFRun + 31)
#define EXESDTInit                                         (SetMrcDone + 15)
#define SetMLMC                                            (EXESDTInit + 8)
#define SetPunitMemDone                                    (SetMLMC + 23)
#define TEST                                               (SetPunitMemDone + 8)
#define CPGC_ONE_TIME_INIT                                 (TEST + 7)
#define SET_REF2XPH                                        (CPGC_ONE_TIME_INIT + 531)
#define CPGC_SETUP_ERT                                     (SET_REF2XPH + 27)
#define CPGC_EXIT_ERT                                      (CPGC_SETUP_ERT + 14)
#define CPGC_RUN_DIRECT                                    (CPGC_EXIT_ERT + 36)
#define SEND_DRAM_CMD                                      (CPGC_RUN_DIRECT + 34)
#define CPGC_CHECK_ERRORS                                  (SEND_DRAM_CMD + 8)
#define CPGC_SETUP_DPAT0                                   (CPGC_CHECK_ERRORS + 8)
#define CPGC_RUN_TEST                                      (CPGC_SETUP_DPAT0 + 8)
#define CPGC_ENABLE                                        (CPGC_RUN_TEST + 64)
#define CPGC_RUN_TEST_OE                                   (CPGC_ENABLE + 32)
#define CPGC_RESETUP_WRITE_ONLY                            (CPGC_RUN_TEST_OE + 111)
#define CPGC_RESETUP_READ_ONLY                             (CPGC_RESETUP_WRITE_ONLY + 32)
#define CPGC_RESETUP_WRITE_READ                            (CPGC_RESETUP_READ_ONLY + 26)
#define FINEWRITELEVEL_ENTRYa                              (CPGC_RESETUP_WRITE_READ + 44)
#define CPGC_DISABLE                                       (FINEWRITELEVEL_ENTRYa + 9)
#define WRLVLMODE                                          (CPGC_DISABLE + 19)
#define CPGC_SETUP_VA                                      (WRLVLMODE + 13)
#define CPGC_LOOPS                                         (CPGC_SETUP_VA + 153)
#define ENTER_CA_TRAINING                                  (CPGC_LOOPS + 13)
#define ENTER_CA_TRAININGa                                 (ENTER_CA_TRAINING + 225)
#define DRIVE_CKE                                          (ENTER_CA_TRAININGa + 34)
#define CPGC_STOP_TEST                                     (DRIVE_CKE + 7)
#define DQCALRD                                            (CPGC_STOP_TEST + 23)
#define ENABLE_CKE_OVERRIDE                                (DQCALRD + 7)
#define EXIT_CA_TRAINING                                   (ENABLE_CKE_OVERRIDE + 7)
#define EXIT_CA_TRAININGa                                  (EXIT_CA_TRAINING + 105)
#define CPGC_CA_VREF_EXIT                                  (EXIT_CA_TRAININGa + 9)
#define PRECHARGEALL                                       (CPGC_CA_VREF_EXIT + 21)
#define CPGC_TARGET_BANK                                   (PRECHARGEALL + 22)
#define CPGC_FIXVAR                                        (CPGC_TARGET_BANK + 14)
#define CPGC_FIXVAR_REVERT                                 (CPGC_FIXVAR + 14)
#define CPGC_MRS                                           (CPGC_FIXVAR_REVERT + 27)
#define CPGC_CA_TRAIN_DIS                                  (CPGC_MRS + 158)
#define CPGC_CA_TRAIN_EXIT                                 (CPGC_CA_TRAIN_DIS + 35)
#define CPGC_RUN                                           (CPGC_CA_TRAIN_EXIT + 15)
#define CPGC_CADB1                                         (CPGC_RUN + 31)
#define CPGC_CADB1_DIS                                     (CPGC_CADB1 + 276)
#define CPGC_DESELECT_DIS                                  (CPGC_CADB1_DIS + 22)
#define CPGC_DESELECT_EN                                   (CPGC_DESELECT_DIS + 69)
#define CPGC_CADB1_BUFA                                    (CPGC_DESELECT_EN + 47)
#define CPGC_CADB1_BUFB                                    (CPGC_CADB1_BUFA + 57)
#define CPGC_CWL_PATTERN                                   (CPGC_CADB1_BUFB + 57)
#define LP4_FREQ_SWITCH                                    (CPGC_CWL_PATTERN + 15)
#define RCVEN_Copy                                         (LP4_FREQ_SWITCH + 1)
#define CPGC_EXIT_MRS                                      (RCVEN_Copy + 14)
#define RMT_CLEAR_REGISTERS                                (CPGC_EXIT_MRS + 15)
#define RMT_GET_CMD_AND_VALUE                              (RMT_CLEAR_REGISTERS + 8)
#define ConnectPmiToCpgc                                   (RMT_GET_CMD_AND_VALUE + 8)
#define CPGC_SETUP_LVL                                     (ConnectPmiToCpgc + 8)
#define CPGC_MPR_TRAINING                                  (CPGC_SETUP_LVL + 8)
#define CPGC_RUNTEST_PARALLEL_CLEAR                        (CPGC_MPR_TRAINING + 8)
#define CPGC_RUNTEST_PARALLEL_CHECK                        (CPGC_RUNTEST_PARALLEL_CLEAR + 8)
#define CPGC_CADB_MODE                                     (CPGC_RUNTEST_PARALLEL_CHECK + 8)
#define CPGC_RESETUP_TRAFFIC                               (CPGC_CADB_MODE + 29)
#define CPGC_DPAT_MODE                                     (CPGC_RESETUP_TRAFFIC + 19)
#define CPGC_LDO_CADB                                      (CPGC_DPAT_MODE + 22)
#define CPGC_LDO_DPAT                                      (CPGC_LDO_CADB + 89)
#define CPGC_LDO_CADB_LFSR                                 (CPGC_LDO_DPAT + 97)
#define CPGC_LDO_DPAT_LFSR                                 (CPGC_LDO_CADB_LFSR + 89)
#define CPGC_RUN_TEST_L                                    (CPGC_LDO_DPAT_LFSR + 97)
#define PERIODIC_TRAINING_START                            (CPGC_RUN_TEST_L + 180)
#define PERIODIC_TRAINING_READ                             (PERIODIC_TRAINING_START + 129)
#define PERIODIC_TRAINING_MNT_DIS                          (PERIODIC_TRAINING_READ + 14)
#define PERIODIC_TRAINING_EN                               (PERIODIC_TRAINING_MNT_DIS + 58)
#define RCVEN_ENTRY                                        (PERIODIC_TRAINING_EN + 19)
#define RCVEN_EXIT                                         (RCVEN_ENTRY + 43)
#define CPGC_INIT                                          (RCVEN_EXIT + 13)
#define CPGC_UNI_LFSR_VICTIM_AGGRESSOR                     (CPGC_INIT + 1)
#define CPGC_SETUP_VICTIM_AGGRESOR                         (CPGC_UNI_LFSR_VICTIM_AGGRESSOR + 1)
#define CPGC_SETUP_ECC_INIT                                (CPGC_SETUP_VICTIM_AGGRESOR + 1)
#define CPGC_SETUP_MEMINIT_AND_TEST                        (CPGC_SETUP_ECC_INIT + 1)
#define CPGC_SETUP_2D_SWEEP                                (CPGC_SETUP_MEMINIT_AND_TEST + 1)
#define CPGC_SETUP_MPR_TRAINING                            (CPGC_SETUP_2D_SWEEP + 1)
#define CPGC_RUNTEST                                       (CPGC_SETUP_MPR_TRAINING + 1)
#define CPGC_CLEAR_ERRORS                                  (CPGC_RUNTEST + 1)
#define RECEIVE_ENABLE_EXITx                               (CPGC_CLEAR_ERRORS + 1)
#define FINEWRITELEVEL_ENTRY                               (RECEIVE_ENABLE_EXITx + 26)
#define FINEWRITELEVEL_EXIT                                (FINEWRITELEVEL_ENTRY + 14)
#define FORCEODT_ON                                        (FINEWRITELEVEL_EXIT + 14)
#define FORCEODT_OFF                                       (FORCEODT_ON + 1)
#define FORCEODT_REL                                       (FORCEODT_OFF + 1)
#define COARSEWRITELEVEL_ENTRY                             (FORCEODT_REL + 1)
#define COARSEWRITELEVEL_EXIT                              (COARSEWRITELEVEL_ENTRY + 1)
#define EARLY_READ_TRAINING_ENTRY                          (COARSEWRITELEVEL_EXIT + 1)
#define EARLY_READ_TRAINING_EXIT                           (EARLY_READ_TRAINING_ENTRY + 1)
#define ENABLE_MPR_MODE                                    (EARLY_READ_TRAINING_EXIT + 1)
#define DISABLE_MPR_MODE                                   (ENABLE_MPR_MODE + 1)
#define READTRAINING_ENTRY                                 (DISABLE_MPR_MODE + 1)
#define READTRAINING_EXIT                                  (READTRAINING_ENTRY + 15)
#define WRITETRAINING_ENTRY                                (READTRAINING_EXIT + 14)
#define WRITETRAINING_EXIT                                 (WRITETRAINING_ENTRY + 1)
#define COMMANDCLOCKTRAINING_ENTRY                         (WRITETRAINING_EXIT + 1)
#define COMMANDCLOCKTRAINING_EXIT                          (COMMANDCLOCKTRAINING_ENTRY + 1)
#define CPGCSETUPFORCMD                                    (COMMANDCLOCKTRAINING_EXIT + 1)
#define CPGCSETUPCADB                                      (CPGCSETUPFORCMD + 1)
#define RESETDRAMS                                         (CPGCSETUPCADB + 1)
#define CPGC_RUNTEST_PARALLEL                              (RESETDRAMS + 1)
#define CPGC_CHECK_ERR_PARALLEL                            (CPGC_RUNTEST_PARALLEL + 1)
#define BREAKPOINTMRC                                      (CPGC_CHECK_ERR_PARALLEL + 1)
#define CPGC_PREPARE_PARALLEL                              (BREAKPOINTMRC + 1)
#define WRITE_SCRATCHPADS                                  (CPGC_PREPARE_PARALLEL + 1)
#define READ_SCRATCHPADS                                   (WRITE_SCRATCHPADS + 13)
#define LDO_TRAIN_INIT                                     (READ_SCRATCHPADS + 13)
#define LDO_TRAIN_INITx                                    (LDO_TRAIN_INIT + 108)
#define SET_CA_SCALE                                       (LDO_TRAIN_INITx + 7)
#define SET_DQ_SCALE                                       (SET_CA_SCALE + 13)
#define LDO_TRAIN_LOOP                                     (SET_DQ_SCALE + 13)
#define VOC_TRAINING_ENTRY                                 (LDO_TRAIN_LOOP + 7)
#define VOC_GET_LDO_ENABLE                                 (VOC_TRAINING_ENTRY + 189)
#define VOC_PHY_ENTRY                                      (VOC_GET_LDO_ENABLE + 8)
#define VOC_COMP_VREF_AND_INIT                             (VOC_PHY_ENTRY + 33)
#define VOC_GET_RCOMP_PUP_VALUE                            (VOC_COMP_VREF_AND_INIT + 27)
#define VOC_GET_RCOMP_PDN_VALUE                            (VOC_GET_RCOMP_PUP_VALUE + 7)
#define VOC_SET_ODT_RCOMP_OVERRIDE                         (VOC_GET_RCOMP_PDN_VALUE + 7)
#define VOC_ENABLE_WLMODE                                  (VOC_SET_ODT_RCOMP_OVERRIDE + 15)
#define VOC_DISABLE_WLMODE                                 (VOC_ENABLE_WLMODE + 7)
#define VOC_TRAINING_EXIT                                  (VOC_DISABLE_WLMODE + 7)
#define CPGC_GET_TEST_RESULT                               (VOC_TRAINING_EXIT + 61)
#define CPGC_SET_CHUNK_MASK                                (CPGC_GET_TEST_RESULT + 43)
#define CPGC_STOP_CLEAR_ERR                                (CPGC_SET_CHUNK_MASK + 8)
#define CPGC_START_TEST                                    (CPGC_STOP_CLEAR_ERR + 23)
#define CheckForWarmReset                                  (CPGC_START_TEST + 12)
#define xyz                                                (CheckForWarmReset + 14)
#define InitDunitx                                         (xyz + 7)
#define InitDunitWakeRemove                                (InitDunitx + 19)
#define DunitFreqChangePart1                               (InitDunitWakeRemove + 22)
#define ChangePHYFreq                                      (DunitFreqChangePart1 + 44)
#define DunitFreqChangePart3                               (ChangePHYFreq + 1)
#define MmapBeforeTrain                                    (DunitFreqChangePart3 + 40)
#define SetICBitDone                                       (MmapBeforeTrain + 9)
#define ProgamFinalSettingsx                               (SetICBitDone + 7)
#define ReadFuses                                          (ProgamFinalSettingsx + 18)
#define EnableScrambling                                   (ReadFuses + 7)
#define SetMrcDoneRemove                                   (EnableScrambling + 7)
#define SetMrcDonex                                        (SetMrcDoneRemove + 7)
#define ReadBarAddress                                     (SetMrcDonex + 10)
#define WriteMchBarAddress                                 (ReadBarAddress + 37)
#define WriteBarAddress                                    (WriteMchBarAddress + 7)
#define WritePCIEXBAR                                      (WriteBarAddress + 21)
#define SetAunitSliceChannel                               (WritePCIEXBAR + 13)
#define LockAunitSliceChannel                              (SetAunitSliceChannel + 11)
#define InitDunitWakeS0                                    (LockAunitSliceChannel + 9)
#define MRC_to_Tap_CWL                                     (InitDunitWakeS0 + 22)
#define S0_fixes_GET                                       (MRC_to_Tap_CWL + 10)
#define S0_fixes_SET                                       (S0_fixes_GET + 163)
#define InitDunitWakeS0pt1                                 (S0_fixes_SET + 33)
#define ToggleBGF_RUN                                      (InitDunitWakeS0pt1 + 8)
#define modmem_init_lpddrgrp3_seq_from_7                   (ToggleBGF_RUN + 23)
#define xxxx                                               (modmem_init_lpddrgrp3_seq_from_7 + 10)
#define modmem_s0ix_entry_m_seq                            (xxxx + 36)
#define modmem_lp4_freq_switch_seq                         (modmem_s0ix_entry_m_seq + 45)
#define modmem_ldo_offsetcomp_poll_seq                     (modmem_lp4_freq_switch_seq + 246)
#define modmem_init_lpddrgrp0m_seq                         (modmem_ldo_offsetcomp_poll_seq + 9)
#define maxpi_dll_init                                     (modmem_init_lpddrgrp0m_seq + 33)
#define maxpi_override_coarse_init                         (maxpi_dll_init + 16)
#define maxpi_set_codes                                    (maxpi_override_coarse_init + 87)
#define maxpi_get_codes                                    (maxpi_set_codes + 36)
#define maxpi_override_coarse_final                        (maxpi_get_codes + 61)
#define modmem_init_progcmdckctl_seq                       (maxpi_override_coarse_final + 22)
#define maxpi_read_value                                   (modmem_init_progcmdckctl_seq + 180)
#define maxpi_write_value                                  (maxpi_read_value + 19)
//
// All dynamic register names. Each of these will be written to during the Init phase of MMRC.
//
#define DYN_PUNIT_P_CR_MC_BIOS_REQ_0_0_0_MCHBAR            0
#define DYN_DPLVUG_PTCTL0                                  1
#define DYN_DQCCC_WRDQSCTL                                 2
#define DYN_DQCCC_WRDQSCTL_1                               3
#define DYN_DQCCC_WRDQSCTL_2                               4
#define DYN_DQCCC_WRDQSCTL_3                               5
#define DYN_DQCCC_RDVLDCTL                                 6
#define DYN_DQCCC_RDVLDCTL_1                               7
#define DYN_DQCCC_RDVLDCTL_2                               8
#define DYN_DQCCC_RDVLDCTL_3                               9
#define DYN_DQCCC_RDVLDCTL_4                               10
#define DYN_DQCCC_RDVLDCTL_5                               11
#define DYN_DQCCC_RDVLDCTL_6                               12
#define DYN_DQCCC_RK2RKCTL0                                13
#define DYN_DQCCC_RK2RKCTL0_1                              14
#define DYN_DQCCC_RK2RKCTL0_2                              15
#define DYN_DQCCC_RXDLLRDCMDCTL0                           16
#define DYN_DQCCC_RXDLLRDCMDCTL0_1                         17
#define DYN_DQCCC_RXDLLRDCMDCTL0_2                         18
#define DYN_DQCCC_RXDLLRDCMDCTL0_3                         19
#define DYN_DQCCC_RXDLLRDCMDCTL0_4                         20
#define DYN_DQCCC_RXDLLRDCMDCTL0_5                         21
#define DYN_DQCCC_RXODTSEGCTL_CC                           22
#define DYN_DQCCC_RXODTSEGCTL_CC_1                         23
#define DYN_DQCCC_RXODTSEGCTL_CC_2                         24
#define DYN_DQCCC_RXODTSEGCTL_CC_3                         25
#define DYN_DQCCC_RXODTSEGCTL_DQ                           26
#define DYN_DQCCC_RXODTSEGCTL_DQ_1                         27
#define DYN_DQCCC_RXODTSEGCTL_DQ_2                         28
#define DYN_DQCCC_RXODTSEGCTL_DQ_3                         29
#define DYN_DQCCC_RXODTCTL_CC                              30
#define DYN_DQCCC_RXODTCTL_CC_1                            31
#define DYN_DQCCC_RXODTCTL_CC_2                            32
#define DYN_DQCCC_RXODTCTL_CC_3                            33
#define DYN_DQCCC_RXODTCTL_DQ                              34
#define DYN_DQCCC_RXODTCTL_DQ_1                            35
#define DYN_DQCCC_RXODTCTL_DQ_2                            36
#define DYN_DQCCC_RXODTCTL_DQ_3                            37
#define DYN_DQCCC_RCVENCTL_CC                              38
#define DYN_DQCCC_RCVENCTL_CC_1                            39
#define DYN_DQCCC_RCVENCTL_CC_2                            40
#define DYN_DQCCC_RCVENCTL_CC_3                            41
#define DYN_DQCCC_RCVENCTL_DQ                              42
#define DYN_DQCCC_RCVENCTL_DQ_1                            43
#define DYN_DQCCC_RCVENCTL_DQ_2                            44
#define DYN_DQCCC_RCVENCTL_DQ_3                            45
#define DYN_DQCCC_DIFFAMPCTL_CC                            46
#define DYN_DQCCC_DIFFAMPCTL_CC_1                          47
#define DYN_DQCCC_DIFFAMPCTL_CC_2                          48
#define DYN_DQCCC_DIFFAMPCTL_CC_3                          49
#define DYN_DQCCC_DIFFAMPCTL_DQ                            50
#define DYN_DQCCC_DIFFAMPCTL_DQ_1                          51
#define DYN_DQCCC_DIFFAMPCTL_DQ_2                          52
#define DYN_DQCCC_DIFFAMPCTL_DQ_3                          53
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1                        54
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1_1                      55
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1_2                      56
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1_3                      57
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2                        58
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2_1                      59
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2_2                      60
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2_3                      61
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3                        62
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3_1                      63
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3_2                      64
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3_3                      65
#define DYN_DUNIT_D_CR_DRP0                                66
#define DYN_DUNIT_D_CR_DRP0_1                              67
#define DYN_DUNIT_D_CR_DRP0_2                              68
#define DYN_DUNIT_D_CR_DTR0A                               69
#define DYN_DUNIT_D_CR_DTR1A                               70
#define DYN_DUNIT_D_CR_DTR2A                               71
#define DYN_DUNIT_D_CR_DTR3A                               72
#define DYN_DUNIT_D_CR_DTR4A                               73
#define DYN_DUNIT_D_CR_DTR5A                               74
#define DYN_DUNIT_D_CR_DTR6A                               75
#define DYN_DUNIT_D_CR_DTR7A                               76
#define DYN_DUNIT_D_CR_DTR8A                               77
#define DYN_DUNIT_D_CR_SSKPD0                              78
#define DYN_DUNIT_D_CR_BONUS0                              79
#define DYN_DUNIT_D_CR_BONUS1                              80
#define DYN_DUNIT_D_CR_MR4_DESWIZZLE                       81
#define DYN_DUNIT_D_CR_BGF_CTL                             82
#define DYN_DUNIT_D_CR_BGF_CTL_1                           83
#define DYN_DUNIT_D_CR_BGF_CTL_2                           84
#define DYN_DQCCC_DIFFAMPCTL_CC_4                          85
#define DYN_DQCCC_DIFFAMPCTL_DQ_4                          86
#define DYN_DUNIT_D_CR_DRP0_3                              87
#define DYN_DUNIT_D_CR_DPMC0                               88
#define DYN_DUNIT_D_CR_DPMC1                               89
#define DYN_DUNIT_D_CR_DRFC                                90
#define DYN_DUNIT_D_CR_DSCH                                91
#define DYN_DUNIT_D_CR_DCAL                                92
#define DYN_DUNIT_D_CR_TQCTL                               93
#define DYN_DUNIT_D_CR_TQOFFSET                            94
#define DYN_DUNIT_D_CR_BGF_CTL_3                           95
#define DYN_DUNIT_D_CR_BGF_CTL_4                           96
#define DYN_DUNIT_D_CR_BGF_CTL_5                           97
#define DYN_DUNIT_D_CR_DQS_RETRAINING_CTL                  98
#define DYN_PUNIT_P_CR_MC_BIOS_REQ_0_0_0_MCHBAR_1          99
#define DYN_DUNIT_D_CR_BGF_CTL_6                           100
#define DYN_DUNIT_D_CR_BGF_CTL_7                           101
#define DYN_DUNIT_D_CR_BGF_CTL_8                           102
#define DYN_MLMC_MLM_CR_CONFIG                             103
#define DYN_MLMC_MLM_CR_FM_CONFIG                          104
#define DYN_DQCCC_TXDLLSIGGRP2CTL                          105
#define DYN_DUNIT_D_CR_DRAM_CMD                            106
#define DYN_CPGC_CPGC_DPAT_UNISEQ_0_                       107
#define DYN_CPGC_CPGC2_BASE_REPEATS                        108
#define DYN_CPGC_CPGC2_BLOCK_REPEATS                       109
#define DYN_CPGC_CPGC2_BASE_REPEATS_1                      110
#define DYN_CPGC_CPGC2_BLOCK_REPEATS_1                     111
#define DYN_CPGC_CPGC2_BASE_REPEATS_2                      112
#define DYN_CPGC_CPGC2_BLOCK_REPEATS_2                     113
#define DYN_DQCCC_WRLVL                                    114
#define DYN_CCC_WRLVL                                      115
#define DYN_CPGC_CPGC_DPAT_XTRA_LFSR_CFG                   116
#define DYN_CPGC_CPGC_DPAT_CFG                             117
#define DYN_CPGC_CPGC2_BASE_REPEATS_3                      118
#define DYN_CPGC_CPGC2_BLOCK_REPEATS_3                     119
#define DYN_CPGC_CPGC_DPAT_INV_DC_MASK_LO                  120
#define DYN_DQCCC_RDVLDCTL_7                               121
#define DYN_DQCCC_RDVLDCTL_8                               122
#define DYN_DQCCC_RDVLDCTL_9                               123
#define DYN_DQCCC_RDVLDCTL_10                              124
#define DYN_DQCCC_RDVLDCTL_11                              125
#define DYN_DQCCC_RDVLDCTL_12                              126
#define DYN_DQCCC_RDVLDCTL_13                              127
#define DYN_DUNIT_D_CR_DRMC                                128
#define DYN_DUNIT_D_CR_DRAM_CMD_1                          129
#define DYN_CPGC_CPGC_SEQ_BANK_L2P_MAPPING_A               130
#define DYN_CPGC_CPGC_SEQ_RANK_L2P_MAPPING                 131
#define DYN_CPGC_CPGC_CADB_BUFA_0_                         132
#define DYN_CPGC_CPGC_CADB_BUFA_2_                         133
#define DYN_CPGC_CPGC_CADB_BUFA_3_                         134
#define DYN_CPGC_CPGC2_ADDRESS_SIZE                        135
#define DYN_CPGC_CPGC2_ADDRESS_CONTROL                     136
#define DYN_CPGC_CPGC_CADB_BUFA_0__1                       137
#define DYN_CPGC_CPGC_CADB_BUFA_1_                         138
#define DYN_CPGC_CPGC_CADB_BUFA_2__1                       139
#define DYN_CPGC_CPGC_CADB_BUFA_3__1                       140
#define DYN_CPGC_CPGC_CADB_BUFA_4_                         141
#define DYN_CPGC_CPGC_CADB_BUFA_5_                         142
#define DYN_CPGC_CPGC_CADB_BUFA_6_                         143
#define DYN_CPGC_CPGC_CADB_BUFA_7_                         144
#define DYN_CPGC_CPGC_CADB_BUFB_0_                         145
#define DYN_CPGC_CPGC_CADB_BUFB_1_                         146
#define DYN_CPGC_CPGC_CADB_BUFB_2_                         147
#define DYN_CPGC_CPGC_CADB_BUFB_3_                         148
#define DYN_CPGC_CPGC_CADB_BUFB_4_                         149
#define DYN_CPGC_CPGC_CADB_BUFB_5_                         150
#define DYN_CPGC_CPGC_CADB_BUFB_6_                         151
#define DYN_CPGC_CPGC_CADB_BUFB_7_                         152
#define DYN_CPGC_CPGC_DPAT_UNISEQ_0__1                     153
#define DYN_CPGC_CPGC_DPAT_UNISEQ_1_                       154
#define DYN_DQCCC_RXODTCTL_DQ_4                            155
#define DYN_CPGC_CPGC_CADB_CTL                             156
#define DYN_CPGC_CPGC_CADB_CTL_1                           157
#define DYN_CPGC_CPGC_CADB_CTL_2                           158
#define DYN_CPGC_CPGC_CADB_CTL_3                           159
#define DYN_CPGC_CPGC_CADB_CTL_4                           160
#define DYN_CPGC_CPGC_CADB_CTL_5                           161
#define DYN_CPGC_CPGC_CADB_CTL_6                           162
#define DYN_CPGC_CPGC_CADB_CFG                             163
#define DYN_CPGC_CPGC_CADB_UNISEQ0_PBUF                    164
#define DYN_CPGC_CPGC_CADB_UNISEQ1_PBUF                    165
#define DYN_CPGC_CPGC_CADB_UNISEQ2_PBUF                    166
#define DYN_CPGC_CPGC2_ALGORITHM_INSTRUCTION_0_            167
#define DYN_CPGC_CPGC_DPAT_UNISEQ_0__2                     168
#define DYN_CPGC_CPGC_DPAT_UNISEQ_1__1                     169
#define DYN_CPGC_CPGC_DPAT_CFG_1                           170
#define DYN_CPGC_CPGC_ERR_CTL                              171
#define DYN_CPGC_CPGC_ERR_LNEN_HI                          172
#define DYN_DUNIT_D_CR_DQS_RETRAINING_CTL_1                173
#define DYN_DPLVUG_PTCTL0_1                                174
#define DYN_DUNIT_D_CR_TQCTL_1                             175
#define DYN_DUNIT_D_CR_DCAL_1                              176
#define DYN_DUNIT_D_CR_DRFC_1                              177
#define DYN_DUNIT_D_CR_DPMC0_1                             178
#define DYN_DUNIT_D_CR_DPMC1_1                             179
#define DYN_DUNIT_D_CR_DQS_RETRAINING_CTL_2                180
#define DYN_DUNIT_D_CR_DTR4A_1                             181
#define DYN_DUNIT_D_CR_DTR6A_1                             182
#define DYN_DPLVUG_PTCTL0_2                                183
#define DYN_DQCCC_RXODTCTL_DQ_5                            184
#define DYN_DQCCC_WKPUPPDNCTL                              185
#define DYN_DQCCC_RXODTSEGCTL_DQ_4                         186
#define DYN_DQCCC_RXODTCTL_DQ_6                            187
#define DYN_DQCCC_DIFFAMPCTL_DQ_5                          188
#define DYN_DUNIT_D_CR_SSKPD0_1                            189
#define DYN_DUNIT_D_CR_SSKPD1                              190
#define DYN_LDO_TXPANIC                                    191
#define DYN_LDO_TXFB                                       192
#define DYN_LDO_TXFFDQ0_DVFS                               193
#define DYN_LDO_TXFFDQ1_DVFS                               194
#define DYN_LDO_TXFFCA0_DVFS                               195
#define DYN_LDO_TXFFCA1_DVFS                               196
#define DYN_LDO_TXFFCA0_DVFS_1                             197
#define DYN_LDO_TXFFCA1_DVFS_1                             198
#define DYN_LDO_TXFFDQ0_DVFS_1                             199
#define DYN_LDO_TXFFDQ1_DVFS_1                             200
#define DYN_LDO_TXFB_1                                     201
#define DYN_DPLVUG_DPIC_GRCOMP_VREF_1                      202
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3_4                      203
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1_4                      204
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2_4                      205
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3_5                      206
#define DYN_DPLVUG_DPIC_LRCOMP_PUPDOVR                     207
#define DYN_DQCCC_RXODTSEGCTL_DQ_5                         208
#define DYN_DQCCC_DIFFAMPCTL_DQ_6                          209
#define DYN_DPLVUG_DPIC_GRCOMP_VREF_0                      210
#define DYN_DPLVUG_DPIC_GRCOMP_VREF_1_1                    211
#define DYN_DQCCC_RXODTCTL_DQ_7                            212
#define DYN_DQCCC_VREFCTL0                                 213
#define DYN_CPGC_CPGC_ERR_CTL_1                            214
#define DYN_DUNIT_D_CR_SCRAMCTRL                           215
#define DYN_CUNIT_MCHBAR_LO_0_0_0_PCI                      216
#define DYN_P2SB_BASE_ADDRESS_LO                           217
#define DYN_CUNIT_PCIEXBAR_LO_0_0_0_PCI                    218
#define DYN_DQCCC_RXPBDBLCTL                               219
#define DYN_DQCCC_TXPBDCTL1                                220
#define DYN_DQCCC_RXPBDBLCTL_1                             221
#define DYN_DQCCC_TXPBDCTL1_1                              222
#define DYN_DQCCC_DLLCOMP_FBMUXSEL                         223
#define DYN_DPIC_PLLCTL                                    224
#define DYN_DQCCC_DLLCOMP_FBMUXSEL_1                       225
#define DYN_DQCCC_DLLCOMP_COARSECODE                       226
#define DYN_DQCCC_DLLCOMP_FINECODE                         227
#define DYN_DPIC_PLLCTL_1                                  228
#define DYN_DQCCC_DLLCOMP_COARSECODE_1                     229
#define DYN_DQCCC_TXDLLSIGGRP5CTL                          230
#define DYN_DQCCC_TXDLLSIGGRP4CTL                          231
#define DYN_DQCCC_TXDLLSIGGRP3CTL                          232
//
// All dynamic field names. These must be populated with real values prior to executing MmrcEntry().
//
#ifdef MEM_SV_HOOKS
#define FM_CH3                                             0
#define FM_CH2                                             1
#define FM_CH1                                             2
#define FM_CH0                                             3
#define PUNIT_REQ_TYPE                                     4
#define PUNIT_REQ_DATA                                     5
#define RL                                                 6
#define WL                                                 7
#define SS_TEMP_VAR                                        8
#define SILICON_BXT_P0                                     9
#define ADDRDEC                                            10
#define BAHEN                                              11
#define RSIEN                                              12
#define DDEN                                               13
#define RANK1_ENABLED                                      14
#define RANK0_ENABLED                                      15
#define TCKSRX                                             16
#define TXSR                                               17
#define TRCD                                               18
#define TRPPB                                              19
#define TXP                                                20
#define TZQCL                                              21
#define TZQCS                                              22
#define TZQLAT                                             23
#define NRFCAB                                             24
#define TCKE                                               25
#define NREFI                                              26
#define TRTP                                               27
#define TWTP                                               28
#define TCWL                                               29
#define TCCDMW                                             30
#define TFAW                                               31
#define TWRDR                                              32
#define TRWDR                                              33
#define TWWDR                                              34
#define TRRDR                                              35
#define TRRD                                               36
#define TDERATE_INC                                        37
#define TWWSR                                              38
#define TRRSR                                              39
#define TWRSR                                              40
#define TRWSR                                              41
#define TCKCKEL                                            42
#define MNTDLY                                             43
#define TPSTMRBLK                                          44
#define TPREMRBLK                                          45
#define TRPAB                                              46
#define TPSTMRWBLK                                         47
#define TWRPDEN                                            48
#define TRDPDEN                                            49
#define TRAS                                               50
#define TCKESR                                             51
#define TLPCKDLY                                           52
#define TCKLPDLY                                           53
#define PWDDLY                                             54
#define SSKPD0                                             55
#define SSKPD1                                             56
#define BONUS0                                             57
#define BONUS1                                             58
#define MR4_BIT2_SEL                                       59
#define MR4_BIT1_SEL                                       60
#define MR4_BIT0_SEL                                       61
#define MR4_BYTE_SEL                                       62
#define SPIDCMDCLK_RATIO                                   63
#define SPIDDATA_RATIO_WIO2                                64
#define CC_DQS_OVR_VAL                                     65
#define CC_DQS_OVR_SEL                                     66
#define CC_DQDM_OVR_VAL                                    67
#define CC_DQDM_OVR_SEL                                    68
#define BL_DQS_OVR_VAL                                     69
#define BL_DQS_OVR_SEL                                     70
#define BL_DQDM_OVR_VAL                                    71
#define BL_DQDM_OVR_SEL                                    72
#define ECCEN                                              73
#define DYNSREN                                            74
#define BXT_A0_PO                                          75
#define PCLSTO                                             76
#define BXT_A0_WA                                          77
#define MINREFRATE                                         78
#define REFWMPNC                                           79
#define REFWMHI                                            80
#define WPQCOUNT                                           81
#define RPQCOUNT                                           82
#define SRXZQC                                             83
#define TQPOLLPER                                          84
#define MR_VALUE                                           85
#define SILICON_BXT_P0_PO                                  86
#define SACLKBY2_RATIO                                     87
#define DQS_RETRAIN_INT                                    88
#define DQS_OSC_RT                                         89
#define BXT_PERIODIC_ENABLED                               90
#define ONE_LM_MODE                                        91
#define FM_SIZE_CH10                                       92
#define FM_SIZE_CH8                                        93
#define FM_SIZE_CH9                                        94
#define FM_SIZE_CH11                                       95
#define FM_ACTIVE_SNWE                                     96
#define REG_DATA                                           97
#define DRAM_CMD_BL                                        98
#define RANK                                               99
#define RDDCMD                                             100
#define BYTEGRP_ERR_STAT                                   101
#define ECC_ERR_STAT                                       102
#define CPGC_RESULT                                        103
#define NUM_BURSTS_EXP                                     104
#define NUM_LOOPS_EXP                                      105
#define WRLVLMODEVAR                                       106
#define LANE_ROTATE_RATE                                   107
#define RELOAD_LFSR_SEED_RATE                              108
#define SAVE_LFSR_SEED_RATE                                109
#define CAVREF                                             110
#define RANK_INDEX                                         111
#define TARGET_BANK                                        112
#define TARGET_RANK                                        113
#define ROW_COL_ADDR                                       114
#define NUM_COLS                                           115
#define NUM_ROWS                                           116
#define ADD_ROTATE_RPT                                     117
#define CADB_BUFA0_BANK                                    118
#define CADB_BUFA0_ROW_COL                                 119
#define CADB_BUFA1_BANK                                    120
#define CADB_BUFA1_ROW_COL                                 121
#define CADB_BUFA2_BANK                                    122
#define CADB_BUFA2_ROW_COL                                 123
#define CADB_BUFA3_BANK                                    124
#define CADB_BUFA3_ROW_COL                                 125
#define CADB_BUFA4_BANK                                    126
#define CADB_BUFA4_ROW_COL                                 127
#define CADB_BUFA5_BANK                                    128
#define CADB_BUFA5_ROW_COL                                 129
#define CADB_BUFA6_BANK                                    130
#define CADB_BUFA6_ROW_COL                                 131
#define CADB_BUFA7_BANK                                    132
#define CADB_BUFA7_ROW_COL                                 133
#define CADB_BUFB0_CMD                                     134
#define CADB_BUFB1_CMD                                     135
#define CADB_BUFB2_CMD                                     136
#define CADB_BUFB3_CMD                                     137
#define CADB_BUFB4_CMD                                     138
#define CADB_BUFB5_CMD                                     139
#define CADB_BUFB6_CMD                                     140
#define CADB_BUFB7_CMD                                     141
#define AGG_PATTERN                                        142
#define VIC_PATTERN                                        143
#define RCVEN_RDPTR                                        144
#define RMT_COMMAND                                        145
#define RMT_VALUE                                          146
#define VAR_SEG_HIGHADDR_HI                                147
#define VAR_SEG_HIGHADDR_LO                                148
#define FIX_SEGMENT_RANK_SELECT                            149
#define FIX_SEGMENT_RANK_SELECT_0                          150
#define FIX_SEGMENT_RANK_SELECT_1                          151
#define FIX_SEGMENT_RANK_SELECT_2                          152
#define FIX_SEGMENT_RANK_SELECT_3                          153
#define SEQ_START                                          154
#define SEQ_END                                            155
#define UNIMODE                                            156
#define PATTERN0                                           157
#define PATTERN1                                           158
#define PATTERN2                                           159
#define INSTR_LAST                                         160
#define INSTR_POINTER                                      161
#define CHUNK_ERR_MASK                                     162
#define CHUNK_ERR_MASK_LP                                  163
#define CHUNK_ERR_STAT                                     164
#define LANE_ERR_STAT_LO                                   165
#define LANE_ERR_STAT_HI                                   166
#define ERR_COUNT0                                         167
#define ERR_COUNT1                                         168
#define ERR_COUNT2                                         169
#define ERR_COUNT3                                         170
#define ERR_COUNT4                                         171
#define ERR_COUNT5                                         172
#define ERR_COUNT6                                         173
#define ERR_COUNT7                                         174
#define ERR_COUNT8                                         175
#define TQPOLLEN_SAVE                                      176
#define SRXZQC_SAVE                                        177
#define ZQDIS_SAVE                                         178
#define OREFDIS_SAVE                                       179
#define DYNSREN_SAVE                                       180
#define DISPWRDN_SAVE                                      181
#define DQS_RETAIN_EN_SAVE                                 182
#define RDCMD2RDVLD                                        183
#define PTLDCODE                                           184
#define ODT_SEL_SAVE                                       185
#define ODT_VAL_SAVE                                       186
#define WEAKPUP_SAVE                                       187
#define WEAKPDN_SAVE                                       188
#define SCRATCHPAD_VALUE0                                  189
#define SCRATCHPAD_VALUE1                                  190
#define PANICVLO                                           191
#define PANICVHI                                           192
#define TARGETV                                            193
#define BGACH                                              194
#define LDOSCALE                                           195
#define LDOCOEF                                            196
#define RCOMP_Up_GRP0                                      197
#define RCOMP_Dn_GRP0                                      198
#define RCOMP_Up_GRP1                                      199
#define RCOMP_Dn_GRP1                                      200
#define RCOMP_Up_GRP2                                      201
#define RCOMP_Dn_GRP2                                      202
#define RCOMP_Up_GRP3                                      203
#define RCOMP_Dn_GRP3                                      204
#define RCOMP_Up_GRP4                                      205
#define RCOMP_Dn_GRP4                                      206
#define RCOMP_Up_GRP5                                      207
#define RCOMP_Dn_GRP5                                      208
#define RCOMP_OVR_Up_En                                    209
#define RCOMP_OVR_Dn_En                                    210
#define RCOMP_Seg_Ovr_Val                                  211
#define RCOMP_Seg_Ovr_En                                   212
#define DIFF_Ovr_Val                                       213
#define DIFF_Ovr_Val_sel                                   214
#define comp_vref_0                                        215
#define comp_vref_1                                        216
#define comp_vref_2                                        217
#define comp_vref_3                                        218
#define comp_vref_4                                        219
#define comp_vref_5                                        220
#define RX_ODTEN_OVR_SEL                                   221
#define RX_ODTEN_OVR_VAL                                   222
#define RXCCVREFCTL                                        223
#define RXBLVREFCTL                                        224
#define VOC_LDO_ENABLE                                     225
#define VOC_RCOMP_PUP                                      226
#define VOC_RCOMP_PDN                                      227
#define DISR                                               228
#define FUSESTAT                                           229
#define SCRAMBLER_KEY                                      230
#define MCHBAR                                             231
#define P2SBBAR                                            232
#define ECBASE_LO                                          233
#define ECBASE_EN                                          234
#define ECBASE_HI                                          235
#define S0_Fixes0                                          236
#define S0_Fixes1                                          237
#define S0_Fixes2                                          238
#define S0_Fixes3                                          239
#define S0_Fixes4                                          240
#define S0_Fixes5                                          241
#define S0_Fixes6                                          242
#define S0_Fixes7                                          243
#define S0_Fixes8                                          244
#define S0_Fixes9                                          245
#define S0_Fixes10                                         246
#define S0_Fixes11                                         247
#define S0_Fixes12                                         248
#define S0_Fixes13                                         249
#define S0_Fixes14                                         250
#define S0_Fixes15                                         251
#define S0_Fixes16                                         252
#define S0_Fixes17                                         253
#define MUX_MAX                                            254
#define MUX_MIN                                            255
#define COARSE_MAX                                         256
#define COARSE_MIN                                         257
#define FINE_MAX                                           258
#define FINE_MIN                                           259
#define FINE_SOFT_MAX                                      260
#define FINE_SOFT_MIN                                      261
#define MAXPI_GRP5                                         262
#define MAXPI_GRP4                                         263
#define MAXPI_GRP3                                         264
#define MR0_0                                              265
#define MR1_0                                              266
#define MR2_0                                              267
#define MR0_1                                              268
#define MR1_1                                              269
#define MR2_1                                              270
#define DYNVAR_MAX                                         271
#else
#define FM_CH3                                             0
#define FM_CH2                                             1
#define FM_CH1                                             2
#define FM_CH0                                             3
#define PUNIT_REQ_TYPE                                     4
#define PUNIT_REQ_DATA                                     5
#define RL                                                 6
#define WL                                                 7
#define SS_TEMP_VAR                                        8
#define SILICON_BXT_P0                                     9
#define ADDRDEC                                            10
#define BAHEN                                              11
#define RSIEN                                              12
#define DDEN                                               13
#define RANK1_ENABLED                                      14
#define RANK0_ENABLED                                      15
#define TCKSRX                                             16
#define TXSR                                               17
#define TRCD                                               18
#define TRPPB                                              19
#define TXP                                                20
#define TZQCL                                              21
#define TZQCS                                              22
#define TZQLAT                                             23
#define NRFCAB                                             24
#define TCKE                                               25
#define NREFI                                              26
#define TRTP                                               27
#define TWTP                                               28
#define TCWL                                               29
#define TCCDMW                                             30
#define TFAW                                               31
#define TWRDR                                              32
#define TRWDR                                              33
#define TWWDR                                              34
#define TRRDR                                              35
#define TRRD                                               36
#define TDERATE_INC                                        37
#define TWWSR                                              38
#define TRRSR                                              39
#define TWRSR                                              40
#define TRWSR                                              41
#define TCKCKEL                                            42
#define MNTDLY                                             43
#define TPSTMRBLK                                          44
#define TPREMRBLK                                          45
#define TRPAB                                              46
#define TPSTMRWBLK                                         47
#define TWRPDEN                                            48
#define TRDPDEN                                            49
#define TRAS                                               50
#define TCKESR                                             51
#define TLPCKDLY                                           52
#define TCKLPDLY                                           53
#define PWDDLY                                             54
#define SSKPD0                                             55
#define SSKPD1                                             56
#define BONUS0                                             57
#define BONUS1                                             58
#define MR4_BIT2_SEL                                       59
#define MR4_BIT1_SEL                                       60
#define MR4_BIT0_SEL                                       61
#define MR4_BYTE_SEL                                       62
#define SPIDCMDCLK_RATIO                                   63
#define SPIDDATA_RATIO_WIO2                                64
#define CC_DQS_OVR_VAL                                     65
#define CC_DQS_OVR_SEL                                     66
#define CC_DQDM_OVR_VAL                                    67
#define CC_DQDM_OVR_SEL                                    68
#define BL_DQS_OVR_VAL                                     69
#define BL_DQS_OVR_SEL                                     70
#define BL_DQDM_OVR_VAL                                    71
#define BL_DQDM_OVR_SEL                                    72
#define ECCEN                                              73
#define DYNSREN                                            74
#define BXT_A0_PO                                          75
#define PCLSTO                                             76
#define BXT_A0_WA                                          77
#define MINREFRATE                                         78
#define REFWMPNC                                           79
#define REFWMHI                                            80
#define WPQCOUNT                                           81
#define RPQCOUNT                                           82
#define SRXZQC                                             83
#define TQPOLLPER                                          84
#define MR_VALUE                                           85
#define SILICON_BXT_P0_PO                                  86
#define SACLKBY2_RATIO                                     87
#define DQS_RETRAIN_INT                                    88
#define DQS_OSC_RT                                         89
#define BXT_PERIODIC_ENABLED                               90
#define ONE_LM_MODE                                        91
#define FM_SIZE_CH10                                       92
#define FM_SIZE_CH8                                        93
#define FM_SIZE_CH9                                        94
#define FM_SIZE_CH11                                       95
#define FM_ACTIVE_SNWE                                     96
#define REG_DATA                                           97
#define DRAM_CMD_BL                                        98
#define RANK                                               99
#define RDDCMD                                             100
#define BYTEGRP_ERR_STAT                                   101
#define ECC_ERR_STAT                                       102
#define CPGC_RESULT                                        103
#define NUM_BURSTS_EXP                                     104
#define NUM_LOOPS_EXP                                      105
#define WRLVLMODEVAR                                       106
#define LANE_ROTATE_RATE                                   107
#define RELOAD_LFSR_SEED_RATE                              108
#define SAVE_LFSR_SEED_RATE                                109
#define CAVREF                                             110
#define RANK_INDEX                                         111
#define TARGET_BANK                                        112
#define TARGET_RANK                                        113
#define ROW_COL_ADDR                                       114
#define NUM_COLS                                           115
#define NUM_ROWS                                           116
#define ADD_ROTATE_RPT                                     117
#define CADB_BUFA0_BANK                                    118
#define CADB_BUFA0_ROW_COL                                 119
#define CADB_BUFA1_BANK                                    120
#define CADB_BUFA1_ROW_COL                                 121
#define CADB_BUFA2_BANK                                    122
#define CADB_BUFA2_ROW_COL                                 123
#define CADB_BUFA3_BANK                                    124
#define CADB_BUFA3_ROW_COL                                 125
#define CADB_BUFA4_BANK                                    126
#define CADB_BUFA4_ROW_COL                                 127
#define CADB_BUFA5_BANK                                    128
#define CADB_BUFA5_ROW_COL                                 129
#define CADB_BUFA6_BANK                                    130
#define CADB_BUFA6_ROW_COL                                 131
#define CADB_BUFA7_BANK                                    132
#define CADB_BUFA7_ROW_COL                                 133
#define CADB_BUFB0_CMD                                     134
#define CADB_BUFB1_CMD                                     135
#define CADB_BUFB2_CMD                                     136
#define CADB_BUFB3_CMD                                     137
#define CADB_BUFB4_CMD                                     138
#define CADB_BUFB5_CMD                                     139
#define CADB_BUFB6_CMD                                     140
#define CADB_BUFB7_CMD                                     141
#define AGG_PATTERN                                        142
#define VIC_PATTERN                                        143
#define RCVEN_RDPTR                                        144
#define RMT_COMMAND                                        145
#define RMT_VALUE                                          146
#define VAR_SEG_HIGHADDR_HI                                147
#define VAR_SEG_HIGHADDR_LO                                148
#define FIX_SEGMENT_RANK_SELECT                            149
#define FIX_SEGMENT_RANK_SELECT_0                          150
#define FIX_SEGMENT_RANK_SELECT_1                          151
#define FIX_SEGMENT_RANK_SELECT_2                          152
#define FIX_SEGMENT_RANK_SELECT_3                          153
#define SEQ_START                                          154
#define SEQ_END                                            155
#define UNIMODE                                            156
#define PATTERN0                                           157
#define PATTERN1                                           158
#define PATTERN2                                           159
#define INSTR_LAST                                         160
#define INSTR_POINTER                                      161
#define CHUNK_ERR_MASK                                     162
#define CHUNK_ERR_MASK_LP                                  163
#define CHUNK_ERR_STAT                                     164
#define LANE_ERR_STAT_LO                                   165
#define LANE_ERR_STAT_HI                                   166
#define ERR_COUNT0                                         167
#define ERR_COUNT1                                         168
#define ERR_COUNT2                                         169
#define ERR_COUNT3                                         170
#define ERR_COUNT4                                         171
#define ERR_COUNT5                                         172
#define ERR_COUNT6                                         173
#define ERR_COUNT7                                         174
#define ERR_COUNT8                                         175
#define TQPOLLEN_SAVE                                      176
#define SRXZQC_SAVE                                        177
#define ZQDIS_SAVE                                         178
#define OREFDIS_SAVE                                       179
#define DYNSREN_SAVE                                       180
#define DISPWRDN_SAVE                                      181
#define DQS_RETAIN_EN_SAVE                                 182
#define RDCMD2RDVLD                                        183
#define PTLDCODE                                           184
#define ODT_SEL_SAVE                                       185
#define ODT_VAL_SAVE                                       186
#define WEAKPUP_SAVE                                       187
#define WEAKPDN_SAVE                                       188
#define SCRATCHPAD_VALUE0                                  189
#define SCRATCHPAD_VALUE1                                  190
#define PANICVLO                                           191
#define PANICVHI                                           192
#define TARGETV                                            193
#define BGACH                                              194
#define LDOSCALE                                           195
#define LDOCOEF                                            196
#define RCOMP_Up_GRP0                                      197
#define RCOMP_Dn_GRP0                                      198
#define RCOMP_Up_GRP1                                      199
#define RCOMP_Dn_GRP1                                      200
#define RCOMP_Up_GRP2                                      201
#define RCOMP_Dn_GRP2                                      202
#define RCOMP_Up_GRP3                                      203
#define RCOMP_Dn_GRP3                                      204
#define RCOMP_Up_GRP4                                      205
#define RCOMP_Dn_GRP4                                      206
#define RCOMP_Up_GRP5                                      207
#define RCOMP_Dn_GRP5                                      208
#define RCOMP_OVR_Up_En                                    209
#define RCOMP_OVR_Dn_En                                    210
#define RCOMP_Seg_Ovr_Val                                  211
#define RCOMP_Seg_Ovr_En                                   212
#define DIFF_Ovr_Val                                       213
#define DIFF_Ovr_Val_sel                                   214
#define comp_vref_0                                        215
#define comp_vref_1                                        216
#define comp_vref_2                                        217
#define comp_vref_3                                        218
#define comp_vref_4                                        219
#define comp_vref_5                                        220
#define RX_ODTEN_OVR_SEL                                   221
#define RX_ODTEN_OVR_VAL                                   222
#define RXCCVREFCTL                                        223
#define RXBLVREFCTL                                        224
#define VOC_LDO_ENABLE                                     225
#define VOC_RCOMP_PUP                                      226
#define VOC_RCOMP_PDN                                      227
#define DISR                                               228
#define FUSESTAT                                           229
#define SCRAMBLER_KEY                                      230
#define MCHBAR                                             231
#define P2SBBAR                                            232
#define ECBASE_LO                                          233
#define ECBASE_EN                                          234
#define ECBASE_HI                                          235
#define S0_Fixes0                                          236
#define S0_Fixes1                                          237
#define S0_Fixes2                                          238
#define S0_Fixes3                                          239
#define S0_Fixes4                                          240
#define S0_Fixes5                                          241
#define S0_Fixes6                                          242
#define S0_Fixes7                                          243
#define S0_Fixes8                                          244
#define S0_Fixes9                                          245
#define S0_Fixes10                                         246
#define S0_Fixes11                                         247
#define S0_Fixes12                                         248
#define S0_Fixes13                                         249
#define S0_Fixes14                                         250
#define S0_Fixes15                                         251
#define S0_Fixes16                                         252
#define S0_Fixes17                                         253
#define MUX_MAX                                            254
#define MUX_MIN                                            255
#define COARSE_MAX                                         256
#define COARSE_MIN                                         257
#define FINE_MAX                                           258
#define FINE_MIN                                           259
#define FINE_SOFT_MAX                                      260
#define FINE_SOFT_MIN                                      261
#define MAXPI_GRP5                                         262
#define MAXPI_GRP4                                         263
#define MAXPI_GRP3                                         264
#define MR0_0                                              265
#define MR1_0                                              266
#define MR2_0                                              267
#define MR0_1                                              268
#define MR1_1                                              269
#define MR2_1                                              270
#define DYNVAR_MAX                                         271
#endif // MEM_SV_HOOKS

#include "DQ.h"
#include "AUNIT.h"
#include "DUNIT.h"
#include "DPLVUG.h"
#include "DPIC.h"
#include "CPGC.h"
#include "DQCCC.h"
#include "WIO2PHY.h"
#include "P2SB.h"
#include "CCC.h"
#include "ADPLL.h"
#include "BUNIT.h"
#include "CUNIT.h"
#include "DDRSAI.h"
#include "LDO.h"
#include "MLMC.h"
#include "PUNIT.h"
#include "SAI.h"


#endif // _MMRCPROJECTDEFINITIONSGENERATED_H_
