/** @file
  File name:    AUNIT.h
  Input File:   BXTP_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in AUNIT.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

  @copyright
  Copyright (c) 2005-2016 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by the
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is uniquely
  identified as 'Intel Reference Module' and is licensed for Intel
  CPUs and chipsets under the terms of your license agreement with
  Intel or your vendor. This file may be modified by the user, subject
  to additional terms of the license agreement.

  @par Specification
**/
#ifndef _AUNIT_H_
#define _AUNIT_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define A_CR_UPARB_GCNT_DEV_A2T_MCHBAR_AUNIT_REG           0x00006400
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VC0A posted to T-Unit MSIs.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX vc0a_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // VC0A completion grant count to T-Unit.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX vc0a_c : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // VC0B posted transaction grant count to T-Unit.  This is only for MSIs.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX vc0b_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // VC0B completion grant count to T-Unit.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX vc0b_c : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_DEV_A2T_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_A2B_0_MCHBAR_AUNIT_REG             0x00006404
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 0.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid0_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 0.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid0_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for IOMMU non-posted transactions on channel ID 0.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX chid0_mmu_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 0 class arbiter.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid0_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_A2B_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_A2B_1_MCHBAR_AUNIT_REG             0x00006408
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 1.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid1_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 1.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid1_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for IOMMU non-posted transactions on channel ID 1.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX chid1_mmu_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 1 class arbiter.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid1_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_A2B_1_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_A2B_2_MCHBAR_AUNIT_REG             0x0000640C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 2.
    //
    // Bits[5:0], RO, default = 0x0
    //
    UINTX chid2_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 2.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid2_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for IOMMU non-posted transactions on channel ID 2.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid2_mmu_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 2 class arbiter.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid2_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_A2B_2_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_A2B_3_MCHBAR_AUNIT_REG             0x00006410
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 3.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid3_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 3.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid3_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for IOMMU non-posted transactions on channel ID 3.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX chid3_mmu_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 3 class arbiter.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid3_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_A2B_3_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_A2B_4_MCHBAR_AUNIT_REG             0x00006414
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 4.
    //
    // Bits[5:0], RO, default = 0x0
    //
    UINTX chid4_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 4.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid4_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for IOMMU non-posted transactions on channel ID 4.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid4_mmu_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 4 class arbiter.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid4_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_A2B_4_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_A2B_5_MCHBAR_AUNIT_REG             0x00006418
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 5.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid5_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 5.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid5_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for IOMMU non-posted transactions on channel ID 5.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid5_mmu_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 5 class arbiter.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid5_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_A2B_5_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_A2B_6_MCHBAR_AUNIT_REG             0x0000641C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 6.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid6_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 6.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid6_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for IOMMU non-posted transactions on channel ID 6.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid6_mmu_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 6 class arbiter.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid6_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_A2B_6_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_A2B_7_MCHBAR_AUNIT_REG             0x00006420
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 7.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid7_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 7.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid7_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for IOMMU non-posted transactions on channel ID 7.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid7_mmu_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 7 class arbiter.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid7_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_A2B_7_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_A2T_0_MCHBAR_AUNIT_REG             0x00006424
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 0.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid0_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 0.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid0_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for IOMMU non-posted transactions on channel ID 0.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid0_mmu_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 0 a2t class arbiter.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid0_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_A2T_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_P2P_0_MCHBAR_AUNIT_REG             0x00006428
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 0.
    //
    // Bits[5:0], RO, default = 0x1
    //
    UINTX chid0_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 0.
    //
    // Bits[13:8], RO, default = 0x1
    //
    UINTX chid0_n : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for completions on channel ID 0.
    //
    // Bits[21:16], RO, default = 0x1
    //
    UINTX chid0_c : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 0 p2p class arbiter.
    //
    // Bits[29:24], RO, default = 0x1
    //
    UINTX chid0_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_P2P_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPARB_GCNT_P2P_1_MCHBAR_AUNIT_REG             0x0000642C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 1
    //
    // Bits[5:0], RO, default = 0x1
    //
    UINTX chid1_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 1.
    //
    // Bits[13:8], RO, default = 0x1
    //
    UINTX chid1_n : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for completions on channel ID 1.
    //
    // Bits[21:16], RO, default = 0x1
    //
    UINTX chid1_c : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Target arbiter grant count for the channel ID 1 p2p class arbiter.
    //
    // Bits[29:24], RO, default = 0x1
    //
    UINTX chid1_tgt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_UPARB_GCNT_P2P_1_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_PRIV_GCNT_DEV_P_0_MCHBAR_AUNIT_REG     0x00006430
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 0.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid0 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for posted transactions on channel ID 1.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid1 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for posted transactions on channel ID 2.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid2 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for posted transactions on channel ID 3.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid3 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_PRIV_GCNT_DEV_P_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_PRIV_GCNT_DEV_P_1_MCHBAR_AUNIT_REG     0x00006434
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 4.
    //
    // Bits[5:0], RO, default = 0x0
    //
    UINTX chid4 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for posted transactions on channel ID 5.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid5 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for posted transactions on channel ID 6.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX chid6 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for posted transactions on channel ID 7.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid7 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_PRIV_GCNT_DEV_P_1_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_PRIV_GCNT_DEV_N_0_MCHBAR_AUNIT_REG     0x00006438
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for non-posted transactions on channel ID 0.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid0 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 1.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid1 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for non-posted transactions on channel ID 2.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX chid2 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for non-posted transactions on channel ID 3.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid3 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_PRIV_GCNT_DEV_N_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_PRIV_GCNT_DEV_N_1_MCHBAR_AUNIT_REG     0x0000643C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for non-posted transactions on channel ID 4.
    //
    // Bits[5:0], RW, default = 0x4
    //
    UINTX chid4 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 5.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid5 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for non-posted transactions on channel ID 6.
    //
    // Bits[21:16], RW, default = 0x4
    //
    UINTX chid6 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for non-posted transactions on channel ID 7.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid7 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_PRIV_GCNT_DEV_N_1_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_PRIV_GCNT_DEV_C_0_MCHBAR_AUNIT_REG     0x00006440
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for completions on channel ID 0.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid0 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for completions on channel ID 1.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid1 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for completions on channel ID 2.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid2 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for completions on channel ID 3.
    //
    // Bits[29:24], RO, default = 0x0
    //
    UINTX chid3 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_PRIV_GCNT_DEV_C_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_SHRD_GCNT_DEV_P_0_MCHBAR_AUNIT_REG     0x00006444
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 0.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid0 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for posted transactions on channel ID 1.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid1 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for posted transactions on channel ID 2.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid2 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for posted transactions on channel ID 3.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid3 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_SHRD_GCNT_DEV_P_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_SHRD_GCNT_DEV_P_1_MCHBAR_AUNIT_REG     0x00006448
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for posted transactions on channel ID 4.
    //
    // Bits[5:0], RO, default = 0x0
    //
    UINTX chid4 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for posted transactions on channel ID 5.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid5 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for posted transactions on channel ID 6.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX chid6 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for posted transactions on channel ID 7.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid7 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_SHRD_GCNT_DEV_P_1_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_SHRD_GCNT_DEV_N_0_MCHBAR_AUNIT_REG     0x0000644C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for non-posted transactions on channel ID 0.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid0 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 1.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid1 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for non-posted transactions on channel ID 2.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX chid2 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for non-posted transactions on channel ID 3.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid3 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_SHRD_GCNT_DEV_N_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_SHRD_GCNT_DEV_N_1_MCHBAR_AUNIT_REG     0x00006450
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for non-posted transactions on channel ID 4.
    //
    // Bits[5:0], RW, default = 0x4
    //
    UINTX chid4 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for non-posted transactions on channel ID 5.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid5 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for non-posted transactions on channel ID 6.
    //
    // Bits[21:16], RW, default = 0x4
    //
    UINTX chid6 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for non-posted transactions on channel ID 7.
    //
    // Bits[29:24], RW, default = 0x1
    //
    UINTX chid7 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_SHRD_GCNT_DEV_N_1_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_SHRD_GCNT_DEV_C_0_MCHBAR_AUNIT_REG     0x00006454
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Grant count for completions on channel ID 0.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX chid0 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Grant count for completions on channel ID 1.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX chid1 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Grant count for completions on channel ID 2.
    //
    // Bits[21:16], RO, default = 0x0
    //
    UINTX chid2 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Grant count for completions on channel ID 3.
    //
    // Bits[29:24], RO, default = 0x0
    //
    UINTX chid3 : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_SHRD_GCNT_DEV_C_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_PRIV_GCNT_CLS_MCHBAR_AUNIT_REG         0x00006458
#ifndef ASM_INC
typedef union {
  struct {
    //
    // All posted.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // All non-posted.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // All Completions.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX c : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 10;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_PRIV_GCNT_CLS_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CRDARB_SHRD_GCNT_CLS_MCHBAR_AUNIT_REG         0x0000645C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // All Posteds
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // All Non Posteds
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // All Completions
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX c : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 10;
  } Bits;
  UINTX Data;
} A_CR_CRDARB_SHRD_GCNT_CLS_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_GZLQ_LIMIT_CH0_3_MCHBAR_AUNIT_REG             0x00006460
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Gazelle queue limit for Upstream NP on channel ID 0.
    //
    // Bits[7:0], RW, default = 0xFF
    //
    UINTX chid0 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 1.
    //
    // Bits[15:8], RW, default = 0xFF
    //
    UINTX chid1 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 2.
    //
    // Bits[23:16], RW, default = 0xFF
    //
    UINTX chid2 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 3.
    //
    // Bits[31:24], RW, default = 0xFF
    //
    UINTX chid3 : 8;
  } Bits;
  UINTX Data;
} A_CR_GZLQ_LIMIT_CH0_3_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_GZLQ_LIMIT_CH4_7_MCHBAR_AUNIT_REG             0x00006464
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Gazelle queue limit for Upstream NP on channel ID 4.
    //
    // Bits[7:0], RW, default = 0xFF
    //
    UINTX chid4 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 5.
    //
    // Bits[15:8], RW, default = 0xFF
    //
    UINTX chid5 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 6.
    //
    // Bits[23:16], RW, default = 0xFF
    //
    UINTX chid6 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 7.
    //
    // Bits[31:24], RW, default = 0xFF
    //
    UINTX chid7 : 8;
  } Bits;
  UINTX Data;
} A_CR_GZLQ_LIMIT_CH4_7_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_IOMMUARB_GCNT_VC0A_0_0_0_MCHBAR_AUNIT_REG     0x00006468
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IOMMU arbiter device grant count for p.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX dev_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // IOMMU arbiter device grant count for NP.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX dev_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // IOMMU arbiter class grant count.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX class_cnt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 10;
  } Bits;
  UINTX Data;
} A_CR_IOMMUARB_GCNT_VC0A_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_IOMMUARB_GCNT_VC0B_0_0_0_MCHBAR_AUNIT_REG     0x0000646C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IOMMU arbiter device grant count for p.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX dev_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // IOMMU arbiter device grant count for NP.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX dev_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // IOMMU arbiter class grant count.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX class_cnt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 10;
  } Bits;
  UINTX Data;
} A_CR_IOMMUARB_GCNT_VC0B_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_IOMMUARB_GCNT_VC1B_0_0_0_MCHBAR_AUNIT_REG     0x00006470
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IOMMU arbiter device grant count for p.
    //
    // Bits[5:0], RW, default = 0x1
    //
    UINTX dev_p : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // IOMMU arbiter device grant count for NP.
    //
    // Bits[13:8], RW, default = 0x1
    //
    UINTX dev_np : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // IOMMU arbiter class grant count.
    //
    // Bits[21:16], RW, default = 0x1
    //
    UINTX class_cnt : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 10;
  } Bits;
  UINTX Data;
} A_CR_IOMMUARB_GCNT_VC1B_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_GZLQ_RSVD_CH0_3_MCHBAR_AUNIT_REG              0x00006474
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Gazelle queue limit for Upstream NP on Channel ID 0.
    //
    // Bits[7:0], RW, default = 0x1
    //
    UINTX chid0 : 8;
    //
    // Gazelle queue limit for Upstream NP on Channel ID 1.
    //
    // Bits[15:8], RW, default = 0x1
    //
    UINTX chid1 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 2.
    //
    // Bits[23:16], RW, default = 0x4
    //
    UINTX chid2 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 3.
    //
    // Bits[31:24], RW, default = 0x4
    //
    UINTX chid3 : 8;
  } Bits;
  UINTX Data;
} A_CR_GZLQ_RSVD_CH0_3_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_GZLQ_RSVD_CH4_7_MCHBAR_AUNIT_REG              0x00006478
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Gazelle queue limit for Upstream NP on channel ID 4.
    //
    // Bits[7:0], RW, default = 0x1
    //
    UINTX chid4 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 5.
    //
    // Bits[15:8], RW, default = 0x1
    //
    UINTX chid5 : 8;
    //
    // Gazellequeue limit for Upstream NP on channel ID 6.
    //
    // Bits[23:16], RW, default = 0x1
    //
    UINTX chid6 : 8;
    //
    // Gazelle queue limit for Upstream NP on channel ID 7.
    //
    // Bits[31:24], RW, default = 0x1
    //
    UINTX chid7 : 8;
  } Bits;
  UINTX Data;
} A_CR_GZLQ_RSVD_CH4_7_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_SPARE_BIOS_MCHBAR_AUNIT_REG                   0x0000647C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Spare RW 32 bits in BIOSWR policy group.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX spare_rw : 32;
  } Bits;
  UINTX Data;
} A_CR_SPARE_BIOS_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPCMD_CRDTMAX_CH0_0_0_0_MCHBAR_AUNIT_REG      0x00006490
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Max posted credits sent to PSF0 for Chid.
    //
    // Bits[6:0], RW, default = 0xC
    //
    UINTX p_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Max non-posted credits sent to PSF0 for Chid.
    //
    // Bits[14:8], RW, default = 0x4
    //
    UINTX np_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Max Cmp credits sent to PSF0 for Chid.
    //
    // Bits[22:16], RW, default = 0x4
    //
    UINTX cmp_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 9;
  } Bits;
  UINTX Data;
} A_CR_UPCMD_CRDTMAX_CH0_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPCMD_CRDTMAX_CH1_0_0_0_MCHBAR_AUNIT_REG      0x00006494
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Max posted credits sent to PSF0 for Chid.
    //
    // Bits[6:0], RW, default = 0x4
    //
    UINTX p_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Max non-posted credits sent to PSF0 for Chid.
    //
    // Bits[14:8], RW, default = 0x4
    //
    UINTX np_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Max Cmp credits sent to PSF0 for Chid.
    //
    // Bits[22:16], RW, default = 0x4
    //
    UINTX cmp_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 9;
  } Bits;
  UINTX Data;
} A_CR_UPCMD_CRDTMAX_CH1_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPCMD_CRDTMAX_CH2_0_0_0_MCHBAR_AUNIT_REG      0x00006498
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Max posted credits sent to PSF0 for Chid.
    //
    // Bits[6:0], RW, default = 0x0
    //
    UINTX p_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Max non-posted credits sent to PSF0 for Chid.
    //
    // Bits[14:8], RW, default = 0x7F
    //
    UINTX np_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Max Cmp credits sent to PSF0 for Chid.
    //
    // Bits[22:16], RW, default = 0x0
    //
    UINTX cmp_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 9;
  } Bits;
  UINTX Data;
} A_CR_UPCMD_CRDTMAX_CH2_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPCMD_CRDTMAX_CH3_0_0_0_MCHBAR_AUNIT_REG      0x0000649C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Max posted credits sent to PSF0 for Chid.
    //
    // Bits[6:0], RW, default = 0x7F
    //
    UINTX p_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Max non-posted credits sent to PSF0 for Chid.
    //
    // Bits[14:8], RW, default = 0x7F
    //
    UINTX np_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Max Cmp credits sent to PSF0 for Chid.
    //
    // Bits[22:16], RW, default = 0x0
    //
    UINTX cmp_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 9;
  } Bits;
  UINTX Data;
} A_CR_UPCMD_CRDTMAX_CH3_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPCMD_CRDTMAX_CH4_0_0_0_MCHBAR_AUNIT_REG      0x000064A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Max posted credits sent to PSF0 for Chid.
    //
    // Bits[6:0], RW, default = 0x0
    //
    UINTX p_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Max non-posted credits sent to PSF0 for Chid.
    //
    // Bits[14:8], RW, default = 0x4
    //
    UINTX np_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Max Cmp credits sent to PSF0 for Chid.
    //
    // Bits[22:16], RW, default = 0x0
    //
    UINTX cmp_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 9;
  } Bits;
  UINTX Data;
} A_CR_UPCMD_CRDTMAX_CH4_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPCMD_CRDTMAX_CH5_0_0_0_MCHBAR_AUNIT_REG      0x000064A4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Max posted credits sent to PSF0 for Chid.
    //
    // Bits[6:0], RW, default = 0x4
    //
    UINTX p_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Max non-posted credits sent to PSF0 for Chid.
    //
    // Bits[14:8], RW, default = 0x4
    //
    UINTX np_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Max Cmp credits sent to PSF0 for Chid.
    //
    // Bits[22:16], RW, default = 0x0
    //
    UINTX cmp_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 9;
  } Bits;
  UINTX Data;
} A_CR_UPCMD_CRDTMAX_CH5_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPCMD_CRDTMAX_CH6_0_0_0_MCHBAR_AUNIT_REG      0x000064A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Max posted credits sent to PSF0 for Chid.
    //
    // Bits[6:0], RW, default = 0x4
    //
    UINTX p_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Max non-posted credits sent to PSF0 for Chid.
    //
    // Bits[14:8], RW, default = 0x4
    //
    UINTX np_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Max Cmp credits sent to PSF0 for Chid.
    //
    // Bits[22:16], RW, default = 0x0
    //
    UINTX cmp_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 9;
  } Bits;
  UINTX Data;
} A_CR_UPCMD_CRDTMAX_CH6_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UPCMD_CRDTMAX_CH7_0_0_0_MCHBAR_AUNIT_REG      0x000064AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Max posted credits sent to PSF0 for Chid.
    //
    // Bits[6:0], RW, default = 0xC
    //
    UINTX p_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Max non-posted credits sent to PSF0 for Chid.
    //
    // Bits[14:8], RW, default = 0x4
    //
    UINTX np_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Max Cmp credits sent to PSF0 for Chid.
    //
    // Bits[22:16], RW, default = 0x0
    //
    UINTX cmp_max : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 9;
  } Bits;
  UINTX Data;
} A_CR_UPCMD_CRDTMAX_CH7_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_MOT_OUT_BASE_0_0_0_MCHBAR_AUNIT_REG           0x000064C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[13:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 14;
    //
    // Specifies bits 38:24 of the start address of the MOT memory region.  Region size
    // must be a strict poweroftwo at least 16MB and naturally aligned to the size.
    // These bits are compared with the result of the MOT_OUT_MASK[28:14] applied to
    // bits 38:24 of the incoming address to determine if an access falls within the
    // MOT region.
    //
    // Bits[28:14], RW, default = 0x0
    //
    UINTX mot_out_base : 15;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:29], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Asset Classification (AC)[0]: Trace Enable: Enables snooping of transactions to
    // the IMR region by tracing agents such as MOT.  Reserved and set to 0 for the MOT
    // region, since otherwise this would enable recursive
    //
    // Bits[30:30], RO, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // IMR Enable: Enables access checking for the MOT region.  Note: this does not enable
    // MOT itself merely enables access control checks for transactions that attempt
    // to access the MOT buffer.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} A_CR_MOT_OUT_BASE_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_MOT_OUT_MASK_0_0_0_MCHBAR_AUNIT_REG           0x000064C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[13:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 14;
    //
    // Specifies the size of the MOT region.  If Request Address [38:24] ANDed with MOT_OUT_MASK[28:14]
    // matches the MOT_OUT_BASE[28:14] then the request falls within the MOT_OUT region
    //
    // Bits[28:14], RW, default = 0x0
    //
    UINTX mot_out_mask : 15;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:29], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Asset Classification AC[1]: IA Implicit WB Enable: Enables implicit writebacks
    // to protected region from IA caching agent.  When set to 1 enables implicit writeback
    // data HITM data from IA cores to be returned to the requester.  When set to 0 inhibits
    // HITM data from IA cores from being returned to the requester.  HITM data from
    // GT may be returned to the requester depending on the setting of the GT_IWB_EN
    // bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: GT Implicit WB Enable: Enables implicit writebacks
    // to protected region from GT caching agent. When set to 1 enables implicit writeback
    // data HITM data from GT to be returned to the requester.  When set to 0 inhibits
    // HITM data from GT from being returned to the requester.  HITM data from IA cores
    // may be returned to the requester depending on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} A_CR_MOT_OUT_MASK_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_P_U_CODEWR_ALLRD_CP_0_0_0_MCHBAR_AUNIT_REG    0x000064E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the Aunit P_U_CODEWR_ALLRD
    // based on the value from the agents 6 bit SAI field. This register is selfreferential
    // the access policy provided applies to access to the control register itself.
    //
    // Bits[63:0], RW, default = 0x40001000202
    //
    UINTX p_u_codewr_allrd_cp : 64;
  } Bits;
  UINTX Data;
} A_CR_P_U_CODEWR_ALLRD_CP_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_P_U_CODEWR_ALLRD_RAC_0_0_0_MCHBAR_AUNIT_REG   0x000064E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed Rd access to the Aunit P_U_CODEWR_ALLRD
    // based on the value from the agents 6 bit SAI field.
    //
    // Bits[63:0], RO, default = 0xFFFFFFFFFFFFFFFF
    //
    UINTX p_u_codewr_allrd_rac : 64;
  } Bits;
  UINTX Data;
} A_CR_P_U_CODEWR_ALLRD_RAC_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_P_U_CODEWR_ALLRD_WAC_0_0_0_MCHBAR_AUNIT_REG   0x000064F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed Wr access to the Aunit P_U_CODEWR_ALLRD
    // based on the value from the agents 6 bit SAI field.
    //
    // Bits[63:0], RW, default = 0x40001000202
    //
    UINTX p_u_codewr_allrd_wac : 64;
  } Bits;
  UINTX Data;
} A_CR_P_U_CODEWR_ALLRD_WAC_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_BIOSWR_CP_0_0_0_MCHBAR_AUNIT_REG              0x000064C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the A-Unit BIOSWR
    // Registers based on the value from the agents 6 bit SAI field. This register is
    // selfreferential the access policy provided applies to access to the control register
    // itself.
    //
    // Bits[63:0], RW, default = 0x40061010202
    //
    UINTX bioswr_cp : 64;
  } Bits;
  UINTX Data;
} A_CR_BIOSWR_CP_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_BIOSWR_RAC_0_0_0_MCHBAR_AUNIT_REG             0x000064D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed Rd access to the A-Unit
    // BIOSWR Register based on the value from the agents 6 bit SAI field.
    //
    // Bits[63:0], RW, default = 0x80000C0063010217
    //
    UINTX bioswr_rac : 64;
  } Bits;
  UINTX Data;
} A_CR_BIOSWR_RAC_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_BIOSWR_WAC_0_0_0_MCHBAR_AUNIT_REG             0x000064D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed Wr access to the A-Unit
    // BIOSWR registers based on the value from the agents 6 bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061000212
    //
    UINTX bioswr_wac : 64;
  } Bits;
  UINTX Data;
} A_CR_BIOSWR_WAC_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_IMRGLOBAL_BM_CP_0_0_0_MCHBAR_AUNIT_REG        0x00006510
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the A-Unit IMRGLOBAL_BM
    // Registers based on the value from the agents 6 bit SAI field. This register is
    // selfreferential the access policy provided applies to access to the control register
    // itself.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imrglobal_bm_cp : 64;
  } Bits;
  UINTX Data;
} A_CR_IMRGLOBAL_BM_CP_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_IMRGLOBAL_BM_RAC_0_0_0_MCHBAR_AUNIT_REG       0x00006518
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed Rd access to the A-Unit
    // IMRGLOBAL_BM Register based on the value from the agents 6 bit SAI field.
    //
    // Bits[63:0], RO, default = 0xFFFFFFFFFFFFFFFF
    //
    UINTX imrglobal_bm_rac : 64;
  } Bits;
  UINTX Data;
} A_CR_IMRGLOBAL_BM_RAC_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_IMRGLOBAL_BM_WAC_0_0_0_MCHBAR_AUNIT_REG       0x00006520
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed Wr access to the A-Unit
    // IMRGLOBAL_BM registers based on the value from the agents 6 bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imrglobal_bm_wac : 64;
  } Bits;
  UINTX Data;
} A_CR_IMRGLOBAL_BM_WAC_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CHAP_SLCT1_MCHBAR_AUNIT_REG                   0x00006500
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Count upstream txn on all VCs where CHID_X[i]=1.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX chid_x_cnt_uptxn : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 8;
    //
    // Count upstream txn on all VCs where CHID_Y[i]=1.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX chid_y_cnt_uptxn : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:24], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 8;
  } Bits;
  UINTX Data;
} A_CR_CHAP_SLCT1_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CHAP_SLCT2_MCHBAR_AUNIT_REG                   0x00006504
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Count downstream txn on all VCs where CHID_X[i]=1.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX chid_x_cnt_dntxn : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 8;
    //
    // Count downstream txn on all VCs where CHID_Y[i]=1.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX chid_y_cnt_dntxn : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:24], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 8;
  } Bits;
  UINTX Data;
} A_CR_CHAP_SLCT2_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_CHAP_SLCT3_MCHBAR_AUNIT_REG                   0x00006508
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Count occupancy/residency of certain Q in A-Unit
    //    [list]
    //    [*]00: UpCmd
    //    [*]01: UpData
    //    [*]10: GzlQ
    //    [*]11: DnCmd/Data
    //    [/list]
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX q_occupancy_x : 2;
    //
    // Count occupancy/residency of certain Q in A-Unit
    //           [list]
    //    [*]00: UpCmd
    //    [*]01: UpData
    //    [*]10: GzlQ
    //    [*]11: DnCmd/Data
    //    [/list]
    //
    // Bits[3:2], RW, default = 0x1
    //
    UINTX q_occupancy_y : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 28;
  } Bits;
  UINTX Data;
} A_CR_CHAP_SLCT3_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UNCERRSTS_0_0_0_MCHBAR_AUNIT_REG              0x00006588
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Illegal/Unsupported posted opcode received from iosf.
    //
    // Bits[0:0], RW/1C, default = 0x0
    //
    UINTX illegal_posted_opcode : 1;
    //
    // An incorrect/illegal sai was received with an upstream posted transaction.
    //
    // Bits[1:1], RW/1C, default = 0x0
    //
    UINTX bad_sai_posted : 1;
    //
    // Illegal/Unsupported non-posted opcode received from iosf.
    //
    // Bits[2:2], RW/1C, default = 0x0
    //
    UINTX illegal_nonposted_opcode : 1;
    //
    // An incorrect/illegal sai was received with an upstream non-posted transaction.
    //
    // Bits[3:3], RW/1C, default = 0x0
    //
    UINTX bad_sai_nonposted : 1;
    //
    // Received a CmplLck completion from iosf.
    //
    // Bits[4:4], RW/1C, default = 0x0
    //
    UINTX received_lk_cmpl : 1;
    //
    // An incorrect/illegal sai was received with an upstream completion transaction.
    //
    // Bits[5:5], RW/1C, default = 0x0
    //
    UINTX bad_sai_cmpl : 1;
    //
    // reserved for future use
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX undefined5 : 1;
    //
    // A device that is not support to set the AT bit set it to an illegal value
    //
    // Bits[7:7], RW/1C, default = 0x0
    //
    UINTX at_translated_illegal_device : 1;
    //
    // A malformed/illegal MSI was received in the upstream direction
    //
    // Bits[8:8], RW/1C, default = 0x0
    //
    UINTX illegal_msi : 1;
    //
    // A transaction was received with a guest physical address that was too large
    //
    // Bits[9:9], RW/1C, default = 0x0
    //
    UINTX gpa_overflow : 1;
    //
    // An MSI was received with reserved bits set
    //
    // Bits[10:10], RW/1C, default = 0x0
    //
    UINTX msi_rsvd_set : 1;
    //
    // reserved for future use
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX undefined11 : 1;
    //
    // reserved for future use
    //
    // Bits[12:12], RO, default = 0x0
    //
    UINTX undefined12 : 1;
    //
    // reserved for future use
    //
    // Bits[13:13], RO, default = 0x0
    //
    UINTX undefined13 : 1;
    //
    // reserved for future use
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX undefined14 : 1;
    //
    // reserved for future use
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX undefined15 : 1;
    //
    // reserved for future use
    //
    // Bits[16:16], RO, default = 0x0
    //
    UINTX undefined16 : 1;
    //
    // reserved for future use
    //
    // Bits[17:17], RO, default = 0x0
    //
    UINTX undefined17 : 1;
    //
    // reserved for future use
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX undefined18 : 1;
    //
    // reserved for future use
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX undefined19 : 1;
    //
    // reserved for future use
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX undefined20 : 1;
    //
    // reserved for future use
    //
    // Bits[21:21], RO, default = 0x0
    //
    UINTX undefined21 : 1;
    //
    // reserved for future use
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX undefined22 : 1;
    //
    // reserved for future use
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX undefined23 : 1;
    //
    // reserved for future use
    //
    // Bits[24:24], RO, default = 0x0
    //
    UINTX undefined24 : 1;
    //
    // reserved for future use
    //
    // Bits[25:25], RO, default = 0x0
    //
    UINTX undefined25 : 1;
    //
    // reserved for future use
    //
    // Bits[26:26], RO, default = 0x0
    //
    UINTX undefined26 : 1;
    //
    // reserved for future use
    //
    // Bits[27:27], RO, default = 0x0
    //
    UINTX undefined27 : 1;
    //
    // reserved for future use
    //
    // Bits[28:28], RO, default = 0x0
    //
    UINTX undefined28 : 1;
    //
    // reserved for future use
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX undefined29 : 1;
    //
    // reserved for future use
    //
    // Bits[30:30], RO, default = 0x0
    //
    UINTX undefined30 : 1;
    //
    // reserved for future use
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX undefined31 : 1;
  } Bits;
  UINTX Data;
} A_CR_UNCERRSTS_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_UNCERRMSK_0_0_0_MCHBAR_AUNIT_REG              0x0000658C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Illegal/Unsupported posted opcode received from iosf.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX illegal_posted_opcode : 1;
    //
    // An incorrect/illegal sai was received with an upstream posted transaction.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX bad_sai_posted : 1;
    //
    // Illegal/Unsupported non-posted opcode received from iosf.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX illegal_nonposted_opcode : 1;
    //
    // An incorrect/illegal sai was received with an upstream non-posted transaction.
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX bad_sai_nonposted : 1;
    //
    // Received a CmplLck completion from iosf.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX received_lk_cmpl : 1;
    //
    // An incorrect/illegal sai was received with an upstream completion transaction.
    //
    // Bits[5:5], RW, default = 0x1
    //
    UINTX bad_sai_cmpl : 1;
    //
    // reserved for future use
    //
    // Bits[6:6], RO, default = 0x1
    //
    UINTX undefined5 : 1;
    //
    // A device that is not support to set the AT bit set it to an illegal value
    //
    // Bits[7:7], RW, default = 0x1
    //
    UINTX at_translated_illegal_device : 1;
    //
    // A malformed/illegal MSI was received in the upstream direction
    //
    // Bits[8:8], RW, default = 0x1
    //
    UINTX illegal_msi : 1;
    //
    // A transaction was received with a guest physical address that was too large
    //
    // Bits[9:9], RW, default = 0x1
    //
    UINTX gpa_overflow : 1;
    //
    // An MSI was received with reserved bits set
    //
    // Bits[10:10], RW, default = 0x1
    //
    UINTX msi_rsvd_set : 1;
    //
    // reserved for future use
    //
    // Bits[11:11], RO, default = 0x1
    //
    UINTX undefined11 : 1;
    //
    // reserved for future use
    //
    // Bits[12:12], RO, default = 0x1
    //
    UINTX undefined12 : 1;
    //
    // reserved for future use
    //
    // Bits[13:13], RO, default = 0x1
    //
    UINTX undefined13 : 1;
    //
    // reserved for future use
    //
    // Bits[14:14], RO, default = 0x1
    //
    UINTX undefined14 : 1;
    //
    // reserved for future use
    //
    // Bits[15:15], RO, default = 0x1
    //
    UINTX undefined15 : 1;
    //
    // reserved for future use
    //
    // Bits[16:16], RO, default = 0x1
    //
    UINTX undefined16 : 1;
    //
    // reserved for future use
    //
    // Bits[17:17], RO, default = 0x1
    //
    UINTX undefined17 : 1;
    //
    // reserved for future use
    //
    // Bits[18:18], RO, default = 0x1
    //
    UINTX undefined18 : 1;
    //
    // reserved for future use
    //
    // Bits[19:19], RO, default = 0x1
    //
    UINTX undefined19 : 1;
    //
    // reserved for future use
    //
    // Bits[20:20], RO, default = 0x1
    //
    UINTX undefined20 : 1;
    //
    // reserved for future use
    //
    // Bits[21:21], RO, default = 0x1
    //
    UINTX undefined21 : 1;
    //
    // reserved for future use
    //
    // Bits[22:22], RO, default = 0x1
    //
    UINTX undefined22 : 1;
    //
    // reserved for future use
    //
    // Bits[23:23], RO, default = 0x1
    //
    UINTX undefined23 : 1;
    //
    // reserved for future use
    //
    // Bits[24:24], RO, default = 0x1
    //
    UINTX undefined24 : 1;
    //
    // reserved for future use
    //
    // Bits[25:25], RO, default = 0x1
    //
    UINTX undefined25 : 1;
    //
    // reserved for future use
    //
    // Bits[26:26], RO, default = 0x1
    //
    UINTX undefined26 : 1;
    //
    // reserved for future use
    //
    // Bits[27:27], RO, default = 0x1
    //
    UINTX undefined27 : 1;
    //
    // reserved for future use
    //
    // Bits[28:28], RO, default = 0x1
    //
    UINTX undefined28 : 1;
    //
    // reserved for future use
    //
    // Bits[29:29], RO, default = 0x1
    //
    UINTX undefined29 : 1;
    //
    // reserved for future use
    //
    // Bits[30:30], RO, default = 0x1
    //
    UINTX undefined30 : 1;
    //
    // reserved for future use
    //
    // Bits[31:31], RO, default = 0x1
    //
    UINTX undefined31 : 1;
  } Bits;
  UINTX Data;
} A_CR_UNCERRMSK_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_SLICE_CHANNEL_HASH_0_0_0_MCHBAR_AUNIT_REG     0x000065C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Slice 1 is disabled; no memory address mapped to Slice 1.  All request sent to
    // Slice 0.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX slice_1_disabled : 1;
    //
    //
    //    [list]
    //    [*]0: HVM mode is disabled.
    //    [*]1: HVM mode is enabled.
    //           [/list]
    //    [p]When HVM mode is enabled, Slice Hash and Channel Hash is done as follows:[/p]
    //    [p]Both slices and all four PMI channels enabled:[/p]
    //    [list]
    //    [*]Slice Hash is Request Physical Addr[29]
    //    [*]Channel Hash is PostRemap Addr[30]
    //    [/list]
    //    [p]Both slices enabled but only one PMI channel in each slice enabled:[/p]
    //    [list]
    //    [*]Slice Hash is Request Physical Addr[29]
    //           [/list]
    //    [p]Only one SLICE0 enabled but both PMI channels in SLICE0 enabled:[/p]
    //    [list]
    //    [*]Channel Hash is PostRemap Addr[29]
    //           [/list]
    //    [p]When HVM_MODE is enabled TOLUD must be set at 2GB.[/p]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX hvm_mode : 1;
    //
    // Default interleave mode that specifies how the Slice Selector and Channel Selector
    // bits are to be determined.  Relevant only when HVM mode is disabled and only for
    // system memory addresses that do not fall under the MOT region or the Asymmetric
    // memory region in the System Address Map.  Legal encodings are 0x0 0x1 and 0x2.
    //  An encoding of 0x3 is treated as if it was 0x2.   When both slices and all four
    // PMI channels are enabled:
    //    [list]
    //    [*]0h: Default Slice Selector is Addr[10] and Default Channel Selector is Addr[11]
    //
    //    [*]1h: Default Slice Selector is Addr[11] and Default Channel Selector is Addr[12]
    //
    //    [*]2h: Default Slice Selector is Addr[12] and Default Channel Selector is Addr[13]
    //           [/list]
    //    [p]When both slices are enabled but only one channel in each slice enabled:[/p]
    //           [list]
    //    [*]0h: Default Slice Selector is Addr[10]
    //    [*]1h: Default Slice Selector is Addr[11]
    //    [*]2h: Default Slice Selector is Addr[12]
    //    [/list]
    //    [p]When only SLICE0 is enabled and both channels on that slice are enabled:[/p]
    //           [list]
    //    [*]0h: Default Channel Selector is Addr[10]
    //    [*]1h: Default Channel Selector is Addr[11]
    //    [*]2h: Default Channel Selector is Addr[12]
    //    [/list]
    //    [p]When SLICE0 and only one channel in that slice is enabled this field is
    // not relevant.  B-Unit overrides the setting of the SLICE_HASH_MASK to always include
    // the Slice Selector bit.  Similarly, B-Unit overrides the setting of the CH_HASH_MASK
    // to always include the Channel Selector bit.[/p]
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX interleave_mode : 2;
    //
    // Slice 0 is disabled for memory accesses; no memory address mapped to Slice 0 and
    // all memory requests sent to Slice 1.  In BXT, this bit is RO with the value of
    // 0.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX slice_0_mem_disabled : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // When both slices are enabled this field specifies the Slice Hash Mask to be applied
    // on Addr[19:6] physical address of the request to compute which slice a request
    // must be routed to.  Relevant only when HVM mode is disabled and only for physical
    // addresses that do not fall under the Asymmetric Memory Region and the MOT region.
    //  B-Unit will override the programmed value to include the Slice Selector bit See
    // INTERLEAVE_MODE field.  Note that HVM mode nonaddress IDI requests asymmetric
    // memory region and MOT regions have special hash requirements and hence they do
    // not use the SLICE_HASH_MASK.
    //
    // Bits[19:6], RW, default = 0x0
    //
    UINTX slice_hash_mask : 14;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 11;
    //
    // When set to 1, Single Command Interface and Dual Data Interface for Reads and
    // Writes
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX enable_pmi_dual_data_mode : 1;
    //
    // Channel 1 in both slices are disabled no memory address mapped to ch 1. All requests
    // sent to channel 0.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX ch_1_disabled : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[33:33], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 1;
    //
    // Specifies which channel is enabled for Slice 0, This is for those cases where
    // Channel 0 or 1 could be disabled for Slice 0
    //                         If both bits are set then channel select will be based
    // on the Channel Select logic
    //
    // Bits[35:34], RW, default = 0x3
    //
    UINTX sym_slice0_channel_enabled : 2;
    //
    // Specifies which channel is enabled for Slice 1, This is for those cases where
    // Channel 0 or 1 could be disabled for Slice 1
    //                         If both bits are set then channel select will be based
    // on the Channel Select logic
    //
    // Bits[37:36], RW, default = 0x3
    //
    UINTX sym_slice1_channel_enabled : 2;
    //
    // When both PMI channels in a slice are enabled, this field specifies the Channel
    // Hash Mask to be applied on Addr[19:6] postremap DRAM address of the request to
    // compute which PMI channel a request must be routed to.  Relevant only when HVM
    // mode is disabled and only for requests that do not fall under the MOT region.
    //  B-Unit will override the programmed value to include the Channel Selector bit
    // See SLICEHASH.INTERLEAVE_MODE field.  Note that HVM mode and MOT regions have
    // special hash requirements and hence they do not use the CH_HASH_MASK.
    //
    // Bits[51:38], RW, default = 0x0
    //
    UINTX ch_hash_mask : 14;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[62:52], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 11;
    //
    // Intended usage is for BIOS to set the LOCK when it updates the CR.  A-Unit implements
    // only storage for this bit.  No hardware exists to implement hardware locking.
    //
    //    [p]NOTE:  B-Unit copy of this bit is used by ucode to protect WRMSR to the
    // B-Unit's CR.  Ucode has no access to the A-Unit's copy of the CR.[/p]
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX lock : 1;
  } Bits;
  UINTX Data;
} A_CR_SLICE_CHANNEL_HASH_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_MIRROR_RANGE_0_0_0_MCHBAR_AUNIT_REG           0x000065C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Mirror Base: specifies b38:b23 of HPA indicating the start of mirror packet buffer
    // region
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX mirror_base : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
    //
    // Mirror Limit: specifies b38:b23 of HPA indicating the end of mirror packet buffer
    // region
    //
    // Bits[47:32], RW, default = 0x0
    //
    UINTX mirror_limit : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[63:48], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 16;
  } Bits;
  UINTX Data;
} A_CR_MIRROR_RANGE_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_ASYM_MEM_REGION0_0_0_0_MCHBAR_AUNIT_REG       0x000065D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // Specifies bits [38:31] of the base address of asymmetric memory region 0 (in slice
    // 0); all the lower bits of the region's base address are equal to 0.
    //
    // Bits[14:4], RW, default = 0x0
    //
    UINTX slice0_asym_base : 11;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[18:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // Specifies bits [38:31] of the highest address of asymmetric memory region 0 (in
    // slice 0); all the lower bits of the region's highest address are equal to 1.
    //
    // Bits[29:19], RW, default = 0x0
    //
    UINTX slice0_asym_limit : 11;
    //
    // Specifies which Channel in ASYM Slice 0 request is sent
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX slice0_asym_channel_select : 1;
    //
    // Setting this bit to 0 disables asymmetric memory region 0; setting it to 1 enables
    // the region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX slice0_asym_enable : 1;
  } Bits;
  UINTX Data;
} A_CR_ASYM_MEM_REGION0_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_ASYM_MEM_REGION1_0_0_0_MCHBAR_AUNIT_REG       0x000065D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // Specifies bits [38:31] of the base address of asymmetric memory region 1 (in slice
    // 1); all the lower bits of the region's base address are equal to 0.
    //
    // Bits[14:4], RW, default = 0x0
    //
    UINTX slice1_asym_base : 11;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[18:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // Specifies bits [38:31] of the highest address of asymmetric memory region 1 (in
    // slice 1); all the lower bits of the region's highest address are equal to 1.
    //
    // Bits[29:19], RW, default = 0x0
    //
    UINTX slice1_asym_limit : 11;
    //
    // Specifies Channel for ASYM Region Slice 1
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX slice1_asym_channel_select : 1;
    //
    // Setting this bit to 0 disables asymmetric memory region 1; setting it to 1 enables
    // the region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX slice1_asym_enable : 1;
  } Bits;
  UINTX Data;
} A_CR_ASYM_MEM_REGION1_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC

#define A_CR_ASYM_2WAY_MEM_REGION_0_0_0_MCHBAR_AUNIT_REG   0x000065D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    //
    //                Going with 2 bits here.
    //                2'b00 : Asymmetric memory Split between Channel 0 of Slice 0 and
    // Slice 1
    //                2'b01 : Asymmetric memory split between Channel 1 of Slice 0 and
    // Slice 1
    //                2'b10 : Asymmetric memory split between Channel 0 and Channel 1
    // of Slice 0
    //                2'b11 : Asymmetric memory split between Channel 0 and Channel 1
    // of Slice 1
    //
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX asym_2way_intlv_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Specifies bits [38:28] of the base address of Interleave Asymmetric Region; all
    // the lower bits of the region's base address are equal to 0.
    //
    // Bits[14:4], RW, default = 0x0
    //
    UINTX asym_2way_base : 11;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[16:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Specifies bits [38:28] of the highest address of Interleave Asymmetric Region,
    // all the lower bits of the region's highest address are equal to 1.
    //
    // Bits[27:17], RW, default = 0x0
    //
    UINTX asym_2way_limit : 11;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 3;
    //
    // Setting this bit to 0 disables Interleave Asymmetric memory region 1, setting
    // it to 1 enables the region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX asym_2way_interleave_enable : 1;
  } Bits;
  UINTX Data;
} A_CR_ASYM_2WAY_MEM_REGION_0_0_0_MCHBAR_AUNIT_STRUCT;
#endif // ASM_INC


#endif // _AUNIT_H_
