/** @file
  File name:    DPIC.h
  Input File:   BXTP_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in DPIC.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

  @copyright
  Copyright (c) 2005-2016 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by the
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is uniquely
  identified as 'Intel Reference Module' and is licensed for Intel
  CPUs and chipsets under the terms of your license agreement with
  Intel or your vendor. This file may be modified by the user, subject
  to additional terms of the license agreement.

  @par Specification
**/
#ifndef _DPIC_H_
#define _DPIC_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define DPIC_CRI_CFG_DPIC_REG                              0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Idle count limit for ISM which is determines when the block should transition
    // to IDLE_REQ. Recommended value = 8'd16.[br]A value of zero breaks the design resulting
    // in an unresponsive endpoint.
    //
    // Bits[7:0], RW, default = 0x10
    //
#ifdef MEM_SV_HOOKS
    UINTX cgctrl_idlecnt : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Clock gate defeature. When set to 1, disables side_clk gating within the endpoint
    // when ISM is IDLE. Set to 0 for normal operation. Recommended value = 0
    //
    // Bits[8:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX cgctrl_clkgatedef : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Clock gate enable. When set to 1, enables the ISM to leave ACTIVE and gates the
    // side_clk if in the IDLE state. When set to 0, the ISM never leaves ACTIVE once
    // it gets to that state and the clock is never gated. Recommended value = 1.
    //
    // Bits[9:9], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX cgctrl_clkgaten : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[15:10], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 6;
#else
    UINTX reserved_3 : 6;
#endif // MEM_SV_HOOKS
    //
    // LDO offset c73p1ddrlp34l64x1top_comp (LPDDR 3/4 Mode Indication)
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ldomaindig_cmn_startldooffsetcomp : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 15;
#else
    UINTX reserved_5 : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_CRI_CFG_DPIC_STRUCT;
#endif // ASM_INC

#define PLLDIVCTL_DPIC_REG                                 0x00000004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // mplldivs reference divider ratio select (diva). not part of adpll.
    //
    // Bits[4:0], RW, default = 0x2
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_refdivsel : 5;
#else
    UINTX reserved : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 19;
#else
    UINTX reserved_1 : 19;
#endif // MEM_SV_HOOKS
    //
    // mplldivs feedback multiplexer select (muxa). not part of adpll.
    //
    // Bits[25:24], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_fbmuxsel : 2;
#else
    UINTX reserved_2 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[27:26], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // Feedback clock reset addition (used during power switch operation)
    //
    // Bits[28:28], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX fbdivrst_b : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 3;
#else
    UINTX reserved_5 : 3;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} PLLDIVCTL_DPIC_STRUCT;
#endif // ASM_INC

#define PLLCTL_DPIC_REG                                    0x00000008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // pll enable signal
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_pllen : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // pll lock signal (hardware based)
    //
    // Bits[1:1], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_plllock : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // forces sfr on even when pll is disabled (active standby mode)
    //
    // Bits[2:2], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_sfren : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // forces dco calibration when exiting deep sleep mode. required if changing feedback
    // divider ratio or refclk frequency
    //
    // Bits[3:3], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_dcocal : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // o_locktimer asserts after the coresponding ip pll lock time spec (in refclk cycles)
    // starting from i_refclk_ack assertion and after all cold boot calibration sequence
    // done. i_locktimercnt_th would determine the number of refclk cycles
    //
    // Bits[4:4], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_plltimerlock : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[7:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved3 : 3;
#else
    UINTX reserved_5 : 3;
#endif // MEM_SV_HOOKS
    //
    // mplldivs divider reset bar
    //
    // Bits[8:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_mplldivsrstb : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[11:9], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved2 : 3;
#else
    UINTX reserved_7 : 3;
#endif // MEM_SV_HOOKS
    //
    // mplldivs 2xclk multiplexer select (muxc). not part of adpll.
    //
    // Bits[13:12], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_2xclkmuxsel : 2;
#else
    UINTX reserved_8 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[15:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 2;
#else
    UINTX reserved_9 : 2;
#endif // MEM_SV_HOOKS
    //
    // 2x clock tree drive output enable
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_2xclken : 1;
#else
    UINTX reserved_10 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[19:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 3;
#else
    UINTX reserved_11 : 3;
#endif // MEM_SV_HOOKS
    //
    // PLL feedback clock trim bits
    //
    // Bits[24:20], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_fbclktrim : 5;
#else
    UINTX reserved_12 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:25], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_13 : 7;
#else
    UINTX reserved_13 : 7;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} PLLCTL_DPIC_STRUCT;
#endif // ASM_INC

#define CRIPG_DELAY1_DPIC_REG                              0x0000000C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay for staggered power gate disable. Determines the number of cycles interval
    // between each power gate enable bit being de-asserted. Cripgctrl FSM is in PWRUNGATE
    // state. A value of zero breaks the design resulting in an unresponsive powergating
    // control.
    //
    // Bits[2:0], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_disable_stgdly : 3;
#else
    UINTX reserved : 3;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[3:3], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Delay for staggered power gate enable. Determines the number of cycles interval
    // between each power gate enable bit being asserted. Cripgctrl FSM is in PWRGATE
    // state. A value of zero breaks the design resulting in an unresponsive powergating
    // control.
    //
    // Bits[6:4], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_enable_stgdly : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Delay for staggered power gate enable. Determines the number of cycles interval
    // between each power gate enable bit being asserted. Cripgctrl FSM is in PWRGATE
    // state. Value of 0 not supported.
    //
    // Bits[15:8], RW, default = 0x3
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_clkgaten_stgdly : 8;
#else
    UINTX reserved_4 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 16;
#else
    UINTX reserved_5 : 16;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CRIPG_DELAY1_DPIC_STRUCT;
#endif // ASM_INC

#define CRIPG_DELAY0_DPIC_REG                              0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When both fabric and agent ISMs are idle. This delay indicates the no. of cycle
    // the FSMs need to be idle after receiving clkack before entering power gating flow.
    // A value of zero breaks the design resulting in an unresponsive powergating control.
    //
    // Bits[7:0], RW, default = 0x14
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_ism_idle_dly : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // On wakeup, this indicates the no. of cycles that FSM stays in PWRUGCLKACK after
    // receiving clkack. A value of zero breaks the design resulting in an unresponsive
    // powergating control.
    //
    // Bits[15:8], RW, default = 0x3
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_clkreq_dsrt_dly : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // No. of cycles after agent ism idle lock/unlock before FSM moves on from ISMLOCK/ISMUNLOCK.
    // A value of zero breaks the design resulting in an unresponsive powergating control.
    //
    // Bits[18:16], RW, default = 0x3
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_ism_lock_dly : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[19:19], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // No. of cycles after staggered reset assertion/de-assertion before FSM moves on
    // from RSTASRT/RSTDSRT. A value of zero breaks the design resulting in an unresponsive
    // powergating control.
    //
    // Bits[22:20], RW, default = 0x2
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_rst_asrt_dly : 3;
#else
    UINTX reserved_4 : 3;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // No. of cycles after isolation cells are enabled/disabled before FSM moves on from
    // ISOLEN/ISOLDIS. A value of zero breaks the design resulting in an unresponsive
    // powergating control.
    //
    // Bits[25:24], RW, default = 0x2
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_isol_en_dly : 2;
#else
    UINTX reserved_6 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:26], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_7 : 6;
#else
    UINTX reserved_7 : 6;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CRIPG_DELAY0_DPIC_STRUCT;
#endif // ASM_INC

#define CRIPGCTL_DPIC_REG                                  0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Config override for staggered power gate enable. When set to '1' cripgen_staggered[3:0]
    // is equal to the value set in cripgen_staggered register field. When set to '0',
    // cripgen_staggered[3:0] is equal to the logic defined value.
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX cripgen_staggered_ovr : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[3:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // Config control for staggered power gate enable. This config value is used for
    // the cripgen_staggered[3:0] when config override in cripgen_staggered_ovr is set
    // to '1'. This value is ignored if cripgen_staggered_ovr is set to '0'.
    //
    // Bits[7:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX cripgen_staggered : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[11:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 4;
#else
    UINTX reserved_3 : 4;
#endif // MEM_SV_HOOKS
    //
    // Config override for isolation enable. This config value is used for isol_en when
    // config override in cripg_isolen_ovr is set to '1'. This value is ignored if cripg_isolen_ovr
    // is set to '0'.
    //
    // Bits[12:12], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_isolen_ovr : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Config control for isolation enable. This config value is used for isol_en when
    // config override in cripg_isolen_ovr is set to '1'. This value is ignored if cripg_isolen_ovr
    // is set to '0'.
    //
    // Bits[13:13], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_isolen : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // Config control for side clock req. This config value is used to override o_side_clkreq.
    // When this config bit is set to '1', o_side_clkreq is set to '1' except when in
    // CLKREQDSRT state of the CRIPG FSM
    //
    // Bits[14:14], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_side_clkreq_ovr : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // Config control for side clock req. This config value is used to override o_side_clkreq.
    // When this config bit is set to '1', o_side_clkreq is set to '1' except when in
    // CLKREQDSRT state of the CRIPG FSM
    //
    // Bits[15:15], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX cripg_clkgaten_ovr : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_8 : 16;
#else
    UINTX reserved_8 : 16;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CRIPGCTL_DPIC_STRUCT;
#endif // ASM_INC

#define CRIPGEN_CTL_DPIC_REG                               0x00000018
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CRI Power Gating Enable. When set to '1' - CRI Power gating logic is enabled.
    // When set to '0' - CRI Power gating logic is disabled.
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX cripgen : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CRIPGEN_CTL_DPIC_STRUCT;
#endif // ASM_INC

#define OBSCTL0_DPIC_REG                                   0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Digital Observation Control 0
    //
    // Bits[3:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX func_mon_cc0_digobs0sel : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // Digital Observation Control 1
    //
    // Bits[7:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX func_mon_cc0_digobs1sel : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Analog Observation Control
    //
    // Bits[9:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX func_mon_cc0_anaobssel : 2;
#else
    UINTX reserved_2 : 2;
#endif // MEM_SV_HOOKS
    //
    // Digital Observation Control 0
    //
    // Bits[13:10], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX func_mon_cc1_digobs0sel : 4;
#else
    UINTX reserved_3 : 4;
#endif // MEM_SV_HOOKS
    //
    // Digital Observation Control 1
    //
    // Bits[17:14], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX func_mon_cc1_digobs1sel : 4;
#else
    UINTX reserved_4 : 4;
#endif // MEM_SV_HOOKS
    //
    // Analog Observation Control
    //
    // Bits[19:18], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX func_mon_cc1_anaobssel : 2;
#else
    UINTX reserved_5 : 2;
#endif // MEM_SV_HOOKS
    //
    // Digital Observation Control 0
    //
    // Bits[23:20], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX func_mon_dq_digobs0sel : 4;
#else
    UINTX reserved_6 : 4;
#endif // MEM_SV_HOOKS
    //
    // Digital Observation Control 1
    //
    // Bits[27:24], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX func_mon_dq_digobs1sel : 4;
#else
    UINTX reserved_7 : 4;
#endif // MEM_SV_HOOKS
    //
    // Analog Observation Control
    //
    // Bits[29:28], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX func_mon_dq_anaobssel : 2;
#else
    UINTX reserved_8 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_9 : 2;
#else
    UINTX reserved_9 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} OBSCTL0_DPIC_STRUCT;
#endif // ASM_INC

#define OBSCTL1_DPIC_REG                                   0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PLL Digital Observation Control 0
    //
    // Bits[3:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_digobs0sel : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // PLL Digital Observation Control 1
    //
    // Bits[7:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_digobs1sel : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // PLL Analog Observation Control 0
    //
    // Bits[9:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_anaobs0sel : 2;
#else
    UINTX reserved_2 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[11:10], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved3 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // PLL Analog Observation Control 1
    //
    // Bits[13:12], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_anaobs1sel : 2;
#else
    UINTX reserved_4 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[15:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved2 : 2;
#else
    UINTX reserved_5 : 2;
#endif // MEM_SV_HOOKS
    //
    // PLL Digital Observation Enable
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_digobsen : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[19:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 3;
#else
    UINTX reserved_7 : 3;
#endif // MEM_SV_HOOKS
    //
    // PLL Analog Observation Enable
    //
    // Bits[20:20], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_anaobsen : 1;
#else
    UINTX reserved_8 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[23:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 3;
#else
    UINTX reserved_9 : 3;
#endif // MEM_SV_HOOKS
    //
    // PLL Error Flag
    //
    // Bits[24:24], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_errorflag : 1;
#else
    UINTX reserved_10 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:25], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_11 : 7;
#else
    UINTX reserved_11 : 7;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} OBSCTL1_DPIC_STRUCT;
#endif // ASM_INC

#define SPIDCLKCTL0_DPIC_REG                               0x00000024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // SPID Usync counter load value. This indicates the ratio between the mpllusync
    // and spidclkusync
    //
    // Bits[5:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX usynccounter : 6;
#else
    UINTX reserved : 6;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // Early usync setting (with respect to global usync boundary)[br]2 : 2 clocks prior
    // to global sync boundary[br]3 : 3 clocks prior to global sync boundary[br]and so
    // on.
    //
    // Bits[11:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX early_spidclkusync : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Delay from CLKREQDSRT to clock off
    //
    // Bits[15:12], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX clkreqdasrt2clkoff_dly : 4;
#else
    UINTX reserved_3 : 4;
#endif // MEM_SV_HOOKS
    //
    // Delay from clock enable to clock ack
    //
    // Bits[19:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX clken2clkack_dly : 4;
#else
    UINTX reserved_4 : 4;
#endif // MEM_SV_HOOKS
    //
    // Clock enable / disable on global sync point boundary.
    //
    // Bits[20:20], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX clken_on_gsp : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:21], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_6 : 11;
#else
    UINTX reserved_6 : 11;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} SPIDCLKCTL0_DPIC_STRUCT;
#endif // ASM_INC

#define LDOCTL1_DPIC_REG                                   0x00000028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // LDO Clock Enable
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_ldoclken : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // LDO FF Clock Enable - BL
    //
    // Bits[1:1], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX ldoffdig_bl_ldoffclkenable : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // LDO FF Clock Enable - CC
    //
    // Bits[2:2], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX ldoffdig_cc_ldoffclkenable : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // LDO IO Bufact - BL
    //
    // Bits[3:3], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ldoffdig_bl_ldoiobufact : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // LDO IO Bufact - CC
    //
    // Bits[4:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ldoffdig_cc_ldoiobufact : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // LDO Self Refresh Exit
    //
    // Bits[5:5], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ldomaindig_cmn_selfrefreshexit : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // LDO Self Refresh Exit
    //
    // Bits[6:6], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX ldomaindig_cmn_dvfsfreqselect : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // LDO IOLB Test Enable
    //
    // Bits[8:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ldomaindig_cmn_iolbtest : 1;
#else
    UINTX reserved_8 : 1;
#endif // MEM_SV_HOOKS
    //
    // When set, vccfar has converged to the target voltage and is ready to use.
    //
    // Bits[9:9], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ldomaindig_cmn_ldovccfarpwrgood : 1;
#else
    UINTX reserved_9 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:10], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_10 : 22;
#else
    UINTX reserved_10 : 22;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LDOCTL1_DPIC_STRUCT;
#endif // ASM_INC

#define LDOONCTL_DPIC_REG                                  0x0000002C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // LDO On
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ldomaindig_cmn_ldoon : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LDOONCTL_DPIC_STRUCT;
#endif // ASM_INC

#define LDORSTCTL_DPIC_REG                                 0x00000030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // LDO Reset
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ldomaindig_cmn_ldodigrstb : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LDORSTCTL_DPIC_STRUCT;
#endif // ASM_INC

#define LVUGSUPPLYCTL0_DPIC_REG                            0x00000034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // vccaddrlvug -> vccsocvnn isolation control (1 - Isolation enabled, 0 - disabled)
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lvug_isolen : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LVUGSUPPLYCTL0_DPIC_STRUCT;
#endif // ASM_INC

#define PLLDIVCTL2_DPIC_REG                                0x00000038
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PLL/DLL Feedback clock divider reset
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_divresetb : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} PLLDIVCTL2_DPIC_STRUCT;
#endif // ASM_INC

#define LDOCLKVAL_DPIC_REG                                 0x0000003C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 1x/2x Clock valid for LDOMAIN FUBs
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ldomain_cmn_clkvalid : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[3:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // LDO Clock Ratio
    //
    // Bits[7:4], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX ldomaindig_cmn_clockratio : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 24;
#else
    UINTX reserved_3 : 24;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LDOCLKVAL_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH0_RSTB_DPIC_REG                          0x00000100
#ifndef ASM_INC
typedef union {
  struct {
    //
    // c73p1ddrlp34l64x1top_PM module reset from config register
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_pmrst_b : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH0_RSTB_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH0_PGOVR_DPIC_REG                         0x00000104
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Isolation Override
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_isolen_ovr : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // PWR VNNA On Staggered Override
    //
    // Bits[1:1], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_vnnapwronstaggered_ovr : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // PWR VCCA On Staggered Override
    //
    // Bits[2:2], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_vccapwronstaggered_ovr : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:3], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 29;
#else
    UINTX reserved_3 : 29;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH0_PGOVR_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH0_CONFIG0_DPIC_REG                       0x00000108
#ifndef ASM_INC
typedef union {
  struct {
    //
    // SFR On Override
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_adpll_sfron_ovr : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // ADPLL Enable Override
    //
    // Bits[1:1], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_adpllen_ovr : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // SDLL Enable Override
    //
    // Bits[2:2], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_ckdll_sdllen_ovr : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // IOBUFACT Override
    //
    // Bits[3:3], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_iobufact_ovr : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // DIFFAMP Enable Overide
    //
    // Bits[4:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_diffampenable_ovr : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Isolation Enable Value
    //
    // Bits[5:5], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_isolen : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // Clock Gate Override
    //
    // Bits[6:6], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_clkgateen_ovr : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_7 : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // PWR VNNA On Staggered value
    //
    // Bits[15:8], RW, default = 0xFF
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_vnnapwronstaggered : 8;
#else
    UINTX reserved_9 : 8;
#endif // MEM_SV_HOOKS
    //
    // PWR VCCA On Staggered value
    //
    // Bits[23:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_vccapwronstaggered : 8;
#else
    UINTX reserved_10 : 8;
#endif // MEM_SV_HOOKS
    //
    // Power mux (ungated): Enable VNN
    //
    // Bits[24:24], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX pswitch_cmn_vnnpwron : 1;
#else
    UINTX reserved_11 : 1;
#endif // MEM_SV_HOOKS
    //
    // Power mux (ungated): Enable VCCA
    //
    // Bits[25:25], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pswitch_cmn_vccapwron : 1;
#else
    UINTX reserved_12 : 1;
#endif // MEM_SV_HOOKS
    //
    // Select VCCA mode of operation
    //
    // Bits[26:26], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX vcca_sel : 1;
#else
    UINTX reserved_13 : 1;
#endif // MEM_SV_HOOKS
    //
    // ref2xrstb override
    //
    // Bits[27:27], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_ref2xrstb_ovr : 1;
#else
    UINTX reserved_14 : 1;
#endif // MEM_SV_HOOKS
    //
    // ref2x phase 0 override
    //
    // Bits[28:28], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_ref2xph0_ovr : 1;
#else
    UINTX reserved_15 : 1;
#endif // MEM_SV_HOOKS
    //
    // Channel 0 dll c73p1ddrlp34l64x1top_comp clock gate overiride
    //
    // Bits[29:29], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_dllcomp_clkgate_ovr : 1;
#else
    UINTX reserved_16 : 1;
#endif // MEM_SV_HOOKS
    //
    // Force c73p1ddrlp34l64x1top_PM LDO c73p1ddrlp34l64x1top_Comp. When set to 1'b1,
    // this results in c73p1ddrlp34l64x1top_PM forcing LDO Offset c73p1ddrlp34l64x1top_comp
    // when exiting PM3. Current recommendation is to enable this in PSMI mode only.
    //
    // Bits[30:30], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_forceldooffsetcomp : 1;
#else
    UINTX reserved_17 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM TxDLY c73p1ddrlp34l64x1top_Comp Disable. When set to 1'b1(reset
    // value), this results in c73p1ddrlp34l64x1top_PM preventing TxDLY code re-eval
    // during PM3. Current recommendation is to disable this in PSMI mode only.
    //
    // Bits[31:31], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_txdlycomp_en_ovr : 1;
#else
    UINTX reserved_18 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH0_CONFIG0_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH0_CONFIG1_DPIC_REG                       0x0000010C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // c73p1ddrlp34l64x1top_COMP Enable Overide
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_comp_en_ovr : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM adpll lock
    //
    // Bits[1:1], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_adpll_lock : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // 2x Reset Value
    //
    // Bits[2:2], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_pg2xrst_b : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // 2x Reset Override
    //
    // Bits[3:3], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_pg2xrst_b_ovr : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Clock DLL Flop Reset Value
    //
    // Bits[4:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_clkdll_floprstb : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Clock DLL Flop Reset Override
    //
    // Bits[5:5], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_clkdll_floprstb_ovr : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // Write Pointer Enable Override
    //
    // Bits[6:6], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_wrptren_ovr : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // PI Enable Override
    //
    // Bits[7:7], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_pien_ovr : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_DQRX FIFO Reset Override
    //
    // Bits[8:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_dqrxfiforstb_ovr : 1;
#else
    UINTX reserved_8 : 1;
#endif // MEM_SV_HOOKS
    //
    // VREFEN  Overide value
    //
    // Bits[9:9], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_vrefen_ovr : 1;
#else
    UINTX reserved_9 : 1;
#endif // MEM_SV_HOOKS
    //
    // VREF IO BUFACT Overide
    //
    // Bits[10:10], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_vrefiobufact_ovr : 1;
#else
    UINTX reserved_10 : 1;
#endif // MEM_SV_HOOKS
    //
    // ADPLL-Out Output Enable Override
    //
    // Bits[11:11], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_adpllouten_ovr : 1;
#else
    UINTX reserved_11 : 1;
#endif // MEM_SV_HOOKS
    //
    // SPID Clock Override
    //
    // Bits[12:12], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_spidclkenovrride : 1;
#else
    UINTX reserved_12 : 1;
#endif // MEM_SV_HOOKS
    //
    // LDO Power On Override
    //
    // Bits[13:13], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_ldopg_pwron_ovr : 1;
#else
    UINTX reserved_13 : 1;
#endif // MEM_SV_HOOKS
    //
    // Delay between power off and power on in hvm mode
    //
    // Bits[17:14], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_hvm_delay : 4;
#else
    UINTX reserved_14 : 4;
#endif // MEM_SV_HOOKS
    //
    // HVM Request
    //
    // Bits[18:18], RW/1S/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_hvm_req : 1;
#else
    UINTX reserved_15 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM Spid Reset Override
    //
    // Bits[19:19], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_spidrst_b_ovr : 1;
#else
    UINTX reserved_16 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM Spid clkreq override
    //
    // Bits[20:20], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_spidclkreq_ovr : 1;
#else
    UINTX reserved_17 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM Spid clkreq Enable
    //
    // Bits[21:21], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_spidclkreq_en : 1;
#else
    UINTX reserved_18 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_19 : 10;
#else
    UINTX reserved_19 : 10;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH0_CONFIG1_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH0_CONFIG2_DPIC_REG                       0x00000110
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DDR Mode Selection 1: DDR3L (Single Channel) 0 : LP* (2 Channel)
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_ddrmode : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH0_CONFIG2_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH0_CLKREQ_DPIC_REG                        0x00000114
#ifndef ASM_INC
typedef union {
  struct {
    //
    // clk request
    //
    // Bits[0:0], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pmclk_clkreq : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH0_CLKREQ_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY0_DPIC_REG                            0x00000118
#ifndef ASM_INC
typedef union {
  struct {
    //
    // ref2x phase 0 disble delay
    //
    // Bits[3:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_ref2xph0_disable_dly : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_dllcomp clock disable  gate delay
    //
    // Bits[7:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_dllcompcg_disable_dly : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // ref2x phase 0 enable delay
    //
    // Bits[11:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_ref2xph0_enable_dly : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_dllcomp clock enable  gate delay
    //
    // Bits[15:12], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_dllcompcg_enable_dly : 4;
#else
    UINTX reserved_3 : 4;
#endif // MEM_SV_HOOKS
    //
    // Delay to assert/de-assert IO BUFFER ACTIVATE
    //
    // Bits[23:16], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_iobufact_dly : 8;
#else
    UINTX reserved_4 : 8;
#endif // MEM_SV_HOOKS
    //
    // Wait timer for the message interface to provide delay before ack/nack is aaserted
    // or deaaserted
    //
    // Bits[27:24], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_acktime : 4;
#else
    UINTX reserved_5 : 4;
#endif // MEM_SV_HOOKS
    //
    // 0 for 2 bit stagger ata time sel and 1 for 1 bit stagger at a time Channel 1
    //
    // Bits[28:28], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_stagger_bits_sel : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // 0 for 2 bit stagger ata time sel and 1 for 1 bit stagger at a time Channel 0
    //
    // Bits[29:29], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_stagger_bits_sel : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_8 : 2;
#else
    UINTX reserved_8 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY0_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY1_DPIC_REG                            0x0000011C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay after which the pmseq state machine moves from en_comp state to en_sigref
    // state
    //
    // Bits[15:0], RW, default = 0x190
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_comp_enable_dly : 16;
#else
    UINTX reserved : 16;
#endif // MEM_SV_HOOKS
    //
    // Delay to turn on the PI's associated with the DLLs in each module
    //
    // Bits[23:16], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_sdll_enable_dly : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Delay to turn on the PI's associated with the wrptr in each module
    //
    // Bits[31:24], RW, default = 0x2
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_wrptr_enable_dly : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY1_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY2_DPIC_REG                            0x00000120
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay to turn off the PI's associated with the DLLs in each module
    //
    // Bits[7:0], RW, default = 0x2
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_sdll_disable_dly : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Delay to turn off the PI's associated with the wrptr in each module
    //
    // Bits[15:8], RW, default = 0x2
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_wrptr_disable_dly : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Delay after which the pmseq state machine moves from adpll_sfron state to adpll_on_hs
    // state
    //
    // Bits[31:16], RW, default = 0xC8
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_adpll_sfron_dly : 16;
#else
    UINTX reserved_2 : 16;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY2_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY3_DPIC_REG                            0x00000124
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay after which the pmseq state machine moves from dis_comp state to adpll_off_hs
    // state
    //
    // Bits[15:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_adpll_sfroff_dly : 16;
#else
    UINTX reserved : 16;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_comp_disable_dly : 16;
#else
    UINTX reserved_1 : 16;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY3_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY4_DPIC_REG                            0x00000128
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay for the clock gate or clock ungate
    //
    // Bits[3:0], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_clkgate_wait_timer : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[7:4], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Delay for the isolate and un-isolate
    //
    // Bits[11:8], RW, default = 0x2
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_isol2pgdly : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // Delay between each power gating stagger FSM state transition
    //
    // Bits[19:12], RW, default = 0xA
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_pg_enable_stgdly : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
    //
    // Delay between each power un-gating stagger FSM state transition
    //
    // Bits[27:20], RW, default = 0xA
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_pg_disable_stgdly : 8;
#else
    UINTX reserved_4 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 4;
#else
    UINTX reserved_5 : 4;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY4_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY5_DPIC_REG                            0x0000012C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay to assert pgphyrst_d
    //
    // Bits[7:0], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_pgphyrstb_disable_dly : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Delay to deassert pgphyrst_b
    //
    // Bits[15:8], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_pgphyrstb_enable_dly : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Delay to assert pg2xrst_b
    //
    // Bits[23:16], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_pg2xrstb_disable_dly : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // Delay to deassert pg2xrstb
    //
    // Bits[31:24], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_pg2xrstb_enable_dly : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY5_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY6_DPIC_REG                            0x00000130
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay after vrefiobufact set to 0
    //
    // Bits[11:0], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_vrefiobufact_disable_dly : 12;
#else
    UINTX reserved : 12;
#endif // MEM_SV_HOOKS
    //
    // Delay after vrefiobufact set to 1
    //
    // Bits[23:12], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_vrefiobufact_enable_dly : 12;
#else
    UINTX reserved_1 : 12;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[29:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 6;
#else
    UINTX reserved_2 : 6;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY6_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY7_DPIC_REG                            0x00000134
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay after vrefen set to 0
    //
    // Bits[11:0], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_vrefen_disable_dly : 12;
#else
    UINTX reserved : 12;
#endif // MEM_SV_HOOKS
    //
    // Delay after vrefen set to 1
    //
    // Bits[23:12], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_vrefen_enable_dly : 12;
#else
    UINTX reserved_1 : 12;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[29:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 6;
#else
    UINTX reserved_2 : 6;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY7_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY8_DPIC_REG                            0x00000138
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enable PI delay
    //
    // Bits[3:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_pien_dly : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // Enable LDO vref delay
    //
    // Bits[7:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_disable_ldovref_dly : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Enable LDO isol dleay
    //
    // Bits[10:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_disable_isol_dly : 3;
#else
    UINTX reserved_2 : 3;
#endif // MEM_SV_HOOKS
    //
    // Enable LDO Power gate delay
    //
    // Bits[18:11], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_disable_ldopg_dly : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
    //
    // disable ref2xrstb
    //
    // Bits[21:19], RW, default = 0x2
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_ref2xrstb_disable_dly : 3;
#else
    UINTX reserved_4 : 3;
#endif // MEM_SV_HOOKS
    //
    // enable ref2xrstb
    //
    // Bits[24:22], RW, default = 0x2
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_ref2xrstb_enable_dly : 3;
#else
    UINTX reserved_5 : 3;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:25], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved500 : 7;
#else
    UINTX reserved_6 : 7;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY8_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY9_DPIC_REG                            0x0000013C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Disable LDO vref delay
    //
    // Bits[15:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_enable_ldovref_dly : 16;
#else
    UINTX reserved : 16;
#endif // MEM_SV_HOOKS
    //
    // Disable LDO isol dleay
    //
    // Bits[18:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_enable_isol_dly : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // Disable LDO Power gate delay
    //
    // Bits[22:19], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_enable_ldopg_dly : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // LDO Self Refresh Exit Override
    //
    // Bits[23:23], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_ldoselfrefreshexit : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Disable ADPLL Lock Delay
    //
    // Bits[31:24], RW, default = 0xFE
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_disable_adpll_lock_dly : 8;
#else
    UINTX reserved_4 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY9_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH0_CLKGATE_DPIC_REG                       0x00000140
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Clock Gate Enable
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_clkgateen : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH0_CLKGATE_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PMSWMSG_CH0_DPIC_REG                          0x00000144
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Config based Power Management Message
    //
    // Bits[4:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_sw_msg : 5;
#else
    UINTX reserved : 5;
#endif // MEM_SV_HOOKS
    //
    // Config based Power Management Message Request
    //
    // Bits[5:5], RW/1S/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_sw_req : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM software acknowledge
    //
    // Bits[6:6], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_sw_ack : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM clock ack
    //
    // Bits[7:7], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pmclk_ack : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[10:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 3;
#else
    UINTX reserved_4 : 3;
#endif // MEM_SV_HOOKS
    //
    // State of Power Management logic. [4]: busy. [3:0] : c73p1ddrlp34l64x1top_PM state
    //
    // Bits[15:11], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_pm_cfg_status : 5;
#else
    UINTX reserved_5 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[26:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_6 : 11;
#else
    UINTX reserved_6 : 11;
#endif // MEM_SV_HOOKS
    //
    // HVM c73p1ddrlp34l64x1top_PM Message
    //
    // Bits[31:27], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX ch0_hvm_pmmsg : 5;
#else
    UINTX reserved_8 : 5;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PMSWMSG_CH0_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_DELAY10_DPIC_REG                           0x00000148
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay to assert divreset
    //
    // Bits[7:0], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_divrst_disable_dly : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Delay to deassert divreset
    //
    // Bits[15:8], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX pm_divrst_enable_dly : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_2 : 16;
#else
    UINTX reserved_2 : 16;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_DELAY10_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH1_RSTB_DPIC_REG                          0x0000014C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // c73p1ddrlp34l64x1top_PM module reset from config register
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_pmrst_b : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH1_RSTB_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH1_PGOVR_DPIC_REG                         0x00000150
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Isolation Override
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_isolen_ovr : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // PWR VNNA On Staggered Override
    //
    // Bits[1:1], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_vnnapwronstaggered_ovr : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // PWR VCCA On Staggered Override
    //
    // Bits[2:2], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_vccapwronstaggered_ovr : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:3], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 29;
#else
    UINTX reserved_3 : 29;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH1_PGOVR_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH1_CONFIG0_DPIC_REG                       0x00000154
#ifndef ASM_INC
typedef union {
  struct {
    //
    // SFR On Override
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_adpll_sfron_ovr : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // ADPLL Enable Override
    //
    // Bits[1:1], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_adpllen_ovr : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // SDLL Enable Override
    //
    // Bits[2:2], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_ckdll_sdllen_ovr : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // IOBUFACT Override
    //
    // Bits[3:3], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_iobufact_ovr : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // DIFFAMP Enable Overide
    //
    // Bits[4:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_diffampenable_ovr : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Isolation Enable Value
    //
    // Bits[5:5], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_isolen : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // Clock Gate Override
    //
    // Bits[6:6], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_clkgateen_ovr : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved3 : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // PWR VNNA On Staggered value
    //
    // Bits[15:8], RW, default = 0xFF
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_vnnapwronstaggered : 8;
#else
    UINTX reserved_8 : 8;
#endif // MEM_SV_HOOKS
    //
    // PWR VCCA On Staggered value
    //
    // Bits[23:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_vccapwronstaggered : 8;
#else
    UINTX reserved_9 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[24:24], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved2 : 1;
#else
    UINTX reserved_10 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[25:25], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 1;
#else
    UINTX reserved_11 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[26:26], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 1;
#else
    UINTX reserved_12 : 1;
#endif // MEM_SV_HOOKS
    //
    // ref2xrstb override
    //
    // Bits[27:27], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_ref2xrstb_ovr : 1;
#else
    UINTX reserved_13 : 1;
#endif // MEM_SV_HOOKS
    //
    // ref2x phase 0 override
    //
    // Bits[28:28], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_ref2xph0_ovr : 1;
#else
    UINTX reserved_14 : 1;
#endif // MEM_SV_HOOKS
    //
    // Channel 1 dll c73p1ddrlp34l64x1top_comp clock gate overiride
    //
    // Bits[29:29], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_dllcomp_clkgate_ovr : 1;
#else
    UINTX reserved_15 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_16 : 2;
#else
    UINTX reserved_16 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH1_CONFIG0_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH1_CONFIG1_DPIC_REG                       0x00000158
#ifndef ASM_INC
typedef union {
  struct {
    //
    // c73p1ddrlp34l64x1top_COMP Enable Overide
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_comp_en_ovr : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM adpll lock
    //
    // Bits[1:1], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_adpll_lock : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // 2x Reset Value
    //
    // Bits[2:2], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_pg2xrst_b : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // 2x Reset Override
    //
    // Bits[3:3], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_pg2xrst_b_ovr : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Clock DLL Flop Reset Value
    //
    // Bits[4:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_clkdll_floprstb : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // Clock DLL Flop Reset Override
    //
    // Bits[5:5], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_clkdll_floprstb_ovr : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // Write Pointer Enable Override
    //
    // Bits[6:6], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_wrptren_ovr : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // PI Enable Override
    //
    // Bits[7:7], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_pien_ovr : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_DQRX FIFO Reset Override
    //
    // Bits[8:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_dqrxfiforstb_ovr : 1;
#else
    UINTX reserved_8 : 1;
#endif // MEM_SV_HOOKS
    //
    // VREFEN  Overide value
    //
    // Bits[9:9], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_vrefen_ovr : 1;
#else
    UINTX reserved_9 : 1;
#endif // MEM_SV_HOOKS
    //
    // VREF IO BUFACT Overide
    //
    // Bits[10:10], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_vrefiobufact_ovr : 1;
#else
    UINTX reserved_10 : 1;
#endif // MEM_SV_HOOKS
    //
    // ADPLL-Out Output Enable Override
    //
    // Bits[11:11], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_adpllouten_ovr : 1;
#else
    UINTX reserved_11 : 1;
#endif // MEM_SV_HOOKS
    //
    // SPID Clock Override
    //
    // Bits[12:12], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_spidclkenovrride : 1;
#else
    UINTX reserved_12 : 1;
#endif // MEM_SV_HOOKS
    //
    // LDO Power On Override
    //
    // Bits[13:13], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_ldopg_pwron_ovr : 1;
#else
    UINTX reserved_13 : 1;
#endif // MEM_SV_HOOKS
    //
    // Delay between power off and power on in hvm mode
    //
    // Bits[17:14], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_hvm_delay : 4;
#else
    UINTX reserved_14 : 4;
#endif // MEM_SV_HOOKS
    //
    // HVM Request
    //
    // Bits[18:18], RW/1S/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_hvm_req : 1;
#else
    UINTX reserved_15 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM Spid Reset Override
    //
    // Bits[19:19], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_spidrst_b_ovr : 1;
#else
    UINTX reserved_16 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM Spid clkreq override
    //
    // Bits[20:20], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_spidclkreq_ovr : 1;
#else
    UINTX reserved_17 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM Spid clkreq Enable
    //
    // Bits[21:21], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_spidclkreq_en : 1;
#else
    UINTX reserved_18 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_19 : 10;
#else
    UINTX reserved_19 : 10;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH1_CONFIG1_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH1_CLKREQ_DPIC_REG                        0x0000015C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // clk request
    //
    // Bits[0:0], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pmclk_clkreq : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH1_CLKREQ_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PM_CH1_CLKGATE_DPIC_REG                       0x00000160
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Clock Gate Enable
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_clkgateen : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PM_CH1_CLKGATE_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_PMSWMSG_CH1_DPIC_REG                          0x00000164
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Config based Power Management Message
    //
    // Bits[4:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_sw_msg : 5;
#else
    UINTX reserved : 5;
#endif // MEM_SV_HOOKS
    //
    // Config based Power Management Message Request
    //
    // Bits[5:5], RW/1S/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_sw_req : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM software acknowledge
    //
    // Bits[6:6], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_sw_ack : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // c73p1ddrlp34l64x1top_PM clock ack
    //
    // Bits[7:7], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pmclk_ack : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[10:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 3;
#else
    UINTX reserved_4 : 3;
#endif // MEM_SV_HOOKS
    //
    // State of Power Management logic. [4]: busy. [3:0] : c73p1ddrlp34l64x1top_PM state
    //
    // Bits[15:11], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_pm_cfg_status : 5;
#else
    UINTX reserved_5 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[26:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_6 : 11;
#else
    UINTX reserved_6 : 11;
#endif // MEM_SV_HOOKS
    //
    // HVM c73p1ddrlp34l64x1top_PM Message
    //
    // Bits[31:27], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_hvm_pmmsg : 5;
#else
    UINTX reserved_8 : 5;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_PMSWMSG_CH1_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_OVR_DPIC_REG                           0x00000300
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[9:0], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 10;
#else
    UINTX reserved : 10;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[17:10], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // debug observation signal to AFE
    //
    // Bits[18:18], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX gcomp_cmn_obsen : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // debug observation signal to AFE
    //
    // Bits[20:19], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX gcomp_cmn_digobs1_sel : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // debug observation signal to AFE
    //
    // Bits[22:21], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX gcomp_cmn_digobs0_sel : 2;
#else
    UINTX reserved_4 : 2;
#endif // MEM_SV_HOOKS
    //
    // override enable for override for pull up live rcomp code going to AFE
    //
    // Bits[23:23], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_rcomp_pu_live_override_en : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // override for pull up live rcomp code going to AFE
    //
    // Bits[29:24], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_rcomp_pu_live_override : 6;
#else
    UINTX reserved_6 : 6;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_7 : 2;
#else
    UINTX reserved_7 : 2;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_OVR_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_CTL_DPIC_REG                           0x00000304
#ifndef ASM_INC
typedef union {
  struct {
    //
    // static leg signal for the AFE
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_pu_staticlive : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // this tells a timer to start the periodic c73p1ddrlp34l64x1top_comp cycle when
    // this number of cycles are completed. Usually this is programmed to 'h7d00 for
    // a 4us delay between two periodic c73p1ddrlp34l64x1top_comp cycles.
    //
    // Bits[20:1], RW, default = 0x7D00
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_wakeup_period : 20;
#else
    UINTX reserved_1 : 20;
#endif // MEM_SV_HOOKS
    //
    // Not used.
    //
    // Bits[26:21], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_general_timer : 6;
#else
    UINTX reserved_2 : 6;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:27], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 5;
#else
    UINTX reserved_3 : 5;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_CTL_DPIC_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_DEBUG_DPIC_REG                         0x00000500
#ifndef ASM_INC
typedef union {
  struct {
    //
    // debug signal to AFE
    //
    // Bits[3:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_cmn_ibonus : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // debug ctrl bits.
    //
    // Bits[4:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_cmn_obsen : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // debug ctrl bits.
    //
    // Bits[6:5], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_cmn_digobs1sel : 2;
#else
    UINTX reserved_2 : 2;
#endif // MEM_SV_HOOKS
    //
    // debug ctrl bits.
    //
    // Bits[8:7], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_cmn_digobs0sel : 2;
#else
    UINTX reserved_3 : 2;
#endif // MEM_SV_HOOKS
    //
    // spare bits
    //
    // Bits[24:9], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_spare : 16;
#else
    UINTX reserved_4 : 16;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:25], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 7;
#else
    UINTX reserved_5 : 7;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_DEBUG_DPIC_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM0PATTGEN_DPIC_REG                       0x00000700
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Pattern Generation
    //
    // Bits[3:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX dfxvisa_ulm0pattgen_lsb : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // VISA Pattern Generation
    //
    // Bits[6:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX dfxvisa_ulm0pattgen_msb : 3;
#else
    UINTX reserved_1 : 3;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved501 : 25;
#else
    UINTX reserved_2 : 25;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DFXVISA_ULM0PATTGEN_DPIC_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM0LN0_DPIC_REG                           0x00000704
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM0LN0 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX dfxvisa_ulm0ln0_datasel : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // VISA ULM0LN0 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX dfxvisa_ulm0ln0_clksel : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // VISA Bypass ULM0LN0
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX dfxvisa_ulm0ln0_bypass : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved502 : 15;
#else
    UINTX reserved_3 : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DFXVISA_ULM0LN0_DPIC_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM0LN1_DPIC_REG                           0x00000708
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM0LN1 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX dfxvisa_ulm0ln1_datasel : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // VISA ULM0LN1 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX dfxvisa_ulm0ln1_clksel : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // VISA Bypass ULM0LN1
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX dfxvisa_ulm0ln1_bypass : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved503 : 15;
#else
    UINTX reserved_3 : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DFXVISA_ULM0LN1_DPIC_STRUCT;
#endif // ASM_INC

#define LDOCTL1X_DPIC_REG                                  0x00000028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // LDO Clock Enable
    //
    // Bits[31:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX pll_cmn_ldoclken : 32;
#else
    UINTX reserved : 32;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LDOCTL1X_DPIC_STRUCT;
#endif // ASM_INC

#define LDORSTCTLX_DPIC_REG                                0x00000030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[31:0], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 32;
#else
    UINTX reserved : 32;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LDORSTCTLX_DPIC_STRUCT;
#endif // ASM_INC

#define LDOCLKVALX_DPIC_REG                                0x0000003C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[31:0], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved : 32;
#else
    UINTX reserved : 32;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} LDOCLKVALX_DPIC_STRUCT;
#endif // ASM_INC


#endif // _DPIC_H_
