/** @file
  File name:    DPLVUG.h
  Input File:   BXTP_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in DPLVUG.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

  @copyright
  Copyright (c) 2005-2016 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by the
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is uniquely
  identified as 'Intel Reference Module' and is licensed for Intel
  CPUs and chipsets under the terms of your license agreement with
  Intel or your vendor. This file may be modified by the user, subject
  to additional terms of the license agreement.

  @par Specification
**/
#ifndef _DPLVUG_H_
#define _DPLVUG_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define DPIC_LRCOMP_OVR1_DPLVUG_REG                        0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // grp1 pull down override code
    //
    // Bits[6:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp1_pd_override : 7;
#else
    UINTX reserved : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved2 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // grp1 pull up override code
    //
    // Bits[14:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp1_pu_override : 7;
#else
    UINTX reserved_2 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // grp0 pull down override code
    //
    // Bits[22:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp0_pd_override : 7;
#else
    UINTX reserved_4 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // grp0 pull up override code
    //
    // Bits[30:24], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp0_pu_override : 7;
#else
    UINTX reserved_6 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_7 : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_OVR1_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_OVR2_DPLVUG_REG                        0x00000004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // grp3 pull down override code
    //
    // Bits[6:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp3_pd_override : 7;
#else
    UINTX reserved : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved2 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // grp3 pull up override code
    //
    // Bits[14:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp3_pu_override : 7;
#else
    UINTX reserved_2 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // grp2 pull down override code
    //
    // Bits[22:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp2_pd_override : 7;
#else
    UINTX reserved_4 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // grp2 pull up override code
    //
    // Bits[30:24], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp2_pu_override : 7;
#else
    UINTX reserved_6 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_7 : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_OVR2_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_OVR3_DPLVUG_REG                        0x00000008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // grp5 pull down override code
    //
    // Bits[6:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp5_pd_override : 7;
#else
    UINTX reserved : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved2 : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // grp5 pull up override code
    //
    // Bits[14:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp5_pu_override : 7;
#else
    UINTX reserved_2 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // grp4 pull down override code
    //
    // Bits[22:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp4_pd_override : 7;
#else
    UINTX reserved_4 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 1;
#else
    UINTX reserved_5 : 1;
#endif // MEM_SV_HOOKS
    //
    // grp4 pull up override code
    //
    // Bits[30:24], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdgrp4_pu_override : 7;
#else
    UINTX reserved_6 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_7 : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_OVR3_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_PUPDOVR_DPLVUG_REG                     0x0000000C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Pull up override enable
    //
    // Bits[5:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomppu_grp_override_en : 6;
#else
    UINTX reserved : 6;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // Pull down override enable
    //
    // Bits[13:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomppd_grp_override_en : 6;
#else
    UINTX reserved_2 : 6;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:14], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 18;
#else
    UINTX reserved_3 : 18;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_PUPDOVR_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_CODES_0_DPLVUG_REG                     0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PU / PD Code
    //
    // Bits[7:0], RO/V, default = 0x8
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_code_grp1 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // PU / PD Code
    //
    // Bits[15:8], RO/V, default = 0x7
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pu_code_grp1 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // PU / PD Code
    //
    // Bits[23:16], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_code_grp0 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // PU / PD Code
    //
    // Bits[31:24], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pu_code_grp0 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_CODES_0_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_CODES_1_DPLVUG_REG                     0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PU / PD Code
    //
    // Bits[7:0], RO/V, default = 0x8
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_code_grp3 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // PU / PD Code
    //
    // Bits[15:8], RO/V, default = 0x7
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pu_code_grp3 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // PU / PD Code
    //
    // Bits[23:16], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_code_grp2 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // PU / PD Code
    //
    // Bits[31:24], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pu_code_grp2 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_CODES_1_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_CODES_2_DPLVUG_REG                     0x00000018
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PU / PD Code
    //
    // Bits[7:0], RO/V, default = 0x8
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_code_grp5 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // PU / PD Code
    //
    // Bits[15:8], RO/V, default = 0x7
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pu_code_grp5 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // PU / PD Code
    //
    // Bits[23:16], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_code_grp4 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // PU / PD Code
    //
    // Bits[31:24], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pu_code_grp4 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_CODES_2_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_CFG1_DPLVUG_REG                        0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay after enabling Rcomp before starting measurement timer
    //
    // Bits[7:0], RW, default = 0xE
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_enable_delay : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Number of binary search steps
    //
    // Bits[11:8], RW, default = 0xA
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_numsteps : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Initial step value for Rcomp binary search
    //
    // Bits[18:12], RW, default = 0x10
    //
    UINTX rcomp_initstep : 7;
    //
    // Initial value for Rcomp binary search
    //
    // Bits[25:19], RW, default = 0x20
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_initval : 7;
#else
    UINTX reserved_2 : 7;
#endif // MEM_SV_HOOKS
    //
    // Number of times to repeat and average the Rcomp compensation
    //
    // Bits[30:26], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_numave : 5;
#else
    UINTX reserved_3 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_4 : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_CFG1_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_CFG2_DPLVUG_REG                        0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // indicates the division ratio of the c73p1ddrlp34l64x1top_comp clock w.r.t spid
    // clk
    //
    // Bits[1:0], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_msgbus_clk_div : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[3:2], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 2;
#else
    UINTX reserved_1 : 2;
#endif // MEM_SV_HOOKS
    //
    // Rcomp sample time 3
    //
    // Bits[11:4], RW, default = 0xE
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_sampdel3 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // Rcomp sample time 2
    //
    // Bits[19:12], RW, default = 0xE
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_sampdel2 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
    //
    // Rcomp sample time 1
    //
    // Bits[27:20], RW, default = 0xE
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_sampdel1 : 8;
#else
    UINTX reserved_4 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 4;
#else
    UINTX reserved_5 : 4;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_CFG2_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_CFG3_DPLVUG_REG                        0x00000024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rcomp max value of code. The live code wont go beyond this. If the c73p1ddrlp34l64x1top_comp
    // sm gives a value greater than this, it will be capped to this value.
    //
    // Bits[7:0], RW, default = 0x3F
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_max_code_val : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Tells which channels are enabled. '1' channel enabled '0' channel disabled. This
    // must be equal to the corresponding bits in the LCOMP
    //
    // Bits[11:8], RW, default = 0xF
    //
#ifdef MEM_SV_HOOKS
    UINTX gcomp_ch_en : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:12], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_2 : 20;
#else
    UINTX reserved_2 : 20;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_CFG3_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_VREF_0_DPLVUG_REG                      0x00000028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // vrefctrl voltage
    //
    // Bits[7:0], RW, default = 0x20
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_vref_grp3 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // vrefctrl voltage
    //
    // Bits[15:8], RW, default = 0x20
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_vref_grp2 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // vrefctrl voltage
    //
    // Bits[23:16], RW, default = 0x20
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_vref_grp1 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // vrefctrl voltage
    //
    // Bits[31:24], RW, default = 0x20
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_vref_grp0 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_VREF_0_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_VREF_1_DPLVUG_REG                      0x0000002C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // vrefctrl voltage
    //
    // Bits[7:0], RW, default = 0x20
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_vref_grp5 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // vrefctrl voltage
    //
    // Bits[15:8], RW, default = 0x20
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_vref_grp4 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:16], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_2 : 16;
#else
    UINTX reserved_2 : 16;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_VREF_1_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_RSTCTL_DPLVUG_REG                      0x00000030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // async active low reset for gcomp
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX comprst_b : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // This count estimates the number of cycles it would take for all LCOMP from the
    // start of LCOMP evaluation to the finish of LCOMP evaluation.
    //
    // Bits[15:1], RW, default = 0x960
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_rcomp_mstrcompctl_timer_exp_cnt : 15;
#else
    UINTX reserved_1 : 15;
#endif // MEM_SV_HOOKS
    //
    // Number of clock cycles, for the design to wait before taking action on bus_quiet_time_gnt.
    // This must be set the same as LCOMP bqt_settle_width
    //
    // Bits[22:16], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX delta_timer_expire_cnt : 7;
#else
    UINTX reserved_2 : 7;
#endif // MEM_SV_HOOKS
    //
    // tells the rcomp to copy the adjecent code instead of evaluating it
    //
    // Bits[30:23], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_rcomp_pu_code_copy_bits : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_4 : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_RSTCTL_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_CLKGATE_DPLVUG_REG                     0x00000034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Clock gating contorl for rcomp.
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_clkgate_en : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_CLKGATE_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_INIT_DPLVUG_REG                        0x00000038
#ifndef ASM_INC
typedef union {
  struct {
    //
    // bit to start the initial rcomp
    //
    // Bits[0:0], RW/1S/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX rcomp_init_comp : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_INIT_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_CFG1_DPLVUG_REG                        0x0000003C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay after enabling Rcomp before starting measurement timer
    //
    // Bits[7:0], RW, default = 0xE
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_enable_delay : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Number of binary search steps
    //
    // Bits[11:8], RW, default = 0xA
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_numsteps : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Initial step value for Rcomp binary search
    //
    // Bits[18:12], RW, default = 0x10
    //
    UINTX lrcomp_initstep : 7;
    //
    // Initial value for Rcomp binary search
    //
    // Bits[25:19], RW, default = 0x20
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_initval : 7;
#else
    UINTX reserved_2 : 7;
#endif // MEM_SV_HOOKS
    //
    // Number of times to repeat and average the Rcomp compensation
    //
    // Bits[30:26], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_numave : 5;
#else
    UINTX reserved_3 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_4 : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_CFG1_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_CFG2_DPLVUG_REG                        0x00000040
#ifndef ASM_INC
typedef union {
  struct {
    //
    // indicates the division ratio of the c73p1ddrlp34l64x1top_comp clock w.r.t spid
    // clk
    //
    // Bits[1:0], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_msgbus_clk_div : 2;
#else
    UINTX reserved : 2;
#endif // MEM_SV_HOOKS
    //
    // set it to '1' to select the membus form gcomp, '0' to select it from previous
    // module.
    //
    // Bits[2:2], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lcomp_sel_membus_frm_gcomp : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Rcomp sample time 3
    //
    // Bits[10:3], RW, default = 0xE
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_sampdel3 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // Rcomp sample time 2
    //
    // Bits[18:11], RW, default = 0xE
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_sampdel2 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
    //
    // Rcomp sample time 1
    //
    // Bits[26:19], RW, default = 0xE
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_sampdel1 : 8;
#else
    UINTX reserved_4 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:27], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 5;
#else
    UINTX reserved_5 : 5;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_CFG2_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_CFG3_DPLVUG_REG                        0x00000044
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rcomp max value of code. The live code wont go beyond this. If the c73p1ddrlp34l64x1top_comp
    // sm gives a value greater than this, it will be capped to this value.
    //
    // Bits[7:0], RW, default = 0x3F
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_max_code_val : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // Tells which channels are enabled. '1' channel enabled '0' channel disabled. This
    // must be equal to the corresponding bits in the GCOMP
    //
    // Bits[11:8], RW, default = 0xF
    //
#ifdef MEM_SV_HOOKS
    UINTX lcomp_ch_en : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:12], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_2 : 20;
#else
    UINTX reserved_2 : 20;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_CFG3_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_OVR0_DPLVUG_REG                        0x00000048
#ifndef ASM_INC
typedef union {
  struct {
    //
    // not used
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_puref_override_en : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // not used
    //
    // Bits[7:1], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_puref_override : 7;
#else
    UINTX reserved_1 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[13:8], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 6;
#else
    UINTX reserved_2 : 6;
#endif // MEM_SV_HOOKS
    //
    // override enable for override for pull down live rcomp code going to AFE
    //
    // Bits[14:14], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_live_override_en : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // override for pull down live rcomp code going to AFE
    //
    // Bits[21:15], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_live_override : 7;
#else
    UINTX reserved_4 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 10;
#else
    UINTX reserved_5 : 10;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_OVR0_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_CTL0_DPLVUG_REG                        0x0000004C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // config contorl for disabling rcomp code per group.
    //
    // Bits[5:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_grp_update_disable : 6;
#else
    UINTX reserved : 6;
#endif // MEM_SV_HOOKS
    //
    // enable for config concifg control for updating rcomp codes.
    //
    // Bits[6:6], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_updtbyen : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // config control for updating rcomp codes.
    //
    // Bits[7:7], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_update : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // no of cycles needed for code update.
    //
    // Bits[11:8], RW, default = 0x8
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_update_len : 4;
#else
    UINTX reserved_3 : 4;
#endif // MEM_SV_HOOKS
    //
    // no of cycles needed for stage 2 update.
    //
    // Bits[15:12], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_stg2_width : 4;
#else
    UINTX reserved_4 : 4;
#endif // MEM_SV_HOOKS
    //
    // not used.
    //
    // Bits[21:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_general_timer : 6;
#else
    UINTX reserved_5 : 6;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[22:22], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved2 : 1;
#else
    UINTX reserved_6 : 1;
#endif // MEM_SV_HOOKS
    //
    // static leg signal for PD c73p1ddrlp34l64x1top_comp buffer.
    //
    // Bits[23:23], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pu_static : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // static live signal for PD c73p1ddrlp34l64x1top_comp buffer.
    //
    // Bits[24:24], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pd_staticlive : 1;
#else
    UINTX reserved_8 : 1;
#endif // MEM_SV_HOOKS
    //
    // selects the bus_quiet_time_gnt signal for lcomp buffer.
    //
    // Bits[26:25], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX sel_bqt_for_lcomp : 2;
#else
    UINTX reserved_9 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[27:27], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved1 : 1;
#else
    UINTX reserved_10 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[28:28], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved0 : 1;
#else
    UINTX reserved_11 : 1;
#endif // MEM_SV_HOOKS
    //
    // CLKTX selects one of several clock inputs to get best update margin
    //
    // Bits[30:29], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX clktx_rcompdelaysel : 2;
#else
    UINTX reserved_12 : 2;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_13 : 1;
#else
    UINTX reserved_13 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_CTL0_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_CTL1_DPLVUG_REG                        0x00000050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // enable indirect update, when '1', it enables indirect update for respective group,
    // when '0', it disables indirect update for that group.
    //
    // Bits[5:0], RW, default = 0x3F
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_en_indirect_update : 6;
#else
    UINTX reserved : 6;
#endif // MEM_SV_HOOKS
    //
    // tells the rcomp which groups are valid.
    //
    // Bits[11:6], RW, default = 0x3F
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_pdcode_valid_bits : 6;
#else
    UINTX reserved_1 : 6;
#endif // MEM_SV_HOOKS
    //
    // tells the rcomp to copy the adjecent code instead of evaluating it
    //
    // Bits[16:12], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lcomp_pdcode_copy_bits : 5;
#else
    UINTX reserved_2 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 15;
#else
    UINTX reserved_3 : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_CTL1_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_RSTCTL_DPLVUG_REG                      0x00000054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // active low reset for lcomp.
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lcomprst_b : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_RSTCTL_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_TXDLYCOMP_CLKGATE_DPLVUG_REG                  0x00000058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Clock gating control for txdlycomp
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_clkgate_en : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Clock gating control for rcomp.
    //
    // Bits[1:1], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_clkgate_en : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:2], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_2 : 30;
#else
    UINTX reserved_2 : 30;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_TXDLYCOMP_CLKGATE_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_TXDLYCOMP_INIT_DPLVUG_REG                     0x0000005C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // enable initial txdlycomp
    //
    // Bits[0:0], RW/1S/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_init_comp : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_1 : 31;
#else
    UINTX reserved_1 : 31;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_TXDLYCOMP_INIT_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_TXDLYCOMPOVR_DPLVUG_REG                       0x00000060
#ifndef ASM_INC
typedef union {
  struct {
    //
    // TX Delay c73p1ddrlp34l64x1top_comp MAX value of fine code.
    //
    // Bits[3:0], RW, default = 0x4
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_fine_max : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // TX Delay c73p1ddrlp34l64x1top_comp MAX value of coarse code.
    //
    // Bits[7:4], RW, default = 0x7
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_coarse_max : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Enable for TX Delay ocmp live code override value.
    //
    // Bits[8:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_live_override_en : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // TX Delay c73p1ddrlp34l64x1top_comp live code override value
    //
    // Bits[16:9], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_live_override : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[19:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_4 : 3;
#else
    UINTX reserved_4 : 3;
#endif // MEM_SV_HOOKS
    //
    // Delay in compclks before sending timing reference pulse. Allows time for new live
    // code under test to propagate to AFE, before applying reference pulse.
    //
    // Bits[23:20], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_dly_setup_delay : 4;
#else
    UINTX reserved_6 : 4;
#endif // MEM_SV_HOOKS
    //
    // Delay in compclks after sending timing reference pulse before sampling updn. Allows
    // time for AFE circuit to resolve to appropriate updn result after asserting the
    // reference pulse.
    //
    // Bits[31:24], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_dly_sample_delay : 8;
#else
    UINTX reserved_7 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_TXDLYCOMPOVR_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LCOMP_READBACK_DPLVUG_REG                     0x00000064
#ifndef ASM_INC
typedef union {
  struct {
    //
    // read back value of txdlycomp limit error set flag
    //
    // Bits[0:0], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_limit_hit_error_set : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // read back value from AFE
    //
    // Bits[4:1], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX lcomp_cmn_obonus : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:5], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_2 : 27;
#else
    UINTX reserved_2 : 27;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LCOMP_READBACK_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LRCOMP_CTL2_DPLVUG_REG                        0x00000068
#ifndef ASM_INC
typedef union {
  struct {
    //
    // For future designs, where there might be a need to generate a stage3 enable for
    // AFE. It needs to be '1' otherwise.
    //
    // Bits[3:0], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_enable_width : 4;
#else
    UINTX reserved : 4;
#endif // MEM_SV_HOOKS
    //
    // For future designs, where there might be a need to generate a stage3 enable for
    // AFE. It needs to be '1' otherwise.
    //
    // Bits[7:4], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_hold_width : 4;
#else
    UINTX reserved_1 : 4;
#endif // MEM_SV_HOOKS
    //
    // For future designs, where there might be a need to generate a stage3 enable for
    // AFE. It needs to be '1' otherwise.
    //
    // Bits[11:8], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_setup_width : 4;
#else
    UINTX reserved_2 : 4;
#endif // MEM_SV_HOOKS
    //
    // the number of cycles after lcomp receives the bus_quiet_time_gnt signal, and before
    // it takes any action. This allows the phy to finish off any running read/write
    // cycles
    //
    // Bits[18:12], RW, default = 0x1
    //
#ifdef MEM_SV_HOOKS
    UINTX lrcomp_bqt_settle_width : 7;
#else
    UINTX reserved_3 : 7;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:19], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_4 : 13;
#else
    UINTX reserved_4 : 13;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LRCOMP_CTL2_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_GRCOMP_PERIODICCOMP_DPLVUG_REG                0x0000006C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // bit to enable the periodic rcomp. It also enables the periodic txdlycomp
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_periodic_enable : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // bit to start the initial rcomp
    //
    // Bits[1:1], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX comp_periodiccntr_enable : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // bit to start the initial rcomp
    //
    // Bits[31:2], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_2 : 30;
#else
    UINTX reserved_2 : 30;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_GRCOMP_PERIODICCOMP_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_TXDLYCOMP_0_DPLVUG_REG                        0x00000070
#ifndef ASM_INC
typedef union {
  struct {
    //
    // TxDLY c73p1ddrlp34l64x1top_PM Exit Enable 0 - Do not re-eval TxDLY codes on PM3
    // Exit 1 - Re-eval txdly codes on PM3 Exit
    //
    // Bits[0:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_pmexit_enable : 1;
#else
    UINTX reserved : 1;
#endif // MEM_SV_HOOKS
    //
    // TBD
    //
    // Bits[1:1], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_1group : 1;
#else
    UINTX reserved_1 : 1;
#endif // MEM_SV_HOOKS
    //
    // continuous enable mode for txdlycomp
    //
    // Bits[2:2], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_continuous_en : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // CLKTX reset of OTF latches, active low
    //
    // Bits[3:3], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX clktx_resetb : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // TBD
    //
    // Bits[4:4], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_limit_hit_error : 1;
#else
    UINTX reserved_4 : 1;
#endif // MEM_SV_HOOKS
    //
    // config value for grp0 fine code.
    //
    // Bits[12:5], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp0_fine_override : 8;
#else
    UINTX reserved_5 : 8;
#endif // MEM_SV_HOOKS
    //
    // config value for grp0 coarse code.
    //
    // Bits[20:13], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp0_coarse_override : 8;
#else
    UINTX reserved_6 : 8;
#endif // MEM_SV_HOOKS
    //
    // bits for override control of grp0 code
    //
    // Bits[21:21], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp0_override_en : 1;
#else
    UINTX reserved_7 : 1;
#endif // MEM_SV_HOOKS
    //
    // bits to disable for group0 code update.
    //
    // Bits[22:22], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp0_update_disable : 1;
#else
    UINTX reserved_8 : 1;
#endif // MEM_SV_HOOKS
    //
    // select the delay tap node in AFE for group0
    //
    // Bits[27:23], RW, default = 0x6
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp0_tapsel : 5;
#else
    UINTX reserved_9 : 5;
#endif // MEM_SV_HOOKS
    //
    // enable for config update contorl for txdlycomp code.
    //
    // Bits[28:28], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_updtbyen : 1;
#else
    UINTX reserved_10 : 1;
#endif // MEM_SV_HOOKS
    //
    // config update contorl for txdlyocmp code
    //
    // Bits[29:29], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_update : 1;
#else
    UINTX reserved_11 : 1;
#endif // MEM_SV_HOOKS
    //
    // Config CLKTX AFE Stg3 txdly c73p1ddrlp34l64x1top_comp override enable, used for
    // non DDR3L modes
    //
    // Bits[30:30], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX clktx_scompoverride : 1;
#else
    UINTX reserved_12 : 1;
#endif // MEM_SV_HOOKS
    //
    // CLKTX AFE Stg3 Rcomp override enable, used for non DDR3L modes
    //
    // Bits[31:31], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX clktx_rcompoverride : 1;
#else
    UINTX reserved_13 : 1;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_TXDLYCOMP_0_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_TXDLYCOMP_1_DPLVUG_REG                        0x00000074
#ifndef ASM_INC
typedef union {
  struct {
    //
    // config value for grp1 fine code.
    //
    // Bits[7:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp1_fine_override : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // config value for grp1 coarse code.
    //
    // Bits[15:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp1_coarse_override : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // bits for override control of grp1 code
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp1_override_en : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // bits to disable for group1 code update.
    //
    // Bits[17:17], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp1_update_disable : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // select the delay tap node in AFE for group1
    //
    // Bits[22:18], RW, default = 0x6
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp1_tapsel : 5;
#else
    UINTX reserved_4 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 9;
#else
    UINTX reserved_5 : 9;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_TXDLYCOMP_1_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_TXDLYCOMP_2_DPLVUG_REG                        0x00000078
#ifndef ASM_INC
typedef union {
  struct {
    //
    // config value for grp2 fine code.
    //
    // Bits[7:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp2_fine_override : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // config value for grp2 coarse code.
    //
    // Bits[15:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp2_coarse_override : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // bits for override control of grp2 code
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp2_override_en : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // bits to disable for group2 code update.
    //
    // Bits[17:17], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp2_update_disable : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // select the delay tap node in AFE for group2
    //
    // Bits[22:18], RW, default = 0x6
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp2_tapsel : 5;
#else
    UINTX reserved_4 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 9;
#else
    UINTX reserved_5 : 9;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_TXDLYCOMP_2_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_TXDLYCOMP_3_DPLVUG_REG                        0x0000007C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // config value for grp3 fine code.
    //
    // Bits[7:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp3_fine_override : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // config value for grp3 coarse code.
    //
    // Bits[15:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp3_coarse_override : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // bits for override control of grp3 code
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp3_override_en : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // bits to disable for group3 code update.
    //
    // Bits[17:17], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp3_update_disable : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // select the delay tap node in AFE for group3
    //
    // Bits[22:18], RW, default = 0x6
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp3_tapsel : 5;
#else
    UINTX reserved_4 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 9;
#else
    UINTX reserved_5 : 9;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_TXDLYCOMP_3_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_TXDLYCOMP_4_DPLVUG_REG                        0x00000080
#ifndef ASM_INC
typedef union {
  struct {
    //
    // config value for grp4 fine code.
    //
    // Bits[7:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp4_fine_override : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // config value for grp4 coarse code.
    //
    // Bits[15:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp4_coarse_override : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // bits for override control of grp4 code
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp4_override_en : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // bits to disable for group4 code update.
    //
    // Bits[17:17], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp4_update_disable : 1;
#else
    UINTX reserved_3 : 1;
#endif // MEM_SV_HOOKS
    //
    // select the delay tap node in AFE for group4
    //
    // Bits[22:18], RW, default = 0x6
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_grp4_tapsel : 5;
#else
    UINTX reserved_4 : 5;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:23], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_5 : 9;
#else
    UINTX reserved_5 : 9;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_TXDLYCOMP_4_DPLVUG_STRUCT;
#endif // ASM_INC

#define CH1_DPIC_TXDLYCOMP_0_DPLVUG_REG                    0x00000084
#ifndef ASM_INC
typedef union {
  struct {
    //
    // config value for grp0 fine code.
    //
    // Bits[7:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_ltxdlycomp_grp0_fine_override : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // config value for grp0 coarse code.
    //
    // Bits[15:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_ltxdlycomp_grp0_coarse_override : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // bits for override control of grp0 code
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_ltxdlycomp_grp0_override_en : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 15;
#else
    UINTX reserved_3 : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CH1_DPIC_TXDLYCOMP_0_DPLVUG_STRUCT;
#endif // ASM_INC

#define CH1_DPIC_TXDLYCOMP_1_DPLVUG_REG                    0x00000088
#ifndef ASM_INC
typedef union {
  struct {
    //
    // config value for grp1 fine code.
    //
    // Bits[7:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_ltxdlycomp_grp1_fine_override : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // config value for grp1 coarse code.
    //
    // Bits[15:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_ltxdlycomp_grp1_coarse_override : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // bits for override control of grp1 code
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_ltxdlycomp_grp1_override_en : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 15;
#else
    UINTX reserved_3 : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CH1_DPIC_TXDLYCOMP_1_DPLVUG_STRUCT;
#endif // ASM_INC

#define CH1_DPIC_TXDLYCOMP_2_DPLVUG_REG                    0x0000008C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // config value for grp2 fine code.
    //
    // Bits[7:0], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_ltxdlycomp_grp2_fine_override : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // config value for grp2 coarse code.
    //
    // Bits[15:8], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_ltxdlycomp_grp2_coarse_override : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // bits for override control of grp2 code
    //
    // Bits[16:16], RW, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ch1_ltxdlycomp_grp2_override_en : 1;
#else
    UINTX reserved_2 : 1;
#endif // MEM_SV_HOOKS
    //
    // Reserved bits
    //
    // Bits[31:17], RO, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX reserved_3 : 15;
#else
    UINTX reserved_3 : 15;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} CH1_DPIC_TXDLYCOMP_2_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LTXDLYCOMP_CODES_0_DPLVUG_REG                 0x00000090
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQS fine code value.
    //
    // Bits[7:0], RO/V, default = 0x8
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_fine_code_grp1 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // DQS coarse code value.
    //
    // Bits[15:8], RO/V, default = 0x7
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_coarse_code_grp1 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // DQ fine code value.
    //
    // Bits[23:16], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_fine_code_grp0 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // DQ coarse code value.
    //
    // Bits[31:24], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_coarse_code_grp0 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LTXDLYCOMP_CODES_0_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LTXDLYCOMP_CODES_1_DPLVUG_REG                 0x00000094
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CTL fine code value.
    //
    // Bits[7:0], RO/V, default = 0x8
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_fine_code_grp3 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // CTL coarse code value.
    //
    // Bits[15:8], RO/V, default = 0x7
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_coarse_code_grp3 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // CA fine code value.
    //
    // Bits[23:16], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_fine_code_grp2 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // CA coarse code value.
    //
    // Bits[31:24], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_coarse_code_grp2 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LTXDLYCOMP_CODES_1_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LTXDLYCOMP_CODES_2_DPLVUG_REG                 0x00000098
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CA fine code value.  (CH1)
    //
    // Bits[7:0], RO/V, default = 0x8
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_ch1_fine_code_grp0 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // CA coarse code value. (CH1)
    //
    // Bits[15:8], RO/V, default = 0x7
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_ch1_coarse_code_grp0 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // CK fine code value.
    //
    // Bits[23:16], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_fine_code_grp4 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // CK coarse code value.
    //
    // Bits[31:24], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_coarse_code_grp4 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LTXDLYCOMP_CODES_2_DPLVUG_STRUCT;
#endif // ASM_INC

#define DPIC_LTXDLYCOMP_CODES_3_DPLVUG_REG                 0x0000009C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CK fine code value.  (CH1)
    //
    // Bits[7:0], RO/V, default = 0x8
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_ch1_fine_code_grp2 : 8;
#else
    UINTX reserved : 8;
#endif // MEM_SV_HOOKS
    //
    // CK coarse code value.  (CH1)
    //
    // Bits[15:8], RO/V, default = 0x7
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_ch1_coarse_code_grp2 : 8;
#else
    UINTX reserved_1 : 8;
#endif // MEM_SV_HOOKS
    //
    // CTL fine code value.  (CH1)
    //
    // Bits[23:16], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_ch1_fine_code_grp1 : 8;
#else
    UINTX reserved_2 : 8;
#endif // MEM_SV_HOOKS
    //
    // CTL coarse code value.  (CH1)
    //
    // Bits[31:24], RO/V, default = 0x0
    //
#ifdef MEM_SV_HOOKS
    UINTX ltxdlycomp_ch1_coarse_code_grp1 : 8;
#else
    UINTX reserved_3 : 8;
#endif // MEM_SV_HOOKS
  } Bits;
  UINTX Data;
} DPIC_LTXDLYCOMP_CODES_3_DPLVUG_STRUCT;
#endif // ASM_INC


#endif // _DPLVUG_H_
