/** @file
  File name:    MmrcProjectDefinitionsGenerated.h
  Input File:   BXTP_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in MmrcProjectDefinitions.h, which is used for non-tool-generated
  data

  Includes all hard defines specific to a project. Things like
  the maximum number of channels, ranks, DIMMs, etc, should be included
  here. This file needs to be included by most MMRC components,
  including Mmrc.h.

  @copyright
  Copyright (c) 2005-2016 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by the
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is uniquely
  identified as 'Intel Reference Module' and is licensed for Intel
  CPUs and chipsets under the terms of your license agreement with
  Intel or your vendor. This file may be modified by the user, subject
  to additional terms of the license agreement.

  @par Specification
**/
#ifndef _MMRCPROJECTDEFINITIONSGENERATED_H_
#define _MMRCPROJECTDEFINITIONSGENERATED_H_

//
// All boxtypes supported by the MRC. Boxtypes are distinct components of silicon.
//
#define DUNIT                                              0x00
#define CPGC                                               0x01
#define DQ                                                 0x02
#define CCC                                                0x03
#define SAI                                                0x04
#define ADPLL                                              0x05
#define LDO                                                0x06
#define DPLVUG                                             0x07
#define DPIC                                               0x08
#define DQDPIC                                             0x09
#define DQDPLVUG                                           0x0A
#define CUNIT                                              0x0B
#define PUNIT                                              0x0C
#define MLMC                                               0x0D
#define AUNIT                                              0x0E
#define P2SB                                               0x0F
#define BUNIT                                              0x10
//
// Maximum Box Types across blueprints
//
#define MAX_BOXES                                          0x11
//
// Maximum IO Levels across blueprints
//
#define MAX_IO_LEVELS                                      0x03
//
// Maximum Box Types for BLUEPRINT_LPDDR34
//
#define BOXES_BLUEPRINT_LPDDR34                            0x11
//
// Maximum Box Types for BLUEPRINT_DDR3
//
#define BOXES_BLUEPRINT_DDR3                               0x11
//
// Maximum length of the boxtype strings
//
#define MAX_BOXNAME_LENGTH                                 9
//
// Register access methods (sideband, PCI, etc)
//
#define eSB                                                0
#define ePCI                                               1
#define eBAR                                               2
#define eACCESS_METHOD_ERROR                               3
//
// Maximum number of GetSets Sheets
//
#define MAX_GETSETS                                        2
//
// Maximum number of blueprints
//
#define MAX_BLUEPRINTS                                     2
//
// Number assignments for each blueprint
//
#define BLUEPRINT_LPDDR34                                  0
#define BLUEPRINT_DDR3                                     1
//
// Maximum number of Instances
//
#define MAX_INSTANCE_PORTS                                 50
//
// Maximum Instance Ports for BLUEPRINT_LPDDR34
//
#define INSTANCE_PORTS_BLUEPRINT_LPDDR34                   50
//
// Maximum Instance Ports for BLUEPRINT_DDR3
//
#define INSTANCE_PORTS_BLUEPRINT_DDR3                      46
//
// Maximum string length of all register names and fieldnames.
//
#define MAX_REGISTER_NAME_LENGTH                           0x0036
//
// This project contains 64 bit variables.
//
#define USE_64_BIT_VARIABLES                               1
//
// Channels
//
#define MAX_CHANNELS                                       4
//
// DIMMS Per Channel
//
#define MAX_DIMMS                                          1
//
// Ranks Per Channel
//
#define MAX_RANKS                                          2
//
// Strobelanes Per Module
//
#define MAX_STROBELANES_PER_DQ_MODULE                      2
//
// DQ Modules Per Channel
//
#define MAX_DQ_MODULES                                     5
//
// Width of the entire bus in bits (i.e. 64 for non-ECC and 72 for ECC)
//
#define MAX_BUS_WIDTH                                      72
//
// Max Strobes Per Channel
//
#define MAX_STROBES                                        9
//
// Max Strobes Per Channel when ECC is disabled
//
#define MAX_STROBES_NON_ECC                                (MAX_STROBES-1)
//
// Bytelanes Per Module
//
#define MAX_BYTELANES_PER_DQ_MODULE                        2
//
// Number of Memory Controllers per CPU socket
//
#define MAX_DUNITS                                         4
//
// Max number of ranks for a single DIMM
//
#define MAX_RANKS_PER_DIMM                                 2
//
// Number of commands sent to the DRAMs during JEDEC init.
//
#define MR_COUNT                                           3
//
// Is DDR3 supported on this project?
//
#define DDR3_SUPPORT                                       1
//
// Is DDR4 supported on this project?
//
#define DDR4_SUPPORT                                       0
//
// Is DDRT supported on this project?
//
#define DDRT_SUPPORT                                       0
//
// Is LPDDR3 supported on this project?
//
#define LPDDR3_SUPPORT                                     1
//
// Is LPDDR4 supported on this project?
//
#define LPDDR4_SUPPORT                                     1
//
// Is WIO2 supported on this project?
//
#define WIO2_SUPPORT                                       1
//
// Which version of CPGC is used on this project? AVN = 99, ANN/CHV = 100, BXT = 200
//
#define CPGC_VERSION                                       200
//
// Max Number of values for the Axis Y
//
#define MAX_ELEMENTS_DIM_Y                                 64
//
// Max Number of values for the Axis X
//
#define MAX_ELEMENTS_DIM_X                                 128
//
// If disabled, the MRC codebase being used will supply its own GetSet functions and data structures.
//
#define USE_GET_SET_FROM_SPREADSHEET                       1
//
// Number of memory confiurations supported. For example - if LPDDR3 1600 and LPDDR4 3200 are the only configurations supported, this would be 2.
//
#define MAX_CONFIGS                                        18
//
// Maximum number of DRAM densities supported (i.e 4Gb, 8Gb, 16Gb = 3)
//
#define MAX_DENSITIES                                      5
//
// Number of knobs per algo
//
#define MAX_KNOBS                                          1
//
// Number of DQ per BL
//
#define MAX_BITS                                           8
//
// Command groups per channel.
//
#define MAX_CMDS                                           2
//
// Control Groups Per Channel.
//
#define MAX_CTLS                                           2
//
// Clock Groups Per Channel.
//
#define MAX_CLKS                                           2
//
// Major Version
//
#define VERSION_MAJOR                                      88
//
// Minor Version
//
#define VERSION_MINOR                                      85
//
// Print MRC functions as they execute
//
#define CAPSULESTRINGS                                     0
//
//
//
#define ERROR_MESSAGES                                     1
//
// Use CPGC for training
//
#define CPGC_API                                           1
//
// Lowest address bit for rank selection during training
//
#define RANK_SHIFT_BIT                                     25
//
// Debug message output to serial or console
//
#define DEBUG_MSG                                          1
//
// Enable training algorithms
//
#define TRAINING_ALGOS                                     1
//
// Number of Samples to take for Rcvn/FWL.
//
#define NUMSAMPLES                                         8
//
// Number of consecutive samples to pass for RCVN/FWL.
//
#define SAMPLETHRESH                                       5
//
// Dithering check for stability for RCVN/FWL.
//
#define DITHER                                             5
//
// Receive enable training
//
#define RECEIVE_ENABLE                                     1
//
// Number of 2x for LP3
//
#define RCVN_PREAMBLE_CNTR_LP3                             1
//
// Number of 2x for LP4
//
#define RCVN_PREAMBLE_CNTR_LP4                             2
//
// Number of 2x for DDR3
//
#define RCVN_PREAMBLE_CNTR_DDR3                            1
//
// Number of ps for LP3
//
#define RCVN_PREAMBLE_OFFSET_LP3                           0
//
// Number of ps for LP4
//
#define RCVN_PREAMBLE_OFFSET_LP4                           0
//
// Number of ps for DDR3
//
#define RCVN_PREAMBLE_OFFSET_DDR3                          0
//
// Starting point for the half clock during receive enable.
//
#define RCVN_INITIAL2XVAL_LP3                              12
//
// Starting point for the half clock during receive enable.
//
#define RCVN_INITIAL2XVAL_LP4                              13
//
// Starting point for the half clock during receive enable.
//
#define RCVN_INITIAL2XVAL_DDR3                             14
//
// Enable Rank-2-Rank Training for LP3
//
#define RCVN_RANK2RANK_ON_LP3                              0
//
// Enable Rank-2-Rank Training for LP4
//
#define RCVN_RANK2RANK_ON_LP4                              0
//
// Enable Rank-2-Rank Training for DDR3
//
#define RCVN_RANK2RANK_ON_DDR3                             0
//
// Large Step size as percentage of the Half Clock.
//
#define RCVN_LARGE_STEP                                    25
//
// Step size during second phase of receive enable
//
#define RCVN_MEDIUM_STEP                                   5
//
// Step size during final phase of receive enable
//
#define RCVN_SMALL_STEP                                    1
//
// Fine write leveling training
//
#define FINE_WRITE_LEVELING                                1
//
// Enable Rank-2-Rank Training for LP3
//
#define FWL_RANK2RANK_ON_LP3                               0
//
// Enable Rank-2-Rank Training for LP4
//
#define FWL_RANK2RANK_ON_LP4                               0
//
// Large Step size as percentage of the Half Clock.
//
#define FWL_LARGE_STEP                                     25
//
// Step size during second phase of receive enable
//
#define FWL_MEDIUM_STEP                                    5
//
// Step size during final phase of receive enable
//
#define FWL_SMALL_STEP                                     1
//
// Coarse write leveling training
//
#define COARSE_WRITE_LEVELING                              1
//
// Number of cks to push out DQS
//
#define CWL_CLK_PUSHOUT                                    3
//
// Step size for each DQ Testing (LP4)
//
#define CWL_DQ_STEP                                        5
//
// Early Command Training
//
#define EARLY_COMMAND_TRAINING                             1
//
// Vref to perform ECT.
//
#define ECT_LP4_VREF                                       0x60
//
// Width and Height of the search matrix.
//
#define ECT_TILE_WIDTH                                     9
//
// Use CPGC or DRAM_CMD to enter CBT mode (LP3 Only CA-2N Mode)
//
#define ECT_ENTERCBT_CPGC                                  1
//
// Enable the pushout of the CCC flag
//
#define PUSHOUT_CCC                                        1
//
// Pushout by the number of 2x clcoks.
//
#define PUSHOUT_VALUE                                      2
//
// Early Read Training
//
#define EARLY_READ_TRAINING                                1
//
// After finding final edge, amount of dithering to test.
//
#define ERT_DITHER                                         0
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF_LPDDR4                                    0xA
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF_LPDDR3                                    0x1f
//
// Nominal RdVref for ERT training.
//
#define ERT_VREF_DDR3                                      0x1f
//
// Larger step size to find edge.
//
#define ERT_LARGESTEP                                      10
//
// Medium step size to find edge.
//
#define ERT_MEDIUMSTEP                                     5
//
// Small step size to find edge.
//
#define ERT_SMALLSTEP                                      1
//
// Victim/aggressor read training
//
#define READ_TRAINING                                      1
//
// P/N Independent Training
//
#define RT_PN_ENABLED                                      1
//
// If no PBD set to 0xFF else use format RANK_SHARED|KNOB_SHARED | BIT_SHARED | BIT_CONTROL
//
#define RT_BIT_SHARING                                     RANK_SHARED|KNOB_SHARED | BIT_CONTROL|CALCULATE_BIT
//
//
//
#define RT_BYTE_SHARING                                    BIT_SHARED|KNOB_SHARED
//
//
//
#define RT_PERBIT_ENABLED                                  1
//
//
//
#define RT_NUM_EYEMASKS                                    2
//
//
//
#define RT_EYEMASK0_PI                                     15
//
//
//
#define MAX_POWER_KNOBS                                    1
//
//
//
#define RT_EYEMASK_VREF                                    3
//
//
//
#define RT_EYEMASK1_PI                                     15
//
//
//
#define RT_STEP1_VREFMIN                                   0
//
//
//
#define RT_STEP1_VREFMAX                                   63
//
//
//
#define RT_STEP1_VREFSTEP                                  2
//
//
//
#define RT_STEP1_VREFSTART_LP3                             25
//
//
//
#define RT_STEP1_VREFSTART_LP4                             0
//
//
//
#define RT_STEP1_VREFSTART_DDR3                            25
//
//
//
#define RT_STEP1_3_PISTEPLARGE                             1
//
//
//
#define RT_STEP1_3_PISTEPMEDIUM                            0
//
//
//
#define RT_STEP1_3_PISTEPSMALL                             0
//
//
//
#define RT_CTLE_MIN                                        0
//
//
//
#define RT_CTLE_MAX                                        0
//
//
//
#define RT_CTLE_STEP                                       2
//
//
//
#define RT_CTLE_ENABLE                                     0
//
//
//
#define RT_STEP2_VREFMIN                                   0
//
//
//
#define RT_STEP2_VREFMAX                                   63
//
//
//
#define RT_STEP2_VREFSTEP                                  5
//
//
//
#define RT_STEP3_VREFSAMPLES                               3
//
// Pi/VREF center estimate weight
//
#define RT_STEP1_PICENTER_MINWEIGHT                        2
//
//
//
#define RT_STEP1_PICENTER_MIDWEIGHT                        3
//
//
//
#define RT_STEP1_PICENTER_MAXWEIGHT                        5
//
//
//
#define RT_CTLE_SHARED                                     RANK_SHARED|KNOB_SHARED | BIT_SHARED | BIT_CONTROL
//
//
//
#define RT_STEP2_PISAMPLES                                 3
//
// Advance Write Training
//
#define WRITE_TRAINING                                     1
//
//
//
#define WT_PERBIT_ENABLED                                  1
//
// 0xff
//
#define WT_BIT_SHARING                                     RANK_SHARED|KNOB_SHARED | BIT_CONTROL
//
//
//
#define WT_BYTE_SHARING                                    BIT_SHARED|KNOB_SHARED
//
//
//
#define WT_NUM_EYEMASKS                                    2
//
//
//
#define WT_EYEMASK0_PI                                     40
//
//
//
#define WT_EYEMASK_VREF                                    3
//
//
//
#define WT_EYEMASK1_PI                                     1
//
// No Vref Control
//
#define WT_STEP1_VREFMIN_DDR3                              0
//
// Vref Control
//
#define WT_STEP1_VREFMIN_LP3                               0
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFMIN_LP4                               100
//
// No Vref Control
//
#define WT_STEP1_VREFSTEP_DDR3                             1
//
// Vref Control
//
#define WT_STEP1_VREFSTEP_LP3                              2
//
// 10th of percange of VDDQ
//
#define WT_STEP1_VREFSTEP_LP4                              8
//
// NO Vref Control
//
#define WT_STEP1_VREFMAX_DDR3                              1
//
// Vref Control
//
#define WT_STEP1_VREFMAX_LP3                               63
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFMAX_LP4                               420
//
// No Vref Control
//
#define WT_STEP1_VREFSTART_DDR3                            0
//
// Vref Control
//
#define WT_STEP1_VREFSTART_LP3                             0
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFSTART_LP4                             420
//
// 10th of percange of VDDQ
//
#define WT_STEP1_VREFSTEP                                  8
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFMAX                                   420
//
// 10th of percange of VDDQ; THESE ARE NOT USED
//
#define WT_STEP1_VREFSTART                                 420
//
//
//
#define WT_STEP1_3_PISTEPLARGE                             1
//
//
//
#define WT_STEP1_3_PISTEPMEDIUM                            0
//
//
//
#define WT_STEP1_3_PISTEPSMALL                             0
//
//
//
#define WT_STEP2_VREFMIN                                   400
//
//
//
#define WT_STEP2_VREFMAX                                   4
//
// No Vref Control
//
#define WT_STEP2_VREFSTEP_DDR3                             1
//
// Vref Control
//
#define WT_STEP2_VREFSTEP_LP3                              5
//
// Vref Control
//
#define WT_STEP2_VREFSTEP_LP4                              421
//
//
//
#define WT_STEP3_VREFSAMPLES                               3
//
//
//
#define WT_STEP1_PICENTER_MINWEIGHT                        2
//
//
//
#define WT_STEP1_PICENTER_MIDWEIGHT                        3
//
//
//
#define WT_STEP1_PICENTER_MAXWEIGHT                        5
//
//
//
#define WT_VREFOVERRIDE_VALUE                              37
//
//
//
#define WT_VREF_OVERRIDE_ENABLE                            1
//
//
//
#define VDDQ                                               1100
//
//
//
#define LDO_TARGET                                         850
//
//
//
#define LDO_ENABLED                                        0
//
//
//
#define RON                                                35
//
//
//
#define ODT                                                999999
//
//
//
#define RTWT_SIM                                           0
//
//
//
#define PERIODIC_TRAINING                                  1
//
// Enable RMT Support
//
#define RMT                                                1
//
//  OKAY to DELETE ** set to 0 on release code ** Peter put here just for sim purposes
//
#define RMT_WRITE_CHECKPOINT                               0
//
// default RMT burst length
//
#define RMT_NUMBURSTS                                      13
//
// default RMT loop count
//
#define RMT_LOOPCOUNT                                      10
//
// Loopcount for production RMT test
//
#define RMT_PRODUCTION_LOOPCOUNT                           7
//
// Numbursts for production RMT test
//
#define RMT_PRODUCTION_NUMBURSTS                           7
//
// CPGC RMT Logging Enable
//
#define RMT_BIT_ERROR_LOGGING_ENABLE                       0
//
// Loopcount for PPV RMT test
//
#define RMT_PPV_LOOPCOUNT                                  7
//
// Numbursts for PPV RMT test
//
#define RMT_PPV_NUMBURSTS                                  13
//
// Enable Per-Bit margin
//
#define RMT_PER_BIT_MARGIN                                 1
//
// max # of retries (w/JEDEC) if fail after RMT test
//
#define POST_RMT_RETRIES                                   5
//
// jump to other training postcode from RMT command loop
//
#define RMT_JUMP_POSTCODES                                 1
//
// Enable or disable support of the production RMT margin check
//
#define RMT_PRODUCTION_MODE_SUPPORT                        1
//
// Late command training
//
#define COMMAND_TRAINING                                   1
//
// Test all memory at the end of MRC
//
#define MEMORY_TEST                                        0
//
// Initialize ECC at the end of MRC
//
#define ECC_SCRUB                                          0
//
// Display all DDRIO delays at the end of MRC
//
#define PHYVIEW_TABLE                                      1
//
// Display memory controller timings
//
#define TIMING_TABLE                                       1
//
// Display function calls
//
#define MRC_FLOW                                           0
//
// Enable BDAT table for publishing memory information in ACPI
//
#define BDAT                                               0
//
// Detect DIMMs via SPD reads
//
#define DETECT_DIMMS                                       0
//
// Enable PUNIT communication via mailbox
//
#define PUNIT_MAILBOX                                      0
//
// Use ODT input table from KIT team
//
#define ODT_TABLE                                          0
//
// Are minus 1 selects supported on this project?
//
#define TX_DQS_MINUS1_SUPPORT                              0
//
// Are minus 1 selects supported on this project?
//
#define TX_DQ_MINUS1_SUPPORT                               0
//
// Display register names with dumping
//
#define DUMP_REGISTER_NAMES                                0
//
// Display register fields when dumping registers
//
#define DUMP_REGISTER_FIELDS                               0
//
// Display all descriptions when dumping them
//
#define DUMP_REGISTER_DESCRIPTIONS                         0
//
// Enable to use new receive enable and fine write leveling algos. These save code space.
//
#define SPACE_OPTIMIZED_ALGOS                              1
//
// Min receive VREF
//
#define RX_VREF_MIN                                        0
//
// Max receive VREF
//
#define RX_VREF_MAX                                        30
//
// Receive VREF step
//
#define RX_VREF_STEP                                       3
//
// Min transmit VREF
//
#define TX_VREF_MIN                                        0
//
// Max transmit VREF
//
#define TX_VREF_MAX                                        63
//
// Transmit VREF step
//
#define TX_VREF_STEP                                       3
//
// Enable Stack size reduction by commented out unused variable
//
#define STACK_SIZE_REDUCE_EN                               1
//
// Enable flag internal validation SV Hooks
//
#define MEM_SV_HOOKS                                       0
//
// Minimum allowable pulse width for RCVN and FWL in 1/16 clock increments. i.e. 4 = 1/4 clock.
//
#define MIN_PULSE_WIDTH                                    2
//
// When running Rd/Wr training, use per-bit algo.
//
#define NEW_RTWT_ALGO                                      1
//
//
//
#define CPGC_BASED_READWRITES                              1
//
//
//
#define CPGC_BASED_WRITES                                  1
//
//
//
#define CPGC_BASED_READS                                   0
//
//
//
#define CPGC_BASE_EARLYREADS                               0
//
//
//
#define EARLYMPR_1DSWEEP                                   1
//
//
//
#define RX_PI_MIN_WIDTH                                    20
//
//
//
#define LDO_TRAINING                                       0
//
//
//
#define CTLE_MIN                                           0
//
//
//
#define CTLE_MAX                                           3
//
//
//
#define CTLE_STEP                                          1
//
//
//
#define RT_VREF_MIN                                        0
//
//
//
#define RT_VREF_MAX                                        30
//
//
//
#define RT_VREF_STEP                                       3
//
//
//
#define NUM_CONS_MIN_EWS                                   3
//
//
//
#define NUM_FINAL_VREF_SAMPLES                             7
//
//
//
#define RX_PI_MIN_EYEWIDTH                                 15
//
//
//
#define TX_PI_MIN_EYEWIDTH                                 15
//
// When doing VREF Sweep, starting value
//
#define RT_VREF_SWEEPMIN                                   0
//
//
//
#define RT_VREF_SWEEPMAX                                   30
//
//
//
#define RT_VREF_SWEEPSTEP                                  5
//
// Pi/VREF center estimate weight
//
#define MIN_WEIGHT                                         2
//
//
//
#define MID_WEIGHT                                         3
//
//
//
#define MAX_WEIGHT                                         5
//
// When doing VREF Sweep, starting value
//
#define WT_VREF_SWEEPMIN                                   0
//
//
//
#define WT_VREF_SWEEPMAX                                   30
//
//
//
#define WT_VREF_SWEEPSTEP                                  5
//
// When determing Vref Center, number of PI columns
//
#define MAX_PI_SAMPLES                                     3
//
// When determing Pi center, number Vref rows
//
#define NUM_CONS_VREFS                                     3
//
//
//
#define RX_PI_MIN                                          0
//
//
//
#define RX_PI_MAX                                          64
//
//
//
#define RX_PI_STEP                                         1
//
//
//
#define MAX_PI                                             63
//
//
//
#define RTWT_SIM                                           0
//
//
//
#define BXT_PO                                             0
//
// Tile Search Step Size
//
#define ECT_STEP_SIZE                                      5
//
// Tile Search Width
//
#define ECT_TSWIDTH                                        9
//
// Tile Search Shedding Percentage
//
#define ECT_TS_SHEDDING_PERCENT                            50
//
// Tile Search Value Limit for each Loop (To prevent overflowing integers)
//
#define ECT_TS_VAL_LIMIT                                   255
//
//
//
#define RCVN_PREAM_CLK_SUBTRACT                            3
//
//
//
#define VOC_TRAINING                                       1
//
//
//
#define VOC_LP4_VrefRMin_LDO_ENABLE                        93
//
//
//
#define VOC_LP4_VrefRMax_LDO_ENABLE                        429
//
// Voltage ; LDO on = LP4 only
//
#define VOC_LP4_VrefRMin_LDO_DISABLE                       238
//
// Voltage ; LDO on = LP4 only
//
#define VOC_LP4_VrefRMax_LDO_DISABLE                       742
//
// Voltage
//
#define VOC_LP3_VrefRMin                                   238
//
// Voltage
//
#define VOC_LP3_VrefRMax                                   742
//
// Voltage
//
#define VOC_DDR3L_VrefRMin                                 238
//
// Voltage
//
#define VOC_DDR3L_VrefRMax                                 742
//
//
//
#define VOC_Rext                                           105
//
//
//
#define VOC_VREF_MAX                                       63
//
//
//
#define VOC_VREF_STEP_SIZE                                 1
//
//
//
#define VOC_LP4_PullUpRon_LDO_ENABLE                       140
//
//
//
#define VOC_LP4_PullDnRon_LDO_ENABLE                       40
//
//
//
#define VOC_LP4_PullUpRon_LDO_DISABLE                      140
//
//
//
#define VOC_LP4_PullDnRon_LDO_DISABLE                      40
//
//
//
#define VOC_LP3_PullUpRon                                  40
//
//
//
#define VOC_LP3_PullDnRon                                  40
//
//
//
#define VOC_DDR3L_PullUpRon                                40
//
//
//
#define VOC_DDR3L_PullDnRon                                40
//
//
//
#define VOC_LP4_SegmentsEnabled_LDO_ENABLE                 2
//
//
//
#define VOC_LP4_SegmentsEnabled_LDO_DISABLE                2
//
//
//
#define VOC_LP3_SegmentsEnabled                            2
//
//
//
#define VOC_DDR3L_SegmentsEnabled                          2
//
// Enable or disable debug messages related to Max PI setup.
//
#define MAXPIDLL_DEBUG_PRINT                               0
//
//
//
#define RDCMD2RDVLD_TRAINING                               1
//
// Does this DDRIO have an analog DLL?
//
#define ANALOG_DLL_SUPPORT_BLUEPRINT_LPDDR34               0
//
// Does this project have a digital DLL?
//
#define DIGITAL_DLL_SUPPORT_BLUEPRINT_LPDDR34              1
//
// Number of delay types which use clock crossings. Sometimes this is 1 in the case of only having a PI delay. Other projects have a coarse and a fine delay, so this would be 2.
//
#define NUM_CC_DEPENDENT_ELEMENTS_BLUEPRINT_LPDDR34        1
//
// Does this DDRIO have an analog DLL?
//
#define ANALOG_DLL_SUPPORT_BLUEPRINT_DDR3                  0
//
// Does this project have a digital DLL?
//
#define DIGITAL_DLL_SUPPORT_BLUEPRINT_DDR3                 1
//
// Number of delay types which use clock crossings. Sometimes this is 1 in the case of only having a PI delay. Other projects have a coarse and a fine delay, so this would be 2.
//
#define NUM_CC_DEPENDENT_ELEMENTS_BLUEPRINT_DDR3           1
//
// Definitions for register initialization sequence that tell the common MMRC libraries
// how to program a register, whether the offset is 8 or 16 bits, etc.
//
#define xxxxx1xx                                           0x00 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxx1xR                                           0x01 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxx1Sx                                           0x02 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxx1SR                                           0x03 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxx2xx                                           0x04 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxx2xR                                           0x05 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxx2Sx                                           0x06 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxx2SR                                           0x07 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxE1xx                                           0x08 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxE1xR                                           0x09 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxE1Sx                                           0x0A //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxE1SR                                           0x0B //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxE2xx                                           0x0C //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxxE2xR                                           0x0D //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxxE2Sx                                           0x0E //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxxE2SR                                           0x0F //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxMx1xx                                           0x10 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxMx1xR                                           0x11 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxMx1Sx                                           0x12 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxMx1SR                                           0x13 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxMx2xx                                           0x14 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxMx2xR                                           0x15 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxMx2Sx                                           0x16 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxMx2SR                                           0x17 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxME1xx                                           0x18 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxxME1xR                                           0x19 //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxxME1Sx                                           0x1A //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxxME1SR                                           0x1B //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxxME2xx                                           0x1C //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxxME2xR                                           0x1D //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxxME2Sx                                           0x1E //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxxME2SR                                           0x1F //  Done=FALSE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxx1xx                                           0x20 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxx1xR                                           0x21 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxx1Sx                                           0x22 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxx1SR                                           0x23 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxx2xx                                           0x24 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxx2xR                                           0x25 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxx2Sx                                           0x26 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxx2SR                                           0x27 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxE1xx                                           0x28 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxE1xR                                           0x29 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxE1Sx                                           0x2A //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxE1SR                                           0x2B //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNxE2xx                                           0x2C //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNxE2xR                                           0x2D //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNxE2Sx                                           0x2E //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNxE2SR                                           0x2F //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNMx1xx                                           0x30 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNMx1xR                                           0x31 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNMx1Sx                                           0x32 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNMx1SR                                           0x33 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNMx2xx                                           0x34 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNMx2xR                                           0x35 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNMx2Sx                                           0x36 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNMx2SR                                           0x37 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxNME1xx                                           0x38 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xxNME1xR                                           0x39 //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xxNME1Sx                                           0x3A //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xxNME1SR                                           0x3B //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xxNME2xx                                           0x3C //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xxNME2xR                                           0x3D //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xxNME2Sx                                           0x3E //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xxNME2SR                                           0x3F //  Done=FALSE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxx1xx                                           0x40 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxx1xR                                           0x41 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxx1Sx                                           0x42 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxx1SR                                           0x43 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxx2xx                                           0x44 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxx2xR                                           0x45 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxx2Sx                                           0x46 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxx2SR                                           0x47 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxE1xx                                           0x48 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxE1xR                                           0x49 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxE1Sx                                           0x4A //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxE1SR                                           0x4B //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxxE2xx                                           0x4C //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxxE2xR                                           0x4D //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxxE2Sx                                           0x4E //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxxE2SR                                           0x4F //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxMx1xx                                           0x50 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxMx1xR                                           0x51 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxMx1Sx                                           0x52 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxMx1SR                                           0x53 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxMx2xx                                           0x54 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxMx2xR                                           0x55 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxMx2Sx                                           0x56 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxMx2SR                                           0x57 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBxME1xx                                           0x58 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBxME1xR                                           0x59 //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBxME1Sx                                           0x5A //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBxME1SR                                           0x5B //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBxME2xx                                           0x5C //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBxME2xR                                           0x5D //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBxME2Sx                                           0x5E //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBxME2SR                                           0x5F //  Done=FALSE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxx1xx                                           0x60 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxx1xR                                           0x61 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxx1Sx                                           0x62 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxx1SR                                           0x63 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxx2xx                                           0x64 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxx2xR                                           0x65 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxx2Sx                                           0x66 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxx2SR                                           0x67 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxE1xx                                           0x68 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxE1xR                                           0x69 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxE1Sx                                           0x6A //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxE1SR                                           0x6B //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNxE2xx                                           0x6C //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNxE2xR                                           0x6D //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNxE2Sx                                           0x6E //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNxE2SR                                           0x6F //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNMx1xx                                           0x70 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNMx1xR                                           0x71 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNMx1Sx                                           0x72 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNMx1SR                                           0x73 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNMx2xx                                           0x74 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNMx2xR                                           0x75 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNMx2Sx                                           0x76 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNMx2SR                                           0x77 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xBNME1xx                                           0x78 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define xBNME1xR                                           0x79 //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define xBNME1Sx                                           0x7A //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define xBNME1SR                                           0x7B //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define xBNME2xx                                           0x7C //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define xBNME2xR                                           0x7D //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define xBNME2Sx                                           0x7E //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define xBNME2SR                                           0x7F //  Done=FALSE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define Dxxxx1xx                                           0x80 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define Dxxxx1xR                                           0x81 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define Dxxxx1Sx                                           0x82 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define Dxxxx1SR                                           0x83 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define Dxxxx2xx                                           0x84 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define Dxxxx2xR                                           0x85 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define Dxxxx2Sx                                           0x86 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define Dxxxx2SR                                           0x87 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxxxE1xx                                           0x88 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxxxE1xR                                           0x89 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxxxE1Sx                                           0x8A //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxxxE1SR                                           0x8B //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxxxE2xx                                           0x8C //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxxxE2xR                                           0x8D //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxxxE2Sx                                           0x8E //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxxxE2SR                                           0x8F //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxxMx1xx                                           0x90 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxxMx1xR                                           0x91 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxxMx1Sx                                           0x92 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxxMx1SR                                           0x93 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxxMx2xx                                           0x94 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxxMx2xR                                           0x95 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxxMx2Sx                                           0x96 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxxMx2SR                                           0x97 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxxME1xx                                           0x98 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxxME1xR                                           0x99 //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxxME1Sx                                           0x9A //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxxME1SR                                           0x9B //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxxME2xx                                           0x9C //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxxME2xR                                           0x9D //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxxME2Sx                                           0x9E //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxxME2SR                                           0x9F //  Done=TRUE UseBB2=FALSE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxx1xx                                           0xA0 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxx1xR                                           0xA1 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxx1Sx                                           0xA2 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxx1SR                                           0xA3 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxx2xx                                           0xA4 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxx2xR                                           0xA5 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxx2Sx                                           0xA6 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxx2SR                                           0xA7 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxE1xx                                           0xA8 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxE1xR                                           0xA9 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxE1Sx                                           0xAA //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxE1SR                                           0xAB //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNxE2xx                                           0xAC //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNxE2xR                                           0xAD //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNxE2Sx                                           0xAE //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNxE2SR                                           0xAF //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNMx1xx                                           0xB0 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNMx1xR                                           0xB1 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNMx1Sx                                           0xB2 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNMx1SR                                           0xB3 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNMx2xx                                           0xB4 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNMx2xR                                           0xB5 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNMx2Sx                                           0xB6 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNMx2SR                                           0xB7 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DxNME1xx                                           0xB8 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DxNME1xR                                           0xB9 //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DxNME1Sx                                           0xBA //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DxNME1SR                                           0xBB //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DxNME2xx                                           0xBC //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DxNME2xR                                           0xBD //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DxNME2Sx                                           0xBE //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DxNME2SR                                           0xBF //  Done=TRUE UseBB2=FALSE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxx1xx                                           0xC0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxx1xR                                           0xC1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxx1Sx                                           0xC2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxx1SR                                           0xC3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxx2xx                                           0xC4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxx2xR                                           0xC5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxx2Sx                                           0xC6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxx2SR                                           0xC7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxE1xx                                           0xC8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxE1xR                                           0xC9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxE1Sx                                           0xCA //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxE1SR                                           0xCB //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxxE2xx                                           0xCC //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxxE2xR                                           0xCD //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxxE2Sx                                           0xCE //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxxE2SR                                           0xCF //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxMx1xx                                           0xD0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxMx1xR                                           0xD1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxMx1Sx                                           0xD2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxMx1SR                                           0xD3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxMx2xx                                           0xD4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxMx2xR                                           0xD5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxMx2Sx                                           0xD6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxMx2SR                                           0xD7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBxME1xx                                           0xD8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBxME1xR                                           0xD9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBxME1Sx                                           0xDA //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBxME1SR                                           0xDB //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBxME2xx                                           0xDC //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBxME2xR                                           0xDD //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBxME2Sx                                           0xDE //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBxME2SR                                           0xDF //  Done=TRUE UseBB2=TRUE NeedSecondByte=FALSE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxx1xx                                           0xE0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxx1xR                                           0xE1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxx1Sx                                           0xE2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxx1SR                                           0xE3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxx2xx                                           0xE4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxx2xR                                           0xE5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxx2Sx                                           0xE6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxx2SR                                           0xE7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxE1xx                                           0xE8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxE1xR                                           0xE9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxE1Sx                                           0xEA //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxE1SR                                           0xEB //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNxE2xx                                           0xEC //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNxE2xR                                           0xED //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNxE2Sx                                           0xEE //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNxE2SR                                           0xEF //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=FALSE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNMx1xx                                           0xF0 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNMx1xR                                           0xF1 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNMx1Sx                                           0xF2 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNMx1SR                                           0xF3 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNMx2xx                                           0xF4 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNMx2xR                                           0xF5 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNMx2Sx                                           0xF6 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNMx2SR                                           0xF7 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=FALSE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define DBNME1xx                                           0xF8 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=FALSE
#define DBNME1xR                                           0xF9 //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=FALSE RankLoop=TRUE
#define DBNME1Sx                                           0xFA //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=FALSE
#define DBNME1SR                                           0xFB //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=8b StrobeLoop=TRUE RankLoop=TRUE
#define DBNME2xx                                           0xFC //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=FALSE
#define DBNME2xR                                           0xFD //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=FALSE RankLoop=TRUE
#define DBNME2Sx                                           0xFE //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=FALSE
#define DBNME2SR                                           0xFF //  Done=TRUE UseBB2=TRUE NeedSecondByte=TRUE MaskPresent=TRUE ConditionalExecution=TRUE Offset=16b StrobeLoop=TRUE RankLoop=TRUE
#define xxxxxxxx                                           0x00 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=FALSE StringPresent=FALSE
#define xxxxxxxS                                           0x01 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=FALSE StringPresent=TRUE
#define xxxxxxIx                                           0x02 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=TRUE StringPresent=FALSE
#define xxxxxxIS                                           0x03 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=FALSE InstanceDependent=TRUE StringPresent=TRUE
#define xxxxxCxx                                           0x04 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=FALSE StringPresent=FALSE
#define xxxxxCxS                                           0x05 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=FALSE StringPresent=TRUE
#define xxxxxCIx                                           0x06 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=TRUE StringPresent=FALSE
#define xxxxxCIS                                           0x07 //  Reserved=xx Reserved=xx Reserved=xx Reserved=xx Reserved=xx ChannelDependent=TRUE InstanceDependent=TRUE StringPresent=TRUE
//
// Max number of DLLs supported (analog plus digital).
//
#define MAX_DLL_COUNT                                      1
//
// Number of DLLs supported (analog plus digital) for BLUEPRINT_LPDDR34
//
#define DLL_COUNT_BLUEPRINT_LPDDR34                        1
//
// Number of DLLs supported (analog plus digital) for BLUEPRINT_DDR3
//
#define DLL_COUNT_BLUEPRINT_DDR3                           1
//
// Max number of registers needed to be cached for the GetSet functions.
//
#define MAX_NUM_CACHE_ELEMENTS                             50
#define MAX_NUM_CACHE_ELEMENTS_PB                          3
#define MAX_NUM_CACHE_ELEMENTS_NON_SR                      23
#define MAX_NUM_CACHE_ELEMENTS_NON_SR_PB                   1
//
// Number of registers needed to be cached for BLUEPRINT_LPDDR34
//
#define NUM_CACHE_ELEMENTS_BLUEPRINT_LPDDR34               40
//
// Number of registers needed to be cached for BLUEPRINT_DDR3
//
#define NUM_CACHE_ELEMENTS_BLUEPRINT_DDR3                  50
//
// Max number of delay types (i.e. receive enable, TX DQS, etc).
//
#define MAX_NUM_ALGOS                                      20
//
// Max number of delay types for BLUEPRINT_LPDDR34
//
#define NUM_ALGOS_BLUEPRINT_LPDDR34                        13
//
// Max number of delay types for BLUEPRINT_DDR3
//
#define NUM_ALGOS_BLUEPRINT_DDR3                           20
//
// Max number of delay elements per delay type.
//
#define MAX_NUM_DELAY_ELEMENTS                             3
//
// Number of delay elements per delay type for BLUEPRINT_LPDDR34
//
#define NUM_DELAY_ELEMENTS_BLUEPRINT_LPDDR34               3
//
// Number of delay elements per delay type for BLUEPRINT_DDR3
//
#define NUM_DELAY_ELEMENTS_BLUEPRINT_DDR3                  3
//
// Max number of clock crossing (deadband) elements per delay type.
//
#define MAX_NUM_CC_ELEMENTS                                3
//
// Max number of clock crossing (deadband) ranges.
//
#define MAX_NUM_CC_RANGES                                  12
//
// Number of clock crossing (deadband) elements per delay type for BLUEPRINT_LPDDR34
//
#define NUM_CC_ELEMENTS_BLUEPRINT_LPDDR34                  3
//
// Number of clock crossing (deadband) ranges for BLUEPRINT_LPDDR34
//
#define NUM_CC_RANGES_BLUEPRINT_LPDDR34                    12
//
// Number of clock crossing (deadband) elements per delay type for BLUEPRINT_DDR3
//
#define NUM_CC_ELEMENTS_BLUEPRINT_DDR3                     3
//
// Number of clock crossing (deadband) ranges for BLUEPRINT_DDR3
//
#define NUM_CC_RANGES_BLUEPRINT_DDR3                       12
//
// Max number of elements (delay and CC) per delay type.
//
#define MAX_NUM_ELEMENTS_PER_ALGO                          6
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_LPDDR34
//
#define NUM_ELEMENTS_PER_ALGO_BLUEPRINT_LPDDR34            6
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_DDR3
//
#define NUM_ELEMENTS_PER_ALGO_BLUEPRINT_DDR3               6
//
// Max number of elements in the Signal Info Array
//
#define MAX_SIGNAL_INFO_ELEMENTS                           102
//
// Number of elements in the Signal Info Array for BLUEPRINT_LPDDR34
//
#define SIGNAL_INFO_ELEMENTS_BLUEPRINT_LPDDR34             68
//
// Number of elements in the Signal Info Array for BLUEPRINT_DDR3
//
#define SIGNAL_INFO_ELEMENTS_BLUEPRINT_DDR3                102
//
// Max number of frequencies supported by DVFS (dynamic voltage and frequency scaling).
//
#define MAX_NUM_DVFS                                       1
//
// Number of frequencies supported by DVFS (dynamic voltage and frequency scaling) for BLUEPRINT_LPDDR34
//
#define NUM_DVFS_BLUEPRINT_LPDDR34                         1
//
// Number of frequencies supported by DVFS (dynamic voltage and frequency scaling) for BLUEPRINT_DDR3
//
#define NUM_DVFS_BLUEPRINT_DDR3                            1
//
// Indices of each delay type.
//
#define ClkCh0                                             0x3000
#define ClkCh1                                             0x3001
#define CmdCh0                                             0x3002
#define CmdCh1                                             0x3003
#define CtlCh0                                             0x3004
#define CtlCh1                                             0x3005
#define RxDqsNDelay_dq                                     0x3006
#define RxDqsPDelay_dq                                     0x3007
#define TxDqDelay_Actual                                   0x3008
#define TxDqDrive                                          0x3009
#define TxDqsDelay_dq                                      0x300A
#define RecEnDelay_dq                                      0x300B
#define RecEnPiCode_dq                                     0x300C
#define RxDqsNDelay_Ecc                                    0x300D
#define RxDqsPDelay_Ecc                                    0x300E
#define TxDqDelay_Actual_Ecc                               0x300F
#define TxDqDrive_Ecc                                      0x3010
#define TxDqsDelay_Ecc                                     0x3011
#define RecEnDelay_Ecc                                     0x3012
#define RecEnPiCode_Ecc                                    0x3013
//
// Indices of each delay type for BLUEPRINT_LPDDR34
//
#define ClkCh0_BLUEPRINT_LPDDR34                           0x1000
#define ClkCh1_BLUEPRINT_LPDDR34                           0x1001
#define CmdCh0_BLUEPRINT_LPDDR34                           0x1002
#define CmdCh1_BLUEPRINT_LPDDR34                           0x1003
#define CtlCh0_BLUEPRINT_LPDDR34                           0x1004
#define CtlCh1_BLUEPRINT_LPDDR34                           0x1005
#define RxDqsNDelay_dq_BLUEPRINT_LPDDR34                   0x1006
#define RxDqsPDelay_dq_BLUEPRINT_LPDDR34                   0x1007
#define TxDqDelay_Actual_BLUEPRINT_LPDDR34                 0x1008
#define TxDqDrive_BLUEPRINT_LPDDR34                        0x1009
#define TxDqsDelay_dq_BLUEPRINT_LPDDR34                    0x100A
#define RecEnDelay_dq_BLUEPRINT_LPDDR34                    0x100B
#define RecEnPiCode_dq_BLUEPRINT_LPDDR34                   0x100C
//
// Indices of each delay type for BLUEPRINT_DDR3
//
#define ClkCh0_BLUEPRINT_DDR3                              0x1000
#define ClkCh1_BLUEPRINT_DDR3                              0x1001
#define CmdCh0_BLUEPRINT_DDR3                              0x1002
#define CmdCh1_BLUEPRINT_DDR3                              0x1003
#define CtlCh0_BLUEPRINT_DDR3                              0x1004
#define CtlCh1_BLUEPRINT_DDR3                              0x1005
#define RxDqsNDelay_dq_BLUEPRINT_DDR3                      0x1006
#define RxDqsNDelay_Ecc_BLUEPRINT_DDR3                     0x1007
#define RxDqsPDelay_dq_BLUEPRINT_DDR3                      0x1008
#define RxDqsPDelay_Ecc_BLUEPRINT_DDR3                     0x1009
#define TxDqDelay_Actual_BLUEPRINT_DDR3                    0x100A
#define TxDqDelay_Actual_Ecc_BLUEPRINT_DDR3                0x100B
#define TxDqDrive_BLUEPRINT_DDR3                           0x100C
#define TxDqDrive_Ecc_BLUEPRINT_DDR3                       0x100D
#define TxDqsDelay_dq_BLUEPRINT_DDR3                       0x100E
#define TxDqsDelay_Ecc_BLUEPRINT_DDR3                      0x100F
#define RecEnDelay_dq_BLUEPRINT_DDR3                       0x1010
#define RecEnDelay_Ecc_BLUEPRINT_DDR3                      0x1011
#define RecEnPiCode_dq_BLUEPRINT_DDR3                      0x1012
#define RecEnPiCode_Ecc_BLUEPRINT_DDR3                     0x1013
//
// These are signal groups. Subtract 0x4000 from each to get the right index for each group.
//
#define R                                                  0x4000
//
// Max number of group signals
//
#define MAX_NUM_GROUP                                      1
//
// These are signal groups. Subtract 0x1000 from each to get the first delay type in each group for BLUEPRINT_LPDDR34
//
#define R_BLUEPRINT_LPDDR34                                0x200B
//
// These are signal groups. Subtract 0x1000 from each to get the first delay type in each group for BLUEPRINT_DDR3
//
#define R_BLUEPRINT_DDR3                                   0x2010
//
// Index for unique get/set calls which aren't tied to a particular delay/cc type.
//
#define CaVref_Actual                                      0x5000
#define CkeAll                                             0x5001
#define CkeCh0                                             0x5002
#define CkeCh1                                             0x5003
#define MmrcCkGrp0                                         0x5004
#define MmrcCmdAll                                         0x5005
#define MmrcCmdGrp0                                        0x5006
#define MmrcCtlAll                                         0x5007
#define MmrcCtlGrp0                                        0x5008
#define CURRENT_INDEX                                      0x5009
#define DQS_CNT_RESET                                      0x500A
#define FifoReset                                          0x500B
#define INITIAL_INDEX                                      0x500C
#define MuxcodeMax                                         0x500D
#define MuxcodeMin                                         0x500E
#define OdtEnOff                                           0x500F
#define OdtSegEnOff                                        0x5010
#define R2RRcvnEn                                          0x5011
#define R2RRxDqsEn                                         0x5012
#define R2RTxDqEn                                          0x5013
#define R2RTxDqsEn                                         0x5014
#define RDCMD2RDVLD_PLUS1SEL                               0x5015
#define RDCMD2RDVLD_REG                                    0x5016
#define RdRk2RkLatency                                     0x5017
#define MmrcRecEnDelay                                     0x5018
#define RecEnSmp                                           0x5019
#define RecEnSmp_dq                                        0x501A
#define MmrcRxDqBitDelay                                   0x501B
#define MmrcRxDqsDelay                                     0x501C
#define MmrcRxDqsNDelay                                    0x501D
#define MmrcRxDqsPDelay                                    0x501E
#define RxVocEnDq                                          0x501F
#define RxVocEnDqs                                         0x5020
#define RxVocSmp                                           0x5021
#define RxVocValAll                                        0x5022
#define MmrcRxVref                                         0x5023
#define RxVref_dq                                          0x5024
#define TrrdrGetSet                                        0x5025
#define TwwdrGetSet                                        0x5026
#define MmrcTxCaVref                                       0x5027
#define MmrcTxDqBitDelay                                   0x5028
#define MmrcTxDqDelay                                      0x5029
#define MmrcTxDqsDelay                                     0x502A
#define MmrcTxVref                                         0x502B
#define TxVref_Actual                                      0x502C
#define WrLvlSmp                                           0x502D
#define WrLvlSmp_dq                                        0x502E
#define WrPtrEn                                            0x502F
#define RxVocVal0                                          0x5030
#define RxVocVal1                                          0x5031
#define RxVocVal2                                          0x5032
#define RxVocVal3                                          0x5033
#define RxVocVal4                                          0x5034
#define RxVocVal5                                          0x5035
#define RxVocVal6                                          0x5036
#define RxVocVal7                                          0x5037
#define DQS_CNT_RESET_Ecc                                  0x5038
#define FifoReset_Ecc                                      0x5039
#define MuxcodeMax_Ecc                                     0x503A
#define MuxcodeMin_Ecc                                     0x503B
#define OdtEnOff_Ecc                                       0x503C
#define OdtSegEnOff_Ecc                                    0x503D
#define R2RRcvnEn_Ecc                                      0x503E
#define R2RRxDqsEn_Ecc                                     0x503F
#define R2RTxDqEn_Ecc                                      0x5040
#define R2RTxDqsEn_Ecc                                     0x5041
#define RdRk2RkLatency_Ecc                                 0x5042
#define RecEnSmp_Ecc                                       0x5043
#define RxVocEnDq_Ecc                                      0x5044
#define RxVocEnDqs_Ecc                                     0x5045
#define RxVocSmp_Ecc                                       0x5046
#define RxVref_Ecc                                         0x5047
#define TimingMode                                         0x5048
#define WrLvlSmp_Ecc                                       0x5049
#define WrPtrEn_Ecc                                        0x504A
#define RxVocVal0_Ecc                                      0x504B
#define RxVocVal1_Ecc                                      0x504C
#define RxVocVal2_Ecc                                      0x504D
#define RxVocVal3_Ecc                                      0x504E
#define RxVocVal4_Ecc                                      0x504F
#define RxVocVal5_Ecc                                      0x5050
#define RxVocVal6_Ecc                                      0x5051
#define RxVocVal7_Ecc                                      0x5052
//
// Max number of unique signals
//
#define MAX_NUM_UNIQUE                                     82
//
// Index for unique get/set calls which aren't tied to a particular delay/cc type for BLUEPRINT_LPDDR34
//
#define CaVref_Actual_BLUEPRINT_LPDDR34                    78
#define CkeAll_BLUEPRINT_LPDDR34                           79
#define CkeCh0_BLUEPRINT_LPDDR34                           80
#define CkeCh1_BLUEPRINT_LPDDR34                           81
#define CkGrp0_BLUEPRINT_LPDDR34                           82
#define CmdAll_BLUEPRINT_LPDDR34                           83
#define CmdGrp0_BLUEPRINT_LPDDR34                          84
#define CtlAll_BLUEPRINT_LPDDR34                           85
#define CtlGrp0_BLUEPRINT_LPDDR34                          86
#define CURRENT_INDEX_BLUEPRINT_LPDDR34                    87
#define DQS_CNT_RESET_BLUEPRINT_LPDDR34                    88
#define FifoReset_BLUEPRINT_LPDDR34                        89
#define INITIAL_INDEX_BLUEPRINT_LPDDR34                    90
#define MuxcodeMax_BLUEPRINT_LPDDR34                       91
#define MuxcodeMin_BLUEPRINT_LPDDR34                       92
#define OdtEnOff_BLUEPRINT_LPDDR34                         93
#define OdtSegEnOff_BLUEPRINT_LPDDR34                      94
#define R2RRcvnEn_BLUEPRINT_LPDDR34                        95
#define R2RRxDqsEn_BLUEPRINT_LPDDR34                       96
#define R2RTxDqEn_BLUEPRINT_LPDDR34                        97
#define R2RTxDqsEn_BLUEPRINT_LPDDR34                       98
#define RDCMD2RDVLD_PLUS1SEL_BLUEPRINT_LPDDR34             99
#define RDCMD2RDVLD_REG_BLUEPRINT_LPDDR34                  100
#define RdRk2RkLatency_BLUEPRINT_LPDDR34                   101
#define RecEnDelay_BLUEPRINT_LPDDR34                       102
#define RecEnSmp_BLUEPRINT_LPDDR34                         103
#define RecEnSmp_dq_BLUEPRINT_LPDDR34                      104
#define RxDqBitDelay_BLUEPRINT_LPDDR34                     105
#define RxDqsDelay_BLUEPRINT_LPDDR34                       106
#define RxDqsNDelay_BLUEPRINT_LPDDR34                      107
#define RxDqsPDelay_BLUEPRINT_LPDDR34                      108
#define RxVocEnDq_BLUEPRINT_LPDDR34                        109
#define RxVocEnDqs_BLUEPRINT_LPDDR34                       110
#define RxVocSmp_BLUEPRINT_LPDDR34                         111
#define RxVocValAll_BLUEPRINT_LPDDR34                      112
#define RxVref_BLUEPRINT_LPDDR34                           113
#define RxVref_dq_BLUEPRINT_LPDDR34                        114
#define TrrdrGetSet_BLUEPRINT_LPDDR34                      115
#define TxCaVref_BLUEPRINT_LPDDR34                         116
#define TxDqBitDelay_BLUEPRINT_LPDDR34                     117
#define TxDqDelay_BLUEPRINT_LPDDR34                        118
#define TxDqsDelay_BLUEPRINT_LPDDR34                       119
#define TxVref_BLUEPRINT_LPDDR34                           120
#define TxVref_Actual_BLUEPRINT_LPDDR34                    121
#define WrLvlSmp_BLUEPRINT_LPDDR34                         122
#define WrLvlSmp_dq_BLUEPRINT_LPDDR34                      123
#define WrPtrEn_BLUEPRINT_LPDDR34                          124
#define RxVocVal0_BLUEPRINT_LPDDR34                        125
#define RxVocVal1_BLUEPRINT_LPDDR34                        126
#define RxVocVal2_BLUEPRINT_LPDDR34                        127
#define RxVocVal3_BLUEPRINT_LPDDR34                        128
#define RxVocVal4_BLUEPRINT_LPDDR34                        129
#define RxVocVal5_BLUEPRINT_LPDDR34                        130
#define RxVocVal6_BLUEPRINT_LPDDR34                        131
#define RxVocVal7_BLUEPRINT_LPDDR34                        132
//
// Index for unique get/set calls which aren't tied to a particular delay/cc type for BLUEPRINT_DDR3
//
#define CaVref_Actual_BLUEPRINT_DDR3                       120
#define CkeAll_BLUEPRINT_DDR3                              121
#define CkeCh0_BLUEPRINT_DDR3                              122
#define CkeCh1_BLUEPRINT_DDR3                              123
#define CkGrp0_BLUEPRINT_DDR3                              124
#define CmdAll_BLUEPRINT_DDR3                              125
#define CmdGrp0_BLUEPRINT_DDR3                             126
#define CtlAll_BLUEPRINT_DDR3                              127
#define CtlGrp0_BLUEPRINT_DDR3                             128
#define CURRENT_INDEX_BLUEPRINT_DDR3                       129
#define DQS_CNT_RESET_BLUEPRINT_DDR3                       130
#define DQS_CNT_RESET_Ecc_BLUEPRINT_DDR3                   131
#define FifoReset_BLUEPRINT_DDR3                           132
#define FifoReset_Ecc_BLUEPRINT_DDR3                       133
#define INITIAL_INDEX_BLUEPRINT_DDR3                       134
#define MuxcodeMax_BLUEPRINT_DDR3                          135
#define MuxcodeMax_Ecc_BLUEPRINT_DDR3                      136
#define MuxcodeMin_BLUEPRINT_DDR3                          137
#define MuxcodeMin_Ecc_BLUEPRINT_DDR3                      138
#define OdtEnOff_BLUEPRINT_DDR3                            139
#define OdtEnOff_Ecc_BLUEPRINT_DDR3                        140
#define OdtSegEnOff_BLUEPRINT_DDR3                         141
#define OdtSegEnOff_Ecc_BLUEPRINT_DDR3                     142
#define R2RRcvnEn_BLUEPRINT_DDR3                           143
#define R2RRcvnEn_Ecc_BLUEPRINT_DDR3                       144
#define R2RRxDqsEn_BLUEPRINT_DDR3                          145
#define R2RRxDqsEn_Ecc_BLUEPRINT_DDR3                      146
#define R2RTxDqEn_BLUEPRINT_DDR3                           147
#define R2RTxDqEn_Ecc_BLUEPRINT_DDR3                       148
#define R2RTxDqsEn_BLUEPRINT_DDR3                          149
#define R2RTxDqsEn_Ecc_BLUEPRINT_DDR3                      150
#define RDCMD2RDVLD_PLUS1SEL_BLUEPRINT_DDR3                151
#define RDCMD2RDVLD_REG_BLUEPRINT_DDR3                     152
#define RdRk2RkLatency_BLUEPRINT_DDR3                      153
#define RdRk2RkLatency_Ecc_BLUEPRINT_DDR3                  154
#define RecEnDelay_BLUEPRINT_DDR3                          155
#define RecEnSmp_BLUEPRINT_DDR3                            156
#define RecEnSmp_dq_BLUEPRINT_DDR3                         157
#define RecEnSmp_Ecc_BLUEPRINT_DDR3                        158
#define RxDqBitDelay_BLUEPRINT_DDR3                        159
#define RxDqsDelay_BLUEPRINT_DDR3                          160
#define RxDqsNDelay_BLUEPRINT_DDR3                         161
#define RxDqsPDelay_BLUEPRINT_DDR3                         162
#define RxVocEnDq_BLUEPRINT_DDR3                           163
#define RxVocEnDq_Ecc_BLUEPRINT_DDR3                       164
#define RxVocEnDqs_BLUEPRINT_DDR3                          165
#define RxVocEnDqs_Ecc_BLUEPRINT_DDR3                      166
#define RxVocSmp_BLUEPRINT_DDR3                            167
#define RxVocSmp_Ecc_BLUEPRINT_DDR3                        168
#define RxVocValAll_BLUEPRINT_DDR3                         169
#define RxVref_BLUEPRINT_DDR3                              170
#define RxVref_dq_BLUEPRINT_DDR3                           171
#define RxVref_Ecc_BLUEPRINT_DDR3                          172
#define TimingMode_BLUEPRINT_DDR3                          173
#define TrrdrGetSet_BLUEPRINT_DDR3                         174
#define TxCaVref_BLUEPRINT_DDR3                            175
#define TxDqBitDelay_BLUEPRINT_DDR3                        176
#define TxDqDelay_BLUEPRINT_DDR3                           177
#define TxDqsDelay_BLUEPRINT_DDR3                          178
#define TxVref_BLUEPRINT_DDR3                              179
#define TxVref_Actual_BLUEPRINT_DDR3                       180
#define WrLvlSmp_BLUEPRINT_DDR3                            181
#define WrLvlSmp_dq_BLUEPRINT_DDR3                         182
#define WrLvlSmp_Ecc_BLUEPRINT_DDR3                        183
#define WrPtrEn_BLUEPRINT_DDR3                             184
#define WrPtrEn_Ecc_BLUEPRINT_DDR3                         185
#define RxVocVal0_BLUEPRINT_DDR3                           186
#define RxVocVal0_Ecc_BLUEPRINT_DDR3                       187
#define RxVocVal1_BLUEPRINT_DDR3                           188
#define RxVocVal1_Ecc_BLUEPRINT_DDR3                       189
#define RxVocVal2_BLUEPRINT_DDR3                           190
#define RxVocVal2_Ecc_BLUEPRINT_DDR3                       191
#define RxVocVal3_BLUEPRINT_DDR3                           192
#define RxVocVal3_Ecc_BLUEPRINT_DDR3                       193
#define RxVocVal4_BLUEPRINT_DDR3                           194
#define RxVocVal4_Ecc_BLUEPRINT_DDR3                       195
#define RxVocVal5_BLUEPRINT_DDR3                           196
#define RxVocVal5_Ecc_BLUEPRINT_DDR3                       197
#define RxVocVal6_BLUEPRINT_DDR3                           198
#define RxVocVal6_Ecc_BLUEPRINT_DDR3                       199
#define RxVocVal7_BLUEPRINT_DDR3                           200
#define RxVocVal7_Ecc_BLUEPRINT_DDR3                       201
//
// External functions that need to be called for GetSet elements which require and external function to read/write the element.
//
#define CkeAll_FUNC                                        0
#define CkGrp0_FUNC                                        1
#define CmdAll_FUNC                                        2
#define CmdGrp0_FUNC                                       3
#define CtlAll_FUNC                                        4
#define CtlGrp0_FUNC                                       5
#define RecEnDelay_FUNC                                    6
#define RecEnSmp_FUNC                                      7
#define RxDqsDelay_FUNC                                    8
#define RxDqsNDelay_FUNC                                   9
#define RxDqsPDelay_FUNC                                   10
#define RxVocValAll_FUNC                                   11
#define RxVref_FUNC                                        12
#define TxCaVref_FUNC                                      13
#define TxDqBitDelay_FUNC                                  14
#define TxDqDelay_FUNC                                     15
#define TxDqsDelay_FUNC                                    16
#define TxVref_FUNC                                        17
#define WrLvlSmp_FUNC                                      18
#define TimingMode_FUNC                                    19
//
// External functions for BLUEPRINT_LPDDR34
//
#define CkeAll_FUNC_BLUEPRINT_LPDDR34                      0
#define CkGrp0_FUNC_BLUEPRINT_LPDDR34                      1
#define CmdAll_FUNC_BLUEPRINT_LPDDR34                      2
#define CmdGrp0_FUNC_BLUEPRINT_LPDDR34                     3
#define CtlAll_FUNC_BLUEPRINT_LPDDR34                      4
#define CtlGrp0_FUNC_BLUEPRINT_LPDDR34                     5
#define RecEnDelay_FUNC_BLUEPRINT_LPDDR34                  6
#define RecEnSmp_FUNC_BLUEPRINT_LPDDR34                    7
#define RxDqsDelay_FUNC_BLUEPRINT_LPDDR34                  8
#define RxDqsNDelay_FUNC_BLUEPRINT_LPDDR34                 9
#define RxDqsPDelay_FUNC_BLUEPRINT_LPDDR34                 10
#define RxVocValAll_FUNC_BLUEPRINT_LPDDR34                 11
#define RxVref_FUNC_BLUEPRINT_LPDDR34                      12
#define TxCaVref_FUNC_BLUEPRINT_LPDDR34                    13
#define TxDqBitDelay_FUNC_BLUEPRINT_LPDDR34                14
#define TxDqDelay_FUNC_BLUEPRINT_LPDDR34                   15
#define TxDqsDelay_FUNC_BLUEPRINT_LPDDR34                  16
#define TxVref_FUNC_BLUEPRINT_LPDDR34                      17
#define WrLvlSmp_FUNC_BLUEPRINT_LPDDR34                    18
//
// External functions for BLUEPRINT_DDR3
//
#define CkeAll_FUNC_BLUEPRINT_DDR3                         0
#define CkGrp0_FUNC_BLUEPRINT_DDR3                         1
#define CmdAll_FUNC_BLUEPRINT_DDR3                         2
#define CmdGrp0_FUNC_BLUEPRINT_DDR3                        3
#define CtlAll_FUNC_BLUEPRINT_DDR3                         4
#define CtlGrp0_FUNC_BLUEPRINT_DDR3                        5
#define RecEnDelay_FUNC_BLUEPRINT_DDR3                     6
#define RecEnSmp_FUNC_BLUEPRINT_DDR3                       7
#define RxDqsDelay_FUNC_BLUEPRINT_DDR3                     8
#define RxDqsNDelay_FUNC_BLUEPRINT_DDR3                    9
#define RxDqsPDelay_FUNC_BLUEPRINT_DDR3                    10
#define RxVocValAll_FUNC_BLUEPRINT_DDR3                    11
#define RxVref_FUNC_BLUEPRINT_DDR3                         12
#define TimingMode_FUNC_BLUEPRINT_DDR3                     13
#define TxCaVref_FUNC_BLUEPRINT_DDR3                       14
#define TxDqBitDelay_FUNC_BLUEPRINT_DDR3                   15
#define TxDqDelay_FUNC_BLUEPRINT_DDR3                      16
#define TxDqsDelay_FUNC_BLUEPRINT_DDR3                     17
#define TxVref_FUNC_BLUEPRINT_DDR3                         18
#define WrLvlSmp_FUNC_BLUEPRINT_DDR3                       19
//
// Max number of elements (delay and CC) per delay type.
//
#define MAX_NUM_ELEMENTS                                   202
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_LPDDR34
//
#define NUM_ELEMENTS_BLUEPRINT_LPDDR34                     133
//
// Number of elements (delay and CC) per delay type for BLUEPRINT_DDR3
//
#define NUM_ELEMENTS_BLUEPRINT_DDR3                        202
//
// Total different PFCT variations supported by this project.
//
#define NUM_PLAT                                           6
#define NUM_FREQ                                           10
#define NUM_CONF                                           2
#define NUM_TYPE                                           5
//
// Macros for converting PFCT combinations from the generated tool output into correct bitmasks for the Init sequence.
//
#define P(p)                                               CONV1(p)
#define F(f)                                               CONV2(f)
#define C(c)                                               CONV1(c)
#define T(t)                                               CONV1(t)
#define PF(p,f)                                            CONV2((((p) << NUM_FREQ) + (f)))
#define PT(p,t)                                            CONV2((((p) << NUM_TYPE) + (t)))
#define PC(p,c)                                            CONV1((((p) << NUM_CONF) + (c)))
#define FT(f,t)                                            CONV2((((f) << NUM_TYPE) + (t)))
#define FC(f,c)                                            CONV2((((f) << NUM_CONF) + (c)))
#define CT(c,t)                                            CONV1((((c) << NUM_TYPE) + (t)))
#define PFT(p,f,t)                                         CONV3((((p) << (NUM_FREQ + NUM_TYPE)) + ((f) << NUM_TYPE) + (t)))
#define PFC(p,f,c)                                         CONV3((((p) << (NUM_FREQ + NUM_CONF)) + ((f) << NUM_CONF) + (c)))
#define PCT(p,c,t)                                         CONV2((((p) << (NUM_CONF + NUM_TYPE)) + ((c) << NUM_TYPE) + (t)))
#define FCT(f,c,t)                                         CONV3((((f) << (NUM_CONF + NUM_TYPE)) + ((c) << NUM_TYPE) + (t)))
#define PFCT(p,f,c,t)                                      CONV3((((p) << (NUM_FREQ + NUM_CONF + NUM_TYPE)) + ((f) << (NUM_CONF + NUM_TYPE)) + ((c) << NUM_TYPE) + (t)))
//
// Supported Platforms
//
#define P_NONE                                             0
#define P_SIM                                              BIT0
#define P_EMU                                              BIT1
#define P_SIL_MD                                           BIT2
#define P_SIL_UD                                           BIT3
#define P_SIL_SD                                           BIT4
#define P_SIL                                              BIT5
#define P_ALL                                              0xFFFF
//
// Supported Frequencies
//
#define F_NONE                                             0
#define F_800                                              BIT0
#define F_1066                                             BIT1
#define F_1333                                             BIT2
#define F_1600                                             BIT3
#define F_1866                                             BIT4
#define F_2133                                             BIT5
#define F_2400                                             BIT6
#define F_2666                                             BIT7
#define F_3200                                             BIT8
#define F_2933                                             BIT9
#define F_ALL                                              0xFFFF
//
// Supported Configurations
//
#define C_NONE                                             0
#define C_PO                                               BIT0
#define C_POR                                              BIT1
#define C_ALL                                              0xFFFF
//
// Supported Types
//
#define T_NONE                                             0
#define T_LPDDR3                                           BIT0
#define T_LPDDR4                                           BIT1
#define T_DDR3                                             BIT2
#define T_WIO2                                             BIT3
#define T_DDR4                                             BIT4
#define T_ALL                                              0xFFFF
//
// Supported Boot Paths
//
#define S0                                                 BIT0
#define S0W                                                BIT1
#define S0C                                                BIT2
#define S5                                                 BIT3
#define FB                                                 BIT4
#define S3                                                 BIT5
#define EM                                                 BIT6
#define CSE                                                BIT7
#define RS                                                 BIT8
#define A0                                                 BIT9
#define ALL_PATHS                                          0xFF
//
// Max number of subtasks
//
#define MAX_SUBTASKS                                       2

//
// All possible actions for the init phase of MMRC.
//
#define SET                                                0
#define DELAY                                              1
#define SET_DELAY                                          2
#define FORCE_SET                                          3
#define POLL                                               4
#define GET                                                5
#define SUBTASK                                            6
#define ACTION_ERROR                                       7
//
// Offsets into InitData[] for each init block. Total size = 16178 bytes.
//
#define InitPunit                                          0
#define PollPunit                                          (InitPunit + 21)
#define sai_init_seq                                       (PollPunit + 15)
#define modmem_init_lpddrgrp1xm_seq                        (sai_init_seq + 55)
#define modmem_init_lpddrgrp1p5_seq                        (modmem_init_lpddrgrp1xm_seq + 258)
#define modmem_init_lpddrgrp2m_seq                         (modmem_init_lpddrgrp1p5_seq + 395)
#define modmem_init_lpddrgrp3m_seq                         (modmem_init_lpddrgrp2m_seq + 511)
#define modmem_init_lpddrgrp3_seq                          (modmem_init_lpddrgrp3m_seq + 906)
#define modmem_init_lpddrgrp3p75_seq                       (modmem_init_lpddrgrp3_seq + 3576)
#define modmem_init_lpddrgrp4m_seq                         (modmem_init_lpddrgrp3p75_seq + 7)
#define modmem_bxtp_ldo_offsetcomp_seq                     (modmem_init_lpddrgrp4m_seq + 51)
#define modmem_init_lpddrgrp2p5_seq                        (modmem_bxtp_ldo_offsetcomp_seq + 9)
#define modmem_bxtp_ldo_offsetcomp_poll_seq                (modmem_init_lpddrgrp2p5_seq + 106)
#define modmem_init_lpddrgrp4_seq                          (modmem_bxtp_ldo_offsetcomp_poll_seq + 15)
#define modmem_init_lpddrgrp4p5_seq                        (modmem_init_lpddrgrp4_seq + 189)
#define modmem_init_lpddrgrp5m_seq                         (modmem_init_lpddrgrp4p5_seq + 99)
#define modmem_init_lpddrgrp5_seq                          (modmem_init_lpddrgrp5m_seq + 440)
#define modmem_init_lpddrgrp5p25_seq                       (modmem_init_lpddrgrp5_seq + 117)
#define modmem_init_lpddrgrp5p5m_seq                       (modmem_init_lpddrgrp5p25_seq + 42)
#define PhyConfigComplete                                  (modmem_init_lpddrgrp5p5m_seq + 625)
#define DunitResetComplete                                 (PhyConfigComplete + 8)
#define wake_dunit                                         (DunitResetComplete + 8)
#define modmem_init_lpddrgrp5p5_seq                        (wake_dunit + 19)
#define modmem_init_lpddrgrp6_seq                          (modmem_init_lpddrgrp5p5_seq + 29)
#define modmem_init_lpddrgrp6p5_seq                        (modmem_init_lpddrgrp6_seq + 49)
#define modmem_init_lpddrgrp7_seq                          (modmem_init_lpddrgrp6p5_seq + 21)
#define modmem_init_lpddrgrp7p5_seq                        (modmem_init_lpddrgrp7_seq + 52)
#define modmem_init_lpddrgrp7p75_seq                       (modmem_init_lpddrgrp7p5_seq + 21)
#define modmem_init_lpddrgrp7p75_lp4seq                    (modmem_init_lpddrgrp7p75_seq + 197)
#define modmem_init_lpddrgrp8m_seq                         (modmem_init_lpddrgrp7p75_lp4seq + 20)
#define modmem_init_lpddrgrp0_seq                          (modmem_init_lpddrgrp8m_seq + 63)
#define modmem_init_lpddrgrp10m_seq                        (modmem_init_lpddrgrp0_seq + 9)
#define InitDunit                                          (modmem_init_lpddrgrp10m_seq + 20)
#define InitDunitWake                                      (InitDunit + 219)
#define PrepareForTraining                                 (InitDunitWake + 21)
#define CPGC_ONE_TIME_INIT                                 (PrepareForTraining + 55)
#define modmem_init_dramreset_seq_sim                      (CPGC_ONE_TIME_INIT + 534)
#define modmem_init_dramreset_seq                          (modmem_init_dramreset_seq_sim + 101)
#define ProgramSelfRefresh                                 (modmem_init_dramreset_seq + 101)
#define ProgramFinalSettings                               (ProgramSelfRefresh + 15)
#define TrainingDone                                       (ProgramFinalSettings + 483)
#define modmem_init_lpddrgrp11m_seq                        (TrainingDone + 31)
#define modmem_init_lpddrgrp12m_seq                        (modmem_init_lpddrgrp11m_seq + 351)
#define CPGCModeComplete                                   (modmem_init_lpddrgrp12m_seq + 50)
#define SetMrcDone                                         (CPGCModeComplete + 8)
#define InitDunitWakeS0set                                 (SetMrcDone + 15)
#define InitDunitWakeS0poll                                (InitDunitWakeS0set + 8)
#define modmem_init_lpddrgrp10_seq                         (InitDunitWakeS0poll + 8)
#define modmem_lp4_freq_switch_seq1                        (modmem_init_lpddrgrp10_seq + 15)
#define modmem_lp4_freq_switch_seq2                        (modmem_lp4_freq_switch_seq1 + 94)
#define modmem_lp4_freq_switch_seq2a                       (modmem_lp4_freq_switch_seq2 + 96)
#define modmem_lp4_freq_switch_seq3                        (modmem_lp4_freq_switch_seq2a + 109)
#define modmem_init_dramreset_seq_lp4_a                    (modmem_lp4_freq_switch_seq3 + 50)
#define modmem_init_dramreset_seq_lp4_b                    (modmem_init_dramreset_seq_lp4_a + 21)
#define modmem_init_dramreset_seq_lp4_c                    (modmem_init_dramreset_seq_lp4_b + 9)
#define modmem_init_dramreset_seq_lp4_d                    (modmem_init_dramreset_seq_lp4_c + 9)
#define maxpi_dll_init                                     (modmem_init_dramreset_seq_lp4_d + 9)
#define maxpi_override_coarse_init                         (maxpi_dll_init + 39)
#define maxpi_set_codes                                    (maxpi_override_coarse_init + 101)
#define maxpi_get_codes                                    (maxpi_set_codes + 71)
#define maxpi_override_coarse_final                        (maxpi_get_codes + 61)
#define WEAK_ODT_SET                                       (maxpi_override_coarse_final + 169)
#define ECC_PHY_INIT                                       (WEAK_ODT_SET + 14)
#define modmem_init_progcmdckctl_seq                       (ECC_PHY_INIT + 15)
#define DunitFreqChangePart1                               (modmem_init_progcmdckctl_seq + 385)
#define ChangePHYFreq                                      (DunitFreqChangePart1 + 52)
#define DunitFreqChangePart3                               (ChangePHYFreq + 1)
#define SetICBitDone                                       (DunitFreqChangePart3 + 56)
#define ProgramECCEnable                                   (SetICBitDone + 7)
#define ReadFuses                                          (ProgramECCEnable + 7)
#define EnableScrambling                                   (ReadFuses + 7)
#define SetMrcDoneRemove                                   (EnableScrambling + 7)
#define ReadBarAddress                                     (SetMrcDoneRemove + 7)
#define WriteMchBarAddress                                 (ReadBarAddress + 37)
#define WriteBarAddress                                    (WriteMchBarAddress + 7)
#define SetSliceChannel                                    (WriteBarAddress + 21)
#define LockAunitSliceChannel                              (SetSliceChannel + 104)
#define DisableDynamicSr                                   (LockAunitSliceChannel + 9)
#define ReadPunit                                          (DisableDynamicSr + 37)
#define SetPunitMemDone                                    (ReadPunit + 16)
#define RESETDRAMS                                         (SetPunitMemDone + 8)
#define ECCClockGate                                       (RESETDRAMS + 9)
#define HALF_CFG_PWR_GATE                                  (ECCClockGate + 11)
#define SwitchTo2N                                         (HALF_CFG_PWR_GATE + 79)
#define SwitchTo1N                                         (SwitchTo2N + 45)
#define WRLVLMODE                                          (SwitchTo1N + 45)
#define DiffAmpOverride                                    (WRLVLMODE + 13)
#define DiffAmpRestore                                     (DiffAmpOverride + 123)
#define SEND_DRAM_CMD                                      (DiffAmpRestore + 23)
#define CPGC_RUN_KIRK                                      (SEND_DRAM_CMD + 8)
#define xyz                                                (CPGC_RUN_KIRK + 46)
#define FORCEODT_ON                                        (xyz + 7)
#define FORCEODT_OFF                                       (FORCEODT_ON + 1)
#define FORCEODT_REL                                       (FORCEODT_OFF + 1)
#define READTRAINING_EXIT                                  (FORCEODT_REL + 1)
#define CPGC_DISABLE                                       (READTRAINING_EXIT + 1)
#define SetAunitSliceChannel                               (CPGC_DISABLE + 19)
#define CPGC_RUN_TEST_L                                    (SetAunitSliceChannel + 1)
#define CPGC_SETUP_ERT                                     (CPGC_RUN_TEST_L + 188)
#define CPGC_EXIT_ERT                                      (CPGC_SETUP_ERT + 14)
#define CPGC_RUN_DIRECT                                    (CPGC_EXIT_ERT + 14)
#define CPGC_CHECK_ERRORS                                  (CPGC_RUN_DIRECT + 34)
#define CPGC_SETUP_DPAT0                                   (CPGC_CHECK_ERRORS + 8)
#define CPGC_RUN_TEST                                      (CPGC_SETUP_DPAT0 + 8)
#define CPGC_ENABLE                                        (CPGC_RUN_TEST + 182)
#define CPGC_RESETUP_WRITE_READ                            (CPGC_ENABLE + 32)
#define DQ_DB_REGION_PROGRAM                               (CPGC_RESETUP_WRITE_READ + 44)
#define CPGC_SETUP_VA                                      (DQ_DB_REGION_PROGRAM + 25)
#define CPGC_LOOPS                                         (CPGC_SETUP_VA + 153)
#define DRIVE_CKE                                          (CPGC_LOOPS + 13)
#define CPGC_STOP_TEST                                     (DRIVE_CKE + 7)
#define DQCALRD                                            (CPGC_STOP_TEST + 23)
#define ENABLE_CKE_OVERRIDE                                (DQCALRD + 7)
#define PRECHARGEALL                                       (ENABLE_CKE_OVERRIDE + 7)
#define CPGC_TARGET_BANK                                   (PRECHARGEALL + 22)
#define CPGC_FIXVAR                                        (CPGC_TARGET_BANK + 14)
#define CPGC_FIXVAR_REVERT                                 (CPGC_FIXVAR + 14)
#define CPGC_MRS                                           (CPGC_FIXVAR_REVERT + 27)
#define CPGC_CADB1                                         (CPGC_MRS + 150)
#define CPGC_DESELECT_DIS                                  (CPGC_CADB1 + 293)
#define CPGC_DESELECT_EN                                   (CPGC_DESELECT_DIS + 69)
#define CPGC_CADB1_BUFA                                    (CPGC_DESELECT_EN + 47)
#define CPGC_CADB1_BUFB                                    (CPGC_CADB1_BUFA + 57)
#define CPGC_CWL_PATTERN                                   (CPGC_CADB1_BUFB + 57)
#define CPGC_EXIT_MRS                                      (CPGC_CWL_PATTERN + 15)
#define CPGC_CADB_MODE                                     (CPGC_EXIT_MRS + 15)
#define CPGC_RESETUP_TRAFFIC                               (CPGC_CADB_MODE + 29)
#define CPGC_DPAT_MODE                                     (CPGC_RESETUP_TRAFFIC + 19)
#define CPGC_LDO_CADB                                      (CPGC_DPAT_MODE + 22)
#define CPGC_LDO_DPAT                                      (CPGC_LDO_CADB + 89)
#define CPGC_LDO_CADB_LFSR                                 (CPGC_LDO_DPAT + 97)
#define CPGC_LDO_DPAT_LFSR                                 (CPGC_LDO_CADB_LFSR + 89)
#define EARLY_READ_TRAINING_ENTRY                          (CPGC_LDO_DPAT_LFSR + 97)
#define EARLY_READ_TRAINING_EXIT                           (EARLY_READ_TRAINING_ENTRY + 1)
#define FINEWRITELEVEL_ENTRY                               (EARLY_READ_TRAINING_EXIT + 7)
#define FINEWRITELEVEL_SHAPE                               (FINEWRITELEVEL_ENTRY + 31)
#define FINEWRITELEVEL_EXIT                                (FINEWRITELEVEL_SHAPE + 50)
#define ENTER_CA_TRAINING                                  (FINEWRITELEVEL_EXIT + 31)
#define EXIT_CA_TRAINING                                   (ENTER_CA_TRAINING + 378)
#define ECT_ENTRY                                          (EXIT_CA_TRAINING + 149)
#define RCVEN_ENTRY                                        (ECT_ENTRY + 89)
#define RCVEN_EXIT                                         (RCVEN_ENTRY + 221)
#define VOC_TRAINING_ENTRY                                 (RCVEN_EXIT + 29)
#define VOC_GET_LDO_ENABLE                                 (VOC_TRAINING_ENTRY + 371)
#define VOC_PHY_ENTRY                                      (VOC_GET_LDO_ENABLE + 8)
#define VOC_COMP_VREF_AND_INIT                             (VOC_PHY_ENTRY + 97)
#define VOC_GET_RCOMP_PUP_VALUE                            (VOC_COMP_VREF_AND_INIT + 27)
#define VOC_GET_RCOMP_PDN_VALUE                            (VOC_GET_RCOMP_PUP_VALUE + 7)
#define VOC_SET_ODT_RCOMP_OVERRIDE                         (VOC_GET_RCOMP_PDN_VALUE + 7)
#define VOC_ENABLE_WLMODE                                  (VOC_SET_ODT_RCOMP_OVERRIDE + 29)
#define VOC_DISABLE_WLMODE                                 (VOC_ENABLE_WLMODE + 13)
#define VOC_TRAINING_EXIT                                  (VOC_DISABLE_WLMODE + 13)
#define PERIODIC_TRAINING_START                            (VOC_TRAINING_EXIT + 163)
#define PERIODIC_TRAINING_READ                             (PERIODIC_TRAINING_START + 129)
#define PERIODIC_TRAINING_MNT_DIS                          (PERIODIC_TRAINING_READ + 14)
#define PERIODIC_TRAINING_EN                               (PERIODIC_TRAINING_MNT_DIS + 58)
#define CPGC_GET_TEST_RESULT                               (PERIODIC_TRAINING_EN + 19)
#define CPGC_SET_CHUNK_MASK                                (CPGC_GET_TEST_RESULT + 43)
#define CPGC_STOP_CLEAR_ERR                                (CPGC_SET_CHUNK_MASK + 8)
#define CPGC_START_TEST                                    (CPGC_STOP_CLEAR_ERR + 23)
#define gen_rxpbden_set                                    (CPGC_START_TEST + 12)
#define CPGC_ECC_EN                                        (gen_rxpbden_set + 20)
#define MEM_INIT                                           (CPGC_ECC_EN + 20)
#define MNTEN_SET                                          (MEM_INIT + 26)
#define MNTEN_CLR                                          (MNTEN_SET + 7)
#define READTRAINING_ENTRY                                 (MNTEN_CLR + 7)
//
// All dynamic register names. Each of these will be written to during the Init phase of MMRC.
//
#define DYN_PUNIT_P_CR_MC_BIOS_REQ_0_0_0_MCHBAR            0
#define DYN_CCC_DIGCTL                                     1
#define DYN_CCC_CH1_DIGCTL                                 2
#define DYN_DQ_DIGCTL                                      3
#define DYN_CCC_WRDQSCTL                                   4
#define DYN_CCC_WRDQSCTL_1                                 5
#define DYN_CCC_WRDQSCTL_2                                 6
#define DYN_CCC_WRDQSCTL_3                                 7
#define DYN_CCC_WRDQSCTL_4                                 8
#define DYN_CCC_WRDQSCTL_5                                 9
#define DYN_CCC_WRDQSCTL_6                                 10
#define DYN_CCC_WRDQSCTL_7                                 11
#define DYN_CCC_RDVLDCTL                                   12
#define DYN_CCC_RDVLDCTL_1                                 13
#define DYN_CCC_RDVLDCTL_2                                 14
#define DYN_CCC_RDVLDCTL_3                                 15
#define DYN_CCC_RDVLDCTL_4                                 16
#define DYN_CCC_RDVLDCTL_5                                 17
#define DYN_CCC_RDVLDCTL_6                                 18
#define DYN_CCC_RDVLDCTL_7                                 19
#define DYN_CCC_RK2RKCTL0                                  20
#define DYN_CCC_RK2RKCTL0_1                                21
#define DYN_CCC_RK2RKCTL0_2                                22
#define DYN_CCC_RK2RKCTL0_3                                23
#define DYN_CCC_RK2RKCTL0_4                                24
#define DYN_CCC_RXDLLRDCMDCTL0                             25
#define DYN_CCC_RXDLLRDCMDCTL0_1                           26
#define DYN_CCC_RXDLLRDCMDCTL0_2                           27
#define DYN_CCC_RXDLLRDCMDCTL0_3                           28
#define DYN_CCC_RXDLLRDCMDCTL0_4                           29
#define DYN_CCC_RXDLLRDCMDCTL0_5                           30
#define DYN_CCC_RXDLLRDCMDCTL0_6                           31
#define DYN_DQ_WRDQSCTL_CC                                 32
#define DYN_DQ_WRDQSCTL_CC_1                               33
#define DYN_DQ_WRDQSCTL_CC_2                               34
#define DYN_DQ_WRDQSCTL_CC_3                               35
#define DYN_DQ_WRDQSCTL_CC_4                               36
#define DYN_DQ_WRDQSCTL_CC_5                               37
#define DYN_DQ_WRDQSCTL_CC_6                               38
#define DYN_DQ_WRDQSCTL_CC_7                               39
#define DYN_DQ_WRDQSCTL_BL                                 40
#define DYN_DQ_WRDQSCTL_BL_1                               41
#define DYN_DQ_WRDQSCTL_BL_2                               42
#define DYN_DQ_WRDQSCTL_BL_3                               43
#define DYN_DQ_WRDQSCTL_BL_4                               44
#define DYN_DQ_WRDQSCTL_BL_5                               45
#define DYN_DQ_WRDQSCTL_BL_6                               46
#define DYN_DQ_WRDQSCTL_BL_7                               47
#define DYN_DQ_RDVLDCTL                                    48
#define DYN_DQ_RDVLDCTL_1                                  49
#define DYN_DQ_RDVLDCTL_2                                  50
#define DYN_DQ_RDVLDCTL_3                                  51
#define DYN_DQ_RDVLDCTL_4                                  52
#define DYN_DQ_RDVLDCTL_5                                  53
#define DYN_DQ_RDVLDCTL_6                                  54
#define DYN_DQ_RDVLDCTL_7                                  55
#define DYN_DQ_RK2RKCTL0                                   56
#define DYN_DQ_RK2RKCTL0_1                                 57
#define DYN_DQ_RK2RKCTL0_2                                 58
#define DYN_DQ_RK2RKCTL0_3                                 59
#define DYN_DQ_RK2RKCTL0_4                                 60
#define DYN_DQ_RK2RKCTL0_5                                 61
#define DYN_DQ_RXDLLRDCMDCTL0                              62
#define DYN_DQ_RXDLLRDCMDCTL0_1                            63
#define DYN_DQ_RXDLLRDCMDCTL0_2                            64
#define DYN_DQ_RXDLLRDCMDCTL0_3                            65
#define DYN_DQ_RXDLLRDCMDCTL0_4                            66
#define DYN_DQ_RXDLLRDCMDCTL0_5                            67
#define DYN_DQ_RXDLLRDCMDCTL0_6                            68
#define DYN_CCC_RXODTSEGCTL                                69
#define DYN_CCC_RXODTSEGCTL_1                              70
#define DYN_CCC_RXODTSEGCTL_2                              71
#define DYN_CCC_RXODTSEGCTL_3                              72
#define DYN_CCC_RXODTSEGCTL_4                              73
#define DYN_CCC_RXODTSEGCTL_5                              74
#define DYN_CCC_RXODTSEGCTL_6                              75
#define DYN_CCC_RXODTCTL                                   76
#define DYN_CCC_RXODTCTL_1                                 77
#define DYN_CCC_RXODTCTL_2                                 78
#define DYN_CCC_RXODTCTL_3                                 79
#define DYN_CCC_RXODTCTL_4                                 80
#define DYN_CCC_RXODTCTL_5                                 81
#define DYN_CCC_RXODTCTL_6                                 82
#define DYN_CCC_RCVENCTL                                   83
#define DYN_CCC_RCVENCTL_1                                 84
#define DYN_CCC_RCVENCTL_2                                 85
#define DYN_CCC_RCVENCTL_3                                 86
#define DYN_CCC_RCVENCTL_4                                 87
#define DYN_CCC_RCVENCTL_5                                 88
#define DYN_CCC_RCVENCTL_6                                 89
#define DYN_CCC_DIFFAMPCTL                                 90
#define DYN_CCC_DIFFAMPCTL_1                               91
#define DYN_CCC_DIFFAMPCTL_2                               92
#define DYN_CCC_DIFFAMPCTL_3                               93
#define DYN_CCC_DIFFAMPCTL_4                               94
#define DYN_CCC_DIFFAMPCTL_5                               95
#define DYN_CCC_DIFFAMPCTL_6                               96
#define DYN_CCC_DIFFAMPCTL_7                               97
#define DYN_CCC_DIFFAMPCTL_8                               98
#define DYN_CCC_DIFFAMPCTL_9                               99
#define DYN_CCC_DIFFAMPCTL_10                              100
#define DYN_CCC_DIFFAMPCTL_11                              101
#define DYN_CCC_DIFFAMPCTL_12                              102
#define DYN_DQ_FIFOPTRCTL                                  103
#define DYN_DQ_FIFOPTRCTL_1                                104
#define DYN_DQ_FIFOPTRCTL_2                                105
#define DYN_DQ_RXODTSEGCTL_BL13                            106
#define DYN_DQ_RXODTSEGCTL_BL13_1                          107
#define DYN_DQ_RXODTSEGCTL_BL13_2                          108
#define DYN_DQ_RXODTSEGCTL_BL13_3                          109
#define DYN_DQ_RXODTSEGCTL_BL13_4                          110
#define DYN_DQ_RXODTSEGCTL_BL13_5                          111
#define DYN_DQ_RXODTSEGCTL_BL13_6                          112
#define DYN_DQ_RXODTSEGCTL_BL02                            113
#define DYN_DQ_RXODTSEGCTL_BL02_1                          114
#define DYN_DQ_RXODTSEGCTL_BL02_2                          115
#define DYN_DQ_RXODTSEGCTL_BL02_3                          116
#define DYN_DQ_RXODTSEGCTL_BL02_4                          117
#define DYN_DQ_RXODTSEGCTL_BL02_5                          118
#define DYN_DQ_RXODTSEGCTL_BL02_6                          119
#define DYN_DQ_RXODTCTL_BL13                               120
#define DYN_DQ_RXODTCTL_BL13_1                             121
#define DYN_DQ_RXODTCTL_BL13_2                             122
#define DYN_DQ_RXODTCTL_BL13_3                             123
#define DYN_DQ_RXODTCTL_BL13_4                             124
#define DYN_DQ_RXODTCTL_BL13_5                             125
#define DYN_DQ_RXODTCTL_BL13_6                             126
#define DYN_DQ_RXODTCTL_DQ                                 127
#define DYN_DQ_RXODTCTL_DQ_1                               128
#define DYN_DQ_RXODTCTL_DQ_2                               129
#define DYN_DQ_RXODTCTL_DQ_3                               130
#define DYN_DQ_RXODTCTL_DQ_4                               131
#define DYN_DQ_RXODTCTL_DQ_5                               132
#define DYN_DQ_RXODTCTL_DQ_6                               133
#define DYN_DQ_RCVENCTL_BL13                               134
#define DYN_DQ_RCVENCTL_BL13_1                             135
#define DYN_DQ_RCVENCTL_BL13_2                             136
#define DYN_DQ_RCVENCTL_BL13_3                             137
#define DYN_DQ_RCVENCTL_BL13_4                             138
#define DYN_DQ_RCVENCTL_BL13_5                             139
#define DYN_DQ_RCVENCTL_BL13_6                             140
#define DYN_DQ_RCVENCTL_BL02                               141
#define DYN_DQ_RCVENCTL_BL02_1                             142
#define DYN_DQ_RCVENCTL_BL02_2                             143
#define DYN_DQ_RCVENCTL_BL02_3                             144
#define DYN_DQ_RCVENCTL_BL02_4                             145
#define DYN_DQ_RCVENCTL_BL02_5                             146
#define DYN_DQ_RCVENCTL_BL02_6                             147
#define DYN_DQ_DIFFAMPCTL_BL13                             148
#define DYN_DQ_DIFFAMPCTL_BL13_1                           149
#define DYN_DQ_DIFFAMPCTL_BL13_2                           150
#define DYN_DQ_DIFFAMPCTL_BL13_3                           151
#define DYN_DQ_DIFFAMPCTL_BL13_4                           152
#define DYN_DQ_DIFFAMPCTL_BL13_5                           153
#define DYN_DQ_DIFFAMPCTL_BL13_6                           154
#define DYN_DQ_DIFFAMPCTL_BL13_7                           155
#define DYN_DQ_DIFFAMPCTL_BL13_8                           156
#define DYN_DQ_DIFFAMPCTL_BL13_9                           157
#define DYN_DQ_DIFFAMPCTL_BL13_10                          158
#define DYN_DQ_DIFFAMPCTL_BL13_11                          159
#define DYN_DQ_DIFFAMPCTL_BL02                             160
#define DYN_DQ_DIFFAMPCTL_BL02_1                           161
#define DYN_DQ_DIFFAMPCTL_BL02_2                           162
#define DYN_DQ_DIFFAMPCTL_BL02_3                           163
#define DYN_DQ_DIFFAMPCTL_BL02_4                           164
#define DYN_DQ_DIFFAMPCTL_BL02_5                           165
#define DYN_DQ_DIFFAMPCTL_BL02_6                           166
#define DYN_DQ_DIFFAMPCTL_BL02_7                           167
#define DYN_DQ_DIFFAMPCTL_BL02_8                           168
#define DYN_DQ_DIFFAMPCTL_BL02_9                           169
#define DYN_DQ_DIFFAMPCTL_BL02_10                          170
#define DYN_DQ_DIFFAMPCTL_BL02_11                          171
#define DYN_DQDPLVUG_PTCTL0                                172
#define DYN_DQDPLVUG_PTCTL0_1                              173
#define DYN_DQDPLVUG_PTCTL0_2                              174
#define DYN_DQDPLVUG_PTCTL0_3                              175
#define DYN_DQDPLVUG_PTCTL0_4                              176
#define DYN_DQDPLVUG_PTCTL0_5                              177
#define DYN_DPLVUG_DPIC_GRCOMP_CFG3                        178
#define DYN_DPIC_PLLCTL                                    179
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1                        180
#define DYN_DQDPLVUG_DPIC_LRCOMP_OVR1                      181
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1_1                      182
#define DYN_DQDPLVUG_DPIC_LRCOMP_OVR1_1                    183
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1_2                      184
#define DYN_DQDPLVUG_DPIC_LRCOMP_OVR1_2                    185
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1_3                      186
#define DYN_DQDPLVUG_DPIC_LRCOMP_OVR1_3                    187
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2                        188
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2_1                      189
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2_2                      190
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2_3                      191
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3                        192
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3_1                      193
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3_2                      194
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3_3                      195
#define DYN_DUNIT_D_CR_DRP0                                196
#define DYN_DUNIT_D_CR_DRP0_1                              197
#define DYN_DUNIT_D_CR_DTR0A                               198
#define DYN_DUNIT_D_CR_DRP0_2                              199
#define DYN_DUNIT_D_CR_DTR1A                               200
#define DYN_DUNIT_D_CR_DTR2A                               201
#define DYN_DUNIT_D_CR_DTR3A                               202
#define DYN_DUNIT_D_CR_DTR4A                               203
#define DYN_DUNIT_D_CR_DTR5A                               204
#define DYN_DUNIT_D_CR_DTR6A                               205
#define DYN_DUNIT_D_CR_DTR7A                               206
#define DYN_DUNIT_D_CR_DTR8A                               207
#define DYN_DUNIT_D_CR_SSKPD0                              208
#define DYN_DUNIT_D_CR_BONUS0                              209
#define DYN_DUNIT_D_CR_BONUS1                              210
#define DYN_DUNIT_D_CR_MR4_DESWIZZLE                       211
#define DYN_DUNIT_D_CR_DOCRA                               212
#define DYN_DUNIT_D_CR_DOCRA_1                             213
#define DYN_DUNIT_D_CR_DOCRA_2                             214
#define DYN_DUNIT_D_CR_DRMC                                215
#define DYN_DUNIT_D_CR_BGF_CTL                             216
#define DYN_DUNIT_D_CR_BGF_CTL_1                           217
#define DYN_DUNIT_D_CR_BGF_CTL_2                           218
#define DYN_DUNIT_D_CR_DRMC_1                              219
#define DYN_DUNIT_D_CR_DRMC_2                              220
#define DYN_DUNIT_D_CR_DRFC                                221
#define DYN_DUNIT_D_CR_DRFC_1                              222
#define DYN_DUNIT_D_CR_DRP0_3                              223
#define DYN_DUNIT_D_CR_DPMC1                               224
#define DYN_DUNIT_D_CR_DSCH                                225
#define DYN_DUNIT_D_CR_BGF_CUSTOM_TSV_CMD_PATTERN          226
#define DYN_DUNIT_D_CR_BGF_CUSTOM_TSV_CMD_INIT             227
#define DYN_DUNIT_D_CR_BGF_CUSTOM_TSV_DATA_PATTERN         228
#define DYN_DUNIT_D_CR_BGF_CUSTOM_TSV_DATA_INIT            229
#define DYN_DUNIT_D_CR_TQCTL                               230
#define DYN_DUNIT_D_CR_TQCTL_1                             231
#define DYN_DUNIT_D_CR_TQOFFSET                            232
#define DYN_DUNIT_D_CR_BGF_CTL_3                           233
#define DYN_DUNIT_D_CR_BGF_CTL_4                           234
#define DYN_DUNIT_D_CR_BGF_CTL_5                           235
#define DYN_DUNIT_D_CR_DQS_RETRAINING_CTL                  236
#define DYN_CCC_RDVLDCTL_8                                 237
#define DYN_DQ_RDVLDCTL_8                                  238
#define DYN_PUNIT_P_CR_MC_BIOS_REQ_0_0_0_MCHBAR_1          239
#define DYN_DUNIT_D_CR_DRMC_3                              240
#define DYN_DQ_DLLCOMP_FBMUXSEL                            241
#define DYN_CCC_DLLCOMP_FBMUXSEL1                          242
#define DYN_DQ_DLLCOMP_FINECODE                            243
#define DYN_CCC_DLLCOMP_FINECODE                           244
#define DYN_DQ_DLLCOMP_COARSECODE                          245
#define DYN_CCC_DLLCOMP_COARSECODE1                        246
#define DYN_CCC_DLLCOMP_COARSECODE0_CH0                    247
#define DYN_CCC_DLLCOMP_COARSECODE0_CH0_1                  248
#define DYN_CCC_DLLCOMP_COARSECODE0_CH1                    249
#define DYN_CCC_DLLCOMP_COARSECODE0_CH1_1                  250
#define DYN_CCC_DLLCOMP_COARSECODE0_ECC                    251
#define DYN_CCC_DLLCOMP_COARSECODE0_ECC_1                  252
#define DYN_DQ_DLLCOMP_COARSECODE_1                        253
#define DYN_DQ_DLLCOMP_COARSECODE_2                        254
#define DYN_DUNIT_D_CR_DRP0_4                              255
#define DYN_DUNIT_D_CR_SCRAMCTRL                           256
#define DYN_CUNIT_MCHBAR_LO_0_0_0_PCI                      257
#define DYN_P2SB_SBREG_BAR                                 258
#define DYN_AUNIT_A_CR_SLICE_CHANNEL_HASH_0_0_0_MCHBAR     259
#define DYN_AUNIT_A_CR_SLICE_CHANNEL_HASH_0_0_0_MCHBAR_1   260
#define DYN_AUNIT_A_CR_SLICE_CHANNEL_HASH_0_0_0_MCHBAR_2   261
#define DYN_AUNIT_A_CR_ASYM_MEM_REGION0_0_0_0_MCHBAR       262
#define DYN_AUNIT_A_CR_ASYM_MEM_REGION1_0_0_0_MCHBAR       263
#define DYN_AUNIT_A_CR_ASYM_2WAY_MEM_REGION_0_0_0_MCHBAR   264
#define DYN_BUNIT_B_CR_ASYM_MEM_REGION0_0_0_0_MCHBAR       265
#define DYN_BUNIT_B_CR_ASYM_MEM_REGION1_0_0_0_MCHBAR       266
#define DYN_BUNIT_B_CR_ASYM_2WAY_MEM_REGION_0_0_0_MCHBAR   267
#define DYN_DQ_RXPBDBLCTL0                                 268
#define DYN_DQ_WRLVL                                       269
#define DYN_CCC_WRLVL                                      270
#define DYN_DQ_DIFFAMPCTL_BL13_12                          271
#define DYN_DQ_DIFFAMPCTL_BL02_12                          272
#define DYN_CCC_DIFFAMPCTL_13                              273
#define DYN_DUNIT_D_CR_DRAM_CMD                            274
#define DYN_CPGC_CPGC_ERR_CTL                              275
#define DYN_CPGC_CPGC_ERR_LNEN_HI                          276
#define DYN_CPGC_CPGC_DPAT_UNISEQ_0_                       277
#define DYN_CPGC_CPGC2_BASE_REPEATS                        278
#define DYN_CPGC_CPGC2_BLOCK_REPEATS                       279
#define DYN_CPGC_CPGC_DPAT_XTRA_LFSR_CFG                   280
#define DYN_CPGC_CPGC_DPAT_CFG                             281
#define DYN_CPGC_CPGC2_BASE_REPEATS_1                      282
#define DYN_CPGC_CPGC2_BLOCK_REPEATS_1                     283
#define DYN_DUNIT_D_CR_DRMC_4                              284
#define DYN_DUNIT_D_CR_DRMC_5                              285
#define DYN_DUNIT_D_CR_DRAM_CMD_1                          286
#define DYN_CPGC_CPGC_SEQ_BANK_L2P_MAPPING_A               287
#define DYN_CPGC_CPGC_SEQ_RANK_L2P_MAPPING                 288
#define DYN_CPGC_CPGC_CADB_BUFA_0_                         289
#define DYN_CPGC_CPGC_CADB_BUFA_1_                         290
#define DYN_CPGC_CPGC_CADB_BUFB_1_                         291
#define DYN_CPGC_CPGC_CADB_BUFA_2_                         292
#define DYN_CPGC_CPGC_CADB_BUFA_3_                         293
#define DYN_CPGC_CPGC2_ADDRESS_SIZE                        294
#define DYN_CPGC_CPGC2_ADDRESS_CONTROL                     295
#define DYN_CPGC_CPGC_CADB_BUFA_0__1                       296
#define DYN_CPGC_CPGC_CADB_BUFA_1__1                       297
#define DYN_CPGC_CPGC_CADB_BUFA_2__1                       298
#define DYN_CPGC_CPGC_CADB_BUFA_3__1                       299
#define DYN_CPGC_CPGC_CADB_BUFA_4_                         300
#define DYN_CPGC_CPGC_CADB_BUFA_5_                         301
#define DYN_CPGC_CPGC_CADB_BUFA_6_                         302
#define DYN_CPGC_CPGC_CADB_BUFA_7_                         303
#define DYN_CPGC_CPGC_CADB_BUFB_0_                         304
#define DYN_CPGC_CPGC_CADB_BUFB_1__1                       305
#define DYN_CPGC_CPGC_CADB_BUFB_2_                         306
#define DYN_CPGC_CPGC_CADB_BUFB_3_                         307
#define DYN_CPGC_CPGC_CADB_BUFB_4_                         308
#define DYN_CPGC_CPGC_CADB_BUFB_5_                         309
#define DYN_CPGC_CPGC_CADB_BUFB_6_                         310
#define DYN_CPGC_CPGC_CADB_BUFB_7_                         311
#define DYN_CPGC_CPGC_DPAT_UNISEQ_0__1                     312
#define DYN_CPGC_CPGC_DPAT_UNISEQ_1_                       313
#define DYN_CPGC_CPGC_CADB_CFG                             314
#define DYN_CPGC_CPGC_CADB_UNISEQ0_PBUF                    315
#define DYN_CPGC_CPGC_CADB_UNISEQ1_PBUF                    316
#define DYN_CPGC_CPGC_CADB_UNISEQ2_PBUF                    317
#define DYN_CPGC_CPGC2_ALGORITHM_INSTRUCTION_0_            318
#define DYN_CPGC_CPGC_DPAT_UNISEQ_0__2                     319
#define DYN_CPGC_CPGC_DPAT_UNISEQ_1__1                     320
#define DYN_CPGC_CPGC_DPAT_CFG_1                           321
#define DYN_DQ_U32_WRDQCTL                                 322
#define DYN_DQ_U32_WRDQSCTL_CC                             323
#define DYN_DQ_U32_WRDQSCTL_BL                             324
#define DYN_CCC_U32_WRDQCTL                                325
#define DYN_CCC_U32_WRDQSCTL                               326
#define DYN_CPGC_CPGC_DPAT_INV_DC_MASK_LO                  327
#define DYN_DUNIT_D_CR_DRMC_6                              328
#define DYN_DQ_U32_WKPUPPDNCTL                             329
#define DYN_CCC_U32_WKPUPPDNCTL                            330
#define DYN_DQ_RXODTCTL_BL13_7                             331
#define DYN_CCC_RXODTSEGCTL_7                              332
#define DYN_DQ_RXODTCTL_DQ_7                               333
#define DYN_DQ_WKPUPPDNCTL                                 334
#define DYN_DPLVUG_DPIC_GRCOMP_VREF_0                      335
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1_4                      336
#define DYN_DQDPLVUG_DPIC_LRCOMP_OVR1_4                    337
#define DYN_DQDPLVUG_DPIC_LRCOMP_OVR1_5                    338
#define DYN_DQDPLVUG_DPIC_LRCOMP_OVR1_6                    339
#define DYN_DQDPLVUG_DPIC_LRCOMP_OVR1_7                    340
#define DYN_DQDPLVUG_DPIC_LRCOMP_OVR1_8                    341
#define DYN_DPLVUG_DPIC_LRCOMP_OVR1_5                      342
#define DYN_DPLVUG_DPIC_LRCOMP_OVR2_4                      343
#define DYN_DPLVUG_DPIC_LRCOMP_OVR3_4                      344
#define DYN_DPLVUG_DPIC_LRCOMP_PUPDOVR                     345
#define DYN_DQDPLVUG_DPIC_LRCOMP_PUPDOVR                   346
#define DYN_DPLVUG_DPIC_LRCOMP_PUPDOVR_1                   347
#define DYN_DQ_RXODTSEGCTL_BL02_7                          348
#define DYN_DQ_DIFFAMPCTL_BL02_13                          349
#define DYN_DQ_RXODTSEGCTL_BL13_7                          350
#define DYN_DQ_DIFFAMPCTL_BL13_13                          351
#define DYN_CCC_DIFFAMPCTL_14                              352
#define DYN_DPLVUG_DPIC_GRCOMP_VREF_0_1                    353
#define DYN_DPLVUG_DPIC_GRCOMP_VREF_1                      354
#define DYN_DQ_RXODTCTL_DQ_8                               355
#define DYN_CCC_RXODTSEGCTL_8                              356
#define DYN_CCC_RXODTCTL_7                                 357
#define DYN_DQ_RXODTCTL_BL13_8                             358
#define DYN_DQ_VREFCTL0                                    359
#define DYN_CCC_VREFCTL2                                   360
#define DYN_DUNIT_D_CR_DRMC_7                              361
#define DYN_DUNIT_D_CR_DQS_RETRAINING_CTL_1                362
#define DYN_DQDPLVUG_PTCTL0_6                              363
#define DYN_DUNIT_D_CR_TQCTL_2                             364
#define DYN_DUNIT_D_CR_DCAL                                365
#define DYN_DUNIT_D_CR_DRFC_2                              366
#define DYN_DUNIT_D_CR_DPMC0                               367
#define DYN_DUNIT_D_CR_DPMC1_1                             368
#define DYN_DUNIT_D_CR_DQS_RETRAINING_CTL_2                369
#define DYN_DUNIT_D_CR_DTR4A_1                             370
#define DYN_DUNIT_D_CR_DTR6A_1                             371
#define DYN_DQDPLVUG_PTCTL0_7                              372
#define DYN_CPGC_CPGC_ERR_CTL_1                            373
#define DYN_DQ_TXPBDCTL1                                   374
#define DYN_CCC_TXPBDCTL1                                  375
#define DYN_CCC_ECC_TXPBDCTL1                              376
#define DYN_CPGC_CPGC2_ADDRESS_SIZE_1                      377
//
// All dynamic field names. These must be populated with real values prior to executing MmrcEntry().
//
#ifdef MEM_SV_HOOKS
#define FM_CH3                                             0
#define FM_CH2                                             1
#define FM_CH1                                             2
#define FM_CH0                                             3
#define PUNIT_REQ_TYPE                                     4
#define PUNIT_REQ_DATA                                     5
#define TEMP                                               6
#define str_m                                              7
#define BXT_P_POST_A0                                      8
#define BXT_P_A0                                           9
#define RSVD                                               10
#define WRPREAM0EN                                         11
#define WL                                                 12
#define pream                                              13
#define RL                                                 14
#define DQSDRVENPREAM0                                     15
#define RANK1_ENABLED                                      16
#define ECCEN_BXT_P_POST_A0                                17
#define INVPH0TO180_DDR3_VAL                               18
#define SLICE_0_MASTER                                     19
#define SLICE_1_MASTER                                     20
#define GCOMP_CH_EN                                        21
#define ECCEN                                              22
#define TEMPVAR                                            23
#define SS_TEMP_VAR_UPGRP0                                 24
#define SS_TEMP_VAR_DNGRP0                                 25
#define SS_TEMP_VAR_UPGRP1                                 26
#define SS_TEMP_VAR_DNGRP1                                 27
#define SS_TEMP_VAR_UPGRP2                                 28
#define SS_TEMP_VAR_DNGRP2                                 29
#define SS_TEMP_VAR_UPGRP3                                 30
#define SS_TEMP_VAR_DNGRP3                                 31
#define SS_TEMP_VAR_UPGRP4                                 32
#define SS_TEMP_VAR_DNGRP4                                 33
#define SS_TEMP_VAR_UPGRP5                                 34
#define SS_TEMP_VAR_DNGRP5                                 35
#define DRAMDEVICE_PR                                      36
#define ADDRDEC                                            37
#define CASWIZZLE                                          38
#define TCKSRX                                             39
#define TXSDLL                                             40
#define TXSR                                               41
#define TRCD                                               42
#define TRPPB                                              43
#define DDEN                                               44
#define DWID                                               45
#define RANK0_ENABLED                                      46
#define TXP                                                47
#define TZQCL                                              48
#define TZQCS                                              49
#define TZQLAT                                             50
#define NRFCAB                                             51
#define TCKE                                               52
#define NREFI                                              53
#define TRTP                                               54
#define TWTP                                               55
#define TCWL                                               56
#define TCCDMW                                             57
#define TFAW                                               58
#define TWRDR                                              59
#define TRWDR                                              60
#define TWWDR                                              61
#define TRRDR                                              62
#define TRRD                                               63
#define TDERATE_INC                                        64
#define TWWSR                                              65
#define TRRSR                                              66
#define TWRSR                                              67
#define TRWSR                                              68
#define TCKCKEL                                            69
#define MNTDLY                                             70
#define TPSTMRRBLK                                         71
#define TPREMRBLK                                          72
#define TRPAB                                              73
#define TPSTMRWBLK                                         74
#define TWRPDEN                                            75
#define TRDPDEN                                            76
#define TRAS                                               77
#define TCKESR                                             78
#define LPMDRES                                            79
#define TLPCKDLY                                           80
#define TCKLPDLY                                           81
#define PWDDLY                                             82
#define SSKPD0                                             83
#define SSKPD1                                             84
#define BONUS0                                             85
#define BONUS1                                             86
#define MR4_BIT2_SEL                                       87
#define MR4_BIT1_SEL                                       88
#define MR4_BIT0_SEL                                       89
#define MR4_BYTE_SEL                                       90
#define MR4_BIT0_SEL2                                      91
#define MR4_BIT1_SEL2                                      92
#define MR4_BIT2_SEL2                                      93
#define MR4_BYTE_SEL2                                      94
#define WRODTSTOP                                          95
#define RDODTSTART                                         96
#define R0WRODTCTL                                         97
#define R1WRODTCTL                                         98
#define R0RDODTCTL                                         99
#define R1RDODTCTL                                         100
#define CKEVAL_VAR                                         101
#define SPIDCMDCLK_RATIO                                   102
#define SPIDDATA_RATIO_WIO2                                103
#define MINREFRATE                                         104
#define REFWMPNC                                           105
#define REFWMHI                                            106
#define BAHEN                                              107
#define RSIEN                                              108
#define CMDTRIST                                           109
#define PCLSTO                                             110
#define BLKRDBF_ADD_RDDATA                                 111
#define BLKRDBF                                            112
#define SPID_EARLY_RDDATA_VALID                            113
#define BGF_EARLY_RDDATA_VALID                             114
#define PATTERN_CMDSPID_TO_SABY2_TSVS                      115
#define PATTERN_SABY2_TO_CMDSPID_TSVS                      116
#define INIT_CMDSPID_TO_SABY2_TSVS                         117
#define INIT_SABY2_TO_CMDSPID_TSVS                         118
#define PATTERN_DATASPID_TO_SABY2_TSVS                     119
#define PATTERN_SABY2_TO_DATASPID_TSVS                     120
#define INIT_DATASPID_TO_SABY2_TSVS                        121
#define INIT_SABY2_TO_DATASPID_TSVS                        122
#define TQPOLLPER                                          123
#define SRTEN                                              124
#define MR_VALUE                                           125
#define SACLKBY2_RATIO                                     126
#define BXT_A0_WA                                          127
#define DQS_RETRAIN_INT                                    128
#define DQS_OSC_RT                                         129
#define MUX_MAX                                            130
#define MUX_MIN                                            131
#define FINE_MAX                                           132
#define FINE_MIN                                           133
#define COARSE_MAX                                         134
#define COARSE_MIN                                         135
#define FINE_SOFT_MAX                                      136
#define FINE_SOFT_MIN                                      137
#define SS_TEMP_VAR                                        138
#define WEAK_ODT_CONFIG                                    139
#define FUSESTAT                                           140
#define SCRAMBLER_KEY                                      141
#define MCHBAR                                             142
#define P2SBBAR                                            143
#define ECBASE_LO                                          144
#define ECBASE_EN                                          145
#define ECBASE_HI                                          146
#define SYM_SLICE1_CHANNEL_ENABLED                         147
#define SYM_SLICE0_CHANNEL_ENABLED                         148
#define SLICE_1_DISABLED                                   149
#define SLICE_0_MEM_DISABLED                               150
#define CHANNEL_HASH_MASK                                  151
#define AUNIT_INTERLEAVED_MODE                             152
#define SLICE_HASH_MASK                                    153
#define SLICE0_ASYM_ENABLE                                 154
#define SLICE0_ASYM_CHANNEL_SELECT                         155
#define SLICE0_ASYM_LIMIT                                  156
#define SLICE0_ASYM_BASE                                   157
#define SLICE1_ASYM_ENABLE                                 158
#define SLICE1_ASYM_CHANNEL_SELECT                         159
#define SLICE1_ASYM_LIMIT                                  160
#define SLICE1_ASYM_BASE                                   161
#define ASYM_2WAY_INTERLEAVE_ENABLE                        162
#define ASYM_2WAY_LIMIT                                    163
#define ASYM_2WAY_BASE                                     164
#define ASYM_2WAY_INTLV_MODE                               165
#define DDR_CONFIG_LIMITATION                              166
#define SABY2CLK                                           167
#define S0_Fixes0                                          168
#define CMD_RDPTROFFSET_ADJUST                             169
#define WRLVLMODEVAR                                       170
#define CC_DQS_OVR_VAL                                     171
#define CC_DQS_OVR_SEL                                     172
#define CC_DQDM_OVR_VAL                                    173
#define CC_DQDM_OVR_SEL                                    174
#define BL_DQS_OVR_VAL                                     175
#define BL_DQS_OVR_SEL                                     176
#define BL_DQDM_OVR_VAL                                    177
#define BL_DQDM_OVR_SEL                                    178
#define DQDM_OVR_SEL_ECC                                   179
#define DQS_OVR_SEL_ECC                                    180
#define DQDM_OVR_ECC                                       181
#define DQS_OVR_ECC                                        182
#define DRAM_CMD_BL                                        183
#define RANK                                               184
#define RDDCMD                                             185
#define REG_DATA                                           186
#define ERROR_STATUS                                       187
#define CHUNK_ERR_MASK                                     188
#define CHUNK_ERR_MASK_LP                                  189
#define BYTEGRP_ERR_STAT                                   190
#define CHUNK_ERR_STAT                                     191
#define LANE_ERR_STAT_LO                                   192
#define LANE_ERR_STAT_HI                                   193
#define ECC_ERR_STAT                                       194
#define ECC_LANE_ERR_STAT                                  195
#define ERR_COUNT0                                         196
#define ERR_COUNT1                                         197
#define ERR_COUNT2                                         198
#define ERR_COUNT3                                         199
#define ERR_COUNT4                                         200
#define ERR_COUNT5                                         201
#define ERR_COUNT6                                         202
#define ERR_COUNT7                                         203
#define ERR_COUNT8                                         204
#define NUM_BURSTS_EXP                                     205
#define NUM_LOOPS_EXP                                      206
#define LANE_ROTATE_RATE                                   207
#define RELOAD_LFSR_SEED_RATE                              208
#define SAVE_LFSR_SEED_RATE                                209
#define RANK_INDEX                                         210
#define TARGET_BANK                                        211
#define TARGET_RANK                                        212
#define ROW_COL_ADDR                                       213
#define NUM_COLS                                           214
#define NUM_ROWS                                           215
#define ADD_ROTATE_RPT                                     216
#define CADB_BUFA0_BANK                                    217
#define CADB_BUFA0_ROW_COL                                 218
#define CADB_BUFA1_BANK                                    219
#define CADB_BUFA1_ROW_COL                                 220
#define CADB_BUFA2_BANK                                    221
#define CADB_BUFA2_ROW_COL                                 222
#define CADB_BUFA3_BANK                                    223
#define CADB_BUFA3_ROW_COL                                 224
#define CADB_BUFA4_BANK                                    225
#define CADB_BUFA4_ROW_COL                                 226
#define CADB_BUFA5_BANK                                    227
#define CADB_BUFA5_ROW_COL                                 228
#define CADB_BUFA6_BANK                                    229
#define CADB_BUFA6_ROW_COL                                 230
#define CADB_BUFA7_BANK                                    231
#define CADB_BUFA7_ROW_COL                                 232
#define CADB_BUFB0_CMD                                     233
#define CADB_BUFB1_CMD                                     234
#define CADB_BUFB2_CMD                                     235
#define CADB_BUFB3_CMD                                     236
#define CADB_BUFB4_CMD                                     237
#define CADB_BUFB5_CMD                                     238
#define CADB_BUFB6_CMD                                     239
#define CADB_BUFB7_CMD                                     240
#define AGG_PATTERN                                        241
#define VIC_PATTERN                                        242
#define UNIMODE                                            243
#define PATTERN0                                           244
#define PATTERN1                                           245
#define PATTERN2                                           246
#define INSTR_LAST                                         247
#define INSTR_POINTER                                      248
#define ORIG_WRDQCTL                                       249
#define ORIG_WRDQSCTL_CC                                   250
#define ORIG_WRDQSCTL_BB                                   251
#define ORIG_CC_WRDQCTL                                    252
#define ORIG_CC_WRDQSCTL                                   253
#define CAVREF                                             254
#define ORIG_DQ_WKCTL                                      255
#define ORIG_CC_WKCTL                                      256
#define CC_DQSRXODTENOVRVAL                                257
#define CC_DQSRXODTENOVRSEL                                258
#define CC_RXODTENOVRVAL                                   259
#define CC_RXODTENOVRSEL                                   260
#define RXODTSEGOVRVAL_ecc                                 261
#define RXODTSEGOVRSEL_ecc                                 262
#define BL_DQSRXODTENOVRVAL                                263
#define BL_DQSRXODTENOVRSEL                                264
#define BL_RXODTENOVRVAL                                   265
#define BL_RXODTENOVRSEL                                   266
#define LVL_CC_WEAKPUPSTATIC                               267
#define LVL_CC_WEAKPUP                                     268
#define LVL_CC_WEAKPDNSTATIC                               269
#define LVL_CC_WEAKPDN                                     270
#define LVL_BL_WEAKPUPSTATIC                               271
#define LVL_BL_WEAKPUP                                     272
#define LVL_BL_WEAKPDNSTATIC                               273
#define LVL_BL_WEAKPDN                                     274
#define RCOMP_Up_GRP0_dq0                                  275
#define RCOMP_Dn_GRP0_dq0                                  276
#define RCOMP_Up_GRP1_dq0                                  277
#define RCOMP_Dn_GRP1_dq0                                  278
#define RCOMP_Up_GRP0_dq1                                  279
#define RCOMP_Dn_GRP0_dq1                                  280
#define RCOMP_Up_GRP1_dq1                                  281
#define RCOMP_Dn_GRP1_dq1                                  282
#define RCOMP_Up_GRP0_dq2                                  283
#define RCOMP_Dn_GRP0_dq2                                  284
#define RCOMP_Up_GRP1_dq2                                  285
#define RCOMP_Dn_GRP1_dq2                                  286
#define RCOMP_Up_GRP0_dq3                                  287
#define RCOMP_Dn_GRP0_dq3                                  288
#define RCOMP_Up_GRP1_dq3                                  289
#define RCOMP_Dn_GRP1_dq3                                  290
#define RCOMP_Up_GRP0                                      291
#define RCOMP_Dn_GRP0                                      292
#define RCOMP_Up_GRP1                                      293
#define RCOMP_Dn_GRP1                                      294
#define RCOMP_Up_GRP2                                      295
#define RCOMP_Dn_GRP2                                      296
#define RCOMP_Up_GRP3                                      297
#define RCOMP_Dn_GRP3                                      298
#define RCOMP_Up_GRP4                                      299
#define RCOMP_Dn_GRP4                                      300
#define RCOMP_Up_GRP5                                      301
#define RCOMP_Dn_GRP5                                      302
#define RCOMP_OVR_Up_En                                    303
#define RCOMP_OVR_Dn_En                                    304
#define RCOMP_OVR_Up_En_dq                                 305
#define RCOMP_OVR_Dn_En_dq                                 306
#define RCOMP_Seg_Ovr_Val_bl                               307
#define RCOMP_Seg_Ovr_En_bl                                308
#define DIFF_Ovr_Val_bl                                    309
#define DIFF_Ovr_Val_sel_bl                                310
#define comp_vref_0                                        311
#define comp_vref_1                                        312
#define comp_vref_2                                        313
#define comp_vref_3                                        314
#define comp_vref_4                                        315
#define comp_vref_5                                        316
#define RX_ODTEN_OVR_SEL_bl                                317
#define RX_ODTEN_OVR_VAL_bl                                318
#define ECC_RX_ODTEN_OVR_SEL_bl                            319
#define ECC_RX_ODTEN_OVR_VAL_bl                            320
#define RXBLVREFCTL                                        321
#define VOC_LDO_ENABLE                                     322
#define VOC_RCOMP_PUP                                      323
#define VOC_RCOMP_PDN                                      324
#define TQPOLLEN_SAVE                                      325
#define SRXZQC_SAVE                                        326
#define ZQDIS_SAVE                                         327
#define OREFDIS_SAVE                                       328
#define DYNSREN_SAVE                                       329
#define DISPWRDN_SAVE                                      330
#define DQS_RETAIN_EN_SAVE                                 331
#define RDCMD2RDVLD                                        332
#define PTLDCODE                                           333
#define MR0_0                                              334
#define MR1_0                                              335
#define MR2_0                                              336
#define MR0_1                                              337
#define MR1_1                                              338
#define MR2_1                                              339
#define DYNVAR_MAX                                         340
#else
#define FM_CH3                                             0
#define FM_CH2                                             1
#define FM_CH1                                             2
#define FM_CH0                                             3
#define PUNIT_REQ_TYPE                                     4
#define PUNIT_REQ_DATA                                     5
#define TEMP                                               6
#define str_m                                              7
#define BXT_P_POST_A0                                      8
#define BXT_P_A0                                           9
#define RSVD                                               10
#define WRPREAM0EN                                         11
#define WL                                                 12
#define pream                                              13
#define RL                                                 14
#define DQSDRVENPREAM0                                     15
#define RANK1_ENABLED                                      16
#define ECCEN_BXT_P_POST_A0                                17
#define INVPH0TO180_DDR3_VAL                               18
#define SLICE_0_MASTER                                     19
#define SLICE_1_MASTER                                     20
#define GCOMP_CH_EN                                        21
#define ECCEN                                              22
#define TEMPVAR                                            23
#define SS_TEMP_VAR_UPGRP0                                 24
#define SS_TEMP_VAR_DNGRP0                                 25
#define SS_TEMP_VAR_UPGRP1                                 26
#define SS_TEMP_VAR_DNGRP1                                 27
#define SS_TEMP_VAR_UPGRP2                                 28
#define SS_TEMP_VAR_DNGRP2                                 29
#define SS_TEMP_VAR_UPGRP3                                 30
#define SS_TEMP_VAR_DNGRP3                                 31
#define SS_TEMP_VAR_UPGRP4                                 32
#define SS_TEMP_VAR_DNGRP4                                 33
#define SS_TEMP_VAR_UPGRP5                                 34
#define SS_TEMP_VAR_DNGRP5                                 35
#define DRAMDEVICE_PR                                      36
#define ADDRDEC                                            37
#define CASWIZZLE                                          38
#define TCKSRX                                             39
#define TXSDLL                                             40
#define TXSR                                               41
#define TRCD                                               42
#define TRPPB                                              43
#define DDEN                                               44
#define DWID                                               45
#define RANK0_ENABLED                                      46
#define TXP                                                47
#define TZQCL                                              48
#define TZQCS                                              49
#define TZQLAT                                             50
#define NRFCAB                                             51
#define TCKE                                               52
#define NREFI                                              53
#define TRTP                                               54
#define TWTP                                               55
#define TCWL                                               56
#define TCCDMW                                             57
#define TFAW                                               58
#define TWRDR                                              59
#define TRWDR                                              60
#define TWWDR                                              61
#define TRRDR                                              62
#define TRRD                                               63
#define TDERATE_INC                                        64
#define TWWSR                                              65
#define TRRSR                                              66
#define TWRSR                                              67
#define TRWSR                                              68
#define TCKCKEL                                            69
#define MNTDLY                                             70
#define TPSTMRRBLK                                         71
#define TPREMRBLK                                          72
#define TRPAB                                              73
#define TPSTMRWBLK                                         74
#define TWRPDEN                                            75
#define TRDPDEN                                            76
#define TRAS                                               77
#define TCKESR                                             78
#define LPMDRES                                            79
#define TLPCKDLY                                           80
#define TCKLPDLY                                           81
#define PWDDLY                                             82
#define SSKPD0                                             83
#define SSKPD1                                             84
#define BONUS0                                             85
#define BONUS1                                             86
#define MR4_BIT2_SEL                                       87
#define MR4_BIT1_SEL                                       88
#define MR4_BIT0_SEL                                       89
#define MR4_BYTE_SEL                                       90
#define MR4_BIT0_SEL2                                      91
#define MR4_BIT1_SEL2                                      92
#define MR4_BIT2_SEL2                                      93
#define MR4_BYTE_SEL2                                      94
#define WRODTSTOP                                          95
#define RDODTSTART                                         96
#define R0WRODTCTL                                         97
#define R1WRODTCTL                                         98
#define R0RDODTCTL                                         99
#define R1RDODTCTL                                         100
#define CKEVAL_VAR                                         101
#define SPIDCMDCLK_RATIO                                   102
#define SPIDDATA_RATIO_WIO2                                103
#define MINREFRATE                                         104
#define REFWMPNC                                           105
#define REFWMHI                                            106
#define BAHEN                                              107
#define RSIEN                                              108
#define CMDTRIST                                           109
#define PCLSTO                                             110
#define BLKRDBF_ADD_RDDATA                                 111
#define BLKRDBF                                            112
#define SPID_EARLY_RDDATA_VALID                            113
#define BGF_EARLY_RDDATA_VALID                             114
#define PATTERN_CMDSPID_TO_SABY2_TSVS                      115
#define PATTERN_SABY2_TO_CMDSPID_TSVS                      116
#define INIT_CMDSPID_TO_SABY2_TSVS                         117
#define INIT_SABY2_TO_CMDSPID_TSVS                         118
#define PATTERN_DATASPID_TO_SABY2_TSVS                     119
#define PATTERN_SABY2_TO_DATASPID_TSVS                     120
#define INIT_DATASPID_TO_SABY2_TSVS                        121
#define INIT_SABY2_TO_DATASPID_TSVS                        122
#define TQPOLLPER                                          123
#define SRTEN                                              124
#define MR_VALUE                                           125
#define SACLKBY2_RATIO                                     126
#define BXT_A0_WA                                          127
#define DQS_RETRAIN_INT                                    128
#define DQS_OSC_RT                                         129
#define MUX_MAX                                            130
#define MUX_MIN                                            131
#define FINE_MAX                                           132
#define FINE_MIN                                           133
#define COARSE_MAX                                         134
#define COARSE_MIN                                         135
#define FINE_SOFT_MAX                                      136
#define FINE_SOFT_MIN                                      137
#define SS_TEMP_VAR                                        138
#define WEAK_ODT_CONFIG                                    139
#define FUSESTAT                                           140
#define SCRAMBLER_KEY                                      141
#define MCHBAR                                             142
#define P2SBBAR                                            143
#define ECBASE_LO                                          144
#define ECBASE_EN                                          145
#define ECBASE_HI                                          146
#define SYM_SLICE1_CHANNEL_ENABLED                         147
#define SYM_SLICE0_CHANNEL_ENABLED                         148
#define SLICE_1_DISABLED                                   149
#define SLICE_0_MEM_DISABLED                               150
#define CHANNEL_HASH_MASK                                  151
#define AUNIT_INTERLEAVED_MODE                             152
#define SLICE_HASH_MASK                                    153
#define SLICE0_ASYM_ENABLE                                 154
#define SLICE0_ASYM_CHANNEL_SELECT                         155
#define SLICE0_ASYM_LIMIT                                  156
#define SLICE0_ASYM_BASE                                   157
#define SLICE1_ASYM_ENABLE                                 158
#define SLICE1_ASYM_CHANNEL_SELECT                         159
#define SLICE1_ASYM_LIMIT                                  160
#define SLICE1_ASYM_BASE                                   161
#define ASYM_2WAY_INTERLEAVE_ENABLE                        162
#define ASYM_2WAY_LIMIT                                    163
#define ASYM_2WAY_BASE                                     164
#define ASYM_2WAY_INTLV_MODE                               165
#define DDR_CONFIG_LIMITATION                              166
#define SABY2CLK                                           167
#define S0_Fixes0                                          168
#define CMD_RDPTROFFSET_ADJUST                             169
#define WRLVLMODEVAR                                       170
#define CC_DQS_OVR_VAL                                     171
#define CC_DQS_OVR_SEL                                     172
#define CC_DQDM_OVR_VAL                                    173
#define CC_DQDM_OVR_SEL                                    174
#define BL_DQS_OVR_VAL                                     175
#define BL_DQS_OVR_SEL                                     176
#define BL_DQDM_OVR_VAL                                    177
#define BL_DQDM_OVR_SEL                                    178
#define DQDM_OVR_SEL_ECC                                   179
#define DQS_OVR_SEL_ECC                                    180
#define DQDM_OVR_ECC                                       181
#define DQS_OVR_ECC                                        182
#define DRAM_CMD_BL                                        183
#define RANK                                               184
#define RDDCMD                                             185
#define REG_DATA                                           186
#define ERROR_STATUS                                       187
#define CHUNK_ERR_MASK                                     188
#define CHUNK_ERR_MASK_LP                                  189
#define BYTEGRP_ERR_STAT                                   190
#define CHUNK_ERR_STAT                                     191
#define LANE_ERR_STAT_LO                                   192
#define LANE_ERR_STAT_HI                                   193
#define ECC_ERR_STAT                                       194
#define ECC_LANE_ERR_STAT                                  195
#define ERR_COUNT0                                         196
#define ERR_COUNT1                                         197
#define ERR_COUNT2                                         198
#define ERR_COUNT3                                         199
#define ERR_COUNT4                                         200
#define ERR_COUNT5                                         201
#define ERR_COUNT6                                         202
#define ERR_COUNT7                                         203
#define ERR_COUNT8                                         204
#define NUM_BURSTS_EXP                                     205
#define NUM_LOOPS_EXP                                      206
#define LANE_ROTATE_RATE                                   207
#define RELOAD_LFSR_SEED_RATE                              208
#define SAVE_LFSR_SEED_RATE                                209
#define RANK_INDEX                                         210
#define TARGET_BANK                                        211
#define TARGET_RANK                                        212
#define ROW_COL_ADDR                                       213
#define NUM_COLS                                           214
#define NUM_ROWS                                           215
#define ADD_ROTATE_RPT                                     216
#define CADB_BUFA0_BANK                                    217
#define CADB_BUFA0_ROW_COL                                 218
#define CADB_BUFA1_BANK                                    219
#define CADB_BUFA1_ROW_COL                                 220
#define CADB_BUFA2_BANK                                    221
#define CADB_BUFA2_ROW_COL                                 222
#define CADB_BUFA3_BANK                                    223
#define CADB_BUFA3_ROW_COL                                 224
#define CADB_BUFA4_BANK                                    225
#define CADB_BUFA4_ROW_COL                                 226
#define CADB_BUFA5_BANK                                    227
#define CADB_BUFA5_ROW_COL                                 228
#define CADB_BUFA6_BANK                                    229
#define CADB_BUFA6_ROW_COL                                 230
#define CADB_BUFA7_BANK                                    231
#define CADB_BUFA7_ROW_COL                                 232
#define CADB_BUFB0_CMD                                     233
#define CADB_BUFB1_CMD                                     234
#define CADB_BUFB2_CMD                                     235
#define CADB_BUFB3_CMD                                     236
#define CADB_BUFB4_CMD                                     237
#define CADB_BUFB5_CMD                                     238
#define CADB_BUFB6_CMD                                     239
#define CADB_BUFB7_CMD                                     240
#define AGG_PATTERN                                        241
#define VIC_PATTERN                                        242
#define UNIMODE                                            243
#define PATTERN0                                           244
#define PATTERN1                                           245
#define PATTERN2                                           246
#define INSTR_LAST                                         247
#define INSTR_POINTER                                      248
#define ORIG_WRDQCTL                                       249
#define ORIG_WRDQSCTL_CC                                   250
#define ORIG_WRDQSCTL_BB                                   251
#define ORIG_CC_WRDQCTL                                    252
#define ORIG_CC_WRDQSCTL                                   253
#define CAVREF                                             254
#define ORIG_DQ_WKCTL                                      255
#define ORIG_CC_WKCTL                                      256
#define CC_DQSRXODTENOVRVAL                                257
#define CC_DQSRXODTENOVRSEL                                258
#define CC_RXODTENOVRVAL                                   259
#define CC_RXODTENOVRSEL                                   260
#define RXODTSEGOVRVAL_ecc                                 261
#define RXODTSEGOVRSEL_ecc                                 262
#define BL_DQSRXODTENOVRVAL                                263
#define BL_DQSRXODTENOVRSEL                                264
#define BL_RXODTENOVRVAL                                   265
#define BL_RXODTENOVRSEL                                   266
#define LVL_CC_WEAKPUPSTATIC                               267
#define LVL_CC_WEAKPUP                                     268
#define LVL_CC_WEAKPDNSTATIC                               269
#define LVL_CC_WEAKPDN                                     270
#define LVL_BL_WEAKPUPSTATIC                               271
#define LVL_BL_WEAKPUP                                     272
#define LVL_BL_WEAKPDNSTATIC                               273
#define LVL_BL_WEAKPDN                                     274
#define RCOMP_Up_GRP0_dq0                                  275
#define RCOMP_Dn_GRP0_dq0                                  276
#define RCOMP_Up_GRP1_dq0                                  277
#define RCOMP_Dn_GRP1_dq0                                  278
#define RCOMP_Up_GRP0_dq1                                  279
#define RCOMP_Dn_GRP0_dq1                                  280
#define RCOMP_Up_GRP1_dq1                                  281
#define RCOMP_Dn_GRP1_dq1                                  282
#define RCOMP_Up_GRP0_dq2                                  283
#define RCOMP_Dn_GRP0_dq2                                  284
#define RCOMP_Up_GRP1_dq2                                  285
#define RCOMP_Dn_GRP1_dq2                                  286
#define RCOMP_Up_GRP0_dq3                                  287
#define RCOMP_Dn_GRP0_dq3                                  288
#define RCOMP_Up_GRP1_dq3                                  289
#define RCOMP_Dn_GRP1_dq3                                  290
#define RCOMP_Up_GRP0                                      291
#define RCOMP_Dn_GRP0                                      292
#define RCOMP_Up_GRP1                                      293
#define RCOMP_Dn_GRP1                                      294
#define RCOMP_Up_GRP2                                      295
#define RCOMP_Dn_GRP2                                      296
#define RCOMP_Up_GRP3                                      297
#define RCOMP_Dn_GRP3                                      298
#define RCOMP_Up_GRP4                                      299
#define RCOMP_Dn_GRP4                                      300
#define RCOMP_Up_GRP5                                      301
#define RCOMP_Dn_GRP5                                      302
#define RCOMP_OVR_Up_En                                    303
#define RCOMP_OVR_Dn_En                                    304
#define RCOMP_OVR_Up_En_dq                                 305
#define RCOMP_OVR_Dn_En_dq                                 306
#define RCOMP_Seg_Ovr_Val_bl                               307
#define RCOMP_Seg_Ovr_En_bl                                308
#define DIFF_Ovr_Val_bl                                    309
#define DIFF_Ovr_Val_sel_bl                                310
#define comp_vref_0                                        311
#define comp_vref_1                                        312
#define comp_vref_2                                        313
#define comp_vref_3                                        314
#define comp_vref_4                                        315
#define comp_vref_5                                        316
#define RX_ODTEN_OVR_SEL_bl                                317
#define RX_ODTEN_OVR_VAL_bl                                318
#define ECC_RX_ODTEN_OVR_SEL_bl                            319
#define ECC_RX_ODTEN_OVR_VAL_bl                            320
#define RXBLVREFCTL                                        321
#define VOC_LDO_ENABLE                                     322
#define VOC_RCOMP_PUP                                      323
#define VOC_RCOMP_PDN                                      324
#define TQPOLLEN_SAVE                                      325
#define SRXZQC_SAVE                                        326
#define ZQDIS_SAVE                                         327
#define OREFDIS_SAVE                                       328
#define DYNSREN_SAVE                                       329
#define DISPWRDN_SAVE                                      330
#define DQS_RETAIN_EN_SAVE                                 331
#define RDCMD2RDVLD                                        332
#define PTLDCODE                                           333
#define MR0_0                                              334
#define MR1_0                                              335
#define MR2_0                                              336
#define MR0_1                                              337
#define MR1_1                                              338
#define MR2_1                                              339
#define DYNVAR_MAX                                         340
#endif // MEM_SV_HOOKS

#include "DQ.h"
#include "DUNIT.h"
#include "CCC.h"
#include "DQDPIC.h"
#include "DPIC.h"
#include "DQDPLVUG.h"
#include "ADPLL.h"
#include "CPGC.h"
#include "LDO.h"
#include "DPLVUG.h"
#include "SAI.h"
#include "MLMC.h"
#include "P2SB.h"
#include "AUNIT.h"
#include "BUNIT.h"
#include "CUNIT.h"
#include "PUNIT.h"


#endif // _MMRCPROJECTDEFINITIONSGENERATED_H_
