/** @file
  EvTools.c
  Rank Margin EV Tools, these file is independent of the project.

@copyright
 Copyright (c) 2005 - 2015 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains an 'Intel Peripheral Driver' and is uniquely
 identified as "Intel Reference Module" and is licensed for Intel
 CPUs and chipsets under the terms of your license agreement with
 Intel or your vendor. This file may be modified by the user, subject
 to additional terms of the license agreement.

@par Specification Reference:
**/
#include "MmrcLibraries.h"
#include "MmrcHooks.h"


#if SIM || JTAG
MMRC_DATA *MyMrcData;
#endif

/**
  Executes the Rank Margin Tool

  @param[in, out]  MrcData             Host structure for all data related to MMRC.
  @param[in]       CapsuleStartIndex   Starting point within the CapsuleData structure
                                       where the Init should begin.
  @param[in]       StringIndex         When provided, this is the index into the string
                                       table to show the register names.
  @param[in]       Channel             Current Channel being examined

  @retval          MMRC_SUCCESS
**/
MMRC_STATUS
EvToolsMain (
  IN  OUT MMRC_DATA         *MrcData,
  IN      UINT16            CapsuleStartIndex,
  IN      UINT16            StringIndex,
  IN      UINT8             Channel
  )
{
  return MMRC_SUCCESS;
}
