/** @file
  File name:    BUNIT_BOXTYPE.h
  Input File:   GLK_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in BUNIT_BOXTYPE.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _BUNIT_BOXTYPE_H_
#define _BUNIT_BOXTYPE_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define B_CR_BMISC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG          0x00006800
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When this bit is set, reads targeting Esegment are routed to DRAM. Esegment corresponds
    // to the memory range 0xE_0000 to 0xE_FFFF.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX read_eseg_from_dram : 1;
    //
    // When this bit is set, reads targeting Fsegment are routed to DRAM. Fsegment corresponds
    // to the memory range 0xF_0000 to 0xF_FFFF.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX read_fseg_from_dram : 1;
    //
    // When this bit is set, reads and writes targeting A or Bsegments are routed to
    // DRAM. Asegment corresponds to the memory range 0xA_0000 to 0xA_FFFF. Bsegment
    // corresponds to the memory ranges 0xB_0000 to 0xB_7FFF and 0xB_8000 to 0xB_FFFF.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX absegindram : 1;
    //
    // When set,IA accesses to 0xFFFF_0000 to 0XFFFF_FFFF will be sent to memory, regardless
    // of the Host IO Boundary setting in TOLUD.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX send_boot_vector_to_dram : 1;
    //
    // Reserved.
    //
    // Bits[31:4], RO, default = 0x0
    //
    UINTX reserved_0 : 28;
  } Bits;
  UINTX Data;
} B_CR_BMISC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_SECURITY_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG    0x00006808
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIARAC, BIAWAC
    // and BIACP registers, based on the value from each agent's 6bit SAI field.
    //
    // Bits[63:0], RO, default = 0x0
    //
    UINTX sec_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_SECURITY_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_SECURITY_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG   0x00006810
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the B-Unit
    // Security Group Configuration registers based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[63:0], RO, default = 0xC0061010202
    //
    UINTX sec_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_SECURITY_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_SECURITY_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG   0x00006818
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the B-Unit
    // Security Group Configuration registers, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[63:0], RO, default = 0xC0061010202
    //
    UINTX sec_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_SECURITY_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MEM_ACCESS_COUNT_SLICE0_BUNIT_BOXTYPE_REG     0x00006868
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Counts the number of PMI transactions that the B-Unit has sent to any PMI channel.
    // Counts both reads and writes. Counter is not saturating and will roll over to
    // zero. It is up to the consumer of the counter to handle roll over cases.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX mem_access_count : 32;
  } Bits;
  UINTX Data;
} B_CR_MEM_ACCESS_COUNT_SLICE0_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MEM_ACCESS_COUNT_SLICE1_BUNIT_BOXTYPE_REG     0x0000686C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Counts the number of PMI transactions that the B-Unit has sent to any PMI channel.
    // Counts both reads and writes. Counter is not saturating and will roll over to
    // zero. It is up to the consumer of the counter to handle roll over cases.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX mem_access_count : 32;
  } Bits;
  UINTX Data;
} B_CR_MEM_ACCESS_COUNT_SLICE1_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006870
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR0 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR0MASK[28:0] applied to bits 38:10
    // of the incoming address, to determine if an access falls within the IMR0 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr0_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR0BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006874
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR0BASE[28:0] value. A match indicates that the incoming
    // address falls within the IMR0 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr0_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables return to the requester of implicit writeback HITM data from GT.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR0MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x00006878
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR0RAC,
    // BIMR0WAC and BIMR0CP registers based on the value from each agent's 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr0_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR0CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006880
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr0_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr0_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr0_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr0_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr0_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr0_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr0_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr0_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr0_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr0_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr0_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr0_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr0_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr0_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr0_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr0_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr0_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr0_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr0_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr0_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr0_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr0_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr0_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr0_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr0_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr0_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr0_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr0_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr0_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr0_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr0_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr0_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr0_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr0_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr0_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr0_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr0_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr0_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr0_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr0_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr0_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr0_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr0_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr0_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr0_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr0_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr0_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr0_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr0_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr0_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr0_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr0_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr0_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr0_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr0_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr0_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr0_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr0_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr0_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr0_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr0_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr0_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr0_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr0_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR0RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR0WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006888
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr0_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr0_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr0_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr0_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr0_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr0_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr0_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr0_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr0_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr0_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr0_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr0_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr0_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr0_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr0_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr0_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr0_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr0_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr0_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr0_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr0_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr0_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr0_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr0_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr0_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr0_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr0_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr0_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr0_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr0_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr0_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr0_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr0_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr0_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr0_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr0_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr0_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr0_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr0_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr0_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr0_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr0_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr0_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr0_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr0_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr0_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr0_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr0_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr0_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr0_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr0_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr0_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr0_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr0_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr0_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr0_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr0_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr0_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr0_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr0_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr0_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr0_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr0_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR0
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr0_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR0WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006890
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR1 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR1MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR1 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr1_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Asset Classification AC[0]: Enables snooping of transactions to the IMR region
    // by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR1BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006894
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR1BASE[28:0] value. A match indicates that the incoming
    // address falls within the IMR1 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr1_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Asset Classification AC[2]: Enables implicit writebacks to protected region from
    // GT caching agent. When set to 1, enables return to the requester of implicit writeback
    // HITM data from GT. When set to 0, inhibits HITM data from GT from being returned
    // to the requester. HITM data from IA cores may be returned to the requester depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR1MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x00006898
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR1RAC,
    // BIMR1WAC and BIMR1CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr1_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR1CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000068A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr1_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr1_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr1_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr1_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr1_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr1_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr1_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr1_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr1_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr1_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr1_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr1_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr1_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr1_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr1_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr1_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr1_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr1_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr1_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr1_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr1_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr1_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr1_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr1_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr1_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr1_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr1_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr1_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr1_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr1_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr1_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr1_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr1_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr1_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr1_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr1_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr1_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr1_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr1_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr1_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr1_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr1_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr1_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr1_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr1_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr1_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr1_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr1_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr1_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr1_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr1_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr1_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr1_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr1_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr1_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr1_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr1_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr1_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr1_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr1_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr1_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr1_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr1_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr1_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR1RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR1WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000068A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr1_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr1_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr1_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr1_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr1_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr1_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr1_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr1_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr1_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr1_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr1_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr1_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr1_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr1_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr1_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr1_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr1_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr1_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr1_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr1_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr1_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr1_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr1_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr1_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr1_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr1_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr1_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr1_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr1_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr1_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr1_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr1_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr1_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr1_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr1_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr1_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr1_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr1_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr1_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr1_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr1_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr1_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr1_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr1_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr1_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr1_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr1_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr1_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr1_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr1_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr1_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr1_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr1_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr1_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr1_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr1_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr1_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr1_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr1_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr1_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr1_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr1_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr1_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR1
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr1_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR1WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000068B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR2 region. IMR region size must
    // be a strict power of two, at least 1KB and naturally aligned to the size.  These
    // bits are compared with the result of the IMR2MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR2 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr2_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR2BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000068B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR2BASE[28:0] value. A match indicates that the incoming
    // address falls within the IMR2 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr2_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    //  When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR2MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x000068B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR2RAC,
    // BIMR2WAC and BIMR2CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr2_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR2CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000068C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr2_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr2_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr2_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr2_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr2_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr2_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr2_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr2_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr2_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr2_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr2_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr2_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr2_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr2_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr2_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr2_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr2_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr2_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr2_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr2_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr2_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr2_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr2_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr2_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr2_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr2_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr2_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr2_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr2_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr2_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr2_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr2_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr2_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr2_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr2_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr2_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr2_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr2_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr2_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr2_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr2_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr2_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr2_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr2_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr2_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr2_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr2_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr2_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr2_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr2_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr2_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr2_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr2_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr2_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr2_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr2_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr2_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr2_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr2_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr2_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr2_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr2_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr2_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr2_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR2RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR2WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000068C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr2_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr2_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr2_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr2_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr2_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr2_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr2_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr2_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr2_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr2_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr2_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr2_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr2_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr2_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr2_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr2_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr2_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr2_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr2_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr2_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr2_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr2_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr2_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr2_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr2_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr2_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr2_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr2_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr2_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr2_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr2_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr2_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr2_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr2_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr2_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr2_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr2_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr2_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr2_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr2_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr2_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr2_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr2_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr2_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr2_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr2_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr2_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr2_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr2_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr2_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr2_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr2_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr2_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr2_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr2_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr2_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr2_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr2_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr2_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr2_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr2_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr2_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr2_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR2
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr2_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR2WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000068D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR3 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR3MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR3 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr3_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR3BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000068D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR3BASE[28:0] value. A match indicates that the incoming
    // address falls within the IMR3 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr3_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester.  When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    //  When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR3MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x000068D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR3RAC,
    // BIMR3WAC and BIMR3CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr3_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR3CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000068E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr3_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr3_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr3_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr3_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr3_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr3_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr3_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr3_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr3_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr3_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr3_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr3_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr3_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr3_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr3_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr3_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr3_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr3_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr3_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr3_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr3_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr3_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr3_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr3_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr3_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr3_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr3_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr3_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr3_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr3_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr3_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr3_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr3_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr3_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr3_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr3_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr3_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr3_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr3_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr3_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr3_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr3_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr3_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr3_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr3_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr3_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr3_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr3_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr3_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr3_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr3_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr3_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr3_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr3_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr3_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr3_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr3_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr3_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr3_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr3_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr3_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr3_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr3_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr3_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR3RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR3WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000068E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr3_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr3_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr3_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr3_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr3_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr3_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr3_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr3_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr3_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr3_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr3_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr3_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr3_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr3_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr3_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr3_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr3_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr3_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr3_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr3_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr3_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr3_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr3_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr3_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr3_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr3_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr3_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr3_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr3_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr3_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr3_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr3_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr3_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr3_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr3_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr3_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr3_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr3_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr3_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr3_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr3_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr3_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr3_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr3_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr3_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr3_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr3_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr3_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr3_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr3_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr3_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr3_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr3_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr3_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr3_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr3_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr3_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr3_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr3_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr3_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr3_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr3_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr3_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR3
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr3_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR3WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000068F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR4 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR4MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR4 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr4_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR4BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000068F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR4BASE[28:0] value. A match indicates that the incoming
    // address falls within the IMR4 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr4_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester, depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR4MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x000068F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR4RAC,
    // BIMR4WAC and BIMR4CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr4_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR4CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006900
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr4_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr4_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr4_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr4_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr4_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr4_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr4_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr4_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr4_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr4_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr4_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr4_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr4_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr4_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr4_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr4_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr4_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr4_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr4_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr4_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr4_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr4_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr4_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr4_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr4_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr4_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr4_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr4_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr4_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr4_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr4_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr4_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr4_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr4_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr4_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr4_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr4_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr4_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr4_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr4_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr4_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr4_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr4_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr4_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr4_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr4_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr4_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr4_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr4_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr4_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr4_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr4_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr4_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr4_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr4_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr4_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr4_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr4_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr4_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr4_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr4_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr4_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr4_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR4
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr4_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR4RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR4WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006908
#ifndef ASM_INC
typedef union {
  struct {
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr4_write_pol_0 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr4_write_pol_1 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr4_write_pol_2 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr4_write_pol_3 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr4_write_pol_4 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr4_write_pol_5 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr4_write_pol_6 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr4_write_pol_7 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr4_write_pol_8 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr4_write_pol_9 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr4_write_pol_10 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr4_write_pol_11 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr4_write_pol_12 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr4_write_pol_13 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr4_write_pol_14 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr4_write_pol_15 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr4_write_pol_16 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr4_write_pol_17 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr4_write_pol_18 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr4_write_pol_19 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr4_write_pol_20 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr4_write_pol_21 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr4_write_pol_22 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr4_write_pol_23 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr4_write_pol_24 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr4_write_pol_25 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr4_write_pol_26 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr4_write_pol_27 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr4_write_pol_28 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr4_write_pol_29 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr4_write_pol_30 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr4_write_pol_31 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr4_write_pol_32 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr4_write_pol_33 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr4_write_pol_34 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr4_write_pol_35 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr4_write_pol_36 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr4_write_pol_37 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr4_write_pol_38 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr4_write_pol_39 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr4_write_pol_40 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr4_write_pol_41 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr4_write_pol_42 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr4_write_pol_43 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr4_write_pol_44 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr4_write_pol_45 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr4_write_pol_46 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr4_write_pol_47 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr4_write_pol_48 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr4_write_pol_49 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr4_write_pol_50 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr4_write_pol_51 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr4_write_pol_52 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr4_write_pol_53 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr4_write_pol_54 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr4_write_pol_55 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr4_write_pol_56 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr4_write_pol_57 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr4_write_pol_58 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr4_write_pol_59 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr4_write_pol_60 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr4_write_pol_61 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr4_write_pol_62 : 1;
    //
    // B-Unit IMR4 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR4 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr4_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR4WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006910
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR5 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR5MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR5 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr5_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR5BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006914
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR5BASE[28:0] value. A match indicates that the incoming
    // address falls within the IMR5 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr5_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester, depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR5MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x00006918
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR5RAC,
    // BIMR5WAC and BIMR5CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr5_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR5CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006920
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr5_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr5_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr5_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr5_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr5_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr5_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr5_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr5_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr5_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr5_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr5_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr5_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr5_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr5_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr5_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr5_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr5_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr5_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr5_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr5_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr5_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr5_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr5_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr5_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr5_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr5_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr5_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr5_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr5_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr5_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr5_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr5_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr5_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr5_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr5_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr5_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr5_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr5_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr5_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr5_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr5_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr5_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr5_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr5_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr5_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr5_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr5_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr5_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr5_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr5_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr5_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr5_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr5_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr5_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr5_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr5_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr5_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr5_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr5_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr5_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr5_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr5_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr5_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr5_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR5RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR5WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006928
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr5_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr5_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr5_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr5_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr5_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr5_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr5_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr5_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr5_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr5_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr5_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr5_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr5_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr5_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr5_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr5_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr5_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr5_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr5_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr5_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr5_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr5_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr5_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr5_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr5_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr5_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr5_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr5_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr5_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr5_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr5_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr5_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr5_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr5_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr5_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr5_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr5_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr5_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr5_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr5_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr5_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr5_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr5_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr5_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr5_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr5_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr5_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr5_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr5_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr5_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr5_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr5_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr5_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr5_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr5_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr5_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr5_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr5_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr5_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr5_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr5_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr5_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr5_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR5
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr5_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR5WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006930
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR6 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR6MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR6 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr6_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR6BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006934
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR6BASE[28:0] value. A match indicates that the incoming
    // address falls within the IMR6 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr6_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester, depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR6MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x00006938
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR6RAC,
    // BIMR6WAC, BIMR6CP registers, based on the value from each agent's 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr6_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR6CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006940
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr6_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr6_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr6_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr6_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr6_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr6_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr6_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr6_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr6_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr6_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr6_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr6_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr6_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr6_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr6_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr6_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr6_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr6_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr6_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr6_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr6_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr6_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr6_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr6_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr6_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr6_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr6_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr6_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr6_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr6_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr6_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr6_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr6_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr6_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr6_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr6_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr6_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr6_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr6_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr6_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr6_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr6_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr6_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr6_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr6_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr6_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr6_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr6_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr6_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr6_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr6_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr6_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr6_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr6_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr6_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr6_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr6_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr6_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr6_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr6_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr6_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr6_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr6_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr6_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR6RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR6WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006948
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr6_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr6_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr6_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr6_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr6_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr6_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr6_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr6_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr6_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr6_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr6_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr6_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr6_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr6_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr6_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr6_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr6_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr6_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr6_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr6_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr6_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr6_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr6_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr6_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr6_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr6_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr6_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr6_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr6_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr6_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr6_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr6_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr6_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr6_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr6_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr6_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr6_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr6_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr6_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr6_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr6_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr6_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr6_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr6_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr6_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr6_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr6_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr6_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr6_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr6_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr6_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr6_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr6_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr6_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr6_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr6_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr6_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr6_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr6_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr6_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr6_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr6_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr6_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR6
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr6_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR6WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006950
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR7 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR7MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR7 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr7_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR7BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006954
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR7BASE[28:0] value. A match indicates that the incoming
    // address falls within the IMR7 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr7_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester, depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR7MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x00006958
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR7RAC,
    // BIMR7WAC and BIMR7CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr7_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR7CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006960
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr7_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr7_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr7_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr7_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr7_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr7_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr7_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr7_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr7_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr7_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr7_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr7_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr7_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr7_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr7_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr7_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr7_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr7_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr7_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr7_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr7_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr7_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr7_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr7_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr7_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr7_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr7_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr7_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr7_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr7_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr7_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr7_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr7_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr7_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr7_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr7_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr7_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr7_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr7_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr7_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr7_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr7_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr7_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr7_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr7_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr7_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr7_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr7_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr7_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr7_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr7_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr7_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr7_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr7_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr7_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr7_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr7_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr7_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr7_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr7_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr7_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr7_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr7_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr7_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR7RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR7WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006968
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr7_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr7_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr7_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr7_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr7_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr7_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr7_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr7_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr7_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr7_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr7_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr7_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr7_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr7_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr7_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr7_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr7_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr7_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr7_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr7_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr7_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr7_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr7_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr7_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr7_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr7_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr7_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr7_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr7_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr7_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr7_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr7_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr7_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr7_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr7_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr7_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr7_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr7_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr7_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr7_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr7_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr7_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr7_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr7_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr7_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr7_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr7_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr7_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr7_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr7_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr7_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr7_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr7_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr7_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr7_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr7_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr7_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr7_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr7_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr7_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr7_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr7_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr7_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR7
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr7_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR7WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006970
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR8 region. IMR region size must
    // be a strict power of two at least 1KB and naturally aligned to the size. These
    // bits are compared with the result of the IMR8MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR8 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr8_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR8BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006974
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR8BASE[28:0] value.  A match indicates that the
    // incoming address falls within the IMR8 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr8_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    //  When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR8MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x00006978
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR8RAC,
    // BIMR8WAC and BIMR8CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr8_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR8CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006980
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr8_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr8_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr8_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr8_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr8_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr8_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr8_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr8_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr8_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr8_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr8_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr8_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr8_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr8_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr8_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr8_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr8_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr8_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr8_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr8_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr8_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr8_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr8_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr8_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr8_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr8_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr8_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr8_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr8_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr8_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr8_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr8_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr8_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr8_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr8_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr8_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr8_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr8_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr8_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr8_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr8_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr8_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr8_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr8_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr8_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr8_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr8_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr8_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr8_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr8_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr8_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr8_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr8_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr8_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr8_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr8_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr8_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr8_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr8_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr8_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr8_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr8_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr8_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr8_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR8RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR8WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006988
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr8_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr8_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr8_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr8_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr8_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr8_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr8_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr8_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr8_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr8_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr8_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr8_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr8_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr8_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr8_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr8_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr8_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr8_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr8_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr8_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr8_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr8_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr8_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr8_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr8_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr8_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr8_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr8_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr8_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr8_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr8_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr8_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr8_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr8_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr8_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr8_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr8_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr8_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr8_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr8_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr8_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr8_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr8_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr8_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr8_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr8_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr8_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr8_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr8_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr8_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr8_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr8_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr8_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr8_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr8_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr8_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr8_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr8_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr8_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr8_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr8_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr8_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr8_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR8
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr8_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR8WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006990
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR9 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR9MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR9 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr9_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR9BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006994
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR9BASE[28:0] value. A match indicates that the incoming
    // address falls within the IMR9 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr9_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback data HITM data from GT to be returned to the
    // requester.  When set to 0, inhibits HITM data from GT from being returned to the
    // requester.  HITM data from IA cores may be returned to the requester depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR9MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x00006998
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR9RAC,
    // BIMR9WAC, BIMR9CP registers based on the value from each agent's 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr9_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR9CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000069A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr9_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr9_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr9_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr9_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr9_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr9_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr9_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr9_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr9_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr9_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr9_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr9_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr9_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr9_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr9_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr9_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr9_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr9_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr9_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr9_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr9_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr9_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr9_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr9_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr9_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr9_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr9_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr9_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr9_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr9_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr9_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr9_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr9_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr9_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr9_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr9_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr9_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr9_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr9_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr9_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr9_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr9_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr9_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr9_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr9_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr9_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr9_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr9_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr9_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr9_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr9_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr9_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr9_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr9_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr9_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr9_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr9_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr9_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr9_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr9_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr9_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr9_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr9_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr9_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR9RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR9WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000069A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr9_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr9_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr9_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr9_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr9_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr9_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr9_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr9_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr9_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr9_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr9_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr9_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr9_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr9_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr9_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr9_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr9_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr9_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr9_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr9_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr9_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr9_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr9_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr9_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr9_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr9_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr9_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr9_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr9_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr9_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr9_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr9_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr9_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr9_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr9_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr9_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr9_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr9_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr9_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr9_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr9_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr9_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr9_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr9_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr9_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr9_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr9_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr9_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr9_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr9_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr9_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr9_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr9_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr9_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr9_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr9_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr9_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr9_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr9_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr9_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr9_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr9_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr9_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR9
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr9_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR9WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x000069B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR10 region.  IMR region size must
    // be a strict power of two at least 1KB and naturally aligned to the size.  These
    // bits are compared with the result of the IMR10MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR10 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr10_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR10BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x000069B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR10BASE[28:0] value.  A match indicates that the
    // incoming address falls within the IMR10 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr10_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent.  When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester.  When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester.  HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback data HITM data from GT to be returned to the
    // requester. When set to 0, inhibits HITM data from GT from being returned to the
    // requester. HITM data from IA cores may be returned to the requester depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR10MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000069B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR10RAC,
    // BIMR10WAC and BIMR10CP, registers based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr10_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR10CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000069C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr10_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr10_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr10_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr10_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr10_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr10_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr10_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr10_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr10_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr10_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr10_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr10_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr10_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr10_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr10_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr10_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr10_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr10_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr10_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr10_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr10_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr10_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr10_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr10_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr10_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr10_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr10_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr10_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr10_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr10_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr10_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr10_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr10_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr10_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr10_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr10_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr10_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr10_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr10_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr10_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr10_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr10_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr10_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr10_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr10_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr10_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr10_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr10_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr10_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr10_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr10_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr10_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr10_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr10_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr10_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr10_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr10_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr10_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr10_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr10_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr10_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr10_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr10_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr10_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR10RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR10WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000069C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr10_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr10_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr10_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr10_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr10_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr10_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr10_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr10_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr10_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr10_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr10_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr10_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr10_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr10_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr10_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr10_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr10_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr10_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr10_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr10_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr10_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr10_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr10_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr10_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr10_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr10_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr10_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr10_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr10_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr10_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr10_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr10_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr10_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr10_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr10_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr10_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr10_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr10_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr10_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr10_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr10_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr10_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr10_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr10_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr10_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr10_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr10_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr10_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr10_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr10_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr10_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr10_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr10_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr10_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr10_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr10_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr10_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr10_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr10_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr10_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr10_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr10_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr10_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR10
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr10_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR10WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x000069D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR11 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR11MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR11 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr11_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR11BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x000069D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR11BASE[28:0] value.  A match indicates that the
    // incoming address falls within the IMR11 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr11_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback data HITM data from GT to be returned to the
    // requester. When set to 0, inhibits HITM data from GT from being returned to the
    // requester.  HITM data from IA cores may be returned to the requester, depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR11MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000069D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR11RAC,
    // BIMR11WAC and BIMR11CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr11_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR11CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000069E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr11_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr11_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr11_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr11_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr11_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr11_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr11_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr11_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr11_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr11_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr11_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr11_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr11_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr11_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr11_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr11_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr11_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr11_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr11_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr11_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr11_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr11_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr11_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr11_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr11_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr11_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr11_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr11_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr11_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr11_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr11_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr11_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr11_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr11_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr11_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr11_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr11_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr11_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr11_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr11_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr11_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr11_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr11_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr11_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr11_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr11_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr11_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr11_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr11_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr11_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr11_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr11_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr11_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr11_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr11_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr11_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr11_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr11_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr11_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr11_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr11_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr11_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr11_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr11_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR11RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR11WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x000069E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr11_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr11_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr11_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr11_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr11_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr11_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr11_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr11_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr11_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr11_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr11_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr11_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr11_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr11_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr11_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr11_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr11_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr11_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr11_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr11_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr11_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr11_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr11_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr11_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr11_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr11_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr11_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr11_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr11_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr11_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr11_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr11_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr11_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr11_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr11_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr11_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr11_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr11_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr11_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr11_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr11_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr11_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr11_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr11_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr11_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr11_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr11_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr11_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr11_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr11_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr11_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr11_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr11_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr11_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr11_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr11_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr11_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr11_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr11_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr11_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr11_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr11_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr11_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR11
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr11_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR11WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x000069F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR12 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR12MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR12 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr12_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR12BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x000069F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR12BASE[28:0] value. A match indicates that the
    // incoming address falls within the IMR12 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr12_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester, depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR12MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x000069F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR12RAC,
    // BIMR12WAC and BIMR12CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr12_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR12CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A00
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr12_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr12_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr12_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr12_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr12_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr12_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr12_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr12_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr12_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr12_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr12_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr12_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr12_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr12_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr12_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr12_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr12_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr12_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr12_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr12_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr12_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr12_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr12_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr12_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr12_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr12_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr12_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr12_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr12_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr12_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr12_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr12_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr12_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr12_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr12_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr12_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr12_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr12_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr12_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr12_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr12_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr12_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr12_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr12_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr12_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr12_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr12_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr12_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr12_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr12_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr12_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr12_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr12_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr12_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr12_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr12_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr12_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr12_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr12_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr12_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr12_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr12_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr12_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr12_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR12RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR12WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A08
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr12_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr12_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr12_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr12_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr12_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr12_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr12_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr12_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr12_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr12_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr12_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr12_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr12_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr12_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr12_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr12_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr12_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr12_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr12_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr12_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr12_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr12_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr12_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr12_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr12_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr12_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr12_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr12_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr12_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr12_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr12_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr12_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr12_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr12_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr12_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr12_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr12_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr12_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr12_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr12_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr12_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr12_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr12_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr12_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr12_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr12_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr12_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr12_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr12_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr12_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr12_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr12_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr12_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr12_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr12_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr12_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr12_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr12_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr12_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr12_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr12_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr12_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr12_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR12
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr12_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR12WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A10
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR13 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR13MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR13 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr13_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR13BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A14
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR13BASE[28:0] value. A match indicates that the
    // incoming address falls within the IMR13 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr13_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent.  When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester.  When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester.  HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR13MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006A18
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR13RAC,
    // BIMR13WAC and BIMR13CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr13_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR13CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A20
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr13_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr13_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr13_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr13_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr13_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr13_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr13_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr13_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr13_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr13_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr13_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr13_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr13_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr13_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr13_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr13_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr13_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr13_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr13_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr13_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr13_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr13_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr13_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr13_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr13_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr13_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr13_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr13_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr13_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr13_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr13_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr13_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr13_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr13_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr13_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr13_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr13_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr13_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr13_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr13_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr13_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr13_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr13_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr13_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr13_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr13_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr13_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr13_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr13_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr13_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr13_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr13_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr13_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr13_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr13_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr13_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr13_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr13_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr13_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr13_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr13_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr13_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr13_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr13_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR13RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR13WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A28
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr13_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr13_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr13_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr13_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr13_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr13_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr13_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr13_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr13_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr13_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr13_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr13_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr13_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr13_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr13_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr13_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr13_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr13_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr13_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr13_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr13_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr13_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr13_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr13_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr13_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr13_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr13_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr13_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr13_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr13_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr13_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr13_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr13_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr13_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr13_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr13_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr13_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr13_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr13_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr13_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr13_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr13_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr13_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr13_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr13_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr13_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr13_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr13_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr13_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr13_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr13_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr13_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr13_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr13_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr13_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr13_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr13_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr13_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr13_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr13_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr13_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr13_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr13_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR13
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr13_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR13WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A30
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR14 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR14MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR14 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr14_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR14BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A34
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR14BASE[28:0] value. A match indicates that the
    // incoming address falls within the IMR14 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr14_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    //  When set to 0, inhibits HITM data from GT from being returned to the requester.
    //  HITM data from IA cores may be returned to the requester depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR14MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006A38
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR14RAC,
    // BIMR14WAC and BIMR14CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr14_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR14CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A40
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr14_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr14_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr14_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr14_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr14_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr14_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr14_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr14_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr14_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr14_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr14_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr14_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr14_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr14_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr14_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr14_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr14_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr14_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr14_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr14_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr14_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr14_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr14_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr14_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr14_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr14_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr14_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr14_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr14_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr14_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr14_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr14_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr14_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr14_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr14_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr14_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr14_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr14_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr14_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr14_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr14_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr14_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr14_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr14_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr14_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr14_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr14_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr14_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr14_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr14_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr14_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr14_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr14_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr14_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr14_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr14_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr14_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr14_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr14_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr14_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr14_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr14_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr14_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr14_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR14RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR14WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A48
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr14_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr14_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr14_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr14_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr14_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr14_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr14_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr14_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr14_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr14_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr14_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr14_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr14_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr14_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr14_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr14_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr14_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr14_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr14_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr14_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr14_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr14_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr14_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr14_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr14_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr14_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr14_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr14_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr14_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr14_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr14_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr14_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr14_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr14_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr14_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr14_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr14_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr14_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr14_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr14_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr14_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr14_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr14_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr14_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr14_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr14_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr14_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr14_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr14_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr14_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr14_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr14_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr14_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr14_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr14_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr14_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr14_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr14_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr14_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr14_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr14_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr14_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr14_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR14
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr14_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR14WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A50
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR15 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR15MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR15 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr15_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR15BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A54
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR15BASE[28:0] value. A match indicates that the
    // incoming address falls within the IMR15 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr15_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR15MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006A58
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR15RAC,
    // BIMR15WAC and BIMR15CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr15_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR15CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A60
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr15_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr15_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr15_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr15_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr15_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr15_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr15_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr15_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr15_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr15_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr15_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr15_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr15_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr15_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr15_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr15_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr15_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr15_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr15_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr15_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr15_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr15_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr15_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr15_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr15_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr15_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr15_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr15_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr15_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr15_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr15_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr15_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr15_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr15_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr15_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr15_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr15_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr15_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr15_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr15_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr15_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr15_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr15_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr15_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr15_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr15_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr15_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr15_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr15_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr15_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr15_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr15_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr15_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr15_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr15_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr15_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr15_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr15_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr15_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr15_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr15_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr15_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr15_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr15_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR15RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR15WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A68
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr15_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr15_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr15_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr15_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr15_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr15_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr15_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr15_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr15_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr15_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr15_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr15_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr15_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr15_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr15_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr15_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr15_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr15_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr15_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr15_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr15_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr15_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr15_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr15_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr15_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr15_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr15_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr15_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr15_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr15_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr15_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr15_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr15_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr15_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr15_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr15_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr15_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr15_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr15_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr15_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr15_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr15_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr15_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr15_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr15_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr15_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr15_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr15_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr15_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr15_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr15_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr15_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr15_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr15_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr15_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr15_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr15_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr15_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr15_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr15_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr15_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr15_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr15_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR15
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr15_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR15WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A70
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR16 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR16MASK[28:0] applied to bits 38:10
    // of the incoming address, to determine if an access falls within the IMR16 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr16_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR16BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A74
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR16BASE[28:0] value.  A match indicates that the
    // incoming address falls within the IMR16 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr16_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester.  HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback data HITM data from GT to be returned to the
    // requester. When set to 0, inhibits HITM data from GT from being returned to the
    // requester. HITM data from IA cores may be returned to the requester, depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR16MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006A78
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR16RAC,
    // BIMR16WAC and BIMR16CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr16_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR16CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A80
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr16_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr16_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr16_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr16_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr16_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr16_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr16_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr16_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr16_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr16_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr16_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr16_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr16_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr16_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr16_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr16_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr16_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr16_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr16_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr16_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr16_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr16_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr16_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr16_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr16_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr16_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr16_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr16_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr16_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr16_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr16_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr16_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr16_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr16_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr16_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr16_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr16_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr16_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr16_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr16_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr16_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr16_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr16_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr16_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr16_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr16_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr16_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr16_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr16_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr16_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr16_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr16_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr16_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr16_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr16_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr16_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr16_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr16_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr16_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr16_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr16_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr16_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr16_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr16_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR16RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR16WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006A88
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr16_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr16_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr16_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr16_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr16_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr16_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr16_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr16_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr16_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr16_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr16_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr16_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr16_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr16_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr16_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr16_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr16_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr16_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr16_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr16_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr16_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr16_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr16_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr16_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr16_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr16_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr16_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr16_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr16_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr16_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr16_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr16_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr16_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr16_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr16_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr16_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr16_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr16_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr16_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr16_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr16_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr16_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr16_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr16_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr16_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr16_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr16_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr16_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr16_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr16_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr16_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr16_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr16_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr16_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr16_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr16_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr16_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr16_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr16_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr16_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr16_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr16_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr16_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR16
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr16_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR16WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A90
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR17 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR17MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR17 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr17_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR17BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006A94
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR17BASE[28:0] value. A match indicates that the
    // incoming address falls within the IMR17 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr17_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent.  When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester.  When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester.  HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester, depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR17MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006A98
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR17RAC,
    // BIMR17WAC and  BIMR17CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr17_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR17CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006AA0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr17_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr17_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr17_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr17_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr17_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr17_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr17_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr17_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr17_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr17_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr17_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr17_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr17_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr17_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr17_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr17_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr17_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr17_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr17_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr17_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr17_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr17_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr17_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr17_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr17_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr17_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr17_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr17_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr17_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr17_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr17_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr17_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr17_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr17_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr17_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr17_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr17_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr17_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr17_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr17_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr17_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr17_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr17_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr17_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr17_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr17_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr17_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr17_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr17_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr17_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr17_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr17_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr17_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr17_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr17_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr17_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr17_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr17_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr17_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr17_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr17_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr17_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr17_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr17_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR17RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR17WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006AA8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr17_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr17_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr17_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr17_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr17_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr17_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr17_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr17_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr17_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr17_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr17_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr17_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr17_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr17_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr17_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr17_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr17_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr17_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr17_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr17_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr17_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr17_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr17_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr17_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr17_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr17_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr17_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr17_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr17_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr17_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr17_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr17_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr17_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr17_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr17_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr17_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr17_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr17_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr17_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr17_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr17_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr17_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr17_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr17_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr17_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr17_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr17_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr17_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr17_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr17_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr17_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr17_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr17_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr17_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr17_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr17_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr17_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr17_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr17_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr17_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr17_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr17_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr17_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR17
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr17_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR17WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006AB0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR18 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR18MASK[28:0] applied to bits 38:10
    // of the incoming address, to determine if an access falls within the IMR18 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr18_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR18BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006AB4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR18BASE[28:0] value. A match indicates that the
    // incoming address falls within the IMR18 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr18_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback data HITM data from GT to be returned to the
    // requester.  When set to 0, inhibits HITM data from GT from being returned to the
    // requester. HITM data from IA cores may be returned to the requester depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR18MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006AB8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR18RAC,
    // BIMR18WAC and BIMR18CP registers, based on the value from each agent's 6bit SAI
    // field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr18_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR18CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006AC0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr18_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr18_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr18_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr18_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr18_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr18_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr18_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr18_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr18_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr18_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr18_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr18_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr18_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr18_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr18_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr18_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr18_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr18_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr18_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr18_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr18_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr18_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr18_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr18_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr18_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr18_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr18_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr18_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr18_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr18_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr18_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr18_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr18_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr18_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr18_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr18_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr18_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr18_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr18_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr18_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr18_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr18_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr18_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr18_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr18_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr18_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr18_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr18_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr18_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr18_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr18_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr18_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr18_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr18_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr18_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr18_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr18_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr18_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr18_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr18_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr18_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr18_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr18_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR18
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr18_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR18RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR18WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006AC8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr18_write_pol_0 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr18_write_pol_1 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr18_write_pol_2 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr18_write_pol_3 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr18_write_pol_4 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr18_write_pol_5 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr18_write_pol_6 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr18_write_pol_7 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr18_write_pol_8 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr18_write_pol_9 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr18_write_pol_10 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr18_write_pol_11 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr18_write_pol_12 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr18_write_pol_13 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr18_write_pol_14 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr18_write_pol_15 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr18_write_pol_16 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr18_write_pol_17 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr18_write_pol_18 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr18_write_pol_19 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr18_write_pol_20 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr18_write_pol_21 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr18_write_pol_22 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr18_write_pol_23 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr18_write_pol_24 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr18_write_pol_25 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr18_write_pol_26 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr18_write_pol_27 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr18_write_pol_28 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr18_write_pol_29 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr18_write_pol_30 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr18_write_pol_31 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr18_write_pol_32 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr18_write_pol_33 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr18_write_pol_34 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr18_write_pol_35 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr18_write_pol_36 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr18_write_pol_37 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr18_write_pol_38 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr18_write_pol_39 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr18_write_pol_40 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr18_write_pol_41 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr18_write_pol_42 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr18_write_pol_43 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr18_write_pol_44 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr18_write_pol_45 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr18_write_pol_46 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr18_write_pol_47 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr18_write_pol_48 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr18_write_pol_49 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr18_write_pol_50 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr18_write_pol_51 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr18_write_pol_52 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr18_write_pol_53 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr18_write_pol_54 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr18_write_pol_55 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr18_write_pol_56 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr18_write_pol_57 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr18_write_pol_58 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr18_write_pol_59 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr18_write_pol_60 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr18_write_pol_61 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr18_write_pol_62 : 1;
    //
    // B-Unit IMR18 Write Access Policy: Bit vector used to determine which agents are
    // allowed write access to the IMR18 region, based on each agent's 6bit encoded SAI
    // value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr18_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR18WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006AD0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies bits 38:10 of the start address of IMR19 region. IMR region size must
    // be a strict power of two, at least 1KB, and naturally aligned to the size. These
    // bits are compared with the result of the IMR19MASK[28:0] applied to bits 38:10
    // of the incoming address to determine if an access falls within the IMR19 defined
    // region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr19_base : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the IMR region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR19BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006AD4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are ANDed with bits 38:10 of the incoming address to determine if the
    // combined result matches the IMR19BASE[28:0] value. A match indicates that the
    // incoming address falls within the IMR19 region.
    //
    // Bits[28:0], RW, default = 0x0
    //
    UINTX imr19_mask : 29;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback data HITM data from GT to be returned to the
    // requester. When set to 0, inhibits HITM data from GT from being returned to the
    // requester. HITM data from IA cores may be returned to the requester depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR19MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006AD8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BIMR19RAC,
    // BIMR19WAC, BIMR19CP registers, based on the value from each agent's 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX imr19_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMR19CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006AE0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr19_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr19_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr19_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr19_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr19_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr19_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr19_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr19_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr19_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr19_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr19_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr19_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr19_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr19_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr19_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr19_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr19_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr19_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr19_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr19_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr19_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr19_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr19_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr19_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr19_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr19_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr19_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr19_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr19_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr19_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr19_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr19_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr19_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr19_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr19_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr19_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr19_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr19_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr19_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr19_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr19_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr19_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr19_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr19_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr19_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr19_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr19_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr19_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr19_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr19_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr19_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr19_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr19_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr19_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr19_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr19_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr19_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr19_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr19_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr19_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr19_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr19_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr19_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr19_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR19RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMR19WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006AE8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX imr19_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX imr19_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX imr19_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX imr19_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX imr19_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX imr19_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX imr19_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX imr19_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX imr19_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX imr19_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX imr19_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX imr19_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX imr19_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX imr19_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX imr19_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX imr19_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX imr19_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX imr19_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX imr19_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX imr19_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX imr19_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX imr19_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX imr19_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX imr19_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX imr19_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX imr19_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX imr19_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX imr19_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX imr19_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX imr19_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX imr19_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX imr19_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX imr19_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX imr19_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX imr19_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX imr19_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX imr19_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX imr19_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX imr19_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX imr19_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX imr19_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX imr19_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX imr19_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX imr19_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX imr19_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX imr19_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX imr19_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX imr19_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX imr19_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX imr19_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX imr19_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX imr19_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX imr19_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX imr19_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX imr19_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX imr19_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX imr19_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX imr19_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX imr19_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX imr19_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX imr19_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX imr19_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX imr19_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the IMR19
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX imr19_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BIMR19WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_OUT_BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG   0x00006AF0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[13:0], RO, default = 0x0
    //
    UINTX reserved_0 : 14;
    //
    // Specifies bits 38:24 of the start address of the MOT memory region. Region size
    // must be a strict power of two, at least 16MB, and naturally aligned to the size.
    // These bits are compared with the result of the MOT_OUT_MASK[28:14] applied to
    // bits 38:24 of the incoming address to determine if an access falls within the
    // MOT region.
    //
    // Bits[28:14], RW, default = 0x0
    //
    UINTX mot_out_base : 15;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables snooping of transactions to the IMR region by tracing agents such as MOT.
    // Reserved and set to 0 for the MOT region, since otherwise this would enable recursive
    // tracing and corrupt MOT buffer.
    //
    // Bits[30:30], RO, default = 0x0
    //
    UINTX tr_en : 1;
    //
    // Enables access checking for the MOT region. Note: this does not enable MOT itself,
    // but merely enables access control checks for transactions that attempt to access
    // the MOT buffer.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX imr_en : 1;
  } Bits;
  UINTX Data;
} B_CR_MOT_OUT_BASE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_OUT_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG   0x00006AF4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[13:0], RO, default = 0x0
    //
    UINTX reserved_0 : 14;
    //
    // Specifies the size of the MOT region. If Request Address [38:24] ANDed with MOT_OUT_MASK[28:14]
    // matches the MOT_OUT_BASE[28:14] then the request falls within the MOT_OUT region.
    //
    // Bits[28:14], RW, default = 0x0
    //
    UINTX mot_out_mask : 15;
    //
    // Reserved.
    //
    // Bits[29:29], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback HITM data from IA cores to be returned to the
    // requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback HITM data from GT to be returned to the requester.
    // When set to 0, inhibits HITM data from GT from being returned to the requester.
    // HITM data from IA cores may be returned to the requester, depending on the setting
    // of the IA_IWB_EN bit.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
  } Bits;
  UINTX Data;
} B_CR_MOT_OUT_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BMOT_BUF_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG    0x00006AF8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BMOT_BUF_RAC,
    // BMOT_BUF_WAC and BMOT_BUF_CP registers, based on the value from each agent's 6bit
    // SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX mot_buf_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BMOT_BUF_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BMOT_BUF_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG   0x00006B00
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX mot_buf_read_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX mot_buf_read_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX mot_buf_read_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX mot_buf_read_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX mot_buf_read_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x1
    //
    UINTX mot_buf_read_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x1
    //
    UINTX mot_buf_read_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX mot_buf_read_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the MOT region,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX mot_buf_read_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BMOT_BUF_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BMOT_BUF_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG   0x00006B08
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX mot_buf_write_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x1
    //
    UINTX mot_buf_write_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x1
    //
    UINTX mot_buf_write_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX mot_buf_write_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the MOT
    // region, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX mot_buf_write_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BMOT_BUF_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMRGLOBAL_BM_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006B10
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to BIMRGLOBAL_BM_WAC,
    // based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX bm_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMRGLOBAL_BM_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMRGLOBAL_BM_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006B18
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to all IMRxBASE
    // and IMRxMASK registers, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:0], RO, default = 0xFFFFFFFFFFFFFFFF
    //
    UINTX bm_read_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMRGLOBAL_BM_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIMRGLOBAL_BM_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006B20
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to all IMRxBASE
    // and IMRxMASK registers, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX bm_write_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIMRGLOBAL_BM_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BGSMCP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG         0x00006B28
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the BGSMRAC, BGSMWAC
    // and BGSMCP registers, based on the value from each agent's 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX gsm_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BGSMCP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BGSMRAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x00006B30
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX gsm_sai_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX gsm_sai_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX gsm_sai_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX gsm_sai_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX gsm_sai_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX gsm_sai_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX gsm_sai_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX gsm_sai_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x1
    //
    UINTX gsm_sai_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX gsm_sai_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX gsm_sai_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX gsm_sai_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX gsm_sai_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX gsm_sai_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX gsm_sai_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX gsm_sai_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX gsm_sai_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX gsm_sai_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX gsm_sai_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX gsm_sai_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX gsm_sai_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX gsm_sai_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX gsm_sai_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX gsm_sai_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX gsm_sai_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX gsm_sai_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX gsm_sai_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX gsm_sai_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX gsm_sai_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x1
    //
    UINTX gsm_sai_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x1
    //
    UINTX gsm_sai_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX gsm_sai_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX gsm_sai_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX gsm_sai_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX gsm_sai_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX gsm_sai_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX gsm_sai_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX gsm_sai_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX gsm_sai_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX gsm_sai_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX gsm_sai_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX gsm_sai_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX gsm_sai_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX gsm_sai_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x1
    //
    UINTX gsm_sai_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX gsm_sai_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX gsm_sai_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX gsm_sai_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX gsm_sai_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX gsm_sai_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX gsm_sai_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX gsm_sai_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX gsm_sai_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX gsm_sai_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX gsm_sai_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX gsm_sai_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX gsm_sai_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX gsm_sai_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX gsm_sai_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX gsm_sai_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX gsm_sai_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX gsm_sai_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX gsm_sai_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed read access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX gsm_sai_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BGSMRAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BGSMWAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG        0x00006B38
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX gsm_sai_pol_0 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX gsm_sai_pol_1 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX gsm_sai_pol_2 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX gsm_sai_pol_3 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX gsm_sai_pol_4 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX gsm_sai_pol_5 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX gsm_sai_pol_6 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX gsm_sai_pol_7 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[8:8], RW, default = 0x1
    //
    UINTX gsm_sai_pol_8 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[9:9], RO, default = 0x0
    //
    UINTX gsm_sai_pol_9 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX gsm_sai_pol_10 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX gsm_sai_pol_11 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX gsm_sai_pol_12 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX gsm_sai_pol_13 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX gsm_sai_pol_14 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX gsm_sai_pol_15 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[16:16], RW, default = 0x1
    //
    UINTX gsm_sai_pol_16 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX gsm_sai_pol_17 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX gsm_sai_pol_18 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX gsm_sai_pol_19 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX gsm_sai_pol_20 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX gsm_sai_pol_21 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX gsm_sai_pol_22 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX gsm_sai_pol_23 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX gsm_sai_pol_24 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX gsm_sai_pol_25 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX gsm_sai_pol_26 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX gsm_sai_pol_27 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX gsm_sai_pol_28 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[29:29], RW, default = 0x1
    //
    UINTX gsm_sai_pol_29 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[30:30], RW, default = 0x1
    //
    UINTX gsm_sai_pol_30 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX gsm_sai_pol_31 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[32:32], RW, default = 0x0
    //
    UINTX gsm_sai_pol_32 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[33:33], RW, default = 0x0
    //
    UINTX gsm_sai_pol_33 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[34:34], RW, default = 0x0
    //
    UINTX gsm_sai_pol_34 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[35:35], RO, default = 0x0
    //
    UINTX gsm_sai_pol_35 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[36:36], RW, default = 0x0
    //
    UINTX gsm_sai_pol_36 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[37:37], RO, default = 0x0
    //
    UINTX gsm_sai_pol_37 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[38:38], RW, default = 0x0
    //
    UINTX gsm_sai_pol_38 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX gsm_sai_pol_39 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[40:40], RW, default = 0x0
    //
    UINTX gsm_sai_pol_40 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[41:41], RW, default = 0x0
    //
    UINTX gsm_sai_pol_41 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[42:42], RW, default = 0x0
    //
    UINTX gsm_sai_pol_42 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[43:43], RW, default = 0x0
    //
    UINTX gsm_sai_pol_43 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[44:44], RW, default = 0x1
    //
    UINTX gsm_sai_pol_44 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[45:45], RO, default = 0x0
    //
    UINTX gsm_sai_pol_45 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[46:46], RO, default = 0x0
    //
    UINTX gsm_sai_pol_46 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX gsm_sai_pol_47 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[48:48], RW, default = 0x0
    //
    UINTX gsm_sai_pol_48 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[49:49], RW, default = 0x0
    //
    UINTX gsm_sai_pol_49 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[50:50], RW, default = 0x0
    //
    UINTX gsm_sai_pol_50 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[51:51], RO, default = 0x0
    //
    UINTX gsm_sai_pol_51 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[52:52], RO, default = 0x0
    //
    UINTX gsm_sai_pol_52 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[53:53], RO, default = 0x0
    //
    UINTX gsm_sai_pol_53 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[54:54], RW, default = 0x0
    //
    UINTX gsm_sai_pol_54 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[55:55], RW, default = 0x0
    //
    UINTX gsm_sai_pol_55 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[56:56], RW, default = 0x0
    //
    UINTX gsm_sai_pol_56 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[57:57], RO, default = 0x0
    //
    UINTX gsm_sai_pol_57 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[58:58], RO, default = 0x0
    //
    UINTX gsm_sai_pol_58 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[59:59], RO, default = 0x0
    //
    UINTX gsm_sai_pol_59 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[60:60], RO, default = 0x0
    //
    UINTX gsm_sai_pol_60 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[61:61], RO, default = 0x0
    //
    UINTX gsm_sai_pol_61 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[62:62], RO, default = 0x0
    //
    UINTX gsm_sai_pol_62 : 1;
    //
    // Bit vector used to determine which agents are allowed write access to the memory
    // range from BGSM to TOLUD1, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX gsm_sai_pol_63 : 1;
  } Bits;
  UINTX Data;
} B_CR_BGSMWAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_TPM_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG         0x00006B40
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to TPM_AC register,
    // based on each agent's 6-bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_TPM_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_TPM_AC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG         0x00006B48
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read/write access to TPM_SELECTOR,
    // based on each agent's 6-bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX ac_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_TPM_AC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BGSM_CTRL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006B50
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enables SAI checking for the memory range from BGSM to TOLUD-1
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX range_check_en : 1;
    //
    // Enables snooping of transactions to the Graphics Stolen Memory region by tracing
    // agents.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX trace_en : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback data HITM data from GT to be returned to the
    // requester. When set to 0, inhibits HITM data from GT from being returned to the
    // requester. HITM data from IA cores may be returned to the requester depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX gt_iwb_en : 1;
    //
    // PII transactions from RS0 that hit the Graphics and Data Stolen Memory range will
    // be allowed access only when both of the following conditions are met: a) Request
    // SAI is in the legal permitted list as specified in the RAC/WAC policy registers
    // and b) GSM_RS0_EN bit is set to 1. PII RS0 transactions targeting DRAM that do
    // not hit any enabled IMR or special protected regions will always be allowed access.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX rs0_en : 1;
    //
    // Reserved.
    //
    // Bits[31:5], RO, default = 0x0
    //
    UINTX reserved_0 : 27;
  } Bits;
  UINTX Data;
} B_CR_BGSM_CTRL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BSMR_CTRL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006B54
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enables SAI checking for the SMM memory range: TSEGMB to BGSM.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX range_check_en : 1;
    //
    // Enables snooping of transactions to the SMM region by tracing agents.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX trace_en : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent.  When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester.  When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester.  HITM data from GT may be returned to the requester depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback data HITM data from GT to be returned to the
    // requester. When set to 0, inhibits HITM data from GT from being returned to the
    // requester. HITM data from IA cores may be returned to the requester, depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX gt_iwb_en : 1;
    //
    // No PII transaction is allowed access to SMM region.  As such RS0 asset classification
    // bit does not apply and hence provisioned as a readonly bit and set to 0.
    //
    // Bits[4:4], RO, default = 0x0
    //
    UINTX rs0_en : 1;
    //
    // Reserved.
    //
    // Bits[31:5], RO, default = 0x0
    //
    UINTX reserved_0 : 27;
  } Bits;
  UINTX Data;
} B_CR_BSMR_CTRL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BDEFVTDPMR_CTRL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006B58
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Enables snooping of transactions to the Default VTd PHM and PLM regions by tracing
    // agents.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX trace_en : 1;
    //
    // Enables implicit writebacks to protected region from IA caching agent. When set
    // to 1, enables implicit writeback data HITM data from IA cores to be returned to
    // the requester. When set to 0, inhibits HITM data from IA cores from being returned
    // to the requester. HITM data from GT may be returned to the requester, depending
    // on the setting of the GT_IWB_EN bit.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX ia_iwb_en : 1;
    //
    // Enables implicit writebacks to protected region from GT caching agent. When set
    // to 1, enables implicit writeback data HITM data from GT to be returned to the
    // requester. When set to 0, inhibits HITM data from GT from being returned to the
    // requester. HITM data from IA cores may be returned to the requester, depending
    // on the setting of the IA_IWB_EN bit.
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX gt_iwb_en : 1;
    //
    // PII transactions from RS0 that hit VTd PMR high and low memory ranges will be
    // allowed access only when both of the following conditions are met: a) Request
    // SAI is in the legal permitted list as specified in the RAC/WAC policy registers
    // and b) VTDPMR_RS0_EN bit is set to 1. PII RS0 transactions targeting DRAM that
    // do not hit any enabled IMR or special protected regions will always be allowed
    // access.
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX rs0_en : 1;
    //
    // Reserved.
    //
    // Bits[31:5], RO, default = 0x0
    //
    UINTX reserved_1 : 27;
  } Bits;
  UINTX Data;
} B_CR_BDEFVTDPMR_CTRL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BNOCACHE_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG       0x00006B5C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // These bits are compared with bits 35:20 of the incoming address to determine the
    // lower 1MB aligned value of the protected range when EnableNoSnoop is set.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX lower_no_snoop_bound : 16;
    //
    // These bits are compared with bits 35:20 of the incoming address to determine the
    // upper 1MB aligned value of the nonsnoop range when EnableNoSnoop is set.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX upper_no_snoop_bound : 16;
  } Bits;
  UINTX Data;
} B_CR_BNOCACHE_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BNOCACHECTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG    0x00006B60
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When set, B-Unit compares bits 35:20 incoming addresses to Upper and Lower NoSnoop
    // Bounds to see if the transaction should be prevented from issuing a processor
    // snoop operation.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX enable_no_snoop : 1;
    //
    // Reserved.
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved_0 : 31;
  } Bits;
  UINTX Data;
} B_CR_BNOCACHECTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_TRIG_TRACE_CTRL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006B7C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]1: enable MOT
    //               [*]0: disable MOT
    //               [/list]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX enable_mot : 1;
    //
    // [list]
    //               [*]1: enable MOT filter 0
    //               [*]0: disable MOT filter 0
    //               [/list]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX enable_mot_filter_0 : 1;
    //
    // [list]
    //               [*]1: enable MOT filter 1
    //               [*]0: disable MOT filter 1
    //               [/list]
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX enable_mot_filter_1 : 1;
    //
    // [list]
    //               [*]1: enable MOT trigger 0
    //               [*]0: disable MOT trigger 0
    //               [/list]
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX enable_mot_trigger_0 : 1;
    //
    // [list]
    //               [*]1: enable MOT trigger 1
    //               [*]0: disable MOT trigger 1
    //               [/list]
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX enable_mot_trigger_1 : 1;
    //
    // [list]
    //               [*]1: enable external trigger out to from MOT to rdu_mid
    //               [*]0: disable external trigger out to from MOT to rdu_mid
    //               [/list]
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX enable_external_trigger_out_0 : 1;
    //
    // Select source of trigger sent to rdu_mid.
    //               [list]
    //               [*]00b: Filter 0
    //               [*]01b: Filter 1
    //               [*]10b: Trigger 0
    //               [*]11b: Trigger 1
    //               [/list]
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX trigger_out_source : 2;
    //
    // [list]
    //               [*]1 to enable external trigger 0 to MOT from rdu_mid
    //               [*]0 to disable external trigger 0 to MOT from rdu_mid
    //               [/list]
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX enable_external_trigger_in_0 : 1;
    //
    // [list]
    //               [*]1 to enable external trigger 1 to MOT from rdu_mid
    //               [*]0 to disable external trigger 1 to MOT from rdu_mid
    //               [/list]
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX enable_external_trigger_in_1 : 1;
    //
    // A bit field allowing multiple triggers to result in a trace storage start.  Storage
    // stop is the logical OR of trigger sources selected. Note that selecting the same
    // trigger to start and stop trace storage results in start trace storage only. For
    // bit positions, see description for MOT_TRACE_STORAGE_STOP_SOURCE field.
    //
    // Bits[15:10], RW, default = 0x0
    //
    UINTX mot_trace_storage_start_source : 6;
    //
    // A bit field allowing multiple triggers to result in a trace storage stop. Storage
    // stop is the logical OR of trigger sources selected. Note that selecting the same
    // trigger to start and stop trace storage results in start trace storage only.
    //               [list]
    //               [*]Bit position 5: External Trigger in 1
    //               [*]Bit position 4: External Trigger in 0
    //               [*]Bit position 3: MOT Trigger  1
    //               [*]Bit position 2: MOT Trigger 0
    //               [*]Bit position 1: MOT Filter 1 match
    //               [*]Bit position 0: MOT Filter 0 match
    //               [/list]
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX mot_trace_storage_stop_source : 6;
    //
    // Current status of MOT storage to memory. Used to save/restore trigger state across
    // power states.
    //
    // Bits[22:22], RW/V, default = 0x0
    //
    UINTX mot_storage_active : 1;
    //
    // 1 indicates Filter 0 match. Cleared by powergood or explicit SW write.
    //
    // Bits[23:23], RW/V, default = 0x0
    //
    UINTX sticky_filter_0_match : 1;
    //
    // 1 indicates Filter 1 match. Cleared by powergood or explicit SW write.
    //
    // Bits[24:24], RW/V, default = 0x0
    //
    UINTX sticky_filter_1_match : 1;
    //
    // 1 indicates Trigger 0 match. Cleared by powergood or explicit SW write.
    //
    // Bits[25:25], RW/V, default = 0x0
    //
    UINTX sticky_trigger_0_match : 1;
    //
    // 1 indicates Trigger 1 match. Cleared by powergood or explicit SW write.
    //
    // Bits[26:26], RW/V, default = 0x0
    //
    UINTX sticky_trigger_1_match : 1;
    //
    // Reserved.
    //
    // Bits[27:27], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Specifies the duration of the periodic MOT flush timer.  Duration is 2^N cycles
    // of a 19.2 MHz clock, where N is the value specified in the field.
    //
    // Bits[31:28], RW, default = 0xE
    //
    UINTX flush_timer_period : 4;
  } Bits;
  UINTX Data;
} B_CR_MOT_TRIG_TRACE_CTRL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_SLICE_0_MEM_PTR_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006B80
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Indication that the MOT slice 0 buffer has wrapped since the last clear of this
    // write cleared by power good or explicit SW write.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX mot_buffer_wrap : 1;
    //
    // Pin MOT slice 0 to near1 or far0 memory. This logic is implemented in the 2LM.
    // Thus, this register bit is shadowed in its entirety in the 2LM. Unused by MOT.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX near_or_far_memory : 1;
    //
    // Reserved.
    //
    // Bits[5:2], RO, default = 0x0
    //
    UINTX reserved_1 : 4;
    //
    // The current pointer into MOT slice 0 region. Cache line granularity bits [38:6].
    //
    // Bits[38:6], RW/V, default = 0x0
    //
    UINTX mot_memory_pointer : 33;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_SLICE_0_MEM_PTR_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_SLICE_1_MEM_PTR_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006B88
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Indication that the MOT slice 1 buffer has wrapped since the last clear of this
    // write cleared by power good or explicit SW write.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX mot_buffer_wrap : 1;
    //
    // Pin MOT slice 1 to near1 or far0 memory. This logic is implemented in the 2LM.
    // Thus, this register is shadowed in its entirety in the 2LM.
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX near_or_far_memory : 1;
    //
    // Reserved.
    //
    // Bits[5:2], RO, default = 0x0
    //
    UINTX reserved_1 : 4;
    //
    // The current pointer into MOT slice 1 region. Cache line granularity bits [38:6].
    //
    // Bits[38:6], RW/V, default = 0x0
    //
    UINTX mot_memory_pointer : 33;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_SLICE_1_MEM_PTR_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_SLICE_0_RECORD_ID_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006B90
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current MOT unique record ID number.
    //
    // Bits[25:0], RW/V, default = 0x0
    //
    UINTX record_id : 26;
    //
    // Indicates that MOT has captured the first data packet after tracing started.
    //
    // Bits[26:26], RW/V, default = 0x0
    //
    UINTX first_pkt_captured : 1;
    //
    // Reserved.
    //
    // Bits[31:27], RO, default = 0x0
    //
    UINTX reserved_0 : 5;
  } Bits;
  UINTX Data;
} B_CR_MOT_SLICE_0_RECORD_ID_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_SLICE_1_RECORD_ID_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006B94
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current MOT unique record ID number.
    //
    // Bits[25:0], RW/V, default = 0x0
    //
    UINTX record_id : 26;
    //
    // Indicates that MOT has captured the first data packet after tracing started.
    //
    // Bits[26:26], RW/V, default = 0x0
    //
    UINTX first_pkt_captured : 1;
    //
    // Reserved.
    //
    // Bits[31:27], RO, default = 0x0
    //
    UINTX reserved_0 : 5;
  } Bits;
  UINTX Data;
} B_CR_MOT_SLICE_1_RECORD_ID_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_FILTER_MATCH0_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BA0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX reserved_1 : 5;
    //
    // Access address to match. Match results in trace of access. Half cache line granularity
    // bits 38:5 to support legacy devices.
    //
    // Bits[38:5], RW, default = 0x0
    //
    UINTX mot_0_filter_match_address : 34;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_FILTER_MATCH0_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_FILTER_MASK0_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BA8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX reserved_1 : 5;
    //
    // Access address bits to mask. A value of 1 ignores the corresponding address bit.
    // Half cache line granularity bits 38:5 to support legacy devices.
    //
    // Bits[38:5], RW, default = 0x3FFFFFFFF
    //
    UINTX mot_0_filter_mask_address : 34;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_FILTER_MASK0_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_FILTER_MATCH1_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BB0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX reserved_1 : 5;
    //
    // Access address to match. Match results in trace of access. Half cache line granularity
    // bits 38:5 to support legacy devices.
    //
    // Bits[38:5], RW, default = 0x0
    //
    UINTX mot_1_filter_match_address : 34;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_FILTER_MATCH1_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_FILTER_MASK1_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BB8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX reserved_1 : 5;
    //
    // Access address bits to mask. A value of 1 ignores the corresponding address bit.
    // Half cache line granularity bits 38:5 to support legacy devices.
    //
    // Bits[38:5], RW, default = 0x3FFFFFFFF
    //
    UINTX mot_1_filter_mask_address : 34;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_FILTER_MASK1_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_FILTER_MISC0_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BC0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]1: match writes
    //               [*]0: match reads
    //               [/list]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX access_type_match_read_or_write : 1;
    //
    // [list]
    //               [*]1: filter inversion
    //               [*]0: match criteria
    //               [/list]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX addr_match_polarity : 1;
    //
    // Match if transaction originated from one of up to 16 virtual channel cores (one
    // bit per VC).
    //
    // Bits[17:2], RW, default = 0x0
    //
    UINTX vc_match : 16;
    //
    // [list]
    //               [*]1: match
    //               [*]0: ignore
    //               [/list]
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX gt_match : 1;
    //
    // Match if transaction originated from one of up to 16 IA cores (one bit per logical
    // processor).
    //
    // Bits[34:19], RW, default = 0x0
    //
    UINTX ia_core_match : 16;
    //
    // N/A
    //
    // Bits[63:35], RO, default = 0x0
    //
    UINTX reserved_0 : 29;
  } Bits;
  UINTX Data;
} B_CR_MOT_FILTER_MISC0_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_FILTER_MISC1_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BC8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]1: match writes
    //               [*]0: match reads
    //               [/list]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX access_type_match_read_or_write : 1;
    //
    // [list]
    //               [*]1: filter inversion
    //               [*]0: match criteria
    //               [/list]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX addr_match_polarity : 1;
    //
    // Match if transaction originated from one of up to 16 virtual channel cores (one
    // bit per VC).
    //
    // Bits[17:2], RW, default = 0x0
    //
    UINTX vc_match : 16;
    //
    // [list]
    //               [*]1: match
    //               [*]0: ignore
    //               [/list]
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX gt_match : 1;
    //
    // Match if transaction originated from one of up to 16 IA cores (one bit per logical
    // processor).
    //
    // Bits[34:19], RW, default = 0x0
    //
    UINTX ia_core_match : 16;
    //
    // N/A
    //
    // Bits[63:35], RO, default = 0x0
    //
    UINTX reserved_0 : 29;
  } Bits;
  UINTX Data;
} B_CR_MOT_FILTER_MISC1_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_TRIGGER_MATCH0_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BD0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX reserved_1 : 5;
    //
    // Access address to match. Match results in trace of access. Half cache line granularity
    // bits 38:5 to support legacy devices.
    //
    // Bits[38:5], RW, default = 0x0
    //
    UINTX mot_0_trigger_match_address : 34;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_TRIGGER_MATCH0_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_TRIGGER_MASK0_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BD8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX reserved_1 : 5;
    //
    // Access address bits to mask. A value of 1 ignores the corresponding address bit.
    // Half cache line granularity bits 38:5 to support legacy devices.
    //
    // Bits[38:5], RW, default = 0x3FFFFFFFF
    //
    UINTX mot_0_trigger_mask_address : 34;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_TRIGGER_MASK0_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_TRIGGER_MATCH1_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BE0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX reserved_1 : 5;
    //
    // Access address to match. Match results in trace of access. Half cache line granularity
    // bits 38:5 to support legacy devices.
    //
    // Bits[38:5], RW, default = 0x0
    //
    UINTX mot_1_trigger_match_address : 34;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_TRIGGER_MATCH1_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_TRIGGER_MASK1_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BE8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[4:0], RO, default = 0x0
    //
    UINTX reserved_1 : 5;
    //
    // Access address bits to mask. A value of 1 ignores the corresponding address bit.
    // Half cache line granularity bits 38:5 to support legacy devices.
    //
    // Bits[38:5], RW, default = 0x3FFFFFFFF
    //
    UINTX mot_1_trigger_mask_address : 34;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_MOT_TRIGGER_MASK1_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_TRIGGER_MISC0_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BF0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]1: match writes
    //               [*]0: match reads
    //               [/list]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX access_type_match_read_or_write : 1;
    //
    // [list]
    //               [*]1: filter inversion
    //               [*]0: match criteria
    //               [/list]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX addr_match_polarity : 1;
    //
    // Match if transaction originated from one of up to 16 virtual channel cores (one
    // bit per VC).
    //
    // Bits[17:2], RW, default = 0x0
    //
    UINTX vc_match : 16;
    //
    // [list]
    //               [*]1: match
    //               [*]0: ignore
    //               [/list]
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX gt_match : 1;
    //
    // Match if transaction originated from one of up to 16 IA cores (one bit per logical
    // processor).
    //
    // Bits[34:19], RW, default = 0x0
    //
    UINTX ia_core_match : 16;
    //
    // N/A
    //
    // Bits[63:35], RO, default = 0x0
    //
    UINTX reserved_0 : 29;
  } Bits;
  UINTX Data;
} B_CR_MOT_TRIGGER_MISC0_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_TRIGGER_MISC1_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006BF8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]1: match writes
    //               [*]0: match reads
    //               [/list]
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX access_type_match_read_or_write : 1;
    //
    // [list]
    //               [*]1: filter inversion
    //               [*]0: match criteria
    //               [/list]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX addr_match_polarity : 1;
    //
    // Match if transaction originated from one of up to 16 virtual channel cores (one
    // bit per VC).
    //
    // Bits[17:2], RW, default = 0x0
    //
    UINTX vc_match : 16;
    //
    // [list]
    //               [*]1: match
    //               [*]0: ignore
    //               [/list]
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX gt_match : 1;
    //
    // Match if transaction originated from one of up to 16 IA cores (one bit per logical
    // processor).
    //
    // Bits[34:19], RW, default = 0x0
    //
    UINTX ia_core_match : 16;
    //
    // N/A
    //
    // Bits[63:35], RO, default = 0x0
    //
    UINTX reserved_0 : 29;
  } Bits;
  UINTX Data;
} B_CR_MOT_TRIGGER_MISC1_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_MOT_PSMI_SYNC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG  0x00006C00
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Set by PSMI microcode. Once set, cleared by HW after creation of first MOT record
    // in Slice0.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX psmi_sync0 : 1;
    //
    // Set by PSMI microcode. Once set, cleared by HW after creation of first MOT record
    // in Slice1.
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX psmi_sync1 : 1;
    //
    // Reserved.
    //
    // Bits[31:2], RO, default = 0x0
    //
    UINTX reserved_0 : 30;
  } Bits;
  UINTX Data;
} B_CR_MOT_PSMI_SYNC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_TPM_SELECTOR_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG   0x00006C24
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]0h: fTPM enabled. Target of TPM accesses is the CSE.
    //               [*]1h: SPI TPM enabled. Target of TPM accesses is SPI.
    //               [*]2h: LPC TPM enabled. Target of TPM accesses is LPC.
    //               [*]3h: All TPMs disabled. Target of TPM accesses is the PSF Error
    // Handler.
    //               [/list]
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX tpm_selector : 2;
    //
    // Reserved.
    //
    // Bits[31:2], RO, default = 0x0
    //
    UINTX reserved_0 : 30;
  } Bits;
  UINTX Data;
} B_CR_TPM_SELECTOR_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_DEFVTDBAR_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006C80
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]0: DEFVTDBAR is disabled and does not claim any memory
    //               [*]1: DEFVTDBAR memory mapped accesses are claimed and decoded appropriately.
    // This bit will remain 0 if VTd capability is disabled.
    //               [/list]
    //
    // Bits[0:0], RW/L, default = 0x0
    //
    UINTX defvtdbaren : 1;
    //
    // Locks the contents of the register including itself. Unused by the B-Unit, and
    // does not implement the intended lock functionality. B-Unit includes this bit to
    // support shadow copies of the register that rely on this lock bit.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved.
    //
    // Bits[11:2], RO, default = 0x0
    //
    UINTX reserved_1 : 10;
    //
    // If DEFVTDBAR is enabled, this field corresponds to bits 38:12 of the base address
    // default IOMMU VTd configuration space. BIOS will program this register resulting
    // in a base address for a 4KB block of contiguous memory address space. This register
    // ensures that a naturally aligned 4KB space is allocated within the first 512GB
    // of addressable memory space. System Software uses this base address to program
    // the default VTd IOMMU register set. If DEFVTDBAR is enabled and incoming Request
    // Address[38:12] matches DEFVTDBAR[38:12] the request targets the Default VTd BAR.
    //
    // Bits[38:12], RW, default = 0x0
    //
    UINTX defvtdbar : 27;
    //
    // Reserved for future growth to 40bit addressing in uServer. Will always be 0 in
    // WLV/BXT.
    //
    // Bits[39:39], RO, default = 0x0
    //
    UINTX defvtdbar_40_bit : 1;
    //
    // Reserved.
    //
    // Bits[63:40], RO, default = 0x0
    //
    UINTX reserved_0 : 24;
  } Bits;
  UINTX Data;
} B_CR_DEFVTDBAR_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_GFXVTDBAR_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006C88
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [list]
    //               [*]0: GFXVTBAR is disabled and does not claim any memory
    //               [*]1: GFXVTBAR memory mapped accesses are claimed and decoded appropriately.
    // This bit will remain 0 if VTd capability is disabled.
    //               [/list]
    //
    // Bits[0:0], RW/L, default = 0x0
    //
    UINTX gfxvtbaren : 1;
    //
    // Locks the contents of the register, including itself. Unused by the B-Unit, and
    // does not implement the intended lock functionality. B-Unit includes this bit to
    // support shadow copies of the register that rely on this lock bit.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX lock : 1;
    //
    // Reserved.
    //
    // Bits[11:2], RO, default = 0x0
    //
    UINTX reserved_1 : 10;
    //
    // This field corresponds to bits 38 to 12 of the base address GFXVT configuration
    // space. BIOS will program this register, resulting in a base address for a 4KB
    // block of contiguous memory address space. This register ensures that a naturally
    // aligned 4KB space is allocated within the first 512GB of addressable memory space.
    // System Software uses this base address to program the GFXVT register set. If GFXVTBAR
    // is enabled and incoming Request Address[38:12] matches GFXVTBAR[38:12] the request
    // targets the Gfx VTd BAR.
    //
    // Bits[38:12], RW, default = 0x0
    //
    UINTX gfxvtbar : 27;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_0 : 25;
  } Bits;
  UINTX Data;
} B_CR_GFXVTDBAR_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES0_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006C90
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enables all match filters for Lites Group 0. The following are the observation
    // points that contain match filters:  Badmit logic within each slice after a transaction
    // is successfully admitted into the B-Unit, U2C request launch, PMI datain for each
    // PMI channel for read data, PMI dataout for each PMI channel for writes, data write
    // from requesters to BRAM in each slice, and read data return on the live bypass
    // and nonlive bypass paths in each slice. To report a match at an observation point,
    // all match criteria for that point must be satisfied.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX enable_group : 1;
    //
    // When set, inverts the polarity of the address match/mask logic, i.e., reports
    // a match for addresses that are not in the specified range.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX invert_addr_match : 1;
    //
    // When set, address match/mask, opcode match and agent match registers are used
    // to generate matches for the U2C request observation point. When clear, Badmit
    // observation point matches are reported on the U2C request observation point.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX altu2creqview : 1;
    //
    // When set, this field enables data matching on Lites Group 0.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX enable_data_match : 1;
    //
    // Selects the dword within the 512bit data field that is compared for data mask/matches
    // for Lites Group 0.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX dword_select : 4;
    //
    // [list]
    //               [*]00: All mask/match hits are suppressed
    //               [*]01: Mask/Match hits enabled only for Slice0
    //               [*]10: Mask/match hits enabled only for Slice1
    //               [*]11: Mask/Match hits enabled for both Slices
    //               [/list]
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX slice_match : 2;
    //
    // Reserved.
    //
    // Bits[11:10], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Enables length matching for PII requests for Lites Group 0. Each bit, when set
    // to 1, enables length match for the PII request.
    //              [list]
    //              [*]Bit 13:64B
    //              [*]Bit 12:32B
    //              [/list]
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX pii_length_match : 2;
    //
    // Enables length matching for IDI requests for Lites Group 0. Each bit, when set
    // to 1, enables match for that length for an IDI request. Lites logic supports only
    // lengths 0-16B for PRd and PortIn and only 64B for all other opcodes.
    // 	  [list]
    // 	    [*]Bit 31:64B
    // 	    [*]Bit 30:16B
    // 	    [*]Bit 29:15B
    // 	    [*]Bit 28:14B
    // 	    [*]Bit 27:13B
    // 	    [*]Bit 26:12B
    // 	    [*]Bit 25:11B
    // 	    [*]Bit 24:10B
    // 	    [*]Bit 23:9B
    // 	    [*]Bit 22:8B
    // 	    [*]Bit 21:7B
    // 	    [*]Bit 20:6B
    // 	    [*]Bit 19:5B
    // 	    [*]Bit 18:4B
    // 	    [*]Bit 17:3B
    // 	    [*]Bit 16:2B
    // 	    [*]Bit 15:1B
    // 	    [*]Bit 14:0B
    // 	  [/list]
    //
    // Bits[31:14], RW, default = 0x0
    //
    UINTX idi_length_match : 18;
  } Bits;
  UINTX Data;
} B_CR_LITES0_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES0_OPCODE_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006C94
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector that enables a match on the opcode for C2U IDI requests, PII A2B requests,
    // and U2C IDI requests. All three observation points, Badmit in both slices  and
    // the U2C request interface, use this same opcode match register. Each bit, when
    // set, enables a match on the corresponding opcode, and, when clear, will suppress
    // a match on the corresponding opcode. To match on any opcode, set all bits to 1.
    //       [list]
    //       [*]Bit 31: C2U_Req_CRd
    //       [*]Bit 30: C2U_Req_DRd
    //       [*]Bit 29: C2U_Req_DRdPTE
    //       [*]Bit 28: C2U_Req_SetMonitor
    //       [*]Bit 27: C2U_Req_RFO,U2C_Req_LTWrite_piclet
    //       [*]Bit 26: C2U_Req_PRd,U2C_Req_VLW_piclet
    //       [*]Bit 25: C2U_Req_UcRdF
    //       [*]Bit 24: C2U_Req_PortIn,U2C_Req_SnpCode
    //       [*]Bit 23: C2U_Req_IntA,U2C_Req_SnpData
    //       [*]Bit 22: C2U_Req_Lock
    //       [*]Bit 21: C2U_Req_SplitLock,U2C_Req_IntLog_piclet
    //       [*]Bit 20: C2U_Req_Unlock,U2C_Req_IntPhy_piclet
    //       [*]Bit 19: C2U_Req_ItoM
    //       [*]Bit 18: C2U_Req_SpCyc,U2C_Req_SnpInv
    //       [*]Bit 17: C2U_Req_RdMonitor,U2C_Req_StopReq
    //       [*]Bit 16: C2U_Req_ClrMonitor,U2C_Req_StartReq
    //       [*]Bit 15: C2U_Req_CLFlush
    //       [*]Bit 14: C2U_Req_WbMtoI,U2C_Req_IntLog_MSI
    //       [*]Bit 13: C2U_Req_WbMtoE,U2C_Req_IntPhy_MSI
    //       [*]Bit 12: C2U_Req_WiL
    //       [*]Bit 11: C2U_Req_WCiL
    //       [*]Bit 10: C2U_Req_WCilF
    //       [*]Bit 9: C2U_Req_PortOut
    //       [*]Bit 8: C2U_Req_IntPriUp,U2C_Req_LTWrite
    //       [*]Bit 7: C2U_Req_IntLog
    //       [*]Bit 6: C2U_Req_IntPhy
    //       [*]Bit 5: C2U_Req_EOI,U2C_Req_VLW
    //       [*]Bit 4: C2U_Req_ItoMWr
    //       [*]Bit 3: A2B_Req_SnoopedRead
    //       [*]Bit 2: A2B_Req_UnSnoopedRead,U2C_Req_IntPhy_IPI
    //       [*]Bit 1: A2B_Req_SnoopedWrite
    //       [*]Bit 0: A2B_Req_UnSnoopedWrite,U2C_Req_IntLog_IPI
    //       [/list]
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX opcode_match : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES0_OPCODE_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES0_AGENT_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006C98
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is used to match Logical Processor Core ID for CPU IDI transactions
    // for Lites Group 0. Each bit, when set, enables a match for a transaction originating
    // from that core. When clear, suppresses a match for a transaction from that core.
    //
    //                [list]
    //                [*]Bit 15: CPU7 Core1
    //                [*]Bit 14: CPU7 Core0
    //                [*]Bit 13: CPU6 Core1
    //                [*]Bit 12: CPU6 Core0
    //                [*]Bit 11: CPU5 Core1
    //                [*]Bit 10: CPU5 Core0
    //                [*]Bit 9: CPU4 Core1
    //                [*]Bit 8: CPU4 Core0
    //                [*]Bit 7: CPU3 Core1
    //                [*]Bit 6: CPU3 Core0
    //                [*]Bit 5: CPU2 Core1
    //                [*]Bit 4: CPU2 Core0
    //                [*]Bit 3: CPU1 Core1
    //                [*]Bit 2: CPU1 Core0
    //                [*]Bit 1: CPU0 Core1
    //                [*]Bit 0: CPU0 Core0
    //                [/list]
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX cpu_core_match : 16;
    //
    // This field is used to match VC Channel ID for PII transactions for Lites Group0.
    // Each bit, when set, enables a match for a transaction originating from that VC.
    // When clear, suppresses a match for a transaction from that VC.
    //        [list]
    //        [*]Bit 30: VC14
    //        [*]Bit 29: VC13
    //        [*]Bit 28: VC12
    //        [*]Bit 27: VC11
    //        [*]Bit 26: VC10
    //        [*]Bit 25: VC9
    //        [*]Bit 24: VC8
    //        [*]Bit 23: VC7
    //        [*]Bit 22: VC6
    //        [*]Bit 21: VC5
    //        [*]Bit 20: VC4
    //        [*]Bit 19: VC3
    //        [*]Bit 18: VC2
    //        [*]Bit 17: VC1
    //        [*]Bit 16: VC0
    //        [/list]
    //
    // Bits[30:16], RW, default = 0x0
    //
    UINTX vc_match : 15;
    //
    // This field is used to match IDI transactions from GT for Lites Group0. When set,
    // enables a match for a transaction originating from GT. When clear, suppresses
    // a match for a transaction from GT.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_match : 1;
  } Bits;
  UINTX Data;
} B_CR_LITES0_AGENT_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES0_U2CINTDATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006C9C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // U2C Request IntData[15:8] value is compared with bits [7:0] of this field to generate
    // a match for the U2C request address match.  Bits [15:8] of this field are ignored.
    //  Note that matching based on the IntData[7:0] bits is not supported.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX intdata_match : 16;
    //
    // This mask is for generating Lites Group 0 U2C request alternative view match.
    //  Only bits [7:0] of this field are used; bits [15:8] are ignored.  If a mask bit
    // in this register is 0, then the corresponding bit in the INTDATA_MATCH field is
    // ignored. If the mask bit is 1, then the corresponding bit in the INTDATA_MATCH[7:0]
    // field must match its corresponding u2c request IntData[15:8] bit for a match.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX intdata_mask : 16;
  } Bits;
  UINTX Data;
} B_CR_LITES0_U2CINTDATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES0_ADDR_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CA0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[2:0], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Address value to match for Lites.
    //
    // Bits[38:3], RW, default = 0x0
    //
    UINTX address_match : 36;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_LITES0_ADDR_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES0_ADDR_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CA8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[2:0], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Address mask value used for comparing request address during filter operation
    // for Lites. If the mask bit in this register is 0, then the corresponding bit in
    // the ADDR_MATCH register is ignored. If the mask bit is 1, then the corresponding
    // bit in the ADDR_MATCH register must match the corresponding request address bit
    // for a match.
    //
    // Bits[38:3], RW, default = 0x0
    //
    UINTX address_mask : 36;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_LITES0_ADDR_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES0_DATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CB0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data value to match for Lites.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_match : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES0_DATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES0_DATA_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CB4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data mask value used for comparing data during filter operations for Lites. If
    // the mask bit in this register is 0, then the corresponding bit in the DATA_MATCH
    // register is ignored. If the mask bit is 1, then the corresponding bit in the DATA_MATCH
    // register must match the corresponding bit of the request data for a match.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_mask : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES0_DATA_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES1_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006CC0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enables all match filters for Lites Group 1. The following are the observation
    // points that contain match filters:  Badmit logic within each slice after a transaction
    // is successfully admitted into the B-Unit, U2C request launch, PMI datain for each
    // PMI channel for read data, PMI dataout for each PMI channel for writes, data write
    // from requesters to BRAM in each slice, and read data return on the live bypass
    // and nonlive bypass paths in each slice. To report a match at an observation point,
    // all match criteria for that point must be satisfied.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX enable_group : 1;
    //
    // When set, inverts the polarity of the address match/mask logic, i.e., reports
    // a match for addresses that are not in the specified range.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX invert_addr_match : 1;
    //
    // When set, address match/mask opcode match and agent match registers are used to
    // generate matches for the U2C request observation point. When clear, Badmit observation
    // point matches are reported on the U2C request observation point.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX altu2creqview : 1;
    //
    // When set, this field enables data matching on Lites Group 1.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX enable_data_match : 1;
    //
    // Selects the dword within the 512bit data field that is compared for data mask/matches
    // for Lites Group 1.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX dword_select : 4;
    //
    //
    //          [list]
    //          [*]00: All mask/match hits are suppressed
    //          [*]01: mask/match hits enabled only for Slice0
    //          [*]10: mask/match hits enabled only for Slice1
    //          [*]11: mask/match hits enabled for both Slices
    //          [/list]
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX slice_match : 2;
    //
    // Reserved.
    //
    // Bits[11:10], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Enables length matching for PII requests for Lites Group 1. Each bit, when set
    // to 1, enables length match for the PII request.
    //         [list]
    //         [*]Bit 13:64B
    //         [*]Bit 12:32B
    //         [/list]
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX pii_length_match : 2;
    //
    // Enables length matching for IDI requests for Lites Group 1. Each bit, when set
    // to 1, enables match for that length for an IDI request. Lites logic supports only
    // lengths 0-16B for PRd and PortIn and only 64B for all other opcodes.
    // 	  [list]
    // 	    [*]Bit 31:64B
    // 	    [*]Bit 30:16B
    // 	    [*]Bit 29:15B
    // 	    [*]Bit 28:14B
    // 	    [*]Bit 27:13B
    // 	    [*]Bit 26:12B
    // 	    [*]Bit 25:11B
    // 	    [*]Bit 24:10B
    // 	    [*]Bit 23:9B
    // 	    [*]Bit 22:8B
    // 	    [*]Bit 21:7B
    // 	    [*]Bit 20:6B
    // 	    [*]Bit 19:5B
    // 	    [*]Bit 18:4B
    // 	    [*]Bit 17:3B
    // 	    [*]Bit 16:2B
    // 	    [*]Bit 15:1B
    // 	    [*]Bit 14:0B
    // 	  [/list]
    //
    // Bits[31:14], RW, default = 0x0
    //
    UINTX idi_length_match : 18;
  } Bits;
  UINTX Data;
} B_CR_LITES1_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES1_OPCODE_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CC4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector that enables a match on the opcode for C2U IDI requests, PII A2B requests,
    // and U2C IDI requests. All three observation points -- Badmit in both slices, and
    // the U2C request interface -- use this same opcode match register. Each bit, when
    // set, enables a match on the corresponding opcode, and when clear will suppress
    // a match on the corresponding opcode. To match on any opcode, set all bits to 1.
    //               [list]
    //               [*]Bit 31: C2U_Req_CRd
    //               [*]Bit 30: C2U_Req_DRd
    //               [*]Bit 29: C2U_Req_DRdPTE
    //               [*]Bit 28: C2U_Req_SetMonitor
    //               [*]Bit 27: C2U_Req_RFO,U2C_Req_LTWrite_piclet
    //               [*]Bit 26: C2U_Req_PRd,U2C_Req_VLW_piclet
    //               [*]Bit 25: C2U_Req_UcRdF
    //               [*]Bit 24: C2U_Req_PortIn,U2C_Req_SnpCode
    //               [*]Bit 23: C2U_Req_IntA,U2C_Req_SnpData
    //               [*]Bit 22: C2U_Req_Lock
    //               [*]Bit 21: C2U_Req_SplitLock,U2C_Req_IntLog_piclet
    //               [*]Bit 20: C2U_Req_Unlock,U2C_Req_IntPhy_piclet
    //               [*]Bit 19: C2U_Req_ItoM
    //               [*]Bit 18: C2U_Req_SpCyc,U2C_Req_SnpInv
    //               [*]Bit 17: C2U_Req_RdMonitor,U2C_Req_StopReq
    //               [*]Bit 16: C2U_Req_ClrMonitor,U2C_Req_StartReq
    //               [*]Bit 15: C2U_Req_CLFlush
    //               [*]Bit 14: C2U_Req_WbMtoI,U2C_Req_IntLog_MSI
    //               [*]Bit 13: C2U_Req_WbMtoE,U2C_Req_IntPhy_MSI
    //               [*]Bit 12: C2U_Req_WiL
    //               [*]Bit 11: C2U_Req_WCiL
    //               [*]Bit 10: C2U_Req_WCilF
    //               [*]Bit 9: C2U_Req_PortOut
    //               [*]Bit 8: C2U_Req_IntPriUp,U2C_Req_LTWrite
    //               [*]Bit 7: C2U_Req_IntLog
    //               [*]Bit 6: C2U_Req_IntPhy
    //               [*]Bit 5: C2U_Req_EOI,U2C_Req_VLW
    //               [*]Bit 4: C2U_Req_ItoMWr
    //               [*]Bit 3: A2B_Req_SnoopedRead
    //               [*]Bit 2: A2B_Req_UnSnoopedRead,U2C_Req_IntPhy_IPI
    //               [*]Bit 1: A2B_Req_SnoopedWrite
    //               [*]Bit 0: A2B_Req_UnSnoopedWrite,U2C_Req_IntLog_IPI
    //               [/list]
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX opcode_match : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES1_OPCODE_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES1_AGENT_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CC8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is used to match Logical Processor Core ID for CPU IDI transactions,
    // for Lites Group 1. Each bit, when set, enables a match for a transaction originating
    // from that core. When clear, each bit suppresses a match for a transaction from
    // that core.
    //               [list]
    //               [*]Bit 15: CPU7 Core1
    //               [*]Bit 14: CPU7 Core0
    //               [*]Bit 13: CPU6 Core1
    //               [*]Bit 12: CPU6 Core0
    //               [*]Bit 11: CPU5 Core1
    //               [*]Bit 10: CPU5 Core0
    //               [*]Bit 9:  CPU4 Core1
    //               [*]Bit 8:  CPU4 Core0
    //               [*]Bit 7:  CPU3 Core1
    //               [*]Bit 6:  CPU3 Core0
    //               [*]Bit 5:  CPU2 Core1
    //               [*]Bit 4:  CPU2 Core0
    //               [*]Bit 3:  CPU1 Core1
    //               [*]Bit 2:  CPU1 Core0
    //               [*]Bit 1:  CPU0 Core1
    //               [*]Bit 0:  CPU0 Core0
    //               [/list]
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX cpu_core_match : 16;
    //
    // This field is used to match VC Channel ID for PII transactions for Lites Group1.
    // Each bit, when set, enables a match for a transaction originating from that VC.
    // When clear, each bit suppresses a match for a transaction from that VC.
    //              [list]
    //              [*]Bit 30: VC14
    //              [*]Bit 29: VC13
    //              [*]Bit 28: VC12
    //              [*]Bit 27: VC11
    //              [*]Bit 26: VC10
    //              [*]Bit 25: VC9
    //              [*]Bit 24: VC8
    //              [*]Bit 23: VC7
    //              [*]Bit 22: VC6
    //              [*]Bit 21: VC5
    //              [*]Bit 20: VC4
    //              [*]Bit 19: VC3
    //              [*]Bit 18: VC2
    //              [*]Bit 17: VC1
    //              [*]Bit 16: VC0
    //              [/list]
    //
    // Bits[30:16], RW, default = 0x0
    //
    UINTX vc_match : 15;
    //
    // This field is used to match IDI transactions from GT for Lites Group1. When set,
    // enables a match for a transaction originating from GT. When clear, suppresses
    // a match for a transaction from GT.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_match : 1;
  } Bits;
  UINTX Data;
} B_CR_LITES1_AGENT_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES1_U2CINTDATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CCC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // U2C Request IntData[15:8] value is compared with bits [7:0] of this field to generate
    // a match for the U2C request address match.  Bits [15:8] of this field are ignored.
    //  Note that matching based on the IntData[7:0] bits is not supported.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX intdata_match : 16;
    //
    // This mask is for generating Lites Group 1 U2C request alternative view match.
    //  Only bits [7:0] of this field are used; bits [15:8] are ignored.  If a mask bit
    // in this register is 0, then the corresponding bit in the INTDATA_MATCH field is
    // ignored. If the mask bit is 1, then the corresponding bit in the INTDATA_MATCH[7:0]
    // field must match its corresponding u2c request IntData[15:8] bit for a match.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX intdata_mask : 16;
  } Bits;
  UINTX Data;
} B_CR_LITES1_U2CINTDATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES1_ADDR_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CD0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[2:0], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Address value to match for Lites
    //
    // Bits[38:3], RW, default = 0x0
    //
    UINTX address_match : 36;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_LITES1_ADDR_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES1_ADDR_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CD8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[2:0], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Address mask value used for comparing request address during filter operation
    // for Lites. If the mask bit in this register is 0, then the corresponding bit in
    // the ADDR_MATCH register is ignored. If the mask bit is 1, then the corresponding
    // bit in the ADDR_MATCH register must match the corresponding request address bit
    // for a match.
    //
    // Bits[38:3], RW, default = 0x0
    //
    UINTX address_mask : 36;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_LITES1_ADDR_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES1_DATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CE0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data value to match for Lites.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_match : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES1_DATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES1_DATA_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CE4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data mask value used for comparing data during filter operations for Lites. If
    // the mask bit in this register is 0, then the corresponding bit in the DATA_MATCH
    // register is ignored. If the mask bit is 1, then the corresponding bit in the DATA_MATCH
    // register must match the corresponding bit of the request data for a match.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_mask : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES1_DATA_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES2_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006CF0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enables all match filters for Lites Group 2. The following are the observation
    // points that contain match filters: Badmit logic within each slice after a transaction
    // is successfully admitted into the B-Unit, U2C request launch PMI datain for each
    // PMI channel read data, PMI dataout for each PMI channel write data, agent data
    // write to BRAM in each slice, read data return on the live bypass and nonlive bypass
    // paths in each slice. To report a match at an observation point all match criteria
    // for that point must be satisfied.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX enable_group : 1;
    //
    // When set, inverts the polarity of the address match/mask logic, i.e., reports
    // a match for addresses that are not in the specified range.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX invert_addr_match : 1;
    //
    // When set, address match/mask opcode match and agent match registers are used to
    // generate matches for the U2C request observation point. When clear, Badmit observation
    // point matches are reported on the U2C request observation point.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX altu2creqview : 1;
    //
    // When set, this field enables data matching on Lites Group 2.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX enable_data_match : 1;
    //
    // Selects the dword within the 512bit data field that is compared for data mask/matches
    // for Lites Group 2.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX dword_select : 4;
    //
    // [list]
    //               [*]00: All mask/match hits are suppressed
    //               [*]01: Mask/Match hits enabled only for Slice0
    //               [*]10: Mask/match hits enabled only for Slice1
    //               [*]11: Mask/Match hits enabled for both Slices
    //               [/list]
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX slice_match : 2;
    //
    // Reserved.
    //
    // Bits[11:10], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Enables length matching for PII requests for Lites Group 2. Each bit, when set
    // to 1, enables  length match for the PII request.
    //         [list]
    //         [*]Bit 13:64B
    //         [*]Bit 12:32B
    //         [/list]
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX pii_length_match : 2;
    //
    // Enables length matching for IDI requests for Lites Group 2. Each bit, when set
    // to 1, enables match for that length for an IDI request. Lites logic supports only
    // lengths 0-16B for PRd and PortIn and only 64B for all other opcodes.
    // 	  [list]
    // 	    [*]Bit 31:64B
    // 	    [*]Bit 30:16B
    // 	    [*]Bit 29:15B
    // 	    [*]Bit 28:14B
    // 	    [*]Bit 27:13B
    // 	    [*]Bit 26:12B
    // 	    [*]Bit 25:11B
    // 	    [*]Bit 24:10B
    // 	    [*]Bit 23:9B
    // 	    [*]Bit 22:8B
    // 	    [*]Bit 21:7B
    // 	    [*]Bit 20:6B
    // 	    [*]Bit 19:5B
    // 	    [*]Bit 18:4B
    // 	    [*]Bit 17:3B
    // 	    [*]Bit 16:2B
    // 	    [*]Bit 15:1B
    // 	    [*]Bit 14:0B
    // 	  [/list]
    //
    // Bits[31:14], RW, default = 0x0
    //
    UINTX idi_length_match : 18;
  } Bits;
  UINTX Data;
} B_CR_LITES2_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES2_OPCODE_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CF4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector that enables a match on the opcode for C2U IDI requests, PII A2B requests,
    // and U2C IDI requests. All three observation points -- Badmit in both slices, and
    // the U2C request interface -- use this same opcode match register. Each bit, when
    // set, enables a match on the corresponding opcode and when clear will suppress
    // a match on the corresponding opcode. To match on any opcode, set all bits to 1.
    //
    //               [list]
    //               [*]Bit 31: C2U_Req_CRd
    //               [*]Bit 30: C2U_Req_DRd
    //               [*]Bit 29: C2U_Req_DRdPTE
    //               [*]Bit 28: C2U_Req_SetMonitor
    //               [*]Bit 27: C2U_Req_RFO,U2C_Req_LTWrite_piclet
    //               [*]Bit 26: C2U_Req_PRd,U2C_Req_VLW_piclet
    //               [*]Bit 25: C2U_Req_UcRdF
    //               [*]Bit 24: C2U_Req_PortIn,U2C_Req_SnpCode
    //               [*]Bit 23: C2U_Req_IntA,U2C_Req_SnpData
    //               [*]Bit 22: C2U_Req_Lock
    //               [*]Bit 21: C2U_Req_SplitLock,U2C_Req_IntLog_piclet
    //               [*]Bit 20: C2U_Req_Unlock,U2C_Req_IntPhy_piclet
    //               [*]Bit 19: C2U_Req_ItoM
    //               [*]Bit 18: C2U_Req_SpCyc,U2C_Req_SnpInv
    //               [*]Bit 17: C2U_Req_RdMonitor,U2C_Req_StopReq
    //               [*]Bit 16: C2U_Req_ClrMonitor,U2C_Req_StartReq
    //               [*]Bit 15: C2U_Req_CLFlush
    //               [*]Bit 14: C2U_Req_WbMtoI,U2C_Req_IntLog_MSI
    //               [*]Bit 13: C2U_Req_WbMtoE,U2C_Req_IntPhy_MSI
    //               [*]Bit 12: C2U_Req_WiL
    //               [*]Bit 11: C2U_Req_WCiL
    //               [*]Bit 10: C2U_Req_WCilF
    //               [*]Bit 9:  C2U_Req_PortOut
    //               [*]Bit 8:  C2U_Req_IntPriUp,U2C_Req_LTWrite
    //               [*]Bit 7:  C2U_Req_IntLog
    //               [*]Bit 6:  C2U_Req_IntPhy
    //               [*]Bit 5:  C2U_Req_EOI,U2C_Req_VLW
    //               [*]Bit 4:  C2U_Req_ItoMWr
    //               [*]Bit 3:  A2B_Req_SnoopedRead
    //               [*]Bit 2:  A2B_Req_UnSnoopedRead,U2C_Req_IntPhy_IPI
    //               [*]Bit 1:  A2B_Req_SnoopedWrite
    //               [*]Bit 0:  A2B_Req_UnSnoopedWrite,U2C_Req_IntLog_IPI
    //               [*][/list]
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX opcode_match : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES2_OPCODE_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES2_AGENT_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CF8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is used to match Logical Processor Core ID for CPU IDI transactions
    // for Lites Group 2. Each bit, when set, enables a match for a transaction originating
    // from that core. When clear, suppresses a match for a transaction from that core.
    //
    //               [list]
    //               [*]Bit 15: CPU7 Core1
    //               [*]Bit 14: CPU7 Core0
    //               [*]Bit 13: CPU6 Core1
    //               [*]Bit 12: CPU6 Core0
    //               [*]Bit 11: CPU5 Core1
    //               [*]Bit 10: CPU5 Core0
    //               [*]Bit 9:  CPU4 Core1
    //               [*]Bit 8:  CPU4 Core0
    //               [*]Bit 7:  CPU3 Core1
    //               [*]Bit 6:  CPU3 Core0
    //               [*]Bit 5:  CPU2 Core1
    //               [*]Bit 4:  CPU2 Core0
    //               [*]Bit 3:  CPU1 Core1
    //               [*]Bit 2:  CPU1 Core0
    //               [*]Bit 1:  CPU0 Core1
    //               [*]Bit 0:  CPU0 Core0
    //               [/list]
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX cpu_core_match : 16;
    //
    // This field is used to match VC Channel ID, for PII transactions for Lites Group2.
    // Each bit, when set, enables a match for a transaction originating from that VC.
    // When clear, suppresses a match for a transaction from that VC.
    //              [list]
    //              [*]Bit 30: VC14
    //              [*]Bit 29: VC13
    //              [*]Bit 28: VC12
    //              [*]Bit 27: VC11
    //              [*]Bit 26: VC10
    //              [*]Bit 25: VC9
    //              [*]Bit 24: VC8
    //              [*]Bit 23: VC7
    //              [*]Bit 22: VC6
    //              [*]Bit 21: VC5
    //              [*]Bit 20: VC4
    //              [*]Bit 19: VC3
    //              [*]Bit 18: VC2
    //              [*]Bit 17: VC1
    //              [*]Bit 16: VC0
    //              [/list]
    //
    // Bits[30:16], RW, default = 0x0
    //
    UINTX vc_match : 15;
    //
    // This field is used to match IDI ransactions from GT for Lites Group2. When set,
    // enables a match for a transaction originating from GT. When clear, suppresses
    // a match for a transaction from GT.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_match : 1;
  } Bits;
  UINTX Data;
} B_CR_LITES2_AGENT_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES2_U2CINTDATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006CFC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // U2C Request IntData[15:8] value is compared with bits [7:0] of this field to generate
    // a match for the U2C request address match.  Bits [15:8] of this field are ignored.
    //  Note that matching based on the IntData[7:0] bits is not supported.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX intdata_match : 16;
    //
    // This mask is for generating Lites Group 2 U2C request alternative view match.
    //  Only bits [7:0] of this field are used; bits [15:8] are ignored.  If a mask bit
    // in this register is 0, then the corresponding bit in the INTDATA_MATCH field is
    // ignored. If the mask bit is 1, then the corresponding bit in the INTDATA_MATCH[7:0]
    // field must match its corresponding u2c request IntData[15:8] bit for a match.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX intdata_mask : 16;
  } Bits;
  UINTX Data;
} B_CR_LITES2_U2CINTDATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES2_ADDR_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D00
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[2:0], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Address value to match for Lites.
    //
    // Bits[38:3], RW, default = 0x0
    //
    UINTX address_match : 36;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_LITES2_ADDR_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES2_ADDR_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D08
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[2:0], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Address mask value used for comparing request address during filter operation
    // for Lites. If the mask bit in this register is 0, then the corresponding bit in
    // the ADDR_MATCH register is ignored. If the mask bit is 1, then the corresponding
    // bit in the ADDR_MATCH register must match the corresponding request address bit
    // for a match.
    //
    // Bits[38:3], RW, default = 0x0
    //
    UINTX address_mask : 36;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_LITES2_ADDR_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES2_DATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D10
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data value to match for Lites
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_match : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES2_DATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES2_DATA_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D14
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data mask value used for comparing data during filter operations for Lites. If
    // the mask bit in this register is 0, then the corresponding bit in the DATA_MATCH
    // register is ignored. If the mask bit is 1, then the corresponding bit in the DATA_MATCH
    // register must match the corresponding bit of the request data for a match.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_mask : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES2_DATA_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES3_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006D20
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Enables all match filters for Lites Group 3. The following are the observation
    // points that contain match filters  Badmit logic within each slice after a transaction
    // is successfully admitted into the B-Unit U2C request launch PMI datain for each
    // PMI channel read data PMI dataout for each PMI channel write data agent data write
    // to BRAM in each slice read data return on the live bypass and nonlive bypass paths
    // in each slice.  To report a match at an observation point all match criteria for
    // that point must be satisfied.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX enable_group : 1;
    //
    // When set inverts the polarity of the address match/mask logic i.e. reports a match
    // for addresses that are not in the specified range.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX invert_addr_match : 1;
    //
    // When set, address match/mask, opcode match and agent match registers are used
    // to generate matches for the U2C request observation point. When clear, Badmit
    // observation point matches are reported on the U2C request observation point.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX altu2creqview : 1;
    //
    // When set, this field enables data matching on Lites Group 3.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX enable_data_match : 1;
    //
    // Selects the dword within the 512bit data field that is compared for data mask/matches
    // for Lites Group 3.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX dword_select : 4;
    //
    // [list]
    //               [*]00: All mask/match hits are suppressed
    //               [*]01: mask/match hits enabled only for Slice0
    //               [*]10: mask/match hits enabled only for Slice1
    //               [*]11: mask/match hits enabled for both Slices
    //               [/list]
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX slice_match : 2;
    //
    // Reserved.
    //
    // Bits[11:10], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Enables length matching for PII requests for Lites Group 3. Each bit, when set
    // to 1, enables length match for the PII request:
    //         [list]
    //         [*] Bit 13:64B
    //         [*] Bit 12:32B
    //         [/list]
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX pii_length_match : 2;
    //
    // Enables length matching for IDI requests for Lites Group 3. Each bit, when set
    // to 1, enables match for that length for an IDI request. Lites logic supports only
    // lengths 0-16B for PRd and PortIn and only 64B for all other opcodes.
    // 	  [list]
    // 	    [*]Bit 31:64B
    // 	    [*]Bit 30:16B
    // 	    [*]Bit 29:15B
    // 	    [*]Bit 28:14B
    // 	    [*]Bit 27:13B
    // 	    [*]Bit 26:12B
    // 	    [*]Bit 25:11B
    // 	    [*]Bit 24:10B
    // 	    [*]Bit 23:9B
    // 	    [*]Bit 22:8B
    // 	    [*]Bit 21:7B
    // 	    [*]Bit 20:6B
    // 	    [*]Bit 19:5B
    // 	    [*]Bit 18:4B
    // 	    [*]Bit 17:3B
    // 	    [*]Bit 16:2B
    // 	    [*]Bit 15:1B
    // 	    [*]Bit 14:0B
    // 	  [/list]
    //
    // Bits[31:14], RW, default = 0x0
    //
    UINTX idi_length_match : 18;
  } Bits;
  UINTX Data;
} B_CR_LITES3_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES3_OPCODE_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D24
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector that enables a match on the opcode for C2U IDI requests, PII A2B requests,
    // and U2C IDI requests. All three observation points -- Badmit in both slices, and
    // the U2C request interface -- use this same opcode match register. Each bit, when
    // set, enables a match on the corresponding opcode, and when clear will suppress
    // a match on the corresponding opcode. To match on any opcode, set all bits to 1.
    //
    //               [list]
    //               [*]Bit 31: C2U_Req_CRd
    //               [*]Bit 30: C2U_Req_DRd
    //               [*]Bit 29: C2U_Req_DRdPTE
    //               [*]Bit 28: C2U_Req_SetMonitor
    //               [*]Bit 27: C2U_Req_RFO,U2C_Req_LTWrite_piclet
    //               [*]Bit 26: C2U_Req_PRd,U2C_Req_VLW_piclet
    //               [*]Bit 25: C2U_Req_UcRdF
    //               [*]Bit 24: C2U_Req_PortIn,U2C_Req_SnpCode
    //               [*]Bit 23: C2U_Req_IntA,U2C_Req_SnpData
    //               [*]Bit 22: C2U_Req_Lock
    //               [*]Bit 21: C2U_Req_SplitLock,U2C_Req_IntLog_piclet
    //               [*]Bit 20: C2U_Req_Unlock,U2C_Req_IntPhy_piclet
    //               [*]Bit 19: C2U_Req_ItoM
    //               [*]Bit 18: C2U_Req_SpCyc,U2C_Req_SnpInv
    //               [*]Bit 17: C2U_Req_RdMonitor,U2C_Req_StopReq
    //               [*]Bit 16: C2U_Req_ClrMonitor,U2C_Req_StartReq
    //               [*]Bit 15: C2U_Req_CLFlush
    //               [*]Bit 14: C2U_Req_WbMtoI,U2C_Req_IntLog_MSI
    //               [*]Bit 13: C2U_Req_WbMtoE,U2C_Req_IntPhy_MSI
    //               [*]Bit 12: C2U_Req_WiL
    //               [*]Bit 11: C2U_Req_WCiL
    //               [*]Bit 10: C2U_Req_WCilF
    //               [*]Bit 9:  C2U_Req_PortOut
    //               [*]Bit 8:  C2U_Req_IntPriUp,U2C_Req_LTWrite
    //               [*]Bit 7:  C2U_Req_IntLog
    //               [*]Bit 6:  C2U_Req_IntPhy
    //               [*]Bit 5:  C2U_Req_EOI,U2C_Req_VLW
    //               [*]Bit 4:  C2U_Req_ItoMWr
    //               [*]Bit 3:  A2B_Req_SnoopedRead
    //               [*]Bit 2:  A2B_Req_UnSnoopedRead,U2C_Req_IntPhy_IPI
    //               [*]Bit 1:  A2B_Req_SnoopedWrite
    //               [*]Bit 0:  A2B_Req_UnSnoopedWrite,U2C_Req_IntLog_IPI
    //               [/list]
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX opcode_match : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES3_OPCODE_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES3_AGENT_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D28
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is used to match Logical Processor Core ID for CPU IDI transactions,
    // for Lites Group 3. Each bit, when set, enables a match for a transaction originating
    // from that core. When clear, the bit suppresses a match for a transaction from
    // that core.
    //               [list]
    //               [*]Bit 15: CPU7 Core1
    //               [*]Bit 14: CPU7 Core0
    //               [*]Bit 13: CPU6 Core1
    //               [*]Bit 12: CPU6 Core0
    //               [*]Bit 11: CPU5 Core1
    //               [*]Bit 10: CPU5 Core0
    //               [*]Bit 9:  CPU4 Core1
    //               [*]Bit 8:  CPU4 Core0
    //               [*]Bit 7:  CPU3 Core1
    //               [*]Bit 6:  CPU3 Core0
    //               [*]Bit 5:  CPU2 Core1
    //               [*]Bit 4:  CPU2 Core0
    //               [*]Bit 3:  CPU1 Core1
    //               [*]Bit 2:  CPU1 Core0
    //               [*]Bit 1:  CPU0 Core1
    //               [*]Bit 0:  CPU0 Core0
    //               [/list]
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX cpu_core_match : 16;
    //
    // This field is used to match VC Channel ID for PII transactions, for Lites Group3.
    // Each bit, when set, enables a match for a transaction originating from that VC.
    // When clear, the bit suppresses a match for a transaction from that VC.
    //              [list]
    //              [*]Bit 30: VC14
    //              [*]Bit 29: VC13
    //              [*]Bit 28: VC12
    //              [*]Bit 27: VC11
    //              [*]Bit 26: VC10
    //              [*]Bit 25: VC9
    //              [*]Bit 24: VC8
    //              [*]Bit 23: VC7
    //              [*]Bit 22: VC6
    //              [*]Bit 21: VC5
    //              [*]Bit 20: VC4
    //              [*]Bit 19: VC3
    //              [*]Bit 18: VC2
    //              [*]Bit 17: VC1
    //              [*]Bit 16: VC0
    //              [/list]
    //
    // Bits[30:16], RW, default = 0x0
    //
    UINTX vc_match : 15;
    //
    // This field is used to match IDI ransactions from GT for Lites Group3. When set,
    // enables a match for a transaction originating from GT. When clear, suppresses
    // a match for a transaction from GT.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX gt_match : 1;
  } Bits;
  UINTX Data;
} B_CR_LITES3_AGENT_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES3_U2CINTDATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D2C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // U2C Request IntData[15:8] value is compared with bits [7:0] of this field to generate
    // a match for the U2C request address match.  Bits [15:8] of this field are ignored.
    //  Note that matching based on the IntData[7:0] bits is not supported.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX intdata_match : 16;
    //
    // This mask is for generating Lites Group 3 U2C request alternative view match.
    //  Only bits [7:0] of this field are used; bits [15:8] are ignored.  If a mask bit
    // in this register is 0, then the corresponding bit in the INTDATA_MATCH field is
    // ignored. If the mask bit is 1, then the corresponding bit in the INTDATA_MATCH[7:0]
    // field must match its corresponding u2c request IntData[15:8] bit for a match.
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX intdata_mask : 16;
  } Bits;
  UINTX Data;
} B_CR_LITES3_U2CINTDATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES3_ADDR_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D30
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[2:0], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Address value to match for Lites.
    //
    // Bits[38:3], RW, default = 0x0
    //
    UINTX address_match : 36;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_LITES3_ADDR_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES3_ADDR_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D38
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[2:0], RO, default = 0x0
    //
    UINTX reserved_0 : 3;
    //
    // Address mask value used for comparing request address during filter operation
    // for Lites. If the mask bit in this register is 0, then the corresponding bit in
    // the ADDR_MATCH register is ignored. If the mask bit is 1,  then the corresponding
    // bit in the ADDR_MATCH register must match the corresponding request address bit
    // for a match.
    //
    // Bits[38:3], RW, default = 0x0
    //
    UINTX address_mask : 36;
    //
    // Reserved.
    //
    // Bits[63:39], RO, default = 0x0
    //
    UINTX reserved_1 : 25;
  } Bits;
  UINTX Data;
} B_CR_LITES3_ADDR_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES3_DATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D40
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data value to match for Lites
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_match : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES3_DATA_MATCH_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITES3_DATA_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006D44
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data mask value used for comparing data during filter operations for Lites. If
    // the mask bit in this register is 0, then the corresponding bit in the DATA_MATCH
    // register is ignored. If the mask bit is 1, then the corresponding bit in the DATA_MATCH
    // register must match the corresponding bit of the request data for a match.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_mask : 32;
  } Bits;
  UINTX Data;
} B_CR_LITES3_DATA_MASK_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_LITESEMON_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG  0x00006D48
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When set to 0, B-Unit exposes only PMI channel 0 views in either slice. No Lites
    // observability of any transaction routed to PMI channel 1 in either slice. When
    // set to 1, B-Unit exposes only PMI Channel 1 views in either slice.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lites_pmi_select : 1;
    //
    // When set to 0, B-Unit and T-Unit expose only Slice0 views. No Lites observability
    // of any transaction routed to Slice 1. When set to 1, B-Unit and T-Unit expose
    // only Slice1 views.  No Lites observability of any transaction routed to Slice0.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX lites_slice_select : 1;
    //
    // B-Unit and T-Unit expose only the views corresponding to the IDI agent specified
    // in this field. IDI agents only refer to GT and GLM modules, not Sunits. Used only
    // on the C2U response views.
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX lites_idi_select : 3;
    //
    // B-Unit and T-Unit expose only the Emons corresponding to the IDI agent(s) specified
    // in this field (it is a mask). IDI agent refers to GLM modules and GT not Sunits.
    //
    // Bits[12:5], RW, default = 0x0
    //
    UINTX emon_idi_mask : 8;
    //
    // B-Unit and T-Unit expose only the Emons corresponding to the VC(s) specified in
    // this field (it is a mask).
    //
    // Bits[23:13], RW, default = 0x0
    //
    UINTX emon_vc_mask : 11;
    //
    // Select barb ingress FIFO.
    //              [list]
    //              [*]000: IDI attach point -0 -mono | per slice fifo0
    //              [*]001: IDI attach point -0 -slice fifo1
    //              [*]010: IDI attach point -1 -mono | per slice fifo1
    //              [*]011: IDI attach point -1 - slice fifo
    //              [*]100: IDI attach point -2 -mono | GT slice0(bxt)
    //              [*]101: IDI attach point -2 - slice fifo | GT slice1(bxt)
    //              [*]110: IDI attach point -3 -mono | per slice fifo0
    //              [*]111: IDI attach point -3 - slice fifo1
    //              [/list]
    //
    // Bits[26:24], RW, default = 0x0
    //
    UINTX emon_barb_ingress_select : 3;
    //
    // Select barb conflictQ FIFO.
    //               [list]
    //               [*]0000 to 0111: pii0 to pii7
    //               [*]1xx0: idi slice0
    //               [*]1xx1: idi slice1
    //               [/list]
    //
    // Bits[30:27], RW, default = 0x0
    //
    UINTX emon_barb_cq_select : 4;
    //
    // [list]
    //               [*]0: Lites logic is disabled. All Lites Views will be driven to
    // 0s.
    //               [*]1: Lites logic is enabled.
    //               [/list]
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX enable_lites : 1;
  } Bits;
  UINTX Data;
} B_CR_LITESEMON_CTL_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BARBCTRL0_BUNIT_BOXTYPE_REG                   0x00006D4C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Arbiter weight for Agent 0.
    //
    // Bits[5:0], RW, default = 0x4
    //
    UINTX agent0_weight : 6;
    //
    // Reserved.
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
    //
    // Arbiter weight for Agent 1.
    //
    // Bits[13:8], RW, default = 0x4
    //
    UINTX agent1_weight : 6;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved_2 : 2;
    //
    // Arbiter weight for Agent 2.
    //
    // Bits[21:16], RW, default = 0x4
    //
    UINTX agent2_weight : 6;
    //
    // Reserved.
    //
    // Bits[23:22], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Arbiter weight for Agent 3.
    //
    // Bits[29:24], RW, default = 0x4
    //
    UINTX agent3_weight : 6;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
  } Bits;
  UINTX Data;
} B_CR_BARBCTRL0_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BARBCTRL1_BUNIT_BOXTYPE_REG                   0x00006D50
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Arbiter weight for Agent 4.
    //
    // Bits[5:0], RW, default = 0x4
    //
    UINTX agent4_weight : 6;
    //
    // Reserved.
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
    //
    // Arbiter weight for Agent 5.
    //
    // Bits[13:8], RW, default = 0x4
    //
    UINTX agent5_weight : 6;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved_2 : 2;
    //
    // Arbiter weight for Agent 6.
    //
    // Bits[21:16], RW, default = 0x4
    //
    UINTX agent6_weight : 6;
    //
    // Reserved.
    //
    // Bits[23:22], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Arbiter weight for Agent 7.
    //
    // Bits[29:24], RW, default = 0x4
    //
    UINTX agent7_weight : 6;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
  } Bits;
  UINTX Data;
} B_CR_BARBCTRL1_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BSCHWT0_BUNIT_BOXTYPE_REG                     0x00006D54
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Arbiter weight for Agent 0.
    //
    // Bits[5:0], RW, default = 0x4
    //
    UINTX agent0_weight : 6;
    //
    // Reserved.
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
    //
    // Arbiter weight for Agent 1.
    //
    // Bits[13:8], RW, default = 0x4
    //
    UINTX agent1_weight : 6;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved_2 : 2;
    //
    // Arbiter weight for Agent 2.
    //
    // Bits[21:16], RW, default = 0x4
    //
    UINTX agent2_weight : 6;
    //
    // Reserved.
    //
    // Bits[23:22], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Arbiter weight for Agent 3.
    //
    // Bits[29:24], RW, default = 0x4
    //
    UINTX agent3_weight : 6;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
  } Bits;
  UINTX Data;
} B_CR_BSCHWT0_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BSCHWT1_BUNIT_BOXTYPE_REG                     0x00006D58
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Arbiter weight for Agent 4.
    //
    // Bits[5:0], RW, default = 0x4
    //
    UINTX agent4_weight : 6;
    //
    // Reserved.
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
    //
    // Arbiter weight for Agent 5.
    //
    // Bits[13:8], RW, default = 0x4
    //
    UINTX agent5_weight : 6;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved_2 : 2;
    //
    // Arbiter weight for Agent 6.
    //
    // Bits[21:16], RW, default = 0x4
    //
    UINTX agent6_weight : 6;
    //
    // Reserved.
    //
    // Bits[23:22], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Arbiter weight for Agent 7.
    //
    // Bits[29:24], RW, default = 0x4
    //
    UINTX agent7_weight : 6;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
  } Bits;
  UINTX Data;
} B_CR_BSCHWT1_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BSCHWT2_BUNIT_BOXTYPE_REG                     0x00006D5C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Arbiter weight for Agent 8.
    //
    // Bits[5:0], RW, default = 0x4
    //
    UINTX agent8_weight : 6;
    //
    // Reserved.
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
    //
    // Arbiter weight for Agent 9.
    //
    // Bits[13:8], RW, default = 0x4
    //
    UINTX agent9_weight : 6;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved_2 : 2;
    //
    // Arbiter weight for Agent 10.
    //
    // Bits[21:16], RW, default = 0x4
    //
    UINTX agent10_weight : 6;
    //
    // Reserved.
    //
    // Bits[23:22], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Arbiter weight for Agent 11.
    //
    // Bits[29:24], RW, default = 0x4
    //
    UINTX agent11_weight : 6;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
  } Bits;
  UINTX Data;
} B_CR_BSCHWT2_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BSCHWT3_BUNIT_BOXTYPE_REG                     0x00006D60
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Arbiter weight for Agent 12.
    //
    // Bits[5:0], RW, default = 0x4
    //
    UINTX agent12_weight : 6;
    //
    // Reserved.
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
    //
    // Arbiter weight for Agent 13.
    //
    // Bits[13:8], RW, default = 0x4
    //
    UINTX agent13_weight : 6;
    //
    // Reserved.
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved_2 : 2;
    //
    // Arbiter weight for Agent 14.
    //
    // Bits[21:16], RW, default = 0x4
    //
    UINTX agent14_weight : 6;
    //
    // Reserved.
    //
    // Bits[23:22], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Arbiter weight for Agent 15.
    //
    // Bits[29:24], RW, default = 0x4
    //
    UINTX agent15_weight : 6;
    //
    // Reserved.
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
  } Bits;
  UINTX Data;
} B_CR_BSCHWT3_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BWFLUSH_BUNIT_BOXTYPE_REG                     0x00006D64
#ifndef ASM_INC
typedef union {
  struct {
    //
    // High water mark for dirty entries retained by the B-Unit. B-Unit will immediately
    // attempt to flush any dirty entry, hence setting the low water mark to 0.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dirty_hwm : 8;
    //
    // Low water mark for dirty entries retained by the B-Unit. B-Unit will immediately
    // attempt to flush any dirty entry, hence setting the low water mark to 0.
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dirty_lwm : 8;
    //
    // All dirty entries in the B-Unit, in both slices, have been flushed.
    //
    // Bits[16:16], RO/V, default = 0x1
    //
    UINTX all_entries_flushed : 1;
    //
    // Reserved.
    //
    // Bits[23:17], RO, default = 0x0
    //
    UINTX reserved_0 : 7;
    //
    // All write commands are blocked at Badmit if the number of write commands in the
    // Flush Pool exceeeds this value.
    //
    // Bits[31:24], RW, default = 0xFF
    //
    UINTX flush_threshold : 8;
  } Bits;
  UINTX Data;
} B_CR_BWFLUSH_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BFLWT_BUNIT_BOXTYPE_REG                       0x00006D68
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of read requests sent to a PMI channel before switching to scheduling write
    // requests, when use of flush weights is not disabled.
    //
    // Bits[5:0], RW, default = 0x4
    //
    UINTX read_weights : 6;
    //
    // Reserved.
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Number of write requests sent to a PMI channel before switching to scheduling
    // read requests, when use of flush weights is not disabled.
    //
    // Bits[13:8], RW, default = 0x4
    //
    UINTX write_weights : 6;
    //
    // Reserved.
    //
    // Bits[30:14], RO, default = 0x0
    //
    UINTX reserved_1 : 17;
    //
    // When set to 1, disables flush weights. Flushing of dirty entries will start when
    // Dirty Limit is HWM, and continue until Dirty Limit is LWM. No reads will be scheduled
    // in between.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX disable_flush_weights : 1;
  } Bits;
  UINTX Data;
} B_CR_BFLWT_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BISOCWT_BUNIT_BOXTYPE_REG                     0x00006D6C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Weight for non-high priority isochronous and best effort requests.
    //
    // Bits[5:0], RW, default = 0xF
    //
    UINTX non_isoc_request_weights : 6;
    //
    // Reserved.
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_0 : 2;
    //
    // Weight for high priority isochronous requests.
    //
    // Bits[13:8], RW, default = 0x3F
    //
    UINTX isoc_request_weights : 6;
    //
    // Reserved.
    //
    // Bits[30:14], RO, default = 0x0
    //
    UINTX reserved_1 : 17;
    //
    // When set to 1, enables switching from scheduling High Priority ISOC requests to
    // scheduling Best Effort and Low Priority ISOC requests, based on ISOC weights and
    // NONISOC weights.
    //
    // Bits[31:31], RW, default = 0x1
    //
    UINTX enable_isoc_weights : 1;
  } Bits;
  UINTX Data;
} B_CR_BISOCWT_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BCTRL2_BUNIT_BOXTYPE_REG                      0x00006D70
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This mode causes reads or writes from any requester interface to dirty valid B-Unit
    // buffer entries to stall on the appropriate requester interface until the entry
    // has been flushed from the B-Unit.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dirty_stall : 1;
    //
    // This mode causes reads to clean valid B-Unit buffer entries to look like misses
    // instead of hits. When this bit is set -- even when all requested bytes are valid
    // and present in the BRAM data buffer -- B-Unit will send read requests over the
    // PMI interface to re-fetch the data from DRAM, instead of returning it from the
    // BRAM.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX miss_valid_entries : 1;
    //
    // Enable Any writes (IWB or normal writes) to set the read_done bit in bstat, which
    // enables return of data from the BRAM cache instead of Memory.
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX enable_read_done_for_write : 1;
    //
    // This mode causes B-Unit to automatically issue a flush to PMI, thus writing correct
    // data back to memory for any read request that returns with a correctable data
    // error.
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX demand_scrub_enable : 1;
    //
    // When set, B-unit will send 64B PMI read requests for transactions requiring read
    // access to DRAM. Must always be set to one, otherwise functional errors may occur.
    //
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX enable_64b_read : 1;
    //
    // When set, B-unit will send 64B PMI Write requests for transactions requiring write
    // access to DRAM. Must always be set to one, otherwise functional errors may occur.
    //
    //
    // Bits[5:5], RW, default = 0x1
    //
    UINTX enable_64b_write : 1;
    //
    // Reserved.
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // The number of clock cycles that the B-Unit waits before starting a casual dirty
    // flush. Casual Flush feature will not be enabled by PND2 architecture. Instead,
    // a dirty write will be made eligible for scheduling immediately.
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX casual_timer : 8;
    //
    // Timer threshold to clear rd_done bits or flush a BRAM entry, if dirty. The value
    // specified is in multiples of 250ns. For each time interval specified, the read
    // done status of one BRAM entry will be cleared based on a BTAG index which is then
    // incremented to point to the next BRAM entry.
    //
    // Bits[23:16], RW, default = 0xF
    //
    UINTX bram_read_invalidate_time : 8;
    //
    // If the HH widget gets an error, allow transactions to get arbitrated.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX mot_disable_stall_arb_on_err : 1;
    //
    // If DRAM ECC is enabled, the data error bits from the Dunit is used for indicating
    // the derror for the corresponding transactions to the agents and forcing the poison
    // bit when BUNIT PARITY is unsupported and Read for partial writes are enabled
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX dram_ecc_enable : 1;
    //
    // Reserved.
    //
    // Bits[30:26], RO, default = 0x0
    //
    UINTX reserved_2 : 5;
    //
    // When set to 1, enables the BRAM to clear the RD_DONE bit and flush dirty data
    // when a timer expires. Used when parity is not enabled, to force the B-Unit to
    // not indefinitely cache previously read lines, and also to cause a flush of dirty
    // data that has been written to the BRAM entry.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX enable_read_invalidate_timer : 1;
  } Bits;
  UINTX Data;
} B_CR_BCTRL2_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BCTRL3_BUNIT_BOXTYPE_REG                      0x00006D7C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Specifies the threshold for the number of consecutive requests B-admit arbiter
    // will grant from the same Slice ingress FIFO for an IDI attachpoint, while the
    // other Slice also has a request available
    //
    // Bits[7:0], RW, default = 0x40
    //
    UINTX slice_anti_starve_threshold : 8;
    //
    // When set, B-unit will always make an available request in each instantiated per-slice
    // C2U Ingress FIFO for all IDI attach points eligible for arbitration in their respective
    // odd/even sa2xclk clock.   When clear, B-unit will mask a C2U Ingress Slice's available
    // request from arbitration when SLICE_ANTI_STARVE_THRESHOLD consecutive requests
    // has been granted for that IDI attach point from the other Slice Ingress FIFO.
    //   Has no effect for IDI attach points that do not have per-slice Ingress FIFOs
    //
    // Bits[8:8], RW, default = 0x1
    //
    UINTX slice_anti_starve_disable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} B_CR_BCTRL3_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_AC_RS0_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG         0x00006D74
#ifndef ASM_INC
typedef union {
  struct {
    //
    // RS Asset Classification bit for IMRs 0-19. PII transactions from RS0 that hit
    // an enabled IMR address range will be allowed access only when both of the following
    // conditions are met: a) Request SAI is in the legal permitted list as specified
    // in the IMRs RAC/WAC policy registers and b) IMR_AC_RS bit corresponding to the
    // IMR is set to 1. PII RS0 transactions targeting DRAM that do not hit any enabled
    // IMR or special protected regions will always be allowed access.
    //
    // Bits[19:0], RW, default = 0x0
    //
    UINTX imr_rs0_en : 20;
    //
    // RS Asset Classification bit for the MOT buffer. PII transactions from RS0 that
    // hit the MOT buffer will be allowed access only when both of the following conditions
    // are met: a) Request SAI is in the legal permitted list, as specified in the RAC/WAC
    // policy registers, and b) MOT_RS0_EN bit is set to 1. PII RS0 transactions targeting
    // DRAM that do not hit any enabled IMR or special protected regions will always
    // be allowed access.
    //
    // Bits[20:20], RW, default = 0x1
    //
    UINTX mot_rs0_en : 1;
    //
    // Reserved.
    //
    // Bits[31:21], RO, default = 0x0
    //
    UINTX reserved_0 : 11;
  } Bits;
  UINTX Data;
} B_CR_AC_RS0_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_P_U_CODEWR_ALLRD_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006C28
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed access to the P_U_CODEWR_ALLRD_RAC,
    // P_U_CODEWR_ALLRD_WAC, and P_U_CODEWR_ALLRD_CP registers, based on the value from
    // the agent's 6bit SAI field.
    //
    // Bits[63:0], RW, default = 0x40001000202
    //
    UINTX ia_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_P_U_CODEWR_ALLRD_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_P_U_CODEWR_ALLRD_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006C30
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access to the B-Unit
    // Pcode/Ucode Write, All Read policy registers, based on each agent's 6bit encoded
    // SAI value.
    //
    // Bits[63:0], RO, default = 0xFFFFFFFFFFFFFFFF
    //
    UINTX ia_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_P_U_CODEWR_ALLRD_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_P_U_CODEWR_ALLRD_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006C38
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the B-Unit
    // IA Core Configuration registers, based on each agent's 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0x40001000202
    //
    UINTX ia_sai_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_P_U_CODEWR_ALLRD_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIOSWR_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG      0x00006C08
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access to the BIOSWR_RAC,
    // BIOSWR_WAC, and BIOSWR_CP registers, based on the value from each agent's 6bit
    // SAI field.
    //
    // Bits[63:0], RW, default = 0xC0061010202
    //
    UINTX mem_range_ctrl_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIOSWR_CP_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIOSWR_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006C10
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed read access, based on each
    // agent's 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0x80000C00630D0217
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIOSWR_RAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BIOSWR_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG     0x00006C18
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit vector used to determine which agents are allowed write access, based on each
    // agent's 6bit encoded SAI value.
    //
    // Bits[63:0], RW, default = 0xC00610C0212
    //
    UINTX mem_range_pol : 64;
  } Bits;
  UINTX Data;
} B_CR_BIOSWR_WAC_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_RT_EN_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG          0x00006D78
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Global enable bit for Real-Time Support
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX rt_enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 15;
    //
    // IDI Agent Real-Time Traffic Mask Bits. Controls which IDI Agent supports Real-Time
    // Traffic/Transactions. Only one IDI Agent needs to be selected for real-time traffic.
    // Currently we don't support multiple IDI agents to be enabled for real-time traffic
    // at the same time. This field will be active only when Bit 0:RT_ENABLE is set to
    // '1'
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX rt_idi_agent : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 14;
  } Bits;
  UINTX Data;
} B_CR_RT_EN_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_ASYM_MEM_REGION0_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006E40
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // Specifies bits [38:28] of the base address of asymmetric memory region 0 (in slice
    // 0); all the lower bits of the region's base address are equal to 0.
    //
    // Bits[14:4], RW, default = 0x0
    //
    UINTX slice0_asym_base : 11;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[18:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // Specifies bits [38:28] of the highest address of asymmetric memory region 0 (in
    // slice 0); all the lower bits of the region's highest address are equal to 1.
    //
    // Bits[29:19], RW, default = 0x0
    //
    UINTX slice0_asym_limit : 11;
    //
    // Specifies Channel Selected for ASYM Region Mapped To Slice 0
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX slice0_asym_channel_select : 1;
    //
    // Setting this bit to 0 disables asymmetric memory region 0; setting it to 1 enables
    // the region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX slice0_asym_enable : 1;
  } Bits;
  UINTX Data;
} B_CR_ASYM_MEM_REGION0_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_ASYM_MEM_REGION1_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006E44
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // Specifies bits [38:28] of the base address of asymmetric memory region 1 (in slice
    // 1); all the lower bits of the region's base address are equal to 0.
    //
    // Bits[14:4], RW, default = 0x0
    //
    UINTX slice1_asym_base : 11;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[18:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // Specifies bits [38:28] of the highest address of asymmetric memory region 1 (in
    // slice 1); all the lower bits of the region's highest address are equal to 1.
    //
    // Bits[29:19], RW, default = 0x0
    //
    UINTX slice1_asym_limit : 11;
    //
    // Specifies Channel Selected for ASYM Region Mapped To Slice 1.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX slice1_asym_channel_select : 1;
    //
    // Setting this bit to 0 disables asymmetric memory region 1; setting it to 1 enables
    // the region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX slice1_asym_enable : 1;
  } Bits;
  UINTX Data;
} B_CR_ASYM_MEM_REGION1_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_ASYM_2WAY_MEM_REGION_0_0_0_MCHBAR_BUNIT_BOXTYPE_REG 0x00006E50
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    //
    //                Going with 2 bits here.
    //                2'b00 : Asymmetric memory Split between Channel 0 of Slice 0 and
    // Slice 1
    //                2'b01 : Asymmetric memory split between Channel 1 of Slice 0 and
    // Slice 1
    //                2'b10 : Asymmetric memory split between Channel 0 and Channel 1
    // of Slice 0
    //                2'b11 : Asymmetric memory split between Channel 0 and Channel 1
    // of Slice 1
    //
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX asym_2way_intlv_mode : 2;
    //
    // Specifies bits [38:28] of the base address of Interleave Asymmetric Region; all
    // the lower bits of the region's base address are equal to 0.
    //
    // Bits[14:4], RW, default = 0x0
    //
    UINTX asym_2way_base : 11;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[16:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Specifies bits [38:28] of the highest address of Interleave Asymmetric Region;
    // all the lower bits of the region's highest address are equal to 1.
    //
    // Bits[27:17], RW, default = 0x0
    //
    UINTX asym_2way_limit : 11;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 3;
    //
    // Setting this bit to 0 disables 2Way Asymmetric Interleaving; setting it to 1 enables
    // the region.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX asym_2way_interleave_enable : 1;
  } Bits;
  UINTX Data;
} B_CR_ASYM_2WAY_MEM_REGION_0_0_0_MCHBAR_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BMCMODE_LOW_BUNIT_BOXTYPE_REG                 0x00006E48
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When set to 1, B-Unit will not allow any transaction with uncorrectable error
    // or subsequent memory transaction to propagate through to Requester. This will
    // essentially hang CPU and CPU will end up with IERR shutdown. Issue: When set to
    // zero B-Unit will allow transaction with an uncorrectable error to propagate and
    // signal MC event to CPU if enabled in IA32_MC5_CTL. If enabled MC event will be
    // taken by CPU cores at the end of instruction boundary after it detected by ROB
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX mc_signal_mode : 1;
    //
    // Reserved.
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved_0 : 31;
  } Bits;
  UINTX Data;
} B_CR_BMCMODE_LOW_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define B_CR_BMCMODE_HIGH_BUNIT_BOXTYPE_REG                0x00006E4C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved.
    //
    // Bits[31:0], RO, default = 0x0
    //
    UINTX reserved_0 : 32;
  } Bits;
  UINTX Data;
} B_CR_BMCMODE_HIGH_BUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC


#endif // _BUNIT_BOXTYPE_H_
