/** @file
  File name:    CPGC_BOXTYPE.h
  Input File:   GLK_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in CPGC_BOXTYPE.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _CPGC_BOXTYPE_H_
#define _CPGC_BOXTYPE_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define CPGC2_ACCESS_CONTROL_POLICY_L_CPGC_BOXTYPE_REG     0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Lower half of the SAI Control Policy Value [31:0].
    //
    // Bits[31:0], RW, default = 0x61010202
    //
    UINTX control_policy_l : 32;
  } Bits;
  UINTX Data;
} CPGC2_ACCESS_CONTROL_POLICY_L_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ACCESS_CONTROL_POLICY_H_CPGC_BOXTYPE_REG     0x00000004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Upper half of the SAI Control Policy Value [63:32].
    //
    // Bits[31:0], RW, default = 0xC00
    //
    UINTX control_policy_h : 32;
  } Bits;
  UINTX Data;
} CPGC2_ACCESS_CONTROL_POLICY_H_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ACCESS_READ_POLICY_L_CPGC_BOXTYPE_REG        0x00000008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Lower half of the SAI Read Policy Value [31:0].
    //
    // Bits[31:0], RW, default = 0xFFFFFF3F
    //
    UINTX read_policy_l : 32;
  } Bits;
  UINTX Data;
} CPGC2_ACCESS_READ_POLICY_L_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ACCESS_READ_POLICY_H_CPGC_BOXTYPE_REG        0x0000000C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Upper half of the SAI Read Policy Value [63:32].
    //
    // Bits[31:0], RW, default = 0x1371FFF
    //
    UINTX read_policy_h : 32;
  } Bits;
  UINTX Data;
} CPGC2_ACCESS_READ_POLICY_H_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ACCESS_WRITE_POLICY_L_CPGC_BOXTYPE_REG       0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Lower half of the SAI Write Policy Value [31:0].
    //
    // Bits[31:0], RW, default = 0x1000212
    //
    UINTX write_policy_l : 32;
  } Bits;
  UINTX Data;
} CPGC2_ACCESS_WRITE_POLICY_L_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ACCESS_WRITE_POLICY_H_CPGC_BOXTYPE_REG       0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Upper half of the SAI Write Policy Value [63:32].
    //
    // Bits[31:0], RW, default = 0xC00
    //
    UINTX write_policy_h : 32;
  } Bits;
  UINTX Data;
} CPGC2_ACCESS_WRITE_POLICY_H_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_CONTROL_CPGC_BOXTYPE_REG             0x00000018
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of times the current Address_Instruction will repeat if Address_Decode_Enable
    // is set (as N-1) (0=1 time).[br]
    // If  for the current Address_Instruction, Address_Decode_Enable is set, then at
    // the start of that Address_Instruction, initialize the XOR_Address_Pattern to a
    // single 1 in the LSB of Column Address. Otherwise, it is initialized to all zero's.[br]
    // For (Address_Decode_Rotate_Repeat_Current = 0; Current_ Address_Decode_Rotate_Repeat_Current
    // <= Address_Decode_Rotate_Repeat;  Address_Decode_Rotate_Repeat_Current ++)[br]
    // Execute the entire Algorithm (Block Traversal, Algorithm_Instruction, Commands)
    // with the following behavior:[br]
    // At the end of each complete Block Traversal, rotate the XOR Address Pattern 1
    // bit position from LSB to MSB (Column through Region_Bits_Column, Region_Bits_Row,
    // Region_Num_Banks, and through Region_Num_Ranks).[br]
    // Region_Size.Num_Bank and Region_Size.Num_Rank numbers are converted to the equivalent
    // number of adddress bits to cover their range (ceil(log2(Num+1))) and should be
    // programmed to a power of 2 value (minus 1): 1,3,7, or 15.[br]
    // If only one Rank is being tested, then you should limit the amount in this register
    // to the sum of the number of address bits without Rank bits.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX address_decode_rotate_repeats : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 26;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_CONTROL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_INSTRUCTION_0__CPGC_BOXTYPE_REG      0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Controls the fastest changing address field, and how that carries into higher
    // order fields.[br]
    // 000 Rank, Bank, Row/Col.[br]
    // 001 Rank, Row/Col, Bank.[br]
    // 010 Bank, Rank, Row/Col.[br]
    // 011 Bank, Row/Col, Rank.[br]
    // 100 Row/Col, Rank, Bank.[br]
    // 101 Row/Col, Bank, Rank.[br]
    // 110 Row/Col  (Used for Offset) Rank and Bank are unchanged.[br]
    // 111 Row-Col (Used for Stripe Offset) No Carry from any field to another.[br]
    // Carry order between Row and Column is dependent on the Address_Direction field.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX address_order : 3;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(10) Inv(FastX) - North West[/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    // [b](0)(11) Diagonal2 - East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(11) Inv(Diagonal2)  West [/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // Note that the Bank and Rank Address direction follows the same as the Column (Increment
    // or Decrement).[br]
    // Note for diagonal directions, a Carry results in twice the normal increment/decrement
    // of the Row field.[br]
    // Incrementing fields start at 0, and Decrementing fields start at 2^(field_block_size)-2^(field_increment)=
    // top of block.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Enables rotating XOR of address bits. Used in concert with the Address_Decode_Enable
    // field in the Command_Instruction list.[br]
    // This bit enables repeating of the current Address_Instruction for Address_Decode_Rotate_Repeats
    // times.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX address_decode_enable : 1;
    //
    // If set, then this is the last Address Instruction and the test will terminate
    // following full execution of this instruction. If there are no Last bits set in
    // the Address Instruction list, then the test will not stop due to a completion
    // of the test, but will be an Infinite Test.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_INSTRUCTION_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_INSTRUCTION_1__CPGC_BOXTYPE_REG      0x0000001D
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Controls the fastest changing address field, and how that carries into higher
    // order fields.[br]
    // 000 Rank, Bank, Row/Col.[br]
    // 001 Rank, Row/Col, Bank.[br]
    // 010 Bank, Rank, Row/Col.[br]
    // 011 Bank, Row/Col, Rank.[br]
    // 100 Row/Col, Rank, Bank.[br]
    // 101 Row/Col, Bank, Rank.[br]
    // 110 Row/Col  (Used for Offset) Rank and Bank are unchanged.[br]
    // 111 Row-Col (Used for Stripe Offset) No Carry from any field to another.[br]
    // Carry order between Row and Column is dependent on the Address_Direction field.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX address_order : 3;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(10) Inv(FastX) - North West[/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    // [b](0)(11) Diagonal2 - East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(11) Inv(Diagonal2)  West [/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // Note that the Bank and Rank Address direction follows the same as the Column (Increment
    // or Decrement).[br]
    // Note for diagonal directions, a Carry results in twice the normal increment/decrement
    // of the Row field.[br]
    // Incrementing fields start at 0, and Decrementing fields start at 2^(field_block_size)-2^(field_increment)=
    // top of block.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Enables rotating XOR of address bits. Used in concert with the Address_Decode_Enable
    // field in the Command_Instruction list.[br]
    // This bit enables repeating of the current Address_Instruction for Address_Decode_Rotate_Repeats
    // times.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX address_decode_enable : 1;
    //
    // If set, then this is the last Address Instruction and the test will terminate
    // following full execution of this instruction. If there are no Last bits set in
    // the Address Instruction list, then the test will not stop due to a completion
    // of the test, but will be an Infinite Test.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_INSTRUCTION_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_INSTRUCTION_2__CPGC_BOXTYPE_REG      0x0000001E
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Controls the fastest changing address field, and how that carries into higher
    // order fields.[br]
    // 000 Rank, Bank, Row/Col.[br]
    // 001 Rank, Row/Col, Bank.[br]
    // 010 Bank, Rank, Row/Col.[br]
    // 011 Bank, Row/Col, Rank.[br]
    // 100 Row/Col, Rank, Bank.[br]
    // 101 Row/Col, Bank, Rank.[br]
    // 110 Row/Col  (Used for Offset) Rank and Bank are unchanged.[br]
    // 111 Row-Col (Used for Stripe Offset) No Carry from any field to another.[br]
    // Carry order between Row and Column is dependent on the Address_Direction field.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX address_order : 3;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(10) Inv(FastX) - North West[/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    // [b](0)(11) Diagonal2 - East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(11) Inv(Diagonal2)  West [/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // Note that the Bank and Rank Address direction follows the same as the Column (Increment
    // or Decrement).[br]
    // Note for diagonal directions, a Carry results in twice the normal increment/decrement
    // of the Row field.[br]
    // Incrementing fields start at 0, and Decrementing fields start at 2^(field_block_size)-2^(field_increment)=
    // top of block.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Enables rotating XOR of address bits. Used in concert with the Address_Decode_Enable
    // field in the Command_Instruction list.[br]
    // This bit enables repeating of the current Address_Instruction for Address_Decode_Rotate_Repeats
    // times.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX address_decode_enable : 1;
    //
    // If set, then this is the last Address Instruction and the test will terminate
    // following full execution of this instruction. If there are no Last bits set in
    // the Address Instruction list, then the test will not stop due to a completion
    // of the test, but will be an Infinite Test.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_INSTRUCTION_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_INSTRUCTION_3__CPGC_BOXTYPE_REG      0x0000001F
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Controls the fastest changing address field, and how that carries into higher
    // order fields.[br]
    // 000 Rank, Bank, Row/Col.[br]
    // 001 Rank, Row/Col, Bank.[br]
    // 010 Bank, Rank, Row/Col.[br]
    // 011 Bank, Row/Col, Rank.[br]
    // 100 Row/Col, Rank, Bank.[br]
    // 101 Row/Col, Bank, Rank.[br]
    // 110 Row/Col  (Used for Offset) Rank and Bank are unchanged.[br]
    // 111 Row-Col (Used for Stripe Offset) No Carry from any field to another.[br]
    // Carry order between Row and Column is dependent on the Address_Direction field.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX address_order : 3;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(10) Inv(FastX) - North West[/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    // [b](0)(11) Diagonal2 - East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(11) Inv(Diagonal2)  West [/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // Note that the Bank and Rank Address direction follows the same as the Column (Increment
    // or Decrement).[br]
    // Note for diagonal directions, a Carry results in twice the normal increment/decrement
    // of the Row field.[br]
    // Incrementing fields start at 0, and Decrementing fields start at 2^(field_block_size)-2^(field_increment)=
    // top of block.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Enables rotating XOR of address bits. Used in concert with the Address_Decode_Enable
    // field in the Command_Instruction list.[br]
    // This bit enables repeating of the current Address_Instruction for Address_Decode_Rotate_Repeats
    // times.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX address_decode_enable : 1;
    //
    // If set, then this is the last Address Instruction and the test will terminate
    // following full execution of this instruction. If there are no Last bits set in
    // the Address Instruction list, then the test will not stop due to a completion
    // of the test, but will be an Infinite Test.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_INSTRUCTION_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_DATA_INSTRUCTION_0__CPGC_BOXTYPE_REG         0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[2:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // Enables rotating lane pattern data. Used in concert with the Data_Select_Rotation_Enable
    // field in the Data_Instruction list.[br]
    // This bit enables repeating of the current Data_Instruction for Data_Select_Rotation_Repeat
    // times.[br]
    // Data generated using the advanced pattern generation will rotate by one data bit
    // (LSB toward MSB) for each Data_Select_Rotation_Repeat.[br]
    // For the purpose of this shift, the order follows the Address_Instruction Address_Order
    // and the Algorithm_Instruction[0] Address_Direction.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX data_select_rotation_enable : 1;
    //
    // 00 - Solid[br]
    // 01 - Column Stripes[br]
    // 10 - Row Stripes[br]
    // 11 - Checkerboard
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX data_background : 2;
    //
    // Globally Invert all data.  Combined with the Algorithm_Instruction Invert_Data
    // field, and the Command_Instruction or Offset_Command_Instruction Invert_Data field
    // to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Data_Instruction indication, execution is continued at Data_Instruction[0]
    // if the test does not otherwise terminate. This bit is implied to be set for Data_Instruction[3].
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_DATA_INSTRUCTION_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_DATA_INSTRUCTION_1__CPGC_BOXTYPE_REG         0x00000021
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[2:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // Enables rotating lane pattern data. Used in concert with the Data_Select_Rotation_Enable
    // field in the Data_Instruction list.[br]
    // This bit enables repeating of the current Data_Instruction for Data_Select_Rotation_Repeat
    // times.[br]
    // Data generated using the advanced pattern generation will rotate by one data bit
    // (LSB toward MSB) for each Data_Select_Rotation_Repeat.[br]
    // For the purpose of this shift, the order follows the Address_Instruction Address_Order
    // and the Algorithm_Instruction[0] Address_Direction.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX data_select_rotation_enable : 1;
    //
    // 00 - Solid[br]
    // 01 - Column Stripes[br]
    // 10 - Row Stripes[br]
    // 11 - Checkerboard
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX data_background : 2;
    //
    // Globally Invert all data.  Combined with the Algorithm_Instruction Invert_Data
    // field, and the Command_Instruction or Offset_Command_Instruction Invert_Data field
    // to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Data_Instruction indication, execution is continued at Data_Instruction[0]
    // if the test does not otherwise terminate. This bit is implied to be set for Data_Instruction[3].
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_DATA_INSTRUCTION_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_DATA_INSTRUCTION_2__CPGC_BOXTYPE_REG         0x00000022
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[2:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // Enables rotating lane pattern data. Used in concert with the Data_Select_Rotation_Enable
    // field in the Data_Instruction list.[br]
    // This bit enables repeating of the current Data_Instruction for Data_Select_Rotation_Repeat
    // times.[br]
    // Data generated using the advanced pattern generation will rotate by one data bit
    // (LSB toward MSB) for each Data_Select_Rotation_Repeat.[br]
    // For the purpose of this shift, the order follows the Address_Instruction Address_Order
    // and the Algorithm_Instruction[0] Address_Direction.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX data_select_rotation_enable : 1;
    //
    // 00 - Solid[br]
    // 01 - Column Stripes[br]
    // 10 - Row Stripes[br]
    // 11 - Checkerboard
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX data_background : 2;
    //
    // Globally Invert all data.  Combined with the Algorithm_Instruction Invert_Data
    // field, and the Command_Instruction or Offset_Command_Instruction Invert_Data field
    // to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Data_Instruction indication, execution is continued at Data_Instruction[0]
    // if the test does not otherwise terminate. This bit is implied to be set for Data_Instruction[3].
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_DATA_INSTRUCTION_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_DATA_INSTRUCTION_3__CPGC_BOXTYPE_REG         0x00000023
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[2:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // Enables rotating lane pattern data. Used in concert with the Data_Select_Rotation_Enable
    // field in the Data_Instruction list.[br]
    // This bit enables repeating of the current Data_Instruction for Data_Select_Rotation_Repeat
    // times.[br]
    // Data generated using the advanced pattern generation will rotate by one data bit
    // (LSB toward MSB) for each Data_Select_Rotation_Repeat.[br]
    // For the purpose of this shift, the order follows the Address_Instruction Address_Order
    // and the Algorithm_Instruction[0] Address_Direction.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX data_select_rotation_enable : 1;
    //
    // 00 - Solid[br]
    // 01 - Column Stripes[br]
    // 10 - Row Stripes[br]
    // 11 - Checkerboard
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX data_background : 2;
    //
    // Globally Invert all data.  Combined with the Algorithm_Instruction Invert_Data
    // field, and the Command_Instruction or Offset_Command_Instruction Invert_Data field
    // to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Data_Instruction indication, execution is continued at Data_Instruction[0]
    // if the test does not otherwise terminate. This bit is implied to be set for Data_Instruction[3].
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_DATA_INSTRUCTION_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_DATA_CONTROL_CPGC_BOXTYPE_REG                0x00000024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Any Data_Instruction with Data_Select_Rotation_Enable will repeat this many times.
    //  As N-1. (0=1 time)
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX data_select_rotation_repeats : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 24;
  } Bits;
  UINTX Data;
} CPGC2_DATA_CONTROL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_DATA_STATUS_CPGC_BOXTYPE_REG         0x00000028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current state of Address_Decode_Rotate_Repeats loop (down count).
    //
    // Bits[5:0], RO/V, default = 0x0
    //
    UINTX address_decode_rotate_repeats_current : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 10;
    //
    // Current state of Data_Select_Rotation_Repeats loop (down count).
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX data_select_rotation_repeats_current : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:24], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 8;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_DATA_STATUS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_0__CPGC_BOXTYPE_REG    0x0000002C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Starting Command_Instruction for exection of this Algorithm_Instruction.  The
    // Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until
    // a Command_Instruction contains the Last bit set, and then repeats for each Base_Address,
    // Base_Repeats.[br]
    // Pointer to which one of the 24 command list to start with.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX command_start_pointer : 5;
    //
    // Invert the direction as set in the current Address_Instruction for the duration
    // of this Algorithm_Instruction.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX inverse_direction : 1;
    //
    // Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction
    // Invert_Data field, and the Command_Instruction and Offset_Command_Instruction
    // Invert_Data field to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Algorithm instruction, and the memory block is moved at
    // its completion. Execution continues at the first Algorithm_Instruction until the
    // test is complete.  Algorithm_Instruction[7] has this bit set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_1__CPGC_BOXTYPE_REG    0x0000002D
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Starting Command_Instruction for exection of this Algorithm_Instruction.  The
    // Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until
    // a Command_Instruction contains the Last bit set, and then repeats for each Base_Address,
    // Base_Repeats.[br]
    // Pointer to which one of the 24 command list to start with.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX command_start_pointer : 5;
    //
    // Invert the direction as set in the current Address_Instruction for the duration
    // of this Algorithm_Instruction.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX inverse_direction : 1;
    //
    // Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction
    // Invert_Data field, and the Command_Instruction and Offset_Command_Instruction
    // Invert_Data field to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Algorithm instruction, and the memory block is moved at
    // its completion. Execution continues at the first Algorithm_Instruction until the
    // test is complete.  Algorithm_Instruction[7] has this bit set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_2__CPGC_BOXTYPE_REG    0x0000002E
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Starting Command_Instruction for exection of this Algorithm_Instruction.  The
    // Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until
    // a Command_Instruction contains the Last bit set, and then repeats for each Base_Address,
    // Base_Repeats.[br]
    // Pointer to which one of the 24 command list to start with.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX command_start_pointer : 5;
    //
    // Invert the direction as set in the current Address_Instruction for the duration
    // of this Algorithm_Instruction.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX inverse_direction : 1;
    //
    // Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction
    // Invert_Data field, and the Command_Instruction and Offset_Command_Instruction
    // Invert_Data field to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Algorithm instruction, and the memory block is moved at
    // its completion. Execution continues at the first Algorithm_Instruction until the
    // test is complete.  Algorithm_Instruction[7] has this bit set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_3__CPGC_BOXTYPE_REG    0x0000002F
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Starting Command_Instruction for exection of this Algorithm_Instruction.  The
    // Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until
    // a Command_Instruction contains the Last bit set, and then repeats for each Base_Address,
    // Base_Repeats.[br]
    // Pointer to which one of the 24 command list to start with.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX command_start_pointer : 5;
    //
    // Invert the direction as set in the current Address_Instruction for the duration
    // of this Algorithm_Instruction.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX inverse_direction : 1;
    //
    // Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction
    // Invert_Data field, and the Command_Instruction and Offset_Command_Instruction
    // Invert_Data field to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Algorithm instruction, and the memory block is moved at
    // its completion. Execution continues at the first Algorithm_Instruction until the
    // test is complete.  Algorithm_Instruction[7] has this bit set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_4__CPGC_BOXTYPE_REG    0x00000030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Starting Command_Instruction for exection of this Algorithm_Instruction.  The
    // Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until
    // a Command_Instruction contains the Last bit set, and then repeats for each Base_Address,
    // Base_Repeats.[br]
    // Pointer to which one of the 24 command list to start with.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX command_start_pointer : 5;
    //
    // Invert the direction as set in the current Address_Instruction for the duration
    // of this Algorithm_Instruction.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX inverse_direction : 1;
    //
    // Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction
    // Invert_Data field, and the Command_Instruction and Offset_Command_Instruction
    // Invert_Data field to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Algorithm instruction, and the memory block is moved at
    // its completion. Execution continues at the first Algorithm_Instruction until the
    // test is complete.  Algorithm_Instruction[7] has this bit set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_5__CPGC_BOXTYPE_REG    0x00000031
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Starting Command_Instruction for exection of this Algorithm_Instruction.  The
    // Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until
    // a Command_Instruction contains the Last bit set, and then repeats for each Base_Address,
    // Base_Repeats.[br]
    // Pointer to which one of the 24 command list to start with.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX command_start_pointer : 5;
    //
    // Invert the direction as set in the current Address_Instruction for the duration
    // of this Algorithm_Instruction.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX inverse_direction : 1;
    //
    // Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction
    // Invert_Data field, and the Command_Instruction and Offset_Command_Instruction
    // Invert_Data field to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Algorithm instruction, and the memory block is moved at
    // its completion. Execution continues at the first Algorithm_Instruction until the
    // test is complete.  Algorithm_Instruction[7] has this bit set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_6__CPGC_BOXTYPE_REG    0x00000032
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Starting Command_Instruction for exection of this Algorithm_Instruction.  The
    // Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until
    // a Command_Instruction contains the Last bit set, and then repeats for each Base_Address,
    // Base_Repeats.[br]
    // Pointer to which one of the 24 command list to start with.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX command_start_pointer : 5;
    //
    // Invert the direction as set in the current Address_Instruction for the duration
    // of this Algorithm_Instruction.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX inverse_direction : 1;
    //
    // Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction
    // Invert_Data field, and the Command_Instruction and Offset_Command_Instruction
    // Invert_Data field to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Algorithm instruction, and the memory block is moved at
    // its completion. Execution continues at the first Algorithm_Instruction until the
    // test is complete.  Algorithm_Instruction[7] has this bit set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_7__CPGC_BOXTYPE_REG    0x00000033
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Starting Command_Instruction for exection of this Algorithm_Instruction.  The
    // Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until
    // a Command_Instruction contains the Last bit set, and then repeats for each Base_Address,
    // Base_Repeats.[br]
    // Pointer to which one of the 24 command list to start with.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX command_start_pointer : 5;
    //
    // Invert the direction as set in the current Address_Instruction for the duration
    // of this Algorithm_Instruction.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX inverse_direction : 1;
    //
    // Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction
    // Invert_Data field, and the Command_Instruction and Offset_Command_Instruction
    // Invert_Data field to determine the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Algorithm instruction, and the memory block is moved at
    // its completion. Execution continues at the first Algorithm_Instruction until the
    // test is complete.  Algorithm_Instruction[7] has this bit set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_CTRL_0__CPGC_BOXTYPE_REG 0x00000034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // FastY_Init is used to allow a background write initialization type algorithm to
    // use FastY with Columns as the LSB address field to ensure the fastest initialization
    // possible.[br]
    // ^(wD1) is a the most typical background Init function.[br]
    // MEMTEL uses the keyword INIT() to reference this feature.[br]
    // FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction
    // and Address_Order.[br]
    // If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank,
    // Bank, Row/Col), else use the settings defined in the current Address_Instruction.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX fasty_init : 1;
    //
    // Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the
    // size of the block for this instruction as the size of the block. This may be used
    // for a rapid short test hitting all banks to open pages etc, or to initialize a
    // row worth of data.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX base_range_row : 1;
    //
    // Reset the Wait Timer at the start of this Algorithm Instruction.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX wait_count_clear : 1;
    //
    // Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm
    // should start. [br]
    // Wait_Time is commonly used for Pause Refresh test where the read to a particular
    // address needs to be a specific time away from when the write to an address occurs.[br]
    // If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]
    // If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled
    // until the Wait_Time_Current is equal to the Wait_Time.[br]
    // Wait_Time_Current represent the current count value from when it was last reset
    // either by a Test starting or Wait_Count_Clear.[br]
    // Wait_Time_Current is a free running counter that accurately reflects the time
    // from when it was last reset by using the following formula.[br]
    // Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]
    // If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction,
    // Wait_Time_Current is reset tzero.[br]
    // Wait_Time_Current is frozen if a Test encounters any stop condition.[br]
    // Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]
    // Wait_Time_Current rolls over at the maximum value back tzero.[br]
    // Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value.
    // The possible frequencies that can be selected are the following.[br]
    // Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]
    // Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]
    // Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]
    // Wait_Clock_Frequence = 11 = DUNIT clock.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX wait_count_start : 1;
    //
    // Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction
    // until the Event indicated by Select_Event has been acknowledged to have occurred.[br]
    // The Select_Event is acknowledged to be in progress.[br]
    // The latency between the event and the acknowledgement must be a known fixed value
    // (preventing a hang situation).[br]
    // The Current_Repeat_Value is reset tzero.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX wait_event_start : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during non Chip Select cycles.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX deselect_on : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during chip select cycles.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX select_on : 1;
    //
    // Enable the BE Training Error Detection feature for individual Algorithm Instructions.
    // This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX be_train_err_en : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_CTRL_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_CTRL_1__CPGC_BOXTYPE_REG 0x00000035
#ifndef ASM_INC
typedef union {
  struct {
    //
    // FastY_Init is used to allow a background write initialization type algorithm to
    // use FastY with Columns as the LSB address field to ensure the fastest initialization
    // possible.[br]
    // ^(wD1) is a the most typical background Init function.[br]
    // MEMTEL uses the keyword INIT() to reference this feature.[br]
    // FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction
    // and Address_Order.[br]
    // If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank,
    // Bank, Row/Col), else use the settings defined in the current Address_Instruction.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX fasty_init : 1;
    //
    // Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the
    // size of the block for this instruction as the size of the block. This may be used
    // for a rapid short test hitting all banks to open pages etc, or to initialize a
    // row worth of data.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX base_range_row : 1;
    //
    // Reset the Wait Timer at the start of this Algorithm Instruction.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX wait_count_clear : 1;
    //
    // Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm
    // should start. [br]
    // Wait_Time is commonly used for Pause Refresh test where the read to a particular
    // address needs to be a specific time away from when the write to an address occurs.[br]
    // If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]
    // If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled
    // until the Wait_Time_Current is equal to the Wait_Time.[br]
    // Wait_Time_Current represent the current count value from when it was last reset
    // either by a Test starting or Wait_Count_Clear.[br]
    // Wait_Time_Current is a free running counter that accurately reflects the time
    // from when it was last reset by using the following formula.[br]
    // Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]
    // If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction,
    // Wait_Time_Current is reset tzero.[br]
    // Wait_Time_Current is frozen if a Test encounters any stop condition.[br]
    // Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]
    // Wait_Time_Current rolls over at the maximum value back tzero.[br]
    // Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value.
    // The possible frequencies that can be selected are the following.[br]
    // Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]
    // Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]
    // Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]
    // Wait_Clock_Frequence = 11 = DUNIT clock.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX wait_count_start : 1;
    //
    // Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction
    // until the Event indicated by Select_Event has been acknowledged to have occurred.[br]
    // The Select_Event is acknowledged to be in progress.[br]
    // The latency between the event and the acknowledgement must be a known fixed value
    // (preventing a hang situation).[br]
    // The Current_Repeat_Value is reset tzero.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX wait_event_start : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during non Chip Select cycles.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX deselect_on : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during chip select cycles.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX select_on : 1;
    //
    // Enable the BE Training Error Detection feature for individual Algorithm Instructions.
    // This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX be_train_err_en : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_CTRL_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_CTRL_2__CPGC_BOXTYPE_REG 0x00000036
#ifndef ASM_INC
typedef union {
  struct {
    //
    // FastY_Init is used to allow a background write initialization type algorithm to
    // use FastY with Columns as the LSB address field to ensure the fastest initialization
    // possible.[br]
    // ^(wD1) is a the most typical background Init function.[br]
    // MEMTEL uses the keyword INIT() to reference this feature.[br]
    // FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction
    // and Address_Order.[br]
    // If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank,
    // Bank, Row/Col), else use the settings defined in the current Address_Instruction.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX fasty_init : 1;
    //
    // Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the
    // size of the block for this instruction as the size of the block. This may be used
    // for a rapid short test hitting all banks to open pages etc, or to initialize a
    // row worth of data.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX base_range_row : 1;
    //
    // Reset the Wait Timer at the start of this Algorithm Instruction.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX wait_count_clear : 1;
    //
    // Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm
    // should start. [br]
    // Wait_Time is commonly used for Pause Refresh test where the read to a particular
    // address needs to be a specific time away from when the write to an address occurs.[br]
    // If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]
    // If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled
    // until the Wait_Time_Current is equal to the Wait_Time.[br]
    // Wait_Time_Current represent the current count value from when it was last reset
    // either by a Test starting or Wait_Count_Clear.[br]
    // Wait_Time_Current is a free running counter that accurately reflects the time
    // from when it was last reset by using the following formula.[br]
    // Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]
    // If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction,
    // Wait_Time_Current is reset tzero.[br]
    // Wait_Time_Current is frozen if a Test encounters any stop condition.[br]
    // Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]
    // Wait_Time_Current rolls over at the maximum value back tzero.[br]
    // Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value.
    // The possible frequencies that can be selected are the following.[br]
    // Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]
    // Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]
    // Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]
    // Wait_Clock_Frequence = 11 = DUNIT clock.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX wait_count_start : 1;
    //
    // Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction
    // until the Event indicated by Select_Event has been acknowledged to have occurred.[br]
    // The Select_Event is acknowledged to be in progress.[br]
    // The latency between the event and the acknowledgement must be a known fixed value
    // (preventing a hang situation).[br]
    // The Current_Repeat_Value is reset tzero.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX wait_event_start : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during non Chip Select cycles.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX deselect_on : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during chip select cycles.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX select_on : 1;
    //
    // Enable the BE Training Error Detection feature for individual Algorithm Instructions.
    // This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX be_train_err_en : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_CTRL_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_CTRL_3__CPGC_BOXTYPE_REG 0x00000037
#ifndef ASM_INC
typedef union {
  struct {
    //
    // FastY_Init is used to allow a background write initialization type algorithm to
    // use FastY with Columns as the LSB address field to ensure the fastest initialization
    // possible.[br]
    // ^(wD1) is a the most typical background Init function.[br]
    // MEMTEL uses the keyword INIT() to reference this feature.[br]
    // FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction
    // and Address_Order.[br]
    // If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank,
    // Bank, Row/Col), else use the settings defined in the current Address_Instruction.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX fasty_init : 1;
    //
    // Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the
    // size of the block for this instruction as the size of the block. This may be used
    // for a rapid short test hitting all banks to open pages etc, or to initialize a
    // row worth of data.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX base_range_row : 1;
    //
    // Reset the Wait Timer at the start of this Algorithm Instruction.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX wait_count_clear : 1;
    //
    // Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm
    // should start. [br]
    // Wait_Time is commonly used for Pause Refresh test where the read to a particular
    // address needs to be a specific time away from when the write to an address occurs.[br]
    // If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]
    // If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled
    // until the Wait_Time_Current is equal to the Wait_Time.[br]
    // Wait_Time_Current represent the current count value from when it was last reset
    // either by a Test starting or Wait_Count_Clear.[br]
    // Wait_Time_Current is a free running counter that accurately reflects the time
    // from when it was last reset by using the following formula.[br]
    // Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]
    // If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction,
    // Wait_Time_Current is reset tzero.[br]
    // Wait_Time_Current is frozen if a Test encounters any stop condition.[br]
    // Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]
    // Wait_Time_Current rolls over at the maximum value back tzero.[br]
    // Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value.
    // The possible frequencies that can be selected are the following.[br]
    // Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]
    // Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]
    // Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]
    // Wait_Clock_Frequence = 11 = DUNIT clock.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX wait_count_start : 1;
    //
    // Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction
    // until the Event indicated by Select_Event has been acknowledged to have occurred.[br]
    // The Select_Event is acknowledged to be in progress.[br]
    // The latency between the event and the acknowledgement must be a known fixed value
    // (preventing a hang situation).[br]
    // The Current_Repeat_Value is reset tzero.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX wait_event_start : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during non Chip Select cycles.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX deselect_on : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during chip select cycles.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX select_on : 1;
    //
    // Enable the BE Training Error Detection feature for individual Algorithm Instructions.
    // This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX be_train_err_en : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_CTRL_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_CTRL_4__CPGC_BOXTYPE_REG 0x00000038
#ifndef ASM_INC
typedef union {
  struct {
    //
    // FastY_Init is used to allow a background write initialization type algorithm to
    // use FastY with Columns as the LSB address field to ensure the fastest initialization
    // possible.[br]
    // ^(wD1) is a the most typical background Init function.[br]
    // MEMTEL uses the keyword INIT() to reference this feature.[br]
    // FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction
    // and Address_Order.[br]
    // If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank,
    // Bank, Row/Col), else use the settings defined in the current Address_Instruction.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX fasty_init : 1;
    //
    // Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the
    // size of the block for this instruction as the size of the block. This may be used
    // for a rapid short test hitting all banks to open pages etc, or to initialize a
    // row worth of data.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX base_range_row : 1;
    //
    // Reset the Wait Timer at the start of this Algorithm Instruction.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX wait_count_clear : 1;
    //
    // Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm
    // should start. [br]
    // Wait_Time is commonly used for Pause Refresh test where the read to a particular
    // address needs to be a specific time away from when the write to an address occurs.[br]
    // If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]
    // If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled
    // until the Wait_Time_Current is equal to the Wait_Time.[br]
    // Wait_Time_Current represent the current count value from when it was last reset
    // either by a Test starting or Wait_Count_Clear.[br]
    // Wait_Time_Current is a free running counter that accurately reflects the time
    // from when it was last reset by using the following formula.[br]
    // Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]
    // If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction,
    // Wait_Time_Current is reset tzero.[br]
    // Wait_Time_Current is frozen if a Test encounters any stop condition.[br]
    // Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]
    // Wait_Time_Current rolls over at the maximum value back tzero.[br]
    // Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value.
    // The possible frequencies that can be selected are the following.[br]
    // Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]
    // Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]
    // Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]
    // Wait_Clock_Frequence = 11 = DUNIT clock.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX wait_count_start : 1;
    //
    // Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction
    // until the Event indicated by Select_Event has been acknowledged to have occurred.[br]
    // The Select_Event is acknowledged to be in progress.[br]
    // The latency between the event and the acknowledgement must be a known fixed value
    // (preventing a hang situation).[br]
    // The Current_Repeat_Value is reset tzero.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX wait_event_start : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during non Chip Select cycles.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX deselect_on : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during chip select cycles.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX select_on : 1;
    //
    // Enable the BE Training Error Detection feature for individual Algorithm Instructions.
    // This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX be_train_err_en : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_CTRL_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_CTRL_5__CPGC_BOXTYPE_REG 0x00000039
#ifndef ASM_INC
typedef union {
  struct {
    //
    // FastY_Init is used to allow a background write initialization type algorithm to
    // use FastY with Columns as the LSB address field to ensure the fastest initialization
    // possible.[br]
    // ^(wD1) is a the most typical background Init function.[br]
    // MEMTEL uses the keyword INIT() to reference this feature.[br]
    // FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction
    // and Address_Order.[br]
    // If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank,
    // Bank, Row/Col), else use the settings defined in the current Address_Instruction.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX fasty_init : 1;
    //
    // Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the
    // size of the block for this instruction as the size of the block. This may be used
    // for a rapid short test hitting all banks to open pages etc, or to initialize a
    // row worth of data.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX base_range_row : 1;
    //
    // Reset the Wait Timer at the start of this Algorithm Instruction.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX wait_count_clear : 1;
    //
    // Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm
    // should start. [br]
    // Wait_Time is commonly used for Pause Refresh test where the read to a particular
    // address needs to be a specific time away from when the write to an address occurs.[br]
    // If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]
    // If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled
    // until the Wait_Time_Current is equal to the Wait_Time.[br]
    // Wait_Time_Current represent the current count value from when it was last reset
    // either by a Test starting or Wait_Count_Clear.[br]
    // Wait_Time_Current is a free running counter that accurately reflects the time
    // from when it was last reset by using the following formula.[br]
    // Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]
    // If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction,
    // Wait_Time_Current is reset tzero.[br]
    // Wait_Time_Current is frozen if a Test encounters any stop condition.[br]
    // Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]
    // Wait_Time_Current rolls over at the maximum value back tzero.[br]
    // Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value.
    // The possible frequencies that can be selected are the following.[br]
    // Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]
    // Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]
    // Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]
    // Wait_Clock_Frequence = 11 = DUNIT clock.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX wait_count_start : 1;
    //
    // Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction
    // until the Event indicated by Select_Event has been acknowledged to have occurred.[br]
    // The Select_Event is acknowledged to be in progress.[br]
    // The latency between the event and the acknowledgement must be a known fixed value
    // (preventing a hang situation).[br]
    // The Current_Repeat_Value is reset tzero.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX wait_event_start : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during non Chip Select cycles.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX deselect_on : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during chip select cycles.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX select_on : 1;
    //
    // Enable the BE Training Error Detection feature for individual Algorithm Instructions.
    // This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX be_train_err_en : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_CTRL_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_CTRL_6__CPGC_BOXTYPE_REG 0x0000003A
#ifndef ASM_INC
typedef union {
  struct {
    //
    // FastY_Init is used to allow a background write initialization type algorithm to
    // use FastY with Columns as the LSB address field to ensure the fastest initialization
    // possible.[br]
    // ^(wD1) is a the most typical background Init function.[br]
    // MEMTEL uses the keyword INIT() to reference this feature.[br]
    // FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction
    // and Address_Order.[br]
    // If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank,
    // Bank, Row/Col), else use the settings defined in the current Address_Instruction.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX fasty_init : 1;
    //
    // Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the
    // size of the block for this instruction as the size of the block. This may be used
    // for a rapid short test hitting all banks to open pages etc, or to initialize a
    // row worth of data.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX base_range_row : 1;
    //
    // Reset the Wait Timer at the start of this Algorithm Instruction.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX wait_count_clear : 1;
    //
    // Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm
    // should start. [br]
    // Wait_Time is commonly used for Pause Refresh test where the read to a particular
    // address needs to be a specific time away from when the write to an address occurs.[br]
    // If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]
    // If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled
    // until the Wait_Time_Current is equal to the Wait_Time.[br]
    // Wait_Time_Current represent the current count value from when it was last reset
    // either by a Test starting or Wait_Count_Clear.[br]
    // Wait_Time_Current is a free running counter that accurately reflects the time
    // from when it was last reset by using the following formula.[br]
    // Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]
    // If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction,
    // Wait_Time_Current is reset tzero.[br]
    // Wait_Time_Current is frozen if a Test encounters any stop condition.[br]
    // Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]
    // Wait_Time_Current rolls over at the maximum value back tzero.[br]
    // Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value.
    // The possible frequencies that can be selected are the following.[br]
    // Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]
    // Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]
    // Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]
    // Wait_Clock_Frequence = 11 = DUNIT clock.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX wait_count_start : 1;
    //
    // Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction
    // until the Event indicated by Select_Event has been acknowledged to have occurred.[br]
    // The Select_Event is acknowledged to be in progress.[br]
    // The latency between the event and the acknowledgement must be a known fixed value
    // (preventing a hang situation).[br]
    // The Current_Repeat_Value is reset tzero.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX wait_event_start : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during non Chip Select cycles.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX deselect_on : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during chip select cycles.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX select_on : 1;
    //
    // Enable the BE Training Error Detection feature for individual Algorithm Instructions.
    // This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX be_train_err_en : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_CTRL_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_INSTRUCTION_CTRL_7__CPGC_BOXTYPE_REG 0x0000003B
#ifndef ASM_INC
typedef union {
  struct {
    //
    // FastY_Init is used to allow a background write initialization type algorithm to
    // use FastY with Columns as the LSB address field to ensure the fastest initialization
    // possible.[br]
    // ^(wD1) is a the most typical background Init function.[br]
    // MEMTEL uses the keyword INIT() to reference this feature.[br]
    // FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction
    // and Address_Order.[br]
    // If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank,
    // Bank, Row/Col), else use the settings defined in the current Address_Instruction.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX fasty_init : 1;
    //
    // Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the
    // size of the block for this instruction as the size of the block. This may be used
    // for a rapid short test hitting all banks to open pages etc, or to initialize a
    // row worth of data.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX base_range_row : 1;
    //
    // Reset the Wait Timer at the start of this Algorithm Instruction.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX wait_count_clear : 1;
    //
    // Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm
    // should start. [br]
    // Wait_Time is commonly used for Pause Refresh test where the read to a particular
    // address needs to be a specific time away from when the write to an address occurs.[br]
    // If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]
    // If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled
    // until the Wait_Time_Current is equal to the Wait_Time.[br]
    // Wait_Time_Current represent the current count value from when it was last reset
    // either by a Test starting or Wait_Count_Clear.[br]
    // Wait_Time_Current is a free running counter that accurately reflects the time
    // from when it was last reset by using the following formula.[br]
    // Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]
    // If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction,
    // Wait_Time_Current is reset tzero.[br]
    // Wait_Time_Current is frozen if a Test encounters any stop condition.[br]
    // Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]
    // Wait_Time_Current rolls over at the maximum value back tzero.[br]
    // Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value.
    // The possible frequencies that can be selected are the following.[br]
    // Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]
    // Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]
    // Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]
    // Wait_Clock_Frequence = 11 = DUNIT clock.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX wait_count_start : 1;
    //
    // Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction
    // until the Event indicated by Select_Event has been acknowledged to have occurred.[br]
    // The Select_Event is acknowledged to be in progress.[br]
    // The latency between the event and the acknowledgement must be a known fixed value
    // (preventing a hang situation).[br]
    // The Current_Repeat_Value is reset tzero.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX wait_event_start : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during non Chip Select cycles.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX deselect_on : 1;
    //
    // If set, the CADB will be able to issue harassment patterns into the command and
    // address bus during chip select cycles.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX select_on : 1;
    //
    // Enable the BE Training Error Detection feature for individual Algorithm Instructions.
    // This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX be_train_err_en : 1;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_INSTRUCTION_CTRL_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_WAIT_COUNT_CURRENT_CPGC_BOXTYPE_REG 0x0000003C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current wait timer value. See Wait_Time description. (down count)
    //
    // Bits[15:0], RW/1C/V, default = 0x0
    //
    UINTX wait_timer_current : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_WAIT_COUNT_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ALGORITHM_WAIT_EVENT_CONTROL_CPGC_BOXTYPE_REG 0x00000040
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of clocks at Wait_Clock_Frequency to wait before starting current Algorithm_Instruction
    // if Wait_Start = 1.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX wait_time : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[19:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // Exponential timer (timer value calculated as 2^Timer).  If WaitEventStart is set
    // in the currently executing Algorithm Instruction, this timer dynamically replaces
    // the current Wait_Time counter following the Select_Event occurring (such as SelfRefresh
    // or PowerDown) , to add a fixed delay for the Select_Event condition to remain
    // before CPGC activity resumes.
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX timer : 4;
    //
    // 00 - 1GHz[br]
    // 01 - 1MHz[br]
    // 10 - 1KHz[br]
    // 11 - Native DUNIT clock
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX wait_clock_frequency : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:26], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // Select_Event is decoded in the following ways.[br]
    // Select_Event = 00 = Read/Write Pending CAS cue is empty[br]
    // Select_Event = 01 = CKE Power Down[br]
    // Select_Event = 10 = Refresh[br]
    // Select_Event = 11 = Self Refresh
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX select_event : 2;
  } Bits;
  UINTX Data;
} CPGC2_ALGORITHM_WAIT_EVENT_CONTROL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_BASE_REPEATS_CPGC_BOXTYPE_REG                0x00000044
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Base Address Loopcount - Typically the number of Base Addresses within the Block
    // (Row*Col*Bank*Rank) As N-1 value.[br]
    // This is the number of times the current Algorithm Instruction will be executed.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX base_repeats : 32;
  } Bits;
  UINTX Data;
} CPGC2_BASE_REPEATS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_BASE_REPEATS_CURRENT_CPGC_BOXTYPE_REG        0x00000048
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current remaining Base Address loops (down count).
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX base_repeats_current : 32;
  } Bits;
  UINTX Data;
} CPGC2_BASE_REPEATS_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_BASE_COL_REPEATS_CPGC_BOXTYPE_REG            0x0000004C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Alternate Base_Address_Loopcount. Often used to initialze a Row or Column worth
    // of data. [br]
    // This is used when Base_Range_Row field of ALGORITHM_INSTRUCTION_CTL is activated.[br]
    // This is the number of times the current Algorithm Instruction will be executed.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX base_col_repeats : 32;
  } Bits;
  UINTX Data;
} CPGC2_BASE_COL_REPEATS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_BLOCK_REPEATS_CPGC_BOXTYPE_REG               0x00000050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Block Loopcount. Typically the number of Blocks to be tested to traverse the entire
    // Tested Region. (2^region_size/2^block_size -1) As N-1 value.[br]
    // This is the number of times the entire list of Algorithm Instructions will be
    // executed.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX block_repeats : 32;
  } Bits;
  UINTX Data;
} CPGC2_BLOCK_REPEATS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_BLOCK_REPEATS_CURRENT_CPGC_BOXTYPE_REG       0x00000054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current Block Loopcount (down count).
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX block_repeats_current : 32;
  } Bits;
  UINTX Data;
} CPGC2_BLOCK_REPEATS_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_0__CPGC_BOXTYPE_REG      0x00000058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_1__CPGC_BOXTYPE_REG      0x00000059
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_2__CPGC_BOXTYPE_REG      0x0000005A
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_3__CPGC_BOXTYPE_REG      0x0000005B
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_4__CPGC_BOXTYPE_REG      0x0000005C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_5__CPGC_BOXTYPE_REG      0x0000005D
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_6__CPGC_BOXTYPE_REG      0x0000005E
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_7__CPGC_BOXTYPE_REG      0x0000005F
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_8__CPGC_BOXTYPE_REG      0x00000060
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_8__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_9__CPGC_BOXTYPE_REG      0x00000061
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_9__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_10__CPGC_BOXTYPE_REG     0x00000062
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_10__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_11__CPGC_BOXTYPE_REG     0x00000063
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_11__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_12__CPGC_BOXTYPE_REG     0x00000064
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_12__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_13__CPGC_BOXTYPE_REG     0x00000065
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_13__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_14__CPGC_BOXTYPE_REG     0x00000066
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_14__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_15__CPGC_BOXTYPE_REG     0x00000067
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_15__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_16__CPGC_BOXTYPE_REG     0x00000068
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_16__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_17__CPGC_BOXTYPE_REG     0x00000069
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_17__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_18__CPGC_BOXTYPE_REG     0x0000006A
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_18__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_19__CPGC_BOXTYPE_REG     0x0000006B
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_19__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_20__CPGC_BOXTYPE_REG     0x0000006C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_20__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_21__CPGC_BOXTYPE_REG     0x0000006D
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_21__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_22__CPGC_BOXTYPE_REG     0x0000006E
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_22__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_COMMAND_INSTRUCTION_23__CPGC_BOXTYPE_REG     0x0000006F
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Base Write operation will be performed.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Selects which Offset_Group will be used if Offset field is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX offset_group : 1;
    //
    // If set, this is an Offset operation, and the selected Offset_Group will be executed
    // in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Base command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable
    // field in the Address_Instruction list is active, and [name] is also active, then
    // for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]
    // If the Address_Decode_Enable field in the Address_Instruction list is inactive
    // (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set,
    // then the desired address bits will be replaced with the PRBS generated value.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX address_decode_or_prbs_en : 1;
    //
    // Invert the data used for this command. This is combined with the Algorithm_Instruction
    // and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses,
    // it is further combined with the Offset_Command Invert_Data bit.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23]
    // has this bit set implicitly.[br]
    // Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's
    // Command_Start_Pointer until the end of the Algorithm_Instruction.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_COMMAND_INSTRUCTION_23__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_HAMMER_REPEATS_CPGC_BOXTYPE_REG              0x00000070
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Hammer_Repeats is the number of times any command is repeated at the same address
    // when the Hammer control bit is set in the Command_Instruction (if not an offset
    // command).
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX hammer_repeats : 32;
  } Bits;
  UINTX Data;
} CPGC2_HAMMER_REPEATS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_HAMMER_REPEATS_CURRENT_CPGC_BOXTYPE_REG      0x00000074
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current Hammer Loopcount (down count).
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX hammer_repeats_current : 32;
  } Bits;
  UINTX Data;
} CPGC2_HAMMER_REPEATS_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_0__CPGC_BOXTYPE_REG 0x00000078
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_1__CPGC_BOXTYPE_REG 0x00000079
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_2__CPGC_BOXTYPE_REG 0x0000007A
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_3__CPGC_BOXTYPE_REG 0x0000007B
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_4__CPGC_BOXTYPE_REG 0x0000007C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_5__CPGC_BOXTYPE_REG 0x0000007D
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_6__CPGC_BOXTYPE_REG 0x0000007E
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_7__CPGC_BOXTYPE_REG 0x0000007F
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_8__CPGC_BOXTYPE_REG 0x00000080
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_8__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_9__CPGC_BOXTYPE_REG 0x00000081
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_9__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_10__CPGC_BOXTYPE_REG 0x00000082
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_10__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_11__CPGC_BOXTYPE_REG 0x00000083
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_11__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_12__CPGC_BOXTYPE_REG 0x00000084
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_12__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_13__CPGC_BOXTYPE_REG 0x00000085
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_13__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_14__CPGC_BOXTYPE_REG 0x00000086
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_14__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_INSTRUCTION_15__CPGC_BOXTYPE_REG 0x00000087
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reduce or increase the inversion interval by -1,0,1 based on the value in this
    // field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is
    // decreased by 1[br]10 - reserved
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX periodic_data_inv_adj : 2;
    //
    // Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally
    // invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX periodic_data_inv_en : 1;
    //
    // [b]Address_Direction[/b][br]
    // There are 4 basic address directions and their inverse for a total of 8.[br]
    // We will denote this as a combination of a 1-bit field and a 2-bit field.[br]
    // [b](0)(00)  FastY -North[/b][br]
    //  Increment Column and Carry Increment into Row.[br]
    // [b](1)(00) Inv(FastY) - South[/b][br]
    //  Decrement Column and Carry Decrement into Row.[br]
    // [b](0)(01) Diagonal  North East[/b][br]
    //  Increment Row and Column together and Carry Increment Column into Row.[br]
    // [b](1)(01) Inv(Diagonal)  South West[/b][br]
    //  Decrement Row and Column together and Carry Decrement Column into Row.[br]
    // [b](0)(10) FastX  East[/b][br]
    //  Increment Row and Carry Increment into Column.[br]
    // [b](1)(10) Inv(FastX) - West[/b][br]
    //  Decrement Row and Carry Decrement into Column.[br]
    // [b](0)(11) Diagonal2 - South East[/b][br]
    //  Decrement Column and Increment Row and Carry Increment Column into Row.[br]
    // [b](1)(11) Inv(Diagonal2)  North West [/b][br]
    //  Increment Column and Decrement Row and Carry Decrement Column into Row.[br]
    //
    // Offset accesses begin one 'step' in the given direction from the current Base_Address.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX address_direction : 3;
    //
    // Normal Offsets use Address_Order=110.[br]
    // This allows full traversal of the entire Block by and offset.[br]
    // If Stripe is active, then there is no carry between Row and Column. This will
    // keep the offset address within the same Row, or the same Column or on the same
    // diagonal.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX stripe : 1;
    //
    // Last Offset_Address_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_INSTRUCTION_15__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_0__CPGC_BOXTYPE_REG 0x00000088
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_1__CPGC_BOXTYPE_REG 0x00000089
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_2__CPGC_BOXTYPE_REG 0x0000008A
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_3__CPGC_BOXTYPE_REG 0x0000008B
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_4__CPGC_BOXTYPE_REG 0x0000008C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_5__CPGC_BOXTYPE_REG 0x0000008D
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_6__CPGC_BOXTYPE_REG 0x0000008E
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_7__CPGC_BOXTYPE_REG 0x0000008F
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_8__CPGC_BOXTYPE_REG 0x00000090
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_8__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_9__CPGC_BOXTYPE_REG 0x00000091
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_9__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_10__CPGC_BOXTYPE_REG 0x00000092
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_10__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_COMMAND_INSTRUCTION_11__CPGC_BOXTYPE_REG 0x00000093
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A Write operation will be performed at the Offset (or Base if the Offset field
    // = 0) Address.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX write : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:1], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // 1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction
    // Write bit.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX offset : 1;
    //
    // This Offset command will be repeated Hammer_Repeats times.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX hammer : 1;
    //
    // Use the alternate zero data source instead of the UniSequencers and Pattern_Select.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX alternate_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction
    // Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction
    // Invert_Data field and Offset_Command_Instruction Invert_Data field to determine
    // the final data polarity.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX invert_data : 1;
    //
    // Last Offset_Command_Instruction. The offset instruction is complete after all
    // Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]
    // Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit
    // set implicitly.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX last : 1;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_COMMAND_INSTRUCTION_11__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_REPEATS_0__CPGC_BOXTYPE_REG           0x00000094
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Set the loopcount for Offset (Distance from Base). The entire list of Offset Commands
    // are executed for each loop.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX offset_repeats : 32;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_REPEATS_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_REPEATS_1__CPGC_BOXTYPE_REG           0x00000098
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Set the loopcount for Offset (Distance from Base). The entire list of Offset Commands
    // are executed for each loop.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX offset_repeats : 32;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_REPEATS_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_REPEATS_CURRENT_CPGC_BOXTYPE_REG      0x0000009C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current Offset Loopcount (down count).
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX offset_repeats_current : 32;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_REPEATS_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_REGION_LOW_ROW_CPGC_BOXTYPE_REG              0x000000A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Set the bottom Row for the physical memory being tested. This value is added to
    // all Region Row Addresses computed.
    //
    // Bits[17:0], RW, default = 0x0
    //
    UINTX low_row : 18;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 14;
  } Bits;
  UINTX Data;
} CPGC2_REGION_LOW_ROW_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_REGION_LOW_COL_CPGC_BOXTYPE_REG              0x000000A4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Set the lowest Column for the physical memory being tested. This value is added
    // to all Region Column Addresses computed.
    //
    // Bits[10:2], RW, default = 0x0
    //
    UINTX low_col : 9;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 21;
  } Bits;
  UINTX Data;
} CPGC2_REGION_LOW_COL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_BLOCK_ORIGIN_ROW_CURRENT_CPGC_BOXTYPE_REG    0x000000A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current row within the testing region of memory Updated as the block traverses
    // through the region.
    //
    // Bits[17:0], RO/V, default = 0x0
    //
    UINTX block_origin_row_current : 18;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 14;
  } Bits;
  UINTX Data;
} CPGC2_BLOCK_ORIGIN_ROW_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_BASE_ADDRESS_COL_RANK_CURRENT_CPGC_BOXTYPE_REG 0x000000AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Current Base Address Column within the block.
    //
    // Bits[10:2], RO/V, default = 0x0
    //
    UINTX base_col_current : 9;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 5;
    //
    // Current Base Address Rank within the block.
    //
    // Bits[18:16], RO/V, default = 0x0
    //
    UINTX base_rank_current : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:19], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 13;
  } Bits;
  UINTX Data;
} CPGC2_BASE_ADDRESS_COL_RANK_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_BASE_ADDRESS_ROW_BANK_CURRENT_CPGC_BOXTYPE_REG 0x000000B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current Base Address Row within the block.
    //
    // Bits[17:0], RO/V, default = 0x0
    //
    UINTX base_row_current : 18;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 6;
    //
    // Current Base Address Bank within the block.
    //
    // Bits[27:24], RO/V, default = 0x0
    //
    UINTX base_bank_current : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
  } Bits;
  UINTX Data;
} CPGC2_BASE_ADDRESS_ROW_BANK_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_COL_CURRENT_CPGC_BOXTYPE_REG  0x000000B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Current Offset Address Column within the block.[br]
    // Only valid if the current Command_Instruction pointed to by Command_Instruction_Current
    // is an Offset command.
    //
    // Bits[10:2], RO/V, default = 0x0
    //
    UINTX offset_col_current : 9;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 21;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_COL_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_OFFSET_ADDRESS_ROW_CURRENT_CPGC_BOXTYPE_REG  0x000000B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current Offset Address Row within the block.[br]
    // Only valid if the current Command_Instruction pointed to by Command_Instruction_Current
    // is an Offset command.
    //
    // Bits[17:0], RO/V, default = 0x0
    //
    UINTX offset_row_current : 18;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 14;
  } Bits;
  UINTX Data;
} CPGC2_OFFSET_ADDRESS_ROW_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_SIZE_CPGC_BOXTYPE_REG                0x000000BC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved for use as Block_Size_Bits_Col - Fixed as same as Region_Size_Bits_Col
    // for BXT. There is no column traversal of a block in BXT.
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX block_size_bits_col : 4;
    //
    // 2^Block_Size_Bits_Row is the number of rows for a Block. If block traversal is
    // used, then this must be at least 4 rows (=2). Minimum value is 1 if Address_Decode_Enable
    // =1.
    //
    // Bits[8:4], RW, default = 0x0
    //
    UINTX block_size_bits_row : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[11:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // Number of Banks to test for a Block (as N-1 = top bank number).[br]
    // All Bank Address values go through the Bank Address Lookup table.
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX block_size_num_banks : 4;
    //
    // Number of Ranks to test for a Block (as N-1 = top rank number).[br]
    // All Rank Addresses go through the Rank Address Lookup table.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX block_size_num_ranks : 4;
    //
    // 2^Region_Size_Bits_Col is the number of columns in the testing region. It is also
    // used as the Block_Size_Bits_Col value to set the size of the block. Minimum value
    // is 1 if Address_Decode_Enable =1. , so this normally needs to be set to the number
    // of Column bits of the memory.
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX region_size_bits_col : 4;
    //
    // 2^Region_Size_Bits_Row is the number of rows in the testing region. Must be >=
    // to Block_Size_Bits_Row.
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX region_size_bits_row : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:29], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 3;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_SIZE_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_BASE_ADDRESS_CONTROL_CPGC_BOXTYPE_REG        0x000000C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // See Block_Move_Half_Block for description.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX block_move_one_row : 1;
    //
    // if Block_Move_One_Row =1 then[br]
    // the Block is moved by 1 row[br]
    // Else if Block_Move_Half_Bock = 1 then[br]
    // the Block is moved by 2^(Block_Size_Bits_Row)/2 Rows[br]
    // Else[br]
    // the Block is moved by = 2^(Row_Block_Size).
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX block_move_half_block : 1;
    //
    // All Base and Offset Row addresses are incremented (or decremented) by 2^Row_Inc
    // (unsigned value).
    //
    // Bits[9:6], RW, default = 0x0
    //
    UINTX row_inc : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[10:10], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // All Base and Offset Column addresses are incremented (or decremented) by 2^Col_Inc
    // (unsigned value).
    //
    // Bits[14:11], RW, default = 0x0
    //
    UINTX col_inc : 4;
    //
    // All Base Bank addresses are incremented (or decremented) by 2^Bank_Inc (unsigned
    // value)  - Fixed at 0 for BXT.
    //
    // Bits[17:15], RO/V, default = 0x0
    //
    UINTX reserved_bank_inc : 3;
    //
    // All Base Rank addresses are incremented (or decremented) by 2^Rank_Inc (unsigned
    // value) - Fixed at 0 for BXT.
    //
    // Bits[20:18], RO/V, default = 0x0
    //
    UINTX reserved_rank_inc : 3;
    //
    // Address_Order0_Inc_Rate determines if the Address Order 0 Field is incremented
    // on the Command Sequence Boundary (following a Command_Instruction with the Last
    // bit set) or every Command_Instruction. [br][br]
    // 0  Increment Address after executing the Command_Instruction with the Last bit
    // set.[br][br]
    // 1  Increment Address following each Command_Instruction.
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX address_order0_inc_rate : 1;
    //
    // Address_Inversion_Enable enables particular Address Fields to be inverted.[br]
    // [25] Rank_Inversion_Enable.[br]
    // [24] Bank_Inversion_Enable.[br]
    // [23] Row_Inversion_Enable.[br]
    // [22] Col_Inversion_Enable.
    //
    // Bits[25:22], RW, default = 0x0
    //
    UINTX address_inversion_enable : 4;
    //
    // Address_Inversion_Rate determines if the enabled Address Fields toggle inversion
    // on the Command Sequence Boundary (following a Command_Instruction with the Last
    // bit set) or every Command_Instruction. [br]
    //    0  Invert enabled Address fields after executing the Command_Instruction with
    // the Last bit set. [br][br]
    // 1  Invert enabled Address fields following each Command_Instruction
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX address_inversion_rate : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:27], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 5;
  } Bits;
  UINTX Data;
} CPGC2_BASE_ADDRESS_CONTROL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_PRBS_CONTROL_CPGC_BOXTYPE_REG        0x000000C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Size of PRBS for address generation if Address_PRBS_Enable is active.  See text
    // for PRBS Polynomials being used for each setting.
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX address_prbs_size : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[6:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // If Address_PRBS_Enable is active, and Address_Decode_Enable is not active in the
    // current Address_Instruction, thenn each command is enabled to use the PRBS address
    // if the Address_Decode_or_PRBS_En bit is set.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX address_prbs_enable : 1;
    //
    // LSB of Column address will be the LSB of the PRBS Address Generator when the PRBS
    // Address is selected.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX address_prbs_low_col : 1;
    //
    // LSB of Row address will be the LSB of the PRBS Address Generator when the PRBS
    // Address is selected.
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX address_prbs_low_row : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:10], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 6;
    //
    // Bits [2:1] of the Column address will be bits [2:1] of the PRBS Address Generator
    // when the PRBS Address is selected.
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX address_prbs_mid_col : 1;
    //
    // Bits [2:1] of the Row address will be bits [2:1] of the PRBS Address Generator
    //  when the PRBS Address is selected.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX address_prbs_mid_row : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 6;
    //
    // The higher order bits of the PRBS Address Generator (bits 3 through Address_PRBS_Size-1)
    // will be on the same Column bits when the PRBS Address is selected.
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX address_prbs_high_col : 1;
    //
    // The higher order bits of the PRBS Address Generator (bits 3 through Address_PRBS_Size-1)
    // will be on the same Row bits when the PRBS Address is selected.
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX address_prbs_high_row : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:26], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 6;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_PRBS_CONTROL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_PRBS_SEED_CPGC_BOXTYPE_REG           0x000000C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Seed for Address PRBS generator.
    //
    // Bits[17:0], RW, default = 0x0
    //
    UINTX address_prbs_seed : 18;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 14;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_PRBS_SEED_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_PRBS_CURRENT_CPGC_BOXTYPE_REG        0x000000CC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current value of Address PRBS generator.  Address advances as Address_Order0_Inc_Rate.
    //  The Seed is re-loaded (from Save) at each Algorithm_Instruction boundary.
    //
    // Bits[17:0], RO/V, default = 0x0
    //
    UINTX address_prbs_current : 18;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 14;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_PRBS_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ADDRESS_PRBS_SAVE_CPGC_BOXTYPE_REG           0x000000D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Saved value of Address PRBS generator.  Value is saved automatically during block
    // advance, and restored (from Seed) when Block Traversal (Repeats) is complete.
    //
    //
    // Bits[17:0], RO/V, default = 0x0
    //
    UINTX address_prbs_save : 18;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 14;
  } Bits;
  UINTX Data;
} CPGC2_ADDRESS_PRBS_SAVE_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_CMD_FSM_CURRENT_CPGC_BOXTYPE_REG             0x000000D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current Offset_Command_Instruction pointer.
    //
    // Bits[2:0], RO/V, default = 0x0
    //
    UINTX offset_command_instruction_current : 3;
    //
    // Current Offset_Address_Instruction pointer.
    //
    // Bits[5:3], RO/V, default = 0x0
    //
    UINTX offset_address_instruction_current : 3;
    //
    // Current Offset_Group as pointed to by the Current Command_Instruction (if an Offset
    // instruction).
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX offset_group_instruction_current : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Current Command_Instruction pointer.
    //
    // Bits[12:8], RO/V, default = 0x0
    //
    UINTX command_instruction_current : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[14:13], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Current Algorithm_Instruction pointer.
    //
    // Bits[17:15], RO/V, default = 0x0
    //
    UINTX algorithm_instruction_current : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 6;
    //
    // Current Data_Instruction pointer.
    //
    // Bits[25:24], RO/V, default = 0x0
    //
    UINTX data_instruction_current : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[27:26], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Current Address_Instruction pointer.
    //
    // Bits[29:28], RO/V, default = 0x0
    //
    UINTX address_instruction_current : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_4 : 2;
  } Bits;
  UINTX Data;
} CPGC2_CMD_FSM_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_WAIT_2_START_CONFIG_CPGC_BOXTYPE_REG         0x000000D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // In order to make the 'standard' 1 GHz clock for the CPGC specified Wait_Clock_Frequency
    // setting, we need to provide a pre-scaler, and Increment Value to modify the existing
    // Wait_Timer_Current advancement. This field will divide the native Memory Controller
    // clock by the provided value, with '1' being 'No Divide'. After that divide, the
    // Wait_Timer_Current will advance by the 'Increment_Value' field. In this way, we
    // are creating a clock ratio able to 'multiply' the native Memory Controller clock
    // by 'Increment_Value/Prescaler'.  For small values of Wait_Time, the error will
    // be substantial, and it may be better to modify the programming to the '11' Native
    // Clock setting and manually compute the required Wait_Time for the desired delay.
    //
    // Bits[9:0], RW, default = 0x0
    //
    UINTX prescaler_for_clock_freq : 10;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:10], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 6;
    //
    // When a setting of 1MHz or 1KHz is used in Wait_Clock_Frequency, this field provides
    // a way to tell the hardware the native Memory Controller clock frequency, which
    // is fed into the Prescaler automatically (with a 1 Increment_Value also automatically
    // fed into the counter).
    //
    // Bits[25:16], RW, default = 0x0
    //
    UINTX clock_freq : 10;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[27:26], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // See Prescaler field for information on this field.
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX increment_value : 4;
  } Bits;
  UINTX Data;
} CPGC2_WAIT_2_START_CONFIG_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_VISA_MUX_SEL_CPGC_BOXTYPE_REG                0x000000DC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Dpat group 0 or Err group 0 select.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dpat0_or_err0 : 1;
    //
    // Cmd group 0  or Dpat group 1 select.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX cmd0_or_dpat1 : 1;
    //
    // Err group 1 or Cmd group 1 select.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX err1_or_cmd1 : 1;
    //
    // Cmd Group 0 Select.
    //
    // Bits[4:3], RW, default = 0x0
    //
    UINTX cmd0_grp_sel : 2;
    //
    // Cmd Group 1 Select.
    //
    // Bits[6:5], RW, default = 0x0
    //
    UINTX cmd1_grp_sel : 2;
    //
    // Dpat Group 0 Select.
    //
    // Bits[8:7], RW, default = 0x0
    //
    UINTX dpat0_grp_sel : 2;
    //
    // Dpat Group 1 Select.
    //
    // Bits[10:9], RW, default = 0x0
    //
    UINTX dpat1_grp_sel : 2;
    //
    // Err Group 0 Select.
    //
    // Bits[12:11], RW, default = 0x0
    //
    UINTX err0_grp_sel : 2;
    //
    // Err Group 1 Select.
    //
    // Bits[14:13], RW, default = 0x0
    //
    UINTX err1_grp_sel : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 17;
  } Bits;
  UINTX Data;
} CPGC2_VISA_MUX_SEL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_LB_SEQ_CFG_CPGC_BOXTYPE_REG                   0x000000E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Pattern_Length (i.e Loopback.Pattern) forms the first half of the Loopcount sequence
    // with PM_Length (i.e Loopback.PM) forming the second half.[br][br]
    //             Pattern_Length is the portion of Loopcount when patterns are generated(Loopback
    // Master) and compared (Loopback Master and optionally the Loopback Slave).[br][br]
    //             Pattern_Length suration is defined in total # of byte clocks. A zero
    // value is illegal.[br][br]
    //             The Sum of Pattern_Length and PM_Length (Duration of a Loopcount)must
    // always be set to a value of two or more.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX pattern_length : 8;
    //
    // PM_Length(i.e Loopback.PM) forms the second half of the loopcount sequence with
    // Pattern_Length (i.e Loopback.Pattern)forming the first half.[br][br]
    //             PM_Length is used in conjection with Pattern_Length and Loopcount
    // to go in and out of Power Savings Modes in an identical way to how the functional
    // power saving mode behave. This includes post amble, pre-amble, etc.[br][br]
    //             PM_Length duration is defined in total # of byte clocks.[br][br]
    //             If PM_Length is set to 0 then no power saving modes will be entered.[br][br]
    //             If the end of the test has not been reached, (Curren_Loopcount !=Loopcount)
    // the loopcount is incremented and the sequence repeats (Pattern_Length followed
    // by PM_Length).[br][br]
    //             If the end of the test has not been reached (Current_Loopcount=Loopcount)
    // the link transitions back to Loopback.Idle following the PM state.
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX pm_length : 8;
    //
    // 2^(Loopcount) determines the length of a test.[br][br]
    //                 One Loopcount consists of Pattern_Length followed by PM_Length.[br][br]
    //                 Pattern_Length corresponds to the Loopback Master generating patterns
    // and the Loopback.Slave and/or Loopback Master performing error checking occueeing
    // (valid is assered).[br][br]
    //                 PM_Length corresponds to the functional power savings mode (valid
    // is not asserted).[br][br]
    // Loopcount=0 means the test is infinite.[br][br]
    // Loopcount=1 means the test will end after two loops.[br][br]
    // Loopcount=2 means the test will end after four loops.[br][br]
    // Loopcount=3 means the test will end after eight loops.
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX loopcount : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:21], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // Start_Test_Delay is the delay period (in byte clocks) to execute a test(i.e transition
    // to Loopback.Pattern) after the link is in Loopback.Idle and Local_Start_Test is
    // asserted.[br][br]
    // If Local_Start_Test is set upon the initial enttry to Loopback.Idle then a test
    // (entry to Loopback.Pattern) will immediately start after Start_Test_Delay number
    // of byte clocks is enforced.[br][br]
    // During Start_Test_test the Valid must not be asserted (i.e Loopback.PM) and no
    // comparison of data will be taking place.[br][br]
    // Start_Test_Delay=0 is reserved and not allowed.[br][br]
    // Start_Test_Delay=1 will result in a 1byte clock delay.[br][br]
    // Start_Test_Delay=2 will result in a 2byte clock delay.
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX start_test_delay : 8;
  } Bits;
  UINTX Data;
} CPGC_LB_SEQ_CFG_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_LB_SEQ_CTL_CPGC_BOXTYPE_REG                   0x000000E4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // If  Local_Start_Test is set a Sequence will immediately start, or wait until entry
    // to Loopback state.  A complete Sequence is defined by the following behavior:[br]
    // 1) An initial delay of Start_Test_Delay byte clocks must first occur in Loopback.PM
    // (with Valid de-asserted).[br]
    // 2) Transition to Loopback.Pattern (Valid asserted) for a duration of Pattern_Length
    // Byte clocks during which data is generated and compared by the Loopback Master
    // and optionally compared by the Loopback Slave.[br]
    // 3) Increment Loopcounter.[br]
    // 4) Optionally Transition to Loopback.PM (with Valid deasserted), if so programmed,
    // for a duration of PM_Length Byte clocks during which power modes are functionally
    // enforced as what would happen normally based on the length of the PM_Length duration.[br]
    // 5) If Current Loopcount !=2^Loopcount then go to step 2.[br]
    // 6) If Current Loopcount !=2^Loopcount then the Link returns to Loopback.Idle,
    // Local_Start_Test is cleared for the Master. Local_Start_Test is not cleared on
    // the Loopback.Slave.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX local_start_test : 1;
    //
    // If  Local_Stop_Test is set to 1 and a Loopback test is in progress (i.e. Test_In_Progress=1)
    // then a transition to Loopback. Idle will occur as soon as possible (i.e. Link
    // enters Loopback.PM).[br]
    // Local_Stop_Test will immediately clear to 0 after stopping a Loopback test (i.e.
    // Local_Stop_Test=0 while in Loopback.Idle).
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX local_stop_test : 1;
    //
    // Setting Local_Clear_Errors  to 1 will immediately clear all local Error registers
    // (i.e. CPGC_ERR_* registers).[br]
    // Local_Clear_Errors will immediately clear to 0 after clearing affected registers.[br]
    // If this bit fails to auto-clear, then there is no clock and the clear will occur
    // at the start of the next test.
    //
    // Bits[2:2], RW/V, default = 0x0
    //
    UINTX local_clear_errors : 1;
    //
    // Local_Start_Test will start all other REUT instances that have this bit  set.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX bind_start_test : 1;
    //
    // Local_Stop_Test will stop all other REUT instances that have this bit set.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX bind_stop_test : 1;
    //
    // Local_Clear_Errors will clear all other REUT instances that have this bit set.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX bind_clear_errors : 1;
    //
    // Test will stop based on Global_Error (external input) and Local_Error will drive
    // Global_Error.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX bind_stop_on_error : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[11:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 5;
    //
    // A change to Initialization_Mode occurs immediately.[br]
    // 00 - OFF - REUT is clock gated.[br]
    // 01 - LSM Mode  - Enter Loopback.Idle state through the appropriate Link Layer
    // bits as a Loopback Master or Loopback Slave.[br]
    // 10 - Force Master - Force entry to Loopback.Idle as a Loopback Master (Supported
    // if Force_Loopback capability is set).[br]
    // 11 - Force Slave - Force entry to Loopback.Idle as Loopback Slave (Supported if
    // Force_Loopback capability is set).[br]
    // Note: A user must be careful to transition both sides of the Link to Loopback.Idle
    // if switching Initialization_Mode from Force Master or Force Slave to LSM Mode
    // or undefined behavior can be expected.[br]
    // Note: Initialization Mode should not be changed while Local_Start_Test is set,
    // or while Test_In_Progress is set.
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX initialization_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 18;
  } Bits;
  UINTX Data;
} CPGC_LB_SEQ_CTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_LB_SEQ_LOOPCOUNT_TX_STATUS_CPGC_BOXTYPE_REG   0x000000E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current_Loopcount indicates how many times the full Sequence has been executed
    // in the TX path. [br][br]
    // Current_Loopcount is cleared by Local_Clear_Errors.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX current_loopcount : 32;
  } Bits;
  UINTX Data;
} CPGC_LB_SEQ_LOOPCOUNT_TX_STATUS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_LB_SEQ_LOOPCOUNT_RX_STATUS_CPGC_BOXTYPE_REG   0x000000EC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current_Loopcount indicates how many times the full Sequence has been executed
    // in the RX path.[br][br]
    // Current_Loopcount is cleared by Local_Clear_Errors.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX current_loopcount : 32;
  } Bits;
  UINTX Data;
} CPGC_LB_SEQ_LOOPCOUNT_RX_STATUS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_LB_SEQ_PL_RX_STATUS_CPGC_BOXTYPE_REG          0x000000F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    //  Current_Pattern_Length is used in conjuntion with Stop_On_Error_Control conditons
    // to determine where the last failure occurred within Loopback.Pattern.[br][br]
    // Current_Pattern_Length indicates how many Bytes were left in Loopback.Pattern
    // when the error occurred.[br][br]
    // Current_Pattern_Length is cleared by Local_Clear_Errors.
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX current_pattern_length : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 24;
  } Bits;
  UINTX Data;
} CPGC_LB_SEQ_PL_RX_STATUS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_MISC_REFRESH_CTL_CPGC_BOXTYPE_REG             0x000000F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // (Not Implemented in BXT) Refresh_Rank_Mask is a per rank field.[br]
    // [br]
    // The LSB relates to Rank0 and the MSB relates to the highest Rank.  If the per
    // Rank bit of the Refresh_Rank_Mask is set to 1, then the REUT engine will disable
    // executing any refresh to that rank while in REUT mode.[br]
    // [br]
    // If the per rank bit of the Refresh_Rank_Mask is set to 0 and then the REUT engine
    // will enable executing a refresh (assuming the MC has refreshes enabled) to that
    // Rank while in REUT mode based on the Panic_Refresh_Only value.
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX refresh_rank_mask : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // (Not Implemented in BXT) If RefZQ_En_Start_Test_Sync=1, this field will ensure
    // all refresh/ZQ powerdown logic (counters, FSMs, etc.) is kept in the default reset
    // state (no refresh/ZQ happening) while in Loopback.Marker during REUT Mode. Once
    // the test starts and the transition to Loopback.Pattern occurs, the refresh/ZQ
    // logic will behave identical to normal functional MC mode based on the values programmed
    // in the refresh/ZQ CRs. This allows deterministic and reproducible behavior across
    // REUT tests with respect to refresh/ZQ since the logic is synchronized to the start
    // of a REUT test.[br]
    // If RefZQ_En_Start_Test_Sync=0, the refresh/ZQ logic will not be synchronized to
    // the start of a REUT test and will always behave identical to normal functional
    // MC mode based on the values programmed in the refresh/ZQ CRs, whether in Loopback.Marker
    // or Loopback.Pattern.[br]
    // [br]
    // NOTE: This bit should not be used in conjuction with Self Refresh.[br]
    //
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX refzq_en_start_test_sync : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 22;
    //
    // (Not Implemented in BXT) If Panick_Refresh_Only=1, then opportunistic and high
    // priority auto refreshes will be disabled for all ranks and refreshes will only
    // occur when the panic refresh watermark has been exceeded. If Panic_Refresh_Only=0,
    // then refreshes will occur using the existing MC functional refresh logic.[br]
    // [br]
    // tREFI defines the average period between refreshes, and the rate that tREFI counter
    // is incremented (in DCLK cycles, default is 4100). This field is a often a shadow
    // register to an exisitng MC tREFI field. tREFI is located in another CR.  In Haswell
    // this is located in the CR TC_RFTP.tREFI (15:0) in MCMNTS.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX panic_refresh_only : 1;
  } Bits;
  UINTX Data;
} CPGC_MISC_REFRESH_CTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_MISC_ZQ_CTL_CPGC_BOXTYPE_REG                  0x000000F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // (Not Implemented in BXT) ZQ Mask is a per rank (Chip Select) field.  The LSB relates
    // to Rank0 and the MSB relates to the highest Rank.[br]
    // [br]
    // If the per rank bit of the ZQ Mask is set to 1, then the REUT engine will disable
    // executing ZQ operations to that Rank.   Note that if the Refresh_Rank_Mask for
    // the same rank is set to 1 then the ZQ Mask will have no effect and ZQ will disabled
    // to that rank.[br]
    // [br]
    // If the per rank bit of the ZQ mask is set to 0 and refreshes are being issued
    // to the corresponding Rank, ZQ will be issued at a rate equal to 128*ZQCS_period
    // programmed inside the channel TC_ZQCAL CR, always occurring after refreshes occur.[br]
    // ZQCS_period is the time between ZQCS operations in tREFI*128 (2 to 255, default
    // is 128.[br]
    // ZQCS_period is located in another CR.  In Haswell this is located in the CR TC_ZQCAL.[br]
    // ZQCS_period (7:0) in MCMNTS.
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX zq_rank_mask : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 29;
    //
    // (Not Implemented in BXT) If Always_Do_ZQ is set to 1, a ZQ operation will always
    // take place after a refresh occurs as long as the ZQ_Rank_Mask for that rank is
    // set to 0.[br]
    // [br]
    // If Always_Do_ZQ is set to 0, a ZQ operation will take place at the normal programmed
    // 128*ZQCS_period after a refresh occurs as long as the ZQ_Rank_Mask for that rank
    // is set to 0.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX always_do_zq : 1;
  } Bits;
  UINTX Data;
} CPGC_MISC_ZQ_CTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_MISC_ODT_CTL_CPGC_BOXTYPE_REG                 0x000000FC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // (Not Implemented in BXT) ODT_Override is a per rank field.  The LSB relates to
    // Rank0 and the MSB relates to the highest Rank. When ODT_Override is set to 1 for
    // a rank, the ODT functional logic will be bypassed and the ODT_On value for that
    // rank will be used. When ODT_Override is set to 0 for a rank, the ODT functional
    // logic will drive the ODT value for that rank.[br]
    //
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX odt_override : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 14;
    //
    // (Not Implemented in BXT) ODT_on is a 4-bit field, one bit per rank (Chip Select).
    //  The LSB relates to Rank0 and the MSB relates to the highest Rank.  When ODT_Override
    // is set to 1 for a rank the value in ODT_On will be used as the ODT value for that
    // rank.[br]
    //
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX odt_on : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 13;
    //
    // (Not Implemented in BXT) This bit is to be set during DDR training.  The MPR pattern
    // (Hardcoded 0101 pattern) from the DRAM will be used to initially train the read
    // timing.  This MPR pattern is accessed via the MR3 DRAM register and, per the JEDEC
    // spec, the mode comes with two key limitations:[br]
    // [br]
    //    1. Before entering this mode, all pages must be precharged.[br]
    // [br]
    //    2. Once in this mode, the MC can only issue RD or RDA commands.[br]
    // [br]
    //    When this CR bit is set, the RAS# and WE# will always drive high.  This will
    // morph any command from the scheduler into either READ or DESELECT.[br]
    // [br]
    //    The flow is as follows:[br]
    // [br]
    //    1. MRS Mode to write MR3.[br]
    // [br]
    //    2. Set MPR_Train_DDR_On.[br]
    // [br]
    //    3. Set REUT Mode.[br]
    // [br]
    //    4. Wait for all pages to close (page table idle counter to expire).[br]
    // [br]
    //    5. Run REUT Test.[br]
    // [br]
    //    6. Stop Test, clear MPR_Train_DDR_On bit, clear MR3 register.[br]
    // [br]
    //    7. Continue with other REUT tests.[br]
    // [br]
    //    Note that ZQ, CKE and Refresh should be disabled using the appropriate CR settings
    // during MPR_Train_DDR_On.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX mpr_train_ddr_on : 1;
  } Bits;
  UINTX Data;
} CPGC_MISC_ODT_CTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_MISC_CKE_CTL_CPGC_BOXTYPE_REG                 0x00000100
#ifndef ASM_INC
typedef union {
  struct {
    //
    // (Not Implemented in BXT) CKE_Override is a a per rank field.  The LSB relates
    // to Rank0 and the MSB relates to the highest Rank. When CKE_Override is set to
    // 1 for a rank, the CKE functional logic will be bypassed and the CKE_On value for
    // that rank will be used. When CKE_Override is set to 0 for a rank, the CKE functional
    // logic will drive the CKE value for that rank.[br]
    //
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX cke_override : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 6;
    //
    // (Not Implemented in BXT) When CKE_En_Start_Test_Sync is set to 1 this field will
    // ensure all CKE powerdown logic (counters, FSMs, etc.) is kept in the default reset
    // state (no CKE powerdowns happening) while in Loopback.Marker during REUT Mode.
    // Once the test starts and the transition to Loopback.Pattern occurs the CKE powerdown
    // logic will behave identical to normal functional MC mode based on the values programmed
    // in the powerdown CR, PM_PDWN_config_0_0_0_MCHBAR. This allows deterministic and
    // reproducible behavior across REUT tests with respect to CKE powerdown since the
    // logic is synchronized to the start of a REUT test.[br]
    // [br]
    // When CKE_En_Start_Test_Sync is set to 0 the CKE powerdown logic will not be synchronized
    // to the start of a REUT test and will always behave identical to normal functional
    // MC mode based on the values programmed in the powerdown CR, PM_PDWN_config_0_0_0_MCHBAR,
    // whether in Loopback.Marker or Loopback.Pattern.[br]
    // [br]
    // NOTE: This bit should not be used in conjuction with Self Refresh.[br]
    //
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX cke_en_start_test_sync : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 7;
    //
    // (Not Implemented in BXT) CKE_On is a 4-bit field, one bit per rank.  The LSB relates
    // to Rank0 and the MSB relates to the highest Rank.  In REUT mode when the per rank
    // bit is set CKE will be always on for that rank.
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX cke_on : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 14;
  } Bits;
  UINTX Data;
} CPGC_MISC_CKE_CTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_MISC_CMD_RATE_CPGC_BOXTYPE_REG                0x00000104
#ifndef ASM_INC
typedef union {
  struct {
    //
    // (Not Implemented in BXT) Enable the Cmd_Rate_Limit.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX enable_cmd_rate_limit : 1;
    //
    // (Not Implemented in BXT) Cmd_Rate_Limit - The legal range is 2-7.
    //
    // Bits[3:1], RW, default = 0x5
    //
    UINTX cmd_rate_limit : 3;
    //
    // (Not Implemented in BXT) N:1 mode is set and utilized as designed in the functional
    // MC logic where N is the number of cycles of allowed continuous CMD cycles before
    // the MC logic will stall a sequence and insert a tri-state bubble.[br]
    // [br]
    // When Deselect traffic is driven by the CADB (combination of Subsequence_Deselect_Enable
    // being set, CMD_Deselect_Enable enabling deselects, and a non zero value for Lane_Deselect_Enable)
    // all Deselect cycles within the MC scheduler logic will be considered as consecutive
    // Select cycles in the N:1 logic and thus a tri-state bubble will be inserted regularly
    // as enforced by the N:1 logic.  Tristate effects both select and deselect cycles.[br]
    // [br]
    // The N:1 logic can also be triggered to insert a tri-state bubble and reset the
    // N:1 logic after a programmable delay (Reset_N_to_1_Delay=0-7 Dclks) after a PRE/ACT/RD/WR
    // CMD.  This allows one to synchronize the N:1 logic periodically to ensure the
    // correct worst case pattern between victim and aggressor occurs.[br]
    // [br]
    // Reset N to 1 Logic on a WR (bit 4).[br]
    // Reset N to 1 Logic on a RD (bit 5).[br]
    // Reset N to 1 Logic on a ACT (bit 6).[br]
    // Reset N to 1 Logic on a PRE (bit 7).
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX reset_on_command : 4;
    //
    // (Not Implemented in BXT) Inserts an N Dclk delay ranging from 0 to 7 after the
    // N to 1 Reset on Cmd is triggered.
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX reset_delay : 4;
    //
    // (Not Implemented in BXT) TBD.
    //
    // Bits[13:12], RW, default = 0x1
    //
    UINTX ck_to_cke_delay : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 17;
    //
    // (Not Implemented in BXT) When sending a MRW command via MRH and setting the Init_MRW
    // bit, send the CS for two DCLK cycles (on the third and fourth cycles, rather than
    // on just the third one).
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX init_mrw_2n_cs : 1;
  } Bits;
  UINTX Data;
} CPGC_MISC_CMD_RATE_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_MISC_EXT_TRIGGER_CPGC_BOXTYPE_REG             0x00000108
#ifndef ASM_INC
typedef union {
  struct {
    //
    // (Not Implemented in BXT) Setting Trigger_In_Global_Start enables a test to start
    // based on a uBP trigger.  This capability enables a test to start in a synchronous
    // fashion with respect to an external event.[br]
    // [br]
    // This is required to allow synchronous REUT operation with external test hardware
    // (HVM Tester, BERT, etc.).[br]
    // When Trigger_In_Global_Start is set the uBP used to start a REUT test will set
    // REUT_GLOBAL_CTL.Global_Start_Test on a deterministic boundary.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX trigger_in_global_start : 1;
    //
    // (Not Implemented in BXT) Setting Trigger_Out_Global_Start will generate a deterministic
    // external uBP trigger that is based on Global_Start_Test being set.[br]
    // [br]
    // This capability enables a test to start in a synchronous fashion with respect
    // to an external event.  This is required to allow synchronous REUT operation with
    // external test hardware (HVM Tester, BERT, etc.).[br]
    // [br]
    // When Trigger_OUT_Global_Start is set a deterministic uBP trigger is generated
    // each time REUT_GLOBAL_CTL.Global_Start_Test is set.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX trigger_out_global_start : 1;
    //
    // (Not Implemented in BXT) Setting Trigger_Out_On_Error_0 enables external equipment
    // to be synced deterministically to when any bit in Data_Error_Status or ECC_Error_Status
    // on channel 0 is set.  Once any bit in Data_Error_Status or ECC_Error_Status on
    // channel 0 is set no additional triggers will be generated.[br]
    // [br]
    // This capability enables external test equipment to be synched to an error event
    // within REUT on channel 0.  This is required to allow synchronous REUT operation
    // with external test hardware (HVM Tester, BERT, etc.).[br]
    // [br]
    // When Trigger_Out_On_Error_0 is set a deterministic uBP trigger is generated in
    // relation to when REUT_CH_ERR_DATA_STATUS.Data_Error_Status or REUT_CH_ERR_ECC_CHUNK_RANK_BYTE_NTH_STATUS.ECC_Error_Status
    // becomes non zero on channel 0.[br]
    //
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX trigger_out_on_error : 1;
    //
    // (Not Implemented in BXT) Setting Trigger_Out_On_Test_Done enables external equipment
    // to be synced deterministically to the exact moment when Trigger_Out_On_Channel_Test_Done_Status_1
    // is set.[br]
    // [br]
    // This capability enables external test equipment to be deterministically synched
    // to when Channel 1 REUT test is completed.  This is required to allow synchronous
    // REUT operation with external test hardware (HVM Tester, BERT, etc.).[br]
    // [br]
    // When Trigger_Out_On_Channel_Test_Done_Status_1 is set a deterministic externally
    // viewable uBP trigger is generated each time REUT_GLOBAL_ERR.Channel_Test_Done_Status_1
    // is set to 1.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX trigger_out_on_test_done : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 28;
  } Bits;
  UINTX Data;
} CPGC_MISC_EXT_TRIGGER_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_CTL_CPGC_BOXTYPE_REG                      0x0000010C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used to initiate a transition to active mode on this engine/channel (note that
    // INIT_MODE has to be programmed first).  Note that this will also cause a test
    // start for all engines with GLB_START_BIND set.[br]
    // This bit will self clear.
    //
    // Bits[0:0], RW/V, default = 0x0
    //
    UINTX start_test : 1;
    //
    // Forces an exit from the tests running on this engine/channel.  Note that this
    // will also cause a test stop for all engines with GLB_STOP_BIND set. This bit will
    // self clear.
    //
    // Bits[1:1], RW/V, default = 0x0
    //
    UINTX stop_test : 1;
    //
    // Setting this bit will immediately clear all error registers and error status.
    // This bit will automatically self clear.
    //
    // Bits[2:2], RW/V, default = 0x0
    //
    UINTX clear_errors : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:3], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 5;
    //
    // Enter Single Command mode were we will issue one command from CPGC and then pause
    // command issuing. This may be resumed by setting Continue_Single_Mode, or normal
    // continuous operation resumed by clearing this bit.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX single_cmd_mode : 1;
    //
    // When in Single_Command_Mode setting this bit will enable a new command to be issued.
    // This bit immediately clears after being set.
    //
    // Bits[9:9], RW/V, default = 0x0
    //
    UINTX continue_single_mode : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:10], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 22;
  } Bits;
  UINTX Data;
} CPGC_SEQ_CTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_CFG_A_CPGC_BOXTYPE_REG                    0x00000110
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 6;
    //
    // (Not Implemented in BXT) Setting this bit will cause the Tx write strobe to be
    // driven out constantly while a test is in progress.[br] Note: This is most often
    // used to help train the correct setting for per rank write levelling.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX enable_constant_write_strobe : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Setting this bit will bind this channel engine to all other channel engines. Clearing
    // all error registers and error status for any channel with GLOBAL_CLEAR_ERR_BIND
    // set will cause the same action to occur on all engines with GLOBAL_CLEAR_ERR_BIND
    // set. This feature is usually used when synchronization between multiple engines/channels
    // necessitates a global control of all supported engines.[br] Note: this field is
    // only available if multiple channels/engines are supported for the current implementation,
    // otherwise it is reserved.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX global_clear_err_bind : 1;
    //
    // Setting this bit will bind this channel engine to all other channel engines. A
    // test stop (due to an error condition) for any channel with GLOBAL_STOP_ON_ERR_BIND
    // set will cause the same action to occur on all engines with GLOBAL_STOP_ON_ERR_BIND
    // set. This feature is usually used when synchronization between multiple engines/channels
    // necessitates a global control of all supported engines.[br] Note: this field is
    // only available if multiple channels/engines are supported for the current implementation,
    // otherwise it is reserved.
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX global_stop_on_err_bind : 1;
    //
    // Setting this bit will bind this channel engine to all other channel engines. A
    // test start for any channel with GLOBAL_START_BIND set will cause the same action
    // to occur on all engines with GLOBAL_START_BIND set. This feature is usually used
    // when synchronization between multiple engines/channels necessitates a global control
    // of all supported engines.[br] Note: this field is only available if multiple channels/engines
    // are supported for the current implementation, otherwise it is reserved.
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX global_start_bind : 1;
    //
    // Setting this bit will bind this channel engine to all other channel engines.
    // A test stop (both forced and due to a stop condition) for any channel engine with
    // GLOBAL_STOP_BIND set will cause the same action to occur on all engines with GLOBAL_STOP_BIND
    // set.  This feature is usually used when synchronization between multiple engines/channels
    // necessitates a global control of all supported engines.[br] Note: this field is
    // only available if multiple channels/engines are supported for the current implementation,
    // otherwise it is reserved.
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX global_stop_bind : 1;
    //
    // 000 - IDLE MODE[br]
    // 001 - ACTIVE MODE[br]
    // 010 - DIRECT MODE[br]
    // 011 - ACTIVE MODE[br]
    // 100 - MRS MODE[br]
    // 101 - ERROR DUMP MODE (Reserved)[br]
    // 110 - WDB FILL MODE (Reserved)[br]
    // 111 - REWIND MODE (Reserved)
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX initialization_mode : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[20:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 6;
    //
    // Used to indicate the OPIO(MCDRAM) or CPGC(DDR) mode.[br][br]
    // 1 - CPGC Mode.[br][br]
    // 0 - OPIO Mode.
    //
    // Bits[21:21], RW, default = 0x1
    //
    UINTX cpgc_control : 1;
    //
    // Size of requests CPGC is issuing, 64B and 32B transactions and is encoded as follows:[br][br]
    //                         0 - 32 Byte Transactions[br][br]
    //                         1 - 64 Byte Transactions
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX request_data_size : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 9;
  } Bits;
  UINTX Data;
} CPGC_SEQ_CFG_A_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_CFG_B_CPGC_BOXTYPE_REG                    0x00000114
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Number of clock cycles (in CPGC-S clock domain) the start of the test is delayed
    // by after START_TEST has been asserted by the user. This is usually used to synchronize
    // multiple SoC CPGC engines on multiple channels according to a defined phase relationship.
    //
    // Bits[9:0], RW, default = 0x0
    //
    UINTX start_delay : 10;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:10], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 22;
  } Bits;
  UINTX Data;
} CPGC_SEQ_CFG_B_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_STATUS_CPGC_BOXTYPE_REG                   0x00000118
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[27:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 28;
    //
    // This bit will be set when a command has been issued and we are paused due to Single_Command_Mode.
    //  The test may be continued by either clearing Single_Command_Mode or by setting
    // Continue_Single_Mode.
    //
    // Bits[28:28], RO/V, default = 0x0
    //
    UINTX single_mode_paused : 1;
    //
    // This bit will be set when all the algorithms are complete. It is cleared on a
    // reset.
    //
    // Bits[29:29], RO/V, default = 0x0
    //
    UINTX algo_done : 1;
    //
    // This bit will be set when once a test has started.  Bit is cleared on a reset
    // or once test is done (or has been forced to exit due a stop condition).
    //
    // Bits[30:30], RO/V, default = 0x0
    //
    UINTX test_busy : 1;
    //
    // This bit will be set when the test is complete (or has been forced to exit due
    // to a stop condition). Bit is cleared on a reset or when user starts another test.
    //
    // Bits[31:31], RO/V, default = 0x0
    //
    UINTX test_done : 1;
  } Bits;
  UINTX Data;
} CPGC_SEQ_STATUS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_CHICKEN_REG_CPGC_BOXTYPE_REG                 0x0000011C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This gives the default value for read credit counter at reset.
    //
    // Bits[4:0], RW/P, default = 0x10
    //
    UINTX rd_credit_init : 5;
    //
    // This gives the default value for write credit counter at reset.
    //
    // Bits[10:5], RW/P, default = 0x20
    //
    UINTX wr_credit_init : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 21;
  } Bits;
  UINTX Data;
} CPGC2_CHICKEN_REG_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_0__CPGC_BOXTYPE_REG      0x00000120
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_1__CPGC_BOXTYPE_REG      0x00000124
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_2__CPGC_BOXTYPE_REG      0x00000128
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_3__CPGC_BOXTYPE_REG      0x0000012C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_4__CPGC_BOXTYPE_REG      0x00000130
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_5__CPGC_BOXTYPE_REG      0x00000134
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_6__CPGC_BOXTYPE_REG      0x00000138
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_7__CPGC_BOXTYPE_REG      0x0000013C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_8__CPGC_BOXTYPE_REG      0x00000140
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_8__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_9__CPGC_BOXTYPE_REG      0x00000144
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_9__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_10__CPGC_BOXTYPE_REG     0x00000148
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_10__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_11__CPGC_BOXTYPE_REG     0x0000014C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_11__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_12__CPGC_BOXTYPE_REG     0x00000150
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_12__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_13__CPGC_BOXTYPE_REG     0x00000154
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_13__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_14__CPGC_BOXTYPE_REG     0x00000158
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_14__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_15__CPGC_BOXTYPE_REG     0x0000015C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Flat register read access to Raster Repository.[br]
    // The format of this is 2 consecutive addresses contain a complete 64-bit data chunk
    // error bit-map, or one Error_Summary entry.[br]
    // In Mode3, there are up to 4 Row addresses for read failures for the associated
    // Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX content : 32;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_15__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_ECC1_CPGC_BOXTYPE_REG    0x00000160
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0  indicates no more than fail_max failing addresses, 1 - indicates more than
    // fail_max failing addresses.
    //
    // Bits[0:0], RO/V/P, default = 0x0
    //
    UINTX fail_excess0 : 1;
    //
    // 0 - indicates no failing address, 1 - indicates 1 or more failing address in the
    // corresponding Content entry.
    //
    // Bits[1:1], RO/V/P, default = 0x0
    //
    UINTX fail_any0 : 1;
    //
    // Bank 0 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries.
    //
    // Bits[3:2], RO/V/P, default = 0x0
    //
    UINTX fail_count0 : 2;
    //
    // ECC chunk 0 raster when in Mode 1.
    //
    // Bits[7:4], RO/V/P, default = 0x0
    //
    UINTX ecc_chunk0 : 4;
    //
    // 0  indicates no more than fail_max failing addresses, 1 - indicates more than
    // fail_max failing addresses.
    //
    // Bits[8:8], RO/V/P, default = 0x0
    //
    UINTX fail_excess1 : 1;
    //
    // 0 - indicates no failing address, 1 - indicates 1 or more failing address in the
    // corresponding Content entry.
    //
    // Bits[9:9], RO/V/P, default = 0x0
    //
    UINTX fail_any1 : 1;
    //
    // Bank 1 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries.
    //
    // Bits[11:10], RO/V/P, default = 0x0
    //
    UINTX fail_count1 : 2;
    //
    // ECC chunk 1 raster when in Mode 1.
    //
    // Bits[15:12], RO/V/P, default = 0x0
    //
    UINTX ecc_chunk1 : 4;
    //
    // 0  indicates no more than fail_max failing addresses, 1 - indicates more than
    // fail_max failing addresses.
    //
    // Bits[16:16], RO/V/P, default = 0x0
    //
    UINTX fail_excess2 : 1;
    //
    // 0 - indicates no failing address, 1 - indicates 1 or more failing address in the
    // corresponding Content entry.
    //
    // Bits[17:17], RO/V/P, default = 0x0
    //
    UINTX fail_any2 : 1;
    //
    // Bank 2 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries.
    //
    // Bits[19:18], RO/V/P, default = 0x0
    //
    UINTX fail_count2 : 2;
    //
    // ECC chunk 2 raster when in Mode 1.
    //
    // Bits[23:20], RO/V/P, default = 0x0
    //
    UINTX ecc_chunk2 : 4;
    //
    // 0  indicates no more than fail_max failing addresses, 1 - indicates more than
    // fail_max failing addresses.
    //
    // Bits[24:24], RO/V/P, default = 0x0
    //
    UINTX fail_excess3 : 1;
    //
    // 0 - indicates no failing address, 1 - indicates 1 or more failing address in the
    // corresponding Content entry.
    //
    // Bits[25:25], RO/V/P, default = 0x0
    //
    UINTX fail_any3 : 1;
    //
    // Bank 3 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries.
    //
    // Bits[27:26], RO/V/P, default = 0x0
    //
    UINTX fail_count3 : 2;
    //
    // ECC chunk 3 raster when in Mode 1.
    //
    // Bits[31:28], RO/V/P, default = 0x0
    //
    UINTX ecc_chunk3 : 4;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_ECC1_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_CONTENT_ECC2_CPGC_BOXTYPE_REG    0x00000164
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0  indicates no more than fail_max failing addresses, 1 - indicates more than
    // fail_max failing addresses.
    //
    // Bits[0:0], RO/V/P, default = 0x0
    //
    UINTX fail_excess4 : 1;
    //
    // 0 - indicates no failing address, 1 - indicates 1 or more failing address in the
    // corresponding Content entry.
    //
    // Bits[1:1], RO/V/P, default = 0x0
    //
    UINTX fail_any4 : 1;
    //
    // Bank 4 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries.
    //
    // Bits[3:2], RO/V/P, default = 0x0
    //
    UINTX fail_count4 : 2;
    //
    // ECC chunk 4 raster when in Mode 1.
    //
    // Bits[7:4], RO/V/P, default = 0x0
    //
    UINTX ecc_chunk4 : 4;
    //
    // 0  indicates no more than fail_max failing addresses, 1 - indicates more than
    // fail_max failing addresses.
    //
    // Bits[8:8], RO/V/P, default = 0x0
    //
    UINTX fail_excess5 : 1;
    //
    // 0 - indicates no failing address, 1 - indicates 1 or more failing address in the
    // corresponding Content entry.
    //
    // Bits[9:9], RO/V/P, default = 0x0
    //
    UINTX fail_any5 : 1;
    //
    // Bank 5 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries.
    //
    // Bits[11:10], RO/V/P, default = 0x0
    //
    UINTX fail_count5 : 2;
    //
    // ECC chunk 5 raster when in Mode 1.
    //
    // Bits[15:12], RO/V/P, default = 0x0
    //
    UINTX ecc_chunk5 : 4;
    //
    // 0  indicates no more than fail_max failing addresses, 1 - indicates more than
    // fail_max failing addresses.
    //
    // Bits[16:16], RO/V/P, default = 0x0
    //
    UINTX fail_excess6 : 1;
    //
    // 0 - indicates no failing address, 1 - indicates 1 or more failing address in the
    // corresponding Content entry.
    //
    // Bits[17:17], RO/V/P, default = 0x0
    //
    UINTX fail_any6 : 1;
    //
    // Bank 6 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries.
    //
    // Bits[19:18], RO/V/P, default = 0x0
    //
    UINTX fail_count6 : 2;
    //
    // ECC chunk 6 raster when in Mode 1.
    //
    // Bits[23:20], RO/V/P, default = 0x0
    //
    UINTX ecc_chunk6 : 4;
    //
    // 0  indicates no more than fail_max failing addresses, 1 - indicates more than
    // fail_max failing addresses.
    //
    // Bits[24:24], RO/V/P, default = 0x0
    //
    UINTX fail_excess7 : 1;
    //
    // 0 - indicates no failing address, 1 - indicates 1 or more failing address in the
    // corresponding Content entry.
    //
    // Bits[25:25], RO/V/P, default = 0x0
    //
    UINTX fail_any7 : 1;
    //
    // Bank 7 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries.
    //
    // Bits[27:26], RO/V/P, default = 0x0
    //
    UINTX fail_count7 : 2;
    //
    // ECC chunk 7 raster when in Mode 1.
    //
    // Bits[31:28], RO/V/P, default = 0x0
    //
    UINTX ecc_chunk7 : 4;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_CONTENT_ECC2_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_READ_COMMAND_COUNT_CURRENT_CPGC_BOXTYPE_REG  0x00000168
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Current count of reads - freezes on stop_on_error conditions at the number of
    // reads including the error that caused the stop.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX read_command_count_current : 32;
  } Bits;
  UINTX Data;
} CPGC2_READ_COMMAND_COUNT_CURRENT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_MASK_ERRS_FIRST_N_READS_CPGC_BOXTYPE_REG     0x0000016C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0=no masking, N= number of reads that will not result in any error indication
    // for the raster repository.
    //
    // Bits[31:0], RW/P, default = 0x0
    //
    UINTX mask_first_n_reads : 32;
  } Bits;
  UINTX Data;
} CPGC2_MASK_ERRS_FIRST_N_READS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_RASTER_REPO_STATUS_CPGC_BOXTYPE_REG          0x00000170
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Indicates when Mode 1 erroneous bitmap data is loaded in the raster repo.
    //
    // Bits[0:0], RO/V/P, default = 0x0
    //
    UINTX bitmapvalid : 1;
    //
    // Indicates when the summary information of the erroneous bitmap is loaded in the
    // current summary buffer. This information consist of Algorithmic data, Physical
    // Addr (Rank, Bank,Row,Col) and 8 2-bit error summary for every chunk.
    //
    // Bits[1:1], RO/V/P, default = 0x0
    //
    UINTX summaryvalid : 1;
    //
    // Indicates when the no. of errors logged exceed max value of 8.
    //
    // Bits[2:2], RO/V/P, default = 0x0
    //
    UINTX rasterrepofull : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:3], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Indicates the current number of errors loaded in the raster repo in Mode 2. Max
    // value is 8.
    //
    // Bits[6:4], RO/V/P, default = 0x0
    //
    UINTX numerrlogged : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // 0 - indicates less than or exactly max_fail failing addresses on all banks.[br]
    // 1 - indicates at least one bank's errors exceed the max_fail limit.
    //
    // Bits[8:8], RO/V/P, default = 0x0
    //
    UINTX failexcessall : 1;
    //
    // 0 - indicates no failing addresses.[br]
    // 1 - indicates 1 or more failing addresses.
    //
    // Bits[9:9], RO/V/P, default = 0x0
    //
    UINTX failanyall : 1;
    //
    // Maximum number of failing address before an additional failing address will set
    // fail_excess for any bank.[br]
    // 00  one failure, 01 - two failures, 10 - three failures, 11- four failures.[br]
    //
    //
    // Bits[11:10], RW/P, default = 0x0
    //
    UINTX failmax : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 4;
    //
    // 00 Mode 1 BitMap Mode.[br]
    // 01 Mode 2 Summary Mode.[br]
    // 10 mode 3 Filtered Failed Row Mode.
    //
    // Bits[17:16], RW/P, default = 0x0
    //
    UINTX rasterrepomode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 12;
    //
    // If Raster Mode 1, test will stop after loading the bitmap into the raster. If
    // Raster Mode 2, test will stop after loading 8 errors in the raster.
    //
    // Bits[30:30], RW/P, default = 0x0
    //
    UINTX stoponraster : 1;
    //
    // Reset the raster repo entries. This bit auto-clears.
    //
    // Bits[31:31], RW/V, default = 0x0
    //
    UINTX rasterrepoclear : 1;
  } Bits;
  UINTX Data;
} CPGC2_RASTER_REPO_STATUS_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ERR_SUMMARY_A_CPGC_BOXTYPE_REG               0x00000174
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Error_Summary - formatted as a pair of adjacent bits for each chunk, 00=no error
    // in that chunk, 01=one error in that chunk, 10=two errors in that chunk, 11=three
    // or more errors in that chunk.
    //
    // Bits[15:0], RO/V/P, default = 0x0
    //
    UINTX error_summary : 16;
    //
    // Algorithm_Summary - currently formated as:[br]
    // [2:0] Offset_Command_Instruction_Current.[br]
    // [5:3] Offset_Address_Instruction_Current.[br]
    // [10:6] Command_Instruction_Current.[br]
    // [13:11] Algorithm_Instruction_Current.[br]
    // [15:14] Data_Instruction_Current.
    //
    // Bits[31:16], RO/V/P, default = 0x0
    //
    UINTX algorithm_summary : 16;
  } Bits;
  UINTX Data;
} CPGC2_ERR_SUMMARY_A_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ERR_SUMMARY_B_CPGC_BOXTYPE_REG               0x00000178
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Algorithm_Summary - currently formated as:[br]
    // [1:0] Address_Instruction_Current.
    //
    // Bits[1:0], RO/V/P, default = 0x0
    //
    UINTX algorithm_summary : 2;
    //
    // Error_Summary - Physical Address encoded as:[br]
    // [7:0] Column, [25:8] Row, [28:26] Bank, [29] Rank.
    //
    // Bits[31:2], RO/V/P, default = 0x0
    //
    UINTX physical_address_summary : 30;
  } Bits;
  UINTX Data;
} CPGC2_ERR_SUMMARY_B_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC2_ERR_SUMMARY_C_CPGC_BOXTYPE_REG               0x0000017C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved for expansion of Error_Summary (bits 7:0).
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX dg_reserved : 32;
  } Bits;
  UINTX Data;
} CPGC2_ERR_SUMMARY_C_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_BUF_CTL_CPGC_BOXTYPE_REG                 0x00000180
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 0: Each buffer entry will be used for 2^BUF_PTR_INC_RATE number of bursts (64Bytes).[br]
    // 1: Each buffer entry will be used for BUF_PTR_INC_RATE + 1 number of 8-UI[br]
    // -- before incrementing the buffer pointer by 1.[br]
    //  Note:  To disable Buffer Pointer increments, set BUF_END_PTR==BUF_STRT_PTR.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX buf_pntr_inc_rate : 6;
    //
    // If set, the buffer pointer will be incremented at a linear rate given by BUF_PTR_INC_RATE,
    // otherwise the buffer pointer will be incremented at an exponential rate given
    // by BUF_PTR_INC_RATE.[br][br]
    // 1=Buffer Pointer Increment Rate field is treated as a linear number.[br][br]
    // 0=Buffer Pointer Increment Rate field is treated is an exponential number.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX buf_pntr_inc_scale : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Pointer to first buffer entry.  Also used as the only entry if BUF_INC_EN is not
    // enabled.[br] Note: The actual size of this field depends on the # of lines supported
    // for data generation (DATA_PAT_DEPTH_CAP), i.e If 1 or 2 lines are supported then
    // it is a 1 bit field, if 16 lines are supported then the whole 4 bits are available.
    // Currently the RTL uses internal CPGC buffers so it has 8 lines and requires 3
    // bits.
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX buf_strt_pntr : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 5;
    //
    // Pointer to last data pattern buffer entry before wrapping back to BUF_STRT_PTR
    // if incrementing is enabled through being different from BUF_STRT_PTR.[br] Note:
    // The actual size of this field depends on the # of lines supported for data generation.
    // i.e If 1 or 2 lines are supported then it is a 1 bit field, if 8 lines are supported
    // then 3 bits are available. Currently the RTL uses internal CPGC buffers so it
    // has 4 lines and requires 2 bits.
    //
    // Bits[18:16], RW, default = 0x0
    //
    UINTX buf_end_pntr : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[19:19], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 1;
    //
    // Pointer to current entry in the data pattern buffers used for generating the write
    // data.
    //
    // Bits[23:20], RO/V, default = 0x0
    //
    UINTX wr_buf_ptr : 4;
    //
    // Pointer to current entry in the data pattern buffers used for generating the read
    // data.
    //
    // Bits[27:24], RO/V, default = 0x0
    //
    UINTX rd_buf_ptr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 4;
  } Bits;
  UINTX Data;
} CPGC_DPAT_BUF_CTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_CFG_CPGC_BOXTYPE_REG                     0x00000184
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines the operational mode for unified sequence 0 as follows:[br][br]
    // 00 - LMN Mode.[br][br]
    // 01 - Pattern Buffer Mode.[br][br]
    // 10 - LFSR Mode.[br][br]
    // 11 - Reserved for future use.
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX uniseq0_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[2:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Defines the operational mode for unified sequence 1 as follows:[br][br]
    // 00 - LMN Mode.[br][br]
    // 01 - Pattern Buffer Mode.[br][br]
    // 10 - LFSR Mode.[br][br]
    // 11 - Reserved for future use.
    //
    // Bits[4:3], RW, default = 0x0
    //
    UINTX uniseq1_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[5:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Defines the operational mode for unified sequence 2 as follows:[br][br]
    // 00 - LMN Mode.[br][br]
    // 01 - Pattern Buffer Mode.[br][br]
    // 10 - LFSR Mode.[br][br]
    // 11 - Reserved for future use.
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX uniseq2_mode : 2;
    //
    // When Write_Address_as_Data is set to '1', any address fields that the CADB is
    // overriding during a Select cycle should be used for generating the write data.
    //  Otherwise, the functional path decoded address field should be used for generating
    // the write data.[br]
    // Data Construction rules follow the same as for READ_ADDRESS_AS_DATA.[br]
    //
    // This format is subject to change based on memory technology supported and other
    // reasons and the main HAS documentation should be referenced if required. What
    // is to be guaranteed is that every Cacheline of data will be unique to each address.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX write_address_as_data : 1;
    //
    // When Read_Address_as_Data is set to '1' any address fields that the CADB is overriding
    // during a Select cycle should be used for comparing the incoming data.  Otherwise,
    // the functional path decoded address field should be used for comparing the incoming
    // data.[br]
    // This override of the data will not respect any inversion, rotation or other data
    // modification. It will only be active (override the normal output/reference) when
    // Alternate_Data is active in either the Command_Instruction or the Offset_Command_Instruction
    // as appropriate .[br]
    // The functional path decoded address field used for read comparison is repeated
    // in chunk and should follow the Data Construction rules described below on what
    // bytegroup relates to what decoded address:[br][br]
    // Chunk0 - Byte0 =Column(7:0).[br]
    // Chunk0 - Byte1 =Column(9:8) <- as many Column bits as supported.[br]
    // Chunk0 - Byte2 =Row(0:7).[br]
    // Chunk0 - Byte3 =Row(15:8).[br]
    // Chunk0 - Byte4 =Row(17:16)<- as many Row bits as supported.[br]
    // Chunk0 - Byte5 =Bank(3:0)  [Note: Bank Group may be part of this field] <- as
    // many Bank bits as supported.[br]
    // Chunk0 - Byte6 =Rank(1:0) <- as many Rank bits as supported (would be CS# if CADB
    // output supported).[br]
    // Chunk0 - Byte7 =Reserved (set to 0).[br]
    //
    // Note: Broxton will not support CADB Select cycle information being used for Address-as-data.
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX read_address_as_data : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[12:10], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 3;
    //
    // Setting this bit will internally disable all related ECC features in CPGC having
    // the effect of generating all '1 in the ECC CPGC interface outputs, and of Binding
    // to '0 all the ECC interface CPGC inputs. ECC masks and error comparisons will
    // be disabled as well.[br]
    // If ECC is supported, but not directly passed to CPGC, then this bit when set will
    // enable the ECC_REPLACE_BYTE_CONTROL and ECC_DATA_SOURCE_SEL functionality, to
    // allow driving of ECC from another ByteLane, and replacing the incoming data with
    // ECC for that ByteLane.[br]
    // When ECC is disabled with this bit, then the output of CPGC will be determined
    // based on BE_TRAIN_ERR_EN and may output all 1's or the content of the DRAMDM and
    // XDRAMDM registers as Byte-Enables.
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX ecc_disable : 1;
    //
    // ECC_Replace_Byte_Control is used by the Read data path to mux the received ECC
    // byte into the same byte group indicated by ECC_Data_Source_Sel.[br]
    // This is needed to capture ECC cacheline errors into the WDB when Enable_WDB_Error_Capture
    // is set to 1.[br]
    // This bit may be reserved if ECC is not supported, or if this functionality is
    // controlled from a different register.
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX ecc_replace_byte_control : 1;
    //
    // Indicates whether byte 0 (Dq0-Dq7) or byte 7 (dq56-dq63) is transmitted and compared
    // for the ECC byte.[br]
    // 0=byte group 0 will be transmitted and compared for the ECC byte.[br]
    // 1=byte group 7 will be transmitted and compared for the ECC byte.[br]
    // Hardware directs if ECC is included within Generation and Checking.[br]
    // This bit may be reserved if ECC is not supported, or if this functionality is
    // controlled from a different register.
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX ecc_data_source_sel : 1;
    //
    // Save_LFSR_Seed_Rate only exists if the LFSR_Save_Restore capability is set to
    // 1.[br][br]
    // See Reload_LFSR_Seed_Rate for use model.[br][br]
    // UNISEQ#_RDSAVE.Pattern_Buffer is initially loaded at the start of a test with
    // UNISEQ#_RDSTAT.Uniseq_RdStat (the Seed). [br][br]
    // 2^(Reload_LFSR_Seed_Rate-1) * (Save_LFSR_Seed_Rate) defines the periodic Loopcount
    // interval that the current LFSR Seed is saved into UNISEQ#_RDSAVE.Pattern_Buffer.[br][br]
    // When the Save_LFSR_Seed_Rate and Reload_LFSR_Seed_Rate is reached in the same
    // Loopcount only the saving of the LFSR seed takes place.[br][br]
    // Examples:[br][br]
    // 0=Disable - The current LFSR seed (UNISEQ#_RDSTAT.Uniseq_RdStat) is saved only
    // at the start of test into UNISEQ#_RDSAVE.Pattern_Buffer.[br][br]
    // 1=Illegal (Would save every Reload and effectively disable both Save and Reload).[br][br]
    // 2=The current LFSR seed is saved every other 2^(Reload_LFSR_Seed_Rate-1) Loopcounts.[br][br]
    // 3=The current LFSR seed is saved every third Reload (and Reload does not happen).
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX save_lfsr_seed_rate : 8;
    //
    // Reload_LFSR_Seed_Rate only exists if the LFSR_Save_Restore capability is set to
    // 1.[br][br]
    // Reload_LFSR_Seed_Rate and Save_LFSR_Seed_Rate is most often used in conjunction
    // with Lane_Rotate_Rate where the user desires to replay the same deterministic
    // LFSR stress as the victim aggressor patterns shifts Lanes left.  When the victim
    // aggressor pattern returns to the starting position the current LFSR stress is
    // saved using Save_LFSR_Seed_Rate to allow the LFSR stress to advance for the new
    // period.[br][br]
    // 2^(Reload_LFSR_Seed_Rate-1) defines the periodic Loopcount interval that the current
    // LFSR Seed UNISEQ#_RDSTAT.Uniseq_RdStat is reloaded from CPGC_UNISEQ#_RDSAVE.Pattern_Buffer.[br][br]
    // When the Save_LFSR_Seed_Rate and Reload_LFSR_Seed_Rate is reached in the same
    // Bit only the saving of the LFSR seed takes place.[br][br]
    // Examples:[br][br]
    // 0=Disable - The current LFSR seed is never reloaded.[br][br]
    // 1=The current LFSR seed  is reloaded every Loopcount.[br][br]
    // 2=The current LFSR seed  is reloaded every other Loopcount.[br][br]
    // 3=The current LFSR seed  is reloaded every fourth Loopcount.
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX reload_lfsr_seed_rate : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:29], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 3;
  } Bits;
  UINTX Data;
} CPGC_DPAT_CFG_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_XTRA_LFSR_CFG_CPGC_BOXTYPE_REG           0x00000188
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[1:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Possible Polynomial Sizes:[br][br]
    // 0x0=Use 8 bit LFSR (x8 + x6 + x5 + x4)[br][br]
    // 0x1=Use 15 bit LFSR (x15 + x14)[br][br]
    // 0x2=Use 31 bit LFSR (x31 + x28)[br][br]
    // 0x3=Use 23 bit LFSR (x23 + x18)[br][br]
    // 0x4=Use 7 bit LFSR (x7 + x6)[br][br]
    // 0x5=Use 16 bit LFSR (x16+x5+x4+x3)[br][br]
    // 0x6=Use 23 bit LFSR (x23+x21+x18+x15+x7+x2)[br][br]
    // 0x7=Use 32 bit LFSR (x32+x31+x30+x10)
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX uniseq0_lfsr_polynomial_size : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[6:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // 0=No Stagger, 1=Stagger.[br][br]
    // This bit must not be set unless Uniseq0_Mode is programmed to Select LFSR or the
    // behavior is undefined.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX uniseq0_lfsr_stagger : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[9:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Possible Polynomial Sizes:[br][br]
    // 0x0=Use 8 bit LFSR (x8 + x6 + x5 + x4)[br][br]
    // 0x1=Use 15 bit LFSR (x15 + x14)[br][br]
    // 0x2=Use 31 bit LFSR (x31 + x28)[br][br]
    // 0x3=Use 23 bit LFSR (x23 + x18)[br][br]
    // 0x4=Use 7 bit LFSR (x7 + x6)[br][br]
    // 0x5=Use 16 bit LFSR (x16+x5+x4+x3)[br][br]
    // 0x6=Use 23 bit LFSR (x23+x21+x18+x15+x7+x2)[br][br]
    // 0x7=Use 32 bit LFSR (x32+x31+x30+x10)
    //
    // Bits[12:10], RW, default = 0x0
    //
    UINTX uniseq1_lfsr_polynomial_size : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[14:13], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // 0=No Stagger, 1=Stagger.[br][br]
    // This bit must not be set unless Uniseq1_Mode is programmed to Select LFSR or the
    // behavior is undefined.
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX uniseq1_lfsr_stagger : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[17:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_4 : 2;
    //
    // Possible Polynomial Sizes:[br][br]
    // 0x0=Use 8 bit LFSR (x8 + x6 + x5 + x4)[br][br]
    // 0x1=Use 15 bit LFSR (x15 + x14)[br][br]
    // 0x2=Use 31 bit LFSR (x31 + x28)[br][br]
    // 0x3=Use 23 bit LFSR (x23 + x18)[br][br]
    // 0x4=Use 7 bit LFSR (x7 + x6)[br][br]
    // 0x5=Use 16 bit LFSR (x16+x5+x4+x3)[br][br]
    // 0x6=Use 23 bit LFSR (x23+x21+x18+x15+x7+x2)[br][br]
    // 0x7=Use 32 bit LFSR (x32+x31+x30+x10)
    //
    // Bits[20:18], RW, default = 0x0
    //
    UINTX uniseq2_lfsr_polynomial_size : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[22:21], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_5 : 2;
    //
    // 0=No Stagger, 1=Stagger.[br][br]
    // This bit must not be set unless Uniseq2_Mode is programmed to Select LFSR or the
    // behavior is undefined.
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX uniseq2_lfsr_stagger : 1;
    //
    // Lane_Rotate_Rate only exists if the Lane_Rotation_Support capability exists.[br][br]
    // 2^(Lane_Rotate_Rate-1) indicates the periodic Loopcount rate when the EXTBUF_#
    // registers are rotated up by one bit.[br][br]
    // Lane_Rotate_Rate=0 disables all rotation.[br][br]
    // Lane_Rotate_Rate=1 causes the EXTBUF_# registers to be rotated every one Loopcount.[br][br]
    // Lane_Rotate_Rate=2  causes the EXTBUF_# registers to be rotated every other Loopcount.[br][br]
    // Etc..[br][br]
    // When the EXTBUF_# registers are rotated Bit 0 shifts to Bit 1 all the way up to
    // the Max-1 Bit and the Max bit shifts to Bit0.
    //
    // Bits[29:24], RW, default = 0x0
    //
    UINTX lane_rotate_rate : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_6 : 2;
  } Bits;
  UINTX Data;
} CPGC_DPAT_XTRA_LFSR_CFG_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_0__CPGC_BOXTYPE_REG               0x0000018C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // If UniSeq#_Mode is set to Pattern Buffer mode, then this field represents the
    // initial content of the rotating pattern buffer for the unified sequencer. If UniSeq#_Mode
    // is set to LFSR mode, then this field represents the 32-bit LFSR seed for the unified
    // sequencer. Note: This is a shared register, it has a meaning according to the
    // UniSeq# mode.[br]
    // [b]For PRBS lengths less than or equal to 8, the seed must contain 16 bits of
    // the initial PRBS sequence.[b]
    //
    // Bits[31:0], RW, default = 0xAA55AA55
    //
    UINTX pattern_buffer : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_1__CPGC_BOXTYPE_REG               0x00000190
#ifndef ASM_INC
typedef union {
  struct {
    //
    // If UniSeq#_Mode is set to Pattern Buffer mode, then this field represents the
    // initial content of the rotating pattern buffer for the unified sequencer. If UniSeq#_Mode
    // is set to LFSR mode, then this field represents the 32-bit LFSR seed for the unified
    // sequencer. Note: This is a shared register, it has a meaning according to the
    // UniSeq# mode.[br]
    // [b]For PRBS lengths less than or equal to 8, the seed must contain 16 bits of
    // the initial PRBS sequence.[b]
    //
    // Bits[31:0], RW, default = 0xAA55AA55
    //
    UINTX pattern_buffer : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_2__CPGC_BOXTYPE_REG               0x00000194
#ifndef ASM_INC
typedef union {
  struct {
    //
    // If UniSeq#_Mode is set to Pattern Buffer mode, then this field represents the
    // initial content of the rotating pattern buffer for the unified sequencer. If UniSeq#_Mode
    // is set to LFSR mode, then this field represents the 32-bit LFSR seed for the unified
    // sequencer. Note: This is a shared register, it has a meaning according to the
    // UniSeq# mode.[br]
    // [b]For PRBS lengths less than or equal to 8, the seed must contain 16 bits of
    // the initial PRBS sequence.[b]
    //
    // Bits[31:0], RW, default = 0xAA55AA55
    //
    UINTX pattern_buffer : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_LMN_0__CPGC_BOXTYPE_REG           0x00000198
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial logic output of the sequencer is defined as follows:[br][br]
    //                         0 - Output Logic '0' for L_CNT UIs.[br][br]
    //                         1 - Output Logic '1' for L_CNT UIs.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX l_sel : 1;
    //
    // Used in concatenation with L_COUNT_EN to enable 3 possible modes of LMN behavior:[br][br]
    // {L_COUNT_EN,FREQ_SWEEP_EN}[br][br]
    // {0,0} - Normal LMN.[br][br]
    // {0,1} - Sweep clock pattern from 2*M period down to 2*N_Count period and repeat.[br][br]
    // {1,0} - L-Counter - drive clock pattern of 2*L period.[br][br]
    // {1,1} - Currently same as L-Counter mode - reserved for future use.[br][br]
    // If Normal LMN mode, then the following pattern is continuously repeated:[br][br]
    //   1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]
    //   2) Drive M_Count bits with the  inverse of L_Polarity.[br][br]
    //   3) Drive N_Count bits with the  value of L_Polarity.[br][br]
    //   4) Go to step 2.[br][br]
    // If any L_Count, M_Count, or N_Count=0 then the  state will freeze at the polarity
    // driven for that stage.[br][br][br]
    // If Sweep mode, then the following pattern is continuously repeated:[br][br]
    //   1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]
    //   2) X_count=M_Count [br][br]
    //   3) Drive X_Count bits with the  inverse of L_Polarity.[br][br]
    //   4) Drive X_Count bits with the  value of L_Polarity.[br][br]
    //   5) Drive X_Count bits with the  inverse of L_Polarity.[br][br]
    //   6) If X_Count==N_Count then go to step 9.[br][br]
    //   7) X_Count=X_Count-1[br][br]
    //   8) Go to step 10.[br][br]
    //   9) X_Count=M_Count[br][br]
    // 10) Drive X_Count bits with the  value of L_Polarity.[br][br]
    // 11) Go to step 3.[br][br]
    // [br]
    // If LCount mode, then the following pattern is continuously repeated:[br][br]
    //   1) Drive L_Polarity for L_Count Bits.[br][br]
    //   2) Drive inverse of L_Polarity for L_Count Bits.[br][br]
    //   3) Go to step 1.[br][br]
    //   [br][br]
    // If {0,1}, L_Count, M_Count, and N_Count must never be programmed to 0 and is considered
    // undefined.[br][br]
    // If {1,0}, L_Count must never be programmed to 0 and is considered undefined.[br][br]
    // If {0,1}, M_Count and N_Count must be greater than or equal to 8 or behavior may
    // be implementation specific.[br][br]
    // If {0,1}, N_Count must be programmed less than M_Count.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX freq_sweep_en : 1;
    //
    // Used in concatenation with FREQ_SWEEP_EN to enable 3 possible modes of LMN behavior.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX l_count_en : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:3], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Additional 4 bits to increase the size of L Count up to 12.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX l_counter_hi : 4;
    //
    // If LMN_Support capability is set to 0 then:[br]A periodic square wave is generated
    // that has the following behavior.[br][br]
    // 1) Drive L_Polarity for L_Count Bits.[br][br]
    // 2) Drive inverse of L_Polarity for L_Count Bits.[br][br]
    // 3) Go to step 1.[br][br]
    // Else if LMN_Support is set to 1 then:[br][br]
    // After L_Count bits are driven at the beginning of a test then periodic pattern
    // is continuously repeated depending on the value of Enable_Sweep_Frequency is set
    // to 1.[br][br]
    // If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency
    // for exact behavior).[br][br]
    // If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging
    // from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior).
    //
    // Bits[15:8], RW, default = 0x1
    //
    UINTX l_cnt : 8;
    //
    // M_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count
    // bits are driven at the beginning of a test then periodic pattern is continuously
    // repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0
    // then a steady state frequency is driven (see Enable_Sweep_Frequency for exact
    // behavior).[br]If Enable_Sweep_Frequency=1 then a frequency sweep is continuously
    // generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact
    // behavior).
    //
    // Bits[23:16], RW, default = 0x1
    //
    UINTX m_cnt : 8;
    //
    // N_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count
    // bits are driven at the beginning of a test then periodic pattern is continuously
    // repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0
    // then a steady state frequency is driven (see Enable_Sweep_Frequency for exact
    // behavior).[br] If Enable_Sweep_Frequency=1 then a frequency sweep is continuously
    // generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact
    // behavior).
    //
    // Bits[31:24], RW, default = 0x1
    //
    UINTX n_cnt : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_LMN_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_LMN_1__CPGC_BOXTYPE_REG           0x0000019C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial logic output of the sequencer is defined as follows:[br][br]
    //                         0 - Output Logic '0' for L_CNT UIs.[br][br]
    //                         1 - Output Logic '1' for L_CNT UIs.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX l_sel : 1;
    //
    // Used in concatenation with L_COUNT_EN to enable 3 possible modes of LMN behavior:[br][br]
    // {L_COUNT_EN,FREQ_SWEEP_EN}[br][br]
    // {0,0} - Normal LMN.[br][br]
    // {0,1} - Sweep clock pattern from 2*M period down to 2*N_Count period and repeat.[br][br]
    // {1,0} - L-Counter - drive clock pattern of 2*L period.[br][br]
    // {1,1} - Currently same as L-Counter mode - reserved for future use.[br][br]
    // If Normal LMN mode, then the following pattern is continuously repeated:[br][br]
    //   1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]
    //   2) Drive M_Count bits with the  inverse of L_Polarity.[br][br]
    //   3) Drive N_Count bits with the  value of L_Polarity.[br][br]
    //   4) Go to step 2.[br][br]
    // If any L_Count, M_Count, or N_Count=0 then the  state will freeze at the polarity
    // driven for that stage.[br][br][br]
    // If Sweep mode, then the following pattern is continuously repeated:[br][br]
    //   1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]
    //   2) X_count=M_Count [br][br]
    //   3) Drive X_Count bits with the  inverse of L_Polarity.[br][br]
    //   4) Drive X_Count bits with the  value of L_Polarity.[br][br]
    //   5) Drive X_Count bits with the  inverse of L_Polarity.[br][br]
    //   6) If X_Count==N_Count then go to step 9.[br][br]
    //   7) X_Count=X_Count-1[br][br]
    //   8) Go to step 10.[br][br]
    //   9) X_Count=M_Count[br][br]
    // 10) Drive X_Count bits with the  value of L_Polarity.[br][br]
    // 11) Go to step 3.[br][br]
    // [br]
    // If LCount mode, then the following pattern is continuously repeated:[br][br]
    //   1) Drive L_Polarity for L_Count Bits.[br][br]
    //   2) Drive inverse of L_Polarity for L_Count Bits.[br][br]
    //   3) Go to step 1.[br][br]
    //   [br][br]
    // If {0,1}, L_Count, M_Count, and N_Count must never be programmed to 0 and is considered
    // undefined.[br][br]
    // If {1,0}, L_Count must never be programmed to 0 and is considered undefined.[br][br]
    // If {0,1}, M_Count and N_Count must be greater than or equal to 8 or behavior may
    // be implementation specific.[br][br]
    // If {0,1}, N_Count must be programmed less than M_Count.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX freq_sweep_en : 1;
    //
    // Used in concatenation with FREQ_SWEEP_EN to enable 3 possible modes of LMN behavior.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX l_count_en : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:3], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Additional 4 bits to increase the size of L Count up to 12.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX l_counter_hi : 4;
    //
    // If LMN_Support capability is set to 0 then:[br]A periodic square wave is generated
    // that has the following behavior.[br][br]
    // 1) Drive L_Polarity for L_Count Bits.[br][br]
    // 2) Drive inverse of L_Polarity for L_Count Bits.[br][br]
    // 3) Go to step 1.[br][br]
    // Else if LMN_Support is set to 1 then:[br][br]
    // After L_Count bits are driven at the beginning of a test then periodic pattern
    // is continuously repeated depending on the value of Enable_Sweep_Frequency is set
    // to 1.[br][br]
    // If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency
    // for exact behavior).[br][br]
    // If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging
    // from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior).
    //
    // Bits[15:8], RW, default = 0x1
    //
    UINTX l_cnt : 8;
    //
    // M_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count
    // bits are driven at the beginning of a test then periodic pattern is continuously
    // repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0
    // then a steady state frequency is driven (see Enable_Sweep_Frequency for exact
    // behavior).[br]If Enable_Sweep_Frequency=1 then a frequency sweep is continuously
    // generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact
    // behavior).
    //
    // Bits[23:16], RW, default = 0x1
    //
    UINTX m_cnt : 8;
    //
    // N_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count
    // bits are driven at the beginning of a test then periodic pattern is continuously
    // repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0
    // then a steady state frequency is driven (see Enable_Sweep_Frequency for exact
    // behavior).[br] If Enable_Sweep_Frequency=1 then a frequency sweep is continuously
    // generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact
    // behavior).
    //
    // Bits[31:24], RW, default = 0x1
    //
    UINTX n_cnt : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_LMN_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_LMN_2__CPGC_BOXTYPE_REG           0x000001A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial logic output of the sequencer is defined as follows:[br][br]
    //                         0 - Output Logic '0' for L_CNT UIs.[br][br]
    //                         1 - Output Logic '1' for L_CNT UIs.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX l_sel : 1;
    //
    // Used in concatenation with L_COUNT_EN to enable 3 possible modes of LMN behavior:[br][br]
    // {L_COUNT_EN,FREQ_SWEEP_EN}[br][br]
    // {0,0} - Normal LMN.[br][br]
    // {0,1} - Sweep clock pattern from 2*M period down to 2*N_Count period and repeat.[br][br]
    // {1,0} - L-Counter - drive clock pattern of 2*L period.[br][br]
    // {1,1} - Currently same as L-Counter mode - reserved for future use.[br][br]
    // If Normal LMN mode, then the following pattern is continuously repeated:[br][br]
    //   1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]
    //   2) Drive M_Count bits with the  inverse of L_Polarity.[br][br]
    //   3) Drive N_Count bits with the  value of L_Polarity.[br][br]
    //   4) Go to step 2.[br][br]
    // If any L_Count, M_Count, or N_Count=0 then the  state will freeze at the polarity
    // driven for that stage.[br][br][br]
    // If Sweep mode, then the following pattern is continuously repeated:[br][br]
    //   1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]
    //   2) X_count=M_Count [br][br]
    //   3) Drive X_Count bits with the  inverse of L_Polarity.[br][br]
    //   4) Drive X_Count bits with the  value of L_Polarity.[br][br]
    //   5) Drive X_Count bits with the  inverse of L_Polarity.[br][br]
    //   6) If X_Count==N_Count then go to step 9.[br][br]
    //   7) X_Count=X_Count-1[br][br]
    //   8) Go to step 10.[br][br]
    //   9) X_Count=M_Count[br][br]
    // 10) Drive X_Count bits with the  value of L_Polarity.[br][br]
    // 11) Go to step 3.[br][br]
    // [br]
    // If LCount mode, then the following pattern is continuously repeated:[br][br]
    //   1) Drive L_Polarity for L_Count Bits.[br][br]
    //   2) Drive inverse of L_Polarity for L_Count Bits.[br][br]
    //   3) Go to step 1.[br][br]
    //   [br][br]
    // If {0,1}, L_Count, M_Count, and N_Count must never be programmed to 0 and is considered
    // undefined.[br][br]
    // If {1,0}, L_Count must never be programmed to 0 and is considered undefined.[br][br]
    // If {0,1}, M_Count and N_Count must be greater than or equal to 8 or behavior may
    // be implementation specific.[br][br]
    // If {0,1}, N_Count must be programmed less than M_Count.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX freq_sweep_en : 1;
    //
    // Used in concatenation with FREQ_SWEEP_EN to enable 3 possible modes of LMN behavior.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX l_count_en : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:3], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Additional 4 bits to increase the size of L Count up to 12.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX l_counter_hi : 4;
    //
    // If LMN_Support capability is set to 0 then:[br]A periodic square wave is generated
    // that has the following behavior.[br][br]
    // 1) Drive L_Polarity for L_Count Bits.[br][br]
    // 2) Drive inverse of L_Polarity for L_Count Bits.[br][br]
    // 3) Go to step 1.[br][br]
    // Else if LMN_Support is set to 1 then:[br][br]
    // After L_Count bits are driven at the beginning of a test then periodic pattern
    // is continuously repeated depending on the value of Enable_Sweep_Frequency is set
    // to 1.[br][br]
    // If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency
    // for exact behavior).[br][br]
    // If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging
    // from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior).
    //
    // Bits[15:8], RW, default = 0x1
    //
    UINTX l_cnt : 8;
    //
    // M_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count
    // bits are driven at the beginning of a test then periodic pattern is continuously
    // repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0
    // then a steady state frequency is driven (see Enable_Sweep_Frequency for exact
    // behavior).[br]If Enable_Sweep_Frequency=1 then a frequency sweep is continuously
    // generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact
    // behavior).
    //
    // Bits[23:16], RW, default = 0x1
    //
    UINTX m_cnt : 8;
    //
    // N_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count
    // bits are driven at the beginning of a test then periodic pattern is continuously
    // repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0
    // then a steady state frequency is driven (see Enable_Sweep_Frequency for exact
    // behavior).[br] If Enable_Sweep_Frequency=1 then a frequency sweep is continuously
    // generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact
    // behavior).
    //
    // Bits[31:24], RW, default = 0x1
    //
    UINTX n_cnt : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_LMN_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_INVDCCTL_CPGC_BOXTYPE_REG                0x000001A4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A value of  for any of the bits means the corresponding ECC lane(s) will be inverted
    // or a DC value driven on it.  Note that this field is used to load bits [71:64]
    // of the continuous shift register composed of this field along with DATA_INV_DC_MASK_HI
    // and DATA_INV_DC_MASK_LO.   Note: this field is only available if ECC is supported
    // for the current implementation, otherwise it is reserved.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX ecc_inv_dc_mask : 8;
    //
    // If inversion mask rotation is enabled through MASK_ROTATE_EN, the mask will rotate
    // to the left every time 2^MASK_ROTATE_RATE bursts (64Bytes) have been have been
    // issued.
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX mask_rotate_rate : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // Select between the two bytes of unique lanes being generated by the DPAT pattern
    // generator, to be applied in each DQ byte group, as many byte groups as required
    // by the number of DQ pins.  MSB is always for the ECC byte group, used only if
    // ECC is present.
    //
    // Bits[24:16], RW, default = 0xAA
    //
    UINTX bytegroup_mapping : 9;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[28:25], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // Selects the polarity of the signal to be driven through the inversion/DC mask
    // if DC_OR_INV is set to 1:[br][br]
    // 0 - Drive a logic low (zero).[br][br]
    // 1 - Drive a logic high (one).
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX dc_pol : 1;
    //
    // Selects between using the inversion/DC mask for inversion or DC as follows:[br][br]
    // 0 - Mask used for inversion.[br][br]
    // 1 - Mask used for driving a DC signal of polarity DC_POL.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX dc_or_inv : 1;
    //
    // If set, the inversion/DC mask will rotate to the left at a rate defined by the
    // MASK_ROTATE_RATE field.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX mask_rotate_en : 1;
  } Bits;
  UINTX Data;
} CPGC_DPAT_INVDCCTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_INV_DC_MASK_LO_CPGC_BOXTYPE_REG          0x000001A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A value of '1' for any of the bits means the corresponding data lane(s) will be
    // inverted or a DC value driven on it. Note that this field is used to load bits
    // [31:0] of the continuous shift register composed of this field along with ECC_INV_DC_MASK
    // and DATA_INV_DC_MASK_HI.[br]
    // DPAT generator only uses the appropriate bits based on the widest bus that this
    // CPGC block is designed to support.[br]
    // This register is also used to provide the Initial value for the Alternate Data
    // pattern generator.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_inv_dc_mask_lo : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_INV_DC_MASK_LO_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_INV_DC_MASK_HI_CPGC_BOXTYPE_REG          0x000001AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A value of '1' for any of the bits means the corresponding data lane(s) will be
    // inverted or a DC value driven on it. Note that this field is used to load bits
    // [63:32] of the continuous shift register composed of this field along with ECC_INV_DC_MASK
    // and DATA_INV_DC_MASK_LO.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data_inv_dc_mask_hi : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_INV_DC_MASK_HI_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_DRAMDM_CPGC_BOXTYPE_REG                  0x000001B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A byte enable field with each bit corresponding to a data byte sent during a burst
    // such that:[br]
    // 0 - Mask the Corresponding Byte.[br]
    // 1 - No Mask to the Corresponding Byte.[br]
    // The byte-to-bit mapping is given by Byte[n] -> bit[n].[br]
    // This register is for the first half cacheline of data.[br]
    // It is only used when ECC is not present or is disabled.
    //
    // Bits[31:0], RW, default = 0xFFFFFFFF
    //
    UINTX data_mask_lo : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_DRAMDM_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_XDRAMDM_CPGC_BOXTYPE_REG                 0x000001B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A byte enable field with each bit corresponding to a data byte sent during a burst
    // such that:[br]
    // 0 - Mask the Corresponding Byte.[br]
    // 1 - No Mask to the Corresponding Byte.[br]
    // The byte-to-bit mapping is given by Byte[n+32] -> bit[n].[br]
    // This register is for the Second half cacheline of data.[br]
    // It is only used when ECC is not present or is disabled.
    //
    // Bits[31:0], RW, default = 0xFFFFFFFF
    //
    UINTX data_mask_hi : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_XDRAMDM_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_WRSTAT_0__CPGC_BOXTYPE_REG        0x000001B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the Pattern/LFSR buffer in write generation domain.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX uniseq_wrstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_WRSTAT_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_WRSTAT_1__CPGC_BOXTYPE_REG        0x000001BC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the Pattern/LFSR buffer in write generation domain.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX uniseq_wrstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_WRSTAT_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_WRSTAT_2__CPGC_BOXTYPE_REG        0x000001C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the Pattern/LFSR buffer in write generation domain.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX uniseq_wrstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_WRSTAT_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_RDSTAT_0__CPGC_BOXTYPE_REG        0x000001C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reflects the current and final status of the pattern buffer in the read domain.[br]
    // If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in
    // serial fashion.   After all the bits in the Pattern_Buffer have been transmitted
    // the  pattern will simply repeat itself continuously while a Loopback Test is in
    // progress.[br][br]
    // If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output
    // in serial fashion.  Over time the LFSR pattern will repeat itself continuously
    // while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer
    // will interact with the LFSR in the following ways:[br][br]
    // If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will
    // interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]
    // 1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]
    // 2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details).
    //
    // Bits[31:0], RO/V, default = 0xDEADBEEF
    //
    UINTX uniseq_rdstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_RDSTAT_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_RDSTAT_1__CPGC_BOXTYPE_REG        0x000001C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reflects the current and final status of the pattern buffer in the read domain.[br]
    // If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in
    // serial fashion.   After all the bits in the Pattern_Buffer have been transmitted
    // the  pattern will simply repeat itself continuously while a Loopback Test is in
    // progress.[br][br]
    // If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output
    // in serial fashion.  Over time the LFSR pattern will repeat itself continuously
    // while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer
    // will interact with the LFSR in the following ways:[br][br]
    // If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will
    // interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]
    // 1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]
    // 2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details).
    //
    // Bits[31:0], RO/V, default = 0xDEADBEEF
    //
    UINTX uniseq_rdstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_RDSTAT_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_RDSTAT_2__CPGC_BOXTYPE_REG        0x000001CC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reflects the current and final status of the pattern buffer in the read domain.[br]
    // If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in
    // serial fashion.   After all the bits in the Pattern_Buffer have been transmitted
    // the  pattern will simply repeat itself continuously while a Loopback Test is in
    // progress.[br][br]
    // If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output
    // in serial fashion.  Over time the LFSR pattern will repeat itself continuously
    // while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer
    // will interact with the LFSR in the following ways:[br][br]
    // If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will
    // interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]
    // 1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]
    // 2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details).
    //
    // Bits[31:0], RO/V, default = 0xDEADBEEF
    //
    UINTX uniseq_rdstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_RDSTAT_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_LMN_WRSTAT_0__CPGC_BOXTYPE_REG           0x000001D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the LMN buffer in write comparison domain.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX lmn_wrstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_LMN_WRSTAT_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_LMN_WRSTAT_1__CPGC_BOXTYPE_REG           0x000001D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the LMN buffer in write comparison domain.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX lmn_wrstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_LMN_WRSTAT_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_LMN_WRSTAT_2__CPGC_BOXTYPE_REG           0x000001D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the LMN buffer in write comparison domain.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX lmn_wrstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_LMN_WRSTAT_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_LMN_RDSTAT_0__CPGC_BOXTYPE_REG           0x000001DC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the LMN buffer in read comparison domain.
    //
    // Bits[31:0], RO/V, default = 0xDEADBEEF
    //
    UINTX lmn_rdstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_LMN_RDSTAT_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_LMN_RDSTAT_1__CPGC_BOXTYPE_REG           0x000001E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the LMN buffer in read comparison domain.
    //
    // Bits[31:0], RO/V, default = 0xDEADBEEF
    //
    UINTX lmn_rdstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_LMN_RDSTAT_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_LMN_RDSTAT_2__CPGC_BOXTYPE_REG           0x000001E4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the LMN buffer in read comparison domain.
    //
    // Bits[31:0], RO/V, default = 0xDEADBEEF
    //
    UINTX lmn_rdstat : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_LMN_RDSTAT_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_WRSAVE_0__CPGC_BOXTYPE_REG        0x000001E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the Save register before the test stops in the write domain.
    //
    // Bits[31:0], RO/V, default = 0xDEADBEEF
    //
    UINTX pattern_buffer : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_WRSAVE_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_WRSAVE_1__CPGC_BOXTYPE_REG        0x000001EC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the Save register before the test stops in the write domain.
    //
    // Bits[31:0], RO/V, default = 0xDEADBEEF
    //
    UINTX pattern_buffer : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_WRSAVE_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_WRSAVE_2__CPGC_BOXTYPE_REG        0x000001F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the Save register before the test stops in the write domain.
    //
    // Bits[31:0], RO/V, default = 0xDEADBEEF
    //
    UINTX pattern_buffer : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_WRSAVE_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_RDSAVE_0__CPGC_BOXTYPE_REG        0x000001F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer will reflect either the initial or
    // last saved value of CPGC_UNISEQ#_RDSTAT.[br][br]
    // If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in
    // serial fashion.  After all the bits in the Pattern_Buffer have been transmitted
    // the  pattern will simply repeat itself continuously while a Loopback Test is in
    // progress.[br][br]
    // If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output
    // in serial fashion.  Over time the LFSR pattern will repeat itself continuously
    // while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer
    // will interact with the LFSR in the following ways:[br][br]
    // If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will
    // interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]
    // 1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]
    // 2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details).
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX pattern_buffer : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_RDSAVE_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_RDSAVE_1__CPGC_BOXTYPE_REG        0x000001F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer will reflect either the initial or
    // last saved value of CPGC_UNISEQ#_RDSTAT.[br][br]
    // If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in
    // serial fashion.  After all the bits in the Pattern_Buffer have been transmitted
    // the  pattern will simply repeat itself continuously while a Loopback Test is in
    // progress.[br][br]
    // If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output
    // in serial fashion.  Over time the LFSR pattern will repeat itself continuously
    // while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer
    // will interact with the LFSR in the following ways:[br][br]
    // If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will
    // interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]
    // 1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]
    // 2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details).
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX pattern_buffer : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_RDSAVE_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_UNISEQ_RDSAVE_2__CPGC_BOXTYPE_REG        0x000001FC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer will reflect either the initial or
    // last saved value of CPGC_UNISEQ#_RDSTAT.[br][br]
    // If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in
    // serial fashion.  After all the bits in the Pattern_Buffer have been transmitted
    // the  pattern will simply repeat itself continuously while a Loopback Test is in
    // progress.[br][br]
    // If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output
    // in serial fashion.  Over time the LFSR pattern will repeat itself continuously
    // while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer
    // will interact with the LFSR in the following ways:[br][br]
    // If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will
    // interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]
    // 1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]
    // 2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer
    // based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details).
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX pattern_buffer : 32;
  } Bits;
  UINTX Data;
} CPGC_DPAT_UNISEQ_RDSAVE_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_0__CPGC_BOXTYPE_REG               0x00000200
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_1__CPGC_BOXTYPE_REG               0x00000204
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_2__CPGC_BOXTYPE_REG               0x00000208
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_3__CPGC_BOXTYPE_REG               0x0000020C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_4__CPGC_BOXTYPE_REG               0x00000210
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_5__CPGC_BOXTYPE_REG               0x00000214
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_6__CPGC_BOXTYPE_REG               0x00000218
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_7__CPGC_BOXTYPE_REG               0x0000021C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_8__CPGC_BOXTYPE_REG               0x00000220
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_8__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_9__CPGC_BOXTYPE_REG               0x00000224
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_9__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_10__CPGC_BOXTYPE_REG              0x00000228
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_10__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_11__CPGC_BOXTYPE_REG              0x0000022C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_11__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_12__CPGC_BOXTYPE_REG              0x00000230
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_12__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_13__CPGC_BOXTYPE_REG              0x00000234
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_13__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_14__CPGC_BOXTYPE_REG              0x00000238
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_14__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_DPAT_EXTBUF_15__CPGC_BOXTYPE_REG              0x0000023C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contents of Pattern Buffer  for Cache Line 0.
    //
    // Bits[7:0], RW, default = 0xAA
    //
    UINTX data_line0 : 8;
    //
    // Contents of Pattern Buffer  for Cache Line 1.
    //
    // Bits[15:8], RW, default = 0xAA
    //
    UINTX data_line1 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 2.[br]
    // Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed
    // to current status at CPGC_DPAT_BUF_CTL.[br]
    // This advancement is controlled by CPGC_DPAT_BUF_CTL.
    //
    // Bits[23:16], RW, default = 0xAA
    //
    UINTX data_line2 : 8;
    //
    // Contents of Pattern Buffer for Cache Line 3.[br]
    // EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]
    // EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]
    // .....[br]
    // EXTBUF[15] corresponds to Lane 15.[br]
    // These 16 lanes are replicated across the number of active DQ lanes on the memory
    // interface.
    //
    // Bits[31:24], RW, default = 0xAA
    //
    UINTX data_line3 : 8;
  } Bits;
  UINTX Data;
} CPGC_DPAT_EXTBUF_15__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CTL_CPGC_BOXTYPE_REG                      0x00000240
#ifndef ASM_INC
typedef union {
  struct {
    //
    // If STOP_ON_ERROR is set to Stop on Nth Error Mode, the test will stop after (STOP_ON_N
    // + 1) or more errors have been accumulated in the ERR_CNTR.
    //
    // Bits[5:0], RW/P, default = 0x0
    //
    UINTX stop_on_n : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Enable BE Training Error Detection Feature.  Note this bit overrides the BE_TRAIN_ERR_EN
    // bit in CPGC2_ALGORITHM_INSTRUCTION_CTRL.
    //
    // Bits[8:8], RW/P, default = 0x0
    //
    UINTX be_train_err_en : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[11:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 3;
    //
    // Defines test stop conditions based on error checking as follows:[br]
    // 00 - Never stop: Prevents any error from stopping the test.[br]
    // 01 - Stop On Nth Error: Stop once STOP_ERR_CNTR has accumulated at least (STOP_ON_N
    // + 1) errors.[br]
    // 10 - Stop On All Byte Groups Error:  Stop if every byte group indicates that at
    // least one of its lanes accumulated at least one error.[br]
    // That is, if all bits BYTEGRP_ERR_STAT, (and ECC_GRP_ERR_STAT if supported), are
    // all set.[br]
    // 11 - Stop On All Lanes Error:  Stop if every lane within every byte group has
    // accumulated at least one error.[br]
    // That is, if all bits in LANE_ERR_STAT_LO, LANE_ERR_STAT_HI, (and LANE_ERR_STATECC
    // if supported) are all set.
    //
    // Bits[13:12], RW/P, default = 0x0
    //
    UINTX stop_on_error_ctl : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:14], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
    //
    // Defines which chunk within the burst of data (i.e. bit within a burst of 8-bits
    // for each lane) to check for errors.[br]
    // Only chunks with a corresponding bit value of '0' will be checked for errors.[br]
    // This field is only used for full width (64bit) DQ busses. Otherwise the upper
    // 32 bits of the Lane Mask is used as the Chunk Enable.[br]
    // This field is also used for Loopback mode for all DQ sizes.
    //
    // Bits[23:16], RW/P, default = 0x0
    //
    UINTX errchk_mask_chunk : 8;
    //
    // Defines a periodic burst mask that repeats every 64Bytes of data as follows:[br]
    // Bit 0 - Burst 0[br]
    // Bit 1 - Burst 1[br]
    // ...[br]
    // Bit 7 - Burst 7[br]
    // Only bursts with a corresponding bit value of '1' will be checked for errors.
    // A burst is defined as a burst length of 64 bytes of data.[br]
    // In Loopback each bit of this register controls the check of each ByteTime (8-bits)
    // on the bus.
    //
    // Bits[31:24], RW/P, default = 0x0
    //
    UINTX errchk_mask_cacheline : 8;
  } Bits;
  UINTX Data;
} CPGC_ERR_CTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_LNEN_LO_CPGC_BOXTYPE_REG                  0x00000244
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A mask used to disable error checking on data lanes [31:0].  Lanes selected through
    // this mask will not be checked for errors. The lane-to-bit mapping for this mask
    // is given by the following formula: Lane[n] -> bit[n].[br]
    // Functionality will change with special mapping when buswidth is < 64 (or 72) such
    // that ChunkMask will move to this field starting at bit [...:32] extending the
    // necessary number of bits for a full cache line of data. The mask in ERR_CTL will
    // be unused for these busses/modes.
    //
    // Bits[31:0], RW/P, default = 0x0
    //
    UINTX data_errchk_mask_lo : 32;
  } Bits;
  UINTX Data;
} CPGC_ERR_LNEN_LO_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_LNEN_HI_CPGC_BOXTYPE_REG                  0x00000248
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A mask used to disable error checking on data lanes [63:32].  Lanes selected through
    // this mask will not be checked for errors. The lane-to-bit mapping for this mask
    // is given by the following formula: Lane[n+32] -> bit[n].[br]
    // Functionality will change with special mapping when buswidth is < 64 (or 72) such
    // that ChunkMask will move to this field starting at bit [...:32] extending the
    // necessary number of bits for a full cache line of data. The mask in ERR_CTL will
    // be unused for these busses/modes.
    //
    // Bits[31:0], RW/P, default = 0x0
    //
    UINTX data_errchk_mask_hi : 32;
  } Bits;
  UINTX Data;
} CPGC_ERR_LNEN_HI_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_XLNEN_CPGC_BOXTYPE_REG                    0x0000024C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A mask used to disable error checking on ECC lanes.  Lanes selected through the
    // mask will not be checked for errors. The lane-to-bit mapping is 1-to-1 and hence
    // bit 1 corresponds to ECC lane 0, bit 1 corresponds to ECC lane 1, and so on.[br]
    // Note: This field is available only if ECC is supported. The default state is to
    // disable ECC checking.
    //
    // Bits[7:0], RW/P, default = 0xFF
    //
    UINTX ecc_errchk_mask : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 24;
  } Bits;
  UINTX Data;
} CPGC_ERR_XLNEN_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_STAT03_CPGC_BOXTYPE_REG                   0x00000250
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Indicates if a mismatch was detected between the WR and the RD data on one of
    // the lanes belonging to byte groups 0 - 3.  Hence lanes [32:0] map to bits [32:0]
    // respectively.  The error status information is encoded as follows:[br]
    // 0: No mismatches detected on corresponding lane.[br]
    // 1: At least one mismatch detected on corresponding lane.[br]
    // Cleared on Local Clear Errors.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX lane_err_stat_lo : 32;
  } Bits;
  UINTX Data;
} CPGC_ERR_STAT03_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_STAT47_CPGC_BOXTYPE_REG                   0x00000254
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Indicates if a mismatch was detected between the WR and the RD data on one of
    // the lanes belonging to byte groups 4 - 7.  Hence lanes [63:32] map to bits [32:0]
    // respectively.[br]
    // If there are less than 32 data lanes, then this register is used to indicate the
    // Extended Chunk Error Status, and the Chunk Error Status in ECC_CHNK_RANK_STAT
    // is not used. Chunks 0 through 15 (32-bit bus) or 0 through 31 (16-bit bus).[br]
    // The error status information is encoded as follows:[br]
    // 0: No mismatches detected on corresponding lane (chunk).[br]
    // 1: At least one mismatch detected on corresponding lane (chunk).[br]
    // Cleared on Local Clear Errors.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX lane_err_stat_hi : 32;
  } Bits;
  UINTX Data;
} CPGC_ERR_STAT47_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_ECC_CHNK_RANK_STAT_CPGC_BOXTYPE_REG       0x00000258
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A fag field which indicates if a mismatch was detected between the WR and the
    // RD data on one of the lanes belonging to the ECC byte group.  The error status
    // information is encoded as follows:[br]
    // 0: No mismatches detected on corresponding lane.[br]
    // 1: At least one mismatch detected on corresponding lane.[br]
    // Note: this field is only available if ECC is supported for the current implementation,
    // otherwise it is reserved.[br]
    // If BE Training Enable is set then this field indicates that the particular BE
    // lane had a fault during the write pass.[br]
    // Cleared on Local Clear Errors.
    //
    // Bits[7:0], RO/V/P, default = 0x0
    //
    UINTX ecc_lane_err_stat : 8;
    //
    // A flag field where each bit corresponds to a specific chunk (i.e. bit within a
    // burst of 8-bits). If set, the corresponding chunk (UI) has accumulated at least
    // one error.[br]
    // Cleared on Local Clear Errors.
    //
    // Bits[15:8], RO/V/P, default = 0x0
    //
    UINTX chunk_err_stat : 8;
    //
    // A status field where each bit corresponds to a specific rank. If set, the corresponding
    // rank has accumulated at least one error.[br]
    // Cleared on Local Clear Errors.
    //
    // Bits[19:16], RO/V/P, default = 0x0
    //
    UINTX rank_err_stat : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 12;
  } Bits;
  UINTX Data;
} CPGC_ERR_ECC_CHNK_RANK_STAT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_BYTE_NTH_PAR_STAT_CPGC_BOXTYPE_REG        0x0000025C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // A flag field with each bit corresponding to a specific byte group.  Bit 0 corresponds
    // to byte group 0, bit 1 corresponds to byte group 1, bit 2 corresponds to byte
    // group 2, and so on.  A set bit implies that the corresponding byte group has at
    // least one lane that accumulated at least one error.[br]
    // When BE Training Enable is set, then this field will indicate that a data error
    // has occured that was not due to the corresponding BE signal.[br]
    // Can also be cleared on Local Clear Errors  (or Global_Control and a Global_Clear_Errors)
    // .
    //
    // Bits[7:0], RW/1C/V/P, default = 0x0
    //
    UINTX bytegrp_err_stat : 8;
    //
    // A set bit implies that the ECC bytegroup has at least one lane that accumulated
    // at least one error.[br]
    // Can also be cleared on Local Clear Errors (or Global_Control and a Global_Clear_Errors)
    // .
    //
    // Bits[8:8], RW/1C/V/P, default = 0x0
    //
    UINTX eccgrp_err_stat : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[19:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 11;
    //
    // RD_Chunk_Num_Status corresponds to the chunk number being read out of the WDB
    // (EXTBUF )for a RdCAS operation while logging an error during Loopback.Pattern.[br][br]
    // RD_Chunk_Num_Status is needed in conjunction with the lower 3 column address bits
    // of the cacheline experiencing the error in order to deterministically rewind the
    // LFSR/PB/LMN counter after the test is stopped due to an error condition. This
    // is due to the pipelined nature of the data path since a cacheline can be read
    // out of the WDB (EXTBUF) at the same time an error is being detected against an
    // earlier read.[br]
    // Using RD_Chunk_Num_Status and the lower 3 column address bits of the cacheline
    // experiencing the error allows the user to determine the skid between the LFSR/PB/LMN
    // counter and the error detection.[br]
    // RD_Chunk_Num_Status can be cleared by one of two ways.[br][br]
    // 1. Local_Clear_Errors or (Global_Control and Global_Clear_Errors) to 1.[br][br]
    // 2. Writing RD_Chunk_Num_Status=0x0. One may also choose to clear individual bits
    // in RD_Chunk_Num_Status.[br]
    // Setting bits in RD_Chunk_Num_Status is undefined and should be avoided.[br][br]
    // Writing a 0 to bits in RD_Chunk_Num_Status can be cleared independently of Data_Error_Status,
    // ECC_Error_Status, Rank_Error_Status, Chunk_Error_Status, and Byte_Group_Error_Status.
    //
    // Bits[22:20], RO/V/P, default = 0x0
    //
    UINTX rd_chunk_num_stat : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Nth_Error indicates the current Nth Error that has occurred.[br][br]
    // Nth_Error will roll over upon saturating to its maximum values.[br][br]
    // An Nth error is defined as 1 or more lane miscompares within a single comparison
    // cycle (i.e. Chunk).
    //
    // Bits[29:24], RO/V/P, default = 0x0
    //
    UINTX nth_error : 6;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 2;
  } Bits;
  UINTX Data;
} CPGC_ERR_BYTE_NTH_PAR_STAT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTRCTL_0__CPGC_BOXTYPE_REG               0x00000260
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used in conjunction with Counter_Control to indicate which Lane, which ByteLane
    // or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on.
    //
    // Bits[6:0], RW/P, default = 0x0
    //
    UINTX counter_pointer : 7;
    //
    // Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]
    // 00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors
    // across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience
    // an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented
    // by only 1.[br]
    // 01=Count Errors on a particular Lane - The Error Counter will count the exact
    // number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]
    // 10=Count Errors on a particular Byte Group - The Error Counter will count the
    // number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.
    // ECC is byte group 8. An error within one Chunk within the selected ByteGroup is
    // counted as 1 error.[br]
    // 11=Count Errors on a particular Chunk - The Error Counter will count the number
    // of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER,
    // across all lanes.
    //
    // Bits[8:7], RW/P, default = 0x0
    //
    UINTX counter_control : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTRCTL_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTRCTL_1__CPGC_BOXTYPE_REG               0x00000264
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used in conjunction with Counter_Control to indicate which Lane, which ByteLane
    // or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on.
    //
    // Bits[6:0], RW/P, default = 0x0
    //
    UINTX counter_pointer : 7;
    //
    // Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]
    // 00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors
    // across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience
    // an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented
    // by only 1.[br]
    // 01=Count Errors on a particular Lane - The Error Counter will count the exact
    // number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]
    // 10=Count Errors on a particular Byte Group - The Error Counter will count the
    // number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.
    // ECC is byte group 8. An error within one Chunk within the selected ByteGroup is
    // counted as 1 error.[br]
    // 11=Count Errors on a particular Chunk - The Error Counter will count the number
    // of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER,
    // across all lanes.
    //
    // Bits[8:7], RW/P, default = 0x0
    //
    UINTX counter_control : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTRCTL_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTRCTL_2__CPGC_BOXTYPE_REG               0x00000268
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used in conjunction with Counter_Control to indicate which Lane, which ByteLane
    // or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on.
    //
    // Bits[6:0], RW/P, default = 0x0
    //
    UINTX counter_pointer : 7;
    //
    // Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]
    // 00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors
    // across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience
    // an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented
    // by only 1.[br]
    // 01=Count Errors on a particular Lane - The Error Counter will count the exact
    // number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]
    // 10=Count Errors on a particular Byte Group - The Error Counter will count the
    // number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.
    // ECC is byte group 8. An error within one Chunk within the selected ByteGroup is
    // counted as 1 error.[br]
    // 11=Count Errors on a particular Chunk - The Error Counter will count the number
    // of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER,
    // across all lanes.
    //
    // Bits[8:7], RW/P, default = 0x0
    //
    UINTX counter_control : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTRCTL_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTRCTL_3__CPGC_BOXTYPE_REG               0x0000026C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used in conjunction with Counter_Control to indicate which Lane, which ByteLane
    // or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on.
    //
    // Bits[6:0], RW/P, default = 0x0
    //
    UINTX counter_pointer : 7;
    //
    // Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]
    // 00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors
    // across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience
    // an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented
    // by only 1.[br]
    // 01=Count Errors on a particular Lane - The Error Counter will count the exact
    // number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]
    // 10=Count Errors on a particular Byte Group - The Error Counter will count the
    // number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.
    // ECC is byte group 8. An error within one Chunk within the selected ByteGroup is
    // counted as 1 error.[br]
    // 11=Count Errors on a particular Chunk - The Error Counter will count the number
    // of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER,
    // across all lanes.
    //
    // Bits[8:7], RW/P, default = 0x0
    //
    UINTX counter_control : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTRCTL_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTRCTL_4__CPGC_BOXTYPE_REG               0x00000270
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used in conjunction with Counter_Control to indicate which Lane, which ByteLane
    // or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on.
    //
    // Bits[6:0], RW/P, default = 0x0
    //
    UINTX counter_pointer : 7;
    //
    // Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]
    // 00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors
    // across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience
    // an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented
    // by only 1.[br]
    // 01=Count Errors on a particular Lane - The Error Counter will count the exact
    // number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]
    // 10=Count Errors on a particular Byte Group - The Error Counter will count the
    // number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.
    // ECC is byte group 8. An error within one Chunk within the selected ByteGroup is
    // counted as 1 error.[br]
    // 11=Count Errors on a particular Chunk - The Error Counter will count the number
    // of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER,
    // across all lanes.
    //
    // Bits[8:7], RW/P, default = 0x0
    //
    UINTX counter_control : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTRCTL_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTRCTL_5__CPGC_BOXTYPE_REG               0x00000274
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used in conjunction with Counter_Control to indicate which Lane, which ByteLane
    // or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on.
    //
    // Bits[6:0], RW/P, default = 0x0
    //
    UINTX counter_pointer : 7;
    //
    // Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]
    // 00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors
    // across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience
    // an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented
    // by only 1.[br]
    // 01=Count Errors on a particular Lane - The Error Counter will count the exact
    // number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]
    // 10=Count Errors on a particular Byte Group - The Error Counter will count the
    // number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.
    // ECC is byte group 8. An error within one Chunk within the selected ByteGroup is
    // counted as 1 error.[br]
    // 11=Count Errors on a particular Chunk - The Error Counter will count the number
    // of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER,
    // across all lanes.
    //
    // Bits[8:7], RW/P, default = 0x0
    //
    UINTX counter_control : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTRCTL_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTRCTL_6__CPGC_BOXTYPE_REG               0x00000278
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used in conjunction with Counter_Control to indicate which Lane, which ByteLane
    // or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on.
    //
    // Bits[6:0], RW/P, default = 0x0
    //
    UINTX counter_pointer : 7;
    //
    // Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]
    // 00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors
    // across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience
    // an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented
    // by only 1.[br]
    // 01=Count Errors on a particular Lane - The Error Counter will count the exact
    // number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]
    // 10=Count Errors on a particular Byte Group - The Error Counter will count the
    // number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.
    // ECC is byte group 8. An error within one Chunk within the selected ByteGroup is
    // counted as 1 error.[br]
    // 11=Count Errors on a particular Chunk - The Error Counter will count the number
    // of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER,
    // across all lanes.
    //
    // Bits[8:7], RW/P, default = 0x0
    //
    UINTX counter_control : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTRCTL_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTRCTL_7__CPGC_BOXTYPE_REG               0x0000027C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used in conjunction with Counter_Control to indicate which Lane, which ByteLane
    // or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on.
    //
    // Bits[6:0], RW/P, default = 0x0
    //
    UINTX counter_pointer : 7;
    //
    // Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]
    // 00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors
    // across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience
    // an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented
    // by only 1.[br]
    // 01=Count Errors on a particular Lane - The Error Counter will count the exact
    // number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]
    // 10=Count Errors on a particular Byte Group - The Error Counter will count the
    // number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.
    // ECC is byte group 8. An error within one Chunk within the selected ByteGroup is
    // counted as 1 error.[br]
    // 11=Count Errors on a particular Chunk - The Error Counter will count the number
    // of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER,
    // across all lanes.
    //
    // Bits[8:7], RW/P, default = 0x0
    //
    UINTX counter_control : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTRCTL_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTRCTL_8__CPGC_BOXTYPE_REG               0x00000280
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used in conjunction with Counter_Control to indicate which Lane, which ByteLane
    // or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on.
    //
    // Bits[6:0], RW/P, default = 0x0
    //
    UINTX counter_pointer : 7;
    //
    // Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]
    // 00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors
    // across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience
    // an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented
    // by only 1.[br]
    // 01=Count Errors on a particular Lane - The Error Counter will count the exact
    // number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]
    // 10=Count Errors on a particular Byte Group - The Error Counter will count the
    // number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.
    // ECC is byte group 8. An error within one Chunk within the selected ByteGroup is
    // counted as 1 error.[br]
    // 11=Count Errors on a particular Chunk - The Error Counter will count the number
    // of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER,
    // across all lanes.
    //
    // Bits[8:7], RW/P, default = 0x0
    //
    UINTX counter_control : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTRCTL_8__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_0__CPGC_BOXTYPE_REG                  0x00000284
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_ERR_ERRCNTR indicates the current error counter value which is configured
    // by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and
    // will wrap around, but any overflow of this counter will set the corresponding
    // overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]
    // Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control
    // and a Global_Clear_Errors) .
    //
    // Bits[22:0], RO/V/P, default = 0x0
    //
    UINTX error_counter : 23;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_1__CPGC_BOXTYPE_REG                  0x00000288
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_ERR_ERRCNTR indicates the current error counter value which is configured
    // by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and
    // will wrap around, but any overflow of this counter will set the corresponding
    // overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]
    // Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control
    // and a Global_Clear_Errors) .
    //
    // Bits[22:0], RO/V/P, default = 0x0
    //
    UINTX error_counter : 23;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_2__CPGC_BOXTYPE_REG                  0x0000028C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_ERR_ERRCNTR indicates the current error counter value which is configured
    // by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and
    // will wrap around, but any overflow of this counter will set the corresponding
    // overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]
    // Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control
    // and a Global_Clear_Errors) .
    //
    // Bits[22:0], RO/V/P, default = 0x0
    //
    UINTX error_counter : 23;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_3__CPGC_BOXTYPE_REG                  0x00000290
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_ERR_ERRCNTR indicates the current error counter value which is configured
    // by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and
    // will wrap around, but any overflow of this counter will set the corresponding
    // overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]
    // Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control
    // and a Global_Clear_Errors) .
    //
    // Bits[22:0], RO/V/P, default = 0x0
    //
    UINTX error_counter : 23;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_4__CPGC_BOXTYPE_REG                  0x00000294
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_ERR_ERRCNTR indicates the current error counter value which is configured
    // by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and
    // will wrap around, but any overflow of this counter will set the corresponding
    // overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]
    // Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control
    // and a Global_Clear_Errors) .
    //
    // Bits[22:0], RO/V/P, default = 0x0
    //
    UINTX error_counter : 23;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_5__CPGC_BOXTYPE_REG                  0x00000298
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_ERR_ERRCNTR indicates the current error counter value which is configured
    // by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and
    // will wrap around, but any overflow of this counter will set the corresponding
    // overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]
    // Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control
    // and a Global_Clear_Errors) .
    //
    // Bits[22:0], RO/V/P, default = 0x0
    //
    UINTX error_counter : 23;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_6__CPGC_BOXTYPE_REG                  0x0000029C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_ERR_ERRCNTR indicates the current error counter value which is configured
    // by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and
    // will wrap around, but any overflow of this counter will set the corresponding
    // overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]
    // Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control
    // and a Global_Clear_Errors) .
    //
    // Bits[22:0], RO/V/P, default = 0x0
    //
    UINTX error_counter : 23;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_7__CPGC_BOXTYPE_REG                  0x000002A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_ERR_ERRCNTR indicates the current error counter value which is configured
    // by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and
    // will wrap around, but any overflow of this counter will set the corresponding
    // overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]
    // Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control
    // and a Global_Clear_Errors) .
    //
    // Bits[22:0], RO/V/P, default = 0x0
    //
    UINTX error_counter : 23;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_8__CPGC_BOXTYPE_REG                  0x000002A4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // CPGC_ERR_ERRCNTR indicates the current error counter value which is configured
    // by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and
    // will wrap around, but any overflow of this counter will set the corresponding
    // overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]
    // Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control
    // and a Global_Clear_Errors) .
    //
    // Bits[22:0], RO/V/P, default = 0x0
    //
    UINTX error_counter : 23;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_8__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_CNTR_OV_CPGC_BOXTYPE_REG                  0x000002A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Contains the overflow flags for all Error Counters.[br]
    // Bit 0 corresponds to ERROR_COUNTER_0.[br]
    // Bit 1 corresponds to ERROR_COUNTER_1.[br]
    // ..[br]
    // Bit 8 corresponds to ERROR_COUNTER_8.[br]
    // Error Counter Overflow Status can be cleared by one of two ways:[br]
    // 1. Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) to 1.[br]
    // 2. Writing the correspoing Error Counter Overflow Status bit to 1.[br]
    // Writing a 0 to bits in Counter_Overflow_Status can be cleared independently of
    // Data_Error_Status, Byte_Group_Error_Status, Chunk_Error_Status, and ECC_Error_Status.
    //
    // Bits[8:0], RW/1C/V/P, default = 0x0
    //
    UINTX error_counter_overflow : 9;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} CPGC_ERR_CNTR_OV_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERRLOG_CTL_STAT_CPGC_BOXTYPE_REG              0x000002AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Provides the current Read Pointer location indexed at the Read Data Buffer. This
    // will be used for knowing how many Reads the user needs to issue to return the
    // pointer to the actual failing entry.
    //
    // Bits[3:0], RO/V/P, default = 0x0
    //
    UINTX curr_rd_ptr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[4:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Provides the Read Pointer location that caused the error that triggered STOP_ON_ERROR.
    // This will be used for knowing exactly which entry in the Read Data Buffer contains
    // the faulty cacheline data.
    //
    // Bits[8:5], RO/V/P, default = 0x0
    //
    UINTX error_rd_ptr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[11:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 3;
    //
    // Signal that will allow auto-increment feature for each 32bit data chunk read from
    // the Error Log Data register.[br]
    // Note: If this bit is set, when doing the last 32bit data access via reading the
    // Error Log Data register, the Error Log Current Read Pointer will auto increment
    // as well.
    //
    // Bits[12:12], RW/P, default = 0x0
    //
    UINTX errlog_auto_chnk_inc : 1;
    //
    // Asserting this bit will have the effect of incrementing by one the Current Read
    // Pointer at the actual Read Data Buffer. User can manually browse through the Read
    // Data Buffer and dump its contents. This bit will always return '0' if read by
    // software.
    //
    // Bits[13:13], RW/1S, default = 0x0
    //
    UINTX errlog_move : 1;
    //
    // Asserting this bit will have the effect of CPGC automatically generating the needed
    // Read transactions such as the current Read Pointer targets the last failing cachline.
    // Instead of manually browsing, user can set this bit and logic will make sure that
    // CURR_RD_PTR==ERROR_RD_PTR. This bit will always return '0' if read by software.
    //
    // Bits[14:14], RW/1S, default = 0x0
    //
    UINTX errlog_auto : 1;
    //
    // Advance to next portion of data which is then available in the Error Log Data
    // Register.
    //
    // Bits[15:15], RW/1S, default = 0x0
    //
    UINTX inc_chunk_count : 1;
    //
    // Initializes the Error Log Current Read Pointer. Do this prior to the start of
    // a test.
    //
    // Bits[16:16], RW/1S, default = 0x0
    //
    UINTX clr_dun_rdbuf_ptr : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:17], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 15;
  } Bits;
  UINTX Data;
} CPGC_ERRLOG_CTL_STAT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERRLOG_DATA_CPGC_BOXTYPE_REG                  0x000002B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 32 bits of data corresponding to one of eight (or four for ANN) 32 bit PMI chunks
    // available per Read Pointer location. If ERRLOG_AUTO_CHNK_INC is set, then each
    // read to this register will read out a successive 32 bit PMI chunk of data.
    //
    // Bits[31:0], RO/V/P, default = 0x0
    //
    UINTX errlog_data : 32;
  } Bits;
  UINTX Data;
} CPGC_ERRLOG_DATA_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_ERR_TEST_ERR_STAT_CPGC_BOXTYPE_REG            0x000002B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bit set during the loopback test. Cleared when Local_Clear_Error in Loopback Sequencer
    // Control is set.
    //
    // Bits[0:0], RO/V/P, default = 0x0
    //
    UINTX error_status : 1;
    //
    // Used to indicate a loopback test is in progress.
    //
    // Bits[1:1], RO/V, default = 0x0
    //
    UINTX test_in_progress : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 30;
  } Bits;
  UINTX Data;
} CPGC_ERR_TEST_ERR_STAT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_RANK_L2P_MAPPING_CPGC_BOXTYPE_REG         0x000002B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines what physical Rank address (Memory Controller Rank Mapping) is mapped
    // to this logical Rank address (Sequence Address Logic Domain).
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX l2p_rank0_mapping : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:3], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Defines what physical Rank address (Memory Controller Rank Mapping) is mapped
    // to this logical Rank address (Sequence Address Logic Domain).
    //
    // Bits[6:4], RW, default = 0x1
    //
    UINTX l2p_rank1_mapping : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Defines what physical Rank address (Memory Controller Rank Mapping) is mapped
    // to this logical Rank address (Sequence Address Logic Domain).
    //
    // Bits[10:8], RW, default = 0x2
    //
    UINTX l2p_rank2_mapping : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[11:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 1;
    //
    // Defines what physical Rank address (Memory Controller Rank Mapping) is mapped
    // to this logical Rank address (Sequence Address Logic Domain).
    //
    // Bits[14:12], RW, default = 0x3
    //
    UINTX l2p_rank3_mapping : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:15], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 1;
    //
    // Defines what physical Rank address (Memory Controller Rank Mapping) is mapped
    // to this logical Rank address (Sequence Address Logic Domain).
    //
    // Bits[18:16], RW, default = 0x4
    //
    UINTX l2p_rank4_mapping : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[19:19], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_4 : 1;
    //
    // Defines what physical Rank address (Memory Controller Rank Mapping) is mapped
    // to this logical Rank address (Sequence Address Logic Domain).
    //
    // Bits[22:20], RW, default = 0x5
    //
    UINTX l2p_rank5_mapping : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:23], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_5 : 1;
    //
    // Defines what physical Rank address (Memory Controller Rank Mapping) is mapped
    // to this logical Rank address (Sequence Address Logic Domain).
    //
    // Bits[26:24], RW, default = 0x6
    //
    UINTX l2p_rank6_mapping : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[27:27], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_6 : 1;
    //
    // Defines what physical Rank address (Memory Controller Rank Mapping) is mapped
    // to this logical Rank address (Sequence Address Logic Domain).
    //
    // Bits[30:28], RW, default = 0x7
    //
    UINTX l2p_rank7_mapping : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:31], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_7 : 1;
  } Bits;
  UINTX Data;
} CPGC_SEQ_RANK_L2P_MAPPING_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_BANK_L2P_MAPPING_A_CPGC_BOXTYPE_REG       0x000002BC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX l2p_bank0_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[7:4], RW, default = 0x1
    //
    UINTX l2p_bank1_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[11:8], RW, default = 0x2
    //
    UINTX l2p_bank2_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[15:12], RW, default = 0x3
    //
    UINTX l2p_bank3_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[19:16], RW, default = 0x4
    //
    UINTX l2p_bank4_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[23:20], RW, default = 0x5
    //
    UINTX l2p_bank5_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[27:24], RW, default = 0x6
    //
    UINTX l2p_bank6_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[31:28], RW, default = 0x7
    //
    UINTX l2p_bank7_mapping : 4;
  } Bits;
  UINTX Data;
} CPGC_SEQ_BANK_L2P_MAPPING_A_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_BANK_L2P_MAPPING_B_CPGC_BOXTYPE_REG       0x000002C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[3:0], RW, default = 0x8
    //
    UINTX l2p_bank8_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[7:4], RW, default = 0x9
    //
    UINTX l2p_bank9_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[11:8], RW, default = 0xA
    //
    UINTX l2p_bank10_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[15:12], RW, default = 0xB
    //
    UINTX l2p_bank11_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[19:16], RW, default = 0xC
    //
    UINTX l2p_bank12_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[23:20], RW, default = 0xD
    //
    UINTX l2p_bank13_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[27:24], RW, default = 0xE
    //
    UINTX l2p_bank14_mapping : 4;
    //
    // Defines what physical Bank address (Memory Controller Bank Mapping) is mapped
    // to this logical Bank address (Sequence Address Logic Domain).
    //
    // Bits[31:28], RW, default = 0xF
    //
    UINTX l2p_bank15_mapping : 4;
  } Bits;
  UINTX Data;
} CPGC_SEQ_BANK_L2P_MAPPING_B_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_RANK_ADDR_SWIZZLE_CPGC_BOXTYPE_REG        0x000002C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[3:0], RW, default = 0xC
    //
    UINTX l2p_rank0_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[7:4], RW, default = 0xD
    //
    UINTX l2p_rank1_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[11:8], RW, default = 0xE
    //
    UINTX l2p_rank2_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.  Only Rank address
    // bits available to the memory controller are valid, others should be set to 0xF.
    //
    // Bits[15:12], RW, default = 0xF
    //
    UINTX l2p_rank3_swizzle : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_SEQ_RANK_ADDR_SWIZZLE_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_BANK_ADDR_SWIZZLE_CPGC_BOXTYPE_REG        0x000002C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Bank
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[4:0], RW, default = 0x18
    //
    UINTX l2p_bank0_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Bank
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[9:5], RW, default = 0x19
    //
    UINTX l2p_bank1_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Bank
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[14:10], RW, default = 0x1A
    //
    UINTX l2p_bank2_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Bank
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value. Only Bank
    // address bits available to the memory controller are valid, others should be set
    // to 0x1F.
    //
    // Bits[19:15], RW, default = 0x1B
    //
    UINTX l2p_bank3_swizzle : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 12;
  } Bits;
  UINTX Data;
} CPGC_SEQ_BANK_ADDR_SWIZZLE_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_ROW_ADDR_SWIZZLE_A_CPGC_BOXTYPE_REG       0x000002CC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX l2p_row0_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[9:5], RW, default = 0x1
    //
    UINTX l2p_row1_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[14:10], RW, default = 0x2
    //
    UINTX l2p_row2_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[19:15], RW, default = 0x3
    //
    UINTX l2p_row3_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[24:20], RW, default = 0x4
    //
    UINTX l2p_row4_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[29:25], RW, default = 0x5
    //
    UINTX l2p_row5_swizzle : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
  } Bits;
  UINTX Data;
} CPGC_SEQ_ROW_ADDR_SWIZZLE_A_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_ROW_ADDR_SWIZZLE_B_CPGC_BOXTYPE_REG       0x000002D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[4:0], RW, default = 0x6
    //
    UINTX l2p_row6_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[9:5], RW, default = 0x7
    //
    UINTX l2p_row7_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[14:10], RW, default = 0x8
    //
    UINTX l2p_row8_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[19:15], RW, default = 0x9
    //
    UINTX l2p_row9_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[24:20], RW, default = 0xA
    //
    UINTX l2p_row10_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[29:25], RW, default = 0xB
    //
    UINTX l2p_row11_swizzle : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
  } Bits;
  UINTX Data;
} CPGC_SEQ_ROW_ADDR_SWIZZLE_B_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_ROW_ADDR_SWIZZLE_C_CPGC_BOXTYPE_REG       0x000002D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[4:0], RW, default = 0xC
    //
    UINTX l2p_row12_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[9:5], RW, default = 0xD
    //
    UINTX l2p_row13_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[14:10], RW, default = 0xE
    //
    UINTX l2p_row14_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[19:15], RW, default = 0xF
    //
    UINTX l2p_row15_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value.
    //
    // Bits[24:20], RW, default = 0x10
    //
    UINTX l2p_row16_swizzle : 5;
    //
    // Defines how a particular Logical Row or Bank bit is remapped to a Physical Row
    // address. The bits are essentially swizzled with each other. Bank Bits start at
    // select value of 24. A value of 31 will select a constant '0' value. Only Row address
    // bits available to the memory controller are valid, others should be set to 0x1F.
    //
    // Bits[29:25], RW, default = 0x11
    //
    UINTX l2p_row17_swizzle : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
  } Bits;
  UINTX Data;
} CPGC_SEQ_ROW_ADDR_SWIZZLE_C_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_ROW_ADDR_SWIZZLE_X_CPGC_BOXTYPE_REG       0x000002D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Row XOR source selection for lower order Row addresses. Select 31 if only using
    // a direct mapping with no XOR. Bank Bits start at select value of 24. A value of
    // 31 will select a constant '0' value.
    //
    // Bits[4:0], RW, default = 0x1F
    //
    UINTX l2p_row0_xor_swizzle : 5;
    //
    // Row XOR source selection for lower order Row addresses. Select 31 if only using
    // a direct mapping with no XOR.
    //
    // Bits[9:5], RW, default = 0x1F
    //
    UINTX l2p_row1_xor_swizzle : 5;
    //
    // Row XOR source selection for lower order Row addresses. Select 31 if only using
    // a direct mapping with no XOR.
    //
    // Bits[14:10], RW, default = 0x1F
    //
    UINTX l2p_row2_xor_swizzle : 5;
    //
    // Row XOR source selection for lower order Row addresses. Select 31 if only using
    // a direct mapping with no XOR.
    //
    // Bits[19:15], RW, default = 0x1F
    //
    UINTX l2p_row3_xor_swizzle : 5;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[28:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 9;
    //
    // Enables the lookup table to invert the DQs based on select Row address bits.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX addr_dq_inv_en : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
  } Bits;
  UINTX Data;
} CPGC_SEQ_ROW_ADDR_SWIZZLE_X_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_COL_ADDR_SWIZZLE_A_CPGC_BOXTYPE_REG       0x000002DC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:0], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other. Column Address Bit
    // 0 always corresponds to the logical A[6] for 64B requests and A[5] for 32B requests.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX l2p_col0_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[11:8], RW, default = 0x1
    //
    UINTX l2p_col1_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[15:12], RW, default = 0x2
    //
    UINTX l2p_col2_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[19:16], RW, default = 0x3
    //
    UINTX l2p_col3_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[23:20], RW, default = 0x4
    //
    UINTX l2p_col4_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[27:24], RW, default = 0x5
    //
    UINTX l2p_col5_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other. Rank Bits start at
    // select value of 12. A value of 11 will select a constant '0' value.
    //
    // Bits[31:28], RW, default = 0x6
    //
    UINTX l2p_col6_swizzle : 4;
  } Bits;
  UINTX Data;
} CPGC_SEQ_COL_ADDR_SWIZZLE_A_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_COL_ADDR_SWIZZLE_B_CPGC_BOXTYPE_REG       0x000002E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other.
    //
    // Bits[3:0], RW, default = 0x7
    //
    UINTX l2p_col7_swizzle : 4;
    //
    // Defines how a particular Logical COL or RANK bit is remapped to a Physical COL
    // address. The bits are essentially swizzled with each other. Rank Bits start at
    // select value of 12. A value of 11 will select a constant '0' value. Only Row address
    // bits available to the memory controller are valid, others should be set to 11.
    //
    // Bits[7:4], RW, default = 0x8
    //
    UINTX l2p_col8_swizzle : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 24;
  } Bits;
  UINTX Data;
} CPGC_SEQ_COL_ADDR_SWIZZLE_B_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_ROW_ADDR_DQ_MAP0_CPGC_BOXTYPE_REG         0x000002E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data written to this register will be placed in the DQ Map register as a stack.
    // Data is read from the bottom of the stack (higher locations). The last write covers
    // Row addresses of Row[11:4] = (0..31).[br]
    // Reading requires you to write into the stack to get the next location. Since this
    // is destructive, if the data is to be preserved, then the data read should be used
    // for the write. See documentation for details.[br]
    //
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} CPGC_SEQ_ROW_ADDR_DQ_MAP0_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_SEQ_ROW_ADDR_DQ_MAP1_CPGC_BOXTYPE_REG         0x000002EC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Data written to this register will be placed in the DQ Map register as a stack.
    // Data is read from the bottom of the stack (higher locations). The last write covers
    // Row addresses of Row[11:4] = (32..63).[br]
    // Reading requires you to write into the stack to get the next location. Since this
    // is destructive, if the data is to be preserved, then the data read should be used
    // for the write. See documentation for details.
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} CPGC_SEQ_ROW_ADDR_DQ_MAP1_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_CTL_CPGC_BOXTYPE_REG                     0x000002F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The operation mode of the command/address pattern generator is encoded as follows:[br][br]
    // 00 - Select and trigger-driven-Deselect : CADB will drive patterns during Select
    // and Deselect cycles depending on the values programmed in Lane_Deselect_Enable
    // and PRE_Select_Enable/ACT_Select_Enable/CAS_Select_Enable. Trigger-driven-Deselect
    // allows start/stop of Deselect cycles to synchronize with various CMD events and/or
    // Subsequence control bits.[br][br]
    // 01 - Global Deselect : CADB generated pattern will be driven on the bus during
    // deselect cycles only when SoC CPGC is in ACTIVE or NORMAL mode. SoC CPGC will
    // drive out the pattern on all command and address signals (except CKE, and ODT).
    // User can choose which ADDRESS/CMD lanes will be enabled for this mode. CS gets
    // special treatment as mentioned in LANE_DESELECT_ENABLE description.[br][br]
    // 10 - Always On: [br][br]
    // If INITIALIZATION_MODE is ACTIVE MODE, pattern stored in the command/address buffers
    // will be driven on all command and address signals on every DCLK cycle. This is
    // not a functional mode and should only be used for BDV purposes.[br][br]
    // If INITIALIZATION_MODE is MRS MODE, pattern stored in the command/address buffers
    // will be driven on all command and address signals under the control of the CADB
    // MRS state machine. This is the way to send MRS commands to DRAM devices using
    // CPGC.[br][br]
    // 11 - RESERVED:
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX cadb_mode : 2;
    //
    // Setting Bit 2 - Start Driving Deselects on the following cycle after a WR CMD
    // if CADB_Deselect_Enable is high.[br][br]
    // Setting Bit 3 - Start Driving Deselects on the following cycle after a RD CMD
    // if CADB_Deselect_Enable is high.[br][br]
    // Setting Bit 4 - Start Driving Deselects on the following cycle after a ACT CMD
    // if CADB_Deselect_Enable is high.[br][br]
    // Setting Bit 5 - Start Driving Deselects on the following cycle after a PRE CMD
    // if CADB_Deselect_Enable is high.[br]
    //
    // Bits[5:2], RW, default = 0x0
    //
    UINTX cmd_deselect_start : 4;
    //
    // Setting Bit 6 - Stop driving CADB Deselect pattern on the following cycle after
    // a WR CMD.[br][br]
    // Setting Bit 7 - Stop driving CADB Deselect pattern on the following cycle after
    // a RD CMD.[br][br]
    // Setting Bit 8 - Stop driving CADB Deselect pattern on the following cycle after
    // an ACT CMD.[br][br]
    // Setting Bit 9 - Stop driving CADB Deselect pattern on the following cycle after
    // a PRE CMD.[br][br]
    // Note: If Deselect was off before the command that is supposed to stop it, it will
    // remain in the off state.
    //
    // Bits[9:6], RW, default = 0x0
    //
    UINTX cmd_deselect_stop : 4;
    //
    // Setting Bit 10 - Drive CADB pattern on MA pins during Deselect cycles.[br][br]
    // Setting Bit 11 - Drive CADB pattern on BA pins during Deselect cycles.[br][br]
    // Setting Bit 12 - Drive CADB pattern on CMD pins during Deselect cycles.[br][br]
    // Setting Bit 13 - Drive CADB pattern on CS pins during Deselect cycles.[br][br]
    // Note: If CS is set than and CADB entry that also has CS set to one, the logic
    // overrides CMD signals w/NOP encoding, thus making CMD and CS mutually exclusive
    // to ensure no DDR functional violations occur.
    //
    // Bits[13:10], RW, default = 0x0
    //
    UINTX lane_deselect_en : 4;
    //
    // CAS_Select_Enable - Drive CADB generated patterns during all CAS CMD Select cycles
    // on pins that are enabled based on the description below.[br][br]
    // Setting Bit 14 - Drive CADB patterns on MA[11] and MA[9:0] pins during a CAS cmd.[br][br]
    // Setting Bit 15 - Drive CADB patterns on BA pins during a CAS cmd.[br][br]
    //
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX cas_select_enable : 2;
    //
    // ACT_Select_Enable - Drive CADB generated patterns during all ACT CMD Select cycles
    // on pins that are enabled based on the description below.[br][br]
    // Setting Bit 16 - Drive CADB patterns on MA pins during an ACT cmd.[br][br]
    // Setting Bit 17 - Drive CADB patterns on BA pins during an ACT cmd.[br]
    //
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX act_select_enable : 2;
    //
    // PRE_Select_Enable - Drive CADB generated patterns during all Precharge Select
    // cycles on pins that are enabled based on the description below.[br][br]
    // Setting Bit 18 - Drive CADB patterns on MA pins except AP bit during a PRE command.[br][br]
    // Setting Bit 19 - Drive CADB patterns on BA pins during a PRE command.[br]
    //
    //
    // Bits[19:18], RW, default = 0x0
    //
    UINTX pre_select_enable : 2;
    //
    // Save_Current_Seed when qualified with Subsequence_Deselect_Save_Enable from REUT
    // engine indicates which command triggers saving the current LFSR/PB values for
    // Select and Deselect logic to the starting seed copy.[br][br]
    // Setting Bit 20 - Save the current seed to starting seed on WR.[br][br]
    // Setting Bit 21 - Save the current seed to starting seed on RD.[br][br]
    // Setting Bit 22 - Save the current seed to starting seed on ACT.[br][br]
    // Setting Bit 23 - Save the current seed to starting seed on PR.
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX save_current_seed : 4;
    //
    // Reload_Starting_Seed will reload the 16bit CADB unisequencer starting seeds for
    // LFSR/PB engines used for Select and Deselect chunk choosing to current seeds synchronous
    // with particular commands (PRE/ACT/RD/WR) that are indicated to cause the reload
    // to happen.  The reload seed must be used as the CADB output in the same cycle
    // as the command which causes the reload to happen.[br][br]
    // Setting Bit 24 - Reload the starting seed to current seed on WR.[br][br]
    // Setting Bit 25 - Reload the starting seed to current seed on RD.[br][br]
    // Setting Bit 26 - Reload the starting seed to current seed on ACT.[br][br]
    // Setting Bit 27 - Reload the starting seed to current seed on PR.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX reload_starting_seed : 4;
    //
    // Setting bit 28 - Command and address are driven in a double-phase pattern (data
    // changes on both halves of the DDR clock).  Clearing bit 28 - Command and address
    // are driven in a single-phase pattern (data changes every full clock cycle).
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX cadb_dbl_pump : 1;
    //
    // If set, the CADB pattern will reload each time the chosen CMD_DESELECT_START condition
    // is met. Please refer to CMD_DESLECT_START field for more info.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX cmd_deselect_restart : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // (Not Implemented in BXT) TBD.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX cmd_deselect_stall : 1;
  } Bits;
  UINTX Data;
} CPGC_CADB_CTL_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_MRSCFG_CPGC_BOXTYPE_REG                  0x000002F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // 2^(MRS_GAP) clock cycles between changing to the next MRS CADB entry. Value Zero
    // is prohibited.[br] Note: This GAP is applicable to both, MRS mode or normal CADB
    // pattern gen. When used for non MRS CADB pattern generation, a value of Zero is
    // allowed.
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX mrs_gap : 4;
    //
    // Linear or Exponential Scale for CADB_GAP value.[br]
    // [b]Note: This is not implemented in Reference RTL yet. [/b]]
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX mrs_gap_scale : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // Pointer to the first CADB entry. To be used if in MRS mode.[br] Note: This indexing
    // mode of the CADB buffer is only available if in CPGC_SEQ_CFG_0.INITIALIZATION_MODE=MRS_MODE.
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX mrs_start_ptr : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 5;
    //
    // Pointer to the last CADB entry. To be used if in MRS mode.[br] Note: This indexing
    // mode of the CADB buffer is only available if in CPGC_SEQ_CFG_0.INITIALIZATION_MODE=MRS_MODE.
    // For MRS Double pump mode or 1/2N mode, the end pointer should be programmed to
    // 3 or 7. Otherwise, the valid willl show up only for the first 40 bits which would
    // be from BUF0- [9:0] bits, BUF1 [9:0] bits, BUF2 [9:0] bits and BUF3 [9:0] bits.
    //
    // Bits[18:16], RW, default = 0x7
    //
    UINTX mrs_end_ptr : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:19], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 5;
    //
    // Current MRS instruction pointer - Valid for LP3 only.
    //
    // Bits[26:24], RO/V, default = 0x7
    //
    UINTX mrs_curr_ptr : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[27:27], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 1;
    //
    // Only if it is set to 0, it will be deaserted at (1 or 2 cycles) number of cycles
    // at the middle of Gap CS, is selected per entry and per rank.[br][br]
    // 00 - No Override.[br][br]
    // 01 - No Override.[br][br]
    // 10 - One Cycle CS.[br][br]
    // 11 - Two Cycles CS.
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX mrs_cs_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:30], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_4 : 2;
  } Bits;
  UINTX Data;
} CPGC_CADB_MRSCFG_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_CFG_CPGC_BOXTYPE_REG                     0x000002F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Defines the operational mode for unified sequence 0 as follows:[br][br]
    // 00 - LMN Mode.[br][br]
    // 01 - Pattern Buffer Mode.[br][br]
    // 10 - LFSR Mode.[br][br]
    // 11 - Reserved for future use.
    //
    // Bits[1:0], RW, default = 0x1
    //
    UINTX uniseq0_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Defines the operational mode for unified sequence 1 as follows:[br][br]
    // 00 - LMN Mode.[br][br]
    // 01 - Pattern Buffer Mode.[br][br]
    // 10 - LFSR Mode.[br][br]
    // 11 - Reserved for future use.
    //
    // Bits[5:4], RW, default = 0x1
    //
    UINTX uniseq1_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 2;
    //
    // Defines the operational mode for unified sequence 2 as follows:[br][br]
    // 00 - LMN Mode.[br][br]
    // 01 - Pattern Buffer Mode.[br][br]
    // 10 - LFSR Mode.[br][br]
    // 11 - Reserved for future use.
    //
    // Bits[9:8], RW, default = 0x1
    //
    UINTX uniseq2_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:10], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 6;
    //
    // Defines the operational mode for select unified sequence 0 as follows:[br][br]
    // 00 - Reserved for future use.[br][br]
    // 01 - Pattern Buffer Mode.[br][br]
    // 10 - LFSR Mode.[br][br]
    // 11 - Reserved for future use.
    //
    // Bits[17:16], RW, default = 0x1
    //
    UINTX sel_uniseq0_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[19:18], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Defines the operational mode for select unified sequence 1 as follows:[br][br]
    // 00 - Reserved for future use.[br][br]
    // 01 - Pattern Buffer Mode.[br][br]
    // 10 - LFSR Mode.[br][br]
    // 11 - Reserved for future use.
    //
    // Bits[21:20], RW, default = 0x1
    //
    UINTX sel_uniseq1_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_4 : 2;
    //
    // Defines the operational mode for select unified sequence 2 as follows:[br][br]
    // 00 - Reserved for future use.[br][br]
    // 01 - Pattern Buffer Mode.[br][br]
    // 10 - LFSR Mode.[br][br]
    // 11 - Reserved for future use.
    //
    // Bits[25:24], RW, default = 0x1
    //
    UINTX sel_uniseq2_mode : 2;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:26], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_5 : 6;
  } Bits;
  UINTX Data;
} CPGC_CADB_CFG_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_UNISEQ0_PBUF_CPGC_BOXTYPE_REG            0x000002FC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial content of the rotating pattern buffer for the unified sequencer.
    //
    // Bits[15:0], RW, default = 0xAA55
    //
    UINTX cmd : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_CADB_UNISEQ0_PBUF_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_UNISEQ1_PBUF_CPGC_BOXTYPE_REG            0x00000300
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial content of the rotating pattern buffer for the unified sequencer.
    //
    // Bits[15:0], RW, default = 0xAA55
    //
    UINTX cmd : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_CADB_UNISEQ1_PBUF_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_UNISEQ2_PBUF_CPGC_BOXTYPE_REG            0x00000304
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial content of the rotating pattern buffer for the unified sequencer.
    //
    // Bits[15:0], RW, default = 0xAA55
    //
    UINTX cmd : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_CADB_UNISEQ2_PBUF_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_UNISEQ0_LMN_CPGC_BOXTYPE_REG             0x00000308
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial logic output of the sequencer is defined as follows:[br][br]
    //                         0 - Output Logic '0' for L_CNT UIs.[br][br]
    //                         1 - Output Logic '1' for L_CNT UIs.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX l_sel : 1;
    //
    // 0 - Disable Sweep Frequency. 1 - Enable Sweep Frequency. [br][br]
    // [b]Note: This is not implemented in Reference RTL yet. [/b]]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX en_sweep_freq : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Values for L_CNT, M_CNT, and N_CNT are scaled by a factor of 2^CNT_SCALE.
    //
    // Bits[6:4], RW, default = 0x5
    //
    UINTX cnt_scale : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Number of UIs that the unisequencer will drive the logic value selected through
    // L_SEL before entering the steady state periodic phase.
    //
    // Bits[10:8], RW, default = 0x4
    //
    UINTX l_cnt : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 5;
    //
    // Number of UIs that the unisequencer will drive logic '0'.
    //
    // Bits[18:16], RW, default = 0x2
    //
    UINTX n_cnt : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:19], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 5;
    //
    // Number of UIs that the unisequencer will drive logic '1'.
    //
    // Bits[26:24], RW, default = 0x5
    //
    UINTX m_cnt : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:27], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_4 : 5;
  } Bits;
  UINTX Data;
} CPGC_CADB_UNISEQ0_LMN_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_UNISEQ1_LMN_CPGC_BOXTYPE_REG             0x0000030C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial logic output of the sequencer is defined as follows:[br][br]
    //                         0 - Output Logic '0' for L_CNT UIs.[br][br]
    //                         1 - Output Logic '1' for L_CNT UIs.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX l_sel : 1;
    //
    // 0 - Disable Sweep Frequency. 1 - Enable Sweep Frequency. [br][br]
    // [b]Note: This is not implemented in Reference RTL yet. [/b]]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX en_sweep_freq : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Values for L_CNT, M_CNT, and N_CNT are scaled by a factor of 2^CNT_SCALE.
    //
    // Bits[6:4], RW, default = 0x5
    //
    UINTX cnt_scale : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Number of UIs that the unisequencer will drive the logic value selected through
    // L_SEL before entering the steady state periodic phase.
    //
    // Bits[10:8], RW, default = 0x4
    //
    UINTX l_cnt : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 5;
    //
    // Number of UIs that the unisequencer will drive logic '0'.
    //
    // Bits[18:16], RW, default = 0x2
    //
    UINTX n_cnt : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:19], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 5;
    //
    // Number of UIs that the unisequencer will drive logic '1'.
    //
    // Bits[26:24], RW, default = 0x5
    //
    UINTX m_cnt : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:27], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_4 : 5;
  } Bits;
  UINTX Data;
} CPGC_CADB_UNISEQ1_LMN_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_UNISEQ2_LMN_CPGC_BOXTYPE_REG             0x00000310
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial logic output of the sequencer is defined as follows:[br][br]
    //                         0 - Output Logic '0' for L_CNT UIs.[br][br]
    //                         1 - Output Logic '1' for L_CNT UIs.
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX l_sel : 1;
    //
    // 0 - Disable Sweep Frequency. 1 - Enable Sweep Frequency. [br][br]
    // [b]Note: This is not implemented in Reference RTL yet. [/b]]
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX en_sweep_freq : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[3:2], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // Values for L_CNT, M_CNT, and N_CNT are scaled by a factor of 2^CNT_SCALE.
    //
    // Bits[6:4], RW, default = 0x5
    //
    UINTX cnt_scale : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:7], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Number of UIs that the unisequencer will drive the logic value selected through
    // L_SEL before entering the steady state periodic phase.
    //
    // Bits[10:8], RW, default = 0x4
    //
    UINTX l_cnt : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:11], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 5;
    //
    // Number of UIs that the unisequencer will drive logic '0'.
    //
    // Bits[18:16], RW, default = 0x2
    //
    UINTX n_cnt : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:19], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 5;
    //
    // Number of UIs that the unisequencer will drive logic '1'.
    //
    // Bits[26:24], RW, default = 0x5
    //
    UINTX m_cnt : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:27], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_4 : 5;
  } Bits;
  UINTX Data;
} CPGC_CADB_UNISEQ2_LMN_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_SEL_UNISEQ0_PBUF_CPGC_BOXTYPE_REG        0x00000314
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial content of the rotating pattern buffer for the select unified sequencer.
    //
    // Bits[15:0], RW, default = 0xAA55
    //
    UINTX cmd : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_CADB_SEL_UNISEQ0_PBUF_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_SEL_UNISEQ1_PBUF_CPGC_BOXTYPE_REG        0x00000318
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial content of the rotating pattern buffer for the select unified sequencer.
    //
    // Bits[15:0], RW, default = 0xAA55
    //
    UINTX cmd : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_CADB_SEL_UNISEQ1_PBUF_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_SEL_UNISEQ2_PBUF_CPGC_BOXTYPE_REG        0x0000031C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The initial content of the rotating pattern buffer for the select unified sequencer.
    //
    // Bits[15:0], RW, default = 0xAA55
    //
    UINTX cmd : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_CADB_SEL_UNISEQ2_PBUF_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFA_0__CPGC_BOXTYPE_REG                 0x00000320
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM row/column address.[br][br]
    // LPDDR2/3 Maps the following:[br][br]
    // CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]
    // CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]
    // Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information
    // on the mapping.
    //
    // Bits[19:0], RW, default = 0x0
    //
    UINTX row_col_addr : 20;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // The DRAM bank address.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX bank_addr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFA_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFA_1__CPGC_BOXTYPE_REG                 0x00000324
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM row/column address.[br][br]
    // LPDDR2/3 Maps the following:[br][br]
    // CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]
    // CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]
    // Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information
    // on the mapping.
    //
    // Bits[19:0], RW, default = 0x0
    //
    UINTX row_col_addr : 20;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // The DRAM bank address.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX bank_addr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFA_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFA_2__CPGC_BOXTYPE_REG                 0x00000328
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM row/column address.[br][br]
    // LPDDR2/3 Maps the following:[br][br]
    // CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]
    // CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]
    // Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information
    // on the mapping.
    //
    // Bits[19:0], RW, default = 0x0
    //
    UINTX row_col_addr : 20;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // The DRAM bank address.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX bank_addr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFA_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFA_3__CPGC_BOXTYPE_REG                 0x0000032C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM row/column address.[br][br]
    // LPDDR2/3 Maps the following:[br][br]
    // CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]
    // CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]
    // Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information
    // on the mapping.
    //
    // Bits[19:0], RW, default = 0x0
    //
    UINTX row_col_addr : 20;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // The DRAM bank address.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX bank_addr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFA_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFA_4__CPGC_BOXTYPE_REG                 0x00000330
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM row/column address.[br][br]
    // LPDDR2/3 Maps the following:[br][br]
    // CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]
    // CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]
    // Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information
    // on the mapping.
    //
    // Bits[19:0], RW, default = 0x0
    //
    UINTX row_col_addr : 20;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // The DRAM bank address.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX bank_addr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFA_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFA_5__CPGC_BOXTYPE_REG                 0x00000334
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM row/column address.[br][br]
    // LPDDR2/3 Maps the following:[br][br]
    // CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]
    // CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]
    // Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information
    // on the mapping.
    //
    // Bits[19:0], RW, default = 0x0
    //
    UINTX row_col_addr : 20;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // The DRAM bank address.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX bank_addr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFA_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFA_6__CPGC_BOXTYPE_REG                 0x00000338
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM row/column address.[br][br]
    // LPDDR2/3 Maps the following:[br][br]
    // CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]
    // CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]
    // Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information
    // on the mapping.
    //
    // Bits[19:0], RW, default = 0x0
    //
    UINTX row_col_addr : 20;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // The DRAM bank address.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX bank_addr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFA_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFA_7__CPGC_BOXTYPE_REG                 0x0000033C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM row/column address.[br][br]
    // LPDDR2/3 Maps the following:[br][br]
    // CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]
    // CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]
    // Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information
    // on the mapping.
    //
    // Bits[19:0], RW, default = 0x0
    //
    UINTX row_col_addr : 20;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 4;
    //
    // The DRAM bank address.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX bank_addr : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFA_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFB_0__CPGC_BOXTYPE_REG                 0x00000340
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM Chip Select signals [CS#]. These signals are active low and hence default
    // is '1' on reset.
    //
    // Bits[1:0], RW, default = 0x3
    //
    UINTX cs : 2;
    //
    // The DRAM Chip ID.
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX cid : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low
    // and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX cmd : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX odt : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 4;
    //
    // The DRAM Clock Enable signals.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX cke : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Used to write the valid CADB data.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX val : 1;
    //
    // Used to write the parity invert CADB data. [br][br]
    // When working with DDR4 if this bit is set and the CADB entry is selected, the
    // parity value is inverted to reflect a C/A parity error.[br][br]
    // See CADB Read_Write_Pointer for programming details.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX par : 1;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFB_0__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFB_1__CPGC_BOXTYPE_REG                 0x00000344
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM Chip Select signals [CS#]. These signals are active low and hence default
    // is '1' on reset.
    //
    // Bits[1:0], RW, default = 0x3
    //
    UINTX cs : 2;
    //
    // The DRAM Chip ID.
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX cid : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low
    // and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX cmd : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX odt : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 4;
    //
    // The DRAM Clock Enable signals.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX cke : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Used to write the valid CADB data.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX val : 1;
    //
    // Used to write the parity invert CADB data. [br][br]
    // When working with DDR4 if this bit is set and the CADB entry is selected, the
    // parity value is inverted to reflect a C/A parity error.[br][br]
    // See CADB Read_Write_Pointer for programming details.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX par : 1;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFB_1__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFB_2__CPGC_BOXTYPE_REG                 0x00000348
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM Chip Select signals [CS#]. These signals are active low and hence default
    // is '1' on reset.
    //
    // Bits[1:0], RW, default = 0x3
    //
    UINTX cs : 2;
    //
    // The DRAM Chip ID.
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX cid : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low
    // and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX cmd : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX odt : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 4;
    //
    // The DRAM Clock Enable signals.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX cke : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Used to write the valid CADB data.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX val : 1;
    //
    // Used to write the parity invert CADB data. [br][br]
    // When working with DDR4 if this bit is set and the CADB entry is selected, the
    // parity value is inverted to reflect a C/A parity error.[br][br]
    // See CADB Read_Write_Pointer for programming details.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX par : 1;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFB_2__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFB_3__CPGC_BOXTYPE_REG                 0x0000034C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM Chip Select signals [CS#]. These signals are active low and hence default
    // is '1' on reset.
    //
    // Bits[1:0], RW, default = 0x3
    //
    UINTX cs : 2;
    //
    // The DRAM Chip ID.
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX cid : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low
    // and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX cmd : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX odt : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 4;
    //
    // The DRAM Clock Enable signals.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX cke : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Used to write the valid CADB data.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX val : 1;
    //
    // Used to write the parity invert CADB data. [br][br]
    // When working with DDR4 if this bit is set and the CADB entry is selected, the
    // parity value is inverted to reflect a C/A parity error.[br][br]
    // See CADB Read_Write_Pointer for programming details.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX par : 1;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFB_3__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFB_4__CPGC_BOXTYPE_REG                 0x00000350
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM Chip Select signals [CS#]. These signals are active low and hence default
    // is '1' on reset.
    //
    // Bits[1:0], RW, default = 0x3
    //
    UINTX cs : 2;
    //
    // The DRAM Chip ID.
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX cid : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low
    // and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX cmd : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX odt : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 4;
    //
    // The DRAM Clock Enable signals.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX cke : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Used to write the valid CADB data.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX val : 1;
    //
    // Used to write the parity invert CADB data. [br][br]
    // When working with DDR4 if this bit is set and the CADB entry is selected, the
    // parity value is inverted to reflect a C/A parity error.[br][br]
    // See CADB Read_Write_Pointer for programming details.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX par : 1;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFB_4__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFB_5__CPGC_BOXTYPE_REG                 0x00000354
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM Chip Select signals [CS#]. These signals are active low and hence default
    // is '1' on reset.
    //
    // Bits[1:0], RW, default = 0x3
    //
    UINTX cs : 2;
    //
    // The DRAM Chip ID.
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX cid : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low
    // and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX cmd : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX odt : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 4;
    //
    // The DRAM Clock Enable signals.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX cke : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Used to write the valid CADB data.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX val : 1;
    //
    // Used to write the parity invert CADB data. [br][br]
    // When working with DDR4 if this bit is set and the CADB entry is selected, the
    // parity value is inverted to reflect a C/A parity error.[br][br]
    // See CADB Read_Write_Pointer for programming details.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX par : 1;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFB_5__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFB_6__CPGC_BOXTYPE_REG                 0x00000358
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM Chip Select signals [CS#]. These signals are active low and hence default
    // is '1' on reset.
    //
    // Bits[1:0], RW, default = 0x3
    //
    UINTX cs : 2;
    //
    // The DRAM Chip ID.
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX cid : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low
    // and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX cmd : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX odt : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 4;
    //
    // The DRAM Clock Enable signals.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX cke : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Used to write the valid CADB data.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX val : 1;
    //
    // Used to write the parity invert CADB data. [br][br]
    // When working with DDR4 if this bit is set and the CADB entry is selected, the
    // parity value is inverted to reflect a C/A parity error.[br][br]
    // See CADB Read_Write_Pointer for programming details.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX par : 1;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFB_6__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_BUFB_7__CPGC_BOXTYPE_REG                 0x0000035C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The DRAM Chip Select signals [CS#]. These signals are active low and hence default
    // is '1' on reset.
    //
    // Bits[1:0], RW, default = 0x3
    //
    UINTX cs : 2;
    //
    // The DRAM Chip ID.
    //
    // Bits[4:2], RW, default = 0x0
    //
    UINTX cid : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:5], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 3;
    //
    // The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low
    // and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[11:8], RW, default = 0x7
    //
    UINTX cmd : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:12], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 4;
    //
    // The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX odt : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:20], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 4;
    //
    // The DRAM Clock Enable signals.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX cke : 4;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[29:28], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_3 : 2;
    //
    // Used to write the valid CADB data.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX val : 1;
    //
    // Used to write the parity invert CADB data. [br][br]
    // When working with DDR4 if this bit is set and the CADB entry is selected, the
    // parity value is inverted to reflect a C/A parity error.[br][br]
    // See CADB Read_Write_Pointer for programming details.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX par : 1;
  } Bits;
  UINTX Data;
} CPGC_CADB_BUFB_7__CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_UNISEQ0STAT_CPGC_BOXTYPE_REG             0x00000360
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the command/address pattern unified sequencer buffer.
    //  In case a stop condition occurs, this register will contain the last value that
    // was used to generate the command/address pattern.  Bit 0 represents the value
    // used for the current chunk.
    //
    // Bits[15:0], RO/V, default = 0x0
    //
    UINTX uniseq_stat : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_CADB_UNISEQ0STAT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_UNISEQ1STAT_CPGC_BOXTYPE_REG             0x00000364
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the command/address pattern unified sequencer buffer.
    //  In case a stop condition occurs, this register will contain the last value that
    // was used to generate the command/address pattern.  Bit 0 represents the value
    // used for the current chunk.
    //
    // Bits[15:0], RO/V, default = 0x0
    //
    UINTX uniseq_stat : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_CADB_UNISEQ1STAT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CPGC_CADB_UNISEQ2STAT_CPGC_BOXTYPE_REG             0x00000368
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The current contents of the command/address pattern unified sequencer buffer.
    //  In case a stop condition occurs, this register will contain the last value that
    // was used to generate the command/address pattern.  Bit 0 represents the value
    // used for the current chunk.
    //
    // Bits[15:0], RO/V, default = 0x0
    //
    UINTX uniseq_stat : 16;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 16;
  } Bits;
  UINTX Data;
} CPGC_CADB_UNISEQ2STAT_CPGC_BOXTYPE_STRUCT;
#endif // ASM_INC


#endif // _CPGC_BOXTYPE_H_
