/** @file
  File name:    DQ_BOXTYPE.h
  Input File:   GLK_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in DQ_BOXTYPE.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _DQ_BOXTYPE_H_
#define _DQ_BOXTYPE_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define DIGCTL_DQ_BOXTYPE_REG                              0x00000000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[1:0], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // Single data rate v/s Double Data rate
    // 0: Double data rate (LP3)
    // 1: Single data rate (LP4)
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX lpddr34mode : 1;
    //
    // SPID clk sel
    // 00: 0.5xmode
    // 01: 0.25x mode
    // 10: 0.1x mode
    // 11: NA
    //
    // Bits[4:3], RW, default = 0x0
    //
    UINTX spidclksel : 2;
    //
    // This is the burstlength configuration register
    // 1:BL16 and BL32
    // 0:BL4 and BL8
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX bl1632xbl48b : 1;
    //
    // CA training mode
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX ca_training : 1;
    //
    // Reserved bits
    //
    // Bits[8:7], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Programmable MCP for Tx FIFO read pointer path.
    //
    // 1: Enable MCP path
    // 0: Disable MCP path
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX rdmcpsel : 1;
    //
    // Reserved bits
    //
    // Bits[10:10], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // When enabled, SPID wrcmd is delayed by 1 spidclk before writing into the fifo.
    // Set to 1 if clock gating is enabled. Else set it to 0.
    //
    // 1: 1 spidclk delay
    // 0: no delay
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX slowpath : 1;
    //
    // Reserved bits
    //
    // Bits[12:12], RO, default = 0x0
    //
    UINTX reserved_3 : 1;
    //
    // This is the stretch mode signal.
    // 00- normal read
    // 01- x4 stretch mode
    // 10- x8 stretch mode
    // 11- x16 stretch mode
    //
    // Bits[14:13], RW, default = 0x0
    //
    UINTX stretchmode : 2;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX reserved_4 : 1;
    //
    // Delay between the phy update request to ack
    // in terms of SPID clocks.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX phyupd_dly : 8;
    //
    // Memory frequency
    // Bit 3:0 DRAM Frequency
    // 0000: 800
    // 0001: 1066
    // 0010: 1333
    // 0011: 1600
    // 0100: 1866
    // 0101: 2133
    // 0110: 2400
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX memfreq : 4;
    //
    // Memory Technology
    // Bit 3:0: DRAM Technology
    // 0000: LPDDR3
    // 0001: LPDDR4
    // 0010: DDR3/L/U
    // 0011: DDR4/L
    // 0100: WIO2
    // 0101: FMI
    // 0110: DDR-T
    // 0111: HBM
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX memtech : 4;
  } Bits;
  UINTX Data;
} DIGCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define FIFOPTRCTL_DQ_BOXTYPE_REG                          0x00000004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the double FIFO offset configuration(in terms of 2xclock).
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX bl_doublefifooffset : 4;
    //
    // This is the double FIFO offset configuration(in terms of 2xclock).
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX cc_doublefifooffset : 4;
    //
    // This is the ref2x read pointer init configuration.
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX ref2xrdptrinit : 5;
    //
    // This is the ref1xread pointer offset configuration.
    //
    // Bits[15:13], RW, default = 0x0
    //
    UINTX ref1xrdptroffset : 3;
    //
    // Configure DQCCC as DQ or CCC
    // 0: CCC
    // 1: DQ
    // This signal is invalid for BXT-P
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dqxccb : 1;
    //
    // This is the ref1x read pointer init configuration.
    //
    // Bits[20:17], RW, default = 0x0
    //
    UINTX ref1xrdptrinit : 4;
    //
    // DLL comp read pointer offset.
    //
    // Bits[23:21], RW, default = 0x0
    //
    UINTX compclkrdptroffset : 3;
    //
    // DLL comp init configuration.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX compclkrdptrinit : 4;
    //
    // DBMUX Phase 180 Clock Selection
    // 0: Phase180 clock from DLL Phase Interpolator (LP* Modes)
    // 1: Phase180 clock from Phase0 clock inversion (DDR3L/DDR4 Mode)
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX siggrp00_invph0to180 : 1;
    //
    // DBMUX Phase 180 Clock Selection
    // 0: Phase180 clock from DLL Phase Interpolator (LP* Modes)
    // 1: Phase180 clock from Phase0 clock inversion (DDR3L/DDR4 Mode)
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX siggrp01_invph0to180 : 1;
    //
    // DBMUX Phase 180 Clock Selection
    // 0: Phase180 clock from DLL Phase Interpolator (LP* Modes)
    // 1: Phase180 clock from Phase0 clock inversion (DDR3L/DDR4 Mode)
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX siggrp02_invph0to180 : 1;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved : 1;
  } Bits;
  UINTX Data;
} FIFOPTRCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DIGRSTCTL_DQ_BOXTYPE_REG                           0x00000008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reset for functional logic in upartition (except compensation and power management
    // logic)
    // 0: Reset assertion
    // 1: Reset de-assertion
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX spidrst_b : 1;
    //
    // Rxfifo reset (active low)
    // 1: deasserted
    // 0 : asserted
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX rxfiforst_b : 1;
    //
    // Reserved bits
    //
    // Bits[31:2], RO, default = 0x0
    //
    UINTX reserved : 30;
  } Bits;
  UINTX Data;
} DIGRSTCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define FIFOPTREN_DQ_BOXTYPE_REG                           0x0000000C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx FIFO write pointer enable.
    // 0: Disable
    // 1: Enable
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX wrptren : 1;
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} FIFOPTREN_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define IOBUFACT_AFE_DQ_BOXTYPE_REG                        0x00000010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IO buffer activate - DQ BL0 Analog
    // Tristates DQ and DQS IO buffers
    // Disable Rx sections of IO buffers
    // 0 : Disable IO buffers
    // 1 : Enable IO buffers
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lvl_bl_iobufactafe : 1;
    //
    // IO buffer activate - DQ BL1 Analog
    // Tristates DQ and DQS IO buffers
    // Disable Rx sections of IO buffers
    // 0 : Disable IO buffers
    // 1 : Enable IO buffers
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX lvl_cc_iobufactafe : 1;
    //
    // Reserved bits
    //
    // Bits[31:2], RO, default = 0x0
    //
    UINTX reserved : 30;
  } Bits;
  UINTX Data;
} IOBUFACT_AFE_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define IOBUFACT_DIG_DQ_BOXTYPE_REG                        0x00000014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IO buffer activate - DQ BL0 Digital.
    // This resets the intermediate/final flops in the transmit path.
    //
    // 0 : Assert reset
    // 1 : De-assert reset
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX bl_iobufactdig : 1;
    //
    // IO buffer activate - DQ BL1 Digital.
    // This resets the intermediate/final flops in the transmit path.
    //
    // 0 : Assert reset
    // 1 : De-assert reset
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX cc_iobufactdig : 1;
    //
    // Reserved bits
    //
    // Bits[31:2], RO, default = 0x0
    //
    UINTX reserved : 30;
  } Bits;
  UINTX Data;
} IOBUFACT_DIG_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define SPIDIC_DQ_BOXTYPE_REG                              0x00000018
#ifndef ASM_INC
typedef union {
  struct {
    //
    // SPID init complete
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX spid_init_complete : 1;
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} SPIDIC_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define WRDQCTL_DQ_BOXTYPE_REG                             0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Preamble 0 setting for BL0 DQ driver enable
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX bl_dqdrvenbpream0 : 2;
    //
    // Last data phase setting for BL0 DQ driver enable. For regular writes, this needs
    // to be set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX bl_dqdrvenblastph : 2;
    //
    // Preamble 1 setting for BL0 DQ driver enable. This is applicable only if 2tCK write
    // preamble mode is enabled.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX bl_dqdrvenbpream1 : 2;
    //
    // First data phase setting for BL0 DQ driver enable. For regular writes, this needs
    // to be set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX bl_dqdrvenbph1 : 2;
    //
    // Preamble 0 setting for BL1 DQ driver enable
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX cc_dqdrvenbpream0 : 2;
    //
    // Last data phase setting for BL1 DQ driver enable. For regular writes, this needs
    // to be set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX cc_dqdrvenblastph : 2;
    //
    // Preamble 1 setting for BL1 DQ driver enable. This is applicable only if 2tCK write
    // preamble mode is enabled.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX cc_dqdrvenbpream1 : 2;
    //
    // First data phase setting for BL1 DQ driver enable. For regular writes, this needs
    // to be set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX cc_dqdrvenbph1 : 2;
    //
    // Early DQ Enable
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX early_dqen : 1;
    //
    // Reserved bits
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} WRDQCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define WRDQSCTL_CC_DQ_BOXTYPE_REG                         0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Write command to BL1 DQS start delay. This is in ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX cc_wrcmd2dqsstart : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // Preamble 0 setting for BL1 DQS data
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX cc_dqsdatapream0 : 2;
    //
    // Last data phase setting for BL1 DQS data. For regular writes, this needs to be
    // set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX cc_dqsdatalastph : 2;
    //
    // Preamble 1 setting for BL1 DQS data. This is applicable only in case of 2tCK write
    // preamble case.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX cc_dqsdatapream1 : 2;
    //
    // First data phase setting for BL1 DQS data. For regular writes, this needs to be
    // set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX cc_dqsdataph1 : 2;
    //
    // Idle phase setting for BL1 DQS data.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[17:16], RW, default = 0x3
    //
    UINTX cc_dqsdrvenbidle : 2;
    //
    // TBD
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // 2tCK write preamble mode for BL1
    // 0 : 1 tCK write preamble mode
    // 1 : 2 tCK write preamble mode
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX cc_wrpream0en : 1;
    //
    // BL1 Data mask drive enable
    // 1: Enable DM buffer
    // 0: Tristate DM buffer
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX cc_dmdrven : 1;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_2 : 3;
    //
    // Preamble 0 setting for BL1 DQS driver enable
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX cc_dqsdrvenbpream0 : 2;
    //
    // Last data phase setting for BL1 DQS driver enable. For regular writes, this needs
    // to be set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX cc_dqsdrvenblastph : 2;
    //
    // Preamble 1 setting for BL1 DQS driver enable. This is applicable only if 2tCK
    // write preamble mode is enabled.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX cc_dqsdrvenbpream1 : 2;
    //
    // First data phase setting for BL1 DQS driver enable. For regular writes, this needs
    // to be set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX cc_dqsdrvenbph1 : 2;
  } Bits;
  UINTX Data;
} WRDQSCTL_CC_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define WRDQSCTL_BL_DQ_BOXTYPE_REG                         0x00000024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Write command to BL0 DQS start delay. This is in ref1xclks.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX bl_wrcmd2dqsstart : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // Preamble 0 setting for BL0 DQS data
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX bl_dqsdatapream0 : 2;
    //
    // Last data phase setting for BL0 DQS data. For regular writes, this needs to be
    // set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX bl_dqsdatalastph : 2;
    //
    // Preamble 1 setting for BL0 DQS data. This is applicable only in case of 2tCK write
    // preamble case.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX bl_dqsdatapream1 : 2;
    //
    // First data phase setting for BL0 DQS data. For regular writes, this needs to be
    // set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX bl_dqsdataph1 : 2;
    //
    // Idle phase setting for BL0 DQS data.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[17:16], RW, default = 0x3
    //
    UINTX bl_dqsdrvenbidle : 2;
    //
    // TBD
    //
    // Bits[18:18], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // 2tCK write preamble mode for BL0
    // 0 : 1 tCK write preamble mode
    // 1 : 2 tCK write preamble mode
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX bl_wrpream0en : 1;
    //
    // BL0 Data mask drive enable
    // 1: Enable DM buffer
    // 0: Tristate DM buffer
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX bl_dmdrven : 1;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_2 : 3;
    //
    // Preamble 0 setting for BL0 DQS driver enable
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX bl_dqsdrvenbpream0 : 2;
    //
    // Last data phase setting for BL0 DQS driver enable. For regular writes, this needs
    // to be set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX bl_dqsdrvenblastph : 2;
    //
    // Preamble 1 setting for BL0 DQS driver enable. This is applicable only if 2tCK
    // write preamble mode is enabled.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX bl_dqsdrvenbpream1 : 2;
    //
    // First data phase setting for BL0 DQS driver enable. For regular writes, this needs
    // to be set to 00.
    //
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1
    // 10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX bl_dqsdrvenbph1 : 2;
  } Bits;
  UINTX Data;
} WRDQSCTL_BL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RDVLDCTL_DQ_BOXTYPE_REG                            0x00000028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the read command to read valid register.
    // This is in terms of spidclk.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX rdcmd2rdvld : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // This controls the delay between the read valid assertion to SOC and the actual
    // read valid assertion
    // 0: Normal
    // 1: 1 spidclk early
    // 2: 2 spidclk early
    // 3: 3 spidclk early
    // 4: 4 spidclk early
    // 4+: Illegal
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX earlyrdvld : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Read command 2 read valid plus 1 sel.
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX rdcmd2rdvld_plus1sel : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // Read command 2 read bonus bits.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX rdcmd2rdvld_bonus : 8;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved_3 : 8;
  } Bits;
  UINTX Data;
} RDVLDCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RK2RKCTL1_DQ_BOXTYPE_REG                           0x0000002C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rank to Rank switch enable for BL0 rcven
    // 0 : Disable rk2rk switch
    // 1 : Disable rk2rk switch
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX bl_rk2rken_txrcven : 1;
    //
    // Rank to Rank switch enable for BL0 rx dqs
    // 0 : Disable rk2rk switch
    // 1 : Disable rk2rk switch
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX bl_rk2rken_rxdq_pi : 1;
    //
    // Rank to Rank switch enable for BL1 rcven
    // 0 : Disable rk2rk switch
    // 1 : Disable rk2rk switch
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX cc_rk2rken_txrcven : 1;
    //
    // Rank to Rank switch enable for BL1 rx dqs
    // 0 : Disable rk2rk switch
    // 1 : Disable rk2rk switch
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX cc_rk2rken_rxdq_pi : 1;
    //
    // Rank to Rank switch enable for BL0 tx dq
    // 0 : Disable rk2rk switch
    // 1 : Disable rk2rk switch
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX bl_rk2rken_txdq_pi : 1;
    //
    // Rank to Rank switch enable for BL0 tx dqs
    // 0 : Disable rk2rk switch
    // 1 : Disable rk2rk switch
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX bl_rk2rken_txdqs_pi : 1;
    //
    // Rank to Rank switch enable for Bl1 tx dq
    // 0 : Disable rk2rk switch
    // 1 : Disable rk2rk switch
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX cc_rk2rken_txdq_pi : 1;
    //
    // Rank to Rank switch enable for BL1 tx dqs
    // 0 : Disable rk2rk switch
    // 1 : Disable rk2rk switch
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX cc_rk2rken_txdqs_pi : 1;
    //
    // Adds an extra clock of delay between rdptr freeze and rcven/rxodten pushout code
    // change during read based rk2rk switch.
    // 1: Add 1 extra 2xclk of delay
    // 0: No delay
    //
    // This is applicable for rcven coarse/fine/dbsel/2xrdptroffset and rxodten 2xrdptroffset
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_txrcven : 1;
    //
    // Adds an extra 2x clock of delay between rdptr freeze and rcven override assertion
    // during read based rk2rk switch.
    // 1: Add 1 extra 2xclk of delay
    // 0: No delay
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_txrden : 1;
    //
    // Adds an extra 2x clock of delay between rdptr freeze and dq/dqs drive enable override
    // during write based rk2rk switch.
    // 1: Add 1 extra 2xclk of delay
    // 0: No delay
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_iodrven : 1;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // Adds an extra 1x clock of delay between rdptr freeze and rcven PI code change
    // during read based rk2rk switch.
    // 1: Add 1 extra ref1xclk of delay
    // 0: No delay
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX rcv_rk2rkswitch_dlyen : 1;
    //
    // Adds an extra 1x clock of delay between rdptr freeze and dq/dqs PI code change
    // during write based rk2rk switch.
    // 1: Add 1 extra ref1xclk of delay
    // 0: No delay
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX dqx_rk2rkswitch_dlyen : 1;
    //
    // Reserved bits
    //
    // Bits[31:14], RO, default = 0x0
    //
    UINTX reserved_1 : 18;
  } Bits;
  UINTX Data;
} RK2RKCTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RK2RKCTL0_DQ_BOXTYPE_REG                           0x00000030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Preamble setting for rcven override during rk2rk switching
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)
    // 10 : Drive 0 for UI0, Drive 1 for UI1
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX rk2rkrdencode_1st : 2;
    //
    // Postamble setting for rcven override during rk2rk switching
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)
    // 10 : Drive 0 for UI0, Drive 1 for UI1
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX rk2rkrdencode_2nd : 2;
    //
    // Preamble setting for dq/dqs drv enable override during rk2rk switching
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)
    // 10 : Drive 0 for UI0, Drive 1 for UI1
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX rk2rkdrvenbcode_1st : 2;
    //
    // Postamble setting for dq/dqs drv enable override during rk2rk switching
    // 00 : Drive 0 for UI0, Drive 0 for UI1
    // 01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)
    // 10 : Drive 0 for UI0, Drive 1 for UI1
    // 11 : Drive 1 for UI0, Drive 1 for UI1
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX rk2rkdrvenbcode_2nd : 2;
    //
    // Delay between spid rdcmd (that requires a rank switch) and rank change detection
    // logic.
    // This is in terms of ref1xclks.
    //
    // Bits[13:8], RW, default = 0x0
    //
    UINTX rdcmd2rkchglatency : 6;
    //
    // Reserved bits
    //
    // Bits[14:14], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // Delay between spid wrcmd (that requires a rank switch) and rank change detection
    // logic.
    // This is in terms of ref1xclks.
    //
    // Bits[20:15], RW, default = 0x0
    //
    UINTX wrcmd2rkchglatency : 6;
    //
    // Adds an extra clock of delay between rdptr freeze and DQ data/DQ drive enable
    // pushout code change during write based rk2rk switch.
    // 1: Add 1 extra 2xclk of delay
    // 0: No delay
    //
    // This is applicable for dq data's and dq drive enable's coarse/fine/dbsel/2xrdptroffset
    // and also their second rdport's 2xrdptroffset
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_txdq : 1;
    //
    // Adds an extra clock of delay between rdptr freeze and DQS data/ DQS drive enable
    // pushout code change during write based rk2rk switch.
    // 1: Add 1 extra 2xclk of delay
    // 0: No delay
    //
    // This is applicable for dqs coarse/fine/dbsel/2xrdptroffset and dqs second rdport's
    // 2xrdptroffset
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_txdqs : 1;
    //
    // Adds an extra clock of delay between rcven override and Rx DQS DLL pushout code
    // change during read based rk2rk switch.
    // 1: Add 1 extra 2xclk of delay
    // 0: No delay
    //
    // This is applicable for Rx DLL DQS HI/LO fine/coarse.
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX rk2rkmio2xclkpushout_rxdq : 1;
    //
    // Length of rcven override during read based rk2rk switching. This, along with preamble
    // and postamble setting,
    // contributes to the total length of the rcven override during rk2rk switching.
    // This is in ref1xclks.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rk2rkrdencode_3rd : 4;
    //
    // Length of dq/dqs drv enable override during write based rk2rk switching. This,
    // along with preamble and postamble
    // setting, contributes to the total length of the dq/dqs drv enable override during
    // rk2rk switching.
    // This is in ref1xclks.
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rk2rkdrvenbcode_3rd : 4;
  } Bits;
  UINTX Data;
} RK2RKCTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXODTSEGCTL_BL13_DQ_BOXTYPE_REG                    0x00000034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the receive ODT segment enable latency configuration register.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX cc_rdcmd2rxodtseg : 6;
    //
    // Reserved bits
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // This is the receive ODT segment enable configuration register - preamble 0(rise
    // & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[8:7], RW, default = 0x0
    //
    UINTX cc_rxodtsegpre0 : 2;
    //
    // This is the receive ODT segment enable configuration register - postamble 0 -
    // new(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[10:9], RW, default = 0x0
    //
    UINTX cc_rxodtsegpst0 : 2;
    //
    // This is the receive ODT segment enable configuration register - preamble 1(rise
    // & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[12:11], RW, default = 0x0
    //
    UINTX cc_rxodtsegpre1 : 2;
    //
    // This is the receive ODT segment enable configuration register - postamble 1 -
    //  new(rise & fall).
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[14:13], RW, default = 0x0
    //
    UINTX cc_rxodtsegpst1 : 2;
    //
    // This is the receive ODT segment enable length configuration register.
    // It's in number of 1x clocks.
    //
    // Bits[20:15], RW, default = 0x0
    //
    UINTX cc_rxodtseglenbl4 : 6;
    //
    // This is the RXODTSEGEN one hot enable
    // 0- rxodtsegen: 001->010->100
    // 1-rxodtsegen: 011->110->101
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX cc_rxodtsegtwohot : 1;
    //
    // Reserved bits
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Receive ODT segment enable read pointer offset.
    //
    // Bits[27:23], RW, default = 0x0
    //
    UINTX rk1_odtsegenrdptroffset : 5;
    //
    // Receive ODT segment enable override select.
    // 0= Dynamic  control
    // 1= Static  control
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX cc_rxodtsegovrsel : 1;
    //
    // Receive ODT segment enable override value.
    //
    // Bits[31:29], RW, default = 0x0
    //
    UINTX cc_rxodtsegovrval : 3;
  } Bits;
  UINTX Data;
} RXODTSEGCTL_BL13_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXODTSEGCTL_BL02_DQ_BOXTYPE_REG                    0x00000038
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the receive ODT segment enable latency configuration register.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX bl_rdcmd2rxodtseg : 6;
    //
    // Reserved bits
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // This is the receive ODT segment enable configuration register - preamble 0(rise
    // & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[8:7], RW, default = 0x0
    //
    UINTX bl_rxodtsegpre0 : 2;
    //
    // This is the receive ODT segment enable configuration register - postamble 0 -
    // new(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[10:9], RW, default = 0x0
    //
    UINTX bl_rxodtsegpst0 : 2;
    //
    // This is the receive ODT segment enable configuration register - preamble 1(rise
    // & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[12:11], RW, default = 0x0
    //
    UINTX bl_rxodtsegpre1 : 2;
    //
    // This is the receive ODT segment enable configuration register - postamble 1 -
    //  new(rise & fall).
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[14:13], RW, default = 0x0
    //
    UINTX bl_rxodtsegpst1 : 2;
    //
    // This is the receive ODT segment enable length configuration register.
    // It's in number of 1x clocks.
    //
    // Bits[20:15], RW, default = 0x0
    //
    UINTX bl_rxodtseglenbl4 : 6;
    //
    // This is the RXODTSEGEN one hot enable
    // 0- rxodtsegen: 001->010->100
    // 1-rxodtsegen: 011->110->101
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX bl_rxodtsegtwohot : 1;
    //
    // Reseved bits
    //
    // Bits[22:22], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Receive ODT segment enable read pointer offset.
    //
    // Bits[27:23], RW, default = 0x0
    //
    UINTX rk0_odtsegenrdptroffset : 5;
    //
    // Receive ODT segment enable override select.
    // 0= Dynamic  receive ODT control
    // 1= Static  receive ODT control
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX bl_rxodtsegovrsel : 1;
    //
    // Receive ODT segment enable override value.
    // 0: De-assert receive ODT enable
    // 1: Assert receive ODT enable
    //
    // Bits[31:29], RW, default = 0x0
    //
    UINTX bl_rxodtsegovrval : 3;
  } Bits;
  UINTX Data;
} RXODTSEGCTL_BL02_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXODTCTL_BL13_DQ_BOXTYPE_REG                       0x0000003C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the receive ODT enable latency configuration register.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX cc_rdcmd2rxodten : 6;
    //
    // Reserved bits
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // This is the receive ODT enable configuration register - preamble 0(rise & fall)
    //
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[8:7], RW, default = 0x0
    //
    UINTX cc_rxodtenpre0 : 2;
    //
    // This is the receive ODT enable configuration register - postamble 0 - new(rise
    // & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[10:9], RW, default = 0x0
    //
    UINTX cc_rxodtenpst0 : 2;
    //
    // This is the receive ODT enable configuration register - preamble 1(rise & fall)
    //
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[12:11], RW, default = 0x0
    //
    UINTX cc_rxodtenpre1 : 2;
    //
    // This is the receive ODT enable configuration register - postamble 1 -  new(rise
    // & fall).
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[14:13], RW, default = 0x0
    //
    UINTX cc_rxodtenpst1 : 2;
    //
    // This is the receive ODT enable length configuration register.
    // It's in number of 1x clocks.
    //
    // Bits[20:15], RW, default = 0x0
    //
    UINTX cc_rxodtenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[22:21], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Receive ODT enable override select.
    // 0= Dynamic RCVEN control
    // 1= Static RCVEN control
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX cc_rxodtenovrsel : 1;
    //
    // Receive ODT enable override value.
    // 0: De-assert receive enable
    // 1: Assert receive enable
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX cc_rxodtenovrval : 1;
    //
    // Rx DQS odt enable override select- DQ BL1 lane
    // 0= Dynamic RCVEN control
    // 1= Static RCVEN control
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX cc_dqsrxodtenovrsel : 1;
    //
    // Rx DQS odt enable override value - DQ BL1 lane
    // 0: De-assert receive enable
    // 1: Assert receive enable
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX cc_dqsrxodtenovrval : 1;
    //
    // This is receive ODT enable read pointer offset.
    //
    // Bits[31:27], RW, default = 0x0
    //
    UINTX rk1_odtenrdptroffset : 5;
  } Bits;
  UINTX Data;
} RXODTCTL_BL13_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXODTCTL_DQ_DQ_BOXTYPE_REG                         0x00000040
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the receive ODT enable latency configuration register.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX bl_rdcmd2rxodten : 6;
    //
    // Reserved bits
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // This is the receive ODT enable configuration register - preamble 0(rise & fall)
    //
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[8:7], RW, default = 0x0
    //
    UINTX bl_rxodtenpre0 : 2;
    //
    // This is the receive ODT enable configuration register - postamble 0 - new(rise
    // & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[10:9], RW, default = 0x0
    //
    UINTX bl_rxodtenpst0 : 2;
    //
    // This is the receive ODT enable configuration register - preamble 1(rise & fall)
    //
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[12:11], RW, default = 0x0
    //
    UINTX bl_rxodtenpre1 : 2;
    //
    // This is the receive ODT enable configuration register - postamble 1 -  new(rise
    // & fall).
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[14:13], RW, default = 0x0
    //
    UINTX bl_rxodtenpst1 : 2;
    //
    // This is the receive ODT enable length configuration register.
    // It's in number of 1x clocks.
    //
    // Bits[20:15], RW, default = 0x0
    //
    UINTX bl_rxodtenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[22:21], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Receive ODT enable override select.
    // 0= Dynamic RCVEN control
    // 1= Static RCVEN control
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX bl_rxodtenovrsel : 1;
    //
    // Receive ODT enable override value.
    // 0: De-assert receive enable
    // 1: Assert receive enable
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX bl_rxodtenovrval : 1;
    //
    // Rx DQS odt enable override select- DQ BL0 lane
    // 0= Dynamic RCVEN control
    // 1= Static RCVEN control
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX bl_dqsrxodtenovrsel : 1;
    //
    // Rx DQS odt enable override value - DQ BL0 lane
    // 0: De-assert receive enable
    // 1: Assert receive enable
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX bl_dqsrxodtenovrval : 1;
    //
    // This is receive ODT enable read pointer offset.
    //
    // Bits[31:27], RW, default = 0x0
    //
    UINTX rk0_odtenrdptroffset : 5;
  } Bits;
  UINTX Data;
} RXODTCTL_DQ_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RCVENCTL_BL13_DQ_BOXTYPE_REG                       0x00000044
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the receive enable latency configuration register.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX cc_rdcmd2rcven : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // This is the receive enable configuration register - preamble 0(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX cc_rcvenpre0 : 2;
    //
    // This is the receive enable configuration register - postamble 0 - new(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX cc_rcvenpst0 : 2;
    //
    // This is the receive enable configuration register - preamble 1(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX cc_rcvenpre1 : 2;
    //
    // This is the receive enable configuration register - postamble 1 -  new(rise &
    // fall).
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX cc_rcvenpst1 : 2;
    //
    // This is the receive enable length(number of 1x clock) configuration register.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX cc_rcvenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[23:22], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Receive enable override select.
    // 0= Dynamic RCVEN control
    // 1= Static RCVEN control
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX cc_rcvenovrsel : 1;
    //
    // Receive enable override value.
    // 0: De-assert receive enable
    // 1: Assert receive enable
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX cc_rcvenovrval : 1;
    //
    // Receive enable margining data
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX cc_rcvenmargin : 1;
    //
    // DQS counter reset
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX drx_cc_dqscountrstb : 1;
    //
    // DQS counter flop override
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX drx_cc_rcvenflopbypass : 1;
    //
    // Reserved bits
    //
    // Bits[30:29], RO, default = 0x0
    //
    UINTX reserved_2 : 2;
    //
    // AFE status register - RCVSMPL - CC
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX drx_cc_rcvsmpl : 1;
  } Bits;
  UINTX Data;
} RCVENCTL_BL13_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RCVENCTL_BL02_DQ_BOXTYPE_REG                       0x00000048
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the receive enable latency configuration register.
    // RL - 1: maps to DRAM RL.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX bl_rdcmd2rcven : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // This is the receive enable configuration register - preamble 0(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[9:8], RW, default = 0x0
    //
    UINTX bl_rcvenpre0 : 2;
    //
    // This is the receive enable configuration register - postamble 0 - new(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX bl_rcvenpst0 : 2;
    //
    // This is the receive enable configuration register - preamble 1(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[13:12], RW, default = 0x0
    //
    UINTX bl_rcvenpre1 : 2;
    //
    // This is the receive enable configuration register - postamble 1 -  new(rise &
    // fall).
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX bl_rcvenpst1 : 2;
    //
    // This is the receive enable length(number of 1x clock) configuration register.
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX bl_rcvenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[23:22], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // Receive enable override select.
    // 0= Dynamic RCVEN control
    // 1= Static RCVEN control
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX bl_rcvenovrsel : 1;
    //
    // Receive enable override value.
    // 0: De-assert receive enable
    // 1: Assert receive enable
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX bl_rcvenovrval : 1;
    //
    // Receive enable margining data
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX bl_rcvenmargin : 1;
    //
    // DQS counter reset
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX drx_bl_dqscountrstb : 1;
    //
    // DQS counter flop override
    //
    // Bits[28:28], RW, default = 0x0
    //
    UINTX drx_bl_rcvenflopbypass : 1;
    //
    // Reserved bits
    //
    // Bits[30:29], RO, default = 0x0
    //
    UINTX reserved_2 : 2;
    //
    // AFE status register - RCVSMPL - DQ
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX drx_bl_rcvsmpl : 1;
  } Bits;
  UINTX Data;
} RCVENCTL_BL02_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DIFFAMPCTL_BL13_DQ_BOXTYPE_REG                     0x0000004C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the Diffamp enable latency register.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX cc_rdcmd2diffampen : 6;
    //
    // Reserved bits
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // This is the diffamp enable length(number of 1x clock) configuration register.
    //
    // Bits[12:7], RW, default = 0x0
    //
    UINTX cc_diffampenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[14:13], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // This is the diffamp enable configuration register - preamble 0(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[16:15], RW, default = 0x0
    //
    UINTX cc_diffampenpre0 : 2;
    //
    // This is the diffamp enable configuration register - postamble 0 - new(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[18:17], RW, default = 0x0
    //
    UINTX cc_diffampenpst0 : 2;
    //
    // This is the diffamp enable configuration register - preamble 1(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[20:19], RW, default = 0x0
    //
    UINTX cc_diffampenpre1 : 2;
    //
    // This is the diffamp enable configuration register - postamble 1 -  new(rise &
    // fall).
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[22:21], RW, default = 0x0
    //
    UINTX cc_diffampenpst1 : 2;
    //
    // Override select for DQ/DM Diffamp enable - DQ Lane
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX cc_dqdmdiffampenovrsel : 1;
    //
    // Override value for DQ/DM Diffamp enable - DQ Lane
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX cc_dqdmdiffampenovrval : 1;
    //
    // Override select for DQS Diffamp enable - DQ Lane
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX cc_dqsdiffampenovrsel : 1;
    //
    // Override value for DQS Diffamp enable - DQ Lane
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX cc_dqsdiffampenovrval : 1;
    //
    // Differential amplifier read pointer offset control.
    //
    // Bits[31:27], RW, default = 0x0
    //
    UINTX rk1_diffampenrdptroffset : 5;
  } Bits;
  UINTX Data;
} DIFFAMPCTL_BL13_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DIFFAMPCTL_BL02_DQ_BOXTYPE_REG                     0x00000050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the Diffamp enable latency register.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX bl_rdcmd2diffampen : 6;
    //
    // Reserved bits
    //
    // Bits[6:6], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // This is the diffamp enable length(number of 1x clock) configuration register.
    //
    // Bits[12:7], RW, default = 0x0
    //
    UINTX bl_diffampenlenbl4 : 6;
    //
    // Reserved bits
    //
    // Bits[14:13], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // This is the diffamp enable configuration register - preamble 0(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[16:15], RW, default = 0x0
    //
    UINTX bl_diffampenpre0 : 2;
    //
    // This is the diffamp enable configuration register - postamble 0 - new(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[18:17], RW, default = 0x0
    //
    UINTX bl_diffampenpst0 : 2;
    //
    // This is the diffamp enable configuration register - preamble 1(rise & fall)
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[20:19], RW, default = 0x0
    //
    UINTX bl_diffampenpre1 : 2;
    //
    // This is the diffamp enable configuration register - postamble 1 -  new(rise &
    // fall).
    // 00 - Rise & Fall - Low & Low
    // 01 - Rise & Fall - High & Low
    // 10 - Rise & Fall - Low & High
    // 11 - Rise & Fall - High & High
    //
    // Bits[22:21], RW, default = 0x0
    //
    UINTX bl_diffampenpst1 : 2;
    //
    // Override select for DQ/DM Diffamp enable - DQ Lane
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX bl_dqdmdiffampenovrsel : 1;
    //
    // Override value for DQ/DM Diffamp enable - DQ Lane
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX bl_dqdmdiffampenovrval : 1;
    //
    // Override select for DQS Diffamp enable - DQ Lane
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX bl_dqsdiffampenovrsel : 1;
    //
    // Override value for DQS Diffamp enable - DQ Lane
    //
    // Bits[26:26], RW, default = 0x0
    //
    UINTX bl_dqsdiffampenovrval : 1;
    //
    // Differential amplifier read pointer offset control.
    //
    // Bits[31:27], RW, default = 0x0
    //
    UINTX rk0_diffampenrdptroffset : 5;
  } Bits;
  UINTX Data;
} DIFFAMPCTL_BL02_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define WRLVL_DQ_BOXTYPE_REG                               0x00000054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQTRAINSTS - WRLVL Byte0 sample OR combination
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX wrlvl_or_sample_b0 : 1;
    //
    // DQTRAINSTS - WRLVL Byte1 sample OR combination
    //
    // Bits[1:1], RO, default = 0x0
    //
    UINTX wrlvl_or_sample_b1 : 1;
    //
    // DQTRAINSTS - WRLVL Byte0 sample AND combination
    //
    // Bits[2:2], RO, default = 0x0
    //
    UINTX wrlvl_and_sample_b0 : 1;
    //
    // DQTRAINSTS - WRLVL Byte1 sample AND combination
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX wrlvl_and_sample_b1 : 1;
    //
    // Reserved bits
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX reserved : 4;
    //
    // DQTRAINSTS - WRLVL sampling from all DQ bit lanes of Bytelane 0
    //
    // Bits[15:8], RO, default = 0x0
    //
    UINTX wrlvl_sample_b0 : 8;
    //
    // DQTRAINSTS - WRLVL sampling from all DQ bit lanes of Bytelane 1
    //
    // Bits[23:16], RO, default = 0x0
    //
    UINTX wrlvl_sample_b1 : 8;
    //
    // Write Levelization enable - DQ 0/2 Byte Lane
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX bl_wrlvl : 1;
    //
    // Write Levelization enable - DQ 1/3 Byte Lane
    //
    // Bits[25:25], RW, default = 0x0
    //
    UINTX cc_wrlvl : 1;
    //
    // Reserved bits
    //
    // Bits[31:26], RO, default = 0x0
    //
    UINTX reserved_1 : 6;
  } Bits;
  UINTX Data;
} WRLVL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CLKGATERDCTL_DQ_BOXTYPE_REG                        0x00000058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IDLE timer counter max value for clock gating on rx .
    // Counter timeout based on last RDCMD received.
    //
    // Bits[5:0], RW, default = 0x3F
    //
    UINTX readclkgate_maxcntr : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // This is the delay in terms of clocks the drven is enabled, once wrcmd/rdcmd is
    // received.
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX read_startrden : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // This is the delay in terms of clocks the dven is disabled before clock gated.
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX read_stoprden : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // Enable Dynamic SPIDCLK control.
    // 1= spidclken  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled SPIDCLKEN
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dynreadspidclken : 1;
    //
    // Enable Dynamic REF1XCLK control.
    // 1= ref1xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled REF1XCLKEN
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX dynreadref1xclken : 1;
    //
    // Enable Dynamic REF2XCLK control.
    // 1= ref2xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled REF2XCLKEN
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX dynreadref2xclken : 1;
    //
    // Enable Dynamic SIGGRP 2x clock control.
    // 1= SIGGRPEN  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled SIGGRPEN
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX dynreadsiggrpen : 1;
    //
    // Reserved bits
    //
    // Bits[31:20], RO, default = 0x0
    //
    UINTX reserved_3 : 12;
  } Bits;
  UINTX Data;
} CLKGATERDCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CLKGATEWRCTL_DQ_BOXTYPE_REG                        0x0000005C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IDLE timer counter max value for clock gating on tx .
    // Counter timeout based on last WRCMD received.
    //
    // Bits[5:0], RW, default = 0x3F
    //
    UINTX writeclkgate_maxcntr : 6;
    //
    // Reserved bits
    //
    // Bits[7:6], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // This is the delay in terms of clocks the drven is enabled, once wrcmd/rdcmd is
    // received.
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX write_startdrv : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // This is the delay in terms of clocks the dven is disabled before clock gated.
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX write_stopdrv : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // Enable Dynamic SPIDCLK control  (writes)
    // 1= spidclken  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled SPIDCLKEN
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dynwritespidclken : 1;
    //
    // Enable Dynamic REF1XCLK control  (writes)
    // 1= ref1xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled REF1XCLKEN
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX dynwriteref1xclken : 1;
    //
    // Enable Dynamic REF2XCLK control  (writes)
    // 1= ref2xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled REF2XCLKEN
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX dynwriteref2xclken : 1;
    //
    // Enable Dynamic SIGGRP 2x clock control (writes)
    // 1= SIGGRPEN  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled SIGGRPEN
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX dynwritesiggrpen : 1;
    //
    // Reserved bits
    //
    // Bits[31:20], RO, default = 0x0
    //
    UINTX reserved_3 : 12;
  } Bits;
  UINTX Data;
} CLKGATEWRCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CLKGATECTL_DQ_BOXTYPE_REG                          0x00000060
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Clock Gating register : IDLE timer counter max value for clock gating on tx/rx
    // . Counter timeout based on last WRCMD/RDCMD received. 6 bits are good enough since
    // it increments in spidclk.
    //
    // Bits[5:0], RW, default = 0x3F
    //
    UINTX clkgate_maxcntr : 6;
    //
    // Reserved bits
    //
    // Bits[15:6], RO, default = 0x0
    //
    UINTX reserved : 10;
    //
    // Enable Dynamic SPIDCLK control  (reads)
    // 1= spidclken  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled SPIDCLKEN
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dynspidclken : 1;
    //
    // Enable Dynamic REF1XCLK control  (reads)
    // 1= ref1xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)
    // 0= Statically-controlled REF1XCLKEN
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX dynref1xclken : 1;
    //
    // Enable Dynamic REF2XCLK control. 1= ref2xclken  controlled by the dynamic clock
    // gating logic (DYNDLLFSM), 0= Statically-controlled REF2XCLKEN
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX dynref2xclken : 1;
    //
    // Enable Dynamic SIGGRP 2x clock control. 1= SIGGRPEN  controlled by the dynamic
    // clock gating logic (DYNDLLFSM), 0= Statically-controlled SIGGRPEN
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX dynsiggrpen : 1;
    //
    // Reserved bits
    //
    // Bits[31:20], RO, default = 0x0
    //
    UINTX reserved_1 : 12;
  } Bits;
  UINTX Data;
} CLKGATECTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP5CTL_DQ_BOXTYPE_REG                     0x00000064
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 5 rank 0 maps to BL1 RCVEN
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05picode : 8;
    //
    // Read pointer offset for sig group 5 rank 0 maps to BL1 RCVEN
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05rdptroffset : 5;
    //
    // Deadband select for sig group 5 rank 0 maps to BL1 RCVEN
    //
    // Bits[15:13], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp05dbsel : 3;
    //
    // PI code for sig group 5 rank 1 maps to BL1 RCVEN
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp05picode : 8;
    //
    // Read pointer offset for sig group 5 rank 1 maps to BL1 RCVEN
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp05rdptroffset : 5;
    //
    // Deadband select for sig group 5 rank 1 maps to BL1 RCVEN
    //
    // Bits[30:29], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp05dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved : 1;
  } Bits;
  UINTX Data;
} TXDLLSIGGRP5CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP4CTL_DQ_BOXTYPE_REG                     0x00000068
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 4 rank 0 maps to BL1 DQS
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04picode : 8;
    //
    // Read pointer offset for sig group 4 rank 0 maps to BL1 DQS
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04rdptroffset : 5;
    //
    // Deadband select for sig group 4 rank 0 maps to BL1 DQS
    //
    // Bits[15:13], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp04dbsel : 3;
    //
    // PI code for sig group 4 rank 1 maps to BL1 DQS
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp04picode : 8;
    //
    // Read pointer offset for sig group 4 rank 1 maps to BL1 DQS
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp04rdptroffset : 5;
    //
    // Deadband select for sig group 4 rank 1 maps to BL1 DQS
    //
    // Bits[30:29], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp04dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved : 1;
  } Bits;
  UINTX Data;
} TXDLLSIGGRP4CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP3CTL_DQ_BOXTYPE_REG                     0x0000006C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 3 rank 0 maps to BL1 DQ
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03picode : 8;
    //
    // Read pointer offset for sig group 3 rank 0 maps to BL1 DQ
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03rdptroffset : 5;
    //
    // Deadband select for sig group 3 rank 0 maps to BL1 DQ
    //
    // Bits[15:13], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp03dbsel : 3;
    //
    // PI code for sig group 3 rank 1 maps to BL1 DQ
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp03picode : 8;
    //
    // Read pointer offset for sig group 3 rank 1 maps to BL1 DQ
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp03rdptroffset : 5;
    //
    // Deadband select for sig group 3 rank 1 maps to BL1 DQ
    //
    // Bits[30:29], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp03dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved : 1;
  } Bits;
  UINTX Data;
} TXDLLSIGGRP3CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP2CTL_DQ_BOXTYPE_REG                     0x00000070
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 2 rank 0 maps to BL0 RCVEN
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp02picode : 8;
    //
    // Read pointer offset for sig group 2 rank 0 maps to BL0 RCVEN
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp02rdptroffset : 5;
    //
    // Deadband select for sig group 2 rank 0 maps to BL0 RCVEN
    //
    // Bits[15:13], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp02dbsel : 3;
    //
    // PI code for sig group 2 rank 1 maps to BL0 RCVEN
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp02picode : 8;
    //
    // Read pointer offset for sig group 2 rank 1 maps to BL0 RCVEN
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp02rdptroffset : 5;
    //
    // Deadband select for sig group 2 rank 1 maps to BL0 RCVEN
    //
    // Bits[30:29], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp02dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved : 1;
  } Bits;
  UINTX Data;
} TXDLLSIGGRP2CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP1CTL_DQ_BOXTYPE_REG                     0x00000074
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 1 rank 0 maps to BL0 DQS
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp01picode : 8;
    //
    // Read pointer offset for sig group 1 rank 0 maps to BL0 DQS
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp01rdptroffset : 5;
    //
    // Deadband select for sig group 1 rank 0 maps to BL0 DQS
    //
    // Bits[15:13], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp01dbsel : 3;
    //
    // PI code for sig group 1 rank 1 maps to BL0 DQS
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp01picode : 8;
    //
    // Read pointer offset for sig group 1 rank 1 maps to BL0 DQS
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp01rdptroffset : 5;
    //
    // Deadband select for sig group 1 rank 1 maps to BL0 DQS
    //
    // Bits[30:29], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp01dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved : 1;
  } Bits;
  UINTX Data;
} TXDLLSIGGRP1CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP0CTL_DQ_BOXTYPE_REG                     0x00000078
#ifndef ASM_INC
typedef union {
  struct {
    //
    // PI code for sig group 0 rank 0 maps to BL0 DQ
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp00picode : 8;
    //
    // Read pointer offset for sig group 0 rank 0 maps to BL0 DQ
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp00rdptroffset : 5;
    //
    // Deadband select for sig group 0 rank 0 maps to BL0 DQ
    //
    // Bits[15:13], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp00dbsel : 3;
    //
    // PI code for sig group 0 rank 1 maps to BL0 DQ
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp00picode : 8;
    //
    // Read pointer offset for sig group 0 rank 1 maps to BL0 DQ
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp00rdptroffset : 5;
    //
    // Deadband select for sig group 0 rank 1 maps to BL0 DQ
    //
    // Bits[30:29], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp00dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved : 1;
  } Bits;
  UINTX Data;
} TXDLLSIGGRP0CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define WKPUPPDNCTL_DQ_BOXTYPE_REG                         0x0000007C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Weak Pull Down Control code for DQS - DQ ByteLane 0/2
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX lvl_bl_weakpdn : 6;
    //
    // Weak Pull Down Control static bit for DQS - DQ ByteLane 0/2
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX lvl_bl_weakpdnstatic : 1;
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // Weak Pull Up Control code for DQSB - DQ ByteLane 0/2
    //
    // Bits[13:8], RW, default = 0x0
    //
    UINTX lvl_bl_weakpup : 6;
    //
    // Weak Pull Up Control static bit for DQSB - DQ ByteLane 0/2
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX lvl_bl_weakpupstatic : 1;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Weak Pull Down Control code for DQS - DQ ByteLane 1/3
    //
    // Bits[21:16], RW, default = 0x0
    //
    UINTX lvl_cc_weakpdn : 6;
    //
    // Weak Pull Down Control static bit for DQS - DQ ByteLane 1/3
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX lvl_cc_weakpdnstatic : 1;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // Weak Pull Up Control code for DQSB - DQ ByteLane 1/3
    //
    // Bits[29:24], RW, default = 0x0
    //
    UINTX lvl_cc_weakpup : 6;
    //
    // Weak Pull Up Control static bit for DQSB - DQ ByteLane 1/3
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX lvl_cc_weakpupstatic : 1;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved_3 : 1;
  } Bits;
  UINTX Data;
} WKPUPPDNCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define AFEMISC1_DQ_BOXTYPE_REG                            0x00000080
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Config Register space has been reallocated for RxBIASEN ECO HSD#1404029255
    // Override value for Rx bias enable - BL0 Lane
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX tx_bl_allfire : 1;
    //
    // Config Register space has been reallocated for RxBIASEN ECO HSD#1404029255
    // Override value  for Rx bias enable - BL1 Lane
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX tx_cc_allfire : 1;
    //
    // Config Register space has been reallocated for RxBIASEN ECO HSD#1404029255
    // Override select for Rx bias enable - BL0 Lane
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX dtx_bl_allfire : 1;
    //
    // Config Register space has been reallocated for RxBIASEN ECO HSD#1404029255
    // Override select for Rx bias enable - BL1 Lane
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX dtx_cc_allfire : 1;
    //
    // set cap tuning for pi
    //
    // Bits[6:4], RW, default = 0x1
    //
    UINTX txdll_picapsel : 3;
    //
    // Selects between LP4/LP3 (1'b0) and DDR4 modes (1'b1) - BL0
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX tx_bl0_techselect : 1;
    //
    // set cap tuning for RxDLL BL 0/2 pi
    //
    // Bits[10:8], RW, default = 0x1
    //
    UINTX rxdll_bl_picapsel : 3;
    //
    // masking out the first dqs negedge during rcven handling in ddr4 (0-ddr4;1-ddr3l,lp3/4)
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX drx_bl_dqsnegedgemask : 1;
    //
    // set cap tuning for RxDLL BL 1/3 pi
    //
    // Bits[14:12], RW, default = 0x1
    //
    UINTX rxdll_cc_picapsel : 3;
    //
    // masking out the first dqs negedge during rcven handling in ddr4 (0-ddr4;1-ddr3l,lp3/4)
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX drx_cc_dqsnegedgemask : 1;
    //
    // Segment enable for BL 0/2 DQ buffer. Used for per leg testing in HVM
    //
    // Bits[18:16], RW, default = 0x7
    //
    UINTX tx_bl_drvsegen : 3;
    //
    // Disable idle mode logic = 1'b0, Enable = 1'b1 - BL0
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX tx_bl0_idlemode : 1;
    //
    // Segment enable for BL 0/2 DQS buffer. Used for per leg testing in HVM
    //
    // Bits[22:20], RW, default = 0x7
    //
    UINTX dtx_bl_drvsegen : 3;
    //
    // Selects between LP4/LP3 (1'b0) and DDR4 modes (1'b1) - BL1
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX tx_bl1_techselect : 1;
    //
    // Segment enable for BL 1/3 DQ buffer. Used for per leg testing in HVM
    //
    // Bits[26:24], RW, default = 0x7
    //
    UINTX tx_cc_drvsegen : 3;
    //
    // Disable idle mode logic = 1'b0, Enable = 1'b1 - BL1
    //
    // Bits[27:27], RW, default = 0x0
    //
    UINTX tx_bl1_idlemode : 1;
    //
    // Segment enable for BL 1/3 DQS buffer. Used for per leg testing in HVM
    //
    // Bits[30:28], RW, default = 0x7
    //
    UINTX dtx_cc_drvsegen : 3;
    //
    // Selects between LP4/LP3 (1'b0) and DDR4 modes (1'b1) - Common for all byte Lanes
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX rx_modelp4ddr4 : 1;
  } Bits;
  UINTX Data;
} AFEMISC1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define AFEMISC0_DQ_BOXTYPE_REG                            0x00000084
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Static pull up code - ODT DQS/DQSB
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX pupodtstaticdqs : 1;
    //
    // Static pull up code - ODT DQ
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX pupodtstatic : 1;
    //
    // Static pull up code - DRV DQS/DQSB
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX pupdrvstaticdqs : 1;
    //
    // Static pull up code - DRV DQ
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX pupdrvstatic : 1;
    //
    // Static pull down code - ODT DQS/DQSB
    //
    // Bits[4:4], RW, default = 0x1
    //
    UINTX pdnodtstaticdqs : 1;
    //
    // Static pull down code - ODT DQ
    //
    // Bits[5:5], RW, default = 0x1
    //
    UINTX pdnodtstatic : 1;
    //
    // Static pull down code - DRV DQS/DQSB
    //
    // Bits[6:6], RW, default = 0x1
    //
    UINTX pdndrvstaticdqs : 1;
    //
    // Static pull down code - DRV DQ
    //
    // Bits[7:7], RW, default = 0x1
    //
    UINTX pdndrvstatic : 1;
    //
    // changes the common mode of receiver  for BL 0/2 DQ Buffer from low common mode
    // to vcc/2 based on lpddr3/ lpddr4.
    //
    // Bits[8:8], RW, default = 0x1
    //
    UINTX rx_bl_rxcommonmode : 1;
    //
    // changes the common mode of receiver  for BL 1/3 DQ Buffer from low common mode
    // to vcc/2 based on lpddr3/ lpddr4.
    //
    // Bits[9:9], RW, default = 0x1
    //
    UINTX rx_cc_rxcommonmode : 1;
    //
    // changes the common mode of receiver  for BL 0/2 DQS Buffer from low common mode
    // to vcc/2 based on lpddr3/ lpddr4.
    //
    // Bits[10:10], RW, default = 0x1
    //
    UINTX drx_bl_rxcommonmode : 1;
    //
    // changes the common mode of receiver  for BL 1/3 DQS Buffer from low common mode
    // to vcc/2 based on lpddr3/ lpddr4.
    //
    // Bits[11:11], RW, default = 0x1
    //
    UINTX drx_cc_rxcommonmode : 1;
    //
    // TxDLL Skew Compensator clock mux select (Clock Select [1:0]/Sync Div Reset[3:2])
    // Below select descriptions apply to both clock and div reset but each one can be
    // controlled independently
    // 00 - Default path - No addditional Skew added
    // 01 - Skew Path 1 - Add ~30-40ps of delay to TxDLL 2xclk input based on PVT
    // 11 - Skew Path 2 - Add ~90-100ps of delay to TxDLL 2xclk input based on PVT
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX txdll_2xclkskewsel : 4;
    //
    // Modulates the Volatge seen by the RX Amplifier
    // 00 - Default; 01,10,11 - Illegal Values
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX rx_bl_rxpwrmode : 2;
    //
    // Modulates the Volatge seen by the RX Amplifier
    // 00 - Default; 01,10,11 - Illegal Values
    //
    // Bits[19:18], RW, default = 0x0
    //
    UINTX drx_bl_rxpwrmode : 2;
    //
    // Modulates the Volatge seen by the RX Amplifier
    // 00 - Default; 01,10,11 - Illegal Values
    //
    // Bits[21:20], RW, default = 0x0
    //
    UINTX rx_cc_rxpwrmode : 2;
    //
    // Modulates the Volatge seen by the RX Amplifier
    // 00 - Default; 01,10,11 - Illegal Values
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX drx_cc_rxpwrmode : 2;
    //
    // Streches rising edge of drivenable to relax data to enable skew for BL 0/2 DQ
    // Buffer.
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX tx_bl_drvenstretch : 2;
    //
    // Streches rising edge of drivenable to relax data to enable skew for BL 1/3 DQ
    // Buffer.
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX tx_cc_drvenstretch : 2;
    //
    // Streches rising edge of drivenable to relax data to enable skew for BL 0/2 DQS
    // Buffer.
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX dtx_bl_drvenstretch : 2;
    //
    // Streches rising edge of drivenable to relax data to enable skew for BL 1/3 DQS
    // Buffer.
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX dtx_cc_drvenstretch : 2;
  } Bits;
  UINTX Data;
} AFEMISC0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define AFEBONUS_DQ_BOXTYPE_REG                            0x00000088
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bonus bits - LVL BL 1/3 Lane
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX lvl_bl_bonus : 4;
    //
    // Bonus bits - LVL BL 0/2 Lane
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX lvl_cc_bonus : 4;
    //
    // Bonus bits - RX BL 1/3 Lane
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rx_bl1_bonus : 4;
    //
    // Bonus bits - RX BL 0/2 Lane
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rx_bl0_bonus : 4;
    //
    // Reserved bits
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX reserved : 16;
  } Bits;
  UINTX Data;
} AFEBONUS_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DIGOBSCTL1_DQ_BOXTYPE_REG                          0x0000008C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Digital observation select mux port 0 for BL 1/3 RxDLL
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rxdll_cc_digobs0sel : 4;
    //
    // Digital observation select mux port 1 for BL 1/3 RxDLL
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rxdll_cc_digobs1sel : 4;
    //
    // Digital observation select mux port 0 for BL 0/2 RxDLL
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rxdll_bl_digobs0sel : 4;
    //
    // Digital observation select mux port 1 for BL 0/2 RxDLL
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rxdll_bl_digobs1sel : 4;
    //
    // Reserved bits
    //
    // Bits[17:16], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // digital buf obs enable (1=enable;0=disable) for BL 0/2 DQS Buffer
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX dtx_bl_digobsen : 1;
    //
    // digital buf obs enable (1=enable;0=disable) for TxDLL
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX txdll_digobsen : 1;
    //
    // Reserved bits
    //
    // Bits[20:20], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // digital buf obs enable (1=enable;0=disable) for BL 1/3 DQS Buffer
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX dtx_cc_digobsen : 1;
    //
    // digital buf obs enable (1=enable;0=disable) for BL 0/2 RxDLL
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX rxdll_bl_digobsen : 1;
    //
    // digital buf obs enable (1=enable;0=disable) for BL 1/3 RxDLL
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX rxdll_cc_digobsen : 1;
    //
    // Digital observation select mux port 0
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX txdll_digobs0sel : 4;
    //
    // Digital observation select mux port 1
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX txdll_digobs1sel : 4;
  } Bits;
  UINTX Data;
} DIGOBSCTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DIGOBSCTL0_DQ_BOXTYPE_REG                          0x00000090
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Digital observation select mux port 0 for BL 0/2 DQ Buffer
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX tx_bl_digobs0sel : 3;
    //
    // Reserved bits
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // Digital observation select mux port 1 for BL 0/2 DQ Buffer
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX tx_bl_digobs1sel : 3;
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // Digital observation select mux port 0 for BL 1/3 DQ Buffer
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX tx_cc_digobs0sel : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // Digital observation select mux port 1 for BL 1/3 DQ Buffer
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX tx_cc_digobs1sel : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX reserved_3 : 1;
    //
    // Digital observation select mux port 0 for BL 0/2 DQS Buffer
    //
    // Bits[18:16], RW, default = 0x0
    //
    UINTX dtx_bl_digobs0sel : 3;
    //
    // Reserved bits
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX reserved_4 : 1;
    //
    // Digital observation select mux port 1 for BL 0/2 DQS Buffer
    //
    // Bits[22:20], RW, default = 0x0
    //
    UINTX dtx_bl_digobs1sel : 3;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX reserved_5 : 1;
    //
    // Digital observation select mux port 0 for BL 1/3 DQS Buffer
    //
    // Bits[26:24], RW, default = 0x0
    //
    UINTX dtx_cc_digobs0sel : 3;
    //
    // Reserved bits
    //
    // Bits[27:27], RO, default = 0x0
    //
    UINTX reserved_6 : 1;
    //
    // Digital observation select mux port 1 for BL 1/3 DQS Buffer
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX dtx_cc_digobs1sel : 3;
    //
    // DQ Post Rx FLOP to Digital MonPort Enable; 0 - DQRX to digital Monitor Port is
    // disabled; 1 - DQRX Flop outputs routed to Digital Monitor Port
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX dqrx2monport_en : 1;
  } Bits;
  UINTX Data;
} DIGOBSCTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXDLLCTL_DQBLDM_DQ_BOXTYPE_REG                     0x00000094
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[15:0], RO, default = 0x0
    //
    UINTX reserved : 16;
    //
    // Rx DLL enable
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX rxdll_bl_rxdllen : 1;
    //
    // Reserved bits
    //
    // Bits[17:17], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // enable strobe output from rx sdll.for each byte
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX rxdll_bl_dqsouten : 1;
    //
    // Reserved bits
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // RxDLL flop reset
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX rxdll_dllfloprstb : 1;
    //
    // TxDLL flop reset
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX txdll_dllfloprstb : 1;
    //
    // Reserved bits
    //
    // Bits[23:22], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
    //
    // enable strobe output from rx sdll.for each byte
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX rxdll_rxmuxsel : 5;
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
    UINTX reserved_4 : 3;
  } Bits;
  UINTX Data;
} RXDLLCTL_DQBLDM_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXDLLCTL_CCBLDM_DQ_BOXTYPE_REG                     0x00000098
#ifndef ASM_INC
typedef union {
  struct {
    //
    // enable tx ref pi phase 0 enable
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX txdll_ref2xph0pien : 1;
    //
    // Reserved bits
    //
    // Bits[15:1], RO, default = 0x0
    //
    UINTX reserved : 15;
    //
    // Rx DLL enable
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX rxdll_cc_rxdllen : 1;
    //
    // Reserved bits
    //
    // Bits[17:17], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // enable strobe output from rx sdll.for each byte
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX rxdll_cc_dqsouten : 1;
    //
    // Reserved bits
    //
    // Bits[31:19], RO, default = 0x0
    //
    UINTX reserved_2 : 13;
  } Bits;
  UINTX Data;
} RXDLLCTL_CCBLDM_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLCTL_DQ_BOXTYPE_REG                            0x0000009C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved bits
    //
    // Bits[0:0], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // enable tx ref pi phase 90 enable
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX txdll_ref2xph90pien : 1;
    //
    // enable tx ref pi phase 180 enable
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX txdll_ref2xph180pien : 1;
    //
    // enable tx ref pi phase 270 enable
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX txdll_ref2xph270pien : 1;
    //
    // Reserved bits
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX reserved_1 : 4;
    //
    // PI enable for sig group 0 rank 0
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX txdll_siggrp00pien : 1;
    //
    // PI enable for sig group 1 rank 0
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX txdll_siggrp01pien : 1;
    //
    // PI enable for sig group 2 rank 0
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX txdll_siggrp02pien : 1;
    //
    // PI enable for sig group 3 rank 0
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX txdll_siggrp03pien : 1;
    //
    // PI enable for sig group 4 rank 0
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX txdll_siggrp04pien : 1;
    //
    // PI enable for sig group 5 rank 0
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX txdll_siggrp05pien : 1;
    //
    // Reserved bits
    //
    // Bits[15:14], RO, default = 0x0
    //
    UINTX reserved_2 : 2;
    //
    // MDLL enable
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX txdll_mdllen : 1;
    //
    // Reserved bits
    //
    // Bits[17:17], RO, default = 0x0
    //
    UINTX reserved_3 : 1;
    //
    // Reserved bits
    //
    // Bits[31:18], RO, default = 0x0
    //
    UINTX reserved_4 : 14;
  } Bits;
  UINTX Data;
} TXDLLCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLREF2XCTL_DQ_BOXTYPE_REG                       0x000000A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // pi code for ref pi phase 90 output
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX txdll_ref2xph90picode : 8;
    //
    // pi code for ref pi phase 180 output
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX txdll_ref2xph180picode : 8;
    //
    // pi code for ref pi phase 270 output
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX txdll_ref2xph270picode : 8;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved : 8;
  } Bits;
  UINTX Data;
} TXDLLREF2XCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXDLLDQSRK1CTL_DQ_BOXTYPE_REG                      0x000000A4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rank 1 pi code for rx falling dqs edge  - DQ 1/3 Lane
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX rxdll_cc_rk1dqslopicode : 8;
    //
    // Rank 1 pi code for rx rising dqs edge  - DQ 1/3 Lane
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX rxdll_cc_rk1dqshipicode : 8;
    //
    // Rank1 pi code for rx falling dqs edge - DQ 0/2 Lane
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX rxdll_bl_rk1dqslopicode : 8;
    //
    // Rank1 pi code for rx rising dqs edge - DQ 0/2 Lane
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX rxdll_bl_rk1dqshipicode : 8;
  } Bits;
  UINTX Data;
} RXDLLDQSRK1CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXDLLDQSRK0CTL_DQ_BOXTYPE_REG                      0x000000A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rank0 pi code for rx falling dqs edge  - DQ 1/3 Lane
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX rxdll_cc_rk0dqslopicode : 8;
    //
    // Rank0 pi code for rx rising dqs edge  - DQ 1/3 Lane
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX rxdll_cc_rk0dqshipicode : 8;
    //
    // Rank0 pi code for rx falling dqs edge  - DQ 0/2 Lane
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX rxdll_bl_rk0dqslopicode : 8;
    //
    // Rank0 pi code for rx rising dqs edge  - DQ 0/2 Lane
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX rxdll_bl_rk0dqshipicode : 8;
  } Bits;
  UINTX Data;
} RXDLLDQSRK0CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define VREFCTL1_DQ_BOXTYPE_REG                            0x000000AC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // enable signal for the tx vref unity gain buffer
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX txvref_cmn_vrefbufen : 1;
    //
    // Reserved bits
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} VREFCTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define VREFCTL0_DQ_BOXTYPE_REG                            0x000000B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // vref decode signal for the b1/3 rx vref
    //
    // Bits[7:0], RW, default = 0x20
    //
    UINTX vref_rxccvrefctrl : 8;
    //
    // vref decode signal for the b0/2 rx vref
    //
    // Bits[15:8], RW, default = 0x20
    //
    UINTX vref_rxblvrefctrl : 8;
    //
    // common mode select to choose between lpddr3;lpddr4
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX vref_vrefcmctrl : 2;
    //
    // Reserved bits
    //
    // Bits[19:18], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // vrefiobufact Reset control - DQ BL1
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX lvl_cc_vrefreset : 1;
    //
    // vrefiobufact Set control - DQ BL1
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX lvl_cc_vrefset : 1;
    //
    // vrefiobufact Reset control - DQ BL0
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX lvl_bl_vrefreset : 1;
    //
    // vrefiobufact Set control - DQ BL0
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX lvl_bl_vrefset : 1;
    //
    // vref decode signal for the lcomp
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX vref_txlcompvrefctrl : 8;
  } Bits;
  UINTX Data;
} VREFCTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXBL8PBDCTL1_DQ_BOXTYPE_REG                        0x000000B4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rx Per bit De-skew code for BL 1/3 dbi valid codes
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rxdll_cc_dq8rxpbdcode : 4;
    //
    // Reserved bits
    //
    // Bits[31:4], RO, default = 0x0
    //
    UINTX reserved : 28;
  } Bits;
  UINTX Data;
} RXBL8PBDCTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXPBDBLCTL1_DQ_BOXTYPE_REG                         0x000000B8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rx Per bit De-skew code for BL1/3  dq0 valid codes
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rxdll_cc_dq0rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL1/3  dq1 valid codes
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rxdll_cc_dq1rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL1/3  dq2 valid codes
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rxdll_cc_dq2rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL1/3  dq3 valid codes
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rxdll_cc_dq3rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL1/3  dq4 valid codes
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX rxdll_cc_dq4rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL1/3  dq5 valid codes
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX rxdll_cc_dq5rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL1/3  dq6 valid codes
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rxdll_cc_dq6rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL1/3  dq7 valid codes
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rxdll_cc_dq7rxpbdcode : 4;
  } Bits;
  UINTX Data;
} RXPBDBLCTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXBL8PBDCTL0_DQ_BOXTYPE_REG                        0x000000BC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rx Per bit De-skew code for BL 0/2 dbi valid codes
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rxdll_bl_dq8rxpbdcode : 4;
    //
    // Reserved bits
    //
    // Bits[31:4], RO, default = 0x0
    //
    UINTX reserved : 28;
  } Bits;
  UINTX Data;
} RXBL8PBDCTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXPBDBLCTL0_DQ_BOXTYPE_REG                         0x000000C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Rx Per bit De-skew code for BL0/2  dq0 valid codes
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rxdll_bl_dq0rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL0/2  dq1 valid codes
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rxdll_bl_dq1rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL0/2  dq2 valid codes
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rxdll_bl_dq2rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL0/2  dq3 valid codes
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rxdll_bl_dq3rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL0/2  dq4 valid codes
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX rxdll_bl_dq4rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL0/2  dq5 valid codes
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX rxdll_bl_dq5rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL0/2  dq6 valid codes
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rxdll_bl_dq6rxpbdcode : 4;
    //
    // Rx Per bit De-skew code for BL0/2  dq7 valid codes
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rxdll_bl_dq7rxpbdcode : 4;
  } Bits;
  UINTX Data;
} RXPBDBLCTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXPBDCTL1_DQ_BOXTYPE_REG                           0x000000C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Per bit deskew enable - DTX - BL 0/2
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX dtx_bl_pbdstaticlegen : 1;
    //
    // Per bit deskew enable - DTX - BL 1/3
    //
    // Bits[1:1], RW, default = 0x1
    //
    UINTX dtx_cc_pbdstaticlegen : 1;
    //
    // Per bit deskew enable - TX - BL 0/2
    //
    // Bits[2:2], RW, default = 0x1
    //
    UINTX tx_bl_pbdstaticlegen : 1;
    //
    // Per bit deskew enable - TX - BL 1/3
    //
    // Bits[3:3], RW, default = 0x1
    //
    UINTX tx_cc_pbdstaticlegen : 1;
    //
    // Reserved bits
    //
    // Bits[21:4], RO, default = 0x0
    //
    UINTX reserved : 18;
    //
    // Rx Per Bit De-skew enable for BL0/2 (1=enable, 0=disable)
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX rxdll_bl_rxpbden : 1;
    //
    // Rx Per Bit De-skew enable for BL1/3 (1=enable, 0=disable)
    //
    // Bits[23:23], RW, default = 0x0
    //
    UINTX rxdll_cc_rxpbden : 1;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved_1 : 8;
  } Bits;
  UINTX Data;
} TXPBDCTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXPBDBLCTL5_DQ_BOXTYPE_REG                         0x000000C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for BL0/2 DQS  valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX dtx_cc_dqspbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 DQSB  valid codes
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX dtx_cc_dqsbpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 DM valid codes
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX tx_ccdm_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:21], RO, default = 0x0
    //
    UINTX reserved_2 : 11;
  } Bits;
  UINTX Data;
} TXPBDBLCTL5_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXPBDBLCTL4_DQ_BOXTYPE_REG                         0x000000CC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for BL0/2 dq4 valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX tx_ccdq4_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq5 valid codes
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX tx_ccdq5_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq6 valid codes
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX tx_ccdq6_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_2 : 3;
    //
    // Tx Per Bit De-skew code for  BL0/2 dq7 valid codes
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX tx_ccdq7_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
    UINTX reserved_3 : 3;
  } Bits;
  UINTX Data;
} TXPBDBLCTL4_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXPBDBLCTL3_DQ_BOXTYPE_REG                         0x000000D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for BL0/2 dq0 valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX tx_ccdq0_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq1 valid codes
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX tx_ccdq1_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq2 valid codes
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX tx_ccdq2_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_2 : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq3 valid codes
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX tx_ccdq3_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
    UINTX reserved_3 : 3;
  } Bits;
  UINTX Data;
} TXPBDBLCTL3_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXPBDBLCTL2_DQ_BOXTYPE_REG                         0x000000D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for BL0/2 DQS  valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX dtx_bl_dqspbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 DQSB  valid codes
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX dtx_bl_dqsbpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 DM valid codes
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX tx_bldm_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:21], RO, default = 0x0
    //
    UINTX reserved_2 : 11;
  } Bits;
  UINTX Data;
} TXPBDBLCTL2_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXPBDBLCTL1_DQ_BOXTYPE_REG                         0x000000D8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for BL0/2 dq4 valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX tx_bldq4_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq5 valid codes
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX tx_bldq5_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq6 valid codes
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX tx_bldq6_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_2 : 3;
    //
    // Tx Per Bit De-skew code for  BL0/2 dq7 valid codes
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX tx_bldq7_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
    UINTX reserved_3 : 3;
  } Bits;
  UINTX Data;
} TXPBDBLCTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXPBDBLCTL0_DQ_BOXTYPE_REG                         0x000000DC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Tx Per Bit De-skew code for BL0/2 dq0 valid codes
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX tx_bldq0_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq1 valid codes
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX tx_bldq1_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq2 valid codes
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX tx_bldq2_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_2 : 3;
    //
    // Tx Per Bit De-skew code for BL0/2 dq3 valid codes
    //
    // Bits[28:24], RW, default = 0x0
    //
    UINTX tx_bldq3_txpbdcode : 5;
    //
    // Reserved bits
    //
    // Bits[31:29], RO, default = 0x0
    //
    UINTX reserved_3 : 3;
  } Bits;
  UINTX Data;
} TXPBDBLCTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define OFFSETCNCLCTRL3_DQ_BOXTYPE_REG                     0x000000E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rx_ccdm_ampoffset : 4;
    //
    // Offset cancellation code (DQS buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX drx_cc_ampoffset : 4;
    //
    // Offset cancellation enable for Rx (not used for cc)
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX rx_cc_ampoffseten : 1;
    //
    // Offset cancellation enable for Rx (not used for cc)
    //
    // Bits[9:9], RW, default = 0x1
    //
    UINTX drx_cc_ampoffseten : 1;
    //
    // Reserved bits
    //
    // Bits[31:10], RO, default = 0x0
    //
    UINTX reserved : 22;
  } Bits;
  UINTX Data;
} OFFSETCNCLCTRL3_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define OFFSETCNCLCTRL2_DQ_BOXTYPE_REG                     0x000000E4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rx_ccdq7_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rx_ccdq6_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rx_ccdq5_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rx_ccdq4_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX rx_ccdq3_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX rx_ccdq2_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rx_ccdq1_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rx_ccdq0_ampoffset : 4;
  } Bits;
  UINTX Data;
} OFFSETCNCLCTRL2_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define OFFSETCNCLCTRL1_DQ_BOXTYPE_REG                     0x000000E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rx_bldm_ampoffset : 4;
    //
    // Offset cancellation code (DQS buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX drx_bl_ampoffset : 4;
    //
    // DQ Offset cancellation enable for Rx (1=enable, 0=disable)
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX rx_bl_ampoffseten : 1;
    //
    // DQS Offset cancellation enable for Rx (1=enable, 0=disable)
    //
    // Bits[9:9], RW, default = 0x1
    //
    UINTX drx_bl_ampoffseten : 1;
    //
    // Reserved bits
    //
    // Bits[31:10], RO, default = 0x0
    //
    UINTX reserved : 22;
  } Bits;
  UINTX Data;
} OFFSETCNCLCTRL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define OFFSETCNCLCTRL0_DQ_BOXTYPE_REG                     0x000000EC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rx_bldq7_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX rx_bldq6_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX rx_bldq5_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX rx_bldq4_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX rx_bldq3_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX rx_bldq2_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX rx_bldq1_ampoffset : 4;
    //
    // Offset cancellation code (DM/DQ buffers)
    // 1111 -8
    // 1110 -7
    // 1101 -6
    // 1100 -5
    // 1011 -4
    // 1010 -3
    // 1001 -2
    // 1000 -1
    // 0000 +1
    // 0001 +2
    // 0010 +3
    // 0011 +4
    // 0100 +5
    // 0101 +6
    // 0110 +7
    // 0111 +8
    //
    // Bits[31:28], RW, default = 0x0
    //
    UINTX rx_bldq0_ampoffset : 4;
  } Bits;
  UINTX Data;
} OFFSETCNCLCTRL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CTLECTL4_DQ_BOXTYPE_REG                            0x000000F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DRX N Bias Control - BL
    //
    // Bits[1:0], RW, default = 0x0
    //
    UINTX drx_bl_nbiasctrl : 2;
    //
    // DRX Bias Command Control 00: Idle Mode Logic Disabled (LP3/4), Default Condition
    // (DDR3L)   01: Idle Mode Logic Enabled (LP3/4), Illegal Condition (DDR3L)   10:
    // Illegal Condition (ALL)   11: Illegal Condition (ALL)
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX drx_bl_casbiasctrl : 2;
    //
    // RX 2nd Stage Amp Fine Tune - BL1
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX rx_bl1_ampcombtune : 2;
    //
    // RX 1st Stage Amp CTLE Fine Tune - BL1
    //
    // Bits[7:6], RW, default = 0x0
    //
    UINTX rx_bl1_ctletune : 2;
    //
    // Reserved bits
    //
    // Bits[31:8], RO, default = 0x0
    //
    UINTX reserved : 24;
  } Bits;
  UINTX Data;
} CTLECTL4_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CTLECTL3_DQ_BOXTYPE_REG                            0x000000F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // cap tuning for DM BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[1:0], RW, default = 0x1
    //
    UINTX rx_ccdm_ctlecap : 2;
    //
    // resistor tuning for DM BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX rx_ccdm_ctleres : 2;
    //
    // bias control for DQ BL1/3 ctle amp
    // 00 2kΩ          0.25xnom
    // 01 1kΩ          0.4xnom
    // 10 0.5kΩ     1xnom
    // 11 0.25kΩ  1.7xnom
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX rx_cc_ctlebiasctrl : 2;
    //
    // Enable CTLE for DQ BL1/3 (1=enable, 0=disable)
    //
    // Bits[6:6], RW, default = 0x1
    //
    UINTX rx_cc_ctleen : 1;
    //
    // cap tuning;00 = 0.5pf;01 = 1pf;10 = 1.5pf;11 = 2pf for BL1/3
    //
    // Bits[8:7], RW, default = 0x1
    //
    UINTX drx_cc_ctlecap : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm for BL1/3
    //
    // Bits[10:9], RW, default = 0x0
    //
    UINTX drx_cc_ctleres : 2;
    //
    // DRX Bias Ctle Control - BL1/3
    //
    // Bits[13:11], RW, default = 0x0
    //
    UINTX drx_cc_ctlebiasctrl : 3;
    //
    // DRX N Bias Control - BL1/3
    //
    // Bits[15:14], RW, default = 0x0
    //
    UINTX drx_cc_nbiasctrl : 2;
    //
    // DRX Bias Command Control 00: Idle Mode Logic Disabled (LP3/4), Default Condition
    // (DDR3L)   01: Idle Mode Logic Enabled (LP3/4), Illegal Condition (DDR3L)   10:
    // Illegal Condition (ALL)   11: Illegal Condition (ALL)
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX drx_cc_casbiasctrl : 2;
    //
    // DRX Bias Enable - BL1/3
    //
    // Bits[18:18], RW, default = 0x1
    //
    UINTX drx_cc_biasen : 1;
    //
    // Enable CTLE for DQS BL1/3(1=enable, 0=disable)
    //
    // Bits[19:19], RW, default = 0x1
    //
    UINTX drx_cc_ctleen : 1;
    //
    // Reserved bits
    //
    // Bits[31:20], RO, default = 0x0
    //
    UINTX reserved : 12;
  } Bits;
  UINTX Data;
} CTLECTL3_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CTLECTL2_DQ_BOXTYPE_REG                            0x000000F8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // cap tuning for DQ7 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[1:0], RW, default = 0x1
    //
    UINTX rx_ccdq7_ctlecap : 2;
    //
    // cap tuning for DQ6 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[3:2], RW, default = 0x1
    //
    UINTX rx_ccdq6_ctlecap : 2;
    //
    // cap tuning for DQ5 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[5:4], RW, default = 0x1
    //
    UINTX rx_ccdq5_ctlecap : 2;
    //
    // cap tuning for DQ4 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[7:6], RW, default = 0x1
    //
    UINTX rx_ccdq4_ctlecap : 2;
    //
    // cap tuning for DQ3 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[9:8], RW, default = 0x1
    //
    UINTX rx_ccdq3_ctlecap : 2;
    //
    // cap tuning for DQ2 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[11:10], RW, default = 0x1
    //
    UINTX rx_ccdq2_ctlecap : 2;
    //
    // cap tuning for DQ1 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[13:12], RW, default = 0x1
    //
    UINTX rx_ccdq1_ctlecap : 2;
    //
    // cap tuning for DQ0 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[15:14], RW, default = 0x1
    //
    UINTX rx_ccdq0_ctlecap : 2;
    //
    // resistor tuning for DQ7 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX rx_ccdq7_ctleres : 2;
    //
    // resistor tuning for DQ6 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[19:18], RW, default = 0x0
    //
    UINTX rx_ccdq6_ctleres : 2;
    //
    // resistor tuning for DQ5 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[21:20], RW, default = 0x0
    //
    UINTX rx_ccdq5_ctleres : 2;
    //
    // resistor tuning for DQ4 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX rx_ccdq4_ctleres : 2;
    //
    // resistor tuning for DQ3 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX rx_ccdq3_ctleres : 2;
    //
    // resistor tuning for DQ2 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX rx_ccdq2_ctleres : 2;
    //
    // resistor tuning for DQ1 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX rx_ccdq1_ctleres : 2;
    //
    // resistor tuning for DQ0 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX rx_ccdq0_ctleres : 2;
  } Bits;
  UINTX Data;
} CTLECTL2_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CTLECTL1_DQ_BOXTYPE_REG                            0x000000FC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // cap tuning for DM BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[1:0], RW, default = 0x1
    //
    UINTX rx_bldm_ctlecap : 2;
    //
    // resistor tuning for DM BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[3:2], RW, default = 0x0
    //
    UINTX rx_bldm_ctleres : 2;
    //
    // bias control for ctle amp for DQ BL0/2
    // 00 2kΩ          0.25xnom
    // 01 1kΩ          0.4xnom
    // 10 0.5kΩ     1xnom
    // 11 0.25kΩ  1.7xnom
    //
    // Bits[5:4], RW, default = 0x0
    //
    UINTX rx_bl_ctlebiasctrl : 2;
    //
    // Enable CTLE for DQ BL0/2 (1=enable, 0=disable)
    //
    // Bits[6:6], RW, default = 0x1
    //
    UINTX rx_bl_ctleen : 1;
    //
    // DRX Bias Enable - BL0/2
    //
    // Bits[7:7], RW, default = 0x1
    //
    UINTX drx_bl_biasen : 1;
    //
    // cap tuning;00 = 0.5pf;01 = 1pf;10 = 1.5pf;11 = 2pf
    //
    // Bits[9:8], RW, default = 0x1
    //
    UINTX drx_bl_ctlecap : 2;
    //
    // resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[11:10], RW, default = 0x0
    //
    UINTX drx_bl_ctleres : 2;
    //
    // bias control for ctle amp
    // 00 2kΩ          0.25xnom
    // 01 1kΩ          0.4xnom
    // 10 0.5kΩ     1xnom
    // 11 0.25kΩ  1.7xnom
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX drx_bl_ctlebiasctrl : 3;
    //
    // Enable CTLE for DQS (1=enable, 0=disable)
    //
    // Bits[15:15], RW, default = 0x1
    //
    UINTX drx_bl_ctleen : 1;
    //
    // RX 2nd Stage Amp Fine Tune - BL0
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX rx_bl0_ampcombtune : 2;
    //
    // RX 1st Stage Amp CTLE Fine Tune - BL0
    //
    // Bits[19:18], RW, default = 0x0
    //
    UINTX rx_bl0_ctletune : 2;
    //
    // Reserved bits
    //
    // Bits[31:20], RO, default = 0x0
    //
    UINTX reserved : 12;
  } Bits;
  UINTX Data;
} CTLECTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define CTLECTL0_DQ_BOXTYPE_REG                            0x00000100
#ifndef ASM_INC
typedef union {
  struct {
    //
    // cap tuning for DQ7 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[1:0], RW, default = 0x1
    //
    UINTX rx_bldq7_ctlecap : 2;
    //
    // cap tuning for DQ6 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[3:2], RW, default = 0x1
    //
    UINTX rx_bldq6_ctlecap : 2;
    //
    // cap tuning for DQ5 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[5:4], RW, default = 0x1
    //
    UINTX rx_bldq5_ctlecap : 2;
    //
    // cap tuning for DQ4 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[7:6], RW, default = 0x1
    //
    UINTX rx_bldq4_ctlecap : 2;
    //
    // cap tuning for DQ3 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[9:8], RW, default = 0x1
    //
    UINTX rx_bldq3_ctlecap : 2;
    //
    // cap tuning for DQ2 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[11:10], RW, default = 0x1
    //
    UINTX rx_bldq2_ctlecap : 2;
    //
    // cap tuning for DQ1 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[13:12], RW, default = 0x1
    //
    UINTX rx_bldq1_ctlecap : 2;
    //
    // cap tuning for DQ0 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf
    //
    // Bits[15:14], RW, default = 0x1
    //
    UINTX rx_bldq0_ctlecap : 2;
    //
    // resistor tuning for DQ7 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[17:16], RW, default = 0x0
    //
    UINTX rx_bldq7_ctleres : 2;
    //
    // resistor tuning for DQ6 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[19:18], RW, default = 0x0
    //
    UINTX rx_bldq6_ctleres : 2;
    //
    // resistor tuning for DQ5 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[21:20], RW, default = 0x0
    //
    UINTX rx_bldq5_ctleres : 2;
    //
    // resistor tuning for DQ4 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX rx_bldq4_ctleres : 2;
    //
    // resistor tuning for DQ3 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX rx_bldq3_ctleres : 2;
    //
    // resistor tuning for DQ2 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[27:26], RW, default = 0x0
    //
    UINTX rx_bldq2_ctleres : 2;
    //
    // resistor tuning for DQ1 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[29:28], RW, default = 0x0
    //
    UINTX rx_bldq1_ctleres : 2;
    //
    // resistor tuning for DQ0 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX rx_bldq0_ctleres : 2;
  } Bits;
  UINTX Data;
} CTLECTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TCOCTL_DQCC_DQ_BOXTYPE_REG                         0x00000104
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQ TCO comp rise code - BL1/3 Lane
    //
    // Bits[4:0], RW, default = 0x1F
    //
    UINTX tx_cc_tcorise : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // DQ TCO comp fall code - BL1/3 Lane
    //
    // Bits[12:8], RW, default = 0x1F
    //
    UINTX tx_cc_tcofall : 5;
    //
    // Reserved bits
    //
    // Bits[14:13], RO, default = 0x0
    //
    UINTX reserved_1 : 2;
    //
    // TX TCO enable - BL1/3
    //
    // Bits[15:15], RW, default = 0x1
    //
    UINTX tx_cc_tcostaticlegen : 1;
    //
    // DQ TCO comp rise code - BL0/2
    //
    // Bits[20:16], RW, default = 0x1F
    //
    UINTX tx_bl_tcorise : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_2 : 3;
    //
    // DQ TCO comp fall code - BL0/2
    //
    // Bits[28:24], RW, default = 0x1F
    //
    UINTX tx_bl_tcofall : 5;
    //
    // Reserved bits
    //
    // Bits[30:29], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
    //
    // TX TCO enable - BL0/2
    //
    // Bits[31:31], RW, default = 0x1
    //
    UINTX tx_bl_tcostaticlegen : 1;
  } Bits;
  UINTX Data;
} TCOCTL_DQCC_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TCOCTL_DQ_DQ_BOXTYPE_REG                           0x00000108
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQS TCO comp rise code - BL0/2
    //
    // Bits[4:0], RW, default = 0x1F
    //
    UINTX dtx_bl_tcorisedqs : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // DQSB TCO comp rise code - BL0/2
    //
    // Bits[12:8], RW, default = 0x1F
    //
    UINTX dtx_bl_tcofalldqs : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // DQS TCO comp fall code - BL0/2
    //
    // Bits[20:16], RW, default = 0x1F
    //
    UINTX dtx_bl_tcorisedqsb : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_2 : 3;
    //
    // DQSB TCO comp fall code - BL0/2
    //
    // Bits[28:24], RW, default = 0x1F
    //
    UINTX dtx_bl_tcofalldqsb : 5;
    //
    // DTX TCO enable - BL0/2
    //
    // Bits[29:29], RW, default = 0x1
    //
    UINTX dtx_bl_tcostaticlegen : 1;
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
  } Bits;
  UINTX Data;
} TCOCTL_DQ_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TCOCTL_CC_DQ_BOXTYPE_REG                           0x0000010C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQS TCO comp rise code - BL1/3 Lane
    //
    // Bits[4:0], RW, default = 0x1F
    //
    UINTX dtx_cc_tcorisedqs : 5;
    //
    // Reserved bits
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // DQS TCO comp fall code - BL1/3 Lane
    //
    // Bits[12:8], RW, default = 0x1F
    //
    UINTX dtx_cc_tcofalldqs : 5;
    //
    // Reserved bits
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // DQSB TCO comp rise code - BL1/3 Lane
    //
    // Bits[20:16], RW, default = 0x1F
    //
    UINTX dtx_cc_tcorisedqsb : 5;
    //
    // Reserved bits
    //
    // Bits[23:21], RO, default = 0x0
    //
    UINTX reserved_2 : 3;
    //
    // DQSB TCO comp fall code - BL1/3 Lane
    //
    // Bits[28:24], RW, default = 0x1F
    //
    UINTX dtx_cc_tcofalldqsb : 5;
    //
    // DTX TCO enable - BL1/3
    //
    // Bits[29:29], RW, default = 0x1
    //
    UINTX dtx_cc_tcostaticlegen : 1;
    //
    // Reserved bits
    //
    // Bits[31:30], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
  } Bits;
  UINTX Data;
} TCOCTL_CC_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP6CTL_DQ_BOXTYPE_REG                     0x00000110
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Read pointer offset for sig group 6 rank 0
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp06rdptroffset : 5;
    //
    // Dead band select for sig grp 6 rank 0  - UNUSED FOR BXT-P
    //
    // Bits[6:5], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp06dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[15:7], RO, default = 0x0
    //
    UINTX reserved : 9;
    //
    // Read pointer offset for sig group 6 rank 1
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp06rdptroffset : 5;
    //
    // Dead band select for sig grp 6 rank 1  - UNUSED FOR BXT-P
    //
    // Bits[22:21], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp06dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:23], RO, default = 0x0
    //
    UINTX reserved_1 : 9;
  } Bits;
  UINTX Data;
} TXDLLSIGGRP6CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define TXDLLSIGGRP7CTL_DQ_BOXTYPE_REG                     0x00000114
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Read pointer offset for sig group 7 rank 0
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp07rdptroffset : 5;
    //
    // Dead band select for sig grp 7 rank 0  - UNUSED FOR BXT-P
    //
    // Bits[6:5], RW, default = 0x0
    //
    UINTX txdll_rk0siggrp07dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[15:7], RO, default = 0x0
    //
    UINTX reserved : 9;
    //
    // Read pointer offset for sig group 7 rank 1
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp07rdptroffset : 5;
    //
    // Dead band select for sig grp 7 rank 1  - UNUSED FOR BXT-P
    //
    // Bits[22:21], RW, default = 0x0
    //
    UINTX txdll_rk1siggrp07dbsel : 2;
    //
    // Reserved bits
    //
    // Bits[31:23], RO, default = 0x0
    //
    UINTX reserved_1 : 9;
  } Bits;
  UINTX Data;
} TXDLLSIGGRP7CTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define LDOCTL1_DQ_BOXTYPE_REG                             0x00000118
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Read pointer offset for second port for LDO integration - DQ - RK0.
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX cc_rk0dqsdrvsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQ - RK1.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX cc_rk1dqsdrvsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQ - RK0.
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX cc_rk0dqsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQ - RK1.
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX cc_rk1dqsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQDMDRV - RK0.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX cc_rk0dqdrvsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQDMDRV - RK1.
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX cc_rk1dqdrvsecondrdportref2xrdptroffset : 4;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved : 8;
  } Bits;
  UINTX Data;
} LDOCTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define LDOCTL0_DQ_BOXTYPE_REG                             0x0000011C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Read pointer offset for second port for LDO integration - DQ - RK0.
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX bl_rk0dqsdrvsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQ - RK1.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX bl_rk1dqsdrvsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQ - RK0.
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX bl_rk0dqsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQ - RK1.
    //
    // Bits[15:12], RW, default = 0x0
    //
    UINTX bl_rk1dqsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQDMDRV - RK0.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX bl_rk0dqdrvsecondrdportref2xrdptroffset : 4;
    //
    // Read pointer offset for second port for LDO integration - DQDMDRV - RK1.
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX bl_rk1dqdrvsecondrdportref2xrdptroffset : 4;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved : 8;
  } Bits;
  UINTX Data;
} LDOCTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define PTDATAMUXSEL_DQ_BOXTYPE_REG                        0x00000120
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DRAM read data bit mux for DQ7.
    // This needs to be programmed based on the how DRAM data pins get swizzled at the
    // DRAM package.
    // 000:  Use DQ0
    // 001:  Use DQ1
    // 010:  Use DQ2
    // 011:  Use DQ3
    // 100:  Use DQ4
    // 101:  Use DQ5
    // 110:  Use DQ6
    // 111:  Use DQ7
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX data7sel : 3;
    //
    // DRAM read data bit mux for DQ6.
    // This needs to be programmed based on the how DRAM data pins get swizzled at the
    // DRAM package.
    // 000:  Use DQ0
    // 001:  Use DQ1
    // 010:  Use DQ2
    // 011:  Use DQ3
    // 100:  Use DQ4
    // 101:  Use DQ5
    // 110:  Use DQ6
    // 111:  Use DQ7
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX data6sel : 3;
    //
    // DRAM read data bit mux for DQ5.
    // This needs to be programmed based on the how DRAM data pins get swizzled at the
    // DRAM package.
    // 000:  Use DQ0
    // 001:  Use DQ1
    // 010:  Use DQ2
    // 011:  Use DQ3
    // 100:  Use DQ4
    // 101:  Use DQ5
    // 110:  Use DQ6
    // 111:  Use DQ7
    //
    // Bits[8:6], RW, default = 0x0
    //
    UINTX data5sel : 3;
    //
    // DRAM read data bit mux for DQ4.
    // This needs to be programmed based on the how DRAM data pins get swizzled at the
    // DRAM package.
    // 000:  Use DQ0
    // 001:  Use DQ1
    // 010:  Use DQ2
    // 011:  Use DQ3
    // 100:  Use DQ4
    // 101:  Use DQ5
    // 110:  Use DQ6
    // 111:  Use DQ7
    //
    // Bits[11:9], RW, default = 0x0
    //
    UINTX data4sel : 3;
    //
    // DRAM read data bit mux for DQ3.
    // This needs to be programmed based on the how DRAM data pins get swizzled at the
    // DRAM package.
    // 000:  Use DQ0
    // 001:  Use DQ1
    // 010:  Use DQ2
    // 011:  Use DQ3
    // 100:  Use DQ4
    // 101:  Use DQ5
    // 110:  Use DQ6
    // 111:  Use DQ7
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX data3sel : 3;
    //
    // DRAM read data bit mux for DQ2.
    // This needs to be programmed based on the how DRAM data pins get swizzled at the
    // DRAM package.
    // 000:  Use DQ0
    // 001:  Use DQ1
    // 010:  Use DQ2
    // 011:  Use DQ3
    // 100:  Use DQ4
    // 101:  Use DQ5
    // 110:  Use DQ6
    // 111:  Use DQ7
    //
    // Bits[17:15], RW, default = 0x0
    //
    UINTX data2sel : 3;
    //
    // DRAM read data bit mux for DQ1.
    // This needs to be programmed based on the how DRAM data pins get swizzled at the
    // DRAM package.
    // 000:  Use DQ0
    // 001:  Use DQ1
    // 010:  Use DQ2
    // 011:  Use DQ3
    // 100:  Use DQ4
    // 101:  Use DQ5
    // 110:  Use DQ6
    // 111:  Use DQ7
    //
    // Bits[20:18], RW, default = 0x0
    //
    UINTX data1sel : 3;
    //
    // DRAM read data bit mux for DQ0.
    // This needs to be programmed based on the how DRAM data pins get swizzled at the
    // DRAM package.
    // 000:  Use DQ0
    // 001:  Use DQ1
    // 010:  Use DQ2
    // 011:  Use DQ3
    // 100:  Use DQ4
    // 101:  Use DQ5
    // 110:  Use DQ6
    // 111:  Use DQ7
    //
    // Bits[23:21], RW, default = 0x0
    //
    UINTX data0sel : 3;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved : 8;
  } Bits;
  UINTX Data;
} PTDATAMUXSEL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define LPMODECTL0_DQ_BOXTYPE_REG                          0x00000124
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This indicates the delay in spidclk cycles for ref2xclk reset de-assertion, during
    // LP mode 2 exit
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX lpmode_dasrtref2xrstb_dly : 3;
    //
    // Reserved bits
    //
    // Bits[3:3], RO, default = 0x0
    //
    UINTX reserved : 1;
    //
    // Reserved bits
    //
    // Bits[6:4], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Reserved bits
    //
    // Bits[7:7], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // This indicates the delay in spidclk cycles for ref2xclk reset assertion, during
    // LP mode 2  entry
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX lpmode_asrtref2xrstb_dly : 3;
    //
    // Reserved bits
    //
    // Bits[11:11], RO, default = 0x0
    //
    UINTX reserved_3 : 1;
    //
    // This indicates the delay in spidclk cycles for write pointer disable, during LP
    // mode  2 entry
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX lpmode_dasrtwrptren_dly : 3;
    //
    // Reserved bits
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX reserved_4 : 1;
    //
    // This indicates the delay in spidclk cycles for IOBUFACT disable, during LP mode
    // 2  entry
    //
    // Bits[18:16], RW, default = 0x0
    //
    UINTX lpmode_dasrtiobufact_dly : 3;
    //
    // Reserved bits
    //
    // Bits[19:19], RO, default = 0x0
    //
    UINTX reserved_5 : 1;
    //
    // This indicates the delay in spidclk cycles for DQ/DQS driver enable, during LP
    // mode  1 exit
    //
    // Bits[22:20], RW, default = 0x0
    //
    UINTX lpmode_asrtdqcmddrvenb_dly : 3;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX reserved_6 : 1;
    //
    // This indicates the delay in spidclk cycles for DQ/DQS/CMD PI disable/enable, during
    // LP mode 1 entry/exit
    //
    // Bits[26:24], RW, default = 0x0
    //
    UINTX lpmode_asrtdqcmdsigpien_dly : 3;
    //
    // Reserved bits
    //
    // Bits[27:27], RO, default = 0x0
    //
    UINTX reserved_7 : 1;
    //
    // This indicates the delay in spidclk cycles for DQ/DQS driver disable, during LP
    // mode 1 entry
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX lpmode_dasrtdqcmddrvenb_dly : 3;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved_8 : 1;
  } Bits;
  UINTX Data;
} LPMODECTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define LPMODECTL1_DQ_BOXTYPE_REG                          0x00000128
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This indicates the delay in spidclk cycles for DLL enable, during LP mode 2 exit
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX lpmode_asrtref2xsigpien_dly : 8;
    //
    // Reserved bits
    //
    // Bits[15:8], RO, default = 0x0
    //
    UINTX reserved : 8;
    //
    // Override LP mode control for ref2xrstb
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX lpmode_ref2xrstbovrd : 1;
    //
    // Override LP mode control for write pointer enable
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX lpmode_wrptrenovrd : 1;
    //
    // Override LP mode control for signal PI enable
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX siggrpen_lpmode2or3ovrd : 1;
    //
    // Override LP mode control for signal PI enable
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX siggrpen_lpmode1ovrd : 1;
    //
    // Override LP mode control for ref2xclk enable
    //
    // Bits[20:20], RW, default = 0x0
    //
    UINTX lpmode_ref2xclkenovrd : 1;
    //
    // Override LP mode control for IOBUFACT
    //
    // Bits[21:21], RW, default = 0x0
    //
    UINTX lpmode_iobufactovrd : 1;
    //
    // Override LP mode control for DQ/DQS/CMD driver
    //
    // Bits[22:22], RW, default = 0x0
    //
    UINTX lpmode_dqcmddrvenbovrd : 1;
    //
    // Reserved bits
    //
    // Bits[23:23], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // This indicates the delay in spidclk cycles for IOBUFACT enable, during LP mode
    // 2 exit
    //
    // Bits[26:24], RW, default = 0x0
    //
    UINTX lpmode_asrtiobufact_dly : 3;
    //
    // Reserved bits
    //
    // Bits[27:27], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // This indicates the delay in spidclk cycles for write pointer enable, during LP
    // mode 2 exit
    //
    // Bits[30:28], RW, default = 0x0
    //
    UINTX lpmode_asrtwrptren_dly : 3;
    //
    // Reserved bits
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved_3 : 1;
  } Bits;
  UINTX Data;
} LPMODECTL1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define RXDLLRDCMDCTL0_DQ_BOXTYPE_REG                      0x0000012C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Read active length.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX rdactivelen : 6;
    //
    // Read command to active delay.
    //
    // Bits[11:6], RW, default = 0x0
    //
    UINTX rdcmd2rdactive : 6;
    //
    // RXDLL update enable.
    //
    // Bits[17:12], RW, default = 0x0
    //
    UINTX rxdllupdtlen : 6;
    //
    // Read command to RXDLL update.
    //
    // Bits[23:18], RW, default = 0x0
    //
    UINTX rdcmd2rxdllupdt : 6;
    //
    // Reserved bits
    //
    // Bits[31:24], RO, default = 0x0
    //
    UINTX reserved : 8;
  } Bits;
  UINTX Data;
} RXDLLRDCMDCTL0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_RESET_DQ_BOXTYPE_REG                       0x00000600
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Power-on or software reset0: reset state1: norma operationSet to 1 to enter normal
    // operation.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX dllcomprst_b : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} DLLCOMP_RESET_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_INIT_DQ_BOXTYPE_REG                        0x00000604
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Activates initialization training sequence.0: initialization training sequence
    // not active.1: initialization training sequence active.Self clearing after successful
    // initialization training sequence.
    //
    // Bits[0:0], RWS, default = 0x0
    //
    UINTX txdll_init : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} DLLCOMP_INIT_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_LPDDRTYPE_DQ_BOXTYPE_REG                   0x00000608
#ifndef ASM_INC
typedef union {
  struct {
    //
    // LPDDR speed target. 0: LPDDR3, 1600 MHz. 1: LPDDR4, 3200 MHz.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX lpddr_type : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} DLLCOMP_LPDDRTYPE_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_CLKUNGATE_DQ_BOXTYPE_REG                   0x0000060C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Internal Clock control. 0 = allow clock gating for low power; 1 = allow free running
    // clock
    //
    // Bits[0:0], RW, default = 0x1
    //
    UINTX clkungate : 1;
    //
    // Reserved
    //
    // Bits[31:1], RO, default = 0x0
    //
    UINTX reserved : 31;
  } Bits;
  UINTX Data;
} DLLCOMP_CLKUNGATE_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_ERROR_STATUS_DQ_BOXTYPE_REG                0x00000610
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Set when Initialization sequence is successful. Cleared on a read or writing a
    // 0.
    //
    // Bits[0:0], RO/V, default = 0x0
    //
    UINTX txdll_init_done : 1;
    //
    // Set when initialization or fine periodic training passed the locking condition.
    // Valid only when scr_lockseq_en is set to 1.Cleared on a read or writing a 0.
    //
    // Bits[1:1], RO/V, default = 0x0
    //
    UINTX txdll_lock_flag : 1;
    //
    // Reserved
    //
    // Bits[3:2], RO, default = 0x0
    //
    UINTX reserved : 2;
    //
    // Set when Delay Cell count exceeds maximum value. Cleared on a read or writing
    // a 0.
    //
    // Bits[4:4], RO/V, default = 0x0
    //
    UINTX txdll_error : 1;
    //
    // Set when coarse code underflow or overflow occurs. Cleared on a read or writing
    // a 0.
    //
    // Bits[5:5], RO/V, default = 0x0
    //
    UINTX txdll_coarsep_error : 1;
    //
    // Set when fine code underflow or overflow occurs. Cleared on a read or writing
    // a 0.
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX txdll_fine_error : 1;
    //
    // Set when initialization or fine periodic training failed the locking condition.
    // Cleared on a read or writing a 0.
    //
    // Bits[7:7], RO/V, default = 0x0
    //
    UINTX txdll_lock_error : 1;
    //
    // Reserved
    //
    // Bits[31:8], RO, default = 0x0
    //
    UINTX reserved_1 : 24;
  } Bits;
  UINTX Data;
} DLLCOMP_ERROR_STATUS_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_CODE_STATUS_DQ_BOXTYPE_REG                 0x00000614
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Fine code value during normal operation
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX txdll_stat_finecode : 8;
    //
    // Coarse code value during normal operation
    //
    // Bits[11:8], RO/V, default = 0x0
    //
    UINTX txdll_stat_coarsecode : 4;
    //
    // Coarse code value at initialization training sequence completion.
    //
    // Bits[15:12], RO/V, default = 0x0
    //
    UINTX txdll_stat_coarseicode : 4;
    //
    // Delay Cell count value during normal operation
    //
    // Bits[20:16], RO/V, default = 0x0
    //
    UINTX txdll_stat_fbmuxsel : 5;
    //
    // Reserved
    //
    // Bits[31:21], RO, default = 0x0
    //
    UINTX reserved : 11;
  } Bits;
  UINTX Data;
} DLLCOMP_CODE_STATUS_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_LOCKCTL_DQ_BOXTYPE_REG                     0x00000618
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Maximum samples to count for lock condition. The counter decrements until the
    // value reaches 0 yielding scr_lockcount_size + 1 samples.
    //
    // Bits[3:0], RW, default = 0x3
    //
    UINTX lockcount_size : 4;
    //
    // Reserved
    //
    // Bits[29:4], RO, default = 0x0
    //
    UINTX reserved : 26;
    //
    // Ignore lock error. Valid when scr_lockseq_en = 1. 0: Exit and wait for initialization
    // training sequence. 1: ignore lock error and proceed to normal operation.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX lockerror_ignore : 1;
    //
    // Enable lock sequence after initialization or fine periodic training sequence.
    // 0: disable lock sequence. 1: enable lock sequence.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX lock_seq_en : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_LOCKCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FBMUXSEL_DQ_BOXTYPE_REG                    0x0000061C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Delay cell minimum count value. Default start code.
    //
    // Bits[4:0], RW, default = 0x9
    //
    UINTX muxcode_min : 5;
    //
    // Reserved
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // Delay cell maximum count value. Used in overflow check
    //
    // Bits[12:8], RW, default = 0x0
    //
    UINTX muxcode_max : 5;
    //
    // Reserved
    //
    // Bits[15:13], RO, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Delay cell fbmuxsel override value.
    //
    // Bits[20:16], RW, default = 0x0
    //
    UINTX muxcode_ovr : 5;
    //
    // Reserved
    //
    // Bits[30:21], RO, default = 0x0
    //
    UINTX reserved_2 : 10;
    //
    // Override txdll_fbmuxsel[4:0] with scr_muxcode_ovr[4:0].0: disable override.1:
    // enable override.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX muxcode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_FBMUXSEL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_COARSECODE_DQ_BOXTYPE_REG                  0x00000620
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Coarse code minimum count value. Used in underflow check.
    //
    // Bits[3:0], RW, default = 0x2
    //
    UINTX coarsecode_min : 4;
    //
    // Reserved
    //
    // Bits[7:4], RO, default = 0x0
    //
    UINTX reserved : 4;
    //
    // Coarse code maximum count value. Default start value. Used in overflow check
    //
    // Bits[11:8], RW, default = 0x0
    //
    UINTX coarsecode_max : 4;
    //
    // Reserved
    //
    // Bits[15:12], RO, default = 0x0
    //
    UINTX reserved_1 : 4;
    //
    // Coarse code override value.
    //
    // Bits[19:16], RW, default = 0x0
    //
    UINTX coarsecode_ovr : 4;
    //
    // Reserved
    //
    // Bits[23:20], RO, default = 0x0
    //
    UINTX reserved_2 : 4;
    //
    // Coarsei code override value.
    //
    // Bits[27:24], RW, default = 0x0
    //
    UINTX coarseicode_ovr : 4;
    //
    // Reserved
    //
    // Bits[29:28], RO, default = 0x0
    //
    UINTX reserved_3 : 2;
    //
    // Override txdll_coarseicode[3:0] with scr_coarseicode_ovr[3:0]. 0: disable override,
    // 1: enable override
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX coarseicode_ovr_sel : 1;
    //
    // Override txdll_coarsecode[3:0] with scr_coarsecode_ovr[3:0]. 0: disable override,
    // 1: enable override
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX coarsecode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_COARSECODE_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FINECODE_DQ_BOXTYPE_REG                    0x00000624
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Underflow check during fine continuous or fine periodic training.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX finecode_min : 8;
    //
    // Fine code maximum value. Used in overflow check during fine continuous or fine
    // periodic
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX finecode_max : 8;
    //
    // Fine code limit - minimum value. Defines fine code drift allowed towards finecode
    // minimum value before decrementing the coarse code for binary search training.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX finecodemin_limit : 8;
    //
    // Fine code limit - maximum value. Defines fine code drift allowed towards finecode
    // maximum value before incrementing the coarse code for binary search training.
    //
    // Bits[31:24], RW, default = 0x0
    //
    UINTX finecodemax_limit : 8;
  } Bits;
  UINTX Data;
} DLLCOMP_FINECODE_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FINEMUXSEL_DQ_BOXTYPE_REG                  0x00000628
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Two bit field selects one of 4 possible finecode values for each 8:1 mux input.
    // Two bit field shared between -/+ index values (ex. -gf / +gf)
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX finecode_muxsel : 8;
    //
    // Reserved
    //
    // Bits[31:8], RO, default = 0x0
    //
    UINTX reserved : 24;
  } Bits;
  UINTX Data;
} DLLCOMP_FINEMUXSEL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FINECTL_DQ_BOXTYPE_REG                     0x0000062C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Fine code start value to apply during binary search training
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX finecode_start : 8;
    //
    // Reserved
    //
    // Bits[28:8], RO, default = 0x0
    //
    UINTX reserved : 21;
    //
    // Propriety search algorithm version to apply during lock, fine continuous and fine
    // periodic training. 0: Apply short version. 1: Apply long version.
    //
    // Bits[29:29], RW, default = 0x0
    //
    UINTX searchalgo_long : 1;
    //
    // Fine priodic training enable after initialization training. 0: Fine periodic disable
    // (default). 1: Fine periodic enable. When both finec_mode and finep_mode are set
    // to 1, dllcomp functionality is unpredictable.
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX finep_mode : 1;
    //
    // Fine continuous training enable after initialization training. 0: Fine continuous
    // training disable. 1: Fine continuous training enable (default). When both finec_mode
    // and finep_mode are set to 1, dllcomp functionality is unpredictable.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX finec_mode : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_FINECTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FINECODEOVR_DQ_BOXTYPE_REG                 0x00000630
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Fine code to override with when scr_finecode_ovr_sel = 1
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX finecode_ovr : 8;
    //
    // Reserved
    //
    // Bits[29:8], RO, default = 0x0
    //
    UINTX reserved : 22;
    //
    // When scr_finecode_ovr_sel is active high, this bit drives txdll_dllupdateovr
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX finecode_updateovr_ovr : 1;
    //
    // Fine code override select. 0: Apply computed fine code (default). 1: Apply scr_finecode_ovr[7:0]
    // .
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX finecode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_FINECODEOVR_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_FPTIMER_DQ_BOXTYPE_REG                     0x00000634
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Fine periodic interval timer start value. Defines the interval between back to
    // back fine periodic training sequences.
    //
    // Bits[15:0], RW, default = 0x0
    //
    UINTX finepwait_interval : 16;
    //
    // Reserved
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX reserved : 16;
  } Bits;
  UINTX Data;
} DLLCOMP_FPTIMER_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_SAMPLEWAIT_DQ_BOXTYPE_REG                  0x00000638
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Wait interval between code update and sample ready. Applied during coarse initialization
    // and fine
    //
    // Bits[4:0], RW, default = 0x2
    //
    UINTX samplewait_min : 5;
    //
    // Reserved
    //
    // Bits[7:5], RO, default = 0x0
    //
    UINTX reserved : 3;
    //
    // Wait interval between code update and sample ready. Applied during lock, fine
    // continuous and fine
    //
    // Bits[12:8], RW, default = 0x6
    //
    UINTX samplewait_max : 5;
    //
    // Reserved
    //
    // Bits[31:13], RO, default = 0x0
    //
    UINTX reserved_1 : 19;
  } Bits;
  UINTX Data;
} DLLCOMP_SAMPLEWAIT_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_RXCOARSEOVR_DQ_BOXTYPE_REG                 0x0000063C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Coarse code override value for rxdll_coarsecode[3:0]
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX rxdll_coarsecode_ovr : 4;
    //
    // Reserved
    //
    // Bits[30:4], RO, default = 0x0
    //
    UINTX reserved : 27;
    //
    // Override rxdll_coarsecode[3:0] with scr_rxdll_coarsecode_ovr[3:0] . 0: disable
    // override. 1: enable override.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX rxdll_coarsecode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_RXCOARSEOVR_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DLLCOMP_RXFINEOVR_DQ_BOXTYPE_REG                   0x00000640
#ifndef ASM_INC
typedef union {
  struct {
    //
    // FIne code override value for rxdll_finecode[7:0]
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX rxdll_finecode_ovr : 8;
    //
    // Reserved
    //
    // Bits[29:8], RO, default = 0x0
    //
    UINTX reserved : 22;
    //
    // When scr_rxdll_finecode_ovr_sel is active high, this bit drives rxdll_rxdqsdllupdateovr
    //
    // Bits[30:30], RW, default = 0x0
    //
    UINTX rxdll_finecode_updateovr_ovr : 1;
    //
    // Override rxdll_finecode[7:0] with scr_rxdll_finecode_ovr[7:0] . 0: disable override.
    // 1: enable override.
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX rxdll_finecode_ovr_sel : 1;
  } Bits;
  UINTX Data;
} DLLCOMP_RXFINEOVR_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM0PATTGEN_DQ_BOXTYPE_REG                 0x00000700
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Pattern Generation
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm0pattgen_lsb : 4;
    //
    // VISA Pattern Generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX dfxvisa_ulm0pattgen_msb : 3;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved : 25;
  } Bits;
  UINTX Data;
} DFXVISA_ULM0PATTGEN_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM0LN0_DQ_BOXTYPE_REG                     0x00000704
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM0LN0 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm0ln0_datasel : 8;
    //
    // VISA ULM0LN0 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxvisa_ulm0ln0_clksel : 8;
    //
    // VISA Bypass ULM0LN0
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxvisa_ulm0ln0_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} DFXVISA_ULM0LN0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM0LN1_DQ_BOXTYPE_REG                     0x00000708
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM0LN1 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm0ln1_datasel : 8;
    //
    // VISA ULM0LN1 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxvisa_ulm0ln1_clksel : 8;
    //
    // VISA Bypass ULM0LN1
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxvisa_ulm0ln1_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} DFXVISA_ULM0LN1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM1PATTGEN_DQ_BOXTYPE_REG                 0x0000070C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Pattern Generation
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm1pattgen_lsb : 4;
    //
    // VISA Pattern Generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX dfxvisa_ulm1pattgen_msb : 3;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved : 25;
  } Bits;
  UINTX Data;
} DFXVISA_ULM1PATTGEN_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM1LN0_DQ_BOXTYPE_REG                     0x00000710
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM1LN0 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm1ln0_datasel : 8;
    //
    // VISA ULM1LN0 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxvisa_ulm1ln0_clksel : 8;
    //
    // VISA Bypass ULM1LN0
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxvisa_ulm1ln0_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} DFXVISA_ULM1LN0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM1LN1_DQ_BOXTYPE_REG                     0x00000714
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM1LN1 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm1ln1_datasel : 8;
    //
    // VISA ULM1LN1 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxvisa_ulm1ln1_clksel : 8;
    //
    // VISA Bypass ULM1LN1
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxvisa_ulm1ln1_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} DFXVISA_ULM1LN1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM2PATTGEN_DQ_BOXTYPE_REG                 0x00000718
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Pattern Generation
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm2pattgen_lsb : 4;
    //
    // VISA Pattern Generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX dfxvisa_ulm2pattgen_msb : 3;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved : 25;
  } Bits;
  UINTX Data;
} DFXVISA_ULM2PATTGEN_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM2LN0_DQ_BOXTYPE_REG                     0x0000071C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM2LN0 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm2ln0_datasel : 8;
    //
    // VISA ULM2LN0 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxvisa_ulm2ln0_clksel : 8;
    //
    // VISA Bypass ULM2LN0
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxvisa_ulm2ln0_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} DFXVISA_ULM2LN0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM2LN1_DQ_BOXTYPE_REG                     0x00000720
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM2LN1 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm2ln1_datasel : 8;
    //
    // VISA ULM2LN1 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxvisa_ulm2ln1_clksel : 8;
    //
    // VISA Bypass ULM2LN1
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxvisa_ulm2ln1_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} DFXVISA_ULM2LN1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM3PATTGEN_DQ_BOXTYPE_REG                 0x00000724
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA Pattern Generation
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm3pattgen_lsb : 4;
    //
    // VISA Pattern Generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX dfxvisa_ulm3pattgen_msb : 3;
    //
    // Reserved
    //
    // Bits[31:7], RO, default = 0x0
    //
    UINTX reserved : 25;
  } Bits;
  UINTX Data;
} DFXVISA_ULM3PATTGEN_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM3LN0_DQ_BOXTYPE_REG                     0x00000728
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM3LN0 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm3ln0_datasel : 8;
    //
    // VISA ULM3LN0 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxvisa_ulm3ln0_clksel : 8;
    //
    // VISA Bypass ULM3LN0
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxvisa_ulm3ln0_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} DFXVISA_ULM3LN0_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXVISA_ULM3LN1_DQ_BOXTYPE_REG                     0x0000072C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // VISA ULM3LN1 (DATA) Select
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX dfxvisa_ulm3ln1_datasel : 8;
    //
    // VISA ULM3LN1 CLK Select
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX dfxvisa_ulm3ln1_clksel : 8;
    //
    // VISA Bypass ULM3LN1
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX dfxvisa_ulm3ln1_bypass : 1;
    //
    // Reserved
    //
    // Bits[31:17], RO, default = 0x0
    //
    UINTX reserved : 15;
  } Bits;
  UINTX Data;
} DFXVISA_ULM3LN1_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXMRG_BL_DQ_BOXTYPE_REG                           0x00000730
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase3 Fall Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 3 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdfall_ph3 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase2 Fall Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 2 Fall SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdfall_ph2 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase1 Fall Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 1 Fall SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdfall_ph1 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase0 Fall Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 0 Fall SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdfall_ph0 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase1 Rise Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 3 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdrise_ph3 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase0 Rise Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 2 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdrise_ph2 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase1 Rise Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 1 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdrise_ph1 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQ Phase0 Rise Tx SubFIFO load value. The value
    // loaded will apply to all DQ BL Phase 0 Rise SubFIFOs  There isnt a valid or invalid
    // value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdrise_ph0 : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQS/B Fall Tx SubFIFO data load value. The value
    // loaded will apply to all DQ Bytelane DQS/B Fall SubFIFOs. Recommended setting
    // for HVM = 2'b00
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdqsfall : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode DQS/B Rise Tx SubFIFO data load value. The value
    // loaded will apply to all DQ Bytelane DQS/B Rise SubFIFOs. Recommended setting
    // for HVM = 2'b00
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxdqsrise : 1;
    //
    // DQ Bytelane TxFIFO Margin Mode Latch enable override value used to make TxFIFO
    // latches transparent allowing the loading of all TxFIFO Latches with data programmed
    // in DFXMRGTXFIFO[23:0], if dfxmrgtxovren is asserted(1'b1)  1'b1 - All DQ/DM/DQS
    // Tx FIFO Latches Transparent  0'b0 - All DQ/DM/DQS TxFIFO Latches CLosed
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxwren : 1;
    //
    // DQ Bytelane Tx FIFO Margin Mode config override enable for Tx data path and Latch
    // enables via  DFXMRGTXFIFO[24:0]    1'b1  - Enable TxFIFO DFx overrides on Latch
    // enables and TxData  1'b0 - Functional Mode of operation
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX bl_dfxmrgtxovren : 1;
    //
    // Reserved bits
    //
    // Bits[31:12], RO, default = 0x0
    //
    UINTX reserved : 20;
  } Bits;
  UINTX Data;
} DFXMRG_BL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXMRG_CC_DQ_BOXTYPE_REG                           0x00000734
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase3 SDR Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 3 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdsdr_ph3 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase2 SDR Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 2 SDR SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b11
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdsdr_ph2 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 SDR Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 1 SDR SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdsdr_ph1 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 SDR Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 0 SDR SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdsdr_ph0 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase3 Fall Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 3 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdfall_ph3 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase2 Fall Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 2 Fall SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdfall_ph2 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 Fall Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 1 Fall SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdfall_ph1 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 Fall Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 0 Fall SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdfall_ph0 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 Rise Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 3 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdrise_ph3 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 Rise Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 2 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdrise_ph2 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 Rise Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 1 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdrise_ph1 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 Rise Tx SubFIFO load value. The
    // value loaded will apply to all DQCCC BL Phase 0 Rise SubFIFOs  There isnt a valid
    // or invalid value for this field, recommended setting for HVM = 2'b00
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdrise_ph0 : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCCS/B Fall Tx SubFIFO data load value. The
    // value loaded will apply to all DQCCC Bytelane DQCCCS/B Fall SubFIFOs. Recommended
    // setting for HVM = 2'b00
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdqsfall : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode DQCCCS/B Rise Tx SubFIFO data load value. The
    // value loaded will apply to all DQCCC Bytelane DQCCCS/B Rise SubFIFOs. Recommended
    // setting for HVM = 2'b00
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxdqsrise : 1;
    //
    // DQCCC Bytelane TxFIFO Margin Mode Latch enable override value used to make TxFIFO
    // latches transparent allowing the loading of all TxFIFO Latches with data programmed
    // in DFXMRGTXFIFO[23:0], if dfxmrgtxovren is asserted(1'b1)  1'b1 - All DQCCC/DM/DQCCCS
    // Tx FIFO Latches Transparent  0'b0 - All DQCCC/DM/DQCCCS TxFIFO Latches CLosed
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxwren : 1;
    //
    // DQCCC Bytelane Tx FIFO Margin Mode config override enable for Tx data path and
    // Latch enables via  DFXMRGTXFIFO[24:0]    1'b1  - Enable TxFIFO DFx overrides on
    // Latch enables and TxData  1'b0 - Functional Mode of operation
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX cc_dfxmrgtxovren : 1;
    //
    // Reserved bits
    //
    // Bits[31:16], RO, default = 0x0
    //
    UINTX reserved : 16;
  } Bits;
  UINTX Data;
} DFXMRG_CC_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXMRG_BLRX_DQ_BOXTYPE_REG                         0x00000738
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DFx Margin Mode DQ Bytelane Rx Compare value; Used to compare Actual RxFIFO value
    // vs Expected Rx FIFO value(TxFIFO Unloaded)
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX bl_dfxmrgrx_cmpval : 8;
    //
    // Reserved bits
    //
    // Bits[31:8], RO, default = 0x0
    //
    UINTX reserved : 24;
  } Bits;
  UINTX Data;
} DFXMRG_BLRX_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define DFXMRG_CCRX_DQ_BOXTYPE_REG                         0x0000073C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // DFx Margin Mode CCC Bytelane Rx Compare value for SDR pins; Used to compare Actual
    // RxFIFO value vs Expected Rx FIFO value(TxFIFO Unloaded)
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX cc_dfxmrgrx_sdrcmpval : 8;
    //
    // DFx Margin Mode CCC Bytelane Rx Compare value for DDR pins; Used to compare Actual
    // RxFIFO value vs Expected Rx FIFO value(TxFIFO Unloaded)
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX cc_dfxmrgrx_ddrcmpval : 8;
    //
    // DFx Margin Mode SDR vs DDR Rx Compare Values
    //
    // Bits[24:16], RW, default = 0x0
    //
    UINTX cc_dfxmrgrx_sdrsel : 9;
    //
    // Reserved bits
    //
    // Bits[31:25], RO, default = 0x0
    //
    UINTX reserved : 7;
  } Bits;
  UINTX Data;
} DFXMRG_CCRX_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define U32_WRDQCTL_DQ_BOXTYPE_REG                         0x0000001C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This is the DQS configuration for first phase  - Bytelane 0[br](2'b01-dqs_hi_lo,2'b00-dqs_lo_lo,2'b11-dqs_hi_hi).
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} U32_WRDQCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define U32_WRDQSCTL_CC_DQ_BOXTYPE_REG                     0x00000020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Phase 1 - DQS Drive enable
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} U32_WRDQSCTL_CC_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define U32_WRDQSCTL_BL_DQ_BOXTYPE_REG                     0x00000024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Phase 1 - DQS Drive enable
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} U32_WRDQSCTL_BL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define U32_WKPUPPDNCTL_DQ_BOXTYPE_REG                     0x0000007C
#ifndef ASM_INC
typedef union {
  struct {
    //
    //
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} U32_WKPUPPDNCTL_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define U32_RXODTCTL_BL13_DQ_BOXTYPE_REG                   0x0000003C
#ifndef ASM_INC
typedef union {
  struct {
    //
    //
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} U32_RXODTCTL_BL13_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC

#define U32_RXODTCTL_DQ_DQ_BOXTYPE_REG                     0x00000040
#ifndef ASM_INC
typedef union {
  struct {
    //
    //
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} U32_RXODTCTL_DQ_DQ_BOXTYPE_STRUCT;
#endif // ASM_INC


#endif // _DQ_BOXTYPE_H_
