/** @file
  File name:    PUNIT_BOXTYPE.h
  Input File:   GLK_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in PUNIT_BOXTYPE.h, which is used for non-tool-generated
  data

  Includes register defines specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/
#ifndef _PUNIT_BOXTYPE_H_
#define _PUNIT_BOXTYPE_H_

#include "DataTypes.h"

#if USE_64_BIT_VARIABLES
#define UINTX UINT64
#else
#define UINTX UINT32
#endif

#define P_CR_THERMAL_MAILBOX_DATA0_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007000
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field contains the low 32 bits of data associated with specific commands.
    //
    // Bits[31:0], RW/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_MAILBOX_DATA0_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_THERMAL_MAILBOX_DATA1_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007004
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field contains the low 32 bits of data associated with specific commands.
    //
    // Bits[31:0], RW/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_MAILBOX_DATA1_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_THERMAL_MAILBOX_INTERFACE_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007008
#ifndef ASM_INC
typedef union {
  struct {
    //
    // For incoming requests (where run/busy=1), this field represents the command opcode.
    //  For responses (where run/busy=0), this field represents the response completion
    // code.  A completion code of 0b indicates passing, all other completion codes indicate
    // failure.  For detailed definition of services provided by this mailbox, please
    // see the full mailbox specification.
    //
    // Bits[7:0], RW/V, default = 0x0
    //
    UINTX command : 8;
    //
    // This field is used as an additional modifier to the command encoding for incoming
    // mailbox requests.  In thermal device mailbox responses, this field is always zero.
    //  The applicability of this additional parameter field is handled on a case by
    // case basis for the services supplied by this mailbox
    //
    // Bits[28:8], RW/V, default = 0x0
    //
    UINTX addr_cntl : 21;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:29], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // The run/busy control is used for managing the semaphore on the mailbox interface.
    //  Typical usage involves the following flow:
    //               [list]
    //               [*] Software waits for the interface run/busy bit to clear.
    //               [*] Software writes the mailbox data registers as appropriate for
    // this command.
    //               [*] Software writes a command encoding and sets the run/busy bit
    // in the interface register.
    //               [*] Software waits for the interface run/busy bit to clear to indicate
    // the command has been handled.
    //               [*] Software queries the completion code in the command field of
    // the interface register to ensure it passed (0b indicates pass)
    //               [/list]
    //
    //               Bit encoding for the run/busy:
    //               [list]
    //               [*] 0 = The thermal mailbox is idle or the last request has been
    // completed.  Software may initiate new requests.
    //               [*] 1 = The thermal mailbox is busy.  The thermal device is still
    // handling a request.  Writes to thermal mailbox are not allowed at this time.
    //               [/list]
    //
    //
    // Bits[31:31], RW/1S/V, default = 0x0
    //
    UINTX run_busy : 1;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_MAILBOX_INTERFACE_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_THERMAL_DEVICE_IRQ_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x0000700C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // IRQ vector number for the thermal / power device.  This field controls the event
    // vector issues to the IOAPIC.   It must be configured by BIOS for INTA support.
    //  Recommended setting for Broxton is 24 (18h)
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX irq : 8;
    //
    // Reserved
    //
    // Bits[30:8], RO, default = 0x0
    //
    UINTX reserved : 23;
    //
    // Used to lock P_CR_INTR_LAT_0_0_1_PCI.INTPIN.  BIOS should set this lock bit before
    // passing control to the OS
    //
    // Bits[31:31], RW/L, default = 0x0
    //
    UINTX lock : 1;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_DEVICE_IRQ_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PKG_THERM_INTERRUPT_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007010
#ifndef ASM_INC
typedef union {
  struct {
    //
    // When set, enables the generation of a thermal interrupt whenever the Thermal Threshold
    // 1 Temperature is crossed.  Interrupts are generated when the threshold is crossed
    // in either direction.  Interrupt destination is programmed in the TMBAR configuration
    // space.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX threshold1_int_enable : 1;
    //
    // When set, enables the generation of a thermal interrupt whenever the Thermal Threshold
    // 2 Temperature is crossed.  Interrupts are generated when the threshold is crossed
    // in either direction.  Interrupt destination is programmed in the TMBAR configuration
    // space.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX threshold2_int_enable : 1;
    //
    // Enable thermal interrupt generation when the processor has detected a critical
    // thermal event that requires immediate servicing.  This event is intended to be
    // an alert indicating thermal control failure and is an early warning of thermal
    // runaway.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX critical_thermal_int_enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[7:3], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 5;
    //
    // Thermal interrupt threshold temperature in degrees Celsius.  Described in a signed,
    // 2's complement format with the LSB representing 1'C resolution (S8.7.0).  E.g.,
    // a reading of 0x28 == 40'C.  This threshold is managed relative to the filtered
    // temperature.
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX threshold1_temp : 8;
    //
    // Thermal interrupt threshold temperature in degrees Celsius.  Described in a signed,
    // 2's complement format with the LSB representing 1'C resolution (S8.7.0).  E.g.,
    // a reading of 0x28 == 40'C.  This threshold is managed relative to the filtered
    // temperature.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX threshold2_temp : 8;
    //
    // Virtual Temperature thermal filter RC time constant.  Virtual temperature readings
    // are run through an RC filter before they are fed into status and interrupt generation.
    //  This filtering allows software smooth control of thermal responses to thermally
    // significant events.  The bits of this field describe parameters for a mathematical
    // equation for time window configuration.
    //               [p]This field is split into two sub-fields:[/p]
    //               [list]
    //               [*] x = bits[6:5]
    //               [*] y = bits[4:0]
    //               [/list]
    //               [p]Time window equation:[/p]
    //               [b]time_window = PACKAGE_POWER_SKU_UNIT.TIME_UNIT * ((1+x/4)^y)[/b]
    //
    // Bits[30:24], RW, default = 0x0
    //
    UINTX time_window : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:31], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
  } Bits;
  UINTX Data;
} P_CR_PKG_THERM_INTERRUPT_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PROCESSING_SYSTEM_FREQ_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007014
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum ratio for the image processing system. Units are 25MHz multiplied by the
    // ratio.
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX min_ratio : 8;
    //
    // Firmware-calculated efficient ratio for the image processing system. Units are
    // 25MHz multiplied by the ratio.
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX efficient_ratio : 8;
    //
    // Maximum ratio for the image processing system. Units are 25MHz multiplied by the
    // ratio.
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX max_ratio : 8;
    //
    // Last resolved ratio for the image processing system. Units are 25MHz multiplied
    // by the ratio. This value is updated dynamically whenever the processing system
    // frequency changes.
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_ratio : 8;
  } Bits;
  UINTX Data;
} P_CR_PROCESSING_SYSTEM_FREQ_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PKG_THERM_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x0000701C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Indicates that the current filtered temperature (bits 23:16 of this register)
    // is greater than or equal to the Threshold1 defined in the PKG_THERM_INTERRUPT
    // configuration register.
    //
    // Bits[0:0], RO/V, default = 0x0
    //
    UINTX threshold1_status : 1;
    //
    // Sticky log bit that indicates temperature has crossed the software programmable
    // thermal threshold1 in either falling or rising directions.
    //
    // Bits[1:1], RW/0C/V, default = 0x0
    //
    UINTX threshold1_log : 1;
    //
    // Indicates that the current filtered temperature (bits 23:16 of this register)
    // is greater than or equal to the Threshold2 defined in the PKG_THERM_INTERRUPT
    // configuration register.
    //
    // Bits[2:2], RO/V, default = 0x0
    //
    UINTX threshold2_status : 1;
    //
    // Sticky log bit that indicates temperature has crossed the software programmable
    // thermal threshold2 in either falling or rising directions.
    //
    // Bits[3:3], RW/0C/V, default = 0x0
    //
    UINTX threshold2_log : 1;
    //
    // Status bit indicating that the processor is operating outside of its thermal specification.
    // It is intended as an early warning of thermal runaway in the silicon and shutdown
    // is recommended.
    //
    // Bits[4:4], RO/V, default = 0x0
    //
    UINTX critical_thermal_event_status : 1;
    //
    // Sticky log bit indicating that the processor has operated out of its thermal specification
    // since the last time software cleared this bit. Set by hardware on a 0 to 1 transition
    // of Critical Thermal Event Status.
    //
    // Bits[5:5], RW/0C/V, default = 0x0
    //
    UINTX critical_thermal_event_log : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:6], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 10;
    //
    // Virtual maximum SOC temperature in degrees Celsius. Caculated as a maximum of
    // all on-die thermal sensor readings and filtered accoring to the time constant
    // described in the PKG_THERM_INTERRUPT register.  Data format is signed, 2's complement
    // with the LSB representing 1'C resolution (S8.7.0).
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX temperature : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:24], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 8;
  } Bits;
  UINTX Data;
} P_CR_PKG_THERM_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_MEM_MR4_TEMPERATURE_DEV0_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007020
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is updated after each read of Wide I/O DRAM MR4 Device Temperature
    // Status. Update rate is configured by BIOS.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX mr4_rank_0 : 3;
    //
    // Reserved
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX mr4_rank_1 : 3;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_0 : 26;
  } Bits;
  UINTX Data;
} P_CR_MEM_MR4_TEMPERATURE_DEV0_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_MEM_MR4_TEMPERATURE_DEV1_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007024
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is updated each read of LPDDR DRAM MR4 Device Temperature Status per
    // rank. Update rate is configured by BIOS.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX mr4_rank_0 : 3;
    //
    // This field is updated each read of LPDDR DRAM MR4 Device Temperature Status per
    // rank. Update rate is configured by BIOS.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX mr4_rank_1 : 3;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_0 : 26;
  } Bits;
  UINTX Data;
} P_CR_MEM_MR4_TEMPERATURE_DEV1_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_MEM_MR4_TEMPERATURE_DEV2_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007028
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is updated each read of LPDDR DRAM MR4 Device Temperature Status per
    // rank. Update rate is configured by BIOS.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX mr4_rank_0 : 3;
    //
    // This field is updated each read of LPDDR DRAM MR4 Device Temperature Status per
    // rank. Update rate is configured by BIOS.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX mr4_rank_1 : 3;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_0 : 26;
  } Bits;
  UINTX Data;
} P_CR_MEM_MR4_TEMPERATURE_DEV2_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_MCA_ERROR_SRC_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG  0x0000702C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Undefined - reserved for future use.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX reserved : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[28:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 21;
    //
    // Asserted by HW on MCERR assertion.
    //
    // Bits[29:29], RW/V, default = 0x0
    //
    UINTX mcerr : 1;
    //
    // Asserted by HW on IERR assertion.
    //
    // Bits[30:30], RW/V, default = 0x0
    //
    UINTX ierr : 1;
    //
    // Asserted by HW on IERR or MCERR assertion.
    //
    // Bits[31:31], RW/V, default = 0x0
    //
    UINTX caterr : 1;
  } Bits;
  UINTX Data;
} P_CR_MCA_ERROR_SRC_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_THERM_THRT_CTRL_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007030
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Configurable threshold of LPDDR memory MR4 value greater than or equal to which
    // thermal throttling is activated.  For the standard LPDDR DRAM that is only capable
    // up to Tcasemax of 85C this field should be configured to avoid DRAM to exceed
    // its Tcasemax spec.
    //              [list]
    //              [*] Memory MR4 >= Threshold = Enable thermal throttling
    //              [*] Memory MR4 < Threshold = Disable thermal throttling
    //              [/list]
    //
    //
    // Bits[2:0], RW/V, default = 0x0
    //
    UINTX fm_therm_thrt_threshold : 3;
    //
    // When set, throttling is activated if LPDDR memory MR4 value is greater than or
    // equal to THERM_THRT_THRESHOLD.  For the standard LPDDR DRAM that is only capable
    // up to Tcasemax of 85C this bit should be set to enable LPDDR throttling to keep
    // DRAM within its Tcasemax spec.
    //
    // Bits[3:3], RW/V, default = 0x0
    //
    UINTX fm_therm_thrt_enable : 1;
    //
    // Reserved
    //
    // Bits[6:4], RW/V, default = 0x0
    //
    UINTX nm_therm_thrt_threshold : 3;
    //
    // Reserved
    //
    // Bits[7:7], RW/V, default = 0x0
    //
    UINTX nm_therm_thrt_enable : 1;
    //
    // Configure memory throttling behavior.  Policies are defined as follows:
    //          [list]
    //          [*] 0 = Thermal throttling policy uses instanous MR4 status for THERM_THRT_THRESHOLD
    //          [*] 1 = Thermal throttling policy uses time filtered MR4 status for THERM_THRT_THRESHOLD.
    //  Filtering time constant is configured in the DDR_THERM_INTERRUPT register.
    //          [/list]
    //
    // Bits[8:8], RW/V, default = 0x0
    //
    UINTX mem_thrt_cfg : 1;
    //
    // When set, memory traffic is throttled if memory MR4 value >= THERM_THRT_THRESHOLD,
    // respectively.  Thermal throttling is achieved by applying memory bandwidth clips
    // in the memory subsystem.
    //
    // Bits[9:9], RW/V, default = 0x0
    //
    UINTX mem_thrt_enable : 1;
    //
    // RESERVED
    //
    // Bits[15:10], RO, default = 0x0
    //
    UINTX reserved_0 : 6;
    //
    // [p]Throttle level in %BW, in units of 1%.  Default = 0%. Input of 100 or higher
    // is clipped to 100%,
    //               NOTE: this field is ignored if DRAM_type is not DDR3L[/p]
    //
    // Bits[23:16], RW/V, default = 0x0
    //
    UINTX throttle_level : 8;
    //
    // [p]When set and DRAM_Type is DDR3L, SOC throttles memory traffic to level specified
    // in THRT_LVL
    //                 NOTE: This field is ignored if DRAM_Type is not DDR3L[/p]
    //
    // Bits[24:24], RW/V, default = 0x0
    //
    UINTX throttle_level_enable : 1;
    //
    // [p]This field is to allow platform software to request refresh rate for DDR3L[/p]
    //
    // Bits[25:25], RW/V, default = 0x0
    //
    UINTX ddr3l_refresh_rate : 1;
    //
    // RESERVED
    //
    // Bits[31:26], RO, default = 0x0
    //
    UINTX reserved_1 : 6;
  } Bits;
  UINTX Data;
} P_CR_DDR_THERM_THRT_CTRL_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_THERM_INTERRUPT_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007034
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Configurable memory threshold1 value for memory thermal interrupt generation
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX far_mem_mr4_threshold1 : 3;
    //
    // Enable thermal interrupt generation whenever the virtual maximum memory MR4 has
    // crossed THRESHOLD1.  Interrupts are triggered when the filtered MR4 temperature
    // crosses in both rising and falling directions.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX far_mem_mr4_threshold1_int_enable : 1;
    //
    // Configurable memory threshold2 value for memory thermal interrupt generation
    //
    // Bits[6:4], RW, default = 0x0
    //
    UINTX far_mem_mr4_threshold2 : 3;
    //
    // Enable thermal interrupt generation whenever the virtual maximum memory MR4 has
    // crossed THRESHOLD2.  Interrupts are triggered when the filtered MR4 temperature
    // crosses in both rising and falling directions.
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX far_mem_mr4_threshold2_int_enable : 1;
    //
    // Reserved
    //
    // Bits[10:8], RW, default = 0x0
    //
    UINTX near_mem_mr4_threshold1 : 3;
    //
    // Reserved
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX near_mem_mr4_threshold1_int_enable : 1;
    //
    // Reserved
    //
    // Bits[14:12], RW, default = 0x0
    //
    UINTX near_mem_mr4_threshold2 : 3;
    //
    // Reserved
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX near_mem_mr4_threshold2_int_enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[23:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 8;
    //
    // Virtual Temperature thermal filter RC time constant.  Virtual temperature readings
    // are run through an RC filter before they are fed into status and interrupt generation.
    //  This filtering allows software smooth control of thermal responses to thermally
    // significant events.  The bits of this field describe parameters for a mathematical
    // equation for time window configuration.
    //               [p]This field is split into two sub-fields:[/p]
    //               [list]
    //               [*] x = bits[6:5]
    //               [*] y = bits[4:0]
    //               [/list]
    //               [p]Time window equation:[/p]
    //               [b]time_window = PACKAGE_POWER_SKU_UNIT.TIME_UNIT * ((1+x/4)^y)[/b]
    //
    // Bits[30:24], RW, default = 0x0
    //
    UINTX time_window : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:31], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
  } Bits;
  UINTX Data;
} P_CR_DDR_THERM_INTERRUPT_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_THERM_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007038
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Status bit is set when the virtual maximum memory MR4 reading is greater than
    // or equal to THRESHOLD1.  It is cleared when temperature is less than THRESHOLD1
    //
    // Bits[0:0], RO/V, default = 0x0
    //
    UINTX far_mem_mr4_threshold1_status : 1;
    //
    // Indicates that the virtual maximum memory MR4 has crossed THRESHOLD1 since the
    // last time this register was cleared.  The bit is set when the threshold is crossed
    // in either direction.  Software may clear this bit.
    //
    // Bits[1:1], RW/0C/V, default = 0x0
    //
    UINTX far_mem_mr4_threshold1_log : 1;
    //
    // Status bit is set when the virtual maximum memory MR4 reading is greater than
    // or equal to THRESHOLD2.  It is cleared when temperature is less than THRESHOLD2
    //
    // Bits[2:2], RO/V, default = 0x0
    //
    UINTX far_mem_mr4_threshold2_status : 1;
    //
    // Indicates that the virtual maximum memory MR4 has crossed THRESHOLD2 since the
    // last time this register was cleared.  The bit is set when the threshold is crossed
    // in either direction.  Software may clear this bit.
    //
    // Bits[3:3], RW/0C/V, default = 0x0
    //
    UINTX far_mem_mr4_threshold2_log : 1;
    //
    // Reserved
    //
    // Bits[4:4], RO/V, default = 0x0
    //
    UINTX near_mem_mr4_threshold1_status : 1;
    //
    // Reserved
    //
    // Bits[5:5], RW/0C/V, default = 0x0
    //
    UINTX near_mem_mr4_threshold1_log : 1;
    //
    // Reserved
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX near_mem_mr4_threshold2_status : 1;
    //
    // Reserved
    //
    // Bits[7:7], RW/0C/V, default = 0x0
    //
    UINTX near_mem_mr4_threshold2_log : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[15:8], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 8;
    //
    // Virtual maximum memory MR4 reading.  Caculated as a maximum of all LPDDR memory
    // MR4 readingsand filtered accoring to the time constant described in DDR_THERM_INTERRUPT
    // register.
    //
    // Bits[18:16], RO/V, default = 0x0
    //
    UINTX far_mem_mr4 : 3;
    //
    // Reserved
    //
    // Bits[21:19], RO/V, default = 0x0
    //
    UINTX near_mem_mr4 : 3;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:22], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 10;
  } Bits;
  UINTX Data;
} P_CR_DDR_THERM_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_RAPL_LIMIT_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007040
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Power Limit[0] for DDR domain. UnitsWatts Format7.8 Resolution0.125W Range02047.875W.
    //
    // Bits[14:0], RW, default = 0x0
    //
    UINTX limit1_power : 15;
    //
    // Power Limit[0] enable bit for DDR domain.
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX limit1_enable : 1;
    //
    // Reserved
    //
    // Bits[16:16], RSV, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // The Tau Exponent.  See TIME_WINDOW_X for more information.
    //
    // Bits[21:17], RW, default = 0x0
    //
    UINTX limit1_time_window_y : 5;
    //
    // The time window for RAPL is expressed in a format called TAU.  TAU is specified
    // in a mantissa+exponent format.  This format is common across all RAPL interfaces
    // for TAU.
    //
    //       The format is specified with a 7 bit number that looks like:
    //          XXYYYYY   (2 bits of mantissa follwed by 5 exponent)
    //
    //       The time window corresponding to this config is calculated as:
    //          (1+ XXb / 4) * (2^YYYYYb)
    //
    //       The value that results from this math species the time window in units that
    // are defined in PACKAGE_POWER_SKU_UNIT.TIME_UNIT MSR.  On every server product
    // we have built, this value has been 976us, which we typically treat as 1ms.
    //
    //
    // Bits[23:22], RW, default = 0x0
    //
    UINTX limit1_time_window_x : 2;
    //
    // Reserved
    //
    // Bits[31:24], RSV, default = 0x0
    //
    UINTX reserved_1 : 8;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[62:32], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 31;
    //
    // When set this entire register becomes readonly. This bit will typically be set
    // by BIOS during boot.
    //
    // Bits[63:63], RW, default = 0x0
    //
    UINTX locked : 1;
  } Bits;
  UINTX Data;
} P_CR_DDR_RAPL_LIMIT_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007048
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Total Joules of energy consumed by all DIMMs.  Units are proportional to Joules
    // and are defined by PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX joules : 32;
  } Bits;
  UINTX Data;
} P_CR_DDR_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_DDR_RAPL_PERF_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x0000704C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Bandwidth throttle duration counter due to Memory RAPL.  Sum across all channels
    // in PACKAGE_POWER_SKU_UNIT_MSR.TIME_UNIT units. This data can serve as a proxy
    // for the potential performance impacts of RAPL on memory accesses.
    //
    // Bits[31:0], RW, default = 0x58F0
    //
    UINTX duration : 32;
  } Bits;
  UINTX Data;
} P_CR_DDR_RAPL_PERF_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_RAPL_PERF_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007050
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Time that any core in the IA domain is performance throttled below OS request
    // and below the base frequency (P1) because of power limits (PL1 or PL2).  Counts
    // in time units defined by PACKAGE_POWER_SKU_UNIT_MSR.TIME_UNIT
    //
    // Bits[31:0], RW, default = 0x0
    //
    UINTX counts : 32;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_RAPL_PERF_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PRIMARY_PLANE_TURBO_PLCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007054
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Performance priority Level for the IA Core (primary) power plane. A higher number
    // implies a higher priority.
    //
    // Bits[4:0], RW, default = 0x0
    //
    UINTX priptp : 5;
    //
    // Reserved
    //
    // Bits[31:5], RO, default = 0x0
    //
    UINTX reserved_0 : 27;
  } Bits;
  UINTX Data;
} P_CR_PRIMARY_PLANE_TURBO_PLCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_SECONDARY_PLANE_TURBO_PLCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007058
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Performance priority Level for the Graphics (secondary) power plane. A higher
    // number implies a higher priority.
    //
    // Bits[4:0], RW, default = 0x10
    //
    UINTX secptp : 5;
    //
    // Reserved
    //
    // Bits[31:5], RO, default = 0x0
    //
    UINTX reserved_0 : 27;
  } Bits;
  UINTX Data;
} P_CR_SECONDARY_PLANE_TURBO_PLCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PRIMARY_PLANE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x0000705C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [p]Contains an accumulated value of the energy consumed in the primary power plane.
    // To find the energy consumed in a given time window, sofwtare should subtract the
    // two energy readings.
    //                  Software will have to take care of counter wrapping around when
    // it overflows.[/p]
    //               [p]Units are proportional to Joules exact precsion is defined by
    // PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT[/p]
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_PRIMARY_PLANE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_SECONDARY_PLANE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007060
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [p]Contains an accumulated value of the energy consumed in the secondary power
    // plane. To find the energy consumed in a given time window, sofwtare should subtract
    // the two energy readings.
    //                  Software will have to take care of counter wrapping around when
    // it overflows.[/p]
    //               [p]Units are proportional to Joules exact precsion is defined by
    // PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT[/p]
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_SECONDARY_PLANE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_POWER_SKU_UNIT_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007068
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Used to define the units of power control registers such as PL1, PL2, PL3 and
    // PL4.   The actual unit value is calculated by 1 W / 2^PWR_UNIT.  The default value
    // of 8 corresponds to 3.9mW per bit.
    //
    // Bits[3:0], RW, default = 0x8
    //
    UINTX pwr_unit : 4;
    //
    // Reserved
    //
    // Bits[7:4], RSV, default = 0x0
    //
    UINTX reserved_0 : 4;
    //
    // Used to define the units of energy reporting registers such as PACKAGE_ENERGY_STATUS.
    //  The actual unit value is calculated by 1 J / 2^ENERGY_UNIT.  The default value
    // of 14 corresponds to ~61uJ per bit.
    //
    // Bits[12:8], RW, default = 0xE
    //
    UINTX energy_unit : 5;
    //
    // Reserved
    //
    // Bits[15:13], RSV, default = 0x0
    //
    UINTX reserved_1 : 3;
    //
    // Used for to define the time units in registers such as PL1, PL2, PL3 and PL4.
    //   The actual unit value is calculated by 1s / 2^TIME_UNIT.  The default value
    // of 10 corresponds to 0.977ms.
    //
    // Bits[19:16], RW, default = 0xA
    //
    UINTX time_unit : 4;
    //
    // Reserved
    //
    // Bits[23:20], RSV, default = 0x0
    //
    UINTX reserved_2 : 4;
    //
    // Used to define the units of amps in control registers such as VR_CURRENT_CONFIG.
    //  The actual unit value is calculated by 1A / 2^CURRENT_UNIT.  The default value
    // of 3 corresponds to 0.125A.
    //
    // Bits[27:24], RW, default = 0x3
    //
    UINTX current_unit : 4;
    //
    // Used to define the units of resistance for control registers that describe parameters
    // in ohms such as VR_CURRENT_CONFIG.  The actual unit value is calculated by 1mohm
    // / 2^RESISTANCE_UNIT.  The default value of 3 corresponds to 0.125mohm.
    //
    // Bits[31:28], RW, default = 0x3
    //
    UINTX resistance_unit : 4;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_POWER_SKU_UNIT_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x0000706C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [p]Contains accumulated energy consumed by the entire CPU. This counter will wrap
    // around and keep counting when the counter overflows.[/p]
    //               [p]Units are proportional to Joules exact precsion is defined by
    // PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT[/p]
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_ENERGY_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_GT_PERF_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007070
#ifndef ASM_INC
typedef union {
  struct {
    //
    // RP-State Voltage GT Target Voltage in U1.7 Volts
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX rp_state_voltage : 8;
    //
    // [p]Ratio of the current RP-state, in 16.6Mhz 1xclks. When the graphics engine
    // is in RC6, this field is zeroed out.[/p]
    //               [p]For BXT the Unslice and Slice run at the same ratio.[/p]
    //
    // Bits[16:8], RO/V, default = 0x0
    //
    UINTX rp_state_ratio_unslice : 9;
    //
    // [p]Ratio of the current RP-state, in 16.6Mhz 1xclks. When the graphics engine
    // is in RC6, this field is zeroed out.[/p]
    //               [p]For BXT the Unslice and Slice run at the same ratio.[/p]
    //
    // Bits[25:17], RO/V, default = 0x0
    //
    UINTX rp_state_ratio_slice : 9;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:26], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 6;
  } Bits;
  UINTX Data;
} P_CR_GT_PERF_STATUS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_TEMPERATURE_TARGET_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007074
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RSV, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Fan Temperature Target Offset a.k.a. TControl indicates the relative offset from
    // the the Thermal Monitor Trip Temperature at which fans should be engaged.
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX fan_temp_target_offset : 8;
    //
    // Tjmax a.k.a. Thermal Monitor activation temperature or Prochot Temperature.  This
    // is the maximum junction temperature at which thermal throttling aka thermal monitor
    // is activated.  This temperature is the maximum temperature at which the silicon
    // is capable of operating at.  All IA core digital thermal sensor readings are reported
    // as a relative nagative offset from this reference temperature, such that a readon
    // of zero implies the cores are running at this temperature.
    //
    // Bits[23:16], RO/V, default = 0x5A
    //
    UINTX ref_temp : 8;
    //
    // This field allows platform software to configure the temperature at which thermal
    // monitor engages to be lower than the manufacturing configured maximum constraint.
    //  This field is programmed in 1'C units.  E.g., if the default silicon configured
    // maximum temperature is 100'C and this field is configured to 10, then the silicon
    // will engage thermal throttling algorithms at 90'C
    //
    // Bits[30:24], RW, default = 0x0
    //
    UINTX tj_max_tcc_offset : 7;
    //
    // Reserved
    //
    // Bits[31:31], RSV, default = 0x0
    //
    UINTX reserved_1 : 1;
  } Bits;
  UINTX Data;
} P_CR_TEMPERATURE_TARGET_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_BIOS_RESET_CPL_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007078
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Set by BIOS to indicate that all power management configurations as part of reset
    // are complete.  This must include Punit patch load done as well as all relevant
    // Punit power management register and mailbox configurations done.  Once this bit
    // is set, Punit will allow normal power management to start.  Before setting this
    // bit, P-states and C-states support is disabled.  BIOS should wait before receiving
    // the Pcode Stage0 reset complete before proceeding with any further steps.
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX rst_cpl : 1;
    //
    // BIOS sets this bit when it has completed this stage, Pcode must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX rst_cpl1 : 1;
    //
    // BIOS sets this bit when it has completed this stage, Pcode must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX rst_cpl2 : 1;
    //
    // BIOS sets this bit when it has completed this stage, Pcode must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX rst_cpl3 : 1;
    //
    // BIOS sets this bit when it has completed this stage, Pcode must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[4:4], RW, default = 0x0
    //
    UINTX rst_cpl4 : 1;
    //
    // BIOS sets this bit when it has completed this stage, Pcode must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[5:5], RW, default = 0x0
    //
    UINTX rst_cpl5 : 1;
    //
    // BIOS sets this bit when it has completed this stage, Pcode must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[6:6], RW, default = 0x0
    //
    UINTX rst_cpl6 : 1;
    //
    // reset complete
    //
    // Bits[7:7], RW, default = 0x0
    //
    UINTX rst_cpl7 : 1;
    //
    // Pcode has completed its actions in response to Stage0 BIOS Reset complete.  Between
    // BIOS Stage0 complete and pcode Stage0 complete, pcode will apply all power savings
    // configurations to PCS and will set up C_STATE_LATENCY control MSR settings for
    // IRTL management.
    //
    // Bits[8:8], RO/V, default = 0x0
    //
    UINTX pcode_init_done : 1;
    //
    // Pcode sets this bit when it has completed this stage, BIOS must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[9:9], RO/V, default = 0x0
    //
    UINTX pcode_init_done1 : 1;
    //
    // Pcode sets this bit when it has completed this stage, BIOS must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[10:10], RO/V, default = 0x0
    //
    UINTX pcode_init_done2 : 1;
    //
    // Pcode sets this bit when it has completed this stage, BIOS must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[11:11], RO/V, default = 0x0
    //
    UINTX pcode_init_done3 : 1;
    //
    // Pcode sets this bit when it has completed this stage, BIOS must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[12:12], RO/V, default = 0x0
    //
    UINTX pcode_init_done4 : 1;
    //
    // Pcode sets this bit when it has completed this stage, BIOS must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[13:13], RO/V, default = 0x0
    //
    UINTX pcode_init_done5 : 1;
    //
    // Pcode sets this bit when it has completed this stage, BIOS must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[14:14], RO/V, default = 0x0
    //
    UINTX pcode_init_done6 : 1;
    //
    // Pcode sets this bit when it has completed this stage, BIOS must wait for this
    // bit to be set before proceeding to the next stage.  Stage validity is product-specific
    // and this stage may not be applicable to this product.
    //
    // Bits[15:15], RO/V, default = 0x0
    //
    UINTX pcode_init_done7 : 1;
    //
    // reserved
    //
    // Bits[31:16], RW, default = 0x0
    //
    UINTX reserved0 : 16;
  } Bits;
  UINTX Data;
} P_CR_BIOS_RESET_CPL_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_BIOS_MAILBOX_DATA_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007080
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field contains the data associated with specific commands.
    //
    // Bits[31:0], RW/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_BIOS_MAILBOX_DATA_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_BIOS_MAILBOX_INTERFACE_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007084
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field contains the SW request command or the PCODE response code depending
    // on the setting of RUN_BUSY.
    //
    // Bits[7:0], RW/V, default = 0x0
    //
    UINTX command : 8;
    //
    // This field is used to specify an additional parameter to extend the command when
    // needed.
    //
    // Bits[28:8], RW/V, default = 0x0
    //
    UINTX address : 21;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[30:29], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 2;
    //
    // SW may write to the two mailbox registers only when RUN_BUSY is clear(0). Setting
    // RUN_BUSY to 1 will pend a Fast Path event to Pcode. After setting this bit SW
    // will poll this bit until it is cleared.  PCODE will clear RUN_BUSY after updating
    // the mailbox registers with the result and error code.
    //
    // Bits[31:31], RW/1S/V, default = 0x0
    //
    UINTX run_busy : 1;
  } Bits;
  UINTX Data;
} P_CR_BIOS_MAILBOX_INTERFACE_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_CORE_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007088
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum supported ratio for the IA cores. Units are 100MHz multiplied by the ratio.
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX min_supported_freq : 8;
    //
    // Firmware-calculated efficient ratio for the IA cores. Units are 100MHz multiplied
    // by the ratio.
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX efficient_freq : 8;
    //
    // Maximum ratio for the IA cores. Units are 100MHz multiplied by the ratio.
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX max_supported_freq : 8;
    //
    // Last resolved ratio for the IA cores. Units are 100MHz multiplied by the ratio.
    // This value is updated dynamically whenever the IA core frequency changes.
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_freq : 8;
  } Bits;
  UINTX Data;
} P_CR_CORE_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_GRAPHICS_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x0000708C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Minimum supported ratio for the integrated graphics engine. Units are 50MHz multiplied
    // by the ratio.
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX min_supported_freq : 8;
    //
    // Firmware-calculated efficient ratio for the integrated graphics engine. Units
    // are 50MHz multiplied by the ratio.
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX efficient_freq : 8;
    //
    // Maximum supported ratio for the integrated graphics engine. Units are 50MHz multiplied
    // by the ratio.
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX max_supported_freq : 8;
    //
    // Last resolved ratio for the integrated graphics engine. Units are 50MHz multiplied
    // by the ratio. This value is updated dynamically whenever the graphics engine frequency
    // changes.
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_freq : 8;
  } Bits;
  UINTX Data;
} P_CR_GRAPHICS_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_SYSTEM_AGENT_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007090
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Reserved
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX reserved_1 : 8;
    //
    // Reserved
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX reserved_2 : 8;
    //
    // Last resolved System Agent ratio, in units of 16.666MHz.
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_ratio : 8;
  } Bits;
  UINTX Data;
} P_CR_SYSTEM_AGENT_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_FAR_MEMORY_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007094
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Reserved
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX reserved_1 : 8;
    //
    // Reserved
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX reserved_2 : 8;
    //
    // This field reports out the LPDDR memory frequency in integer multiple of 133.33MHz.
    //  This register reflects what BIOS has programmed as the default LPDDR frequency
    // in products that do not support run-time memory frequency control.  For products
    // supporting run-time memory frequency control, this field describes the last resolved
    // frequency.
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_ratio : 8;
  } Bits;
  UINTX Data;
} P_CR_FAR_MEMORY_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_NEAR_MEMORY_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007098
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Reserved
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Reserved
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX reserved_1 : 8;
    //
    // Reserved
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX reserved_2 : 8;
    //
    // This field reports out the Wide I/O near memory frequency in integer multiple
    // of 133.33MHz.  This register reflects what BIOS has programmed as the default
    // Wide I/O near memory frequency in products that do not support run-time memory
    // frequency control.  For products supporting run-time memory frequency control,
    // this field describes the last resolved frequency.
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX last_resolved_ratio : 8;
  } Bits;
  UINTX Data;
} P_CR_NEAR_MEMORY_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_POWER_SKU_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070A0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // The TDP package power setting allowed for the SKU. The TDP setting is typical
    // not guaranteed.  The default value for this field is determined by fuses.  The
    // units for this value are defined in PACKAGE_POWER_SKU_MSR[PWR_UNIT].
    //
    // Bits[14:0], RW, default = 0x118
    //
    UINTX pkg_tdp : 15;
    //
    // Reserved
    //
    // Bits[15:15], RO, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // The minimal package power setting allowed for the SKU. Lower values may not be
    // achievable by run-time RAPL PL1 and PL2 control algorithms.
    //
    // Bits[30:16], RW, default = 0x60
    //
    UINTX pkg_min_pwr : 15;
    //
    // Reserved
    //
    // Bits[31:31], RO, default = 0x0
    //
    UINTX reserved_1 : 1;
    //
    // The maximal package power setting allowed for the SKU. Higher values will be clamped
    // to this value. The maximum setting is typical not guaranteed.  The default value
    // for this field is determined by fuses.  The units for this value are defined in
    // PACKAGE_POWER_SKU_MSR[PWR_UNIT].
    //
    // Bits[46:32], RW, default = 0x240
    //
    UINTX pkg_max_pwr : 15;
    //
    // Reserved
    //
    // Bits[47:47], RO, default = 0x0
    //
    UINTX reserved_2 : 1;
    //
    // The maximal time window allowed to be programmed for RAPL PL1 and PL2 controls
    // for the SKU.  Higher values will be clamped to this value.                [p]The
    // bits of this field describe parameters for a mathematical equation for time window
    // configuration.  This field is split into two sub-fields:[/p]
    //               [list]
    //               [*] x = bits[6:5]
    //               [*] y = bits[4:0]
    //               [/list]
    //               [p]Time window equation:[/p]
    //               [b]time_window = PACKAGE_POWER_SKU_UNIT.TIME_UNIT * ((1+x/4)^y)[/b]
    //
    // Bits[54:48], RW, default = 0x12
    //
    UINTX pkg_max_win : 7;
    //
    // Reserved
    //
    // Bits[63:55], RO, default = 0x0
    //
    UINTX reserved_3 : 9;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_POWER_SKU_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_RAPL_LIMIT_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070A8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Sets the average power usage limit of the package domain corresponding to the
    // PL1 time window. The power units of this field are specified by the PACKAGE_POWER_SKU_UNIT_MSR.PWR_UNIT.
    //  This power limit must be configured by software before it will engage.  The PL1
    // limit is most commonly associated with long time windows (1s and longer), although
    // there are no explicit constraints on what software configures.
    //
    // Bits[14:0], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_1 : 15;
    //
    // Enable for Power Limit 1 (PL1).  Setting this bit activates the power limit and
    // time window defined for PL1.
    //
    // Bits[15:15], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_1_en : 1;
    //
    // Clamp mode control for PL1.
    //               [list]
    //               [*] 0 = PL1 power control is prevented from forcing P-states below
    // the base frequency / P1 for any domain in the SOC.
    //               [*] 1 = PL1 power control will take all actions necessary to meet
    // the power target, even if that involves running at clock frequencies below the
    // base frequency / P1 level.
    //               [/list]
    //               In order to ensure proper SOC cooling, it is generally recommended
    // that the clamp mode is always enabled.
    //
    // Bits[16:16], RW/L, default = 0x0
    //
    UINTX pkg_clmp_lim_1 : 1;
    //
    // [p]Time window for Power Limit 1 (PL1).  This describes the control window of
    // the power limit.  This time window is described in an RC time constant format,
    // which means that if 1s is programmed, the power limit constraint really applies
    // at more like 5s.  The maximal time window is bounded by PACKAGE_POWER_SKU_MSR.PKG_MAX_WIN.
    // Thre is no constraint on the minimum programmable time window, however at very
    // short time windows the control algorithms may not be effective.[/p]
    //               [p]The bits of this field describe parameters for a mathematical
    // equation for time window configuration.  This field is split into two sub-fields:[/p]
    //               [list]
    //               [*] x = bits[6:5]
    //               [*] y = bits[4:0]
    //               [/list]
    //               [p]Time window equation:[/p]
    //               [b]time_window = PACKAGE_POWER_SKU_UNIT.TIME_UNIT * ((1+x/4)^y)[/b]
    //
    // Bits[23:17], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_1_time : 7;
    //
    // Reserved
    //
    // Bits[31:24], RSV, default = 0x0
    //
    UINTX reserved_0 : 8;
    //
    // Sets the average power usage limit of the package domain corresponding to the
    // PL2 time window. The power units of this field are specified by the PACKAGE_POWER_SKU_UNIT_MSR.PWR_UNIT.
    //  This power limit must be configured by software before it will engage.  The PL2
    // limit is most commonly associated with long time windows (1s and longer), although
    // there are no explicit constraints on what software configures.
    //
    // Bits[46:32], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_2 : 15;
    //
    // Enable for Power Limit 2 (PL2).  Setting this bit activates the power limit and
    // time window defined for PL2.
    //
    // Bits[47:47], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_2_en : 1;
    //
    // Clamp mode control for PL2.
    //               [list]
    //               [*] 0 = PL2 power control is prevented from forcing P-states below
    // the base frequency / P1 for any domain in the SOC.
    //               [*] 1 = PL2 power control will take all actions necessary to meet
    // the power target, even if that involves running at clock frequencies below the
    // base frequency / P1 level.
    //               [/list]
    //               In order to ensure proper SOC cooling, it is generally recommended
    // that the clamp mode is always enabled.
    //
    // Bits[48:48], RW/L, default = 0x0
    //
    UINTX pkg_clmp_lim_2 : 1;
    //
    // [p]Time window for Power Limit 1 (PL2).  This describes the control window of
    // the power limit.  This time window is described in an RC time constant format,
    // which means that if 1s is programmed, the power limit constraint really applies
    // at more like 5s.  The maximal time window is bounded by PACKAGE_POWER_SKU_MSR.PKG_MAX_WIN.
    // Thre is no constraint on the minimum programmable time window, however at very
    // short time windows the control algorithms may not be effective.[/p]
    //               [p]The bits of this field describe parameters for a mathematical
    // equation for time window configuration.  This field is split into two sub-fields:[/p]
    //               [list]
    //               [*] x = bits[6:5]
    //               [*] y = bits[4:0]
    //               [/list]
    //               [p]Time window equation:[/p]
    //               [b]time_window = PACKAGE_POWER_SKU_UNIT.TIME_UNIT * ((1+x/4)^y)[/b]
    //
    // Bits[55:49], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_2_time : 7;
    //
    // Reserved
    //
    // Bits[62:56], RSV, default = 0x0
    //
    UINTX reserved_1 : 7;
    //
    // When set all settings in this register are locked and are treated as Read Only.
    //  This lock control is persistent until the next reset.  This bit will typically
    // set by BIOS during boot time or resume from Sx.
    //
    // Bits[63:63], RW/L, default = 0x0
    //
    UINTX pkg_pwr_lim_lock : 1;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_RAPL_LIMIT_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_IA_PERF_LIMIT_REASONS_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070B0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Frequency is limited due to external PROCHOT assertion.
    //
    // Bits[0:0], RO/V, default = 0x0
    //
    UINTX prochot_status : 1;
    //
    // Frequency is limited due to thermal excursion.
    //
    // Bits[1:1], RO/V, default = 0x0
    //
    UINTX thermal_status : 1;
    //
    // Frequency is limited due to a package-level PL1 excursion.
    //
    // Bits[2:2], RO/V, default = 0x0
    //
    UINTX pl1_status : 1;
    //
    // Frequency is limited due to a package-level PL2 excursion.
    //
    // Bits[3:3], RO/V, default = 0x0
    //
    UINTX pl2_status : 1;
    //
    // Spare status bit.
    //
    // Bits[4:4], RO/V, default = 0x0
    //
    UINTX spare4_status : 1;
    //
    // Spare status bit.
    //
    // Bits[5:5], RO/V, default = 0x0
    //
    UINTX spare5_status : 1;
    //
    // Spare status bit.
    //
    // Bits[6:6], RO/V, default = 0x0
    //
    UINTX spare6_status : 1;
    //
    // Frequency is limited due to Dev2 driver override.
    //
    // Bits[7:7], RO/V, default = 0x0
    //
    UINTX dev2_status : 1;
    //
    // Frequency is limited due to Dev3 driver override.
    //
    // Bits[8:8], RO/V, default = 0x0
    //
    UINTX dev3_status : 1;
    //
    // Frequency is limited due to autonomous utilization-based P-state control.
    //
    // Bits[9:9], RO/V, default = 0x0
    //
    UINTX ia_utilization_status : 1;
    //
    // Frequency is limited due to a VR thermal excursion.
    //
    // Bits[10:10], RO/V, default = 0x0
    //
    UINTX vr_thermalert_status : 1;
    //
    // Frequency is limited due to effective multi-core turbo constraints.
    //
    // Bits[11:11], RO/V, default = 0x0
    //
    UINTX multi_core_turbo_status : 1;
    //
    // Frequency is limited due to a package-level EDP constraint.
    //
    // Bits[12:12], RO/V, default = 0x0
    //
    UINTX edp_status : 1;
    //
    // Frequency is limited due to ratio change transition attenuation (MCT, prevents
    // frequent ratio changes due to core C-state entry/exit).
    //
    // Bits[13:13], RO/V, default = 0x0
    //
    UINTX mct_status : 1;
    //
    // Frequency is limited below the maximum efficiency frequency.
    //
    // Bits[14:14], RO/V, default = 0x0
    //
    UINTX max_efficiency_freq_status : 1;
    //
    // Frequency is limited below the operating system or driver Quality-of-Service floor.
    //
    // Bits[15:15], RO/V, default = 0x0
    //
    UINTX qos_status : 1;
    //
    // Logged indication that frequency was clamped due to PROCHOT assertion. This bit
    // is set by firmware, and is clearable by software.
    //
    // Bits[16:16], RW/0C/V, default = 0x0
    //
    UINTX prochot_log : 1;
    //
    // Logged indication that frequency was clamped due to a thermal excursion. This
    // bit is set by firmware, and is clearable by software.
    //
    // Bits[17:17], RW/0C/V, default = 0x0
    //
    UINTX thermal_log : 1;
    //
    // Logged indication that frequency was clamped due to a package-level PL1 excursion.
    // This bit is set by firmware, and is clearable by software.
    //
    // Bits[18:18], RW/0C/V, default = 0x0
    //
    UINTX pl1_log : 1;
    //
    // Logged indication that frequency was clamped due to a package-level PL2 excursion.
    // This bit is set by firmware, and is clearable by software.
    //
    // Bits[19:19], RW/0C/V, default = 0x0
    //
    UINTX pl2_log : 1;
    //
    // Spare log bit. This bit is set by firmware, and is clearable by software.
    //
    // Bits[20:20], RW/0C/V, default = 0x0
    //
    UINTX spare4_log : 1;
    //
    // Spare log bit. This bit is set by firmware, and is clearable by software.
    //
    // Bits[21:21], RW/0C/V, default = 0x0
    //
    UINTX spare5_log : 1;
    //
    // Spare log bit. This bit is set by firmware, and is clearable by software.
    //
    // Bits[22:22], RW/0C/V, default = 0x0
    //
    UINTX spare6_log : 1;
    //
    // Logged indication that frequency was clamped due to a Device 2 driver override.
    // This bit is set by firmware, and is clearable by software.
    //
    // Bits[23:23], RW/0C/V, default = 0x0
    //
    UINTX dev2_log : 1;
    //
    // Logged indication that frequency was clamped due to a Device 3 driver override.
    // This bit is set by firmware, and is clearable by software.
    //
    // Bits[24:24], RW/0C/V, default = 0x0
    //
    UINTX dev3_log : 1;
    //
    // Logged indication that frequency was clamped due to the autonomous utilization-based
    // P-state control algorithm. This bit is set by firmware, and is clearable by software.
    //
    // Bits[25:25], RW/0C/V, default = 0x0
    //
    UINTX ia_utilization_log : 1;
    //
    // Logged indication that frequency was clamped due to a voltage regulator thermal
    // excursion. This bit is set by firmware, and is clearable by software.
    //
    // Bits[26:26], RW/0C/V, default = 0x0
    //
    UINTX vr_thermalert_log : 1;
    //
    // Logged indication that frequency was clamped due to effective multi-core turbo
    // constraints. This bit is set by firmware, and is clearable by software.
    //
    // Bits[27:27], RW/0C/V, default = 0x0
    //
    UINTX multi_core_turbo_log : 1;
    //
    // Logged indication that frequency was clamped due to the package-level Electrical
    // Design Point constraint. This bit is set by firmware, and is clearable by software.
    //
    // Bits[28:28], RW/0C/V, default = 0x0
    //
    UINTX edp_log : 1;
    //
    // Logged indication that frequency was clamped due to ratio change transition attenuation.
    // This bit is set by firmware, and is clearable by software.
    //
    // Bits[29:29], RW/0C/V, default = 0x0
    //
    UINTX mct_log : 1;
    //
    // Logged indication that frequency was clamped below the firmware-calculated maximum
    // efficiency frequency. This bit is set by firmware, and is clearable by software.
    //
    // Bits[30:30], RW/0C/V, default = 0x0
    //
    UINTX max_efficiency_freq_log : 1;
    //
    // Logged indication that frequency was clamped below the software-defined quality-of-service
    // floor. This bit is set by firmware, and is clearable by software.
    //
    // Bits[31:31], RW/0C/V, default = 0x0
    //
    UINTX qos_log : 1;
  } Bits;
  UINTX Data;
} P_CR_IA_PERF_LIMIT_REASONS_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_IA_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070C0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This counter measures time that any core is active in the C0 state.  This counter
    // counts at the crystal clock frequency divided by 16.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_IA_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_GT_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070C4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This counter measures time that graphics is active in the C0 state.  This counter
    // counts at the crystal clock frequency divided by 16.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_GT_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_IUNIT_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070C8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This counter measures time that I-unit processing system is active in the C0 state.
    //  This counter counts at the crystal clock frequency divided by 16.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_IUNIT_C0_RESIDENCY_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_IA_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070CC
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Residency data
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_IA_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_GT_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070D0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This counter integrates the current clock ratio of the domain at the same rate
    // as the corresponding C0 residency counter
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_GT_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_IUNIT_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070D4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This counter integrates the current clock ratio of the domain at the same rate
    // as the corresponding C0 residency counter
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_TELEM_IUNIT_FREQ_ACCUMULATOR_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_NEAR_MEMORY_ACTIVE_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070E0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This counter measures the total time spent with near memory active, as measured
    // by any rank being in the active or active idle state.  The inverse of this counter
    // indicates the total time spent with all near memory in the self-refresh state.
    //  This counter counts at the crystal clock frequency divided by 16.
    //
    // Bits[63:0], RO/V, default = 0x0
    //
    UINTX data : 64;
  } Bits;
  UINTX Data;
} P_CR_TELEM_NEAR_MEMORY_ACTIVE_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_TELEM_FAR_MEMORY_ACTIVE_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070E8
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This counter measures the total time spent with memory active, as measured by
    // any rank being in the active or active idle state.  The inverse of this counter
    // indicates the total time spent with all memory in the self-refresh state.  This
    // counter counts at the crystal clock frequency divided by 16.
    //
    // Bits[63:0], RO/V, default = 0x0
    //
    UINTX data : 64;
  } Bits;
  UINTX Data;
} P_CR_TELEM_FAR_MEMORY_ACTIVE_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_SOUTH_IO_PORT_STATUS3_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x0000711C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Snapshot of the number of USB2 lanes for power meter.
    //
    // Bits[3:0], RW, default = 0x0
    //
    UINTX usb2_lanes : 4;
    //
    // Snapshot of the number of USB3 lanes for power meter.
    //
    // Bits[7:4], RW, default = 0x0
    //
    UINTX usb3_lanes : 4;
    //
    // Snapshot of the number of SATA lanes for power meter.
    //
    // Bits[15:8], RW, default = 0x0
    //
    UINTX sata_lanes : 8;
    //
    // Snapshot of the number of PCIE lanes for power meter.
    //
    // Bits[23:16], RW, default = 0x0
    //
    UINTX pcie_lanes : 8;
    //
    // Snapshot of the number of GBE lanes for power meter.
    //
    // Bits[25:24], RW, default = 0x0
    //
    UINTX gbe_ports : 2;
    //
    // reserved
    //
    // Bits[31:26], RW, default = 0x0
    //
    UINTX rsvd : 6;
  } Bits;
  UINTX Data;
} P_CR_SOUTH_IO_PORT_STATUS3_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PACKAGE_TEMPERATURES_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x000070F4
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Virtual max temperature of all IA cores in degrees C.  Reported in a signed, 2's
    // complement format with the LSB representing 1'C resolution (S8.7.0).  Raw, unfiltered
    //
    // Bits[7:0], RO/V, default = 0x0
    //
    UINTX ia_temperature : 8;
    //
    // Graphics domain max temperature in degrees C.  Reported in a signed, 2's complement
    // format with the LSB representing 1'C resolution (S8.7.0).  Raw, unfiltered
    //
    // Bits[15:8], RO/V, default = 0x0
    //
    UINTX gt_temperature : 8;
    //
    // Camera domain max temperature in degrees C.  Reported in a signed, 2's complement
    // format with the LSB representing 1'C resolution (S8.7.0).  Raw, unfiltered
    //
    // Bits[23:16], RO/V, default = 0x0
    //
    UINTX isp_temperature : 8;
    //
    // System agent domain max temperature in degrees C.  Reported in a signed, 2's complement
    // format with the LSB representing 1'C resolution (S8.7.0).  Raw, unfiltered
    //
    // Bits[31:24], RO/V, default = 0x0
    //
    UINTX sa_temperature : 8;
  } Bits;
  UINTX Data;
} P_CR_PACKAGE_TEMPERATURES_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_THERMAL_LIMIT_CONTROL_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007104
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Maximum SOC temperature allowed.  Described in a signed, 2's complement format
    // with the least significant bit representing 1'C resolution (S8.7.0).  If the setting
    // is higher than the processor's factory configured maximum temperature as described
    // in the TEMPERATURE_TARGET MSR, this field is ignored.  This field may be updated
    // at any time.
    //
    // Bits[7:0], RW, default = 0x0
    //
    UINTX thermal_limit_temp : 8;
    //
    // When set, it enables run-time thermal limit control to the THERMAL_LIMIT_TEMP
    // described in this register.
    //
    // Bits[8:8], RW, default = 0x0
    //
    UINTX enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:9], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 23;
  } Bits;
  UINTX Data;
} P_CR_THERMAL_LIMIT_CONTROL_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_MEMSS_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007108
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field indicates maximum LPDDR3 frequency supported at the minimum voltage
    // level, in integer multiple of 133.33MHz.  If this frequency is the same as 'Max'
    // frequency, it indicates there is no voltage scaling.  A value of zero indicates
    // LPDDR3 is not supported.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX lp3_freq_low : 6;
    //
    // This field indicates maximum LPDDR3 frequency that SOC supports, in integer multiple
    // of 133.33MHz.  A value of zero indicates LPDDR3 is not supported.
    //
    // Bits[11:6], RW, default = 0x0
    //
    UINTX lp3_freq_high : 6;
    //
    // This field indicates maximum LPDDR4 frequency supported at the minimum voltage
    // level, in integer multiple of 133.33MHz.  If this frequency is the same as 'Max'
    // frequency, it indicates there is no voltage scaling.  A value of zero indicates
    // LPDDR4 is not supported.
    //
    // Bits[17:12], RW, default = 0x0
    //
    UINTX lp4_freq_low : 6;
    //
    // This field indicates maximum LPDDR4 frequency that SOC supports, in integer multiple
    // of 133.33MHz.  A value of zero indicates LPDDR4 is not supported.
    //
    // Bits[23:18], RW, default = 0x0
    //
    UINTX lp4_freq_high : 6;
    //
    // Reserved
    //
    // Bits[29:24], RW, default = 0x0
    //
    UINTX wio_freq : 6;
    //
    // Reserved
    //
    // Bits[31:30], RW, default = 0x0
    //
    UINTX num_nm_ch : 2;
  } Bits;
  UINTX Data;
} P_CR_MEMSS_FREQUENCY_CAPABILITIES_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_MC_BIOS_REQ_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG    0x00007114
#ifndef ASM_INC
typedef union {
  struct {
    //
    // [p]BIOS programs this field to request DDR frequency in integer
    //               multiple of 133.33MHz.  BIOS reads MEMSS_FREQUENCY_CAPABILITIES
    // register(s) to
    //               discover maximum SOC supported capabilities.  And BIOS is expected
    // to request
    //               only legal DDR frequencies that are equal or lower than the maximum
    // SOC
    //               supported capabilities.[/p]
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX req_data : 6;
    //
    // This field is used to configure reset hints to the P-unit firmware.  Encodings
    // include:
    //               [list]
    //               [*] 1xxb = Memory is in self-refresh, manual self-refresh exit is
    // required
    //               [*] 0xxb = Memory is not in self-refresh or DRAM contents do not
    // need to be preserved.
    //               [/list]
    //
    // Bits[8:6], RW, default = 0x0
    //
    UINTX req_type : 3;
    //
    // reserved
    //
    // Bits[9:9], RW, default = 0x0
    //
    UINTX req_type_special : 1;
    //
    // reserved
    //
    // Bits[10:10], RW, default = 0x0
    //
    UINTX reserved_0 : 1;
    //
    // Reserved
    //
    // Bits[11:11], RW, default = 0x0
    //
    UINTX wio_only : 1;
    //
    // BIOS writes this value to indicate a DDR memory channel has DRAM devices active
    // to allow the channel to have active memory traffic.  Note, by default, a channel
    // is not active and BIOS needs to explicitly program a value of 1 to indicate that
    // the channel is active. If a channel is fused off on a particular SOC, BIOS input
    // is ignored:
    //               [list]
    //               [*] 0 = channel not active
    //               [*] 1 = channel active
    //               [/list]
    //
    // Bits[12:12], RW, default = 0x0
    //
    UINTX fm_ch0_active : 1;
    //
    // BIOS writes this value to indicate a DDR memory channel has DRAM devices active
    // to allow the channel to have active memory traffic.  Note, by default, a channel
    // is not active and BIOS needs to explicitly program a value of 1 to indicate that
    // the channel is active. If a channel is fused off on a particular SOC, BIOS input
    // is ignored:
    //               [list]
    //               [*] 0 = channel not active
    //               [*] 1 = channel active
    //               [/list]
    //
    // Bits[13:13], RW, default = 0x0
    //
    UINTX fm_ch1_active : 1;
    //
    // BIOS writes this value to indicate a DDR memory channel has DRAM devices active
    // to allow the channel to have active memory traffic.  Note, by default, a channel
    // is not active and BIOS needs to explicitly program a value of 1 to indicate that
    // the channel is active. If a channel is fused off on a particular SOC, BIOS input
    // is ignored:
    //               [list]
    //               [*] 0 = channel not active
    //               [*] 1 = channel active
    //               [/list]
    //
    // Bits[14:14], RW, default = 0x0
    //
    UINTX fm_ch2_active : 1;
    //
    // BIOS writes this value to indicate a DDR memory channel has DRAM devices active
    // to allow the channel to have active memory traffic.  Note, by default, a channel
    // is not active and BIOS needs to explicitly program a value of 1 to indicate that
    // the channel is active. If a channel is fused off on a particular SOC, BIOS input
    // is ignored:
    //               [list]
    //               [*] 0 = channel not active
    //               [*] 1 = channel active
    //               [/list]
    //
    // Bits[15:15], RW, default = 0x0
    //
    UINTX fm_ch3_active : 1;
    //
    // BIOS programs this bit indicating PHY initial configuration is complete and all
    // DDR PHY PLLs are locked. Upon observation of this flag, P-unit firmware will initiate
    // the power-up sequence of memory subsystem related IPs
    //
    // Bits[16:16], RW, default = 0x0
    //
    UINTX phy_config_complete : 1;
    //
    // Punit programs this bit after memory subsystem IPs are powered and corresponding
    // reset flows are complete.  At this point, those blocks are ready for executing
    // the memory training flow, including intialization to support CPGC mode.  BIOS
    // can talk to Dunit after this.
    //
    // Bits[17:17], RW, default = 0x0
    //
    UINTX dunit_reset_complete : 1;
    //
    // BIOS programs this bit after the memory train/init flow is complete.  This initiates
    // P-unit firmware execution of memory and D-unit clock configuration settings for
    // normal operation
    //
    // Bits[18:18], RW, default = 0x0
    //
    UINTX cpgc_mode_complete : 1;
    //
    // BIOS programs this bit after memory subsystem is fully configured, including security
    // locking configuration completed
    //
    // Bits[19:19], RW, default = 0x0
    //
    UINTX mem_init_done : 1;
    //
    // reserved
    //
    // Bits[23:20], RW, default = 0x0
    //
    UINTX reserved_1 : 4;
    //
    // BIOS programs DRAM type filed:
    //               [list]
    //               [*] 001b = LPDDR3
    //               [*] 010b = LPDDR4
    //               [*] 100b = DDR3L
    //               [*] else = reserved
    //               [/list]
    //
    // Bits[26:24], RW, default = 0x0
    //
    UINTX dram_type : 3;
    //
    // reserved
    //
    // Bits[30:27], RW, default = 0x0
    //
    UINTX reserved_2 : 4;
    //
    // [p]This bit indicates that the BIOS request is pending for P-unit firmware processing.
    //  BIOS sets this bit together with command details defined in the lower bits of
    // this register.  Firmware may only clear this bit after the BIOS request has been
    // observed and completed.[p]
    //               [list]
    //               [*] 0 = The MC BIOS reset mailbox is idle or the last request has
    // been completed.  Software may initiate new requests.
    //               [*] 1 = The MC BIOS reset mailbox is busy. It is still handling
    // a request.  Writes to the mailbox are not allowed at this time.
    //               [/list]
    //
    // Bits[31:31], RW, default = 0x0
    //
    UINTX run_busy : 1;
  } Bits;
  UINTX Data;
} P_CR_MC_BIOS_REQ_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_MEMSS_FREQUENCY_CAPABILITIES1_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007118
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field indicates maximum DDR3L frequency supported at the minimum voltage
    // level, in integer multiple of 133.33MHz.  If this frequency is the same as Max
    // frequency, it indicates there is no voltage scaling.  A value of zero indicates
    // LPDDR4 is not supported.
    //
    // Bits[5:0], RW, default = 0x0
    //
    UINTX ddr3l_freq_low : 6;
    //
    // This field indicates maximum DDR3L frequency that SOC supports, in integer multiple
    // of 133.33MHz.  A value of zero indicates DDR3L is not supported.
    //
    // Bits[11:6], RW, default = 0x0
    //
    UINTX ddr3l_freq_high : 6;
    //
    // This field indicates maximum DDR4 frequency supported at the minimum voltage level,
    // in integer multiple of 133.33MHz. If this frequency is the same as Max frequency,
    // it indicates there is no voltage scaling. A value of zero indicates DDR4 is not
    // supported
    //
    // Bits[17:12], RW, default = 0x0
    //
    UINTX ddr4_freq_low : 6;
    //
    // This field indicates maximum DDR4 frequency that SOC supports, in integer multiple
    // of 133.33MHz. A value of zero indicates DDR4 is not supported
    //
    // Bits[23:18], RW, default = 0x0
    //
    UINTX ddr4_freq_high : 6;
    //
    // Describe the DDR configuration limitation of this particular SOC:
    //              [list]
    //              [*] 0 = no DDR configuration limitation
    //              [*] 1 = DDR configuration is limited to1ch x 64-bit DDR3L, or 2ch
    // x32 LPDDR3 or LPDDR4
    //              [/list]
    //
    // Bits[24:24], RW, default = 0x0
    //
    UINTX ddr_config_limitation : 1;
    //
    // reserved
    //
    // Bits[31:25], RW, default = 0x0
    //
    UINTX reserved_2 : 7;
  } Bits;
  UINTX Data;
} P_CR_MEMSS_FREQUENCY_CAPABILITIES1_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PP1_C0_CORE_CLOCK_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007160
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Accumulated cycles GT has been in RC0.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX data : 32;
  } Bits;
  UINTX Data;
} P_CR_PP1_C0_CORE_CLOCK_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_CORE_EXISTS_VECTOR_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007164
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Indication of core physical presence
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX core0_exists : 1;
    //
    // Indication of core physical presence
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX core1_exists : 1;
    //
    // Indication of core physical presence
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX core2_exists : 1;
    //
    // Indication of core physical presence
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX core3_exists : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 28;
  } Bits;
  UINTX Data;
} P_CR_CORE_EXISTS_VECTOR_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_CORE_DISABLE_MASK_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007168
#ifndef ASM_INC
typedef union {
  struct {
    //
    // core0 disable mask
    //
    // Bits[0:0], RW, default = 0x0
    //
    UINTX core0_disable_mask : 1;
    //
    // core1 disable mask
    //
    // Bits[1:1], RW, default = 0x0
    //
    UINTX core1_disable_mask : 1;
    //
    // core2 disable mask
    //
    // Bits[2:2], RW, default = 0x0
    //
    UINTX core2_disable_mask : 1;
    //
    // core3 disable mask
    //
    // Bits[3:3], RW, default = 0x0
    //
    UINTX core3_disable_mask : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:4], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 28;
  } Bits;
  UINTX Data;
} P_CR_CORE_DISABLE_MASK_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PL3_CONTROL_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG    0x000071F0
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Power Limit 3 (PL3) or PAppMax power level.  Any SOC power measurement observed
    // above this level is considered as an excursion against the PL3 power limit and
    // duty cycle / time window budget.  Units of this power limit are defined by PACKAGE_POWER_SKU_UNIT_MSR.PWR_UNIT.
    //
    // Bits[14:0], RW/L, default = 0x0
    //
    UINTX power_limit : 15;
    //
    // [list]
    //               [*]0 = disabled
    //               [*]1 = enabled
    //               [/list]
    //
    // Bits[15:15], RW/L, default = 0x0
    //
    UINTX pl3_enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[16:16], Unknown, default = Unknown
    //
    UINTX missing_from_register_description : 1;
    //
    // Duration over which duty cycle control will be maintained.  The bits of this field
    // describe parameters for a mathematical equation for time window configuration.
    //   This time window is strictly adhered to, if the window described is 40ms, then
    // silicon guarantees no excursions to the programmed duty cycle within a rolling
    // 40ms window.  [p]This field is split into two sub-fields:[/p]
    //               [list]
    //               [*] x = bits[6:5]
    //               [*] y = bits[4:0]
    //               [/list]
    //               [p]Time window equation:[/p]
    //               [b]time_window = PACKAGE_POWER_SKU_UNIT.TIME_UNIT * ((1+x/4)^y)[/b]
    //
    // Bits[23:17], RW/L, default = 0x0
    //
    UINTX time_window : 7;
    //
    // Power limit excursion duty cycle control for PL3, describing what percentage of
    // time it is allowed for the SOC to exceed the programmed PL3 power limit.  0% implies
    // excursions are not supported ever and 100% implies excursions are always allowed
    // (effectively disabling the feature).  Units are in percentage(%).  E.g., to allow
    // for 20% excursion time and 80% PL3 power limit clamp time, program a value of
    // 14h.  Values greater than 100 (64h) are clipped to 100%.
    //
    // Bits[30:24], RW/L, default = 0x0
    //
    UINTX duty_cycle : 7;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[31:31], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_1 : 1;
    //
    // Power Limit 'PL4' or Pmax power limit in the units as described PACAKGE_POWER_SKU_UNIT
    // MSR.  The SOC guarantees it will never exceed this power limit even for very short
    // time windows.
    //
    // Bits[46:32], RW/L, default = 0x0
    //
    UINTX pmax : 15;
    //
    // [list]
    //               [*]0 = disabled
    //               [*]1 = enabled
    //               [/list]
    //
    // Bits[47:47], RW/L, default = 0x0
    //
    UINTX pl4_enable : 1;
    //
    // Missing bits not found in register description spreadsheet.
    // Bits[62:48], Unknown, default = Unknown
    //
    UINTX missing_from_register_description_2 : 15;
    //
    // Write a 1b to lock this register until next reset.  Once locked, no further updates
    // may be written to any bits in the register.
    //
    // Bits[63:63], RW/L, default = 0x0
    //
    UINTX lock : 1;
  } Bits;
  UINTX Data;
} P_CR_PL3_CONTROL_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_PP1_ANY_THREAD_ACTIVITY_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007244
#ifndef ASM_INC
typedef union {
  struct {
    //
    // Graphics Superqueue active residency counter.  Counts in crystal reference clocks
    // divided by 16.
    //
    // Bits[31:0], RO/V, default = 0x0
    //
    UINTX superqueue_active_residency : 32;
  } Bits;
  UINTX Data;
} P_CR_PP1_ANY_THREAD_ACTIVITY_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_MEM_MR4_TEMPERATURE_DEV3_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x00007248
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is updated each read of LPDDR DRAM MR4 Device Temperature Status per
    // rank. Update rate is configured by BIOS.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX mr4_rank_0 : 3;
    //
    // This field is updated each read of LPDDR DRAM MR4 Device Temperature Status per
    // rank. Update rate is configured by BIOS.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX mr4_rank_1 : 3;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_0 : 26;
  } Bits;
  UINTX Data;
} P_CR_MEM_MR4_TEMPERATURE_DEV3_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC

#define P_CR_MEM_MR4_TEMPERATURE_DEV4_0_0_0_MCHBAR_PUNIT_BOXTYPE_REG 0x0000724C
#ifndef ASM_INC
typedef union {
  struct {
    //
    // This field is updated each read of LPDDR DRAM MR4 Device Temperature Status per
    // rank. Update rate is configured by BIOS.
    //
    // Bits[2:0], RW, default = 0x0
    //
    UINTX mr4_rank_0 : 3;
    //
    // This field is updated each read of LPDDR DRAM MR4 Device Temperature Status per
    // rank. Update rate is configured by BIOS.
    //
    // Bits[5:3], RW, default = 0x0
    //
    UINTX mr4_rank_1 : 3;
    //
    // Reserved
    //
    // Bits[31:6], RO, default = 0x0
    //
    UINTX reserved_0 : 26;
  } Bits;
  UINTX Data;
} P_CR_MEM_MR4_TEMPERATURE_DEV4_0_0_0_MCHBAR_PUNIT_BOXTYPE_STRUCT;
#endif // ASM_INC


#endif // _PUNIT_BOXTYPE_H_
