/** @file
  File name:    StringsGenerated.c
  Input File:   GLK_SOC.xlsx

  THIS FILE IS AUTO-GENERATED BY THE MMRC TOOL. DO NOT CHANGE THIS CODE.

  If edits are needed in this file, they must be done via the MMRC tool.

  If there is additional project-specific data required by the MMRC, it
  can be placed in Strings.c, which is used for non-tool-generated
  data

  Includes various strings specific to a project.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2005 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification
**/

#include "MmrcData.h"

#if CAPSULESTRINGS
char *OutputStrings[] = {
  NULL,
};
#endif //CAPSULESTRINGS

#if DUMP_REGISTER_NAMES
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields0[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RW", "dramdevice_pr", "Specifies the number of DRAM devices that are ganged together to form a single rank. \r\n"
"      [list]\r\n"
"      [*]00: 1 DRAM device in each rank.\r\n"
"      [*]01: 2 DRAM devices in each rank.\r\n"
"      [*]10: 4 DRAM devices in each rank.\r\n"
"      [*]11: 8 DRAM devices in each rank. \r\n"
"      [/list]\r\n"
"      [p]Note: The actual number of devices is one more than the value programmed when ECC is enabled.[/p]"},
#else
{30, 31, 0x0000000000000000, "RW", "dramdevice_pr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000001, "RW", "addrdec", "Specifies the address mapping to be used:\r\n"
"  [list]\r\n"
"  [*]00: 1KB (A). \r\n"
"  [*]01: 2KB (B).\r\n"
"  [*]10: 4KB (C).\r\n"
"  [*]11: Reserved.\r\n"
"  [/list]"},
#else
{28, 29, 0x0000000000000001, "RW", "addrdec", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 27, 0x0000000000000000, "RW", "blmode", "\r\n"
"  [list]\r\n"
"  [*]000: Fixed BL8.  \r\n"
"  [*]001: Onthefly BL8.\r\n"
"  [*]010: Fixed BL16.\r\n"
"  [*]011: Onthefly BL16.\r\n"
"  [*]100: Fixed BL32.\r\n"
"  [*]101: Onthefly BL32.\r\n"
"  [*]110-111: Reserved.\r\n"
"  [/list]"},
#else
{25, 27, 0x0000000000000000, "RW", "blmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 24, 0x0000000000000000, "RW", "dramtype", "\r\n"
"  [list]\r\n"
"  [*]000: DDR3L.\r\n"
"  [*]001: LPDDR3.\r\n"
"  [*]010: LPDDR4.\r\n"
"  [*]011: WIO2.\r\n"
"  [*]100: DDR4.\r\n"
"  [*]101-111: Reserved.\r\n"
"      [/list]\r\n"
"  [p]Note: The D-Unit should only use this field if allowed by fuse.[/p]"},
#else
{22, 24, 0x0000000000000000, "RW", "dramtype", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "eccen", "\r\n"
"  [list]\r\n"
"  [*]0: ECC is disabled.\r\n"
"  [*]1: ECC is enabled.\r\n"
"      [/list]\r\n"
"  [p]This bit determines if the D-Unit treats the PMI BE_ECC bits as ECC bits or Byte Enables. The D-Unit should not allow this bit to be set if ECC is disabled by fuse. This should only be used in configurations that support ECC.[/p]"},
#else
{21, 21, 0x0000000000000000, "RW", "eccen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 20, 0x0000000000000000, "RW", "caswizzle", "\r\n"
"      [list]\r\n"
"      [*]00: uniDIMM/SODIMM/UDIMM.\r\n"
"      [*]01: BGA. \r\n"
"      [*]10: BGA mirrored (LPDDR3 Only). \r\n"
"      [*]11: uniDIMM/SODIMM/UDIMM with Rank 1 mirrored (DDR4 Only).\r\n"
"      [/list]"},
#else
{19, 20, 0x0000000000000000, "RW", "caswizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 18, 0x0000000000000000, "RO", "rsvd18_17", "Reserved."},
#else
{17, 18, 0x0000000000000000, "RO", "rsvd18_17", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "fbginten", "When enabled, D-unit will use a lower order address bit in the bank hashing function (DDR4 Only). \r\n"
"  [list]\r\n"
"  [*]0: Bank Group Interleave disabled.\r\n"
"  [*]1: Bank Group Interleave enabled.\r\n"
"  [/list]\r\n"
"      [p]Note: BAHEN must be set for this bit to take effect.[/p]"},
#else
{16, 16, 0x0000000000000000, "RW", "fbginten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RW", "bahen", "See Address Mapping section for full description.  \r\n"
"  [list]\r\n"
"  [*]0: Bank Address Hashing disabled.\r\n"
"  [*]1: Bank Address Hashing enabled.\r\n"
"  [/list]"},
#else
{15, 15, 0x0000000000000000, "RW", "bahen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 14, 0x0000000000000000, "RW", "rsien", "See Address Mapping section for full description.\r\n"
"      [list]\r\n"
"  [*]0: Rank Select Interleaving disabled.\r\n"
"  [*]1: Rank Select Interleaving enabled.\r\n"
"  [/list]"},
#else
{14, 14, 0x0000000000000000, "RW", "rsien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 13, 0x0000000000000000, "RO", "rsvd13_9", "Reserved."},
#else
{9, 13, 0x0000000000000000, "RO", "rsvd13_9", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 8, 0x0000000000000000, "RW", "dden", "Density of the DRAM devices populated on Ranks 0 and 1.\r\n"
"      [list]\r\n"
"  [*]000: 4 Gb.\r\n"
"  [*]001: 6 Gb.\r\n"
"  [*]010: 8 Gb.\r\n"
"  [*]011: 12 Gb.\r\n"
"  [*]100: 16 Gb.\r\n"
"  [*]101-111: Reserved.\r\n"
"      [/list]\r\n"
"  [p]Note: For LPDDR4 this value is the die density.[/p]"},
#else
{6, 8, 0x0000000000000000, "RW", "dden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "dwid", "Data width of the DRAM device populated on Ranks 0 and 1.\r\n"
"      [list]\r\n"
"  [*]00: x8.\r\n"
"  [*]01: x16.\r\n"
"  [*]10: x32.\r\n"
"  [*]11: x64.\r\n"
"  [/list]"},
#else
{4, 5, 0x0000000000000000, "RW", "dwid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RO", "rsvd3", "Reserved."},
#else
{3, 3, 0x0000000000000000, "RO", "rsvd3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "ddmen", "\r\n"
"      [list]\r\n"
"      [*]0: PMI Dual Data Mode is disabled in D-Unit.\r\n"
"      [*]1: PMI Dual Data Mode is enabled.\r\n"
"      [/list]\r\n"
"      [p]Note: Dual Data Mode must be enable for DDR3L/DDR4 configurations."},
#else
{2, 2, 0x0000000000000000, "RW", "ddmen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "rken1", "Enable Rank 1: Must be set to 1 to enable use of this rank."},
#else
{1, 1, 0x0000000000000000, "RW", "rken1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "rken0", "Enable Rank 0: Must be set to 1 to enable use of this rank.  \r\n"
"  [p]Note: Setting this bit to 0 is not a functional mode.[/p]"},
#else
{0, 0, 0x0000000000000000, "RW", "rken0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo0[] = {{"D_CR_DRP0", "", 0x00000000, 17, 0x00000000FFFFFFFF, 0x0000000010000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields1[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{23, 31, 0x0000000000000000, "RO", "rsvd31_23", "Reserved."},
#else
{23, 31, 0x0000000000000000, "RO", "rsvd31_23", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 22, 0x0000000000000005, "RW", "twwsr_l", "Specifies the delay from a DRAM Write to another Write command within the same bank group of the same rank (in DRAM clocks).\r\n"
"  [p]DDR4 Equation: tWWSR_L = tCCD_L.[/p]"},
#else
{18, 22, 0x0000000000000005, "RW", "twwsr_l", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 17, 0x0000000000000005, "RW", "trrsr_l", "Specifies the delay from a DRAM Read to another Read command  within the same bank group of the same rank (in DRAM clocks).\r\n"
"  [p]DDR4 Equation: tRRSR_L = tCCD_L.[/p]"},
#else
{13, 17, 0x0000000000000005, "RW", "trrsr_l", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 12, 0x0000000000000015, "RW", "twrsr_l", "Specifies the delay from a DRAM Read to Write command within the same bank group of the same rank (in DRAM clocks).\r\n"
"      [list]\r\n"
"      [*]DDR4 Equation: tWRSR_L  = CWL + tDQSSmax + BL/2 + tWPST + tWTR_L.\r\n"
"      [/list]"},
#else
{6, 12, 0x0000000000000015, "RW", "twrsr_l", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000006, "RW", "trrd_l", "Specifies the minimum delay (in DRAM clocks) between two DRAM Activate commands to different banks within the same bank group of a rank. (DDR4 Only)"},
#else
{0, 5, 0x0000000000000006, "RW", "trrd_l", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo1[] = {{"D_CR_DTR9A", "", 0x00000004, 5, 0x00000000FFFFFFFF, 0x000000000014A546}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields2[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000010, "RW", "tckckeh", "Number of valid clocks before CKE high (in DRAM clocks).\r\n"
"  [list]\r\n"
"  [*]LPDDR4: The value in this register covers both tCKCKEH and tCSCKEH.\r\n"
"  [*]DDR3L/DDR4/LPDDR3/WIO2: The value covers tCKSRX which is defined as the number of valid DRAM clocks that have to toggle before the issuing of the Self Refresh Exit SRX. This value is also used if the clock frequency is changed or the clock is stopped or tristated during Power Down i.e. the number valid DRAM clocks that have to toggle before the issuing of the Power Down Exit PDX command.\r\n"
"  [/list]\r\n"
"  [p]TCKCKEH can be used to compensate for clock stabilization delays in the motherboard.[/p]\r\n"
"      [p]Note: D-unit hardware enforces minimum of two SPID clock before CKEH, any value in this register is the additional time.[/p]"},
#else
{27, 31, 0x0000000000000010, "RW", "tckckeh", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 26, 0x0000000000000008, "RW", "txsdll", "D-Unit waits max(tXSR+tZQCL/tZQCS, tXSDLL) before allowing traffic to DRAM (in 32 x DRAM Clocks). \r\n"
"      [p]LPDDR3/LPDDR4/WIO2: tXSDLL = 0.[/p] \r\n"
"      [p]DDR3L/DDR4: tXSDLL = tDLLK.[/p]\r\n"
"      [p]Note: In the equation above, tZQCL/tZQCS = 0 if no ZQ is performed on SR exit.[/p]"},
#else
{22, 26, 0x0000000000000008, "RW", "txsdll", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 21, 0x0000000000000070, "RW", "txsr", "DDR3L/DDR4: tXS - Delay between Self Refresh Exit SRX to any DRAM Command not requiring DLL Lock.\r\n"
"  [p]LPDDR/WIO2: tXSR - Delay between Self Refresh Exit SRX to any DRAM Command. (in DRAM clocks).[/p]"},
#else
{12, 21, 0x0000000000000070, "RW", "txsr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 11, 0x000000000000000B, "RW", "trcd", "Specifies the delay between a DRAM Activate command and a DRAM Read or Write command to the same bank (in DRAM clocks).\r\n"
"  [p]Note: Derating adds 1.875ns to this timing.[/p]"},
#else
{6, 11, 0x000000000000000B, "RW", "trcd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x000000000000000B, "RW", "trppb", "Specifies the delay between a DRAM Precharge command and a DRAM Activate command to the same bank (in DRAM Clocks). \r\n"
"      [p]Note : this CR should be constrained to a minimum of 4 in LPDDR3/DDR3L/WIO2 and minimum of 8 in LPDDR4/DDR4.[/p]\r\n"
"  [p]Note: Derating adds 1.875ns to this timing.[/p]"},
#else
{0, 5, 0x000000000000000B, "RW", "trppb", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo2[] = {{"D_CR_DTR0A", "", 0x00000008, 5, 0x00000000FFFFFFFF, 0x00000000820702CB}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields3[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000006, "RW", "txp", "Specifies the delay from the DRAM Power Down Exit (PDX) command to any valid command (in DRAM clocks).\r\n"
"      [p]Note: The value in this field must be programmed to tXPDLL when Slow Exit Mode Power-down is enabled for DDR3L.[/p]"},
#else
{27, 31, 0x0000000000000006, "RW", "txp", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RO", "rsvd26", "Reserved."},
#else
{26, 26, 0x0000000000000000, "RO", "rsvd26", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 25, 0x0000000000000120, "RW", "tzqcl", "\r\n"
"  [list]\r\n"
"  [*]LPDDR3/DDR3L/DDR4: tZQCL/tZQoper - Specifies the delay between the DRAM ZQ Calibration Long (ZQCL) command and any DRAM command during normal operation. \r\n"
"  [*]LPDDR4: tZQCAL - ZQ Calibration time (in DRAM clocks).\r\n"
"  [/list]\r\n"
"  [p]Note: This field defines the ZQ Calibration Long delay during normal operation. It is not the same as tZQinit which uses the same ZQCL command but the delay is longer. tZQinit applies only during poweron initialization of the DRAM devices and tZQoper applies during normal operation. BIOS executes the DRAM initialization sequence so it has to ensure tZQinit is met and not the D-Unit.[/p]"},
#else
{14, 25, 0x0000000000000120, "RW", "tzqcl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 13, 0x0000000000000048, "RW", "tzqcs", "ZQCS to any DRAM Command Delay:  Specifies the delay between the DRAM ZQ Calibration Short (ZQCS) command and any DRAM command (in DRAM clocks).\r\n"
"  [p]DDR3L/DDR4/LPDDR3 only. LPDDR4 does not support ZQCS command[/p]"},
#else
{6, 13, 0x0000000000000048, "RW", "tzqcs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000018, "RW", "tzqlat", "Specifies the delay between the DRAM ZQ Calibration Latch command and any DRAM command (in DRAM clocks).\r\n"
"  [p]LPDDR4 only. Not used in DDR3L/DDR4/LPDDR3/WIO2.[/p]"},
#else
{0, 5, 0x0000000000000018, "RW", "tzqlat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo3[] = {{"D_CR_DTR1A", "", 0x0000000C, 5, 0x00000000FFFFFFFF, 0x0000000030481218}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields4[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{22, 31, 0x0000000000000118, "RW", "nrfcab", "Specifies the delay between the REFab command to the next valid command. (in DRAM clocks)"},
#else
{22, 31, 0x0000000000000118, "RW", "nrfcab", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RO", "rsvd21", "Reserved."},
#else
{21, 21, 0x0000000000000000, "RO", "rsvd21", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 20, 0x0000000000000004, "RW", "tcke", "Specifies the minimum time from CKEL to CKEH (in DRAM clocks)."},
#else
{17, 20, 0x0000000000000004, "RW", "tcke", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RO", "rsvd16", "Reserved."},
#else
{16, 16, 0x0000000000000000, "RO", "rsvd16", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000C30, "RW", "nrefi", "Specifies the average time between refresh commands. JEDEC Base Refresh Interval time (in DRAM clocks).\r\n"
"      [p]Note: D-Unit will ignore the 2 LSBs of this field.[/p]"},
#else
{0, 15, 0x0000000000000C30, "RW", "nrefi", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo4[] = {{"D_CR_DTR2A", "", 0x00000010, 5, 0x00000000FFFFFFFF, 0x0000000046080C30}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields5[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000006, "RW", "trtp", "Specifies the minimum delay between the DRAM Read and Precharge commands to the same bank (in DRAM clocks).\r\n"
"  [list]\r\n"
"  [*]LPDDR3 Equation: = BL/2 + tRTP - 4.\r\n"
"  [*]LPDDR4 Equation: = BL/2 + Max (8, tRTP) - 8.\r\n"
"  [*]WIO2 Equation: = BL/2 + tRTP - 2.\r\n"
"      [*]DDR3L/DDR4 Equation: = tRTP.\r\n"
"  [/list]"},
#else
{27, 31, 0x0000000000000006, "RW", "trtp", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 26, 0x0000000000000000, "RW", "tccd_inc", "Specifies the number of clocks to be added to turnaround times (for Stretch Mode). It increases delay between Read to Read or Read to Write commands by the amount programmed in this field (in 4 x DRAM clocks)."},
#else
{20, 26, 0x0000000000000000, "RW", "tccd_inc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 19, 0x0000000000000017, "RW", "twtp", "Specifies the minimum delay between the DRAM Write command and the Precharge command to the same bank (in DRAM clocks).\r\n"
"  [list]\r\n"
"      [*]LPDDR3/LPDDR4/WIO2 Equation: tWTP = BL/2 + WL + tWR + 1.\r\n"
"      [*]DDR3L/DDR4 Equation: tWTP = BL/2 + CWL + tWR.\r\n"
"      [/list]"},
#else
{13, 19, 0x0000000000000017, "RW", "twtp", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 12, 0x0000000000000001, "RW", "tcmd", "Specifies the number of DRAM clocks a command is held valid on the DRAM Address and Control buses. 1N is the DDR3 basic requirement.  2N is the extended mode for board signal integrity. \r\n"
"  [list]\r\n"
"  [*]0h: Reserved.\r\n"
"  [*]1h: 1 DRAM Clock (1N).\r\n"
"  [*]2h: 2 DRAM Clocks (2N).\r\n"
"  [*]3h: Reserved.\r\n"
"  [/list]\r\n"
"  [p]Note: DDR3L/DDR4 only. tCMD must be set to 1N for LPDDR3/LPDDR4/WIO2.[/p]"},
#else
{11, 12, 0x0000000000000001, "RW", "tcmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 10, 0x0000000000000008, "RW", "tcwl", "The delay between the internal write command and the availability of the first word of DRAM input data (in DRAM clocks)."},
#else
{6, 10, 0x0000000000000008, "RW", "tcwl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000028, "RW", "twmwsb", "Specifies the minimum delay between DRAM Write command to Masked Write command to same bank (in DRAM clocks).\r\n"
"      [list]\r\n"
"  [*]LPDDR4 Equation: tWMWSB = tCCDMW (BL16) or tCCDMW + 8 (BL32).\r\n"
"  [*]WIO2 Equation: tWMWSB = tCCDMW (BL4) or tCCDMW + 2 (BL8).\r\n"
"  [/list]\r\n"
"  [p]Note: Masked Write operation in LPDDR4 is always BL16 and in WIO2 is always BL4.[/p]\r\n"
"  [p]D-Unit applies this timing for same rank as well as same bank, refer to D-Unit HAS for more details.[/p]"},
#else
{0, 5, 0x0000000000000028, "RW", "twmwsb", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo5[] = {{"D_CR_DTR3A", "", 0x00000014, 6, 0x00000000FFFFFFFF, 0x000000003002EA28}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields6[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000030, "RW", "tfaw", "A rolling timeframe in which a maximum of four Activate commands can be issued to the same rank. This is to limit the peak current draw from the DRAM devices (in DRAM clocks)."},
#else
{24, 31, 0x0000000000000030, "RW", "tfaw", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 23, 0x0000000000000008, "RW", "twrdr", "Specifies the delay from the start of a Write data burst of one rank to the start of a Read data burst of a different rank (in DRAM clocks).\r\n"
"  [list]\r\n"
"  [*]LPDDR3 Equation: tWRDR = WL + tDQSSmax + BL/2 - (RL + tDQSCKmin - tRPRE).\r\n"
"  [*]LPDDR4 Equation: tWRDR = WL - RL + BL/2 + 4 - tDQSCKmin.\r\n"
"      [*]DDR3L/DDR4 Equation: tWRDR = CWL + tDQSSmax + BL/2 - (CL + tDQSCKmin - tRPRE).\r\n"
"      [/list]   \r\n"
"  [p]Note: For LPDDR3/4 using ODT, this latency may need to be increased by tODToffadj.[/p]"},
#else
{18, 23, 0x0000000000000008, "RW", "twrdr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 17, 0x0000000000000009, "RW", "trwdr", "Specifies the delay from the start of a Read data burst of one rank to the Start of a Write data burst of a different rank (in DRAM clocks).\r\n"
"  [list]\r\n"
"  [*]LPDDR3/LPDDR4 Equation: tRWDR = RL + tDQSCKmax + BL/2 - (WL - tWPRE).\r\n"
"      [*]DDR3L/DDR4 Equation: tRWDR = CL + tDQSCKmax + BL/2 - (CWL - tWPRE).\r\n"
"  [/list]\r\n"
"  [p]Note: For LPDDR3/4 using ODT, this latency may need to be adjusted by tODTon.[/p]\r\n"
"      [p]Note: For DDR3L/DDR4 using ODT, this latency may need to be increased by one clock.[/p]"},
#else
{12, 17, 0x0000000000000009, "RW", "trwdr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 11, 0x0000000000000005, "RW", "twwdr", "Specifies the delay from the start of a Write data burst of one rank to the start of a Write data burst of a different rank (in DRAM clocks).\r\n"
"  [list]\r\n"
"  [*]LPDDR3/DDR3L/DDR4 Equation: tWWDR = BL/2 + tDQSSmax - tDQSSmin + tWPRE.\r\n"
"  [*]LPDDR4 Equation: tWWDR = BL/2 + 4 - tDQSSmin.\r\n"
"  [/list]\r\n"
"  [p]Note: For LPDDR3/4 using ODT, this latency may need to be increased by tODToffadj.[/p]"},
#else
{6, 11, 0x0000000000000005, "RW", "twwdr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000009, "RW", "trrdr", "Specifies the delay from the start of a Read data burst of one rank to the Start of a Read data burst of a different rank (in DRAM clocks).\r\n"
"      [list]\r\n"
"  [*]Equation: tRRDR = BL/2 + tDQSCKmax - tDQSCKmin + tRPRE.\r\n"
"      [/list]"},
#else
{0, 5, 0x0000000000000009, "RW", "trrdr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo6[] = {{"D_CR_DTR4A", "", 0x00000018, 5, 0x00000000FFFFFFFF, 0x0000000030209149}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields7[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000006, "RW", "trrd", "Specifies the minimum delay in DRAM clocks between two DRAM Activate commands to the same rank but different banks (tRC is the minimum delay between activations of the same bank).\r\n"
"  [p]Note: Derating adds 1.875ns to this timing.[/p]"},
#else
{27, 31, 0x0000000000000006, "RW", "trrd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RO", "rsvd26", "Reserved."},
#else
{26, 26, 0x0000000000000000, "RO", "rsvd26", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 25, 0x0000000000000000, "RW", "tderate_inc", "Specifies the additional delay that is added to DRAM timing when indicated by MR4 status. (in DRAM clocks)\r\n"
"  [p]LPDDR3/LPDDR4/WIO2: Value is 1.875ns.[/p]\r\n"
"  [p]Note: The value in this register is only added to these timing parameters: tRCD, tRAS, tRP and tRRD.[/p]"},
#else
{23, 25, 0x0000000000000000, "RW", "tderate_inc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 22, 0x0000000000000010, "RW", "twwsr", "Specifies the delay from a DRAM Write to another Write command of the same rank (in DRAM clocks).\r\n"
"  [p]Equation: tWWSR = tCCD.[/p]"},
#else
{18, 22, 0x0000000000000010, "RW", "twwsr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 17, 0x0000000000000010, "RW", "trrsr", "Specifies the delay from a DRAM Read to another Read command of the same rank (in DRAM clocks).\r\n"
"  [p]Equation: tRRSR = tCCD.[/p]"},
#else
{13, 17, 0x0000000000000010, "RW", "trrsr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 12, 0x0000000000000003, "RW", "twrsr", "Specifies the delay from a DRAM Read to Write command of the same rank (in DRAM clocks).\r\n"
"      [list]\r\n"
"  [*]LPDDR3/LPDDR4/WIO2 Equation: tWRSR  = WL + tDQSSmax + BL/2 + tWTR.\r\n"
"      [*]DDR3L Equation: tWRSR  = CWL + tDQSSmax + BL/2 + tWTR.\r\n"
"      [*]DDR4 Equation: tWRSR  = CWL + tDQSSmax + BL/2 + tWTR_S.\r\n"
"      [/list]"},
#else
{6, 12, 0x0000000000000003, "RW", "twrsr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000002, "RW", "trwsr", "Specifies the delay from a DRAM Read to a Write command of the same rank (in DRAM clocks).\r\n"
"      [list]\r\n"
"  [*]LPDDR3/LPDDR4/WIO2 Equation: tRWSR = RL + tDQSCKmax + BL/2 - WL + tWPRE.\r\n"
"      [*]DDR3L/DDR4 Equation: tRWSR = CL + tDQSCKmax + BL/2 - CWL + tWPRE.\r\n"
"      [/list]\r\n"
"  [p]Note: For LPDDR3/4 using ODT, this latency may need to be increased by tODToffadj.[/p]\r\n"
"      [p]Note: For DDR3L/DDR4 using ODT, this latency may need to be increased by one clock.[/p]"},
#else
{0, 5, 0x0000000000000002, "RW", "trwsr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo7[] = {{"D_CR_DTR5A", "", 0x0000001C, 7, 0x00000000FFFFFFFF, 0x00000000304200C2}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields8[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000020, "RW", "orefdly", "Rank idle period that defines an opportunity for refresh (in DRAM clocks)."},
#else
{24, 31, 0x0000000000000020, "RW", "orefdly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 23, 0x0000000000000002, "RW", "tckckel", "Specifies the amount of time that DRAM clocks need to toggle after CKE goes low (in DRAM Clocks).\r\n"
"  [list]\r\n"
"  [*]For WIO2/LPDDR3, this covers tCPDED.\r\n"
"  [*]For LPDDR4, this covers both tCKELCK and tCKELCS.\r\n"
"  [*]For DDR3L/DDR4, this is tCKSRE.\r\n"
"      [/list]\r\n"
"  [p]Note: D-Unit hardware enforces minimum of one SPID clocks after CKEL, any value in this register is the additional time.[/p]"},
#else
{19, 23, 0x0000000000000002, "RW", "tckckel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 18, 0x0000000000000000, "RW", "rsvd18_15", "Reserved."},
#else
{15, 18, 0x0000000000000000, "RW", "rsvd18_15", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 14, 0x0000000000000000, "RW", "tpstmrrblk", "Specifies the quiet time after issuing MRR command (in DRAM Clocks). This is the channel block time for the MR19 command issued as part of LPDDR4 DQS Retraining flow. For all other MR commands this is the rank block time.   \r\n"
"      [p]Note: D-Unit treats MRR as a read and always applies relevant turnaround times, any value programmed in this CR must be greater than those turnaround times for D-Unit to enforce any additional time from MRR to the next read/write.[/p]"},
#else
{8, 14, 0x0000000000000000, "RW", "tpstmrrblk", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO", "rsvd7", "Reserved."},
#else
{7, 7, 0x0000000000000000, "RO", "rsvd7", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW", "tpremrblk", "Specifies the channel quiet time before issuing MRR/MRW command. (in DRAM clocks).\r\n"
"      [list]\r\n"
"      [*]LPDDR3 Equation: = tXP + tMRRI - 4.\r\n"
"      [*]LPDDR4 Equation: = tXP + tMRRI - 8.\r\n"
"      [*]DDR3L Equation: = CWL + BL/2 + 1 - 8\r\n"
"      [*]DDR4 Equation: = CWL + BL/2 + 1 - 16.\r\n"
"      [/list]\r\n"
"      [p]Note: D-Unit treats MRR as a read and MRW/MRS as a write and always applies relevant turnaround times, any value programmed in this CR must be greater than those turnaround times for D-Unit to enforce any additional time from previous read/writes.[/p]"},
#else
{0, 6, 0x0000000000000000, "RW", "tpremrblk", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo8[] = {{"D_CR_DTR6A", "", 0x00000020, 6, 0x00000000FFFFFFFF, 0x0000000020100000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields9[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{26, 31, 0x0000000000000003, "RW", "trpab", "Specifies the delay between a DRAM Precharge All Bank command and a DRAM Activate command (in DRAM Clocks). \r\n"
"      [p]Note: This CR should be constrained to a minimum of 4 in LP3 and minimum of 8 in LP4.[/p]\r\n"
"  [p]Note: Derating adds 1.875ns to this timing.[/p]\r\n"
"  [list]\r\n"
"  [*]For LPDDR, tRPpb = tRP, tRPab = tRP + 3ns.\r\n"
"  [*]For DDR3L, DDR4 and WIO2 8ch tRPpb = tRPab = tRP.\r\n"
"  [/list]"},
#else
{26, 31, 0x0000000000000003, "RW", "trpab", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 25, 0x0000000000000002, "RW", "tpstmrwblk", "Specifies the quiet time after issuing MRW command (in 8 x DRAM clocks).\r\n"
"      [p]Note: This time covers for both tMRD and tMRW.[/p]"},
#else
{23, 25, 0x0000000000000002, "RW", "tpstmrwblk", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 22, 0x0000000000000006, "RW", "twrpden", "Specifies the minimum time between a write command to PowerDown command (in DRAM clocks).\r\n"
"  [p]Must be at least equal to tWR + tCCD + tWL + 2.[/p]"},
#else
{16, 22, 0x0000000000000006, "RW", "twrpden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 15, 0x0000000000000006, "RW", "trdpden", "Specifies the minimum time between a read command to PowerDown command (in DRAM clocks).\r\n"
"  [p]Must be at least equal to CL/RL + tDQSCKmax + tCCD + 1.[/p]"},
#else
{9, 15, 0x0000000000000006, "RW", "trdpden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RO", "rsvd8_7", "Reserved."},
#else
{7, 8, 0x0000000000000000, "RO", "rsvd8_7", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000006, "RW", "tras", "Specifies the minimum delay between the DRAM Activate and Precharge commands to the same bank (in DRAM clocks).\r\n"
"      [p]Note: Derating adds 1.875ns to this timing.[/p]"},
#else
{0, 6, 0x0000000000000006, "RW", "tras", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo9[] = {{"D_CR_DTR7A", "", 0x00000024, 6, 0x00000000FFFFFFFF, 0x000000000D060C06}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields10[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{26, 31, 0x0000000000000003, "RW", "tckesr", "Specifies the minimum time that DRAM should remain in SR (in DRAM clocks)."},
#else
{26, 31, 0x0000000000000003, "RW", "tckesr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 25, 0x0000000000000006, "RW", "lpmdres", "Specifies the minimum time that PHY should remain in LPMode (in DRAM clocks)."},
#else
{21, 25, 0x0000000000000006, "RW", "lpmdres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 20, 0x000000000000000A, "RW", "lpmdtockedly", "Specifies the minimum time between the LP Mode exit to the CK stop/tristate deassertion and powerdown exit (in DRAM clocks).\r\n"
"  [p]Note: Must be equal to t_idle_latency published in the DDRIO PHY HAS and less than 0x3C.[/p]"},
#else
{15, 20, 0x000000000000000A, "RW", "lpmdtockedly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 14, 0x000000000000000A, "RW", "cketolpmddly", "Specifies the time between CK stop/tristate to the Low Power Mode entry. This timing parameter is used to delay Low Power Mode entry (in DRAM clocks).\r\n"
"  [p]Note: Must be at least equal to t_idle_length parameter published in the DDRIO PHY HAS and less than 0x7C.[/p]"},
#else
{8, 14, 0x000000000000000A, "RW", "cketolpmddly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000018, "RW", "pwddly", "This is a non-JEDEC timing parameter used to delay powerdown entry (in DRAM clocks)."},
#else
{0, 7, 0x0000000000000018, "RW", "pwddly", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo10[] = {{"D_CR_DTR8A", "", 0x00000028, 5, 0x00000000FFFFFFFF, 0x000000000CC50A18}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields11[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", "Reserved."},
#else
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW", "r1rdodtctl", "Specifies the behavior of ODT signals when a Read command is issued to Rank 1.\r\n"
"      [p]0 - Read ODT is disabled for Rank 1[/p] \r\n"
"      [p]1 - Assert ODT to for Rank 0 (non-targeted Rank) [/p]\r\n"
"      [p]Note: This register should be set to 0 for LPDDR3 devices[/p]"},
#else
{29, 29, 0x0000000000000000, "RW", "r1rdodtctl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "r0rdodtctl", "Specifies the behavior of ODT signals when a Read command is issued to Rank 0.\r\n"
"      [p]0 - Read ODT is disabled for Rank 0 [/p]\r\n"
"      [p]1 - Assert ODT to for Rank 1 (non-targeted Rank) [/p]\r\n"
"      [p]Note: This register is reserved for LPDDR3 devices[/p]"},
#else
{28, 28, 0x0000000000000000, "RW", "r0rdodtctl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RW", "r1wrodtctl", "Specifies the behavior of ODT signals when a Write command is issued to Rank 1.\r\n"
"      [p]00 - Write ODT is disabled [/p]\r\n"
"      [p]01 - Assert ODT to Rank 0 (non-targeted Rank) [/p]\r\n"
"      [p]10 - Assert ODT to Rank 1 (targeted Rank) [/p]\r\n"
"      [p]11 - Assert ODT to Rank 0 and Rank 1 [/p]\r\n"
"      [p]Note: 10 and 11 are reserved values for LPDDR3[/p]"},
#else
{26, 27, 0x0000000000000000, "RW", "r1wrodtctl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "r0wrodtctl", "Specifies the behavior of ODT signals when a Write command is issued to Rank 0.\r\n"
"      [p]00 - Write ODT is disabled [/p]\r\n"
"      [p]01 - Assert ODT to Rank 0 (targeted Rank) [/p]\r\n"
"      [p]10 - Assert ODT to Rank 1 (non-targeted Rank) [/p]\r\n"
"      [p]11 - Assert ODT to Rank 0 and Rank 1 [/p]\r\n"
"      [p]Note: 10 and 11 are reserved values for LPDDR3[/p]"},
#else
{24, 25, 0x0000000000000000, "RW", "r0wrodtctl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 23, 0x0000000000000000, "RO", "rsvd23_18", "Reserved."},
#else
{18, 23, 0x0000000000000000, "RO", "rsvd23_18", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 17, 0x0000000000000000, "RW", "rdodtstop", "Specifies Read ODT assertion to ODT de-assert delay (in DRAM clocks).\r\n"
"      [p]DDR3L Equation: RDODTSTOP = 6.[/p]\r\n"
"      [p]DDR4 Equation: RDODTSTOP = 5 + tRPRE.[/p]\r\n"
"      [p]Note: Add 1 if DOCRx.RDODTSTART = CL - CWL in 2N mode.[/p]"},
#else
{14, 17, 0x0000000000000000, "RW", "rdodtstop", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 13, 0x0000000000000000, "RO", "rsvd13", "Reserved."},
#else
{13, 13, 0x0000000000000000, "RO", "rsvd13", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 12, 0x0000000000000000, "RW", "rdodtstart", "Specifies Read ODT assertion delay after Read Command (in DRAM clocks).\r\n"
"      [p]DDR3L/DDR4 Equation: RDODTSTART = CL - CWL + tWPRE - tRPRE.[/p]\r\n"
"      [p]Note: In DDR3L/DDR4 2N mode add 1 to enable termination at the start of read data burst.[/p]"},
#else
{9, 12, 0x0000000000000000, "RW", "rdodtstart", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 8, 0x0000000000000000, "RW", "wrodtstop", "Specifies number of clocks after ODT assertion that D-Unit deasserts ODT signal (in DRAM clocks).\r\n"
"      [p]LPDDR3 Equation: WRODTSTOP = RU(tODTon(max)/tCK) + RU((tDQSSmax+tWPST)/tCK) + BL/2 - RD(tODToffmin/tCK)[/p]\r\n"
"      [p]DDR3L Equation: WRODTSTOP = 6.[/p]\r\n"
"      [p]DDR4 Equation: WRODTSTOP = 5 + tWPRE.[/p]\r\n"
"      [p]Note: Add 1 if DOCRx.WRODTSTART = 0 in 2N mode.[/p]"},
#else
{5, 8, 0x0000000000000000, "RW", "wrodtstop", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RO", "rsvd4", "Reserved."},
#else
{4, 4, 0x0000000000000000, "RO", "rsvd4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "wrodtstart", "Specifies number of clocks after Write command that D-Unit asserts ODT signal (in DRAM clocks).\r\n"
"      [p]LPDDR3 Equation: WRODTSTART = WL - RU(tODTon(max)/tCK) [/p]\r\n"
"      [p]DDR3L/DDR4 Equation: WRODTSTART = 0[/p]\r\n"
"      [p]Note: In DDR3L/DDR4 2N mode the value can be set to 0 to assert ODT one DRAM clock earlier than the Write Command (WR) or set to 1 to assert at the same clock as command (CS assertion).[/p]"},
#else
{0, 3, 0x0000000000000000, "RW", "wrodtstart", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo11[] = {{"D_CR_DOCRA", "", 0x0000002C, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields12[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RO", "rsvd31_29", "Reserved."},
#else
{29, 31, 0x0000000000000000, "RO", "rsvd31_29", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "suspmop", "DDRIO PHY Power Mode Opcode: After the D-Unit has placed the DRAM devices in Self Refresh/PASR mode as the result of a SUSPEND/SUSPENDP message, it sends this 5-bit value to the DDRIO PHY to tell it which power saving mode it should enter.\r\n"
"  [p]Changing this register value while in SUSPEND will have no effect.[/p]\r\n"
"  [p]Note: This opcode cannot be a PM state where it disables PHY PLLs i.e PM7 in LPDDR PHY.[/p]"},
#else
{24, 28, 0x0000000000000000, "RW", "suspmop", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RO", "rsvd23", "Reserved."},
#else
{23, 23, 0x0000000000000000, "RO", "rsvd23", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "srpmclkw", "Specifies when it is safe to send PM message to the PHY. When enabled, D-Unit waits for SPID Clock to deassert before sending a PM message on SR entry.\r\n"
"  [list]\r\n"
"  [*]0: D-Unit will not wait for SPID_clk to deassert before sending the PM message to PHY.\r\n"
"  [*]1: D-Unit will wait for SPID_clk to deassert before sending PM message to the PHY.\r\n"
"      [/list]\r\n"
"  [p]Note: The value must be 1 when DYNPMOP = 7h.[/p]"},
#else
{22, 22, 0x0000000000000000, "RW", "srpmclkw", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 21, 0x0000000000000000, "RW", "dynpmop", "DDRIO PHY Power Mode Opcode:  After the D-Unit has placed the DRAM devices in Self Refresh mode as the result of a Dynamic Self-Refresh, it sends this 5bit value to the DDRIO PHY to tell it which power saving mode it should enter. \r\n"
"  [p]Changing this register value while in self-refresh will only change the PM state for the next entry in DynSR.[/p]"},
#else
{17, 21, 0x0000000000000000, "RW", "dynpmop", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dynsren", "When set to 1, the D-Unit will automatically control DRAM Self Refresh entry and exit based on interface state and requests in pending queues. When there is no pending request in the queues and PMI is idle, then the D-Unit will place the DRAM devices in Self Refresh mode. The DRAM devices will be brought out of Self-Refresh when idle conditions don't hold."},
#else
{16, 16, 0x0000000000000000, "RW", "dynsren", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW", "sredly", "Specifies the minimum time the D-Unit will wait before it enters Dynamic Self-Refresh mode when idle (in 16x DRAM Clocks). \r\n"
"      [p]Note: The value in this field needs to be minimum of 4 in functional mode and minimum of 50 in PSMI mode.[/p]"},
#else
{0, 15, 0x0000000000000000, "RW", "sredly", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo12[] = {{"D_CR_DPMC0", "", 0x00000030, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields13[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", "Reserved."},
#else
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW", "rptclkgtdis", "Setting this bit to 0 allows majority of the repeaters between D-Unit and PHY to clock gate when there is no activity in order to save power.\r\n"
"      [list]\r\n"
"      [*]0 -  Enable Repeaters clock gating.  \r\n"
"      [*]1 -  Disable Repeaters clock gating.\r\n"
"      [/list]\r\n"
"      [p]Note: This is a de-feature bit and should be set to 0 for normal operation.[/p]\r\n"
"      [p]Note: The value should only change after DRAM Timing Registers (DTR) are programmed.[/p]"},
#else
{29, 29, 0x0000000000000000, "RW", "rptclkgtdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000001, "RW", "sbepclkgtdis", "Setting this bit to 0 enables the clock gating of IOSF-SB End Points in D-Unit and CPGC when there is no IOSF-SB activity in order to save power.\r\n"
"      [list]\r\n"
"      [*]0 -  Enable IOSF-SB EP clock gating.\r\n"
"      [*]1 -  Disable IOSF-SB clock gating.\r\n"
"      [/list] \r\n"
"      [p]Note: This is a de-feature bit and should be set to 0 for normal operation.[/p]\r\n"
"      [p]Note: The value should only change after DRAM Timing Registers (DTR) are programmed.[/p]"},
#else
{28, 28, 0x0000000000000001, "RW", "sbepclkgtdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RW", "clkgtdis", "Setting this bit to 0 allows the majority of the D-Unit clocks to be gated off when there is no activity in order to save power. \r\n"
"  [p]When set to 1, D-Unit clockgating is disabled.[/p]\r\n"
"  [list]\r\n"
"  [*]0: Enable.  \r\n"
"  [*]1: Disable. \r\n"
"      [/list]\r\n"
"  [p]Note: This is a de-feature bit and should be set to 0 for normal operation.[/p]\r\n"
"      [p]Note: The value should only change after DRAM Timing Registers (DTR) are programmed.[/p]"},
#else
{27, 27, 0x0000000000000000, "RW", "clkgtdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "cstrist", "\r\n"
"  [list]\r\n"
"  [*]0: The DRAM CS pins associated with the enabled ranks are never tristated.  \r\n"
"  [*]1: The DRAM CS pins are tristated when DRAM clock is stopped or tristated.\r\n"
"  [/list]\r\n"
"  [p]Note: CS is not tristated when global tristate flow is disabled (DCBR.TRISTDIS = 1).[/p]"},
#else
{26, 26, 0x0000000000000000, "RW", "cstrist", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "cmdtrist", "\r\n"
"      [list]\r\n"
"      [*]00: The DRAM CA pins are never tristated. \r\n"
"      [*]01: The DRAM CA pins are only tristated when all enabled CKE pins are low.\r\n"
"      [*]10: The DRAM CA pins are tristated when not driving a valid command.\r\n"
"      [*]11: Reserved\r\n"
"      [/list]"},
#else
{24, 25, 0x0000000000000000, "RW", "cmdtrist", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "pasr", "This is the Segment Mask used for the MRW to enable PASR during SUSPENDP (Partial Array Self Refresh entry)."},
#else
{16, 23, 0x0000000000000000, "RW", "pasr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "pclsto", "Specifies the time from the last access of a DRAM page until that page is scheduled to close by sending a Precharge command to DRAM (in 16 x DRAM clocks)."},
#else
{8, 15, 0x0000000000000000, "RW", "pclsto", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "pclstodis", "When disabled, D-Unit will not close the DRAM page when idle. \r\n"
"  [list]\r\n"
"  [*]0: Enable page close timer.  \r\n"
"  [*]1: Disable page close timer (Used during DRAM init and DDRIO training).\r\n"
"  [/list]"},
#else
{7, 7, 0x0000000000000000, "RW", "pclstodis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO", "rsvd6", "Reserved."},
#else
{6, 6, 0x0000000000000000, "RO", "rsvd6", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000001, "RW", "odttrist", "\r\n"
"      [list]\r\n"
"      [*]0: The DRAM ODT pins associated with the enabled ranks are never tristated.  \r\n"
"      [*]1: DRAMs ODT pins are tristated when DRAM clock is stopped or tristated.\r\n"
"      [/list]\r\n"
"      [p]Note: ODT is not tristated when global tristate flow is disabled (DCBR.TRISTDIS = 1)[/p]"},
#else
{5, 5, 0x0000000000000001, "RW", "odttrist", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 4, 0x0000000000000001, "RW", "enckstp", "Enable/Disable CK Stop/Tristate During Power down.\r\n"
"  [list]\r\n"
"  [*]00: Disable CK Stop/Tristate During Power down. \r\n"
"  [*]01: Enable CK Stop During Power down. \r\n"
"  [*]10: Enable CK Tristate During Power down. \r\n"
"  [*]11: Reserved\r\n"
"      [/list]\r\n"
"      [p]Note: CK is not stopped or tristated when global tristate flow is disabled (DCBR.TRISTDIS = 1).[/p]"},
#else
{3, 4, 0x0000000000000001, "RW", "enckstp", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 2, 0x0000000000000000, "RW", "lpmodeop", "D-Unit will send the value in this register after it has entered Powerdown Mode and has stopped/tristated the clock. \r\n"
"  [p]00: Disable LPMode.[/p]\r\n"
"      [p]Note: LPMODE entry is not possible when global tristate flow is disabled (DCBR.TRISTDIS = 1).[/p]"},
#else
{1, 2, 0x0000000000000000, "RW", "lpmodeop", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "dispwrdn", "Setting this bit to 1 disables dynamic control of DRAM Power-Down entry and exit by keeping the CKE pins driven high. BIOS may set it to 1 during DRAM initialization and DDRIO training. This bit should be set to 0 for normal operation. \r\n"
"  [list]\r\n"
"  [*]0: The D-Unit dynamically controls the CKE pins to place the DRAM devices in Power Down mode and bring them out of Power Down mode. \r\n"
"  [*]1: The D-Unit constantly drives the CKE pins high to keep the DRAM devices from entering Power Down mode when ranks are idle. \r\n"
"  [/list]\r\n"
"  [p]Note: This bit is overridden if CKEMODE = 1.[/p]\r\n"
"  [p]This bit does not control CKE behavior on SR entry/exit.[/p]"},
#else
{0, 0, 0x0000000000000000, "RW", "dispwrdn", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo13[] = {{"D_CR_DPMC1", "", 0x00000034, 14, 0x00000000FFFFFFFF, 0x0000000010000028}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields14[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000001, "RW", "mntchnblktime", "Specifies the amount of time that D-unit will block the channel before any DRAM maintenance operation is issued. (in SPIDclk)"},
#else
{29, 31, 0x0000000000000001, "RW", "mntchnblktime", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 28, 0x0000000000000000, "RW", "mntdlycascount", "When a critical read request is pending in RPQ and a maintenance operation (MRR, ZQCal, Ref, etc.) needs to be performed, D-unit delays the maintenance operation and allows this many read or write requests to be scheduled before allowing the maintenance operation.\r\n"
"      [p]Note: This mode does not apply to Panic refreshes.[/p]"},
#else
{25, 28, 0x0000000000000000, "RW", "mntdlycascount", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 24, 0x0000000000000000, "RO", "rsvd24_22", "Reserved."},
#else
{22, 24, 0x0000000000000000, "RO", "rsvd24_22", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "disrefdbtclr", "When set, D-Unit will not clear refresh debt before Self Refresh SR Entry:\r\n"
"  [list]\r\n"
"  [*]0: D-Unit sends all postponed REF commands to DRAM before it enters Self Refresh. \r\n"
"  [*]1: D-Unit enters SR without clearing the Refresh Debt (for Debug only).\r\n"
"  [/list]"},
#else
{21, 21, 0x0000000000000000, "RW", "disrefdbtclr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "refskwdis", "Disables Skewing of Refresh Counting between Ranks.  \r\n"
"  [p]Each rank has its own refresh counter. By default incrementing these refresh counters are skewed by 1/2 the tREFI period. Setting this bit to a 1 disables this feature and all refresh counters will increment at the same time per tREFI period. Skewing the tREFI counters can improve performance since traffic to all ranks does not have to be blocked to perform refresh.[/p] \r\n"
"  [list]\r\n"
"  [*]0: Incrementing the refresh counters are skewed by 1/2 tREFI period. \r\n"
"  [*]1: All refresh counters will increment at the same time per tREFI period. \r\n"
"  [/list]\r\n"
"  [p]Reserved in BXT0/1.[/p]"},
#else
{20, 20, 0x0000000000000000, "RW", "refskwdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RO", "rsvd19_18", "Reserved."},
#else
{18, 19, 0x0000000000000000, "RO", "rsvd19_18", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RO", "rsvd17_16", "Reserved."},
#else
{16, 17, 0x0000000000000000, "RO", "rsvd17_16", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RW", "extrarefdbt", "When set to 1, D-Unit adds one extra refresh debit (for a total of two) on Self-refresh exit."},
#else
{15, 15, 0x0000000000000000, "RW", "extrarefdbt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000001, "RW", "minrefrate", "Ensures that refresh rate never drops below a certain limit regardless of TQ polling. \r\n"
"  [list]\r\n"
"  [*]000: Stop issuing refresh commands and accumulating refresh debits. (does not stop tREFI counter). \r\n"
"  [*]001: 0.25x refresh rate (i.e. 4x tREFI same as no limit).\r\n"
"  [*]010: 0.5x refresh rate (i.e. 2x tREFI). \r\n"
"  [*]011: 1x refresh rate (i.e. 1x tREFI). \r\n"
"  [*]100: 2x refresh rate (i.e. 0.5x tREFI). \r\n"
"  [*]101: 4x refresh rate (i.e. 0.25x tREFI). \r\n"
"  [*]110: 4x refresh rate with derating forced on i.e. 0.25x tREFI. \r\n"
"  [*]111: Reserved.\r\n"
"  [/list]"},
#else
{12, 14, 0x0000000000000001, "RW", "minrefrate", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000007, "RW", "refwmpnc", "When the Refresh counter per rank is greater than this value, the D-Unit will send a REF command to the rank regardless of pending requests.\r\n"
"  [p]Note: REFWMPNC must be greater than or equal to REFWMHI and greater than 2, Max Value must be less than 8 to not violate 9xtREFI JEDEC requirement.[/p]"},
#else
{8, 11, 0x0000000000000007, "RW", "refwmpnc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000005, "RW", "refwmhi", "When the Refresh counter per rank is greater than this value, the D-Unit will send a REF command to the rank if there is no critical priority requests in the pending queues.\r\n"
"  [p]Note: Value must be greater or equal to 1 and less than or equal to REFWMPNC.[/p]"},
#else
{4, 7, 0x0000000000000005, "RW", "refwmhi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 3, 0x0000000000000000, "RO", "rsvd3_1", "Reserved."},
#else
{1, 3, 0x0000000000000000, "RO", "rsvd3_1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "orefdis", "Disable opportunistic scheduling of refresh.\r\n"
"      [list]   \r\n"
"  [*]0: D-Unit will send a REF command only if there is no pending request to that rank.\r\n"
"  [*]1: D-Unit will not send any opportunistic refreshes. Refresh commands are only sent when the refresh counter is greater than REFWMHI.\r\n"
"  [/list]\r\n"
"  [p]Note: When set, DISREFDBTCLR must also be set to be able to enter SR.[/p]"},
#else
{0, 0, 0x0000000000000000, "RW", "orefdis", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo14[] = {{"D_CR_DRFC", "", 0x00000038, 13, 0x00000000FFFFFFFF, 0x0000000020001750}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields15[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "early_dq_en", "Enables D-unit to send the write data to the PHY one clock earlier than WL value (WL - 1). \r\n"
"      [p]Note: Applicable to DDR3L and DDR4 only.[/p]"},
#else
{31, 31, 0x0000000000000000, "RW", "early_dq_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RW", "bgf_early_rddata_valid", "Specifies the number of clocks the D-Unit sends the read data valid through the BGF earlier as compared to the data.\r\n"
"      [list]\r\n"
"      [*]00: Always write read valid in same SPID clock as data (STATIC_0). \r\n"
"      [*]01: Always write read valid one SPID clock before data (STATIC_1). \r\n"
"      [*]10: Write read valid up to 2 SPID clocks before data (DYNAMIC). \r\n"
"      [*]11: Reserved\r\n"
"      [/list]"},
#else
{29, 30, 0x0000000000000000, "RW", "bgf_early_rddata_valid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 28, 0x0000000000000000, "RW", "spid_early_rddata_valid", "Specifies the delay in SPID clocks from RDDATA_VALID assertion to actual data on SPID. The value should match what is programmed in DDRIO (PHY)."},
#else
{27, 28, 0x0000000000000000, "RW", "spid_early_rddata_valid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 26, 0x000000000000001C, "RW", "wpqcount", "Used to limit the number of available slots in Write Pending Queue/ Write Data Buffer. WPQCOUNT will only recognize changes when PMI ISM is not active."},
#else
{21, 26, 0x000000000000001C, "RW", "wpqcount", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000010, "RW", "rpqcount", "Used to limit the number of entries in Read Pending Queue. RPQCOUNT will only recognize changes when PMI ISM is not active."},
#else
{16, 20, 0x0000000000000010, "RW", "rpqcount", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "rsvd15", "Reserved."},
#else
{15, 15, 0x0000000000000000, "RO", "rsvd15", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x0000000000000007, "RW", "blkrdbf_add_rddata_cr", "Number of additional  full cacheline (64B) read data return credits exposed to D-Unit when BLKRDBF is set.\r\n"
"      [p]Note: The value in this field has no effect on Read return credits when BLKRDBF is not set.[/p]"},
#else
{10, 14, 0x0000000000000007, "RW", "blkrdbf_add_rddata_cr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "inordermode", "\r\n"
"  [list]\r\n"
"  [*]0h: In order mode disabled: Commands are sent out of order. \r\n"
"  [*]1h: Partial in order mode: Read and Write CAS commands are sent in the order they were recieved. ACT and PRE can go out of order. \r\n"
"  [*]2h: Full in order mode serialized test: All DRAM commands CAS ACT PRE associated with a PMI request are issued to DDR before any DRAM commands for a subsequent PMI request.  \r\n"
"  [*]3h: Reserved.   \r\n"
"  [/list]\r\n"
"  In order modes should be enabled during init/training/CPGC testing. Should never be changed while the D-Unit queues are nonempty. For WIO2, when in-order mode is enabled (01 or 10), D_CR_DSCH_BYPASSEN must be set to 0"},
#else
{8, 9, 0x0000000000000000, "RW", "inordermode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "bypassen", "When set new page hit/empty read requests will bypass D-Unit pipeline stages to save latency 0 - Disable Idle Bypass 1 - Enable Idle Bypass Note: Only applies to WIO2, this bit is reserved for other technologies"},
#else
{7, 7, 0x0000000000000000, "RW", "bypassen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "blkrdbf", "When set D-Unit stops scheduling new read commands to DRAM when the read data buffer (RDB) is full."},
#else
{6, 6, 0x0000000000000000, "RW", "blkrdbf", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "stretchmode", "When stretch mode is enabled, commands are initiated only on Phase 0 of SPIDClk. \r\n"
"  [list]\r\n"
"  [*]00: Stretch mode is disabled. \r\n"
"  [*]01: Commands are initiated on Phase 0 of every SPID clocks. \r\n"
"  [*]10: Commands are initiated on Phase 0 of even SPID clocks. \r\n"
"  [*]11: Commands are initiated on Phase 0 of odd SPID clocks.\r\n"
"  [/list]"},
#else
{4, 5, 0x0000000000000000, "RW", "stretchmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000008, "RW", "tmwr_ta_delta", "The value in this register is subtracted from Masked Write to Read, Masked Write to Write and Masked Write to Masked Write turnaround times to account for half BL MWr commands in LPDDR4 and WIO2. \r\n"
"  [list]\r\n"
"  [*]LPDDR4: = MWr tCCD = MWr BL/2 = 8.\r\n"
"  [*]WIO2: = MWr tCCD = MWr BL/2 = 2.\r\n"
"  [/list]"},
#else
{0, 3, 0x0000000000000008, "RW", "tmwr_ta_delta", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo15[] = {{"D_CR_DSCH", "", 0x0000003C, 12, 0x00000000FFFFFFFF, 0x0000000003901C08}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields16[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "zqcaltype", "Determines whether the ZQ Calibration is a long or short calibration command (due to ZQCALSTRT). \r\n"
"      [p]0: Short calibration (ZQCS).[/p]\r\n"
"      [p]1: Long calibration (ZQCL).[/p]"},
#else
{31, 31, 0x0000000000000000, "RW", "zqcaltype", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW/V", "zqcalstrtr1", "Set this bit to 1 to start the ZQ calibration sequence on Rank 1. This bit will remain a 1 until the ZQ calibration is complete for rank 1, then it will return to 0. \r\n"
"      [p]0: ZQ calibration is done.[/p] \r\n"
"      [p]1: ZQ calibration has started and is in progress.[/p]"},
#else
{30, 30, 0x0000000000000000, "RW/V", "zqcalstrtr1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW/V", "zqcalstrtr0", "Set this bit to 1 to start the ZQ calibration sequence on Rank 0. This bit will remain a 1 until the ZQ calibration is complete for rank 0, then it will return to 0. \r\n"
"      [p]0: ZQ calibration is done.[/p] \r\n"
"      [p]1: ZQ calibration has started and is in progress.[/p]"},
#else
{29, 29, 0x0000000000000000, "RW/V", "zqcalstrtr0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 28, 0x0000000000000000, "RO", "rsvd28_23", "Reserved."},
#else
{23, 28, 0x0000000000000000, "RO", "rsvd28_23", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 22, 0x0000000000000000, "RW", "srxzqc", "\r\n"
"  [list]\r\n"
"  [*]00: On DynSR exit ZQ timer determines the ZQ type. When the state is lost (i.e due to AutoPG/S0ix) ZQCL is always performed. \r\n"
"  [*]01: Always perform ZQCL after self refresh exit. In LPDDR4, ZQ with traffic blocked.\r\n"
"  [*]10: Always perform ZQCS on SR exit. For LPDDR4, ZQ while traffic is allowed. \r\n"
"  [*]11: No ZQCL commands are sent (it disables ZQCAL commands on SR exit).\r\n"
"  [/list]"},
#else
{21, 22, 0x0000000000000000, "RW", "srxzqc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 20, 0x0000000000000000, "RO", "rsvd20_18", "Reserved."},
#else
{18, 20, 0x0000000000000000, "RO", "rsvd20_18", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "zqclmode", "Specifies how ZQCal commands are sent to different ranks.\r\n"
"  [list]\r\n"
"  [*]0: ZQCal commands are sent in parallel to all ranks. \r\n"
"  [*]1: ZQCal commands are sent serially to each rank.\r\n"
"  [/list]"},
#else
{17, 17, 0x0000000000000000, "RW", "zqclmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "zqcdis", "\r\n"
"  [list]\r\n"
"  [*]0: Periodic ZQ Calibration is Enabled. \r\n"
"  [*]1: Disable periodic ZQ Calibration.\r\n"
"  [/list]"},
#else
{16, 16, 0x0000000000000000, "RW", "zqcdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RO", "rsvd15_14", "Reserved."},
#else
{14, 15, 0x0000000000000000, "RO", "rsvd15_14", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 13, 0x0000000000001057, "RW", "zqint", "Specifies the time interval between two ZQCS (LPDDR3/DDR3L/DDR4) or ZQ Start (LPDDR4) commands to a DRAM device. (in RTC 32.8KHz clocks)"},
#else
{0, 13, 0x0000000000001057, "RW", "zqint", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo16[] = {{"D_CR_DCAL", "", 0x00000040, 10, 0x00000000FFFFFFFF, 0x0000000000001057}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields17[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{20, 31, 0x0000000000000000, "RO", "rsvd31_20", "Reserved."},
#else
{20, 31, 0x0000000000000000, "RO", "rsvd31_20", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "mansrdis", "When set before a SUSPEND/WAKE command, D-Unit will not send SR entry/exit commands to DRAM."},
#else
{19, 19, 0x0000000000000000, "RW", "mansrdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "cpgclock", "Write a 1 to this bit to lock and clock gate the CPGC."},
#else
{18, 18, 0x0000000000000000, "RW", "cpgclock", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000001, "RW", "cpgcwarmrst", "Write a 1 to this bit to send warm reset to CPGC and then set to 0 to deassert the reset. Value of this field must be 0 before CPGC funtional usage is enabled."},
#else
{17, 17, 0x0000000000000001, "RW", "cpgcwarmrst", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "coldwake", "This bit must be set and then cleared by BIOS during cold/warm reset."},
#else
{16, 16, 0x0000000000000000, "RW", "coldwake", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "rsvd15_13", "Reserved."},
#else
{13, 15, 0x0000000000000000, "RO", "rsvd15_13", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000000, "RW", "odtmode", "\r\n"
"  [list]\r\n"
"  [*]0: D-Unit auto controls the ODT pins based on DRAM transactions. \r\n"
"  [*]1: The value of ODTVAL directly controls the ODT pins.\r\n"
"  [/list]"},
#else
{12, 12, 0x0000000000000000, "RW", "odtmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RO", "rsvd11_10", "Reserved."},
#else
{10, 11, 0x0000000000000000, "RO", "rsvd11_10", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "odtval", "Each bit of ODTVAL directly controls an ODT pin when ODTMODE is set to 1.  Used only during init flow. Note: Reserved for BXT0/1"},
#else
{8, 9, 0x0000000000000000, "RW", "odtval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "rsvd7_5", "Reserved."},
#else
{5, 7, 0x0000000000000000, "RO", "rsvd7_5", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "ckemode", "\r\n"
"  [list]\r\n"
"  [*]0: D-Unit auto controls the CKE pins based on PowerDown and Self Refresh entry and exit.  \r\n"
"  [*]1: The value of CKEVAL field directly controls the CKE pins.\r\n"
"  [/list]"},
#else
{4, 4, 0x0000000000000000, "RW", "ckemode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RO", "rsvd3_2", "Reserved."},
#else
{2, 3, 0x0000000000000000, "RO", "rsvd3_2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "ckeval", "Each bit of CKEVAL directly controls a CKE pin when CKEMODE is set to 1.  \r\n"
"  [p]Used only during init flow.[/p]"},
#else
{0, 1, 0x0000000000000000, "RW", "ckeval", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo17[] = {{"D_CR_DRMC", "", 0x00000044, 13, 0x00000000FFFFFFFF, 0x0000000000020000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields18[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", "Reserved."},
#else
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 29, 0x0000000000000000, "RW", "mr_value2", "MR3 Shadow Register (DDR4):\r\n"
"      [p]BIOS writes the correct value of MR3 register in DDR4 into this field at boot time. D-Unit modifies one bit and rewrites the MR3 into DDR4 to enter and exit MPR mode.[/p]"},
#else
{16, 29, 0x0000000000000000, "RW", "mr_value2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RO", "rsvd15_14", "Reserved."},
#else
{14, 15, 0x0000000000000000, "RO", "rsvd15_14", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 13, 0x0000000000000000, "RW", "mr_value", "MR3 Shadow Register (WIO2): \r\n"
"      [p]BIOS sets the value of this field at boot time based on the DRAM device configuration. D-Unit merges the value in MR3_THERM_OFFSET with this field and writes the result into DRAM MR3 [/p]\r\n"
"      [p]MR2 Shadow Register (DDR3L):[/p]\r\n"
"      [p]BIOS writes the correct value of MR2 register in DDR3L into this field at boot time. D-Unit modifies one bit and rewrites the MR2 into DDR3L DRAM before SR entry.[/p]\r\n"
"      [p]MR4 Shadow Register (DDR4):[/p]\r\n"
"      [p]BIOS writes the correct value of MR4 register in DDR4 into this field at boot time. D-Unit modifies one bit and rewrites the MR4 into DDR4 DRAM after temperature read out.[/p]"},
#else
{0, 13, 0x0000000000000000, "RW", "mr_value", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo18[] = {{"D_CR_MR_SHADOW", "", 0x00000048, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields19[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "vnn_timer_en", "\r\n"
"  [list]\r\n"
"  [*]0: The D-Unit VNN Scaling Timer is disabled. \r\n"
"  [*]1: The D-Unit VNN Scaling Timer is enabled.\r\n"
"  [/list]"},
#else
{31, 31, 0x0000000000000000, "RW", "vnn_timer_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 30, 0x0000000000000000, "RO", "rsvd30_12", "Reserved."},
#else
{12, 30, 0x0000000000000000, "RO", "rsvd30_12", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 11, 0x0000000000000000, "RW", "vnn_timer_time", "The final timer value (in 16 x DRAM clocks)."},
#else
{0, 11, 0x0000000000000000, "RW", "vnn_timer_time", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo19[] = {{"D_CR_VNNTIMER", "", 0x0000004C, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields20[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000003, "RW/V", "tqdatar1", "If Rank 1 is disabled, this value will remain zero. \r\n"
"  [p]This field contains the data of the last temperature sensor read from Rank 1 DRAM Mode Register. It is overwritten with each command.[/p]"},
#else
{29, 31, 0x0000000000000003, "RW/V", "tqdatar1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 28, 0x0000000000000003, "RW/V", "tqdatar0", "This field contains the data of the last temperature sensor read from Rank 0 DRAM Mode Register. It is overwritten with each command."},
#else
{26, 28, 0x0000000000000003, "RW/V", "tqdatar0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 25, 0x0000000000000000, "RO", "rsvd25_22", "Reserved."},
#else
{22, 25, 0x0000000000000000, "RO", "rsvd25_22", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 21, 0x0000000000000000, "RW", "tqpollper", "This sets the frequency by which the D-Unit initiates temperature sensor read from DRAM mode register to determine required refresh rate (in 4x tREFI units)."},
#else
{8, 21, 0x0000000000000000, "RW", "tqpollper", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "tcrren", "When set, after a DRAM temperature read out (MPR sequence), D-unit writes a 1 to bit 2 of MR_SHADOW.MR_VALUE when temperature sensor read out for that rank indicates a value higher than 0x1, and writes a 0 to that bit otherwise. The new MR_VALUE is then written into MR4 of DDR4 for each enabled rank."},
#else
{7, 7, 0x0000000000000000, "RW", "tcrren", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW/V", "tqpoll_start_r1", "When set Dunit will initiate temperature sensor read for Rank 1.\r\n"
"      [p]Hardware will clear the bit once the MR read command is issued for this rank.[/p]\r\n"
"      [p]Note:  TQPOLLEN mus be 0 before this bit is set.[/p]"},
#else
{6, 6, 0x0000000000000000, "RW/V", "tqpoll_start_r1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW/V", "tqpoll_start_r0", "When set Dunit will initiate temperature sensor read for Rank 0.\r\n"
"      [p]Hardware will clear the bit once the MR read command is issued for this rank.[/p]\r\n"
"      [p]Note:  TQPOLLEN mus be 0 before this bit is set.[/p]"},
#else
{5, 5, 0x0000000000000000, "RW/V", "tqpoll_start_r0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "srten", "When set, before every Self refresh entry, D-Unit writes a 1 to bit 7 of MR_SHADOW.MR_VALUE when TQDATA for that rank indicates a value higher then 0x3, and writes a 0 to that bit otherwise. The new MR_VALUE is then written into MR2 of DDR3 for each enabled rank."},
#else
{4, 4, 0x0000000000000000, "RW", "srten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000001, "RW", "enderate", "When set to 1, the Dynamic Timing Derating is enabled. When the D-Unit determines (via TQ polling) that the DRAM requires timing derating in addition to refresh interval adjustment, the D-Unit will automatically adjust the relevant timing parameters."},
#else
{3, 3, 0x0000000000000001, "RW", "enderate", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "tqdatapushen", "When set to 1, D-Unit pushes the data form the last temperature sensor read to a punit register."},
#else
{2, 2, 0x0000000000000000, "RW", "tqdatapushen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "tqpollsren", "This bit enables temperature sensor read on Self Refresh Exit. If disabled, D-Unit will not initiate MR Read sequence to read temperature value on Self-Refresh exit."},
#else
{1, 1, 0x0000000000000000, "RW", "tqpollsren", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "tqpollen", "This bit enables periodic TQ Poll. If disabled, D-Unit will not read the DRAM's temperature sensor value periodically."},
#else
{0, 0, 0x0000000000000000, "RW", "tqpollen", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo20[] = {{"D_CR_TQCTL", "", 0x00000050, 12, 0x00000000FFFFFFFF, 0x000000006C000008}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields21[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "rsvd31_16", "Reserved."},
#else
{16, 31, 0x0000000000000000, "RO", "rsvd31_16", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 15, 0x0000000000000000, "RO", "rsvd15_11", "Reserved."},
#else
{11, 15, 0x0000000000000000, "RO", "rsvd15_11", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "mr4_adder", "D-Unit adds the value of this field to TQDATA read from MR4 the resulting value is used to control refresh rate and AC timing derating."},
#else
{8, 10, 0x0000000000000000, "RW", "mr4_adder", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 7, 0x0000000000000000, "RO", "rsvd7_3", "Reserved."},
#else
{3, 7, 0x0000000000000000, "RO", "rsvd7_3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW/V", "mr3_offset_update", "When set, D-Unit writes the merged value of MR3_VALUE and MR3_THERM_OFFSET into MR3 of DRAM. D-Unit clears this bit once the value is written."},
#else
{2, 2, 0x0000000000000000, "RW/V", "mr3_offset_update", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "mr3_therm_offset", "(WIO2 only) Everytime MR3_OFFSET_UPDATE is set, D-Unit merges the value in this field with MR3_VALUE and writes the result to MR3 in DRAM"},
#else
{0, 1, 0x0000000000000000, "RW", "mr3_therm_offset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo21[] = {{"D_CR_TQOFFSET", "", 0x00000054, 6, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields22[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW/V", "ic", "Indicates that initialization of the D-Unit has been completed. Memory accesses are permitted and maintenance operation begins. Until this bit is set to a 1, the memory controller will not accept DRAM requests from the Bunit/GSA/2LM (PMI ISMs will not leave idle).  \r\n"
"  [p]Note: Set this bit to 1 only when all other D-Unit registers have been configured. Usually set at the last configuration step by BIOS on cold/warm reset. D-Unit hardware sets this bit on SR exit.[/p]"},
#else
{31, 31, 0x0000000000000000, "RW/V", "ic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RO/V", "dioic", "Status indication that the DDRIO PHY initialization is complete reflects the status spid_init_complete signal."},
#else
{30, 30, 0x0000000000000000, "RO/V", "dioic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RO", "rsvd29", "Reserved."},
#else
{29, 29, 0x0000000000000000, "RO", "rsvd29", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "pmictl", "\r\n"
"  [list]\r\n"
"  [*]0: D-Unit PMI is connected to Bunit/GSA/2LM. \r\n"
"  [*]1: D-Unit PMI is connected to CPGC. \r\n"
"      [/list]\r\n"
"      [p]Note: D_CR_DSCH_BYPASSEN must be set to 0 in CPGC mode.[/p]\r\n"
"  [p]Note: PMI must be idle and D-Unit BGF_RUN = 0 before changing the value in this register.[/p]"},
#else
{28, 28, 0x0000000000000000, "RW", "pmictl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 27, 0x0000000000000000, "RO", "rsvd27_8", "Reserved."},
#else
{8, 27, 0x0000000000000000, "RO", "rsvd27_8", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO", "rsvd7_4", "Reserved."},
#else
{4, 7, 0x0000000000000000, "RO", "rsvd7_4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "psmien", "When enabled, D-Unit will synchronize clock crossing signals.\r\n"
"  [list]\r\n"
"  [*]0: PSMI Mode is disabled. \r\n"
"  [*]1: PSMI Mode is enabled.\r\n"
"      [/list]\r\n"
"  [p]Note: Change only allowed when D-Unit is idle.[/p]"},
#else
{3, 3, 0x0000000000000000, "RW", "psmien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "mntrst", "Writing a 1 to this field resets all maintenance timers. Clears all states and also clears refresh debt queues. This bit must be cleared by software after at least 3 SPID clocks."},
#else
{2, 2, 0x0000000000000000, "RW", "mntrst", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "mnten", "Setting this field to 1 enables all maintenance operations. When DCO.IC is set, the maintenance operations are enabled irrespective of the value of this field."},
#else
{1, 1, 0x0000000000000000, "RW", "mnten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO", "rsvd0", "Reserved."},
#else
{0, 0, 0x0000000000000000, "RO", "rsvd0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo22[] = {{"D_CR_DCO", "", 0x00000058, 10, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields23[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{11, 31, 0x0000000000000000, "RO", "rsvd31_11", "Reserved."},
#else
{11, 31, 0x0000000000000000, "RO", "rsvd31_11", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "pgtbl_bypass_en", "When set, D-unit scheduler will bypass page table lookups when scheduling read/write and assumes a Page Hit. So D-unit will only send RD/WR CAS command (without the ACT). After issuing the CAS command, D-unit will also not update the Page Table status to avoid issuing PRE due to access to same page."},
#else
{10, 10, 0x0000000000000000, "RW", "pgtbl_bypass_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "cpgc_ecc_bypass_en", "When set, CPGC will have full control of the Write ECC data and bypasses D-Unit's runtime ECC and data scrambling function. Also when enabled, read ECC error detection/correction/reporting logic is disabled."},
#else
{9, 9, 0x0000000000000000, "RW", "cpgc_ecc_bypass_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "catrainen", "\r\n"
"  [list]\r\n"
"  [*]0: D-Unit is not in JEDEC CA Training Mode. \r\n"
"  [*]1: D-Unit is in JEDEC CA Training Mode.\r\n"
"  [/list]"},
#else
{8, 8, 0x0000000000000000, "RW", "catrainen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "dqcalen", "\r\n"
"  [list]\r\n"
"  [*]0: D-Unit is not in DQ Calibration Mode. \r\n"
"  [*]1: D-Unit is in DQ Calibration Mode.\r\n"
"  [/list]"},
#else
{7, 7, 0x0000000000000000, "RW", "dqcalen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "blkphaseb", "The D-Unit runs at half (LPDDR3/WIO2/DDR3L) or quarter (LPDDR4/DDR4) the frequency of the DRAM clock to save power. In order to issue back-to-back commands on every DRAM clock cycle, the D-Unit has to schedule two/four commands per D-Unit clock. Therefore, it processes requests through separate arbitration paths labeled as Phase_0, Phase_1, Phase_2 and Phase_3.  \r\n"
"      [p]In LPDDR3/WIO2/DDR3 case setting this bit to a 1 will disable Phase_1 and all memory requests will be processed through Phase_0 arbitration path. With only Phase_0 enabled, the DRAM device will never see back-to-back commands. The best it will see is a command every other DRAM clock cycle.[/p]\r\n"
"      [p]In LPDDR4 case, each command is two DRAM clocks and they are sent in two consecutive phases. Also, most of the LPDDR4 operations are broken into two commands that have to be sent back-to-back. Therefore, setting this bit to 1 will disable initiating *new* commands on Phase_1, Phase_2 and Phase_3.[/p]\r\n"
"      [p]in DDR4, D-unit schedules command through Phase_0 and Phase_2. Setting this bit disables new commands from being scheduled on Phase_2, so the DRAM will only see one command every 4 DRAM clocks.[/p] \r\n"
"      [p]0: No block[/p]\r\n"
"      [p]1: Block [/p]\r\n"
"      [p]Note: This bit does/must not impact the CPGCs ability to send requests to the SPID in Phase 1/2/3.  D-Unit arbiter comprehends this bit to issue 1 Command per SPIDCLK when set versus 2 Commands per SPIDCLK when not set.[/p]\r\n"
"      [p]Note 2: Setting this bit will not affect commands issued via the DRAM CMD register interface as those bypass the arbiter entirely. So it is possible to see commands issued on phase 1/2/3 when the DRAM_Command.M2N bit is set.[/p]\r\n"
"      [p]Note 3: When DRAM_Timing_Register_3A.TCMD is set to 2N mode commands can only win through the phase 0 arbitration path but it is possible to see DDR3 and DDR4 commands issued on phase 1 due to the nature of 2N delaying sending the command until the second DRAM clock.[/p]"},
#else
{6, 6, 0x0000000000000000, "RW", "blkphaseb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "blkwpqf", "Block Processing Write Requests until WPQ is Full. \r\n"
"  [p]When this bit is set to 1, the D-Unit is blocked from processing any of the requests in the WPQ until it is full. The full level is based on the WPQCOUNT value.[/p] \r\n"
"  [list]\r\n"
"  [*]0: No block. \r\n"
"  [*]1: Block.\r\n"
"  [/list]\r\n"
"  [p]Note: Once WPQ is full, it is unblocked until an entry is deallocated. So there could be more than one write scheduled during that window.[/p]"},
#else
{5, 5, 0x0000000000000000, "RW", "blkwpqf", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "blkrpqf", "Block Processing Read Requests until RPQ is Full. \r\n"
"  [p]When this bit is set to 1, the D-Unit is blocked from processing any of the requests in the RPQ until it is full. The full level is based on the RPQCOUNT value.[/p] \r\n"
"  [list]\r\n"
"  [*]0: No block.\r\n"
"  [*]1: Block.\r\n"
"  [/list]"},
#else
{4, 4, 0x0000000000000000, "RW", "blkrpqf", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "blkpre", "Block Precharge Commands to DRAM.\r\n"
"      [p]Note: setting this bit only blocks functional precharge commands issued via the RPQ and WPQ.  Precharge commands issued by the page table as part of the idle page timer feature and Precharge All commands issued as part of maintenance or CKE power down commands are not blocked by this bit. There are separate bits to enable/disable those functionalities.[/p]\r\n"
"  [list]\r\n"
"  [*]0: No Block. \r\n"
"  [*]1: Block.\r\n"
"  [/list]"},
#else
{3, 3, 0x0000000000000000, "RW", "blkpre", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "blkact", "Block Activate Commands to DRAM.\r\n"
"  [list]\r\n"
"  [*]0: No Block. \r\n"
"  [*]1: Block.\r\n"
"  [/list]"},
#else
{2, 2, 0x0000000000000000, "RW", "blkact", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "blkwr", "Block Write Commands to DRAM.\r\n"
"      [list]\r\n"
"  [*]0: No Block.\r\n"
"  [*]1: Block.\r\n"
"  [/list]"},
#else
{1, 1, 0x0000000000000000, "RW", "blkwr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "blkrd", "Block Read Commands to DRAM.\r\n"
"      [list]\r\n"
"  [*]0: No Block.\r\n"
"  [*]1: Block.\r\n"
"  [/list]"},
#else
{0, 0, 0x0000000000000000, "RW", "blkrd", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo23[] = {{"D_CR_DTRC", "", 0x0000005C, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields24[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{12, 31, 0x0000000000000000, "RO", "rsvd31_12", "Reserved."},
#else
{12, 31, 0x0000000000000000, "RO", "rsvd31_12", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "pasrdis", "When set, D-Unit will not do a Mode Register Write to set the mask on SR entry due to SUSPENDP message and will not do Mode Register Write to clear the mask on SR due to WAKE message."},
#else
{11, 11, 0x0000000000000000, "RW", "pasrdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "tristdis", "When set, D-Unit will not be able to enter the state to stop/tristate the CK or tristate ODT/CS pins. \r\n"
"      [p]Note: Setting this bit also disables entry to LPMODEs.[/p]"},
#else
{10, 10, 0x0000000000000000, "RW", "tristdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "fullcmdcrdis", "When set to 1, D-Unit will always use credit metering to only advertise few initial credits to PMI requestor rather than advertising the full Pending Queue size."},
#else
{9, 9, 0x0000000000000000, "RW", "fullcmdcrdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "srxnrqdis", "Disable Accepting Requests During Self Refresh Exit (prevent D-Unit PMI ISM to leave idle).\r\n"
"  [list]\r\n"
"  [*]0: D-Unit accepts and loads PMI requests into the queues during Self Refresh exit period while maintenance operation are in progress.\r\n"
"  [*]1: D-Unit does not accept PMI requests until Self Refresh exit and all maintenance operations have completed.\r\n"
"  [/list]"},
#else
{8, 8, 0x0000000000000000, "RW", "srxnrqdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "mrrcp", "When set to 1, D-Unit closes all pages by issuing a PREALL before sending the MRR command to DRAM."},
#else
{7, 7, 0x0000000000000000, "RW", "mrrcp", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 6, 0x0000000000000000, "RO", "rsvd6_5", "Reserved."},
#else
{5, 6, 0x0000000000000000, "RO", "rsvd6_5", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "pgtblstaten", "When set, D-Unit will update the status bits in PGTBLSTAT.PGTBLVLD. If not set, the status CR, will not reflect the latest status of the page table."},
#else
{4, 4, 0x0000000000000000, "RW", "pgtblstaten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "phyqtdis", "When set to 1, the D-Unit ignores PHY periodic quite time update requests. \r\n"
"  [p]Note: Setting this bit does not prevent PHY from requesting selfrefresh exit or bus quiet time.[/p]"},
#else
{3, 3, 0x0000000000000000, "RW", "phyqtdis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "pmidis", "When set to 1, the PMI interface remains in idle state. \r\n"
"  [p]Note: Setting this bit does not force the PMI ISM to move to idle state.[/p]"},
#else
{2, 2, 0x0000000000000000, "RW", "pmidis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "cr_stat_en", "When set, D-Unit will update the status bits in D_CR_DSTAT. If not set, D_CR_DSTAT will not reflect the latest status of the D-Unit. \r\n"
"      [p]Note: This enable bit does not control Page Table Status Field in DSTAT CR.[/p]"},
#else
{1, 1, 0x0000000000000000, "RW", "cr_stat_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "ecdis", "When set to 1, D-Unit error correction logic will be disabled. So all ECC errors would be considered uncorrectable."},
#else
{0, 0, 0x0000000000000000, "RW", "ecdis", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo24[] = {{"D_CR_DCBR", "", 0x000000A0, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields25[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "scrm_en", "When set to 1, data scrambling is enabled. When set to 0, data scrambling is disabled. Should be set before D_CR_BGF_CTL_BGF_RUN is set to 1."},
#else
{31, 31, 0x0000000000000000, "RW", "scrm_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RO", "rsvd30", "Reserved."},
#else
{30, 30, 0x0000000000000000, "RO", "rsvd30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RW", "clockgate", "This field controls how the scrambler output code is clock gated to reduce power.\r\n"
"  [list]\r\n"
"  [*]00: Clock gate disabled.  \r\n"
"  [*]01: Clock Gate every 2 cycles.  \r\n"
"  [*]10: Clock Gate every 3 cycles.  \r\n"
"  [*]11: Clock Gate every 4 cycles.\r\n"
"  [/list]"},
#else
{28, 29, 0x0000000000000000, "RW", "clockgate", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 27, 0x0000000000000000, "RO", "rsvd27_16", "Reserved."},
#else
{16, 27, 0x0000000000000000, "RO", "rsvd27_16", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW", "key", "Sets the key for the scrambler. The key should be a random value that is set following each cold boot."},
#else
{0, 15, 0x0000000000000000, "RW", "key", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo25[] = {{"D_CR_SCRAMCTRL", "", 0x000000A4, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields26[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "rsvd31_16", "Reserved."},
#else
{16, 31, 0x0000000000000000, "RO", "rsvd31_16", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 15, 0x0000000000000000, "RO", "rsvd15_11", "Reserved."},
#else
{11, 15, 0x0000000000000000, "RO", "rsvd15_11", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RO/V", "disr", "The D-Unit sets this bit to a 1 after it has placed the DRAM devices in Self Refresh mode.  \r\n"
"  [p]The D-Unit clears this bit when it brings the DRAM devices out of Self Refresh mode and completes maintenance operations.[/p]\r\n"
"  [list]\r\n"
"  [*]0: DRAM not in SelfRefresh.  \r\n"
"  [*]1: DRAM in SelfRefresh.\r\n"
"  [/list]\r\n"
"  [p]Note: If DRAM is in SR because of Dynamic SR reading any D-Unit register will bring DRAM out of SR.[/p]"},
#else
{10, 10, 0x0000000000000000, "RO/V", "disr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RO/V", "refdbt1", "Rank 1 has a Refresh Debt."},
#else
{9, 9, 0x0000000000000000, "RO/V", "refdbt1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RO/V", "refdbt0", "Rank 0 has a Refresh Debt."},
#else
{8, 8, 0x0000000000000000, "RO/V", "refdbt0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO/V", "invtech", "\r\n"
"  [list]\r\n"
"  [*]0: Selected DRAM technology is valid.\r\n"
"  [*]1: Selected DRAM technology is not supported.\r\n"
"  [/list]"},
#else
{7, 7, 0x0000000000000000, "RO/V", "invtech", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000001, "RO/V", "wpqempty", "\r\n"
"  [list]\r\n"
"  [*]0: D-Unit WPQ is not empty (pending write requests in WPQ).\r\n"
"  [*]1: D-Unit WPQ is empty.\r\n"
"  [/list]"},
#else
{6, 6, 0x0000000000000001, "RO/V", "wpqempty", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000001, "RO/V", "rpqempty", "\r\n"
"  [list]\r\n"
"  [*]0: D-Unit RPQ is not empty (pending read requests in RPQ).\r\n"
"  [*]1: D-Unit RPQ is empty.\r\n"
"  [/list]"},
#else
{5, 5, 0x0000000000000001, "RO/V", "rpqempty", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RO", "rsvd4_0", "Reserved."},
#else
{0, 4, 0x0000000000000000, "RO", "rsvd4_0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo26[] = {{"D_CR_DSTAT", "", 0x000000A8, 9, 0x00000000FFFFFFFF, 0x0000000000000060}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields27[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "rsvd31", "Reserved."},
#else
{31, 31, 0x0000000000000000, "RO", "rsvd31", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 30, 0x0000000000000000, "RW", "address", "Specifies the PMI address of the write transaction to be injected with the error. Only applicable to Write transactions. Read/under-fill read of the partial write operation is not affected."},
#else
{1, 30, 0x0000000000000000, "RW", "address", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO", "rsvd0", "Reserved."},
#else
{0, 0, 0x0000000000000000, "RO", "rsvd0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo27[] = {{"D_CR_ERR_INJ", "", 0x000000AC, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields28[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{4, 31, 0x0000000000000000, "RO", "rsvd31_4", "Reserved"},
#else
{4, 31, 0x0000000000000000, "RO", "rsvd31_4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "sel_hi", "0 - Uncorrectable Error (UE) is armed for write address matching to inject UE by using the same poisoning scheme, i.e. inverting corresponding write ECC[6:0] on every QW of the 32B data. [br]1 - Correctable Error (CE) is armed for write address matching to inject CE by inverting corresponding write ECC[0] on every QW of the 32B data."},
#else
{3, 3, 0x0000000000000000, "RW", "sel_hi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "en_hi", "When set the error injection is continuously armed for higher 32B of D_CR_ERR_INJ_ADDR write address matching until it is cleared. "},
#else
{2, 2, 0x0000000000000000, "RW", "en_hi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "sel_lo", "0 - Uncorrectable Error (UE) is armed for write address matching to inject UE by using the same poisoning scheme, i.e. inverting corresponding write ECC[6:0] on every QW of the 32B data. [br]1 - Correctable Error (CE) is armed for write address matching to inject CE by inverting corresponding write ECC[0] on every QW of the 32B data."},
#else
{1, 1, 0x0000000000000000, "RW", "sel_lo", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "en_lo", "When set, the error injection is continuously armed for lower 32B of D_CR_ERR_INJ_ADDR write address matching until it is cleared. "},
#else
{0, 0, 0x0000000000000000, "RW", "en_lo", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo28[] = {{"D_CR_ERR_INJ_CTL", "", 0x000000B0, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields29[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW/V", "clear", "Setting this bit to one clears all fields in this register, including itself."},
#else
{31, 31, 0x0000000000000000, "RW/V", "clear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RW", "ecc_visa", "Select ECC or PMI byte on VISA : \r\n"
"      [list]\r\n"
"      [*]00: ECC byte, \r\n"
"      [*]01: PMI Data Byte [7:0],\r\n"
"      [*]10: PMI Data Byte [63:56],\r\n"
"      [*]11: PMI Data Byte [255:248]\r\n"
"      [/list]"},
#else
{29, 30, 0x0000000000000000, "RW", "ecc_visa", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW/V", "cerr", "This bit is set when a correctable single-bit error occurs on a memory read data transfer.  When this bit is set, the address that caused the error and the error syndrome are also logged and they are locked to further single bit errors, until this bit is cleared. A multiple bit error that occurs after this bit is set will override the address/error syndrome information."},
#else
{28, 28, 0x0000000000000000, "RW/V", "cerr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RW/V", "merr", "This bit is set when an uncorrectable multiple-bit error occurs on a memory read data transfer.  When this bit is set, the address that caused the error and the error syndrome are also logged and they are locked until this bit is cleared."},
#else
{27, 27, 0x0000000000000000, "RW/V", "merr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 26, 0x0000000000000000, "RW/V", "err_burst", "Burst number (in BL8) of the error within a chunk."},
#else
{25, 26, 0x0000000000000000, "RW/V", "err_burst", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW/V", "err_chunk", "Chunk number of the error. [br]0 - lower 32B chunk has error if MERR/CERR is set [br]1 - higher 32B chunk has the error if MERR/CERR is set"},
#else
{24, 24, 0x0000000000000000, "RW/V", "err_chunk", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW/V", "syndrome_qw", "ECC Syndrome for a QW (64 bit) within 32B Address"},
#else
{16, 23, 0x0000000000000000, "RW/V", "syndrome_qw", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW/V", "tag", "Read Return Tag matches with the PMI Request Tag which triggered the error log."},
#else
{0, 15, 0x0000000000000000, "RW/V", "tag", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo29[] = {{"D_CR_ERR_ECC_LOG", "", 0x000000B4, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields30[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "pgtblvld", "This register indicates whether a page is open within a bank. Each bit reflects the page open status of a bank.\r\n"
"      [p]DDR3L/LPDDR3/LPDDR4/WIO2:[/p]\r\n"
"  [list]\r\n"
"  [*]PGTBLVLD[7:0] = Page open status for Rank 0 Bank[7:0]. \r\n"
"  [*]PGTBLVLD[23:16] = Page open status for Rank 1 Bank[7:0].\r\n"
"      [/list]\r\n"
"      [p]DDR4:[/p]\r\n"
"      [list]\r\n"
"      [*]PGTBLVLD[3:0] = Page open status for Rank 0, Bank Group 0, Bank[3:0]. \r\n"
"      [*]PGTBLVLD[7:4] = Page open status for Rank 0, Bank Group 1, Bank[3:0].\r\n"
"      [*]PGTBLVLD[11:8] = Page open status for Rank 0, Bank Group 2, Bank[3:0].\r\n"
"      [*]PGTBLVLD[15:12] = Page open status for Rank 0, Bank Group 3, Bank[3:0].\r\n"
"      [*]PGTBLVLD[19:16] = Page open status for Rank 1, Bank Group 0, Bank[3:0].\r\n"
"      [*]PGTBLVLD[23:20] = Page open status for Rank 1, Bank Group 1, Bank[3:0].\r\n"
"      [*]PGTBLVLD[27:24] = Page open status for Rank 1, Bank Group 2, Bank[3:0].\r\n"
"      [*]PGTBLVLD[31:28] = Page open status for Rank 1, Bank Group 3, Bank[3:0].\r\n"
"      [/list]\r\n"
"      [list]\r\n"
"      [*]0: The associated bank is closed.\r\n"
"  [*]1: The associated bank has been opened. \r\n"
"  [/list]"},
#else
{0, 31, 0x0000000000000000, "RO/V", "pgtblvld", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo30[] = {{"D_CR_PGTBLSTAT", "", 0x000000B8, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields31[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "rsvd31_16", "Reserved."},
#else
{16, 31, 0x0000000000000000, "RO", "rsvd31_16", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RO/V", "fusestat", "D-Unit fuse bits are captured into this register and are available to be read.\r\n"
"      [list]\r\n"
"  [*][0]: fus_dun_ecc_dis.  \r\n"
"  [*][3:1]: fus_dun_max_supported_device_size[2:0].\r\n"
"  [*][4:4]: fus_dun_lpddr3_dis.\r\n"
"  [*][5:5]: fus_dun_lpddr4_dis.\r\n"
"  [*][6:6]: fus_dun_wio2_dis.\r\n"
"  [*][7:7]: fus_dun_ddr3l_dis.\r\n"
"      [*][8:8]: fus_dun_ddr4_dis.\r\n"
"  [*][15:9]: reserved.\r\n"
"  [/list]"},
#else
{0, 15, 0x0000000000000000, "RO/V", "fusestat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo31[] = {{"D_CR_DFUSESTAT", "", 0x000000BC, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields32[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "val", "General purpose scratchpad.  May be used for BIOS for data storage."},
#else
{0, 31, 0x0000000000000000, "RW", "val", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo32[] = {{"D_CR_SSKPD0", "", 0x000000C0, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields33[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "val", "General purpose scratchpad.  May be used for BIOS for data storage."},
#else
{0, 31, 0x0000000000000000, "RW", "val", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo33[] = {{"D_CR_SSKPD1", "", 0x000000C4, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields34[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "bonus0", "This register is reserved for ECO."},
#else
{0, 31, 0x0000000000000000, "RW", "bonus0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo34[] = {{"D_CR_BONUS0", "", 0x000000C8, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields35[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "bonus1", "This register is reserved for ECO."},
#else
{0, 31, 0x0000000000000000, "RW", "bonus1", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo35[] = {{"D_CR_BONUS1", "", 0x000000CC, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields36[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "dqcalrdatlo", "Holds least significant 32 bits returned as a result of CA Training."},
#else
{0, 31, 0x0000000000000000, "RO/V", "dqcalrdatlo", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo36[] = {{"D_CR_DQCALRDATLO", "", 0x000000D0, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields37[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "dqcalrdathi", "Holds most significant 32 bits returned as a result of DQ calibration/CA training (Reserved in BXT/GLK)."},
#else
{0, 31, 0x0000000000000000, "RO/V", "dqcalrdathi", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo37[] = {{"D_CR_DQCALRDATHI", "", 0x000000D4, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields38[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RW", "cmdspid_to_saby2_tsvs", "Provides custom TSVs for BGFs which write in the CMD SPID clock and read in SABY2 clock."},
#else
{16, 31, 0x0000000000000000, "RW", "cmdspid_to_saby2_tsvs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW", "saby2_to_cmdspid_tsvs", "Provides custom TSVs for BGFs which write in the SABY2 clock and read in CMD SPID clock."},
#else
{0, 15, 0x0000000000000000, "RW", "saby2_to_cmdspid_tsvs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo38[] = {{"D_CR_BGF_CUSTOM_TSV_CMD_PATTERN", "", 0x000000D8, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields39[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RW", "cmdspid_to_saby2_tsvs", "Provides custom TSVs for BGFs which write in the CMD SPID clock and read in SABY2 clock."},
#else
{16, 31, 0x0000000000000000, "RW", "cmdspid_to_saby2_tsvs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW", "saby2_to_cmdspid_tsvs", "Provides custom TSVs for BGFs which write in SABY2 clock and read in CMD SPID clock."},
#else
{0, 15, 0x0000000000000000, "RW", "saby2_to_cmdspid_tsvs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo39[] = {{"D_CR_BGF_CUSTOM_TSV_CMD_INIT", "", 0x000000DC, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields40[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RW", "dataspid_to_saby2_tsvs", "Provides custom TSVs for BGFs which write in the DATA SPID clock and read in SABY2 clock."},
#else
{16, 31, 0x0000000000000000, "RW", "dataspid_to_saby2_tsvs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW", "saby2_to_dataspid_tsvs", "Provides custom TSVs for BGFs which write in SABY2 clock and read in DATA SPID clock"},
#else
{0, 15, 0x0000000000000000, "RW", "saby2_to_dataspid_tsvs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo40[] = {{"D_CR_BGF_CUSTOM_TSV_DATA_PATTERN", "", 0x000000E0, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields41[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RW", "dataspid_to_saby2_tsvs", "Provides custom TSVs for BGFs which write in the DATA SPID clock and read in SABY2 clock."},
#else
{16, 31, 0x0000000000000000, "RW", "dataspid_to_saby2_tsvs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW", "saby2_to_dataspid_tsvs", "Provides custom TSVs for BGFs which write in SABY2 clock and read in DATA SPID clock."},
#else
{0, 15, 0x0000000000000000, "RW", "saby2_to_dataspid_tsvs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo41[] = {{"D_CR_BGF_CUSTOM_TSV_DATA_INIT", "", 0x000000E4, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields42[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000003, "RW", "spiddataclk_ratio", "The ratio of clock C (SPIDData):1."},
#else
{24, 31, 0x0000000000000003, "RW", "spiddataclk_ratio", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000003, "RW", "spidcmdclk_ratio", "The ratio of clock B (SPIDCmd):1."},
#else
{16, 23, 0x0000000000000003, "RW", "spidcmdclk_ratio", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000001, "RW", "saclkby2_ratio", "The ratio of clock A (SAby2):1.   \r\n"
"  [p]Note: this field must be set to the same value as SPIDCMDCLK_RATIO when CPGC is active.[/p]"},
#else
{8, 15, 0x0000000000000001, "RW", "saclkby2_ratio", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RW", "fus_separation_spidsaby2", "Variable separation of the serial fifos to be passed into the se module."},
#else
{6, 7, 0x0000000000000000, "RW", "fus_separation_spidsaby2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "cg_dis", "BGF Reset."},
#else
{5, 5, 0x0000000000000000, "RW", "cg_dis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 4, 0x0000000000000000, "RW", "fus_separation_saby2spid", "Variable separation of the serial fifos to be passed into the se module. BEZAN TO FIX"},
#else
{3, 4, 0x0000000000000000, "RW", "fus_separation_saby2spid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "use_localsync", "Enable the use of locally generated sync signals."},
#else
{2, 2, 0x0000000000000000, "RW", "use_localsync", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO", "rsvd1", "Reserved."},
#else
{1, 1, 0x0000000000000000, "RO", "rsvd1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "bgf_run", "Start BGFs."},
#else
{0, 0, 0x0000000000000000, "RW", "bgf_run", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo42[] = {{"D_CR_BGF_CTL", "", 0x00000120, 9, 0x00000000FFFFFFFF, 0x0000000003030100}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields43[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", "Reserved."},
#else
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 29, 0x0000000000000005, "RW", "raw_wmm", "If a conflict read reaches this priority (or greater depending on access class occupancy), WMM will be triggered to unblock the corresponding write. D-Unit will stay in WMM until corresponding write is issued. \r\n"
"  [p]Note: The value in this bit must not be higher than lowest terminal priority level of each access class.[/p]"},
#else
{27, 29, 0x0000000000000005, "RW", "raw_wmm", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RO", "rsvd26", "Reserved."},
#else
{26, 26, 0x0000000000000000, "RO", "rsvd26", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 25, 0x0000000000000006, "RW", "rimprio", "If any read in the RPQ is at this programmable priority, RIM is triggered."},
#else
{23, 25, 0x0000000000000006, "RW", "rimprio", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 22, 0x0000000000000000, "RO", "rsvd22_18", "Reserved."},
#else
{18, 22, 0x0000000000000000, "RO", "rsvd22_18", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 17, 0x000000000000001A, "RW", "wimthrs", "When the number of entries in WPQ is greater than or equal to this value (higher than WMM entry watermark, less than WPQ size), it triggers write isoch mode (WIM)."},
#else
{12, 17, 0x000000000000001A, "RW", "wimthrs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 11, 0x0000000000000014, "RW", "wmmexit", "When the number of entries in WPQ is less than this value, the D-Unit will switch back to read major mode."},
#else
{6, 11, 0x0000000000000014, "RW", "wmmexit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000018, "RW", "wmmentry", "When the number of entries in WPQ is greater than or equal to this value, the D-Unit will switch to write major mode (WMM).\r\n"
"  [p]Note: the value must not be set to 0.[/p]"},
#else
{0, 5, 0x0000000000000018, "RW", "wmmentry", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo43[] = {{"D_CR_MMC", "", 0x00000124, 8, 0x00000000FFFFFFFF, 0x000000002B01A518}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields44[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{26, 31, 0x0000000000000000, "RO", "rsvd31_26", "Reserved."},
#else
{26, 31, 0x0000000000000000, "RO", "rsvd31_26", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 25, 0x0000000000000010, "RW", "maxwrb", "Maximum number of writes D-Unit can send in WMM mode before returning to RMM (set B)."},
#else
{20, 25, 0x0000000000000010, "RW", "maxwrb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 19, 0x0000000000000008, "RW", "minrdb", "Minimum number of reads that has to be serviced before a switch to WMM is allowed (set B)."},
#else
{14, 19, 0x0000000000000008, "RW", "minrdb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RO", "rsvd13_12", "Reserved."},
#else
{12, 13, 0x0000000000000000, "RO", "rsvd13_12", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 11, 0x0000000000000010, "RW", "maxwra", "Maximum number of writes D-Unit can send in WMM mode before returning to RMM (set A)."},
#else
{6, 11, 0x0000000000000010, "RW", "maxwra", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000008, "RW", "minrda", "Minimum number of reads that has to be serviced before a switch to WMM is allowed (set A)."},
#else
{0, 5, 0x0000000000000008, "RW", "minrda", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo44[] = {{"D_CR_MMRDWR_AB", "", 0x00000128, 6, 0x00000000FFFFFFFF, 0x0000000001020408}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields45[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{26, 31, 0x0000000000000000, "RO", "rsvd31_26", "Reserved."},
#else
{26, 31, 0x0000000000000000, "RO", "rsvd31_26", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 25, 0x0000000000000010, "RW", "maxwrd", "Maximum number of writes D-Unit can send in WMM mode before returning to RMM (set D)."},
#else
{20, 25, 0x0000000000000010, "RW", "maxwrd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 19, 0x0000000000000008, "RW", "minrdd", "Minimum number of reads that has to be serviced before a switch to WMM is allowed (set D)."},
#else
{14, 19, 0x0000000000000008, "RW", "minrdd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RO", "rsvd13_12", "Reserved."},
#else
{12, 13, 0x0000000000000000, "RO", "rsvd13_12", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 11, 0x0000000000000010, "RW", "maxwrc", "Maximum number of writes D-Unit can send in WMM mode before returning to RMM (set C)."},
#else
{6, 11, 0x0000000000000010, "RW", "maxwrc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000008, "RW", "minrdc", "Minimum number of reads that has to be serviced before a switch to WMM is allowed (set C)."},
#else
{0, 5, 0x0000000000000008, "RW", "minrdc", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo45[] = {{"D_CR_MMRDWR_CD", "", 0x0000012C, 6, 0x00000000FFFFFFFF, 0x0000000001020408}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields46[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{15, 31, 0x0000000000000000, "RO", "rsvd31_15", "Reserved."},
#else
{15, 31, 0x0000000000000000, "RO", "rsvd31_15", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000001, "RW", "ac4ip", "Initial priority level of read requests coming with access class 4."},
#else
{12, 14, 0x0000000000000001, "RW", "ac4ip", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 11, 0x0000000000000003, "RW", "ac3ip", "Initial priority level of read requests coming with access class 3."},
#else
{9, 11, 0x0000000000000003, "RW", "ac3ip", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 8, 0x0000000000000007, "RW", "ac2ip", "Initial priority level of read requests coming with access class 2."},
#else
{6, 8, 0x0000000000000007, "RW", "ac2ip", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "ac1ip", "Initial priority level of read requests coming with access class 1."},
#else
{3, 5, 0x0000000000000000, "RW", "ac1ip", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000002, "RW", "ac0ip", "Initial priority level of read requests coming with access class 0."},
#else
{0, 2, 0x0000000000000002, "RW", "ac0ip", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo46[] = {{"D_CR_ACCIP", "", 0x00000130, 6, 0x00000000FFFFFFFF, 0x00000000000017C2}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields47[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", "Reserved."},
#else
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 29, 0x0000000000000000, "RW", "p6res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{25, 29, 0x0000000000000000, "RW", "p6res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 24, 0x000000000000001F, "RW", "p5res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{20, 24, 0x000000000000001F, "RW", "p5res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x000000000000000A, "RW", "p4res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{15, 19, 0x000000000000000A, "RW", "p4res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x000000000000000A, "RW", "p3res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{10, 14, 0x000000000000000A, "RW", "p3res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x000000000000000A, "RW", "p2res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{5, 9, 0x000000000000000A, "RW", "p2res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "p1res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{0, 4, 0x0000000000000000, "RW", "p1res", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo47[] = {{"D_CR_RD_PROM0", "", 0x00000134, 7, 0x00000000FFFFFFFF, 0x0000000001F52940}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields48[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", "Reserved."},
#else
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 29, 0x000000000000000A, "RW", "p6res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{25, 29, 0x000000000000000A, "RW", "p6res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 24, 0x0000000000000000, "RW", "p5res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{20, 24, 0x0000000000000000, "RW", "p5res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x0000000000000000, "RW", "p4res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{15, 19, 0x0000000000000000, "RW", "p4res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x0000000000000000, "RW", "p3res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{10, 14, 0x0000000000000000, "RW", "p3res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x0000000000000000, "RW", "p2res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{5, 9, 0x0000000000000000, "RW", "p2res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "p1res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{0, 4, 0x0000000000000000, "RW", "p1res", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo48[] = {{"D_CR_RD_PROM1", "", 0x00000138, 7, 0x00000000FFFFFFFF, 0x0000000014000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields49[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", "Reserved."},
#else
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 29, 0x0000000000000000, "RW", "p6res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{25, 29, 0x0000000000000000, "RW", "p6res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 24, 0x0000000000000000, "RW", "p5res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{20, 24, 0x0000000000000000, "RW", "p5res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x0000000000000000, "RW", "p4res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{15, 19, 0x0000000000000000, "RW", "p4res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x0000000000000000, "RW", "p3res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{10, 14, 0x0000000000000000, "RW", "p3res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x0000000000000000, "RW", "p2res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{5, 9, 0x0000000000000000, "RW", "p2res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "p1res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{0, 4, 0x0000000000000000, "RW", "p1res", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo49[] = {{"D_CR_RD_PROM2", "", 0x0000013C, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields50[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", "Reserved."},
#else
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 29, 0x0000000000000000, "RW", "p6res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{25, 29, 0x0000000000000000, "RW", "p6res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 24, 0x000000000000001F, "RW", "p5res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{20, 24, 0x000000000000001F, "RW", "p5res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x0000000000000005, "RW", "p4res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{15, 19, 0x0000000000000005, "RW", "p4res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x0000000000000005, "RW", "p3res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{10, 14, 0x0000000000000005, "RW", "p3res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x0000000000000000, "RW", "p2res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{5, 9, 0x0000000000000000, "RW", "p2res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "p1res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{0, 4, 0x0000000000000000, "RW", "p1res", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo50[] = {{"D_CR_RD_PROM3", "", 0x00000140, 7, 0x00000000FFFFFFFF, 0x0000000001F29400}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields51[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", "Reserved."},
#else
{30, 31, 0x0000000000000000, "RO", "rsvd31_30", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 29, 0x0000000000000000, "RW", "p6res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{25, 29, 0x0000000000000000, "RW", "p6res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 24, 0x000000000000001F, "RW", "p5res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{20, 24, 0x000000000000001F, "RW", "p5res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x000000000000000A, "RW", "p4res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{15, 19, 0x000000000000000A, "RW", "p4res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x000000000000000A, "RW", "p3res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{10, 14, 0x000000000000000A, "RW", "p3res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x000000000000000A, "RW", "p2res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{5, 9, 0x000000000000000A, "RW", "p2res", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x000000000000000A, "RW", "p1res", "Number of CASes that pass before a request in this priority promotes to the next priority level."},
#else
{0, 4, 0x000000000000000A, "RW", "p1res", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo51[] = {{"D_CR_RD_PROM4", "", 0x00000144, 7, 0x00000000FFFFFFFF, 0x0000000001F5294A}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields52[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{11, 31, 0x0000000000000000, "RO", "rsvd31_11", "Reserved."},
#else
{11, 31, 0x0000000000000000, "RO", "rsvd31_11", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 10, 0x0000000000000006, "RW", "deadline_thrs", "A requests with initial priority of 0 will exit priority 0 when its deadline is equal or less than this value plus current time.  This field does not affect the priority of any requests in access classes with initial priority bigger than 0."},
#else
{0, 10, 0x0000000000000006, "RW", "deadline_thrs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo52[] = {{"D_CR_DL_THRS", "", 0x00000148, 2, 0x00000000FFFFFFFF, 0x0000000000000006}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields53[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{25, 31, 0x0000000000000000, "RO", "rsvd31_25", "Reserved."},
#else
{25, 31, 0x0000000000000000, "RO", "rsvd31_25", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "wmm_reg_r1", "Disable WMM unsafe write page hits block safe write page misses same bank."},
#else
{24, 24, 0x0000000000000000, "RW", "wmm_reg_r1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RO", "rsvd23_20", "Reserved."},
#else
{20, 23, 0x0000000000000000, "RO", "rsvd23_20", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "wmm_prio_r4", "Disable WMM unsafe priority 1 read miss block write hit to same bank. \r\n"
"  [p]Note: This rule does not block the bank that is being blocked by WMM_PRIO_R3.[/p]\r\n"
"  [p]Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]"},
#else
{19, 19, 0x0000000000000000, "RW", "wmm_prio_r4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "wmm_prio_r3", "Disable WMM unsafe priority 1 write hit block write miss to same bank.\r\n"
"  [p]Note: This rule does not block the bank that is being blocked by WMM_PRIO_R1.[/p]\r\n"
"  [p]Priority rules 1,3 and 4 should be enabled/disabled together.[/p]"},
#else
{18, 18, 0x0000000000000000, "RW", "wmm_prio_r3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "wmm_prio_r2", "Disable WMM CAS block rule."},
#else
{17, 17, 0x0000000000000000, "RW", "wmm_prio_r2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "wmm_prio_r1", "Disable WMM unsafe top priority 1 write miss block write hit same bank.\r\n"
"  [p]Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]"},
#else
{16, 16, 0x0000000000000000, "RW", "wmm_prio_r1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RO", "rsvd15_14", "Reserved."},
#else
{14, 15, 0x0000000000000000, "RO", "rsvd15_14", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 13, 0x0000000000000000, "RW", "rmm_reg_r6", "Disable RMM unsafe write page hits block safe write page misses same bank."},
#else
{13, 13, 0x0000000000000000, "RW", "rmm_reg_r6", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000001, "RW", "rmm_reg_r5", "Disable RMM unsafe read page miss block all safe and unsafe write page hit to the same bank. \r\n"
"  [p]Note: This field must not be set to 0 (enabled) if RMM_REG_R4 is also 0.[/p]"},
#else
{12, 12, 0x0000000000000001, "RW", "rmm_reg_r5", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000001, "RW", "rmm_reg_r4", "Disable RMM unsafe write page hit block safe read page miss same bank. \r\n"
"  [p]Note: This field must not be set to 0 (enabled) if RMM_REG_R5 is also 0.[/p]"},
#else
{11, 11, 0x0000000000000001, "RW", "rmm_reg_r4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "rmm_reg_r3", "Disable RMM unsafe read page hit block safe read and write page miss same bank. \r\n"
"  [p]Note: This rule does not block the bank that is being blocked by RMM_PRIO_R3 and RMM_PRIO_R1.[/p]"},
#else
{10, 10, 0x0000000000000000, "RW", "rmm_reg_r3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "rmm_reg_r2", "Disable RMM unsafe read page empty block safe write page empty same rank."},
#else
{9, 9, 0x0000000000000000, "RW", "rmm_reg_r2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "rmm_reg_r1", "Disable RMM unsafe read page hit block safe write page hit same rank."},
#else
{8, 8, 0x0000000000000000, "RW", "rmm_reg_r1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO", "rsvd7_4", "Reserved."},
#else
{4, 7, 0x0000000000000000, "RO", "rsvd7_4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "rmm_prio_r4", "Disable RMM unsafe critical read miss block read and write hit to same bank. \r\n"
"  [p]Note: This rule does not block the bank that is being blocked by RMM_PRIO_R3.[/p]\r\n"
"  [p]Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]"},
#else
{3, 3, 0x0000000000000000, "RW", "rmm_prio_r4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "rmm_prio_r3", "Disable RMM unsafe critical read hit block read and write miss to same bank. \r\n"
"  [p]Note: This rule does not block the bank that is being blocked by RMM_PRIO_R1.[/p]\r\n"
"  [p]Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]"},
#else
{2, 2, 0x0000000000000000, "RW", "rmm_prio_r3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "rmm_prio_r2", "Disable RMM CAS block rule."},
#else
{1, 1, 0x0000000000000000, "RW", "rmm_prio_r2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "rmm_prio_r1", "Disable RMM unsafe top critical read miss block read and write hit same bank. \r\n"
"  [p]Note: Priority rules 1, 3 and 4 should be enabled/disabled together.[/p]"},
#else
{0, 0, 0x0000000000000000, "RW", "rmm_prio_r1", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo53[] = {{"D_CR_MM_BLK", "", 0x0000014C, 19, 0x00000000FFFFFFFF, 0x0000000000001800}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields54[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{4, 31, 0x0000000000000000, "RO", "rsvd31_4", "Reserved."},
#else
{4, 31, 0x0000000000000000, "RO", "rsvd31_4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW/V", "suspendp", "A SUSPENDP message will put the DRAM into self-refresh mode. The D-Unit will complete servicing outstanding memory requests and flush all queued Refresh commands to DRAM before putting the DRAM in self refresh mode. Finally, a PM message will be sent to the PHY. The bit is cleared by hardware after the PHY indicates the transition requested in the PM message has been completed.  D-Unit will perform an MRW to MR17 with an opcode as defined by DPMC0.PASR before it places the DRAM into Self-Refresh. \r\n"
"  [p]Note: Reserved for BXT0/1.[/p]"},
#else
{3, 3, 0x0000000000000000, "RW/V", "suspendp", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW/V", "suspend", "A SUSPEND message will put the DRAM into self-refresh mode. The D-Unit will complete servicing outstanding memory requests and flush all queued Refresh commands to DRAM before putting the DRAM in Self Refresh mode. Finally, a PM message will be sent to the PHY. The bit is cleared by hardware only after the PHY indicates the transition requested in the PM message has been completed. \r\n"
"  [p]Note: When COLDWAKE is set prior of setting this bit the DRAM will not be placed in SR.[/p]"},
#else
{2, 2, 0x0000000000000000, "RW/V", "suspend", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO", "rsvd1", "Reserved."},
#else
{1, 1, 0x0000000000000000, "RO", "rsvd1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW/V", "wake", "Take PHY out of PM states and wakes the DRAM out of self refresh mode. The bit is cleared by hardware only when the DRAM has exited out of self refresh mode and is accessible. \r\n"
"  [p]Note: When COLDWAKE is set prior of setting this bit the D-Unit will not send SR exit command and will not set the DCO.IC bit.[/p]"},
#else
{0, 0, 0x0000000000000000, "RW/V", "wake", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo54[] = {{"D_CR_DRAM_SR_CMD", "", 0x00000154, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields55[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "m2n", "2N Mode Command (LPDDR3/DDR3L/DDR4)"},
#else
{31, 31, 0x0000000000000000, "RW", "m2n", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "rank", "Rank select. \r\n"
"  [list]\r\n"
"  [*]0: Rank0.\r\n"
"  [*]1: Rank1.\r\n"
"  [/list]"},
#else
{30, 30, 0x0000000000000000, "RW", "rank", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW", "mrrcmd", "This bit needs to be set if the command is a MRR/Read."},
#else
{29, 29, 0x0000000000000000, "RW", "mrrcmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "bl", "This field sets the BL that D-Unit drives on SPID interface. \r\n"
"  For LPDDR3, DDR3L and WIO2: \r\n"
"  [list]\r\n"
"  [*]0: Burst Length is 4.  \r\n"
"  [*]1: Burst Length is 8. \r\n"
"  [/list]\r\n"
"  For LPDDR4:\r\n"
"      [list]\r\n"
"  [*]0: Burst Length is 16.\r\n"
"  [*]1: Burst Length is 32.\r\n"
"      [/list]\r\n"
"  "},
#else
{28, 28, 0x0000000000000000, "RW", "bl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RW", "rdcmd_type", "Dunit will drive the value on SPID RDCMD_TYPE bus. Indicates to PHY whether it needs to consume DRAM returned data\r\n"
"      [list]\r\n"
"  [*]00: All commands other than MR18 and MR19.\r\n"
"  [*]01: LPDDR4 MR18 Command.\r\n"
"      [*]10: LPDDR4 MR19 Command.\r\n"
"      {*]11: Reserved.\r\n"
"      [/list]\r\n"
"      "},
#else
{26, 27, 0x0000000000000000, "RW", "rdcmd_type", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RO", "rsvd25_24", "Reserved."},
#else
{24, 25, 0x0000000000000000, "RO", "rsvd25_24", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 23, 0x0000000000000000, "RW", "data", "Command to be sent to DRAM. Not all DRAM commands are supported. \r\n"
"      [p]For DDR3L: DATA[15:0] = A[15:0], DATA[18:16] = BA[2:0], DATA[19] = WE_N, DATA[20] = CAS_N, DATA[21] = RAS_N, DATA[23:22] not used.[/p]\r\n"
"  [p]For LPDDR3: DATA[9:0]=CA[9:0] Rising Edge, DATA [19:10]=CA[9:0] Falling Edge, DATA[23:20] not used.[/p] \r\n"
"  [p]For WIO2: DATA[10:0]=CA[10:0] Rising Edge, DATA[21:11]=CA[10:0] Falling Edge, Data[23:22] not used.[/p] \r\n"
"  [p]For LPDDR4: DATA[5:0]=CA[5:0] CMD1 Edge1, DATA[11:6]=CA[5:0] CMD1 Edge2, DATA[17:12]=CA[5:0] CMD2 Edge1, DATA[23:18]=CA[5:0] CMD2 Edge2.[/p]\r\n"
"      [p]For DDR4: DATA[13:0] = A[13:0], DATA[14:14] = A[14]/WE_N, DATA[15:15] = A[15]/CAS_N, DATA[16:16] = A[16]/RAS_N, DATA[18:17] = BA[1:0], DATA[20:19] = BG[1:0], DATA[21] = ACT_N, DATA[23:22] not used.[/p]"},
#else
{0, 23, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo55[] = {{"D_CR_DRAM_CMD", "", 0x00000158, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields56[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "rsvd31_24", "Reserved."},
#else
{24, 31, 0x0000000000000000, "RO", "rsvd31_24", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RO/V", "mrrdata2", "MRR Data (2nd Device): This field contains the 2nd device data of the last DRAM mode register read (MRR) issued through DRAM_CMD register. It is overwritten with each MRR command.\r\n"
"      [p]Note: Correct byte is selected in MR4_BYTE_SEL2.[/p]"},
#else
{16, 23, 0x0000000000000000, "RO/V", "mrrdata2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RO", "rsvd15_8", "Reserved."},
#else
{8, 15, 0x0000000000000000, "RO", "rsvd15_8", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RO/V", "mrrdata", "MRR Data (1st Device): This field contains 8bit data of the last DRAM mode register read (MRR) issued through DRAM_CMD register. It is overwritten with each MRR command. \r\n"
"      [p]Note: Correct byte is selected in MR4_BYTE_SEL.[/p]"},
#else
{0, 7, 0x0000000000000000, "RO/V", "mrrdata", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo56[] = {{"D_CR_DCMDDATA", "", 0x0000015C, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields57[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "enable_prdr", "Enables pseudo-random data return feature in D-Unit. Should be\r\n"
"      set before D_CR_BGF_CTL_BGF_RUN is set to 1. Note one should always enable PRDR before enabling CheckSum for any usage model that requires both features"},
#else
{31, 31, 0x0000000000000000, "RW", "enable_prdr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "enable_checksum", "Enables checksum calculation in D-Unit. Should be set before D_CR_BGF_CTL_BGF_RUN is set to 1"},
#else
{30, 30, 0x0000000000000000, "RW", "enable_checksum", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "WO", "reset", "Resets the checksum registers when written to 1. \r\n"
"  [p]Bit automatically resets to 0.[/p]"},
#else
{29, 29, 0x0000000000000000, "WO", "reset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "rddata_credit_en", "When set, read data credit counter register is used for credit handling instead of initial credit handshaking."},
#else
{28, 28, 0x0000000000000000, "RW", "rddata_credit_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "rddata_credit", "Read data credit counter value. This values is used as read return credit."},
#else
{24, 27, 0x0000000000000000, "RW", "rddata_credit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW/1C", "addr_checksum", "Contains the address checksum value for all addresses read and written from this D-Unit. Write 1 to clear this field."},
#else
{16, 23, 0x0000000000000000, "RW/1C", "addr_checksum", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW/1C", "data_checksum", "Contains the final checksum value for all data written to this D-Unit. Write 1 to clear this field."},
#else
{0, 15, 0x0000000000000000, "RW/1C", "data_checksum", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo57[] = {{"D_CR_SBFT_CTL", "", 0x00000160, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields58[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000FFFFFFFF, "RW", "clear_mask", "Mask ANDed with pseudo-random data. Resets to all 1s. Setting bit n to 0 in this register will force every nth bit in the data to be set to 0"},
#else
{0, 31, 0x00000000FFFFFFFF, "RW", "clear_mask", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo58[] = {{"D_CR_SBFT_CMASK", "", 0x00000164, 1, 0x00000000FFFFFFFF, 0x00000000FFFFFFFF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields59[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "set_mask", "Mask ORed with pseudo-random data.  Resets to all 0s.  Setting bit n to 1 in this register will force every nth bit in the data to be set to 1."},
#else
{0, 31, 0x0000000000000000, "RW", "set_mask", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo59[] = {{"D_CR_SBFT_SMASK", "", 0x00000168, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields60[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "seed", "Seed XORed with address bits to produce pseudo-random data.  Use this to statically produce different pseudo-random data streams for the same set of request addresses."},
#else
{0, 31, 0x0000000000000000, "RW", "seed", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo60[] = {{"D_CR_SBFT_SEED", "", 0x0000016C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields61[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{6, 31, 0x0000000000000000, "RO", "rsvd31_6", "Reserved."},
#else
{6, 31, 0x0000000000000000, "RO", "rsvd31_6", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "hae", "If enabled (1), D-Unit may request a power-gate whenever it is idle. \r\n"
"  [p]Note: If this bit is set, then PMCRE must be 0.[/p]"},
#else
{5, 5, 0x0000000000000000, "RW", "hae", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RO", "rsvd4", "Reserved."},
#else
{4, 4, 0x0000000000000000, "RO", "rsvd4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000001, "RW", "se", "\r\n"
"  [list]\r\n"
"  [*]0: D-Unit will never asset Sleep to the retention flops. \r\n"
"  [*]1: D-Unit may assert Sleep during Power Gating. \r\n"
"  [/list]\r\n"
"  [p]Note: Some platforms may default this bit to 0 others to 1.[/p]"},
#else
{3, 3, 0x0000000000000001, "RW", "se", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 2, 0x0000000000000000, "RO", "rsvd2_1", "Reserved."},
#else
{1, 2, 0x0000000000000000, "RO", "rsvd2_1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "pmcre", "When enabled (1), D-Unit will power gate when idle and the PMC requests power gating."},
#else
{0, 0, 0x0000000000000001, "RW", "pmcre", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo61[] = {{"D_CR_PGCB_PWRGATE_PCE", "", 0x00000170, 6, 0x00000000FFFFFFFF, 0x0000000000000009}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields62[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{4, 31, 0x0000000000000000, "RO", "rsvd31_4", "Reserved."},
#else
{4, 31, 0x0000000000000000, "RO", "rsvd31_4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "pg_timer", "This is the time from which all internal Idle conditions have been observed to when PGCB actually starts the power gating sequence. Used only when power gating is enabled (HAE is set to 1). \r\n"
"  [p]Note: The actual count value is 2^value.[/p]"},
#else
{0, 3, 0x0000000000000000, "RW", "pg_timer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo62[] = {{"D_CR_PGCB_PG_IDLE_TIMER", "", 0x00000174, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields63[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{12, 31, 0x0000000000000000, "RO", "rsvd31_12", "Reserved."},
#else
{12, 31, 0x0000000000000000, "RO", "rsvd31_12", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "pgcb_clkreq_dis", "When set to 1, it prevents the PGCB from deasserting PGCB clkreq. Prevents PGCB clock trunk from ever gating.  \r\n"
"  [list]\r\n"
"  [*]0: Enable PGCB clock request.\r\n"
"  [*]1: Disable PGCB clock request.\r\n"
"  [/list]"},
#else
{11, 11, 0x0000000000000000, "RW", "pgcb_clkreq_dis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "saby2_clkreq_dis", "When set to 1, it prevents the SA/2 CDC from deasserting clkreq due to idle conditions. Has no effect on clkreq deassertion during a forced power gate entry flow. This prevents trunk clock gating. However, local clock gating can still be enabled. \r\n"
"  [list]\r\n"
"  [*]0: Enable SA/2 clock request. \r\n"
"  [*]1: Disable SA/2 clock request.\r\n"
"  [/list]"},
#else
{10, 10, 0x0000000000000000, "RW", "saby2_clkreq_dis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "spid_clkreq_dis", "When set to 1, it prevents the SPID CDC from deasserting clkreq due to idle conditions. Has no effect on clkreq deassertion during a forced power gate entry flow. This prevents trunk clock gating. However, local clock gating can still be enabled. \r\n"
"  [list]\r\n"
"  [*]0: Enable SPID clock request.\r\n"
"  [*]1: Disable SPID clock request.\r\n"
"  [/list]"},
#else
{9, 9, 0x0000000000000000, "RW", "spid_clkreq_dis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "sb_clkreq_dis", "When set to 1, it prevents the SB CDC from deasserting clkreq due to idle conditions. Has no effect on clkreq deassertion during a forced power gate entry flow. This prevents trunk clock gating. However, local clock gating can still be enabled. \r\n"
"  [list]\r\n"
"  [*]0: Enable SB clock request.\r\n"
"  [*]1: Disable SB clock request.\r\n"
"  [/list]"},
#else
{8, 8, 0x0000000000000000, "RW", "sb_clkreq_dis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000001, "RW", "ug_cg_dis", "Setting this field to 1 disables any clock gating in the ungated domain due to idle conditions. Also, if set, it prevents D-Unit ungated domain trunk clock gating.\r\n"
"      [list]\r\n"
"      [*]0 - Enable ungated domain Clock Gating.\r\n"
"      [*]1 - Disable ungated domain Clock Gating.\r\n"
"      [/list]"},
#else
{7, 7, 0x0000000000000001, "RW", "ug_cg_dis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 6, 0x0000000000000000, "RO", "rsvd6_3", "Reserved"},
#else
{3, 6, 0x0000000000000000, "RO", "rsvd6_3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "saby2_cg_dis", "Setting this field to 1 disables SA/2 clock gating due to idle conditions. Also, if set, it prevents SA/2 trunk clock gating. \r\n"
"  [list]\r\n"
"  [*]0: Enable SA/2 clock gating.\r\n"
"  [*]1: Disable SA/2 clock gating.\r\n"
"  [/list]"},
#else
{2, 2, 0x0000000000000000, "RW", "saby2_cg_dis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "spid_cg_dis", "Setting this field to 1 disables any SPID clock gating due to idle conditions. Also if set, it prevents SPID trunk clock gating.  \r\n"
"  [list]\r\n"
"  [*]0: Enable SPID clock gating.\r\n"
"  [*]1: Disable SPID clock gating.\r\n"
"  [/list]"},
#else
{1, 1, 0x0000000000000000, "RW", "spid_cg_dis", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "sb_cg_dis", "Setting this field to 1 disables any Side Band clock gating due to idle conditions. Also if set, it prevents SB trunk clock gating. \r\n"
"  [list]\r\n"
"  [*]0: Enable SB Clock Gating.\r\n"
"  [*]1: Disable SB Clock Gating.\r\n"
"  [/list]"},
#else
{0, 0, 0x0000000000000000, "RW", "sb_cg_dis", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo63[] = {{"D_CR_PGCB_CLKGATE_DIS", "", 0x00000178, 10, 0x00000000FFFFFFFF, 0x0000000000000080}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields64[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{20, 31, 0x0000000000000000, "RO", "rsvd31_20", "Reserved."},
#else
{20, 31, 0x0000000000000000, "RO", "rsvd31_20", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000002, "RW", "saby2_clk_timer", "This is the minimum time from the SA/2 CDC detects clock reqs deasserting until gclock is gated.  The actual count is 2^value. For example, setting this register to 4'd5 would result in a holdoff time of 32 clock cycles."},
#else
{16, 19, 0x0000000000000002, "RW", "saby2_clk_timer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RO", "rsvd15_12", "Reserved."},
#else
{12, 15, 0x0000000000000000, "RO", "rsvd15_12", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000002, "RW", "spid_clk_timer", "This is the minimum time from the SPID CDC detects all clock reqs deasserting until gclock is gated. The actual count is 2^value. For example, setting this register to 4'd5 would result in a holdoff time of 32 clock cycles."},
#else
{8, 11, 0x0000000000000002, "RW", "spid_clk_timer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO", "rsvd7_4", "Reserved."},
#else
{4, 7, 0x0000000000000000, "RO", "rsvd7_4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000002, "RW", "sb_clk_timer", "This is the minimum time from the SB CDC detects all clock reqs deasserting until gclock is gated. The actual count is 2^value. For example, setting this register to 4'd5 would result in a holdoff time of 32 clock cycles."},
#else
{0, 3, 0x0000000000000002, "RW", "sb_clk_timer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo64[] = {{"D_CR_PGCB_CG_IDLE_TIMER", "", 0x0000017C, 6, 0x00000000FFFFFFFF, 0x0000000000020202}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields65[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RW", "dqs_retrain_int", "This sets the frequency by which the D-Unit initiates periodic retraining (in 1x NREFI)."},
#else
{16, 31, 0x0000000000000000, "RW", "dqs_retrain_int", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RO", "rsvd15_14", "Reserved."},
#else
{14, 15, 0x0000000000000000, "RO", "rsvd15_14", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 13, 0x0000000000000000, "RW", "dqs_osc_rt", "After D-Unit starts DQS oscillator, it must wait this amount of time before being able to read the value in MR18 and MR19 (in 16x DRAM clocks).\r\n"
"  [p]Value in this register must be at least equal to DRAM's MR23 value. + tOSCO.[/p]"},
#else
{4, 13, 0x0000000000000000, "RW", "dqs_osc_rt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW/V", "dqs_retrain_start_r1", "When set, Dunit will initiate LPDDR4 DQS training sequence on Rank1. \r\n"
"      [p]Hardware will clear bit when sequence completes (after issuing MR19).[/p]\r\n"
"      [p]Note: DQS_RETRAIN_EN must be 0 before setting this bit.[/p]"},
#else
{3, 3, 0x0000000000000000, "RW/V", "dqs_retrain_start_r1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW/V", "dqs_retrain_start_r0", "When set, Dunit will initiate LPDDR4 DQS training sequence on Rank0. \r\n"
"      [p]Hardware will clear bit when sequence completes (after issuing MR19).[/p]\r\n"
"      [p]Note: DQS_RETRAIN_EN must be 0 before setting this bit.[/p]"},
#else
{2, 2, 0x0000000000000000, "RW/V", "dqs_retrain_start_r0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "dqs_retrain_srx_en", "Enable retraining on SR exit.\r\n"
"  [p]This bit enables LPDDR4 DQS retraining on Self Refresh Exit. If disabled, D-Unit will not perform retraining on SR exit.[/p]"},
#else
{1, 1, 0x0000000000000000, "RW", "dqs_retrain_srx_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "dqs_retrain_en", "Periodic retraining enable:\r\n"
"  [p]This bit enables periodic DQS retraining. If disabled, D-Unit will not perform retraining periodically.[/p] \r\n"
"  [p]Note: Will be enabled only if DCO.IC is set and refreshes are enabled in DRF.MINREFRATE.[/p]"},
#else
{0, 0, 0x0000000000000000, "RW", "dqs_retrain_en", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo65[] = {{"D_CR_DQS_RETRAINING_CTL", "", 0x00000180, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields66[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "rsvd31", "Reserved."},
#else
{31, 31, 0x0000000000000000, "RO", "rsvd31", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 30, 0x0000000000000000, "RW", "mr4_bit2_sel2", "Selects bit 2 of MR4 data."},
#else
{28, 30, 0x0000000000000000, "RW", "mr4_bit2_sel2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RO", "rsvd27", "Reserved"},
#else
{27, 27, 0x0000000000000000, "RO", "rsvd27", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000000, "RW", "mr4_bit1_sel2", "Selects bit 1 of MR4 data"},
#else
{24, 26, 0x0000000000000000, "RW", "mr4_bit1_sel2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RO", "rsvd23", "Reserved"},
#else
{23, 23, 0x0000000000000000, "RO", "rsvd23", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 22, 0x0000000000000000, "RW", "mr4_bit0_sel2", "Selects bit 0 of MR4 data."},
#else
{20, 22, 0x0000000000000000, "RW", "mr4_bit0_sel2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RO", "rsvd19_18", "Reserved"},
#else
{18, 19, 0x0000000000000000, "RO", "rsvd19_18", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "mr4_byte_sel2", "Selects byte position of the MR4 data for second device."},
#else
{16, 17, 0x0000000000000000, "RW", "mr4_byte_sel2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "rsvd15", "Reserved"},
#else
{15, 15, 0x0000000000000000, "RO", "rsvd15", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "mr4_bit2_sel", "Selects bit 2 of MR4 data."},
#else
{12, 14, 0x0000000000000000, "RW", "mr4_bit2_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "rsvd11", "Reserved."},
#else
{11, 11, 0x0000000000000000, "RO", "rsvd11", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "mr4_bit1_sel", "Selects bit 1 of MR4 data."},
#else
{8, 10, 0x0000000000000000, "RW", "mr4_bit1_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO", "rsvd7", "Reserved."},
#else
{7, 7, 0x0000000000000000, "RO", "rsvd7", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000000, "RW", "mr4_bit0_sel", "Selects bit 0 of MR4 data."},
#else
{4, 6, 0x0000000000000000, "RW", "mr4_bit0_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RO", "rsvd3_2", "Reserved."},
#else
{2, 3, 0x0000000000000000, "RO", "rsvd3_2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "mr4_byte_sel", "Selects byte position of the MR4 data first device."},
#else
{0, 1, 0x0000000000000000, "RW", "mr4_byte_sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo66[] = {{"D_CR_MR4_DESWIZZLE", "", 0x00000184, 16, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields67[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 63, 0x00000C00610D0212, "RW", "rac_policy", "Each bit specifies read access policy of one SAI agent."},
#else
{0, 63, 0x00000C00610D0212, "RW", "rac_policy", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo67[] = {{"D_CR_DUNIT_GRPA_RAC", "", 0x00000190, 1, 0xFFFFFFFFFFFFFFFF, 0x00000C00610D0212}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields68[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 63, 0x00000C00610D0212, "RW", "wac_policy", "Each bit specifies write access policy of one SAI agent."},
#else
{0, 63, 0x00000C00610D0212, "RW", "wac_policy", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo68[] = {{"D_CR_DUNIT_GRPA_WAC", "", 0x00000198, 1, 0xFFFFFFFFFFFFFFFF, 0x00000C00610D0212}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields69[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 63, 0x00000C0061010202, "RW", "c_policy", "Each bit specifies control access policy of one SAI agent. Agents who have access can modify the control policies in the SAI registers."},
#else
{0, 63, 0x00000C0061010202, "RW", "c_policy", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo69[] = {{"D_CR_DUNIT_GRPA_CP", "", 0x000001A0, 1, 0xFFFFFFFFFFFFFFFF, 0x00000C0061010202}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields70[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 63, 0x00000C00010C0212, "RW", "rac_policy", "Each bit specifies read access policy of one SAI agent."},
#else
{0, 63, 0x00000C00010C0212, "RW", "rac_policy", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo70[] = {{"D_CR_DUNIT_GRPB_RAC", "", 0x000001A8, 1, 0xFFFFFFFFFFFFFFFF, 0x00000C00010C0212}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields71[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 63, 0x00000C00010C0212, "RW", "wac_policy", "Each bit specifies write access policy of one SAI agent."},
#else
{0, 63, 0x00000C00010C0212, "RW", "wac_policy", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo71[] = {{"D_CR_DUNIT_GRPB_WAC", "", 0x000001B0, 1, 0xFFFFFFFFFFFFFFFF, 0x00000C00010C0212}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields72[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 63, 0x00000C0001000202, "RW", "c_policy", "Each bit specifies control access policy of one SAI agent. Agents who have access can modify the control policies in the SAI registers."},
#else
{0, 63, 0x00000C0001000202, "RW", "c_policy", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo72[] = {{"D_CR_DUNIT_GRPB_CP", "", 0x000001B8, 1, 0xFFFFFFFFFFFFFFFF, 0x00000C0001000202}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields73[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "tmpdata", "xxx"},
#else
{0, 31, 0x0000000000000000, "RW", "tmpdata", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo73[] = {{"CR_BGF_CTL", "", 0x00000120, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields74[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "tmpdata", "xxx"},
#else
{0, 31, 0x0000000000000000, "RW", "tmpdata", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo74[] = {{"FAKE_WAKE", "", 0x000001F0, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields75[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000061010202, "RW", "control_policy_l", "Lower half of the SAI Control Policy Value [31:0]."},
#else
{0, 31, 0x0000000061010202, "RW", "control_policy_l", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo75[] = {{"CPGC2_ACCESS_CONTROL_POLICY_L", "", 0x00000000, 1, 0x00000000FFFFFFFF, 0x0000000061010202}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields76[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000C00, "RW", "control_policy_h", "Upper half of the SAI Control Policy Value [63:32]."},
#else
{0, 31, 0x0000000000000C00, "RW", "control_policy_h", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo76[] = {{"CPGC2_ACCESS_CONTROL_POLICY_H", "", 0x00000004, 1, 0x00000000FFFFFFFF, 0x0000000000000C00}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields77[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000FFFFFF3F, "RW", "read_policy_l", "Lower half of the SAI Read Policy Value [31:0]."},
#else
{0, 31, 0x00000000FFFFFF3F, "RW", "read_policy_l", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo77[] = {{"CPGC2_ACCESS_READ_POLICY_L", "", 0x00000008, 1, 0x00000000FFFFFFFF, 0x00000000FFFFFF3F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields78[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000001371FFF, "RW", "read_policy_h", "Upper half of the SAI Read Policy Value [63:32]."},
#else
{0, 31, 0x0000000001371FFF, "RW", "read_policy_h", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo78[] = {{"CPGC2_ACCESS_READ_POLICY_H", "", 0x0000000C, 1, 0x00000000FFFFFFFF, 0x0000000001371FFF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields79[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000001000212, "RW", "write_policy_l", "Lower half of the SAI Write Policy Value [31:0]."},
#else
{0, 31, 0x0000000001000212, "RW", "write_policy_l", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo79[] = {{"CPGC2_ACCESS_WRITE_POLICY_L", "", 0x00000010, 1, 0x00000000FFFFFFFF, 0x0000000001000212}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields80[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000C00, "RW", "write_policy_h", "Upper half of the SAI Write Policy Value [63:32]."},
#else
{0, 31, 0x0000000000000C00, "RW", "write_policy_h", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo80[] = {{"CPGC2_ACCESS_WRITE_POLICY_H", "", 0x00000014, 1, 0x00000000FFFFFFFF, 0x0000000000000C00}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields81[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "address_decode_rotate_repeats", "Number of times the current Address_Instruction will repeat if Address_Decode_Enable is set (as N-1) (0=1 time).[br]\r\n"
"If  for the current Address_Instruction, Address_Decode_Enable is set, then at the start of that Address_Instruction, initialize the XOR_Address_Pattern to a single 1 in the LSB of Column Address. Otherwise, it is initialized to all zero's.[br]\r\n"
"For (Address_Decode_Rotate_Repeat_Current = 0; Current_ Address_Decode_Rotate_Repeat_Current <= Address_Decode_Rotate_Repeat;  Address_Decode_Rotate_Repeat_Current ++)[br]\r\n"
"Execute the entire Algorithm (Block Traversal, Algorithm_Instruction, Commands) with the following behavior:[br]\r\n"
"At the end of each complete Block Traversal, rotate the XOR Address Pattern 1 bit position from LSB to MSB (Column through Region_Bits_Column, Region_Bits_Row, Region_Num_Banks, and through Region_Num_Ranks).[br]\r\n"
"Region_Size.Num_Bank and Region_Size.Num_Rank numbers are converted to the equivalent number of adddress bits to cover their range (ceil(log2(Num+1))) and should be programmed to a power of 2 value (minus 1): 1,3,7, or 15.[br]\r\n"
"If only one Rank is being tested, then you should limit the amount in this register to the sum of the number of address bits without Rank bits."},
#else
{0, 5, 0x0000000000000000, "RW", "address_decode_rotate_repeats", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo81[] = {{"CPGC2_ADDRESS_CONTROL", "", 0x00000018, 1, 0x000000000000003F, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields82[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set, then this is the last Address Instruction and the test will terminate following full execution of this instruction. If there are no Last bits set in the Address Instruction list, then the test will not stop due to a completion of the test, but will be an Infinite Test."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "address_decode_enable", "Enables rotating XOR of address bits. Used in concert with the Address_Decode_Enable field in the Command_Instruction list.[br]\r\n"
"This bit enables repeating of the current Address_Instruction for Address_Decode_Rotate_Repeats times."},
#else
{6, 6, 0x0000000000000000, "RW", "address_decode_enable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(10) Inv(FastX) - North West[/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(11) Diagonal2 - East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  West [/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"Note that the Bank and Rank Address direction follows the same as the Column (Increment or Decrement).[br]\r\n"
"Note for diagonal directions, a Carry results in twice the normal increment/decrement of the Row field.[br]\r\n"
"Incrementing fields start at 0, and Decrementing fields start at 2^(field_block_size)-2^(field_increment)= top of block."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RW", "address_order", "Controls the fastest changing address field, and how that carries into higher order fields.[br]\r\n"
"000 Rank, Bank, Row/Col.[br]\r\n"
"001 Rank, Row/Col, Bank.[br]\r\n"
"010 Bank, Rank, Row/Col.[br]\r\n"
"011 Bank, Row/Col, Rank.[br]\r\n"
"100 Row/Col, Rank, Bank.[br]\r\n"
"101 Row/Col, Bank, Rank.[br]\r\n"
"110 Row/Col  (Used for Offset) Rank and Bank are unchanged.[br]\r\n"
"111 Row-Col (Used for Stripe Offset) No Carry from any field to another.[br]\r\n"
"Carry order between Row and Column is dependent on the Address_Direction field."},
#else
{0, 2, 0x0000000000000000, "RW", "address_order", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo82[] = {{"CPGC2_ADDRESS_INSTRUCTION_0_", "", 0x0000001C, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields83[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set, then this is the last Address Instruction and the test will terminate following full execution of this instruction. If there are no Last bits set in the Address Instruction list, then the test will not stop due to a completion of the test, but will be an Infinite Test."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "address_decode_enable", "Enables rotating XOR of address bits. Used in concert with the Address_Decode_Enable field in the Command_Instruction list.[br]\r\n"
"This bit enables repeating of the current Address_Instruction for Address_Decode_Rotate_Repeats times."},
#else
{6, 6, 0x0000000000000000, "RW", "address_decode_enable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(10) Inv(FastX) - North West[/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(11) Diagonal2 - East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  West [/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"Note that the Bank and Rank Address direction follows the same as the Column (Increment or Decrement).[br]\r\n"
"Note for diagonal directions, a Carry results in twice the normal increment/decrement of the Row field.[br]\r\n"
"Incrementing fields start at 0, and Decrementing fields start at 2^(field_block_size)-2^(field_increment)= top of block."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RW", "address_order", "Controls the fastest changing address field, and how that carries into higher order fields.[br]\r\n"
"000 Rank, Bank, Row/Col.[br]\r\n"
"001 Rank, Row/Col, Bank.[br]\r\n"
"010 Bank, Rank, Row/Col.[br]\r\n"
"011 Bank, Row/Col, Rank.[br]\r\n"
"100 Row/Col, Rank, Bank.[br]\r\n"
"101 Row/Col, Bank, Rank.[br]\r\n"
"110 Row/Col  (Used for Offset) Rank and Bank are unchanged.[br]\r\n"
"111 Row-Col (Used for Stripe Offset) No Carry from any field to another.[br]\r\n"
"Carry order between Row and Column is dependent on the Address_Direction field."},
#else
{0, 2, 0x0000000000000000, "RW", "address_order", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo83[] = {{"CPGC2_ADDRESS_INSTRUCTION_1_", "", 0x0000001D, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields84[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set, then this is the last Address Instruction and the test will terminate following full execution of this instruction. If there are no Last bits set in the Address Instruction list, then the test will not stop due to a completion of the test, but will be an Infinite Test."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "address_decode_enable", "Enables rotating XOR of address bits. Used in concert with the Address_Decode_Enable field in the Command_Instruction list.[br]\r\n"
"This bit enables repeating of the current Address_Instruction for Address_Decode_Rotate_Repeats times."},
#else
{6, 6, 0x0000000000000000, "RW", "address_decode_enable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(10) Inv(FastX) - North West[/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(11) Diagonal2 - East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  West [/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"Note that the Bank and Rank Address direction follows the same as the Column (Increment or Decrement).[br]\r\n"
"Note for diagonal directions, a Carry results in twice the normal increment/decrement of the Row field.[br]\r\n"
"Incrementing fields start at 0, and Decrementing fields start at 2^(field_block_size)-2^(field_increment)= top of block."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RW", "address_order", "Controls the fastest changing address field, and how that carries into higher order fields.[br]\r\n"
"000 Rank, Bank, Row/Col.[br]\r\n"
"001 Rank, Row/Col, Bank.[br]\r\n"
"010 Bank, Rank, Row/Col.[br]\r\n"
"011 Bank, Row/Col, Rank.[br]\r\n"
"100 Row/Col, Rank, Bank.[br]\r\n"
"101 Row/Col, Bank, Rank.[br]\r\n"
"110 Row/Col  (Used for Offset) Rank and Bank are unchanged.[br]\r\n"
"111 Row-Col (Used for Stripe Offset) No Carry from any field to another.[br]\r\n"
"Carry order between Row and Column is dependent on the Address_Direction field."},
#else
{0, 2, 0x0000000000000000, "RW", "address_order", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo84[] = {{"CPGC2_ADDRESS_INSTRUCTION_2_", "", 0x0000001E, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields85[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set, then this is the last Address Instruction and the test will terminate following full execution of this instruction. If there are no Last bits set in the Address Instruction list, then the test will not stop due to a completion of the test, but will be an Infinite Test."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "address_decode_enable", "Enables rotating XOR of address bits. Used in concert with the Address_Decode_Enable field in the Command_Instruction list.[br]\r\n"
"This bit enables repeating of the current Address_Instruction for Address_Decode_Rotate_Repeats times."},
#else
{6, 6, 0x0000000000000000, "RW", "address_decode_enable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(10) Inv(FastX) - North West[/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(11) Diagonal2 - East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  West [/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"Note that the Bank and Rank Address direction follows the same as the Column (Increment or Decrement).[br]\r\n"
"Note for diagonal directions, a Carry results in twice the normal increment/decrement of the Row field.[br]\r\n"
"Incrementing fields start at 0, and Decrementing fields start at 2^(field_block_size)-2^(field_increment)= top of block."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RW", "address_order", "Controls the fastest changing address field, and how that carries into higher order fields.[br]\r\n"
"000 Rank, Bank, Row/Col.[br]\r\n"
"001 Rank, Row/Col, Bank.[br]\r\n"
"010 Bank, Rank, Row/Col.[br]\r\n"
"011 Bank, Row/Col, Rank.[br]\r\n"
"100 Row/Col, Rank, Bank.[br]\r\n"
"101 Row/Col, Bank, Rank.[br]\r\n"
"110 Row/Col  (Used for Offset) Rank and Bank are unchanged.[br]\r\n"
"111 Row-Col (Used for Stripe Offset) No Carry from any field to another.[br]\r\n"
"Carry order between Row and Column is dependent on the Address_Direction field."},
#else
{0, 2, 0x0000000000000000, "RW", "address_order", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo85[] = {{"CPGC2_ADDRESS_INSTRUCTION_3_", "", 0x0000001F, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields86[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Data_Instruction indication, execution is continued at Data_Instruction[0] if the test does not otherwise terminate. This bit is implied to be set for Data_Instruction[3]."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Globally Invert all data.  Combined with the Algorithm_Instruction Invert_Data field, and the Command_Instruction or Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "data_background", "00 - Solid[br]\r\n"
"01 - Column Stripes[br]\r\n"
"10 - Row Stripes[br]\r\n"
"11 - Checkerboard"},
#else
{4, 5, 0x0000000000000000, "RW", "data_background", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "data_select_rotation_enable", "Enables rotating lane pattern data. Used in concert with the Data_Select_Rotation_Enable field in the Data_Instruction list.[br]\r\n"
"This bit enables repeating of the current Data_Instruction for Data_Select_Rotation_Repeat times.[br]\r\n"
"Data generated using the advanced pattern generation will rotate by one data bit (LSB toward MSB) for each Data_Select_Rotation_Repeat.[br]\r\n"
"For the purpose of this shift, the order follows the Address_Instruction Address_Order and the Algorithm_Instruction[0] Address_Direction."},
#else
{3, 3, 0x0000000000000000, "RW", "data_select_rotation_enable", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo86[] = {{"CPGC2_DATA_INSTRUCTION_0_", "", 0x00000020, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields87[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Data_Instruction indication, execution is continued at Data_Instruction[0] if the test does not otherwise terminate. This bit is implied to be set for Data_Instruction[3]."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Globally Invert all data.  Combined with the Algorithm_Instruction Invert_Data field, and the Command_Instruction or Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "data_background", "00 - Solid[br]\r\n"
"01 - Column Stripes[br]\r\n"
"10 - Row Stripes[br]\r\n"
"11 - Checkerboard"},
#else
{4, 5, 0x0000000000000000, "RW", "data_background", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "data_select_rotation_enable", "Enables rotating lane pattern data. Used in concert with the Data_Select_Rotation_Enable field in the Data_Instruction list.[br]\r\n"
"This bit enables repeating of the current Data_Instruction for Data_Select_Rotation_Repeat times.[br]\r\n"
"Data generated using the advanced pattern generation will rotate by one data bit (LSB toward MSB) for each Data_Select_Rotation_Repeat.[br]\r\n"
"For the purpose of this shift, the order follows the Address_Instruction Address_Order and the Algorithm_Instruction[0] Address_Direction."},
#else
{3, 3, 0x0000000000000000, "RW", "data_select_rotation_enable", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo87[] = {{"CPGC2_DATA_INSTRUCTION_1_", "", 0x00000021, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields88[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Data_Instruction indication, execution is continued at Data_Instruction[0] if the test does not otherwise terminate. This bit is implied to be set for Data_Instruction[3]."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Globally Invert all data.  Combined with the Algorithm_Instruction Invert_Data field, and the Command_Instruction or Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "data_background", "00 - Solid[br]\r\n"
"01 - Column Stripes[br]\r\n"
"10 - Row Stripes[br]\r\n"
"11 - Checkerboard"},
#else
{4, 5, 0x0000000000000000, "RW", "data_background", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "data_select_rotation_enable", "Enables rotating lane pattern data. Used in concert with the Data_Select_Rotation_Enable field in the Data_Instruction list.[br]\r\n"
"This bit enables repeating of the current Data_Instruction for Data_Select_Rotation_Repeat times.[br]\r\n"
"Data generated using the advanced pattern generation will rotate by one data bit (LSB toward MSB) for each Data_Select_Rotation_Repeat.[br]\r\n"
"For the purpose of this shift, the order follows the Address_Instruction Address_Order and the Algorithm_Instruction[0] Address_Direction."},
#else
{3, 3, 0x0000000000000000, "RW", "data_select_rotation_enable", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo88[] = {{"CPGC2_DATA_INSTRUCTION_2_", "", 0x00000022, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields89[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Data_Instruction indication, execution is continued at Data_Instruction[0] if the test does not otherwise terminate. This bit is implied to be set for Data_Instruction[3]."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Globally Invert all data.  Combined with the Algorithm_Instruction Invert_Data field, and the Command_Instruction or Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "data_background", "00 - Solid[br]\r\n"
"01 - Column Stripes[br]\r\n"
"10 - Row Stripes[br]\r\n"
"11 - Checkerboard"},
#else
{4, 5, 0x0000000000000000, "RW", "data_background", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "data_select_rotation_enable", "Enables rotating lane pattern data. Used in concert with the Data_Select_Rotation_Enable field in the Data_Instruction list.[br]\r\n"
"This bit enables repeating of the current Data_Instruction for Data_Select_Rotation_Repeat times.[br]\r\n"
"Data generated using the advanced pattern generation will rotate by one data bit (LSB toward MSB) for each Data_Select_Rotation_Repeat.[br]\r\n"
"For the purpose of this shift, the order follows the Address_Instruction Address_Order and the Algorithm_Instruction[0] Address_Direction."},
#else
{3, 3, 0x0000000000000000, "RW", "data_select_rotation_enable", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo89[] = {{"CPGC2_DATA_INSTRUCTION_3_", "", 0x00000023, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields90[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "data_select_rotation_repeats", "Any Data_Instruction with Data_Select_Rotation_Enable will repeat this many times.  As N-1. (0=1 time)"},
#else
{0, 7, 0x0000000000000000, "RW", "data_select_rotation_repeats", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo90[] = {{"CPGC2_DATA_CONTROL", "", 0x00000024, 1, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields91[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RO/V", "data_select_rotation_repeats_current", "Current state of Data_Select_Rotation_Repeats loop (down count)."},
#else
{16, 23, 0x0000000000000000, "RO/V", "data_select_rotation_repeats_current", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RO/V", "address_decode_rotate_repeats_current", "Current state of Address_Decode_Rotate_Repeats loop (down count)."},
#else
{0, 5, 0x0000000000000000, "RO/V", "address_decode_rotate_repeats_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo91[] = {{"CPGC2_ADDRESS_DATA_STATUS", "", 0x00000028, 2, 0x0000000000FFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields92[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Algorithm instruction, and the memory block is moved at its completion. Execution continues at the first Algorithm_Instruction until the test is complete.  Algorithm_Instruction[7] has this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction Invert_Data field, and the Command_Instruction and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "inverse_direction", "Invert the direction as set in the current Address_Instruction for the duration of this Algorithm_Instruction."},
#else
{5, 5, 0x0000000000000000, "RW", "inverse_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", "Starting Command_Instruction for exection of this Algorithm_Instruction.  The Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until a Command_Instruction contains the Last bit set, and then repeats for each Base_Address, Base_Repeats.[br]\r\n"
"Pointer to which one of the 24 command list to start with."},
#else
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo92[] = {{"CPGC2_ALGORITHM_INSTRUCTION_0_", "", 0x0000002C, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields93[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Algorithm instruction, and the memory block is moved at its completion. Execution continues at the first Algorithm_Instruction until the test is complete.  Algorithm_Instruction[7] has this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction Invert_Data field, and the Command_Instruction and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "inverse_direction", "Invert the direction as set in the current Address_Instruction for the duration of this Algorithm_Instruction."},
#else
{5, 5, 0x0000000000000000, "RW", "inverse_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", "Starting Command_Instruction for exection of this Algorithm_Instruction.  The Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until a Command_Instruction contains the Last bit set, and then repeats for each Base_Address, Base_Repeats.[br]\r\n"
"Pointer to which one of the 24 command list to start with."},
#else
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo93[] = {{"CPGC2_ALGORITHM_INSTRUCTION_1_", "", 0x0000002D, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields94[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Algorithm instruction, and the memory block is moved at its completion. Execution continues at the first Algorithm_Instruction until the test is complete.  Algorithm_Instruction[7] has this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction Invert_Data field, and the Command_Instruction and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "inverse_direction", "Invert the direction as set in the current Address_Instruction for the duration of this Algorithm_Instruction."},
#else
{5, 5, 0x0000000000000000, "RW", "inverse_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", "Starting Command_Instruction for exection of this Algorithm_Instruction.  The Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until a Command_Instruction contains the Last bit set, and then repeats for each Base_Address, Base_Repeats.[br]\r\n"
"Pointer to which one of the 24 command list to start with."},
#else
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo94[] = {{"CPGC2_ALGORITHM_INSTRUCTION_2_", "", 0x0000002E, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields95[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Algorithm instruction, and the memory block is moved at its completion. Execution continues at the first Algorithm_Instruction until the test is complete.  Algorithm_Instruction[7] has this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction Invert_Data field, and the Command_Instruction and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "inverse_direction", "Invert the direction as set in the current Address_Instruction for the duration of this Algorithm_Instruction."},
#else
{5, 5, 0x0000000000000000, "RW", "inverse_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", "Starting Command_Instruction for exection of this Algorithm_Instruction.  The Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until a Command_Instruction contains the Last bit set, and then repeats for each Base_Address, Base_Repeats.[br]\r\n"
"Pointer to which one of the 24 command list to start with."},
#else
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo95[] = {{"CPGC2_ALGORITHM_INSTRUCTION_3_", "", 0x0000002F, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields96[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Algorithm instruction, and the memory block is moved at its completion. Execution continues at the first Algorithm_Instruction until the test is complete.  Algorithm_Instruction[7] has this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction Invert_Data field, and the Command_Instruction and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "inverse_direction", "Invert the direction as set in the current Address_Instruction for the duration of this Algorithm_Instruction."},
#else
{5, 5, 0x0000000000000000, "RW", "inverse_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", "Starting Command_Instruction for exection of this Algorithm_Instruction.  The Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until a Command_Instruction contains the Last bit set, and then repeats for each Base_Address, Base_Repeats.[br]\r\n"
"Pointer to which one of the 24 command list to start with."},
#else
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo96[] = {{"CPGC2_ALGORITHM_INSTRUCTION_4_", "", 0x00000030, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields97[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Algorithm instruction, and the memory block is moved at its completion. Execution continues at the first Algorithm_Instruction until the test is complete.  Algorithm_Instruction[7] has this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction Invert_Data field, and the Command_Instruction and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "inverse_direction", "Invert the direction as set in the current Address_Instruction for the duration of this Algorithm_Instruction."},
#else
{5, 5, 0x0000000000000000, "RW", "inverse_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", "Starting Command_Instruction for exection of this Algorithm_Instruction.  The Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until a Command_Instruction contains the Last bit set, and then repeats for each Base_Address, Base_Repeats.[br]\r\n"
"Pointer to which one of the 24 command list to start with."},
#else
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo97[] = {{"CPGC2_ALGORITHM_INSTRUCTION_5_", "", 0x00000031, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields98[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Algorithm instruction, and the memory block is moved at its completion. Execution continues at the first Algorithm_Instruction until the test is complete.  Algorithm_Instruction[7] has this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction Invert_Data field, and the Command_Instruction and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "inverse_direction", "Invert the direction as set in the current Address_Instruction for the duration of this Algorithm_Instruction."},
#else
{5, 5, 0x0000000000000000, "RW", "inverse_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", "Starting Command_Instruction for exection of this Algorithm_Instruction.  The Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until a Command_Instruction contains the Last bit set, and then repeats for each Base_Address, Base_Repeats.[br]\r\n"
"Pointer to which one of the 24 command list to start with."},
#else
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo98[] = {{"CPGC2_ALGORITHM_INSTRUCTION_6_", "", 0x00000032, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields99[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Algorithm instruction, and the memory block is moved at its completion. Execution continues at the first Algorithm_Instruction until the test is complete.  Algorithm_Instruction[7] has this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Algorithm_Instruction.  Combined with the Data_Instruction Invert_Data field, and the Command_Instruction and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "inverse_direction", "Invert the direction as set in the current Address_Instruction for the duration of this Algorithm_Instruction."},
#else
{5, 5, 0x0000000000000000, "RW", "inverse_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", "Starting Command_Instruction for exection of this Algorithm_Instruction.  The Command_Inxtruction_Current cycles from Command_Start_Pointer, incrementing until a Command_Instruction contains the Last bit set, and then repeats for each Base_Address, Base_Repeats.[br]\r\n"
"Pointer to which one of the 24 command list to start with."},
#else
{0, 4, 0x0000000000000000, "RW", "command_start_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo99[] = {{"CPGC2_ALGORITHM_INSTRUCTION_7_", "", 0x00000033, 4, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields100[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", "Enable the BE Training Error Detection feature for individual Algorithm Instructions. This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL."},
#else
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "select_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during chip select cycles."},
#else
{6, 6, 0x0000000000000000, "RW", "select_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "deselect_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during non Chip Select cycles."},
#else
{5, 5, 0x0000000000000000, "RW", "deselect_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "wait_event_start", "Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction until the Event indicated by Select_Event has been acknowledged to have occurred.[br]\r\n"
"The Select_Event is acknowledged to be in progress.[br]\r\n"
"The latency between the event and the acknowledgement must be a known fixed value (preventing a hang situation).[br]\r\n"
"The Current_Repeat_Value is reset tzero."},
#else
{4, 4, 0x0000000000000000, "RW", "wait_event_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "wait_count_start", "Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm should start. [br]\r\n"
"Wait_Time is commonly used for Pause Refresh test where the read to a particular address needs to be a specific time away from when the write to an address occurs.[br]\r\n"
"If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]\r\n"
"If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled until the Wait_Time_Current is equal to the Wait_Time.[br]\r\n"
"Wait_Time_Current represent the current count value from when it was last reset either by a Test starting or Wait_Count_Clear.[br]\r\n"
"Wait_Time_Current is a free running counter that accurately reflects the time from when it was last reset by using the following formula.[br]\r\n"
"Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]\r\n"
"If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction, Wait_Time_Current is reset tzero.[br]\r\n"
"Wait_Time_Current is frozen if a Test encounters any stop condition.[br]\r\n"
"Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]\r\n"
"Wait_Time_Current rolls over at the maximum value back tzero.[br]\r\n"
"Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value. The possible frequencies that can be selected are the following.[br]\r\n"
"Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]\r\n"
"Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]\r\n"
"Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]\r\n"
"Wait_Clock_Frequence = 11 = DUNIT clock."},
#else
{3, 3, 0x0000000000000000, "RW", "wait_count_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", "Reset the Wait Timer at the start of this Algorithm Instruction."},
#else
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "base_range_row", "Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the size of the block for this instruction as the size of the block. This may be used for a rapid short test hitting all banks to open pages etc, or to initialize a row worth of data."},
#else
{1, 1, 0x0000000000000000, "RW", "base_range_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "fasty_init", "FastY_Init is used to allow a background write initialization type algorithm to use FastY with Columns as the LSB address field to ensure the fastest initialization possible.[br]\r\n"
"^(wD1) is a the most typical background Init function.[br]\r\n"
"MEMTEL uses the keyword INIT() to reference this feature.[br]\r\n"
"FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction and Address_Order.[br]\r\n"
"If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank, Bank, Row/Col), else use the settings defined in the current Address_Instruction."},
#else
{0, 0, 0x0000000000000000, "RW", "fasty_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo100[] = {{"CPGC2_ALGORITHM_INSTRUCTION_CTRL_0_", "", 0x00000034, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields101[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", "Enable the BE Training Error Detection feature for individual Algorithm Instructions. This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL."},
#else
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "select_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during chip select cycles."},
#else
{6, 6, 0x0000000000000000, "RW", "select_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "deselect_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during non Chip Select cycles."},
#else
{5, 5, 0x0000000000000000, "RW", "deselect_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "wait_event_start", "Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction until the Event indicated by Select_Event has been acknowledged to have occurred.[br]\r\n"
"The Select_Event is acknowledged to be in progress.[br]\r\n"
"The latency between the event and the acknowledgement must be a known fixed value (preventing a hang situation).[br]\r\n"
"The Current_Repeat_Value is reset tzero."},
#else
{4, 4, 0x0000000000000000, "RW", "wait_event_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "wait_count_start", "Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm should start. [br]\r\n"
"Wait_Time is commonly used for Pause Refresh test where the read to a particular address needs to be a specific time away from when the write to an address occurs.[br]\r\n"
"If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]\r\n"
"If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled until the Wait_Time_Current is equal to the Wait_Time.[br]\r\n"
"Wait_Time_Current represent the current count value from when it was last reset either by a Test starting or Wait_Count_Clear.[br]\r\n"
"Wait_Time_Current is a free running counter that accurately reflects the time from when it was last reset by using the following formula.[br]\r\n"
"Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]\r\n"
"If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction, Wait_Time_Current is reset tzero.[br]\r\n"
"Wait_Time_Current is frozen if a Test encounters any stop condition.[br]\r\n"
"Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]\r\n"
"Wait_Time_Current rolls over at the maximum value back tzero.[br]\r\n"
"Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value. The possible frequencies that can be selected are the following.[br]\r\n"
"Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]\r\n"
"Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]\r\n"
"Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]\r\n"
"Wait_Clock_Frequence = 11 = DUNIT clock."},
#else
{3, 3, 0x0000000000000000, "RW", "wait_count_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", "Reset the Wait Timer at the start of this Algorithm Instruction."},
#else
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "base_range_row", "Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the size of the block for this instruction as the size of the block. This may be used for a rapid short test hitting all banks to open pages etc, or to initialize a row worth of data."},
#else
{1, 1, 0x0000000000000000, "RW", "base_range_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "fasty_init", "FastY_Init is used to allow a background write initialization type algorithm to use FastY with Columns as the LSB address field to ensure the fastest initialization possible.[br]\r\n"
"^(wD1) is a the most typical background Init function.[br]\r\n"
"MEMTEL uses the keyword INIT() to reference this feature.[br]\r\n"
"FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction and Address_Order.[br]\r\n"
"If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank, Bank, Row/Col), else use the settings defined in the current Address_Instruction."},
#else
{0, 0, 0x0000000000000000, "RW", "fasty_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo101[] = {{"CPGC2_ALGORITHM_INSTRUCTION_CTRL_1_", "", 0x00000035, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields102[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", "Enable the BE Training Error Detection feature for individual Algorithm Instructions. This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL."},
#else
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "select_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during chip select cycles."},
#else
{6, 6, 0x0000000000000000, "RW", "select_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "deselect_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during non Chip Select cycles."},
#else
{5, 5, 0x0000000000000000, "RW", "deselect_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "wait_event_start", "Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction until the Event indicated by Select_Event has been acknowledged to have occurred.[br]\r\n"
"The Select_Event is acknowledged to be in progress.[br]\r\n"
"The latency between the event and the acknowledgement must be a known fixed value (preventing a hang situation).[br]\r\n"
"The Current_Repeat_Value is reset tzero."},
#else
{4, 4, 0x0000000000000000, "RW", "wait_event_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "wait_count_start", "Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm should start. [br]\r\n"
"Wait_Time is commonly used for Pause Refresh test where the read to a particular address needs to be a specific time away from when the write to an address occurs.[br]\r\n"
"If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]\r\n"
"If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled until the Wait_Time_Current is equal to the Wait_Time.[br]\r\n"
"Wait_Time_Current represent the current count value from when it was last reset either by a Test starting or Wait_Count_Clear.[br]\r\n"
"Wait_Time_Current is a free running counter that accurately reflects the time from when it was last reset by using the following formula.[br]\r\n"
"Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]\r\n"
"If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction, Wait_Time_Current is reset tzero.[br]\r\n"
"Wait_Time_Current is frozen if a Test encounters any stop condition.[br]\r\n"
"Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]\r\n"
"Wait_Time_Current rolls over at the maximum value back tzero.[br]\r\n"
"Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value. The possible frequencies that can be selected are the following.[br]\r\n"
"Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]\r\n"
"Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]\r\n"
"Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]\r\n"
"Wait_Clock_Frequence = 11 = DUNIT clock."},
#else
{3, 3, 0x0000000000000000, "RW", "wait_count_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", "Reset the Wait Timer at the start of this Algorithm Instruction."},
#else
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "base_range_row", "Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the size of the block for this instruction as the size of the block. This may be used for a rapid short test hitting all banks to open pages etc, or to initialize a row worth of data."},
#else
{1, 1, 0x0000000000000000, "RW", "base_range_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "fasty_init", "FastY_Init is used to allow a background write initialization type algorithm to use FastY with Columns as the LSB address field to ensure the fastest initialization possible.[br]\r\n"
"^(wD1) is a the most typical background Init function.[br]\r\n"
"MEMTEL uses the keyword INIT() to reference this feature.[br]\r\n"
"FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction and Address_Order.[br]\r\n"
"If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank, Bank, Row/Col), else use the settings defined in the current Address_Instruction."},
#else
{0, 0, 0x0000000000000000, "RW", "fasty_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo102[] = {{"CPGC2_ALGORITHM_INSTRUCTION_CTRL_2_", "", 0x00000036, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields103[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", "Enable the BE Training Error Detection feature for individual Algorithm Instructions. This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL."},
#else
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "select_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during chip select cycles."},
#else
{6, 6, 0x0000000000000000, "RW", "select_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "deselect_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during non Chip Select cycles."},
#else
{5, 5, 0x0000000000000000, "RW", "deselect_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "wait_event_start", "Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction until the Event indicated by Select_Event has been acknowledged to have occurred.[br]\r\n"
"The Select_Event is acknowledged to be in progress.[br]\r\n"
"The latency between the event and the acknowledgement must be a known fixed value (preventing a hang situation).[br]\r\n"
"The Current_Repeat_Value is reset tzero."},
#else
{4, 4, 0x0000000000000000, "RW", "wait_event_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "wait_count_start", "Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm should start. [br]\r\n"
"Wait_Time is commonly used for Pause Refresh test where the read to a particular address needs to be a specific time away from when the write to an address occurs.[br]\r\n"
"If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]\r\n"
"If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled until the Wait_Time_Current is equal to the Wait_Time.[br]\r\n"
"Wait_Time_Current represent the current count value from when it was last reset either by a Test starting or Wait_Count_Clear.[br]\r\n"
"Wait_Time_Current is a free running counter that accurately reflects the time from when it was last reset by using the following formula.[br]\r\n"
"Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]\r\n"
"If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction, Wait_Time_Current is reset tzero.[br]\r\n"
"Wait_Time_Current is frozen if a Test encounters any stop condition.[br]\r\n"
"Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]\r\n"
"Wait_Time_Current rolls over at the maximum value back tzero.[br]\r\n"
"Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value. The possible frequencies that can be selected are the following.[br]\r\n"
"Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]\r\n"
"Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]\r\n"
"Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]\r\n"
"Wait_Clock_Frequence = 11 = DUNIT clock."},
#else
{3, 3, 0x0000000000000000, "RW", "wait_count_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", "Reset the Wait Timer at the start of this Algorithm Instruction."},
#else
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "base_range_row", "Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the size of the block for this instruction as the size of the block. This may be used for a rapid short test hitting all banks to open pages etc, or to initialize a row worth of data."},
#else
{1, 1, 0x0000000000000000, "RW", "base_range_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "fasty_init", "FastY_Init is used to allow a background write initialization type algorithm to use FastY with Columns as the LSB address field to ensure the fastest initialization possible.[br]\r\n"
"^(wD1) is a the most typical background Init function.[br]\r\n"
"MEMTEL uses the keyword INIT() to reference this feature.[br]\r\n"
"FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction and Address_Order.[br]\r\n"
"If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank, Bank, Row/Col), else use the settings defined in the current Address_Instruction."},
#else
{0, 0, 0x0000000000000000, "RW", "fasty_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo103[] = {{"CPGC2_ALGORITHM_INSTRUCTION_CTRL_3_", "", 0x00000037, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields104[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", "Enable the BE Training Error Detection feature for individual Algorithm Instructions. This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL."},
#else
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "select_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during chip select cycles."},
#else
{6, 6, 0x0000000000000000, "RW", "select_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "deselect_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during non Chip Select cycles."},
#else
{5, 5, 0x0000000000000000, "RW", "deselect_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "wait_event_start", "Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction until the Event indicated by Select_Event has been acknowledged to have occurred.[br]\r\n"
"The Select_Event is acknowledged to be in progress.[br]\r\n"
"The latency between the event and the acknowledgement must be a known fixed value (preventing a hang situation).[br]\r\n"
"The Current_Repeat_Value is reset tzero."},
#else
{4, 4, 0x0000000000000000, "RW", "wait_event_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "wait_count_start", "Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm should start. [br]\r\n"
"Wait_Time is commonly used for Pause Refresh test where the read to a particular address needs to be a specific time away from when the write to an address occurs.[br]\r\n"
"If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]\r\n"
"If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled until the Wait_Time_Current is equal to the Wait_Time.[br]\r\n"
"Wait_Time_Current represent the current count value from when it was last reset either by a Test starting or Wait_Count_Clear.[br]\r\n"
"Wait_Time_Current is a free running counter that accurately reflects the time from when it was last reset by using the following formula.[br]\r\n"
"Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]\r\n"
"If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction, Wait_Time_Current is reset tzero.[br]\r\n"
"Wait_Time_Current is frozen if a Test encounters any stop condition.[br]\r\n"
"Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]\r\n"
"Wait_Time_Current rolls over at the maximum value back tzero.[br]\r\n"
"Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value. The possible frequencies that can be selected are the following.[br]\r\n"
"Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]\r\n"
"Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]\r\n"
"Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]\r\n"
"Wait_Clock_Frequence = 11 = DUNIT clock."},
#else
{3, 3, 0x0000000000000000, "RW", "wait_count_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", "Reset the Wait Timer at the start of this Algorithm Instruction."},
#else
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "base_range_row", "Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the size of the block for this instruction as the size of the block. This may be used for a rapid short test hitting all banks to open pages etc, or to initialize a row worth of data."},
#else
{1, 1, 0x0000000000000000, "RW", "base_range_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "fasty_init", "FastY_Init is used to allow a background write initialization type algorithm to use FastY with Columns as the LSB address field to ensure the fastest initialization possible.[br]\r\n"
"^(wD1) is a the most typical background Init function.[br]\r\n"
"MEMTEL uses the keyword INIT() to reference this feature.[br]\r\n"
"FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction and Address_Order.[br]\r\n"
"If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank, Bank, Row/Col), else use the settings defined in the current Address_Instruction."},
#else
{0, 0, 0x0000000000000000, "RW", "fasty_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo104[] = {{"CPGC2_ALGORITHM_INSTRUCTION_CTRL_4_", "", 0x00000038, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields105[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", "Enable the BE Training Error Detection feature for individual Algorithm Instructions. This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL."},
#else
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "select_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during chip select cycles."},
#else
{6, 6, 0x0000000000000000, "RW", "select_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "deselect_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during non Chip Select cycles."},
#else
{5, 5, 0x0000000000000000, "RW", "deselect_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "wait_event_start", "Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction until the Event indicated by Select_Event has been acknowledged to have occurred.[br]\r\n"
"The Select_Event is acknowledged to be in progress.[br]\r\n"
"The latency between the event and the acknowledgement must be a known fixed value (preventing a hang situation).[br]\r\n"
"The Current_Repeat_Value is reset tzero."},
#else
{4, 4, 0x0000000000000000, "RW", "wait_event_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "wait_count_start", "Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm should start. [br]\r\n"
"Wait_Time is commonly used for Pause Refresh test where the read to a particular address needs to be a specific time away from when the write to an address occurs.[br]\r\n"
"If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]\r\n"
"If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled until the Wait_Time_Current is equal to the Wait_Time.[br]\r\n"
"Wait_Time_Current represent the current count value from when it was last reset either by a Test starting or Wait_Count_Clear.[br]\r\n"
"Wait_Time_Current is a free running counter that accurately reflects the time from when it was last reset by using the following formula.[br]\r\n"
"Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]\r\n"
"If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction, Wait_Time_Current is reset tzero.[br]\r\n"
"Wait_Time_Current is frozen if a Test encounters any stop condition.[br]\r\n"
"Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]\r\n"
"Wait_Time_Current rolls over at the maximum value back tzero.[br]\r\n"
"Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value. The possible frequencies that can be selected are the following.[br]\r\n"
"Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]\r\n"
"Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]\r\n"
"Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]\r\n"
"Wait_Clock_Frequence = 11 = DUNIT clock."},
#else
{3, 3, 0x0000000000000000, "RW", "wait_count_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", "Reset the Wait Timer at the start of this Algorithm Instruction."},
#else
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "base_range_row", "Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the size of the block for this instruction as the size of the block. This may be used for a rapid short test hitting all banks to open pages etc, or to initialize a row worth of data."},
#else
{1, 1, 0x0000000000000000, "RW", "base_range_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "fasty_init", "FastY_Init is used to allow a background write initialization type algorithm to use FastY with Columns as the LSB address field to ensure the fastest initialization possible.[br]\r\n"
"^(wD1) is a the most typical background Init function.[br]\r\n"
"MEMTEL uses the keyword INIT() to reference this feature.[br]\r\n"
"FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction and Address_Order.[br]\r\n"
"If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank, Bank, Row/Col), else use the settings defined in the current Address_Instruction."},
#else
{0, 0, 0x0000000000000000, "RW", "fasty_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo105[] = {{"CPGC2_ALGORITHM_INSTRUCTION_CTRL_5_", "", 0x00000039, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields106[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", "Enable the BE Training Error Detection feature for individual Algorithm Instructions. This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL."},
#else
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "select_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during chip select cycles."},
#else
{6, 6, 0x0000000000000000, "RW", "select_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "deselect_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during non Chip Select cycles."},
#else
{5, 5, 0x0000000000000000, "RW", "deselect_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "wait_event_start", "Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction until the Event indicated by Select_Event has been acknowledged to have occurred.[br]\r\n"
"The Select_Event is acknowledged to be in progress.[br]\r\n"
"The latency between the event and the acknowledgement must be a known fixed value (preventing a hang situation).[br]\r\n"
"The Current_Repeat_Value is reset tzero."},
#else
{4, 4, 0x0000000000000000, "RW", "wait_event_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "wait_count_start", "Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm should start. [br]\r\n"
"Wait_Time is commonly used for Pause Refresh test where the read to a particular address needs to be a specific time away from when the write to an address occurs.[br]\r\n"
"If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]\r\n"
"If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled until the Wait_Time_Current is equal to the Wait_Time.[br]\r\n"
"Wait_Time_Current represent the current count value from when it was last reset either by a Test starting or Wait_Count_Clear.[br]\r\n"
"Wait_Time_Current is a free running counter that accurately reflects the time from when it was last reset by using the following formula.[br]\r\n"
"Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]\r\n"
"If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction, Wait_Time_Current is reset tzero.[br]\r\n"
"Wait_Time_Current is frozen if a Test encounters any stop condition.[br]\r\n"
"Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]\r\n"
"Wait_Time_Current rolls over at the maximum value back tzero.[br]\r\n"
"Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value. The possible frequencies that can be selected are the following.[br]\r\n"
"Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]\r\n"
"Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]\r\n"
"Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]\r\n"
"Wait_Clock_Frequence = 11 = DUNIT clock."},
#else
{3, 3, 0x0000000000000000, "RW", "wait_count_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", "Reset the Wait Timer at the start of this Algorithm Instruction."},
#else
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "base_range_row", "Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the size of the block for this instruction as the size of the block. This may be used for a rapid short test hitting all banks to open pages etc, or to initialize a row worth of data."},
#else
{1, 1, 0x0000000000000000, "RW", "base_range_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "fasty_init", "FastY_Init is used to allow a background write initialization type algorithm to use FastY with Columns as the LSB address field to ensure the fastest initialization possible.[br]\r\n"
"^(wD1) is a the most typical background Init function.[br]\r\n"
"MEMTEL uses the keyword INIT() to reference this feature.[br]\r\n"
"FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction and Address_Order.[br]\r\n"
"If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank, Bank, Row/Col), else use the settings defined in the current Address_Instruction."},
#else
{0, 0, 0x0000000000000000, "RW", "fasty_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo106[] = {{"CPGC2_ALGORITHM_INSTRUCTION_CTRL_6_", "", 0x0000003A, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields107[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", "Enable the BE Training Error Detection feature for individual Algorithm Instructions. This bit is inactive unless the BE_TRAIN_ERR_ENABLE bit is set in CPGC_ERR_CTL."},
#else
{7, 7, 0x0000000000000000, "RW", "be_train_err_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "select_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during chip select cycles."},
#else
{6, 6, 0x0000000000000000, "RW", "select_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "deselect_on", "If set, the CADB will be able to issue harassment patterns into the command and address bus during non Chip Select cycles."},
#else
{5, 5, 0x0000000000000000, "RW", "deselect_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "wait_event_start", "Wait_Event_Start causes the delay in beginning the current Algorithm_Instruction until the Event indicated by Select_Event has been acknowledged to have occurred.[br]\r\n"
"The Select_Event is acknowledged to be in progress.[br]\r\n"
"The latency between the event and the acknowledgement must be a known fixed value (preventing a hang situation).[br]\r\n"
"The Current_Repeat_Value is reset tzero."},
#else
{4, 4, 0x0000000000000000, "RW", "wait_event_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "wait_count_start", "Wait_Count_Start and Wait_Time are used to synchronize a specific time an Algorithm should start. [br]\r\n"
"Wait_Time is commonly used for Pause Refresh test where the read to a particular address needs to be a specific time away from when the write to an address occurs.[br]\r\n"
"If Wait_Count_Start = 0 then the start of the Algorithm_Instruction is not stalled.[br]\r\n"
"If Wait_Count_Start = 1 then the start of the Algorithm_Instruction is stalled until the Wait_Time_Current is equal to the Wait_Time.[br]\r\n"
"Wait_Time_Current represent the current count value from when it was last reset either by a Test starting or Wait_Count_Clear.[br]\r\n"
"Wait_Time_Current is a free running counter that accurately reflects the time from when it was last reset by using the following formula.[br]\r\n"
"Time elapsed = Wait_Timer_Current * (1/(frequency selected by Count_Value_Frequency).[br]\r\n"
"If Wait_Count_Clear = 1 then prior to starting the current Algorithm_Instruction, Wait_Time_Current is reset tzero.[br]\r\n"
"Wait_Time_Current is frozen if a Test encounters any stop condition.[br]\r\n"
"Wait_Time_Current is reset to zer0 when a test starts (Start_Test is asserted).[br]\r\n"
"Wait_Time_Current rolls over at the maximum value back tzero.[br]\r\n"
"Wait_Clock_Frequency(1:0) set the frequency that increment Current_Repeat_Value. The possible frequencies that can be selected are the following.[br]\r\n"
"Wait_Clock_Frequency = 00 = 1GHz (time = 1ns).[br]\r\n"
"Wait_Clock_Frequency = 01 = 1MHZ (time = 1us).[br]\r\n"
"Wait_Clock_Frequency = 10 = 1KHZ (time = 1ms).[br]\r\n"
"Wait_Clock_Frequence = 11 = DUNIT clock."},
#else
{3, 3, 0x0000000000000000, "RW", "wait_count_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", "Reset the Wait Timer at the start of this Algorithm Instruction."},
#else
{2, 2, 0x0000000000000000, "RW", "wait_count_clear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "base_range_row", "Instead of using the Base_Repeats setting, use Base_Col_Repeats setting for the size of the block for this instruction as the size of the block. This may be used for a rapid short test hitting all banks to open pages etc, or to initialize a row worth of data."},
#else
{1, 1, 0x0000000000000000, "RW", "base_range_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "fasty_init", "FastY_Init is used to allow a background write initialization type algorithm to use FastY with Columns as the LSB address field to ensure the fastest initialization possible.[br]\r\n"
"^(wD1) is a the most typical background Init function.[br]\r\n"
"MEMTEL uses the keyword INIT() to reference this feature.[br]\r\n"
"FastY_Init enables the current Algortihm_Instruction to override the current Address_Instruction[].Address_Direction and Address_Order.[br]\r\n"
"If set, then use the Address_Direction=000 (FastY) and Address_Order=000 (Rank, Bank, Row/Col), else use the settings defined in the current Address_Instruction."},
#else
{0, 0, 0x0000000000000000, "RW", "fasty_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo107[] = {{"CPGC2_ALGORITHM_INSTRUCTION_CTRL_7_", "", 0x0000003B, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields108[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW/1C/V", "wait_timer_current", "Current wait timer value. See Wait_Time description. (down count)"},
#else
{0, 15, 0x0000000000000000, "RW/1C/V", "wait_timer_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo108[] = {{"CPGC2_ALGORITHM_WAIT_COUNT_CURRENT", "", 0x0000003C, 1, 0x000000000000FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields109[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RW", "select_event", "Select_Event is decoded in the following ways.[br]\r\n"
"Select_Event = 00 = Read/Write Pending CAS cue is empty[br]\r\n"
"Select_Event = 01 = CKE Power Down[br]\r\n"
"Select_Event = 10 = Refresh[br]\r\n"
"Select_Event = 11 = Self Refresh"},
#else
{30, 31, 0x0000000000000000, "RW", "select_event", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "wait_clock_frequency", "00 - 1GHz[br]\r\n"
"01 - 1MHz[br]\r\n"
"10 - 1KHz[br]\r\n"
"11 - Native DUNIT clock"},
#else
{24, 25, 0x0000000000000000, "RW", "wait_clock_frequency", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "timer", "Exponential timer (timer value calculated as 2^Timer).  If WaitEventStart is set in the currently executing Algorithm Instruction, this timer dynamically replaces the current Wait_Time counter following the Select_Event occurring (such as SelfRefresh or PowerDown) , to add a fixed delay for the Select_Event condition to remain before CPGC activity resumes."},
#else
{20, 23, 0x0000000000000000, "RW", "timer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW", "wait_time", "Number of clocks at Wait_Clock_Frequency to wait before starting current Algorithm_Instruction if Wait_Start = 1."},
#else
{0, 15, 0x0000000000000000, "RW", "wait_time", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo109[] = {{"CPGC2_ALGORITHM_WAIT_EVENT_CONTROL", "", 0x00000040, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields110[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "base_repeats", "Base Address Loopcount - Typically the number of Base Addresses within the Block (Row*Col*Bank*Rank) As N-1 value.[br]\r\n"
"This is the number of times the current Algorithm Instruction will be executed."},
#else
{0, 31, 0x0000000000000000, "RW", "base_repeats", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo110[] = {{"CPGC2_BASE_REPEATS", "", 0x00000044, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields111[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "base_repeats_current", "Current remaining Base Address loops (down count)."},
#else
{0, 31, 0x0000000000000000, "RO/V", "base_repeats_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo111[] = {{"CPGC2_BASE_REPEATS_CURRENT", "", 0x00000048, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields112[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "base_col_repeats", "Alternate Base_Address_Loopcount. Often used to initialze a Row or Column worth of data. [br]\r\n"
"This is used when Base_Range_Row field of ALGORITHM_INSTRUCTION_CTL is activated.[br]\r\n"
"This is the number of times the current Algorithm Instruction will be executed."},
#else
{0, 31, 0x0000000000000000, "RW", "base_col_repeats", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo112[] = {{"CPGC2_BASE_COL_REPEATS", "", 0x0000004C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields113[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "block_repeats", "Block Loopcount. Typically the number of Blocks to be tested to traverse the entire Tested Region. (2^region_size/2^block_size -1) As N-1 value.[br]\r\n"
"This is the number of times the entire list of Algorithm Instructions will be executed."},
#else
{0, 31, 0x0000000000000000, "RW", "block_repeats", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo113[] = {{"CPGC2_BLOCK_REPEATS", "", 0x00000050, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields114[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "block_repeats_current", "Current Block Loopcount (down count)."},
#else
{0, 31, 0x0000000000000000, "RO/V", "block_repeats_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo114[] = {{"CPGC2_BLOCK_REPEATS_CURRENT", "", 0x00000054, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields115[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo115[] = {{"CPGC2_COMMAND_INSTRUCTION_0_", "", 0x00000058, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields116[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo116[] = {{"CPGC2_COMMAND_INSTRUCTION_1_", "", 0x00000059, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields117[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo117[] = {{"CPGC2_COMMAND_INSTRUCTION_2_", "", 0x0000005A, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields118[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo118[] = {{"CPGC2_COMMAND_INSTRUCTION_3_", "", 0x0000005B, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields119[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo119[] = {{"CPGC2_COMMAND_INSTRUCTION_4_", "", 0x0000005C, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields120[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo120[] = {{"CPGC2_COMMAND_INSTRUCTION_5_", "", 0x0000005D, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields121[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo121[] = {{"CPGC2_COMMAND_INSTRUCTION_6_", "", 0x0000005E, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields122[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo122[] = {{"CPGC2_COMMAND_INSTRUCTION_7_", "", 0x0000005F, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields123[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo123[] = {{"CPGC2_COMMAND_INSTRUCTION_8_", "", 0x00000060, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields124[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo124[] = {{"CPGC2_COMMAND_INSTRUCTION_9_", "", 0x00000061, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields125[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo125[] = {{"CPGC2_COMMAND_INSTRUCTION_10_", "", 0x00000062, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields126[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo126[] = {{"CPGC2_COMMAND_INSTRUCTION_11_", "", 0x00000063, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields127[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo127[] = {{"CPGC2_COMMAND_INSTRUCTION_12_", "", 0x00000064, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields128[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo128[] = {{"CPGC2_COMMAND_INSTRUCTION_13_", "", 0x00000065, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields129[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo129[] = {{"CPGC2_COMMAND_INSTRUCTION_14_", "", 0x00000066, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields130[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo130[] = {{"CPGC2_COMMAND_INSTRUCTION_15_", "", 0x00000067, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields131[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo131[] = {{"CPGC2_COMMAND_INSTRUCTION_16_", "", 0x00000068, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields132[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo132[] = {{"CPGC2_COMMAND_INSTRUCTION_17_", "", 0x00000069, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields133[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo133[] = {{"CPGC2_COMMAND_INSTRUCTION_18_", "", 0x0000006A, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields134[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo134[] = {{"CPGC2_COMMAND_INSTRUCTION_19_", "", 0x0000006B, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields135[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo135[] = {{"CPGC2_COMMAND_INSTRUCTION_20_", "", 0x0000006C, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields136[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo136[] = {{"CPGC2_COMMAND_INSTRUCTION_21_", "", 0x0000006D, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields137[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo137[] = {{"CPGC2_COMMAND_INSTRUCTION_22_", "", 0x0000006E, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields138[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "If set this is the last Command Instruction for this Algorithm Command Sequence.Command_Instruction[23] has this bit set implicitly.[br]\r\n"
"Execution continues at the Command_Instruction pointed to by the Algorithm_Instruction's Command_Start_Pointer until the end of the Algorithm_Instruction."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert the data used for this command. This is combined with the Algorithm_Instruction and Data_Instruction Invert_Data bits for Base accesses. For Offset accesses, it is further combined with the Offset_Command Invert_Data bit."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", "Enable rotating XOR of address bits or PRBS address generation. If the Address_Decode_Enable field in the Address_Instruction list is active, and [name] is also active, then for the access of this Command_Instruction, the address will be XOR with the XOR_Address_Pattern.[br]\r\n"
"If the Address_Decode_Enable field in the Address_Instruction list is inactive (0), and the Address_PRBS_Enable bit in the Address_PRBS_Control register is set, then the desired address bits will be replaced with the PRBS generated value."},
#else
{5, 5, 0x0000000000000000, "RW", "address_decode_or_prbs_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Base command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "If set, this is an Offset operation, and the selected Offset_Group will be executed in its place. In this case the Write, Hammer, and Alternate_Data fields are ignored."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "offset_group", "Selects which Offset_Group will be used if Offset field is set."},
#else
{1, 1, 0x0000000000000000, "RW", "offset_group", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Base Write operation will be performed."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo138[] = {{"CPGC2_COMMAND_INSTRUCTION_23_", "", 0x0000006F, 8, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields139[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "hammer_repeats", "Hammer_Repeats is the number of times any command is repeated at the same address when the Hammer control bit is set in the Command_Instruction (if not an offset command)."},
#else
{0, 31, 0x0000000000000000, "RW", "hammer_repeats", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo139[] = {{"CPGC2_HAMMER_REPEATS", "", 0x00000070, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields140[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "hammer_repeats_current", "Current Hammer Loopcount (down count)."},
#else
{0, 31, 0x0000000000000000, "RO/V", "hammer_repeats_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo140[] = {{"CPGC2_HAMMER_REPEATS_CURRENT", "", 0x00000074, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields141[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo141[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_0_", "", 0x00000078, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields142[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo142[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_1_", "", 0x00000079, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields143[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo143[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_2_", "", 0x0000007A, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields144[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo144[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_3_", "", 0x0000007B, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields145[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo145[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_4_", "", 0x0000007C, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields146[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo146[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_5_", "", 0x0000007D, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields147[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo147[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_6_", "", 0x0000007E, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields148[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo148[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_7_", "", 0x0000007F, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields149[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo149[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_8_", "", 0x00000080, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields150[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo150[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_9_", "", 0x00000081, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields151[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo151[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_10_", "", 0x00000082, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields152[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo152[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_11_", "", 0x00000083, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields153[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo153[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_12_", "", 0x00000084, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields154[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo154[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_13_", "", 0x00000085, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields155[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo155[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_14_", "", 0x00000086, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields156[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Address_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[7] and Offset_Address_Instruction[15] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "stripe", "Normal Offsets use Address_Order=110.[br]\r\n"
"This allows full traversal of the entire Block by and offset.[br]\r\n"
"If Stripe is active, then there is no carry between Row and Column. This will keep the offset address within the same Row, or the same Column or on the same diagonal."},
#else
{6, 6, 0x0000000000000000, "RW", "stripe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "address_direction", "[b]Address_Direction[/b][br]\r\n"
"There are 4 basic address directions and their inverse for a total of 8.[br]\r\n"
"We will denote this as a combination of a 1-bit field and a 2-bit field.[br]\r\n"
"[b](0)(00)  FastY -North[/b][br]\r\n"
" Increment Column and Carry Increment into Row.[br]\r\n"
"[b](1)(00) Inv(FastY) - South[/b][br]\r\n"
" Decrement Column and Carry Decrement into Row.[br]\r\n"
"[b](0)(01) Diagonal  North East[/b][br]\r\n"
" Increment Row and Column together and Carry Increment Column into Row.[br]\r\n"
"[b](1)(01) Inv(Diagonal)  South West[/b][br]\r\n"
" Decrement Row and Column together and Carry Decrement Column into Row.[br]\r\n"
"[b](0)(10) FastX  East[/b][br]\r\n"
" Increment Row and Carry Increment into Column.[br]\r\n"
"[b](1)(10) Inv(FastX) - West[/b][br]\r\n"
" Decrement Row and Carry Decrement into Column.[br]\r\n"
"[b](0)(11) Diagonal2 - South East[/b][br]\r\n"
" Decrement Column and Increment Row and Carry Increment Column into Row.[br]\r\n"
"[b](1)(11) Inv(Diagonal2)  North West [/b][br]\r\n"
" Increment Column and Decrement Row and Carry Decrement Column into Row.[br]\r\n"
"\r\n"
"Offset accesses begin one 'step' in the given direction from the current Base_Address."},
#else
{3, 5, 0x0000000000000000, "RW", "address_direction", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", "Enabled periodic data inversion - based on Address_Direction (OrderX field) -normally invert every 2^Block_Size_Bits_Row/Col, modified based on Periodic_Data_Inversion_Adjustment."},
#else
{2, 2, 0x0000000000000000, "RW", "periodic_data_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", "Reduce or increase the inversion interval by -1,0,1 based on the value in this field.[br]00 - no adjust[br]01 - interval is increased by 1[br]11 - interval is decreased by 1[br]10 - reserved"},
#else
{0, 1, 0x0000000000000000, "RW", "periodic_data_inv_adj", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo156[] = {{"CPGC2_OFFSET_ADDRESS_INSTRUCTION_15_", "", 0x00000087, 5, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields157[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo157[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_0_", "", 0x00000088, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields158[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo158[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_1_", "", 0x00000089, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields159[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo159[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_2_", "", 0x0000008A, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields160[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo160[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_3_", "", 0x0000008B, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields161[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo161[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_4_", "", 0x0000008C, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields162[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo162[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_5_", "", 0x0000008D, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields163[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo163[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_6_", "", 0x0000008E, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields164[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo164[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_7_", "", 0x0000008F, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields165[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo165[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_8_", "", 0x00000090, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields166[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo166[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_9_", "", 0x00000091, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields167[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo167[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_10_", "", 0x00000092, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields168[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "last", "Last Offset_Command_Instruction. The offset instruction is complete after all Offset_Address, Offset_Repeats, and Offset_Commands have finished.[br]\r\n"
"Offset_Address_Instruction[5] and Offset_Address_Instruction[11] have this bit set implicitly."},
#else
{7, 7, 0x0000000000000000, "RW", "last", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "invert_data", "Invert all data for this Offset_Command_Instruction.  Combine the Data_Instruction Invert_Data field, the Algorithm_Instruction  Invert_Data field, Command_Instruction Invert_Data field and Offset_Command_Instruction Invert_Data field to determine the final data polarity."},
#else
{6, 6, 0x0000000000000000, "RW", "invert_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "alternate_data", "Use the alternate zero data source instead of the UniSequencers and Pattern_Select."},
#else
{4, 4, 0x0000000000000000, "RW", "alternate_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "hammer", "This Offset command will be repeated Hammer_Repeats times."},
#else
{3, 3, 0x0000000000000000, "RW", "hammer", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "offset", "1=Normal Offset Command/Address, 0=Use Base Address and Offset_Command_Instruction Write bit."},
#else
{2, 2, 0x0000000000000000, "RW", "offset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "write", "A Write operation will be performed at the Offset (or Base if the Offset field = 0) Address."},
#else
{0, 0, 0x0000000000000000, "RW", "write", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo168[] = {{"CPGC2_OFFSET_COMMAND_INSTRUCTION_11_", "", 0x00000093, 6, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields169[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "offset_repeats", "Set the loopcount for Offset (Distance from Base). The entire list of Offset Commands are executed for each loop."},
#else
{0, 31, 0x0000000000000000, "RW", "offset_repeats", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo169[] = {{"CPGC2_OFFSET_REPEATS_0_", "", 0x00000094, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields170[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "offset_repeats", "Set the loopcount for Offset (Distance from Base). The entire list of Offset Commands are executed for each loop."},
#else
{0, 31, 0x0000000000000000, "RW", "offset_repeats", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo170[] = {{"CPGC2_OFFSET_REPEATS_1_", "", 0x00000098, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields171[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "offset_repeats_current", "Current Offset Loopcount (down count)."},
#else
{0, 31, 0x0000000000000000, "RO/V", "offset_repeats_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo171[] = {{"CPGC2_OFFSET_REPEATS_CURRENT", "", 0x0000009C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields172[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 17, 0x0000000000000000, "RW", "low_row", "Set the bottom Row for the physical memory being tested. This value is added to all Region Row Addresses computed."},
#else
{0, 17, 0x0000000000000000, "RW", "low_row", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo172[] = {{"CPGC2_REGION_LOW_ROW", "", 0x000000A0, 1, 0x000000000003FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields173[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{2, 10, 0x0000000000000000, "RW", "low_col", "Set the lowest Column for the physical memory being tested. This value is added to all Region Column Addresses computed."},
#else
{2, 10, 0x0000000000000000, "RW", "low_col", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo173[] = {{"CPGC2_REGION_LOW_COL", "", 0x000000A4, 1, 0x00000000000007FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields174[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 17, 0x0000000000000000, "RO/V", "block_origin_row_current", "Current row within the testing region of memory Updated as the block traverses through the region."},
#else
{0, 17, 0x0000000000000000, "RO/V", "block_origin_row_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo174[] = {{"CPGC2_BLOCK_ORIGIN_ROW_CURRENT", "", 0x000000A8, 1, 0x000000000003FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields175[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000000, "RO/V", "base_rank_current", "Current Base Address Rank within the block."},
#else
{16, 18, 0x0000000000000000, "RO/V", "base_rank_current", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 10, 0x0000000000000000, "RO/V", "base_col_current", "Current Base Address Column within the block."},
#else
{2, 10, 0x0000000000000000, "RO/V", "base_col_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo175[] = {{"CPGC2_BASE_ADDRESS_COL_RANK_CURRENT", "", 0x000000AC, 2, 0x000000000007FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields176[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RO/V", "base_bank_current", "Current Base Address Bank within the block."},
#else
{24, 27, 0x0000000000000000, "RO/V", "base_bank_current", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 17, 0x0000000000000000, "RO/V", "base_row_current", "Current Base Address Row within the block."},
#else
{0, 17, 0x0000000000000000, "RO/V", "base_row_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo176[] = {{"CPGC2_BASE_ADDRESS_ROW_BANK_CURRENT", "", 0x000000B0, 2, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields177[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{2, 10, 0x0000000000000000, "RO/V", "offset_col_current", "Current Offset Address Column within the block.[br]\r\n"
"Only valid if the current Command_Instruction pointed to by Command_Instruction_Current is an Offset command."},
#else
{2, 10, 0x0000000000000000, "RO/V", "offset_col_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo177[] = {{"CPGC2_OFFSET_ADDRESS_COL_CURRENT", "", 0x000000B4, 1, 0x00000000000007FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields178[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 17, 0x0000000000000000, "RO/V", "offset_row_current", "Current Offset Address Row within the block.[br]\r\n"
"Only valid if the current Command_Instruction pointed to by Command_Instruction_Current is an Offset command."},
#else
{0, 17, 0x0000000000000000, "RO/V", "offset_row_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo178[] = {{"CPGC2_OFFSET_ADDRESS_ROW_CURRENT", "", 0x000000B8, 1, 0x000000000003FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields179[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "region_size_bits_row", "2^Region_Size_Bits_Row is the number of rows in the testing region. Must be >= to Block_Size_Bits_Row."},
#else
{24, 28, 0x0000000000000000, "RW", "region_size_bits_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "region_size_bits_col", "2^Region_Size_Bits_Col is the number of columns in the testing region. It is also used as the Block_Size_Bits_Col value to set the size of the block. Minimum value is 1 if Address_Decode_Enable =1. , so this normally needs to be set to the number of Column bits of the memory."},
#else
{20, 23, 0x0000000000000000, "RW", "region_size_bits_col", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "block_size_num_ranks", "Number of Ranks to test for a Block (as N-1 = top rank number).[br]\r\n"
"All Rank Addresses go through the Rank Address Lookup table."},
#else
{16, 19, 0x0000000000000000, "RW", "block_size_num_ranks", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "block_size_num_banks", "Number of Banks to test for a Block (as N-1 = top bank number).[br]\r\n"
"All Bank Address values go through the Bank Address Lookup table."},
#else
{12, 15, 0x0000000000000000, "RW", "block_size_num_banks", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 8, 0x0000000000000000, "RW", "block_size_bits_row", "2^Block_Size_Bits_Row is the number of rows for a Block. If block traversal is used, then this must be at least 4 rows (=2). Minimum value is 1 if Address_Decode_Enable =1."},
#else
{4, 8, 0x0000000000000000, "RW", "block_size_bits_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "block_size_bits_col", "Reserved for use as Block_Size_Bits_Col - Fixed as same as Region_Size_Bits_Col for BXT. There is no column traversal of a block in BXT."},
#else
{0, 3, 0x0000000000000000, "RW", "block_size_bits_col", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo179[] = {{"CPGC2_ADDRESS_SIZE", "", 0x000000BC, 6, 0x000000001FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields180[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "address_inversion_rate", "Address_Inversion_Rate determines if the enabled Address Fields toggle inversion on the Command Sequence Boundary (following a Command_Instruction with the Last bit set) or every Command_Instruction. [br]\r\n"
"   0  Invert enabled Address fields after executing the Command_Instruction with the Last bit set. [br][br]\r\n"
"1  Invert enabled Address fields following each Command_Instruction"},
#else
{26, 26, 0x0000000000000000, "RW", "address_inversion_rate", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 25, 0x0000000000000000, "RW", "address_inversion_enable", "Address_Inversion_Enable enables particular Address Fields to be inverted.[br]\r\n"
"[25] Rank_Inversion_Enable.[br]\r\n"
"[24] Bank_Inversion_Enable.[br]\r\n"
"[23] Row_Inversion_Enable.[br]\r\n"
"[22] Col_Inversion_Enable."},
#else
{22, 25, 0x0000000000000000, "RW", "address_inversion_enable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "address_order0_inc_rate", "Address_Order0_Inc_Rate determines if the Address Order 0 Field is incremented on the Command Sequence Boundary (following a Command_Instruction with the Last bit set) or every Command_Instruction. [br][br]\r\n"
"0  Increment Address after executing the Command_Instruction with the Last bit set.[br][br]\r\n"
"1  Increment Address following each Command_Instruction."},
#else
{21, 21, 0x0000000000000000, "RW", "address_order0_inc_rate", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 20, 0x0000000000000000, "RO/V", "reserved_rank_inc", "All Base Rank addresses are incremented (or decremented) by 2^Rank_Inc (unsigned value) - Fixed at 0 for BXT."},
#else
{18, 20, 0x0000000000000000, "RO/V", "reserved_rank_inc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 17, 0x0000000000000000, "RO/V", "reserved_bank_inc", "All Base Bank addresses are incremented (or decremented) by 2^Bank_Inc (unsigned value)  - Fixed at 0 for BXT."},
#else
{15, 17, 0x0000000000000000, "RO/V", "reserved_bank_inc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 14, 0x0000000000000000, "RW", "col_inc", "All Base and Offset Column addresses are incremented (or decremented) by 2^Col_Inc (unsigned value)."},
#else
{11, 14, 0x0000000000000000, "RW", "col_inc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 9, 0x0000000000000000, "RW", "row_inc", "All Base and Offset Row addresses are incremented (or decremented) by 2^Row_Inc (unsigned value)."},
#else
{6, 9, 0x0000000000000000, "RW", "row_inc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "block_move_half_block", "if Block_Move_One_Row =1 then[br]\r\n"
"the Block is moved by 1 row[br]\r\n"
"Else if Block_Move_Half_Bock = 1 then[br]\r\n"
"the Block is moved by 2^(Block_Size_Bits_Row)/2 Rows[br]\r\n"
"Else[br]\r\n"
"the Block is moved by = 2^(Row_Block_Size)."},
#else
{5, 5, 0x0000000000000000, "RW", "block_move_half_block", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "block_move_one_row", "See Block_Move_Half_Block for description."},
#else
{4, 4, 0x0000000000000000, "RW", "block_move_one_row", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo180[] = {{"CPGC2_BASE_ADDRESS_CONTROL", "", 0x000000C0, 9, 0x0000000007FFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields181[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "address_prbs_high_row", "The higher order bits of the PRBS Address Generator (bits 3 through Address_PRBS_Size-1) will be on the same Row bits when the PRBS Address is selected."},
#else
{25, 25, 0x0000000000000000, "RW", "address_prbs_high_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "address_prbs_high_col", "The higher order bits of the PRBS Address Generator (bits 3 through Address_PRBS_Size-1) will be on the same Column bits when the PRBS Address is selected."},
#else
{24, 24, 0x0000000000000000, "RW", "address_prbs_high_col", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "address_prbs_mid_row", "Bits [2:1] of the Row address will be bits [2:1] of the PRBS Address Generator  when the PRBS Address is selected."},
#else
{17, 17, 0x0000000000000000, "RW", "address_prbs_mid_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "address_prbs_mid_col", "Bits [2:1] of the Column address will be bits [2:1] of the PRBS Address Generator when the PRBS Address is selected."},
#else
{16, 16, 0x0000000000000000, "RW", "address_prbs_mid_col", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "address_prbs_low_row", "LSB of Row address will be the LSB of the PRBS Address Generator when the PRBS Address is selected."},
#else
{9, 9, 0x0000000000000000, "RW", "address_prbs_low_row", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "address_prbs_low_col", "LSB of Column address will be the LSB of the PRBS Address Generator when the PRBS Address is selected."},
#else
{8, 8, 0x0000000000000000, "RW", "address_prbs_low_col", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "address_prbs_enable", "If Address_PRBS_Enable is active, and Address_Decode_Enable is not active in the current Address_Instruction, thenn each command is enabled to use the PRBS address if the Address_Decode_or_PRBS_En bit is set."},
#else
{7, 7, 0x0000000000000000, "RW", "address_prbs_enable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "address_prbs_size", "Size of PRBS for address generation if Address_PRBS_Enable is active.  See text for PRBS Polynomials being used for each setting."},
#else
{0, 3, 0x0000000000000000, "RW", "address_prbs_size", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo181[] = {{"CPGC2_ADDRESS_PRBS_CONTROL", "", 0x000000C4, 8, 0x0000000003FFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields182[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 17, 0x0000000000000000, "RW", "address_prbs_seed", "Seed for Address PRBS generator."},
#else
{0, 17, 0x0000000000000000, "RW", "address_prbs_seed", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo182[] = {{"CPGC2_ADDRESS_PRBS_SEED", "", 0x000000C8, 1, 0x000000000003FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields183[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 17, 0x0000000000000000, "RO/V", "address_prbs_current", "Current value of Address PRBS generator.  Address advances as Address_Order0_Inc_Rate.  The Seed is re-loaded (from Save) at each Algorithm_Instruction boundary."},
#else
{0, 17, 0x0000000000000000, "RO/V", "address_prbs_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo183[] = {{"CPGC2_ADDRESS_PRBS_CURRENT", "", 0x000000CC, 1, 0x000000000003FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields184[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 17, 0x0000000000000000, "RO/V", "address_prbs_save", "Saved value of Address PRBS generator.  Value is saved automatically during block advance, and restored (from Seed) when Block Traversal (Repeats) is complete. "},
#else
{0, 17, 0x0000000000000000, "RO/V", "address_prbs_save", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo184[] = {{"CPGC2_ADDRESS_PRBS_SAVE", "", 0x000000D0, 1, 0x000000000003FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields185[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RO/V", "address_instruction_current", "Current Address_Instruction pointer."},
#else
{28, 29, 0x0000000000000000, "RO/V", "address_instruction_current", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RO/V", "data_instruction_current", "Current Data_Instruction pointer."},
#else
{24, 25, 0x0000000000000000, "RO/V", "data_instruction_current", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 17, 0x0000000000000000, "RO/V", "algorithm_instruction_current", "Current Algorithm_Instruction pointer."},
#else
{15, 17, 0x0000000000000000, "RO/V", "algorithm_instruction_current", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RO/V", "command_instruction_current", "Current Command_Instruction pointer."},
#else
{8, 12, 0x0000000000000000, "RO/V", "command_instruction_current", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO/V", "offset_group_instruction_current", "Current Offset_Group as pointed to by the Current Command_Instruction (if an Offset instruction)."},
#else
{6, 6, 0x0000000000000000, "RO/V", "offset_group_instruction_current", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RO/V", "offset_address_instruction_current", "Current Offset_Address_Instruction pointer."},
#else
{3, 5, 0x0000000000000000, "RO/V", "offset_address_instruction_current", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RO/V", "offset_command_instruction_current", "Current Offset_Command_Instruction pointer."},
#else
{0, 2, 0x0000000000000000, "RO/V", "offset_command_instruction_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo185[] = {{"CPGC2_CMD_FSM_CURRENT", "", 0x000000D4, 7, 0x000000003FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields186[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "increment_value", "See Prescaler field for information on this field."},
#else
{28, 31, 0x0000000000000000, "RW", "increment_value", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 25, 0x0000000000000000, "RW", "clock_freq", "When a setting of 1MHz or 1KHz is used in Wait_Clock_Frequency, this field provides a way to tell the hardware the native Memory Controller clock frequency, which is fed into the Prescaler automatically (with a 1 Increment_Value also automatically fed into the counter)."},
#else
{16, 25, 0x0000000000000000, "RW", "clock_freq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 9, 0x0000000000000000, "RW", "prescaler_for_clock_freq", "In order to make the 'standard' 1 GHz clock for the CPGC specified Wait_Clock_Frequency setting, we need to provide a pre-scaler, and Increment Value to modify the existing Wait_Timer_Current advancement. This field will divide the native Memory Controller clock by the provided value, with '1' being 'No Divide'. After that divide, the Wait_Timer_Current will advance by the 'Increment_Value' field. In this way, we are creating a clock ratio able to 'multiply' the native Memory Controller clock by 'Increment_Value/Prescaler'.  For small values of Wait_Time, the error will be substantial, and it may be better to modify the programming to the '11' Native Clock setting and manually compute the required Wait_Time for the desired delay."},
#else
{0, 9, 0x0000000000000000, "RW", "prescaler_for_clock_freq", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo186[] = {{"CPGC2_WAIT_2_START_CONFIG", "", 0x000000D8, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields187[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RW", "err1_grp_sel", "Err Group 1 Select."},
#else
{13, 14, 0x0000000000000000, "RW", "err1_grp_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 12, 0x0000000000000000, "RW", "err0_grp_sel", "Err Group 0 Select."},
#else
{11, 12, 0x0000000000000000, "RW", "err0_grp_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 10, 0x0000000000000000, "RW", "dpat1_grp_sel", "Dpat Group 1 Select."},
#else
{9, 10, 0x0000000000000000, "RW", "dpat1_grp_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW", "dpat0_grp_sel", "Dpat Group 0 Select."},
#else
{7, 8, 0x0000000000000000, "RW", "dpat0_grp_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 6, 0x0000000000000000, "RW", "cmd1_grp_sel", "Cmd Group 1 Select."},
#else
{5, 6, 0x0000000000000000, "RW", "cmd1_grp_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 4, 0x0000000000000000, "RW", "cmd0_grp_sel", "Cmd Group 0 Select."},
#else
{3, 4, 0x0000000000000000, "RW", "cmd0_grp_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "err1_or_cmd1", "Err group 1 or Cmd group 1 select."},
#else
{2, 2, 0x0000000000000000, "RW", "err1_or_cmd1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "cmd0_or_dpat1", "Cmd group 0  or Dpat group 1 select."},
#else
{1, 1, 0x0000000000000000, "RW", "cmd0_or_dpat1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "dpat0_or_err0", "Dpat group 0 or Err group 0 select."},
#else
{0, 0, 0x0000000000000000, "RW", "dpat0_or_err0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo187[] = {{"CPGC2_VISA_MUX_SEL", "", 0x000000DC, 9, 0x0000000000007FFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields188[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RW", "start_test_delay", "Start_Test_Delay is the delay period (in byte clocks) to execute a test(i.e transition to Loopback.Pattern) after the link is in Loopback.Idle and Local_Start_Test is asserted.[br][br]\r\n"
"If Local_Start_Test is set upon the initial enttry to Loopback.Idle then a test (entry to Loopback.Pattern) will immediately start after Start_Test_Delay number of byte clocks is enforced.[br][br]\r\n"
"During Start_Test_test the Valid must not be asserted (i.e Loopback.PM) and no comparison of data will be taking place.[br][br]\r\n"
"Start_Test_Delay=0 is reserved and not allowed.[br][br]\r\n"
"Start_Test_Delay=1 will result in a 1byte clock delay.[br][br]\r\n"
"Start_Test_Delay=2 will result in a 2byte clock delay."},
#else
{24, 31, 0x0000000000000000, "RW", "start_test_delay", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "loopcount", "2^(Loopcount) determines the length of a test.[br][br]\r\n"
"                One Loopcount consists of Pattern_Length followed by PM_Length.[br][br]\r\n"
"                Pattern_Length corresponds to the Loopback Master generating patterns and the Loopback.Slave and/or Loopback Master performing error checking occueeing (valid is assered).[br][br]\r\n"
"                PM_Length corresponds to the functional power savings mode (valid is not asserted).[br][br]\r\n"
"Loopcount=0 means the test is infinite.[br][br]\r\n"
"Loopcount=1 means the test will end after two loops.[br][br]\r\n"
"Loopcount=2 means the test will end after four loops.[br][br]\r\n"
"Loopcount=3 means the test will end after eight loops."},
#else
{16, 20, 0x0000000000000000, "RW", "loopcount", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "pm_length", "PM_Length(i.e Loopback.PM) forms the second half of the loopcount sequence with Pattern_Length (i.e Loopback.Pattern)forming the first half.[br][br]\r\n"
"            PM_Length is used in conjection with Pattern_Length and Loopcount to go in and out of Power Savings Modes in an identical way to how the functional power saving mode behave. This includes post amble, pre-amble, etc.[br][br]\r\n"
"            PM_Length duration is defined in total # of byte clocks.[br][br]\r\n"
"            If PM_Length is set to 0 then no power saving modes will be entered.[br][br]\r\n"
"            If the end of the test has not been reached, (Curren_Loopcount !=Loopcount) the loopcount is incremented and the sequence repeats (Pattern_Length followed by PM_Length).[br][br]\r\n"
"            If the end of the test has not been reached (Current_Loopcount=Loopcount) the link transitions back to Loopback.Idle following the PM state."},
#else
{8, 15, 0x0000000000000000, "RW", "pm_length", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "pattern_length", "Pattern_Length (i.e Loopback.Pattern) forms the first half of the Loopcount sequence with PM_Length (i.e Loopback.PM) forming the second half.[br][br]\r\n"
"            Pattern_Length is the portion of Loopcount when patterns are generated(Loopback Master) and compared (Loopback Master and optionally the Loopback Slave).[br][br]\r\n"
"            Pattern_Length suration is defined in total # of byte clocks. A zero value is illegal.[br][br]\r\n"
"            The Sum of Pattern_Length and PM_Length (Duration of a Loopcount)must always be set to a value of two or more."},
#else
{0, 7, 0x0000000000000000, "RW", "pattern_length", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo188[] = {{"CPGC_LB_SEQ_CFG", "", 0x000000E0, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields189[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW", "initialization_mode", "A change to Initialization_Mode occurs immediately.[br]\r\n"
"00 - OFF - REUT is clock gated.[br]\r\n"
"01 - LSM Mode  - Enter Loopback.Idle state through the appropriate Link Layer bits as a Loopback Master or Loopback Slave.[br]\r\n"
"10 - Force Master - Force entry to Loopback.Idle as a Loopback Master (Supported if Force_Loopback capability is set).[br]\r\n"
"11 - Force Slave - Force entry to Loopback.Idle as Loopback Slave (Supported if Force_Loopback capability is set).[br]\r\n"
"Note: A user must be careful to transition both sides of the Link to Loopback.Idle if switching Initialization_Mode from Force Master or Force Slave to LSM Mode or undefined behavior can be expected.[br]\r\n"
"Note: Initialization Mode should not be changed while Local_Start_Test is set, or while Test_In_Progress is set."},
#else
{12, 13, 0x0000000000000000, "RW", "initialization_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "bind_stop_on_error", "Test will stop based on Global_Error (external input) and Local_Error will drive Global_Error."},
#else
{6, 6, 0x0000000000000000, "RW", "bind_stop_on_error", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "bind_clear_errors", "Local_Clear_Errors will clear all other REUT instances that have this bit set."},
#else
{5, 5, 0x0000000000000000, "RW", "bind_clear_errors", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "bind_stop_test", "Local_Stop_Test will stop all other REUT instances that have this bit set."},
#else
{4, 4, 0x0000000000000000, "RW", "bind_stop_test", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "bind_start_test", "Local_Start_Test will start all other REUT instances that have this bit  set."},
#else
{3, 3, 0x0000000000000000, "RW", "bind_start_test", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW/V", "local_clear_errors", "Setting Local_Clear_Errors  to 1 will immediately clear all local Error registers (i.e. CPGC_ERR_* registers).[br]\r\n"
"Local_Clear_Errors will immediately clear to 0 after clearing affected registers.[br]\r\n"
"If this bit fails to auto-clear, then there is no clock and the clear will occur at the start of the next test."},
#else
{2, 2, 0x0000000000000000, "RW/V", "local_clear_errors", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW/V", "local_stop_test", "If  Local_Stop_Test is set to 1 and a Loopback test is in progress (i.e. Test_In_Progress=1) then a transition to Loopback. Idle will occur as soon as possible (i.e. Link enters Loopback.PM).[br]\r\n"
"Local_Stop_Test will immediately clear to 0 after stopping a Loopback test (i.e. Local_Stop_Test=0 while in Loopback.Idle)."},
#else
{1, 1, 0x0000000000000000, "RW/V", "local_stop_test", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW/V", "local_start_test", "If  Local_Start_Test is set a Sequence will immediately start, or wait until entry to Loopback state.  A complete Sequence is defined by the following behavior:[br]\r\n"
"1) An initial delay of Start_Test_Delay byte clocks must first occur in Loopback.PM (with Valid de-asserted).[br]\r\n"
"2) Transition to Loopback.Pattern (Valid asserted) for a duration of Pattern_Length Byte clocks during which data is generated and compared by the Loopback Master and optionally compared by the Loopback Slave.[br]\r\n"
"3) Increment Loopcounter.[br]\r\n"
"4) Optionally Transition to Loopback.PM (with Valid deasserted), if so programmed, for a duration of PM_Length Byte clocks during which power modes are functionally enforced as what would happen normally based on the length of the PM_Length duration.[br]\r\n"
"5) If Current Loopcount !=2^Loopcount then go to step 2.[br]\r\n"
"6) If Current Loopcount !=2^Loopcount then the Link returns to Loopback.Idle, Local_Start_Test is cleared for the Master. Local_Start_Test is not cleared on the Loopback.Slave."},
#else
{0, 0, 0x0000000000000000, "RW/V", "local_start_test", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo189[] = {{"CPGC_LB_SEQ_CTL", "", 0x000000E4, 8, 0x0000000000003FFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields190[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "current_loopcount", "Current_Loopcount indicates how many times the full Sequence has been executed in the TX path. [br][br]\r\n"
"Current_Loopcount is cleared by Local_Clear_Errors."},
#else
{0, 31, 0x0000000000000000, "RO/V", "current_loopcount", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo190[] = {{"CPGC_LB_SEQ_LOOPCOUNT_TX_STATUS", "", 0x000000E8, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields191[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "current_loopcount", "Current_Loopcount indicates how many times the full Sequence has been executed in the RX path.[br][br]\r\n"
"Current_Loopcount is cleared by Local_Clear_Errors."},
#else
{0, 31, 0x0000000000000000, "RO/V", "current_loopcount", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo191[] = {{"CPGC_LB_SEQ_LOOPCOUNT_RX_STATUS", "", 0x000000EC, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields192[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RO/V", "current_pattern_length", " Current_Pattern_Length is used in conjuntion with Stop_On_Error_Control conditons to determine where the last failure occurred within Loopback.Pattern.[br][br]\r\n"
"Current_Pattern_Length indicates how many Bytes were left in Loopback.Pattern when the error occurred.[br][br]\r\n"
"Current_Pattern_Length is cleared by Local_Clear_Errors."},
#else
{0, 7, 0x0000000000000000, "RO/V", "current_pattern_length", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo192[] = {{"CPGC_LB_SEQ_PL_RX_STATUS", "", 0x000000F0, 1, 0x00000000000000FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields193[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "panic_refresh_only", "(Not Implemented in BXT) If Panick_Refresh_Only=1, then opportunistic and high priority auto refreshes will be disabled for all ranks and refreshes will only occur when the panic refresh watermark has been exceeded. If Panic_Refresh_Only=0, then refreshes will occur using the existing MC functional refresh logic.[br]\r\n"
"[br]\r\n"
"tREFI defines the average period between refreshes, and the rate that tREFI counter is incremented (in DCLK cycles, default is 4100). This field is a often a shadow register to an exisitng MC tREFI field. tREFI is located in another CR.  In Haswell this is located in the CR TC_RFTP.tREFI (15:0) in MCMNTS."},
#else
{31, 31, 0x0000000000000000, "RW", "panic_refresh_only", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "refzq_en_start_test_sync", "(Not Implemented in BXT) If RefZQ_En_Start_Test_Sync=1, this field will ensure all refresh/ZQ powerdown logic (counters, FSMs, etc.) is kept in the default reset state (no refresh/ZQ happening) while in Loopback.Marker during REUT Mode. Once the test starts and the transition to Loopback.Pattern occurs, the refresh/ZQ logic will behave identical to normal functional MC mode based on the values programmed in the refresh/ZQ CRs. This allows deterministic and reproducible behavior across REUT tests with respect to refresh/ZQ since the logic is synchronized to the start of a REUT test.[br]\r\n"
"If RefZQ_En_Start_Test_Sync=0, the refresh/ZQ logic will not be synchronized to the start of a REUT test and will always behave identical to normal functional MC mode based on the values programmed in the refresh/ZQ CRs, whether in Loopback.Marker or Loopback.Pattern.[br]\r\n"
"[br]\r\n"
"NOTE: This bit should not be used in conjuction with Self Refresh.[br]\r\n"
""},
#else
{8, 8, 0x0000000000000000, "RW", "refzq_en_start_test_sync", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "refresh_rank_mask", "(Not Implemented in BXT) Refresh_Rank_Mask is a per rank field.[br]\r\n"
"[br]\r\n"
"The LSB relates to Rank0 and the MSB relates to the highest Rank.  If the per Rank bit of the Refresh_Rank_Mask is set to 1, then the REUT engine will disable executing any refresh to that rank while in REUT mode.[br]\r\n"
"[br]\r\n"
"If the per rank bit of the Refresh_Rank_Mask is set to 0 and then the REUT engine will enable executing a refresh (assuming the MC has refreshes enabled) to that Rank while in REUT mode based on the Panic_Refresh_Only value."},
#else
{0, 3, 0x0000000000000000, "RW", "refresh_rank_mask", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo193[] = {{"CPGC_MISC_REFRESH_CTL", "", 0x000000F4, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields194[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "always_do_zq", "(Not Implemented in BXT) If Always_Do_ZQ is set to 1, a ZQ operation will always take place after a refresh occurs as long as the ZQ_Rank_Mask for that rank is set to 0.[br]\r\n"
"[br]\r\n"
"If Always_Do_ZQ is set to 0, a ZQ operation will take place at the normal programmed 128*ZQCS_period after a refresh occurs as long as the ZQ_Rank_Mask for that rank is set to 0."},
#else
{31, 31, 0x0000000000000000, "RW", "always_do_zq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "zq_rank_mask", "(Not Implemented in BXT) ZQ Mask is a per rank (Chip Select) field.  The LSB relates to Rank0 and the MSB relates to the highest Rank.[br]\r\n"
"[br]\r\n"
"If the per rank bit of the ZQ Mask is set to 1, then the REUT engine will disable executing ZQ operations to that Rank.   Note that if the Refresh_Rank_Mask for the same rank is set to 1 then the ZQ Mask will have no effect and ZQ will disabled to that rank.[br]\r\n"
"[br]\r\n"
"If the per rank bit of the ZQ mask is set to 0 and refreshes are being issued to the corresponding Rank, ZQ will be issued at a rate equal to 128*ZQCS_period programmed inside the channel TC_ZQCAL CR, always occurring after refreshes occur.[br]\r\n"
"ZQCS_period is the time between ZQCS operations in tREFI*128 (2 to 255, default is 128.[br]\r\n"
"ZQCS_period is located in another CR.  In Haswell this is located in the CR TC_ZQCAL.[br]\r\n"
"ZQCS_period (7:0) in MCMNTS."},
#else
{0, 1, 0x0000000000000000, "RW", "zq_rank_mask", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo194[] = {{"CPGC_MISC_ZQ_CTL", "", 0x000000F8, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields195[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "mpr_train_ddr_on", "(Not Implemented in BXT) This bit is to be set during DDR training.  The MPR pattern (Hardcoded 0101 pattern) from the DRAM will be used to initially train the read timing.  This MPR pattern is accessed via the MR3 DRAM register and, per the JEDEC spec, the mode comes with two key limitations:[br]\r\n"
"[br]\r\n"
"   1. Before entering this mode, all pages must be precharged.[br]\r\n"
"[br]\r\n"
"   2. Once in this mode, the MC can only issue RD or RDA commands.[br]\r\n"
"[br]\r\n"
"   When this CR bit is set, the RAS# and WE# will always drive high.  This will morph any command from the scheduler into either READ or DESELECT.[br]\r\n"
"[br]\r\n"
"   The flow is as follows:[br]\r\n"
"[br]\r\n"
"   1. MRS Mode to write MR3.[br]\r\n"
"[br]\r\n"
"   2. Set MPR_Train_DDR_On.[br]\r\n"
"[br]\r\n"
"   3. Set REUT Mode.[br]\r\n"
"[br]\r\n"
"   4. Wait for all pages to close (page table idle counter to expire).[br]\r\n"
"[br]\r\n"
"   5. Run REUT Test.[br]\r\n"
"[br]\r\n"
"   6. Stop Test, clear MPR_Train_DDR_On bit, clear MR3 register.[br]\r\n"
"[br]\r\n"
"   7. Continue with other REUT tests.[br]\r\n"
"[br]\r\n"
"   Note that ZQ, CKE and Refresh should be disabled using the appropriate CR settings during MPR_Train_DDR_On."},
#else
{31, 31, 0x0000000000000000, "RW", "mpr_train_ddr_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "odt_on", "(Not Implemented in BXT) ODT_on is a 4-bit field, one bit per rank (Chip Select).  The LSB relates to Rank0 and the MSB relates to the highest Rank.  When ODT_Override is set to 1 for a rank the value in ODT_On will be used as the ODT value for that rank.[br]\r\n"
""},
#else
{16, 17, 0x0000000000000000, "RW", "odt_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "odt_override", "(Not Implemented in BXT) ODT_Override is a per rank field.  The LSB relates to Rank0 and the MSB relates to the highest Rank. When ODT_Override is set to 1 for a rank, the ODT functional logic will be bypassed and the ODT_On value for that rank will be used. When ODT_Override is set to 0 for a rank, the ODT functional logic will drive the ODT value for that rank.[br]\r\n"
""},
#else
{0, 1, 0x0000000000000000, "RW", "odt_override", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo195[] = {{"CPGC_MISC_ODT_CTL", "", 0x000000FC, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields196[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "cke_on", "(Not Implemented in BXT) CKE_On is a 4-bit field, one bit per rank.  The LSB relates to Rank0 and the MSB relates to the highest Rank.  In REUT mode when the per rank bit is set CKE will be always on for that rank."},
#else
{16, 17, 0x0000000000000000, "RW", "cke_on", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "cke_en_start_test_sync", "(Not Implemented in BXT) When CKE_En_Start_Test_Sync is set to 1 this field will ensure all CKE powerdown logic (counters, FSMs, etc.) is kept in the default reset state (no CKE powerdowns happening) while in Loopback.Marker during REUT Mode. Once the test starts and the transition to Loopback.Pattern occurs the CKE powerdown logic will behave identical to normal functional MC mode based on the values programmed in the powerdown CR, PM_PDWN_config_0_0_0_MCHBAR. This allows deterministic and reproducible behavior across REUT tests with respect to CKE powerdown since the logic is synchronized to the start of a REUT test.[br]\r\n"
"[br]\r\n"
"When CKE_En_Start_Test_Sync is set to 0 the CKE powerdown logic will not be synchronized to the start of a REUT test and will always behave identical to normal functional MC mode based on the values programmed in the powerdown CR, PM_PDWN_config_0_0_0_MCHBAR, whether in Loopback.Marker or Loopback.Pattern.[br]\r\n"
"[br]\r\n"
"NOTE: This bit should not be used in conjuction with Self Refresh.[br]\r\n"
""},
#else
{8, 8, 0x0000000000000000, "RW", "cke_en_start_test_sync", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "cke_override", "(Not Implemented in BXT) CKE_Override is a a per rank field.  The LSB relates to Rank0 and the MSB relates to the highest Rank. When CKE_Override is set to 1 for a rank, the CKE functional logic will be bypassed and the CKE_On value for that rank will be used. When CKE_Override is set to 0 for a rank, the CKE functional logic will drive the CKE value for that rank.[br]\r\n"
""},
#else
{0, 1, 0x0000000000000000, "RW", "cke_override", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo196[] = {{"CPGC_MISC_CKE_CTL", "", 0x00000100, 3, 0x000000000003FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields197[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "init_mrw_2n_cs", "(Not Implemented in BXT) When sending a MRW command via MRH and setting the Init_MRW bit, send the CS for two DCLK cycles (on the third and fourth cycles, rather than on just the third one)."},
#else
{31, 31, 0x0000000000000000, "RW", "init_mrw_2n_cs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000001, "RW", "ck_to_cke_delay", "(Not Implemented in BXT) TBD."},
#else
{12, 13, 0x0000000000000001, "RW", "ck_to_cke_delay", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "reset_delay", "(Not Implemented in BXT) Inserts an N Dclk delay ranging from 0 to 7 after the N to 1 Reset on Cmd is triggered."},
#else
{8, 11, 0x0000000000000000, "RW", "reset_delay", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "reset_on_command", "(Not Implemented in BXT) N:1 mode is set and utilized as designed in the functional MC logic where N is the number of cycles of allowed continuous CMD cycles before the MC logic will stall a sequence and insert a tri-state bubble.[br]\r\n"
"[br]\r\n"
"When Deselect traffic is driven by the CADB (combination of Subsequence_Deselect_Enable being set, CMD_Deselect_Enable enabling deselects, and a non zero value for Lane_Deselect_Enable) all Deselect cycles within the MC scheduler logic will be considered as consecutive Select cycles in the N:1 logic and thus a tri-state bubble will be inserted regularly as enforced by the N:1 logic.  Tristate effects both select and deselect cycles.[br]\r\n"
"[br]\r\n"
"The N:1 logic can also be triggered to insert a tri-state bubble and reset the N:1 logic after a programmable delay (Reset_N_to_1_Delay=0-7 Dclks) after a PRE/ACT/RD/WR CMD.  This allows one to synchronize the N:1 logic periodically to ensure the correct worst case pattern between victim and aggressor occurs.[br]\r\n"
"[br]\r\n"
"Reset N to 1 Logic on a WR (bit 4).[br]\r\n"
"Reset N to 1 Logic on a RD (bit 5).[br]\r\n"
"Reset N to 1 Logic on a ACT (bit 6).[br]\r\n"
"Reset N to 1 Logic on a PRE (bit 7)."},
#else
{4, 7, 0x0000000000000000, "RW", "reset_on_command", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 3, 0x0000000000000005, "RW", "cmd_rate_limit", "(Not Implemented in BXT) Cmd_Rate_Limit - The legal range is 2-7."},
#else
{1, 3, 0x0000000000000005, "RW", "cmd_rate_limit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "enable_cmd_rate_limit", "(Not Implemented in BXT) Enable the Cmd_Rate_Limit."},
#else
{0, 0, 0x0000000000000000, "RW", "enable_cmd_rate_limit", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo197[] = {{"CPGC_MISC_CMD_RATE", "", 0x00000104, 6, 0x00000000FFFFFFFF, 0x000000000000100A}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields198[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "trigger_out_on_test_done", "(Not Implemented in BXT) Setting Trigger_Out_On_Test_Done enables external equipment to be synced deterministically to the exact moment when Trigger_Out_On_Channel_Test_Done_Status_1 is set.[br]\r\n"
"[br]\r\n"
"This capability enables external test equipment to be deterministically synched to when Channel 1 REUT test is completed.  This is required to allow synchronous REUT operation with external test hardware (HVM Tester, BERT, etc.).[br]\r\n"
"[br]\r\n"
"When Trigger_Out_On_Channel_Test_Done_Status_1 is set a deterministic externally viewable uBP trigger is generated each time REUT_GLOBAL_ERR.Channel_Test_Done_Status_1 is set to 1."},
#else
{3, 3, 0x0000000000000000, "RW", "trigger_out_on_test_done", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "trigger_out_on_error", "(Not Implemented in BXT) Setting Trigger_Out_On_Error_0 enables external equipment to be synced deterministically to when any bit in Data_Error_Status or ECC_Error_Status on channel 0 is set.  Once any bit in Data_Error_Status or ECC_Error_Status on channel 0 is set no additional triggers will be generated.[br]\r\n"
"[br]\r\n"
"This capability enables external test equipment to be synched to an error event within REUT on channel 0.  This is required to allow synchronous REUT operation with external test hardware (HVM Tester, BERT, etc.).[br]\r\n"
"[br]\r\n"
"When Trigger_Out_On_Error_0 is set a deterministic uBP trigger is generated in relation to when REUT_CH_ERR_DATA_STATUS.Data_Error_Status or REUT_CH_ERR_ECC_CHUNK_RANK_BYTE_NTH_STATUS.ECC_Error_Status becomes non zero on channel 0.[br]\r\n"
""},
#else
{2, 2, 0x0000000000000000, "RW", "trigger_out_on_error", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "trigger_out_global_start", "(Not Implemented in BXT) Setting Trigger_Out_Global_Start will generate a deterministic external uBP trigger that is based on Global_Start_Test being set.[br]\r\n"
"[br]\r\n"
"This capability enables a test to start in a synchronous fashion with respect to an external event.  This is required to allow synchronous REUT operation with external test hardware (HVM Tester, BERT, etc.).[br]\r\n"
"[br]\r\n"
"When Trigger_OUT_Global_Start is set a deterministic uBP trigger is generated each time REUT_GLOBAL_CTL.Global_Start_Test is set."},
#else
{1, 1, 0x0000000000000000, "RW", "trigger_out_global_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "trigger_in_global_start", "(Not Implemented in BXT) Setting Trigger_In_Global_Start enables a test to start based on a uBP trigger.  This capability enables a test to start in a synchronous fashion with respect to an external event.[br]\r\n"
"[br]\r\n"
"This is required to allow synchronous REUT operation with external test hardware (HVM Tester, BERT, etc.).[br]\r\n"
"When Trigger_In_Global_Start is set the uBP used to start a REUT test will set REUT_GLOBAL_CTL.Global_Start_Test on a deterministic boundary."},
#else
{0, 0, 0x0000000000000000, "RW", "trigger_in_global_start", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo198[] = {{"CPGC_MISC_EXT_TRIGGER", "", 0x00000108, 4, 0x000000000000000F, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields199[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW/V", "continue_single_mode", "When in Single_Command_Mode setting this bit will enable a new command to be issued. This bit immediately clears after being set."},
#else
{9, 9, 0x0000000000000000, "RW/V", "continue_single_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "single_cmd_mode", "Enter Single Command mode were we will issue one command from CPGC and then pause command issuing. This may be resumed by setting Continue_Single_Mode, or normal continuous operation resumed by clearing this bit."},
#else
{8, 8, 0x0000000000000000, "RW", "single_cmd_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW/V", "clear_errors", "Setting this bit will immediately clear all error registers and error status. This bit will automatically self clear."},
#else
{2, 2, 0x0000000000000000, "RW/V", "clear_errors", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW/V", "stop_test", "Forces an exit from the tests running on this engine/channel.  Note that this will also cause a test stop for all engines with GLB_STOP_BIND set. This bit will self clear."},
#else
{1, 1, 0x0000000000000000, "RW/V", "stop_test", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW/V", "start_test", "Used to initiate a transition to active mode on this engine/channel (note that INIT_MODE has to be programmed first).  Note that this will also cause a test start for all engines with GLB_START_BIND set.[br]\r\n"
"This bit will self clear."},
#else
{0, 0, 0x0000000000000000, "RW/V", "start_test", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo199[] = {{"CPGC_SEQ_CTL", "", 0x0000010C, 5, 0x00000000000003FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields200[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "request_data_size", "Size of requests CPGC is issuing, 64B and 32B transactions and is encoded as follows:[br][br]\r\n"
"                        0 - 32 Byte Transactions[br][br]\r\n"
"                        1 - 64 Byte Transactions"},
#else
{22, 22, 0x0000000000000000, "RW", "request_data_size", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000001, "RW", "cpgc_control", "Used to indicate the OPIO(MCDRAM) or CPGC(DDR) mode.[br][br]\r\n"
"1 - CPGC Mode.[br][br]\r\n"
"0 - OPIO Mode."},
#else
{21, 21, 0x0000000000000001, "RW", "cpgc_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "initialization_mode", "000 - IDLE MODE[br]\r\n"
"001 - ACTIVE MODE[br]\r\n"
"010 - DIRECT MODE[br]\r\n"
"011 - ACTIVE MODE[br]\r\n"
"100 - MRS MODE[br]\r\n"
"101 - ERROR DUMP MODE (Reserved)[br]\r\n"
"110 - WDB FILL MODE (Reserved)[br]\r\n"
"111 - REWIND MODE (Reserved)"},
#else
{12, 14, 0x0000000000000000, "RW", "initialization_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "global_stop_bind", "Setting this bit will bind this channel engine to all other channel engines.  A test stop (both forced and due to a stop condition) for any channel engine with GLOBAL_STOP_BIND set will cause the same action to occur on all engines with GLOBAL_STOP_BIND set.  This feature is usually used when synchronization between multiple engines/channels necessitates a global control of all supported engines.[br] Note: this field is only available if multiple channels/engines are supported for the current implementation, otherwise it is reserved."},
#else
{11, 11, 0x0000000000000000, "RW", "global_stop_bind", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "global_start_bind", "Setting this bit will bind this channel engine to all other channel engines. A test start for any channel with GLOBAL_START_BIND set will cause the same action to occur on all engines with GLOBAL_START_BIND set. This feature is usually used when synchronization between multiple engines/channels necessitates a global control of all supported engines.[br] Note: this field is only available if multiple channels/engines are supported for the current implementation, otherwise it is reserved."},
#else
{10, 10, 0x0000000000000000, "RW", "global_start_bind", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "global_stop_on_err_bind", "Setting this bit will bind this channel engine to all other channel engines. A test stop (due to an error condition) for any channel with GLOBAL_STOP_ON_ERR_BIND set will cause the same action to occur on all engines with GLOBAL_STOP_ON_ERR_BIND set. This feature is usually used when synchronization between multiple engines/channels necessitates a global control of all supported engines.[br] Note: this field is only available if multiple channels/engines are supported for the current implementation, otherwise it is reserved."},
#else
{9, 9, 0x0000000000000000, "RW", "global_stop_on_err_bind", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "global_clear_err_bind", "Setting this bit will bind this channel engine to all other channel engines. Clearing all error registers and error status for any channel with GLOBAL_CLEAR_ERR_BIND set will cause the same action to occur on all engines with GLOBAL_CLEAR_ERR_BIND set. This feature is usually used when synchronization between multiple engines/channels necessitates a global control of all supported engines.[br] Note: this field is only available if multiple channels/engines are supported for the current implementation, otherwise it is reserved."},
#else
{8, 8, 0x0000000000000000, "RW", "global_clear_err_bind", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "enable_constant_write_strobe", "(Not Implemented in BXT) Setting this bit will cause the Tx write strobe to be driven out constantly while a test is in progress.[br] Note: This is most often used to help train the correct setting for per rank write levelling."},
#else
{6, 6, 0x0000000000000000, "RW", "enable_constant_write_strobe", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo200[] = {{"CPGC_SEQ_CFG_A", "", 0x00000110, 8, 0x00000000007FFFFF, 0x0000000000200000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields201[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 9, 0x0000000000000000, "RW", "start_delay", "Number of clock cycles (in CPGC-S clock domain) the start of the test is delayed by after START_TEST has been asserted by the user. This is usually used to synchronize multiple SoC CPGC engines on multiple channels according to a defined phase relationship."},
#else
{0, 9, 0x0000000000000000, "RW", "start_delay", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo201[] = {{"CPGC_SEQ_CFG_B", "", 0x00000114, 1, 0x00000000000003FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields202[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO/V", "test_done", "This bit will be set when the test is complete (or has been forced to exit due to a stop condition). Bit is cleared on a reset or when user starts another test."},
#else
{31, 31, 0x0000000000000000, "RO/V", "test_done", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RO/V", "test_busy", "This bit will be set when once a test has started.  Bit is cleared on a reset or once test is done (or has been forced to exit due a stop condition)."},
#else
{30, 30, 0x0000000000000000, "RO/V", "test_busy", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RO/V", "algo_done", "This bit will be set when all the algorithms are complete. It is cleared on a reset."},
#else
{29, 29, 0x0000000000000000, "RO/V", "algo_done", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RO/V", "single_mode_paused", "This bit will be set when a command has been issued and we are paused due to Single_Command_Mode.  The test may be continued by either clearing Single_Command_Mode or by setting Continue_Single_Mode."},
#else
{28, 28, 0x0000000000000000, "RO/V", "single_mode_paused", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo202[] = {{"CPGC_SEQ_STATUS", "", 0x00000118, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields203[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{5, 10, 0x0000000000000020, "RW/P", "wr_credit_init", "This gives the default value for write credit counter at reset."},
#else
{5, 10, 0x0000000000000020, "RW/P", "wr_credit_init", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000010, "RW/P", "rd_credit_init", "This gives the default value for read credit counter at reset."},
#else
{0, 4, 0x0000000000000010, "RW/P", "rd_credit_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo203[] = {{"CPGC2_CHICKEN_REG", "", 0x0000011C, 2, 0x00000000000007FF, 0x0000000000000410}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields204[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo204[] = {{"CPGC2_RASTER_REPO_CONTENT_0_", "", 0x00000120, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields205[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo205[] = {{"CPGC2_RASTER_REPO_CONTENT_1_", "", 0x00000124, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields206[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo206[] = {{"CPGC2_RASTER_REPO_CONTENT_2_", "", 0x00000128, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields207[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo207[] = {{"CPGC2_RASTER_REPO_CONTENT_3_", "", 0x0000012C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields208[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo208[] = {{"CPGC2_RASTER_REPO_CONTENT_4_", "", 0x00000130, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields209[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo209[] = {{"CPGC2_RASTER_REPO_CONTENT_5_", "", 0x00000134, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields210[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo210[] = {{"CPGC2_RASTER_REPO_CONTENT_6_", "", 0x00000138, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields211[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo211[] = {{"CPGC2_RASTER_REPO_CONTENT_7_", "", 0x0000013C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields212[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo212[] = {{"CPGC2_RASTER_REPO_CONTENT_8_", "", 0x00000140, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields213[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo213[] = {{"CPGC2_RASTER_REPO_CONTENT_9_", "", 0x00000144, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields214[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo214[] = {{"CPGC2_RASTER_REPO_CONTENT_10_", "", 0x00000148, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields215[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo215[] = {{"CPGC2_RASTER_REPO_CONTENT_11_", "", 0x0000014C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields216[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo216[] = {{"CPGC2_RASTER_REPO_CONTENT_12_", "", 0x00000150, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields217[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo217[] = {{"CPGC2_RASTER_REPO_CONTENT_13_", "", 0x00000154, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields218[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo218[] = {{"CPGC2_RASTER_REPO_CONTENT_14_", "", 0x00000158, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields219[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "content", "Flat register read access to Raster Repository.[br]\r\n"
"The format of this is 2 consecutive addresses contain a complete 64-bit data chunk error bit-map, or one Error_Summary entry.[br]\r\n"
"In Mode3, there are up to 4 Row addresses for read failures for the associated Bank, based on the indicators in RASTER_REPO_CONTENT_ECC*."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "content", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo219[] = {{"CPGC2_RASTER_REPO_CONTENT_15_", "", 0x0000015C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields220[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RO/V/P", "ecc_chunk3", "ECC chunk 3 raster when in Mode 1."},
#else
{28, 31, 0x0000000000000000, "RO/V/P", "ecc_chunk3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RO/V/P", "fail_count3", "Bank 3 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries."},
#else
{26, 27, 0x0000000000000000, "RO/V/P", "fail_count3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RO/V/P", "fail_any3", "0 - indicates no failing address, 1 - indicates 1 or more failing address in the corresponding Content entry."},
#else
{25, 25, 0x0000000000000000, "RO/V/P", "fail_any3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RO/V/P", "fail_excess3", "0  indicates no more than fail_max failing addresses, 1 - indicates more than fail_max failing addresses."},
#else
{24, 24, 0x0000000000000000, "RO/V/P", "fail_excess3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RO/V/P", "ecc_chunk2", "ECC chunk 2 raster when in Mode 1."},
#else
{20, 23, 0x0000000000000000, "RO/V/P", "ecc_chunk2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RO/V/P", "fail_count2", "Bank 2 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries."},
#else
{18, 19, 0x0000000000000000, "RO/V/P", "fail_count2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RO/V/P", "fail_any2", "0 - indicates no failing address, 1 - indicates 1 or more failing address in the corresponding Content entry."},
#else
{17, 17, 0x0000000000000000, "RO/V/P", "fail_any2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RO/V/P", "fail_excess2", "0  indicates no more than fail_max failing addresses, 1 - indicates more than fail_max failing addresses."},
#else
{16, 16, 0x0000000000000000, "RO/V/P", "fail_excess2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RO/V/P", "ecc_chunk1", "ECC chunk 1 raster when in Mode 1."},
#else
{12, 15, 0x0000000000000000, "RO/V/P", "ecc_chunk1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RO/V/P", "fail_count1", "Bank 1 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries."},
#else
{10, 11, 0x0000000000000000, "RO/V/P", "fail_count1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RO/V/P", "fail_any1", "0 - indicates no failing address, 1 - indicates 1 or more failing address in the corresponding Content entry."},
#else
{9, 9, 0x0000000000000000, "RO/V/P", "fail_any1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RO/V/P", "fail_excess1", "0  indicates no more than fail_max failing addresses, 1 - indicates more than fail_max failing addresses."},
#else
{8, 8, 0x0000000000000000, "RO/V/P", "fail_excess1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO/V/P", "ecc_chunk0", "ECC chunk 0 raster when in Mode 1."},
#else
{4, 7, 0x0000000000000000, "RO/V/P", "ecc_chunk0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RO/V/P", "fail_count0", "Bank 0 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries."},
#else
{2, 3, 0x0000000000000000, "RO/V/P", "fail_count0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO/V/P", "fail_any0", "0 - indicates no failing address, 1 - indicates 1 or more failing address in the corresponding Content entry."},
#else
{1, 1, 0x0000000000000000, "RO/V/P", "fail_any0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO/V/P", "fail_excess0", "0  indicates no more than fail_max failing addresses, 1 - indicates more than fail_max failing addresses."},
#else
{0, 0, 0x0000000000000000, "RO/V/P", "fail_excess0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo220[] = {{"CPGC2_RASTER_REPO_CONTENT_ECC1", "", 0x00000160, 16, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields221[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RO/V/P", "ecc_chunk7", "ECC chunk 7 raster when in Mode 1."},
#else
{28, 31, 0x0000000000000000, "RO/V/P", "ecc_chunk7", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RO/V/P", "fail_count7", "Bank 7 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries."},
#else
{26, 27, 0x0000000000000000, "RO/V/P", "fail_count7", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RO/V/P", "fail_any7", "0 - indicates no failing address, 1 - indicates 1 or more failing address in the corresponding Content entry."},
#else
{25, 25, 0x0000000000000000, "RO/V/P", "fail_any7", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RO/V/P", "fail_excess7", "0  indicates no more than fail_max failing addresses, 1 - indicates more than fail_max failing addresses."},
#else
{24, 24, 0x0000000000000000, "RO/V/P", "fail_excess7", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RO/V/P", "ecc_chunk6", "ECC chunk 6 raster when in Mode 1."},
#else
{20, 23, 0x0000000000000000, "RO/V/P", "ecc_chunk6", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RO/V/P", "fail_count6", "Bank 6 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries."},
#else
{18, 19, 0x0000000000000000, "RO/V/P", "fail_count6", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RO/V/P", "fail_any6", "0 - indicates no failing address, 1 - indicates 1 or more failing address in the corresponding Content entry."},
#else
{17, 17, 0x0000000000000000, "RO/V/P", "fail_any6", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RO/V/P", "fail_excess6", "0  indicates no more than fail_max failing addresses, 1 - indicates more than fail_max failing addresses."},
#else
{16, 16, 0x0000000000000000, "RO/V/P", "fail_excess6", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RO/V/P", "ecc_chunk5", "ECC chunk 5 raster when in Mode 1."},
#else
{12, 15, 0x0000000000000000, "RO/V/P", "ecc_chunk5", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RO/V/P", "fail_count5", "Bank 5 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries."},
#else
{10, 11, 0x0000000000000000, "RO/V/P", "fail_count5", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RO/V/P", "fail_any5", "0 - indicates no failing address, 1 - indicates 1 or more failing address in the corresponding Content entry."},
#else
{9, 9, 0x0000000000000000, "RO/V/P", "fail_any5", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RO/V/P", "fail_excess5", "0  indicates no more than fail_max failing addresses, 1 - indicates more than fail_max failing addresses."},
#else
{8, 8, 0x0000000000000000, "RO/V/P", "fail_excess5", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO/V/P", "ecc_chunk4", "ECC chunk 4 raster when in Mode 1."},
#else
{4, 7, 0x0000000000000000, "RO/V/P", "ecc_chunk4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RO/V/P", "fail_count4", "Bank 4 Number of failing address. 0=none or 1, 1=2, 2=3, and 3=4 entries."},
#else
{2, 3, 0x0000000000000000, "RO/V/P", "fail_count4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO/V/P", "fail_any4", "0 - indicates no failing address, 1 - indicates 1 or more failing address in the corresponding Content entry."},
#else
{1, 1, 0x0000000000000000, "RO/V/P", "fail_any4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO/V/P", "fail_excess4", "0  indicates no more than fail_max failing addresses, 1 - indicates more than fail_max failing addresses."},
#else
{0, 0, 0x0000000000000000, "RO/V/P", "fail_excess4", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo221[] = {{"CPGC2_RASTER_REPO_CONTENT_ECC2", "", 0x00000164, 16, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields222[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "read_command_count_current", "Current count of reads - freezes on stop_on_error conditions at the number of reads including the error that caused the stop."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "read_command_count_current", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo222[] = {{"CPGC2_READ_COMMAND_COUNT_CURRENT", "", 0x00000168, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields223[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW/P", "mask_first_n_reads", "0=no masking, N= number of reads that will not result in any error indication for the raster repository."},
#else
{0, 31, 0x0000000000000000, "RW/P", "mask_first_n_reads", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo223[] = {{"CPGC2_MASK_ERRS_FIRST_N_READS", "", 0x0000016C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields224[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW/V", "rasterrepoclear", "Reset the raster repo entries. This bit auto-clears."},
#else
{31, 31, 0x0000000000000000, "RW/V", "rasterrepoclear", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW/P", "stoponraster", "If Raster Mode 1, test will stop after loading the bitmap into the raster. If Raster Mode 2, test will stop after loading 8 errors in the raster."},
#else
{30, 30, 0x0000000000000000, "RW/P", "stoponraster", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW/P", "rasterrepomode", "00 Mode 1 BitMap Mode.[br]\r\n"
"01 Mode 2 Summary Mode.[br]\r\n"
"10 mode 3 Filtered Failed Row Mode."},
#else
{16, 17, 0x0000000000000000, "RW/P", "rasterrepomode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW/P", "failmax", "Maximum number of failing address before an additional failing address will set fail_excess for any bank.[br]\r\n"
"00  one failure, 01 - two failures, 10 - three failures, 11- four failures.[br]\r\n"
""},
#else
{10, 11, 0x0000000000000000, "RW/P", "failmax", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RO/V/P", "failanyall", "0 - indicates no failing addresses.[br]\r\n"
"1 - indicates 1 or more failing addresses."},
#else
{9, 9, 0x0000000000000000, "RO/V/P", "failanyall", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RO/V/P", "failexcessall", "0 - indicates less than or exactly max_fail failing addresses on all banks.[br]\r\n"
"1 - indicates at least one bank's errors exceed the max_fail limit."},
#else
{8, 8, 0x0000000000000000, "RO/V/P", "failexcessall", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000000, "RO/V/P", "numerrlogged", "Indicates the current number of errors loaded in the raster repo in Mode 2. Max value is 8."},
#else
{4, 6, 0x0000000000000000, "RO/V/P", "numerrlogged", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RO/V/P", "rasterrepofull", "Indicates when the no. of errors logged exceed max value of 8."},
#else
{2, 2, 0x0000000000000000, "RO/V/P", "rasterrepofull", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO/V/P", "summaryvalid", "Indicates when the summary information of the erroneous bitmap is loaded in the current summary buffer. This information consist of Algorithmic data, Physical Addr (Rank, Bank,Row,Col) and 8 2-bit error summary for every chunk."},
#else
{1, 1, 0x0000000000000000, "RO/V/P", "summaryvalid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO/V/P", "bitmapvalid", "Indicates when Mode 1 erroneous bitmap data is loaded in the raster repo."},
#else
{0, 0, 0x0000000000000000, "RO/V/P", "bitmapvalid", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo224[] = {{"CPGC2_RASTER_REPO_STATUS", "", 0x00000170, 10, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields225[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO/V/P", "algorithm_summary", "Algorithm_Summary - currently formated as:[br]\r\n"
"[2:0] Offset_Command_Instruction_Current.[br]\r\n"
"[5:3] Offset_Address_Instruction_Current.[br]\r\n"
"[10:6] Command_Instruction_Current.[br]\r\n"
"[13:11] Algorithm_Instruction_Current.[br]\r\n"
"[15:14] Data_Instruction_Current."},
#else
{16, 31, 0x0000000000000000, "RO/V/P", "algorithm_summary", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RO/V/P", "error_summary", "Error_Summary - formatted as a pair of adjacent bits for each chunk, 00=no error in that chunk, 01=one error in that chunk, 10=two errors in that chunk, 11=three or more errors in that chunk."},
#else
{0, 15, 0x0000000000000000, "RO/V/P", "error_summary", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo225[] = {{"CPGC2_ERR_SUMMARY_A", "", 0x00000174, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields226[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{2, 31, 0x0000000000000000, "RO/V/P", "physical_address_summary", "Error_Summary - Physical Address encoded as:[br]\r\n"
"[7:0] Column, [25:8] Row, [28:26] Bank, [29] Rank."},
#else
{2, 31, 0x0000000000000000, "RO/V/P", "physical_address_summary", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RO/V/P", "algorithm_summary", "Algorithm_Summary - currently formated as:[br]\r\n"
"[1:0] Address_Instruction_Current."},
#else
{0, 1, 0x0000000000000000, "RO/V/P", "algorithm_summary", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo226[] = {{"CPGC2_ERR_SUMMARY_B", "", 0x00000178, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields227[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "dg_reserved", "Reserved for expansion of Error_Summary (bits 7:0)."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "dg_reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo227[] = {{"CPGC2_ERR_SUMMARY_C", "", 0x0000017C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields228[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RO/V", "rd_buf_ptr", "Pointer to current entry in the data pattern buffers used for generating the read data."},
#else
{24, 27, 0x0000000000000000, "RO/V", "rd_buf_ptr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RO/V", "wr_buf_ptr", "Pointer to current entry in the data pattern buffers used for generating the write data."},
#else
{20, 23, 0x0000000000000000, "RO/V", "wr_buf_ptr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000000, "RW", "buf_end_pntr", "Pointer to last data pattern buffer entry before wrapping back to BUF_STRT_PTR if incrementing is enabled through being different from BUF_STRT_PTR.[br] Note: The actual size of this field depends on the # of lines supported for data generation. i.e If 1 or 2 lines are supported then it is a 1 bit field, if 8 lines are supported then 3 bits are available. Currently the RTL uses internal CPGC buffers so it has 4 lines and requires 2 bits."},
#else
{16, 18, 0x0000000000000000, "RW", "buf_end_pntr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "buf_strt_pntr", "Pointer to first buffer entry.  Also used as the only entry if BUF_INC_EN is not enabled.[br] Note: The actual size of this field depends on the # of lines supported for data generation (DATA_PAT_DEPTH_CAP), i.e If 1 or 2 lines are supported then it is a 1 bit field, if 16 lines are supported then the whole 4 bits are available. Currently the RTL uses internal CPGC buffers so it has 8 lines and requires 3 bits."},
#else
{8, 10, 0x0000000000000000, "RW", "buf_strt_pntr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "buf_pntr_inc_scale", "If set, the buffer pointer will be incremented at a linear rate given by BUF_PTR_INC_RATE, otherwise the buffer pointer will be incremented at an exponential rate given by BUF_PTR_INC_RATE.[br][br]\r\n"
"1=Buffer Pointer Increment Rate field is treated as a linear number.[br][br]\r\n"
"0=Buffer Pointer Increment Rate field is treated is an exponential number."},
#else
{6, 6, 0x0000000000000000, "RW", "buf_pntr_inc_scale", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "buf_pntr_inc_rate", "0: Each buffer entry will be used for 2^BUF_PTR_INC_RATE number of bursts (64Bytes).[br]\r\n"
"1: Each buffer entry will be used for BUF_PTR_INC_RATE + 1 number of 8-UI[br]\r\n"
"-- before incrementing the buffer pointer by 1.[br]\r\n"
" Note:  To disable Buffer Pointer increments, set BUF_END_PTR==BUF_STRT_PTR."},
#else
{0, 5, 0x0000000000000000, "RW", "buf_pntr_inc_rate", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo228[] = {{"CPGC_DPAT_BUF_CTL", "", 0x00000180, 6, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields229[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "reload_lfsr_seed_rate", "Reload_LFSR_Seed_Rate only exists if the LFSR_Save_Restore capability is set to 1.[br][br]\r\n"
"Reload_LFSR_Seed_Rate and Save_LFSR_Seed_Rate is most often used in conjunction with Lane_Rotate_Rate where the user desires to replay the same deterministic LFSR stress as the victim aggressor patterns shifts Lanes left.  When the victim aggressor pattern returns to the starting position the current LFSR stress is saved using Save_LFSR_Seed_Rate to allow the LFSR stress to advance for the new period.[br][br]\r\n"
"2^(Reload_LFSR_Seed_Rate-1) defines the periodic Loopcount interval that the current LFSR Seed UNISEQ#_RDSTAT.Uniseq_RdStat is reloaded from CPGC_UNISEQ#_RDSAVE.Pattern_Buffer.[br][br]\r\n"
"When the Save_LFSR_Seed_Rate and Reload_LFSR_Seed_Rate is reached in the same Bit only the saving of the LFSR seed takes place.[br][br]\r\n"
"Examples:[br][br]\r\n"
"0=Disable - The current LFSR seed is never reloaded.[br][br]\r\n"
"1=The current LFSR seed  is reloaded every Loopcount.[br][br]\r\n"
"2=The current LFSR seed  is reloaded every other Loopcount.[br][br]\r\n"
"3=The current LFSR seed  is reloaded every fourth Loopcount."},
#else
{24, 28, 0x0000000000000000, "RW", "reload_lfsr_seed_rate", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "save_lfsr_seed_rate", "Save_LFSR_Seed_Rate only exists if the LFSR_Save_Restore capability is set to 1.[br][br]\r\n"
"See Reload_LFSR_Seed_Rate for use model.[br][br]\r\n"
"UNISEQ#_RDSAVE.Pattern_Buffer is initially loaded at the start of a test with UNISEQ#_RDSTAT.Uniseq_RdStat (the Seed). [br][br]\r\n"
"2^(Reload_LFSR_Seed_Rate-1) * (Save_LFSR_Seed_Rate) defines the periodic Loopcount interval that the current LFSR Seed is saved into UNISEQ#_RDSAVE.Pattern_Buffer.[br][br]\r\n"
"When the Save_LFSR_Seed_Rate and Reload_LFSR_Seed_Rate is reached in the same Loopcount only the saving of the LFSR seed takes place.[br][br]\r\n"
"Examples:[br][br]\r\n"
"0=Disable - The current LFSR seed (UNISEQ#_RDSTAT.Uniseq_RdStat) is saved only at the start of test into UNISEQ#_RDSAVE.Pattern_Buffer.[br][br]\r\n"
"1=Illegal (Would save every Reload and effectively disable both Save and Reload).[br][br]\r\n"
"2=The current LFSR seed is saved every other 2^(Reload_LFSR_Seed_Rate-1) Loopcounts.[br][br]\r\n"
"3=The current LFSR seed is saved every third Reload (and Reload does not happen)."},
#else
{16, 23, 0x0000000000000000, "RW", "save_lfsr_seed_rate", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RW", "ecc_data_source_sel", "Indicates whether byte 0 (Dq0-Dq7) or byte 7 (dq56-dq63) is transmitted and compared for the ECC byte.[br]\r\n"
"0=byte group 0 will be transmitted and compared for the ECC byte.[br]\r\n"
"1=byte group 7 will be transmitted and compared for the ECC byte.[br]\r\n"
"Hardware directs if ECC is included within Generation and Checking.[br]\r\n"
"This bit may be reserved if ECC is not supported, or if this functionality is controlled from a different register."},
#else
{15, 15, 0x0000000000000000, "RW", "ecc_data_source_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 14, 0x0000000000000000, "RW", "ecc_replace_byte_control", "ECC_Replace_Byte_Control is used by the Read data path to mux the received ECC byte into the same byte group indicated by ECC_Data_Source_Sel.[br]\r\n"
"This is needed to capture ECC cacheline errors into the WDB when Enable_WDB_Error_Capture is set to 1.[br]\r\n"
"This bit may be reserved if ECC is not supported, or if this functionality is controlled from a different register."},
#else
{14, 14, 0x0000000000000000, "RW", "ecc_replace_byte_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 13, 0x0000000000000000, "RW", "ecc_disable", "Setting this bit will internally disable all related ECC features in CPGC having the effect of generating all '1 in the ECC CPGC interface outputs, and of Binding to '0 all the ECC interface CPGC inputs. ECC masks and error comparisons will be disabled as well.[br]\r\n"
"If ECC is supported, but not directly passed to CPGC, then this bit when set will enable the ECC_REPLACE_BYTE_CONTROL and ECC_DATA_SOURCE_SEL functionality, to allow driving of ECC from another ByteLane, and replacing the incoming data with ECC for that ByteLane.[br]\r\n"
"When ECC is disabled with this bit, then the output of CPGC will be determined based on BE_TRAIN_ERR_EN and may output all 1's or the content of the DRAMDM and XDRAMDM registers as Byte-Enables."},
#else
{13, 13, 0x0000000000000000, "RW", "ecc_disable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "read_address_as_data", "When Read_Address_as_Data is set to '1' any address fields that the CADB is overriding during a Select cycle should be used for comparing the incoming data.  Otherwise, the functional path decoded address field should be used for comparing the incoming data.[br]\r\n"
"This override of the data will not respect any inversion, rotation or other data modification. It will only be active (override the normal output/reference) when Alternate_Data is active in either the Command_Instruction or the Offset_Command_Instruction as appropriate .[br]\r\n"
"The functional path decoded address field used for read comparison is repeated in chunk and should follow the Data Construction rules described below on what bytegroup relates to what decoded address:[br][br]\r\n"
"Chunk0 - Byte0 =Column(7:0).[br]\r\n"
"Chunk0 - Byte1 =Column(9:8) <- as many Column bits as supported.[br]\r\n"
"Chunk0 - Byte2 =Row(0:7).[br]\r\n"
"Chunk0 - Byte3 =Row(15:8).[br]\r\n"
"Chunk0 - Byte4 =Row(17:16)<- as many Row bits as supported.[br]\r\n"
"Chunk0 - Byte5 =Bank(3:0)  [Note: Bank Group may be part of this field] <- as many Bank bits as supported.[br]\r\n"
"Chunk0 - Byte6 =Rank(1:0) <- as many Rank bits as supported (would be CS# if CADB output supported).[br]\r\n"
"Chunk0 - Byte7 =Reserved (set to 0).[br]\r\n"
"\r\n"
"Note: Broxton will not support CADB Select cycle information being used for Address-as-data."},
#else
{9, 9, 0x0000000000000000, "RW", "read_address_as_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "write_address_as_data", "When Write_Address_as_Data is set to '1', any address fields that the CADB is overriding during a Select cycle should be used for generating the write data.  Otherwise, the functional path decoded address field should be used for generating the write data.[br]\r\n"
"Data Construction rules follow the same as for READ_ADDRESS_AS_DATA.[br]\r\n"
"\r\n"
"This format is subject to change based on memory technology supported and other reasons and the main HAS documentation should be referenced if required. What is to be guaranteed is that every Cacheline of data will be unique to each address."},
#else
{8, 8, 0x0000000000000000, "RW", "write_address_as_data", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RW", "uniseq2_mode", "Defines the operational mode for unified sequence 2 as follows:[br][br]\r\n"
"00 - LMN Mode.[br][br]\r\n"
"01 - Pattern Buffer Mode.[br][br]\r\n"
"10 - LFSR Mode.[br][br]\r\n"
"11 - Reserved for future use."},
#else
{6, 7, 0x0000000000000000, "RW", "uniseq2_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 4, 0x0000000000000000, "RW", "uniseq1_mode", "Defines the operational mode for unified sequence 1 as follows:[br][br]\r\n"
"00 - LMN Mode.[br][br]\r\n"
"01 - Pattern Buffer Mode.[br][br]\r\n"
"10 - LFSR Mode.[br][br]\r\n"
"11 - Reserved for future use."},
#else
{3, 4, 0x0000000000000000, "RW", "uniseq1_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "uniseq0_mode", "Defines the operational mode for unified sequence 0 as follows:[br][br]\r\n"
"00 - LMN Mode.[br][br]\r\n"
"01 - Pattern Buffer Mode.[br][br]\r\n"
"10 - LFSR Mode.[br][br]\r\n"
"11 - Reserved for future use."},
#else
{0, 1, 0x0000000000000000, "RW", "uniseq0_mode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo229[] = {{"CPGC_DPAT_CFG", "", 0x00000184, 10, 0x000000001FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields230[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 29, 0x0000000000000000, "RW", "lane_rotate_rate", "Lane_Rotate_Rate only exists if the Lane_Rotation_Support capability exists.[br][br]\r\n"
"2^(Lane_Rotate_Rate-1) indicates the periodic Loopcount rate when the EXTBUF_# registers are rotated up by one bit.[br][br]\r\n"
"Lane_Rotate_Rate=0 disables all rotation.[br][br]\r\n"
"Lane_Rotate_Rate=1 causes the EXTBUF_# registers to be rotated every one Loopcount.[br][br]\r\n"
"Lane_Rotate_Rate=2  causes the EXTBUF_# registers to be rotated every other Loopcount.[br][br]\r\n"
"Etc..[br][br]\r\n"
"When the EXTBUF_# registers are rotated Bit 0 shifts to Bit 1 all the way up to the Max-1 Bit and the Max bit shifts to Bit0."},
#else
{24, 29, 0x0000000000000000, "RW", "lane_rotate_rate", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "uniseq2_lfsr_stagger", "0=No Stagger, 1=Stagger.[br][br]\r\n"
"This bit must not be set unless Uniseq2_Mode is programmed to Select LFSR or the behavior is undefined."},
#else
{23, 23, 0x0000000000000000, "RW", "uniseq2_lfsr_stagger", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 20, 0x0000000000000000, "RW", "uniseq2_lfsr_polynomial_size", "Possible Polynomial Sizes:[br][br]\r\n"
"0x0=Use 8 bit LFSR (x8 + x6 + x5 + x4)[br][br]\r\n"
"0x1=Use 15 bit LFSR (x15 + x14)[br][br]\r\n"
"0x2=Use 31 bit LFSR (x31 + x28)[br][br]\r\n"
"0x3=Use 23 bit LFSR (x23 + x18)[br][br]\r\n"
"0x4=Use 7 bit LFSR (x7 + x6)[br][br]\r\n"
"0x5=Use 16 bit LFSR (x16+x5+x4+x3)[br][br]\r\n"
"0x6=Use 23 bit LFSR (x23+x21+x18+x15+x7+x2)[br][br]\r\n"
"0x7=Use 32 bit LFSR (x32+x31+x30+x10)"},
#else
{18, 20, 0x0000000000000000, "RW", "uniseq2_lfsr_polynomial_size", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RW", "uniseq1_lfsr_stagger", "0=No Stagger, 1=Stagger.[br][br]\r\n"
"This bit must not be set unless Uniseq1_Mode is programmed to Select LFSR or the behavior is undefined."},
#else
{15, 15, 0x0000000000000000, "RW", "uniseq1_lfsr_stagger", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 12, 0x0000000000000000, "RW", "uniseq1_lfsr_polynomial_size", "Possible Polynomial Sizes:[br][br]\r\n"
"0x0=Use 8 bit LFSR (x8 + x6 + x5 + x4)[br][br]\r\n"
"0x1=Use 15 bit LFSR (x15 + x14)[br][br]\r\n"
"0x2=Use 31 bit LFSR (x31 + x28)[br][br]\r\n"
"0x3=Use 23 bit LFSR (x23 + x18)[br][br]\r\n"
"0x4=Use 7 bit LFSR (x7 + x6)[br][br]\r\n"
"0x5=Use 16 bit LFSR (x16+x5+x4+x3)[br][br]\r\n"
"0x6=Use 23 bit LFSR (x23+x21+x18+x15+x7+x2)[br][br]\r\n"
"0x7=Use 32 bit LFSR (x32+x31+x30+x10)"},
#else
{10, 12, 0x0000000000000000, "RW", "uniseq1_lfsr_polynomial_size", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "uniseq0_lfsr_stagger", "0=No Stagger, 1=Stagger.[br][br]\r\n"
"This bit must not be set unless Uniseq0_Mode is programmed to Select LFSR or the behavior is undefined."},
#else
{7, 7, 0x0000000000000000, "RW", "uniseq0_lfsr_stagger", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 4, 0x0000000000000000, "RW", "uniseq0_lfsr_polynomial_size", "Possible Polynomial Sizes:[br][br]\r\n"
"0x0=Use 8 bit LFSR (x8 + x6 + x5 + x4)[br][br]\r\n"
"0x1=Use 15 bit LFSR (x15 + x14)[br][br]\r\n"
"0x2=Use 31 bit LFSR (x31 + x28)[br][br]\r\n"
"0x3=Use 23 bit LFSR (x23 + x18)[br][br]\r\n"
"0x4=Use 7 bit LFSR (x7 + x6)[br][br]\r\n"
"0x5=Use 16 bit LFSR (x16+x5+x4+x3)[br][br]\r\n"
"0x6=Use 23 bit LFSR (x23+x21+x18+x15+x7+x2)[br][br]\r\n"
"0x7=Use 32 bit LFSR (x32+x31+x30+x10)"},
#else
{2, 4, 0x0000000000000000, "RW", "uniseq0_lfsr_polynomial_size", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo230[] = {{"CPGC_DPAT_XTRA_LFSR_CFG", "", 0x00000188, 7, 0x000000003FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields231[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000AA55AA55, "RW", "pattern_buffer", "If UniSeq#_Mode is set to Pattern Buffer mode, then this field represents the initial content of the rotating pattern buffer for the unified sequencer. If UniSeq#_Mode is set to LFSR mode, then this field represents the 32-bit LFSR seed for the unified sequencer. Note: This is a shared register, it has a meaning according to the UniSeq# mode.[br]\r\n"
"[b]For PRBS lengths less than or equal to 8, the seed must contain 16 bits of the initial PRBS sequence.[b]"},
#else
{0, 31, 0x00000000AA55AA55, "RW", "pattern_buffer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo231[] = {{"CPGC_DPAT_UNISEQ_0_", "", 0x0000018C, 1, 0x00000000FFFFFFFF, 0x00000000AA55AA55}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields232[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000AA55AA55, "RW", "pattern_buffer", "If UniSeq#_Mode is set to Pattern Buffer mode, then this field represents the initial content of the rotating pattern buffer for the unified sequencer. If UniSeq#_Mode is set to LFSR mode, then this field represents the 32-bit LFSR seed for the unified sequencer. Note: This is a shared register, it has a meaning according to the UniSeq# mode.[br]\r\n"
"[b]For PRBS lengths less than or equal to 8, the seed must contain 16 bits of the initial PRBS sequence.[b]"},
#else
{0, 31, 0x00000000AA55AA55, "RW", "pattern_buffer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo232[] = {{"CPGC_DPAT_UNISEQ_1_", "", 0x00000190, 1, 0x00000000FFFFFFFF, 0x00000000AA55AA55}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields233[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000AA55AA55, "RW", "pattern_buffer", "If UniSeq#_Mode is set to Pattern Buffer mode, then this field represents the initial content of the rotating pattern buffer for the unified sequencer. If UniSeq#_Mode is set to LFSR mode, then this field represents the 32-bit LFSR seed for the unified sequencer. Note: This is a shared register, it has a meaning according to the UniSeq# mode.[br]\r\n"
"[b]For PRBS lengths less than or equal to 8, the seed must contain 16 bits of the initial PRBS sequence.[b]"},
#else
{0, 31, 0x00000000AA55AA55, "RW", "pattern_buffer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo233[] = {{"CPGC_DPAT_UNISEQ_2_", "", 0x00000194, 1, 0x00000000FFFFFFFF, 0x00000000AA55AA55}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields234[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000001, "RW", "n_cnt", "N_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count bits are driven at the beginning of a test then periodic pattern is continuously repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency for exact behavior).[br] If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior)."},
#else
{24, 31, 0x0000000000000001, "RW", "n_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000001, "RW", "m_cnt", "M_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count bits are driven at the beginning of a test then periodic pattern is continuously repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency for exact behavior).[br]If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior)."},
#else
{16, 23, 0x0000000000000001, "RW", "m_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000001, "RW", "l_cnt", "If LMN_Support capability is set to 0 then:[br]A periodic square wave is generated that has the following behavior.[br][br]\r\n"
"1) Drive L_Polarity for L_Count Bits.[br][br]\r\n"
"2) Drive inverse of L_Polarity for L_Count Bits.[br][br]\r\n"
"3) Go to step 1.[br][br]\r\n"
"Else if LMN_Support is set to 1 then:[br][br]\r\n"
"After L_Count bits are driven at the beginning of a test then periodic pattern is continuously repeated depending on the value of Enable_Sweep_Frequency is set to 1.[br][br]\r\n"
"If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency for exact behavior).[br][br]\r\n"
"If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior)."},
#else
{8, 15, 0x0000000000000001, "RW", "l_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "l_counter_hi", "Additional 4 bits to increase the size of L Count up to 12."},
#else
{4, 7, 0x0000000000000000, "RW", "l_counter_hi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "l_count_en", "Used in concatenation with FREQ_SWEEP_EN to enable 3 possible modes of LMN behavior."},
#else
{2, 2, 0x0000000000000000, "RW", "l_count_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "freq_sweep_en", "Used in concatenation with L_COUNT_EN to enable 3 possible modes of LMN behavior:[br][br]\r\n"
"{L_COUNT_EN,FREQ_SWEEP_EN}[br][br]\r\n"
"{0,0} - Normal LMN.[br][br]\r\n"
"{0,1} - Sweep clock pattern from 2*M period down to 2*N_Count period and repeat.[br][br]\r\n"
"{1,0} - L-Counter - drive clock pattern of 2*L period.[br][br]\r\n"
"{1,1} - Currently same as L-Counter mode - reserved for future use.[br][br]\r\n"
"If Normal LMN mode, then the following pattern is continuously repeated:[br][br]\r\n"
"  1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]\r\n"
"  2) Drive M_Count bits with the  inverse of L_Polarity.[br][br]\r\n"
"  3) Drive N_Count bits with the  value of L_Polarity.[br][br]\r\n"
"  4) Go to step 2.[br][br]\r\n"
"If any L_Count, M_Count, or N_Count=0 then the  state will freeze at the polarity driven for that stage.[br][br][br]\r\n"
"If Sweep mode, then the following pattern is continuously repeated:[br][br]\r\n"
"  1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]\r\n"
"  2) X_count=M_Count [br][br]\r\n"
"  3) Drive X_Count bits with the  inverse of L_Polarity.[br][br]\r\n"
"  4) Drive X_Count bits with the  value of L_Polarity.[br][br]\r\n"
"  5) Drive X_Count bits with the  inverse of L_Polarity.[br][br]\r\n"
"  6) If X_Count==N_Count then go to step 9.[br][br]\r\n"
"  7) X_Count=X_Count-1[br][br]\r\n"
"  8) Go to step 10.[br][br]\r\n"
"  9) X_Count=M_Count[br][br]\r\n"
"10) Drive X_Count bits with the  value of L_Polarity.[br][br]\r\n"
"11) Go to step 3.[br][br]\r\n"
"[br]\r\n"
"If LCount mode, then the following pattern is continuously repeated:[br][br]\r\n"
"  1) Drive L_Polarity for L_Count Bits.[br][br]\r\n"
"  2) Drive inverse of L_Polarity for L_Count Bits.[br][br]\r\n"
"  3) Go to step 1.[br][br]\r\n"
"  [br][br]\r\n"
"If {0,1}, L_Count, M_Count, and N_Count must never be programmed to 0 and is considered undefined.[br][br]\r\n"
"If {1,0}, L_Count must never be programmed to 0 and is considered undefined.[br][br]\r\n"
"If {0,1}, M_Count and N_Count must be greater than or equal to 8 or behavior may be implementation specific.[br][br]\r\n"
"If {0,1}, N_Count must be programmed less than M_Count."},
#else
{1, 1, 0x0000000000000000, "RW", "freq_sweep_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "l_sel", "The initial logic output of the sequencer is defined as follows:[br][br]\r\n"
"                        0 - Output Logic '0' for L_CNT UIs.[br][br]\r\n"
"                        1 - Output Logic '1' for L_CNT UIs."},
#else
{0, 0, 0x0000000000000000, "RW", "l_sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo234[] = {{"CPGC_DPAT_UNISEQ_LMN_0_", "", 0x00000198, 7, 0x00000000FFFFFFFF, 0x0000000001010100}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields235[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000001, "RW", "n_cnt", "N_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count bits are driven at the beginning of a test then periodic pattern is continuously repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency for exact behavior).[br] If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior)."},
#else
{24, 31, 0x0000000000000001, "RW", "n_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000001, "RW", "m_cnt", "M_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count bits are driven at the beginning of a test then periodic pattern is continuously repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency for exact behavior).[br]If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior)."},
#else
{16, 23, 0x0000000000000001, "RW", "m_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000001, "RW", "l_cnt", "If LMN_Support capability is set to 0 then:[br]A periodic square wave is generated that has the following behavior.[br][br]\r\n"
"1) Drive L_Polarity for L_Count Bits.[br][br]\r\n"
"2) Drive inverse of L_Polarity for L_Count Bits.[br][br]\r\n"
"3) Go to step 1.[br][br]\r\n"
"Else if LMN_Support is set to 1 then:[br][br]\r\n"
"After L_Count bits are driven at the beginning of a test then periodic pattern is continuously repeated depending on the value of Enable_Sweep_Frequency is set to 1.[br][br]\r\n"
"If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency for exact behavior).[br][br]\r\n"
"If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior)."},
#else
{8, 15, 0x0000000000000001, "RW", "l_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "l_counter_hi", "Additional 4 bits to increase the size of L Count up to 12."},
#else
{4, 7, 0x0000000000000000, "RW", "l_counter_hi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "l_count_en", "Used in concatenation with FREQ_SWEEP_EN to enable 3 possible modes of LMN behavior."},
#else
{2, 2, 0x0000000000000000, "RW", "l_count_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "freq_sweep_en", "Used in concatenation with L_COUNT_EN to enable 3 possible modes of LMN behavior:[br][br]\r\n"
"{L_COUNT_EN,FREQ_SWEEP_EN}[br][br]\r\n"
"{0,0} - Normal LMN.[br][br]\r\n"
"{0,1} - Sweep clock pattern from 2*M period down to 2*N_Count period and repeat.[br][br]\r\n"
"{1,0} - L-Counter - drive clock pattern of 2*L period.[br][br]\r\n"
"{1,1} - Currently same as L-Counter mode - reserved for future use.[br][br]\r\n"
"If Normal LMN mode, then the following pattern is continuously repeated:[br][br]\r\n"
"  1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]\r\n"
"  2) Drive M_Count bits with the  inverse of L_Polarity.[br][br]\r\n"
"  3) Drive N_Count bits with the  value of L_Polarity.[br][br]\r\n"
"  4) Go to step 2.[br][br]\r\n"
"If any L_Count, M_Count, or N_Count=0 then the  state will freeze at the polarity driven for that stage.[br][br][br]\r\n"
"If Sweep mode, then the following pattern is continuously repeated:[br][br]\r\n"
"  1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]\r\n"
"  2) X_count=M_Count [br][br]\r\n"
"  3) Drive X_Count bits with the  inverse of L_Polarity.[br][br]\r\n"
"  4) Drive X_Count bits with the  value of L_Polarity.[br][br]\r\n"
"  5) Drive X_Count bits with the  inverse of L_Polarity.[br][br]\r\n"
"  6) If X_Count==N_Count then go to step 9.[br][br]\r\n"
"  7) X_Count=X_Count-1[br][br]\r\n"
"  8) Go to step 10.[br][br]\r\n"
"  9) X_Count=M_Count[br][br]\r\n"
"10) Drive X_Count bits with the  value of L_Polarity.[br][br]\r\n"
"11) Go to step 3.[br][br]\r\n"
"[br]\r\n"
"If LCount mode, then the following pattern is continuously repeated:[br][br]\r\n"
"  1) Drive L_Polarity for L_Count Bits.[br][br]\r\n"
"  2) Drive inverse of L_Polarity for L_Count Bits.[br][br]\r\n"
"  3) Go to step 1.[br][br]\r\n"
"  [br][br]\r\n"
"If {0,1}, L_Count, M_Count, and N_Count must never be programmed to 0 and is considered undefined.[br][br]\r\n"
"If {1,0}, L_Count must never be programmed to 0 and is considered undefined.[br][br]\r\n"
"If {0,1}, M_Count and N_Count must be greater than or equal to 8 or behavior may be implementation specific.[br][br]\r\n"
"If {0,1}, N_Count must be programmed less than M_Count."},
#else
{1, 1, 0x0000000000000000, "RW", "freq_sweep_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "l_sel", "The initial logic output of the sequencer is defined as follows:[br][br]\r\n"
"                        0 - Output Logic '0' for L_CNT UIs.[br][br]\r\n"
"                        1 - Output Logic '1' for L_CNT UIs."},
#else
{0, 0, 0x0000000000000000, "RW", "l_sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo235[] = {{"CPGC_DPAT_UNISEQ_LMN_1_", "", 0x0000019C, 7, 0x00000000FFFFFFFF, 0x0000000001010100}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields236[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000001, "RW", "n_cnt", "N_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count bits are driven at the beginning of a test then periodic pattern is continuously repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency for exact behavior).[br] If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior)."},
#else
{24, 31, 0x0000000000000001, "RW", "n_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000001, "RW", "m_cnt", "M_Count only exists if  LMN_Support capability is set to 1.[br] After L_Count bits are driven at the beginning of a test then periodic pattern is continuously repeated depending on the value of Enable_Sweep_Frequency.[br] If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency for exact behavior).[br]If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior)."},
#else
{16, 23, 0x0000000000000001, "RW", "m_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000001, "RW", "l_cnt", "If LMN_Support capability is set to 0 then:[br]A periodic square wave is generated that has the following behavior.[br][br]\r\n"
"1) Drive L_Polarity for L_Count Bits.[br][br]\r\n"
"2) Drive inverse of L_Polarity for L_Count Bits.[br][br]\r\n"
"3) Go to step 1.[br][br]\r\n"
"Else if LMN_Support is set to 1 then:[br][br]\r\n"
"After L_Count bits are driven at the beginning of a test then periodic pattern is continuously repeated depending on the value of Enable_Sweep_Frequency is set to 1.[br][br]\r\n"
"If Enable_Sweep_Frequency=0 then a steady state frequency is driven (see Enable_Sweep_Frequency for exact behavior).[br][br]\r\n"
"If Enable_Sweep_Frequency=1 then a frequency sweep is continuously generated ranging from 2*(M) to 2*(N) driven (see Enable_Sweep_Frequency for exact behavior)."},
#else
{8, 15, 0x0000000000000001, "RW", "l_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "l_counter_hi", "Additional 4 bits to increase the size of L Count up to 12."},
#else
{4, 7, 0x0000000000000000, "RW", "l_counter_hi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "l_count_en", "Used in concatenation with FREQ_SWEEP_EN to enable 3 possible modes of LMN behavior."},
#else
{2, 2, 0x0000000000000000, "RW", "l_count_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "freq_sweep_en", "Used in concatenation with L_COUNT_EN to enable 3 possible modes of LMN behavior:[br][br]\r\n"
"{L_COUNT_EN,FREQ_SWEEP_EN}[br][br]\r\n"
"{0,0} - Normal LMN.[br][br]\r\n"
"{0,1} - Sweep clock pattern from 2*M period down to 2*N_Count period and repeat.[br][br]\r\n"
"{1,0} - L-Counter - drive clock pattern of 2*L period.[br][br]\r\n"
"{1,1} - Currently same as L-Counter mode - reserved for future use.[br][br]\r\n"
"If Normal LMN mode, then the following pattern is continuously repeated:[br][br]\r\n"
"  1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]\r\n"
"  2) Drive M_Count bits with the  inverse of L_Polarity.[br][br]\r\n"
"  3) Drive N_Count bits with the  value of L_Polarity.[br][br]\r\n"
"  4) Go to step 2.[br][br]\r\n"
"If any L_Count, M_Count, or N_Count=0 then the  state will freeze at the polarity driven for that stage.[br][br][br]\r\n"
"If Sweep mode, then the following pattern is continuously repeated:[br][br]\r\n"
"  1) Drive L_Count bits with the  polarity set by L_Polarity.[br][br]\r\n"
"  2) X_count=M_Count [br][br]\r\n"
"  3) Drive X_Count bits with the  inverse of L_Polarity.[br][br]\r\n"
"  4) Drive X_Count bits with the  value of L_Polarity.[br][br]\r\n"
"  5) Drive X_Count bits with the  inverse of L_Polarity.[br][br]\r\n"
"  6) If X_Count==N_Count then go to step 9.[br][br]\r\n"
"  7) X_Count=X_Count-1[br][br]\r\n"
"  8) Go to step 10.[br][br]\r\n"
"  9) X_Count=M_Count[br][br]\r\n"
"10) Drive X_Count bits with the  value of L_Polarity.[br][br]\r\n"
"11) Go to step 3.[br][br]\r\n"
"[br]\r\n"
"If LCount mode, then the following pattern is continuously repeated:[br][br]\r\n"
"  1) Drive L_Polarity for L_Count Bits.[br][br]\r\n"
"  2) Drive inverse of L_Polarity for L_Count Bits.[br][br]\r\n"
"  3) Go to step 1.[br][br]\r\n"
"  [br][br]\r\n"
"If {0,1}, L_Count, M_Count, and N_Count must never be programmed to 0 and is considered undefined.[br][br]\r\n"
"If {1,0}, L_Count must never be programmed to 0 and is considered undefined.[br][br]\r\n"
"If {0,1}, M_Count and N_Count must be greater than or equal to 8 or behavior may be implementation specific.[br][br]\r\n"
"If {0,1}, N_Count must be programmed less than M_Count."},
#else
{1, 1, 0x0000000000000000, "RW", "freq_sweep_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "l_sel", "The initial logic output of the sequencer is defined as follows:[br][br]\r\n"
"                        0 - Output Logic '0' for L_CNT UIs.[br][br]\r\n"
"                        1 - Output Logic '1' for L_CNT UIs."},
#else
{0, 0, 0x0000000000000000, "RW", "l_sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo236[] = {{"CPGC_DPAT_UNISEQ_LMN_2_", "", 0x000001A0, 7, 0x00000000FFFFFFFF, 0x0000000001010100}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields237[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "mask_rotate_en", "If set, the inversion/DC mask will rotate to the left at a rate defined by the MASK_ROTATE_RATE field."},
#else
{31, 31, 0x0000000000000000, "RW", "mask_rotate_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "dc_or_inv", "Selects between using the inversion/DC mask for inversion or DC as follows:[br][br]\r\n"
"0 - Mask used for inversion.[br][br]\r\n"
"1 - Mask used for driving a DC signal of polarity DC_POL."},
#else
{30, 30, 0x0000000000000000, "RW", "dc_or_inv", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW", "dc_pol", "Selects the polarity of the signal to be driven through the inversion/DC mask if DC_OR_INV is set to 1:[br][br]\r\n"
"0 - Drive a logic low (zero).[br][br]\r\n"
"1 - Drive a logic high (one)."},
#else
{29, 29, 0x0000000000000000, "RW", "dc_pol", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 24, 0x00000000000000AA, "RW", "bytegroup_mapping", "Select between the two bytes of unique lanes being generated by the DPAT pattern generator, to be applied in each DQ byte group, as many byte groups as required by the number of DQ pins.  MSB is always for the ECC byte group, used only if ECC is present."},
#else
{16, 24, 0x00000000000000AA, "RW", "bytegroup_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "mask_rotate_rate", "If inversion mask rotation is enabled through MASK_ROTATE_EN, the mask will rotate to the left every time 2^MASK_ROTATE_RATE bursts (64Bytes) have been have been issued."},
#else
{8, 11, 0x0000000000000000, "RW", "mask_rotate_rate", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "ecc_inv_dc_mask", "A value of  for any of the bits means the corresponding ECC lane(s) will be inverted or a DC value driven on it.  Note that this field is used to load bits [71:64] of the continuous shift register composed of this field along with DATA_INV_DC_MASK_HI and DATA_INV_DC_MASK_LO.   Note: this field is only available if ECC is supported for the current implementation, otherwise it is reserved."},
#else
{0, 7, 0x0000000000000000, "RW", "ecc_inv_dc_mask", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo237[] = {{"CPGC_DPAT_INVDCCTL", "", 0x000001A4, 6, 0x00000000FFFFFFFF, 0x0000000000AA0000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields238[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data_inv_dc_mask_lo", "A value of '1' for any of the bits means the corresponding data lane(s) will be inverted or a DC value driven on it. Note that this field is used to load bits [31:0] of the continuous shift register composed of this field along with ECC_INV_DC_MASK and DATA_INV_DC_MASK_HI.[br]\r\n"
"DPAT generator only uses the appropriate bits based on the widest bus that this CPGC block is designed to support.[br]\r\n"
"This register is also used to provide the Initial value for the Alternate Data pattern generator."},
#else
{0, 31, 0x0000000000000000, "RW", "data_inv_dc_mask_lo", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo238[] = {{"CPGC_DPAT_INV_DC_MASK_LO", "", 0x000001A8, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields239[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data_inv_dc_mask_hi", "A value of '1' for any of the bits means the corresponding data lane(s) will be inverted or a DC value driven on it. Note that this field is used to load bits [63:32] of the continuous shift register composed of this field along with ECC_INV_DC_MASK and DATA_INV_DC_MASK_LO."},
#else
{0, 31, 0x0000000000000000, "RW", "data_inv_dc_mask_hi", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo239[] = {{"CPGC_DPAT_INV_DC_MASK_HI", "", 0x000001AC, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields240[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000FFFFFFFF, "RW", "data_mask_lo", "A byte enable field with each bit corresponding to a data byte sent during a burst such that:[br]\r\n"
"0 - Mask the Corresponding Byte.[br]\r\n"
"1 - No Mask to the Corresponding Byte.[br]\r\n"
"The byte-to-bit mapping is given by Byte[n] -> bit[n].[br]\r\n"
"This register is for the first half cacheline of data.[br]\r\n"
"It is only used when ECC is not present or is disabled."},
#else
{0, 31, 0x00000000FFFFFFFF, "RW", "data_mask_lo", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo240[] = {{"CPGC_DPAT_DRAMDM", "", 0x000001B0, 1, 0x00000000FFFFFFFF, 0x00000000FFFFFFFF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields241[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000FFFFFFFF, "RW", "data_mask_hi", "A byte enable field with each bit corresponding to a data byte sent during a burst such that:[br]\r\n"
"0 - Mask the Corresponding Byte.[br]\r\n"
"1 - No Mask to the Corresponding Byte.[br]\r\n"
"The byte-to-bit mapping is given by Byte[n+32] -> bit[n].[br]\r\n"
"This register is for the Second half cacheline of data.[br]\r\n"
"It is only used when ECC is not present or is disabled."},
#else
{0, 31, 0x00000000FFFFFFFF, "RW", "data_mask_hi", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo241[] = {{"CPGC_DPAT_XDRAMDM", "", 0x000001B4, 1, 0x00000000FFFFFFFF, 0x00000000FFFFFFFF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields242[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "uniseq_wrstat", "The current contents of the Pattern/LFSR buffer in write generation domain."},
#else
{0, 31, 0x0000000000000000, "RO/V", "uniseq_wrstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo242[] = {{"CPGC_DPAT_UNISEQ_WRSTAT_0_", "", 0x000001B8, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields243[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "uniseq_wrstat", "The current contents of the Pattern/LFSR buffer in write generation domain."},
#else
{0, 31, 0x0000000000000000, "RO/V", "uniseq_wrstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo243[] = {{"CPGC_DPAT_UNISEQ_WRSTAT_1_", "", 0x000001BC, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields244[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "uniseq_wrstat", "The current contents of the Pattern/LFSR buffer in write generation domain."},
#else
{0, 31, 0x0000000000000000, "RO/V", "uniseq_wrstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo244[] = {{"CPGC_DPAT_UNISEQ_WRSTAT_2_", "", 0x000001C0, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields245[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000DEADBEEF, "RO/V", "uniseq_rdstat", "Reflects the current and final status of the pattern buffer in the read domain.[br]\r\n"
"If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in serial fashion.   After all the bits in the Pattern_Buffer have been transmitted the  pattern will simply repeat itself continuously while a Loopback Test is in progress.[br][br]\r\n"
"If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output in serial fashion.  Over time the LFSR pattern will repeat itself continuously while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer will interact with the LFSR in the following ways:[br][br]\r\n"
"If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]\r\n"
"1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]\r\n"
"2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details)."},
#else
{0, 31, 0x00000000DEADBEEF, "RO/V", "uniseq_rdstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo245[] = {{"CPGC_DPAT_UNISEQ_RDSTAT_0_", "", 0x000001C4, 1, 0x00000000FFFFFFFF, 0x00000000DEADBEEF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields246[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000DEADBEEF, "RO/V", "uniseq_rdstat", "Reflects the current and final status of the pattern buffer in the read domain.[br]\r\n"
"If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in serial fashion.   After all the bits in the Pattern_Buffer have been transmitted the  pattern will simply repeat itself continuously while a Loopback Test is in progress.[br][br]\r\n"
"If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output in serial fashion.  Over time the LFSR pattern will repeat itself continuously while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer will interact with the LFSR in the following ways:[br][br]\r\n"
"If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]\r\n"
"1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]\r\n"
"2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details)."},
#else
{0, 31, 0x00000000DEADBEEF, "RO/V", "uniseq_rdstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo246[] = {{"CPGC_DPAT_UNISEQ_RDSTAT_1_", "", 0x000001C8, 1, 0x00000000FFFFFFFF, 0x00000000DEADBEEF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields247[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000DEADBEEF, "RO/V", "uniseq_rdstat", "Reflects the current and final status of the pattern buffer in the read domain.[br]\r\n"
"If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in serial fashion.   After all the bits in the Pattern_Buffer have been transmitted the  pattern will simply repeat itself continuously while a Loopback Test is in progress.[br][br]\r\n"
"If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output in serial fashion.  Over time the LFSR pattern will repeat itself continuously while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer will interact with the LFSR in the following ways:[br][br]\r\n"
"If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]\r\n"
"1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]\r\n"
"2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details)."},
#else
{0, 31, 0x00000000DEADBEEF, "RO/V", "uniseq_rdstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo247[] = {{"CPGC_DPAT_UNISEQ_RDSTAT_2_", "", 0x000001CC, 1, 0x00000000FFFFFFFF, 0x00000000DEADBEEF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields248[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "lmn_wrstat", "The current contents of the LMN buffer in write comparison domain."},
#else
{0, 31, 0x0000000000000000, "RO/V", "lmn_wrstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo248[] = {{"CPGC_DPAT_LMN_WRSTAT_0_", "", 0x000001D0, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields249[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "lmn_wrstat", "The current contents of the LMN buffer in write comparison domain."},
#else
{0, 31, 0x0000000000000000, "RO/V", "lmn_wrstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo249[] = {{"CPGC_DPAT_LMN_WRSTAT_1_", "", 0x000001D4, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields250[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "lmn_wrstat", "The current contents of the LMN buffer in write comparison domain."},
#else
{0, 31, 0x0000000000000000, "RO/V", "lmn_wrstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo250[] = {{"CPGC_DPAT_LMN_WRSTAT_2_", "", 0x000001D8, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields251[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000DEADBEEF, "RO/V", "lmn_rdstat", "The current contents of the LMN buffer in read comparison domain."},
#else
{0, 31, 0x00000000DEADBEEF, "RO/V", "lmn_rdstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo251[] = {{"CPGC_DPAT_LMN_RDSTAT_0_", "", 0x000001DC, 1, 0x00000000FFFFFFFF, 0x00000000DEADBEEF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields252[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000DEADBEEF, "RO/V", "lmn_rdstat", "The current contents of the LMN buffer in read comparison domain."},
#else
{0, 31, 0x00000000DEADBEEF, "RO/V", "lmn_rdstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo252[] = {{"CPGC_DPAT_LMN_RDSTAT_1_", "", 0x000001E0, 1, 0x00000000FFFFFFFF, 0x00000000DEADBEEF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields253[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000DEADBEEF, "RO/V", "lmn_rdstat", "The current contents of the LMN buffer in read comparison domain."},
#else
{0, 31, 0x00000000DEADBEEF, "RO/V", "lmn_rdstat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo253[] = {{"CPGC_DPAT_LMN_RDSTAT_2_", "", 0x000001E4, 1, 0x00000000FFFFFFFF, 0x00000000DEADBEEF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields254[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000DEADBEEF, "RO/V", "pattern_buffer", "The current contents of the Save register before the test stops in the write domain."},
#else
{0, 31, 0x00000000DEADBEEF, "RO/V", "pattern_buffer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo254[] = {{"CPGC_DPAT_UNISEQ_WRSAVE_0_", "", 0x000001E8, 1, 0x00000000FFFFFFFF, 0x00000000DEADBEEF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields255[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000DEADBEEF, "RO/V", "pattern_buffer", "The current contents of the Save register before the test stops in the write domain."},
#else
{0, 31, 0x00000000DEADBEEF, "RO/V", "pattern_buffer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo255[] = {{"CPGC_DPAT_UNISEQ_WRSAVE_1_", "", 0x000001EC, 1, 0x00000000FFFFFFFF, 0x00000000DEADBEEF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields256[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x00000000DEADBEEF, "RO/V", "pattern_buffer", "The current contents of the Save register before the test stops in the write domain."},
#else
{0, 31, 0x00000000DEADBEEF, "RO/V", "pattern_buffer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo256[] = {{"CPGC_DPAT_UNISEQ_WRSAVE_2_", "", 0x000001F0, 1, 0x00000000FFFFFFFF, 0x00000000DEADBEEF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields257[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "pattern_buffer", "CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer will reflect either the initial or last saved value of CPGC_UNISEQ#_RDSTAT.[br][br]\r\n"
"If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in serial fashion.  After all the bits in the Pattern_Buffer have been transmitted the  pattern will simply repeat itself continuously while a Loopback Test is in progress.[br][br]\r\n"
"If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output in serial fashion.  Over time the LFSR pattern will repeat itself continuously while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer will interact with the LFSR in the following ways:[br][br]\r\n"
"If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]\r\n"
"1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]\r\n"
"2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details)."},
#else
{0, 31, 0x0000000000000000, "RO/V", "pattern_buffer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo257[] = {{"CPGC_DPAT_UNISEQ_RDSAVE_0_", "", 0x000001F4, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields258[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "pattern_buffer", "CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer will reflect either the initial or last saved value of CPGC_UNISEQ#_RDSTAT.[br][br]\r\n"
"If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in serial fashion.  After all the bits in the Pattern_Buffer have been transmitted the  pattern will simply repeat itself continuously while a Loopback Test is in progress.[br][br]\r\n"
"If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output in serial fashion.  Over time the LFSR pattern will repeat itself continuously while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer will interact with the LFSR in the following ways:[br][br]\r\n"
"If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]\r\n"
"1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]\r\n"
"2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details)."},
#else
{0, 31, 0x0000000000000000, "RO/V", "pattern_buffer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo258[] = {{"CPGC_DPAT_UNISEQ_RDSAVE_1_", "", 0x000001F8, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields259[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V", "pattern_buffer", "CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer will reflect either the initial or last saved value of CPGC_UNISEQ#_RDSTAT.[br][br]\r\n"
"If PATBUF mode, then Pattern_Buffer is used as a fixed buffer that is output in serial fashion.  After all the bits in the Pattern_Buffer have been transmitted the  pattern will simply repeat itself continuously while a Loopback Test is in progress.[br][br]\r\n"
"If LFSR mode, then Pattern_Buffer is used as a seed to a fixed LFSR that is output in serial fashion.  Over time the LFSR pattern will repeat itself continuously while a Loopback Test is in progress. In LFSR Mode the contents of Pattern_Buffer will interact with the LFSR in the following ways:[br][br]\r\n"
"If LFSR_Save_Restore is set then CPGC_REG_DPAT_UNISEQ_WRSAVE.Pattern_Buffer will interact with CPGC_UNISEQ#_RDSTAT in the following ways:[br][br]\r\n"
"1) CPGC_UNISEQ#_RDSTAT will be periodically saved into CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Save_LFSR_Seed_Rate (see Save_LFSR_Seed_Rate for more details).[br][br]\r\n"
"2) CPGC_UNISEQ#_RDSTAT will be periodically reloaded with CPGC_REG_DPAT_UNISEQ#_RDSAVE.Pattern_Buffer based on Reload_LFSR_Seed_Rate (see Reload_LFSR_Seed_Rate for more details)."},
#else
{0, 31, 0x0000000000000000, "RO/V", "pattern_buffer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo259[] = {{"CPGC_DPAT_UNISEQ_RDSAVE_2_", "", 0x000001FC, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields260[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo260[] = {{"CPGC_DPAT_EXTBUF_0_", "", 0x00000200, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields261[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo261[] = {{"CPGC_DPAT_EXTBUF_1_", "", 0x00000204, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields262[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo262[] = {{"CPGC_DPAT_EXTBUF_2_", "", 0x00000208, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields263[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo263[] = {{"CPGC_DPAT_EXTBUF_3_", "", 0x0000020C, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields264[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo264[] = {{"CPGC_DPAT_EXTBUF_4_", "", 0x00000210, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields265[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo265[] = {{"CPGC_DPAT_EXTBUF_5_", "", 0x00000214, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields266[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo266[] = {{"CPGC_DPAT_EXTBUF_6_", "", 0x00000218, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields267[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo267[] = {{"CPGC_DPAT_EXTBUF_7_", "", 0x0000021C, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields268[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo268[] = {{"CPGC_DPAT_EXTBUF_8_", "", 0x00000220, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields269[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo269[] = {{"CPGC_DPAT_EXTBUF_9_", "", 0x00000224, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields270[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo270[] = {{"CPGC_DPAT_EXTBUF_10_", "", 0x00000228, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields271[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo271[] = {{"CPGC_DPAT_EXTBUF_11_", "", 0x0000022C, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields272[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo272[] = {{"CPGC_DPAT_EXTBUF_12_", "", 0x00000230, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields273[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo273[] = {{"CPGC_DPAT_EXTBUF_13_", "", 0x00000234, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields274[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo274[] = {{"CPGC_DPAT_EXTBUF_14_", "", 0x00000238, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields275[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x00000000000000AA, "RW", "data_line3", "Contents of Pattern Buffer for Cache Line 3.[br]\r\n"
"EXTBUF[0] corresponds to Lane 0 (32 UI of data maximum).[br]\r\n"
"EXTBUF[1] corresponds to Lane 1 (32 UI of data maximum).[br]\r\n"
".....[br]\r\n"
"EXTBUF[15] corresponds to Lane 15.[br]\r\n"
"These 16 lanes are replicated across the number of active DQ lanes on the memory interface."},
#else
{24, 31, 0x00000000000000AA, "RW", "data_line3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x00000000000000AA, "RW", "data_line2", "Contents of Pattern Buffer for Cache Line 2.[br]\r\n"
"Line 2 (and same for Lines 3..0) refers to the 8-UI partial cache line as pointed to current status at CPGC_DPAT_BUF_CTL.[br]\r\n"
"This advancement is controlled by CPGC_DPAT_BUF_CTL."},
#else
{16, 23, 0x00000000000000AA, "RW", "data_line2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x00000000000000AA, "RW", "data_line1", "Contents of Pattern Buffer  for Cache Line 1."},
#else
{8, 15, 0x00000000000000AA, "RW", "data_line1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000AA, "RW", "data_line0", "Contents of Pattern Buffer  for Cache Line 0."},
#else
{0, 7, 0x00000000000000AA, "RW", "data_line0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo275[] = {{"CPGC_DPAT_EXTBUF_15_", "", 0x0000023C, 4, 0x00000000FFFFFFFF, 0x00000000AAAAAAAA}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields276[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RW/P", "errchk_mask_cacheline", "Defines a periodic burst mask that repeats every 64Bytes of data as follows:[br]\r\n"
"Bit 0 - Burst 0[br]\r\n"
"Bit 1 - Burst 1[br]\r\n"
"...[br]\r\n"
"Bit 7 - Burst 7[br]\r\n"
"Only bursts with a corresponding bit value of '1' will be checked for errors. A burst is defined as a burst length of 64 bytes of data.[br]\r\n"
"In Loopback each bit of this register controls the check of each ByteTime (8-bits) on the bus."},
#else
{24, 31, 0x0000000000000000, "RW/P", "errchk_mask_cacheline", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW/P", "errchk_mask_chunk", "Defines which chunk within the burst of data (i.e. bit within a burst of 8-bits for each lane) to check for errors.[br]\r\n"
"Only chunks with a corresponding bit value of '0' will be checked for errors.[br]\r\n"
"This field is only used for full width (64bit) DQ busses. Otherwise the upper 32 bits of the Lane Mask is used as the Chunk Enable.[br]\r\n"
"This field is also used for Loopback mode for all DQ sizes."},
#else
{16, 23, 0x0000000000000000, "RW/P", "errchk_mask_chunk", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW/P", "stop_on_error_ctl", "Defines test stop conditions based on error checking as follows:[br]\r\n"
"00 - Never stop: Prevents any error from stopping the test.[br]\r\n"
"01 - Stop On Nth Error: Stop once STOP_ERR_CNTR has accumulated at least (STOP_ON_N + 1) errors.[br]\r\n"
"10 - Stop On All Byte Groups Error:  Stop if every byte group indicates that at least one of its lanes accumulated at least one error.[br]\r\n"
"That is, if all bits BYTEGRP_ERR_STAT, (and ECC_GRP_ERR_STAT if supported), are all set.[br]\r\n"
"11 - Stop On All Lanes Error:  Stop if every lane within every byte group has accumulated at least one error.[br]\r\n"
"That is, if all bits in LANE_ERR_STAT_LO, LANE_ERR_STAT_HI, (and LANE_ERR_STATECC if supported) are all set."},
#else
{12, 13, 0x0000000000000000, "RW/P", "stop_on_error_ctl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW/P", "be_train_err_en", "Enable BE Training Error Detection Feature.  Note this bit overrides the BE_TRAIN_ERR_EN bit in CPGC2_ALGORITHM_INSTRUCTION_CTRL."},
#else
{8, 8, 0x0000000000000000, "RW/P", "be_train_err_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW/P", "stop_on_n", "If STOP_ON_ERROR is set to Stop on Nth Error Mode, the test will stop after (STOP_ON_N + 1) or more errors have been accumulated in the ERR_CNTR."},
#else
{0, 5, 0x0000000000000000, "RW/P", "stop_on_n", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo276[] = {{"CPGC_ERR_CTL", "", 0x00000240, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields277[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW/P", "data_errchk_mask_lo", "A mask used to disable error checking on data lanes [31:0].  Lanes selected through this mask will not be checked for errors. The lane-to-bit mapping for this mask is given by the following formula: Lane[n] -> bit[n].[br]\r\n"
"Functionality will change with special mapping when buswidth is < 64 (or 72) such that ChunkMask will move to this field starting at bit [...:32] extending the necessary number of bits for a full cache line of data. The mask in ERR_CTL will be unused for these busses/modes."},
#else
{0, 31, 0x0000000000000000, "RW/P", "data_errchk_mask_lo", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo277[] = {{"CPGC_ERR_LNEN_LO", "", 0x00000244, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields278[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW/P", "data_errchk_mask_hi", "A mask used to disable error checking on data lanes [63:32].  Lanes selected through this mask will not be checked for errors. The lane-to-bit mapping for this mask is given by the following formula: Lane[n+32] -> bit[n].[br]\r\n"
"Functionality will change with special mapping when buswidth is < 64 (or 72) such that ChunkMask will move to this field starting at bit [...:32] extending the necessary number of bits for a full cache line of data. The mask in ERR_CTL will be unused for these busses/modes."},
#else
{0, 31, 0x0000000000000000, "RW/P", "data_errchk_mask_hi", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo278[] = {{"CPGC_ERR_LNEN_HI", "", 0x00000248, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields279[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x00000000000000FF, "RW/P", "ecc_errchk_mask", "A mask used to disable error checking on ECC lanes.  Lanes selected through the mask will not be checked for errors. The lane-to-bit mapping is 1-to-1 and hence bit 1 corresponds to ECC lane 0, bit 1 corresponds to ECC lane 1, and so on.[br]\r\n"
"Note: This field is available only if ECC is supported. The default state is to disable ECC checking."},
#else
{0, 7, 0x00000000000000FF, "RW/P", "ecc_errchk_mask", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo279[] = {{"CPGC_ERR_XLNEN", "", 0x0000024C, 1, 0x00000000000000FF, 0x00000000000000FF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields280[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "lane_err_stat_lo", "Indicates if a mismatch was detected between the WR and the RD data on one of the lanes belonging to byte groups 0 - 3.  Hence lanes [32:0] map to bits [32:0] respectively.  The error status information is encoded as follows:[br]\r\n"
"0: No mismatches detected on corresponding lane.[br]\r\n"
"1: At least one mismatch detected on corresponding lane.[br]\r\n"
"Cleared on Local Clear Errors."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "lane_err_stat_lo", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo280[] = {{"CPGC_ERR_STAT03", "", 0x00000250, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields281[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "lane_err_stat_hi", "Indicates if a mismatch was detected between the WR and the RD data on one of the lanes belonging to byte groups 4 - 7.  Hence lanes [63:32] map to bits [32:0] respectively.[br]\r\n"
"If there are less than 32 data lanes, then this register is used to indicate the Extended Chunk Error Status, and the Chunk Error Status in ECC_CHNK_RANK_STAT is not used. Chunks 0 through 15 (32-bit bus) or 0 through 31 (16-bit bus).[br]\r\n"
"The error status information is encoded as follows:[br]\r\n"
"0: No mismatches detected on corresponding lane (chunk).[br]\r\n"
"1: At least one mismatch detected on corresponding lane (chunk).[br]\r\n"
"Cleared on Local Clear Errors."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "lane_err_stat_hi", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo281[] = {{"CPGC_ERR_STAT47", "", 0x00000254, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields282[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RO/V/P", "rank_err_stat", "A status field where each bit corresponds to a specific rank. If set, the corresponding rank has accumulated at least one error.[br]\r\n"
"Cleared on Local Clear Errors."},
#else
{16, 19, 0x0000000000000000, "RO/V/P", "rank_err_stat", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RO/V/P", "chunk_err_stat", "A flag field where each bit corresponds to a specific chunk (i.e. bit within a burst of 8-bits). If set, the corresponding chunk (UI) has accumulated at least one error.[br]\r\n"
"Cleared on Local Clear Errors."},
#else
{8, 15, 0x0000000000000000, "RO/V/P", "chunk_err_stat", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RO/V/P", "ecc_lane_err_stat", "A fag field which indicates if a mismatch was detected between the WR and the RD data on one of the lanes belonging to the ECC byte group.  The error status information is encoded as follows:[br]\r\n"
"0: No mismatches detected on corresponding lane.[br]\r\n"
"1: At least one mismatch detected on corresponding lane.[br]\r\n"
"Note: this field is only available if ECC is supported for the current implementation, otherwise it is reserved.[br]\r\n"
"If BE Training Enable is set then this field indicates that the particular BE lane had a fault during the write pass.[br]\r\n"
"Cleared on Local Clear Errors."},
#else
{0, 7, 0x0000000000000000, "RO/V/P", "ecc_lane_err_stat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo282[] = {{"CPGC_ERR_ECC_CHNK_RANK_STAT", "", 0x00000258, 3, 0x00000000000FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields283[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 29, 0x0000000000000000, "RO/V/P", "nth_error", "Nth_Error indicates the current Nth Error that has occurred.[br][br]\r\n"
"Nth_Error will roll over upon saturating to its maximum values.[br][br]\r\n"
"An Nth error is defined as 1 or more lane miscompares within a single comparison cycle (i.e. Chunk)."},
#else
{24, 29, 0x0000000000000000, "RO/V/P", "nth_error", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 22, 0x0000000000000000, "RO/V/P", "rd_chunk_num_stat", "RD_Chunk_Num_Status corresponds to the chunk number being read out of the WDB (EXTBUF )for a RdCAS operation while logging an error during Loopback.Pattern.[br][br]\r\n"
"RD_Chunk_Num_Status is needed in conjunction with the lower 3 column address bits of the cacheline experiencing the error in order to deterministically rewind the LFSR/PB/LMN counter after the test is stopped due to an error condition. This is due to the pipelined nature of the data path since a cacheline can be read out of the WDB (EXTBUF) at the same time an error is being detected against an earlier read.[br]\r\n"
"Using RD_Chunk_Num_Status and the lower 3 column address bits of the cacheline experiencing the error allows the user to determine the skid between the LFSR/PB/LMN counter and the error detection.[br]\r\n"
"RD_Chunk_Num_Status can be cleared by one of two ways.[br][br]\r\n"
"1. Local_Clear_Errors or (Global_Control and Global_Clear_Errors) to 1.[br][br]\r\n"
"2. Writing RD_Chunk_Num_Status=0x0. One may also choose to clear individual bits in RD_Chunk_Num_Status.[br]\r\n"
"Setting bits in RD_Chunk_Num_Status is undefined and should be avoided.[br][br]\r\n"
"Writing a 0 to bits in RD_Chunk_Num_Status can be cleared independently of Data_Error_Status, ECC_Error_Status, Rank_Error_Status, Chunk_Error_Status, and Byte_Group_Error_Status."},
#else
{20, 22, 0x0000000000000000, "RO/V/P", "rd_chunk_num_stat", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW/1C/V/P", "eccgrp_err_stat", "A set bit implies that the ECC bytegroup has at least one lane that accumulated at least one error.[br]\r\n"
"Can also be cleared on Local Clear Errors (or Global_Control and a Global_Clear_Errors) ."},
#else
{8, 8, 0x0000000000000000, "RW/1C/V/P", "eccgrp_err_stat", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW/1C/V/P", "bytegrp_err_stat", "A flag field with each bit corresponding to a specific byte group.  Bit 0 corresponds to byte group 0, bit 1 corresponds to byte group 1, bit 2 corresponds to byte group 2, and so on.  A set bit implies that the corresponding byte group has at least one lane that accumulated at least one error.[br]\r\n"
"When BE Training Enable is set, then this field will indicate that a data error has occured that was not due to the corresponding BE signal.[br]\r\n"
"Can also be cleared on Local Clear Errors  (or Global_Control and a Global_Clear_Errors) ."},
#else
{0, 7, 0x0000000000000000, "RW/1C/V/P", "bytegrp_err_stat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo283[] = {{"CPGC_ERR_BYTE_NTH_PAR_STAT", "", 0x0000025C, 4, 0x000000003FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields284[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW/P", "counter_control", "Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]\r\n"
"00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented by only 1.[br]\r\n"
"01=Count Errors on a particular Lane - The Error Counter will count the exact number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]\r\n"
"10=Count Errors on a particular Byte Group - The Error Counter will count the number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER. ECC is byte group 8. An error within one Chunk within the selected ByteGroup is counted as 1 error.[br]\r\n"
"11=Count Errors on a particular Chunk - The Error Counter will count the number of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER, across all lanes."},
#else
{7, 8, 0x0000000000000000, "RW/P", "counter_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", "Used in conjunction with Counter_Control to indicate which Lane, which ByteLane or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on."},
#else
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo284[] = {{"CPGC_ERR_CNTRCTL_0_", "", 0x00000260, 2, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields285[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW/P", "counter_control", "Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]\r\n"
"00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented by only 1.[br]\r\n"
"01=Count Errors on a particular Lane - The Error Counter will count the exact number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]\r\n"
"10=Count Errors on a particular Byte Group - The Error Counter will count the number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER. ECC is byte group 8. An error within one Chunk within the selected ByteGroup is counted as 1 error.[br]\r\n"
"11=Count Errors on a particular Chunk - The Error Counter will count the number of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER, across all lanes."},
#else
{7, 8, 0x0000000000000000, "RW/P", "counter_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", "Used in conjunction with Counter_Control to indicate which Lane, which ByteLane or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on."},
#else
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo285[] = {{"CPGC_ERR_CNTRCTL_1_", "", 0x00000264, 2, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields286[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW/P", "counter_control", "Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]\r\n"
"00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented by only 1.[br]\r\n"
"01=Count Errors on a particular Lane - The Error Counter will count the exact number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]\r\n"
"10=Count Errors on a particular Byte Group - The Error Counter will count the number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER. ECC is byte group 8. An error within one Chunk within the selected ByteGroup is counted as 1 error.[br]\r\n"
"11=Count Errors on a particular Chunk - The Error Counter will count the number of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER, across all lanes."},
#else
{7, 8, 0x0000000000000000, "RW/P", "counter_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", "Used in conjunction with Counter_Control to indicate which Lane, which ByteLane or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on."},
#else
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo286[] = {{"CPGC_ERR_CNTRCTL_2_", "", 0x00000268, 2, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields287[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW/P", "counter_control", "Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]\r\n"
"00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented by only 1.[br]\r\n"
"01=Count Errors on a particular Lane - The Error Counter will count the exact number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]\r\n"
"10=Count Errors on a particular Byte Group - The Error Counter will count the number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER. ECC is byte group 8. An error within one Chunk within the selected ByteGroup is counted as 1 error.[br]\r\n"
"11=Count Errors on a particular Chunk - The Error Counter will count the number of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER, across all lanes."},
#else
{7, 8, 0x0000000000000000, "RW/P", "counter_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", "Used in conjunction with Counter_Control to indicate which Lane, which ByteLane or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on."},
#else
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo287[] = {{"CPGC_ERR_CNTRCTL_3_", "", 0x0000026C, 2, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields288[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW/P", "counter_control", "Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]\r\n"
"00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented by only 1.[br]\r\n"
"01=Count Errors on a particular Lane - The Error Counter will count the exact number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]\r\n"
"10=Count Errors on a particular Byte Group - The Error Counter will count the number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER. ECC is byte group 8. An error within one Chunk within the selected ByteGroup is counted as 1 error.[br]\r\n"
"11=Count Errors on a particular Chunk - The Error Counter will count the number of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER, across all lanes."},
#else
{7, 8, 0x0000000000000000, "RW/P", "counter_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", "Used in conjunction with Counter_Control to indicate which Lane, which ByteLane or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on."},
#else
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo288[] = {{"CPGC_ERR_CNTRCTL_4_", "", 0x00000270, 2, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields289[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW/P", "counter_control", "Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]\r\n"
"00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented by only 1.[br]\r\n"
"01=Count Errors on a particular Lane - The Error Counter will count the exact number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]\r\n"
"10=Count Errors on a particular Byte Group - The Error Counter will count the number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER. ECC is byte group 8. An error within one Chunk within the selected ByteGroup is counted as 1 error.[br]\r\n"
"11=Count Errors on a particular Chunk - The Error Counter will count the number of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER, across all lanes."},
#else
{7, 8, 0x0000000000000000, "RW/P", "counter_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", "Used in conjunction with Counter_Control to indicate which Lane, which ByteLane or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on."},
#else
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo289[] = {{"CPGC_ERR_CNTRCTL_5_", "", 0x00000274, 2, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields290[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW/P", "counter_control", "Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]\r\n"
"00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented by only 1.[br]\r\n"
"01=Count Errors on a particular Lane - The Error Counter will count the exact number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]\r\n"
"10=Count Errors on a particular Byte Group - The Error Counter will count the number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER. ECC is byte group 8. An error within one Chunk within the selected ByteGroup is counted as 1 error.[br]\r\n"
"11=Count Errors on a particular Chunk - The Error Counter will count the number of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER, across all lanes."},
#else
{7, 8, 0x0000000000000000, "RW/P", "counter_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", "Used in conjunction with Counter_Control to indicate which Lane, which ByteLane or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on."},
#else
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo290[] = {{"CPGC_ERR_CNTRCTL_6_", "", 0x00000278, 2, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields291[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW/P", "counter_control", "Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]\r\n"
"00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented by only 1.[br]\r\n"
"01=Count Errors on a particular Lane - The Error Counter will count the exact number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]\r\n"
"10=Count Errors on a particular Byte Group - The Error Counter will count the number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER. ECC is byte group 8. An error within one Chunk within the selected ByteGroup is counted as 1 error.[br]\r\n"
"11=Count Errors on a particular Chunk - The Error Counter will count the number of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER, across all lanes."},
#else
{7, 8, 0x0000000000000000, "RW/P", "counter_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", "Used in conjunction with Counter_Control to indicate which Lane, which ByteLane or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on."},
#else
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo291[] = {{"CPGC_ERR_CNTRCTL_7_", "", 0x0000027C, 2, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields292[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW/P", "counter_control", "Counter_Control determines what gets counted by CPGC_ERR_CNTR_#.Error_Counter.[br]\r\n"
"00=Count Errors on all Lanes - The Error Counter will capture the OR of all errors across all unmasked Lanes in a Chunk.  For example, if 1 lane or 72 lanes experience an error in a Chunk then the CPGC_ERR_CNTR_#.Error_Counter will be incremented by only 1.[br]\r\n"
"01=Count Errors on a particular Lane - The Error Counter will count the exact number of errors on the Lane indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER.[br]\r\n"
"10=Count Errors on a particular Byte Group - The Error Counter will count the number of errors on the Byte group indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER. ECC is byte group 8. An error within one Chunk within the selected ByteGroup is counted as 1 error.[br]\r\n"
"11=Count Errors on a particular Chunk - The Error Counter will count the number of errors on the a particular chunk in the cacheline indicated by CPGC_ERR_CNTRCTL.COUNTER_POINTER, across all lanes."},
#else
{7, 8, 0x0000000000000000, "RW/P", "counter_control", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", "Used in conjunction with Counter_Control to indicate which Lane, which ByteLane or which Chunk the CPGC_ERR_CNTR_#.Error_Counter will count errors on."},
#else
{0, 6, 0x0000000000000000, "RW/P", "counter_pointer", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo292[] = {{"CPGC_ERR_CNTRCTL_8_", "", 0x00000280, 2, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields293[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", "CPGC_ERR_ERRCNTR indicates the current error counter value which is configured by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and will wrap around, but any overflow of this counter will set the corresponding overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]\r\n"
"Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) . "},
#else
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo293[] = {{"CPGC_ERR_CNTR_0_", "", 0x00000284, 1, 0x00000000007FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields294[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", "CPGC_ERR_ERRCNTR indicates the current error counter value which is configured by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and will wrap around, but any overflow of this counter will set the corresponding overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]\r\n"
"Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) . "},
#else
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo294[] = {{"CPGC_ERR_CNTR_1_", "", 0x00000288, 1, 0x00000000007FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields295[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", "CPGC_ERR_ERRCNTR indicates the current error counter value which is configured by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and will wrap around, but any overflow of this counter will set the corresponding overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]\r\n"
"Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) . "},
#else
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo295[] = {{"CPGC_ERR_CNTR_2_", "", 0x0000028C, 1, 0x00000000007FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields296[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", "CPGC_ERR_ERRCNTR indicates the current error counter value which is configured by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and will wrap around, but any overflow of this counter will set the corresponding overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]\r\n"
"Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) . "},
#else
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo296[] = {{"CPGC_ERR_CNTR_3_", "", 0x00000290, 1, 0x00000000007FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields297[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", "CPGC_ERR_ERRCNTR indicates the current error counter value which is configured by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and will wrap around, but any overflow of this counter will set the corresponding overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]\r\n"
"Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) . "},
#else
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo297[] = {{"CPGC_ERR_CNTR_4_", "", 0x00000294, 1, 0x00000000007FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields298[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", "CPGC_ERR_ERRCNTR indicates the current error counter value which is configured by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and will wrap around, but any overflow of this counter will set the corresponding overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]\r\n"
"Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) . "},
#else
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo298[] = {{"CPGC_ERR_CNTR_5_", "", 0x00000298, 1, 0x00000000007FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields299[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", "CPGC_ERR_ERRCNTR indicates the current error counter value which is configured by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and will wrap around, but any overflow of this counter will set the corresponding overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]\r\n"
"Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) . "},
#else
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo299[] = {{"CPGC_ERR_CNTR_6_", "", 0x0000029C, 1, 0x00000000007FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields300[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", "CPGC_ERR_ERRCNTR indicates the current error counter value which is configured by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and will wrap around, but any overflow of this counter will set the corresponding overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]\r\n"
"Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) . "},
#else
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo300[] = {{"CPGC_ERR_CNTR_7_", "", 0x000002A0, 1, 0x00000000007FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields301[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", "CPGC_ERR_ERRCNTR indicates the current error counter value which is configured by CPGC_ERR_CNTRCTL.Counter_Control.  The  Counter_Status will not  saturate and will wrap around, but any overflow of this counter will set the corresponding overflow status bit in CPGC_ERR_ERRCNTR_OVERFLOW_STATUS.ERROR_COUNTER_OVERFLOW.[br][br]\r\n"
"Counter_Status can only be cleared by setting Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) . "},
#else
{0, 22, 0x0000000000000000, "RO/V/P", "error_counter", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo301[] = {{"CPGC_ERR_CNTR_8_", "", 0x000002A4, 1, 0x00000000007FFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields302[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 8, 0x0000000000000000, "RW/1C/V/P", "error_counter_overflow", "Contains the overflow flags for all Error Counters.[br]\r\n"
"Bit 0 corresponds to ERROR_COUNTER_0.[br]\r\n"
"Bit 1 corresponds to ERROR_COUNTER_1.[br]\r\n"
"..[br]\r\n"
"Bit 8 corresponds to ERROR_COUNTER_8.[br]\r\n"
"Error Counter Overflow Status can be cleared by one of two ways:[br]\r\n"
"1. Local_Clear_Errors (or Global_Control and a Global_Clear_Errors) to 1.[br]\r\n"
"2. Writing the correspoing Error Counter Overflow Status bit to 1.[br]\r\n"
"Writing a 0 to bits in Counter_Overflow_Status can be cleared independently of Data_Error_Status, Byte_Group_Error_Status, Chunk_Error_Status, and ECC_Error_Status."},
#else
{0, 8, 0x0000000000000000, "RW/1C/V/P", "error_counter_overflow", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo302[] = {{"CPGC_ERR_CNTR_OV", "", 0x000002A8, 1, 0x00000000000001FF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields303[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW/1S", "clr_dun_rdbuf_ptr", "Initializes the Error Log Current Read Pointer. Do this prior to the start of a test."},
#else
{16, 16, 0x0000000000000000, "RW/1S", "clr_dun_rdbuf_ptr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RW/1S", "inc_chunk_count", "Advance to next portion of data which is then available in the Error Log Data Register."},
#else
{15, 15, 0x0000000000000000, "RW/1S", "inc_chunk_count", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 14, 0x0000000000000000, "RW/1S", "errlog_auto", "Asserting this bit will have the effect of CPGC automatically generating the needed Read transactions such as the current Read Pointer targets the last failing cachline. Instead of manually browsing, user can set this bit and logic will make sure that CURR_RD_PTR==ERROR_RD_PTR. This bit will always return '0' if read by software."},
#else
{14, 14, 0x0000000000000000, "RW/1S", "errlog_auto", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 13, 0x0000000000000000, "RW/1S", "errlog_move", "Asserting this bit will have the effect of incrementing by one the Current Read Pointer at the actual Read Data Buffer. User can manually browse through the Read Data Buffer and dump its contents. This bit will always return '0' if read by software."},
#else
{13, 13, 0x0000000000000000, "RW/1S", "errlog_move", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000000, "RW/P", "errlog_auto_chnk_inc", "Signal that will allow auto-increment feature for each 32bit data chunk read from the Error Log Data register.[br]\r\n"
"Note: If this bit is set, when doing the last 32bit data access via reading the Error Log Data register, the Error Log Current Read Pointer will auto increment as well."},
#else
{12, 12, 0x0000000000000000, "RW/P", "errlog_auto_chnk_inc", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 8, 0x0000000000000000, "RO/V/P", "error_rd_ptr", "Provides the Read Pointer location that caused the error that triggered STOP_ON_ERROR. This will be used for knowing exactly which entry in the Read Data Buffer contains the faulty cacheline data."},
#else
{5, 8, 0x0000000000000000, "RO/V/P", "error_rd_ptr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RO/V/P", "curr_rd_ptr", "Provides the current Read Pointer location indexed at the Read Data Buffer. This will be used for knowing how many Reads the user needs to issue to return the pointer to the actual failing entry."},
#else
{0, 3, 0x0000000000000000, "RO/V/P", "curr_rd_ptr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo303[] = {{"CPGC_ERRLOG_CTL_STAT", "", 0x000002AC, 7, 0x000000000001FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields304[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RO/V/P", "errlog_data", "32 bits of data corresponding to one of eight (or four for ANN) 32 bit PMI chunks available per Read Pointer location. If ERRLOG_AUTO_CHNK_INC is set, then each read to this register will read out a successive 32 bit PMI chunk of data."},
#else
{0, 31, 0x0000000000000000, "RO/V/P", "errlog_data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo304[] = {{"CPGC_ERRLOG_DATA", "", 0x000002B0, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields305[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO/V", "test_in_progress", "Used to indicate a loopback test is in progress."},
#else
{1, 1, 0x0000000000000000, "RO/V", "test_in_progress", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO/V/P", "error_status", "Bit set during the loopback test. Cleared when Local_Clear_Error in Loopback Sequencer Control is set."},
#else
{0, 0, 0x0000000000000000, "RO/V/P", "error_status", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo305[] = {{"CPGC_ERR_TEST_ERR_STAT", "", 0x000002B4, 2, 0x0000000000000003, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields306[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 30, 0x0000000000000007, "RW", "l2p_rank7_mapping", "Defines what physical Rank address (Memory Controller Rank Mapping) is mapped to this logical Rank address (Sequence Address Logic Domain)."},
#else
{28, 30, 0x0000000000000007, "RW", "l2p_rank7_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000006, "RW", "l2p_rank6_mapping", "Defines what physical Rank address (Memory Controller Rank Mapping) is mapped to this logical Rank address (Sequence Address Logic Domain)."},
#else
{24, 26, 0x0000000000000006, "RW", "l2p_rank6_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 22, 0x0000000000000005, "RW", "l2p_rank5_mapping", "Defines what physical Rank address (Memory Controller Rank Mapping) is mapped to this logical Rank address (Sequence Address Logic Domain)."},
#else
{20, 22, 0x0000000000000005, "RW", "l2p_rank5_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000004, "RW", "l2p_rank4_mapping", "Defines what physical Rank address (Memory Controller Rank Mapping) is mapped to this logical Rank address (Sequence Address Logic Domain)."},
#else
{16, 18, 0x0000000000000004, "RW", "l2p_rank4_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000003, "RW", "l2p_rank3_mapping", "Defines what physical Rank address (Memory Controller Rank Mapping) is mapped to this logical Rank address (Sequence Address Logic Domain)."},
#else
{12, 14, 0x0000000000000003, "RW", "l2p_rank3_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000002, "RW", "l2p_rank2_mapping", "Defines what physical Rank address (Memory Controller Rank Mapping) is mapped to this logical Rank address (Sequence Address Logic Domain)."},
#else
{8, 10, 0x0000000000000002, "RW", "l2p_rank2_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000001, "RW", "l2p_rank1_mapping", "Defines what physical Rank address (Memory Controller Rank Mapping) is mapped to this logical Rank address (Sequence Address Logic Domain)."},
#else
{4, 6, 0x0000000000000001, "RW", "l2p_rank1_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RW", "l2p_rank0_mapping", "Defines what physical Rank address (Memory Controller Rank Mapping) is mapped to this logical Rank address (Sequence Address Logic Domain)."},
#else
{0, 2, 0x0000000000000000, "RW", "l2p_rank0_mapping", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo306[] = {{"CPGC_SEQ_RANK_L2P_MAPPING", "", 0x000002B8, 8, 0x000000007FFFFFFF, 0x0000000076543210}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields307[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000007, "RW", "l2p_bank7_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{28, 31, 0x0000000000000007, "RW", "l2p_bank7_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000006, "RW", "l2p_bank6_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{24, 27, 0x0000000000000006, "RW", "l2p_bank6_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000005, "RW", "l2p_bank5_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{20, 23, 0x0000000000000005, "RW", "l2p_bank5_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000004, "RW", "l2p_bank4_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{16, 19, 0x0000000000000004, "RW", "l2p_bank4_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000003, "RW", "l2p_bank3_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{12, 15, 0x0000000000000003, "RW", "l2p_bank3_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000002, "RW", "l2p_bank2_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{8, 11, 0x0000000000000002, "RW", "l2p_bank2_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000001, "RW", "l2p_bank1_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{4, 7, 0x0000000000000001, "RW", "l2p_bank1_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "l2p_bank0_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{0, 3, 0x0000000000000000, "RW", "l2p_bank0_mapping", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo307[] = {{"CPGC_SEQ_BANK_L2P_MAPPING_A", "", 0x000002BC, 8, 0x00000000FFFFFFFF, 0x0000000076543210}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields308[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x000000000000000F, "RW", "l2p_bank15_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{28, 31, 0x000000000000000F, "RW", "l2p_bank15_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x000000000000000E, "RW", "l2p_bank14_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{24, 27, 0x000000000000000E, "RW", "l2p_bank14_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x000000000000000D, "RW", "l2p_bank13_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{20, 23, 0x000000000000000D, "RW", "l2p_bank13_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x000000000000000C, "RW", "l2p_bank12_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{16, 19, 0x000000000000000C, "RW", "l2p_bank12_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x000000000000000B, "RW", "l2p_bank11_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{12, 15, 0x000000000000000B, "RW", "l2p_bank11_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x000000000000000A, "RW", "l2p_bank10_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{8, 11, 0x000000000000000A, "RW", "l2p_bank10_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000009, "RW", "l2p_bank9_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{4, 7, 0x0000000000000009, "RW", "l2p_bank9_mapping", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000008, "RW", "l2p_bank8_mapping", "Defines what physical Bank address (Memory Controller Bank Mapping) is mapped to this logical Bank address (Sequence Address Logic Domain)."},
#else
{0, 3, 0x0000000000000008, "RW", "l2p_bank8_mapping", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo308[] = {{"CPGC_SEQ_BANK_L2P_MAPPING_B", "", 0x000002C0, 8, 0x00000000FFFFFFFF, 0x00000000FEDCBA98}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields309[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x000000000000000F, "RW", "l2p_rank3_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other.  Only Rank address bits available to the memory controller are valid, others should be set to 0xF."},
#else
{12, 15, 0x000000000000000F, "RW", "l2p_rank3_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x000000000000000E, "RW", "l2p_rank2_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other."},
#else
{8, 11, 0x000000000000000E, "RW", "l2p_rank2_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x000000000000000D, "RW", "l2p_rank1_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other."},
#else
{4, 7, 0x000000000000000D, "RW", "l2p_rank1_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x000000000000000C, "RW", "l2p_rank0_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other."},
#else
{0, 3, 0x000000000000000C, "RW", "l2p_rank0_swizzle", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo309[] = {{"CPGC_SEQ_RANK_ADDR_SWIZZLE", "", 0x000002C4, 4, 0x000000000000FFFF, 0x000000000000FEDC}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields310[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x000000000000001B, "RW", "l2p_bank3_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Bank address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value. Only Bank address bits available to the memory controller are valid, others should be set to 0x1F."},
#else
{15, 19, 0x000000000000001B, "RW", "l2p_bank3_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x000000000000001A, "RW", "l2p_bank2_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Bank address. The bits are essentially swizzled with each other."},
#else
{10, 14, 0x000000000000001A, "RW", "l2p_bank2_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x0000000000000019, "RW", "l2p_bank1_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Bank address. The bits are essentially swizzled with each other."},
#else
{5, 9, 0x0000000000000019, "RW", "l2p_bank1_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000018, "RW", "l2p_bank0_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Bank address. The bits are essentially swizzled with each other."},
#else
{0, 4, 0x0000000000000018, "RW", "l2p_bank0_swizzle", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo310[] = {{"CPGC_SEQ_BANK_ADDR_SWIZZLE", "", 0x000002C8, 4, 0x00000000000FFFFF, 0x00000000000DEB38}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields311[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{25, 29, 0x0000000000000005, "RW", "l2p_row5_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{25, 29, 0x0000000000000005, "RW", "l2p_row5_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 24, 0x0000000000000004, "RW", "l2p_row4_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{20, 24, 0x0000000000000004, "RW", "l2p_row4_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x0000000000000003, "RW", "l2p_row3_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{15, 19, 0x0000000000000003, "RW", "l2p_row3_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x0000000000000002, "RW", "l2p_row2_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{10, 14, 0x0000000000000002, "RW", "l2p_row2_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x0000000000000001, "RW", "l2p_row1_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{5, 9, 0x0000000000000001, "RW", "l2p_row1_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "l2p_row0_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{0, 4, 0x0000000000000000, "RW", "l2p_row0_swizzle", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo311[] = {{"CPGC_SEQ_ROW_ADDR_SWIZZLE_A", "", 0x000002CC, 6, 0x000000003FFFFFFF, 0x000000000A418820}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields312[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{25, 29, 0x000000000000000B, "RW", "l2p_row11_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{25, 29, 0x000000000000000B, "RW", "l2p_row11_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 24, 0x000000000000000A, "RW", "l2p_row10_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{20, 24, 0x000000000000000A, "RW", "l2p_row10_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x0000000000000009, "RW", "l2p_row9_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{15, 19, 0x0000000000000009, "RW", "l2p_row9_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x0000000000000008, "RW", "l2p_row8_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{10, 14, 0x0000000000000008, "RW", "l2p_row8_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x0000000000000007, "RW", "l2p_row7_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{5, 9, 0x0000000000000007, "RW", "l2p_row7_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000006, "RW", "l2p_row6_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{0, 4, 0x0000000000000006, "RW", "l2p_row6_swizzle", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo312[] = {{"CPGC_SEQ_ROW_ADDR_SWIZZLE_B", "", 0x000002D0, 6, 0x000000003FFFFFFF, 0x0000000016A4A0E6}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields313[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{25, 29, 0x0000000000000011, "RW", "l2p_row17_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value. Only Row address bits available to the memory controller are valid, others should be set to 0x1F."},
#else
{25, 29, 0x0000000000000011, "RW", "l2p_row17_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 24, 0x0000000000000010, "RW", "l2p_row16_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{20, 24, 0x0000000000000010, "RW", "l2p_row16_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x000000000000000F, "RW", "l2p_row15_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{15, 19, 0x000000000000000F, "RW", "l2p_row15_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x000000000000000E, "RW", "l2p_row14_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{10, 14, 0x000000000000000E, "RW", "l2p_row14_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x000000000000000D, "RW", "l2p_row13_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{5, 9, 0x000000000000000D, "RW", "l2p_row13_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x000000000000000C, "RW", "l2p_row12_swizzle", "Defines how a particular Logical Row or Bank bit is remapped to a Physical Row address. The bits are essentially swizzled with each other. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{0, 4, 0x000000000000000C, "RW", "l2p_row12_swizzle", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo313[] = {{"CPGC_SEQ_ROW_ADDR_SWIZZLE_C", "", 0x000002D4, 6, 0x000000003FFFFFFF, 0x000000002307B9AC}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields314[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW", "addr_dq_inv_en", "Enables the lookup table to invert the DQs based on select Row address bits."},
#else
{29, 29, 0x0000000000000000, "RW", "addr_dq_inv_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 19, 0x000000000000001F, "RW", "l2p_row3_xor_swizzle", "Row XOR source selection for lower order Row addresses. Select 31 if only using a direct mapping with no XOR."},
#else
{15, 19, 0x000000000000001F, "RW", "l2p_row3_xor_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 14, 0x000000000000001F, "RW", "l2p_row2_xor_swizzle", "Row XOR source selection for lower order Row addresses. Select 31 if only using a direct mapping with no XOR."},
#else
{10, 14, 0x000000000000001F, "RW", "l2p_row2_xor_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 9, 0x000000000000001F, "RW", "l2p_row1_xor_swizzle", "Row XOR source selection for lower order Row addresses. Select 31 if only using a direct mapping with no XOR."},
#else
{5, 9, 0x000000000000001F, "RW", "l2p_row1_xor_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x000000000000001F, "RW", "l2p_row0_xor_swizzle", "Row XOR source selection for lower order Row addresses. Select 31 if only using a direct mapping with no XOR. Bank Bits start at select value of 24. A value of 31 will select a constant '0' value."},
#else
{0, 4, 0x000000000000001F, "RW", "l2p_row0_xor_swizzle", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo314[] = {{"CPGC_SEQ_ROW_ADDR_SWIZZLE_X", "", 0x000002D8, 5, 0x000000003FFFFFFF, 0x00000000000FFFFF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields315[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000006, "RW", "l2p_col6_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other. Rank Bits start at select value of 12. A value of 11 will select a constant '0' value. "},
#else
{28, 31, 0x0000000000000006, "RW", "l2p_col6_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000005, "RW", "l2p_col5_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other."},
#else
{24, 27, 0x0000000000000005, "RW", "l2p_col5_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000004, "RW", "l2p_col4_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other."},
#else
{20, 23, 0x0000000000000004, "RW", "l2p_col4_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000003, "RW", "l2p_col3_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other."},
#else
{16, 19, 0x0000000000000003, "RW", "l2p_col3_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000002, "RW", "l2p_col2_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other."},
#else
{12, 15, 0x0000000000000002, "RW", "l2p_col2_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000001, "RW", "l2p_col1_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other."},
#else
{8, 11, 0x0000000000000001, "RW", "l2p_col1_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "l2p_col0_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other. Column Address Bit 0 always corresponds to the logical A[6] for 64B requests and A[5] for 32B requests."},
#else
{4, 7, 0x0000000000000000, "RW", "l2p_col0_swizzle", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo315[] = {{"CPGC_SEQ_COL_ADDR_SWIZZLE_A", "", 0x000002DC, 7, 0x00000000FFFFFFFF, 0x0000000065432100}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields316[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000008, "RW", "l2p_col8_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other. Rank Bits start at select value of 12. A value of 11 will select a constant '0' value. Only Row address bits available to the memory controller are valid, others should be set to 11."},
#else
{4, 7, 0x0000000000000008, "RW", "l2p_col8_swizzle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000007, "RW", "l2p_col7_swizzle", "Defines how a particular Logical COL or RANK bit is remapped to a Physical COL address. The bits are essentially swizzled with each other."},
#else
{0, 3, 0x0000000000000007, "RW", "l2p_col7_swizzle", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo316[] = {{"CPGC_SEQ_COL_ADDR_SWIZZLE_B", "", 0x000002E0, 2, 0x00000000000000FF, 0x0000000000000087}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields317[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", "Data written to this register will be placed in the DQ Map register as a stack. Data is read from the bottom of the stack (higher locations). The last write covers Row addresses of Row[11:4] = (0..31).[br]\r\n"
"Reading requires you to write into the stack to get the next location. Since this is destructive, if the data is to be preserved, then the data read should be used for the write. See documentation for details.[br]\r\n"
""},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo317[] = {{"CPGC_SEQ_ROW_ADDR_DQ_MAP0", "", 0x000002E8, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields318[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", "Data written to this register will be placed in the DQ Map register as a stack. Data is read from the bottom of the stack (higher locations). The last write covers Row addresses of Row[11:4] = (32..63).[br]\r\n"
"Reading requires you to write into the stack to get the next location. Since this is destructive, if the data is to be preserved, then the data read should be used for the write. See documentation for details."},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo318[] = {{"CPGC_SEQ_ROW_ADDR_DQ_MAP1", "", 0x000002EC, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields319[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "cmd_deselect_stall", "(Not Implemented in BXT) TBD."},
#else
{31, 31, 0x0000000000000000, "RW", "cmd_deselect_stall", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW", "cmd_deselect_restart", "If set, the CADB pattern will reload each time the chosen CMD_DESELECT_START condition is met. Please refer to CMD_DESLECT_START field for more info."},
#else
{29, 29, 0x0000000000000000, "RW", "cmd_deselect_restart", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "cadb_dbl_pump", "Setting bit 28 - Command and address are driven in a double-phase pattern (data changes on both halves of the DDR clock).  Clearing bit 28 - Command and address are driven in a single-phase pattern (data changes every full clock cycle)."},
#else
{28, 28, 0x0000000000000000, "RW", "cadb_dbl_pump", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "reload_starting_seed", "Reload_Starting_Seed will reload the 16bit CADB unisequencer starting seeds for LFSR/PB engines used for Select and Deselect chunk choosing to current seeds synchronous with particular commands (PRE/ACT/RD/WR) that are indicated to cause the reload to happen.  The reload seed must be used as the CADB output in the same cycle as the command which causes the reload to happen.[br][br]\r\n"
"Setting Bit 24 - Reload the starting seed to current seed on WR.[br][br]\r\n"
"Setting Bit 25 - Reload the starting seed to current seed on RD.[br][br]\r\n"
"Setting Bit 26 - Reload the starting seed to current seed on ACT.[br][br]\r\n"
"Setting Bit 27 - Reload the starting seed to current seed on PR."},
#else
{24, 27, 0x0000000000000000, "RW", "reload_starting_seed", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "save_current_seed", "Save_Current_Seed when qualified with Subsequence_Deselect_Save_Enable from REUT engine indicates which command triggers saving the current LFSR/PB values for Select and Deselect logic to the starting seed copy.[br][br]\r\n"
"Setting Bit 20 - Save the current seed to starting seed on WR.[br][br]\r\n"
"Setting Bit 21 - Save the current seed to starting seed on RD.[br][br]\r\n"
"Setting Bit 22 - Save the current seed to starting seed on ACT.[br][br]\r\n"
"Setting Bit 23 - Save the current seed to starting seed on PR."},
#else
{20, 23, 0x0000000000000000, "RW", "save_current_seed", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RW", "pre_select_enable", "PRE_Select_Enable - Drive CADB generated patterns during all Precharge Select cycles on pins that are enabled based on the description below.[br][br]\r\n"
"Setting Bit 18 - Drive CADB patterns on MA pins except AP bit during a PRE command.[br][br]\r\n"
"Setting Bit 19 - Drive CADB patterns on BA pins during a PRE command.[br]\r\n"
""},
#else
{18, 19, 0x0000000000000000, "RW", "pre_select_enable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "act_select_enable", "ACT_Select_Enable - Drive CADB generated patterns during all ACT CMD Select cycles on pins that are enabled based on the description below.[br][br]\r\n"
"Setting Bit 16 - Drive CADB patterns on MA pins during an ACT cmd.[br][br]\r\n"
"Setting Bit 17 - Drive CADB patterns on BA pins during an ACT cmd.[br]\r\n"
""},
#else
{16, 17, 0x0000000000000000, "RW", "act_select_enable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "cas_select_enable", "CAS_Select_Enable - Drive CADB generated patterns during all CAS CMD Select cycles on pins that are enabled based on the description below.[br][br]\r\n"
"Setting Bit 14 - Drive CADB patterns on MA[11] and MA[9:0] pins during a CAS cmd.[br][br]\r\n"
"Setting Bit 15 - Drive CADB patterns on BA pins during a CAS cmd.[br][br]\r\n"
""},
#else
{14, 15, 0x0000000000000000, "RW", "cas_select_enable", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 13, 0x0000000000000000, "RW", "lane_deselect_en", "Setting Bit 10 - Drive CADB pattern on MA pins during Deselect cycles.[br][br]\r\n"
"Setting Bit 11 - Drive CADB pattern on BA pins during Deselect cycles.[br][br]\r\n"
"Setting Bit 12 - Drive CADB pattern on CMD pins during Deselect cycles.[br][br]\r\n"
"Setting Bit 13 - Drive CADB pattern on CS pins during Deselect cycles.[br][br]\r\n"
"Note: If CS is set than and CADB entry that also has CS set to one, the logic overrides CMD signals w/NOP encoding, thus making CMD and CS mutually exclusive to ensure no DDR functional violations occur."},
#else
{10, 13, 0x0000000000000000, "RW", "lane_deselect_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 9, 0x0000000000000000, "RW", "cmd_deselect_stop", "Setting Bit 6 - Stop driving CADB Deselect pattern on the following cycle after a WR CMD.[br][br]\r\n"
"Setting Bit 7 - Stop driving CADB Deselect pattern on the following cycle after a RD CMD.[br][br]\r\n"
"Setting Bit 8 - Stop driving CADB Deselect pattern on the following cycle after an ACT CMD.[br][br]\r\n"
"Setting Bit 9 - Stop driving CADB Deselect pattern on the following cycle after a PRE CMD.[br][br]\r\n"
"Note: If Deselect was off before the command that is supposed to stop it, it will remain in the off state."},
#else
{6, 9, 0x0000000000000000, "RW", "cmd_deselect_stop", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 5, 0x0000000000000000, "RW", "cmd_deselect_start", "Setting Bit 2 - Start Driving Deselects on the following cycle after a WR CMD if CADB_Deselect_Enable is high.[br][br]\r\n"
"Setting Bit 3 - Start Driving Deselects on the following cycle after a RD CMD if CADB_Deselect_Enable is high.[br][br]\r\n"
"Setting Bit 4 - Start Driving Deselects on the following cycle after a ACT CMD if CADB_Deselect_Enable is high.[br][br]\r\n"
"Setting Bit 5 - Start Driving Deselects on the following cycle after a PRE CMD if CADB_Deselect_Enable is high.[br]"},
#else
{2, 5, 0x0000000000000000, "RW", "cmd_deselect_start", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "cadb_mode", "The operation mode of the command/address pattern generator is encoded as follows:[br][br]\r\n"
"00 - Select and trigger-driven-Deselect : CADB will drive patterns during Select and Deselect cycles depending on the values programmed in Lane_Deselect_Enable and PRE_Select_Enable/ACT_Select_Enable/CAS_Select_Enable. Trigger-driven-Deselect allows start/stop of Deselect cycles to synchronize with various CMD events and/or Subsequence control bits.[br][br]\r\n"
"01 - Global Deselect : CADB generated pattern will be driven on the bus during deselect cycles only when SoC CPGC is in ACTIVE or NORMAL mode. SoC CPGC will drive out the pattern on all command and address signals (except CKE, and ODT). User can choose which ADDRESS/CMD lanes will be enabled for this mode. CS gets special treatment as mentioned in LANE_DESELECT_ENABLE description.[br][br]\r\n"
"10 - Always On: [br][br]\r\n"
"If INITIALIZATION_MODE is ACTIVE MODE, pattern stored in the command/address buffers will be driven on all command and address signals on every DCLK cycle. This is not a functional mode and should only be used for BDV purposes.[br][br]\r\n"
"If INITIALIZATION_MODE is MRS MODE, pattern stored in the command/address buffers will be driven on all command and address signals under the control of the CADB MRS state machine. This is the way to send MRS commands to DRAM devices using CPGC.[br][br]\r\n"
"11 - RESERVED:"},
#else
{0, 1, 0x0000000000000000, "RW", "cadb_mode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo319[] = {{"CPGC_CADB_CTL", "", 0x000002F0, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields320[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RW", "mrs_cs_mode", "Only if it is set to 0, it will be deaserted at (1 or 2 cycles) number of cycles at the middle of Gap CS, is selected per entry and per rank.[br][br]\r\n"
"00 - No Override.[br][br]\r\n"
"01 - No Override.[br][br]\r\n"
"10 - One Cycle CS.[br][br]\r\n"
"11 - Two Cycles CS."},
#else
{28, 29, 0x0000000000000000, "RW", "mrs_cs_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000007, "RO/V", "mrs_curr_ptr", "Current MRS instruction pointer - Valid for LP3 only."},
#else
{24, 26, 0x0000000000000007, "RO/V", "mrs_curr_ptr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000007, "RW", "mrs_end_ptr", "Pointer to the last CADB entry. To be used if in MRS mode.[br] Note: This indexing mode of the CADB buffer is only available if in CPGC_SEQ_CFG_0.INITIALIZATION_MODE=MRS_MODE. For MRS Double pump mode or 1/2N mode, the end pointer should be programmed to 3 or 7. Otherwise, the valid willl show up only for the first 40 bits which would be from BUF0- [9:0] bits, BUF1 [9:0] bits, BUF2 [9:0] bits and BUF3 [9:0] bits."},
#else
{16, 18, 0x0000000000000007, "RW", "mrs_end_ptr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "mrs_start_ptr", "Pointer to the first CADB entry. To be used if in MRS mode.[br] Note: This indexing mode of the CADB buffer is only available if in CPGC_SEQ_CFG_0.INITIALIZATION_MODE=MRS_MODE."},
#else
{8, 10, 0x0000000000000000, "RW", "mrs_start_ptr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "mrs_gap_scale", "Linear or Exponential Scale for CADB_GAP value.[br]\r\n"
"[b]Note: This is not implemented in Reference RTL yet. [/b]]"},
#else
{4, 4, 0x0000000000000000, "RW", "mrs_gap_scale", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "mrs_gap", "2^(MRS_GAP) clock cycles between changing to the next MRS CADB entry. Value Zero is prohibited.[br] Note: This GAP is applicable to both, MRS mode or normal CADB pattern gen. When used for non MRS CADB pattern generation, a value of Zero is allowed."},
#else
{0, 3, 0x0000000000000000, "RW", "mrs_gap", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo320[] = {{"CPGC_CADB_MRSCFG", "", 0x000002F4, 6, 0x000000003FFFFFFF, 0x0000000007070000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields321[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000001, "RW", "sel_uniseq2_mode", "Defines the operational mode for select unified sequence 2 as follows:[br][br]\r\n"
"00 - Reserved for future use.[br][br]\r\n"
"01 - Pattern Buffer Mode.[br][br]\r\n"
"10 - LFSR Mode.[br][br]\r\n"
"11 - Reserved for future use."},
#else
{24, 25, 0x0000000000000001, "RW", "sel_uniseq2_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 21, 0x0000000000000001, "RW", "sel_uniseq1_mode", "Defines the operational mode for select unified sequence 1 as follows:[br][br]\r\n"
"00 - Reserved for future use.[br][br]\r\n"
"01 - Pattern Buffer Mode.[br][br]\r\n"
"10 - LFSR Mode.[br][br]\r\n"
"11 - Reserved for future use."},
#else
{20, 21, 0x0000000000000001, "RW", "sel_uniseq1_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000001, "RW", "sel_uniseq0_mode", "Defines the operational mode for select unified sequence 0 as follows:[br][br]\r\n"
"00 - Reserved for future use.[br][br]\r\n"
"01 - Pattern Buffer Mode.[br][br]\r\n"
"10 - LFSR Mode.[br][br]\r\n"
"11 - Reserved for future use."},
#else
{16, 17, 0x0000000000000001, "RW", "sel_uniseq0_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000001, "RW", "uniseq2_mode", "Defines the operational mode for unified sequence 2 as follows:[br][br]\r\n"
"00 - LMN Mode.[br][br]\r\n"
"01 - Pattern Buffer Mode.[br][br]\r\n"
"10 - LFSR Mode.[br][br]\r\n"
"11 - Reserved for future use."},
#else
{8, 9, 0x0000000000000001, "RW", "uniseq2_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000001, "RW", "uniseq1_mode", "Defines the operational mode for unified sequence 1 as follows:[br][br]\r\n"
"00 - LMN Mode.[br][br]\r\n"
"01 - Pattern Buffer Mode.[br][br]\r\n"
"10 - LFSR Mode.[br][br]\r\n"
"11 - Reserved for future use."},
#else
{4, 5, 0x0000000000000001, "RW", "uniseq1_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000001, "RW", "uniseq0_mode", "Defines the operational mode for unified sequence 0 as follows:[br][br]\r\n"
"00 - LMN Mode.[br][br]\r\n"
"01 - Pattern Buffer Mode.[br][br]\r\n"
"10 - LFSR Mode.[br][br]\r\n"
"11 - Reserved for future use."},
#else
{0, 1, 0x0000000000000001, "RW", "uniseq0_mode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo321[] = {{"CPGC_CADB_CFG", "", 0x000002F8, 6, 0x0000000003FFFFFF, 0x0000000001110111}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields322[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x000000000000AA55, "RW", "cmd", "The initial content of the rotating pattern buffer for the unified sequencer."},
#else
{0, 15, 0x000000000000AA55, "RW", "cmd", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo322[] = {{"CPGC_CADB_UNISEQ0_PBUF", "", 0x000002FC, 1, 0x000000000000FFFF, 0x000000000000AA55}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields323[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x000000000000AA55, "RW", "cmd", "The initial content of the rotating pattern buffer for the unified sequencer."},
#else
{0, 15, 0x000000000000AA55, "RW", "cmd", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo323[] = {{"CPGC_CADB_UNISEQ1_PBUF", "", 0x00000300, 1, 0x000000000000FFFF, 0x000000000000AA55}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields324[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x000000000000AA55, "RW", "cmd", "The initial content of the rotating pattern buffer for the unified sequencer."},
#else
{0, 15, 0x000000000000AA55, "RW", "cmd", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo324[] = {{"CPGC_CADB_UNISEQ2_PBUF", "", 0x00000304, 1, 0x000000000000FFFF, 0x000000000000AA55}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields325[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000005, "RW", "m_cnt", "Number of UIs that the unisequencer will drive logic '1'."},
#else
{24, 26, 0x0000000000000005, "RW", "m_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000002, "RW", "n_cnt", "Number of UIs that the unisequencer will drive logic '0'."},
#else
{16, 18, 0x0000000000000002, "RW", "n_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000004, "RW", "l_cnt", "Number of UIs that the unisequencer will drive the logic value selected through L_SEL before entering the steady state periodic phase."},
#else
{8, 10, 0x0000000000000004, "RW", "l_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000005, "RW", "cnt_scale", "Values for L_CNT, M_CNT, and N_CNT are scaled by a factor of 2^CNT_SCALE."},
#else
{4, 6, 0x0000000000000005, "RW", "cnt_scale", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "en_sweep_freq", "0 - Disable Sweep Frequency. 1 - Enable Sweep Frequency. [br][br]\r\n"
"[b]Note: This is not implemented in Reference RTL yet. [/b]]"},
#else
{1, 1, 0x0000000000000000, "RW", "en_sweep_freq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "l_sel", "The initial logic output of the sequencer is defined as follows:[br][br]\r\n"
"                        0 - Output Logic '0' for L_CNT UIs.[br][br]\r\n"
"                        1 - Output Logic '1' for L_CNT UIs."},
#else
{0, 0, 0x0000000000000001, "RW", "l_sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo325[] = {{"CPGC_CADB_UNISEQ0_LMN", "", 0x00000308, 6, 0x0000000007FFFFFF, 0x0000000005020451}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields326[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000005, "RW", "m_cnt", "Number of UIs that the unisequencer will drive logic '1'."},
#else
{24, 26, 0x0000000000000005, "RW", "m_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000002, "RW", "n_cnt", "Number of UIs that the unisequencer will drive logic '0'."},
#else
{16, 18, 0x0000000000000002, "RW", "n_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000004, "RW", "l_cnt", "Number of UIs that the unisequencer will drive the logic value selected through L_SEL before entering the steady state periodic phase."},
#else
{8, 10, 0x0000000000000004, "RW", "l_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000005, "RW", "cnt_scale", "Values for L_CNT, M_CNT, and N_CNT are scaled by a factor of 2^CNT_SCALE."},
#else
{4, 6, 0x0000000000000005, "RW", "cnt_scale", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "en_sweep_freq", "0 - Disable Sweep Frequency. 1 - Enable Sweep Frequency. [br][br]\r\n"
"[b]Note: This is not implemented in Reference RTL yet. [/b]]"},
#else
{1, 1, 0x0000000000000000, "RW", "en_sweep_freq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "l_sel", "The initial logic output of the sequencer is defined as follows:[br][br]\r\n"
"                        0 - Output Logic '0' for L_CNT UIs.[br][br]\r\n"
"                        1 - Output Logic '1' for L_CNT UIs."},
#else
{0, 0, 0x0000000000000001, "RW", "l_sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo326[] = {{"CPGC_CADB_UNISEQ1_LMN", "", 0x0000030C, 6, 0x0000000007FFFFFF, 0x0000000005020451}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields327[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000005, "RW", "m_cnt", "Number of UIs that the unisequencer will drive logic '1'."},
#else
{24, 26, 0x0000000000000005, "RW", "m_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000002, "RW", "n_cnt", "Number of UIs that the unisequencer will drive logic '0'."},
#else
{16, 18, 0x0000000000000002, "RW", "n_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000004, "RW", "l_cnt", "Number of UIs that the unisequencer will drive the logic value selected through L_SEL before entering the steady state periodic phase."},
#else
{8, 10, 0x0000000000000004, "RW", "l_cnt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000005, "RW", "cnt_scale", "Values for L_CNT, M_CNT, and N_CNT are scaled by a factor of 2^CNT_SCALE."},
#else
{4, 6, 0x0000000000000005, "RW", "cnt_scale", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "en_sweep_freq", "0 - Disable Sweep Frequency. 1 - Enable Sweep Frequency. [br][br]\r\n"
"[b]Note: This is not implemented in Reference RTL yet. [/b]]"},
#else
{1, 1, 0x0000000000000000, "RW", "en_sweep_freq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "l_sel", "The initial logic output of the sequencer is defined as follows:[br][br]\r\n"
"                        0 - Output Logic '0' for L_CNT UIs.[br][br]\r\n"
"                        1 - Output Logic '1' for L_CNT UIs."},
#else
{0, 0, 0x0000000000000001, "RW", "l_sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo327[] = {{"CPGC_CADB_UNISEQ2_LMN", "", 0x00000310, 6, 0x0000000007FFFFFF, 0x0000000005020451}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields328[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x000000000000AA55, "RW", "cmd", "The initial content of the rotating pattern buffer for the select unified sequencer."},
#else
{0, 15, 0x000000000000AA55, "RW", "cmd", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo328[] = {{"CPGC_CADB_SEL_UNISEQ0_PBUF", "", 0x00000314, 1, 0x000000000000FFFF, 0x000000000000AA55}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields329[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x000000000000AA55, "RW", "cmd", "The initial content of the rotating pattern buffer for the select unified sequencer."},
#else
{0, 15, 0x000000000000AA55, "RW", "cmd", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo329[] = {{"CPGC_CADB_SEL_UNISEQ1_PBUF", "", 0x00000318, 1, 0x000000000000FFFF, 0x000000000000AA55}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields330[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x000000000000AA55, "RW", "cmd", "The initial content of the rotating pattern buffer for the select unified sequencer."},
#else
{0, 15, 0x000000000000AA55, "RW", "cmd", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo330[] = {{"CPGC_CADB_SEL_UNISEQ2_PBUF", "", 0x0000031C, 1, 0x000000000000FFFF, 0x000000000000AA55}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields331[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "bank_addr", "The DRAM bank address.[br] Note: Not used in LPDDR2/3."},
#else
{24, 27, 0x0000000000000000, "RW", "bank_addr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 19, 0x0000000000000000, "RW", "row_col_addr", "The DRAM row/column address.[br][br]\r\n"
"LPDDR2/3 Maps the following:[br][br]\r\n"
"CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]\r\n"
"CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]\r\n"
"Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information on the mapping."},
#else
{0, 19, 0x0000000000000000, "RW", "row_col_addr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo331[] = {{"CPGC_CADB_BUFA_0_", "", 0x00000320, 2, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields332[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "bank_addr", "The DRAM bank address.[br] Note: Not used in LPDDR2/3."},
#else
{24, 27, 0x0000000000000000, "RW", "bank_addr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 19, 0x0000000000000000, "RW", "row_col_addr", "The DRAM row/column address.[br][br]\r\n"
"LPDDR2/3 Maps the following:[br][br]\r\n"
"CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]\r\n"
"CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]\r\n"
"Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information on the mapping."},
#else
{0, 19, 0x0000000000000000, "RW", "row_col_addr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo332[] = {{"CPGC_CADB_BUFA_1_", "", 0x00000324, 2, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields333[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "bank_addr", "The DRAM bank address.[br] Note: Not used in LPDDR2/3."},
#else
{24, 27, 0x0000000000000000, "RW", "bank_addr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 19, 0x0000000000000000, "RW", "row_col_addr", "The DRAM row/column address.[br][br]\r\n"
"LPDDR2/3 Maps the following:[br][br]\r\n"
"CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]\r\n"
"CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]\r\n"
"Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information on the mapping."},
#else
{0, 19, 0x0000000000000000, "RW", "row_col_addr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo333[] = {{"CPGC_CADB_BUFA_2_", "", 0x00000328, 2, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields334[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "bank_addr", "The DRAM bank address.[br] Note: Not used in LPDDR2/3."},
#else
{24, 27, 0x0000000000000000, "RW", "bank_addr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 19, 0x0000000000000000, "RW", "row_col_addr", "The DRAM row/column address.[br][br]\r\n"
"LPDDR2/3 Maps the following:[br][br]\r\n"
"CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]\r\n"
"CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]\r\n"
"Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information on the mapping."},
#else
{0, 19, 0x0000000000000000, "RW", "row_col_addr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo334[] = {{"CPGC_CADB_BUFA_3_", "", 0x0000032C, 2, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields335[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "bank_addr", "The DRAM bank address.[br] Note: Not used in LPDDR2/3."},
#else
{24, 27, 0x0000000000000000, "RW", "bank_addr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 19, 0x0000000000000000, "RW", "row_col_addr", "The DRAM row/column address.[br][br]\r\n"
"LPDDR2/3 Maps the following:[br][br]\r\n"
"CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]\r\n"
"CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]\r\n"
"Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information on the mapping."},
#else
{0, 19, 0x0000000000000000, "RW", "row_col_addr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo335[] = {{"CPGC_CADB_BUFA_4_", "", 0x00000330, 2, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields336[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "bank_addr", "The DRAM bank address.[br] Note: Not used in LPDDR2/3."},
#else
{24, 27, 0x0000000000000000, "RW", "bank_addr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 19, 0x0000000000000000, "RW", "row_col_addr", "The DRAM row/column address.[br][br]\r\n"
"LPDDR2/3 Maps the following:[br][br]\r\n"
"CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]\r\n"
"CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]\r\n"
"Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information on the mapping."},
#else
{0, 19, 0x0000000000000000, "RW", "row_col_addr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo336[] = {{"CPGC_CADB_BUFA_5_", "", 0x00000334, 2, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields337[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "bank_addr", "The DRAM bank address.[br] Note: Not used in LPDDR2/3."},
#else
{24, 27, 0x0000000000000000, "RW", "bank_addr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 19, 0x0000000000000000, "RW", "row_col_addr", "The DRAM row/column address.[br][br]\r\n"
"LPDDR2/3 Maps the following:[br][br]\r\n"
"CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]\r\n"
"CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]\r\n"
"Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information on the mapping."},
#else
{0, 19, 0x0000000000000000, "RW", "row_col_addr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo337[] = {{"CPGC_CADB_BUFA_6_", "", 0x00000338, 2, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields338[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "bank_addr", "The DRAM bank address.[br] Note: Not used in LPDDR2/3."},
#else
{24, 27, 0x0000000000000000, "RW", "bank_addr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 19, 0x0000000000000000, "RW", "row_col_addr", "The DRAM row/column address.[br][br]\r\n"
"LPDDR2/3 Maps the following:[br][br]\r\n"
"CA[9:0] rise=ROW_COL_ADDR[9:0][br][br]\r\n"
"CA[9:0] fall=ROW_COL_ADDR[19:10][br][br]\r\n"
"Note: Shared for DDR3 and LPDDR2/3. See ANN/CHV Dunit HAS for further information on the mapping."},
#else
{0, 19, 0x0000000000000000, "RW", "row_col_addr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo338[] = {{"CPGC_CADB_BUFA_7_", "", 0x0000033C, 2, 0x000000000FFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields339[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "par", "Used to write the parity invert CADB data. [br][br]\r\n"
"When working with DDR4 if this bit is set and the CADB entry is selected, the parity value is inverted to reflect a C/A parity error.[br][br]\r\n"
"See CADB Read_Write_Pointer for programming details."},
#else
{31, 31, 0x0000000000000000, "RW", "par", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "val", "Used to write the valid CADB data."},
#else
{30, 30, 0x0000000000000000, "RW", "val", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "cke", "The DRAM Clock Enable signals."},
#else
{24, 27, 0x0000000000000000, "RW", "cke", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "odt", "The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3."},
#else
{16, 19, 0x0000000000000000, "RW", "odt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000007, "RW", "cmd", "The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3."},
#else
{8, 11, 0x0000000000000007, "RW", "cmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 4, 0x0000000000000000, "RW", "cid", "The DRAM Chip ID."},
#else
{2, 4, 0x0000000000000000, "RW", "cid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000003, "RW", "cs", "The DRAM Chip Select signals [CS#]. These signals are active low and hence default is '1' on reset."},
#else
{0, 1, 0x0000000000000003, "RW", "cs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo339[] = {{"CPGC_CADB_BUFB_0_", "", 0x00000340, 7, 0x00000000FFFFFFFF, 0x0000000000000703}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields340[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "par", "Used to write the parity invert CADB data. [br][br]\r\n"
"When working with DDR4 if this bit is set and the CADB entry is selected, the parity value is inverted to reflect a C/A parity error.[br][br]\r\n"
"See CADB Read_Write_Pointer for programming details."},
#else
{31, 31, 0x0000000000000000, "RW", "par", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "val", "Used to write the valid CADB data."},
#else
{30, 30, 0x0000000000000000, "RW", "val", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "cke", "The DRAM Clock Enable signals."},
#else
{24, 27, 0x0000000000000000, "RW", "cke", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "odt", "The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3."},
#else
{16, 19, 0x0000000000000000, "RW", "odt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000007, "RW", "cmd", "The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3."},
#else
{8, 11, 0x0000000000000007, "RW", "cmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 4, 0x0000000000000000, "RW", "cid", "The DRAM Chip ID."},
#else
{2, 4, 0x0000000000000000, "RW", "cid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000003, "RW", "cs", "The DRAM Chip Select signals [CS#]. These signals are active low and hence default is '1' on reset."},
#else
{0, 1, 0x0000000000000003, "RW", "cs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo340[] = {{"CPGC_CADB_BUFB_1_", "", 0x00000344, 7, 0x00000000FFFFFFFF, 0x0000000000000703}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields341[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "par", "Used to write the parity invert CADB data. [br][br]\r\n"
"When working with DDR4 if this bit is set and the CADB entry is selected, the parity value is inverted to reflect a C/A parity error.[br][br]\r\n"
"See CADB Read_Write_Pointer for programming details."},
#else
{31, 31, 0x0000000000000000, "RW", "par", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "val", "Used to write the valid CADB data."},
#else
{30, 30, 0x0000000000000000, "RW", "val", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "cke", "The DRAM Clock Enable signals."},
#else
{24, 27, 0x0000000000000000, "RW", "cke", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "odt", "The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3."},
#else
{16, 19, 0x0000000000000000, "RW", "odt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000007, "RW", "cmd", "The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3."},
#else
{8, 11, 0x0000000000000007, "RW", "cmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 4, 0x0000000000000000, "RW", "cid", "The DRAM Chip ID."},
#else
{2, 4, 0x0000000000000000, "RW", "cid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000003, "RW", "cs", "The DRAM Chip Select signals [CS#]. These signals are active low and hence default is '1' on reset."},
#else
{0, 1, 0x0000000000000003, "RW", "cs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo341[] = {{"CPGC_CADB_BUFB_2_", "", 0x00000348, 7, 0x00000000FFFFFFFF, 0x0000000000000703}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields342[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "par", "Used to write the parity invert CADB data. [br][br]\r\n"
"When working with DDR4 if this bit is set and the CADB entry is selected, the parity value is inverted to reflect a C/A parity error.[br][br]\r\n"
"See CADB Read_Write_Pointer for programming details."},
#else
{31, 31, 0x0000000000000000, "RW", "par", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "val", "Used to write the valid CADB data."},
#else
{30, 30, 0x0000000000000000, "RW", "val", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "cke", "The DRAM Clock Enable signals."},
#else
{24, 27, 0x0000000000000000, "RW", "cke", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "odt", "The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3."},
#else
{16, 19, 0x0000000000000000, "RW", "odt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000007, "RW", "cmd", "The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3."},
#else
{8, 11, 0x0000000000000007, "RW", "cmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 4, 0x0000000000000000, "RW", "cid", "The DRAM Chip ID."},
#else
{2, 4, 0x0000000000000000, "RW", "cid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000003, "RW", "cs", "The DRAM Chip Select signals [CS#]. These signals are active low and hence default is '1' on reset."},
#else
{0, 1, 0x0000000000000003, "RW", "cs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo342[] = {{"CPGC_CADB_BUFB_3_", "", 0x0000034C, 7, 0x00000000FFFFFFFF, 0x0000000000000703}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields343[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "par", "Used to write the parity invert CADB data. [br][br]\r\n"
"When working with DDR4 if this bit is set and the CADB entry is selected, the parity value is inverted to reflect a C/A parity error.[br][br]\r\n"
"See CADB Read_Write_Pointer for programming details."},
#else
{31, 31, 0x0000000000000000, "RW", "par", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "val", "Used to write the valid CADB data."},
#else
{30, 30, 0x0000000000000000, "RW", "val", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "cke", "The DRAM Clock Enable signals."},
#else
{24, 27, 0x0000000000000000, "RW", "cke", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "odt", "The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3."},
#else
{16, 19, 0x0000000000000000, "RW", "odt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000007, "RW", "cmd", "The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3."},
#else
{8, 11, 0x0000000000000007, "RW", "cmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 4, 0x0000000000000000, "RW", "cid", "The DRAM Chip ID."},
#else
{2, 4, 0x0000000000000000, "RW", "cid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000003, "RW", "cs", "The DRAM Chip Select signals [CS#]. These signals are active low and hence default is '1' on reset."},
#else
{0, 1, 0x0000000000000003, "RW", "cs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo343[] = {{"CPGC_CADB_BUFB_4_", "", 0x00000350, 7, 0x00000000FFFFFFFF, 0x0000000000000703}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields344[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "par", "Used to write the parity invert CADB data. [br][br]\r\n"
"When working with DDR4 if this bit is set and the CADB entry is selected, the parity value is inverted to reflect a C/A parity error.[br][br]\r\n"
"See CADB Read_Write_Pointer for programming details."},
#else
{31, 31, 0x0000000000000000, "RW", "par", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "val", "Used to write the valid CADB data."},
#else
{30, 30, 0x0000000000000000, "RW", "val", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "cke", "The DRAM Clock Enable signals."},
#else
{24, 27, 0x0000000000000000, "RW", "cke", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "odt", "The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3."},
#else
{16, 19, 0x0000000000000000, "RW", "odt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000007, "RW", "cmd", "The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3."},
#else
{8, 11, 0x0000000000000007, "RW", "cmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 4, 0x0000000000000000, "RW", "cid", "The DRAM Chip ID."},
#else
{2, 4, 0x0000000000000000, "RW", "cid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000003, "RW", "cs", "The DRAM Chip Select signals [CS#]. These signals are active low and hence default is '1' on reset."},
#else
{0, 1, 0x0000000000000003, "RW", "cs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo344[] = {{"CPGC_CADB_BUFB_5_", "", 0x00000354, 7, 0x00000000FFFFFFFF, 0x0000000000000703}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields345[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "par", "Used to write the parity invert CADB data. [br][br]\r\n"
"When working with DDR4 if this bit is set and the CADB entry is selected, the parity value is inverted to reflect a C/A parity error.[br][br]\r\n"
"See CADB Read_Write_Pointer for programming details."},
#else
{31, 31, 0x0000000000000000, "RW", "par", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "val", "Used to write the valid CADB data."},
#else
{30, 30, 0x0000000000000000, "RW", "val", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "cke", "The DRAM Clock Enable signals."},
#else
{24, 27, 0x0000000000000000, "RW", "cke", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "odt", "The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3."},
#else
{16, 19, 0x0000000000000000, "RW", "odt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000007, "RW", "cmd", "The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3."},
#else
{8, 11, 0x0000000000000007, "RW", "cmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 4, 0x0000000000000000, "RW", "cid", "The DRAM Chip ID."},
#else
{2, 4, 0x0000000000000000, "RW", "cid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000003, "RW", "cs", "The DRAM Chip Select signals [CS#]. These signals are active low and hence default is '1' on reset."},
#else
{0, 1, 0x0000000000000003, "RW", "cs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo345[] = {{"CPGC_CADB_BUFB_6_", "", 0x00000358, 7, 0x00000000FFFFFFFF, 0x0000000000000703}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields346[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "par", "Used to write the parity invert CADB data. [br][br]\r\n"
"When working with DDR4 if this bit is set and the CADB entry is selected, the parity value is inverted to reflect a C/A parity error.[br][br]\r\n"
"See CADB Read_Write_Pointer for programming details."},
#else
{31, 31, 0x0000000000000000, "RW", "par", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "val", "Used to write the valid CADB data."},
#else
{30, 30, 0x0000000000000000, "RW", "val", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "cke", "The DRAM Clock Enable signals."},
#else
{24, 27, 0x0000000000000000, "RW", "cke", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "odt", "The DRAM On-Die Termination Signals.[br] Note: Not used in LPDDR2/3."},
#else
{16, 19, 0x0000000000000000, "RW", "odt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000007, "RW", "cmd", "The DRAM command signals [ACT#,RAS#,CAS#,WE#]. All three signals are active low and hence default to '1's on reset.[br] Note: Not used in LPDDR2/3."},
#else
{8, 11, 0x0000000000000007, "RW", "cmd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 4, 0x0000000000000000, "RW", "cid", "The DRAM Chip ID."},
#else
{2, 4, 0x0000000000000000, "RW", "cid", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000003, "RW", "cs", "The DRAM Chip Select signals [CS#]. These signals are active low and hence default is '1' on reset."},
#else
{0, 1, 0x0000000000000003, "RW", "cs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo346[] = {{"CPGC_CADB_BUFB_7_", "", 0x0000035C, 7, 0x00000000FFFFFFFF, 0x0000000000000703}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields347[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RO/V", "uniseq_stat", "The current contents of the command/address pattern unified sequencer buffer.  In case a stop condition occurs, this register will contain the last value that was used to generate the command/address pattern.  Bit 0 represents the value used for the current chunk."},
#else
{0, 15, 0x0000000000000000, "RO/V", "uniseq_stat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo347[] = {{"CPGC_CADB_UNISEQ0STAT", "", 0x00000360, 1, 0x000000000000FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields348[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RO/V", "uniseq_stat", "The current contents of the command/address pattern unified sequencer buffer.  In case a stop condition occurs, this register will contain the last value that was used to generate the command/address pattern.  Bit 0 represents the value used for the current chunk."},
#else
{0, 15, 0x0000000000000000, "RO/V", "uniseq_stat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo348[] = {{"CPGC_CADB_UNISEQ1STAT", "", 0x00000364, 1, 0x000000000000FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields349[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RO/V", "uniseq_stat", "The current contents of the command/address pattern unified sequencer buffer.  In case a stop condition occurs, this register will contain the last value that was used to generate the command/address pattern.  Bit 0 represents the value used for the current chunk."},
#else
{0, 15, 0x0000000000000000, "RO/V", "uniseq_stat", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo349[] = {{"CPGC_CADB_UNISEQ2STAT", "", 0x00000368, 1, 0x000000000000FFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields350[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "memtech", "Memory Technology\r\n"
"Bit 3:0: DRAM Technology\r\n"
"0000: LPDDR3\r\n"
"0001: LPDDR4\r\n"
"0010: DDR3/L/U\r\n"
"0011: DDR4/L\r\n"
"0100: WIO2\r\n"
"0101: FMI\r\n"
"0110: DDR-T\r\n"
"0111: HBM"},
#else
{28, 31, 0x0000000000000000, "RW", "memtech", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "memfreq", "Memory frequency\r\n"
"Bit 3:0 DRAM Frequency\r\n"
"0000: 800\r\n"
"0001: 1066\r\n"
"0010: 1333\r\n"
"0011: 1600\r\n"
"0100: 1866\r\n"
"0101: 2133\r\n"
"0110: 2400"},
#else
{24, 27, 0x0000000000000000, "RW", "memfreq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "phyupd_dly", "Delay between the phy update request to ack \r\n"
"in terms of SPID clocks."},
#else
{16, 23, 0x0000000000000000, "RW", "phyupd_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RW", "stretchmode", "This is the stretch mode signal.\r\n"
"00- normal read\r\n"
"01- x4 stretch mode \r\n"
"10- x8 stretch mode\r\n"
"11- x16 stretch mode"},
#else
{13, 14, 0x0000000000000000, "RW", "stretchmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{12, 12, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "slowpath", "When enabled, SPID wrcmd is delayed by 1 spidclk before writing into the fifo.\r\n"
"Set to 1 if clock gating is enabled. Else set it to 0. \r\n"
"\r\n"
"1: 1 spidclk delay \r\n"
"0: no delay"},
#else
{11, 11, 0x0000000000000000, "RW", "slowpath", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{10, 10, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "rdmcpsel", "Programmable MCP for Tx FIFO read pointer path.\r\n"
"\r\n"
"1: Enable MCP path \r\n"
"0: Disable MCP path"},
#else
{9, 9, 0x0000000000000000, "RW", "rdmcpsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 8, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "ca_training", "CA training mode"},
#else
{6, 6, 0x0000000000000000, "RW", "ca_training", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "bl1632xbl48b", "This is the burstlength configuration register\r\n"
"1:BL16 and BL32\r\n"
"0:BL4 and BL8"},
#else
{5, 5, 0x0000000000000000, "RW", "bl1632xbl48b", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 4, 0x0000000000000000, "RW", "spidclksel", "SPID clk sel \r\n"
"00: 0.5xmode\r\n"
"01: 0.25x mode\r\n"
"10: 0.1x mode\r\n"
"11: NA"},
#else
{3, 4, 0x0000000000000000, "RW", "spidclksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "lpddr34mode", "Single data rate v/s Double Data rate \r\n"
"0: Double data rate (LP3)\r\n"
"1: Single data rate (LP4)"},
#else
{2, 2, 0x0000000000000000, "RW", "lpddr34mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{0, 1, 0x0000000000000000, "RO", "reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo350[] = {{"DIGCTL", "", 0x00000000, 15, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields351[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "siggrp02_invph0to180", "DBMUX Phase 180 Clock Selection\r\n"
"0: Phase180 clock from DLL Phase Interpolator (LP* Modes)\r\n"
"1: Phase180 clock from Phase0 clock inversion (DDR3L/DDR4 Mode)"},
#else
{30, 30, 0x0000000000000000, "RW", "siggrp02_invph0to180", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW", "siggrp01_invph0to180", "DBMUX Phase 180 Clock Selection\r\n"
"0: Phase180 clock from DLL Phase Interpolator (LP* Modes)\r\n"
"1: Phase180 clock from Phase0 clock inversion (DDR3L/DDR4 Mode)"},
#else
{29, 29, 0x0000000000000000, "RW", "siggrp01_invph0to180", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "siggrp00_invph0to180", "DBMUX Phase 180 Clock Selection\r\n"
"0: Phase180 clock from DLL Phase Interpolator (LP* Modes)\r\n"
"1: Phase180 clock from Phase0 clock inversion (DDR3L/DDR4 Mode)"},
#else
{28, 28, 0x0000000000000000, "RW", "siggrp00_invph0to180", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "compclkrdptrinit", "DLL comp init configuration."},
#else
{24, 27, 0x0000000000000000, "RW", "compclkrdptrinit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RW", "compclkrdptroffset", "DLL comp read pointer offset."},
#else
{21, 23, 0x0000000000000000, "RW", "compclkrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 20, 0x0000000000000000, "RW", "ref1xrdptrinit", "This is the ref1x read pointer init configuration."},
#else
{17, 20, 0x0000000000000000, "RW", "ref1xrdptrinit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dqxccb", "Configure DQCCC as DQ or CCC\r\n"
"0: CCC\r\n"
"1: DQ\r\n"
"This signal is invalid for BXT-P"},
#else
{16, 16, 0x0000000000000000, "RW", "dqxccb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "ref1xrdptroffset", "This is the ref1xread pointer offset configuration."},
#else
{13, 15, 0x0000000000000000, "RW", "ref1xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "ref2xrdptrinit", "This is the ref2x read pointer init configuration."},
#else
{8, 12, 0x0000000000000000, "RW", "ref2xrdptrinit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "cc_doublefifooffset", "This is the double FIFO offset configuration(in terms of 2xclock)."},
#else
{4, 7, 0x0000000000000000, "RW", "cc_doublefifooffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "bl_doublefifooffset", "This is the double FIFO offset configuration(in terms of 2xclock)."},
#else
{0, 3, 0x0000000000000000, "RW", "bl_doublefifooffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo351[] = {{"FIFOPTRCTL", "", 0x00000004, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields352[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{2, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{2, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "rxfiforst_b", "Rxfifo reset (active low)\r\n"
"1: deasserted\r\n"
"0 : asserted"},
#else
{1, 1, 0x0000000000000000, "RW", "rxfiforst_b", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "spidrst_b", "Reset for functional logic in upartition (except compensation and power management logic)  \r\n"
"0: Reset assertion  \r\n"
"1: Reset de-assertion"},
#else
{0, 0, 0x0000000000000000, "RW", "spidrst_b", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo352[] = {{"DIGRSTCTL", "", 0x00000008, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields353[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{1, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "wrptren", "Tx FIFO write pointer enable. \r\n"
"0: Disable\r\n"
"1: Enable"},
#else
{0, 0, 0x0000000000000000, "RW", "wrptren", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo353[] = {{"FIFOPTREN", "", 0x0000000C, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields354[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{2, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{2, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "lvl_cc_iobufactafe", "IO buffer activate - DQ BL1 Analog\r\n"
"Tristates DQ and DQS IO buffers \r\n"
"Disable Rx sections of IO buffers \r\n"
"0 : Disable IO buffers \r\n"
"1 : Enable IO buffers"},
#else
{1, 1, 0x0000000000000000, "RW", "lvl_cc_iobufactafe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "lvl_bl_iobufactafe", "IO buffer activate - DQ BL0 Analog\r\n"
"Tristates DQ and DQS IO buffers \r\n"
"Disable Rx sections of IO buffers \r\n"
"0 : Disable IO buffers \r\n"
"1 : Enable IO buffers"},
#else
{0, 0, 0x0000000000000000, "RW", "lvl_bl_iobufactafe", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo354[] = {{"IOBUFACT_AFE", "", 0x00000010, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields355[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{2, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{2, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "cc_iobufactdig", "IO buffer activate - DQ BL1 Digital.\r\n"
"This resets the intermediate/final flops in the transmit path.\r\n"
"\r\n"
"0 : Assert reset \r\n"
"1 : De-assert reset"},
#else
{1, 1, 0x0000000000000000, "RW", "cc_iobufactdig", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "bl_iobufactdig", "IO buffer activate - DQ BL0 Digital.\r\n"
"This resets the intermediate/final flops in the transmit path.\r\n"
"\r\n"
"0 : Assert reset \r\n"
"1 : De-assert reset"},
#else
{0, 0, 0x0000000000000000, "RW", "bl_iobufactdig", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo355[] = {{"IOBUFACT_DIG", "", 0x00000014, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields356[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{1, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "spid_init_complete", "SPID init complete"},
#else
{0, 0, 0x0000000000000000, "RW", "spid_init_complete", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo356[] = {{"SPIDIC", "", 0x00000018, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields357[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "early_dqen", "Early DQ Enable"},
#else
{16, 16, 0x0000000000000000, "RW", "early_dqen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "cc_dqdrvenbph1", "First data phase setting for BL1 DQ driver enable. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{14, 15, 0x0000000000000000, "RW", "cc_dqdrvenbph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW", "cc_dqdrvenbpream1", "Preamble 1 setting for BL1 DQ driver enable. This is applicable only if 2tCK write preamble mode is enabled.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{12, 13, 0x0000000000000000, "RW", "cc_dqdrvenbpream1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW", "cc_dqdrvenblastph", "Last data phase setting for BL1 DQ driver enable. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{10, 11, 0x0000000000000000, "RW", "cc_dqdrvenblastph", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "cc_dqdrvenbpream0", "Preamble 0 setting for BL1 DQ driver enable\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{8, 9, 0x0000000000000000, "RW", "cc_dqdrvenbpream0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RW", "bl_dqdrvenbph1", "First data phase setting for BL0 DQ driver enable. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{6, 7, 0x0000000000000000, "RW", "bl_dqdrvenbph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "bl_dqdrvenbpream1", "Preamble 1 setting for BL0 DQ driver enable. This is applicable only if 2tCK write preamble mode is enabled.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{4, 5, 0x0000000000000000, "RW", "bl_dqdrvenbpream1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RW", "bl_dqdrvenblastph", "Last data phase setting for BL0 DQ driver enable. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{2, 3, 0x0000000000000000, "RW", "bl_dqdrvenblastph", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "bl_dqdrvenbpream0", "Preamble 0 setting for BL0 DQ driver enable\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{0, 1, 0x0000000000000000, "RW", "bl_dqdrvenbpream0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo357[] = {{"WRDQCTL", "", 0x0000001C, 10, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields358[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RW", "cc_dqsdrvenbph1", "First data phase setting for BL1 DQS driver enable. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{30, 31, 0x0000000000000000, "RW", "cc_dqsdrvenbph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RW", "cc_dqsdrvenbpream1", "Preamble 1 setting for BL1 DQS driver enable. This is applicable only if 2tCK write preamble mode is enabled.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{28, 29, 0x0000000000000000, "RW", "cc_dqsdrvenbpream1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RW", "cc_dqsdrvenblastph", "Last data phase setting for BL1 DQS driver enable. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{26, 27, 0x0000000000000000, "RW", "cc_dqsdrvenblastph", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "cc_dqsdrvenbpream0", "Preamble 0 setting for BL1 DQS driver enable\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{24, 25, 0x0000000000000000, "RW", "cc_dqsdrvenbpream0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "cc_dmdrven", "BL1 Data mask drive enable\r\n"
"1: Enable DM buffer\r\n"
"0: Tristate DM buffer"},
#else
{20, 20, 0x0000000000000000, "RW", "cc_dmdrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "cc_wrpream0en", "2tCK write preamble mode for BL1\r\n"
"0 : 1 tCK write preamble mode\r\n"
"1 : 2 tCK write preamble mode"},
#else
{19, 19, 0x0000000000000000, "RW", "cc_wrpream0en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RO", "reserved", "TBD"},
#else
{18, 18, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000003, "RW", "cc_dqsdrvenbidle", "Idle phase setting for BL1 DQS data. \r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{16, 17, 0x0000000000000003, "RW", "cc_dqsdrvenbidle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "cc_dqsdataph1", "First data phase setting for BL1 DQS data. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{14, 15, 0x0000000000000000, "RW", "cc_dqsdataph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW", "cc_dqsdatapream1", "Preamble 1 setting for BL1 DQS data. This is applicable only in case of 2tCK write preamble case.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{12, 13, 0x0000000000000000, "RW", "cc_dqsdatapream1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW", "cc_dqsdatalastph", "Last data phase setting for BL1 DQS data. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{10, 11, 0x0000000000000000, "RW", "cc_dqsdatalastph", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "cc_dqsdatapream0", "Preamble 0 setting for BL1 DQS data\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{8, 9, 0x0000000000000000, "RW", "cc_dqsdatapream0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "cc_wrcmd2dqsstart", "Write command to BL1 DQS start delay. This is in ref1xclks."},
#else
{0, 5, 0x0000000000000000, "RW", "cc_wrcmd2dqsstart", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo358[] = {{"WRDQSCTL_CC", "", 0x00000020, 15, 0x00000000FFFFFFFF, 0x0000000000030000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields359[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RW", "bl_dqsdrvenbph1", "First data phase setting for BL0 DQS driver enable. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{30, 31, 0x0000000000000000, "RW", "bl_dqsdrvenbph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RW", "bl_dqsdrvenbpream1", "Preamble 1 setting for BL0 DQS driver enable. This is applicable only if 2tCK write preamble mode is enabled.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{28, 29, 0x0000000000000000, "RW", "bl_dqsdrvenbpream1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RW", "bl_dqsdrvenblastph", "Last data phase setting for BL0 DQS driver enable. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{26, 27, 0x0000000000000000, "RW", "bl_dqsdrvenblastph", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "bl_dqsdrvenbpream0", "Preamble 0 setting for BL0 DQS driver enable\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{24, 25, 0x0000000000000000, "RW", "bl_dqsdrvenbpream0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "bl_dmdrven", "BL0 Data mask drive enable\r\n"
"1: Enable DM buffer\r\n"
"0: Tristate DM buffer"},
#else
{20, 20, 0x0000000000000000, "RW", "bl_dmdrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "bl_wrpream0en", "2tCK write preamble mode for BL0\r\n"
"0 : 1 tCK write preamble mode\r\n"
"1 : 2 tCK write preamble mode"},
#else
{19, 19, 0x0000000000000000, "RW", "bl_wrpream0en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RO", "reserved", "TBD"},
#else
{18, 18, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000003, "RW", "bl_dqsdrvenbidle", "Idle phase setting for BL0 DQS data. \r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{16, 17, 0x0000000000000003, "RW", "bl_dqsdrvenbidle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "bl_dqsdataph1", "First data phase setting for BL0 DQS data. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{14, 15, 0x0000000000000000, "RW", "bl_dqsdataph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW", "bl_dqsdatapream1", "Preamble 1 setting for BL0 DQS data. This is applicable only in case of 2tCK write preamble case.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{12, 13, 0x0000000000000000, "RW", "bl_dqsdatapream1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW", "bl_dqsdatalastph", "Last data phase setting for BL0 DQS data. For regular writes, this needs to be set to 00.\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{10, 11, 0x0000000000000000, "RW", "bl_dqsdatalastph", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "bl_dqsdatapream0", "Preamble 0 setting for BL0 DQS data\r\n"
"\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 (illegal)\r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{8, 9, 0x0000000000000000, "RW", "bl_dqsdatapream0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "bl_wrcmd2dqsstart", "Write command to BL0 DQS start delay. This is in ref1xclks."},
#else
{0, 5, 0x0000000000000000, "RW", "bl_wrcmd2dqsstart", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo359[] = {{"WRDQSCTL_BL", "", 0x00000024, 15, 0x00000000FFFFFFFF, 0x0000000000030000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields360[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "rdcmd2rdvld_bonus", "Read command 2 read bonus bits."},
#else
{16, 23, 0x0000000000000000, "RW", "rdcmd2rdvld_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "rdcmd2rdvld_plus1sel", "Read command 2 read valid plus 1 sel."},
#else
{12, 14, 0x0000000000000000, "RW", "rdcmd2rdvld_plus1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "earlyrdvld", "This controls the delay between the read valid assertion to SOC and the actual read valid assertion\r\n"
"0: Normal\r\n"
"1: 1 spidclk early \r\n"
"2: 2 spidclk early\r\n"
"3: 3 spidclk early\r\n"
"4: 4 spidclk early\r\n"
"4+: Illegal"},
#else
{8, 10, 0x0000000000000000, "RW", "earlyrdvld", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "rdcmd2rdvld", "This is the read command to read valid register.\r\n"
"This is in terms of spidclk."},
#else
{0, 5, 0x0000000000000000, "RW", "rdcmd2rdvld", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo360[] = {{"RDVLDCTL", "", 0x00000028, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields361[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{14, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{14, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 13, 0x0000000000000000, "RW", "dqx_rk2rkswitch_dlyen", "Adds an extra 1x clock of delay between rdptr freeze and dq/dqs PI code change during write based rk2rk switch.\r\n"
"1: Add 1 extra ref1xclk of delay \r\n"
"0: No delay"},
#else
{13, 13, 0x0000000000000000, "RW", "dqx_rk2rkswitch_dlyen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000000, "RW", "rcv_rk2rkswitch_dlyen", "Adds an extra 1x clock of delay between rdptr freeze and rcven PI code change during read based rk2rk switch.\r\n"
"1: Add 1 extra ref1xclk of delay \r\n"
"0: No delay"},
#else
{12, 12, 0x0000000000000000, "RW", "rcv_rk2rkswitch_dlyen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_iodrven", "Adds an extra 2x clock of delay between rdptr freeze and dq/dqs drive enable override during write based rk2rk switch.\r\n"
"1: Add 1 extra 2xclk of delay\r\n"
"0: No delay"},
#else
{10, 10, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_iodrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txrden", "Adds an extra 2x clock of delay between rdptr freeze and rcven override assertion during read based rk2rk switch.\r\n"
"1: Add 1 extra 2xclk of delay \r\n"
"0: No delay"},
#else
{9, 9, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txrden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txrcven", "Adds an extra clock of delay between rdptr freeze and rcven/rxodten pushout code change during read based rk2rk switch.\r\n"
"1: Add 1 extra 2xclk of delay \r\n"
"0: No delay\r\n"
"\r\n"
"This is applicable for rcven coarse/fine/dbsel/2xrdptroffset and rxodten 2xrdptroffset"},
#else
{8, 8, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txrcven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "cc_rk2rken_txdqs_pi", "Rank to Rank switch enable for BL1 tx dqs\r\n"
"0 : Disable rk2rk switch\r\n"
"1 : Disable rk2rk switch"},
#else
{7, 7, 0x0000000000000000, "RW", "cc_rk2rken_txdqs_pi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "cc_rk2rken_txdq_pi", "Rank to Rank switch enable for Bl1 tx dq\r\n"
"0 : Disable rk2rk switch\r\n"
"1 : Disable rk2rk switch"},
#else
{6, 6, 0x0000000000000000, "RW", "cc_rk2rken_txdq_pi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "bl_rk2rken_txdqs_pi", "Rank to Rank switch enable for BL0 tx dqs\r\n"
"0 : Disable rk2rk switch\r\n"
"1 : Disable rk2rk switch"},
#else
{5, 5, 0x0000000000000000, "RW", "bl_rk2rken_txdqs_pi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "bl_rk2rken_txdq_pi", "Rank to Rank switch enable for BL0 tx dq\r\n"
"0 : Disable rk2rk switch\r\n"
"1 : Disable rk2rk switch"},
#else
{4, 4, 0x0000000000000000, "RW", "bl_rk2rken_txdq_pi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "cc_rk2rken_rxdq_pi", "Rank to Rank switch enable for BL1 rx dqs\r\n"
"0 : Disable rk2rk switch\r\n"
"1 : Disable rk2rk switch"},
#else
{3, 3, 0x0000000000000000, "RW", "cc_rk2rken_rxdq_pi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "cc_rk2rken_txrcven", "Rank to Rank switch enable for BL1 rcven\r\n"
"0 : Disable rk2rk switch\r\n"
"1 : Disable rk2rk switch"},
#else
{2, 2, 0x0000000000000000, "RW", "cc_rk2rken_txrcven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "bl_rk2rken_rxdq_pi", "Rank to Rank switch enable for BL0 rx dqs\r\n"
"0 : Disable rk2rk switch\r\n"
"1 : Disable rk2rk switch"},
#else
{1, 1, 0x0000000000000000, "RW", "bl_rk2rken_rxdq_pi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "bl_rk2rken_txrcven", "Rank to Rank switch enable for BL0 rcven\r\n"
"0 : Disable rk2rk switch\r\n"
"1 : Disable rk2rk switch"},
#else
{0, 0, 0x0000000000000000, "RW", "bl_rk2rken_txrcven", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo361[] = {{"RK2RKCTL1", "", 0x0000002C, 15, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields362[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "rk2rkdrvenbcode_3rd", "Length of dq/dqs drv enable override during write based rk2rk switching. This, along with preamble and postamble \r\n"
"setting, contributes to the total length of the dq/dqs drv enable override during rk2rk switching.\r\n"
"This is in ref1xclks."},
#else
{28, 31, 0x0000000000000000, "RW", "rk2rkdrvenbcode_3rd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "rk2rkrdencode_3rd", "Length of rcven override during read based rk2rk switching. This, along with preamble and postamble setting, \r\n"
"contributes to the total length of the rcven override during rk2rk switching.\r\n"
"This is in ref1xclks."},
#else
{24, 27, 0x0000000000000000, "RW", "rk2rkrdencode_3rd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_rxdq", "Adds an extra clock of delay between rcven override and Rx DQS DLL pushout code change during read based rk2rk switch.\r\n"
"1: Add 1 extra 2xclk of delay \r\n"
"0: No delay\r\n"
"\r\n"
"This is applicable for Rx DLL DQS HI/LO fine/coarse."},
#else
{23, 23, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_rxdq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txdqs", "Adds an extra clock of delay between rdptr freeze and DQS data/ DQS drive enable pushout code change during write based rk2rk switch.\r\n"
"1: Add 1 extra 2xclk of delay \r\n"
"0: No delay\r\n"
"\r\n"
"This is applicable for dqs coarse/fine/dbsel/2xrdptroffset and dqs second rdport's 2xrdptroffset"},
#else
{22, 22, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txdqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txdq", "Adds an extra clock of delay between rdptr freeze and DQ data/DQ drive enable pushout code change during write based rk2rk switch.\r\n"
"1: Add 1 extra 2xclk of delay \r\n"
"0: No delay\r\n"
"\r\n"
"This is applicable for dq data's and dq drive enable's coarse/fine/dbsel/2xrdptroffset and also their second rdport's 2xrdptroffset"},
#else
{21, 21, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txdq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 20, 0x0000000000000000, "RW", "wrcmd2rkchglatency", "Delay between spid wrcmd (that requires a rank switch) and rank change detection logic.\r\n"
"This is in terms of ref1xclks."},
#else
{15, 20, 0x0000000000000000, "RW", "wrcmd2rkchglatency", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 14, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{14, 14, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 13, 0x0000000000000000, "RW", "rdcmd2rkchglatency", "Delay between spid rdcmd (that requires a rank switch) and rank change detection logic.\r\n"
"This is in terms of ref1xclks."},
#else
{8, 13, 0x0000000000000000, "RW", "rdcmd2rkchglatency", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RW", "rk2rkdrvenbcode_2nd", "Postamble setting for dq/dqs drv enable override during rk2rk switching\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 \r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{6, 7, 0x0000000000000000, "RW", "rk2rkdrvenbcode_2nd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "rk2rkdrvenbcode_1st", "Preamble setting for dq/dqs drv enable override during rk2rk switching\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 \r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{4, 5, 0x0000000000000000, "RW", "rk2rkdrvenbcode_1st", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RW", "rk2rkrdencode_2nd", "Postamble setting for rcven override during rk2rk switching\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 \r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{2, 3, 0x0000000000000000, "RW", "rk2rkrdencode_2nd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "rk2rkrdencode_1st", "Preamble setting for rcven override during rk2rk switching\r\n"
"00 : Drive 0 for UI0, Drive 0 for UI1\r\n"
"01 : Drive 1 for UI0, Drive 0 for UI1 (illegal)\r\n"
"10 : Drive 0 for UI0, Drive 1 for UI1 \r\n"
"11 : Drive 1 for UI0, Drive 1 for UI1"},
#else
{0, 1, 0x0000000000000000, "RW", "rk2rkrdencode_1st", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo362[] = {{"RK2RKCTL0", "", 0x00000030, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields363[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RW", "cc_rxodtsegovrval", "Receive ODT segment enable override value."},
#else
{29, 31, 0x0000000000000000, "RW", "cc_rxodtsegovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "cc_rxodtsegovrsel", "Receive ODT segment enable override select.\r\n"
"0= Dynamic  control\r\n"
"1= Static  control"},
#else
{28, 28, 0x0000000000000000, "RW", "cc_rxodtsegovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 27, 0x0000000000000000, "RW", "rk1_odtsegenrdptroffset", "Receive ODT segment enable read pointer offset."},
#else
{23, 27, 0x0000000000000000, "RW", "rk1_odtsegenrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{22, 22, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "cc_rxodtsegtwohot", "This is the RXODTSEGEN one hot enable\r\n"
"0- rxodtsegen: 001->010->100\r\n"
"1-rxodtsegen: 011->110->101"},
#else
{21, 21, 0x0000000000000000, "RW", "cc_rxodtsegtwohot", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 20, 0x0000000000000000, "RW", "cc_rxodtseglenbl4", "This is the receive ODT segment enable length configuration register.\r\n"
"It's in number of 1x clocks."},
#else
{15, 20, 0x0000000000000000, "RW", "cc_rxodtseglenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RW", "cc_rxodtsegpst1", "This is the receive ODT segment enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{13, 14, 0x0000000000000000, "RW", "cc_rxodtsegpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 12, 0x0000000000000000, "RW", "cc_rxodtsegpre1", "This is the receive ODT segment enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{11, 12, 0x0000000000000000, "RW", "cc_rxodtsegpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 10, 0x0000000000000000, "RW", "cc_rxodtsegpst0", "This is the receive ODT segment enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{9, 10, 0x0000000000000000, "RW", "cc_rxodtsegpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW", "cc_rxodtsegpre0", "This is the receive ODT segment enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{7, 8, 0x0000000000000000, "RW", "cc_rxodtsegpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 6, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "cc_rdcmd2rxodtseg", "This is the receive ODT segment enable latency configuration register."},
#else
{0, 5, 0x0000000000000000, "RW", "cc_rdcmd2rxodtseg", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo363[] = {{"RXODTSEGCTL_BL13", "", 0x00000034, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields364[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RW", "bl_rxodtsegovrval", "Receive ODT segment enable override value. \r\n"
"0: De-assert receive ODT enable \r\n"
"1: Assert receive ODT enable"},
#else
{29, 31, 0x0000000000000000, "RW", "bl_rxodtsegovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "bl_rxodtsegovrsel", "Receive ODT segment enable override select.\r\n"
"0= Dynamic  receive ODT control\r\n"
"1= Static  receive ODT control"},
#else
{28, 28, 0x0000000000000000, "RW", "bl_rxodtsegovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 27, 0x0000000000000000, "RW", "rk0_odtsegenrdptroffset", "Receive ODT segment enable read pointer offset."},
#else
{23, 27, 0x0000000000000000, "RW", "rk0_odtsegenrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RO", "reserved", "Reseved bits"},
#else
{22, 22, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "bl_rxodtsegtwohot", "This is the RXODTSEGEN one hot enable\r\n"
"0- rxodtsegen: 001->010->100\r\n"
"1-rxodtsegen: 011->110->101"},
#else
{21, 21, 0x0000000000000000, "RW", "bl_rxodtsegtwohot", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 20, 0x0000000000000000, "RW", "bl_rxodtseglenbl4", "This is the receive ODT segment enable length configuration register.\r\n"
"It's in number of 1x clocks."},
#else
{15, 20, 0x0000000000000000, "RW", "bl_rxodtseglenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RW", "bl_rxodtsegpst1", "This is the receive ODT segment enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{13, 14, 0x0000000000000000, "RW", "bl_rxodtsegpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 12, 0x0000000000000000, "RW", "bl_rxodtsegpre1", "This is the receive ODT segment enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{11, 12, 0x0000000000000000, "RW", "bl_rxodtsegpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 10, 0x0000000000000000, "RW", "bl_rxodtsegpst0", "This is the receive ODT segment enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{9, 10, 0x0000000000000000, "RW", "bl_rxodtsegpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW", "bl_rxodtsegpre0", "This is the receive ODT segment enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{7, 8, 0x0000000000000000, "RW", "bl_rxodtsegpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 6, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "bl_rdcmd2rxodtseg", "This is the receive ODT segment enable latency configuration register."},
#else
{0, 5, 0x0000000000000000, "RW", "bl_rdcmd2rxodtseg", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo364[] = {{"RXODTSEGCTL_BL02", "", 0x00000038, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields365[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000000, "RW", "rk1_odtenrdptroffset", "This is receive ODT enable read pointer offset."},
#else
{27, 31, 0x0000000000000000, "RW", "rk1_odtenrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "cc_dqsrxodtenovrval", "Rx DQS odt enable override value - DQ BL1 lane \r\n"
"0: De-assert receive enable \r\n"
"1: Assert receive enable"},
#else
{26, 26, 0x0000000000000000, "RW", "cc_dqsrxodtenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "cc_dqsrxodtenovrsel", "Rx DQS odt enable override select- DQ BL1 lane \r\n"
"0= Dynamic RCVEN control\r\n"
"1= Static RCVEN control"},
#else
{25, 25, 0x0000000000000000, "RW", "cc_dqsrxodtenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "cc_rxodtenovrval", "Receive ODT enable override value. \r\n"
"0: De-assert receive enable \r\n"
"1: Assert receive enable"},
#else
{24, 24, 0x0000000000000000, "RW", "cc_rxodtenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "cc_rxodtenovrsel", "Receive ODT enable override select.\r\n"
"0= Dynamic RCVEN control\r\n"
"1= Static RCVEN control"},
#else
{23, 23, 0x0000000000000000, "RW", "cc_rxodtenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 22, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 22, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 20, 0x0000000000000000, "RW", "cc_rxodtenlenbl4", "This is the receive ODT enable length configuration register.\r\n"
"It's in number of 1x clocks."},
#else
{15, 20, 0x0000000000000000, "RW", "cc_rxodtenlenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RW", "cc_rxodtenpst1", "This is the receive ODT enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{13, 14, 0x0000000000000000, "RW", "cc_rxodtenpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 12, 0x0000000000000000, "RW", "cc_rxodtenpre1", "This is the receive ODT enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{11, 12, 0x0000000000000000, "RW", "cc_rxodtenpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 10, 0x0000000000000000, "RW", "cc_rxodtenpst0", "This is the receive ODT enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{9, 10, 0x0000000000000000, "RW", "cc_rxodtenpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW", "cc_rxodtenpre0", "This is the receive ODT enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{7, 8, 0x0000000000000000, "RW", "cc_rxodtenpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 6, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "cc_rdcmd2rxodten", "This is the receive ODT enable latency configuration register."},
#else
{0, 5, 0x0000000000000000, "RW", "cc_rdcmd2rxodten", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo365[] = {{"RXODTCTL_BL13", "", 0x0000003C, 13, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields366[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000000, "RW", "rk0_odtenrdptroffset", "This is receive ODT enable read pointer offset."},
#else
{27, 31, 0x0000000000000000, "RW", "rk0_odtenrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "bl_dqsrxodtenovrval", "Rx DQS odt enable override value - DQ BL0 lane \r\n"
"0: De-assert receive enable \r\n"
"1: Assert receive enable"},
#else
{26, 26, 0x0000000000000000, "RW", "bl_dqsrxodtenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "bl_dqsrxodtenovrsel", "Rx DQS odt enable override select- DQ BL0 lane \r\n"
"0= Dynamic RCVEN control\r\n"
"1= Static RCVEN control"},
#else
{25, 25, 0x0000000000000000, "RW", "bl_dqsrxodtenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "bl_rxodtenovrval", "Receive ODT enable override value. \r\n"
"0: De-assert receive enable \r\n"
"1: Assert receive enable"},
#else
{24, 24, 0x0000000000000000, "RW", "bl_rxodtenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "bl_rxodtenovrsel", "Receive ODT enable override select.\r\n"
"0= Dynamic RCVEN control\r\n"
"1= Static RCVEN control"},
#else
{23, 23, 0x0000000000000000, "RW", "bl_rxodtenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 22, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 22, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 20, 0x0000000000000000, "RW", "bl_rxodtenlenbl4", "This is the receive ODT enable length configuration register.\r\n"
"It's in number of 1x clocks."},
#else
{15, 20, 0x0000000000000000, "RW", "bl_rxodtenlenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RW", "bl_rxodtenpst1", "This is the receive ODT enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{13, 14, 0x0000000000000000, "RW", "bl_rxodtenpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 12, 0x0000000000000000, "RW", "bl_rxodtenpre1", "This is the receive ODT enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{11, 12, 0x0000000000000000, "RW", "bl_rxodtenpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 10, 0x0000000000000000, "RW", "bl_rxodtenpst0", "This is the receive ODT enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{9, 10, 0x0000000000000000, "RW", "bl_rxodtenpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW", "bl_rxodtenpre0", "This is the receive ODT enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{7, 8, 0x0000000000000000, "RW", "bl_rxodtenpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 6, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "bl_rdcmd2rxodten", "This is the receive ODT enable latency configuration register."},
#else
{0, 5, 0x0000000000000000, "RW", "bl_rdcmd2rxodten", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo366[] = {{"RXODTCTL_DQ", "", 0x00000040, 13, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields367[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "drx_cc_rcvsmpl", "AFE status register - RCVSMPL - CC"},
#else
{31, 31, 0x0000000000000000, "RO", "drx_cc_rcvsmpl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 30, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "drx_cc_rcvenflopbypass", "DQS counter flop override"},
#else
{28, 28, 0x0000000000000000, "RW", "drx_cc_rcvenflopbypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RW", "drx_cc_dqscountrstb", "DQS counter reset"},
#else
{27, 27, 0x0000000000000000, "RW", "drx_cc_dqscountrstb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "cc_rcvenmargin", "Receive enable margining data"},
#else
{26, 26, 0x0000000000000000, "RW", "cc_rcvenmargin", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "cc_rcvenovrval", "Receive enable override value. \r\n"
"0: De-assert receive enable \r\n"
"1: Assert receive enable"},
#else
{25, 25, 0x0000000000000000, "RW", "cc_rcvenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "cc_rcvenovrsel", "Receive enable override select.\r\n"
"0= Dynamic RCVEN control\r\n"
"1= Static RCVEN control"},
#else
{24, 24, 0x0000000000000000, "RW", "cc_rcvenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{22, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 21, 0x0000000000000000, "RW", "cc_rcvenlenbl4", "This is the receive enable length(number of 1x clock) configuration register."},
#else
{16, 21, 0x0000000000000000, "RW", "cc_rcvenlenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "cc_rcvenpst1", "This is the receive enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{14, 15, 0x0000000000000000, "RW", "cc_rcvenpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW", "cc_rcvenpre1", "This is the receive enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{12, 13, 0x0000000000000000, "RW", "cc_rcvenpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW", "cc_rcvenpst0", "This is the receive enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{10, 11, 0x0000000000000000, "RW", "cc_rcvenpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "cc_rcvenpre0", "This is the receive enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{8, 9, 0x0000000000000000, "RW", "cc_rcvenpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "cc_rdcmd2rcven", "This is the receive enable latency configuration register."},
#else
{0, 5, 0x0000000000000000, "RW", "cc_rdcmd2rcven", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo367[] = {{"RCVENCTL_BL13", "", 0x00000044, 15, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields368[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "drx_bl_rcvsmpl", "AFE status register - RCVSMPL - DQ"},
#else
{31, 31, 0x0000000000000000, "RO", "drx_bl_rcvsmpl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 30, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "drx_bl_rcvenflopbypass", "DQS counter flop override"},
#else
{28, 28, 0x0000000000000000, "RW", "drx_bl_rcvenflopbypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RW", "drx_bl_dqscountrstb", "DQS counter reset"},
#else
{27, 27, 0x0000000000000000, "RW", "drx_bl_dqscountrstb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "bl_rcvenmargin", "Receive enable margining data"},
#else
{26, 26, 0x0000000000000000, "RW", "bl_rcvenmargin", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "bl_rcvenovrval", "Receive enable override value. \r\n"
"0: De-assert receive enable \r\n"
"1: Assert receive enable"},
#else
{25, 25, 0x0000000000000000, "RW", "bl_rcvenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "bl_rcvenovrsel", "Receive enable override select.\r\n"
"0= Dynamic RCVEN control\r\n"
"1= Static RCVEN control"},
#else
{24, 24, 0x0000000000000000, "RW", "bl_rcvenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{22, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 21, 0x0000000000000000, "RW", "bl_rcvenlenbl4", "This is the receive enable length(number of 1x clock) configuration register."},
#else
{16, 21, 0x0000000000000000, "RW", "bl_rcvenlenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "bl_rcvenpst1", "This is the receive enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{14, 15, 0x0000000000000000, "RW", "bl_rcvenpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW", "bl_rcvenpre1", "This is the receive enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{12, 13, 0x0000000000000000, "RW", "bl_rcvenpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW", "bl_rcvenpst0", "This is the receive enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{10, 11, 0x0000000000000000, "RW", "bl_rcvenpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "bl_rcvenpre0", "This is the receive enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{8, 9, 0x0000000000000000, "RW", "bl_rcvenpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "bl_rdcmd2rcven", "This is the receive enable latency configuration register.\r\n"
"RL - 1: maps to DRAM RL."},
#else
{0, 5, 0x0000000000000000, "RW", "bl_rdcmd2rcven", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo368[] = {{"RCVENCTL_BL02", "", 0x00000048, 15, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields369[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000000, "RW", "rk1_diffampenrdptroffset", "Differential amplifier read pointer offset control."},
#else
{27, 31, 0x0000000000000000, "RW", "rk1_diffampenrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "cc_dqsdiffampenovrval", "Override value for DQS Diffamp enable - DQ Lane"},
#else
{26, 26, 0x0000000000000000, "RW", "cc_dqsdiffampenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "cc_dqsdiffampenovrsel", "Override select for DQS Diffamp enable - DQ Lane"},
#else
{25, 25, 0x0000000000000000, "RW", "cc_dqsdiffampenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "cc_dqdmdiffampenovrval", "Override value for DQ/DM Diffamp enable - DQ Lane"},
#else
{24, 24, 0x0000000000000000, "RW", "cc_dqdmdiffampenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "cc_dqdmdiffampenovrsel", "Override select for DQ/DM Diffamp enable - DQ Lane"},
#else
{23, 23, 0x0000000000000000, "RW", "cc_dqdmdiffampenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 22, 0x0000000000000000, "RW", "cc_diffampenpst1", "This is the diffamp enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{21, 22, 0x0000000000000000, "RW", "cc_diffampenpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 20, 0x0000000000000000, "RW", "cc_diffampenpre1", "This is the diffamp enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{19, 20, 0x0000000000000000, "RW", "cc_diffampenpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 18, 0x0000000000000000, "RW", "cc_diffampenpst0", "This is the diffamp enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{17, 18, 0x0000000000000000, "RW", "cc_diffampenpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 16, 0x0000000000000000, "RW", "cc_diffampenpre0", "This is the diffamp enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{15, 16, 0x0000000000000000, "RW", "cc_diffampenpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 14, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 12, 0x0000000000000000, "RW", "cc_diffampenlenbl4", "This is the diffamp enable length(number of 1x clock) configuration register."},
#else
{7, 12, 0x0000000000000000, "RW", "cc_diffampenlenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 6, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "cc_rdcmd2diffampen", "This is the Diffamp enable latency register."},
#else
{0, 5, 0x0000000000000000, "RW", "cc_rdcmd2diffampen", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo369[] = {{"DIFFAMPCTL_BL13", "", 0x0000004C, 13, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields370[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000000, "RW", "rk0_diffampenrdptroffset", "Differential amplifier read pointer offset control."},
#else
{27, 31, 0x0000000000000000, "RW", "rk0_diffampenrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "bl_dqsdiffampenovrval", "Override value for DQS Diffamp enable - DQ Lane"},
#else
{26, 26, 0x0000000000000000, "RW", "bl_dqsdiffampenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "bl_dqsdiffampenovrsel", "Override select for DQS Diffamp enable - DQ Lane"},
#else
{25, 25, 0x0000000000000000, "RW", "bl_dqsdiffampenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "bl_dqdmdiffampenovrval", "Override value for DQ/DM Diffamp enable - DQ Lane"},
#else
{24, 24, 0x0000000000000000, "RW", "bl_dqdmdiffampenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "bl_dqdmdiffampenovrsel", "Override select for DQ/DM Diffamp enable - DQ Lane"},
#else
{23, 23, 0x0000000000000000, "RW", "bl_dqdmdiffampenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 22, 0x0000000000000000, "RW", "bl_diffampenpst1", "This is the diffamp enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{21, 22, 0x0000000000000000, "RW", "bl_diffampenpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 20, 0x0000000000000000, "RW", "bl_diffampenpre1", "This is the diffamp enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{19, 20, 0x0000000000000000, "RW", "bl_diffampenpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 18, 0x0000000000000000, "RW", "bl_diffampenpst0", "This is the diffamp enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{17, 18, 0x0000000000000000, "RW", "bl_diffampenpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 16, 0x0000000000000000, "RW", "bl_diffampenpre0", "This is the diffamp enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{15, 16, 0x0000000000000000, "RW", "bl_diffampenpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 14, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 12, 0x0000000000000000, "RW", "bl_diffampenlenbl4", "This is the diffamp enable length(number of 1x clock) configuration register."},
#else
{7, 12, 0x0000000000000000, "RW", "bl_diffampenlenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 6, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "bl_rdcmd2diffampen", "This is the Diffamp enable latency register."},
#else
{0, 5, 0x0000000000000000, "RW", "bl_rdcmd2diffampen", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo370[] = {{"DIFFAMPCTL_BL02", "", 0x00000050, 13, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields371[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{26, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{26, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "cc_wrlvl", "Write Levelization enable - DQ 1/3 Byte Lane"},
#else
{25, 25, 0x0000000000000000, "RW", "cc_wrlvl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "bl_wrlvl", "Write Levelization enable - DQ 0/2 Byte Lane"},
#else
{24, 24, 0x0000000000000000, "RW", "bl_wrlvl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RO", "wrlvl_sample_b1", "DQTRAINSTS - WRLVL sampling from all DQ bit lanes of Bytelane 1"},
#else
{16, 23, 0x0000000000000000, "RO", "wrlvl_sample_b1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RO", "wrlvl_sample_b0", "DQTRAINSTS - WRLVL sampling from all DQ bit lanes of Bytelane 0"},
#else
{8, 15, 0x0000000000000000, "RO", "wrlvl_sample_b0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RO", "wrlvl_and_sample_b1", "DQTRAINSTS - WRLVL Byte1 sample AND combination"},
#else
{3, 3, 0x0000000000000000, "RO", "wrlvl_and_sample_b1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RO", "wrlvl_and_sample_b0", "DQTRAINSTS - WRLVL Byte0 sample AND combination"},
#else
{2, 2, 0x0000000000000000, "RO", "wrlvl_and_sample_b0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO", "wrlvl_or_sample_b1", "DQTRAINSTS - WRLVL Byte1 sample OR combination"},
#else
{1, 1, 0x0000000000000000, "RO", "wrlvl_or_sample_b1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO", "wrlvl_or_sample_b0", "DQTRAINSTS - WRLVL Byte0 sample OR combination"},
#else
{0, 0, 0x0000000000000000, "RO", "wrlvl_or_sample_b0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo371[] = {{"WRLVL", "", 0x00000054, 10, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields372[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{20, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{20, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "dynreadsiggrpen", "Enable Dynamic SIGGRP 2x clock control. \r\n"
"1= SIGGRPEN  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled SIGGRPEN"},
#else
{19, 19, 0x0000000000000000, "RW", "dynreadsiggrpen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "dynreadref2xclken", "Enable Dynamic REF2XCLK control. \r\n"
"1= ref2xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled REF2XCLKEN"},
#else
{18, 18, 0x0000000000000000, "RW", "dynreadref2xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "dynreadref1xclken", "Enable Dynamic REF1XCLK control. \r\n"
"1= ref1xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled REF1XCLKEN"},
#else
{17, 17, 0x0000000000000000, "RW", "dynreadref1xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dynreadspidclken", "Enable Dynamic SPIDCLK control. \r\n"
"1= spidclken  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled SPIDCLKEN"},
#else
{16, 16, 0x0000000000000000, "RW", "dynreadspidclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "read_stoprden", "This is the delay in terms of clocks the dven is disabled before clock gated."},
#else
{12, 14, 0x0000000000000000, "RW", "read_stoprden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "read_startrden", "This is the delay in terms of clocks the drven is enabled, once wrcmd/rdcmd is received."},
#else
{8, 10, 0x0000000000000000, "RW", "read_startrden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x000000000000003F, "RW", "readclkgate_maxcntr", "IDLE timer counter max value for clock gating on rx . \r\n"
"Counter timeout based on last RDCMD received."},
#else
{0, 5, 0x000000000000003F, "RW", "readclkgate_maxcntr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo372[] = {{"CLKGATERDCTL", "", 0x00000058, 11, 0x00000000FFFFFFFF, 0x000000000000003F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields373[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{20, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{20, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "dynwritesiggrpen", "Enable Dynamic SIGGRP 2x clock control (writes)\r\n"
"1= SIGGRPEN  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled SIGGRPEN"},
#else
{19, 19, 0x0000000000000000, "RW", "dynwritesiggrpen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "dynwriteref2xclken", "Enable Dynamic REF2XCLK control  (writes)\r\n"
"1= ref2xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled REF2XCLKEN"},
#else
{18, 18, 0x0000000000000000, "RW", "dynwriteref2xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "dynwriteref1xclken", "Enable Dynamic REF1XCLK control  (writes)\r\n"
"1= ref1xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled REF1XCLKEN"},
#else
{17, 17, 0x0000000000000000, "RW", "dynwriteref1xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dynwritespidclken", "Enable Dynamic SPIDCLK control  (writes)\r\n"
"1= spidclken  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled SPIDCLKEN"},
#else
{16, 16, 0x0000000000000000, "RW", "dynwritespidclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "write_stopdrv", "This is the delay in terms of clocks the dven is disabled before clock gated."},
#else
{12, 14, 0x0000000000000000, "RW", "write_stopdrv", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "write_startdrv", "This is the delay in terms of clocks the drven is enabled, once wrcmd/rdcmd is received."},
#else
{8, 10, 0x0000000000000000, "RW", "write_startdrv", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x000000000000003F, "RW", "writeclkgate_maxcntr", "IDLE timer counter max value for clock gating on tx . \r\n"
"Counter timeout based on last WRCMD received."},
#else
{0, 5, 0x000000000000003F, "RW", "writeclkgate_maxcntr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo373[] = {{"CLKGATEWRCTL", "", 0x0000005C, 11, 0x00000000FFFFFFFF, 0x000000000000003F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields374[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{20, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{20, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "dynsiggrpen", "Enable Dynamic SIGGRP 2x clock control. 1= SIGGRPEN  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled SIGGRPEN"},
#else
{19, 19, 0x0000000000000000, "RW", "dynsiggrpen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "dynref2xclken", "Enable Dynamic REF2XCLK control. 1= ref2xclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled REF2XCLKEN"},
#else
{18, 18, 0x0000000000000000, "RW", "dynref2xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "dynref1xclken", "Enable Dynamic REF1XCLK control  (reads)\r\n"
"1= ref1xclken  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled REF1XCLKEN"},
#else
{17, 17, 0x0000000000000000, "RW", "dynref1xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dynspidclken", "Enable Dynamic SPIDCLK control  (reads)\r\n"
"1= spidclken  controlled by the dynamic clock gating logic (DYNDLLFSM)\r\n"
"0= Statically-controlled SPIDCLKEN"},
#else
{16, 16, 0x0000000000000000, "RW", "dynspidclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x000000000000003F, "RW", "clkgate_maxcntr", "Clock Gating register : IDLE timer counter max value for clock gating on tx/rx . Counter timeout based on last WRCMD/RDCMD received. 6 bits are good enough since it increments in spidclk."},
#else
{0, 5, 0x000000000000003F, "RW", "clkgate_maxcntr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo374[] = {{"CLKGATECTL", "", 0x00000060, 7, 0x00000000FFFFFFFF, 0x000000000000003F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields375[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp05dbsel", "Deadband select for sig group 5 rank 1 maps to BL1 RCVEN"},
#else
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp05dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp05rdptroffset", "Read pointer offset for sig group 5 rank 1 maps to BL1 RCVEN"},
#else
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp05rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp05picode", "PI code for sig group 5 rank 1 maps to BL1 RCVEN"},
#else
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp05picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp05dbsel", "Deadband select for sig group 5 rank 0 maps to BL1 RCVEN"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp05dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp05rdptroffset", "Read pointer offset for sig group 5 rank 0 maps to BL1 RCVEN"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp05rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp05picode", "PI code for sig group 5 rank 0 maps to BL1 RCVEN"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp05picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo375[] = {{"TXDLLSIGGRP5CTL", "", 0x00000064, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields376[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp04dbsel", "Deadband select for sig group 4 rank 1 maps to BL1 DQS"},
#else
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp04dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp04rdptroffset", "Read pointer offset for sig group 4 rank 1 maps to BL1 DQS"},
#else
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp04rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp04picode", "PI code for sig group 4 rank 1 maps to BL1 DQS"},
#else
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp04picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp04dbsel", "Deadband select for sig group 4 rank 0 maps to BL1 DQS"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp04dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp04rdptroffset", "Read pointer offset for sig group 4 rank 0 maps to BL1 DQS"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp04rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp04picode", "PI code for sig group 4 rank 0 maps to BL1 DQS"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp04picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo376[] = {{"TXDLLSIGGRP4CTL", "", 0x00000068, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields377[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp03dbsel", "Deadband select for sig group 3 rank 1 maps to BL1 DQ"},
#else
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp03dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp03rdptroffset", "Read pointer offset for sig group 3 rank 1 maps to BL1 DQ"},
#else
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp03rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp03picode", "PI code for sig group 3 rank 1 maps to BL1 DQ"},
#else
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp03picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp03dbsel", "Deadband select for sig group 3 rank 0 maps to BL1 DQ"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp03dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp03rdptroffset", "Read pointer offset for sig group 3 rank 0 maps to BL1 DQ"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp03rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp03picode", "PI code for sig group 3 rank 0 maps to BL1 DQ"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp03picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo377[] = {{"TXDLLSIGGRP3CTL", "", 0x0000006C, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields378[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp02dbsel", "Deadband select for sig group 2 rank 1 maps to BL0 RCVEN"},
#else
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp02dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp02rdptroffset", "Read pointer offset for sig group 2 rank 1 maps to BL0 RCVEN"},
#else
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp02rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp02picode", "PI code for sig group 2 rank 1 maps to BL0 RCVEN"},
#else
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp02picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp02dbsel", "Deadband select for sig group 2 rank 0 maps to BL0 RCVEN"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp02dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp02rdptroffset", "Read pointer offset for sig group 2 rank 0 maps to BL0 RCVEN"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp02rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp02picode", "PI code for sig group 2 rank 0 maps to BL0 RCVEN"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp02picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo378[] = {{"TXDLLSIGGRP2CTL", "", 0x00000070, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields379[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp01dbsel", "Deadband select for sig group 1 rank 1 maps to BL0 DQS"},
#else
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp01dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp01rdptroffset", "Read pointer offset for sig group 1 rank 1 maps to BL0 DQS"},
#else
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp01rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp01picode", "PI code for sig group 1 rank 1 maps to BL0 DQS"},
#else
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp01picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp01dbsel", "Deadband select for sig group 1 rank 0 maps to BL0 DQS"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp01dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp01rdptroffset", "Read pointer offset for sig group 1 rank 0 maps to BL0 DQS"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp01rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp01picode", "PI code for sig group 1 rank 0 maps to BL0 DQS"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp01picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo379[] = {{"TXDLLSIGGRP1CTL", "", 0x00000074, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields380[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp00dbsel", "Deadband select for sig group 0 rank 1 maps to BL0 DQ"},
#else
{29, 30, 0x0000000000000000, "RW", "txdll_rk1siggrp00dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp00rdptroffset", "Read pointer offset for sig group 0 rank 1 maps to BL0 DQ"},
#else
{24, 28, 0x0000000000000000, "RW", "txdll_rk1siggrp00rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp00picode", "PI code for sig group 0 rank 1 maps to BL0 DQ"},
#else
{16, 23, 0x0000000000000000, "RW", "txdll_rk1siggrp00picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp00dbsel", "Deadband select for sig group 0 rank 0 maps to BL0 DQ"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp00dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp00rdptroffset", "Read pointer offset for sig group 0 rank 0 maps to BL0 DQ"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp00rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp00picode", "PI code for sig group 0 rank 0 maps to BL0 DQ"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp00picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo380[] = {{"TXDLLSIGGRP0CTL", "", 0x00000078, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields381[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "lvl_cc_weakpupstatic", "Weak Pull Up Control static bit for DQSB - DQ ByteLane 1/3"},
#else
{30, 30, 0x0000000000000000, "RW", "lvl_cc_weakpupstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 29, 0x0000000000000000, "RW", "lvl_cc_weakpup", "Weak Pull Up Control code for DQSB - DQ ByteLane 1/3"},
#else
{24, 29, 0x0000000000000000, "RW", "lvl_cc_weakpup", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "lvl_cc_weakpdnstatic", "Weak Pull Down Control static bit for DQS - DQ ByteLane 1/3"},
#else
{22, 22, 0x0000000000000000, "RW", "lvl_cc_weakpdnstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 21, 0x0000000000000000, "RW", "lvl_cc_weakpdn", "Weak Pull Down Control code for DQS - DQ ByteLane 1/3"},
#else
{16, 21, 0x0000000000000000, "RW", "lvl_cc_weakpdn", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 14, 0x0000000000000000, "RW", "lvl_bl_weakpupstatic", "Weak Pull Up Control static bit for DQSB - DQ ByteLane 0/2"},
#else
{14, 14, 0x0000000000000000, "RW", "lvl_bl_weakpupstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 13, 0x0000000000000000, "RW", "lvl_bl_weakpup", "Weak Pull Up Control code for DQSB - DQ ByteLane 0/2"},
#else
{8, 13, 0x0000000000000000, "RW", "lvl_bl_weakpup", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "lvl_bl_weakpdnstatic", "Weak Pull Down Control static bit for DQS - DQ ByteLane 0/2"},
#else
{6, 6, 0x0000000000000000, "RW", "lvl_bl_weakpdnstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "lvl_bl_weakpdn", "Weak Pull Down Control code for DQS - DQ ByteLane 0/2"},
#else
{0, 5, 0x0000000000000000, "RW", "lvl_bl_weakpdn", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo381[] = {{"WKPUPPDNCTL", "", 0x0000007C, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields382[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "rx_modelp4ddr4", "Selects between LP4/LP3 (1'b0) and DDR4 modes (1'b1) - Common for all byte Lanes"},
#else
{31, 31, 0x0000000000000000, "RW", "rx_modelp4ddr4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 30, 0x0000000000000007, "RW", "dtx_cc_drvsegen", "Segment enable for BL 1/3 DQS buffer. Used for per leg testing in HVM"},
#else
{28, 30, 0x0000000000000007, "RW", "dtx_cc_drvsegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RW", "tx_bl1_idlemode", "Disable idle mode logic = 1'b0, Enable = 1'b1 - BL1"},
#else
{27, 27, 0x0000000000000000, "RW", "tx_bl1_idlemode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000007, "RW", "tx_cc_drvsegen", "Segment enable for BL 1/3 DQ buffer. Used for per leg testing in HVM"},
#else
{24, 26, 0x0000000000000007, "RW", "tx_cc_drvsegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "tx_bl1_techselect", "Selects between LP4/LP3 (1'b0) and DDR4 modes (1'b1) - BL1"},
#else
{23, 23, 0x0000000000000000, "RW", "tx_bl1_techselect", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 22, 0x0000000000000007, "RW", "dtx_bl_drvsegen", "Segment enable for BL 0/2 DQS buffer. Used for per leg testing in HVM"},
#else
{20, 22, 0x0000000000000007, "RW", "dtx_bl_drvsegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "tx_bl0_idlemode", "Disable idle mode logic = 1'b0, Enable = 1'b1 - BL0"},
#else
{19, 19, 0x0000000000000000, "RW", "tx_bl0_idlemode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000007, "RW", "tx_bl_drvsegen", "Segment enable for BL 0/2 DQ buffer. Used for per leg testing in HVM"},
#else
{16, 18, 0x0000000000000007, "RW", "tx_bl_drvsegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RW", "drx_cc_dqsnegedgemask", "masking out the first dqs negedge during rcven handling in ddr4 (0-ddr4;1-ddr3l,lp3/4)"},
#else
{15, 15, 0x0000000000000000, "RW", "drx_cc_dqsnegedgemask", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000001, "RW", "rxdll_cc_picapsel", "set cap tuning for RxDLL BL 1/3 pi"},
#else
{12, 14, 0x0000000000000001, "RW", "rxdll_cc_picapsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "drx_bl_dqsnegedgemask", "masking out the first dqs negedge during rcven handling in ddr4 (0-ddr4;1-ddr3l,lp3/4)"},
#else
{11, 11, 0x0000000000000000, "RW", "drx_bl_dqsnegedgemask", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000001, "RW", "rxdll_bl_picapsel", "set cap tuning for RxDLL BL 0/2 pi"},
#else
{8, 10, 0x0000000000000001, "RW", "rxdll_bl_picapsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "tx_bl0_techselect", "Selects between LP4/LP3 (1'b0) and DDR4 modes (1'b1) - BL0"},
#else
{7, 7, 0x0000000000000000, "RW", "tx_bl0_techselect", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000001, "RW", "txdll_picapsel", "set cap tuning for pi"},
#else
{4, 6, 0x0000000000000001, "RW", "txdll_picapsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "dtx_cc_allfire", "Config Register space has been reallocated for RxBIASEN ECO HSD#1404029255\r\n"
"Override select for Rx bias enable - BL1 Lane"},
#else
{3, 3, 0x0000000000000000, "RW", "dtx_cc_allfire", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "dtx_bl_allfire", "Config Register space has been reallocated for RxBIASEN ECO HSD#1404029255\r\n"
"Override select for Rx bias enable - BL0 Lane"},
#else
{2, 2, 0x0000000000000000, "RW", "dtx_bl_allfire", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "tx_cc_allfire", "Config Register space has been reallocated for RxBIASEN ECO HSD#1404029255\r\n"
"Override value  for Rx bias enable - BL1 Lane"},
#else
{1, 1, 0x0000000000000000, "RW", "tx_cc_allfire", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "tx_bl_allfire", "Config Register space has been reallocated for RxBIASEN ECO HSD#1404029255\r\n"
"Override value for Rx bias enable - BL0 Lane"},
#else
{0, 0, 0x0000000000000000, "RW", "tx_bl_allfire", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo382[] = {{"AFEMISC1", "", 0x00000080, 18, 0x00000000FFFFFFFF, 0x0000000077771110}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields383[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RW", "dtx_cc_drvenstretch", "Streches rising edge of drivenable to relax data to enable skew for BL 1/3 DQS Buffer."},
#else
{30, 31, 0x0000000000000000, "RW", "dtx_cc_drvenstretch", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RW", "dtx_bl_drvenstretch", "Streches rising edge of drivenable to relax data to enable skew for BL 0/2 DQS Buffer."},
#else
{28, 29, 0x0000000000000000, "RW", "dtx_bl_drvenstretch", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RW", "tx_cc_drvenstretch", "Streches rising edge of drivenable to relax data to enable skew for BL 1/3 DQ Buffer."},
#else
{26, 27, 0x0000000000000000, "RW", "tx_cc_drvenstretch", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "tx_bl_drvenstretch", "Streches rising edge of drivenable to relax data to enable skew for BL 0/2 DQ Buffer."},
#else
{24, 25, 0x0000000000000000, "RW", "tx_bl_drvenstretch", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 23, 0x0000000000000000, "RW", "drx_cc_rxpwrmode", "Modulates the Volatge seen by the RX Amplifier\r\n"
"00 - Default; 01,10,11 - Illegal Values"},
#else
{22, 23, 0x0000000000000000, "RW", "drx_cc_rxpwrmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 21, 0x0000000000000000, "RW", "rx_cc_rxpwrmode", "Modulates the Volatge seen by the RX Amplifier\r\n"
"00 - Default; 01,10,11 - Illegal Values"},
#else
{20, 21, 0x0000000000000000, "RW", "rx_cc_rxpwrmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RW", "drx_bl_rxpwrmode", "Modulates the Volatge seen by the RX Amplifier\r\n"
"00 - Default; 01,10,11 - Illegal Values"},
#else
{18, 19, 0x0000000000000000, "RW", "drx_bl_rxpwrmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "rx_bl_rxpwrmode", "Modulates the Volatge seen by the RX Amplifier\r\n"
"00 - Default; 01,10,11 - Illegal Values"},
#else
{16, 17, 0x0000000000000000, "RW", "rx_bl_rxpwrmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "txdll_2xclkskewsel", "TxDLL Skew Compensator clock mux select (Clock Select [1:0]/Sync Div Reset[3:2])\r\n"
"Below select descriptions apply to both clock and div reset but each one can be controlled independently\r\n"
"00 - Default path - No addditional Skew added\r\n"
"01 - Skew Path 1 - Add ~30-40ps of delay to TxDLL 2xclk input based on PVT\r\n"
"11 - Skew Path 2 - Add ~90-100ps of delay to TxDLL 2xclk input based on PVT"},
#else
{12, 15, 0x0000000000000000, "RW", "txdll_2xclkskewsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000001, "RW", "drx_cc_rxcommonmode", "changes the common mode of receiver  for BL 1/3 DQS Buffer from low common mode to vcc/2 based on lpddr3/ lpddr4."},
#else
{11, 11, 0x0000000000000001, "RW", "drx_cc_rxcommonmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000001, "RW", "drx_bl_rxcommonmode", "changes the common mode of receiver  for BL 0/2 DQS Buffer from low common mode to vcc/2 based on lpddr3/ lpddr4."},
#else
{10, 10, 0x0000000000000001, "RW", "drx_bl_rxcommonmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000001, "RW", "rx_cc_rxcommonmode", "changes the common mode of receiver  for BL 1/3 DQ Buffer from low common mode to vcc/2 based on lpddr3/ lpddr4."},
#else
{9, 9, 0x0000000000000001, "RW", "rx_cc_rxcommonmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000001, "RW", "rx_bl_rxcommonmode", "changes the common mode of receiver  for BL 0/2 DQ Buffer from low common mode to vcc/2 based on lpddr3/ lpddr4."},
#else
{8, 8, 0x0000000000000001, "RW", "rx_bl_rxcommonmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000001, "RW", "pdndrvstatic", "Static pull down code - DRV DQ"},
#else
{7, 7, 0x0000000000000001, "RW", "pdndrvstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000001, "RW", "pdndrvstaticdqs", "Static pull down code - DRV DQS/DQSB"},
#else
{6, 6, 0x0000000000000001, "RW", "pdndrvstaticdqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000001, "RW", "pdnodtstatic", "Static pull down code - ODT DQ"},
#else
{5, 5, 0x0000000000000001, "RW", "pdnodtstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000001, "RW", "pdnodtstaticdqs", "Static pull down code - ODT DQS/DQSB"},
#else
{4, 4, 0x0000000000000001, "RW", "pdnodtstaticdqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000001, "RW", "pupdrvstatic", "Static pull up code - DRV DQ"},
#else
{3, 3, 0x0000000000000001, "RW", "pupdrvstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000001, "RW", "pupdrvstaticdqs", "Static pull up code - DRV DQS/DQSB"},
#else
{2, 2, 0x0000000000000001, "RW", "pupdrvstaticdqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000001, "RW", "pupodtstatic", "Static pull up code - ODT DQ"},
#else
{1, 1, 0x0000000000000001, "RW", "pupodtstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "pupodtstaticdqs", "Static pull up code - ODT DQS/DQSB"},
#else
{0, 0, 0x0000000000000001, "RW", "pupodtstaticdqs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo383[] = {{"AFEMISC0", "", 0x00000084, 21, 0x00000000FFFFFFFF, 0x0000000000000FFF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields384[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rx_bl0_bonus", "Bonus bits - RX BL 0/2 Lane"},
#else
{12, 15, 0x0000000000000000, "RW", "rx_bl0_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rx_bl1_bonus", "Bonus bits - RX BL 1/3 Lane"},
#else
{8, 11, 0x0000000000000000, "RW", "rx_bl1_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "lvl_cc_bonus", "Bonus bits - LVL BL 0/2 Lane"},
#else
{4, 7, 0x0000000000000000, "RW", "lvl_cc_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "lvl_bl_bonus", "Bonus bits - LVL BL 1/3 Lane"},
#else
{0, 3, 0x0000000000000000, "RW", "lvl_bl_bonus", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo384[] = {{"AFEBONUS", "", 0x00000088, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields385[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "txdll_digobs1sel", "Digital observation select mux port 1"},
#else
{28, 31, 0x0000000000000000, "RW", "txdll_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "txdll_digobs0sel", "Digital observation select mux port 0"},
#else
{24, 27, 0x0000000000000000, "RW", "txdll_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "rxdll_cc_digobsen", "digital buf obs enable (1=enable;0=disable) for BL 1/3 RxDLL"},
#else
{23, 23, 0x0000000000000000, "RW", "rxdll_cc_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "rxdll_bl_digobsen", "digital buf obs enable (1=enable;0=disable) for BL 0/2 RxDLL"},
#else
{22, 22, 0x0000000000000000, "RW", "rxdll_bl_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "dtx_cc_digobsen", "digital buf obs enable (1=enable;0=disable) for BL 1/3 DQS Buffer"},
#else
{21, 21, 0x0000000000000000, "RW", "dtx_cc_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{20, 20, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "txdll_digobsen", "digital buf obs enable (1=enable;0=disable) for TxDLL"},
#else
{19, 19, 0x0000000000000000, "RW", "txdll_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "dtx_bl_digobsen", "digital buf obs enable (1=enable;0=disable) for BL 0/2 DQS Buffer"},
#else
{18, 18, 0x0000000000000000, "RW", "dtx_bl_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 17, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rxdll_bl_digobs1sel", "Digital observation select mux port 1 for BL 0/2 RxDLL"},
#else
{12, 15, 0x0000000000000000, "RW", "rxdll_bl_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rxdll_bl_digobs0sel", "Digital observation select mux port 0 for BL 0/2 RxDLL"},
#else
{8, 11, 0x0000000000000000, "RW", "rxdll_bl_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rxdll_cc_digobs1sel", "Digital observation select mux port 1 for BL 1/3 RxDLL"},
#else
{4, 7, 0x0000000000000000, "RW", "rxdll_cc_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_cc_digobs0sel", "Digital observation select mux port 0 for BL 1/3 RxDLL"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_cc_digobs0sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo385[] = {{"DIGOBSCTL1", "", 0x0000008C, 13, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields386[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "dqrx2monport_en", "DQ Post Rx FLOP to Digital MonPort Enable; 0 - DQRX to digital Monitor Port is disabled; 1 - DQRX Flop outputs routed to Digital Monitor Port"},
#else
{31, 31, 0x0000000000000000, "RW", "dqrx2monport_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 30, 0x0000000000000000, "RW", "dtx_cc_digobs1sel", "Digital observation select mux port 1 for BL 1/3 DQS Buffer"},
#else
{28, 30, 0x0000000000000000, "RW", "dtx_cc_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{27, 27, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000000, "RW", "dtx_cc_digobs0sel", "Digital observation select mux port 0 for BL 1/3 DQS Buffer"},
#else
{24, 26, 0x0000000000000000, "RW", "dtx_cc_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 22, 0x0000000000000000, "RW", "dtx_bl_digobs1sel", "Digital observation select mux port 1 for BL 0/2 DQS Buffer"},
#else
{20, 22, 0x0000000000000000, "RW", "dtx_bl_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{19, 19, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000000, "RW", "dtx_bl_digobs0sel", "Digital observation select mux port 0 for BL 0/2 DQS Buffer"},
#else
{16, 18, 0x0000000000000000, "RW", "dtx_bl_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "tx_cc_digobs1sel", "Digital observation select mux port 1 for BL 1/3 DQ Buffer"},
#else
{12, 14, 0x0000000000000000, "RW", "tx_cc_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "tx_cc_digobs0sel", "Digital observation select mux port 0 for BL 1/3 DQ Buffer"},
#else
{8, 10, 0x0000000000000000, "RW", "tx_cc_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000000, "RW", "tx_bl_digobs1sel", "Digital observation select mux port 1 for BL 0/2 DQ Buffer"},
#else
{4, 6, 0x0000000000000000, "RW", "tx_bl_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{3, 3, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RW", "tx_bl_digobs0sel", "Digital observation select mux port 0 for BL 0/2 DQ Buffer"},
#else
{0, 2, 0x0000000000000000, "RW", "tx_bl_digobs0sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo386[] = {{"DIGOBSCTL0", "", 0x00000090, 16, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields387[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "rxdll_rxmuxsel", "enable strobe output from rx sdll.for each byte"},
#else
{24, 28, 0x0000000000000000, "RW", "rxdll_rxmuxsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{22, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "txdll_dllfloprstb", "TxDLL flop reset"},
#else
{21, 21, 0x0000000000000000, "RW", "txdll_dllfloprstb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "rxdll_dllfloprstb", "RxDLL flop reset"},
#else
{20, 20, 0x0000000000000000, "RW", "rxdll_dllfloprstb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{19, 19, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "rxdll_bl_dqsouten", "enable strobe output from rx sdll.for each byte"},
#else
{18, 18, 0x0000000000000000, "RW", "rxdll_bl_dqsouten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 17, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "rxdll_bl_rxdllen", "Rx DLL enable"},
#else
{16, 16, 0x0000000000000000, "RW", "rxdll_bl_rxdllen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{0, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo387[] = {{"RXDLLCTL_DQBLDM", "", 0x00000094, 10, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields388[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{19, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{19, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "rxdll_cc_dqsouten", "enable strobe output from rx sdll.for each byte"},
#else
{18, 18, 0x0000000000000000, "RW", "rxdll_cc_dqsouten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 17, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "rxdll_cc_rxdllen", "Rx DLL enable"},
#else
{16, 16, 0x0000000000000000, "RW", "rxdll_cc_rxdllen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{1, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "txdll_ref2xph0pien", "enable tx ref pi phase 0 enable"},
#else
{0, 0, 0x0000000000000000, "RW", "txdll_ref2xph0pien", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo388[] = {{"RXDLLCTL_CCBLDM", "", 0x00000098, 6, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields389[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{18, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{18, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 17, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "txdll_mdllen", "MDLL enable"},
#else
{16, 16, 0x0000000000000000, "RW", "txdll_mdllen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{14, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 13, 0x0000000000000000, "RW", "txdll_siggrp05pien", "PI enable for sig group 5 rank 0"},
#else
{13, 13, 0x0000000000000000, "RW", "txdll_siggrp05pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000000, "RW", "txdll_siggrp04pien", "PI enable for sig group 4 rank 0"},
#else
{12, 12, 0x0000000000000000, "RW", "txdll_siggrp04pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "txdll_siggrp03pien", "PI enable for sig group 3 rank 0"},
#else
{11, 11, 0x0000000000000000, "RW", "txdll_siggrp03pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "txdll_siggrp02pien", "PI enable for sig group 2 rank 0"},
#else
{10, 10, 0x0000000000000000, "RW", "txdll_siggrp02pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "txdll_siggrp01pien", "PI enable for sig group 1 rank 0"},
#else
{9, 9, 0x0000000000000000, "RW", "txdll_siggrp01pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "txdll_siggrp00pien", "PI enable for sig group 0 rank 0"},
#else
{8, 8, 0x0000000000000000, "RW", "txdll_siggrp00pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "txdll_ref2xph270pien", "enable tx ref pi phase 270 enable"},
#else
{3, 3, 0x0000000000000000, "RW", "txdll_ref2xph270pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "txdll_ref2xph180pien", "enable tx ref pi phase 180 enable"},
#else
{2, 2, 0x0000000000000000, "RW", "txdll_ref2xph180pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "txdll_ref2xph90pien", "enable tx ref pi phase 90 enable"},
#else
{1, 1, 0x0000000000000000, "RW", "txdll_ref2xph90pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{0, 0, 0x0000000000000000, "RO", "reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo389[] = {{"TXDLLCTL", "", 0x0000009C, 15, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields390[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "txdll_ref2xph270picode", "pi code for ref pi phase 270 output"},
#else
{16, 23, 0x0000000000000000, "RW", "txdll_ref2xph270picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "txdll_ref2xph180picode", "pi code for ref pi phase 180 output"},
#else
{8, 15, 0x0000000000000000, "RW", "txdll_ref2xph180picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_ref2xph90picode", "pi code for ref pi phase 90 output"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_ref2xph90picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo390[] = {{"TXDLLREF2XCTL", "", 0x000000A0, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields391[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RW", "rxdll_bl_rk1dqshipicode", "Rank1 pi code for rx rising dqs edge - DQ 0/2 Lane"},
#else
{24, 31, 0x0000000000000000, "RW", "rxdll_bl_rk1dqshipicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "rxdll_bl_rk1dqslopicode", "Rank1 pi code for rx falling dqs edge - DQ 0/2 Lane"},
#else
{16, 23, 0x0000000000000000, "RW", "rxdll_bl_rk1dqslopicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "rxdll_cc_rk1dqshipicode", "Rank 1 pi code for rx rising dqs edge  - DQ 1/3 Lane"},
#else
{8, 15, 0x0000000000000000, "RW", "rxdll_cc_rk1dqshipicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "rxdll_cc_rk1dqslopicode", "Rank 1 pi code for rx falling dqs edge  - DQ 1/3 Lane"},
#else
{0, 7, 0x0000000000000000, "RW", "rxdll_cc_rk1dqslopicode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo391[] = {{"RXDLLDQSRK1CTL", "", 0x000000A4, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields392[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RW", "rxdll_bl_rk0dqshipicode", "Rank0 pi code for rx rising dqs edge  - DQ 0/2 Lane"},
#else
{24, 31, 0x0000000000000000, "RW", "rxdll_bl_rk0dqshipicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "rxdll_bl_rk0dqslopicode", "Rank0 pi code for rx falling dqs edge  - DQ 0/2 Lane"},
#else
{16, 23, 0x0000000000000000, "RW", "rxdll_bl_rk0dqslopicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "rxdll_cc_rk0dqshipicode", "Rank0 pi code for rx rising dqs edge  - DQ 1/3 Lane"},
#else
{8, 15, 0x0000000000000000, "RW", "rxdll_cc_rk0dqshipicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "rxdll_cc_rk0dqslopicode", "Rank0 pi code for rx falling dqs edge  - DQ 1/3 Lane"},
#else
{0, 7, 0x0000000000000000, "RW", "rxdll_cc_rk0dqslopicode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo392[] = {{"RXDLLDQSRK0CTL", "", 0x000000A8, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields393[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{1, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "txvref_cmn_vrefbufen", "enable signal for the tx vref unity gain buffer"},
#else
{0, 0, 0x0000000000000001, "RW", "txvref_cmn_vrefbufen", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo393[] = {{"VREFCTL1", "", 0x000000AC, 2, 0x00000000FFFFFFFF, 0x0000000000000001}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields394[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RW", "vref_txlcompvrefctrl", "vref decode signal for the lcomp"},
#else
{24, 31, 0x0000000000000000, "RW", "vref_txlcompvrefctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "lvl_bl_vrefset", "vrefiobufact Set control - DQ BL0"},
#else
{23, 23, 0x0000000000000000, "RW", "lvl_bl_vrefset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "lvl_bl_vrefreset", "vrefiobufact Reset control - DQ BL0"},
#else
{22, 22, 0x0000000000000000, "RW", "lvl_bl_vrefreset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "lvl_cc_vrefset", "vrefiobufact Set control - DQ BL1"},
#else
{21, 21, 0x0000000000000000, "RW", "lvl_cc_vrefset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "lvl_cc_vrefreset", "vrefiobufact Reset control - DQ BL1"},
#else
{20, 20, 0x0000000000000000, "RW", "lvl_cc_vrefreset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{18, 19, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "vref_vrefcmctrl", "common mode select to choose between lpddr3;lpddr4"},
#else
{16, 17, 0x0000000000000000, "RW", "vref_vrefcmctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000020, "RW", "vref_rxblvrefctrl", "vref decode signal for the b0/2 rx vref"},
#else
{8, 15, 0x0000000000000020, "RW", "vref_rxblvrefctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000020, "RW", "vref_rxccvrefctrl", "vref decode signal for the b1/3 rx vref"},
#else
{0, 7, 0x0000000000000020, "RW", "vref_rxccvrefctrl", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo394[] = {{"VREFCTL0", "", 0x000000B0, 9, 0x00000000FFFFFFFF, 0x0000000000002020}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields395[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{4, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_cc_dq8rxpbdcode", "Rx Per bit De-skew code for BL 1/3 dbi valid codes"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_cc_dq8rxpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo395[] = {{"RXBL8PBDCTL1", "", 0x000000B4, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields396[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "rxdll_cc_dq7rxpbdcode", "Rx Per bit De-skew code for BL1/3  dq7 valid codes"},
#else
{28, 31, 0x0000000000000000, "RW", "rxdll_cc_dq7rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "rxdll_cc_dq6rxpbdcode", "Rx Per bit De-skew code for BL1/3  dq6 valid codes"},
#else
{24, 27, 0x0000000000000000, "RW", "rxdll_cc_dq6rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "rxdll_cc_dq5rxpbdcode", "Rx Per bit De-skew code for BL1/3  dq5 valid codes"},
#else
{20, 23, 0x0000000000000000, "RW", "rxdll_cc_dq5rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "rxdll_cc_dq4rxpbdcode", "Rx Per bit De-skew code for BL1/3  dq4 valid codes"},
#else
{16, 19, 0x0000000000000000, "RW", "rxdll_cc_dq4rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rxdll_cc_dq3rxpbdcode", "Rx Per bit De-skew code for BL1/3  dq3 valid codes"},
#else
{12, 15, 0x0000000000000000, "RW", "rxdll_cc_dq3rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rxdll_cc_dq2rxpbdcode", "Rx Per bit De-skew code for BL1/3  dq2 valid codes"},
#else
{8, 11, 0x0000000000000000, "RW", "rxdll_cc_dq2rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rxdll_cc_dq1rxpbdcode", "Rx Per bit De-skew code for BL1/3  dq1 valid codes"},
#else
{4, 7, 0x0000000000000000, "RW", "rxdll_cc_dq1rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_cc_dq0rxpbdcode", "Rx Per bit De-skew code for BL1/3  dq0 valid codes"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_cc_dq0rxpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo396[] = {{"RXPBDBLCTL1", "", 0x000000B8, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields397[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{4, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_bl_dq8rxpbdcode", "Rx Per bit De-skew code for BL 0/2 dbi valid codes"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_bl_dq8rxpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo397[] = {{"RXBL8PBDCTL0", "", 0x000000BC, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields398[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "rxdll_bl_dq7rxpbdcode", "Rx Per bit De-skew code for BL0/2  dq7 valid codes"},
#else
{28, 31, 0x0000000000000000, "RW", "rxdll_bl_dq7rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "rxdll_bl_dq6rxpbdcode", "Rx Per bit De-skew code for BL0/2  dq6 valid codes"},
#else
{24, 27, 0x0000000000000000, "RW", "rxdll_bl_dq6rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "rxdll_bl_dq5rxpbdcode", "Rx Per bit De-skew code for BL0/2  dq5 valid codes"},
#else
{20, 23, 0x0000000000000000, "RW", "rxdll_bl_dq5rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "rxdll_bl_dq4rxpbdcode", "Rx Per bit De-skew code for BL0/2  dq4 valid codes"},
#else
{16, 19, 0x0000000000000000, "RW", "rxdll_bl_dq4rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rxdll_bl_dq3rxpbdcode", "Rx Per bit De-skew code for BL0/2  dq3 valid codes"},
#else
{12, 15, 0x0000000000000000, "RW", "rxdll_bl_dq3rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rxdll_bl_dq2rxpbdcode", "Rx Per bit De-skew code for BL0/2  dq2 valid codes"},
#else
{8, 11, 0x0000000000000000, "RW", "rxdll_bl_dq2rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rxdll_bl_dq1rxpbdcode", "Rx Per bit De-skew code for BL0/2  dq1 valid codes"},
#else
{4, 7, 0x0000000000000000, "RW", "rxdll_bl_dq1rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_bl_dq0rxpbdcode", "Rx Per bit De-skew code for BL0/2  dq0 valid codes"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_bl_dq0rxpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo398[] = {{"RXPBDBLCTL0", "", 0x000000C0, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields399[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "rxdll_cc_rxpbden", "Rx Per Bit De-skew enable for BL1/3 (1=enable, 0=disable)"},
#else
{23, 23, 0x0000000000000000, "RW", "rxdll_cc_rxpbden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "rxdll_bl_rxpbden", "Rx Per Bit De-skew enable for BL0/2 (1=enable, 0=disable)"},
#else
{22, 22, 0x0000000000000000, "RW", "rxdll_bl_rxpbden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 21, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 21, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000001, "RW", "tx_cc_pbdstaticlegen", "Per bit deskew enable - TX - BL 1/3"},
#else
{3, 3, 0x0000000000000001, "RW", "tx_cc_pbdstaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000001, "RW", "tx_bl_pbdstaticlegen", "Per bit deskew enable - TX - BL 0/2"},
#else
{2, 2, 0x0000000000000001, "RW", "tx_bl_pbdstaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000001, "RW", "dtx_cc_pbdstaticlegen", "Per bit deskew enable - DTX - BL 1/3"},
#else
{1, 1, 0x0000000000000001, "RW", "dtx_cc_pbdstaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "dtx_bl_pbdstaticlegen", "Per bit deskew enable - DTX - BL 0/2"},
#else
{0, 0, 0x0000000000000001, "RW", "dtx_bl_pbdstaticlegen", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo399[] = {{"TXPBDCTL1", "", 0x000000C4, 8, 0x00000000FFFFFFFF, 0x000000000000000F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields400[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{21, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "tx_ccdm_txpbdcode", "Tx Per Bit De-skew code for BL0/2 DM valid codes"},
#else
{16, 20, 0x0000000000000000, "RW", "tx_ccdm_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "dtx_cc_dqsbpbdcode", "Tx Per Bit De-skew code for BL0/2 DQSB  valid codes"},
#else
{8, 12, 0x0000000000000000, "RW", "dtx_cc_dqsbpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "dtx_cc_dqspbdcode", "Tx Per Bit De-skew code for BL0/2 DQS  valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "dtx_cc_dqspbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo400[] = {{"TXPBDBLCTL5", "", 0x000000C8, 6, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields401[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "tx_ccdq7_txpbdcode", "Tx Per Bit De-skew code for  BL0/2 dq7 valid codes"},
#else
{24, 28, 0x0000000000000000, "RW", "tx_ccdq7_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "tx_ccdq6_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq6 valid codes"},
#else
{16, 20, 0x0000000000000000, "RW", "tx_ccdq6_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "tx_ccdq5_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq5 valid codes"},
#else
{8, 12, 0x0000000000000000, "RW", "tx_ccdq5_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "tx_ccdq4_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq4 valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "tx_ccdq4_txpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo401[] = {{"TXPBDBLCTL4", "", 0x000000CC, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields402[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "tx_ccdq3_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq3 valid codes"},
#else
{24, 28, 0x0000000000000000, "RW", "tx_ccdq3_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "tx_ccdq2_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq2 valid codes"},
#else
{16, 20, 0x0000000000000000, "RW", "tx_ccdq2_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "tx_ccdq1_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq1 valid codes"},
#else
{8, 12, 0x0000000000000000, "RW", "tx_ccdq1_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "tx_ccdq0_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq0 valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "tx_ccdq0_txpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo402[] = {{"TXPBDBLCTL3", "", 0x000000D0, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields403[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{21, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "tx_bldm_txpbdcode", "Tx Per Bit De-skew code for BL0/2 DM valid codes"},
#else
{16, 20, 0x0000000000000000, "RW", "tx_bldm_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "dtx_bl_dqsbpbdcode", "Tx Per Bit De-skew code for BL0/2 DQSB  valid codes"},
#else
{8, 12, 0x0000000000000000, "RW", "dtx_bl_dqsbpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "dtx_bl_dqspbdcode", "Tx Per Bit De-skew code for BL0/2 DQS  valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "dtx_bl_dqspbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo403[] = {{"TXPBDBLCTL2", "", 0x000000D4, 6, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields404[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "tx_bldq7_txpbdcode", "Tx Per Bit De-skew code for  BL0/2 dq7 valid codes"},
#else
{24, 28, 0x0000000000000000, "RW", "tx_bldq7_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "tx_bldq6_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq6 valid codes"},
#else
{16, 20, 0x0000000000000000, "RW", "tx_bldq6_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "tx_bldq5_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq5 valid codes"},
#else
{8, 12, 0x0000000000000000, "RW", "tx_bldq5_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "tx_bldq4_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq4 valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "tx_bldq4_txpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo404[] = {{"TXPBDBLCTL1", "", 0x000000D8, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields405[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "tx_bldq3_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq3 valid codes"},
#else
{24, 28, 0x0000000000000000, "RW", "tx_bldq3_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "tx_bldq2_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq2 valid codes"},
#else
{16, 20, 0x0000000000000000, "RW", "tx_bldq2_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "tx_bldq1_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq1 valid codes"},
#else
{8, 12, 0x0000000000000000, "RW", "tx_bldq1_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "tx_bldq0_txpbdcode", "Tx Per Bit De-skew code for BL0/2 dq0 valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "tx_bldq0_txpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo405[] = {{"TXPBDBLCTL0", "", 0x000000DC, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields406[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{10, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{10, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000001, "RW", "drx_cc_ampoffseten", "Offset cancellation enable for Rx (not used for cc)"},
#else
{9, 9, 0x0000000000000001, "RW", "drx_cc_ampoffseten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "rx_cc_ampoffseten", "Offset cancellation enable for Rx (not used for cc)"},
#else
{8, 8, 0x0000000000000000, "RW", "rx_cc_ampoffseten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "drx_cc_ampoffset", "Offset cancellation code (DQS buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{4, 7, 0x0000000000000000, "RW", "drx_cc_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rx_ccdm_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{0, 3, 0x0000000000000000, "RW", "rx_ccdm_ampoffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo406[] = {{"OFFSETCNCLCTRL3", "", 0x000000E0, 5, 0x00000000FFFFFFFF, 0x0000000000000200}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields407[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "rx_ccdq0_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{28, 31, 0x0000000000000000, "RW", "rx_ccdq0_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "rx_ccdq1_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{24, 27, 0x0000000000000000, "RW", "rx_ccdq1_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "rx_ccdq2_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{20, 23, 0x0000000000000000, "RW", "rx_ccdq2_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "rx_ccdq3_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{16, 19, 0x0000000000000000, "RW", "rx_ccdq3_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rx_ccdq4_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{12, 15, 0x0000000000000000, "RW", "rx_ccdq4_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rx_ccdq5_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{8, 11, 0x0000000000000000, "RW", "rx_ccdq5_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rx_ccdq6_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{4, 7, 0x0000000000000000, "RW", "rx_ccdq6_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rx_ccdq7_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{0, 3, 0x0000000000000000, "RW", "rx_ccdq7_ampoffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo407[] = {{"OFFSETCNCLCTRL2", "", 0x000000E4, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields408[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{10, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{10, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000001, "RW", "drx_bl_ampoffseten", "DQS Offset cancellation enable for Rx (1=enable, 0=disable)"},
#else
{9, 9, 0x0000000000000001, "RW", "drx_bl_ampoffseten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "rx_bl_ampoffseten", "DQ Offset cancellation enable for Rx (1=enable, 0=disable)"},
#else
{8, 8, 0x0000000000000000, "RW", "rx_bl_ampoffseten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "drx_bl_ampoffset", "Offset cancellation code (DQS buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{4, 7, 0x0000000000000000, "RW", "drx_bl_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rx_bldm_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{0, 3, 0x0000000000000000, "RW", "rx_bldm_ampoffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo408[] = {{"OFFSETCNCLCTRL1", "", 0x000000E8, 5, 0x00000000FFFFFFFF, 0x0000000000000200}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields409[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "rx_bldq0_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{28, 31, 0x0000000000000000, "RW", "rx_bldq0_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "rx_bldq1_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{24, 27, 0x0000000000000000, "RW", "rx_bldq1_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "rx_bldq2_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{20, 23, 0x0000000000000000, "RW", "rx_bldq2_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "rx_bldq3_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{16, 19, 0x0000000000000000, "RW", "rx_bldq3_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rx_bldq4_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{12, 15, 0x0000000000000000, "RW", "rx_bldq4_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rx_bldq5_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{8, 11, 0x0000000000000000, "RW", "rx_bldq5_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rx_bldq6_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{4, 7, 0x0000000000000000, "RW", "rx_bldq6_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rx_bldq7_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{0, 3, 0x0000000000000000, "RW", "rx_bldq7_ampoffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo409[] = {{"OFFSETCNCLCTRL0", "", 0x000000EC, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields410[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{8, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{8, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RW", "rx_bl1_ctletune", "RX 1st Stage Amp CTLE Fine Tune - BL1"},
#else
{6, 7, 0x0000000000000000, "RW", "rx_bl1_ctletune", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "rx_bl1_ampcombtune", "RX 2nd Stage Amp Fine Tune - BL1"},
#else
{4, 5, 0x0000000000000000, "RW", "rx_bl1_ampcombtune", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RW", "drx_bl_casbiasctrl", "DRX Bias Command Control 00: Idle Mode Logic Disabled (LP3/4), Default Condition (DDR3L)   01: Idle Mode Logic Enabled (LP3/4), Illegal Condition (DDR3L)   10: Illegal Condition (ALL)   11: Illegal Condition (ALL)"},
#else
{2, 3, 0x0000000000000000, "RW", "drx_bl_casbiasctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "drx_bl_nbiasctrl", "DRX N Bias Control - BL"},
#else
{0, 1, 0x0000000000000000, "RW", "drx_bl_nbiasctrl", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo410[] = {{"CTLECTL4", "", 0x000000F0, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields411[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{20, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{20, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000001, "RW", "drx_cc_ctleen", "Enable CTLE for DQS BL1/3(1=enable, 0=disable)"},
#else
{19, 19, 0x0000000000000001, "RW", "drx_cc_ctleen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000001, "RW", "drx_cc_biasen", "DRX Bias Enable - BL1/3"},
#else
{18, 18, 0x0000000000000001, "RW", "drx_cc_biasen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "drx_cc_casbiasctrl", "DRX Bias Command Control 00: Idle Mode Logic Disabled (LP3/4), Default Condition (DDR3L)   01: Idle Mode Logic Enabled (LP3/4), Illegal Condition (DDR3L)   10: Illegal Condition (ALL)   11: Illegal Condition (ALL)"},
#else
{16, 17, 0x0000000000000000, "RW", "drx_cc_casbiasctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "drx_cc_nbiasctrl", "DRX N Bias Control - BL1/3"},
#else
{14, 15, 0x0000000000000000, "RW", "drx_cc_nbiasctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 13, 0x0000000000000000, "RW", "drx_cc_ctlebiasctrl", "DRX Bias Ctle Control - BL1/3"},
#else
{11, 13, 0x0000000000000000, "RW", "drx_cc_ctlebiasctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 10, 0x0000000000000000, "RW", "drx_cc_ctleres", "resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm for BL1/3"},
#else
{9, 10, 0x0000000000000000, "RW", "drx_cc_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000001, "RW", "drx_cc_ctlecap", "cap tuning;00 = 0.5pf;01 = 1pf;10 = 1.5pf;11 = 2pf for BL1/3"},
#else
{7, 8, 0x0000000000000001, "RW", "drx_cc_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000001, "RW", "rx_cc_ctleen", "Enable CTLE for DQ BL1/3 (1=enable, 0=disable)"},
#else
{6, 6, 0x0000000000000001, "RW", "rx_cc_ctleen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "rx_cc_ctlebiasctrl", "bias control for DQ BL1/3 ctle amp\r\n"
"00 2kΩ          0.25xnom\r\n"
"01 1kΩ          0.4xnom\r\n"
"10 0.5kΩ     1xnom\r\n"
"11 0.25kΩ  1.7xnom"},
#else
{4, 5, 0x0000000000000000, "RW", "rx_cc_ctlebiasctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RW", "rx_ccdm_ctleres", "resistor tuning for DM BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{2, 3, 0x0000000000000000, "RW", "rx_ccdm_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000001, "RW", "rx_ccdm_ctlecap", "cap tuning for DM BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{0, 1, 0x0000000000000001, "RW", "rx_ccdm_ctlecap", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo411[] = {{"CTLECTL3", "", 0x000000F4, 12, 0x00000000FFFFFFFF, 0x00000000000C00C1}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields412[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RW", "rx_ccdq0_ctleres", "resistor tuning for DQ0 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{30, 31, 0x0000000000000000, "RW", "rx_ccdq0_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RW", "rx_ccdq1_ctleres", "resistor tuning for DQ1 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{28, 29, 0x0000000000000000, "RW", "rx_ccdq1_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RW", "rx_ccdq2_ctleres", "resistor tuning for DQ2 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{26, 27, 0x0000000000000000, "RW", "rx_ccdq2_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "rx_ccdq3_ctleres", "resistor tuning for DQ3 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{24, 25, 0x0000000000000000, "RW", "rx_ccdq3_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 23, 0x0000000000000000, "RW", "rx_ccdq4_ctleres", "resistor tuning for DQ4 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{22, 23, 0x0000000000000000, "RW", "rx_ccdq4_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 21, 0x0000000000000000, "RW", "rx_ccdq5_ctleres", "resistor tuning for DQ5 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{20, 21, 0x0000000000000000, "RW", "rx_ccdq5_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RW", "rx_ccdq6_ctleres", "resistor tuning for DQ6 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{18, 19, 0x0000000000000000, "RW", "rx_ccdq6_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "rx_ccdq7_ctleres", "resistor tuning for DQ7 BL1/3;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{16, 17, 0x0000000000000000, "RW", "rx_ccdq7_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000001, "RW", "rx_ccdq0_ctlecap", "cap tuning for DQ0 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{14, 15, 0x0000000000000001, "RW", "rx_ccdq0_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000001, "RW", "rx_ccdq1_ctlecap", "cap tuning for DQ1 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{12, 13, 0x0000000000000001, "RW", "rx_ccdq1_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000001, "RW", "rx_ccdq2_ctlecap", "cap tuning for DQ2 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{10, 11, 0x0000000000000001, "RW", "rx_ccdq2_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000001, "RW", "rx_ccdq3_ctlecap", "cap tuning for DQ3 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{8, 9, 0x0000000000000001, "RW", "rx_ccdq3_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000001, "RW", "rx_ccdq4_ctlecap", "cap tuning for DQ4 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{6, 7, 0x0000000000000001, "RW", "rx_ccdq4_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000001, "RW", "rx_ccdq5_ctlecap", "cap tuning for DQ5 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{4, 5, 0x0000000000000001, "RW", "rx_ccdq5_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000001, "RW", "rx_ccdq6_ctlecap", "cap tuning for DQ6 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{2, 3, 0x0000000000000001, "RW", "rx_ccdq6_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000001, "RW", "rx_ccdq7_ctlecap", "cap tuning for DQ7 BL1/3;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{0, 1, 0x0000000000000001, "RW", "rx_ccdq7_ctlecap", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo412[] = {{"CTLECTL2", "", 0x000000F8, 16, 0x00000000FFFFFFFF, 0x0000000000005555}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields413[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{20, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{20, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RW", "rx_bl0_ctletune", "RX 1st Stage Amp CTLE Fine Tune - BL0"},
#else
{18, 19, 0x0000000000000000, "RW", "rx_bl0_ctletune", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "rx_bl0_ampcombtune", "RX 2nd Stage Amp Fine Tune - BL0"},
#else
{16, 17, 0x0000000000000000, "RW", "rx_bl0_ampcombtune", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000001, "RW", "drx_bl_ctleen", "Enable CTLE for DQS (1=enable, 0=disable)"},
#else
{15, 15, 0x0000000000000001, "RW", "drx_bl_ctleen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "drx_bl_ctlebiasctrl", "bias control for ctle amp\r\n"
"00 2kΩ          0.25xnom\r\n"
"01 1kΩ          0.4xnom\r\n"
"10 0.5kΩ     1xnom\r\n"
"11 0.25kΩ  1.7xnom"},
#else
{12, 14, 0x0000000000000000, "RW", "drx_bl_ctlebiasctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW", "drx_bl_ctleres", "resistor tuning;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{10, 11, 0x0000000000000000, "RW", "drx_bl_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000001, "RW", "drx_bl_ctlecap", "cap tuning;00 = 0.5pf;01 = 1pf;10 = 1.5pf;11 = 2pf"},
#else
{8, 9, 0x0000000000000001, "RW", "drx_bl_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000001, "RW", "drx_bl_biasen", "DRX Bias Enable - BL0/2"},
#else
{7, 7, 0x0000000000000001, "RW", "drx_bl_biasen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000001, "RW", "rx_bl_ctleen", "Enable CTLE for DQ BL0/2 (1=enable, 0=disable)"},
#else
{6, 6, 0x0000000000000001, "RW", "rx_bl_ctleen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "rx_bl_ctlebiasctrl", "bias control for ctle amp for DQ BL0/2\r\n"
"00 2kΩ          0.25xnom\r\n"
"01 1kΩ          0.4xnom\r\n"
"10 0.5kΩ     1xnom\r\n"
"11 0.25kΩ  1.7xnom"},
#else
{4, 5, 0x0000000000000000, "RW", "rx_bl_ctlebiasctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RW", "rx_bldm_ctleres", "resistor tuning for DM BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{2, 3, 0x0000000000000000, "RW", "rx_bldm_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000001, "RW", "rx_bldm_ctlecap", "cap tuning for DM BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{0, 1, 0x0000000000000001, "RW", "rx_bldm_ctlecap", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo413[] = {{"CTLECTL1", "", 0x000000FC, 12, 0x00000000FFFFFFFF, 0x00000000000081C1}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields414[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RW", "rx_bldq0_ctleres", "resistor tuning for DQ0 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{30, 31, 0x0000000000000000, "RW", "rx_bldq0_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RW", "rx_bldq1_ctleres", "resistor tuning for DQ1 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{28, 29, 0x0000000000000000, "RW", "rx_bldq1_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RW", "rx_bldq2_ctleres", "resistor tuning for DQ2 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{26, 27, 0x0000000000000000, "RW", "rx_bldq2_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "rx_bldq3_ctleres", "resistor tuning for DQ3 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{24, 25, 0x0000000000000000, "RW", "rx_bldq3_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 23, 0x0000000000000000, "RW", "rx_bldq4_ctleres", "resistor tuning for DQ4 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{22, 23, 0x0000000000000000, "RW", "rx_bldq4_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 21, 0x0000000000000000, "RW", "rx_bldq5_ctleres", "resistor tuning for DQ5 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{20, 21, 0x0000000000000000, "RW", "rx_bldq5_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RW", "rx_bldq6_ctleres", "resistor tuning for DQ6 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{18, 19, 0x0000000000000000, "RW", "rx_bldq6_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "rx_bldq7_ctleres", "resistor tuning for DQ7 BL0/2;00=0.5kohm;01=1kohm;10=1.5kohm;11=2kohm"},
#else
{16, 17, 0x0000000000000000, "RW", "rx_bldq7_ctleres", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000001, "RW", "rx_bldq0_ctlecap", "cap tuning for DQ0 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{14, 15, 0x0000000000000001, "RW", "rx_bldq0_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000001, "RW", "rx_bldq1_ctlecap", "cap tuning for DQ1 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{12, 13, 0x0000000000000001, "RW", "rx_bldq1_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000001, "RW", "rx_bldq2_ctlecap", "cap tuning for DQ2 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{10, 11, 0x0000000000000001, "RW", "rx_bldq2_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000001, "RW", "rx_bldq3_ctlecap", "cap tuning for DQ3 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{8, 9, 0x0000000000000001, "RW", "rx_bldq3_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000001, "RW", "rx_bldq4_ctlecap", "cap tuning for DQ4 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{6, 7, 0x0000000000000001, "RW", "rx_bldq4_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000001, "RW", "rx_bldq5_ctlecap", "cap tuning for DQ5 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{4, 5, 0x0000000000000001, "RW", "rx_bldq5_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000001, "RW", "rx_bldq6_ctlecap", "cap tuning for DQ6 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{2, 3, 0x0000000000000001, "RW", "rx_bldq6_ctlecap", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000001, "RW", "rx_bldq7_ctlecap", "cap tuning for DQ7 BL0/2;00 = 0.1pf;01 = 0.2pf;10 = 0.3pf;11 = 0.4pf"},
#else
{0, 1, 0x0000000000000001, "RW", "rx_bldq7_ctlecap", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo414[] = {{"CTLECTL0", "", 0x00000100, 16, 0x00000000FFFFFFFF, 0x0000000000005555}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields415[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000001, "RW", "tx_bl_tcostaticlegen", "TX TCO enable - BL0/2"},
#else
{31, 31, 0x0000000000000001, "RW", "tx_bl_tcostaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 30, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 30, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x000000000000001F, "RW", "tx_bl_tcofall", "DQ TCO comp fall code - BL0/2"},
#else
{24, 28, 0x000000000000001F, "RW", "tx_bl_tcofall", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x000000000000001F, "RW", "tx_bl_tcorise", "DQ TCO comp rise code - BL0/2"},
#else
{16, 20, 0x000000000000001F, "RW", "tx_bl_tcorise", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000001, "RW", "tx_cc_tcostaticlegen", "TX TCO enable - BL1/3"},
#else
{15, 15, 0x0000000000000001, "RW", "tx_cc_tcostaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 14, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x000000000000001F, "RW", "tx_cc_tcofall", "DQ TCO comp fall code - BL1/3 Lane"},
#else
{8, 12, 0x000000000000001F, "RW", "tx_cc_tcofall", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x000000000000001F, "RW", "tx_cc_tcorise", "DQ TCO comp rise code - BL1/3 Lane"},
#else
{0, 4, 0x000000000000001F, "RW", "tx_cc_tcorise", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo415[] = {{"TCOCTL_DQCC", "", 0x00000104, 10, 0x00000000FFFFFFFF, 0x000000009F1F9F1F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields416[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{30, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000001, "RW", "dtx_bl_tcostaticlegen", "DTX TCO enable - BL0/2"},
#else
{29, 29, 0x0000000000000001, "RW", "dtx_bl_tcostaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x000000000000001F, "RW", "dtx_bl_tcofalldqsb", "DQSB TCO comp fall code - BL0/2"},
#else
{24, 28, 0x000000000000001F, "RW", "dtx_bl_tcofalldqsb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x000000000000001F, "RW", "dtx_bl_tcorisedqsb", "DQS TCO comp fall code - BL0/2"},
#else
{16, 20, 0x000000000000001F, "RW", "dtx_bl_tcorisedqsb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x000000000000001F, "RW", "dtx_bl_tcofalldqs", "DQSB TCO comp rise code - BL0/2"},
#else
{8, 12, 0x000000000000001F, "RW", "dtx_bl_tcofalldqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x000000000000001F, "RW", "dtx_bl_tcorisedqs", "DQS TCO comp rise code - BL0/2"},
#else
{0, 4, 0x000000000000001F, "RW", "dtx_bl_tcorisedqs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo416[] = {{"TCOCTL_DQ", "", 0x00000108, 9, 0x00000000FFFFFFFF, 0x000000003F1F1F1F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields417[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{30, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000001, "RW", "dtx_cc_tcostaticlegen", "DTX TCO enable - BL1/3"},
#else
{29, 29, 0x0000000000000001, "RW", "dtx_cc_tcostaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x000000000000001F, "RW", "dtx_cc_tcofalldqsb", "DQSB TCO comp fall code - BL1/3 Lane"},
#else
{24, 28, 0x000000000000001F, "RW", "dtx_cc_tcofalldqsb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x000000000000001F, "RW", "dtx_cc_tcorisedqsb", "DQSB TCO comp rise code - BL1/3 Lane"},
#else
{16, 20, 0x000000000000001F, "RW", "dtx_cc_tcorisedqsb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x000000000000001F, "RW", "dtx_cc_tcofalldqs", "DQS TCO comp fall code - BL1/3 Lane"},
#else
{8, 12, 0x000000000000001F, "RW", "dtx_cc_tcofalldqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x000000000000001F, "RW", "dtx_cc_tcorisedqs", "DQS TCO comp rise code - BL1/3 Lane"},
#else
{0, 4, 0x000000000000001F, "RW", "dtx_cc_tcorisedqs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo417[] = {{"TCOCTL_CC", "", 0x0000010C, 9, 0x00000000FFFFFFFF, 0x000000003F1F1F1F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields418[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{23, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 22, 0x0000000000000000, "RW", "txdll_rk1siggrp06dbsel", "Dead band select for sig grp 6 rank 1  - UNUSED FOR BXT-P"},
#else
{21, 22, 0x0000000000000000, "RW", "txdll_rk1siggrp06dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "txdll_rk1siggrp06rdptroffset", "Read pointer offset for sig group 6 rank 1"},
#else
{16, 20, 0x0000000000000000, "RW", "txdll_rk1siggrp06rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 6, 0x0000000000000000, "RW", "txdll_rk0siggrp06dbsel", "Dead band select for sig grp 6 rank 0  - UNUSED FOR BXT-P"},
#else
{5, 6, 0x0000000000000000, "RW", "txdll_rk0siggrp06dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "txdll_rk0siggrp06rdptroffset", "Read pointer offset for sig group 6 rank 0"},
#else
{0, 4, 0x0000000000000000, "RW", "txdll_rk0siggrp06rdptroffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo418[] = {{"TXDLLSIGGRP6CTL", "", 0x00000110, 6, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields419[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{23, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 22, 0x0000000000000000, "RW", "txdll_rk1siggrp07dbsel", "Dead band select for sig grp 7 rank 1  - UNUSED FOR BXT-P"},
#else
{21, 22, 0x0000000000000000, "RW", "txdll_rk1siggrp07dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "txdll_rk1siggrp07rdptroffset", "Read pointer offset for sig group 7 rank 1"},
#else
{16, 20, 0x0000000000000000, "RW", "txdll_rk1siggrp07rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 6, 0x0000000000000000, "RW", "txdll_rk0siggrp07dbsel", "Dead band select for sig grp 7 rank 0  - UNUSED FOR BXT-P"},
#else
{5, 6, 0x0000000000000000, "RW", "txdll_rk0siggrp07dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "txdll_rk0siggrp07rdptroffset", "Read pointer offset for sig group 7 rank 0"},
#else
{0, 4, 0x0000000000000000, "RW", "txdll_rk0siggrp07rdptroffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo419[] = {{"TXDLLSIGGRP7CTL", "", 0x00000114, 6, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields420[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "cc_rk1dqdrvsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQDMDRV - RK1."},
#else
{20, 23, 0x0000000000000000, "RW", "cc_rk1dqdrvsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "cc_rk0dqdrvsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQDMDRV - RK0."},
#else
{16, 19, 0x0000000000000000, "RW", "cc_rk0dqdrvsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "cc_rk1dqsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQ - RK1."},
#else
{12, 15, 0x0000000000000000, "RW", "cc_rk1dqsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "cc_rk0dqsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQ - RK0."},
#else
{8, 11, 0x0000000000000000, "RW", "cc_rk0dqsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "cc_rk1dqsdrvsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQ - RK1."},
#else
{4, 7, 0x0000000000000000, "RW", "cc_rk1dqsdrvsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "cc_rk0dqsdrvsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQ - RK0."},
#else
{0, 3, 0x0000000000000000, "RW", "cc_rk0dqsdrvsecondrdportref2xrdptroffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo420[] = {{"LDOCTL1", "", 0x00000118, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields421[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "bl_rk1dqdrvsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQDMDRV - RK1."},
#else
{20, 23, 0x0000000000000000, "RW", "bl_rk1dqdrvsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "bl_rk0dqdrvsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQDMDRV - RK0."},
#else
{16, 19, 0x0000000000000000, "RW", "bl_rk0dqdrvsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "bl_rk1dqsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQ - RK1."},
#else
{12, 15, 0x0000000000000000, "RW", "bl_rk1dqsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "bl_rk0dqsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQ - RK0."},
#else
{8, 11, 0x0000000000000000, "RW", "bl_rk0dqsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "bl_rk1dqsdrvsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQ - RK1."},
#else
{4, 7, 0x0000000000000000, "RW", "bl_rk1dqsdrvsecondrdportref2xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "bl_rk0dqsdrvsecondrdportref2xrdptroffset", "Read pointer offset for second port for LDO integration - DQ - RK0."},
#else
{0, 3, 0x0000000000000000, "RW", "bl_rk0dqsdrvsecondrdportref2xrdptroffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo421[] = {{"LDOCTL0", "", 0x0000011C, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields422[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RW", "data0sel", "DRAM read data bit mux for DQ0. \r\n"
"This needs to be programmed based on the how DRAM data pins get swizzled at the DRAM package.\r\n"
"000:  Use DQ0\r\n"
"001:  Use DQ1\r\n"
"010:  Use DQ2\r\n"
"011:  Use DQ3\r\n"
"100:  Use DQ4\r\n"
"101:  Use DQ5\r\n"
"110:  Use DQ6\r\n"
"111:  Use DQ7"},
#else
{21, 23, 0x0000000000000000, "RW", "data0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 20, 0x0000000000000000, "RW", "data1sel", "DRAM read data bit mux for DQ1. \r\n"
"This needs to be programmed based on the how DRAM data pins get swizzled at the DRAM package.\r\n"
"000:  Use DQ0\r\n"
"001:  Use DQ1\r\n"
"010:  Use DQ2\r\n"
"011:  Use DQ3\r\n"
"100:  Use DQ4\r\n"
"101:  Use DQ5\r\n"
"110:  Use DQ6\r\n"
"111:  Use DQ7"},
#else
{18, 20, 0x0000000000000000, "RW", "data1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 17, 0x0000000000000000, "RW", "data2sel", "DRAM read data bit mux for DQ2. \r\n"
"This needs to be programmed based on the how DRAM data pins get swizzled at the DRAM package.\r\n"
"000:  Use DQ0\r\n"
"001:  Use DQ1\r\n"
"010:  Use DQ2\r\n"
"011:  Use DQ3\r\n"
"100:  Use DQ4\r\n"
"101:  Use DQ5\r\n"
"110:  Use DQ6\r\n"
"111:  Use DQ7"},
#else
{15, 17, 0x0000000000000000, "RW", "data2sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "data3sel", "DRAM read data bit mux for DQ3. \r\n"
"This needs to be programmed based on the how DRAM data pins get swizzled at the DRAM package.\r\n"
"000:  Use DQ0\r\n"
"001:  Use DQ1\r\n"
"010:  Use DQ2\r\n"
"011:  Use DQ3\r\n"
"100:  Use DQ4\r\n"
"101:  Use DQ5\r\n"
"110:  Use DQ6\r\n"
"111:  Use DQ7"},
#else
{12, 14, 0x0000000000000000, "RW", "data3sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 11, 0x0000000000000000, "RW", "data4sel", "DRAM read data bit mux for DQ4. \r\n"
"This needs to be programmed based on the how DRAM data pins get swizzled at the DRAM package.\r\n"
"000:  Use DQ0\r\n"
"001:  Use DQ1\r\n"
"010:  Use DQ2\r\n"
"011:  Use DQ3\r\n"
"100:  Use DQ4\r\n"
"101:  Use DQ5\r\n"
"110:  Use DQ6\r\n"
"111:  Use DQ7"},
#else
{9, 11, 0x0000000000000000, "RW", "data4sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 8, 0x0000000000000000, "RW", "data5sel", "DRAM read data bit mux for DQ5. \r\n"
"This needs to be programmed based on the how DRAM data pins get swizzled at the DRAM package.\r\n"
"000:  Use DQ0\r\n"
"001:  Use DQ1\r\n"
"010:  Use DQ2\r\n"
"011:  Use DQ3\r\n"
"100:  Use DQ4\r\n"
"101:  Use DQ5\r\n"
"110:  Use DQ6\r\n"
"111:  Use DQ7"},
#else
{6, 8, 0x0000000000000000, "RW", "data5sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 5, 0x0000000000000000, "RW", "data6sel", "DRAM read data bit mux for DQ6. \r\n"
"This needs to be programmed based on the how DRAM data pins get swizzled at the DRAM package.\r\n"
"000:  Use DQ0\r\n"
"001:  Use DQ1\r\n"
"010:  Use DQ2\r\n"
"011:  Use DQ3\r\n"
"100:  Use DQ4\r\n"
"101:  Use DQ5\r\n"
"110:  Use DQ6\r\n"
"111:  Use DQ7"},
#else
{3, 5, 0x0000000000000000, "RW", "data6sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RW", "data7sel", "DRAM read data bit mux for DQ7.  \r\n"
"This needs to be programmed based on the how DRAM data pins get swizzled at the DRAM package.\r\n"
"000:  Use DQ0\r\n"
"001:  Use DQ1\r\n"
"010:  Use DQ2\r\n"
"011:  Use DQ3\r\n"
"100:  Use DQ4\r\n"
"101:  Use DQ5\r\n"
"110:  Use DQ6\r\n"
"111:  Use DQ7"},
#else
{0, 2, 0x0000000000000000, "RW", "data7sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo422[] = {{"PTDATAMUXSEL", "", 0x00000120, 9, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields423[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 30, 0x0000000000000000, "RW", "lpmode_dasrtdqcmddrvenb_dly", "This indicates the delay in spidclk cycles for DQ/DQS driver disable, during LP mode 1 entry"},
#else
{28, 30, 0x0000000000000000, "RW", "lpmode_dasrtdqcmddrvenb_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{27, 27, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000000, "RW", "lpmode_asrtdqcmdsigpien_dly", "This indicates the delay in spidclk cycles for DQ/DQS/CMD PI disable/enable, during LP mode 1 entry/exit"},
#else
{24, 26, 0x0000000000000000, "RW", "lpmode_asrtdqcmdsigpien_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 22, 0x0000000000000000, "RW", "lpmode_asrtdqcmddrvenb_dly", "This indicates the delay in spidclk cycles for DQ/DQS driver enable, during LP mode  1 exit"},
#else
{20, 22, 0x0000000000000000, "RW", "lpmode_asrtdqcmddrvenb_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{19, 19, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000000, "RW", "lpmode_dasrtiobufact_dly", "This indicates the delay in spidclk cycles for IOBUFACT disable, during LP mode 2  entry"},
#else
{16, 18, 0x0000000000000000, "RW", "lpmode_dasrtiobufact_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "lpmode_dasrtwrptren_dly", "This indicates the delay in spidclk cycles for write pointer disable, during LP mode  2 entry"},
#else
{12, 14, 0x0000000000000000, "RW", "lpmode_dasrtwrptren_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "lpmode_asrtref2xrstb_dly", "This indicates the delay in spidclk cycles for ref2xclk reset assertion, during LP mode 2  entry"},
#else
{8, 10, 0x0000000000000000, "RW", "lpmode_asrtref2xrstb_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 6, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{3, 3, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RW", "lpmode_dasrtref2xrstb_dly", "This indicates the delay in spidclk cycles for ref2xclk reset de-assertion, during LP mode 2 exit"},
#else
{0, 2, 0x0000000000000000, "RW", "lpmode_dasrtref2xrstb_dly", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo423[] = {{"LPMODECTL0", "", 0x00000124, 16, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields424[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 30, 0x0000000000000000, "RW", "lpmode_asrtwrptren_dly", "This indicates the delay in spidclk cycles for write pointer enable, during LP mode 2 exit"},
#else
{28, 30, 0x0000000000000000, "RW", "lpmode_asrtwrptren_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{27, 27, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000000, "RW", "lpmode_asrtiobufact_dly", "This indicates the delay in spidclk cycles for IOBUFACT enable, during LP mode 2 exit"},
#else
{24, 26, 0x0000000000000000, "RW", "lpmode_asrtiobufact_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "lpmode_dqcmddrvenbovrd", "Override LP mode control for DQ/DQS/CMD driver"},
#else
{22, 22, 0x0000000000000000, "RW", "lpmode_dqcmddrvenbovrd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "lpmode_iobufactovrd", "Override LP mode control for IOBUFACT"},
#else
{21, 21, 0x0000000000000000, "RW", "lpmode_iobufactovrd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "lpmode_ref2xclkenovrd", "Override LP mode control for ref2xclk enable"},
#else
{20, 20, 0x0000000000000000, "RW", "lpmode_ref2xclkenovrd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "siggrpen_lpmode1ovrd", "Override LP mode control for signal PI enable"},
#else
{19, 19, 0x0000000000000000, "RW", "siggrpen_lpmode1ovrd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "siggrpen_lpmode2or3ovrd", "Override LP mode control for signal PI enable"},
#else
{18, 18, 0x0000000000000000, "RW", "siggrpen_lpmode2or3ovrd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "lpmode_wrptrenovrd", "Override LP mode control for write pointer enable"},
#else
{17, 17, 0x0000000000000000, "RW", "lpmode_wrptrenovrd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "lpmode_ref2xrstbovrd", "Override LP mode control for ref2xrstb"},
#else
{16, 16, 0x0000000000000000, "RW", "lpmode_ref2xrstbovrd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{8, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "lpmode_asrtref2xsigpien_dly", "This indicates the delay in spidclk cycles for DLL enable, during LP mode 2 exit"},
#else
{0, 7, 0x0000000000000000, "RW", "lpmode_asrtref2xsigpien_dly", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo424[] = {{"LPMODECTL1", "", 0x00000128, 14, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields425[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 23, 0x0000000000000000, "RW", "rdcmd2rxdllupdt", "Read command to RXDLL update."},
#else
{18, 23, 0x0000000000000000, "RW", "rdcmd2rxdllupdt", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 17, 0x0000000000000000, "RW", "rxdllupdtlen", "RXDLL update enable."},
#else
{12, 17, 0x0000000000000000, "RW", "rxdllupdtlen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 11, 0x0000000000000000, "RW", "rdcmd2rdactive", "Read command to active delay."},
#else
{6, 11, 0x0000000000000000, "RW", "rdcmd2rdactive", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "rdactivelen", "Read active length."},
#else
{0, 5, 0x0000000000000000, "RW", "rdactivelen", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo425[] = {{"RXDLLRDCMDCTL0", "", 0x0000012C, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields426[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{1, 31, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "dllcomprst_b", "Power-on or software reset0: reset state1: norma operationSet to 1 to enter normal operation."},
#else
{0, 0, 0x0000000000000000, "RW", "dllcomprst_b", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo426[] = {{"DLLCOMP_RESET", "", 0x00000600, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields427[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{1, 31, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RWS", "txdll_init", "Activates initialization training sequence.0: initialization training sequence not active.1: initialization training sequence active.Self clearing after successful initialization training sequence."},
#else
{0, 0, 0x0000000000000000, "RWS", "txdll_init", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo427[] = {{"DLLCOMP_INIT", "", 0x00000604, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields428[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{1, 31, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "lpddr_type", "LPDDR speed target. 0: LPDDR3, 1600 MHz. 1: LPDDR4, 3200 MHz."},
#else
{0, 0, 0x0000000000000000, "RW", "lpddr_type", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo428[] = {{"DLLCOMP_LPDDRTYPE", "", 0x00000608, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields429[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{1, 31, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "clkungate", "Internal Clock control. 0 = allow clock gating for low power; 1 = allow free running clock"},
#else
{0, 0, 0x0000000000000001, "RW", "clkungate", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo429[] = {{"DLLCOMP_CLKUNGATE", "", 0x0000060C, 2, 0x00000000FFFFFFFF, 0x0000000000000001}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields430[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{8, 31, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{8, 31, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO/V", "txdll_lock_error", "Set when initialization or fine periodic training failed the locking condition. Cleared on a read or writing a 0."},
#else
{7, 7, 0x0000000000000000, "RO/V", "txdll_lock_error", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO/V", "txdll_fine_error", "Set when fine code underflow or overflow occurs. Cleared on a read or writing a 0."},
#else
{6, 6, 0x0000000000000000, "RO/V", "txdll_fine_error", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RO/V", "txdll_coarsep_error", "Set when coarse code underflow or overflow occurs. Cleared on a read or writing a 0."},
#else
{5, 5, 0x0000000000000000, "RO/V", "txdll_coarsep_error", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RO/V", "txdll_error", "Set when Delay Cell count exceeds maximum value. Cleared on a read or writing a 0."},
#else
{4, 4, 0x0000000000000000, "RO/V", "txdll_error", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{2, 3, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO/V", "txdll_lock_flag", "Set when initialization or fine periodic training passed the locking condition. Valid only when scr_lockseq_en is set to 1.Cleared on a read or writing a 0."},
#else
{1, 1, 0x0000000000000000, "RO/V", "txdll_lock_flag", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO/V", "txdll_init_done", "Set when Initialization sequence is successful. Cleared on a read or writing a 0."},
#else
{0, 0, 0x0000000000000000, "RO/V", "txdll_init_done", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo430[] = {{"DLLCOMP_ERROR_STATUS", "", 0x00000610, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields431[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{21, 31, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{21, 31, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RO/V", "txdll_stat_fbmuxsel", "Delay Cell count value during normal operation"},
#else
{16, 20, 0x0000000000000000, "RO/V", "txdll_stat_fbmuxsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RO/V", "txdll_stat_coarseicode", "Coarse code value at initialization training sequence completion."},
#else
{12, 15, 0x0000000000000000, "RO/V", "txdll_stat_coarseicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RO/V", "txdll_stat_coarsecode", "Coarse code value during normal operation"},
#else
{8, 11, 0x0000000000000000, "RO/V", "txdll_stat_coarsecode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RO/V", "txdll_stat_finecode", "Fine code value during normal operation"},
#else
{0, 7, 0x0000000000000000, "RO/V", "txdll_stat_finecode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo431[] = {{"DLLCOMP_CODE_STATUS", "", 0x00000614, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields432[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "lock_seq_en", "Enable lock sequence after initialization or fine periodic training sequence. 0: disable lock sequence. 1: enable lock sequence."},
#else
{31, 31, 0x0000000000000000, "RW", "lock_seq_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "lockerror_ignore", "Ignore lock error. Valid when scr_lockseq_en = 1. 0: Exit and wait for initialization training sequence. 1: ignore lock error and proceed to normal operation."},
#else
{30, 30, 0x0000000000000000, "RW", "lockerror_ignore", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 29, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{4, 29, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000003, "RW", "lockcount_size", "Maximum samples to count for lock condition. The counter decrements until the value reaches 0 yielding scr_lockcount_size + 1 samples."},
#else
{0, 3, 0x0000000000000003, "RW", "lockcount_size", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo432[] = {{"DLLCOMP_LOCKCTL", "", 0x00000618, 4, 0x00000000FFFFFFFF, 0x0000000000000003}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields433[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "muxcode_ovr_sel", "Override txdll_fbmuxsel[4:0] with scr_muxcode_ovr[4:0].0: disable override.1: enable override."},
#else
{31, 31, 0x0000000000000000, "RW", "muxcode_ovr_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 30, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{21, 30, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "muxcode_ovr", "Delay cell fbmuxsel override value."},
#else
{16, 20, 0x0000000000000000, "RW", "muxcode_ovr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{13, 15, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "muxcode_max", "Delay cell maximum count value. Used in overflow check"},
#else
{8, 12, 0x0000000000000000, "RW", "muxcode_max", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{5, 7, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000009, "RW", "muxcode_min", "Delay cell minimum count value. Default start code."},
#else
{0, 4, 0x0000000000000009, "RW", "muxcode_min", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo433[] = {{"DLLCOMP_FBMUXSEL", "", 0x0000061C, 7, 0x00000000FFFFFFFF, 0x0000000000000009}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields434[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "coarsecode_ovr_sel", "Override txdll_coarsecode[3:0] with scr_coarsecode_ovr[3:0]. 0: disable override, 1: enable override"},
#else
{31, 31, 0x0000000000000000, "RW", "coarsecode_ovr_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "coarseicode_ovr_sel", "Override txdll_coarseicode[3:0] with scr_coarseicode_ovr[3:0]. 0: disable override, 1: enable override"},
#else
{30, 30, 0x0000000000000000, "RW", "coarseicode_ovr_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{28, 29, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "coarseicode_ovr", "Coarsei code override value."},
#else
{24, 27, 0x0000000000000000, "RW", "coarseicode_ovr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{20, 23, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "coarsecode_ovr", "Coarse code override value."},
#else
{16, 19, 0x0000000000000000, "RW", "coarsecode_ovr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{12, 15, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "coarsecode_max", "Coarse code maximum count value. Default start value. Used in overflow check"},
#else
{8, 11, 0x0000000000000000, "RW", "coarsecode_max", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{4, 7, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000002, "RW", "coarsecode_min", "Coarse code minimum count value. Used in underflow check."},
#else
{0, 3, 0x0000000000000002, "RW", "coarsecode_min", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo434[] = {{"DLLCOMP_COARSECODE", "", 0x00000620, 10, 0x00000000FFFFFFFF, 0x0000000000000002}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields435[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RW", "finecodemax_limit", "Fine code limit - maximum value. Defines fine code drift allowed towards finecode maximum value before incrementing the coarse code for binary search training."},
#else
{24, 31, 0x0000000000000000, "RW", "finecodemax_limit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "finecodemin_limit", "Fine code limit - minimum value. Defines fine code drift allowed towards finecode minimum value before decrementing the coarse code for binary search training."},
#else
{16, 23, 0x0000000000000000, "RW", "finecodemin_limit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "finecode_max", "Fine code maximum value. Used in overflow check during fine continuous or fine periodic"},
#else
{8, 15, 0x0000000000000000, "RW", "finecode_max", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "finecode_min", "Underflow check during fine continuous or fine periodic training."},
#else
{0, 7, 0x0000000000000000, "RW", "finecode_min", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo435[] = {{"DLLCOMP_FINECODE", "", 0x00000624, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields436[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{8, 31, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{8, 31, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "finecode_muxsel", "Two bit field selects one of 4 possible finecode values for each 8:1 mux input. Two bit field shared between -/+ index values (ex. -gf / +gf)"},
#else
{0, 7, 0x0000000000000000, "RW", "finecode_muxsel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo436[] = {{"DLLCOMP_FINEMUXSEL", "", 0x00000628, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields437[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "finec_mode", "Fine continuous training enable after initialization training. 0: Fine continuous training disable. 1: Fine continuous training enable (default). When both finec_mode and finep_mode are set to 1, dllcomp functionality is unpredictable."},
#else
{31, 31, 0x0000000000000000, "RW", "finec_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "finep_mode", "Fine priodic training enable after initialization training. 0: Fine periodic disable (default). 1: Fine periodic enable. When both finec_mode and finep_mode are set to 1, dllcomp functionality is unpredictable."},
#else
{30, 30, 0x0000000000000000, "RW", "finep_mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW", "searchalgo_long", "Propriety search algorithm version to apply during lock, fine continuous and fine periodic training. 0: Apply short version. 1: Apply long version."},
#else
{29, 29, 0x0000000000000000, "RW", "searchalgo_long", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 28, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{8, 28, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "finecode_start", "Fine code start value to apply during binary search training"},
#else
{0, 7, 0x0000000000000000, "RW", "finecode_start", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo437[] = {{"DLLCOMP_FINECTL", "", 0x0000062C, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields438[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "finecode_ovr_sel", "Fine code override select. 0: Apply computed fine code (default). 1: Apply scr_finecode_ovr[7:0] ."},
#else
{31, 31, 0x0000000000000000, "RW", "finecode_ovr_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "finecode_updateovr_ovr", "When scr_finecode_ovr_sel is active high, this bit drives txdll_dllupdateovr"},
#else
{30, 30, 0x0000000000000000, "RW", "finecode_updateovr_ovr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 29, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{8, 29, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "finecode_ovr", "Fine code to override with when scr_finecode_ovr_sel = 1"},
#else
{0, 7, 0x0000000000000000, "RW", "finecode_ovr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo438[] = {{"DLLCOMP_FINECODEOVR", "", 0x00000630, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields439[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{16, 31, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RW", "finepwait_interval", "Fine periodic interval timer start value. Defines the interval between back to back fine periodic training sequences."},
#else
{0, 15, 0x0000000000000000, "RW", "finepwait_interval", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo439[] = {{"DLLCOMP_FPTIMER", "", 0x00000634, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields440[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{13, 31, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{13, 31, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000006, "RW", "samplewait_max", "Wait interval between code update and sample ready. Applied during lock, fine continuous and fine"},
#else
{8, 12, 0x0000000000000006, "RW", "samplewait_max", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{5, 7, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000002, "RW", "samplewait_min", "Wait interval between code update and sample ready. Applied during coarse initialization and fine"},
#else
{0, 4, 0x0000000000000002, "RW", "samplewait_min", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo440[] = {{"DLLCOMP_SAMPLEWAIT", "", 0x00000638, 4, 0x00000000FFFFFFFF, 0x0000000000000602}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields441[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "rxdll_coarsecode_ovr_sel", "Override rxdll_coarsecode[3:0] with scr_rxdll_coarsecode_ovr[3:0] . 0: disable override. 1: enable override."},
#else
{31, 31, 0x0000000000000000, "RW", "rxdll_coarsecode_ovr_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 30, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{4, 30, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_coarsecode_ovr", "Coarse code override value for rxdll_coarsecode[3:0]"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_coarsecode_ovr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo441[] = {{"DLLCOMP_RXCOARSEOVR", "", 0x0000063C, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields442[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "rxdll_finecode_ovr_sel", "Override rxdll_finecode[7:0] with scr_rxdll_finecode_ovr[7:0] . 0: disable override. 1: enable override."},
#else
{31, 31, 0x0000000000000000, "RW", "rxdll_finecode_ovr_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "rxdll_finecode_updateovr_ovr", "When scr_rxdll_finecode_ovr_sel is active high, this bit drives rxdll_rxdqsdllupdateovr"},
#else
{30, 30, 0x0000000000000000, "RW", "rxdll_finecode_updateovr_ovr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 29, 0x0000000000000000, "RO", "Reserved", "Reserved"},
#else
{8, 29, 0x0000000000000000, "RO", "Reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "rxdll_finecode_ovr", "FIne code override value for rxdll_finecode[7:0]"},
#else
{0, 7, 0x0000000000000000, "RW", "rxdll_finecode_ovr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo442[] = {{"DLLCOMP_RXFINEOVR", "", 0x00000640, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields443[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{7, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000000, "RW", "dfxvisa_ulm0pattgen_msb", "VISA Pattern Generation"},
#else
{4, 6, 0x0000000000000000, "RW", "dfxvisa_ulm0pattgen_msb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "dfxvisa_ulm0pattgen_lsb", "VISA Pattern Generation"},
#else
{0, 3, 0x0000000000000000, "RW", "dfxvisa_ulm0pattgen_lsb", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo443[] = {{"DFXVISA_ULM0PATTGEN", "", 0x00000700, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields444[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm0ln0_bypass", "VISA Bypass ULM0LN0"},
#else
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm0ln0_bypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm0ln0_clksel", "VISA ULM0LN0 CLK Select"},
#else
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm0ln0_clksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm0ln0_datasel", "VISA ULM0LN0 (DATA) Select"},
#else
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm0ln0_datasel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo444[] = {{"DFXVISA_ULM0LN0", "", 0x00000704, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields445[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm0ln1_bypass", "VISA Bypass ULM0LN1"},
#else
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm0ln1_bypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm0ln1_clksel", "VISA ULM0LN1 CLK Select"},
#else
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm0ln1_clksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm0ln1_datasel", "VISA ULM0LN1 (DATA) Select"},
#else
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm0ln1_datasel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo445[] = {{"DFXVISA_ULM0LN1", "", 0x00000708, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields446[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{7, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000000, "RW", "dfxvisa_ulm1pattgen_msb", "VISA Pattern Generation"},
#else
{4, 6, 0x0000000000000000, "RW", "dfxvisa_ulm1pattgen_msb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "dfxvisa_ulm1pattgen_lsb", "VISA Pattern Generation"},
#else
{0, 3, 0x0000000000000000, "RW", "dfxvisa_ulm1pattgen_lsb", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo446[] = {{"DFXVISA_ULM1PATTGEN", "", 0x0000070C, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields447[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm1ln0_bypass", "VISA Bypass ULM1LN0"},
#else
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm1ln0_bypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm1ln0_clksel", "VISA ULM1LN0 CLK Select"},
#else
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm1ln0_clksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm1ln0_datasel", "VISA ULM1LN0 (DATA) Select"},
#else
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm1ln0_datasel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo447[] = {{"DFXVISA_ULM1LN0", "", 0x00000710, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields448[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm1ln1_bypass", "VISA Bypass ULM1LN1"},
#else
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm1ln1_bypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm1ln1_clksel", "VISA ULM1LN1 CLK Select"},
#else
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm1ln1_clksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm1ln1_datasel", "VISA ULM1LN1 (DATA) Select"},
#else
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm1ln1_datasel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo448[] = {{"DFXVISA_ULM1LN1", "", 0x00000714, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields449[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{7, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000000, "RW", "dfxvisa_ulm2pattgen_msb", "VISA Pattern Generation"},
#else
{4, 6, 0x0000000000000000, "RW", "dfxvisa_ulm2pattgen_msb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "dfxvisa_ulm2pattgen_lsb", "VISA Pattern Generation"},
#else
{0, 3, 0x0000000000000000, "RW", "dfxvisa_ulm2pattgen_lsb", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo449[] = {{"DFXVISA_ULM2PATTGEN", "", 0x00000718, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields450[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm2ln0_bypass", "VISA Bypass ULM2LN0"},
#else
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm2ln0_bypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm2ln0_clksel", "VISA ULM2LN0 CLK Select"},
#else
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm2ln0_clksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm2ln0_datasel", "VISA ULM2LN0 (DATA) Select"},
#else
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm2ln0_datasel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo450[] = {{"DFXVISA_ULM2LN0", "", 0x0000071C, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields451[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm2ln1_bypass", "VISA Bypass ULM2LN1"},
#else
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm2ln1_bypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm2ln1_clksel", "VISA ULM2LN1 CLK Select"},
#else
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm2ln1_clksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm2ln1_datasel", "VISA ULM2LN1 (DATA) Select"},
#else
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm2ln1_datasel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo451[] = {{"DFXVISA_ULM2LN1", "", 0x00000720, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields452[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{7, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{7, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000000, "RW", "dfxvisa_ulm3pattgen_msb", "VISA Pattern Generation"},
#else
{4, 6, 0x0000000000000000, "RW", "dfxvisa_ulm3pattgen_msb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "dfxvisa_ulm3pattgen_lsb", "VISA Pattern Generation"},
#else
{0, 3, 0x0000000000000000, "RW", "dfxvisa_ulm3pattgen_lsb", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo452[] = {{"DFXVISA_ULM3PATTGEN", "", 0x00000724, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields453[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm3ln0_bypass", "VISA Bypass ULM3LN0"},
#else
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm3ln0_bypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm3ln0_clksel", "VISA ULM3LN0 CLK Select"},
#else
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm3ln0_clksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm3ln0_datasel", "VISA ULM3LN0 (DATA) Select"},
#else
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm3ln0_datasel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo453[] = {{"DFXVISA_ULM3LN0", "", 0x00000728, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields454[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm3ln1_bypass", "VISA Bypass ULM3LN1"},
#else
{16, 16, 0x0000000000000000, "RW", "dfxvisa_ulm3ln1_bypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm3ln1_clksel", "VISA ULM3LN1 CLK Select"},
#else
{8, 15, 0x0000000000000000, "RW", "dfxvisa_ulm3ln1_clksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm3ln1_datasel", "VISA ULM3LN1 (DATA) Select"},
#else
{0, 7, 0x0000000000000000, "RW", "dfxvisa_ulm3ln1_datasel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo454[] = {{"DFXVISA_ULM3LN1", "", 0x0000072C, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields455[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{12, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{12, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "bl_dfxmrgtxovren", "DQ Bytelane Tx FIFO Margin Mode config override enable for Tx data path and Latch enables via  DFXMRGTXFIFO[24:0]    1'b1  - Enable TxFIFO DFx overrides on Latch enables and TxData  1'b0 - Functional Mode of operation"},
#else
{11, 11, 0x0000000000000000, "RW", "bl_dfxmrgtxovren", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "bl_dfxmrgtxwren", "DQ Bytelane TxFIFO Margin Mode Latch enable override value used to make TxFIFO latches transparent allowing the loading of all TxFIFO Latches with data programmed in DFXMRGTXFIFO[23:0], if dfxmrgtxovren is asserted(1'b1)  1'b1 - All DQ/DM/DQS Tx FIFO Latches Transparent  0'b0 - All DQ/DM/DQS TxFIFO Latches CLosed"},
#else
{10, 10, 0x0000000000000000, "RW", "bl_dfxmrgtxwren", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "bl_dfxmrgtxdqsrise", "DQ Bytelane Tx FIFO Margin Mode DQS/B Rise Tx SubFIFO data load value. The value loaded will apply to all DQ Bytelane DQS/B Rise SubFIFOs. Recommended setting for HVM = 2'b00"},
#else
{9, 9, 0x0000000000000000, "RW", "bl_dfxmrgtxdqsrise", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "bl_dfxmrgtxdqsfall", "DQ Bytelane Tx FIFO Margin Mode DQS/B Fall Tx SubFIFO data load value. The value loaded will apply to all DQ Bytelane DQS/B Fall SubFIFOs. Recommended setting for HVM = 2'b00"},
#else
{8, 8, 0x0000000000000000, "RW", "bl_dfxmrgtxdqsfall", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "bl_dfxmrgtxdrise_ph0", "DQ Bytelane Tx FIFO Margin Mode DQ Phase0 Rise Tx SubFIFO load value. The value loaded will apply to all DQ BL Phase 0 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{7, 7, 0x0000000000000000, "RW", "bl_dfxmrgtxdrise_ph0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "bl_dfxmrgtxdrise_ph1", "DQ Bytelane Tx FIFO Margin Mode DQ Phase1 Rise Tx SubFIFO load value. The value loaded will apply to all DQ BL Phase 1 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{6, 6, 0x0000000000000000, "RW", "bl_dfxmrgtxdrise_ph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "bl_dfxmrgtxdrise_ph2", "DQ Bytelane Tx FIFO Margin Mode DQ Phase0 Rise Tx SubFIFO load value. The value loaded will apply to all DQ BL Phase 2 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{5, 5, 0x0000000000000000, "RW", "bl_dfxmrgtxdrise_ph2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "bl_dfxmrgtxdrise_ph3", "DQ Bytelane Tx FIFO Margin Mode DQ Phase1 Rise Tx SubFIFO load value. The value loaded will apply to all DQ BL Phase 3 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{4, 4, 0x0000000000000000, "RW", "bl_dfxmrgtxdrise_ph3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "bl_dfxmrgtxdfall_ph0", "DQ Bytelane Tx FIFO Margin Mode DQ Phase0 Fall Tx SubFIFO load value. The value loaded will apply to all DQ BL Phase 0 Fall SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{3, 3, 0x0000000000000000, "RW", "bl_dfxmrgtxdfall_ph0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "bl_dfxmrgtxdfall_ph1", "DQ Bytelane Tx FIFO Margin Mode DQ Phase1 Fall Tx SubFIFO load value. The value loaded will apply to all DQ BL Phase 1 Fall SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{2, 2, 0x0000000000000000, "RW", "bl_dfxmrgtxdfall_ph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "bl_dfxmrgtxdfall_ph2", "DQ Bytelane Tx FIFO Margin Mode DQ Phase2 Fall Tx SubFIFO load value. The value loaded will apply to all DQ BL Phase 2 Fall SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{1, 1, 0x0000000000000000, "RW", "bl_dfxmrgtxdfall_ph2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "bl_dfxmrgtxdfall_ph3", "DQ Bytelane Tx FIFO Margin Mode DQ Phase3 Fall Tx SubFIFO load value. The value loaded will apply to all DQ BL Phase 3 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{0, 0, 0x0000000000000000, "RW", "bl_dfxmrgtxdfall_ph3", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo455[] = {{"DFXMRG_BL", "", 0x00000730, 13, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields456[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RW", "cc_dfxmrgtxovren", "DQCCC Bytelane Tx FIFO Margin Mode config override enable for Tx data path and Latch enables via  DFXMRGTXFIFO[24:0]    1'b1  - Enable TxFIFO DFx overrides on Latch enables and TxData  1'b0 - Functional Mode of operation"},
#else
{15, 15, 0x0000000000000000, "RW", "cc_dfxmrgtxovren", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 14, 0x0000000000000000, "RW", "cc_dfxmrgtxwren", "DQCCC Bytelane TxFIFO Margin Mode Latch enable override value used to make TxFIFO latches transparent allowing the loading of all TxFIFO Latches with data programmed in DFXMRGTXFIFO[23:0], if dfxmrgtxovren is asserted(1'b1)  1'b1 - All DQCCC/DM/DQCCCS Tx FIFO Latches Transparent  0'b0 - All DQCCC/DM/DQCCCS TxFIFO Latches CLosed"},
#else
{14, 14, 0x0000000000000000, "RW", "cc_dfxmrgtxwren", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 13, 0x0000000000000000, "RW", "cc_dfxmrgtxdqsrise", "DQCCC Bytelane Tx FIFO Margin Mode DQCCCS/B Rise Tx SubFIFO data load value. The value loaded will apply to all DQCCC Bytelane DQCCCS/B Rise SubFIFOs. Recommended setting for HVM = 2'b00"},
#else
{13, 13, 0x0000000000000000, "RW", "cc_dfxmrgtxdqsrise", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000000, "RW", "cc_dfxmrgtxdqsfall", "DQCCC Bytelane Tx FIFO Margin Mode DQCCCS/B Fall Tx SubFIFO data load value. The value loaded will apply to all DQCCC Bytelane DQCCCS/B Fall SubFIFOs. Recommended setting for HVM = 2'b00"},
#else
{12, 12, 0x0000000000000000, "RW", "cc_dfxmrgtxdqsfall", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "cc_dfxmrgtxdrise_ph0", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 Rise Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 0 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{11, 11, 0x0000000000000000, "RW", "cc_dfxmrgtxdrise_ph0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "cc_dfxmrgtxdrise_ph1", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 Rise Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 1 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{10, 10, 0x0000000000000000, "RW", "cc_dfxmrgtxdrise_ph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "cc_dfxmrgtxdrise_ph2", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 Rise Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 2 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{9, 9, 0x0000000000000000, "RW", "cc_dfxmrgtxdrise_ph2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "cc_dfxmrgtxdrise_ph3", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 Rise Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 3 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{8, 8, 0x0000000000000000, "RW", "cc_dfxmrgtxdrise_ph3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "cc_dfxmrgtxdfall_ph0", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 Fall Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 0 Fall SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{7, 7, 0x0000000000000000, "RW", "cc_dfxmrgtxdfall_ph0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "cc_dfxmrgtxdfall_ph1", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 Fall Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 1 Fall SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{6, 6, 0x0000000000000000, "RW", "cc_dfxmrgtxdfall_ph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "cc_dfxmrgtxdfall_ph2", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase2 Fall Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 2 Fall SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{5, 5, 0x0000000000000000, "RW", "cc_dfxmrgtxdfall_ph2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "cc_dfxmrgtxdfall_ph3", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase3 Fall Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 3 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{4, 4, 0x0000000000000000, "RW", "cc_dfxmrgtxdfall_ph3", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "cc_dfxmrgtxdsdr_ph0", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase0 SDR Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 0 SDR SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{3, 3, 0x0000000000000000, "RW", "cc_dfxmrgtxdsdr_ph0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "cc_dfxmrgtxdsdr_ph1", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase1 SDR Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 1 SDR SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{2, 2, 0x0000000000000000, "RW", "cc_dfxmrgtxdsdr_ph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "cc_dfxmrgtxdsdr_ph2", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase2 SDR Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 2 SDR SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b11"},
#else
{1, 1, 0x0000000000000000, "RW", "cc_dfxmrgtxdsdr_ph2", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "cc_dfxmrgtxdsdr_ph3", "DQCCC Bytelane Tx FIFO Margin Mode DQCCC Phase3 SDR Tx SubFIFO load value. The value loaded will apply to all DQCCC BL Phase 3 Rise SubFIFOs  There isnt a valid or invalid value for this field, recommended setting for HVM = 2'b00"},
#else
{0, 0, 0x0000000000000000, "RW", "cc_dfxmrgtxdsdr_ph3", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo456[] = {{"DFXMRG_CC", "", 0x00000734, 17, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields457[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{8, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{8, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "bl_dfxmrgrx_cmpval", "DFx Margin Mode DQ Bytelane Rx Compare value; Used to compare Actual RxFIFO value vs Expected Rx FIFO value(TxFIFO Unloaded)"},
#else
{0, 7, 0x0000000000000000, "RW", "bl_dfxmrgrx_cmpval", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo457[] = {{"DFXMRG_BLRX", "", 0x00000738, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields458[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{25, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{25, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 24, 0x0000000000000000, "RW", "cc_dfxmrgrx_sdrsel", "DFx Margin Mode SDR vs DDR Rx Compare Values"},
#else
{16, 24, 0x0000000000000000, "RW", "cc_dfxmrgrx_sdrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "cc_dfxmrgrx_ddrcmpval", "DFx Margin Mode CCC Bytelane Rx Compare value for DDR pins; Used to compare Actual RxFIFO value vs Expected Rx FIFO value(TxFIFO Unloaded)"},
#else
{8, 15, 0x0000000000000000, "RW", "cc_dfxmrgrx_ddrcmpval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "cc_dfxmrgrx_sdrcmpval", "DFx Margin Mode CCC Bytelane Rx Compare value for SDR pins; Used to compare Actual RxFIFO value vs Expected Rx FIFO value(TxFIFO Unloaded)"},
#else
{0, 7, 0x0000000000000000, "RW", "cc_dfxmrgrx_sdrcmpval", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo458[] = {{"DFXMRG_CCRX", "", 0x0000073C, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields459[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", "This is the DQS configuration for first phase  - Bytelane 0[br](2'b01-dqs_hi_lo,2'b00-dqs_lo_lo,2'b11-dqs_hi_hi)."},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo459[] = {{"U32_WRDQCTL", "", 0x0000001C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields460[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", "Phase 1 - DQS Drive enable"},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo460[] = {{"U32_WRDQSCTL_CC", "", 0x00000020, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields461[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", "Phase 1 - DQS Drive enable"},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo461[] = {{"U32_WRDQSCTL_BL", "", 0x00000024, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields462[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", ""},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo462[] = {{"U32_WKPUPPDNCTL", "", 0x0000007C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields463[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", ""},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo463[] = {{"U32_RXODTCTL_BL13", "", 0x0000003C, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields464[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", ""},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo464[] = {{"U32_RXODTCTL_DQ", "", 0x00000040, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields465[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", "This is the DQS configuration for first phase [br](2'b01-dqs_hi_lo,2'b00-dqs_lo_lo,2'b11-dqs_hi_hi)."},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo465[] = {{"U32_WRDQCTL", "", 0x00000024, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields466[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", "Phase 1 - DQS Drive enable"},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo466[] = {{"U32_WRDQSCTL", "", 0x00000028, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields467[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{0, 31, 0x0000000000000000, "RW", "data", ""},
#else
{0, 31, 0x0000000000000000, "RW", "data", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo467[] = {{"U32_WKPUPPDNCTL", "", 0x00000068, 1, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields468[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "memtech", "Memory Technology\r\n"
"Bit 3:0: DRAM Technology\r\n"
"0000: LPDDR3\r\n"
"0001: LPDDR4\r\n"
"0010: DDR3/L/U\r\n"
"0011: DDR4/L\r\n"
"0100: WIO2\r\n"
"0101: FMI\r\n"
"0110: DDR-T\r\n"
"0111: HBM"},
#else
{28, 31, 0x0000000000000000, "RW", "memtech", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "memfreq", "Indicates the Memory Frequency currently selected\r\n"
"within the PHY. This signal is valid after initialization\r\n"
"complete is set.\r\n"
"Bit 3:0 DRAM Frequency\r\n"
"0000: 800\r\n"
"0001: 1066\r\n"
"0010: 1333\r\n"
"0011: 1600\r\n"
"0100: 1866\r\n"
"0101: 2133\r\n"
"0110: 2400\r\n"
"1001: Reserved For Future Use (RFU)\r\n"
"101X: Reserved For Future Use (RFU)\r\n"
"11XX: Reserved For Future Use (RFU)"},
#else
{24, 27, 0x0000000000000000, "RW", "memfreq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "phyupd_dly", "Delay between the phy update request to ack \r\n"
"in terms of SPID clocks."},
#else
{16, 23, 0x0000000000000000, "RW", "phyupd_dly", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RW", "stretchmode", "This is the stretch mode signal.\r\n"
"00- normal read\r\n"
"01- x4 stretch mode \r\n"
"10- x8 stretch mode\r\n"
"11- x16 stretch mode"},
#else
{13, 14, 0x0000000000000000, "RW", "stretchmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{12, 12, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "slowpath", "Delay the wrcmd 1 spidclk before write into the fifo.\r\n"
"1: 1 spidclk delay\r\n"
"0: no delay\r\n"
"With clock gating enable, the write pointer is only valid @ the next spid clock edge of write command. -> delay 1 spidclk so we can capture it into the fifo.\r\n"
"Set to 1 if do clock gate. Else set it to 0."},
#else
{11, 11, 0x0000000000000000, "RW", "slowpath", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "txfifo_csn_ffloppreseten", "This is the txFIFO final flop preset enable\r\n"
"1 - iobufact_b assert will preset the final flop, otherwise resets the final flop"},
#else
{10, 10, 0x0000000000000000, "RW", "txfifo_csn_ffloppreseten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "rdmcpsel", "Programmable MCP for Tx FIFO read pointer path."},
#else
{9, 9, 0x0000000000000000, "RW", "rdmcpsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 8, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "bl1632xbl48b", "This is the burstlength configuration register\r\n"
"1:BL16 and BL32\r\n"
"0:BL4 and BL8"},
#else
{6, 6, 0x0000000000000000, "RW", "bl1632xbl48b", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "spidclksel", "SPID clk sel \r\n"
"00: 0.5xmode\r\n"
"01: 0.25x mode\r\n"
"10: 0.1x mode\r\n"
"11: NA"},
#else
{4, 5, 0x0000000000000000, "RW", "spidclksel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "membus_loopback", "Membus Loopback Mode (For testing membus interface in a single family test environment.)  0=Not in Loopback 1=Loopback Mode"},
#else
{3, 3, 0x0000000000000000, "RW", "membus_loopback", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "lpddr34mode", "Single data rate v/s Double Data rate \r\n"
"0: Double data rate (LP3)\r\n"
"1: Single data rate (LP4)"},
#else
{2, 2, 0x0000000000000000, "RW", "lpddr34mode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "ddr3lmode", "Indicates DDR3L mode vs LPDDR* mode (1 - DDR3L mode 0 - Disabled)"},
#else
{1, 1, 0x0000000000000000, "RW", "ddr3lmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{0, 0, 0x0000000000000000, "RO", "reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo468[] = {{"DIGCTL", "", 0x00000000, 16, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields469[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RW", "siggrp03_invph0to180", "DBMUX Phase 180 Clock Selection\r\n"
"0: Phase180 clock from DLL Phase Interpolator (LP* Modes / DDR4 = 2400)\r\n"
"1: Phase180 clock from Phase0 clock inversion (DDR3L/(DDR4 < 2400) Mode)"},
#else
{31, 31, 0x0000000000000000, "RW", "siggrp03_invph0to180", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "siggrp02_invph0to180", "DBMUX Phase 180 Clock Selection\r\n"
"0: Phase180 clock from DLL Phase Interpolator (LP* Modes / DDR4 = 2400)\r\n"
"1: Phase180 clock from Phase0 clock inversion (DDR3L/(DDR4 < 2400) Mode)"},
#else
{30, 30, 0x0000000000000000, "RW", "siggrp02_invph0to180", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RW", "siggrp01_invph0to180", "DBMUX Phase 180 Clock Selection\r\n"
"0: Phase180 clock from DLL Phase Interpolator (LP* Modes / DDR4 = 2400)\r\n"
"1: Phase180 clock from Phase0 clock inversion (DDR3L/(DDR4 < 2400) Mode)"},
#else
{29, 29, 0x0000000000000000, "RW", "siggrp01_invph0to180", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "siggrp00_invph0to180", "DBMUX Phase 180 Clock Selection\r\n"
"0: Phase180 clock from DLL Phase Interpolator (LP* Modes)\r\n"
"1: Phase180 clock from Phase0 clock inversion (DDR3L/DDR4 Mode)"},
#else
{28, 28, 0x0000000000000000, "RW", "siggrp00_invph0to180", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "compclkrdptrinit", "DLL comp init configuration."},
#else
{24, 27, 0x0000000000000000, "RW", "compclkrdptrinit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RW", "compclkrdptroffset", "DLL comp read pointer offset."},
#else
{21, 23, 0x0000000000000000, "RW", "compclkrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 20, 0x0000000000000000, "RW", "ref1xrdptrinit", "This is the ref1x read pointer init configuration."},
#else
{17, 20, 0x0000000000000000, "RW", "ref1xrdptrinit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RO", "dqxccb", "Reserved bits"},
#else
{16, 16, 0x0000000000000000, "RO", "dqxccb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "ref1xrdptroffset", "This is the ref1xread pointer offset configuration."},
#else
{13, 15, 0x0000000000000000, "RW", "ref1xrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "ref2xrdptrinit", "This is the ref2x read pointer init configuration."},
#else
{8, 12, 0x0000000000000000, "RW", "ref2xrdptrinit", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "cc_doublefifooffset", "This is the double FIFO offset configuration(in terms of 2xclock)."},
#else
{4, 7, 0x0000000000000000, "RW", "cc_doublefifooffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RO", "bl_doublefifooffset", "Reserved bits"},
#else
{0, 3, 0x0000000000000000, "RO", "bl_doublefifooffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo469[] = {{"FIFOPTRCTL", "", 0x00000004, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields470[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "ten_pad_sel", "Selects between CH0/CH1 CKE Pads for Test Mode Enable - One hot encoding {0001 - CH0 CKE[0], 0010 - CH0 CKE[1], 0100 - CH1 CKE[0], 1000 - CH1 CKE[1]}"},
#else
{28, 31, 0x0000000000000000, "RW", "ten_pad_sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{26, 27, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "ca_training", "CA training mode"},
#else
{25, 25, 0x0000000000000000, "RW", "ca_training", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 24, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 24, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "ckemasken", "CH0 CKE Mask Enable"},
#else
{22, 22, 0x0000000000000000, "RW", "ckemasken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "odttxdrven", "ODT buffer enable\r\n"
"1: Enable buffer\r\n"
"0: Tristate buffer"},
#else
{21, 21, 0x0000000000000000, "RW", "odttxdrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "clktxdrven", "CK buffer enable\r\n"
"1: Enable buffer\r\n"
"0: Tristate buffer"},
#else
{20, 20, 0x0000000000000000, "RW", "clktxdrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "cketxdrven", "CKE buffer enable\r\n"
"1: Enable buffer\r\n"
"0: Tristate buffer"},
#else
{19, 19, 0x0000000000000000, "RW", "cketxdrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "cstxdrven", "CS buffer enable\r\n"
"1: Enable buffer\r\n"
"0: Tristate buffer"},
#else
{18, 18, 0x0000000000000000, "RW", "cstxdrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 17, 0x0000000000000000, "RW", "cmdtxdrven", "CMD buffer enable\r\n"
"1: Enable buffer\r\n"
"0: Tristate buffer"},
#else
{7, 17, 0x0000000000000000, "RW", "cmdtxdrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 6, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "ten_en", "TestMode Enable Pin"},
#else
{5, 5, 0x0000000000000000, "RW", "ten_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 4, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{3, 4, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "clknegxposb", "Start phase of CK"},
#else
{2, 2, 0x0000000000000000, "RW", "clknegxposb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "cmdtristateovrval", "Command tristate override value"},
#else
{1, 1, 0x0000000000000000, "RW", "cmdtristateovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "cmdtristateovrsel", "Command tristate override select"},
#else
{0, 0, 0x0000000000000000, "RW", "cmdtristateovrsel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo470[] = {{"CCCCTL", "", 0x00000008, 16, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields471[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{3, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{3, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "rstbtx_enbrst", "Tri-state control for LP4 reset buffer"},
#else
{2, 2, 0x0000000000000000, "RW", "rstbtx_enbrst", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "rstbtx_reset", "Reset for the LP4 reset buffer"},
#else
{1, 1, 0x0000000000000000, "RW", "rstbtx_reset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "rstbtx_set", "Set for the LP4 reset buffer"},
#else
{0, 0, 0x0000000000000000, "RW", "rstbtx_set", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo471[] = {{"LP4RSTCTL", "", 0x0000000C, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields472[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{2, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{2, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "rxfiforst_b", "Rxfifo reset (active low)\r\n"
"1: deasserted\r\n"
"0 : asserted"},
#else
{1, 1, 0x0000000000000000, "RW", "rxfiforst_b", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "spidrst_b", "Reset for functional logic in upartition (except compensation and power management logic)  \r\n"
"0: Reset assertion  \r\n"
"1: Reset de-assertion"},
#else
{0, 0, 0x0000000000000000, "RW", "spidrst_b", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo472[] = {{"DIGRSTCTL", "", 0x00000010, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields473[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{1, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "wrptren", "Config-controlled Write pointer enable. 0=config control disabled, 1=config control enabled. This bit qualifies the pm_wrptren, which eventually goes to DQPTRGEN Fub."},
#else
{0, 0, 0x0000000000000000, "RW", "wrptren", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo473[] = {{"FIFOPTREN", "", 0x00000014, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields474[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{3, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{3, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "lvl_dq_iobufactafe", "IO buffer activate - DQ Analog\r\n"
"Tristates DQ and DQS IO buffers \r\n"
"Disable Rx sections of IO buffers \r\n"
"0 : reset \r\n"
"1 : out of reset"},
#else
{2, 2, 0x0000000000000000, "RW", "lvl_dq_iobufactafe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "lvl_cc1_iobufactafe", "IO buffer activate - CCC Analog\r\n"
"Tristates DQ and DQS IO buffers \r\n"
"Disable Rx sections of IO buffers \r\n"
"0 : reset \r\n"
"1 : out of reset"},
#else
{1, 1, 0x0000000000000000, "RW", "lvl_cc1_iobufactafe", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "lvl_cc0_iobufactafe", "IO buffer activate - DQ Analog\r\n"
"Tristates DQ and DQS IO buffers \r\n"
"Disable Rx sections of IO buffers \r\n"
"0 : reset \r\n"
"1 : out of reset"},
#else
{0, 0, 0x0000000000000000, "RW", "lvl_cc0_iobufactafe", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo474[] = {{"IOBUFACT_AFE", "", 0x00000018, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields475[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{3, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{3, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "dq_iobufactdig", "IO buffer activate - CCC Digital\r\n"
"Bytelane 1 SW reset for final TX flops in all upartitions."},
#else
{2, 2, 0x0000000000000000, "RW", "dq_iobufactdig", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "cc1_iobufactdig", "IO buffer activate - CCC Digital\r\n"
"Bytelane 1 SW reset for final TX flops in all upartitions."},
#else
{1, 1, 0x0000000000000000, "RW", "cc1_iobufactdig", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "cc0_iobufactdig", "IO buffer activate - DQ Digital\r\n"
"Bytelane 1 SW reset for final TX flops in all upartitions."},
#else
{0, 0, 0x0000000000000000, "RW", "cc0_iobufactdig", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo475[] = {{"IOBUFACT_DIG", "", 0x0000001C, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields476[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{1, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "ch0_spid_init_complete", "SPID init complete"},
#else
{0, 0, 0x0000000000000000, "RW", "ch0_spid_init_complete", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo476[] = {{"CH0_SPIDIC", "", 0x00000020, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields477[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{9, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{9, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "early_dqen", "Early DQ Enable Register"},
#else
{8, 8, 0x0000000000000000, "RW", "early_dqen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RW", "dqdrvenbph1", "Data mask drive enable"},
#else
{6, 7, 0x0000000000000000, "RW", "dqdrvenbph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "dqdrvenbpream1", "This is the two write preambles enable"},
#else
{4, 5, 0x0000000000000000, "RW", "dqdrvenbpream1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RW", "dqdrvenblastph", "Last phase - DQ Drive Enable"},
#else
{2, 3, 0x0000000000000000, "RW", "dqdrvenblastph", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "dqdrvenbpream0", "This is the DQS configuration for first phase \r\n"
"(2'b01-dqs_hi_lo,2'b00-dqs_lo_lo,2'b11-dqs_hi_hi)."},
#else
{0, 1, 0x0000000000000000, "RW", "dqdrvenbpream0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo477[] = {{"WRDQCTL", "", 0x00000024, 6, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields478[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RW", "dqsdrvenbph1", "Phase 1 - DQS Drive enable"},
#else
{30, 31, 0x0000000000000000, "RW", "dqsdrvenbph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RW", "dqsdrvenbpream1", "Preamble 1 - DQS drive enable"},
#else
{28, 29, 0x0000000000000000, "RW", "dqsdrvenbpream1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RW", "dqsdrvenblastph", "Last phase - DQS Drive enable"},
#else
{26, 27, 0x0000000000000000, "RW", "dqsdrvenblastph", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "dqsdrvenbpream0", "Preamble 0 - DQS Drive enable"},
#else
{24, 25, 0x0000000000000000, "RW", "dqsdrvenbpream0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "dmdrven", "Data mask drive enable"},
#else
{20, 20, 0x0000000000000000, "RW", "dmdrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "wrpream0en", "This is the two write preambles enable"},
#else
{19, 19, 0x0000000000000000, "RW", "wrpream0en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{18, 18, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000003, "RW", "dqsdrvenbidle", "DQS Drive Enable - Idle"},
#else
{16, 17, 0x0000000000000003, "RW", "dqsdrvenbidle", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "dqsdataph1", "This is the DQS configuration for first phase \r\n"
"(2'b01-dqs_hi_lo,2'b00-dqs_lo_lo,2'b11-dqs_hi_hi)."},
#else
{14, 15, 0x0000000000000000, "RW", "dqsdataph1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW", "dqsdatapream1", "This is the DQS configuration during second preamble\r\n"
"(2'b01-dqs_hi_lo,2'b00-dqs_lo_lo,2'b11-dqs_hi_hi)."},
#else
{12, 13, 0x0000000000000000, "RW", "dqsdatapream1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW", "dqsdatalastph", "This is the DQS configuration for last phase \r\n"
"(2'b01-dqs_hi_lo,2'b00-dqs_lo_lo,2'b11-dqs_hi_hi)."},
#else
{10, 11, 0x0000000000000000, "RW", "dqsdatalastph", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "dqsdatapream0", "This is the DQS configuration during first preamble\r\n"
"(2'b01-dqs_hi_lo,2'b00-dqs_lo_lo,2'b11-dqs_hi_hi)."},
#else
{8, 9, 0x0000000000000000, "RW", "dqsdatapream0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "wrcmd2dqsstart", "Write command to DQS start delay"},
#else
{0, 5, 0x0000000000000000, "RW", "wrcmd2dqsstart", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo478[] = {{"WRDQSCTL", "", 0x00000028, 15, 0x00000000FFFFFFFF, 0x0000000000030000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields479[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "rdcmd2rdvld_plus1sel", "Read command 2 read valid plus 1 sel."},
#else
{12, 14, 0x0000000000000000, "RW", "rdcmd2rdvld_plus1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "earlyrdvld", "This is the early read valid configuration register \r\n"
"0: no early read valid geneartion\r\n"
"1/2/3/4: 1/2/3/4/spidclk early valid\r\n"
" >4: Illegal"},
#else
{8, 10, 0x0000000000000000, "RW", "earlyrdvld", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "rdcmd2rdvld", "This is the read command to read valid register.\r\n"
"This is in terms of spidclk."},
#else
{0, 5, 0x0000000000000000, "RW", "rdcmd2rdvld", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo479[] = {{"RDVLDCTL", "", 0x0000002C, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields480[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{14, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{14, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 13, 0x0000000000000000, "RW", "dqx_rk2rkswitch_dlyen", "Adds an extra 1x clock of delay between rdptr freeze and dq/dqs PI code change during write based rk2rk switch.\r\n"
"1: Add 1 extra ref1xclk of delay \r\n"
"0: No delay"},
#else
{13, 13, 0x0000000000000000, "RW", "dqx_rk2rkswitch_dlyen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000000, "RW", "rcv_rk2rkswitch_dlyen", "Adds an extra 1x clock of delay between rdptr freeze and rcven PI code change during read based rk2rk switch.\r\n"
"1: Add 1 extra ref1xclk of delay \r\n"
"0: No delay"},
#else
{12, 12, 0x0000000000000000, "RW", "rcv_rk2rkswitch_dlyen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_iodrven", "pushing out the update of rank information  for IO driver enable control 1 more 2xclk if set to 1."},
#else
{10, 10, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_iodrven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txrden", "pushing out the update of rank information for Tx rden control 1 more 2xclk if set to 1."},
#else
{9, 9, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txrden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txrcven", "pushing out the update of rank information for Tx RCVEN control 1 more 2xclk if set to 1."},
#else
{8, 8, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txrcven", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RW", "rk2rken_txdqs_pi", "Rank2Rank Picode switching enabled for TxDLL DQS picodes (1- rk2rk picode switching enabled; 0 - disabled)"},
#else
{7, 7, 0x0000000000000000, "RW", "rk2rken_txdqs_pi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "rk2rken_txdq_pi", "Rank2Rank Picode switching enabled for TxDLL DQ picodes (1- rk2rk picode switching enabled; 0 - disabled)"},
#else
{6, 6, 0x0000000000000000, "RW", "rk2rken_txdq_pi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 5, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{2, 5, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "rk2rken_rxdq_pi", "Rank2Rank Picode switching enabled for RxDLL DQS picodes (1- rk2rk picode switching enabled; 0 - disabled)"},
#else
{1, 1, 0x0000000000000000, "RW", "rk2rken_rxdq_pi", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "rk2rken_txrcven", "Rank2Rank Picode switching enabled for TxDLL rcven picodes (1- rk2rk picode switching enabled; 0 - disabled)"},
#else
{0, 0, 0x0000000000000000, "RW", "rk2rken_txrcven", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo480[] = {{"RK2RKCTL1", "", 0x00000030, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields481[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "rk2rkdrvenbcode_3rd", "This is the pattern for third 1x clock of rk2rk_rden\r\n"
"(bit[0] - 1xhigh phase value, bit[1] - 1xlow phase value).\r\n"
"Applicable for both DQ and DQS drvenb."},
#else
{28, 31, 0x0000000000000000, "RW", "rk2rkdrvenbcode_3rd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "rk2rkrdencode_3rd", "This is the pattern for third 1x clock of rk2rk_rden\r\n"
"(bit[0] - 1xhigh phase value, bit[1] - 1xlow phase value)."},
#else
{24, 27, 0x0000000000000000, "RW", "rk2rkrdencode_3rd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_rxdq", "pushing out the update of rank information 1 more 2xclk if set to 1."},
#else
{23, 23, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_rxdq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txdqs", "pushing out the update of rank information 1 more 2xclk if set to 1."},
#else
{22, 22, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txdqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txdq", "pushing out the update of rank information 1 more 2xclk if set to 1."},
#else
{21, 21, 0x0000000000000000, "RW", "rk2rkmio2xclkpushout_txdq", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 20, 0x0000000000000000, "RW", "wrcmd2rkchglatency", "This is the pattern for second 1x clock of rk2rk_iodrvenb\r\n"
"(bit[0] - 1xhigh phase value, bit[1] - 1xlow phase value)."},
#else
{15, 20, 0x0000000000000000, "RW", "wrcmd2rkchglatency", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 14, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{14, 14, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 13, 0x0000000000000000, "RW", "rdcmd2rkchglatency", "This is the pattern for first 1x clock of rk2rk_iodrvenb\r\n"
"(bit[0] - 1xhigh phase value, bit[1] - 1xlow phase value)."},
#else
{8, 13, 0x0000000000000000, "RW", "rdcmd2rkchglatency", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RW", "rk2rkdrvenbcode_2nd", "This is the pattern for second 1x clock of rk2rk_rden\r\n"
"(bit[0] - 1xhigh phase value, bit[1] - 1xlow phase value).\r\n"
"Applicable for both DQ and DQS drvenb."},
#else
{6, 7, 0x0000000000000000, "RW", "rk2rkdrvenbcode_2nd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 5, 0x0000000000000000, "RW", "rk2rkdrvenbcode_1st", "This is the pattern for first 1x clock of rk2rk_rden\r\n"
"(bit[0] - 1xhigh phase value, bit[1] - 1xlow phase value).\r\n"
"Applicable for both DQ and DQS drvenb."},
#else
{4, 5, 0x0000000000000000, "RW", "rk2rkdrvenbcode_1st", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 3, 0x0000000000000000, "RW", "rk2rkrdencode_2nd", "This is the pattern for second 1x clock of rk2rk_rden\r\n"
"(bit[0] - 1xhigh phase value, bit[1] - 1xlow phase value)."},
#else
{2, 3, 0x0000000000000000, "RW", "rk2rkrdencode_2nd", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 1, 0x0000000000000000, "RW", "rk2rkrdencode_1st", "This is the pattern for first 1x clock of rk2rk_rden\r\n"
"(bit[0] - 1xhigh phase value, bit[1] - 1xlow phase value)."},
#else
{0, 1, 0x0000000000000000, "RW", "rk2rkrdencode_1st", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo481[] = {{"RK2RKCTL0", "", 0x00000034, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields482[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RW", "rxodtsegovrval", "Receive ODT segment enable override value."},
#else
{29, 31, 0x0000000000000000, "RW", "rxodtsegovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RW", "rxodtsegovrsel", "Receive ODT segment enable override select.\r\n"
"0= Dynamic  control\r\n"
"1= Static  control"},
#else
{28, 28, 0x0000000000000000, "RW", "rxodtsegovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 27, 0x0000000000000000, "RW", "odtsegenrdptroffset", "Receive ODT segment enable read pointer offset."},
#else
{23, 27, 0x0000000000000000, "RW", "odtsegenrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{22, 22, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "rxodtsegtwohot", "This is the RXODTSEGEN one hot enable\r\n"
"0- rxodtsegen: 001->010->100\r\n"
"1-rxodtsegen: 011->110->101"},
#else
{21, 21, 0x0000000000000000, "RW", "rxodtsegtwohot", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 20, 0x0000000000000000, "RW", "rxodtseglenbl4", "This is the receive ODT segment enable length configuration register.\r\n"
"It's in number of 1x clocks."},
#else
{15, 20, 0x0000000000000000, "RW", "rxodtseglenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 14, 0x0000000000000000, "RW", "rxodtsegpst1", "This is the receive ODT segment enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{13, 14, 0x0000000000000000, "RW", "rxodtsegpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 12, 0x0000000000000000, "RW", "rxodtsegpre1", "This is the receive ODT segment enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{11, 12, 0x0000000000000000, "RW", "rxodtsegpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 10, 0x0000000000000000, "RW", "rxodtsegpst0", "This is the receive ODT segment enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{9, 10, 0x0000000000000000, "RW", "rxodtsegpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 8, 0x0000000000000000, "RW", "rxodtsegpre0", "This is the receive ODT segment enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{7, 8, 0x0000000000000000, "RW", "rxodtsegpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 6, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "rdcmd2rxodtseg", "This is the receive ODT segment enable latency configuration register."},
#else
{0, 5, 0x0000000000000000, "RW", "rdcmd2rxodtseg", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo482[] = {{"RXODTSEGCTL", "", 0x00000038, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields483[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000000, "RW", "odtenrdptroffset", "This is receive ODT enable read pointer offset."},
#else
{27, 31, 0x0000000000000000, "RW", "odtenrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "dqsrxodtenovrval", "Rx DQS odt enable override value - DQ BL0 lane \r\n"
"0: De-assert receive enable \r\n"
"1: Assert receive enable"},
#else
{26, 26, 0x0000000000000000, "RW", "dqsrxodtenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "dqsrxodtenovrsel", "Rx DQS odt enable override select- DQ BL0 lane \r\n"
"0= Dynamic RCVEN control\r\n"
"1= Static RCVEN control"},
#else
{25, 25, 0x0000000000000000, "RW", "dqsrxodtenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "rxodtenovrval", "Receive ODT enable override value. \r\n"
"0: De-assert receive enable \r\n"
"1: Assert receive enable"},
#else
{24, 24, 0x0000000000000000, "RW", "rxodtenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "rxodtenovrsel", "Receive ODT enable override select.\r\n"
"0= Dynamic RCVEN control\r\n"
"1= Static RCVEN control"},
#else
{23, 23, 0x0000000000000000, "RW", "rxodtenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{22, 22, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 21, 0x0000000000000000, "RW", "rxodtenlenbl4", "This is the receive ODT enable length configuration register.\r\n"
"It's in number of 1x clocks."},
#else
{16, 21, 0x0000000000000000, "RW", "rxodtenlenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "rxodtenpst1", "This is the receive ODT enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{14, 15, 0x0000000000000000, "RW", "rxodtenpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW", "rxodtenpre1", "This is the receive ODT enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{12, 13, 0x0000000000000000, "RW", "rxodtenpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW", "rxodtenpst0", "This is the receive ODT enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{10, 11, 0x0000000000000000, "RW", "rxodtenpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "rxodtenpre0", "This is the receive ODT enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{8, 9, 0x0000000000000000, "RW", "rxodtenpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "rdcmd2rxodten", "This is the receive ODT enable latency configuration register."},
#else
{0, 5, 0x0000000000000000, "RW", "rdcmd2rxodten", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo483[] = {{"RXODTCTL", "", 0x0000003C, 13, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields484[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "ch0_drx_rcvsmpl", "AFE status register - RCVSMPL - CCC0"},
#else
{31, 31, 0x0000000000000000, "RO", "ch0_drx_rcvsmpl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RO", "ch1_drx_rcvsmpl", "AFE status register - RCVSMPL - CCC1"},
#else
{30, 30, 0x0000000000000000, "RO", "ch1_drx_rcvsmpl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{29, 29, 0x0000000000000000, "RO", "ecc_drx_rcvsmpl", "AFE status register - RCVSMPL - ECC"},
#else
{29, 29, 0x0000000000000000, "RO", "ecc_drx_rcvsmpl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 28, 0x0000000000000000, "RO", "drx_cmn_bonus", "AFE status register - Bonus"},
#else
{28, 28, 0x0000000000000000, "RO", "drx_cmn_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RW", "drx_rcvenflopbypass", "DQS counter flop override"},
#else
{27, 27, 0x0000000000000000, "RW", "drx_rcvenflopbypass", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "drx_dqscountrstb", "DQS counter reset"},
#else
{26, 26, 0x0000000000000000, "RW", "drx_dqscountrstb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "rcvenovrval", "Receive enable override value. \r\n"
"0: De-assert receive enable \r\n"
"1: Assert receive enable"},
#else
{25, 25, 0x0000000000000000, "RW", "rcvenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "rcvenovrsel", "Receive enable override select.\r\n"
"0= Dynamic RCVEN control\r\n"
"1= Static RCVEN control"},
#else
{24, 24, 0x0000000000000000, "RW", "rcvenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{22, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 21, 0x0000000000000000, "RW", "rcvenlenbl4", "This is the receive enable length(number of 1x clock) configuration register."},
#else
{16, 21, 0x0000000000000000, "RW", "rcvenlenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "rcvenpst1", "This is the receive enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{14, 15, 0x0000000000000000, "RW", "rcvenpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 13, 0x0000000000000000, "RW", "rcvenpre1", "This is the receive enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{12, 13, 0x0000000000000000, "RW", "rcvenpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 11, 0x0000000000000000, "RW", "rcvenpst0", "This is the receive enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{10, 11, 0x0000000000000000, "RW", "rcvenpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 9, 0x0000000000000000, "RW", "rcvenpre0", "This is the receive enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{8, 9, 0x0000000000000000, "RW", "rcvenpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "rdcmd2rcven", "This is the receive enable latency configuration register."},
#else
{0, 5, 0x0000000000000000, "RW", "rdcmd2rcven", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo484[] = {{"RCVENCTL", "", 0x00000040, 16, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields485[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000000, "RW", "diffampenrdptroffset", "Differential amplifier read pointer offset control."},
#else
{27, 31, 0x0000000000000000, "RW", "diffampenrdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "dqsdiffampenovrval", "Override value for DQS Diffamp enable - DQ Lane"},
#else
{26, 26, 0x0000000000000000, "RW", "dqsdiffampenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "dqsdiffampenovrsel", "Override select for DQS Diffamp enable - DQ Lane"},
#else
{25, 25, 0x0000000000000000, "RW", "dqsdiffampenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RW", "dqdmdiffampenovrval", "Override value for DQ/DM Diffamp enable - DQ Lane"},
#else
{24, 24, 0x0000000000000000, "RW", "dqdmdiffampenovrval", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "dqdmdiffampenovrsel", "Override select for DQ/DM Diffamp enable - DQ Lane"},
#else
{23, 23, 0x0000000000000000, "RW", "dqdmdiffampenovrsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 22, 0x0000000000000000, "RW", "diffampenpst1", "This is the diffamp enable configuration register - postamble 1 -  new(rise & fall). \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{21, 22, 0x0000000000000000, "RW", "diffampenpst1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 20, 0x0000000000000000, "RW", "diffampenpre1", "This is the diffamp enable configuration register - preamble 1(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{19, 20, 0x0000000000000000, "RW", "diffampenpre1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 18, 0x0000000000000000, "RW", "diffampenpst0", "This is the diffamp enable configuration register - postamble 0 - new(rise & fall)\r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{17, 18, 0x0000000000000000, "RW", "diffampenpst0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 16, 0x0000000000000000, "RW", "diffampenpre0", "This is the diffamp enable configuration register - preamble 0(rise & fall) \r\n"
"00 - Rise & Fall - Low & Low\r\n"
"01 - Rise & Fall - High & Low\r\n"
"10 - Rise & Fall - Low & High\r\n"
"11 - Rise & Fall - High & High"},
#else
{15, 16, 0x0000000000000000, "RW", "diffampenpre0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 14, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{14, 14, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 13, 0x0000000000000000, "RW", "diffampenlenbl4", "This is the diffamp enable length(number of 1x clock) configuration register."},
#else
{8, 13, 0x0000000000000000, "RW", "diffampenlenbl4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "rdcmd2diffampen", "This is the Diffamp enable latency register."},
#else
{0, 5, 0x0000000000000000, "RW", "rdcmd2diffampen", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo485[] = {{"DIFFAMPCTL", "", 0x00000044, 13, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields486[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{28, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RW", "cc0_wrlvl", "Write Levelization enable - CC0 Lane"},
#else
{27, 27, 0x0000000000000000, "RW", "cc0_wrlvl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "cc1_wrlvl", "Write Levelization enable - CC1 Lane"},
#else
{26, 26, 0x0000000000000000, "RW", "cc1_wrlvl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{25, 25, 0x0000000000000000, "RW", "bl_wrlvl", "Write Levelization enable - DQ Byte Lane"},
#else
{25, 25, 0x0000000000000000, "RW", "bl_wrlvl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 24, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 24, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RO", "wrlvl_sample_b1", "DQTRAINSTS - WRLVL sampling from all DQ bit lanes of Bytelane 1 - Not Used"},
#else
{16, 23, 0x0000000000000000, "RO", "wrlvl_sample_b1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RO", "wrlvl_sample_b0", "DQTRAINSTS - WRLVL sampling from all DQ bit lanes of Bytelane 0"},
#else
{8, 15, 0x0000000000000000, "RO", "wrlvl_sample_b0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RO", "wrlvl_and_sample_b1", "DQTRAINSTS - WRLVL Byte1 sample AND combination - Not Used"},
#else
{3, 3, 0x0000000000000000, "RO", "wrlvl_and_sample_b1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RO", "wrlvl_and_sample_b0", "DQTRAINSTS - WRLVL Byte0 sample AND combination"},
#else
{2, 2, 0x0000000000000000, "RO", "wrlvl_and_sample_b0", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO", "wrlvl_or_sample_b1", "DQTRAINSTS - WRLVL Byte1 sample OR combination"},
#else
{1, 1, 0x0000000000000000, "RO", "wrlvl_or_sample_b1", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO", "wrlvl_or_sample_b0", "DQTRAINSTS - WRLVL Byte0 sample OR combination"},
#else
{0, 0, 0x0000000000000000, "RO", "wrlvl_or_sample_b0", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo486[] = {{"WRLVL", "", 0x00000048, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields487[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{20, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{20, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "dynreadsiggrpen", "Enable Dynamic SIGGRP 2x clock control. 1= SIGGRPEN  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled SIGGRPEN"},
#else
{19, 19, 0x0000000000000000, "RW", "dynreadsiggrpen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "dynreadref2xclken", "Enable Dynamic REF2XCLK control. 1= ref2xclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled REF2XCLKEN"},
#else
{18, 18, 0x0000000000000000, "RW", "dynreadref2xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "dynreadref1xclken", "Enable Dynamic REF1XCLK read clock gating. 1= ref1xclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled REF1XCLKEN"},
#else
{17, 17, 0x0000000000000000, "RW", "dynreadref1xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dynreadspidclken", "Enable Dynamic SPIDCLK read clock gating. 1= spidclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled SPIDCLKEN"},
#else
{16, 16, 0x0000000000000000, "RW", "dynreadspidclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "read_stoprden", "This is the delay in terms of clocks the dven is disabled before clock gated."},
#else
{12, 14, 0x0000000000000000, "RW", "read_stoprden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "read_startrden", "This is the delay in terms of clocks the drven is enabled, once wrcmd/rdcmd is received."},
#else
{8, 10, 0x0000000000000000, "RW", "read_startrden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x000000000000003F, "RW", "readclkgate_maxcntr", "Clock Gating register : IDLE timer counter max value for clock gating on tx/rx . Counter timeout based on last WRCMD/RDCMD received. 6 bits are good enough since it increments in spidclk."},
#else
{0, 5, 0x000000000000003F, "RW", "readclkgate_maxcntr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo487[] = {{"CLKGATERDCTL", "", 0x0000004C, 11, 0x00000000FFFFFFFF, 0x000000000000003F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields488[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{20, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{20, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "dynwritesiggrpen", "Enable Dynamic SIGGRP 2x clock control. 1= SIGGRPEN  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled SIGGRPEN"},
#else
{19, 19, 0x0000000000000000, "RW", "dynwritesiggrpen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "dynwriteref2xclken", "Enable Dynamic REF2XCLK control. 1= ref2xclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled REF2XCLKEN"},
#else
{18, 18, 0x0000000000000000, "RW", "dynwriteref2xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "dynwriteref1xclken", "Enable Dynamic REF1XCLK Tx(write) clock gating. 1= ref1xclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled REF1XCLKEN"},
#else
{17, 17, 0x0000000000000000, "RW", "dynwriteref1xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dynwritespidclken", "Enable Dynamic SPIDCLK Tx(write) clock gating. 1= spidclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled SPIDCLKEN"},
#else
{16, 16, 0x0000000000000000, "RW", "dynwritespidclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "write_stopdrv", "This is the delay in terms of clocks the dven is disabled before clock gated."},
#else
{12, 14, 0x0000000000000000, "RW", "write_stopdrv", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "write_startdrv", "This is the delay in terms of clocks the drven is enabled, once wrcmd/rdcmd is received."},
#else
{8, 10, 0x0000000000000000, "RW", "write_startdrv", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{6, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x000000000000003F, "RW", "writeclkgate_maxcntr", "Clock Gating register : IDLE timer counter max value for clock gating on tx/rx . Counter timeout based on last WRCMD/RDCMD received. 6 bits are good enough since it increments in spidclk."},
#else
{0, 5, 0x000000000000003F, "RW", "writeclkgate_maxcntr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo488[] = {{"CLKGATEWRCTL", "", 0x00000050, 11, 0x00000000FFFFFFFF, 0x000000000000003F}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields489[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{21, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "ldoffdyncg_en", "Enable Dynamic LDO FF clock control. 1= LDOFF clock controlled by dynamic clock gating logic; 0 = Clock gating disabled"},
#else
{20, 20, 0x0000000000000000, "RW", "ldoffdyncg_en", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "dynsiggrpen", "Enable Dynamic SIGGRP 2x clock control. 1= SIGGRPEN  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled SIGGRPEN"},
#else
{19, 19, 0x0000000000000000, "RW", "dynsiggrpen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "dynref2xclken", "Enable Dynamic REF2XCLK control. 1= ref2xclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled REF2XCLKEN"},
#else
{18, 18, 0x0000000000000000, "RW", "dynref2xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RW", "dynref1xclken", "Enable Dynamic REF1XCLK global clock gating. 1= ref1xclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled REF1XCLKEN"},
#else
{17, 17, 0x0000000000000000, "RW", "dynref1xclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "dynspidclken", "Enable Dynamic SPIDCLK global clock gating. 1= spidclken  controlled by the dynamic clock gating logic (DYNDLLFSM), 0= Statically-controlled SPIDCLKEN"},
#else
{16, 16, 0x0000000000000000, "RW", "dynspidclken", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{9, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 8, 0x0000000000000007, "RW", "ldoffclkgate_maxcntr", "Clock Gating register : IDLE timer counter max value for clock gating on LDO FF . Counter timeout based on last datavalid recieved."},
#else
{6, 8, 0x0000000000000007, "RW", "ldoffclkgate_maxcntr", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x000000000000003F, "RW", "clkgate_maxcntr", "Clock Gating register : IDLE timer counter max value for clock gating on tx/rx . Counter timeout based on last WRCMD/RDCMD received. 6 bits are good enough since it increments in spidclk."},
#else
{0, 5, 0x000000000000003F, "RW", "clkgate_maxcntr", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo489[] = {{"CLKGATECTL", "", 0x00000054, 9, 0x00000000FFFFFFFF, 0x00000000000001FF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields490[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 16, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp03dbsel", "Deadband select for sig group 3 rank 0"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp03dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp03rdptroffset", "Read pointer offset for sig group 3 rank 0"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp03rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp03picode", "PI code for sig group 3 rank 0"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp03picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo490[] = {{"TXDLLSIGGRP3CTL", "", 0x00000058, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields491[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 16, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp02dbsel", "Deadband select for sig group 2 rank 0"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp02dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp02rdptroffset", "Read pointer offset for sig group 2 rank 0"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp02rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp02picode", "PI code for sig group 2 rank 0"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp02picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo491[] = {{"TXDLLSIGGRP2CTL", "", 0x0000005C, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields492[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 16, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp01dbsel", "Deadband select for sig group 1 rank 0"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp01dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp01rdptroffset", "Read pointer offset for sig group 1 rank 0"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp01rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp01picode", "PI code for sig group 1 rank 0"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp01picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo492[] = {{"TXDLLSIGGRP1CTL", "", 0x00000060, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields493[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{17, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 16, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp00dbsel", "Deadband select for sig group 0 rank 0"},
#else
{13, 15, 0x0000000000000000, "RW", "txdll_rk0siggrp00dbsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp00rdptroffset", "Read pointer offset for sig group 0 rank 0"},
#else
{8, 12, 0x0000000000000000, "RW", "txdll_rk0siggrp00rdptroffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp00picode", "PI code for sig group 0 rank 0"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_rk0siggrp00picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo493[] = {{"TXDLLSIGGRP0CTL", "", 0x00000064, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields494[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{30, 30, 0x0000000000000000, "RW", "lvl_bl0_weakpupstatic", "Weak Pull Up Control - CC Lane - UNUSED in BXTP"},
#else
{30, 30, 0x0000000000000000, "RW", "lvl_bl0_weakpupstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 29, 0x0000000000000000, "RW", "lvl_bl0_weakpup", "Weak Pull Up Control - CC Lane - UNUSED in BXTP"},
#else
{24, 29, 0x0000000000000000, "RW", "lvl_bl0_weakpup", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "lvl_bl0_weakpdnstatic", "Weak Pull Down Control - CC Lane - UNUSED in BXTP"},
#else
{22, 22, 0x0000000000000000, "RW", "lvl_bl0_weakpdnstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 21, 0x0000000000000000, "RW", "lvl_bl0_weakpdn", "Weak Pull Down Control - CC Lane - UNUSED in BXTP"},
#else
{16, 21, 0x0000000000000000, "RW", "lvl_bl0_weakpdn", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 14, 0x0000000000000000, "RW", "lvl_bl1_weakpupstatic", "Weak Pull Up Control static bit for DQS - DQ Lane - UNUSED in BXTP"},
#else
{14, 14, 0x0000000000000000, "RW", "lvl_bl1_weakpupstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 13, 0x0000000000000000, "RW", "lvl_bl1_weakpup", "Weak Pull Up Control code for DQS - DQ Lane - UNUSED in BXTP"},
#else
{8, 13, 0x0000000000000000, "RW", "lvl_bl1_weakpup", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000000, "RW", "lvl_bl1_weakpdnstatic", "Weak Pull Down Control static bit for DQS - DQ Lane - UNUSED in BXTP"},
#else
{6, 6, 0x0000000000000000, "RW", "lvl_bl1_weakpdnstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 5, 0x0000000000000000, "RW", "lvl_bl1_weakpdn", "Weak Pull Down Control code for DQS - DQ Lane - UNUSED in BXTP"},
#else
{0, 5, 0x0000000000000000, "RW", "lvl_bl1_weakpdn", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo494[] = {{"WKPUPPDNCTL", "", 0x00000068, 12, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields495[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 30, 0x0000000000000007, "RW", "dtx_cc0_drvsegen", "Segment enable for CC buffer. Used for per leg testing in HVM"},
#else
{28, 30, 0x0000000000000007, "RW", "dtx_cc0_drvsegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{27, 27, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000007, "RW", "tx_cc0_drvsegen", "Segment enable for CC buffer. Used for per leg testing in HVM"},
#else
{24, 26, 0x0000000000000007, "RW", "tx_cc0_drvsegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 22, 0x0000000000000007, "RW", "dtx_cc1_drvsegen", "Segment enable for CC buffer. Used for per leg testing in HVM"},
#else
{20, 22, 0x0000000000000007, "RW", "dtx_cc1_drvsegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{19, 19, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000007, "RW", "tx_cc1_drvsegen", "Segment enable for CC buffer. Used for per leg testing in HVM"},
#else
{16, 18, 0x0000000000000007, "RW", "tx_cc1_drvsegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000001, "RW", "rxdll_bl0_picapsel", "set cap tuning for pi"},
#else
{12, 14, 0x0000000000000001, "RW", "rxdll_bl0_picapsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000001, "RW", "rxdll_bl1_picapsel", "set cap tuning for pi  - UNUSED in BXTP"},
#else
{8, 10, 0x0000000000000001, "RW", "rxdll_bl1_picapsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000001, "RW", "txdll_picapsel", "set cap tuning for pi"},
#else
{4, 6, 0x0000000000000001, "RW", "txdll_picapsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{0, 3, 0x0000000000000000, "RO", "reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo495[] = {{"AFEMISC1", "", 0x0000006C, 15, 0x00000000FFFFFFFF, 0x0000000077771110}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields496[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{27, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{27, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 26, 0x0000000000000000, "RW", "tx_cc0_techselect", "Selects between LP4/LP3 (1'b0) and DDR4 modes (1'b1) - CC0"},
#else
{26, 26, 0x0000000000000000, "RW", "tx_cc0_techselect", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000001, "RW", "tx_cc0_scompdelaysel", "Mux Select for DCOMP update block - 2'b00 or 2'b01 used values - CC0"},
#else
{24, 25, 0x0000000000000001, "RW", "tx_cc0_scompdelaysel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "tx_cc0_idlemode", "Disable idle mode logic = 1'b0, Enable = 1'b1 - CC0"},
#else
{23, 23, 0x0000000000000000, "RW", "tx_cc0_idlemode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "rx_cc0_modelp4ddr4", "Selects between LP4/LP3 (1'b0) and DDR4 modes (1'b1) - CC0"},
#else
{22, 22, 0x0000000000000000, "RW", "rx_cc0_modelp4ddr4", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 21, 0x0000000000000000, "RW", "dtx_cc0_drvenstretch", "Channel 0 CCC CKP/N Stretches rising edge of drivenable to relax data to enable skew."},
#else
{20, 21, 0x0000000000000000, "RW", "dtx_cc0_drvenstretch", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 19, 0x0000000000000000, "RW", "tx_cc0_drvenstretch", "Channel 0 CA/CTL Stretches rising edge of drivenable to relax data to enable skew."},
#else
{18, 19, 0x0000000000000000, "RW", "tx_cc0_drvenstretch", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RW", "drx_cc0_rxpwrmode", "Modulates the Volatge seen by the RX Amplifier\r\n"
"00 - Default; 01,10,11 - Illegal Values"},
#else
{16, 17, 0x0000000000000000, "RW", "drx_cc0_rxpwrmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{14, 15, 0x0000000000000000, "RW", "rx_cc0_rxpwrmode", "Modulates the Volatge seen by the RX Amplifier\r\n"
"00 - Default; 01,10,11 - Illegal Values"},
#else
{14, 15, 0x0000000000000000, "RW", "rx_cc0_rxpwrmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 13, 0x0000000000000000, "RW", "txdll_cc0_2xclkskewsel", "Channel 0 TxDLL Skew Compensator clock mux select (Clock Select [1:0]/Sync Div Reset[3:2])\r\n"
"Below select descriptions apply to both clock and div reset but each one can be controlled independently\r\n"
"00 - Default path - No addditional Skew added\r\n"
"01 - Skew Path 1 - Add ~30-40ps of delay to TxDLL 2xclk input based on PVT\r\n"
"11 - Skew Path 2 - Add ~90-100ps of delay to TxDLL 2xclk input based on PVT"},
#else
{10, 13, 0x0000000000000000, "RW", "txdll_cc0_2xclkskewsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000001, "RW", "drx_cc0_rxcommonmode", "changes the common mode of receiver from low common mode to vcc/2 based on lpddr3/ lpddr4."},
#else
{9, 9, 0x0000000000000001, "RW", "drx_cc0_rxcommonmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000001, "RW", "rx_cc0_rxcommonmode", "changes the common mode of receiver from low common mode to vcc/2 based on lpddr3/ lpddr4."},
#else
{8, 8, 0x0000000000000001, "RW", "rx_cc0_rxcommonmode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000001, "RW", "ch0_pdndrvstatic", "Static pull down code - DRV DQ"},
#else
{7, 7, 0x0000000000000001, "RW", "ch0_pdndrvstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 6, 0x0000000000000001, "RW", "ch0_pdndrvstaticdqs", "Channel 0 Static pull down Enable - DRV CK and CTL (DQS buffer swapped with CLK buffer; config names were not changed but re-used)"},
#else
{6, 6, 0x0000000000000001, "RW", "ch0_pdndrvstaticdqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000001, "RW", "ch0_pdnodtstatic", "Static pull down code - ODT DQ"},
#else
{5, 5, 0x0000000000000001, "RW", "ch0_pdnodtstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000001, "RW", "ch0_pdnodtstaticdqs", "Channel 0 Static pull down Enable - ODT CK and CTL (DQS buffer swapped with CLK buffer; config names were not changed but re-used)"},
#else
{4, 4, 0x0000000000000001, "RW", "ch0_pdnodtstaticdqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000001, "RW", "ch0_pupdrvstatic", "Static pull up code - DRV DQ"},
#else
{3, 3, 0x0000000000000001, "RW", "ch0_pupdrvstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000001, "RW", "ch0_pupdrvstaticdqs", "Channel 0 Static pull up code - DRV CK and CTL (DQS buffer swapped with CLK buffer; config names were not changed but re-used)"},
#else
{2, 2, 0x0000000000000001, "RW", "ch0_pupdrvstaticdqs", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000001, "RW", "ch0_pupodtstatic", "Static pull up code - ODT DQ"},
#else
{1, 1, 0x0000000000000001, "RW", "ch0_pupodtstatic", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "ch0_pupodtstaticdqs", "Channel 0 Static pull up code - ODT CK and CTL (DQS buffer swapped with CLK buffer; config names were not changed but re-used)"},
#else
{0, 0, 0x0000000000000001, "RW", "ch0_pupodtstaticdqs", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo496[] = {{"CH0_AFEMISC0", "", 0x00000070, 20, 0x00000000FFFFFFFF, 0x00000000010003FF}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields497[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "rx_cc0_bonus", "Bonus Bits - RX CC0"},
#else
{20, 23, 0x0000000000000000, "RW", "rx_cc0_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "rx_cc1_bonus", "Bonus Bits - RX CC1"},
#else
{16, 19, 0x0000000000000000, "RW", "rx_cc1_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rx_ecc_bonus", "Bonus Bits - RX ECC"},
#else
{12, 15, 0x0000000000000000, "RW", "rx_ecc_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "lvl_cc0_bonus", "Bonus bits - LVL CC0"},
#else
{8, 11, 0x0000000000000000, "RW", "lvl_cc0_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "lvl_cc1_bonus", "Bonus bits - LVL CC1"},
#else
{4, 7, 0x0000000000000000, "RW", "lvl_cc1_bonus", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "lvl_ecc_bonus", "Bonus bits - LVL ECC"},
#else
{0, 3, 0x0000000000000000, "RW", "lvl_ecc_bonus", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo497[] = {{"AFEBONUS", "", 0x00000074, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields498[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "txdll_digobs1sel", "Digital observation select mux port 1"},
#else
{28, 31, 0x0000000000000000, "RW", "txdll_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "txdll_digobs0sel", "Digital observation select mux port 0"},
#else
{24, 27, 0x0000000000000000, "RW", "txdll_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "rxdll_bl0_digobsen", "digital buf obs enable (1=enable;0=disable)"},
#else
{23, 23, 0x0000000000000000, "RW", "rxdll_bl0_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "rxdll_bl1_digobsen", "digital buf obs enable (1=enable;0=disable)  - UNUSED in BXTP"},
#else
{22, 22, 0x0000000000000000, "RW", "rxdll_bl1_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "dtx_cc1_digobsen", "CCC Channel 1 digital buf obs enable (1=enable;0=disable)"},
#else
{21, 21, 0x0000000000000000, "RW", "dtx_cc1_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{20, 20, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RW", "txdll_digobsen", "digital buf obs enable (1=enable;0=disable)"},
#else
{19, 19, 0x0000000000000000, "RW", "txdll_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "dtx_cc0_digobsen", "CCC Channel 1 digital buf obs enable (1=enable;0=disable)"},
#else
{18, 18, 0x0000000000000000, "RW", "dtx_cc0_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 17, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 17, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rxdll_bl1_digobs1sel", "Digital observation select mux port 1  - UNUSED in BXTP"},
#else
{12, 15, 0x0000000000000000, "RW", "rxdll_bl1_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rxdll_bl1_digobs0sel", "Digital observation select mux port 0  - UNUSED in BXTP"},
#else
{8, 11, 0x0000000000000000, "RW", "rxdll_bl1_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rxdll_bl0_digobs1sel", "Digital observation select mux port 1"},
#else
{4, 7, 0x0000000000000000, "RW", "rxdll_bl0_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_bl0_digobs0sel", "Digital observation select mux port 0"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_bl0_digobs0sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo498[] = {{"DIGOBSCTL1", "", 0x00000078, 13, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields499[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RW", "dtx_dq_digobsen", "ECC digital buf obs enable (1=enable;0=disable)"},
#else
{15, 15, 0x0000000000000000, "RW", "dtx_dq_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{12, 14, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "rxdll_dq_digobsen", "digital buf obs enable (1=enable;0=disable)"},
#else
{11, 11, 0x0000000000000000, "RW", "rxdll_dq_digobsen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{8, 10, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rxdll_dq_digobs1sel", "Digital observation select mux port 1"},
#else
{4, 7, 0x0000000000000000, "RW", "rxdll_dq_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_dq_digobs0sel", "Digital observation select mux port 0"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_dq_digobs0sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo499[] = {{"ECC_DIGOBSCTL1", "", 0x0000007C, 7, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields500[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RW", "dtx_dq_digobs1sel", "ECC DQS Digital observation select mux port 1"},
#else
{13, 15, 0x0000000000000000, "RW", "dtx_dq_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 12, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{12, 12, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 11, 0x0000000000000000, "RW", "dtx_dq_digobs0sel", "ECC DQS Digital observation select mux port 0"},
#else
{9, 11, 0x0000000000000000, "RW", "dtx_dq_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{8, 8, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RW", "tx_dq_digobs1sel", "ECC DQ Digital observation select mux port 1"},
#else
{5, 7, 0x0000000000000000, "RW", "tx_dq_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 4, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 3, 0x0000000000000000, "RW", "tx_dq_digobs0sel", "ECC DQ Digital observation select mux port 0"},
#else
{1, 3, 0x0000000000000000, "RW", "tx_dq_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{0, 0, 0x0000000000000000, "RO", "reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo500[] = {{"ECC_DIGOBSCTL0", "", 0x00000080, 9, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields501[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{31, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{31, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 30, 0x0000000000000000, "RW", "dtx_cc0_digobs1sel", "Channel 0 CK Digital observation select mux port 1"},
#else
{28, 30, 0x0000000000000000, "RW", "dtx_cc0_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{27, 27, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{27, 27, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 26, 0x0000000000000000, "RW", "dtx_cc0_digobs0sel", "Channel 0 CK Digital observation select mux port 0"},
#else
{24, 26, 0x0000000000000000, "RW", "dtx_cc0_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{23, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 22, 0x0000000000000000, "RW", "dtx_cc1_digobs1sel", "Channel 1 CK Digital observation select mux port 1"},
#else
{20, 22, 0x0000000000000000, "RW", "dtx_cc1_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{19, 19, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 18, 0x0000000000000000, "RW", "dtx_cc1_digobs0sel", "Channel 1 CK Digital observation select mux port 0"},
#else
{16, 18, 0x0000000000000000, "RW", "dtx_cc1_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{15, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RW", "tx_cc0_digobs1sel", "Channel 0 CA/CTL Digital observation select mux port 1"},
#else
{12, 14, 0x0000000000000000, "RW", "tx_cc0_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{11, 11, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 10, 0x0000000000000000, "RW", "tx_cc0_digobs0sel", "Channel 0 CA/CTL Digital observation select mux port 0"},
#else
{8, 10, 0x0000000000000000, "RW", "tx_cc0_digobs0sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{7, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{7, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 6, 0x0000000000000000, "RW", "tx_cc1_digobs1sel", "Channel 1 CA/CTL Digital observation select mux port 1"},
#else
{4, 6, 0x0000000000000000, "RW", "tx_cc1_digobs1sel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{3, 3, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 2, 0x0000000000000000, "RW", "tx_cc1_digobs0sel", "Channel 1 CA/CTL Digital observation select mux port 0"},
#else
{0, 2, 0x0000000000000000, "RW", "tx_cc1_digobs0sel", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo501[] = {{"DIGOBSCTL0", "", 0x00000084, 16, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields502[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "rxdll_rxmuxsel", "enable strobe output from rx sdll.for each byte"},
#else
{24, 28, 0x0000000000000000, "RW", "rxdll_rxmuxsel", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{22, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000000, "RW", "txdll_dllfloprstb", "TxDLL flop reset"},
#else
{21, 21, 0x0000000000000000, "RW", "txdll_dllfloprstb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "rxdll_dllfloprstb", "RxDLL flop reset"},
#else
{20, 20, 0x0000000000000000, "RW", "rxdll_dllfloprstb", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{19, 19, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{19, 19, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{18, 18, 0x0000000000000000, "RW", "rxdll_bl_dqsouten", "enable strobe output from rx sdll.for each byte"},
#else
{18, 18, 0x0000000000000000, "RW", "rxdll_bl_dqsouten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 17, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "rxdll_bl_rxdllen", "Rx DLL enable"},
#else
{16, 16, 0x0000000000000000, "RW", "rxdll_bl_rxdllen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{0, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo502[] = {{"RXDLLCTL_DQBLDM", "", 0x00000088, 10, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields503[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{2, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{2, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "ecc_txdll_ref2xph0pien", "enable tx ref pi phase 0 enable for ECC Bytelane"},
#else
{1, 1, 0x0000000000000000, "RW", "ecc_txdll_ref2xph0pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "ch0_txdll_ref2xph0pien", "enable tx ref pi phase 0 enable for CC0 Bytelane"},
#else
{0, 0, 0x0000000000000000, "RW", "ch0_txdll_ref2xph0pien", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo503[] = {{"RXDLLCTL_CCBLDM", "", 0x0000008C, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields504[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{18, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{18, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{17, 17, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{17, 17, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 16, 0x0000000000000000, "RW", "txdll_cc0_mdllen", "MDLL enable"},
#else
{16, 16, 0x0000000000000000, "RW", "txdll_cc0_mdllen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{15, 15, 0x0000000000000000, "RW", "txdll_cc1_mdllen", "MDLL enable"},
#else
{15, 15, 0x0000000000000000, "RW", "txdll_cc1_mdllen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 14, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{12, 14, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{11, 11, 0x0000000000000000, "RW", "ch0_txdll_siggrp03pien", "PI enable for sig group 3 rank 0"},
#else
{11, 11, 0x0000000000000000, "RW", "ch0_txdll_siggrp03pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{10, 10, 0x0000000000000000, "RW", "ch0_txdll_siggrp02pien", "PI enable for sig group 2 rank 0"},
#else
{10, 10, 0x0000000000000000, "RW", "ch0_txdll_siggrp02pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{9, 9, 0x0000000000000000, "RW", "ch0_txdll_siggrp01pien", "PI enable for sig group 1 rank 0"},
#else
{9, 9, 0x0000000000000000, "RW", "ch0_txdll_siggrp01pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 8, 0x0000000000000000, "RW", "ch0_txdll_siggrp00pien", "PI enable for sig group 0 rank 0"},
#else
{8, 8, 0x0000000000000000, "RW", "ch0_txdll_siggrp00pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{3, 3, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "ch0_txdll_ref2xph180pien", "enable tx ref pi phase 180 enable"},
#else
{2, 2, 0x0000000000000000, "RW", "ch0_txdll_ref2xph180pien", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{1, 1, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{0, 0, 0x0000000000000000, "RO", "reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo504[] = {{"TXDLLCTL", "", 0x00000090, 14, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields505[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "txdll_ref2xph270picode", "pi code for ref pi phase 270 output"},
#else
{16, 23, 0x0000000000000000, "RW", "txdll_ref2xph270picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "txdll_ref2xph180picode", "pi code for ref pi phase 180 output"},
#else
{8, 15, 0x0000000000000000, "RW", "txdll_ref2xph180picode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "txdll_ref2xph90picode", "pi code for ref pi phase 90 output"},
#else
{0, 7, 0x0000000000000000, "RW", "txdll_ref2xph90picode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo505[] = {{"TXDLLREF2XCTL", "", 0x00000094, 4, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields506[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RW", "rxdll_rk1dqshipicode", "pi code for rx rising dqs edge - DQ Lane"},
#else
{24, 31, 0x0000000000000000, "RW", "rxdll_rk1dqshipicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000000, "RW", "rxdll_rk1dqslopicode", "pi code for rx falling dqs edge - DQ Lane"},
#else
{16, 23, 0x0000000000000000, "RW", "rxdll_rk1dqslopicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{0, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo506[] = {{"RXDLLDQSRK1CTL", "", 0x00000098, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields507[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{16, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{16, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RW", "rxdll_bl0_rk0dqshipicode", "pi code for rx rising dqs edge  - CC Lane"},
#else
{8, 15, 0x0000000000000000, "RW", "rxdll_bl0_rk0dqshipicode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000000, "RW", "rxdll_bl0_rk0dqslopicode", "pi code for rx falling dqs edge  - CC Lane"},
#else
{0, 7, 0x0000000000000000, "RW", "rxdll_bl0_rk0dqslopicode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo507[] = {{"RXDLLDQSRK0CTL", "", 0x0000009C, 3, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields508[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000020, "RW", "vref_dq_rxblvrefctrl", "ECC Rx vref decode signal for ECC bytelane Rx Vref circuit"},
#else
{24, 31, 0x0000000000000020, "RW", "vref_dq_rxblvrefctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000020, "RW", "vref_dq_rxccvrefctrl", "ECC Rx vref decode signal for ECC bytelane Rx Vref circuit - UNUSED in BXTP"},
#else
{16, 23, 0x0000000000000020, "RW", "vref_dq_rxccvrefctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000020, "RW", "vref_cc1_rxblvrefctrl", "Channel 1 Rx vref decode signal for the CC1 bl rx vref"},
#else
{8, 15, 0x0000000000000020, "RW", "vref_cc1_rxblvrefctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 7, 0x0000000000000020, "RW", "vref_cc1_rxccvrefctrl", "Tx VREF vref decode signal - This RxVref was re-purposed for the TxVref Control per HSD#1204294748"},
#else
{0, 7, 0x0000000000000020, "RW", "vref_cc1_rxccvrefctrl", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo508[] = {{"VREFCTL2", "", 0x000000A0, 4, 0x00000000FFFFFFFF, 0x0000000020202020}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields509[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{1, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{1, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000001, "RW", "txvref_cmn_vrefbufen", "enable signal for the tx vref unity gain buffer"},
#else
{0, 0, 0x0000000000000001, "RW", "txvref_cmn_vrefbufen", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo509[] = {{"VREFCTL1", "", 0x000000A4, 2, 0x00000000FFFFFFFF, 0x0000000000000001}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields510[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RW", "vref_txlcompvrefctrl", "vref decode signal for the lcomp"},
#else
{24, 31, 0x0000000000000000, "RW", "vref_txlcompvrefctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 23, 0x0000000000000020, "RW", "vref_cc0_rxblvrefctrl", "Channel 0 Rx vref decode signal for the CC0 bl rx vref"},
#else
{16, 23, 0x0000000000000020, "RW", "vref_cc0_rxblvrefctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000020, "RW", "vref_cc0_rxccvrefctrl", "Channel 1 Rx vref decode signal for the CC0 cc rx vref"},
#else
{8, 15, 0x0000000000000020, "RW", "vref_cc0_rxccvrefctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{6, 7, 0x0000000000000000, "RW", "vref_dq_vrefcmctrl", "common mode select to choose between lpddr3;lpddr4"},
#else
{6, 7, 0x0000000000000000, "RW", "vref_dq_vrefcmctrl", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 5, 0x0000000000000000, "RW", "lvl_bl_vrefset", "vrefiobufact Set control - ECC Lane"},
#else
{5, 5, 0x0000000000000000, "RW", "lvl_bl_vrefset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 4, 0x0000000000000000, "RW", "lvl_bl_vrefreset", "vrefiobufact Reset control - ECC Lane"},
#else
{4, 4, 0x0000000000000000, "RW", "lvl_bl_vrefreset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "lvl_cc1_vrefset", "vrefiobufact Set control - CCC1 Lane"},
#else
{3, 3, 0x0000000000000000, "RW", "lvl_cc1_vrefset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "lvl_cc1_vrefreset", "vrefiobufact Reset control - CCC1 Lane"},
#else
{2, 2, 0x0000000000000000, "RW", "lvl_cc1_vrefreset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "lvl_cc0_vrefset", "vrefiobufact Set control - CCC0 Lane"},
#else
{1, 1, 0x0000000000000000, "RW", "lvl_cc0_vrefset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "lvl_cc0_vrefreset", "vrefiobufact Reset control - CCC0 Lane"},
#else
{0, 0, 0x0000000000000000, "RW", "lvl_cc0_vrefreset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo510[] = {{"VREFCTL0", "", 0x000000A8, 10, 0x00000000FFFFFFFF, 0x0000000000202000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields511[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{4, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_dq_dq8rxpbdcode", "Rx Per bit De-skew code for dq0 valid codes"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_dq_dq8rxpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo511[] = {{"RXBL8PBDCTL", "", 0x000000AC, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields512[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "rxdll_dq_dq7rxpbdcode", "Rx Per bit De-skew code for dq0 valid codes"},
#else
{28, 31, 0x0000000000000000, "RW", "rxdll_dq_dq7rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "rxdll_dq_dq6rxpbdcode", "Rx Per bit De-skew code for dq0 valid codes"},
#else
{24, 27, 0x0000000000000000, "RW", "rxdll_dq_dq6rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "rxdll_dq_dq5rxpbdcode", "Rx Per bit De-skew code for dq0 valid codes"},
#else
{20, 23, 0x0000000000000000, "RW", "rxdll_dq_dq5rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "rxdll_dq_dq4rxpbdcode", "Rx Per bit De-skew code for dq0 valid codes"},
#else
{16, 19, 0x0000000000000000, "RW", "rxdll_dq_dq4rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rxdll_dq_dq3rxpbdcode", "Rx Per bit De-skew code for dq0 valid codes"},
#else
{12, 15, 0x0000000000000000, "RW", "rxdll_dq_dq3rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rxdll_dq_dq2rxpbdcode", "Rx Per bit De-skew code for dq0 valid codes"},
#else
{8, 11, 0x0000000000000000, "RW", "rxdll_dq_dq2rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rxdll_dq_dq1rxpbdcode", "Rx Per bit De-skew code for dq0 valid codes"},
#else
{4, 7, 0x0000000000000000, "RW", "rxdll_dq_dq1rxpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rxdll_dq_dq0rxpbdcode", "Rx Per bit De-skew code for dq0 valid codes"},
#else
{0, 3, 0x0000000000000000, "RW", "rxdll_dq_dq0rxpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo512[] = {{"RXPBDBLCTL", "", 0x000000B0, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields513[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000000, "RW", "rxdll_bl0_rxpbden", "Rx Per Bit De-skew enable (1=enable, 0=disable), 0 for cc always"},
#else
{23, 23, 0x0000000000000000, "RW", "rxdll_bl0_rxpbden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "rxdll_bl1_rxpbden", "Rx Per Bit De-skew enable (1=enable, 0=disable) - UNUSED in BXTP"},
#else
{22, 22, 0x0000000000000000, "RW", "rxdll_bl1_rxpbden", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 21, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{4, 21, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{3, 3, 0x0000000000000000, "RW", "tx_cc0_pbdstaticlegen", "Per bit deskew enable - TX - CC Channel 0"},
#else
{3, 3, 0x0000000000000000, "RW", "tx_cc0_pbdstaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{2, 2, 0x0000000000000000, "RW", "tx_cc1_pbdstaticlegen", "Per bit deskew enable - TX - CC Channel 1"},
#else
{2, 2, 0x0000000000000000, "RW", "tx_cc1_pbdstaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{1, 1, 0x0000000000000000, "RW", "dtx_cc0_pbdstaticlegen", "Per bit deskew enable - DTX - CC Channel 0"},
#else
{1, 1, 0x0000000000000000, "RW", "dtx_cc0_pbdstaticlegen", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 0, 0x0000000000000000, "RW", "dtx_cc1_pbdstaticlegen", "Per bit deskew enable - DTX - Channel 1"},
#else
{0, 0, 0x0000000000000000, "RW", "dtx_cc1_pbdstaticlegen", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo513[] = {{"TXPBDCTL1", "", 0x000000B4, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields514[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{5, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "tx_bldm_txpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "tx_bldm_txpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo514[] = {{"TXPBDRK0CTL1", "", 0x000000B8, 2, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields515[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{21, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "dtx_dq_dqsbpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{16, 20, 0x0000000000000000, "RW", "dtx_dq_dqsbpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{8, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "dtx_dq_dqspbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "dtx_dq_dqspbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo515[] = {{"TXPBDRK0CTL0", "", 0x000000BC, 5, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields516[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "tx_bldq7_txpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{24, 28, 0x0000000000000000, "RW", "tx_bldq7_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "tx_bldq6_txpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{16, 20, 0x0000000000000000, "RW", "tx_bldq6_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "tx_bldq5_txpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{8, 12, 0x0000000000000000, "RW", "tx_bldq5_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "tx_bldq4_txpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "tx_bldq4_txpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo516[] = {{"TXPBDBLCTL1", "", 0x000000C0, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields517[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{29, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{29, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 28, 0x0000000000000000, "RW", "tx_bldq3_txpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{24, 28, 0x0000000000000000, "RW", "tx_bldq3_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 23, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{21, 23, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 20, 0x0000000000000000, "RW", "tx_bldq2_txpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{16, 20, 0x0000000000000000, "RW", "tx_bldq2_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{13, 15, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{13, 15, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 12, 0x0000000000000000, "RW", "tx_bldq1_txpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{8, 12, 0x0000000000000000, "RW", "tx_bldq1_txpbdcode", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{5, 7, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{5, 7, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 4, 0x0000000000000000, "RW", "tx_bldq0_txpbdcode", "Tx Per Bit De-skew code for dq0 valid codes"},
#else
{0, 4, 0x0000000000000000, "RW", "tx_bldq0_txpbdcode", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo517[] = {{"TXPBDBLCTL0", "", 0x000000C4, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields518[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{24, 31, 0x0000000000000000, "RO", "reserved", "Reserved bits"},
#else
{24, 31, 0x0000000000000000, "RO", "reserved", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{23, 23, 0x0000000000000001, "RW", "rx_dq_ampoffseten", "ECC Offset cancellation enable for Rx (not used for cc)"},
#else
{23, 23, 0x0000000000000001, "RW", "rx_dq_ampoffseten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{22, 22, 0x0000000000000000, "RW", "rx_cc0_ampoffseten", "CCC Channel 0 Offset cancellation enable for Rx (not used for cc)"},
#else
{22, 22, 0x0000000000000000, "RW", "rx_cc0_ampoffseten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{21, 21, 0x0000000000000001, "RW", "drx_dq_ampoffseten", "ECC DQS Offset cancellation enable for Rx (1=enable, 0=disable)"},
#else
{21, 21, 0x0000000000000001, "RW", "drx_dq_ampoffseten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 20, 0x0000000000000000, "RW", "rx_cc1_ampoffseten", "CCC Channel 1 Offset cancellation enable for Rx (1=enable, 0=disable)"},
#else
{20, 20, 0x0000000000000000, "RW", "rx_cc1_ampoffseten", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "drx_ccck0_ampoffset", "tuning bits for offset cancellation (can be tied off for CC)"},
#else
{16, 19, 0x0000000000000000, "RW", "drx_ccck0_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rx_cc0_ampoffset", "tuning bits for offset cancellation (can be tied off for CC)"},
#else
{12, 15, 0x0000000000000000, "RW", "rx_cc0_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rx_cc1_ampoffset", "Offset cancellation code (DQS buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{8, 11, 0x0000000000000000, "RW", "rx_cc1_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rx_bldm_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{4, 7, 0x0000000000000000, "RW", "rx_bldm_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "drx_dq_ampoffset", "tuning bits for offset cancellation (can be tied off for CC)"},
#else
{0, 3, 0x0000000000000000, "RW", "drx_dq_ampoffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo518[] = {{"OFFSETCNCLCTRL1", "", 0x000000C8, 10, 0x00000000FFFFFFFF, 0x0000000000A00000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields519[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{28, 31, 0x0000000000000000, "RW", "rx_bldq0_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{28, 31, 0x0000000000000000, "RW", "rx_bldq0_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 27, 0x0000000000000000, "RW", "rx_bldq1_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{24, 27, 0x0000000000000000, "RW", "rx_bldq1_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{20, 23, 0x0000000000000000, "RW", "rx_bldq2_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{20, 23, 0x0000000000000000, "RW", "rx_bldq2_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{16, 19, 0x0000000000000000, "RW", "rx_bldq3_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{16, 19, 0x0000000000000000, "RW", "rx_bldq3_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{12, 15, 0x0000000000000000, "RW", "rx_bldq4_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{12, 15, 0x0000000000000000, "RW", "rx_bldq4_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{8, 11, 0x0000000000000000, "RW", "rx_bldq5_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{8, 11, 0x0000000000000000, "RW", "rx_bldq5_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{4, 7, 0x0000000000000000, "RW", "rx_bldq6_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{4, 7, 0x0000000000000000, "RW", "rx_bldq6_ampoffset", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{0, 3, 0x0000000000000000, "RW", "rx_bldq7_ampoffset", "Offset cancellation code (DM/DQ buffers)\r\n"
"1111 -8\r\n"
"1110 -7\r\n"
"1101 -6\r\n"
"1100 -5\r\n"
"1011 -4\r\n"
"1010 -3\r\n"
"1001 -2\r\n"
"1000 -1\r\n"
"0000 +1\r\n"
"0001 +2\r\n"
"0010 +3\r\n"
"0011 +4\r\n"
"0100 +5\r\n"
"0101 +6\r\n"
"0110 +7\r\n"
"0111 +8"},
#else
{0, 3, 0x0000000000000000, "RW", "rx_bldq7_ampoffset", NULL},
#endif
};
#endif // DUMP_REGISTER_FIELDS
RegisterInformation RegisterInfo519[] = {{"OFFSETCNCLCTRL0", "", 0x000000CC, 8, 0x00000000FFFFFFFF, 0x0000000000000000}};
#if DUMP_REGISTER_FIELDS
RegisterField RegisterFields520[] = {
#if DUMP_REGISTER_DESCRIPTIONS
{30, 31, 0x0000000000000000, "RW", "rx_dq_ampcombtune", "RX 2nd Stage Amp Fine Tune - ECC"},
#else
{30, 31, 0x0000000000000000, "RW", "rx_dq_ampcombtune", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{28, 29, 0x0000000000000000, "RW", "rx_dq_ctletune", "RX 1st Stage Amp CTLE Fine Tune - ECC"},
#else
{28, 29, 0x0000000000000000, "RW", "rx_dq_ctletune", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{26, 27, 0x0000000000000000, "RW", "rx_cc1_ampcombtune", "RX 2nd Stage Amp Fine Tune - CC1"},
#else
{26, 27, 0x0000000000000000, "RW", "rx_cc1_ampcombtune", NULL},
#endif
#if DUMP_REGISTER_DESCRIPTIONS
{24, 25, 0x0000000000000000, "RW", "rx_cc1_ctletune", "RX 1st Stage Amp CTLE Fine Tune - CC1"},
#else
{24, 25, 0x0000000000000000, "RW", "rx_cc1_ctletune", NULL},
#endif
#if DUMP_R