/** @file
  CNVI policy

@copyright
  Copyright (c) 2016 - 2019 Intel Corporation. All rights reserved
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by the
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is uniquely
  identified as "Intel Reference Module" and is licensed for Intel
  CPUs and chipsets under the terms of your license agreement with
  Intel or your vendor. This file may be modified by the user, subject
  to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _CNVI_CONFIG_H_
#define _CNVI_CONFIG_H_


#define CNVI_CONFIG_REVISION 2
/*
// Revision History
// 1: CNVi Init
// 2: ModifyCrfGpios
*/
extern EFI_GUID gCnviConfigGuid;

#pragma pack (push,1)

/**
  CNVi Bluetooth interface options
**/
typedef enum {
  CnviModeDisabled = 0,
  CnviModeAuto
} CNVI_MODE;

/**
  CNVi Bluetooth interface options
**/
typedef enum {
  CnviBtIfUart = 0,
  CnviBtIfUsb
} CNVI_BT_INTERFACE;

/**
  CNVi Bluetooth UART connection options
**/
typedef enum {
  CnviBtUartSerialIo = 0,
  CnviBtUartIsh,
  CnviBtUartExtPads
} CNVI_BT_UART_TYPE;

///
/// The SC_CNVI_CONFIG block describes CNVi IP in GLK-SOC.
///
typedef struct {
  CONFIG_BLOCK_HEADER   Header;               ///< Config Block Header
  /** 
    This option allows for automatic detection of Connectivity Solution.
    Auto Detection assumes that CNVi will be enabled when available;
    Disable allows for disabling CNVi.
  **/
  UINT32 Mode                  :  1;          ///< CnviModeDisabled = Disabled, <b>CnviModeAuto = Auto Detection</b>
  UINT32 BtCore                :  1;          ///< 0 = Disabled, <b>1 = Enabled</b>
  /** 
    This option allows configuration of BT interface to USB or UART
    Use CNVI_BT_INTERFACE enum for selection:
    CnviBtIfUart = BT over UART interface,
    <b>CnviBtIfUsb = BT over USB interface</b>
  **/
  UINT32 BtInterface           :  1;
  /** 
      This option allows setting conditional wake states
      EnableSxWake = Sx wake enabled for all states,
      <b>DisableSxWake = Sx wake disabled for all states </b>
    **/
  UINT32 DisableSxWake         :  1;
  /**
    <b>(Test)</b> This option configures Uart type when BtInterface = CnviBtIfUart
    For production configuration SerialIO is the default, for tests ISH Uart0 or external pads can be used
    Use CNVI_BT_UART_TYPE enum for selection
    <b>CnviBtUartSerialIo = BT Uart over SerialIO Uart0</b>,
    CnviBtUartIsh = BT Uart over ISH Uart0,
    CnviBtUartExtPads = BT Uart over exteranl pads
  **/
  UINT32 BtUartType            :  2;
  /** 
    This option allows setting crf gpios, would be used if platform gpios related to crf are used for other platform feature enabling
    Useful for gpios optimization on platform
    <b> 0 : CRF gpios are modified </b>
    <b> 1 : CRF gpios are not modified for Gnss and BtOnUart </b>
    
  **/
  UINT32 ModifyCrfGpios        :  1;  
        
  UINT32 RsvdBits              : 25;
} SC_CNVI_CONFIG;

#pragma pack (pop)

#endif // _CNVI_CONFIG_H_

